/**
  *********************************************************************************
  *
  * @file    usb_audio.h
  * @brief   Header file for the USB AUDIO.
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USB_AUDIO_H__
#define __USB_AUDIO_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usb_utils.h"


/** @addtogroup USB_LIBRARY
  * @{
  */

/** @addtogroup UTILS
  * @{
  */

/**
  * @defgroup Audio_Private_Macros Audio Private Macros
  * @{
  */
#define USB_AI_UNDEFINED		0U
#define USB_AI_HEADER			1U
#define USB_AI_INPUT_TERMINAL		2U
#define USB_AI_OUTPUT_TERMINAL		3U
#define USB_AI_MIXER_UNIT		4U
#define USB_AI_SELECTOR_UNIT		5U
#define USB_AI_FEATURE_UNIT		6U
#define USB_AI_PROCESSING_UNIT		7U
#define USB_AI_EXTENSION_UNIT		8U
#define USB_AS_UNDEFINED		0U
#define USB_AS_GENERAL			1U
#define USB_AS_FORMAT_TYPE		2U
#define USB_AS_FORMAT_SPECIFIC		3U
#define USB_TTYPE_UNDEFINED		0x0100U
#define USB_TTYPE_STREAMING		0x0101U
#define USB_TTYPE_VENDOR		0x01ffU
#define USB_TTYPE_OUT_UNDEF		0x0300U
#define USB_TTYPE_OUT_SPEAKER		0x0301U
#define USB_TTYPE_OUT_HEADPHONE		0x0302U
#define USB_TTYPE_OUT_DESK_SPKR		0x0304U
#define USB_TTYPE_OUT_ROOM_SPKR		0x0305U
#define USB_TTYPE_OUT_COMM_SPKR		0x0306U
#define USB_TTYPE_OUT_LFE		0x0307U
#define USB_TTYPE_EXT_UNDEF		0x0600U
#define USB_TTYPE_EXT_ANALOG		0x0601U
#define USB_TTYPE_EXT_DIGITAL		0x0602U
#define USB_TTYPE_EXT_LINE		0x0603U
#define USB_TTYPE_EXT_LEGACY		0x0604U
#define USB_TTYPE_EXT_SPDIF		0x0605U
#define USB_TTYPE_EXT_1394_DA		0x0606U
#define USB_TTYPE_EXT_1394_DV		0x0607U
#define USB_ASC_UNDEFINED		0x00U
#define USB_ASC_AUDIO_CONTROL		0x01U
#define USB_ASC_AUDIO_STREAMING		0x02U
#define USB_ASC_MIDI_STREAMING		0x03U
#define USB_ACSDT_UNDEFINED		0x20U
#define USB_ACSDT_DEVICE		0x21U
#define USB_ACSDT_CONFIGURATION		0x22U
#define USB_ACSDT_STRING		0x23U
#define USB_ACSDT_INTERFACE		0x24U
#define USB_ACSDT_ENDPOINT		0x25U
#define USB_ACDSTYPE_UNDEFINED		0x00U
#define USB_ACDSTYPE_HEADER		0x01U
#define USB_ACDSTYPE_IN_TERMINAL	0x02U
#define USB_ACDSTYPE_OUT_TERMINAL	0x03U
#define USB_ACDSTYPE_MIXER_UNIT		0x04U
#define USB_ACDSTYPE_SELECTOR_UNIT	0x05U
#define USB_ACDSTYPE_FEATURE_UNIT	0x06U
#define USB_ACDSTYPE_PROCESSING_UNIT	0x07U
#define USB_ACDSTYPE_EXTENSION_UNIT	0x08U
#define USB_ASDSTYPE_UNDEFINED		0x00U
#define USB_ASDSTYPE_GENERAL		0x01U
#define USB_ASDSTYPE_FORMAT_TYPE	0x02U
#define USB_ASDSTYPE_FORMAT_SPECIFIC	0x03U
#define USB_ADF_UNDEFINED		0x0000U
#define USB_ADF_PCM			0x0001U
#define USB_ADF_PCM8			0x0002U
#define USB_ADF_IEEE_FLOAT		0x0003U
#define USB_ADF_ALAW			0x0004U
#define USB_ADF_MULAW			0x0005U
#define USB_AF_TYPE_UNDEFINED		0x00U
#define USB_AF_TYPE_TYPE_I		0x01U
#define USB_AF_TYPE_TYPE_II		0x02U
#define USB_AF_TYPE_TYPE_III		0x03U
#define USB_ACONTROL_MUTE		0x0001U
#define USB_ACONTROL_VOLUME		0x0002U
#define USB_ACONTROL_BASS		0x0004U
#define USB_ACONTROL_MID		0x0008U
#define USB_ACONTROL_TREBLE		0x0010U
#define USB_ACONTROL_EQ			0x0020U
#define USB_ACONTROL_AGC		0x0040U
#define USB_ACONTROL_DELAY		0x0080U
#define USB_ACONTROL_BASS_BOOST		0x0100U
#define USB_ACONTROL_LOUD		0x0200U
#define USB_ATTYPE_UNDEFINED		0x0300U
#define USB_ATTYPE_SPEAKER		0x0301U
#define USB_ATTYPE_HEADPHONES		0x0302U
#define USB_ATTYPE_HMD			0x0303U
#define USB_ATTYPE_SPEAKER_DT		0x0304U
#define USB_ATTYPE_SPEAKER_RM		0x0305U
#define USB_ATTYPE_SPEAKER_COM		0x0306U
#define USB_ATTYPE_SPEAKER_LFE		0x0307U
#define USB_CHANNEL_L			0x0001U
#define USB_CHANNEL_R			0x0002U
#define USB_CHANNEL_C			0x0004U
#define USB_CHANNEL_LFE			0x0008U
#define USB_CHANNEL_LS			0x0010U
#define USB_CHANNEL_RS			0x0020U
#define USB_CHANNEL_LC			0x0040U
#define USB_CHANNEL_RC			0x0080U
#define USB_CHANNEL_S			0x0100U
#define USB_CHANNEL_SL			0x0200U
#define USB_CHANNEL_SR			0x0400U
#define USB_CHANNEL_T			0x0800U
#define USB_EP_ATTR_ACG_SAMPLING	0x01U
#define USB_EP_ATTR_ACG_PITCH		0x02U
#define USB_EP_ATTR_ACG_MAXPACKET	0x80U
#define USB_EP_LOCKDELAY_UNDEF		0x00U
#define USB_EP_LOCKDELAY_MS		0x01U
#define USB_EP_LOCKDELAY_PCM		0x02U
#define USB_AC_SET_CUR			0x01U
#define USB_AC_SET_MIN			0x02U
#define USB_AC_SET_MAX			0x03U
#define USB_AC_SET_RES			0x04U
#define USB_AC_SET_MEM			0x05U
#define USB_AC_GET_CUR			0x81U
#define USB_AC_GET_MIN			0x82U
#define USB_AC_GET_MAX			0x83U
#define USB_AC_GET_RES			0x84U
#define USB_AC_GET_MEM			0x85U
#define USB_AC_GET_STAT			0xffU
#define USB_CS_CONTROL_M		0xff00U
#define USB_CS_CHANNEL_M		0x00ffU
#define EP_CONTROL_UNDEFINED		0x0000U
#define SAMPLING_FREQ_CONTROL		0x0100U
#define PITCH_CONTROL			0x0200U
#define FU_CONTROL_UNDEFINED		0x0000U
#define MUTE_CONTROL			0x0100U
#define VOLUME_CONTROL			0x0200U
#define BASS_CONTROL			0x0300U
#define MID_CONTROL			0x0400U
#define TREBLE_CONTROL			0x0500U
#define EQUALIZER_CONTROL		0x0600U
#define AUTOMATIC_GAIN_CONTROL		0x0700U
#define DELAY_CONTROL			0x0800U
#define BASS_BOOST_CONTROL		0x0900U
#define LOUDNESS_CONTROL		0x0A00U
#define USB_AC_CC_LEFT			0x0001U
#define USB_AC_CC_RIGHT			0x0002U
#define USB_AC_CC_CENTER		0x0004U
#define USB_AC_CC_LFE			0x0008U
#define USB_AC_CC_LEFTSURROUND		0x0010U
#define USB_AC_CC_RIGHTSURROUND		0x0020U
#define USB_AC_CC_LEFT_CENTER		0x0040U
#define USB_AC_CC_RIGHT_CENTER		0x0080U
#define USB_AC_CC_SURROUND		0x0100U
#define USB_AC_CC_SIDE_LEFT		0x0200U
#define USB_AC_CC_SIDE_RIGHT		0x0400U
#define USB_AC_CC_TOP			0x0800U
/**
  * @}
  */

/**
  * @defgroup Audio_Public_Types Audio Public Types
  * @{
  */
#ifdef __ICCARM__
#pragma pack(1)
#endif

/**
  * @brief Audio Class Interface Header
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint16_t bcdADC;		/** Number in Binary-Coded Decimal */
	uint16_t wTotai32Length;	/** Total number of bytes */
	uint8_t bInCollection;		/** Number of AudioStreaming and MIDIStreaming interfaces */
	uint8_t baInterfaceNr;		/** Number of the first AudioStreaming */
} PACKED ac_head_t;

/**
  * @brief Feature Unit Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bUnitID;		/** Uniquely identifying */
	uint8_t bSourceID;		/** ID of the Unit or Terminal */
	uint8_t bControlSize;		/** ID of the Output Terminal */
	uint16_t bmaControls;		/** Mentioned Control */
} PACKED ac_feature_t;

/**
  * @brief Output Terminal Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bTerminalID;		/** ID of the Terminal */
	uint16_t wTerminalType;		/** Type of Terminal */
	uint8_t bAssocTerminal;		/** Identifying the Input Terminal */
	uint8_t bSourceID;		/** ID of the Unit or Terminal */
	uint8_t iTerminal;		/** Index of a string descriptor */
} PACKED ac_output_t;

/**
  * @brief Input Terminal Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bTerminalID;		/** ID of the Terminal */
	uint16_t wTerminalType;		/** Type of Terminal */
	uint8_t bAssocTerminal;		/** Identifying the Input Terminal */
	uint8_t bNrChannels;		/** Number of logical output channels */
	uint16_t wChannelConfig;	/** Describes the spatial location */
	uint8_t iChannelNames;		/** Index of a string descriptor */
	uint8_t iTerminal;		/** Index of a string descriptor */
} PACKED ac_input_t;

/**
  * @brief Mixer Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bUnitID;		/** Uniquely identifying the Unit */
	uint8_t bNrInPins;		/** Number of Input Pins */
	uint8_t baSourceID;		/** ID of the Unit or Terminal */
} PACKED ac_mixer_t;

/**
  * @brief Selector Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bUnitID;		/** Uniquely identifying the Unit */
	uint8_t bNrInPins;		/** Number of Input Pins */
	uint8_t baSourceID;		/** ID of the Unit or Terminal */
} PACKED ac_select_t;

/**
  * @brief Output Terminal Descriptor
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bTerminalLink;		/** Terminal ID  which endpoint is connected */
	uint8_t bDelay;			/** Delay */
	uint16_t wFormatTag;		/** Audio Data Format */
} PACKED ac_general_t;

/**
  * @brief Audio format descriptors
  */
typedef struct {
	uint8_t bLength;		/** Length */
	uint8_t bDescriptorType;	/** Type */
	uint8_t bDescriptorSubtype;	/** Sub-Type */
	uint8_t bFormatType;		/** USB_AS_FORMAT_TYPE_I */
	uint8_t bNrChannels;		/** Number of channels */
	uint8_t bSubFrameSize;		/** Number of bytes per audio sub-frame */
	uint8_t bBitResolution;		/** Number of bits per sample */
	uint8_t bSamFreqType;		/** Number of sample rates */
	uint8_t tSamFreq;		/** Number of bits per sample */
} PACKED ac_format_t;

#ifdef __ICCARM__
#pragma pack()
#endif
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
