/**
  *********************************************************************************
  *
  * @file    uart_stdio.h
  * @brief   Header file for the USB debug.
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __UART_STDIO_H__
#define __UART_STDIO_H__

#include "usb_library_config.h"
#ifdef USB_DRIVER_ALD
#include "ald_uart.h"
#endif

/** @addtogroup USB_LIBRARY
  * @{
  */

/** @addtogroup UTILS
  * @{
  */
#ifdef USB_DRIVER_ALD
/** @addtogroup UTILS_Public_Variables
  * @{
  */
#if ((defined USB_DEBUG) && (defined(ES32F36xx) || defined(ES32F336x) || defined(ES32F326x)))
extern uart_handle_t h_uart;
#elif ((defined USB_DEBUG) && (defined(ES32F0271) || defined(ES32F027x)))
extern ald_uart_handle_t h_uart;
#else
#endif

/**
  * @}
  */
#endif
/** @addtogroup UTILS_Public_Functions
  * @{
  */
/** @addtogroup UTILS_Public_Functions_Group5
  * @{
  */
extern void printf_e(const char *fmt, ...);
extern void uart_stdio_init(void);

/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#endif
