/**
  *********************************************************************************
  *
  * @file    usbh_scsi.h
  * @brief   Header file for the SCSI[HOST].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBH_SCSI_H__
#define __USBH_SCSI_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbh_core.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup HOST
  * @{
  */
/** @addtogroup Host_SCSI
  * @{
  */
/**
  * @defgroup Host_SCSI_Public_Macros Public Macros
  * @{
  */
#define CBW_TAG_VALUE	0x54231990U
#define SLAVE_LUN	0x0U
/**
  * @}
  */

/** @addtogroup Host_SCSI_Public_Functions
  * @{
  */
extern uint32_t usbh_scsi_inquiry(uint32_t in_pipe, uint32_t out_pipe, uint8_t *data, uint32_t *size);
extern uint32_t usbh_scsi_read_capacity(uint32_t in_pipe, uint32_t out_pipe, uint8_t *data, uint32_t *size);
extern uint32_t usbh_scsi_read_capacities(uint32_t in_pipe, uint32_t out_pipe, uint8_t *data, uint32_t *size);
extern uint32_t usbh_scsi_mode_sense6(uint32_t in_pipe, uint32_t out_pipe, uint32_t flag, uint8_t *data, uint32_t *size);
extern uint32_t usbh_scsi_test_unit_ready(uint32_t in_pipe, uint32_t out_pipe);
extern uint32_t usbh_scsi_request_sense(uint32_t in_pipe, uint32_t out_pipe, uint8_t *data, uint32_t *size);
extern uint32_t usbh_scsi_read10(uint32_t in_pipe, uint32_t out_pipe, uint32_t lba, uint8_t *data, uint32_t *size, uint32_t nr);
extern uint32_t usbh_scsi_write10(uint32_t in_pipe, uint32_t out_pipe, uint32_t lba, uint8_t *data, uint32_t *size, uint32_t nr);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
