/**
  *********************************************************************************
  *
  * @file    usbh_hid_mouse.h
  * @brief   Header file for the mouse[HOST].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBH_HID_MOUSE_H__
#define __USBH_HID_MOUSE_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbh_hid.h"	


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup HOST
  * @{
  */
/** @addtogroup Host_Mouse
  * @{
  */
/**
  * @defgroup Host_Mouse_Public_Macros Public Macros
  * @{
  */
#define USBHMS_REPORT_SIZE	0x4U
#define USBHMS_DEVICE_PRESENT	0x1U
/**
  * @}
  */

/**
  * @defgroup Host_Mouse_Public_Types Public Types
  * @{
  */
struct usbh_mouse_s;
typedef void (*usbh_mouse_cbk)(struct usbh_mouse_s *inst, uint32_t event, uint32_t param, void *data);

/**
  * @brief Instance of a USB mouse host driver
  */
typedef struct usbh_mouse_s {
	uint32_t flag;				/**< Flags */
	usbh_mouse_cbk cbk;			/**< Callback */
	uint8_t button;				/**< Current state of the buttons */
	uint8_t buf[USBHMS_REPORT_SIZE];	/**< Buffer to hold the current HID report */
	uint8_t *heap;				/**< Heap data for the HID Report Descriptor */
	uint32_t size;				/**< Size of the heap */
	usbh_hid_inst_t *hid_inst;		/**< HID instance pointer */
} usbh_mouse_t;
/**
  * @}
  */

/** @addtogroup Host_Mouse_Public_Functions
  * @{
  */
extern usbh_mouse_t *usbh_mouse_open(usbh_mouse_cbk cbk, uint8_t *buf, uint32_t size);
extern uint32_t usbh_mouse_close(usbh_mouse_t *inst);
extern uint32_t usbh_mouse_init(usbh_mouse_t *inst);
extern uint32_t usbh_mouse_lpm_sleep(usbh_mouse_t *inst);
extern uint32_t usbh_mouse_lpm_status(usbh_mouse_t *inst);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
