/**
  *********************************************************************************
  *
  * @file    usbh_hid_keyb.h
  * @brief   Header file for the Keyboard[HOST].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBH_HID_KEYB_H__
#define __USBH_HID_KEYB_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbh_hid.h"
#include "usb_hid.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup HOST
  * @{
  */
/** @addtogroup Host_Keyb
  * @{
  */
/**
  * @defgroup Host_Keyb_Public_Macros Public Macros
  * @{
  */
#define USBHKEYB_REPORT_SIZE	0x8U
#define USBHKEYB_DEVICE_PRESENT	0x1U
/**
  * @}
  */

/**
  * @defgroup Host_Keyb_Public_Types Public Types
  * @{
  */
struct usbh_keyb_s;
typedef void (*usbh_keyb_cbk)(struct usbh_keyb_s *inst, uint32_t event, uint32_t param, void *data);

/**
  * @brief Instance of a USB keyboard host driver
  */
typedef struct usbh_keyb_s  {
	uint32_t flag;				/**< Flags */
	usbh_keyb_cbk cbk;			/**< Callback */
	usbh_hid_inst_t *hid_inst;		/**< HID instance pointer */
	uint8_t mod_sticky;			/**< NUM_LOCK, CAPS_LOCK, SCROLL_LOCK, COMPOSE or KANA keys */
	uint8_t mod_state;			/**< Current state of the keyboard modifier keys */
	uint8_t key_state[6];			/**< Keyboard usage codes */
	uint8_t buf[USBHKEYB_REPORT_SIZE];	/**< Buffer to hold the current HID report */
} usbh_keyb_t;
/**
  * @}
  */

/** @addtogroup Host_Keyb_Public_Functions
  * @{
  */
extern usbh_keyb_t *usbh_keyb_open(usbh_keyb_cbk cbk, uint8_t *buf, uint32_t size);
extern uint32_t usbh_keyb_close(usbh_keyb_t *inst);
extern uint32_t usbh_keyb_init(usbh_keyb_t *inst);
extern uint32_t usbh_keyb_modifier_set(usbh_keyb_t *inst, uint32_t modifier);
extern uint32_t usbh_keyb_poll_rate_set(usbh_keyb_t *inst, uint32_t rate);
extern uint32_t usbh_keyb_usage_to_char(usbh_keyb_t *inst, const hid_keyb_usage_table_t *table, uint8_t usage);
extern uint32_t usbh_keyb_lpm_sleep(usbh_keyb_t *inst);
extern uint32_t usbh_keyb_lpm_status(usbh_keyb_t *inst);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
