/**
  *********************************************************************************
  *
  * @file    usbh_hid.h
  * @brief   Header file for the HID[HOST].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBH_HID_H__
#define __USBH_HID_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbh_core.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup HOST
  * @{
  */
/** @addtogroup Host_HID
  * @{
  */
/**
  * @defgroup Host_HID_Public_Macros Public Macros
  * @{
  */
#ifndef HID_MAX_DEVICES
#define HID_MAX_DEVICES		USB_MAX_DEVICES
#endif

#define USBH_EVENT_HID_SETRPT	USBH_HID_EVENT_BASE + 0
#define USBH_EVENT_HID_REPORT	USBH_HID_EVENT_BASE + 1
#define USBH_EVENT_HID_KB_PRESS	USBH_HID_EVENT_BASE + 16
#define USBH_EVENT_HID_KB_REL	USBH_HID_EVENT_BASE + 17
#define USBH_EVENT_HID_KB_MOD	USBH_HID_EVENT_BASE + 18
#define USBH_EVENT_HID_MS_PRESS	USBH_HID_EVENT_BASE + 32
#define USBH_EVENT_HID_MS_REL	USBH_HID_EVENT_BASE + 33
#define USBH_EVENT_HID_MS_X	USBH_HID_EVENT_BASE + 34
#define USBH_EVENT_HID_MS_Y	USBH_HID_EVENT_BASE + 35
/**
  * @}
  */

/**
  * @defgroup Host_HID_Public_Types Public Types
  * @{
  */
/**
  * @brief Type of HID class
  */
typedef enum {
	USBH_HID_CLASS_NONE   = 0x0,	/**< None */
	USBH_HID_CLASS_KEYB   = 0x1,	/**< Keyboard */
	USBH_HID_CLASS_MOUSE  = 0x2,	/**< Mouse */
	USBH_HID_CLASS_VENDOR = 0x3,	/**< Vendor */
} hid_sub_class_t;

/**
  * @brief Instance of a USB HID host driver
  */
typedef struct  {
	usbh_device_t *dev;	/**< Device instance */
	usb_cbk cbk;		/**< Callback */
	void *arg;		/**< Parameter of the callback */
	hid_sub_class_t type;	/**< type of HID device */
	uint32_t in_pipe;	/**< Interrupt IN pipe */
} usbh_hid_inst_t;
/**
  * @}
  */

/** @addtogroup Host_HID_Public_Functions
  * @{
  */
extern usbh_hid_inst_t * usbh_hid_open(hid_sub_class_t type, usb_cbk cbk, void *arg);
extern void usbh_hid_close(usbh_hid_inst_t *inst);
extern uint32_t usbh_hid_report_desc_get(usbh_hid_inst_t *inst, uint8_t *buf, uint32_t size);
extern uint32_t usbh_hid_idle_set(usbh_hid_inst_t *inst, uint8_t dur, uint8_t report_id);
extern uint32_t usbh_hid_protocol_set(usbh_hid_inst_t *inst, uint32_t protocol);
extern uint32_t usbh_hid_report_set(usbh_hid_inst_t *inst, uint32_t interface, uint8_t *data, uint32_t size);
extern uint32_t usbh_hid_report_get(usbh_hid_inst_t *inst, uint32_t interface, uint8_t *data, uint32_t size);
extern uint32_t usbh_hid_lpm_sleep(usbh_hid_inst_t *inst);
extern uint32_t usbh_hid_lpm_status(usbh_hid_inst_t *inst);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
