/**
  *********************************************************************************
  *
  * @file    usbh_bulk.h
  * @brief   Header file for the BULK[HOST].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBH_BULK_H__
#define __USBH_BULK_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbh_core.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup HOST
  * @{
  */
/** @addtogroup Host_BULK
  * @{
  */
/**
  * @defgroup Host_BULK_Public_Macros Public Macros
  * @{
  */
#define USBH_BULK_EVENT_OPEN	0x1U
#define USBH_BULK_EVENT_CLOSE	0x2U
/**
  * @}
  */

/**
  * @defgroup Host_BULK_Public_Types Public Types
  * @{
  */
struct usbh_bulk_inst_s;
typedef void (*usbh_bulk_cbk)(struct usbh_bulk_inst_s *inst, uint32_t event, void *data);

/**
  * @brief Instance of a USB BULK host driver
  */
typedef struct usbh_bulk_inst_s {
	usbh_device_t *dev;	/**< Device instance */
	usbh_bulk_cbk cbk;	/**< Callback */
	uint32_t in_pipe;	/**< BULK IN pipe */
	uint32_t out_pipe;	/**< BULK OUT pipe */
} usbh_bulk_inst_t;
/**
  * @}
  */

/** @addtogroup Host_BULK_Public_Functions
  * @{
  */
extern usbh_bulk_inst_t *usbh_bulk_driver_open(usbh_bulk_cbk cbk);
extern void usbh_bulk_driver_close(usbh_bulk_inst_t *inst);
extern uint32_t usbh_bulk_target_speed_get(usbh_bulk_inst_t *inst);
extern int32_t usbh_bulk_read(usbh_bulk_inst_t *inst, uint8_t *data, uint32_t size);
extern int32_t usbh_bulk_write(usbh_bulk_inst_t *inst, uint8_t *data, uint32_t size);
extern uint32_t usbh_bulk_lpm_sleep(usbh_bulk_inst_t *inst);
extern uint32_t usbh_bulk_lpm_status(usbh_bulk_inst_t *inst);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
