/**
  *********************************************************************************
  *
  * @file    usbd_hid_mouse.h
  * @brief   Header file for the mouse driver[Device].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBD_HID_MOUSE_H__
#define __USBD_HID_MOUSE_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbd_hid.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup DEVICE
  * @{
  */
/** @addtogroup Device_Mouse
  * @{
  */
/**
  * @defgroup Device_Mouse_Public_Macros Public Macros
  * @{
  */
#define MOUSE_REPORT_SIZE	3U
#define MOUSE_SUCCESS		0U
#define MOUSE_ERR_TX_ERROR	2U
#define MOUSE_ERR_NOT_CONFIG	4U
#define MOUSE_REPORT_BUTTON_1	0x01U
#define MOUSE_REPORT_BUTTON_2	0x02U
#define MOUSE_REPORT_BUTTON_3	0x04U
#define MOUSE_REPORT_BUTTON	0U
#define MOUSE_REPORT_X		1U
#define MOUSE_REPORT_Y		2U
#define MOUSE_IN_ENDPOINT	HID_MOUSE_EP_IN
/**
  * @}
  */

/**
  * @defgroup Device_Mouse_Public_Types Public Types
  * @{
  */
/**
  * @brief Mouse status
  */
typedef enum {
	HID_MOUSE_STATE_UNCONFIG  = 0,	/**< Unconfigured */
	HID_MOUSE_STATE_IDLE      = 1,	/**< Idle */
	HID_MOUSE_STATE_WAIT_DATA = 2,	/**< Waiting data */
	HID_MOUSE_STATE_SEND      = 3,	/**< Send */
} mouse_state_t;

/**
  * @brief Define the private instance data.
  */
typedef struct {
	uint8_t config;				/**< Configuration number */
	uint8_t protocol;			/**< Protocol */
	uint8_t report[MOUSE_REPORT_SIZE];	/**< Report buffer */
	volatile mouse_state_t state;		/**< State of the mouse */
	hid_report_idle_t idle;			/**< Idle */
	usbd_hid_dev_t dev;			/**< HID device */
} hid_mouse_inst_t;

/**
  * @brief Define operating parameters for the HID device
  */
typedef struct {
    const uint16_t vid;			/**< Vendor ID */
    const uint16_t pid;			/**< Product ID */
    const uint16_t max_power;		/**< Maximum power consumption */
    const uint8_t attr_pwr;		/**< Attribute of the power */
    const usb_cbk cbk;			/**< Callback function */
    void *arg;				/**< Parameter */
    const uint8_t * const *desc_str;	/**< String descriptor */
    const uint32_t num_str;		/**< Number of the string descriptors */
    hid_mouse_inst_t inst;		/**< Device instance */
} usbd_hid_mouse_dev_t;
/**
  * @}
  */

/** @addtogroup Device_Mouse_Public_Functions
  * @{
  */
extern void *usbd_hid_mouse_init(uint32_t idx, usbd_hid_mouse_dev_t *dev);
extern void *usbd_hid_mouse_init_comp(uint32_t idx, usbd_hid_mouse_dev_t *dev, comp_entry_t *entry);
extern void usbd_hid_mouse_term(void *device);
extern void *usbd_hid_mouse_set_param(void *device, void *arg);
extern uint32_t usbd_hid_mouse_state_change(void *device, int8_t x, int8_t y, uint8_t button);
extern void usbd_hid_mouse_power_status_set(void *device, uint8_t power);
extern int usbd_hid_mouse_remote_wakeup_req(void *device);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
