/**
  *********************************************************************************
  *
  * @file    usbd_comp.h
  * @brief   Header file for the composite driver[Device].
  *
  * @version V1.0
  * @date    30 Jul 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          30 Jul 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
  * NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
  * NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  * A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. EASTSOFT SHALL NOT, UNDER ANY
  * CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
  * DAMAGES, FOR ANY REASON WHATSOEVER.
  *
  *********************************************************************************
  */

#ifndef __USBD_COMP_H__
#define __USBD_COMP_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include "usbd_core.h"


/** @addtogroup USB_LIBRARY
  * @{
  */
/** @addtogroup DEVICE
  * @{
  */
/** @addtogroup Device_COMP
  * @{
  */
/**
  * @defgroup Device_COMP_Public_Macros Public Macros
  * @{
  */
#define LOOKUP_INDEX_BYTE	0U
#define LOOKUP_INTERFACE_BYTE	1U
#define LOOKUP_IN_END_BYTE	2U
#define LOOKUP_OUT_END_BYTE	3U
#define INVALID_DEVICE_INDEX	0xFFFFFFFFU
/**
  * @}
  */

/**
  * @defgroup Device_COMP_Public_Types Public Types
  * @{
  */
/**
  * @brief Composite entry structure
  */
typedef struct {
	const device_info_t *info;	/**< Device information */
	const config_head_t *hdr;	/**< configure descriptor */
	uint8_t offset;			/**< Offset */
} usbd_comp_entry_t;

/**
  * @brief Define the private instance data.
  */
typedef struct {
	uint32_t usb_idx;		/**< Index of the USB controller */
	device_info_t info;		/**< Device information */
	config_desc_t desc_config;	/**< Configure descriptor */
	device_desc_t desc_device;	/**< Device descriptor */
	config_head_t hdr;		/**< Head of configure descriptor */
	config_section_t sec[2];	/**< Section */
	config_section_t *p_sec[2];	/**< Section pointer */
	uint32_t size;			/**< Size of the buffer */
	uint8_t *data;			/**< Data buffer */
	uint32_t ep0_owner;		/**< Owner of the EP0 */
} comp_inst_t;

/**
  * @brief Define operating parameters for the HID device
  */
typedef struct {
	const uint16_t vid;			/**< Vendor ID */
	const uint16_t pid;			/**< Product ID */
	const uint16_t max_power;		/**< Maximum power consumption */
	const uint8_t attr_pwr;			/**< Attribute of the power */
	const usb_cbk cbk;			/**< Callback function */
	const uint8_t * const *desc_str;	/**< String descriptor */
	const uint32_t num_str;			/**< Number of the string descriptors */
	const uint32_t nr_device;		/**< Number of the device */
	comp_entry_t * const device;		/**< Entry array */
	comp_inst_t inst;			/**< Device instance */
} usbd_comp_dev_t;
/**
  * @}
  */
/** @addtogroup Device_COMP_Public_Functions
  * @{
  */
extern void *usbd_comp_init(uint32_t idx, usbd_comp_dev_t *dev, uint32_t size, uint8_t *data);
extern void usbd_comp_term(usbd_comp_dev_t *dev);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif
