/*******************************************************************************
* Function Name  : iirarma
* Description    : IIR order ARMA 16-bit filter
* Input          : - y: Output array .
*                  - x: Input array 
*                  - h2: AutoRegressive part Filter Coefficients
*                  - h1: Moving Average part Filter Coefficients
*                  - ny: the number of output samples
* Output         : None
* Return         : None
*******************************************************************************/
/* void iirarma(void *y, void *x,  short *h2, short *h1, int ny); */

  SECTION .text:CODE(2)

  PUBLIC  iirarma

#define y       R0    /* Assigned to output array y[]  */
#define x       R1    /* Assigned to input array x[]   */
#define h2      R2    /* Assigned to coefficients h2[] */
#define h1      R3    /* Assigned to coefficients h1[] */

#define ar_a    R4
#define ar_b    R5
#define ar_c    R6
#define ar_d    R7

#define val_ny  R12   /* number of output samples */

iirarma:
           STMDB       SP!, {R4-R7}
           LDR         R12, [SP, #+16]
;
           CMP      val_ny, #+1           ;if val_ny==1
           BEQ     done_for_now          ;go to done_for_now
;
acc_five_data:
           LDRSH    ar_a, [h2, #+0]
           LDRSH    ar_b, [x, #+8]
           LDRSH    ar_c, [h2, #+2]
           LDRSH    ar_d, [x, #+6]
;
           SUBS     val_ny, val_ny, #+1     ;decrement val_ny
           MUL      ar_c, ar_d, ar_c
           MLA      ar_a, ar_b, ar_a, ar_c
           LDRSH    ar_b, [h1, #+2]
           LDRSH    ar_c, [y, #+6]
           MUL      ar_b, ar_c,ar_b
           LDRSH    ar_c, [x, #+4]
           SUB      ar_a, ar_a, ar_b
           LDRSH    ar_b, [h2, #+4]
           MLA      ar_a, ar_c, ar_b, ar_a
           LDRSH    ar_b, [h1, #+4]
           LDRSH    ar_c, [y, #+4]
           MUL      ar_b, ar_c, ar_b
           LDRSH    ar_c, [x, #+2]
           SUB      ar_a, ar_a, ar_b
           LDRSH    ar_b, [h2, #+6]
           MLA      ar_a, ar_c, ar_b, ar_a
           LDRSH    ar_b, [h1, #+6]
           LDRSH    ar_c, [y, #+2]
           MUL      ar_b, ar_c, ar_b
           LDRSH    ar_c, [x], #+2
           SUB      ar_a, ar_a, ar_b
           LDRSH    ar_b, [h2, #+8]
           MLA      ar_a, ar_c, ar_b, ar_a
           LDRSH    ar_b, [h1, #+8]
           LDRSH    ar_c, [y, #+0]
           MUL      ar_b, ar_c, ar_b
           SUB      ar_a, ar_a, ar_b
           ASR      ar_a, ar_a, #+15
           STRH     ar_a, [y, #+8]
           ADD      y, y, #+2
           BNE      acc_five_data
;
done_for_now:
           LDMIA    SP!, {R4-R7}
           BX       LR               ;; return
           END
