/*;******************************************************************************
;* Function Name  : iirarma
;* Description    : IIR order ARMA 16-bit filter
;* Input          : - y: Output array .
;*                  - x: Input array 
;*                  - h2: AutoRegressive part Filter Coefficients
;*                  - h1: Moving Average part Filter Coefficients
;*                  - ny: the number of output samples
;* Output         : None
;* Return         : None
;*******************************************************************************/
/* void iirarma(void *y, void *x,  short *h2, short *h1, int ny) */

.cpu cortex-m3
.fpu softvfp   
.syntax unified
.thumb
.text	

.global  iirarma

.thumb_func
iirarma:
           STMDB       SP!, {R4-R7}
           LDR         R12, [SP, #+16]

           CMP      r12, #+1        /*if val_ny==1*/
           BEQ     done_for_now     /*go to done_for_now*/

acc_five_data:
           LDRSH    r4, [r2, #+0]
           LDRSH    r5, [r1, #+8]
           LDRSH    r6, [r2, #+2]
           LDRSH    r7, [r1, #+6]

           SUBS     r12, r12, #+1   /*decrement val_ny*/
           MUL      r6, r7, r6
           MLA      r4, r5, r4, r6
           LDRSH    r5, [r3, #+2]
           LDRSH    r6, [r0, #+6]
           MUL      r5, r6,r5
           LDRSH    r6, [r1, #+4]
           SUB      r4, r4, r5
           LDRSH    r5, [r2, #+4]
           MLA      r4, r6, r5, r4
           LDRSH    r5, [r3, #+4]
           LDRSH    r6, [r0, #+4]
           MUL      r5, r6, r5
           LDRSH    r6, [r1, #+2]
           SUB      r4, r4, r5
           LDRSH    r5, [r2, #+6]
           MLA      r4, r6, r5, r4
           LDRSH    r5, [r3, #+6]
           LDRSH    r6, [r0, #+2]
           MUL      r5, r6, r5
           LDRSH    r6, [r1], #+2
           SUB      r4, r4, r5
           LDRSH    r5, [r2, #+8]
           MLA      r4, r6, r5, r4
           LDRSH    r5, [r3, #+8]
           LDRSH    r6, [r0, #+0]
           MUL      r5, r6, r5
           SUB      r4, r4, r5
           ASR      r4, r4, #+15
           STRH     r4, [r0, #+8]
           ADD      r0, r0, #+2
           BNE      acc_five_data

done_for_now:
           LDMIA    SP!, {R4-R7}
           BX       LR               /* return */
.end          
