;/*******************************************************************************
;* Function Name  : do_pid_asm
;* Description    : PID in ASM, Error computed outside the routine
;* Input          : Error: difference between reference and measured value
;*                  Coeff: pointer to the coefficient table
;* Output         : None
;* Return         : PID output (command)
;*******************************************************************************/

  THUMB
  REQUIRE8
  PRESERVE8

  AREA |.text|, CODE, READONLY, ALIGN=2

  EXPORT do_pid_asm
  IMPORT IntTerm
  IMPORT PrevError

Err     RN R0    				; 1st function input: Error  
Coeff   RN R1    				; 2nd fct input: Address of coefficient table 
Kd      RN R1
Ki      RN R2
Kp      RN R3

Out     RN R4
Result  RN R2
Integ   RN R5
PrevErr RN R12

do_pid_asm

  PUSH {R4, R5, R9}

  LDR R12, =IntTerm
  LDR R9, =PrevError

  LDRSH Kp, [Coeff, #0]  		; Load Kp 
  LDRSH Ki, [Coeff, #2]  		; Load Ki 
  LDRSH Kd, [Coeff, #4]  		; Load Kd and destroy Coeff
  LDRSH Integ, [R12, #0]  		; Last Integral Term 
  LDRSH PrevErr, [R9, #0]  		; Previous Error 

  MLA Integ, Ki, Err, Integ   	; IntTerm += Ki*error 
  MLA Out, Kp, Err, Integ      	; Output = (Kp * error) + InTerm 
  SUBS PrevErr, Err, PrevErr    ; PrevErr now holds DeltaError = Error - PrevError 
  MLA Result, Kd, PrevErr, Out  ; Output += Kd * DeltaError 

  LDR R12, =IntTerm
  STRH Integ, [R12, #0]       	; Write back InTerm 
  STRH Err, [R9, #0]         	; Write back PrevError 

  MOV R0, Result
  ;UXTH R0, R0
  POP {R4, R5, R9}
  BX LR

  END

