/**
 ******************************************************************************
 * @file es32_dsp.h
 * @author  AE team
 * @version  V1.0.0
 * @date  2024.1.25
 * @brief  DSP include file
 ******************************************************************************
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 Jan 2024     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __ES32F3_DSP_H__
#define __ES32F3_DSP_H__

/* Includes ------------------------------------------------------------------*/
#include "stdint.h"


/* Exported types ------------------------------------------------------------*/
/* for block FIR module */
typedef struct {
  const int16_t *h;
  uint32_t nh;
} COEFS;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

/* FIR 16-bit filter in assembly */
void fir_16by16(int32_t *y, const int16_t *x, COEFS *c, uint32_t N);

/* PID controller in C, error computed outside the function */
int16_t do_pid(int16_t Error, int16_t *Coeff);

/* Full PID in C, error computed inside the function */
int16_t do_full_pid(int16_t In, int16_t Ref, int16_t *Coeff);

/* Reset internal PID error&intergram (C version) */
void reset_pid_c(int16_t prev_err,int16_t int_term);

/* PID controller in assembly, error computed outside the function */
int16_t do_pid_asm(int16_t Error, int16_t *Coeff);

/* Reset internal PID error&intergram (ASM version) */
void reset_pid_asm(int16_t prev_err,int16_t int_term);

/* Radix-4 complex FFT, in assembly  */
/* 64 points*/
void cfft_r4_64(void *pssOUT, void *pssIN, uint16_t Nbin);
/* 256 points */
void cfft_r4_256(void *pssOUT, void *pssIN, uint16_t Nbin);
/* 1024 points */
void cfft_r4_1024(void *pssOUT, void *pssIN, uint16_t Nbin);

/* IIR filter in assembly */
void iir_arma(void *y, void *x, uint16_t *h2, uint16_t *h1, uint32_t ny );

/* IIR filter in C */
void iir_biquad_fixed(uint16_t *y,const uint16_t *x,const int16_t *IIRCoeff, uint16_t ny);

/*IIR coefficient fixed point */
#define IIR_FIXED 12

#endif /* ES32F3_DSP_H */

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
