/**********************************************************************************
 *
 * @file    md_sva.c
 * @brief   md_sva C file
 *
 * @date    11 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          11 Aug 2022     kevin zeng      the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/
#include "md_rcu.h"
#include "md_sva.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Micro_Driver
  * @{
  */

/** @addtogroup MD_SVA
  * @{
  */

/** @addtogroup MD_SVA_Public_Functions
  * @{
  */
/** @addtogroup SVA_Function
  * @{
  */
void md_sva_config(SVA_TypeDef *SVAx, md_sva_config_typedef *config)
{
    md_sva_set_operation_mode(SVAx, config->op_mode);
    md_sva_set_input_data_0(SVAx, config->input_data0);
    md_sva_set_input_data_1(SVAx, config->input_data1);
    md_sva_set_input_angle(SVAx, config->input_angle);

    if (config->dma_en == MD_SVA_DMA_ENABLE)
    {
        md_sva_enable_dma_request(SVAx);
    }
    else
    {
        md_sva_disable_dma_request(SVAx);
    }

    if (config->outputmul_en == MD_SVA_OUTPUTMUL_ENABLE)
    {
        md_sva_enable_output_multiple(SVAx);
    }
    else
    {
        md_sva_disable_output_multiple(SVAx);
    }

    md_sva_set_output_multiple(SVAx, config->outputmul);

    if (config->input_exchange == MD_SVA_INPUT_EXCHANGE)
        md_sva_set_input_exchange(SVAx);
    else
        md_sva_set_input_no_exchange(SVAx);
}
/**
 * @}
 */
/**
 * @}
 */
/**
 * @}
 */
/**
 * @}
 */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
