/**********************************************************************************
 *
 * @file    md_cmp.c
 * @brief   md_cmp C file
 *
 * @date    07 Jun. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Jun. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/
#include "md_cmp.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup MD
 * @{
 */

/**@defgroup CMP CMP
 * @brief CMP module driver
 * @{
 */

/* Public Function ---------------------------------------------------------- */

/**@defgroup CMP_Public_Functions CMP Public Functions
 * @{
 */

/**
  * @brief  Initializes the CMP according to the specified
  *         parameters in the ald_cmp_init_t.
  * @param  hperh: Pointer to a ald_cmp_init_t structure that contains
  *         the configuration information for the specified CMP module.
  * @retval None
  */
void md_cmp1_init(md_cmp1_init_t *hperh)
{
    if (((CMP->CFG1) >> CMP_CFG1_LOCK_POS))
    {
        RCU->APB2RST = 1 << 23;
        RCU->APB2RST = 0;
    }

    if (hperh->en == MD_CMP_CFG_EN_OPEN)
        SET_BIT(CMP->CFG1, CMP_CFG1_EN_MSK);
    else
        CLEAR_BIT(CMP->CFG1, CMP_CFG1_EN_MSK);

    if (hperh->lock == MD_CMP_CFG_LOCK_R)
        SET_BIT(CMP->CFG1, CMP_CFG1_LOCK_MSK);
    else
        CLEAR_BIT(CMP->CFG1, CMP_CFG1_LOCK_MSK);

    MODIFY_REG(CMP->CFG1, CMP_CFG1_BLANKSEL_MSK, (hperh->blanksel << CMP_CFG1_BLANKSEL_POSS));

    if (hperh->hyst == MD_CMP_CFG_HYST_OPEN)
        SET_BIT(CMP->CFG1, CMP_CFG1_HYST_MSK);
    else
        CLEAR_BIT(CMP->CFG1, CMP_CFG1_HYST_MSK);

    if (hperh->polarity == MD_CMP_CFG_POLARITY_YES)
        SET_BIT(CMP->CFG1, CMP_CFG1_POLARITY_MSK);
    else
        CLEAR_BIT(CMP->CFG1, CMP_CFG1_POLARITY_MSK);

    MODIFY_REG(CMP->CFG1, CMP_CFG1_INPSEL_MSK, (hperh->inpsel << CMP_CFG1_INPSEL_POSS));
    MODIFY_REG(CMP->CFG1, CMP_CFG1_INNSEL_MSK, (hperh->innsel << CMP_CFG1_INNSEL_POSS));
}

void ald_cmp2_init(md_cmp2_init_t *hperh)
{
    if (((CMP->CFG2) >> CMP_CFG1_LOCK_POS))
    {
        RCU->APB2RST = 1 << 23;
        RCU->APB2RST = 0;
    }

    if (hperh->en == MD_CMP_CFG_EN_OPEN)
        SET_BIT(CMP->CFG2, CMP_CFG2_EN_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_EN_MSK);

    if (hperh->lock == MD_CMP_CFG_LOCK_R)
        SET_BIT(CMP->CFG2, CMP_CFG2_LOCK_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_LOCK_MSK);

    MODIFY_REG(CMP->CFG2, CMP_CFG2_BLANKSEL_MSK, (hperh->blanksel << CMP_CFG2_BLANKSEL_POSS));

    if (hperh->hyst == MD_CMP_CFG_HYST_OPEN)
        SET_BIT(CMP->CFG2, CMP_CFG2_HYST_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_HYST_MSK);

    if (hperh->polarity == MD_CMP_CFG_POLARITY_YES)
        SET_BIT(CMP->CFG2, CMP_CFG2_POLARITY_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_POLARITY_MSK);

    MODIFY_REG(CMP->CFG2, CMP_CFG2_INPSEL_MSK, (hperh->inpsel << CMP_CFG2_INPSEL_POSS));
    MODIFY_REG(CMP->CFG2, CMP_CFG2_INNSEL_MSK, (hperh->innsel << CMP_CFG2_INNSEL_POSS));

    if (hperh->winout == MD_CMP_CFG2_WINOUT_OPEN)
        SET_BIT(CMP->CFG2, CMP_CFG2_WINOUT_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_WINOUT_MSK);

    if (hperh->winmode == MD_CMP_CFG2_WINMODE_OPEN)
        SET_BIT(CMP->CFG2, CMP_CFG2_WINMODE_MSK);
    else
        CLEAR_BIT(CMP->CFG2, CMP_CFG2_WINMODE_MSK);
}

/**
  * @brief  Get comp1 result
  * @param  None.
  * @retval result.
  */
uint32_t md_cmp_read_cmp1(CMP_TypeDef *cmp)
{
    return (uint32_t)(READ_BIT(cmp->CFG1, CMP_CFG1_VALUE) >> CMP_CFG1_VALUE_POS);
}

/**
  * @brief  Get comp2 result
  * @param  None.
  * @retval result.
  */
uint32_t md_cmp_read_cmp2(CMP_TypeDef *cmp)
{
    return (uint32_t)(READ_BIT(cmp->CFG2, CMP_CFG2_VALUE) >> CMP_CFG2_VALUE_POS);
}

void md_cmp_deinit(void)
{
    RCU->APB2RST = 1 << 23;
    RCU->APB2RST = 0;
}
/**
 * @}
 */

/**
  * @}
  */

/**
  * @}
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
