/**********************************************************************************
 *
 * @file    md_calc.c
 * @brief   md_calc C file
 *
 * @date    07 Jun. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Jun. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/
#include "md_calc.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/** @addtogroup MD
  * @{
  */

/** @defgroup CALC CALC
  * @brief CALC module driver
  * @{
  */

/* Private Function ---------------------------------------------------------- */

/** @defgroup CALC_Public_Functions CALC Public functions
  * @{
  */

/**
  * @brief  Set Division operation initial.
  * @param  calc_perh: Pointer to a ald_calc_div_t structure that contains
  *                the configuration information for the specified Division operation.
  * @param  Quotient
  * @param  Remainder
  * @retval Status, see @ref ald_status_t.
  */
md_status_t md_calc_division(md_calc_div_t *calc_perh, uint32_t *Quotient, uint32_t *Remainder)
{

    if (calc_perh->calc_divisor == 0)
        return MD_ERROR;

    CALC->DIVCON = ((calc_perh->div_trm << 1) | (calc_perh->sign)) ;
    CALC->DIVDR = calc_perh->calc_dividend;
    CALC->DIVSR = calc_perh->calc_divisor;

    *Quotient =  CALC->DIVQR;
    *Remainder = CALC->DIVRR;

    return MD_OK;
}

/**
  * @brief  Set Square root operation.
  * @param  calc_perh: Pointer to a ald_calc_radicand_t structure that contains
  *                the configuration information for the specified Square root operation.
  * @retval SQRTRES
  */
uint32_t md_calc_square_root(md_calc_radicand_t *calc_perh)
{
    CALC->RDCND = calc_perh->calc_radicand;

    return READ_REG(CALC->SQRTRES);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE****/
