/**
  *********************************************************************************
  *
  * @file    ald_cache.c
  * @brief   CACHE module driver.
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "md_conf.h"

/** @addtogroup Micro_Driver
  * @{
  */

/** @defgroup CACHE CACHE
  * @brief CACHE module driver
  * @{
  */
#ifdef MD_CACHE

/** @defgroup CACHE_Public_Functions CACHE Public Functions
  * @brief    Flash Cache functions
  * @{
  */

/**
 * @brief Initializes the Cache according to the specified parameters.
 * @param config: Pointer to md_cache_config_t structure which contains
 *        the configuration parameters.
 * @retval None
 */
void md_cache_init(md_cache_config_t* config)
{
    MODIFY_REG(CACHE->CCR, CACHE_CCR_STATISTIC_EN_MSK, config->statistic << CACHE_CCR_STATISTIC_EN_POS);
    MODIFY_REG(CACHE->CCR, CACHE_CCR_SET_PREFETCH_MSK, config->prefetch << CACHE_CCR_SET_PREFETCH_POS);
    MODIFY_REG(CACHE->CCR, CACHE_CCR_SET_MAN_INV_MSK, config->invlidate << CACHE_CCR_SET_MAN_INV_POS);
    MODIFY_REG(CACHE->CCR, CACHE_CCR_SET_MAN_POW_MSK, config->power << CACHE_CCR_SET_MAN_POW_POS);
}

/**
  * @}
  */
#endif /* MD_CACHE */
/**
  * @}
  */
/**
  * @}
  */
