/**
  *********************************************************************************
  *
  * @file    ald_calc.h
  * @brief   Header file of CALC module driver.
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __MD_CALC_H__
#define __MD_CALC_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "md_utils.h"


/** @addtogroup ES32F3XXX_ALD
  * @{
  */
#define UNSIGNED_DIV_MODE 0
#define SIGNED_DIV_MODE   1
#define SQRT_MODE         2

/** @addtogroup CALC
  * @{
  */
/**
  * @brief  Check if Calculation is busy or complet.
  * @param  CALC_TypeDef calc Instance.
  * @retval State of bit (1 or 0).
  */
__STATIC_INLINE uint32_t md_calc_is_enable_busy(CALC_TypeDef *calc)
{
    return (READ_BIT(calc->CSR, CALC_CSR_BUSY_MSK) == (SET));
}
/**
  * @brief  Check if Calculation is busy or complet.
  * @param  CALC_TypeDef calc Instance.
  * @retval State of bit (1 or 0).
  */
__STATIC_INLINE uint32_t md_calc_is_enable_zero(CALC_TypeDef *calc)
{
    return (READ_BIT(calc->CSR, CALC_CSR_DZ_MSK) == (SET));
}
/** @addtogroup CALC_Public_Functions
  * @{
  */


extern uint32_t md_calc_sqrt(uint32_t data);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif /* __ALD_CALC_H__ */
