/**
  *********************************************************************************
  *
  * @file    md_crypt.c
  * @brief   CRYPT module driver.
  *
  * @version V1.0
  * @date    19 Feb 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          19 Feb 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "md_conf.h"

/** @addtogroup Micro_Driver
  * @{
  */
#ifdef MD_CRYPT
/** @addtogroup MD_CRYPT
  * @{
  */

/** @addtogroup MD_CRYPT_Public_Functions
  * @{
  */
/** @addtogroup MD_CRYPT_Public_Functions_Group1
  * @{
  */
/**
  * @brief  Reset the CRYPT peripheral.
  * @retval None
  */
void md_crypt_reset(void)
{
	WRITE_REG(CRYPT->DATA[0], 0);
	WRITE_REG(CRYPT->DATA[1], 0);
	WRITE_REG(CRYPT->DATA[2], 0);
	WRITE_REG(CRYPT->DATA[3], 0);
	WRITE_REG(CRYPT->KEY[0], 0);
	WRITE_REG(CRYPT->KEY[1], 0);
	WRITE_REG(CRYPT->KEY[2], 0);
	WRITE_REG(CRYPT->KEY[3], 0);
	WRITE_REG(CRYPT->KEY[4], 0);
	WRITE_REG(CRYPT->KEY[5], 0);
	WRITE_REG(CRYPT->KEY[6], 0);
	WRITE_REG(CRYPT->KEY[7], 0);
	WRITE_REG(CRYPT->IV[0], 0);
	WRITE_REG(CRYPT->IV[1], 0);
	WRITE_REG(CRYPT->IV[2], 0);
	WRITE_REG(CRYPT->IV[3], 0);
	WRITE_REG(CRYPT->CON, 0x8000);
	WRITE_REG(CRYPT->IFC, 0xFFFF);
}

/**
  * @brief  Initializes the CRYPT mode according to the specified parameters in
  *         the @ref md_crypt_init_t
  * @param  init Pointer to a md_crypt_init_t structure that contains
  *         the configuration information for the specified CRYPT module.
  * @retval None
  */
void md_crypt_init(md_crypt_init_t *init)
{
	md_crypt_reset();
	MODIFY_REG(CRYPT->CON, CRYPT_CON_ENCS_MSK, init->encs);
	MODIFY_REG(CRYPT->CON, CRYPT_CON_MODE_MSK, init->mode);
	MODIFY_REG(CRYPT->CON, CRYPT_CON_TYPE_MSK, init->type);
	MODIFY_REG(CRYPT->CON, CRYPT_CON_FIFOODR_MSK, init->order);
	MODIFY_REG(CRYPT->CON, CRYPT_CON_CRYSEL_MSK, (init->standard << CRYPT_CON_CRYSEL_POS));
}

/**
  * @brief  Initialize the CRYPT peripheral using the default parameters.
  * @param  init: Pointer to a md_crypt_init_t structure
  * @retval None
  */
void md_crypt_init_struct(md_crypt_init_t *init)
{
	init->standard = MD_CRYPT_STANDARD_AES;
	init->mode     = MD_CRYPT_MODE_ECB;
	init->type     = MD_CRYPT_TYPE_32;
	init->order    = MD_CRYPT_FIFO_ORDER_0;
	init->encs     = MD_CRYPT_SEL_ENCRYPT;
}
/**
 * @}
 */
/**
 * @}
 */
/**
 * @}
 */
#endif
/**
 * @}
 */
