/**
  *********************************************************************************
  *
  * @file    md_bkpc.c
  * @brief   Backup control unit driver.
  *
  * @version V1.0
  * @date    01 Jul 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          01 Jul 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "md_conf.h"


/** @addtogroup Micro_Driver
  * @{
  */
#ifdef MD_BKPC

/** @addtogroup MD_BKPC
  * @{
  */

/** @addtogroup MD_BKPC_Public_Functions
  * @{
  */
/** @addtogroup MD_BKPC_Public_Functions_Group1
  * @{
  */
/**
  * @brief  Configure standby wakeup in backup field
  * @param  port: Wakeup port
  * @param  level: HIGH/LOW.
  * @retval None
  */
void md_bkpc_standby_wakeup_config(md_bkpc_wakeup_port_t port, md_bkpc_wakeup_level_t level)
{
	if (port == MD_PMU_STANDBY_PORT_SEL_NONE) {
		MD_BKPC_UNLOCK();
		CLEAR_BIT(BKPC->CR, BKPC_CR_WKPEN_MSK);
		SET_BIT(BKPC->CR, BKPC_CR_MRST_WKPEN_MSK);
		MD_BKPC_LOCK();
		return;
	}

	MD_BKPC_UNLOCK();
	SET_BIT(BKPC->CR, BKPC_CR_WKPEN_MSK | BKPC_CR_MRST_WKPEN_MSK);
	MODIFY_REG(BKPC->CR, BKPC_CR_WKPS_MSK, port << BKPC_CR_WKPS_POSS);
	MODIFY_REG(BKPC->CR, BKPC_CR_WKPOL_MSK, level << BKPC_CR_WKPOL_POS);
	MD_BKPC_LOCK();

	return;
}

/**
  * @brief  Configure rtc clock in backup field
  * @param  clock: Clock
  * @retval None
  */
void md_bkpc_rtc_clock_config(md_bkpc_preh_clk_t clock)
{
	MD_BKPC_UNLOCK();
	MODIFY_REG(BKPC->PCCR, BKPC_PCCR_RTCCS_MSK, clock << BKPC_PCCR_RTCCS_POSS);
	MD_BKPC_LOCK();

	return;
}

/**
  * @brief  Configure tsense clock in backup field
  * @param  clock: Clock
  * @retval None
  */
void md_bkpc_tsense_clock_config(md_bkpc_preh_clk_t clock)
{
	MD_BKPC_UNLOCK();
	MODIFY_REG(BKPC->PCCR, BKPC_PCCR_TSENSECS_MSK, clock << BKPC_PCCR_TSENSECS_POSS);
	MD_BKPC_LOCK();

	return;
}
/**
 * @}
 */
/**
 * @}
 */
/**
 * @}
 */
#endif
/**
 * @}
 */
