#include "md_anpwr.h"
#include "md_rcu.h"
#include "md_tick.h"
#include "md_opamp.h"

/**
  * @brief  opamp power init
  * @param  rcu RCU Instance
  * @param  anpwr ANPWR Instance
  * @param  a 32-bit value
  *         @arg @ref MD_ANPWR_VLDO_CHPCKS_1MHZ
  *         @arg @ref MD_ANPWR_VLDO_CHPCKS_2MHZ
  * @retval None
  */
void md_opamp_power_init(RCU_TypeDef *rcu, ANPWR_TypeDef *anpwr, md_opamp_power_init_typedef *anpwr_power_init)
{
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);

    //enable anpwr
    md_rcu_enable_anpwr(rcu);

    md_anpwr_enable_vbg_bias(anpwr);
    md_tick_wait10us(1, 1);
    md_anpwr_set_vldo_mode(anpwr, anpwr_power_init->vldo_mode);
    md_anpwr_set_vldo_sel(anpwr, anpwr_power_init->vldo_sel);

    md_tick_wait10us(20, 1);

    md_anpwr_enable_vbg(anpwr);
    md_anpwr_enable_vbg_chp(anpwr);
    md_anpwr_set_vbg_chpcks(anpwr, anpwr_power_init->vbg_chpcks);

    //chopper clock must be 4MHz
    md_rcu_set_chop_ckdiv(rcu, anpwr_power_init->chop_clockdiv);
    md_rcu_set_chop_ckcfg(rcu, anpwr_power_init->chop_clocksource);


}

void md_opamp_cofig(OPAMP_TypeDef *OPAMPx, md_opamp_config_typedef *config)
{
    md_opamp_enable_opa(OPAMPx);
    md_opamp_set_opa_inns(OPAMPx, config->opa_inns);
    md_opamp_set_opa_inps(OPAMPx, config->opa_inps);
    md_opamp_set_opa_out(OPAMPx, config->opa_out);
    md_opamp_set_opa_pwm_source(OPAMPx, config->opa_pwm_source);
    md_opamp_set_opa_mults(OPAMPx, config->opa_mults);
    md_opamp_set_opa_polas(OPAMPx, config->opa_polas);
    md_opamp_set_opa_caps(OPAMPx, config->opa_caps);
    md_opamp_set_opa_chpcks(OPAMPx, config->opa_chpcks);
    md_opamp_set_bounce_counter(OPAMPx, config->bounce_counter);
    md_opamp_set_bounce_prescaler(OPAMPx, config->bounce_prescaler);
}

void md_opamp_init(OPAMP_TypeDef *OPAMPx, md_opamp_power_init_typedef *anpwr_power_init, md_opamp_config_typedef *config)
{
    md_opamp_power_init(RCU, ANPWR, anpwr_power_init);
    md_opamp_cofig(OPAMPx, config);
}
