#include "md_lcd.h"
#include "md_rcu.h"
#include "md_tick.h"
#include "md_gpio.h"

void md_lcd_power_init(RCU_TypeDef *RCUx, LCD_TypeDef *LCDx, uint32_t lcd_ckcfg, uint32_t lcd_ckdiv, uint32_t vlcd_ckcfg, uint32_t vlcd_ckdiv, uint32_t vlcd_voltage)
{
    md_gpio_inittypedef GPIOB_PIN11_Init =
    {
        MD_GPIO_PIN_11,
        MD_GPIO_MODE_FUNCTION,
        MD_GPIO_OUTPUT_PUSHPULL,
        MD_GPIO_PULL_FLOATING,
        MD_GPIO_DRIVING_8MA,
        MD_GPIO_AF8
    };

    md_tick_init(MD_SYSTICK_CLKSRC_HCLK);

    md_rcu_enable_lcd(RCUx);
    md_rcu_enable_gpiob(RCUx);

    

    if (md_rcu_get_lcd_ckcfg(RCUx)!=MD_RCU_CFG2_LCDCK_DISABLE)
    {
        md_rcu_set_lcd_ckcfg(RCUx, MD_RCU_CFG2_LCDCK_DISABLE);
    }

    md_rcu_set_lcd_ckdiv(RCUx, lcd_ckdiv);
    md_rcu_set_lcd_ckcfg(RCUx, lcd_ckcfg);
    
    md_rcu_enable_lrc(RCUx);

    if (md_lcd_is_enabled_led(LCDx))
        md_lcd_disable_led(LCDx);

    switch (vlcd_ckcfg)
    {
        case MD_RCU_CFG2_VLCDCK_HOSC:
        case MD_RCU_CFG2_VLCDCK_HRC:
        case MD_RCU_CFG2_VLCDCK_PLL:
            //must be 2MHz
            md_rcu_set_vlcd_ckdiv(RCUx, vlcd_ckdiv);
            md_rcu_set_vlcd_ckcfg(RCUx, vlcd_ckcfg);
            md_lcd_set_vlcd_src(LCDx, MD_VLCD_SRC_CHARGE_PUMP);
            break;

        case MD_RCU_CFG2_VLCDCK_DISABLE:
            md_lcd_set_vlcd_src(LCDx, MD_VLCD_SRC_EXTERNAL);
            break;
    }

    //Must be PA11
    md_gpio_init(GPIOB, &GPIOB_PIN11_Init);

    if (vlcd_ckcfg != MD_RCU_CFG2_VLCDCK_DISABLE)
    {
        md_tick_waitms(2, 1);
        md_lcd_set_vlcd_voltage(LCDx, vlcd_voltage);
    }
}

void md_lcd_basic_init(LCD_TypeDef *LCDx, md_lcd_init_typedef *init)
{
    md_lcd_set_duty(LCDx, init->lcd_duty);
    md_lcd_set_bias(LCDx, init->lcd_bias);
    md_lcd_set_type(LCDx, init->lcd_type);
    md_lcd_set_division(LCDx, init->lcd_frdiv);
    md_lcd_set_update_control(LCDx, init->lcd_updctrl);
}




void md_lcd_init(LCD_TypeDef *LCDx, md_lcd_power_init_typedef *power_init, md_lcd_init_typedef *init)
{
    md_lcd_power_init(RCU, LCDx, power_init->lcd_clocksource, power_init->lcd_clockdiv, power_init->vlcd_clocksource, power_init->vlcd_clockdiv, power_init->vlcd_voltage);
    md_lcd_basic_init(LCD, init);
    md_lcd_enable_led(LCDx);

    while (md_lcd_is_active_flag_vlcd_ready(LCDx) == 0);
}
