/**********************************************************************************
 *
 * @file    md_anpwr.c
 * @brief   md_anpwr C file
 *
 * @date    28 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Apr 2023     Kevin zeng      the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/
#include "md_anpwr.h"
#include "md_rcu.h"
#include "md_tick.h"

/** @defgroup ANPWR ANPWR
  * @brief ANPWR micro driver
  * @{
  */

/* Private types --------------------------------------------------------------*/
/* Private variables ----------------------------------------------------------*/
/* Private constants ----------------------------------------------------------*/
/* Private macros -------------------------------------------------------------*/
/* Private function prototypes ------------------------------------------------*/
/* Public functions -----------------------------------------------------------*/

void md_anpwr_init(ANPWR_TypeDef *anpwr, md_anpwr_init_typedef *anpwr_init)
{
    md_tick_init(MD_SYSTICK_CLKSRC_HCLK_DIV8);
    md_anpwr_enable_vbg_bias(anpwr);
    md_tick_wait10us(1, 1);
    md_anpwr_set_vldo_mode(anpwr, anpwr_init->vldo_mode);
    md_anpwr_set_vldo_sel(anpwr, anpwr_init->vldo_sel);
    md_tick_wait100us(2, 1);
}

/**
  * @} ANPWR_PUB_FUNC ANPWR Public Functions
  */

/**
  * @} ADC
  */

/**
  * @} Micro_Driver
  */

/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
