;*********************************************************************************
;
; @file    startup_es32m0502.s
; @brief   ES32M0502 Device Startup File
;
; @date    28 Mar 2023
; @author  AE Team
; @note
;          Change Logs:
;          Date            Author          Notes
;          28 Mar 2023     AE Team         the first version
;
; Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
;
; SPDX-License-Identifier: Apache-2.0
;
; Licensed under the Apache License, Version 2.0 (the License); you may
; not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an AS IS BASIS, WITHOUT
; WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
;
;*********************************************************************************

; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp               ; Top of Stack
                ; External Interrupts
                DCD     Reset_Handler              ;1, Reset Handler
                DCD     NMI_Handler                ;2, NMI Handler
                DCD     HardFault_Handler          ;3, HardFault Handler
                DCD     0                          ;4, Reserved
                DCD     0                          ;5, Reserved
                DCD     0                          ;6, Reserved
                DCD     0                          ;7, Reserved
                DCD     0                          ;8, Reserved
                DCD     0                          ;9, Reserved
                DCD     0                          ;10, Reserved
                DCD     SVCall_Handler             ;11, SVCall Handler
                DCD     0                          ;12, Reserved
                DCD     0                          ;13, Reserved
                DCD     PendSV_Handler             ;14, PendSV Handler
                DCD     SysTick_Handler            ;15, SysTick Handler
                DCD     WWDT_IRQHandler            ;16, WWDT IRQHandler
                DCD     LVD_IRQHandler             ;17, LVD IRQHandler
                DCD     CM0IKMCU_IRQ2_IRQHandler   ;18, Reserved
                DCD     WAKEUP_IRQHandler          ;19, WAKEUP IRQHandler
                DCD     RCU_IRQHandler             ;20, RCU IRQHandler
                DCD     EXTI_0to1_IRQHandler       ;21, EXTI_0to1 IRQHandler
                DCD     EXTI_2to3_IRQHandler       ;22, EXTI_2to3 IRQHandler
                DCD     EXTI_4to15_IRQHandler      ;23, EXTI_4to15 IRQHandler
                DCD     DMA1_CH0_IRQHandler        ;24, DMA1_CH0 IRQHandler   
                DCD     DMA1_CH1_IRQHandler        ;25, DMA1_CH1 IRQHandler   
                DCD     DMA1_CH2_IRQHandler        ;26, DMA1_CH2 IRQHandler
                DCD     DMA1_CH3_IRQHandler        ;27, DMA1_CH3 IRQHandler
                DCD     DMA1_CH4_IRQHandler        ;28, DMA1_CH4 IRQHandler
                DCD     DMA1_CH5_IRQHandler        ;29, DMA1_CH5 IRQHandler
                DCD     ADC_IRQHandler             ;30, ADC IRQHandler
                DCD     SVA_IRQHandler             ;31, SVA IRQHandler
                DCD     CAN1_TX_IRQHandler         ;32, CAN1_TX IRQHandler     
                DCD     CAN1_RXFIFO0_IRQHandler    ;33, CAN1_RXFIFO0 IRQHandler
                DCD     CAN1_RXFIFO1_IRQHandler    ;34, CAN1_RXFIFO1 IRQHandler
                DCD     CAN1_IRQHandler            ;35, CAN1 IRQHandler        
                DCD     AD16C6T1_IRQHandler        ;36, AD16C6T1 IRQHandler
                DCD     GP16C2T1_IRQHandler        ;37, GP16C2T1 IRQHandler
                DCD     GP16C2T2_IRQHandler        ;38, GP16C2T2 IRQHandler
                DCD     GP32C4T1_IRQHandler        ;39, GP32C4T1 IRQHandler
                DCD     GP32C4T2_IRQHandler        ;40, GP32C4T2 IRQHandler
                DCD     I2C1_IRQHandler            ;41, I2C1 IRQHandler
                DCD     SPI1_IRQHandler            ;42, SPI1 IRQHandler
                DCD     UART1_IRQHandler           ;43, UART1 IRQHandler
                DCD     UART2_IRQHandler           ;44, UART2 IRQHandler
                DCD     AD16C6T2_IRQHandler        ;45, AD16C6T2 IRQHandler
                DCD     BS16T1_IRQHandler          ;46, BS16T1 IRQHandler
                DCD     CMP_IRQHandler             ;47, CMP IRQHandler


                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  __main
                IMPORT  SystemInit
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP

; Dummy Exception IRQHandlers (infinite loops which can be modified)

NMI_Handler      PROC
            EXPORT  NMI_Handler            [WEAK]
            B       .
            ENDP
HardFault_Handler      PROC
            EXPORT  HardFault_Handler      [WEAK]
            B       .
            ENDP


SVCall_Handler      PROC
            EXPORT  SVCall_Handler         [WEAK]
            B       .
            ENDP

PendSV_Handler      PROC
            EXPORT  PendSV_Handler         [WEAK]
            B       .
            ENDP
SysTick_Handler      PROC
            EXPORT  SysTick_Handler        [WEAK]
            B       .
            ENDP

Default_Handler PROC



                EXPORT  WWDT_IRQHandler            [WEAK]
                EXPORT  LVD_IRQHandler             [WEAK]
                EXPORT  CM0IKMCU_IRQ2_IRQHandler   [WEAK]
                EXPORT  WAKEUP_IRQHandler          [WEAK]
                EXPORT  RCU_IRQHandler             [WEAK]
                EXPORT  EXTI_0to1_IRQHandler       [WEAK]
                EXPORT  EXTI_2to3_IRQHandler       [WEAK]
                EXPORT  EXTI_4to15_IRQHandler      [WEAK]
                EXPORT  DMA1_CH0_IRQHandler        [WEAK]
                EXPORT  DMA1_CH1_IRQHandler        [WEAK]
                EXPORT  DMA1_CH2_IRQHandler        [WEAK]
                EXPORT  DMA1_CH3_IRQHandler        [WEAK]
                EXPORT  DMA1_CH4_IRQHandler        [WEAK]
                EXPORT  DMA1_CH5_IRQHandler        [WEAK]
                EXPORT  ADC_IRQHandler             [WEAK]
                EXPORT  SVA_IRQHandler             [WEAK]
                EXPORT  CAN1_TX_IRQHandler         [WEAK]
                EXPORT  CAN1_RXFIFO0_IRQHandler    [WEAK]
                EXPORT  CAN1_RXFIFO1_IRQHandler    [WEAK]
                EXPORT  CAN1_IRQHandler            [WEAK]
                EXPORT  AD16C6T1_IRQHandler        [WEAK]
                EXPORT  GP16C2T1_IRQHandler        [WEAK]
                EXPORT  GP16C2T2_IRQHandler        [WEAK]
                EXPORT  GP32C4T1_IRQHandler        [WEAK]
                EXPORT  GP32C4T2_IRQHandler        [WEAK]
                EXPORT  I2C1_IRQHandler            [WEAK]
                EXPORT  SPI1_IRQHandler            [WEAK]
                EXPORT  UART1_IRQHandler           [WEAK]
                EXPORT  UART2_IRQHandler           [WEAK]
                EXPORT  AD16C6T2_IRQHandler        [WEAK]
                EXPORT  BS16T1_IRQHandler          [WEAK]
                EXPORT  CMP_IRQHandler             [WEAK]



WWDT_IRQHandler         
LVD_IRQHandler          
CM0IKMCU_IRQ2_IRQHandler
WAKEUP_IRQHandler       
RCU_IRQHandler          
EXTI_0to1_IRQHandler    
EXTI_2to3_IRQHandler    
EXTI_4to15_IRQHandler       
DMA1_CH0_IRQHandler     
DMA1_CH1_IRQHandler     
DMA1_CH2_IRQHandler     
DMA1_CH3_IRQHandler     
DMA1_CH4_IRQHandler     
DMA1_CH5_IRQHandler     
ADC_IRQHandler          
SVA_IRQHandler          
CAN1_TX_IRQHandler      
CAN1_RXFIFO0_IRQHandler 
CAN1_RXFIFO1_IRQHandler 
CAN1_IRQHandler         
AD16C6T1_IRQHandler     
GP16C2T1_IRQHandler     
GP16C2T2_IRQHandler     
GP32C4T1_IRQHandler     
GP32C4T2_IRQHandler     
I2C1_IRQHandler         
SPI1_IRQHandler         
UART1_IRQHandler        
UART2_IRQHandler        
AD16C6T2_IRQHandler     
BS16T1_IRQHandler       
CMP_IRQHandler          
       
                B       .

                ENDP

                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF

                END


