;*********************************************************************************
;
; @file    startup_es32m0502.s
; @brief   ES32M0502 Device Startup File
;
; @date    28 Mar 2023
; @author  AE Team
; @note
;          Change Logs:
;          Date            Author          Notes
;          28 Mar 2023     AE Team         the first version
;
; Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
;
; SPDX-License-Identifier: Apache-2.0
;
; Licensed under the Apache License, Version 2.0 (the License); you may
; not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an AS IS BASIS, WITHOUT
; WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
;
;*********************************************************************************

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)
        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table

        DATA
__vector_table
        DCD     sfe(CSTACK)				    ;0,  load top of stack
                DCD     Reset_Handler              ;1, Reset Handler
                DCD     NMI_Handler                ;2, NMI Handler
                DCD     HardFault_Handler          ;3, HardFault Handler
                DCD     0                          ;4, Reserved
                DCD     0                          ;5, Reserved
                DCD     0                          ;6, Reserved
                DCD     0                          ;7, Reserved
                DCD     0                          ;8, Reserved
                DCD     0                          ;9, Reserved
                DCD     0                          ;10, Reserved
                DCD     SVCall_Handler             ;11, SVCall_IRQn Handler
                DCD     0                          ;12, Reserved
                DCD     0                          ;13, Reserved
                DCD     PendSV_Handler             ;14, PendSV Handler
                DCD     SysTick_Handler            ;15, SysTick Handler
                DCD     WWDT_IRQHandler            ;16, WWDT IRQHandler
                DCD     LVD_IRQHandler             ;17, LVD IRQHandler
                DCD     CM0IKMCU_IRQ2_IRQHandler   ;18, Reserved
                DCD     WAKEUP_IRQHandler          ;19, WAKEUP IRQHandler
                DCD     RCU_IRQHandler             ;20, RCU IRQHandler
                DCD     EXTI_0to1_IRQHandler       ;21, EXTI_0to1 IRQHandler
                DCD     EXTI_2to3_IRQHandler       ;22, EXTI_2to3 IRQHandler
                DCD     EXTI_4to15_IRQHandler      ;23, EXTI_4to15 IRQHandler
                DCD     DMA1_CH0_IRQHandler        ;24, DMA1_CH0 IRQHandler   
                DCD     DMA1_CH1_IRQHandler        ;25, DMA1_CH1 IRQHandler   
                DCD     DMA1_CH2_IRQHandler        ;26, DMA1_CH2 IRQHandler
                DCD     DMA1_CH3_IRQHandler        ;27, DMA1_CH3 IRQHandler
                DCD     DMA1_CH4_IRQHandler        ;28, DMA1_CH4 IRQHandler
                DCD     DMA1_CH5_IRQHandler        ;29, DMA1_CH5 IRQHandler
                DCD     ADC_IRQHandler             ;30, ADC IRQHandler
                DCD     SVA_IRQHandler             ;31, SVA IRQHandler
                DCD     CAN1_TX_IRQHandler         ;32, CAN1_TX IRQHandler     
                DCD     CAN1_RXFIFO0_IRQHandler    ;33, CAN1_RXFIFO0 IRQHandler
                DCD     CAN1_RXFIFO1_IRQHandler    ;34, CAN1_RXFIFO1 IRQHandler
                DCD     CAN1_IRQHandler            ;35, CAN1 IRQHandler        
                DCD     AD16C6T1_IRQHandler        ;36, AD16C6T1 IRQHandler
                DCD     GP16C2T1_IRQHandler        ;37, GP16C2T1 IRQHandler
                DCD     GP16C2T2_IRQHandler        ;38, GP16C2T2 IRQHandler
                DCD     GP32C4T1_IRQHandler        ;39, GP32C4T1 IRQHandler
                DCD     GP32C4T2_IRQHandler        ;40, GP32C4T2 IRQHandler
                DCD     I2C1_IRQHandler            ;41, I2C1 IRQHandler
                DCD     SPI1_IRQHandler            ;42, SPI1 IRQHandler
                DCD     UART1_IRQHandler           ;43, UART1 IRQHandler
                DCD     UART2_IRQHandler           ;44, UART2 IRQHandler
                DCD     AD16C6T2_IRQHandler        ;45, AD16C6T2 IRQHandler
                DCD     BS16T1_IRQHandler          ;46, BS16T1 IRQHandler
                DCD     CMP_IRQHandler             ;47, CMP IRQHandler
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:NOROOT:REORDER(2)
Reset_Handler
        LDR     R0, =__iar_program_start
        BX      R0
        
        PUBWEAK NMI_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK SVCall_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
SVCall_Handler
        B SVCall_Handler
		
    	PUBWEAK PendSV_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
PendSV_Handler
    	B PendSV_Handler

   	PUBWEAK SysTick_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
SysTick_Handler
    	B SysTick_Handler

        PUBWEAK WWDT_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WWDT_IRQHandler
        B WWDT_IRQHandler

	PUBWEAK LVD_IRQHandler
	SECTION .text:CODE:NOROOT:REORDER(1)
LVD_IRQHandler
	B LVD_IRQHandler
		
	PUBWEAK CM0IKMCU_IRQ2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ2_IRQHandler
        B CM0IKMCU_IRQ2_IRQHandler

        PUBWEAK WAKEUP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WAKEUP_IRQHandler
        B WAKEUP_IRQHandler
        
        PUBWEAK RCU_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RCU_IRQHandler
        B RCU_IRQHandler

        PUBWEAK EXTI_0to1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_0to1_IRQHandler
        B EXTI_0to1_IRQHandler

        PUBWEAK EXTI_2to3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_2to3_IRQHandler
        B EXTI_2to3_IRQHandler

        PUBWEAK EXTI_4to15_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_4to15_IRQHandler
        B EXTI_4to15_IRQHandler
        
        PUBWEAK DMA1_CH0_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH0_IRQHandler
        B DMA1_CH0_IRQHandler

        PUBWEAK DMA1_CH1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH1_IRQHandler
        B DMA1_CH1_IRQHandler

 	PUBWEAK DMA1_CH2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH2_IRQHandler
        B DMA1_CH2_IRQHandler

        PUBWEAK DMA1_CH3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH3_IRQHandler
        B DMA1_CH3_IRQHandler

        PUBWEAK DMA1_CH4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH4_IRQHandler
        B DMA1_CH4_IRQHandler

        PUBWEAK DMA1_CH5_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_CH5_IRQHandler
        B DMA1_CH5_IRQHandler

        PUBWEAK ADC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
ADC_IRQHandler
        B ADC_IRQHandler

        PUBWEAK SVA_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SVA_IRQHandler
        B SVA_IRQHandler

        PUBWEAK CAN1_TX_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN1_TX_IRQHandler
        B CAN1_TX_IRQHandler

        PUBWEAK CAN1_RXFIFO0_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN1_RXFIFO0_IRQHandler
        B CAN1_RXFIFO0_IRQHandler

        PUBWEAK CAN1_RXFIFO1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN1_RXFIFO1_IRQHandler
        B CAN1_RXFIFO1_IRQHandler

        PUBWEAK CAN1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN1_IRQHandler
        B CAN1_IRQHandler

        PUBWEAK AD16C6T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
AD16C6T1_IRQHandler
        B AD16C6T1_IRQHandler

        PUBWEAK GP16C2T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T1_IRQHandler
        B GP16C2T1_IRQHandler

        PUBWEAK GP16C2T2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T2_IRQHandler
        B GP16C2T2_IRQHandler

        PUBWEAK GP32C4T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP32C4T1_IRQHandler
        B GP32C4T1_IRQHandler

	PUBWEAK GP32C4T2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP32C4T2_IRQHandler
        B GP32C4T2_IRQHandler

	PUBWEAK I2C1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2C1_IRQHandler
        B I2C1_IRQHandler

	PUBWEAK SPI1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI1_IRQHandler
        B SPI1_IRQHandler

	PUBWEAK UART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART1_IRQHandler
        B UART1_IRQHandler

	PUBWEAK UART2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART2_IRQHandler
        B UART2_IRQHandler

	PUBWEAK AD16C6T2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
AD16C6T2_IRQHandler
        B AD16C6T2_IRQHandler

	PUBWEAK BS16T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
BS16T1_IRQHandler
        B BS16T1_IRQHandler

	PUBWEAK CMP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CMP_IRQHandler
        B CMP_IRQHandler

        END
