/**********************************************************************************
 *
 * @file    reg_vres.h
 * @brief   VRES Head File
 *
 * @date    6 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Apr 2023      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __VRES_H__
#define __VRES_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for VRES_CTRL register ************************/

# define	VRES_CTRL_VRESEN_POS 0U 
# define	VRES_CTRL_VRESEN_MSK BIT(VRES_CTRL_VRESEN_POS) 
# define	VRES_CTRL_VRESEN VRES_CTRL_VRESEN_MSK 

/****************** Bit definition for VRES_VSEL register ************************/

# define	VRES_VSEL_VRES2SEL_POSS 16U 
# define	VRES_VSEL_VRES2SEL_POSE 20U 
# define	VRES_VSEL_VRES2SEL_MSK BITS(VRES_VSEL_VRES2SEL_POSS, VRES_VSEL_VRES2SEL_POSE) 
# define	VRES_VSEL_VRES2SEL VRES_VSEL_VRES2SEL_MSK 

# define	VRES_VSEL_VRES1SEL_POSS 0U 
# define	VRES_VSEL_VRES1SEL_POSE 4U 
# define	VRES_VSEL_VRES1SEL_MSK BITS(VRES_VSEL_VRES1SEL_POSS, VRES_VSEL_VRES1SEL_POSE) 
# define	VRES_VSEL_VRES1SEL VRES_VSEL_VRES1SEL_MSK 

typedef struct
{
    __IO uint32_t CTRL;                     // 0x000
    __IO uint32_t VSEL;                     // 0x004
} VRES_TypeDef;


#endif
