/**********************************************************************************
 *
 * @file    reg_timer.h
 * @brief   TIMER Head File
 *
 * @date    07 May 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 May 2024     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_TIMER_H__
#define __REG_TIMER_H__

/* Includes ------------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/****************** Bit definition for TIMER_CON1 register ************************/

#define TIMER_CON1_DITHEN_POS 12U
#define TIMER_CON1_DITHEN_MSK BIT(TIMER_CON1_DITHEN_POS)
#define TIMER_CON1_DITHEN     TIMER_CON1_DITHEN_MSK

#define TIMER_CON1_UPDREMAP_POS 11U
#define TIMER_CON1_UPDREMAP_MSK BIT(TIMER_CON1_UPDREMAP_POS)
#define TIMER_CON1_UPDREMAP     TIMER_CON1_UPDREMAP_MSK

#define TIMER_CON1_DFCKSEL_POSS 8U
#define TIMER_CON1_DFCKSEL_POSE 9U
#define TIMER_CON1_DFCKSEL_MSK  BITS(TIMER_CON1_DFCKSEL_POSS, TIMER_CON1_DFCKSEL_POSE)
#define TIMER_CON1_DFCKSEL      TIMER_CON1_DFCKSEL_MSK

#define TIMER_CON1_ARPEN_POS 7U
#define TIMER_CON1_ARPEN_MSK BIT(TIMER_CON1_ARPEN_POS)
#define TIMER_CON1_ARPEN     TIMER_CON1_ARPEN_MSK

#define TIMER_CON1_CMSEL_POSS 5U
#define TIMER_CON1_CMSEL_POSE 6U
#define TIMER_CON1_CMSEL_MSK  BITS(TIMER_CON1_CMSEL_POSS, TIMER_CON1_CMSEL_POSE)
#define TIMER_CON1_CMSEL      TIMER_CON1_CMSEL_MSK

#define TIMER_CON1_DIRSEL_POS 4U
#define TIMER_CON1_DIRSEL_MSK BIT(TIMER_CON1_DIRSEL_POS)
#define TIMER_CON1_DIRSEL     TIMER_CON1_DIRSEL_MSK

#define TIMER_CON1_SPMEN_POS 3U
#define TIMER_CON1_SPMEN_MSK BIT(TIMER_CON1_SPMEN_POS)
#define TIMER_CON1_SPMEN     TIMER_CON1_SPMEN_MSK

#define TIMER_CON1_UERSEL_POS 2U
#define TIMER_CON1_UERSEL_MSK BIT(TIMER_CON1_UERSEL_POS)
#define TIMER_CON1_UERSEL     TIMER_CON1_UERSEL_MSK

#define TIMER_CON1_DISUE_POS 1U
#define TIMER_CON1_DISUE_MSK BIT(TIMER_CON1_DISUE_POS)
#define TIMER_CON1_DISUE     TIMER_CON1_DISUE_MSK

#define TIMER_CON1_CNTEN_POS 0U
#define TIMER_CON1_CNTEN_MSK BIT(TIMER_CON1_CNTEN_POS)
#define TIMER_CON1_CNTEN     TIMER_CON1_CNTEN_MSK

/****************** Bit definition for TIMER_CON2 register ************************/

#define TIMER_CON2_MMSEL2_POS 25U
#define TIMER_CON2_MMSEL2_MSK BIT(TIMER_CON2_MMSEL2_POS)
#define TIMER_CON2_MMSEL2     TIMER_CON2_MMSEL2_MSK

#define TIMER_CON2_MMSELTGO2_POSS 20U
#define TIMER_CON2_MMSELTGO2_POSE 24U
#define TIMER_CON2_MMSELTGO2_MSK  BITS(TIMER_CON2_MMSELTGO2_POSS, TIMER_CON2_MMSELTGO2_POSE)
#define TIMER_CON2_MMSELTGO2      TIMER_CON2_MMSELTGO2_MSK

#define TIMER_CON2_OISS6_POS 18U
#define TIMER_CON2_OISS6_MSK BIT(TIMER_CON2_OISS6_POS)
#define TIMER_CON2_OISS6     TIMER_CON2_OISS6_MSK

#define TIMER_CON2_OISS5_POS 16U
#define TIMER_CON2_OISS5_MSK BIT(TIMER_CON2_OISS5_POS)
#define TIMER_CON2_OISS5     TIMER_CON2_OISS5_MSK

#define TIMER_CON2_OISS4N_POS 15U
#define TIMER_CON2_OISS4N_MSK BIT(TIMER_CON2_OISS4N_POS)
#define TIMER_CON2_OISS4N     TIMER_CON2_OISS4N_MSK

#define TIMER_CON2_OISS4_POS 14U
#define TIMER_CON2_OISS4_MSK BIT(TIMER_CON2_OISS4_POS)
#define TIMER_CON2_OISS4     TIMER_CON2_OISS4_MSK

#define TIMER_CON2_OISS3N_POS 13U
#define TIMER_CON2_OISS3N_MSK BIT(TIMER_CON2_OISS3N_POS)
#define TIMER_CON2_OISS3N     TIMER_CON2_OISS3N_MSK

#define TIMER_CON2_OISS3_POS 12U
#define TIMER_CON2_OISS3_MSK BIT(TIMER_CON2_OISS3_POS)
#define TIMER_CON2_OISS3     TIMER_CON2_OISS3_MSK

#define TIMER_CON2_OISS2N_POS 11U
#define TIMER_CON2_OISS2N_MSK BIT(TIMER_CON2_OISS2N_POS)
#define TIMER_CON2_OISS2N     TIMER_CON2_OISS2N_MSK

#define TIMER_CON2_OISS2_POS 10U
#define TIMER_CON2_OISS2_MSK BIT(TIMER_CON2_OISS2_POS)
#define TIMER_CON2_OISS2     TIMER_CON2_OISS2_MSK

#define TIMER_CON2_OISS1N_POS 9U
#define TIMER_CON2_OISS1N_MSK BIT(TIMER_CON2_OISS1N_POS)
#define TIMER_CON2_OISS1N     TIMER_CON2_OISS1N_MSK

#define TIMER_CON2_OISS1_POS 8U
#define TIMER_CON2_OISS1_MSK BIT(TIMER_CON2_OISS1_POS)
#define TIMER_CON2_OISS1     TIMER_CON2_OISS1_MSK

#define TIMER_CON2_I1SEL_POS 7U
#define TIMER_CON2_I1SEL_MSK BIT(TIMER_CON2_I1SEL_POS)
#define TIMER_CON2_I1SEL     TIMER_CON2_I1SEL_MSK

#define TIMER_CON2_MMSEL_POSS 4U
#define TIMER_CON2_MMSEL_POSE 6U
#define TIMER_CON2_MMSEL_MSK  BITS(TIMER_CON2_MMSEL_POSS, TIMER_CON2_MMSEL_POSE)
#define TIMER_CON2_MMSEL      TIMER_CON2_MMSEL_MSK

#define TIMER_CON2_CCDMASEL_POS 3U
#define TIMER_CON2_CCDMASEL_MSK BIT(TIMER_CON2_CCDMASEL_POS)
#define TIMER_CON2_CCDMASEL     TIMER_CON2_CCDMASEL_MSK

#define TIMER_CON2_CCUSEL_POS 2U
#define TIMER_CON2_CCUSEL_MSK BIT(TIMER_CON2_CCUSEL_POS)
#define TIMER_CON2_CCUSEL     TIMER_CON2_CCUSEL_MSK

#define TIMER_CON2_CCPCEN_POS 0U
#define TIMER_CON2_CCPCEN_MSK BIT(TIMER_CON2_CCPCEN_POS)
#define TIMER_CON2_CCPCEN     TIMER_CON2_CCPCEN_MSK

/****************** Bit definition for TIMER_SMCON register ************************/

#define TIMER_SMCON_SMODPS_POS 25U
#define TIMER_SMCON_SMODPS_MSK BIT(TIMER_SMCON_SMODPS_POS)
#define TIMER_SMCON_SMODPS     TIMER_SMCON_SMODPS_MSK

#define TIMER_SMCON_SMODPE_POS 24U
#define TIMER_SMCON_SMODPE_MSK BIT(TIMER_SMCON_SMODPE_POS)
#define TIMER_SMCON_SMODPE     TIMER_SMCON_SMODPE_MSK

#define TIMER_SMCON_TSSEL2_POSS 20U
#define TIMER_SMCON_TSSEL2_POSE 21U
#define TIMER_SMCON_TSSEL2_MSK  BITS(TIMER_SMCON_TSSEL2_POSS, TIMER_SMCON_TSSEL2_POSE)
#define TIMER_SMCON_TSSEL2      TIMER_SMCON_TSSEL2_MSK

#define TIMER_SMCON_SMODS2_POS 16U
#define TIMER_SMCON_SMODS2_MSK BIT(TIMER_SMCON_SMODS2_POS)
#define TIMER_SMCON_SMODS2     TIMER_SMCON_SMODS2_MSK

#define TIMER_SMCON_ETPOL_POS 15U
#define TIMER_SMCON_ETPOL_MSK BIT(TIMER_SMCON_ETPOL_POS)
#define TIMER_SMCON_ETPOL     TIMER_SMCON_ETPOL_MSK

#define TIMER_SMCON_ECM2EN_POS 14U
#define TIMER_SMCON_ECM2EN_MSK BIT(TIMER_SMCON_ECM2EN_POS)
#define TIMER_SMCON_ECM2EN     TIMER_SMCON_ECM2EN_MSK

#define TIMER_SMCON_ETPRES_POSS 12U
#define TIMER_SMCON_ETPRES_POSE 13U
#define TIMER_SMCON_ETPRES_MSK  BITS(TIMER_SMCON_ETPRES_POSS, TIMER_SMCON_ETPRES_POSE)
#define TIMER_SMCON_ETPRES      TIMER_SMCON_ETPRES_MSK

#define TIMER_SMCON_ETFLT_POSS 8U
#define TIMER_SMCON_ETFLT_POSE 11U
#define TIMER_SMCON_ETFLT_MSK  BITS(TIMER_SMCON_ETFLT_POSS, TIMER_SMCON_ETFLT_POSE)
#define TIMER_SMCON_ETFLT      TIMER_SMCON_ETFLT_MSK

#define TIMER_SMCON_MSCFG_POS 7U
#define TIMER_SMCON_MSCFG_MSK BIT(TIMER_SMCON_MSCFG_POS)
#define TIMER_SMCON_MSCFG     TIMER_SMCON_MSCFG_MSK

#define TIMER_SMCON_TSSEL1_POSS 4U
#define TIMER_SMCON_TSSEL1_POSE 6U
#define TIMER_SMCON_TSSEL1_MSK  BITS(TIMER_SMCON_TSSEL1_POSS, TIMER_SMCON_TSSEL1_POSE)
#define TIMER_SMCON_TSSEL1      TIMER_SMCON_TSSEL1_MSK

#define TIMER_SMCON_OCLRS_POS 3U
#define TIMER_SMCON_OCLRS_MSK BIT(TIMER_SMCON_OCLRS_POS)
#define TIMER_SMCON_OCLRS     TIMER_SMCON_OCLRS_MSK

#define TIMER_SMCON_SMODS_POSS 0U
#define TIMER_SMCON_SMODS_POSE 2U
#define TIMER_SMCON_SMODS_MSK  BITS(TIMER_SMCON_SMODS_POSS, TIMER_SMCON_SMODS_POSE)
#define TIMER_SMCON_SMODS      TIMER_SMCON_SMODS_MSK

/****************** Bit definition for TIMER_IER register ************************/

#define TIMER_IER_TERR_POS 23U
#define TIMER_IER_TERR_MSK BIT(TIMER_IER_TERR_POS)
#define TIMER_IER_TERR     TIMER_IER_TERR_MSK

#define TIMER_IER_IERR_POS 22U
#define TIMER_IER_IERR_MSK BIT(TIMER_IER_IERR_POS)
#define TIMER_IER_IERR     TIMER_IER_IERR_MSK

#define TIMER_IER_DIR_POS 21U
#define TIMER_IER_DIR_MSK BIT(TIMER_IER_DIR_POS)
#define TIMER_IER_DIR     TIMER_IER_DIR_MSK

#define TIMER_IER_IDX_POS 20U
#define TIMER_IER_IDX_MSK BIT(TIMER_IER_IDX_POS)
#define TIMER_IER_IDX     TIMER_IER_IDX_MSK

#define TIMER_IER_CH6_POS 17U
#define TIMER_IER_CH6_MSK BIT(TIMER_IER_CH6_POS)
#define TIMER_IER_CH6     TIMER_IER_CH6_MSK

#define TIMER_IER_CH5_POS 16U
#define TIMER_IER_CH5_MSK BIT(TIMER_IER_CH5_POS)
#define TIMER_IER_CH5     TIMER_IER_CH5_MSK

#define TIMER_IER_SBRK_POS 13U
#define TIMER_IER_SBRK_MSK BIT(TIMER_IER_SBRK_POS)
#define TIMER_IER_SBRK     TIMER_IER_SBRK_MSK

#define TIMER_IER_CH4OV_POS 12U
#define TIMER_IER_CH4OV_MSK BIT(TIMER_IER_CH4OV_POS)
#define TIMER_IER_CH4OV     TIMER_IER_CH4OV_MSK

#define TIMER_IER_CH3OV_POS 11U
#define TIMER_IER_CH3OV_MSK BIT(TIMER_IER_CH3OV_POS)
#define TIMER_IER_CH3OV     TIMER_IER_CH3OV_MSK

#define TIMER_IER_CH2OV_POS 10U
#define TIMER_IER_CH2OV_MSK BIT(TIMER_IER_CH2OV_POS)
#define TIMER_IER_CH2OV     TIMER_IER_CH2OV_MSK

#define TIMER_IER_CH1OV_POS 9U
#define TIMER_IER_CH1OV_MSK BIT(TIMER_IER_CH1OV_POS)
#define TIMER_IER_CH1OV     TIMER_IER_CH1OV_MSK

#define TIMER_IER_BRK2_POS 8U
#define TIMER_IER_BRK2_MSK BIT(TIMER_IER_BRK2_POS)
#define TIMER_IER_BRK2     TIMER_IER_BRK2_MSK

#define TIMER_IER_BRK_POS 7U
#define TIMER_IER_BRK_MSK BIT(TIMER_IER_BRK_POS)
#define TIMER_IER_BRK     TIMER_IER_BRK_MSK

#define TIMER_IER_TRGI_POS 6U
#define TIMER_IER_TRGI_MSK BIT(TIMER_IER_TRGI_POS)
#define TIMER_IER_TRGI     TIMER_IER_TRGI_MSK

#define TIMER_IER_COM_POS 5U
#define TIMER_IER_COM_MSK BIT(TIMER_IER_COM_POS)
#define TIMER_IER_COM     TIMER_IER_COM_MSK

#define TIMER_IER_CH4_POS 4U
#define TIMER_IER_CH4_MSK BIT(TIMER_IER_CH4_POS)
#define TIMER_IER_CH4     TIMER_IER_CH4_MSK

#define TIMER_IER_CH3_POS 3U
#define TIMER_IER_CH3_MSK BIT(TIMER_IER_CH3_POS)
#define TIMER_IER_CH3     TIMER_IER_CH3_MSK

#define TIMER_IER_CH2_POS 2U
#define TIMER_IER_CH2_MSK BIT(TIMER_IER_CH2_POS)
#define TIMER_IER_CH2     TIMER_IER_CH2_MSK

#define TIMER_IER_CH1_POS 1U
#define TIMER_IER_CH1_MSK BIT(TIMER_IER_CH1_POS)
#define TIMER_IER_CH1     TIMER_IER_CH1_MSK

#define TIMER_IER_UPD_POS 0U
#define TIMER_IER_UPD_MSK BIT(TIMER_IER_UPD_POS)
#define TIMER_IER_UPD     TIMER_IER_UPD_MSK

/****************** Bit definition for TIMER_IDR register ************************/

#define TIMER_IDR_TERR_POS 23U
#define TIMER_IDR_TERR_MSK BIT(TIMER_IDR_TERR_POS)
#define TIMER_IDR_TERR     TIMER_IDR_TERR_MSK

#define TIMER_IDR_IERR_POS 22U
#define TIMER_IDR_IERR_MSK BIT(TIMER_IDR_IERR_POS)
#define TIMER_IDR_IERR     TIMER_IDR_IERR_MSK

#define TIMER_IDR_DIR_POS 21U
#define TIMER_IDR_DIR_MSK BIT(TIMER_IDR_DIR_POS)
#define TIMER_IDR_DIR     TIMER_IDR_DIR_MSK

#define TIMER_IDR_IDX_POS 20U
#define TIMER_IDR_IDX_MSK BIT(TIMER_IDR_IDX_POS)
#define TIMER_IDR_IDX     TIMER_IDR_IDX_MSK

#define TIMER_IDR_CH6_POS 17U
#define TIMER_IDR_CH6_MSK BIT(TIMER_IDR_CH6_POS)
#define TIMER_IDR_CH6     TIMER_IDR_CH6_MSK

#define TIMER_IDR_CH5_POS 16U
#define TIMER_IDR_CH5_MSK BIT(TIMER_IDR_CH5_POS)
#define TIMER_IDR_CH5     TIMER_IDR_CH5_MSK

#define TIMER_IDR_SBRK_POS 13U
#define TIMER_IDR_SBRK_MSK BIT(TIMER_IDR_SBRK_POS)
#define TIMER_IDR_SBRK     TIMER_IDR_SBRK_MSK

#define TIMER_IDR_CH4OV_POS 12U
#define TIMER_IDR_CH4OV_MSK BIT(TIMER_IDR_CH4OV_POS)
#define TIMER_IDR_CH4OV     TIMER_IDR_CH4OV_MSK

#define TIMER_IDR_CH3OV_POS 11U
#define TIMER_IDR_CH3OV_MSK BIT(TIMER_IDR_CH3OV_POS)
#define TIMER_IDR_CH3OV     TIMER_IDR_CH3OV_MSK

#define TIMER_IDR_CH2OV_POS 10U
#define TIMER_IDR_CH2OV_MSK BIT(TIMER_IDR_CH2OV_POS)
#define TIMER_IDR_CH2OV     TIMER_IDR_CH2OV_MSK

#define TIMER_IDR_CH1OV_POS 9U
#define TIMER_IDR_CH1OV_MSK BIT(TIMER_IDR_CH1OV_POS)
#define TIMER_IDR_CH1OV     TIMER_IDR_CH1OV_MSK

#define TIMER_IDR_BRK2_POS 8U
#define TIMER_IDR_BRK2_MSK BIT(TIMER_IDR_BRK2_POS)
#define TIMER_IDR_BRK2     TIMER_IDR_BRK2_MSK

#define TIMER_IDR_BRK_POS 7U
#define TIMER_IDR_BRK_MSK BIT(TIMER_IDR_BRK_POS)
#define TIMER_IDR_BRK     TIMER_IDR_BRK_MSK

#define TIMER_IDR_TRGI_POS 6U
#define TIMER_IDR_TRGI_MSK BIT(TIMER_IDR_TRGI_POS)
#define TIMER_IDR_TRGI     TIMER_IDR_TRGI_MSK

#define TIMER_IDR_COM_POS 5U
#define TIMER_IDR_COM_MSK BIT(TIMER_IDR_COM_POS)
#define TIMER_IDR_COM     TIMER_IDR_COM_MSK

#define TIMER_IDR_CH4_POS 4U
#define TIMER_IDR_CH4_MSK BIT(TIMER_IDR_CH4_POS)
#define TIMER_IDR_CH4     TIMER_IDR_CH4_MSK

#define TIMER_IDR_CH3_POS 3U
#define TIMER_IDR_CH3_MSK BIT(TIMER_IDR_CH3_POS)
#define TIMER_IDR_CH3     TIMER_IDR_CH3_MSK

#define TIMER_IDR_CH2_POS 2U
#define TIMER_IDR_CH2_MSK BIT(TIMER_IDR_CH2_POS)
#define TIMER_IDR_CH2     TIMER_IDR_CH2_MSK

#define TIMER_IDR_CH1_POS 1U
#define TIMER_IDR_CH1_MSK BIT(TIMER_IDR_CH1_POS)
#define TIMER_IDR_CH1     TIMER_IDR_CH1_MSK

#define TIMER_IDR_UPD_POS 0U
#define TIMER_IDR_UPD_MSK BIT(TIMER_IDR_UPD_POS)
#define TIMER_IDR_UPD     TIMER_IDR_UPD_MSK

/****************** Bit definition for TIMER_IVS register ************************/

#define TIMER_IVS_TERR_POS 23U
#define TIMER_IVS_TERR_MSK BIT(TIMER_IVS_TERR_POS)
#define TIMER_IVS_TERR     TIMER_IVS_TERR_MSK

#define TIMER_IVS_IERR_POS 22U
#define TIMER_IVS_IERR_MSK BIT(TIMER_IVS_IERR_POS)
#define TIMER_IVS_IERR     TIMER_IVS_IERR_MSK

#define TIMER_IVS_DIR_POS 21U
#define TIMER_IVS_DIR_MSK BIT(TIMER_IVS_DIR_POS)
#define TIMER_IVS_DIR     TIMER_IVS_DIR_MSK

#define TIMER_IVS_IDX_POS 20U
#define TIMER_IVS_IDX_MSK BIT(TIMER_IVS_IDX_POS)
#define TIMER_IVS_IDX     TIMER_IVS_IDX_MSK

#define TIMER_IVS_CH6_POS 17U
#define TIMER_IVS_CH6_MSK BIT(TIMER_IVS_CH6_POS)
#define TIMER_IVS_CH6     TIMER_IVS_CH6_MSK

#define TIMER_IVS_CH5_POS 16U
#define TIMER_IVS_CH5_MSK BIT(TIMER_IVS_CH5_POS)
#define TIMER_IVS_CH5     TIMER_IVS_CH5_MSK

#define TIMER_IVS_SBRK_POS 13U
#define TIMER_IVS_SBRK_MSK BIT(TIMER_IVS_SBRK_POS)
#define TIMER_IVS_SBRK     TIMER_IVS_SBRK_MSK

#define TIMER_IVS_CH4OV_POS 12U
#define TIMER_IVS_CH4OV_MSK BIT(TIMER_IVS_CH4OV_POS)
#define TIMER_IVS_CH4OV     TIMER_IVS_CH4OV_MSK

#define TIMER_IVS_CH3OV_POS 11U
#define TIMER_IVS_CH3OV_MSK BIT(TIMER_IVS_CH3OV_POS)
#define TIMER_IVS_CH3OV     TIMER_IVS_CH3OV_MSK

#define TIMER_IVS_CH2OV_POS 10U
#define TIMER_IVS_CH2OV_MSK BIT(TIMER_IVS_CH2OV_POS)
#define TIMER_IVS_CH2OV     TIMER_IVS_CH2OV_MSK

#define TIMER_IVS_CH1OV_POS 9U
#define TIMER_IVS_CH1OV_MSK BIT(TIMER_IVS_CH1OV_POS)
#define TIMER_IVS_CH1OV     TIMER_IVS_CH1OV_MSK

#define TIMER_IVS_BRK2_POS 8U
#define TIMER_IVS_BRK2_MSK BIT(TIMER_IVS_BRK2_POS)
#define TIMER_IVS_BRK2     TIMER_IVS_BRK2_MSK

#define TIMER_IVS_BRK_POS 7U
#define TIMER_IVS_BRK_MSK BIT(TIMER_IVS_BRK_POS)
#define TIMER_IVS_BRK     TIMER_IVS_BRK_MSK

#define TIMER_IVS_TRGI_POS 6U
#define TIMER_IVS_TRGI_MSK BIT(TIMER_IVS_TRGI_POS)
#define TIMER_IVS_TRGI     TIMER_IVS_TRGI_MSK

#define TIMER_IVS_COM_POS 5U
#define TIMER_IVS_COM_MSK BIT(TIMER_IVS_COM_POS)
#define TIMER_IVS_COM     TIMER_IVS_COM_MSK

#define TIMER_IVS_CH4_POS 4U
#define TIMER_IVS_CH4_MSK BIT(TIMER_IVS_CH4_POS)
#define TIMER_IVS_CH4     TIMER_IVS_CH4_MSK

#define TIMER_IVS_CH3_POS 3U
#define TIMER_IVS_CH3_MSK BIT(TIMER_IVS_CH3_POS)
#define TIMER_IVS_CH3     TIMER_IVS_CH3_MSK

#define TIMER_IVS_CH2_POS 2U
#define TIMER_IVS_CH2_MSK BIT(TIMER_IVS_CH2_POS)
#define TIMER_IVS_CH2     TIMER_IVS_CH2_MSK

#define TIMER_IVS_CH1_POS 1U
#define TIMER_IVS_CH1_MSK BIT(TIMER_IVS_CH1_POS)
#define TIMER_IVS_CH1     TIMER_IVS_CH1_MSK

#define TIMER_IVS_UPD_POS 0U
#define TIMER_IVS_UPD_MSK BIT(TIMER_IVS_UPD_POS)
#define TIMER_IVS_UPD     TIMER_IVS_UPD_MSK

/****************** Bit definition for TIMER_RIF register ************************/

#define TIMER_RIF_TERR_POS 23U
#define TIMER_RIF_TERR_MSK BIT(TIMER_RIF_TERR_POS)
#define TIMER_RIF_TERR     TIMER_RIF_TERR_MSK

#define TIMER_RIF_IERR_POS 22U
#define TIMER_RIF_IERR_MSK BIT(TIMER_RIF_IERR_POS)
#define TIMER_RIF_IERR     TIMER_RIF_IERR_MSK

#define TIMER_RIF_DIR_POS 21U
#define TIMER_RIF_DIR_MSK BIT(TIMER_RIF_DIR_POS)
#define TIMER_RIF_DIR     TIMER_RIF_DIR_MSK

#define TIMER_RIF_IDX_POS 20U
#define TIMER_RIF_IDX_MSK BIT(TIMER_RIF_IDX_POS)
#define TIMER_RIF_IDX     TIMER_RIF_IDX_MSK

#define TIMER_RIF_CH6_POS 17U
#define TIMER_RIF_CH6_MSK BIT(TIMER_RIF_CH6_POS)
#define TIMER_RIF_CH6     TIMER_RIF_CH6_MSK

#define TIMER_RIF_CH5_POS 16U
#define TIMER_RIF_CH5_MSK BIT(TIMER_RIF_CH5_POS)
#define TIMER_RIF_CH5     TIMER_RIF_CH5_MSK

#define TIMER_RIF_SBRK_POS 13U
#define TIMER_RIF_SBRK_MSK BIT(TIMER_RIF_SBRK_POS)
#define TIMER_RIF_SBRK     TIMER_RIF_SBRK_MSK

#define TIMER_RIF_CH4OV_POS 12U
#define TIMER_RIF_CH4OV_MSK BIT(TIMER_RIF_CH4OV_POS)
#define TIMER_RIF_CH4OV     TIMER_RIF_CH4OV_MSK

#define TIMER_RIF_CH3OV_POS 11U
#define TIMER_RIF_CH3OV_MSK BIT(TIMER_RIF_CH3OV_POS)
#define TIMER_RIF_CH3OV     TIMER_RIF_CH3OV_MSK

#define TIMER_RIF_CH2OV_POS 10U
#define TIMER_RIF_CH2OV_MSK BIT(TIMER_RIF_CH2OV_POS)
#define TIMER_RIF_CH2OV     TIMER_RIF_CH2OV_MSK

#define TIMER_RIF_CH1OV_POS 9U
#define TIMER_RIF_CH1OV_MSK BIT(TIMER_RIF_CH1OV_POS)
#define TIMER_RIF_CH1OV     TIMER_RIF_CH1OV_MSK

#define TIMER_RIF_BRK2_POS 8U
#define TIMER_RIF_BRK2_MSK BIT(TIMER_RIF_BRK2_POS)
#define TIMER_RIF_BRK2     TIMER_RIF_BRK2_MSK

#define TIMER_RIF_BRK_POS 7U
#define TIMER_RIF_BRK_MSK BIT(TIMER_RIF_BRK_POS)
#define TIMER_RIF_BRK     TIMER_RIF_BRK_MSK

#define TIMER_RIF_TRGI_POS 6U
#define TIMER_RIF_TRGI_MSK BIT(TIMER_RIF_TRGI_POS)
#define TIMER_RIF_TRGI     TIMER_RIF_TRGI_MSK

#define TIMER_RIF_COM_POS 5U
#define TIMER_RIF_COM_MSK BIT(TIMER_RIF_COM_POS)
#define TIMER_RIF_COM     TIMER_RIF_COM_MSK

#define TIMER_RIF_CH4_POS 4U
#define TIMER_RIF_CH4_MSK BIT(TIMER_RIF_CH4_POS)
#define TIMER_RIF_CH4     TIMER_RIF_CH4_MSK

#define TIMER_RIF_CH3_POS 3U
#define TIMER_RIF_CH3_MSK BIT(TIMER_RIF_CH3_POS)
#define TIMER_RIF_CH3     TIMER_RIF_CH3_MSK

#define TIMER_RIF_CH2_POS 2U
#define TIMER_RIF_CH2_MSK BIT(TIMER_RIF_CH2_POS)
#define TIMER_RIF_CH2     TIMER_RIF_CH2_MSK

#define TIMER_RIF_CH1_POS 1U
#define TIMER_RIF_CH1_MSK BIT(TIMER_RIF_CH1_POS)
#define TIMER_RIF_CH1     TIMER_RIF_CH1_MSK

#define TIMER_RIF_UPD_POS 0U
#define TIMER_RIF_UPD_MSK BIT(TIMER_RIF_UPD_POS)
#define TIMER_RIF_UPD     TIMER_RIF_UPD_MSK

/****************** Bit definition for TIMER_IFM register ************************/

#define TIMER_IFM_TERR_POS 23U
#define TIMER_IFM_TERR_MSK BIT(TIMER_IFM_TERR_POS)
#define TIMER_IFM_TERR     TIMER_IFM_TERR_MSK

#define TIMER_IFM_IERR_POS 22U
#define TIMER_IFM_IERR_MSK BIT(TIMER_IFM_IERR_POS)
#define TIMER_IFM_IERR     TIMER_IFM_IERR_MSK

#define TIMER_IFM_DIR_POS 21U
#define TIMER_IFM_DIR_MSK BIT(TIMER_IFM_DIR_POS)
#define TIMER_IFM_DIR     TIMER_IFM_DIR_MSK

#define TIMER_IFM_IDX_POS 20U
#define TIMER_IFM_IDX_MSK BIT(TIMER_IFM_IDX_POS)
#define TIMER_IFM_IDX     TIMER_IFM_IDX_MSK

#define TIMER_IFM_CH6_POS 17U
#define TIMER_IFM_CH6_MSK BIT(TIMER_IFM_CH6_POS)
#define TIMER_IFM_CH6     TIMER_IFM_CH6_MSK

#define TIMER_IFM_CH5_POS 16U
#define TIMER_IFM_CH5_MSK BIT(TIMER_IFM_CH5_POS)
#define TIMER_IFM_CH5     TIMER_IFM_CH5_MSK

#define TIMER_IFM_SBRK_POS 13U
#define TIMER_IFM_SBRK_MSK BIT(TIMER_IFM_SBRK_POS)
#define TIMER_IFM_SBRK     TIMER_IFM_SBRK_MSK

#define TIMER_IFM_CH4OV_POS 12U
#define TIMER_IFM_CH4OV_MSK BIT(TIMER_IFM_CH4OV_POS)
#define TIMER_IFM_CH4OV     TIMER_IFM_CH4OV_MSK

#define TIMER_IFM_CH3OV_POS 11U
#define TIMER_IFM_CH3OV_MSK BIT(TIMER_IFM_CH3OV_POS)
#define TIMER_IFM_CH3OV     TIMER_IFM_CH3OV_MSK

#define TIMER_IFM_CH2OV_POS 10U
#define TIMER_IFM_CH2OV_MSK BIT(TIMER_IFM_CH2OV_POS)
#define TIMER_IFM_CH2OV     TIMER_IFM_CH2OV_MSK

#define TIMER_IFM_CH1OV_POS 9U
#define TIMER_IFM_CH1OV_MSK BIT(TIMER_IFM_CH1OV_POS)
#define TIMER_IFM_CH1OV     TIMER_IFM_CH1OV_MSK

#define TIMER_IFM_BRK2_POS 8U
#define TIMER_IFM_BRK2_MSK BIT(TIMER_IFM_BRK2_POS)
#define TIMER_IFM_BRK2     TIMER_IFM_BRK2_MSK

#define TIMER_IFM_BRK_POS 7U
#define TIMER_IFM_BRK_MSK BIT(TIMER_IFM_BRK_POS)
#define TIMER_IFM_BRK     TIMER_IFM_BRK_MSK

#define TIMER_IFM_TRGI_POS 6U
#define TIMER_IFM_TRGI_MSK BIT(TIMER_IFM_TRGI_POS)
#define TIMER_IFM_TRGI     TIMER_IFM_TRGI_MSK

#define TIMER_IFM_COM_POS 5U
#define TIMER_IFM_COM_MSK BIT(TIMER_IFM_COM_POS)
#define TIMER_IFM_COM     TIMER_IFM_COM_MSK

#define TIMER_IFM_CH4_POS 4U
#define TIMER_IFM_CH4_MSK BIT(TIMER_IFM_CH4_POS)
#define TIMER_IFM_CH4     TIMER_IFM_CH4_MSK

#define TIMER_IFM_CH3_POS 3U
#define TIMER_IFM_CH3_MSK BIT(TIMER_IFM_CH3_POS)
#define TIMER_IFM_CH3     TIMER_IFM_CH3_MSK

#define TIMER_IFM_CH2_POS 2U
#define TIMER_IFM_CH2_MSK BIT(TIMER_IFM_CH2_POS)
#define TIMER_IFM_CH2     TIMER_IFM_CH2_MSK

#define TIMER_IFM_CH1_POS 1U
#define TIMER_IFM_CH1_MSK BIT(TIMER_IFM_CH1_POS)
#define TIMER_IFM_CH1     TIMER_IFM_CH1_MSK

#define TIMER_IFM_UPD_POS 0U
#define TIMER_IFM_UPD_MSK BIT(TIMER_IFM_UPD_POS)
#define TIMER_IFM_UPD     TIMER_IFM_UPD_MSK
/****************** Bit definition for TIMER_ICR register ************************/

#define TIMER_ICR_TERR_POS 23U
#define TIMER_ICR_TERR_MSK BIT(TIMER_ICR_TERR_POS)
#define TIMER_ICR_TERR     TIMER_ICR_TERR_MSK

#define TIMER_ICR_IERR_POS 22U
#define TIMER_ICR_IERR_MSK BIT(TIMER_ICR_IERR_POS)
#define TIMER_ICR_IERR     TIMER_ICR_IERR_MSK

#define TIMER_ICR_DIR_POS 21U
#define TIMER_ICR_DIR_MSK BIT(TIMER_ICR_DIR_POS)
#define TIMER_ICR_DIR     TIMER_ICR_DIR_MSK

#define TIMER_ICR_IDX_POS 20U
#define TIMER_ICR_IDX_MSK BIT(TIMER_ICR_IDX_POS)
#define TIMER_ICR_IDX     TIMER_ICR_IDX_MSK

#define TIMER_ICR_CH6_POS 17U
#define TIMER_ICR_CH6_MSK BIT(TIMER_ICR_CH6_POS)
#define TIMER_ICR_CH6     TIMER_ICR_CH6_MSK

#define TIMER_ICR_CH5_POS 16U
#define TIMER_ICR_CH5_MSK BIT(TIMER_ICR_CH5_POS)
#define TIMER_ICR_CH5     TIMER_ICR_CH5_MSK

#define TIMER_ICR_SBRK_POS 13U
#define TIMER_ICR_SBRK_MSK BIT(TIMER_ICR_SBRK_POS)
#define TIMER_ICR_SBRK     TIMER_ICR_SBRK_MSK

#define TIMER_ICR_CH4OV_POS 12U
#define TIMER_ICR_CH4OV_MSK BIT(TIMER_ICR_CH4OV_POS)
#define TIMER_ICR_CH4OV     TIMER_ICR_CH4OV_MSK

#define TIMER_ICR_CH3OV_POS 11U
#define TIMER_ICR_CH3OV_MSK BIT(TIMER_ICR_CH3OV_POS)
#define TIMER_ICR_CH3OV     TIMER_ICR_CH3OV_MSK

#define TIMER_ICR_CH2OV_POS 10U
#define TIMER_ICR_CH2OV_MSK BIT(TIMER_ICR_CH2OV_POS)
#define TIMER_ICR_CH2OV     TIMER_ICR_CH2OV_MSK

#define TIMER_ICR_CH1OV_POS 9U
#define TIMER_ICR_CH1OV_MSK BIT(TIMER_ICR_CH1OV_POS)
#define TIMER_ICR_CH1OV     TIMER_ICR_CH1OV_MSK

#define TIMER_ICR_BRK2_POS 8U
#define TIMER_ICR_BRK2_MSK BIT(TIMER_ICR_BRK2_POS)
#define TIMER_ICR_BRK2     TIMER_ICR_BRK2_MSK

#define TIMER_ICR_BRK_POS 7U
#define TIMER_ICR_BRK_MSK BIT(TIMER_ICR_BRK_POS)
#define TIMER_ICR_BRK     TIMER_ICR_BRK_MSK

#define TIMER_ICR_TRGI_POS 6U
#define TIMER_ICR_TRGI_MSK BIT(TIMER_ICR_TRGI_POS)
#define TIMER_ICR_TRGI     TIMER_ICR_TRGI_MSK

#define TIMER_ICR_COM_POS 5U
#define TIMER_ICR_COM_MSK BIT(TIMER_ICR_COM_POS)
#define TIMER_ICR_COM     TIMER_ICR_COM_MSK

#define TIMER_ICR_CH4_POS 4U
#define TIMER_ICR_CH4_MSK BIT(TIMER_ICR_CH4_POS)
#define TIMER_ICR_CH4     TIMER_ICR_CH4_MSK

#define TIMER_ICR_CH3_POS 3U
#define TIMER_ICR_CH3_MSK BIT(TIMER_ICR_CH3_POS)
#define TIMER_ICR_CH3     TIMER_ICR_CH3_MSK

#define TIMER_ICR_CH2_POS 2U
#define TIMER_ICR_CH2_MSK BIT(TIMER_ICR_CH2_POS)
#define TIMER_ICR_CH2     TIMER_ICR_CH2_MSK

#define TIMER_ICR_CH1_POS 1U
#define TIMER_ICR_CH1_MSK BIT(TIMER_ICR_CH1_POS)
#define TIMER_ICR_CH1     TIMER_ICR_CH1_MSK

#define TIMER_ICR_UPD_POS 0U
#define TIMER_ICR_UPD_MSK BIT(TIMER_ICR_UPD_POS)
#define TIMER_ICR_UPD     TIMER_ICR_UPD_MSK

/****************** Bit definition for TIMER_SGE register ************************/

#define TIMER_SGE_SGBRK2_POS 8U
#define TIMER_SGE_SGBRK2_MSK BIT(TIMER_SGE_SGBRK2_POS)
#define TIMER_SGE_SGBRK2     TIMER_SGE_SGBRK2_MSK

#define TIMER_SGE_SGBRK_POS 7U
#define TIMER_SGE_SGBRK_MSK BIT(TIMER_SGE_SGBRK_POS)
#define TIMER_SGE_SGBRK     TIMER_SGE_SGBRK_MSK

#define TIMER_SGE_SGTRGI_POS 6U
#define TIMER_SGE_SGTRGI_MSK BIT(TIMER_SGE_SGTRGI_POS)
#define TIMER_SGE_SGTRGI     TIMER_SGE_SGTRGI_MSK

#define TIMER_SGE_SGCOM_POS 5U
#define TIMER_SGE_SGCOM_MSK BIT(TIMER_SGE_SGCOM_POS)
#define TIMER_SGE_SGCOM     TIMER_SGE_SGCOM_MSK

#define TIMER_SGE_SGCH4_POS 4U
#define TIMER_SGE_SGCH4_MSK BIT(TIMER_SGE_SGCH4_POS)
#define TIMER_SGE_SGCH4     TIMER_SGE_SGCH4_MSK

#define TIMER_SGE_SGCH3_POS 3U
#define TIMER_SGE_SGCH3_MSK BIT(TIMER_SGE_SGCH3_POS)
#define TIMER_SGE_SGCH3     TIMER_SGE_SGCH3_MSK

#define TIMER_SGE_SGCH2_POS 2U
#define TIMER_SGE_SGCH2_MSK BIT(TIMER_SGE_SGCH2_POS)
#define TIMER_SGE_SGCH2     TIMER_SGE_SGCH2_MSK

#define TIMER_SGE_SGCH1_POS 1U
#define TIMER_SGE_SGCH1_MSK BIT(TIMER_SGE_SGCH1_POS)
#define TIMER_SGE_SGCH1     TIMER_SGE_SGCH1_MSK

#define TIMER_SGE_SGUPD_POS 0U
#define TIMER_SGE_SGUPD_MSK BIT(TIMER_SGE_SGUPD_POS)
#define TIMER_SGE_SGUPD     TIMER_SGE_SGUPD_MSK

/****************** Bit definition for TIMER_CHMR1_OUTPUT register ************************/

#define TIMER_CHMR1_OUTPUT_CH2MOD2_POSS 24U
#define TIMER_CHMR1_OUTPUT_CH2MOD2_POSE 25U
#define TIMER_CHMR1_OUTPUT_CH2MOD2_MSK  BITS(TIMER_CHMR1_OUTPUT_CH2MOD2_POSS, TIMER_CHMR1_OUTPUT_CH2MOD2_POSE)
#define TIMER_CHMR1_OUTPUT_CH2MOD2      TIMER_CHMR1_OUTPUT_CH2MOD2_MSK

#define TIMER_CHMR1_OUTPUT_CH1MOD2_POSS 16U
#define TIMER_CHMR1_OUTPUT_CH1MOD2_POSE 17U
#define TIMER_CHMR1_OUTPUT_CH1MOD2_MSK  BITS(TIMER_CHMR1_OUTPUT_CH1MOD2_POSS, TIMER_CHMR1_OUTPUT_CH1MOD2_POSE)
#define TIMER_CHMR1_OUTPUT_CH1MOD2      TIMER_CHMR1_OUTPUT_CH1MOD2_MSK

#define TIMER_CHMR1_OUTPUT_CH2OCLREN_POS 15U
#define TIMER_CHMR1_OUTPUT_CH2OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2OCLREN_POS)
#define TIMER_CHMR1_OUTPUT_CH2OCLREN     TIMER_CHMR1_OUTPUT_CH2OCLREN_MSK

#define TIMER_CHMR1_OUTPUT_CH2MOD_POSS 12U
#define TIMER_CHMR1_OUTPUT_CH2MOD_POSE 14U
#define TIMER_CHMR1_OUTPUT_CH2MOD_MSK  BITS(TIMER_CHMR1_OUTPUT_CH2MOD_POSS, TIMER_CHMR1_OUTPUT_CH2MOD_POSE)
#define TIMER_CHMR1_OUTPUT_CH2MOD      TIMER_CHMR1_OUTPUT_CH2MOD_MSK

#define TIMER_CHMR1_OUTPUT_CH2PEN_POS 11U
#define TIMER_CHMR1_OUTPUT_CH2PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2PEN_POS)
#define TIMER_CHMR1_OUTPUT_CH2PEN     TIMER_CHMR1_OUTPUT_CH2PEN_MSK

#define TIMER_CHMR1_OUTPUT_CH2FEN_POS 10U
#define TIMER_CHMR1_OUTPUT_CH2FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2FEN_POS)
#define TIMER_CHMR1_OUTPUT_CH2FEN     TIMER_CHMR1_OUTPUT_CH2FEN_MSK

#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_MSK  BITS(TIMER_CHMR1_OUTPUT_CC2SSEL_POSS, TIMER_CHMR1_OUTPUT_CC2SSEL_POSE)
#define TIMER_CHMR1_OUTPUT_CC2SSEL      TIMER_CHMR1_OUTPUT_CC2SSEL_MSK

#define TIMER_CHMR1_OUTPUT_CH1OCLREN_POS 7U
#define TIMER_CHMR1_OUTPUT_CH1OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1OCLREN_POS)
#define TIMER_CHMR1_OUTPUT_CH1OCLREN     TIMER_CHMR1_OUTPUT_CH1OCLREN_MSK

#define TIMER_CHMR1_OUTPUT_CH1MOD_POSS 4U
#define TIMER_CHMR1_OUTPUT_CH1MOD_POSE 6U
#define TIMER_CHMR1_OUTPUT_CH1MOD_MSK  BITS(TIMER_CHMR1_OUTPUT_CH1MOD_POSS, TIMER_CHMR1_OUTPUT_CH1MOD_POSE)
#define TIMER_CHMR1_OUTPUT_CH1MOD      TIMER_CHMR1_OUTPUT_CH1MOD_MSK

#define TIMER_CHMR1_OUTPUT_CH1PEN_POS 3U
#define TIMER_CHMR1_OUTPUT_CH1PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1PEN_POS)
#define TIMER_CHMR1_OUTPUT_CH1PEN     TIMER_CHMR1_OUTPUT_CH1PEN_MSK

#define TIMER_CHMR1_OUTPUT_CH1FEN_POS 2U
#define TIMER_CHMR1_OUTPUT_CH1FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1FEN_POS)
#define TIMER_CHMR1_OUTPUT_CH1FEN     TIMER_CHMR1_OUTPUT_CH1FEN_MSK

#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_MSK  BITS(TIMER_CHMR1_OUTPUT_CC1SSEL_POSS, TIMER_CHMR1_OUTPUT_CC1SSEL_POSE)
#define TIMER_CHMR1_OUTPUT_CC1SSEL      TIMER_CHMR1_OUTPUT_CC1SSEL_MSK

/****************** Bit definition for TIMER_CHMR1_INPUT register ************************/

#define TIMER_CHMR1_INPUT_I2FLT_POSS 12U
#define TIMER_CHMR1_INPUT_I2FLT_POSE 15U
#define TIMER_CHMR1_INPUT_I2FLT_MSK  BITS(TIMER_CHMR1_INPUT_I2FLT_POSS,TIMER_CHMR1_INPUT_I2FLT_POSE)
#define TIMER_CHMR1_INPUT_I2FLT      TIMER_CHMR1_INPUT_I2FLT_MSK

#define TIMER_CHMR1_INPUT_I2PRES_POSS 10U
#define TIMER_CHMR1_INPUT_I2PRES_POSE 11U
#define TIMER_CHMR1_INPUT_I2PRES_MSK  BITS(TIMER_CHMR1_INPUT_I2PRES_POSS,TIMER_CHMR1_INPUT_I2PRES_POSE)
#define TIMER_CHMR1_INPUT_I2PRES      TIMER_CHMR1_INPUT_I2PRES_MSK

#define TIMER_CHMR1_INPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_INPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_INPUT_CC2SSEL_MSK  BITS(TIMER_CHMR1_INPUT_CC2SSEL_POSS,TIMER_CHMR1_INPUT_CC2SSEL_POSE)
#define TIMER_CHMR1_INPUT_CC2SSEL      TIMER_CHMR1_INPUT_CC2SSEL_MSK

#define TIMER_CHMR1_INPUT_I1FLT_POSS 4U
#define TIMER_CHMR1_INPUT_I1FLT_POSE 7U
#define TIMER_CHMR1_INPUT_I1FLT_MSK  BITS(TIMER_CHMR1_INPUT_I1FLT_POSS,TIMER_CHMR1_INPUT_I1FLT_POSE)
#define TIMER_CHMR1_INPUT_I1FLT      TIMER_CHMR1_INPUT_I1FLT_MSK

#define TIMER_CHMR1_INPUT_I1PRES_POSS 2U
#define TIMER_CHMR1_INPUT_I1PRES_POSE 3U
#define TIMER_CHMR1_INPUT_I1PRES_MSK  BITS(TIMER_CHMR1_INPUT_I1PRES_POSS,TIMER_CHMR1_INPUT_I1PRES_POSE)
#define TIMER_CHMR1_INPUT_I1PRES      TIMER_CHMR1_INPUT_I1PRES_MSK

#define TIMER_CHMR1_INPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_INPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_INPUT_CC1SSEL_MSK  BITS(TIMER_CHMR1_INPUT_CC1SSEL_POSS,TIMER_CHMR1_INPUT_CC1SSEL_POSE)
#define TIMER_CHMR1_INPUT_CC1SSEL      TIMER_CHMR1_INPUT_CC1SSEL_MSK

/****************** Bit definition for TIMER_CHMR2_OUTPUT register ************************/

#define TIMER_CHMR2_OUTPUT_CH4MOD2_POSS 24U
#define TIMER_CHMR2_OUTPUT_CH4MOD2_POSE 25U
#define TIMER_CHMR2_OUTPUT_CH4MOD2_MSK  BITS(TIMER_CHMR2_OUTPUT_CH4MOD2_POSS, TIMER_CHMR2_OUTPUT_CH4MOD2_POSE)
#define TIMER_CHMR2_OUTPUT_CH4MOD2      TIMER_CHMR2_OUTPUT_CH4MOD2_MSK

#define TIMER_CHMR2_OUTPUT_CH3MOD2_POSS 16U
#define TIMER_CHMR2_OUTPUT_CH3MOD2_POSE 17U
#define TIMER_CHMR2_OUTPUT_CH3MOD2_MSK  BITS(TIMER_CHMR2_OUTPUT_CH3MOD2_POSS, TIMER_CHMR2_OUTPUT_CH3MOD2_POSE)
#define TIMER_CHMR2_OUTPUT_CH3MOD2      TIMER_CHMR2_OUTPUT_CH3MOD2_MSK

#define TIMER_CHMR2_OUTPUT_CH4OCLREN_POS 15U
#define TIMER_CHMR2_OUTPUT_CH4OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4OCLREN_POS)
#define TIMER_CHMR2_OUTPUT_CH4OCLREN     TIMER_CHMR2_OUTPUT_CH4OCLREN_MSK

#define TIMER_CHMR2_OUTPUT_CH4MOD_POSS 12U
#define TIMER_CHMR2_OUTPUT_CH4MOD_POSE 14U
#define TIMER_CHMR2_OUTPUT_CH4MOD_MSK  BITS(TIMER_CHMR2_OUTPUT_CH4MOD_POSS, TIMER_CHMR2_OUTPUT_CH4MOD_POSE)
#define TIMER_CHMR2_OUTPUT_CH4MOD      TIMER_CHMR2_OUTPUT_CH4MOD_MSK

#define TIMER_CHMR2_OUTPUT_CH4PEN_POS 11U
#define TIMER_CHMR2_OUTPUT_CH4PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4PEN_POS)
#define TIMER_CHMR2_OUTPUT_CH4PEN     TIMER_CHMR2_OUTPUT_CH4PEN_MSK

#define TIMER_CHMR2_OUTPUT_CH4FEN_POS 10U
#define TIMER_CHMR2_OUTPUT_CH4FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4FEN_POS)
#define TIMER_CHMR2_OUTPUT_CH4FEN     TIMER_CHMR2_OUTPUT_CH4FEN_MSK

#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_MSK  BITS(TIMER_CHMR2_OUTPUT_CC4SSEL_POSS, TIMER_CHMR2_OUTPUT_CC4SSEL_POSE)
#define TIMER_CHMR2_OUTPUT_CC4SSEL      TIMER_CHMR2_OUTPUT_CC4SSEL_MSK

#define TIMER_CHMR2_OUTPUT_CH3OCLREN_POS 7U
#define TIMER_CHMR2_OUTPUT_CH3OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3OCLREN_POS)
#define TIMER_CHMR2_OUTPUT_CH3OCLREN     TIMER_CHMR2_OUTPUT_CH3OCLREN_MSK

#define TIMER_CHMR2_OUTPUT_CH3MOD_POSS 4U
#define TIMER_CHMR2_OUTPUT_CH3MOD_POSE 6U
#define TIMER_CHMR2_OUTPUT_CH3MOD_MSK  BITS(TIMER_CHMR2_OUTPUT_CH3MOD_POSS, TIMER_CHMR2_OUTPUT_CH3MOD_POSE)
#define TIMER_CHMR2_OUTPUT_CH3MOD      TIMER_CHMR2_OUTPUT_CH3MOD_MSK

#define TIMER_CHMR2_OUTPUT_CH3PEN_POS 3U
#define TIMER_CHMR2_OUTPUT_CH3PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3PEN_POS)
#define TIMER_CHMR2_OUTPUT_CH3PEN     TIMER_CHMR2_OUTPUT_CH3PEN_MSK

#define TIMER_CHMR2_OUTPUT_CH3FEN_POS 2U
#define TIMER_CHMR2_OUTPUT_CH3FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3FEN_POS)
#define TIMER_CHMR2_OUTPUT_CH3FEN     TIMER_CHMR2_OUTPUT_CH3FEN_MSK

#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_MSK  BITS(TIMER_CHMR2_OUTPUT_CC3SSEL_POSS, TIMER_CHMR2_OUTPUT_CC3SSEL_POSE)
#define TIMER_CHMR2_OUTPUT_CC3SSEL      TIMER_CHMR2_OUTPUT_CC3SSEL_MSK

/****************** Bit definition for TIMER_CHMR2_INPUT register ************************/

#define TIMER_CHMR2_INPUT_I4FLT_POSS 12U
#define TIMER_CHMR2_INPUT_I4FLT_POSE 15U
#define TIMER_CHMR2_INPUT_I4FLT_MSK  BITS(TIMER_CHMR2_INPUT_I4FLT_POSS, TIMER_CHMR2_INPUT_I4FLT_POSE)
#define TIMER_CHMR2_INPUT_I4FLT      TIMER_CHMR2_INPUT_I4FLT_MSK

#define TIMER_CHMR2_INPUT_I4PRES_POSS 10U
#define TIMER_CHMR2_INPUT_I4PRES_POSE 11U
#define TIMER_CHMR2_INPUT_I4PRES_MSK  BITS(TIMER_CHMR2_INPUT_I4PRES_POSS, TIMER_CHMR2_INPUT_I4PRES_POSE)
#define TIMER_CHMR2_INPUT_I4PRES      TIMER_CHMR2_INPUT_I4PRES_MSK

#define TIMER_CHMR2_INPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_INPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_INPUT_CC4SSEL_MSK  BITS(TIMER_CHMR2_INPUT_CC4SSEL_POSS, TIMER_CHMR2_INPUT_CC4SSEL_POSE)
#define TIMER_CHMR2_INPUT_CC4SSEL      TIMER_CHMR2_INPUT_CC4SSEL_MSK

#define TIMER_CHMR2_INPUT_I3FLT_POSS 4U
#define TIMER_CHMR2_INPUT_I3FLT_POSE 7U
#define TIMER_CHMR2_INPUT_I3FLT_MSK  BITS(TIMER_CHMR2_INPUT_I3FLT_POSS, TIMER_CHMR2_INPUT_I3FLT_POSE)
#define TIMER_CHMR2_INPUT_I3FLT      TIMER_CHMR2_INPUT_I3FLT_MSK

#define TIMER_CHMR2_INPUT_I3PRES_POSS 2U
#define TIMER_CHMR2_INPUT_I3PRES_POSE 3U
#define TIMER_CHMR2_INPUT_I3PRES_MSK  BITS(TIMER_CHMR2_INPUT_I3PRES_POSS, TIMER_CHMR2_INPUT_I3PRES_POSE)
#define TIMER_CHMR2_INPUT_I3PRES      TIMER_CHMR2_INPUT_I3PRES_MSK

#define TIMER_CHMR2_INPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_INPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_INPUT_CC3SSEL_MSK  BITS(TIMER_CHMR2_INPUT_CC3SSEL_POSS, TIMER_CHMR2_INPUT_CC3SSEL_POSE)
#define TIMER_CHMR2_INPUT_CC3SSEL      TIMER_CHMR2_INPUT_CC3SSEL_MSK

/****************** Bit definition for TIMER_CCEP register ************************/

#define  TIMER_CCEP_CC6POL_POS  21U
#define  TIMER_CCEP_CC6POL_MSK  BIT(TIMER_CCEP_CC6POL_POS)
#define  TIMER_CCEP_CC6POL      TIMER_CCEP_CC6POL_MSK

#define  TIMER_CCEP_CC6EN_POS  20U
#define  TIMER_CCEP_CC6EN_MSK  BIT(TIMER_CCEP_CC6EN_POS)
#define  TIMER_CCEP_CC6EN      TIMER_CCEP_CC6EN_MSK

#define  TIMER_CCEP_CC5POL_POS  17U
#define  TIMER_CCEP_CC5POL_MSK  BIT(TIMER_CCEP_CC5POL_POS)
#define  TIMER_CCEP_CC5POL      TIMER_CCEP_CC5POL_MSK

#define  TIMER_CCEP_CC5EN_POS  16U
#define  TIMER_CCEP_CC5EN_MSK  BIT(TIMER_CCEP_CC5EN_POS)
#define  TIMER_CCEP_CC5EN      TIMER_CCEP_CC5EN_MSK

#define  TIMER_CCEP_CC4NPOL_POS  15U
#define  TIMER_CCEP_CC4NPOL_MSK  BIT(TIMER_CCEP_CC4NPOL_POS)
#define  TIMER_CCEP_CC4NPOL      TIMER_CCEP_CC4NPOL_MSK

#define  TIMER_CCEP_CC4NEN_POS  14U
#define  TIMER_CCEP_CC4NEN_MSK  BIT(TIMER_CCEP_CC4NEN_POS)
#define  TIMER_CCEP_CC4NEN      TIMER_CCEP_CC4NEN_MSK

#define  TIMER_CCEP_CC4POL_POS  13U
#define  TIMER_CCEP_CC4POL_MSK  BIT(TIMER_CCEP_CC4POL_POS)
#define  TIMER_CCEP_CC4POL      TIMER_CCEP_CC4POL_MSK

#define  TIMER_CCEP_CC4EN_POS  12U
#define  TIMER_CCEP_CC4EN_MSK  BIT(TIMER_CCEP_CC4EN_POS)
#define  TIMER_CCEP_CC4EN      TIMER_CCEP_CC4EN_MSK

#define  TIMER_CCEP_CC3NPOL_POS  11U
#define  TIMER_CCEP_CC3NPOL_MSK  BIT(TIMER_CCEP_CC3NPOL_POS)
#define  TIMER_CCEP_CC3NPOL      TIMER_CCEP_CC3NPOL_MSK

#define  TIMER_CCEP_CC3NEN_POS  10U
#define  TIMER_CCEP_CC3NEN_MSK  BIT(TIMER_CCEP_CC3NEN_POS)
#define  TIMER_CCEP_CC3NEN      TIMER_CCEP_CC3NEN_MSK

#define  TIMER_CCEP_CC3POL_POS  9U
#define  TIMER_CCEP_CC3POL_MSK  BIT(TIMER_CCEP_CC3POL_POS)
#define  TIMER_CCEP_CC3POL      TIMER_CCEP_CC3POL_MSK

#define  TIMER_CCEP_CC3EN_POS  8U
#define  TIMER_CCEP_CC3EN_MSK  BIT(TIMER_CCEP_CC3EN_POS)
#define  TIMER_CCEP_CC3EN      TIMER_CCEP_CC3EN_MSK

#define  TIMER_CCEP_CC2NPOL_POS  7U
#define  TIMER_CCEP_CC2NPOL_MSK  BIT(TIMER_CCEP_CC2NPOL_POS)
#define  TIMER_CCEP_CC2NPOL      TIMER_CCEP_CC2NPOL_MSK

#define  TIMER_CCEP_CC2NEN_POS  6U
#define  TIMER_CCEP_CC2NEN_MSK  BIT(TIMER_CCEP_CC2NEN_POS)
#define  TIMER_CCEP_CC2NEN      TIMER_CCEP_CC2NEN_MSK

#define  TIMER_CCEP_CC2POL_POS  5U
#define  TIMER_CCEP_CC2POL_MSK  BIT(TIMER_CCEP_CC2POL_POS)
#define  TIMER_CCEP_CC2POL      TIMER_CCEP_CC2POL_MSK

#define  TIMER_CCEP_CC2EN_POS  4U
#define  TIMER_CCEP_CC2EN_MSK  BIT(TIMER_CCEP_CC2EN_POS)
#define  TIMER_CCEP_CC2EN      TIMER_CCEP_CC2EN_MSK

#define  TIMER_CCEP_CC1NPOL_POS  3U
#define  TIMER_CCEP_CC1NPOL_MSK  BIT(TIMER_CCEP_CC1NPOL_POS)
#define  TIMER_CCEP_CC1NPOL      TIMER_CCEP_CC1NPOL_MSK

#define  TIMER_CCEP_CC1NEN_POS  2U
#define  TIMER_CCEP_CC1NEN_MSK  BIT(TIMER_CCEP_CC1NEN_POS)
#define  TIMER_CCEP_CC1NEN      TIMER_CCEP_CC1NEN_MSK

#define  TIMER_CCEP_CC1POL_POS  1U
#define  TIMER_CCEP_CC1POL_MSK  BIT(TIMER_CCEP_CC1POL_POS)
#define  TIMER_CCEP_CC1POL      TIMER_CCEP_CC1POL_MSK

#define  TIMER_CCEP_CC1EN_POS  0U
#define  TIMER_CCEP_CC1EN_MSK  BIT(TIMER_CCEP_CC1EN_POS)
#define  TIMER_CCEP_CC1EN      TIMER_CCEP_CC1EN_MSK

/****************** Bit definition for TIMER_COUNT register ************************/

#define  TIMER_COUNT_UPDRIF_POS  31U
#define  TIMER_COUNT_UPDRIF_MSK  BIT(TIMER_COUNT_UPDRIF_POS)
#define  TIMER_COUNT_UPDRIF      TIMER_COUNT_UPDRIF_MSK

#define  TIMER_COUNT_CNTV_POSS  0U
#define  TIMER_COUNT_CNTV_POSE  30U
#define  TIMER_COUNT_CNTV_MSK   BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)
#define  TIMER_COUNT_CNTV       TIMER_COUNT_CNTV_MSK

/****************** Bit definition for TIMER_PRES register ************************/

#define  TIMER_PRES_PSCV_POSS  0U
#define  TIMER_PRES_PSCV_POSE  15U
#define  TIMER_PRES_PSCV_MSK   BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)
#define  TIMER_PRES_PSCV       TIMER_PRES_PSCV_MSK

/****************** Bit definition for TIMER_AR register ************************/

#define TIMER_AR_ARV_POSS 0U
#define TIMER_AR_ARV_POSE 31U
#define TIMER_AR_ARV_MSK  BITS(TIMER_AR_ARV_POSS, TIMER_AR_ARV_POSE)
#define TIMER_AR_ARV      TIMER_AR_ARV_MSK

/****************** Bit definition for TIMER_REPAR register ************************/

#define TIMER_REPAR_REPV_POSS 0U
#define TIMER_REPAR_REPV_POSE 15U
#define TIMER_REPAR_REPV_MSK  BITS(TIMER_REPAR_REPV_POSS, TIMER_REPAR_REPV_POSE)
#define TIMER_REPAR_REPV      TIMER_REPAR_REPV_MSK

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define TIMER_CCVAL1_CCRV1_POSS 0U
#define TIMER_CCVAL1_CCRV1_POSE 31U
#define TIMER_CCVAL1_CCRV1_MSK  BITS(TIMER_CCVAL1_CCRV1_POSS, TIMER_CCVAL1_CCRV1_POSE)
#define TIMER_CCVAL1_CCRV1      TIMER_CCVAL1_CCRV1_MSK

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define TIMER_CCVAL2_CCRV2_POSS 0U
#define TIMER_CCVAL2_CCRV2_POSE 31U
#define TIMER_CCVAL2_CCRV2_MSK  BITS(TIMER_CCVAL2_CCRV2_POSS, TIMER_CCVAL2_CCRV2_POSE)
#define TIMER_CCVAL2_CCRV2      TIMER_CCVAL2_CCRV2_MSK

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define TIMER_CCVAL3_CCRV3_POSS 0U
#define TIMER_CCVAL3_CCRV3_POSE 31U
#define TIMER_CCVAL3_CCRV3_MSK  BITS(TIMER_CCVAL3_CCRV3_POSS, TIMER_CCVAL3_CCRV3_POSE)
#define TIMER_CCVAL3_CCRV3      TIMER_CCVAL3_CCRV3_MSK

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define TIMER_CCVAL4_CCRV4_POSS 0U
#define TIMER_CCVAL4_CCRV4_POSE 31U
#define TIMER_CCVAL4_CCRV4_MSK  BITS(TIMER_CCVAL4_CCRV4_POSS, TIMER_CCVAL4_CCRV4_POSE)
#define TIMER_CCVAL4_CCRV4      TIMER_CCVAL4_CCRV4_MSK

/****************** Bit definition for TIMER_BDCFG register ************************/

#define  TIMER_BDCFG_BRK2BID_POS  29U
#define  TIMER_BDCFG_BRK2BID_MSK  BIT(TIMER_BDCFG_BRK2BID_POS)
#define  TIMER_BDCFG_BRK2BID      TIMER_BDCFG_BRK2BID_MSK

#define  TIMER_BDCFG_BRKBID_POS  28U
#define  TIMER_BDCFG_BRKBID_MSK  BIT(TIMER_BDCFG_BRKBID_POS)
#define  TIMER_BDCFG_BRKBID      TIMER_BDCFG_BRKBID_MSK

#define  TIMER_BDCFG_BRK2DSRM_POS  27U
#define  TIMER_BDCFG_BRK2DSRM_MSK  BIT(TIMER_BDCFG_BRK2DSRM_POS)
#define  TIMER_BDCFG_BRK2DSRM      TIMER_BDCFG_BRK2DSRM_MSK

#define  TIMER_BDCFG_BRKDSRM_POS  26U
#define  TIMER_BDCFG_BRKDSRM_MSK  BIT(TIMER_BDCFG_BRKDSRM_POS)
#define  TIMER_BDCFG_BRKDSRM      TIMER_BDCFG_BRKDSRM_MSK

#define  TIMER_BDCFG_BRK2P_POS  25U
#define  TIMER_BDCFG_BRK2P_MSK  BIT(TIMER_BDCFG_BRK2P_POS)
#define  TIMER_BDCFG_BRK2P      TIMER_BDCFG_BRK2P_MSK

#define  TIMER_BDCFG_BRK2EN_POS  24U
#define  TIMER_BDCFG_BRK2EN_MSK  BIT(TIMER_BDCFG_BRK2EN_POS)
#define  TIMER_BDCFG_BRK2EN      TIMER_BDCFG_BRK2EN_MSK

#define  TIMER_BDCFG_BRK2FLT_POSS  20U
#define  TIMER_BDCFG_BRK2FLT_POSE  23U
#define  TIMER_BDCFG_BRK2FLT_MSK  BITS(TIMER_BDCFG_BRK2FLT_POSS, TIMER_BDCFG_BRK2FLT_POSE)
#define  TIMER_BDCFG_BRK2FLT      TIMER_BDCFG_BRK2FLT_MSK

#define  TIMER_BDCFG_BRKFLT_POSS  16U
#define  TIMER_BDCFG_BRKFLT_POSE  19U
#define  TIMER_BDCFG_BRKFLT_MSK  BITS(TIMER_BDCFG_BRKFLT_POSS, TIMER_BDCFG_BRKFLT_POSE)
#define  TIMER_BDCFG_BRKFLT      TIMER_BDCFG_BRKFLT_MSK

#define  TIMER_BDCFG_GOEN_POS  15U
#define  TIMER_BDCFG_GOEN_MSK  BIT(TIMER_BDCFG_GOEN_POS)
#define  TIMER_BDCFG_GOEN      TIMER_BDCFG_GOEN_MSK

#define  TIMER_BDCFG_AOEN_POS  14U
#define  TIMER_BDCFG_AOEN_MSK  BIT(TIMER_BDCFG_AOEN_POS)
#define  TIMER_BDCFG_AOEN      TIMER_BDCFG_AOEN_MSK

#define  TIMER_BDCFG_BRKP_POS  13U
#define  TIMER_BDCFG_BRKP_MSK  BIT(TIMER_BDCFG_BRKP_POS)
#define  TIMER_BDCFG_BRKP      TIMER_BDCFG_BRKP_MSK

#define  TIMER_BDCFG_BRKEN_POS  12U
#define  TIMER_BDCFG_BRKEN_MSK  BIT(TIMER_BDCFG_BRKEN_POS)
#define  TIMER_BDCFG_BRKEN      TIMER_BDCFG_BRKEN_MSK

#define  TIMER_BDCFG_OFFSSR_POS  11U
#define  TIMER_BDCFG_OFFSSR_MSK  BIT(TIMER_BDCFG_OFFSSR_POS)
#define  TIMER_BDCFG_OFFSSR      TIMER_BDCFG_OFFSSR_MSK

#define  TIMER_BDCFG_OFFSSI_POS  10U
#define  TIMER_BDCFG_OFFSSI_MSK  BIT(TIMER_BDCFG_OFFSSI_POS)
#define  TIMER_BDCFG_OFFSSI      TIMER_BDCFG_OFFSSI_MSK

#define  TIMER_BDCFG_LOCKLVL_POSS  8U
#define  TIMER_BDCFG_LOCKLVL_POSE  9U
#define  TIMER_BDCFG_LOCKLVL_MSK   BITS(TIMER_BDCFG_LOCKLVL_POSS, TIMER_BDCFG_LOCKLVL_POSE)
#define  TIMER_BDCFG_LOCKLVL       TIMER_BDCFG_LOCKLVL_MSK

#define  TIMER_BDCFG_DT_POSS  0U
#define  TIMER_BDCFG_DT_POSE  7U
#define  TIMER_BDCFG_DT_MSK   BITS(TIMER_BDCFG_DT_POSS, TIMER_BDCFG_DT_POSE)
#define  TIMER_BDCFG_DT       TIMER_BDCFG_DT_MSK

/****************** Bit definition for TIMER_DMAEN register ************************/

#define  TIMER_DMAEN_TRGI_POS  6U
#define  TIMER_DMAEN_TRGI_MSK  BIT(TIMER_DMAEN_TRGI_POS)
#define  TIMER_DMAEN_TRGI      TIMER_DMAEN_TRGI_MSK

#define  TIMER_DMAEN_COM_POS  5U
#define  TIMER_DMAEN_COM_MSK  BIT(TIMER_DMAEN_COM_POS)
#define  TIMER_DMAEN_COM      TIMER_DMAEN_COM_MSK

#define  TIMER_DMAEN_CH4_POS  4U
#define  TIMER_DMAEN_CH4_MSK  BIT(TIMER_DMAEN_CH4_POS)
#define  TIMER_DMAEN_CH4      TIMER_DMAEN_CH4_MSK

#define  TIMER_DMAEN_CH3_POS  3U
#define  TIMER_DMAEN_CH3_MSK  BIT(TIMER_DMAEN_CH3_POS)
#define  TIMER_DMAEN_CH3      TIMER_DMAEN_CH3_MSK

#define  TIMER_DMAEN_CH2_POS  2U
#define  TIMER_DMAEN_CH2_MSK  BIT(TIMER_DMAEN_CH2_POS)
#define  TIMER_DMAEN_CH2      TIMER_DMAEN_CH2_MSK

#define  TIMER_DMAEN_CH1_POS  1U
#define  TIMER_DMAEN_CH1_MSK  BIT(TIMER_DMAEN_CH1_POS)
#define  TIMER_DMAEN_CH1      TIMER_DMAEN_CH1_MSK

#define  TIMER_DMAEN_UPD_POS  0U
#define  TIMER_DMAEN_UPD_MSK  BIT(TIMER_DMAEN_UPD_POS)
#define  TIMER_DMAEN_UPD      TIMER_DMAEN_UPD_MSK

/****************** Bit definition for TIMER_CCVAL5 register ************************/

#define  TIMER_CCVAL5_GC5C3_POS  31U
#define  TIMER_CCVAL5_GC5C3_MSK  BIT(TIMER_CCVAL5_GC5C3_POS)
#define  TIMER_CCVAL5_GC5C3      TIMER_CCVAL5_GC5C3_MSK

#define  TIMER_CCVAL5_GC5C2_POS  30U
#define  TIMER_CCVAL5_GC5C2_MSK  BIT(TIMER_CCVAL5_GC5C2_POS)
#define  TIMER_CCVAL5_GC5C2      TIMER_CCVAL5_GC5C2_MSK

#define  TIMER_CCVAL5_GC5C1_POS  29U
#define  TIMER_CCVAL5_GC5C1_MSK  BIT(TIMER_CCVAL5_GC5C1_POS)
#define  TIMER_CCVAL5_GC5C1      TIMER_CCVAL5_GC5C1_MSK

#define  TIMER_CCVAL5_CCRV5_POSS  0U
#define  TIMER_CCVAL5_CCRV5_POSE  19U
#define  TIMER_CCVAL5_CCRV5_MSK  BITS(TIMER_CCVAL5_CCRV5_POSS, TIMER_CCVAL5_CCRV5_POSE)
#define  TIMER_CCVAL5_CCRV5      TIMER_CCVAL5_CCRV5_MSK

/****************** Bit definition for TIMER_CCVAL6 register ************************/

#define  TIMER_CCVAL6_CCRV6_POSS  0U
#define  TIMER_CCVAL6_CCRV6_POSE  19U
#define  TIMER_CCVAL6_CCRV6_MSK  BITS(TIMER_CCVAL6_CCRV6_POSS, TIMER_CCVAL6_CCRV6_POSE)
#define  TIMER_CCVAL6_CCRV6      TIMER_CCVAL6_CCRV6_MSK

/****************** Bit definition for TIMER_CHMR3 register ************************/

#define  TIMER_CHMR3_CH6MOD2_POS  24U
#define  TIMER_CHMR3_CH6MOD2_MSK  BIT(TIMER_CHMR3_CH6MOD2_POS)
#define  TIMER_CHMR3_CH6MOD2      TIMER_CHMR3_CH6MOD2_MSK

#define  TIMER_CHMR3_CH5MOD2_POS  16U
#define  TIMER_CHMR3_CH5MOD2_MSK  BIT(TIMER_CHMR3_CH5MOD2_POS)
#define  TIMER_CHMR3_CH5MOD2      TIMER_CHMR3_CH5MOD2_MSK

#define  TIMER_CHMR3_CH6OCLREN_POS  15U
#define  TIMER_CHMR3_CH6OCLREN_MSK  BIT(TIMER_CHMR3_CH6OCLREN_POS)
#define  TIMER_CHMR3_CH6OCLREN      TIMER_CHMR3_CH6OCLREN_MSK

#define  TIMER_CHMR3_CH6MOD_POSS  12U
#define  TIMER_CHMR3_CH6MOD_POSE  14U
#define  TIMER_CHMR3_CH6MOD_MSK  BITS(TIMER_CHMR3_CH6MOD_POSS, TIMER_CHMR3_CH6MOD_POSE)
#define  TIMER_CHMR3_CH6MOD      TIMER_CHMR3_CH6MOD_MSK

#define  TIMER_CHMR3_CH6PEN_POS  11U
#define  TIMER_CHMR3_CH6PEN_MSK  BIT(TIMER_CHMR3_CH6PEN_POS)
#define  TIMER_CHMR3_CH6PEN      TIMER_CHMR3_CH6PEN_MSK

#define  TIMER_CHMR3_CH6FEN_POS  10U
#define  TIMER_CHMR3_CH6FEN_MSK  BIT(TIMER_CHMR3_CH6FEN_POS)
#define  TIMER_CHMR3_CH6FEN      TIMER_CHMR3_CH6FEN_MSK

#define  TIMER_CHMR3_CH5OCLREN_POS  7U
#define  TIMER_CHMR3_CH5OCLREN_MSK  BIT(TIMER_CHMR3_CH5OCLREN_POS)
#define  TIMER_CHMR3_CH5OCLREN      TIMER_CHMR3_CH5OCLREN_MSK

#define  TIMER_CHMR3_CH5MOD_POSS  4U
#define  TIMER_CHMR3_CH5MOD_POSE  6U
#define  TIMER_CHMR3_CH5MOD_MSK  BITS(TIMER_CHMR3_CH5MOD_POSS, TIMER_CHMR3_CH5MOD_POSE)
#define  TIMER_CHMR3_CH5MOD      TIMER_CHMR3_CH5MOD_MSK

#define  TIMER_CHMR3_CH5PEN_POS  3U
#define  TIMER_CHMR3_CH5PEN_MSK  BIT(TIMER_CHMR3_CH5PEN_POS)
#define  TIMER_CHMR3_CH5PEN      TIMER_CHMR3_CH5PEN_MSK

#define  TIMER_CHMR3_CH5FEN_POS  2U
#define  TIMER_CHMR3_CH5FEN_MSK  BIT(TIMER_CHMR3_CH5FEN_POS)
#define  TIMER_CHMR3_CH5FEN      TIMER_CHMR3_CH5FEN_MSK

/****************** Bit definition for TIMER_DCFG2 register ************************/

#define  TIMER_DCFG2_DTPEN_POS  17U
#define  TIMER_DCFG2_DTPEN_MSK  BIT(TIMER_DCFG2_DTPEN_POS)
#define  TIMER_DCFG2_DTPEN      TIMER_DCFG2_DTPEN_MSK

#define  TIMER_DCFG2_DTAEN_POS  16U
#define  TIMER_DCFG2_DTAEN_MSK  BIT(TIMER_DCFG2_DTAEN_POS)
#define  TIMER_DCFG2_DTAEN      TIMER_DCFG2_DTAEN_MSK

#define  TIMER_DCFG2_DT2_POSS  0U
#define  TIMER_DCFG2_DT2_POSE  7U
#define  TIMER_DCFG2_DT2_MSK  BITS(TIMER_DCFG2_DT2_POSS, TIMER_DCFG2_DT2_POSE)
#define  TIMER_DCFG2_DT2      TIMER_DCFG2_DT2_MSK

/****************** Bit definition for TIMER_ENCR register ************************/

#define  TIMER_ENCR_PWPRES_POSS  24U
#define  TIMER_ENCR_PWPRES_POSE  26U
#define  TIMER_ENCR_PWPRES_MSK  BITS(TIMER_ENCR_PWPRES_POSS, TIMER_ENCR_PWPRES_POSE)
#define  TIMER_ENCR_PWPRES      TIMER_ENCR_PWPRES_MSK

#define  TIMER_ENCR_PW_POSS  16U
#define  TIMER_ENCR_PW_POSE  23U
#define  TIMER_ENCR_PW_MSK  BITS(TIMER_ENCR_PW_POSS, TIMER_ENCR_PW_POSE)
#define  TIMER_ENCR_PW      TIMER_ENCR_PW_MSK

#define  TIMER_ENCR_IDXPOS_POSS  6U
#define  TIMER_ENCR_IDXPOS_POSE  7U
#define  TIMER_ENCR_IDXPOS_MSK  BITS(TIMER_ENCR_IDXPOS_POSS, TIMER_ENCR_IDXPOS_POSE)
#define  TIMER_ENCR_IDXPOS      TIMER_ENCR_IDXPOS_MSK

#define  TIMER_ENCR_FIDX_POS  5U
#define  TIMER_ENCR_FIDX_MSK  BIT(TIMER_ENCR_FIDX_POS)
#define  TIMER_ENCR_FIDX      TIMER_ENCR_FIDX_MSK

#define  TIMER_ENCR_IDXDIR_POSS  1U
#define  TIMER_ENCR_IDXDIR_POSE  2U
#define  TIMER_ENCR_IDXDIR_MSK  BITS(TIMER_ENCR_IDXDIR_POSS, TIMER_ENCR_IDXDIR_POSE)
#define  TIMER_ENCR_IDXDIR      TIMER_ENCR_IDXDIR_MSK

#define  TIMER_ENCR_IDXEN_POS  0U
#define  TIMER_ENCR_IDXEN_MSK  BIT(TIMER_ENCR_IDXEN_POS)
#define  TIMER_ENCR_IDXEN      TIMER_ENCR_IDXEN_MSK

/****************** Bit definition for TIMER_CHISEL register ************************/

#define  TIMER_CHISEL_I4SEL_POSS  24U
#define  TIMER_CHISEL_I4SEL_POSE  27U
#define  TIMER_CHISEL_I4SEL_MSK  BITS(TIMER_CHISEL_I4SEL_POSS, TIMER_CHISEL_I4SEL_POSE)
#define  TIMER_CHISEL_I4SEL      TIMER_CHISEL_I4SEL_MSK

#define  TIMER_CHISEL_I3SEL_POSS  16U
#define  TIMER_CHISEL_I3SEL_POSE  19U
#define  TIMER_CHISEL_I3SEL_MSK  BITS(TIMER_CHISEL_I3SEL_POSS, TIMER_CHISEL_I3SEL_POSE)
#define  TIMER_CHISEL_I3SEL      TIMER_CHISEL_I3SEL_MSK

#define  TIMER_CHISEL_I2SEL_POSS  8U
#define  TIMER_CHISEL_I2SEL_POSE  11U
#define  TIMER_CHISEL_I2SEL_MSK  BITS(TIMER_CHISEL_I2SEL_POSS, TIMER_CHISEL_I2SEL_POSE)
#define  TIMER_CHISEL_I2SEL      TIMER_CHISEL_I2SEL_MSK

#define  TIMER_CHISEL_I1SEL_POSS  0U
#define  TIMER_CHISEL_I1SEL_POSE  3U
#define  TIMER_CHISEL_I1SEL_MSK  BITS(TIMER_CHISEL_I1SEL_POSS, TIMER_CHISEL_I1SEL_POSE)
#define  TIMER_CHISEL_I1SEL      TIMER_CHISEL_I1SEL_MSK

/****************** Bit definition for TIMER_AFR1 register ************************/

#define  TIMER_AFR1_ETRSEL_POSS  14U
#define  TIMER_AFR1_ETRSEL_POSE  17U
#define  TIMER_AFR1_ETRSEL_MSK  BITS(TIMER_AFR1_ETRSEL_POSS, TIMER_AFR1_ETRSEL_POSE)
#define  TIMER_AFR1_ETRSEL      TIMER_AFR1_ETRSEL_MSK

#define  TIMER_AFR1_BRKEXTP_POS  12U
#define  TIMER_AFR1_BRKEXTP_MSK  BIT(TIMER_AFR1_BRKEXTP_POS)
#define  TIMER_AFR1_BRKEXTP      TIMER_AFR1_BRKEXTP_MSK

#define  TIMER_AFR1_BRKCMP2P_POS  11U
#define  TIMER_AFR1_BRKCMP2P_MSK  BIT(TIMER_AFR1_BRKCMP2P_POS)
#define  TIMER_AFR1_BRKCMP2P      TIMER_AFR1_BRKCMP2P_MSK

#define  TIMER_AFR1_BRKCMP1P_POS  10U
#define  TIMER_AFR1_BRKCMP1P_MSK  BIT(TIMER_AFR1_BRKCMP1P_POS)
#define  TIMER_AFR1_BRKCMP1P      TIMER_AFR1_BRKCMP1P_MSK

#define  TIMER_AFR1_BRKINP_POS  9U
#define  TIMER_AFR1_BRKINP_MSK  BIT(TIMER_AFR1_BRKINP_POS)
#define  TIMER_AFR1_BRKINP      TIMER_AFR1_BRKINP_MSK

#define  TIMER_AFR1_BRKEXTEN_POS  3U
#define  TIMER_AFR1_BRKEXTEN_MSK  BIT(TIMER_AFR1_BRKEXTEN_POS)
#define  TIMER_AFR1_BRKEXTEN      TIMER_AFR1_BRKEXTEN_MSK

#define  TIMER_AFR1_BRKCMP2EN_POS  2U
#define  TIMER_AFR1_BRKCMP2EN_MSK  BIT(TIMER_AFR1_BRKCMP2EN_POS)
#define  TIMER_AFR1_BRKCMP2EN      TIMER_AFR1_BRKCMP2EN_MSK

#define  TIMER_AFR1_BRKCMP1EN_POS  1U
#define  TIMER_AFR1_BRKCMP1EN_MSK  BIT(TIMER_AFR1_BRKCMP1EN_POS)
#define  TIMER_AFR1_BRKCMP1EN      TIMER_AFR1_BRKCMP1EN_MSK

#define  TIMER_AFR1_BRKINEN_POS  0U
#define  TIMER_AFR1_BRKINEN_MSK  BIT(TIMER_AFR1_BRKINEN_POS)
#define  TIMER_AFR1_BRKINEN      TIMER_AFR1_BRKINEN_MSK

/****************** Bit definition for TIMER_AFR2 register ************************/

#define  TIMER_AFR2_OCLRSEL_POSS  16U
#define  TIMER_AFR2_OCLRSEL_POSE  18U
#define  TIMER_AFR2_OCLRSEL_MSK  BITS(TIMER_AFR2_OCLRSEL_POSS, TIMER_AFR2_OCLRSEL_POSE)
#define  TIMER_AFR2_OCLRSEL      TIMER_AFR2_OCLRSEL_MSK

#define  TIMER_AFR2_BRK2EXTP_POS  12U
#define  TIMER_AFR2_BRK2EXTP_MSK  BIT(TIMER_AFR2_BRK2EXTP_POS)
#define  TIMER_AFR2_BRK2EXTP      TIMER_AFR2_BRK2EXTP_MSK

#define  TIMER_AFR2_BRK2CMP2P_POS  11U
#define  TIMER_AFR2_BRK2CMP2P_MSK  BIT(TIMER_AFR2_BRK2CMP2P_POS)
#define  TIMER_AFR2_BRK2CMP2P      TIMER_AFR2_BRK2CMP2P_MSK

#define  TIMER_AFR2_BRK2CMP1P_POS  10U
#define  TIMER_AFR2_BRK2CMP1P_MSK  BIT(TIMER_AFR2_BRK2CMP1P_POS)
#define  TIMER_AFR2_BRK2CMP1P      TIMER_AFR2_BRK2CMP1P_MSK

#define  TIMER_AFR2_BRK2INP_POS  9U
#define  TIMER_AFR2_BRK2INP_MSK  BIT(TIMER_AFR2_BRK2INP_POS)
#define  TIMER_AFR2_BRK2INP      TIMER_AFR2_BRK2INP_MSK

#define  TIMER_AFR2_BRK2EXTEN_POS  3U
#define  TIMER_AFR2_BRK2EXTEN_MSK  BIT(TIMER_AFR2_BRK2EXTEN_POS)
#define  TIMER_AFR2_BRK2EXTEN      TIMER_AFR2_BRK2EXTEN_MSK

#define  TIMER_AFR2_BRK2CMP2EN_POS  2U
#define  TIMER_AFR2_BRK2CMP2EN_MSK  BIT(TIMER_AFR2_BRK2CMP2EN_POS)
#define  TIMER_AFR2_BRK2CMP2EN      TIMER_AFR2_BRK2CMP2EN_MSK

#define  TIMER_AFR2_BRK2CMP1EN_POS  1U
#define  TIMER_AFR2_BRK2CMP1EN_MSK  BIT(TIMER_AFR2_BRK2CMP1EN_POS)
#define  TIMER_AFR2_BRK2CMP1EN      TIMER_AFR2_BRK2CMP1EN_MSK

#define  TIMER_AFR2_BRK2INEN_POS  0U
#define  TIMER_AFR2_BRK2INEN_MSK  BIT(TIMER_AFR2_BRK2INEN_POS)
#define  TIMER_AFR2_BRK2INEN      TIMER_AFR2_BRK2INEN_MSK

/****************** Bit definition for TIMER_TGOSEL register ************************/

#define  TIMER_TGOSEL_CH6U_POS  21U
#define  TIMER_TGOSEL_CH6U_MSK  BIT(TIMER_TGOSEL_CH6U_POS)
#define  TIMER_TGOSEL_CH6U      TIMER_TGOSEL_CH6U_MSK

#define  TIMER_TGOSEL_CH5U_POS  20U
#define  TIMER_TGOSEL_CH5U_MSK  BIT(TIMER_TGOSEL_CH5U_POS)
#define  TIMER_TGOSEL_CH5U      TIMER_TGOSEL_CH5U_MSK

#define  TIMER_TGOSEL_CH4U_POS  19U
#define  TIMER_TGOSEL_CH4U_MSK  BIT(TIMER_TGOSEL_CH4U_POS)
#define  TIMER_TGOSEL_CH4U      TIMER_TGOSEL_CH4U_MSK

#define  TIMER_TGOSEL_CH3U_POS  18U
#define  TIMER_TGOSEL_CH3U_MSK  BIT(TIMER_TGOSEL_CH3U_POS)
#define  TIMER_TGOSEL_CH3U      TIMER_TGOSEL_CH3U_MSK

#define  TIMER_TGOSEL_CH2U_POS  17U
#define  TIMER_TGOSEL_CH2U_MSK  BIT(TIMER_TGOSEL_CH2U_POS)
#define  TIMER_TGOSEL_CH2U      TIMER_TGOSEL_CH2U_MSK

#define  TIMER_TGOSEL_CH1U_POS  16U
#define  TIMER_TGOSEL_CH1U_MSK  BIT(TIMER_TGOSEL_CH1U_POS)
#define  TIMER_TGOSEL_CH1U      TIMER_TGOSEL_CH1U_MSK

#define  TIMER_TGOSEL_CH6D_POS  5U
#define  TIMER_TGOSEL_CH6D_MSK  BIT(TIMER_TGOSEL_CH6D_POS)
#define  TIMER_TGOSEL_CH6D      TIMER_TGOSEL_CH6D_MSK

#define  TIMER_TGOSEL_CH5D_POS  4U
#define  TIMER_TGOSEL_CH5D_MSK  BIT(TIMER_TGOSEL_CH5D_POS)
#define  TIMER_TGOSEL_CH5D      TIMER_TGOSEL_CH5D_MSK

#define  TIMER_TGOSEL_CH4D_POS  3U
#define  TIMER_TGOSEL_CH4D_MSK  BIT(TIMER_TGOSEL_CH4D_POS)
#define  TIMER_TGOSEL_CH4D      TIMER_TGOSEL_CH4D_MSK

#define  TIMER_TGOSEL_CH3D_POS  2U
#define  TIMER_TGOSEL_CH3D_MSK  BIT(TIMER_TGOSEL_CH3D_POS)
#define  TIMER_TGOSEL_CH3D      TIMER_TGOSEL_CH3D_MSK

#define  TIMER_TGOSEL_CH2D_POS  1U
#define  TIMER_TGOSEL_CH2D_MSK  BIT(TIMER_TGOSEL_CH2D_POS)
#define  TIMER_TGOSEL_CH2D      TIMER_TGOSEL_CH2D_MSK

#define  TIMER_TGOSEL_CH1D_POS  0U
#define  TIMER_TGOSEL_CH1D_MSK  BIT(TIMER_TGOSEL_CH1D_POS)
#define  TIMER_TGOSEL_CH1D      TIMER_TGOSEL_CH1D_MSK

/****************** Bit definition for TIMER_CHRMP register ************************/

#define TIMER_CHRMP_CH4NRMP_POSS 28U
#define TIMER_CHRMP_CH4NRMP_POSE 31U
#define TIMER_CHRMP_CH4NRMP_MSK  BITS(TIMER_CHRMP_CH4NRMP_POSS, TIMER_CHRMP_CH4NRMP_POSE)
#define TIMER_CHRMP_CH4NRMP      TIMER_CHRMP_CH4NRMP_MSK

#define TIMER_CHRMP_CH3NRMP_POSS 24U
#define TIMER_CHRMP_CH3NRMP_POSE 27U
#define TIMER_CHRMP_CH3NRMP_MSK  BITS(TIMER_CHRMP_CH3NRMP_POSS, TIMER_CHRMP_CH3NRMP_POSE)
#define TIMER_CHRMP_CH3NRMP      TIMER_CHRMP_CH3NRMP_MSK

#define TIMER_CHRMP_CH2NRMP_POSS 20U
#define TIMER_CHRMP_CH2NRMP_POSE 23U
#define TIMER_CHRMP_CH2NRMP_MSK  BITS(TIMER_CHRMP_CH2NRMP_POSS, TIMER_CHRMP_CH2NRMP_POSE)
#define TIMER_CHRMP_CH2NRMP      TIMER_CHRMP_CH2NRMP_MSK

#define TIMER_CHRMP_CH1NRMP_POSS 16U
#define TIMER_CHRMP_CH1NRMP_POSE 19U
#define TIMER_CHRMP_CH1NRMP_MSK  BITS(TIMER_CHRMP_CH1NRMP_POSS, TIMER_CHRMP_CH1NRMP_POSE)
#define TIMER_CHRMP_CH1NRMP      TIMER_CHRMP_CH1NRMP_MSK

#define TIMER_CHRMP_CH4RMP_POSS 12U
#define TIMER_CHRMP_CH4RMP_POSE 15U
#define TIMER_CHRMP_CH4RMP_MSK  BITS(TIMER_CHRMP_CH4RMP_POSS, TIMER_CHRMP_CH4RMP_POSE)
#define TIMER_CHRMP_CH4RMP      TIMER_CHRMP_CH4RMP_MSK

#define TIMER_CHRMP_CH3RMP_POSS 8U
#define TIMER_CHRMP_CH3RMP_POSE 11U
#define TIMER_CHRMP_CH3RMP_MSK  BITS(TIMER_CHRMP_CH3RMP_POSS, TIMER_CHRMP_CH3RMP_POSE)
#define TIMER_CHRMP_CH3RMP      TIMER_CHRMP_CH3RMP_MSK

#define TIMER_CHRMP_CH2RMP_POSS 4U
#define TIMER_CHRMP_CH2RMP_POSE 7U
#define TIMER_CHRMP_CH2RMP_MSK  BITS(TIMER_CHRMP_CH2RMP_POSS, TIMER_CHRMP_CH2RMP_POSE)
#define TIMER_CHRMP_CH2RMP      TIMER_CHRMP_CH2RMP_MSK

#define TIMER_CHRMP_CH1RMP_POSS 0U
#define TIMER_CHRMP_CH1RMP_POSE 3U
#define TIMER_CHRMP_CH1RMP_MSK  BITS(TIMER_CHRMP_CH1RMP_POSS, TIMER_CHRMP_CH1RMP_POSE)
#define TIMER_CHRMP_CH1RMP      TIMER_CHRMP_CH1RMP_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CON1;                // 0x000
    __IO uint32_t CON2;                // 0x004
    __IO uint32_t SMCON;               // 0x008
    __O  uint32_t IER;                 // 0x00c
    __O  uint32_t IDR;                 // 0x010
    __I  uint32_t IVS;                 // 0x014
    __I  uint32_t RIF;                 // 0x018
    __I  uint32_t IFM;                 // 0x01c
    __O  uint32_t ICR;                 // 0x020
    __O  uint32_t SGE;                 // 0x024
    __IO uint32_t CHMR1;               // 0x028
    __IO uint32_t CHMR2;               // 0x02c
    __IO uint32_t CCEP;                // 0x030
    __IO uint32_t COUNT;               // 0x034
    __IO uint32_t PRES;                // 0x038
    __IO uint32_t AR;                  // 0x03c
    __IO uint32_t REPAR;               // 0x040
    __IO uint32_t CCVAL1;              // 0x044
    __IO uint32_t CCVAL2;              // 0x048
    __IO uint32_t CCVAL3;              // 0x04c
    __IO uint32_t CCVAL4;              // 0x050
    __IO uint32_t BDCFG;               // 0x054
    __IO uint32_t DMAEN;               // 0x058
    __IO uint32_t CCVAL5;              // 0x05c
    __IO uint32_t CCVAL6;              // 0x060
    __IO uint32_t CHMR3;               // 0x064
    __IO uint32_t DCFG2;               // 0x068
    __IO uint32_t ENCR;                // 0x06C
    __IO uint32_t CHISEL;              // 0x070
    __IO uint32_t AFR1;                // 0x074
    __IO uint32_t AFR2;                // 0x078
    __IO uint32_t TGOSEL;              // 0x07C
    __IO uint32_t CHRMP;               // 0x080
} TIMER_TypeDef;

#endif /* __REG_TIMER_H__ */
