/**********************************************************************************
 *
 * @file    reg_syscfg.h
 * @brief   SYSCFG Head File
 *
 * @date    6 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Apr 2023      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_SYSCFG_H__
#define __REG_SYSCFG_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for SYSCFG_REMAP register ************************/

# define  SYSCFG_REMAP_REALBASE_POSS 13U
# define  SYSCFG_REMAP_REALBASE_POSE 19U
# define  SYSCFG_REMAP_REALBASE_MSK  BITS(SYSCFG_REMAP_REALBASE_POSS, SYSCFG_REMAP_REALBASE_POSE)
# define  SYSCFG_REMAP_REALBASE      SYSCFG_REMAP_REALBASE_MSK

# define  SYSCFG_REMAP_REALMOD_POSS 11U
# define  SYSCFG_REMAP_REALMOD_POSE 12U
# define  SYSCFG_REMAP_REALMOD_MSK  BITS(SYSCFG_REMAP_REALMOD_POSS, SYSCFG_REMAP_REALMOD_POSE)
# define  SYSCFG_REMAP_REALMOD      SYSCFG_REMAP_REALMOD_MSK

# define  SYSCFG_REMAP_EFBASE_POSS 4U
# define  SYSCFG_REMAP_EFBASE_POSE 10U
# define  SYSCFG_REMAP_EFBASE_MSK  BITS(SYSCFG_REMAP_EFBASE_POSS, SYSCFG_REMAP_EFBASE_POSE)
# define  SYSCFG_REMAP_EFBASE      SYSCFG_REMAP_EFBASE_MSK

# define  SYSCFG_REMAP_MEMMOD_POSS 2U
# define  SYSCFG_REMAP_MEMMOD_POSE 3U
# define  SYSCFG_REMAP_MEMMOD_MSK  BITS(SYSCFG_REMAP_MEMMOD_POSS, SYSCFG_REMAP_MEMMOD_POSE)
# define  SYSCFG_REMAP_MEMMOD      SYSCFG_REMAP_MEMMOD_MSK

# define  SYSCFG_REMAP_REMAP_POS 0U
# define  SYSCFG_REMAP_REMAP_MSK BIT(SYSCFG_REMAP_REMAP_POS)
# define  SYSCFG_REMAP_REMAP     SYSCFG_REMAP_REMAP_MSK

/****************** Bit definition for SYSCFG_SYSTRIM register ************************/

# define  SYSCFG_SYSTRIM_LRCTRIM_POSS 12U
# define  SYSCFG_SYSTRIM_LRCTRIM_POSE 18U
# define  SYSCFG_SYSTRIM_LRCTRIM_MSK  BITS(SYSCFG_SYSTRIM_LRCTRIM_POSS, SYSCFG_SYSTRIM_LRCTRIM_POSE)
# define  SYSCFG_SYSTRIM_LRCTRIM      SYSCFG_SYSTRIM_LRCTRIM_MSK

# define  SYSCFG_SYSTRIM_LVDTRIM_POSS 8U
# define  SYSCFG_SYSTRIM_LVDTRIM_POSE 9U
# define  SYSCFG_SYSTRIM_LVDTRIM_MSK  BITS(SYSCFG_SYSTRIM_LVDTRIM_POSS, SYSCFG_SYSTRIM_LVDTRIM_POSE)
# define  SYSCFG_SYSTRIM_LVDTRIM      SYSCFG_SYSTRIM_LVDTRIM_MSK

# define  SYSCFG_SYSTRIM_BG1VTRIM_POSS 4U
# define  SYSCFG_SYSTRIM_BG1VTRIM_POSE 7U
# define  SYSCFG_SYSTRIM_BG1VTRIM_MSK  BITS(SYSCFG_SYSTRIM_BG1VTRIM_POSS, SYSCFG_SYSTRIM_BG1VTRIM_POSE)
# define  SYSCFG_SYSTRIM_BG1VTRIM      SYSCFG_SYSTRIM_BG1VTRIM_MSK


# define  SYSCFG_SYSTRIM_BG1V2TRIM_POSS 0U
# define  SYSCFG_SYSTRIM_BG1V2TRIM_POSE 3U
# define  SYSCFG_SYSTRIM_BG1V2TRIM_MSK  BITS(SYSCFG_SYSTRIM_BG1V2TRIM_POSS, SYSCFG_SYSTRIM_BG1V2TRIM_POSE)
# define  SYSCFG_SYSTRIM_BG1V2TRIM      SYSCFG_SYSTRIM_BG1V2TRIM_MSK

/****************** Bit definition for SYSCFG_CLKTRIM1 register ************************/

# define  SYSCFG_CLKTRIM1_HRC16MTRIMH_POSS 16U
# define  SYSCFG_CLKTRIM1_HRC16MTRIMH_POSE 31U
# define  SYSCFG_CLKTRIM1_HRC16MTRIMH_MSK  BITS(SYSCFG_CLKTRIM1_HRC16MTRIMH_POSS, SYSCFG_CLKTRIM1_HRC16MTRIMH_POSE)
# define  SYSCFG_CLKTRIM1_HRC16MTRIMH      SYSCFG_CLKTRIM1_HRC16MTRIMH_MSK

/****************** Bit definition for SYSCFG_OSCTRIM register ************************/

# define  SYSCFG_OSCTRIM_HOSCRCNT_POSS 4U
# define  SYSCFG_OSCTRIM_HOSCRCNT_POSE 6U
# define  SYSCFG_OSCTRIM_HOSCRCNT_MSK  BITS(SYSCFG_OSCTRIM_HOSCRCNT_POSS, SYSCFG_OSCTRIM_HOSCRCNT_POSE)
# define  SYSCFG_OSCTRIM_HOSCRCNT      SYSCFG_OSCTRIM_HOSCRCNT_MSK

# define  SYSCFG_OSCTRIM_HOSCCURSEL_POSS 0U
# define  SYSCFG_OSCTRIM_HOSCCURSEL_POSE 1U
# define  SYSCFG_OSCTRIM_HOSCCURSEL_MSK  BITS(SYSCFG_OSCTRIM_HOSCCURSEL_POSS, SYSCFG_OSCTRIM_HOSCCURSEL_POSE)
# define  SYSCFG_OSCTRIM_HOSCCURSEL      SYSCFG_OSCTRIM_HOSCCURSEL_MSK

/****************** Bit definition for SYSCFG_CMPTRIM register ************************/

# define  SYSCFG_CMPTRIM_CMP1PTRIM_POSS 24U
# define  SYSCFG_CMPTRIM_CMP1PTRIM_POSE 28U
# define  SYSCFG_CMPTRIM_CMP1PTRIM_MSK  BITS(SYSCFG_CMPTRIM_CMP1PTRIM_POSS, SYSCFG_CMPTRIM_CMP1PTRIM_POSE)
# define  SYSCFG_CMPTRIM_CMP1PTRIM      SYSCFG_CMPTRIM_CMP1PTRIM_MSK

# define  SYSCFG_CMPTRIM_CMP1NTRIM_POSS 16U
# define  SYSCFG_CMPTRIM_CMP1NTRIM_POSE 20U
# define  SYSCFG_CMPTRIM_CMP1NTRIM_MSK  BITS(SYSCFG_CMPTRIM_CMP1NTRIM_POSS, SYSCFG_CMPTRIM_CMP1NTRIM_POSE)
# define  SYSCFG_CMPTRIM_CMP1NTRIM      SYSCFG_CMPTRIM_CMP1NTRIM_MSK

# define  SYSCFG_CMPTRIM_CMP2PTRIM_POSS 8U
# define  SYSCFG_CMPTRIM_CMP2PTRIM_POSE 12U
# define  SYSCFG_CMPTRIM_CMP2PTRIM_MSK  BITS(SYSCFG_CMPTRIM_CMP2PTRIM_POSS, SYSCFG_CMPTRIM_CMP2PTRIM_POSE)
# define  SYSCFG_CMPTRIM_CMP2PTRIM      SYSCFG_CMPTRIM_CMP2PTRIM_MSK

# define  SYSCFG_CMPTRIM_CMP2NTRIM_POSS 0U
# define  SYSCFG_CMPTRIM_CMP2NTRIM_POSE 4U
# define  SYSCFG_CMPTRIM_CMP2NTRIM_MSK  BITS(SYSCFG_CMPTRIM_CMP2NTRIM_POSS, SYSCFG_CMPTRIM_CMP2NTRIM_POSE)
# define  SYSCFG_CMPTRIM_CMP2NTRIM      SYSCFG_CMPTRIM_CMP2NTRIM_MSK

/****************** Bit definition for SYSCFG_OPATRIM1 register ************************/

# define  SYSCFG_OPATRIM1_OPA1PTRIM_POSS 24U
# define  SYSCFG_OPATRIM1_OPA1PTRIM_POSE 28U
# define  SYSCFG_OPATRIM1_OPA1PTRIM_MSK  BITS(SYSCFG_OPATRIM1_OPA1PTRIM_POSS, SYSCFG_OPATRIM1_OPA1PTRIM_POSE)
# define  SYSCFG_OPATRIM1_OPA1PTRIM      SYSCFG_OPATRIM1_OPA1PTRIM_MSK

# define  SYSCFG_OPATRIM1_OPA1NTRIM_POSS 16U
# define  SYSCFG_OPATRIM1_OPA1NTRIM_POSE 20U
# define  SYSCFG_OPATRIM1_OPA1NTRIM_MSK  BITS(SYSCFG_OPATRIM1_OPA1NTRIM_POSS, SYSCFG_OPATRIM1_OPA1NTRIM_POSE)
# define  SYSCFG_OPATRIM1_OPA1NTRIM      SYSCFG_OPATRIM1_OPA1NTRIM_MSK

# define  SYSCFG_OPATRIM1_OPA2PTRIM_POSS 8U
# define  SYSCFG_OPATRIM1_OPA2PTRIM_POSE 12U
# define  SYSCFG_OPATRIM1_OPA2PTRIM_MSK  BITS(SYSCFG_OPATRIM1_OPA2PTRIM_POSS, SYSCFG_OPATRIM1_OPA2PTRIM_POSE)
# define  SYSCFG_OPATRIM1_OPA2PTRIM      SYSCFG_OPATRIM1_OPA2PTRIM_MSK

# define  SYSCFG_OPATRIM1_OPA2NTRIM_POSS 0U
# define  SYSCFG_OPATRIM1_OPA2NTRIM_POSE 4U
# define  SYSCFG_OPATRIM1_OPA2NTRIM_MSK  BITS(SYSCFG_OPATRIM1_OPA2NTRIM_POSS, SYSCFG_OPATRIM1_OPA2NTRIM_POSE)
# define  SYSCFG_OPATRIM1_OPA2NTRIM      SYSCFG_OPATRIM1_OPA2NTRIM_MSK

/****************** Bit definition for SYSCFG_OPATRIM2 register ************************/

# define  SYSCFG_OPATRIM2_OPA3PTRIM_POSS 24U
# define  SYSCFG_OPATRIM2_OPA3PTRIM_POSE 28U
# define  SYSCFG_OPATRIM2_OPA3PTRIM_MSK  BITS(SYSCFG_OPATRIM2_OPA3PTRIM_POSS, SYSCFG_OPATRIM2_OPA3PTRIM_POSE)
# define  SYSCFG_OPATRIM2_OPA3PTRIM      SYSCFG_OPATRIM2_OPA3PTRIM_MSK

# define  SYSCFG_OPATRIM2_OPA3NTRIM_POSS 16U
# define  SYSCFG_OPATRIM2_OPA3NTRIM_POSE 20U
# define  SYSCFG_OPATRIM2_OPA3NTRIM_MSK  BITS(SYSCFG_OPATRIM2_OPA3NTRIM_POSS, SYSCFG_OPATRIM2_OPA3NTRIM_POSE)
# define  SYSCFG_OPATRIM2_OPA3NTRIM      SYSCFG_OPATRIM2_OPA3NTRIM_MSK

# define  SYSCFG_OPATRIM2_OPA4PTRIM_POSS 8U
# define  SYSCFG_OPATRIM2_OPA4PTRIM_POSE 12U
# define  SYSCFG_OPATRIM2_OPA4PTRIM_MSK  BITS(SYSCFG_OPATRIM2_OPA4PTRIM_POSS, SYSCFG_OPATRIM2_OPA4PTRIM_POSE)
# define  SYSCFG_OPATRIM2_OPA4PTRIM      SYSCFG_OPATRIM2_OPA4PTRIM_MSK

# define  SYSCFG_OPATRIM2_OPA4NTRIM_POSS 0U
# define  SYSCFG_OPATRIM2_OPA4NTRIM_POSE 4U
# define  SYSCFG_OPATRIM2_OPA4NTRIM_MSK  BITS(SYSCFG_OPATRIM2_OPA4NTRIM_POSS, SYSCFG_OPATRIM2_OPA4NTRIM_POSE)
# define  SYSCFG_OPATRIM2_OPA4NTRIM      SYSCFG_OPATRIM2_OPA4NTRIM_MSK

/****************** Bit definition for SYSCFG_ADCVREF register ************************/

# define  SYSCFG_ADCVREF_ADCVREF_POSS 0U
# define  SYSCFG_ADCVREF_ADCVREF_POSE 11U
# define  SYSCFG_ADCVREF_ADCVREF_MSK  BITS(SYSCFG_ADCVREF_ADCVREF_POSS, SYSCFG_ADCVREF_ADCVREF_POSE)
# define  SYSCFG_ADCVREF_ADCVREF      SYSCFG_ADCVREF_ADCVREF_MSK

/****************** Bit definition for SYSCFG_ADCTEMP register ************************/

# define  SYSCFG_ADCTEMP_ADCTEMPH_POSS 16U
# define  SYSCFG_ADCTEMP_ADCTEMPH_POSE 27U
# define  SYSCFG_ADCTEMP_ADCTEMPH_MSK  BITS(SYSCFG_ADCTEMP_ADCTEMPH_POSS, SYSCFG_ADCTEMP_ADCTEMPH_POSE)
# define  SYSCFG_ADCTEMP_ADCTEMPH      SYSCFG_ADCTEMP_ADCTEMPH_MSK

# define  SYSCFG_ADCTEMP_ADCTEMPL_POSS 0U
# define  SYSCFG_ADCTEMP_ADCTEMPL_POSE 11U
# define  SYSCFG_ADCTEMP_ADCTEMPL_MSK  BITS(SYSCFG_ADCTEMP_ADCTEMPL_POSS, SYSCFG_ADCTEMP_ADCTEMPL_POSE)
# define  SYSCFG_ADCTEMP_ADCTEMPL      SYSCFG_ADCTEMP_ADCTEMPL_MSK

/****************** Bit definition for SYSCFG_MEMMOD register ************************/

# define  SYSCFG_MEMMOD_SMOD_POSS 16U
# define  SYSCFG_MEMMOD_SMOD_POSE 23U
# define  SYSCFG_MEMMOD_SMOD_MSK  BITS(SYSCFG_MEMMOD_SMOD_POSS, SYSCFG_MEMMOD_SMOD_POSE)
# define  SYSCFG_MEMMOD_SMOD      SYSCFG_MEMMOD_SMOD_MSK

# define  SYSCFG_MEMMOD_FMOD_POSS 0U
# define  SYSCFG_MEMMOD_FMOD_POSE 8U
# define  SYSCFG_MEMMOD_FMOD_MSK  BITS(SYSCFG_MEMMOD_FMOD_POSS, SYSCFG_MEMMOD_FMOD_POSE)
# define  SYSCFG_MEMMOD_FMOD      SYSCFG_MEMMOD_FMOD_MSK

/****************** Bit definition for SYSCFG_SYSSET register ************************/

# define  SYSCFG_SYSSET_SYS_IWDTEN_POSS 16U
# define  SYSCFG_SYSSET_SYS_IWDTEN_POSE 23U
# define  SYSCFG_SYSSET_SYS_IWDTEN_MSK  BITS(SYSCFG_SYSSET_SYS_IWDTEN_POSS, SYSCFG_SYSSET_SYS_IWDTEN_POSE)
# define  SYSCFG_SYSSET_SYS_IWDTEN      SYSCFG_SYSSET_SYS_IWDTEN_MSK

# define  SYSCFG_SYSSET_SYS_BOREN_POSS 8U
# define  SYSCFG_SYSSET_SYS_BOREN_POSE 15U
# define  SYSCFG_SYSSET_SYS_BOREN_MSK  BITS(SYSCFG_SYSSET_SYS_BOREN_POSS, SYSCFG_SYSSET_SYS_BOREN_POSE)
# define  SYSCFG_SYSSET_SYS_BOREN      SYSCFG_SYSSET_SYS_BOREN_MSK

# define  SYSCFG_SYSSET_SYS_BORLS_POSS 0U
# define  SYSCFG_SYSSET_SYS_BORLS_POSE 2U
# define  SYSCFG_SYSSET_SYS_BORLS_MSK  BITS(SYSCFG_SYSSET_SYS_BORLS_POSS, SYSCFG_SYSSET_SYS_BORLS_POSE)
# define  SYSCFG_SYSSET_SYS_BORLS      SYSCFG_SYSSET_SYS_BORLS_MSK

/****************** Bit definition for SYSCFG_APWR register ************************/

# define  SYSCFG_APWR_VREFINT_EN_POS 2U
# define  SYSCFG_APWR_VREFINT_EN_MSK BIT(SYSCFG_APWR_VREFINT_EN_POS)
# define  SYSCFG_APWR_VREFINT_EN      SYSCFG_APWR_VREFINT_EN_MSK

# define  SYSCFG_APWR_VTSENSE_EN_POS 1U
# define  SYSCFG_APWR_VTSENSE_EN_MSK BIT(SYSCFG_APWR_VTSENSE_EN_POS)
# define  SYSCFG_APWR_VTSENSE_EN      SYSCFG_APWR_VTSENSE_EN_MSK

# define  SYSCFG_APWR_VDDA_PWREN_POS 0U
# define  SYSCFG_APWR_VDDA_PWREN_MSK BIT(SYSCFG_APWR_VDDA_PWREN_POS)
# define  SYSCFG_APWR_VDDA_PWREN      SYSCFG_APWR_VDDA_PWREN_MSK

/****************** Bit definition for SYSCFG_CFG register ************************/

# define  SYSCFG_CFG_DBGHEN_POSS 16U
# define  SYSCFG_CFG_DBGHEN_POSE 31U
# define  SYSCFG_CFG_DBGHEN_MSK  BITS(SYSCFG_CFG_DBGHEN_POSS, SYSCFG_CFG_DBGHEN_POSE)
# define  SYSCFG_CFG_DBGHEN      SYSCFG_CFG_DBGHEN_MSK

# define  SYSCFG_CFG_LVDLCK_POS 14U
# define  SYSCFG_CFG_LVDLCK_MSK BIT(SYSCFG_CFG_LVDLCK_POS)
# define  SYSCFG_CFG_LVDLCK     SYSCFG_CFG_LVDLCK_MSK

# define  SYSCFG_CFG_CSSLCK_POS 13U
# define  SYSCFG_CFG_CSSLCK_MSK BIT(SYSCFG_CFG_CSSLCK_POS)
# define  SYSCFG_CFG_CSSLCK     SYSCFG_CFG_CSSLCK_MSK

# define  SYSCFG_CFG_CPULCK_POS 12U
# define  SYSCFG_CFG_CPULCK_MSK BIT(SYSCFG_CFG_CPULCK_POS)
# define  SYSCFG_CFG_CPULCK     SYSCFG_CFG_CPULCK_MSK

# define  SYSCFG_CFG_BKREADY_POS 0U
# define  SYSCFG_CFG_BKREADY_MSK BIT(SYSCFG_CFG_BKREADY_POS)
# define  SYSCFG_CFG_BKREADY     SYSCFG_CFG_BKREADY_MSK

/****************** Bit definition for SYSCFG_PWRCON register ************************/

# define  SYSCFG_PWRCON_IWDTEN_POSS 15U
# define  SYSCFG_PWRCON_IWDTEN_MSK  BIT(SYSCFG_PWRCON_IWDTEN_POSS)
# define  SYSCFG_PWRCON_IWDTEN      SYSCFG_PWRCON_IWDTEN_MSK

# define  SYSCFG_PWRCON_BOREN_POSS 11U
# define  SYSCFG_PWRCON_BOREN_MSK  BIT(SYSCFG_PWRCON_BOREN_POSS)
# define  SYSCFG_PWRCON_BOREN      SYSCFG_PWRCON_BOREN_MSK

# define  SYSCFG_PWRCON_BORLS_POSS 8U
# define  SYSCFG_PWRCON_BORLS_POSE 10U
# define  SYSCFG_PWRCON_BORLS_MSK  BITS(SYSCFG_PWRCON_BORLS_POSS, SYSCFG_PWRCON_BORLS_POSE)
# define  SYSCFG_PWRCON_BORLS      SYSCFG_PWRCON_BORLS_MSK

# define  SYSCFG_PWRCON_LVDEN_POS 4U
# define  SYSCFG_PWRCON_LVDEN_MSK BIT(SYSCFG_PWRCON_LVDEN_POS)
# define  SYSCFG_PWRCON_LVDEN     SYSCFG_PWRCON_LVDEN_MSK

# define  SYSCFG_PWRCON_LVDLS_POSS 0U
# define  SYSCFG_PWRCON_LVDLS_POSE 3U
# define  SYSCFG_PWRCON_LVDLS_MSK  BITS(SYSCFG_PWRCON_LVDLS_POSS, SYSCFG_PWRCON_LVDLS_POSE)
# define  SYSCFG_PWRCON_LVDLS      SYSCFG_PWRCON_LVDLS_MSK

/****************** Bit definition for SYSCFG_WKTRIM register ************************/

# define  SYSCFG_WKTRIM_LVDTRIM_POSS 30U
# define  SYSCFG_WKTRIM_LVDTRIM_POSE 31U
# define  SYSCFG_WKTRIM_LVDTRIM_MSK  BITS(SYSCFG_WKTRIM_LVDTRIM_POSS, SYSCFG_WKTRIM_LVDTRIM_POSE)
# define  SYSCFG_WKTRIM_LVDTRIM      SYSCFG_WKTRIM_LVDTRIM_MSK

# define  SYSCFG_WKTRIM_LRCTRIM_POSS 16U
# define  SYSCFG_WKTRIM_LRCTRIM_POSE 22U
# define  SYSCFG_WKTRIM_LRCTRIM_MSK  BITS(SYSCFG_WKTRIM_LRCTRIM_POSS, SYSCFG_WKTRIM_LRCTRIM_POSE)
# define  SYSCFG_WKTRIM_LRCTRIM      SYSCFG_WKTRIM_LRCTRIM_MSK

# define  SYSCFG_WKTRIM_BG1V2TRIM_POSS 4U
# define  SYSCFG_WKTRIM_BG1V2TRIM_POSE 7U
# define  SYSCFG_WKTRIM_BG1V2TRIM_MSK  BITS(SYSCFG_WKTRIM_BG1V2TRIM_POSS, SYSCFG_WKTRIM_BG1V2TRIM_POSE)
# define  SYSCFG_WKTRIM_BG1V2TRIM      SYSCFG_WKTRIM_BG1V2TRIM_MSK

# define  SYSCFG_WKTRIM_BG1VTRIM_POSS 0U
# define  SYSCFG_WKTRIM_BG1VTRIM_POSE 3U
# define  SYSCFG_WKTRIM_BG1VTRIM_MSK  BITS(SYSCFG_WKTRIM_BG1VTRIM_POSS, SYSCFG_WKTRIM_BG1VTRIM_POSE)
# define  SYSCFG_WKTRIM_BG1VTRIM      SYSCFG_WKTRIM_BG1VTRIM_MSK

/****************** Bit definition for SYSCFG_WKUP register ************************/

# define  SYSCFG_WKUP_WKEG_POSS 16U
# define  SYSCFG_WKUP_WKEG_POSE 31U
# define  SYSCFG_WKUP_WKEG_MSK  BITS(SYSCFG_WKUP_WKEG_POSS, SYSCFG_WKUP_WKEG_POSE)
# define  SYSCFG_WKUP_WKEG      SYSCFG_WKUP_WKEG_MSK

# define  SYSCFG_WKUP_WKEN_POSS 0U
# define  SYSCFG_WKUP_WKEN_POSE 15U
# define  SYSCFG_WKUP_WKEN_MSK  BITS(SYSCFG_WKUP_WKEN_POSS, SYSCFG_WKUP_WKEN_POSE)
# define  SYSCFG_WKUP_WKEN      SYSCFG_WKUP_WKEN_MSK

/****************** Bit definition for SYSCFG_WKSR register ************************/

# define  SYSCFG_WKSR_WKCLR_POSS 31U
# define  SYSCFG_WKSR_WKCLR_MSK  BIT(SYSCFG_WKSR_WKCLR_POSS)
# define  SYSCFG_WKSR_WKCLR      SYSCFG_WKSR_WKCLR_MSK

# define  SYSCFG_WKSR_LPLS_POSS 28U
# define  SYSCFG_WKSR_LPLS_POSE 29U
# define  SYSCFG_WKSR_LPLS_MSK  BITS(SYSCFG_WKSR_LPLS_POSS, SYSCFG_WKSR_LPLS_POSE)
# define  SYSCFG_WKSR_LPLS      SYSCFG_WKSR_LPLS_MSK

# define  SYSCFG_WKSR_LPVSEL_POSS 26U
# define  SYSCFG_WKSR_LPVSEL_POSE 27U
# define  SYSCFG_WKSR_LPVSEL_MSK  BITS(SYSCFG_WKSR_LPLS_POSS, SYSCFG_WKSR_LPLS_POSE)
# define  SYSCFG_WKSR_LPVSEL      SYSCFG_WKSR_LPLS_MSK

# define  SYSCFG_WKSR_FLAG_POSS 16U
# define  SYSCFG_WKSR_FLAG_MSK  BIT(SYSCFG_WKSR_FLAG_POSS)
# define  SYSCFG_WKSR_FLAG      SYSCFG_WKSR_FLAG_MSK

# define  SYSCFG_WKSR_FG_POSS 0U
# define  SYSCFG_WKSR_FG_POSE 15U
# define  SYSCFG_WKSR_FG_MSK  BITS(SYSCFG_WKSR_FG_POSS, SYSCFG_WKSR_FG_POSE)
# define  SYSCFG_WKSR_FG      SYSCFG_WKSR_FG_MSK

/****************** Bit definition for SYSCFG_BKREG0 register ************************/

# define  SYSCFG_BKREG0_BKREG0_POSS 0U
# define  SYSCFG_BKREG0_BKREG0_POSE 31U
# define  SYSCFG_BKREG0_BKREG0_MSK  BITS(SYSCFG_BKREG0_BKREG0_POSS, SYSCFG_BKREG0_BKREG0_POSE)
# define  SYSCFG_BKREG0_BKREG0      SYSCFG_BKREG0_BKREG0_MSK

/****************** Bit definition for SYSCFG_BKREG1 register ************************/

# define  SYSCFG_BKREG1_BKREG1_POSS 0U
# define  SYSCFG_BKREG1_BKREG1_POSE 31U
# define  SYSCFG_BKREG1_BKREG1_MSK  BITS(SYSCFG_BKREG1_BKREG1_POSS, SYSCFG_BKREG1_BKREG1_POSE)
# define  SYSCFG_BKREG1_BKREG1      SYSCFG_BKREG1_BKREG1_MSK

/****************** Bit definition for SYSCFG_BKREG2 register ************************/

# define  SYSCFG_BKREG2_BKREG2_POSS 0U
# define  SYSCFG_BKREG2_BKREG2_POSE 31U
# define  SYSCFG_BKREG2_BKREG2_MSK  BITS(SYSCFG_BKREG2_BKREG2_POSS, SYSCFG_BKREG2_BKREG2_POSE)
# define  SYSCFG_BKREG2_BKREG2      SYSCFG_BKREG2_BKREG2_MSK

/****************** Bit definition for SYSCFG_BKREG3 register ************************/

# define  SYSCFG_BKREG3_BKREG3_POSS 0U
# define  SYSCFG_BKREG3_BKREG3_POSE 31U
# define  SYSCFG_BKREG3_BKREG3_MSK  BITS(SYSCFG_BKREG3_BKREG3_POSS, SYSCFG_BKREG3_BKREG3_POSE)
# define  SYSCFG_BKREG3_BKREG3      SYSCFG_BKREG3_BKREG3_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t REMAP;                    // 0x000
    __IO uint32_t RESERVED0[2];             // 0x004-0x008
    __I  uint32_t SYSTRIM;                  // 0x000c
    __I  uint32_t CLKTRIM1;                 // 0x010
    __IO uint32_t RESERVED1;                // 0x014    
    __I  uint32_t OSCTRIM;                  // 0x018
    __I  uint32_t CMPTRIM;                  // 0x01c
    __I  uint32_t OPATRIM1;                 // 0x020
    __I  uint32_t OPATRIM2;                 // 0x024
    __I  uint32_t ADCVREF;                  // 0x028
    __I  uint32_t ADCTEMP;                  // 0x02c
    __I  uint32_t MEMMOD;                   // 0x030    
    __I  uint32_t SYSSET;                   // 0x034
    __IO uint32_t APWR;                     // 0x038
    __IO uint32_t CFG;                      // 0x03c
    __IO uint32_t PWRCON;                   // 0x040
    __I  uint32_t WKTRIM;                   // 0x044
    __IO uint32_t WKUP;                     // 0x048
    __IO uint32_t WKSR;                     // 0x04c
    __IO uint32_t BKREG0;                   // 0x050
    __IO uint32_t BKREG1;                   // 0x054
    __IO uint32_t BKREG2;                   // 0x058
    __IO uint32_t BKREG3;                   // 0x05c
} SYSCFG_TypeDef;


#endif /* __REG_SYSCFG_H__ */
