/**********************************************************************************
 *
 * @file    reg_sva.h
 * @brief   SVA Head File
 *
 * @date    31 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          31 Mar 2023     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_SVA_H__
#define __REG_SVA_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/****************** Bit definition for SVA_IER register ************************/

# define	SVA_IER_DONE_POS 0U 
# define	SVA_IER_DONE_MSK BIT(SVA_IER_DONE_POS) 
# define	SVA_IER_DONE     SVA_IER_DONE_MSK

/****************** Bit definition for SVA_IDR register ************************/

# define	SVA_IDR_DONE_POS 0U 
# define	SVA_IDR_DONE_MSK BIT(SVA_IDR_DONE_POS) 
# define	SVA_IDR_DONE     SVA_IDR_DONE_MSK

/****************** Bit definition for SVA_IVS register ************************/

# define	SVA_IVS_DONE_POS 0U 
# define	SVA_IVS_DONE_MSK BIT(SVA_IVS_DONE_POS) 
# define	SVA_IVS_DONE     SVA_IVS_DONE_MSK

/****************** Bit definition for SVA_RIF register ************************/

# define	SVA_RIF_DONE_POS 0U 
# define	SVA_RIF_DONE_MSK BIT(SVA_RIF_DONE_POS) 
# define	SVA_RIF_DONE     SVA_RIF_DONE_MSK

/****************** Bit definition for SVA_IFM register ************************/

# define	SVA_IFM_DONE_POS 0U 
# define	SVA_IFM_DONE_MSK BIT(SVA_IFM_DONE_POS) 
# define	SVA_IFM_DONE     SVA_IFM_DONE_MSK

/****************** Bit definition for SVA_ICR register ************************/

# define	SVA_ICR_DONE_POS 0U 
# define	SVA_ICR_DONE_MSK BIT(SVA_ICR_DONE_POS) 
# define	SVA_ICR_DONE     SVA_ICR_DONE_MSK

/****************** Bit definition for SVA_INDATA0 register ************************/

# define	SVA_INDATA0_INDATA0_POSS 0U 
# define	SVA_INDATA0_INDATA0_POSE 15U 
# define	SVA_INDATA0_INDATA0_MSK  BITS(SVA_INDATA0_INDATA0_POSS, SVA_INDATA0_INDATA0_POSE) 
# define	SVA_INDATA0_INDATA0      SVA_INDATA0_INDATA0_MSK

/****************** Bit definition for SVA_INDATA1 register ************************/

# define	SVA_INDATA1_INDATA1_POSS 0U 
# define	SVA_INDATA1_INDATA1_POSE 15U 
# define	SVA_INDATA1_INDATA1_MSK  BITS(SVA_INDATA1_INDATA1_POSS, SVA_INDATA1_INDATA1_POSE) 
# define	SVA_INDATA1_INDATA1      SVA_INDATA1_INDATA1_MSK

/****************** Bit definition for SVA_INANGLE register ************************/

# define	SVA_INANGLE_INANGLE_POSS 0U 
# define	SVA_INANGLE_INANGLE_POSE 15U 
# define	SVA_INANGLE_INANGLE_MSK  BITS(SVA_INANGLE_INANGLE_POSS, SVA_INANGLE_INANGLE_POSE) 
# define	SVA_INANGLE_INANGLE      SVA_INANGLE_INANGLE_MSK

/****************** Bit definition for SVA_CTRL register ************************/

# define	SVA_CTRL_DMA_EN_POS  6U 
# define	SVA_CTRL_DMA_EN_MSK  BIT(SVA_CTRL_DMA_EN_POS) 
# define	SVA_CTRL_DMA_EN      SVA_CTRL_DMA_EN_MSK

# define	SVA_CTRL_OUTMUL_EN_POS 5U 
# define	SVA_CTRL_OUTMUL_EN_MSK BIT(SVA_CTRL_OUTMUL_EN_POS) 
# define	SVA_CTRL_OUTMUL_EN     SVA_CTRL_OUTMUL_EN_MSK

# define	SVA_CTRL_EXCHAHGE_POS 4U 
# define	SVA_CTRL_EXCHAHGE_MSK BIT(SVA_CTRL_EXCHAHGE_POS) 
# define	SVA_CTRL_EXCHAHGE     SVA_CTRL_EXCHAHGE_MSK

# define	SVA_CTRL_OP_MODE_POSS 1U 
# define	SVA_CTRL_OP_MODE_POSE 3U 
# define	SVA_CTRL_OP_MODE_MSK  BITS(SVA_CTRL_OP_MODE_POSS, SVA_CTRL_OP_MODE_POSE) 
# define	SVA_CTRL_OP_MODE      SVA_CTRL_OP_MODE_MSK

# define	SVA_CTRL_STR_TRIG_POS 0U 
# define	SVA_CTRL_STR_TRIG_MSK BIT(SVA_CTRL_STR_TRIG_POS) 
# define	SVA_CTRL_STR_TRIG     SVA_CTRL_STR_TRIG_MSK

/****************** Bit definition for SVA_OTDATA0 register ************************/

# define	SVA_OTDATA0_OTDATA0_POSS 0U 
# define	SVA_OTDATA0_OTDATA0_POSE 15U 
# define	SVA_OTDATA0_OTDATA0_MSK  BITS(SVA_OTDATA0_OTDATA0_POSS, SVA_OTDATA0_OTDATA0_POSE) 
# define	SVA_OTDATA0_OTDATA0      SVA_OTDATA0_OTDATA0_MSK

/****************** Bit definition for SVA_OTDATA1 register ************************/

# define	SVA_OTDATA1_OTDATA1_POSS 0U 
# define	SVA_OTDATA1_OTDATA1_POSE 15U 
# define	SVA_OTDATA1_OTDATA1_MSK  BITS(SVA_OTDATA1_OTDATA1_POSS, SVA_OTDATA1_OTDATA1_POSE) 
# define	SVA_OTDATA1_OTDATA1      SVA_OTDATA1_OTDATA1_MSK

/****************** Bit definition for SVA_OTDATA2 register ************************/

# define	SVA_OTDATA2_OTDATA2_POSS 0U 
# define	SVA_OTDATA2_OTDATA2_POSE 15U 
# define	SVA_OTDATA2_OTDATA2_MSK  BITS(SVA_OTDATA2_OTDATA2_POSS, SVA_OTDATA2_OTDATA2_POSE) 
# define	SVA_OTDATA2_OTDATA2      SVA_OTDATA2_OTDATA2_MSK

/****************** Bit definition for SVA_STATUS register ************************/

# define	SVA_STATUS_SECTOR_FLAG_POSS 5U 
# define	SVA_STATUS_SECTOR_FLAG_POSE 7U 
# define	SVA_STATUS_SECTOR_FLAG_MSK  BITS(SVA_STATUS_SECTOR_FLAG_POSS, SVA_STATUS_SECTOR_FLAG_POSE) 
# define	SVA_STATUS_SECTOR_FLAG      SVA_STATUS_SECTOR_FLAG_MSK

# define	SVA_STATUS_OP_MODE_POSS 1U 
# define	SVA_STATUS_OP_MODE_POSE 4U 
# define	SVA_STATUS_OP_MODE_MSK  BITS(SVA_STATUS_OP_MODE_POSS, SVA_STATUS_OP_MODE_POSE) 
# define	SVA_STATUS_OP_MODE      SVA_STATUS_OP_MODE_MSK

# define	SVA_STATUS_BUSY_POS 0U 
# define	SVA_STATUS_BUSY_MSK  BIT(SVA_STATUS_BUSY_POS) 
# define	SVA_STATUS_BUSY      SVA_STATUS_BUSY_MSK

/****************** Bit definition for SVA_OUTMUL register ************************/

# define	SVA_OUTMUL_OUTMUL_POSS 0U 
# define	SVA_OUTMUL_OUTMUL_POSE 15U 
# define	SVA_OUTMUL_OUTMUL_MSK  BITS(SVA_OUTMUL_OUTMUL_POSS, SVA_OUTMUL_OUTMUL_POSE) 
# define	SVA_OUTMUL_OUTMUL      SVA_OUTMUL_OUTMUL_MSK

/****************** Bit definition for SVA_PWMTH register ************************/

# define	SVA_PWMTH_PWM_TH_POSS 0U 
# define	SVA_PWMTH_PWM_TH_POSE 15U 
# define	SVA_PWMTH_PWM_TH_MSK  BITS(SVA_PWMTH_PWM_TH_POSS, SVA_PWMTH_PWM_TH_POSE) 
# define	SVA_PWMTH_PWM_TH      SVA_PWMTH_PWM_TH_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __O  uint32_t IER        ; // 0x08
    __O  uint32_t IDR        ; // 0x0C
    __I  uint32_t IVS        ; // 0x10
    __I  uint32_t RIF        ; // 0x14
    __I  uint32_t IFM        ; // 0x18
    __O  uint32_t ICR        ; // 0x1C
    __IO uint32_t INDATA0    ; // 0x00
    __IO uint32_t INDATA1    ; // 0x04
    __IO uint32_t INANGLE    ; // 0x08
    __IO uint32_t CTRL       ; // 0x0C
    __I  uint32_t OTDATA0    ; // 0x10
    __I  uint32_t OTDATA1    ; // 0x14
    __I  uint32_t OTDATA2    ; // 0x18
    __I  uint32_t STATUS     ; // 0x1C
    __IO uint32_t OUTMUL     ; // 0x20
    __IO uint32_t PWMTH      ; // 0x24
} SVA_TypeDef;

#endif /* __REG_SVA_H__ */
