/**********************************************************************************
 *
 * @file    reg_opamp.h
 * @brief   OPAMP Head File
 *
 * @date    6 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Apr 2023      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __OPAMP_H__
#define __OPAMP_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for OPA1_CSR register ************************/

# define    OPAMP_OPA1_CSR_LOCK_POS 31U
# define    OPAMP_OPA1_CSR_LOCK_MSK BIT(OPAMP_OPA1_CSR_LOCK_POS)
# define    OPAMP_OPA1_CSR_LOCK     OPAMP_OPA1_CSR_LOCK_MSK

# define    OPAMP_OPA1_CSR_CAL_OUT_POS 30U
# define    OPAMP_OPA1_CSR_CAL_OUT_MSK BIT(OPAMP_OPA1_CSR_CAL_OUT_POS)
# define    OPAMP_OPA1_CSR_CAL_OUT     OPAMP_OPA1_CSR_CAL_OUT_MSK

# define    OPAMP_OPA1_CSR_TRIMOFFSETN_POSS 24U
# define    OPAMP_OPA1_CSR_TRIMOFFSETN_POSE 28U
# define    OPAMP_OPA1_CSR_TRIMOFFSETN_MSK BITS(OPAMP_OPA1_CSR_TRIMOFFSETN_POSS, OPAMP_OPA1_CSR_TRIMOFFSETN_POSE)
# define    OPAMP_OPA1_CSR_TRIMOFFSETN     OPAMP_OPA1_CSR_TRIMOFFSETN_MSK

# define    OPAMP_OPA1_CSR_TRIMOFFSETP_POSS 19U
# define    OPAMP_OPA1_CSR_TRIMOFFSETP_POSE 23U
# define    OPAMP_OPA1_CSR_TRIMOFFSETP_MSK BITS(OPAMP_OPA1_CSR_TRIMOFFSETP_POSS, OPAMP_OPA1_CSR_TRIMOFFSETP_POSE)
# define    OPAMP_OPA1_CSR_TRIMOFFSETP     OPAMP_OPA1_CSR_TRIMOFFSETP_MSK

# define    OPAMP_OPA1_CSR_PGA_GAIN_POSS 14U
# define    OPAMP_OPA1_CSR_PGA_GAIN_POSE 18U
# define    OPAMP_OPA1_CSR_PGA_GAIN_MSK BITS(OPAMP_OPA1_CSR_PGA_GAIN_POSS, OPAMP_OPA1_CSR_PGA_GAIN_POSE)
# define    OPAMP_OPA1_CSR_PGA_GAIN     OPAMP_OPA1_CSR_PGA_GAIN_MSK

# define    OPAMP_OPA1_CSR_CALSWON_POS 12U
# define    OPAMP_OPA1_CSR_CALSWON_MSK BIT(OPAMP_OPA1_CSR_CALSWON_POS)
# define    OPAMP_OPA1_CSR_CALSWON     OPAMP_OPA1_CSR_CALSWON_MSK

# define    OPAMP_OPA1_CSR_CALON_POS 11U
# define    OPAMP_OPA1_CSR_CALON_MSK BIT(OPAMP_OPA1_CSR_CALON_POS)
# define    OPAMP_OPA1_CSR_CALON     OPAMP_OPA1_CSR_CALON_MSK

# define    OPAMP_OPA1_CSR_OPAINTOEN_POS 8U
# define    OPAMP_OPA1_CSR_OPAINTOEN_MSK BIT(OPAMP_OPA1_CSR_OPAINTOEN_POS)
# define    OPAMP_OPA1_CSR_OPAINTOEN     OPAMP_OPA1_CSR_OPAINTOEN_MSK

# define    OPAMP_OPA1_CSR_OPAHSM_POS 7U
# define    OPAMP_OPA1_CSR_OPAHSM_MSK BIT(OPAMP_OPA1_CSR_OPAHSM_POS)
# define    OPAMP_OPA1_CSR_OPAHSM     OPAMP_OPA1_CSR_OPAHSM_MSK

# define    OPAMP_OPA1_CSR_VN_SEL_POSS 5U
# define    OPAMP_OPA1_CSR_VN_SEL_POSE 6U
# define    OPAMP_OPA1_CSR_VN_SEL_MSK BITS(OPAMP_OPA1_CSR_VN_SEL_POSS, OPAMP_OPA1_CSR_VN_SEL_POSE)
# define    OPAMP_OPA1_CSR_VN_SEL     OPAMP_OPA1_CSR_VN_SEL_MSK

# define    OPAMP_OPA1_CSR_USERTRIM_POS 4U
# define    OPAMP_OPA1_CSR_USERTRIM_MSK BIT(OPAMP_OPA1_CSR_USERTRIM_POS)
# define    OPAMP_OPA1_CSR_USERTRIM     OPAMP_OPA1_CSR_USERTRIM_MSK

# define    OPAMP_OPA1_CSR_VP_SEL_POSS 2U
# define    OPAMP_OPA1_CSR_VP_SEL_POSE 3U
# define    OPAMP_OPA1_CSR_VP_SEL_MSK BITS(OPAMP_OPA1_CSR_VP_SEL_POSS, OPAMP_OPA1_CSR_VP_SEL_POSE)
# define    OPAMP_OPA1_CSR_VP_SEL     OPAMP_OPA1_CSR_VP_SEL_MSK

# define    OPAMP_OPA1_CSR_OPAEN_POS 0U
# define    OPAMP_OPA1_CSR_OPAEN_MSK BIT(OPAMP_OPA1_CSR_OPAEN_POS)
# define    OPAMP_OPA1_CSR_OPAEN     OPAMP_OPA1_CSR_OPAEN_MSK

/****************** Bit definition for OPA2_CSR register ************************/

# define    OPAMP_OPA2_CSR_LOCK_POS 31U
# define    OPAMP_OPA2_CSR_LOCK_MSK BIT(OPAMP_OPA2_CSR_LOCK_POS)
# define    OPAMP_OPA2_CSR_LOCK     OPAMP_OPA2_CSR_LOCK_MSK

# define    OPAMP_OPA2_CSR_CAL_OUT_POS 30U
# define    OPAMP_OPA2_CSR_CAL_OUT_MSK BIT(OPAMP_OPA2_CSR_CAL_OUT_POS)
# define    OPAMP_OPA2_CSR_CAL_OUT     OPAMP_OPA2_CSR_CAL_OUT_MSK

# define    OPAMP_OPA2_CSR_TRIMOFFSETN_POSS 24U
# define    OPAMP_OPA2_CSR_TRIMOFFSETN_POSE 28U
# define    OPAMP_OPA2_CSR_TRIMOFFSETN_MSK BITS(OPAMP_OPA2_CSR_TRIMOFFSETN_POSS, OPAMP_OPA2_CSR_TRIMOFFSETN_POSE)
# define    OPAMP_OPA2_CSR_TRIMOFFSETN     OPAMP_OPA2_CSR_TRIMOFFSETN_MSK

# define    OPAMP_OPA2_CSR_TRIMOFFSETP_POSS 19U
# define    OPAMP_OPA2_CSR_TRIMOFFSETP_POSE 23U
# define    OPAMP_OPA2_CSR_TRIMOFFSETP_MSK BITS(OPAMP_OPA2_CSR_TRIMOFFSETP_POSS, OPAMP_OPA2_CSR_TRIMOFFSETP_POSE)
# define    OPAMP_OPA2_CSR_TRIMOFFSETP     OPAMP_OPA2_CSR_TRIMOFFSETP_MSK

# define    OPAMP_OPA2_CSR_PGA_GAIN_POSS 14U
# define    OPAMP_OPA2_CSR_PGA_GAIN_POSE 18U
# define    OPAMP_OPA2_CSR_PGA_GAIN_MSK BITS(OPAMP_OPA2_CSR_PGA_GAIN_POSS, OPAMP_OPA2_CSR_PGA_GAIN_POSE)
# define    OPAMP_OPA2_CSR_PGA_GAIN     OPAMP_OPA2_CSR_PGA_GAIN_MSK

# define    OPAMP_OPA2_CSR_CALSWON_POS 12U
# define    OPAMP_OPA2_CSR_CALSWON_MSK BIT(OPAMP_OPA2_CSR_CALSWON_POS)
# define    OPAMP_OPA2_CSR_CALSWON     OPAMP_OPA2_CSR_CALSWON_MSK

# define    OPAMP_OPA2_CSR_CALON_POS 11U
# define    OPAMP_OPA2_CSR_CALON_MSK BIT(OPAMP_OPA2_CSR_CALON_POS)
# define    OPAMP_OPA2_CSR_CALON     OPAMP_OPA2_CSR_CALON_MSK

# define    OPAMP_OPA2_CSR_OPAINTOEN_POS 8U
# define    OPAMP_OPA2_CSR_OPAINTOEN_MSK BIT(OPAMP_OPA2_CSR_OPAINTOEN_POS)
# define    OPAMP_OPA2_CSR_OPAINTOEN     OPAMP_OPA2_CSR_OPAINTOEN_MSK

# define    OPAMP_OPA2_CSR_OPAHSM_POS 7U
# define    OPAMP_OPA2_CSR_OPAHSM_MSK BIT(OPAMP_OPA2_CSR_OPAHSM_POS)
# define    OPAMP_OPA2_CSR_OPAHSM     OPAMP_OPA2_CSR_OPAHSM_MSK

# define    OPAMP_OPA2_CSR_VN_SEL_POSS 5U
# define    OPAMP_OPA2_CSR_VN_SEL_POSE 6U
# define    OPAMP_OPA2_CSR_VN_SEL_MSK BITS(OPAMP_OPA2_CSR_VN_SEL_POSS, OPAMP_OPA2_CSR_VN_SEL_POSE)
# define    OPAMP_OPA2_CSR_VN_SEL     OPAMP_OPA2_CSR_VN_SEL_MSK

# define    OPAMP_OPA2_CSR_USERTRIM_POS 4U
# define    OPAMP_OPA2_CSR_USERTRIM_MSK BIT(OPAMP_OPA2_CSR_USERTRIM_POS)
# define    OPAMP_OPA2_CSR_USERTRIM     OPAMP_OPA2_CSR_USERTRIM_MSK

# define    OPAMP_OPA2_CSR_VP_SEL_POSS 2U
# define    OPAMP_OPA2_CSR_VP_SEL_POSE 3U
# define    OPAMP_OPA2_CSR_VP_SEL_MSK BITS(OPAMP_OPA2_CSR_VP_SEL_POSS, OPAMP_OPA2_CSR_VP_SEL_POSE)
# define    OPAMP_OPA2_CSR_VP_SEL     OPAMP_OPA2_CSR_VP_SEL_MSK

# define    OPAMP_OPA2_CSR_OPAEN_POS 0U
# define    OPAMP_OPA2_CSR_OPAEN_MSK BIT(OPAMP_OPA2_CSR_OPAEN_POS)
# define    OPAMP_OPA2_CSR_OPAEN     OPAMP_OPA2_CSR_OPAEN_MSK

/****************** Bit definition for OPA3_CSR register ************************/

# define    OPAMP_OPA3_CSR_LOCK_POS 31U
# define    OPAMP_OPA3_CSR_LOCK_MSK BIT(OPAMP_OPA3_CSR_LOCK_POS)
# define    OPAMP_OPA3_CSR_LOCK     OPAMP_OPA3_CSR_LOCK_MSK

# define    OPAMP_OPA3_CSR_CAL_OUT_POS 30U
# define    OPAMP_OPA3_CSR_CAL_OUT_MSK BIT(OPAMP_OPA3_CSR_CAL_OUT_POS)
# define    OPAMP_OPA3_CSR_CAL_OUT     OPAMP_OPA3_CSR_CAL_OUT_MSK

# define    OPAMP_OPA3_CSR_TRIMOFFSETN_POSS 24U
# define    OPAMP_OPA3_CSR_TRIMOFFSETN_POSE 28U
# define    OPAMP_OPA3_CSR_TRIMOFFSETN_MSK BITS(OPAMP_OPA3_CSR_TRIMOFFSETN_POSS, OPAMP_OPA3_CSR_TRIMOFFSETN_POSE)
# define    OPAMP_OPA3_CSR_TRIMOFFSETN     OPAMP_OPA3_CSR_TRIMOFFSETN_MSK

# define    OPAMP_OPA3_CSR_TRIMOFFSETP_POSS 19U
# define    OPAMP_OPA3_CSR_TRIMOFFSETP_POSE 23U
# define    OPAMP_OPA3_CSR_TRIMOFFSETP_MSK BITS(OPAMP_OPA3_CSR_TRIMOFFSETP_POSS, OPAMP_OPA3_CSR_TRIMOFFSETP_POSE)
# define    OPAMP_OPA3_CSR_TRIMOFFSETP     OPAMP_OPA3_CSR_TRIMOFFSETP_MSK

# define    OPAMP_OPA3_CSR_PGA_GAIN_POSS 14U
# define    OPAMP_OPA3_CSR_PGA_GAIN_POSE 18U
# define    OPAMP_OPA3_CSR_PGA_GAIN_MSK BITS(OPAMP_OPA3_CSR_PGA_GAIN_POSS, OPAMP_OPA3_CSR_PGA_GAIN_POSE)
# define    OPAMP_OPA3_CSR_PGA_GAIN     OPAMP_OPA3_CSR_PGA_GAIN_MSK

# define    OPAMP_OPA3_CSR_CALSWON_POS 12U
# define    OPAMP_OPA3_CSR_CALSWON_MSK BIT(OPAMP_OPA3_CSR_CALSWON_POS)
# define    OPAMP_OPA3_CSR_CALSWON     OPAMP_OPA3_CSR_CALSWON_MSK

# define    OPAMP_OPA3_CSR_CALON_POS 11U
# define    OPAMP_OPA3_CSR_CALON_MSK BIT(OPAMP_OPA3_CSR_CALON_POS)
# define    OPAMP_OPA3_CSR_CALON     OPAMP_OPA3_CSR_CALON_MSK

# define    OPAMP_OPA3_CSR_OPAINTOEN_POS 8U
# define    OPAMP_OPA3_CSR_OPAINTOEN_MSK BIT(OPAMP_OPA3_CSR_OPAINTOEN_POS)
# define    OPAMP_OPA3_CSR_OPAINTOEN     OPAMP_OPA3_CSR_OPAINTOEN_MSK

# define    OPAMP_OPA3_CSR_OPAHSM_POS 7U
# define    OPAMP_OPA3_CSR_OPAHSM_MSK BIT(OPAMP_OPA3_CSR_OPAHSM_POS)
# define    OPAMP_OPA3_CSR_OPAHSM     OPAMP_OPA3_CSR_OPAHSM_MSK

# define    OPAMP_OPA3_CSR_VN_SEL_POSS 5U
# define    OPAMP_OPA3_CSR_VN_SEL_POSE 6U
# define    OPAMP_OPA3_CSR_VN_SEL_MSK BITS(OPAMP_OPA3_CSR_VN_SEL_POSS, OPAMP_OPA3_CSR_VN_SEL_POSE)
# define    OPAMP_OPA3_CSR_VN_SEL     OPAMP_OPA3_CSR_VN_SEL_MSK

# define    OPAMP_OPA3_CSR_USERTRIM_POS 4U
# define    OPAMP_OPA3_CSR_USERTRIM_MSK BIT(OPAMP_OPA3_CSR_USERTRIM_POS)
# define    OPAMP_OPA3_CSR_USERTRIM     OPAMP_OPA3_CSR_USERTRIM_MSK

# define    OPAMP_OPA3_CSR_VP_SEL_POSS 2U
# define    OPAMP_OPA3_CSR_VP_SEL_POSE 3U
# define    OPAMP_OPA3_CSR_VP_SEL_MSK BITS(OPAMP_OPA3_CSR_VP_SEL_POSS, OPAMP_OPA3_CSR_VP_SEL_POSE)
# define    OPAMP_OPA3_CSR_VP_SEL     OPAMP_OPA3_CSR_VP_SEL_MSK

# define    OPAMP_OPA3_CSR_OPAEN_POS 0U
# define    OPAMP_OPA3_CSR_OPAEN_MSK BIT(OPAMP_OPA3_CSR_OPAEN_POS)
# define    OPAMP_OPA3_CSR_OPAEN     OPAMP_OPA3_CSR_OPAEN_MSK

/****************** Bit definition for OPA4_CSR register ************************/

# define    OPAMP_OPA4_CSR_LOCK_POS 31U
# define    OPAMP_OPA4_CSR_LOCK_MSK BIT(OPAMP_OPA4_CSR_LOCK_POS)
# define    OPAMP_OPA4_CSR_LOCK     OPAMP_OPA4_CSR_LOCK_MSK

# define    OPAMP_OPA4_CSR_CAL_OUT_POS 30U
# define    OPAMP_OPA4_CSR_CAL_OUT_MSK BIT(OPAMP_OPA4_CSR_CAL_OUT_POS)
# define    OPAMP_OPA4_CSR_CAL_OUT     OPAMP_OPA4_CSR_CAL_OUT_MSK

# define    OPAMP_OPA4_CSR_TRIMOFFSETN_POSS 24U
# define    OPAMP_OPA4_CSR_TRIMOFFSETN_POSE 28U
# define    OPAMP_OPA4_CSR_TRIMOFFSETN_MSK BITS(OPAMP_OPA4_CSR_TRIMOFFSETN_POSS, OPAMP_OPA4_CSR_TRIMOFFSETN_POSE)
# define    OPAMP_OPA4_CSR_TRIMOFFSETN     OPAMP_OPA4_CSR_TRIMOFFSETN_MSK

# define    OPAMP_OPA4_CSR_TRIMOFFSETP_POSS 19U
# define    OPAMP_OPA4_CSR_TRIMOFFSETP_POSE 23U
# define    OPAMP_OPA4_CSR_TRIMOFFSETP_MSK BITS(OPAMP_OPA4_CSR_TRIMOFFSETP_POSS, OPAMP_OPA4_CSR_TRIMOFFSETP_POSE)
# define    OPAMP_OPA4_CSR_TRIMOFFSETP     OPAMP_OPA4_CSR_TRIMOFFSETP_MSK

# define    OPAMP_OPA4_CSR_PGA_GAIN_POSS 14U
# define    OPAMP_OPA4_CSR_PGA_GAIN_POSE 18U
# define    OPAMP_OPA4_CSR_PGA_GAIN_MSK BITS(OPAMP_OPA4_CSR_PGA_GAIN_POSS, OPAMP_OPA4_CSR_PGA_GAIN_POSE)
# define    OPAMP_OPA4_CSR_PGA_GAIN     OPAMP_OPA4_CSR_PGA_GAIN_MSK

# define    OPAMP_OPA4_CSR_CALSWON_POS 12U
# define    OPAMP_OPA4_CSR_CALSWON_MSK BIT(OPAMP_OPA4_CSR_CALSWON_POS)
# define    OPAMP_OPA4_CSR_CALSWON     OPAMP_OPA4_CSR_CALSWON_MSK

# define    OPAMP_OPA4_CSR_CALON_POS 11U
# define    OPAMP_OPA4_CSR_CALON_MSK BIT(OPAMP_OPA4_CSR_CALON_POS)
# define    OPAMP_OPA4_CSR_CALON     OPAMP_OPA4_CSR_CALON_MSK

# define    OPAMP_OPA4_CSR_OPAINTOEN_POS 8U
# define    OPAMP_OPA4_CSR_OPAINTOEN_MSK BIT(OPAMP_OPA4_CSR_OPAINTOEN_POS)
# define    OPAMP_OPA4_CSR_OPAINTOEN     OPAMP_OPA4_CSR_OPAINTOEN_MSK

# define    OPAMP_OPA4_CSR_OPAHSM_POS 7U
# define    OPAMP_OPA4_CSR_OPAHSM_MSK BIT(OPAMP_OPA4_CSR_OPAHSM_POS)
# define    OPAMP_OPA4_CSR_OPAHSM     OPAMP_OPA4_CSR_OPAHSM_MSK

# define    OPAMP_OPA4_CSR_VN_SEL_POSS 5U
# define    OPAMP_OPA4_CSR_VN_SEL_POSE 6U
# define    OPAMP_OPA4_CSR_VN_SEL_MSK BITS(OPAMP_OPA4_CSR_VN_SEL_POSS, OPAMP_OPA4_CSR_VN_SEL_POSE)
# define    OPAMP_OPA4_CSR_VN_SEL     OPAMP_OPA4_CSR_VN_SEL_MSK

# define    OPAMP_OPA4_CSR_USERTRIM_POS 4U
# define    OPAMP_OPA4_CSR_USERTRIM_MSK BIT(OPAMP_OPA4_CSR_USERTRIM_POS)
# define    OPAMP_OPA4_CSR_USERTRIM     OPAMP_OPA4_CSR_USERTRIM_MSK

# define    OPAMP_OPA4_CSR_VP_SEL_POSS 2U
# define    OPAMP_OPA4_CSR_VP_SEL_POSE 3U
# define    OPAMP_OPA4_CSR_VP_SEL_MSK BITS(OPAMP_OPA4_CSR_VP_SEL_POSS, OPAMP_OPA4_CSR_VP_SEL_POSE)
# define    OPAMP_OPA4_CSR_VP_SEL     OPAMP_OPA4_CSR_VP_SEL_MSK

# define    OPAMP_OPA4_CSR_OPAEN_POS 0U
# define    OPAMP_OPA4_CSR_OPAEN_MSK BIT(OPAMP_OPA4_CSR_OPAEN_POS)
# define    OPAMP_OPA4_CSR_OPAEN     OPAMP_OPA4_CSR_OPAEN_MSK

/****************** Bit definition for OPA1_TCMR register ************************/

# define    OPAMP_OPA1_TCMR_LOCK_POS 31U
# define    OPAMP_OPA1_TCMR_LOCK_MSK BIT(OPAMP_OPA1_TCMR_LOCK_POS)
# define    OPAMP_OPA1_TCMR_LOCK     OPAMP_OPA1_TCMR_LOCK_MSK

# define    OPAMP_OPA1_TCMR_AD2CM_EN_POS 5U
# define    OPAMP_OPA1_TCMR_AD2CM_EN_MSK BIT(OPAMP_OPA1_TCMR_AD2CM_EN_POS)
# define    OPAMP_OPA1_TCMR_AD2CM_EN     OPAMP_OPA1_TCMR_AD2CM_EN_MSK

# define    OPAMP_OPA1_TCMR_AD1CM_EN_POS 4U
# define    OPAMP_OPA1_TCMR_AD1CM_EN_MSK BIT(OPAMP_OPA1_TCMR_AD1CM_EN_POS)
# define    OPAMP_OPA1_TCMR_AD1CM_EN     OPAMP_OPA1_TCMR_AD1CM_EN_MSK

# define    OPAMP_OPA1_TCMR_VPS_SEL_POSS 2U
# define    OPAMP_OPA1_TCMR_VPS_SEL_POSE 3U
# define    OPAMP_OPA1_TCMR_VPS_SEL_MSK  BITS(OPAMP_OPA1_TCMR_VPS_SEL_POSS, OPAMP_OPA1_TCMR_VPS_SEL_POSE)
# define    OPAMP_OPA1_TCMR_VPS_SEL      OPAMP_OPA1_TCMR_VPS_SEL_MSK

# define    OPAMP_OPA1_TCMR_VNS_SEL_POS 0U
# define    OPAMP_OPA1_TCMR_VNS_SEL_MSK BIT(OPAMP_OPA1_TCMR_VNS_SEL_POS)
# define    OPAMP_OPA1_TCMR_VNS_SEL     OPAMP_OPA1_TCMR_VNS_SEL_MSK

/****************** Bit definition for OPA2_TCMR register ************************/

# define    OPAMP_OPA2_TCMR_LOCK_POS 31U
# define    OPAMP_OPA2_TCMR_LOCK_MSK BIT(OPAMP_OPA2_TCMR_LOCK_POS)
# define    OPAMP_OPA2_TCMR_LOCK     OPAMP_OPA2_TCMR_LOCK_MSK

# define    OPAMP_OPA2_TCMR_AD2CM_EN_POS 5U
# define    OPAMP_OPA2_TCMR_AD2CM_EN_MSK BIT(OPAMP_OPA2_TCMR_AD2CM_EN_POS)
# define    OPAMP_OPA2_TCMR_AD2CM_EN     OPAMP_OPA2_TCMR_AD2CM_EN_MSK

# define    OPAMP_OPA2_TCMR_AD1CM_EN_POS 4U
# define    OPAMP_OPA2_TCMR_AD1CM_EN_MSK BIT(OPAMP_OPA2_TCMR_AD1CM_EN_POS)
# define    OPAMP_OPA2_TCMR_AD1CM_EN     OPAMP_OPA2_TCMR_AD1CM_EN_MSK

# define    OPAMP_OPA2_TCMR_VPS_SEL_POSS 2U
# define    OPAMP_OPA2_TCMR_VPS_SEL_POSE 3U
# define    OPAMP_OPA2_TCMR_VPS_SEL_MSK BITS(OPAMP_OPA2_TCMR_VPS_SEL_POSS, OPAMP_OPA2_TCMR_VPS_SEL_POSE)
# define    OPAMP_OPA2_TCMR_VPS_SEL     OPAMP_OPA2_TCMR_VPS_SEL_MSK

# define    OPAMP_OPA2_TCMR_VNS_SEL_POS 0U
# define    OPAMP_OPA2_TCMR_VNS_SEL_MSK BIT(OPAMP_OPA2_TCMR_VNS_SEL_POS)
# define    OPAMP_OPA2_TCMR_VNS_SEL     OPAMP_OPA2_TCMR_VNS_SEL_MSK

/****************** Bit definition for OPA3_TCMR register ************************/

# define    OPAMP_OPA3_TCMR_LOCK_POS 31U
# define    OPAMP_OPA3_TCMR_LOCK_MSK BIT(OPAMP_OPA3_TCMR_LOCK_POS)
# define    OPAMP_OPA3_TCMR_LOCK     OPAMP_OPA3_TCMR_LOCK_MSK

# define    OPAMP_OPA3_TCMR_AD2CM_EN_POS 5U
# define    OPAMP_OPA3_TCMR_AD2CM_EN_MSK BIT(OPAMP_OPA3_TCMR_AD2CM_EN_POS)
# define    OPAMP_OPA3_TCMR_AD2CM_EN     OPAMP_OPA3_TCMR_AD2CM_EN_MSK

# define    OPAMP_OPA3_TCMR_AD1CM_EN_POS 4U
# define    OPAMP_OPA3_TCMR_AD1CM_EN_MSK BIT(OPAMP_OPA3_TCMR_AD1CM_EN_POS)
# define    OPAMP_OPA3_TCMR_AD1CM_EN     OPAMP_OPA3_TCMR_AD1CM_EN_MSK

# define    OPAMP_OPA3_TCMR_VPS_SEL_POSS 2U
# define    OPAMP_OPA3_TCMR_VPS_SEL_POSE 3U
# define    OPAMP_OPA3_TCMR_VPS_SEL_MSK BITS(OPAMP_OPA3_TCMR_VPS_SEL_POSS, OPAMP_OPA3_TCMR_VPS_SEL_POSE)
# define    OPAMP_OPA3_TCMR_VPS_SEL     OPAMP_OPA3_TCMR_VPS_SEL_MSK

# define    OPAMP_OPA3_TCMR_VNS_SEL_POS 0U
# define    OPAMP_OPA3_TCMR_VNS_SEL_MSK BIT(OPAMP_OPA3_TCMR_VNS_SEL_POS)
# define    OPAMP_OPA3_TCMR_VNS_SEL     OPAMP_OPA3_TCMR_VNS_SEL_MSK

/****************** Bit definition for OPA4_TCMR register ************************/

# define    OPAMP_OPA4_TCMR_LOCK_POS 31U
# define    OPAMP_OPA4_TCMR_LOCK_MSK BIT(OPAMP_OPA4_TCMR_LOCK_POS)
# define    OPAMP_OPA4_TCMR_LOCK     OPAMP_OPA4_TCMR_LOCK_MSK

# define    OPAMP_OPA4_TCMR_AD2CM_EN_POS 5U
# define    OPAMP_OPA4_TCMR_AD2CM_EN_MSK BIT(OPAMP_OPA4_TCMR_AD2CM_EN_POS)
# define    OPAMP_OPA4_TCMR_AD2CM_EN     OPAMP_OPA4_TCMR_AD2CM_EN_MSK

# define    OPAMP_OPA4_TCMR_AD1CM_EN_POS 4U
# define    OPAMP_OPA4_TCMR_AD1CM_EN_MSK BIT(OPAMP_OPA4_TCMR_AD1CM_EN_POS)
# define    OPAMP_OPA4_TCMR_AD1CM_EN     OPAMP_OPA4_TCMR_AD1CM_EN_MSK

# define    OPAMP_OPA4_TCMR_VPS_SEL_POSS 2U
# define    OPAMP_OPA4_TCMR_VPS_SEL_POSE 3U
# define    OPAMP_OPA4_TCMR_VPS_SEL_MSK BITS(OPAMP_OPA4_TCMR_VPS_SEL_POSS, OPAMP_OPA4_TCMR_VPS_SEL_POSE)
# define    OPAMP_OPA4_TCMR_VPS_SEL     OPAMP_OPA4_TCMR_VPS_SEL_MSK

# define    OPAMP_OPA4_TCMR_VNS_SEL_POS 0U
# define    OPAMP_OPA4_TCMR_VNS_SEL_MSK BIT(OPAMP_OPA4_TCMR_VNS_SEL_POS)
# define    OPAMP_OPA4_TCMR_VNS_SEL     OPAMP_OPA4_TCMR_VNS_SEL_MSK

typedef struct
{
    __IO uint32_t OPA1_CSR;                     // 0x000
    __IO uint32_t OPA2_CSR;                     // 0x004
    __IO uint32_t OPA3_CSR;                     // 0x008
    __IO uint32_t OPA4_CSR;                     // 0x00c
    __IO uint32_t RESERVED0[2];                 // 0x010-0x014   
    __IO uint32_t OPA1_TCMR;                    // 0x018
    __IO uint32_t OPA2_TCMR;                    // 0x01c
    __IO uint32_t OPA3_TCMR;                    // 0x020
    __IO uint32_t OPA4_TCMR;                    // 0x024    
} OPAMP_TypeDef;


#endif
