/**********************************************************************************
 *
 * @file    reg_iir.h
 * @brief   IIR Head File
 *
 * @date    31 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          31 Mar 2023     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_IIR_H__
#define __REG_IIR_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/****************** Bit definition for IIR_CTRL register ************************/

# define	IIR_CTRL_MODE_POS 2U 
# define	IIR_CTRL_MODE_MSK BIT(IIR_CTRL_MODE_POS) 
# define	IIR_CTRL_MODE     IIR_CTRL_MODE_MSK

# define	IIR_CTRL_INIT_POS 1U 
# define	IIR_CTRL_INIT_MSK BIT(IIR_CTRL_INIT_POS) 
# define	IIR_CTRL_INIT     IIR_CTRL_INIT_MSK

# define	IIR_CTRL_STR_TRIG_POS 0U 
# define	IIR_CTRL_STR_TRIG_MSK BIT(IIR_CTRL_STR_TRIG_POS) 
# define	IIR_CTRL_STR_TRIG     IIR_CTRL_STR_TRIG_MSK

/****************** Bit definition for IIR_STATUS register ************************/

# define	IIR_STATUS_BUSY_POS 0U 
# define	IIR_STATUS_BUSY_MSK BIT(IIR_STATUS_BUSY_POS) 
# define	IIR_STATUS_BUSY     IIR_STATUS_BUSY_MSK

/****************** Bit definition for IIR_INDATA register ************************/

# define	IIR_INDATA_INDATA_POSS 0U 
# define	IIR_INDATA_INDATA_POSE 15U 
# define	IIR_INDATA_INDATA_MSK  BITS(IIR_INDATA_INDATA_POSS, IIR_INDATA_INDATA_POSE) 
# define	IIR_INDATA_INDATA      IIR_INDATA_INDATA_MSK

/****************** Bit definition for IIR_OUTDATA register ************************/

# define	IIR_OUTDATA_OUTDATA_POSS 0U 
# define	IIR_OUTDATA_OUTDATA_POSE 15U 
# define	IIR_OUTDATA_OUTDATA_MSK  BITS(IIR_OUTDATA_OUTDATA_POSS, IIR_OUTDATA_OUTDATA_POSE) 
# define	IIR_OUTDATA_OUTDATA      IIR_OUTDATA_OUTDATA_MSK

/****************** Bit definition for IIR_SCALE_0 register ************************/

# define	IIR_SCALE_0_SCALE_POSS 0U 
# define	IIR_SCALE_0_SCALE_POSE 23U 
# define	IIR_SCALE_0_SCALE_MSK  BITS(IIR_SCALE_0_SCALE_POSS, IIR_SCALE_0_SCALE_POSE) 
# define	IIR_SCALE_0_SCALE      IIR_SCALE_0_SCALE_MSK

/****************** Bit definition for IIR_COEB1_0 register ************************/

# define	IIR_COEB1_0_COEB1_POSS 0U 
# define	IIR_COEB1_0_COEB1_POSE 23U 
# define	IIR_COEB1_0_COEB1_MSK  BITS(IIR_COEB1_0_COEB1_POSS, IIR_COEB1_0_COEB1_POSE) 
# define	IIR_COEB1_0_COEB1      IIR_COEB1_0_COEB1_MSK

/****************** Bit definition for IIR_COEB2_0 register ************************/

# define	IIR_COEB2_0_COEB2_POSS 0U 
# define	IIR_COEB2_0_COEB2_POSE 23U 
# define	IIR_COEB2_0_COEB2_MSK  BITS(IIR_COEB2_0_COEB2_POSS, IIR_COEB2_0_COEB2_POSE) 
# define	IIR_COEB2_0_COEB2      IIR_COEB2_0_COEB2_MSK

/****************** Bit definition for IIR_COEB3_0 register ************************/

# define	IIR_COEB3_0_COEB3_POSS 0U 
# define	IIR_COEB3_0_COEB3_POSE 23U 
# define	IIR_COEB3_0_COEB3_MSK  BITS(IIR_COEB3_0_COEB3_POSS, IIR_COEB3_0_COEB3_POSE) 
# define	IIR_COEB3_0_COEB3      IIR_COEB3_0_COEB3_MSK

/****************** Bit definition for IIR_COEA2_0 register ************************/

# define	IIR_COEA2_0_COEA2_POSS 0U 
# define	IIR_COEA2_0_COEA2_POSE 23U 
# define	IIR_COEA2_0_COEA2_MSK  BITS(IIR_COEA2_0_COEA2_POSS, IIR_COEA2_0_COEA2_POSE) 
# define	IIR_COEA2_0_COEA2      IIR_COEA2_0_COEA2_MSK

/****************** Bit definition for IIR_COEA3_0 register ************************/

# define	IIR_COEA3_0_COEA3_POSS 0U 
# define	IIR_COEA3_0_COEA3_POSE 23U 
# define	IIR_COEA3_0_COEA3_MSK  BITS(IIR_COEA3_0_COEA3_POSS, IIR_COEA3_0_COEA3_POSE) 
# define	IIR_COEA3_0_COEA3      IIR_COEA3_0_COEA3_MSK

/****************** Bit definition for IIR_INTD1_0 register ************************/

# define	IIR_INTD1_0_INTD1_POSS 0U 
# define	IIR_INTD1_0_INTD1_POSE 23U 
# define	IIR_INTD1_0_INTD1_MSK  BITS(IIR_INTD1_0_INTD1_POSS, IIR_INTD1_0_INTD1_POSE) 
# define	IIR_INTD1_0_INTD1      IIR_INTD1_0_INTD1_MSK

/****************** Bit definition for IIR_INTD2_0 register ************************/

# define	IIR_INTD2_0_INTD2_POSS 0U 
# define	IIR_INTD2_0_INTD2_POSE 23U 
# define	IIR_INTD2_0_INTD2_MSK  BITS(IIR_INTD2_0_INTD2_POSS, IIR_INTD2_0_INTD2_POSE) 
# define	IIR_INTD2_0_INTD2      IIR_INTD2_0_INTD2_MSK

/****************** Bit definition for IIR_SCALE_1 register ************************/

# define	IIR_SCALE_1_SCALE_POSS 0U 
# define	IIR_SCALE_1_SCALE_POSE 23U 
# define	IIR_SCALE_1_SCALE_MSK  BITS(IIR_SCALE_1_SCALE_POSS, IIR_SCALE_1_SCALE_POSE) 
# define	IIR_SCALE_1_SCALE      IIR_SCALE_1_SCALE_MSK

/****************** Bit definition for IIR_COEB1_1 register ************************/

# define	IIR_COEB1_1_COEB1_POSS 0U 
# define	IIR_COEB1_1_COEB1_POSE 23U 
# define	IIR_COEB1_1_COEB1_MSK  BITS(IIR_COEB1_1_COEB1_POSS, IIR_COEB1_1_COEB1_POSE) 
# define	IIR_COEB1_1_COEB1      IIR_COEB1_1_COEB1_MSK

/****************** Bit definition for IIR_COEB2_1 register ************************/

# define	IIR_COEB2_1_COEB2_POSS 0U 
# define	IIR_COEB2_1_COEB2_POSE 23U 
# define	IIR_COEB2_1_COEB2_MSK  BITS(IIR_COEB2_1_COEB2_POSS, IIR_COEB2_1_COEB2_POSE) 
# define	IIR_COEB2_1_COEB2      IIR_COEB2_1_COEB2_MSK

/****************** Bit definition for IIR_COEB3_1 register ************************/

# define	IIR_COEB3_1_COEB3_POSS 0U 
# define	IIR_COEB3_1_COEB3_POSE 23U 
# define	IIR_COEB3_1_COEB3_MSK  BITS(IIR_COEB3_1_COEB3_POSS, IIR_COEB3_1_COEB3_POSE) 
# define	IIR_COEB3_1_COEB3      IIR_COEB3_1_COEB3_MSK

/****************** Bit definition for IIR_COEA2_1 register ************************/

# define	IIR_COEA2_1_COEA2_POSS 0U 
# define	IIR_COEA2_1_COEA2_POSE 23U 
# define	IIR_COEA2_1_COEA2_MSK  BITS(IIR_COEA2_1_COEA2_POSS, IIR_COEA2_1_COEA2_POSE) 
# define	IIR_COEA2_1_COEA2      IIR_COEA2_1_COEA2_MSK

/****************** Bit definition for IIR_COEA3_1 register ************************/

# define	IIR_COEA3_1_COEA3_POSS 0U 
# define	IIR_COEA3_1_COEA3_POSE 23U 
# define	IIR_COEA3_1_COEA3_MSK  BITS(IIR_COEA3_1_COEA3_POSS, IIR_COEA3_1_COEA3_POSE) 
# define	IIR_COEA3_1_COEA3      IIR_COEA3_1_COEA3_MSK

/****************** Bit definition for IIR_INTD1_1 register ************************/

# define	IIR_INTD1_1_INTD1_POSS 0U 
# define	IIR_INTD1_1_INTD1_POSE 23U 
# define	IIR_INTD1_1_INTD1_MSK  BITS(IIR_INTD1_1_INTD1_POSS, IIR_INTD1_1_INTD1_POSE) 
# define	IIR_INTD1_1_INTD1      IIR_INTD1_1_INTD1_MSK

/****************** Bit definition for IIR_INTD2_1 register ************************/

# define	IIR_INTD2_1_INTD2_POSS 0U 
# define	IIR_INTD2_1_INTD2_POSE 23U 
# define	IIR_INTD2_1_INTD2_MSK  BITS(IIR_INTD2_1_INTD2_POSS, IIR_INTD2_1_INTD2_POSE) 
# define	IIR_INTD2_1_INTD2      IIR_INTD2_1_INTD2_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t   CTRL       ; // 0x00
    __I  uint32_t   STATUS     ; // 0x04
    __IO uint32_t   INDATA     ; // 0x08
    __I  uint32_t   OUTDATA    ; // 0x0C
    __IO uint32_t   SCALE_0    ; // 0x10
    __IO uint32_t   COEB1_0    ; // 0x14
    __IO uint32_t   COEB2_0    ; // 0x18
    __IO uint32_t   COEB3_0    ; // 0x1C
    __IO uint32_t   COEA2_0    ; // 0x20
    __IO uint32_t   COEA3_0    ; // 0x24
    __IO uint32_t   INTD1_0    ; // 0x28
    __IO uint32_t   INTD2_0    ; // 0x2C
    __IO uint32_t   SCALE_1    ; // 0x30
    __IO uint32_t   COEB1_1    ; // 0x34
    __IO uint32_t   COEB2_1    ; // 0x38
    __IO uint32_t   COEB3_1    ; // 0x3C
    __IO uint32_t   COEA2_1    ; // 0x40
    __IO uint32_t   COEA3_1    ; // 0x44
    __IO uint32_t   INTD1_1    ; // 0x48
    __IO uint32_t   INTD2_1    ; // 0x4C
} IIR_TypeDef;

#endif /* __REG_IIR_H__ */
