/**********************************************************************************
 *
 * @file    reg_dmamux.h
 * @brief   DMAMUX Head File
 *
 * @date    6 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Apr 2023      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __DMAMUX_H__
#define __DMAMUX_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for DMA_CH0_SELCON register ************************/

# define	DMA_CH0_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH0_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH0_SELCON_MSIGSEL_MSK BITS(DMA_CH0_SELCON_MSIGSEL_POSS, DMA_CH0_SELCON_MSIGSEL_POSE) 
# define	DMA_CH0_SELCON_MSIGSEL DMA_CH0_SELCON_MSIGSEL_MSK 

/****************** Bit definition for DMA_CH1_SELCON register ************************/

# define	DMA_CH1_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH1_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH1_SELCON_MSIGSEL_MSK BITS(DMA_CH1_SELCON_MSIGSEL_POSS, DMA_CH1_SELCON_MSIGSEL_POSE) 
# define	DMA_CH1_SELCON_MSIGSEL DMA_CH1_SELCON_MSIGSEL_MSK 

/****************** Bit definition for DMA_CH2_SELCON register ************************/

# define	DMA_CH2_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH2_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH2_SELCON_MSIGSEL_MSK BITS(DMA_CH2_SELCON_MSIGSEL_POSS, DMA_CH2_SELCON_MSIGSEL_POSE) 
# define	DMA_CH2_SELCON_MSIGSEL DMA_CH2_SELCON_MSIGSEL_MSK 

/****************** Bit definition for DMA_CH3_SELCON register ************************/

# define	DMA_CH3_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH3_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH3_SELCON_MSIGSEL_MSK BITS(DMA_CH3_SELCON_MSIGSEL_POSS, DMA_CH3_SELCON_MSIGSEL_POSE) 
# define	DMA_CH3_SELCON_MSIGSEL DMA_CH3_SELCON_MSIGSEL_MSK 

/****************** Bit definition for DMA_CH4_SELCON register ************************/

# define	DMA_CH4_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH4_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH4_SELCON_MSIGSEL_MSK BITS(DMA_CH4_SELCON_MSIGSEL_POSS, DMA_CH4_SELCON_MSIGSEL_POSE) 
# define	DMA_CH4_SELCON_MSIGSEL DMA_CH4_SELCON_MSIGSEL_MSK 

/****************** Bit definition for DMA_CH5_SELCON register ************************/

# define	DMA_CH5_SELCON_MSIGSEL_POSS 0U 
# define	DMA_CH5_SELCON_MSIGSEL_POSE 6U 
# define	DMA_CH5_SELCON_MSIGSEL_MSK BITS(DMA_CH5_SELCON_MSIGSEL_POSS, DMA_CH5_SELCON_MSIGSEL_POSE) 
# define	DMA_CH5_SELCON_MSIGSEL DMA_CH5_SELCON_MSIGSEL_MSK 

typedef struct
{
    __IO uint32_t CH0_SELCON;               // 0x000
    __IO uint32_t CH1_SELCON;               // 0x004
    __IO uint32_t CH2_SELCON;               // 0x008
    __IO uint32_t CH3_SELCON;               // 0x00c
    __IO uint32_t CH4_SELCON;               // 0x010
    __IO uint32_t CH5_SELCON;               // 0x014
} DMAMUX_TypeDef;


#endif
