/**********************************************************************************
 *
 * @file    reg_dma.h
 * @brief   DMA Head File
 *
 * @date    23 Apr. 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Apr. 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_DMA_H__
#define __REG_DMA_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


#define DMA_CHANNELS 6
/****************** Bit definition for DMA_INTRRUPT register ************************/

/****************** Bit definition for DMA_IER register ************************/

#define DMA_IER_CH11HT_POS  23U
#define DMA_IER_CH11HT_MSK  BIT(DMA_IER_CH11HT_POS)

#define DMA_IER_CH11TC_POS  22U
#define DMA_IER_CH11TC_MSK  BIT(DMA_IER_CH11TC_POS)

#define DMA_IER_CH10HT_POS  21U
#define DMA_IER_CH10HT_MSK  BIT(DMA_IER_CH10HT_POS)

#define DMA_IER_CH10TC_POS  20U
#define DMA_IER_CH10TC_MSK  BIT(DMA_IER_CH10TC_POS)

#define DMA_IER_CH9HT_POS   19U
#define DMA_IER_CH9HT_MSK   BIT(DMA_IER_CH9HT_POS)

#define DMA_IER_CH9TC_POS   18U
#define DMA_IER_CH9TC_MSK   BIT(DMA_IER_CH9TC_POS)

#define DMA_IER_CH8HT_POS   17U
#define DMA_IER_CH8HT_MSK   BIT(DMA_IER_CH8HT_POS)

#define DMA_IER_CH8TC_POS   16U
#define DMA_IER_CH8TC_MSK   BIT(DMA_IER_CH8TC_POS)

#define DMA_IER_CH7HT_POS   15U
#define DMA_IER_CH7HT_MSK   BIT(DMA_IER_CH7HT_POS)

#define DMA_IER_CH7TC_POS   14U
#define DMA_IER_CH7TC_MSK   BIT(DMA_IER_CH7TC_POS)

#define DMA_IER_CH6HT_POS   13U
#define DMA_IER_CH6HT_MSK   BIT(DMA_IER_CH6HT_POS)

#define DMA_IER_CH6TC_POS   12U
#define DMA_IER_CH6TC_MSK   BIT(DMA_IER_CH6TC_POS)

#define DMA_IER_CH5HT_POS   11U
#define DMA_IER_CH5HT_MSK   BIT(DMA_IER_CH5HT_POS)

#define DMA_IER_CH5TC_POS   10U
#define DMA_IER_CH5TC_MSK   BIT(DMA_IER_CH5TC_POS)

#define DMA_IER_CH4HT_POS   9U
#define DMA_IER_CH4HT_MSK   BIT(DMA_IER_CH4HT_POS)

#define DMA_IER_CH4TC_POS   8U
#define DMA_IER_CH4TC_MSK   BIT(DMA_IER_CH4TC_POS)

#define DMA_IER_CH3HT_POS   7U
#define DMA_IER_CH3HT_MSK   BIT(DMA_IER_CH3HT_POS)

#define DMA_IER_CH3TC_POS   6U
#define DMA_IER_CH3TC_MSK   BIT(DMA_IER_CH3TC_POS)

#define DMA_IER_CH2HT_POS   5U
#define DMA_IER_CH2HT_MSK   BIT(DMA_IER_CH2HT_POS)

#define DMA_IER_CH2TC_POS   4U
#define DMA_IER_CH2TC_MSK   BIT(DMA_IER_CH2TC_POS)

#define DMA_IER_CH1HT_POS   3U
#define DMA_IER_CH1HT_MSK   BIT(DMA_IER_CH1HT_POS)

#define DMA_IER_CH1TC_POS   2U
#define DMA_IER_CH1TC_MSK   BIT(DMA_IER_CH1TC_POS)

#define DMA_IER_CH0HT_POS   1U
#define DMA_IER_CH0HT_MSK   BIT(DMA_IER_CH0HT_POS)

#define DMA_IER_CH0TC_POS   0U
#define DMA_IER_CH0TC_MSK   BIT(DMA_IER_CH0TC_POS)

/****************** Bit definition for DMA_IDR register ************************/

#define DMA_IDR_CH11HT_POS  23U
#define DMA_IDR_CH11HT_MSK  BIT(DMA_IDR_CH11HT_POS)

#define DMA_IDR_CH11TC_POS  22U
#define DMA_IDR_CH11TC_MSK  BIT(DMA_IDR_CH11TC_POS)

#define DMA_IDR_CH10HT_POS  21U
#define DMA_IDR_CH10HT_MSK  BIT(DMA_IDR_CH10HT_POS)

#define DMA_IDR_CH10TC_POS  20U
#define DMA_IDR_CH10TC_MSK  BIT(DMA_IDR_CH10TC_POS)

#define DMA_IDR_CH9HT_POS   19U
#define DMA_IDR_CH9HT_MSK   BIT(DMA_IDR_CH9HT_POS)

#define DMA_IDR_CH9TC_POS   18U
#define DMA_IDR_CH9TC_MSK   BIT(DMA_IDR_CH9TC_POS)

#define DMA_IDR_CH8HT_POS   17U
#define DMA_IDR_CH8HT_MSK   BIT(DMA_IDR_CH8HT_POS)

#define DMA_IDR_CH8TC_POS   16U
#define DMA_IDR_CH8TC_MSK   BIT(DMA_IDR_CH8TC_POS)

#define DMA_IDR_CH7HT_POS   15U
#define DMA_IDR_CH7HT_MSK   BIT(DMA_IDR_CH7HT_POS)

#define DMA_IDR_CH7TC_POS   14U
#define DMA_IDR_CH7TC_MSK   BIT(DMA_IDR_CH7TC_POS)

#define DMA_IDR_CH6HT_POS   13U
#define DMA_IDR_CH6HT_MSK   BIT(DMA_IDR_CH6HT_POS)

#define DMA_IDR_CH6TC_POS   12U
#define DMA_IDR_CH6TC_MSK   BIT(DMA_IDR_CH6TC_POS)

#define DMA_IDR_CH5HT_POS   11U
#define DMA_IDR_CH5HT_MSK   BIT(DMA_IDR_CH5HT_POS)

#define DMA_IDR_CH5TC_POS   10U
#define DMA_IDR_CH5TC_MSK   BIT(DMA_IDR_CH5TC_POS)

#define DMA_IDR_CH4HT_POS   9U
#define DMA_IDR_CH4HT_MSK   BIT(DMA_IDR_CH4HT_POS)

#define DMA_IDR_CH4TC_POS   8U
#define DMA_IDR_CH4TC_MSK   BIT(DMA_IDR_CH4TC_POS)

#define DMA_IDR_CH3HT_POS   7U
#define DMA_IDR_CH3HT_MSK   BIT(DMA_IDR_CH3HT_POS)

#define DMA_IDR_CH3TC_POS   6U
#define DMA_IDR_CH3TC_MSK   BIT(DMA_IDR_CH3TC_POS)

#define DMA_IDR_CH2HT_POS   5U
#define DMA_IDR_CH2HT_MSK   BIT(DMA_IDR_CH2HT_POS)

#define DMA_IDR_CH2TC_POS   4U
#define DMA_IDR_CH2TC_MSK   BIT(DMA_IDR_CH2TC_POS)

#define DMA_IDR_CH1HT_POS   3U
#define DMA_IDR_CH1HT_MSK   BIT(DMA_IDR_CH1HT_POS)

#define DMA_IDR_CH1TC_POS   2U
#define DMA_IDR_CH1TC_MSK   BIT(DMA_IDR_CH1TC_POS)

#define DMA_IDR_CH0HT_POS   1U
#define DMA_IDR_CH0HT_MSK   BIT(DMA_IDR_CH0HT_POS)

#define DMA_IDR_CH0TC_POS   0U
#define DMA_IDR_CH0TC_MSK   BIT(DMA_IDR_CH0TC_POS)

/****************** Bit definition for DMA_IVS register ************************/

#define DMA_IVS_CH11HT_POS  23U
#define DMA_IVS_CH11HT_MSK  BIT(DMA_IVS_CH11HT_POS)

#define DMA_IVS_CH11TC_POS  22U
#define DMA_IVS_CH11TC_MSK  BIT(DMA_IVS_CH11TC_POS)

#define DMA_IVS_CH10HT_POS  21U
#define DMA_IVS_CH10HT_MSK  BIT(DMA_IVS_CH10HT_POS)

#define DMA_IVS_CH10TC_POS  20U
#define DMA_IVS_CH10TC_MSK  BIT(DMA_IVS_CH10TC_POS)

#define DMA_IVS_CH9HT_POS   19U
#define DMA_IVS_CH9HT_MSK   BIT(DMA_IVS_CH9HT_POS)

#define DMA_IVS_CH9TC_POS   18U
#define DMA_IVS_CH9TC_MSK   BIT(DMA_IVS_CH9TC_POS)

#define DMA_IVS_CH8HT_POS   17U
#define DMA_IVS_CH8HT_MSK   BIT(DMA_IVS_CH8HT_POS)

#define DMA_IVS_CH8TC_POS   16U
#define DMA_IVS_CH8TC_MSK   BIT(DMA_IVS_CH8TC_POS)

#define DMA_IVS_CH7HT_POS   15U
#define DMA_IVS_CH7HT_MSK   BIT(DMA_IVS_CH7HT_POS)

#define DMA_IVS_CH7TC_POS   14U
#define DMA_IVS_CH7TC_MSK   BIT(DMA_IVS_CH7TC_POS)

#define DMA_IVS_CH6HT_POS   13U
#define DMA_IVS_CH6HT_MSK   BIT(DMA_IVS_CH6HT_POS)

#define DMA_IVS_CH6TC_POS   12U
#define DMA_IVS_CH6TC_MSK   BIT(DMA_IVS_CH6TC_POS)

#define DMA_IVS_CH5HT_POS   11U
#define DMA_IVS_CH5HT_MSK   BIT(DMA_IVS_CH5HT_POS)

#define DMA_IVS_CH5TC_POS   10U
#define DMA_IVS_CH5TC_MSK   BIT(DMA_IVS_CH5TC_POS)

#define DMA_IVS_CH4HT_POS   9U
#define DMA_IVS_CH4HT_MSK   BIT(DMA_IVS_CH4HT_POS)

#define DMA_IVS_CH4TC_POS   8U
#define DMA_IVS_CH4TC_MSK   BIT(DMA_IVS_CH4TC_POS)

#define DMA_IVS_CH3HT_POS   7U
#define DMA_IVS_CH3HT_MSK   BIT(DMA_IVS_CH3HT_POS)

#define DMA_IVS_CH3TC_POS   6U
#define DMA_IVS_CH3TC_MSK   BIT(DMA_IVS_CH3TC_POS)

#define DMA_IVS_CH2HT_POS   5U
#define DMA_IVS_CH2HT_MSK   BIT(DMA_IVS_CH2HT_POS)

#define DMA_IVS_CH2TC_POS   4U
#define DMA_IVS_CH2TC_MSK   BIT(DMA_IVS_CH2TC_POS)

#define DMA_IVS_CH1HT_POS   3U
#define DMA_IVS_CH1HT_MSK   BIT(DMA_IVS_CH1HT_POS)

#define DMA_IVS_CH1TC_POS   2U
#define DMA_IVS_CH1TC_MSK   BIT(DMA_IVS_CH1TC_POS)

#define DMA_IVS_CH0HT_POS   1U
#define DMA_IVS_CH0HT_MSK   BIT(DMA_IVS_CH0HT_POS)

#define DMA_IVS_CH0TC_POS   0U
#define DMA_IVS_CH0TC_MSK   BIT(DMA_IVS_CH0TC_POS)

/****************** Bit definition for DMA_RIF register ************************/

#define DMA_RIF_CH11HT_POS  23U
#define DMA_RIF_CH11HT_MSK  BIT(DMA_RIF_CH11HT_POS)

#define DMA_RIF_CH11TC_POS  22U
#define DMA_RIF_CH11TC_MSK  BIT(DMA_RIF_CH11TC_POS)

#define DMA_RIF_CH10HT_POS  21U
#define DMA_RIF_CH10HT_MSK  BIT(DMA_RIF_CH10HT_POS)

#define DMA_RIF_CH10TC_POS  20U
#define DMA_RIF_CH10TC_MSK  BIT(DMA_RIF_CH10TC_POS)

#define DMA_RIF_CH9HT_POS   19U
#define DMA_RIF_CH9HT_MSK   BIT(DMA_RIF_CH9HT_POS)

#define DMA_RIF_CH9TC_POS   18U
#define DMA_RIF_CH9TC_MSK   BIT(DMA_RIF_CH9TC_POS)

#define DMA_RIF_CH8HT_POS   17U
#define DMA_RIF_CH8HT_MSK   BIT(DMA_RIF_CH8HT_POS)

#define DMA_RIF_CH8TC_POS   16U
#define DMA_RIF_CH8TC_MSK   BIT(DMA_RIF_CH8TC_POS)

#define DMA_RIF_CH7HT_POS   15U
#define DMA_RIF_CH7HT_MSK   BIT(DMA_RIF_CH7HT_POS)

#define DMA_RIF_CH7TC_POS   14U
#define DMA_RIF_CH7TC_MSK   BIT(DMA_RIF_CH7TC_POS)

#define DMA_RIF_CH6HT_POS   13U
#define DMA_RIF_CH6HT_MSK   BIT(DMA_RIF_CH6HT_POS)

#define DMA_RIF_CH6TC_POS   12U
#define DMA_RIF_CH6TC_MSK   BIT(DMA_RIF_CH6TC_POS)

#define DMA_RIF_CH5HT_POS   11U
#define DMA_RIF_CH5HT_MSK   BIT(DMA_RIF_CH5HT_POS)

#define DMA_RIF_CH5TC_POS   10U
#define DMA_RIF_CH5TC_MSK   BIT(DMA_RIF_CH5TC_POS)

#define DMA_RIF_CH4HT_POS   9U
#define DMA_RIF_CH4HT_MSK   BIT(DMA_RIF_CH4HT_POS)

#define DMA_RIF_CH4TC_POS   8U
#define DMA_RIF_CH4TC_MSK   BIT(DMA_RIF_CH4TC_POS)

#define DMA_RIF_CH3HT_POS   7U
#define DMA_RIF_CH3HT_MSK   BIT(DMA_RIF_CH3HT_POS)

#define DMA_RIF_CH3TC_POS   6U
#define DMA_RIF_CH3TC_MSK   BIT(DMA_RIF_CH3TC_POS)

#define DMA_RIF_CH2HT_POS   5U
#define DMA_RIF_CH2HT_MSK   BIT(DMA_RIF_CH2HT_POS)

#define DMA_RIF_CH2TC_POS   4U
#define DMA_RIF_CH2TC_MSK   BIT(DMA_RIF_CH2TC_POS)

#define DMA_RIF_CH1HT_POS   3U
#define DMA_RIF_CH1HT_MSK   BIT(DMA_RIF_CH1HT_POS)

#define DMA_RIF_CH1TC_POS   2U
#define DMA_RIF_CH1TC_MSK   BIT(DMA_RIF_CH1TC_POS)

#define DMA_RIF_CH0HT_POS   1U
#define DMA_RIF_CH0HT_MSK   BIT(DMA_RIF_CH0HT_POS)

#define DMA_RIF_CH0TC_POS   0U
#define DMA_RIF_CH0TC_MSK   BIT(DMA_RIF_CH0TC_POS)

/****************** Bit definition for DMA_IFM register ************************/

#define DMA_IFM_CH11HT_POS  23U
#define DMA_IFM_CH11HT_MSK  BIT(DMA_IFM_CH11HT_POS)

#define DMA_IFM_CH11TC_POS  22U
#define DMA_IFM_CH11TC_MSK  BIT(DMA_IFM_CH11TC_POS)

#define DMA_IFM_CH10HT_POS  21U
#define DMA_IFM_CH10HT_MSK  BIT(DMA_IFM_CH10HT_POS)

#define DMA_IFM_CH10TC_POS  20U
#define DMA_IFM_CH10TC_MSK  BIT(DMA_IFM_CH10TC_POS)

#define DMA_IFM_CH9HT_POS   19U
#define DMA_IFM_CH9HT_MSK   BIT(DMA_IFM_CH9HT_POS)

#define DMA_IFM_CH9TC_POS   18U
#define DMA_IFM_CH9TC_MSK   BIT(DMA_IFM_CH9TC_POS)

#define DMA_IFM_CH8HT_POS   17U
#define DMA_IFM_CH8HT_MSK   BIT(DMA_IFM_CH8HT_POS)

#define DMA_IFM_CH8TC_POS   16U
#define DMA_IFM_CH8TC_MSK   BIT(DMA_IFM_CH8TC_POS)

#define DMA_IFM_CH7HT_POS   15U
#define DMA_IFM_CH7HT_MSK   BIT(DMA_IFM_CH7HT_POS)

#define DMA_IFM_CH7TC_POS   14U
#define DMA_IFM_CH7TC_MSK   BIT(DMA_IFM_CH7TC_POS)

#define DMA_IFM_CH6HT_POS   13U
#define DMA_IFM_CH6HT_MSK   BIT(DMA_IFM_CH6HT_POS)

#define DMA_IFM_CH6TC_POS   12U
#define DMA_IFM_CH6TC_MSK   BIT(DMA_IFM_CH6TC_POS)

#define DMA_IFM_CH5HT_POS   11U
#define DMA_IFM_CH5HT_MSK   BIT(DMA_IFM_CH5HT_POS)

#define DMA_IFM_CH5TC_POS   10U
#define DMA_IFM_CH5TC_MSK   BIT(DMA_IFM_CH5TC_POS)

#define DMA_IFM_CH4HT_POS   9U
#define DMA_IFM_CH4HT_MSK   BIT(DMA_IFM_CH4HT_POS)

#define DMA_IFM_CH4TC_POS   8U
#define DMA_IFM_CH4TC_MSK   BIT(DMA_IFM_CH4TC_POS)

#define DMA_IFM_CH3HT_POS   7U
#define DMA_IFM_CH3HT_MSK   BIT(DMA_IFM_CH3HT_POS)

#define DMA_IFM_CH3TC_POS   6U
#define DMA_IFM_CH3TC_MSK   BIT(DMA_IFM_CH3TC_POS)

#define DMA_IFM_CH2HT_POS   5U
#define DMA_IFM_CH2HT_MSK   BIT(DMA_IFM_CH2HT_POS)

#define DMA_IFM_CH2TC_POS   4U
#define DMA_IFM_CH2TC_MSK   BIT(DMA_IFM_CH2TC_POS)

#define DMA_IFM_CH1HT_POS   3U
#define DMA_IFM_CH1HT_MSK   BIT(DMA_IFM_CH1HT_POS)

#define DMA_IFM_CH1TC_POS   2U
#define DMA_IFM_CH1TC_MSK   BIT(DMA_IFM_CH1TC_POS)

#define DMA_IFM_CH0HT_POS   1U
#define DMA_IFM_CH0HT_MSK   BIT(DMA_IFM_CH0HT_POS)

#define DMA_IFM_CH0TC_POS   0U
#define DMA_IFM_CH0TC_MSK   BIT(DMA_IFM_CH0TC_POS)

/****************** Bit definition for DMA_ICR register ************************/

#define DMA_ICR_CH11HT_POS  23U
#define DMA_ICR_CH11HT_MSK  BIT(DMA_ICR_CH11HT_POS)

#define DMA_ICR_CH11TC_POS  22U
#define DMA_ICR_CH11TC_MSK  BIT(DMA_ICR_CH11TC_POS)

#define DMA_ICR_CH10HT_POS  21U
#define DMA_ICR_CH10HT_MSK  BIT(DMA_ICR_CH10HT_POS)

#define DMA_ICR_CH10TC_POS  20U
#define DMA_ICR_CH10TC_MSK  BIT(DMA_ICR_CH10TC_POS)

#define DMA_ICR_CH9HT_POS   19U
#define DMA_ICR_CH9HT_MSK   BIT(DMA_ICR_CH9HT_POS)

#define DMA_ICR_CH9TC_POS   18U
#define DMA_ICR_CH9TC_MSK   BIT(DMA_ICR_CH9TC_POS)

#define DMA_ICR_CH8HT_POS   17U
#define DMA_ICR_CH8HT_MSK   BIT(DMA_ICR_CH8HT_POS)

#define DMA_ICR_CH8TC_POS   16U
#define DMA_ICR_CH8TC_MSK   BIT(DMA_ICR_CH8TC_POS)

#define DMA_ICR_CH7HT_POS   15U
#define DMA_ICR_CH7HT_MSK   BIT(DMA_ICR_CH7HT_POS)

#define DMA_ICR_CH7TC_POS   14U
#define DMA_ICR_CH7TC_MSK   BIT(DMA_ICR_CH7TC_POS)

#define DMA_ICR_CH6HT_POS   13U
#define DMA_ICR_CH6HT_MSK   BIT(DMA_ICR_CH6HT_POS)

#define DMA_ICR_CH6TC_POS   12U
#define DMA_ICR_CH6TC_MSK   BIT(DMA_ICR_CH6TC_POS)

#define DMA_ICR_CH5HT_POS   11U
#define DMA_ICR_CH5HT_MSK   BIT(DMA_ICR_CH5HT_POS)

#define DMA_ICR_CH5TC_POS   10U
#define DMA_ICR_CH5TC_MSK   BIT(DMA_ICR_CH5TC_POS)

#define DMA_ICR_CH4HT_POS   9U
#define DMA_ICR_CH4HT_MSK   BIT(DMA_ICR_CH4HT_POS)

#define DMA_ICR_CH4TC_POS   8U
#define DMA_ICR_CH4TC_MSK   BIT(DMA_ICR_CH4TC_POS)

#define DMA_ICR_CH3HT_POS   7U
#define DMA_ICR_CH3HT_MSK   BIT(DMA_ICR_CH3HT_POS)

#define DMA_ICR_CH3TC_POS   6U
#define DMA_ICR_CH3TC_MSK   BIT(DMA_ICR_CH3TC_POS)

#define DMA_ICR_CH2HT_POS   5U
#define DMA_ICR_CH2HT_MSK   BIT(DMA_ICR_CH2HT_POS)

#define DMA_ICR_CH2TC_POS   4U
#define DMA_ICR_CH2TC_MSK   BIT(DMA_ICR_CH2TC_POS)

#define DMA_ICR_CH1HT_POS   3U
#define DMA_ICR_CH1HT_MSK   BIT(DMA_ICR_CH1HT_POS)

#define DMA_ICR_CH1TC_POS   2U
#define DMA_ICR_CH1TC_MSK   BIT(DMA_ICR_CH1TC_POS)

#define DMA_ICR_CH0HT_POS   1U
#define DMA_ICR_CH0HT_MSK   BIT(DMA_ICR_CH0HT_POS)

#define DMA_ICR_CH0TC_POS   0U
#define DMA_ICR_CH0TC_MSK   BIT(DMA_ICR_CH0TC_POS)

/****************** Bit definition for DMA_CON register ************************/

#define DMA_CON_MAX_BURST_POSS  16U
#define DMA_CON_MAX_BURST_POSE  19U
#define DMA_CON_MAX_BURST_MSK   BITS(DMA_CON_MAX_BURST_POSS,DMA_CON_MAX_BURST_POSE)

#define DMA_CON_DDWSEL_POSS 13U
#define DMA_CON_DDWSEL_POSE 14U
#define DMA_CON_DDWSEL_MSK  BITS(DMA_CON_DDWSEL_POSS,DMA_CON_DDWSEL_POSE)

#define DMA_CON_DINC_POS    12U
#define DMA_CON_DINC_MSK    BIT(DMA_CON_DINC_POS)

#define DMA_CON_SDWSEL_POSS 9U
#define DMA_CON_SDWSEL_POSE 10U
#define DMA_CON_SDWSEL_MSK  BITS(DMA_CON_SDWSEL_POSS,DMA_CON_SDWSEL_POSE)

#define DMA_CON_SINC_POS    8U
#define DMA_CON_SINC_MSK    BIT(DMA_CON_SINC_POS)

#define DMA_CON_CHPRI_POSS  4U
#define DMA_CON_CHPRI_POSE  5U
#define DMA_CON_CHPRI_MSK   BITS(DMA_CON_CHPRI_POSS,DMA_CON_CHPRI_POSE)

#define DMA_CON_M2M_POS 3U
#define DMA_CON_M2M_MSK BIT(DMA_CON_M2M_POS)

#define DMA_CON_DIR_POS 2U
#define DMA_CON_DIR_MSK BIT(DMA_CON_DIR_POS)

#define DMA_CON_CIRC_POS    1U
#define DMA_CON_CIRC_MSK    BIT(DMA_CON_CIRC_POS)

#define DMA_CON_CHEN_POS    0U
#define DMA_CON_CHEN_MSK    BIT(DMA_CON_CHEN_POS)

/****************** Bit definition for DMA_SAR register ************************/

#define DMA_SAR_SAR_POSS    0U
#define DMA_SAR_SAR_POSE    31U
#define DMA_SAR_SAR_MSK BITS(DMA_SAR_SAR_POSS,DMA_SAR_SAR_POSE)

/****************** Bit definition for DMA_DAR register ************************/

#define DMA_DAR_DAR_POSS    0U
#define DMA_DAR_DAR_POSE    31U
#define DMA_DAR_DAR_MSK BITS(DMA_DAR_DAR_POSS,DMA_DAR_DAR_POSE)

/****************** Bit definition for DMA_NDT register ************************/

#define DMA_NDT_NRDT_POSS   16U
#define DMA_NDT_NRDT_POSE   31U
#define DMA_NDT_NRDT_MSK    BITS(DMA_NDT_NRDT_POSS,DMA_NDT_NRDT_POSE)

#define DMA_NDT_TNDT_POSS   0U
#define DMA_NDT_TNDT_POSE   15U
#define DMA_NDT_TNDT_MSK    BITS(DMA_NDT_TNDT_POSS,DMA_NDT_TNDT_POSE)

#define DMA_SELCON_MSIGSEL_POSS 0U
#define DMA_SELCON_MSIGSEL_POSE 6U
#define DMA_SELCON_MSIGSEL_MSK  BITS(DMA_SELCON_MSIGSEL_POSS,DMA_SELCON_MSIGSEL_POSE)

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CON;
    __IO uint32_t SAR;
    __IO uint32_t DAR;
    __IO uint32_t NDT;
} DMA_CHANNEL_TypeDef;

typedef struct
{
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __I uint32_t RESERVED[2];
    DMA_CHANNEL_TypeDef CH[DMA_CHANNELS];
} DMA_TypeDef;

typedef struct
{
    __IO uint32_t CH_SELCON[DMA_CHANNELS];
} DMA_MUX_TypeDef;

#endif /* __REG_DMA_H__ */
