/**********************************************************************************
 *
 * @file    reg_cmp.h
 * @brief   CMP Head File
 *
 * @date    6 Apr 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Apr 2023      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_CMP_H__
#define __REG_CMP_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for CMP_CFG1 register ************************/

# define  CMP_CFG1_LOCK_POS 31U
# define  CMP_CFG1_LOCK_MSK BIT(CMP_CFG1_LOCK_POS)
# define  CMP_CFG1_LOCK     CMP_CFG1_LOCK_MSK

# define  CMP_CFG1_VALUE_POS 30U
# define  CMP_CFG1_VALUE_MSK BIT(CMP_CFG1_VALUE_POS)
# define  CMP_CFG1_VALUE     CMP_CFG1_VALUE_MSK

# define  CMP_CFG1_BLANKSEL_POSS 19U
# define  CMP_CFG1_BLANKSEL_POSE 24U
# define  CMP_CFG1_BLANKSEL_MSK  BITS(CMP_CFG1_BLANKSEL_POSS, CMP_CFG1_BLANKSEL_POSE)
# define  CMP_CFG1_BLANKSEL      CMP_CFG1_BLANKSEL_MSK

# define  CMP_CFG1_HYST_POS 16U
# define  CMP_CFG1_HYST_MSK BIT(CMP_CFG1_HYST_POS)
# define  CMP_CFG1_HYST     CMP_CFG1_HYST_MSK

# define  CMP_CFG1_POLARITY_POS 15U
# define  CMP_CFG1_POLARITY_MSK BIT(CMP_CFG1_POLARITY_POS)
# define  CMP_CFG1_POLARITY     CMP_CFG1_POLARITY_MSK

# define  CMP_CFG1_INPSEL_POSS 8U
# define  CMP_CFG1_INPSEL_POSE 9U
# define  CMP_CFG1_INPSEL_MSK  BITS(CMP_CFG1_INPSEL_POSS, CMP_CFG1_INPSEL_POSE)
# define  CMP_CFG1_INPSEL      CMP_CFG1_INPSEL_MSK

# define  CMP_CFG1_INNSEL_POSS 4U
# define  CMP_CFG1_INNSEL_POSE 6U
# define  CMP_CFG1_INNSEL_MSK  BITS(CMP_CFG1_INNSEL_POSS, CMP_CFG1_INNSEL_POSE)
# define  CMP_CFG1_INNSEL      CMP_CFG1_INNSEL_MSK

# define  CMP_CFG1_EN_POS 0U
# define  CMP_CFG1_EN_MSK BIT(CMP_CFG1_EN_POS)
# define  CMP_CFG1_EN     CMP_CFG1_EN_MSK

/****************** Bit definition for CMP_CFG2 register ************************/

# define  CMP_CFG2_LOCK_POS 31U
# define  CMP_CFG2_LOCK_MSK BIT(CMP_CFG2_LOCK_POS)
# define  CMP_CFG2_LOCK     CMP_CFG2_LOCK_MSK

# define  CMP_CFG2_VALUE_POS 30U
# define  CMP_CFG2_VALUE_MSK BIT(CMP_CFG2_VALUE_POS)
# define  CMP_CFG2_VALUE     CMP_CFG2_VALUE_MSK

# define  CMP_CFG2_BLANKSEL_POSS 19U
# define  CMP_CFG2_BLANKSEL_POSE 24U
# define  CMP_CFG2_BLANKSEL_MSK  BITS(CMP_CFG2_BLANKSEL_POSS, CMP_CFG2_BLANKSEL_POSE)
# define  CMP_CFG2_BLANKSEL      CMP_CFG2_BLANKSEL_MSK

# define  CMP_CFG2_HYST_POS 16U
# define  CMP_CFG2_HYST_MSK BIT(CMP_CFG2_HYST_POS)
# define  CMP_CFG2_HYST     CMP_CFG2_HYST_MSK

# define  CMP_CFG2_POLARITY_POS 15U
# define  CMP_CFG2_POLARITY_MSK BIT(CMP_CFG2_POLARITY_POS)
# define  CMP_CFG2_POLARITY     CMP_CFG2_POLARITY_MSK

# define  CMP_CFG2_INPSEL_POSS 8U
# define  CMP_CFG2_INPSEL_POSE 9U
# define  CMP_CFG2_INPSEL_MSK  BITS(CMP_CFG2_INPSEL_POSS, CMP_CFG2_INPSEL_POSE)
# define  CMP_CFG2_INPSEL      CMP_CFG2_INPSEL_MSK

# define  CMP_CFG2_INNSEL_POSS 4U
# define  CMP_CFG2_INNSEL_POSE 6U
# define  CMP_CFG2_INNSEL_MSK  BITS(CMP_CFG2_INNSEL_POSS, CMP_CFG2_INNSEL_POSE)
# define  CMP_CFG2_INNSEL      CMP_CFG2_INNSEL_MSK

# define  CMP_CFG2_WINOUT_POS 3U
# define  CMP_CFG2_WINOUT_MSK BIT(CMP_CFG2_WINOUT_POS)
# define  CMP_CFG2_WINOUT     CMP_CFG2_WINOUT_MSK

# define  CMP_CFG2_WINMODE_POS 2U
# define  CMP_CFG2_WINMODE_MSK BIT(CMP_CFG2_WINMODE_POS)
# define  CMP_CFG2_WINMODE     CMP_CFG2_WINMODE_MSK

# define  CMP_CFG2_EN_POS 0U
# define  CMP_CFG2_EN_MSK BIT(CMP_CFG2_EN_POS)
# define  CMP_CFG2_EN     CMP_CFG2_EN_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CFG1;                     // 0x000
    __IO uint32_t CFG2;                     // 0x004
} CMP_TypeDef;

#endif /* __REG_CMP_H__ */
