/**********************************************************************************
 *
 * @file    reg_can.h
 * @brief   CAN Head File
 *
 * @date    30 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Mar 2023     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_CAN_H__
#define __REG_CAN_H__

/* Includes ------------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for CAN_CON register ************************/

# define	CAN_CON_DBGSTP_POS 16U 
# define	CAN_CON_DBGSTP_MSK BIT(CAN_CON_DBGSTP_POS) 
# define	CAN_CON_DBGSTP CAN_CON_DBGSTP_MSK 

# define	CAN_CON_RST_POS 15U 
# define	CAN_CON_RST_MSK BIT(CAN_CON_RST_POS) 
# define	CAN_CON_RST CAN_CON_RST_MSK 

# define	CAN_CON_TTCEN_POS 7U 
# define	CAN_CON_TTCEN_MSK BIT(CAN_CON_TTCEN_POS) 
# define	CAN_CON_TTCEN CAN_CON_TTCEN_MSK 

# define	CAN_CON_ABOFFEN_POS 6U 
# define	CAN_CON_ABOFFEN_MSK BIT(CAN_CON_ABOFFEN_POS) 
# define	CAN_CON_ABOFFEN CAN_CON_ABOFFEN_MSK 

# define	CAN_CON_AWKEN_POS 5U 
# define	CAN_CON_AWKEN_MSK BIT(CAN_CON_AWKEN_POS) 
# define	CAN_CON_AWKEN CAN_CON_AWKEN_MSK 

# define	CAN_CON_ARTXDIS_POS 4U 
# define	CAN_CON_ARTXDIS_MSK BIT(CAN_CON_ARTXDIS_POS) 
# define	CAN_CON_ARTXDIS CAN_CON_ARTXDIS_MSK 

# define	CAN_CON_RXFOPM_POS 3U 
# define	CAN_CON_RXFOPM_MSK BIT(CAN_CON_RXFOPM_POS) 
# define	CAN_CON_RXFOPM CAN_CON_RXFOPM_MSK 

# define	CAN_CON_TXMP_POS 2U 
# define	CAN_CON_TXMP_MSK BIT(CAN_CON_TXMP_POS) 
# define	CAN_CON_TXMP CAN_CON_TXMP_MSK 

# define	CAN_CON_SLPREQ_POS 1U 
# define	CAN_CON_SLPREQ_MSK BIT(CAN_CON_SLPREQ_POS) 
# define	CAN_CON_SLPREQ CAN_CON_SLPREQ_MSK 

# define	CAN_CON_INIREQ_POS 0U 
# define	CAN_CON_INIREQ_MSK BIT(CAN_CON_INIREQ_POS) 
# define	CAN_CON_INIREQ CAN_CON_INIREQ_MSK 

/****************** Bit definition for CAN_STAT register ************************/

# define	CAN_STAT_RX_POS 11U 
# define	CAN_STAT_RX_MSK BIT(CAN_STAT_RX_POS) 
# define	CAN_STAT_RX CAN_STAT_RX_MSK 

# define	CAN_STAT_PRESMP_POS 10U 
# define	CAN_STAT_PRESMP_MSK BIT(CAN_STAT_PRESMP_POS) 
# define	CAN_STAT_PRESMP CAN_STAT_PRESMP_MSK 

# define	CAN_STAT_RXSTAT_POS 9U 
# define	CAN_STAT_RXSTAT_MSK BIT(CAN_STAT_RXSTAT_POS) 
# define	CAN_STAT_RXSTAT CAN_STAT_RXSTAT_MSK 

# define	CAN_STAT_TXSTAT_POS 8U 
# define	CAN_STAT_TXSTAT_MSK BIT(CAN_STAT_TXSTAT_POS) 
# define	CAN_STAT_TXSTAT CAN_STAT_TXSTAT_MSK 

# define	CAN_STAT_SLPIF_POS 4U 
# define	CAN_STAT_SLPIF_MSK BIT(CAN_STAT_SLPIF_POS) 
# define	CAN_STAT_SLPIF CAN_STAT_SLPIF_MSK 

# define	CAN_STAT_WKIF_POS 3U 
# define	CAN_STAT_WKIF_MSK BIT(CAN_STAT_WKIF_POS) 
# define	CAN_STAT_WKIF CAN_STAT_WKIF_MSK 

# define	CAN_STAT_ERRIF_POS 2U 
# define	CAN_STAT_ERRIF_MSK BIT(CAN_STAT_ERRIF_POS) 
# define	CAN_STAT_ERRIF CAN_STAT_ERRIF_MSK 

# define	CAN_STAT_SLPSTAT_POS 1U 
# define	CAN_STAT_SLPSTAT_MSK BIT(CAN_STAT_SLPSTAT_POS) 
# define	CAN_STAT_SLPSTAT CAN_STAT_SLPSTAT_MSK 

# define	CAN_STAT_INISTAT_POS 0U 
# define	CAN_STAT_INISTAT_MSK BIT(CAN_STAT_INISTAT_POS) 
# define	CAN_STAT_INISTAT CAN_STAT_INISTAT_MSK 

/****************** Bit definition for CAN_IFC register ************************/

# define	CAN_IFC_SLPIFC_POS 4U 
# define	CAN_IFC_SLPIFC_MSK BIT(CAN_IFC_SLPIFC_POS) 
# define	CAN_IFC_SLPIFC CAN_IFC_SLPIFC_MSK 

# define	CAN_IFC_WKIFC_POS 3U 
# define	CAN_IFC_WKIFC_MSK BIT(CAN_IFC_WKIFC_POS) 
# define	CAN_IFC_WKIFC CAN_IFC_WKIFC_MSK 

# define	CAN_IFC_ERRIFC_POS 2U 
# define	CAN_IFC_ERRIFC_MSK BIT(CAN_IFC_ERRIFC_POS) 
# define	CAN_IFC_ERRIFC CAN_IFC_ERRIFC_MSK 

/****************** Bit definition for CAN_TXSTAT register ************************/

# define	CAN_TXSTAT_TXM2LPF_POS 31U 
# define	CAN_TXSTAT_TXM2LPF_MSK BIT(CAN_TXSTAT_TXM2LPF_POS) 
# define	CAN_TXSTAT_TXM2LPF CAN_TXSTAT_TXM2LPF_MSK 

# define	CAN_TXSTAT_TXM1LPF_POS 30U 
# define	CAN_TXSTAT_TXM1LPF_MSK BIT(CAN_TXSTAT_TXM1LPF_POS) 
# define	CAN_TXSTAT_TXM1LPF CAN_TXSTAT_TXM1LPF_MSK 

# define	CAN_TXSTAT_TXM0LPF_POS 29U 
# define	CAN_TXSTAT_TXM0LPF_MSK BIT(CAN_TXSTAT_TXM0LPF_POS) 
# define	CAN_TXSTAT_TXM0LPF CAN_TXSTAT_TXM0LPF_MSK 

# define	CAN_TXSTAT_TXM2EF_POS 28U 
# define	CAN_TXSTAT_TXM2EF_MSK BIT(CAN_TXSTAT_TXM2EF_POS) 
# define	CAN_TXSTAT_TXM2EF CAN_TXSTAT_TXM2EF_MSK 

# define	CAN_TXSTAT_TXM1EF_POS 27U 
# define	CAN_TXSTAT_TXM1EF_MSK BIT(CAN_TXSTAT_TXM1EF_POS) 
# define	CAN_TXSTAT_TXM1EF CAN_TXSTAT_TXM1EF_MSK 

# define	CAN_TXSTAT_TXM0EF_POS 26U 
# define	CAN_TXSTAT_TXM0EF_MSK BIT(CAN_TXSTAT_TXM0EF_POS) 
# define	CAN_TXSTAT_TXM0EF CAN_TXSTAT_TXM0EF_MSK 

# define	CAN_TXSTAT_CODE_POSS 24U 
# define	CAN_TXSTAT_CODE_POSE 25U 
# define	CAN_TXSTAT_CODE_MSK BITS(CAN_TXSTAT_CODE_POSS, CAN_TXSTAT_CODE_POSE) 
# define	CAN_TXSTAT_CODE CAN_TXSTAT_CODE_MSK 

# define	CAN_TXSTAT_M2STPREQ_POS 23U 
# define	CAN_TXSTAT_M2STPREQ_MSK BIT(CAN_TXSTAT_M2STPREQ_POS) 
# define	CAN_TXSTAT_M2STPREQ CAN_TXSTAT_M2STPREQ_MSK 

# define	CAN_TXSTAT_M2TXERR_POS 19U 
# define	CAN_TXSTAT_M2TXERR_MSK BIT(CAN_TXSTAT_M2TXERR_POS) 
# define	CAN_TXSTAT_M2TXERR CAN_TXSTAT_M2TXERR_MSK 

# define	CAN_TXSTAT_M2ARBLST_POS 18U 
# define	CAN_TXSTAT_M2ARBLST_MSK BIT(CAN_TXSTAT_M2ARBLST_POS) 
# define	CAN_TXSTAT_M2ARBLST CAN_TXSTAT_M2ARBLST_MSK 

# define	CAN_TXSTAT_M2TXC_POS 17U 
# define	CAN_TXSTAT_M2TXC_MSK BIT(CAN_TXSTAT_M2TXC_POS) 
# define	CAN_TXSTAT_M2TXC CAN_TXSTAT_M2TXC_MSK 

# define	CAN_TXSTAT_M2REQC_POS 16U 
# define	CAN_TXSTAT_M2REQC_MSK BIT(CAN_TXSTAT_M2REQC_POS) 
# define	CAN_TXSTAT_M2REQC CAN_TXSTAT_M2REQC_MSK 

# define	CAN_TXSTAT_M1STPREQ_POS 15U 
# define	CAN_TXSTAT_M1STPREQ_MSK BIT(CAN_TXSTAT_M1STPREQ_POS) 
# define	CAN_TXSTAT_M1STPREQ CAN_TXSTAT_M1STPREQ_MSK 

# define	CAN_TXSTAT_M1TXERR_POS 11U 
# define	CAN_TXSTAT_M1TXERR_MSK BIT(CAN_TXSTAT_M1TXERR_POS) 
# define	CAN_TXSTAT_M1TXERR CAN_TXSTAT_M1TXERR_MSK 

# define	CAN_TXSTAT_M1ARBLST_POS 10U 
# define	CAN_TXSTAT_M1ARBLST_MSK BIT(CAN_TXSTAT_M1ARBLST_POS) 
# define	CAN_TXSTAT_M1ARBLST CAN_TXSTAT_M1ARBLST_MSK 

# define	CAN_TXSTAT_M1TXC_POS 9U 
# define	CAN_TXSTAT_M1TXC_MSK BIT(CAN_TXSTAT_M1TXC_POS) 
# define	CAN_TXSTAT_M1TXC CAN_TXSTAT_M1TXC_MSK 

# define	CAN_TXSTAT_M1REQC_POS 8U 
# define	CAN_TXSTAT_M1REQC_MSK BIT(CAN_TXSTAT_M1REQC_POS) 
# define	CAN_TXSTAT_M1REQC CAN_TXSTAT_M1REQC_MSK 

# define	CAN_TXSTAT_M0STPREQ_POS 7U 
# define	CAN_TXSTAT_M0STPREQ_MSK BIT(CAN_TXSTAT_M0STPREQ_POS) 
# define	CAN_TXSTAT_M0STPREQ CAN_TXSTAT_M0STPREQ_MSK 

# define	CAN_TXSTAT_M0TXERR_POS 3U 
# define	CAN_TXSTAT_M0TXERR_MSK BIT(CAN_TXSTAT_M0TXERR_POS) 
# define	CAN_TXSTAT_M0TXERR CAN_TXSTAT_M0TXERR_MSK 

# define	CAN_TXSTAT_M0ARBLST_POS 2U 
# define	CAN_TXSTAT_M0ARBLST_MSK BIT(CAN_TXSTAT_M0ARBLST_POS) 
# define	CAN_TXSTAT_M0ARBLST CAN_TXSTAT_M0ARBLST_MSK 

# define	CAN_TXSTAT_M0TXC_POS 1U 
# define	CAN_TXSTAT_M0TXC_MSK BIT(CAN_TXSTAT_M0TXC_POS) 
# define	CAN_TXSTAT_M0TXC CAN_TXSTAT_M0TXC_MSK 

# define	CAN_TXSTAT_M0REQC_POS 0U 
# define	CAN_TXSTAT_M0REQC_MSK BIT(CAN_TXSTAT_M0REQC_POS) 
# define	CAN_TXSTAT_M0REQC CAN_TXSTAT_M0REQC_MSK 

/****************** Bit definition for CAN_TXSTATC register ************************/

# define	CAN_TXSTATC_M2TXERR_POS 19U 
# define	CAN_TXSTATC_M2TXERR_MSK BIT(CAN_TXSTATC_M2TXERR_POS) 
# define	CAN_TXSTATC_M2TXERR CAN_TXSTATC_M2TXERR_MSK 

# define	CAN_TXSTATC_M2ARBLST_POS 18U 
# define	CAN_TXSTATC_M2ARBLST_MSK BIT(CAN_TXSTATC_M2ARBLST_POS) 
# define	CAN_TXSTATC_M2ARBLST CAN_TXSTATC_M2ARBLST_MSK 

# define	CAN_TXSTATC_M2TXC_POS 17U 
# define	CAN_TXSTATC_M2TXC_MSK BIT(CAN_TXSTATC_M2TXC_POS) 
# define	CAN_TXSTATC_M2TXC CAN_TXSTATC_M2TXC_MSK 

# define	CAN_TXSTATC_M2REQC_POS 16U 
# define	CAN_TXSTATC_M2REQC_MSK BIT(CAN_TXSTATC_M2REQC_POS) 
# define	CAN_TXSTATC_M2REQC CAN_TXSTATC_M2REQC_MSK 

# define	CAN_TXSTATC_M1TXERR_POS 11U 
# define	CAN_TXSTATC_M1TXERR_MSK BIT(CAN_TXSTATC_M1TXERR_POS) 
# define	CAN_TXSTATC_M1TXERR CAN_TXSTATC_M1TXERR_MSK 

# define	CAN_TXSTATC_M1ARBLST_POS 10U 
# define	CAN_TXSTATC_M1ARBLST_MSK BIT(CAN_TXSTATC_M1ARBLST_POS) 
# define	CAN_TXSTATC_M1ARBLST CAN_TXSTATC_M1ARBLST_MSK 

# define	CAN_TXSTATC_M1TXC_POS 9U 
# define	CAN_TXSTATC_M1TXC_MSK BIT(CAN_TXSTATC_M1TXC_POS) 
# define	CAN_TXSTATC_M1TXC CAN_TXSTATC_M1TXC_MSK 

# define	CAN_TXSTATC_M1REQC_POS 8U 
# define	CAN_TXSTATC_M1REQC_MSK BIT(CAN_TXSTATC_M1REQC_POS) 
# define	CAN_TXSTATC_M1REQC CAN_TXSTATC_M1REQC_MSK 

# define	CAN_TXSTATC_M0TXERR_POS 3U 
# define	CAN_TXSTATC_M0TXERR_MSK BIT(CAN_TXSTATC_M0TXERR_POS) 
# define	CAN_TXSTATC_M0TXERR CAN_TXSTATC_M0TXERR_MSK 

# define	CAN_TXSTATC_M0ARBLST_POS 2U 
# define	CAN_TXSTATC_M0ARBLST_MSK BIT(CAN_TXSTATC_M0ARBLST_POS) 
# define	CAN_TXSTATC_M0ARBLST CAN_TXSTATC_M0ARBLST_MSK 

# define	CAN_TXSTATC_M0TXC_POS 1U 
# define	CAN_TXSTATC_M0TXC_MSK BIT(CAN_TXSTATC_M0TXC_POS) 
# define	CAN_TXSTATC_M0TXC CAN_TXSTATC_M0TXC_MSK 

# define	CAN_TXSTATC_M0REQC_POS 0U 
# define	CAN_TXSTATC_M0REQC_MSK BIT(CAN_TXSTATC_M0REQC_POS) 
# define	CAN_TXSTATC_M0REQC CAN_TXSTATC_M0REQC_MSK 

/****************** Bit definition for CAN_RXF0 register ************************/

# define	CAN_RXF0_FREE_POS 5U 
# define	CAN_RXF0_FREE_MSK BIT(CAN_RXF0_FREE_POS) 
# define	CAN_RXF0_FREE CAN_RXF0_FREE_MSK 

# define	CAN_RXF0_OVR_POS 4U 
# define	CAN_RXF0_OVR_MSK BIT(CAN_RXF0_OVR_POS) 
# define	CAN_RXF0_OVR CAN_RXF0_OVR_MSK 

# define	CAN_RXF0_FULL_POS 3U 
# define	CAN_RXF0_FULL_MSK BIT(CAN_RXF0_FULL_POS) 
# define	CAN_RXF0_FULL CAN_RXF0_FULL_MSK 

# define	CAN_RXF0_PEND_POSS 0U 
# define	CAN_RXF0_PEND_POSE 1U 
# define	CAN_RXF0_PEND_MSK BITS(CAN_RXF0_PEND_POSS, CAN_RXF0_PEND_POSE) 
# define	CAN_RXF0_PEND CAN_RXF0_PEND_MSK 

/****************** Bit definition for CAN_RXF0C register ************************/

# define	CAN_RXF0C_OVRC_POS 4U 
# define	CAN_RXF0C_OVRC_MSK BIT(CAN_RXF0C_OVRC_POS) 
# define	CAN_RXF0C_OVRC CAN_RXF0C_OVRC_MSK 

# define	CAN_RXF0C_FULLC_POS 3U 
# define	CAN_RXF0C_FULLC_MSK BIT(CAN_RXF0C_FULLC_POS) 
# define	CAN_RXF0C_FULLC CAN_RXF0C_FULLC_MSK 

/****************** Bit definition for CAN_RXF1 register ************************/

# define	CAN_RXF1_FREE_POS 5U 
# define	CAN_RXF1_FREE_MSK BIT(CAN_RXF1_FREE_POS) 
# define	CAN_RXF1_FREE CAN_RXF1_FREE_MSK 

# define	CAN_RXF1_OVR_POS 4U 
# define	CAN_RXF1_OVR_MSK BIT(CAN_RXF1_OVR_POS) 
# define	CAN_RXF1_OVR CAN_RXF1_OVR_MSK 

# define	CAN_RXF1_FULL_POS 3U 
# define	CAN_RXF1_FULL_MSK BIT(CAN_RXF1_FULL_POS) 
# define	CAN_RXF1_FULL CAN_RXF1_FULL_MSK 

# define	CAN_RXF1_PEND_POSS 0U 
# define	CAN_RXF1_PEND_POSE 1U 
# define	CAN_RXF1_PEND_MSK BITS(CAN_RXF1_PEND_POSS, CAN_RXF1_PEND_POSE) 
# define	CAN_RXF1_PEND CAN_RXF1_PEND_MSK 

/****************** Bit definition for CAN_RXF1C register ************************/

# define	CAN_RXF1C_OVRC_POS 4U 
# define	CAN_RXF1C_OVRC_MSK BIT(CAN_RXF1C_OVRC_POS) 
# define	CAN_RXF1C_OVRC CAN_RXF1C_OVRC_MSK 

# define	CAN_RXF1C_FULLC_POS 3U 
# define	CAN_RXF1C_FULLC_MSK BIT(CAN_RXF1C_FULLC_POS) 
# define	CAN_RXF1C_FULLC CAN_RXF1C_FULLC_MSK 

/****************** Bit definition for CAN_IE register ************************/

# define	CAN_IE_SLPIE_POS 17U 
# define	CAN_IE_SLPIE_MSK BIT(CAN_IE_SLPIE_POS) 
# define	CAN_IE_SLPIE CAN_IE_SLPIE_MSK 

# define	CAN_IE_WKIE_POS 16U 
# define	CAN_IE_WKIE_MSK BIT(CAN_IE_WKIE_POS) 
# define	CAN_IE_WKIE CAN_IE_WKIE_MSK 

# define	CAN_IE_ERRIE_POS 15U 
# define	CAN_IE_ERRIE_MSK BIT(CAN_IE_ERRIE_POS) 
# define	CAN_IE_ERRIE CAN_IE_ERRIE_MSK 

# define	CAN_IE_PRERRIE_POS 11U 
# define	CAN_IE_PRERRIE_MSK BIT(CAN_IE_PRERRIE_POS) 
# define	CAN_IE_PRERRIE CAN_IE_PRERRIE_MSK 

# define	CAN_IE_BOFFIE_POS 10U 
# define	CAN_IE_BOFFIE_MSK BIT(CAN_IE_BOFFIE_POS) 
# define	CAN_IE_BOFFIE CAN_IE_BOFFIE_MSK 

# define	CAN_IE_PERRIE_POS 9U 
# define	CAN_IE_PERRIE_MSK BIT(CAN_IE_PERRIE_POS) 
# define	CAN_IE_PERRIE CAN_IE_PERRIE_MSK 

# define	CAN_IE_WARNIE_POS 8U 
# define	CAN_IE_WARNIE_MSK BIT(CAN_IE_WARNIE_POS) 
# define	CAN_IE_WARNIE CAN_IE_WARNIE_MSK 

# define	CAN_IE_F1OVRIE_POS 6U 
# define	CAN_IE_F1OVRIE_MSK BIT(CAN_IE_F1OVRIE_POS) 
# define	CAN_IE_F1OVRIE CAN_IE_F1OVRIE_MSK 

# define	CAN_IE_F1FULIE_POS 5U 
# define	CAN_IE_F1FULIE_MSK BIT(CAN_IE_F1FULIE_POS) 
# define	CAN_IE_F1FULIE CAN_IE_F1FULIE_MSK 

# define	CAN_IE_F1PIE_POS 4U 
# define	CAN_IE_F1PIE_MSK BIT(CAN_IE_F1PIE_POS) 
# define	CAN_IE_F1PIE CAN_IE_F1PIE_MSK 

# define	CAN_IE_F0OVRIE_POS 3U 
# define	CAN_IE_F0OVRIE_MSK BIT(CAN_IE_F0OVRIE_POS) 
# define	CAN_IE_F0OVRIE CAN_IE_F0OVRIE_MSK 

# define	CAN_IE_F0FULIE_POS 2U 
# define	CAN_IE_F0FULIE_MSK BIT(CAN_IE_F0FULIE_POS) 
# define	CAN_IE_F0FULIE CAN_IE_F0FULIE_MSK 

# define	CAN_IE_F0PIE_POS 1U 
# define	CAN_IE_F0PIE_MSK BIT(CAN_IE_F0PIE_POS) 
# define	CAN_IE_F0PIE CAN_IE_F0PIE_MSK 

# define	CAN_IE_TXMEIE_POS 0U 
# define	CAN_IE_TXMEIE_MSK BIT(CAN_IE_TXMEIE_POS) 
# define	CAN_IE_TXMEIE CAN_IE_TXMEIE_MSK 

/****************** Bit definition for CAN_ERRSTAT register ************************/

# define	CAN_ERRSTAT_RXERRC_POSS 24U 
# define	CAN_ERRSTAT_RXERRC_POSE 31U 
# define	CAN_ERRSTAT_RXERRC_MSK BITS(CAN_ERRSTAT_RXERRC_POSS, CAN_ERRSTAT_RXERRC_POSE) 
# define	CAN_ERRSTAT_RXERRC CAN_ERRSTAT_RXERRC_MSK 

# define	CAN_ERRSTAT_TXERRC_POSS 16U 
# define	CAN_ERRSTAT_TXERRC_POSE 23U 
# define	CAN_ERRSTAT_TXERRC_MSK BITS(CAN_ERRSTAT_TXERRC_POSS, CAN_ERRSTAT_TXERRC_POSE) 
# define	CAN_ERRSTAT_TXERRC CAN_ERRSTAT_TXERRC_MSK 

# define	CAN_ERRSTAT_PRERRF_POSS 4U 
# define	CAN_ERRSTAT_PRERRF_POSE 6U 
# define	CAN_ERRSTAT_PRERRF_MSK BITS(CAN_ERRSTAT_PRERRF_POSS, CAN_ERRSTAT_PRERRF_POSE) 
# define	CAN_ERRSTAT_PRERRF CAN_ERRSTAT_PRERRF_MSK 

# define	CAN_ERRSTAT_BOFF_POS 2U 
# define	CAN_ERRSTAT_BOFF_MSK BIT(CAN_ERRSTAT_BOFF_POS) 
# define	CAN_ERRSTAT_BOFF CAN_ERRSTAT_BOFF_MSK 

# define	CAN_ERRSTAT_PERRF_POS 1U 
# define	CAN_ERRSTAT_PERRF_MSK BIT(CAN_ERRSTAT_PERRF_POS) 
# define	CAN_ERRSTAT_PERRF CAN_ERRSTAT_PERRF_MSK 

# define	CAN_ERRSTAT_WARNF_POS 0U 
# define	CAN_ERRSTAT_WARNF_MSK BIT(CAN_ERRSTAT_WARNF_POS) 
# define	CAN_ERRSTAT_WARNF CAN_ERRSTAT_WARNF_MSK 

/****************** Bit definition for CAN_BTIME register ************************/

# define	CAN_BTIME_SILENT_POS 31U 
# define	CAN_BTIME_SILENT_MSK BIT(CAN_BTIME_SILENT_POS) 
# define	CAN_BTIME_SILENT CAN_BTIME_SILENT_MSK 

# define	CAN_BTIME_LOOP_POS 30U 
# define	CAN_BTIME_LOOP_MSK BIT(CAN_BTIME_LOOP_POS) 
# define	CAN_BTIME_LOOP CAN_BTIME_LOOP_MSK 

# define	CAN_BTIME_RESJW_POSS 24U 
# define	CAN_BTIME_RESJW_POSE 25U 
# define	CAN_BTIME_RESJW_MSK BITS(CAN_BTIME_RESJW_POSS, CAN_BTIME_RESJW_POSE) 
# define	CAN_BTIME_RESJW CAN_BTIME_RESJW_MSK 

# define	CAN_BTIME_SEG2_POSS 20U 
# define	CAN_BTIME_SEG2_POSE 22U 
# define	CAN_BTIME_SEG2_MSK BITS(CAN_BTIME_SEG2_POSS, CAN_BTIME_SEG2_POSE) 
# define	CAN_BTIME_SEG2 CAN_BTIME_SEG2_MSK 

# define	CAN_BTIME_SEG1_POSS 16U 
# define	CAN_BTIME_SEG1_POSE 19U 
# define	CAN_BTIME_SEG1_MSK BITS(CAN_BTIME_SEG1_POSS, CAN_BTIME_SEG1_POSE) 
# define	CAN_BTIME_SEG1 CAN_BTIME_SEG1_MSK 

# define	CAN_BTIME_BPSC_POSS 0U 
# define	CAN_BTIME_BPSC_POSE 8U 
# define	CAN_BTIME_BPSC_MSK BITS(CAN_BTIME_BPSC_POSS, CAN_BTIME_BPSC_POSE) 
# define	CAN_BTIME_BPSC CAN_BTIME_BPSC_MSK 

/****************** Bit definition for CAN_TXID0 register ************************/

# define	CAN_TXID0_STDID10_0_EXID28_18_POSS 21U 
# define	CAN_TXID0_STDID10_0_EXID28_18_POSE 31U 
# define	CAN_TXID0_STDID10_0_EXID28_18_MSK  BITS(CAN_TXID0_STDID10_0_EXID28_18_POSS, CAN_TXID0_STDID10_0_EXID28_18_POSE) 
# define	CAN_TXID0_STDID10_0_EXID28_18      CAN_TXID0_STDID10_0_EXID28_18_MSK

# define	CAN_TXID0_EXID17_0_POSS 3U 
# define	CAN_TXID0_EXID17_0_POSE 20U 
# define	CAN_TXID0_EXID17_0_MSK  BITS(CAN_TXID0_EXID17_0_POSS, CAN_TXID0_EXID17_0_POSE) 
# define	CAN_TXID0_EXID17_0      CAN_TXID0_EXID17_0_MSK

# define	CAN_TXID0_IDE_POS 2U 
# define	CAN_TXID0_IDE_MSK BIT(CAN_TXID0_IDE_POS) 
# define	CAN_TXID0_IDE CAN_TXID0_IDE_MSK 

# define	CAN_TXID0_RTR_POS 1U 
# define	CAN_TXID0_RTR_MSK BIT(CAN_TXID0_RTR_POS) 
# define	CAN_TXID0_RTR CAN_TXID0_RTR_MSK 

# define	CAN_TXID0_TXMREQ_POS 0U 
# define	CAN_TXID0_TXMREQ_MSK BIT(CAN_TXID0_TXMREQ_POS) 
# define	CAN_TXID0_TXMREQ CAN_TXID0_TXMREQ_MSK 

/****************** Bit definition for CAN_TXFCON0 register ************************/

# define	CAN_TXFCON0_STAMP_POSS 16U 
# define	CAN_TXFCON0_STAMP_POSE 31U 
# define	CAN_TXFCON0_STAMP_MSK BITS(CAN_TXFCON0_STAMP_POSS, CAN_TXFCON0_STAMP_POSE) 
# define	CAN_TXFCON0_STAMP CAN_TXFCON0_STAMP_MSK 

# define	CAN_TXFCON0_TXGT_POS 8U 
# define	CAN_TXFCON0_TXGT_MSK BIT(CAN_TXFCON0_TXGT_POS) 
# define	CAN_TXFCON0_TXGT CAN_TXFCON0_TXGT_MSK 

# define	CAN_TXFCON0_DLEN_POSS 0U 
# define	CAN_TXFCON0_DLEN_POSE 3U 
# define	CAN_TXFCON0_DLEN_MSK BITS(CAN_TXFCON0_DLEN_POSS, CAN_TXFCON0_DLEN_POSE) 
# define	CAN_TXFCON0_DLEN CAN_TXFCON0_DLEN_MSK 

/****************** Bit definition for CAN_TXDL0 register ************************/

# define	CAN_TXDL0_BYTE3_POSS 24U 
# define	CAN_TXDL0_BYTE3_POSE 31U 
# define	CAN_TXDL0_BYTE3_MSK BITS(CAN_TXDL0_BYTE3_POSS, CAN_TXDL0_BYTE3_POSE) 
# define	CAN_TXDL0_BYTE3 CAN_TXDL0_BYTE3_MSK 

# define	CAN_TXDL0_BYTE2_POSS 16U 
# define	CAN_TXDL0_BYTE2_POSE 23U 
# define	CAN_TXDL0_BYTE2_MSK BITS(CAN_TXDL0_BYTE2_POSS, CAN_TXDL0_BYTE2_POSE) 
# define	CAN_TXDL0_BYTE2 CAN_TXDL0_BYTE2_MSK 

# define	CAN_TXDL0_BYTE1_POSS 8U 
# define	CAN_TXDL0_BYTE1_POSE 15U 
# define	CAN_TXDL0_BYTE1_MSK BITS(CAN_TXDL0_BYTE1_POSS, CAN_TXDL0_BYTE1_POSE) 
# define	CAN_TXDL0_BYTE1 CAN_TXDL0_BYTE1_MSK 

# define	CAN_TXDL0_BYTE0_POSS 0U 
# define	CAN_TXDL0_BYTE0_POSE 7U 
# define	CAN_TXDL0_BYTE0_MSK BITS(CAN_TXDL0_BYTE0_POSS, CAN_TXDL0_BYTE0_POSE) 
# define	CAN_TXDL0_BYTE0 CAN_TXDL0_BYTE0_MSK 

/****************** Bit definition for CAN_TXDH0 register ************************/

# define	CAN_TXDH0_BYTE7_POSS 24U 
# define	CAN_TXDH0_BYTE7_POSE 31U 
# define	CAN_TXDH0_BYTE7_MSK BITS(CAN_TXDH0_BYTE7_POSS, CAN_TXDH0_BYTE7_POSE) 
# define	CAN_TXDH0_BYTE7 CAN_TXDH0_BYTE7_MSK 

# define	CAN_TXDH0_BYTE6_POSS 16U 
# define	CAN_TXDH0_BYTE6_POSE 23U 
# define	CAN_TXDH0_BYTE6_MSK BITS(CAN_TXDH0_BYTE6_POSS, CAN_TXDH0_BYTE6_POSE) 
# define	CAN_TXDH0_BYTE6 CAN_TXDH0_BYTE6_MSK 

# define	CAN_TXDH0_BYTE5_POSS 8U 
# define	CAN_TXDH0_BYTE5_POSE 15U 
# define	CAN_TXDH0_BYTE5_MSK BITS(CAN_TXDH0_BYTE5_POSS, CAN_TXDH0_BYTE5_POSE) 
# define	CAN_TXDH0_BYTE5 CAN_TXDH0_BYTE5_MSK 

# define	CAN_TXDH0_BYTE4_POSS 0U 
# define	CAN_TXDH0_BYTE4_POSE 7U 
# define	CAN_TXDH0_BYTE4_MSK BITS(CAN_TXDH0_BYTE4_POSS, CAN_TXDH0_BYTE4_POSE) 
# define	CAN_TXDH0_BYTE4 CAN_TXDH0_BYTE4_MSK 

/****************** Bit definition for CAN_TXID1 register ************************/

# define	CAN_TXID1_STDID10_0_EXID28_18_POSS 21U 
# define	CAN_TXID1_STDID10_0_EXID28_18_POSE 31U 
# define	CAN_TXID1_STDID10_0_EXID28_18_MSK  BITS(CAN_TXID1_STDID10_0_EXID28_18_POSS, CAN_TXID1_STDID10_0_EXID28_18_POSE) 
# define	CAN_TXID1_STDID10_0_EXID28_18      CAN_TXID1_STDID10_0_EXID28_18_MSK

# define	CAN_TXID1_EXID17_0_POSS 3U 
# define	CAN_TXID1_EXID17_0_POSE 20U 
# define	CAN_TXID1_EXID17_0_MSK  BITS(CAN_TXID1_EXID17_0_POSS, CAN_TXID1_EXID17_0_POSE) 
# define	CAN_TXID1_EXID17_0      CAN_TXID1_EXID17_0_MSK

# define	CAN_TXID1_IDE_POS 2U 
# define	CAN_TXID1_IDE_MSK BIT(CAN_TXID1_IDE_POS) 
# define	CAN_TXID1_IDE CAN_TXID1_IDE_MSK 

# define	CAN_TXID1_RTR_POS 1U 
# define	CAN_TXID1_RTR_MSK BIT(CAN_TXID1_RTR_POS) 
# define	CAN_TXID1_RTR CAN_TXID1_RTR_MSK 

# define	CAN_TXID1_TXMREQ_POS 0U 
# define	CAN_TXID1_TXMREQ_MSK BIT(CAN_TXID1_TXMREQ_POS) 
# define	CAN_TXID1_TXMREQ CAN_TXID1_TXMREQ_MSK 

/****************** Bit definition for CAN_TXFCON1 register ************************/

# define	CAN_TXFCON1_STAMP_POSS 16U 
# define	CAN_TXFCON1_STAMP_POSE 31U 
# define	CAN_TXFCON1_STAMP_MSK BITS(CAN_TXFCON1_STAMP_POSS, CAN_TXFCON1_STAMP_POSE) 
# define	CAN_TXFCON1_STAMP CAN_TXFCON1_STAMP_MSK 

# define	CAN_TXFCON1_TXGT_POS 8U 
# define	CAN_TXFCON1_TXGT_MSK BIT(CAN_TXFCON1_TXGT_POS) 
# define	CAN_TXFCON1_TXGT CAN_TXFCON1_TXGT_MSK 

# define	CAN_TXFCON1_DLEN_POSS 0U 
# define	CAN_TXFCON1_DLEN_POSE 3U 
# define	CAN_TXFCON1_DLEN_MSK BITS(CAN_TXFCON1_DLEN_POSS, CAN_TXFCON1_DLEN_POSE) 
# define	CAN_TXFCON1_DLEN CAN_TXFCON1_DLEN_MSK 

/****************** Bit definition for CAN_TXDL1 register ************************/

# define	CAN_TXDL1_BYTE3_POSS 24U 
# define	CAN_TXDL1_BYTE3_POSE 31U 
# define	CAN_TXDL1_BYTE3_MSK BITS(CAN_TXDL1_BYTE3_POSS, CAN_TXDL1_BYTE3_POSE) 
# define	CAN_TXDL1_BYTE3 CAN_TXDL1_BYTE3_MSK 

# define	CAN_TXDL1_BYTE2_POSS 16U 
# define	CAN_TXDL1_BYTE2_POSE 23U 
# define	CAN_TXDL1_BYTE2_MSK BITS(CAN_TXDL1_BYTE2_POSS, CAN_TXDL1_BYTE2_POSE) 
# define	CAN_TXDL1_BYTE2 CAN_TXDL1_BYTE2_MSK 

# define	CAN_TXDL1_BYTE1_POSS 8U 
# define	CAN_TXDL1_BYTE1_POSE 15U 
# define	CAN_TXDL1_BYTE1_MSK BITS(CAN_TXDL1_BYTE1_POSS, CAN_TXDL1_BYTE1_POSE) 
# define	CAN_TXDL1_BYTE1 CAN_TXDL1_BYTE1_MSK 

# define	CAN_TXDL1_BYTE0_POSS 0U 
# define	CAN_TXDL1_BYTE0_POSE 7U 
# define	CAN_TXDL1_BYTE0_MSK BITS(CAN_TXDL1_BYTE0_POSS, CAN_TXDL1_BYTE0_POSE) 
# define	CAN_TXDL1_BYTE0 CAN_TXDL1_BYTE0_MSK 

/****************** Bit definition for CAN_TXDH1 register ************************/

# define	CAN_TXDH1_BYTE7_POSS 24U 
# define	CAN_TXDH1_BYTE7_POSE 31U 
# define	CAN_TXDH1_BYTE7_MSK BITS(CAN_TXDH1_BYTE7_POSS, CAN_TXDH1_BYTE7_POSE) 
# define	CAN_TXDH1_BYTE7 CAN_TXDH1_BYTE7_MSK 

# define	CAN_TXDH1_BYTE6_POSS 16U 
# define	CAN_TXDH1_BYTE6_POSE 23U 
# define	CAN_TXDH1_BYTE6_MSK BITS(CAN_TXDH1_BYTE6_POSS, CAN_TXDH1_BYTE6_POSE) 
# define	CAN_TXDH1_BYTE6 CAN_TXDH1_BYTE6_MSK 

# define	CAN_TXDH1_BYTE5_POSS 8U 
# define	CAN_TXDH1_BYTE5_POSE 15U 
# define	CAN_TXDH1_BYTE5_MSK BITS(CAN_TXDH1_BYTE5_POSS, CAN_TXDH1_BYTE5_POSE) 
# define	CAN_TXDH1_BYTE5 CAN_TXDH1_BYTE5_MSK 

# define	CAN_TXDH1_BYTE4_POSS 0U 
# define	CAN_TXDH1_BYTE4_POSE 7U 
# define	CAN_TXDH1_BYTE4_MSK BITS(CAN_TXDH1_BYTE4_POSS, CAN_TXDH1_BYTE4_POSE) 
# define	CAN_TXDH1_BYTE4 CAN_TXDH1_BYTE4_MSK 

/****************** Bit definition for CAN_TXID2 register ************************/

# define	CAN_TXID2_STDID10_0_EXID28_18_POSS 21U 
# define	CAN_TXID2_STDID10_0_EXID28_18_POSE 31U 
# define	CAN_TXID2_STDID10_0_EXID28_18_MSK  BITS(CAN_TXID2_STDID10_0_EXID28_18_POSS, CAN_TXID2_STDID10_0_EXID28_18_POSE) 
# define	CAN_TXID2_STDID10_0_EXID28_18      CAN_TXID2_STDID10_0_EXID28_18_MSK

# define	CAN_TXID2_EXID17_0_POSS 3U 
# define	CAN_TXID2_EXID17_0_POSE 20U 
# define	CAN_TXID2_EXID17_0_MSK  BITS(CAN_TXID2_EXID17_0_POSS, CAN_TXID2_EXID17_0_POSE) 
# define	CAN_TXID2_EXID17_0      CAN_TXID2_EXID17_0_MSK

# define	CAN_TXID2_IDE_POS 2U 
# define	CAN_TXID2_IDE_MSK BIT(CAN_TXID2_IDE_POS) 
# define	CAN_TXID2_IDE CAN_TXID2_IDE_MSK 

# define	CAN_TXID2_RTR_POS 1U 
# define	CAN_TXID2_RTR_MSK BIT(CAN_TXID2_RTR_POS) 
# define	CAN_TXID2_RTR CAN_TXID2_RTR_MSK 

# define	CAN_TXID2_TXMREQ_POS 0U 
# define	CAN_TXID2_TXMREQ_MSK BIT(CAN_TXID2_TXMREQ_POS) 
# define	CAN_TXID2_TXMREQ CAN_TXID2_TXMREQ_MSK 

/****************** Bit definition for CAN_TXFCON2 register ************************/

# define	CAN_TXFCON2_STAMP_POSS 16U 
# define	CAN_TXFCON2_STAMP_POSE 31U 
# define	CAN_TXFCON2_STAMP_MSK BITS(CAN_TXFCON2_STAMP_POSS, CAN_TXFCON2_STAMP_POSE) 
# define	CAN_TXFCON2_STAMP CAN_TXFCON2_STAMP_MSK 

# define	CAN_TXFCON2_TXGT_POS 8U 
# define	CAN_TXFCON2_TXGT_MSK BIT(CAN_TXFCON2_TXGT_POS) 
# define	CAN_TXFCON2_TXGT CAN_TXFCON2_TXGT_MSK 

# define	CAN_TXFCON2_DLEN_POSS 0U 
# define	CAN_TXFCON2_DLEN_POSE 3U 
# define	CAN_TXFCON2_DLEN_MSK BITS(CAN_TXFCON2_DLEN_POSS, CAN_TXFCON2_DLEN_POSE) 
# define	CAN_TXFCON2_DLEN CAN_TXFCON2_DLEN_MSK 

/****************** Bit definition for CAN_TXDL2 register ************************/

# define	CAN_TXDL2_BYTE3_POSS 24U 
# define	CAN_TXDL2_BYTE3_POSE 31U 
# define	CAN_TXDL2_BYTE3_MSK BITS(CAN_TXDL2_BYTE3_POSS, CAN_TXDL2_BYTE3_POSE) 
# define	CAN_TXDL2_BYTE3 CAN_TXDL2_BYTE3_MSK 

# define	CAN_TXDL2_BYTE2_POSS 16U 
# define	CAN_TXDL2_BYTE2_POSE 23U 
# define	CAN_TXDL2_BYTE2_MSK BITS(CAN_TXDL2_BYTE2_POSS, CAN_TXDL2_BYTE2_POSE) 
# define	CAN_TXDL2_BYTE2 CAN_TXDL2_BYTE2_MSK 

# define	CAN_TXDL2_BYTE1_POSS 8U 
# define	CAN_TXDL2_BYTE1_POSE 15U 
# define	CAN_TXDL2_BYTE1_MSK BITS(CAN_TXDL2_BYTE1_POSS, CAN_TXDL2_BYTE1_POSE) 
# define	CAN_TXDL2_BYTE1 CAN_TXDL2_BYTE1_MSK 

# define	CAN_TXDL2_BYTE0_POSS 0U 
# define	CAN_TXDL2_BYTE0_POSE 7U 
# define	CAN_TXDL2_BYTE0_MSK BITS(CAN_TXDL2_BYTE0_POSS, CAN_TXDL2_BYTE0_POSE) 
# define	CAN_TXDL2_BYTE0 CAN_TXDL2_BYTE0_MSK 

/****************** Bit definition for CAN_TXDH2 register ************************/

# define	CAN_TXDH2_BYTE7_POSS 24U 
# define	CAN_TXDH2_BYTE7_POSE 31U 
# define	CAN_TXDH2_BYTE7_MSK BITS(CAN_TXDH2_BYTE7_POSS, CAN_TXDH2_BYTE7_POSE) 
# define	CAN_TXDH2_BYTE7 CAN_TXDH2_BYTE7_MSK 

# define	CAN_TXDH2_BYTE6_POSS 16U 
# define	CAN_TXDH2_BYTE6_POSE 23U 
# define	CAN_TXDH2_BYTE6_MSK BITS(CAN_TXDH2_BYTE6_POSS, CAN_TXDH2_BYTE6_POSE) 
# define	CAN_TXDH2_BYTE6 CAN_TXDH2_BYTE6_MSK 

# define	CAN_TXDH2_BYTE5_POSS 8U 
# define	CAN_TXDH2_BYTE5_POSE 15U 
# define	CAN_TXDH2_BYTE5_MSK BITS(CAN_TXDH2_BYTE5_POSS, CAN_TXDH2_BYTE5_POSE) 
# define	CAN_TXDH2_BYTE5 CAN_TXDH2_BYTE5_MSK 

# define	CAN_TXDH2_BYTE4_POSS 0U 
# define	CAN_TXDH2_BYTE4_POSE 7U 
# define	CAN_TXDH2_BYTE4_MSK BITS(CAN_TXDH2_BYTE4_POSS, CAN_TXDH2_BYTE4_POSE) 
# define	CAN_TXDH2_BYTE4 CAN_TXDH2_BYTE4_MSK 

/****************** Bit definition for CAN_RXF0ID register ************************/

# define	CAN_RXF0ID_STDID10_0_EXID28_18_POSS 21U 
# define	CAN_RXF0ID_STDID10_0_EXID28_18_POSE 31U 
# define	CAN_RXF0ID_STDID10_0_EXID28_18_MSK  BITS(CAN_RXF0ID_STDID10_0_EXID28_18_POSS, CAN_RXF0ID_STDID10_0_EXID28_18_POSE) 
# define	CAN_RXF0ID_STDID10_0_EXID28_18      CAN_RXF0ID_STDID10_0_EXID28_18_MSK

# define	CAN_RXF0ID_EXID17_0_POSS 3U 
# define	CAN_RXF0ID_EXID17_0_POSE 20U 
# define	CAN_RXF0ID_EXID17_0_MSK  BITS(CAN_RXF0ID_EXID17_0_POSS, CAN_RXF0ID_EXID17_0_POSE) 
# define	CAN_RXF0ID_EXID17_0      CAN_RXF0ID_EXID17_0_MSK

# define	CAN_RXF0ID_IDE_POS 2U 
# define	CAN_RXF0ID_IDE_MSK BIT(CAN_RXF0ID_IDE_POS) 
# define	CAN_RXF0ID_IDE CAN_RXF0ID_IDE_MSK 

# define	CAN_RXF0ID_RTR_POS 1U 
# define	CAN_RXF0ID_RTR_MSK BIT(CAN_RXF0ID_RTR_POS) 
# define	CAN_RXF0ID_RTR CAN_RXF0ID_RTR_MSK 

/****************** Bit definition for CAN_RXF0INF register ************************/

# define	CAN_RXF0INF_STAMP_POSS 16U 
# define	CAN_RXF0INF_STAMP_POSE 31U 
# define	CAN_RXF0INF_STAMP_MSK BITS(CAN_RXF0INF_STAMP_POSS, CAN_RXF0INF_STAMP_POSE) 
# define	CAN_RXF0INF_STAMP CAN_RXF0INF_STAMP_MSK 

# define	CAN_RXF0INF_FLTIDX_POSS 8U 
# define	CAN_RXF0INF_FLTIDX_POSE 15U 
# define	CAN_RXF0INF_FLTIDX_MSK BITS(CAN_RXF0INF_FLTIDX_POSS, CAN_RXF0INF_FLTIDX_POSE) 
# define	CAN_RXF0INF_FLTIDX CAN_RXF0INF_FLTIDX_MSK 

# define	CAN_RXF0INF_DLEN_POSS 0U 
# define	CAN_RXF0INF_DLEN_POSE 3U 
# define	CAN_RXF0INF_DLEN_MSK BITS(CAN_RXF0INF_DLEN_POSS, CAN_RXF0INF_DLEN_POSE) 
# define	CAN_RXF0INF_DLEN CAN_RXF0INF_DLEN_MSK 

/****************** Bit definition for CAN_RXF0DL register ************************/

# define	CAN_RXF0DL_BYTE3_POSS 24U 
# define	CAN_RXF0DL_BYTE3_POSE 31U 
# define	CAN_RXF0DL_BYTE3_MSK BITS(CAN_RXF0DL_BYTE3_POSS, CAN_RXF0DL_BYTE3_POSE) 
# define	CAN_RXF0DL_BYTE3 CAN_RXF0DL_BYTE3_MSK 

# define	CAN_RXF0DL_BYTE2_POSS 16U 
# define	CAN_RXF0DL_BYTE2_POSE 23U 
# define	CAN_RXF0DL_BYTE2_MSK BITS(CAN_RXF0DL_BYTE2_POSS, CAN_RXF0DL_BYTE2_POSE) 
# define	CAN_RXF0DL_BYTE2 CAN_RXF0DL_BYTE2_MSK 

# define	CAN_RXF0DL_BYTE1_POSS 8U 
# define	CAN_RXF0DL_BYTE1_POSE 15U 
# define	CAN_RXF0DL_BYTE1_MSK BITS(CAN_RXF0DL_BYTE1_POSS, CAN_RXF0DL_BYTE1_POSE) 
# define	CAN_RXF0DL_BYTE1 CAN_RXF0DL_BYTE1_MSK 

# define	CAN_RXF0DL_BYTE0_POSS 0U 
# define	CAN_RXF0DL_BYTE0_POSE 7U 
# define	CAN_RXF0DL_BYTE0_MSK BITS(CAN_RXF0DL_BYTE0_POSS, CAN_RXF0DL_BYTE0_POSE) 
# define	CAN_RXF0DL_BYTE0 CAN_RXF0DL_BYTE0_MSK 

/****************** Bit definition for CAN_RXF0DH register ************************/

# define	CAN_RXF0DH_BYTE7_POSS 24U 
# define	CAN_RXF0DH_BYTE7_POSE 31U 
# define	CAN_RXF0DH_BYTE7_MSK BITS(CAN_RXF0DH_BYTE7_POSS, CAN_RXF0DH_BYTE7_POSE) 
# define	CAN_RXF0DH_BYTE7 CAN_RXF0DH_BYTE7_MSK 

# define	CAN_RXF0DH_BYTE6_POSS 16U 
# define	CAN_RXF0DH_BYTE6_POSE 23U 
# define	CAN_RXF0DH_BYTE6_MSK BITS(CAN_RXF0DH_BYTE6_POSS, CAN_RXF0DH_BYTE6_POSE) 
# define	CAN_RXF0DH_BYTE6 CAN_RXF0DH_BYTE6_MSK 

# define	CAN_RXF0DH_BYTE5_POSS 8U 
# define	CAN_RXF0DH_BYTE5_POSE 15U 
# define	CAN_RXF0DH_BYTE5_MSK BITS(CAN_RXF0DH_BYTE5_POSS, CAN_RXF0DH_BYTE5_POSE) 
# define	CAN_RXF0DH_BYTE5 CAN_RXF0DH_BYTE5_MSK 

# define	CAN_RXF0DH_BYTE4_POSS 0U 
# define	CAN_RXF0DH_BYTE4_POSE 7U 
# define	CAN_RXF0DH_BYTE4_MSK BITS(CAN_RXF0DH_BYTE4_POSS, CAN_RXF0DH_BYTE4_POSE) 
# define	CAN_RXF0DH_BYTE4 CAN_RXF0DH_BYTE4_MSK 

/****************** Bit definition for CAN_RXF1ID register ************************/

# define	CAN_RXF1ID_STDID10_0_EXID28_18_POSS 21U 
# define	CAN_RXF1ID_STDID10_0_EXID28_18_POSE 31U 
# define	CAN_RXF1ID_STDID10_0_EXID28_18_MSK  BITS(CAN_RXF1ID_STDID10_0_EXID28_18_POSS, CAN_RXF1ID_STDID10_0_EXID28_18_POSE) 
# define	CAN_RXF1ID_STDID10_0_EXID28_18      CAN_RXF1ID_STDID10_0_EXID28_18_MSK

# define	CAN_RXF1ID_EXID17_0_POSS 3U 
# define	CAN_RXF1ID_EXID17_0_POSE 20U 
# define	CAN_RXF1ID_EXID17_0_MSK  BITS(CAN_RXF1ID_EXID17_0_POSS, CAN_RXF1ID_EXID17_0_POSE) 
# define	CAN_RXF1ID_EXID17_0      CAN_RXF1ID_EXID17_0_MSK

# define	CAN_RXF1ID_IDE_POS 2U 
# define	CAN_RXF1ID_IDE_MSK BIT(CAN_RXF1ID_IDE_POS) 
# define	CAN_RXF1ID_IDE CAN_RXF1ID_IDE_MSK 

# define	CAN_RXF1ID_RTR_POS 1U 
# define	CAN_RXF1ID_RTR_MSK BIT(CAN_RXF1ID_RTR_POS) 
# define	CAN_RXF1ID_RTR CAN_RXF1ID_RTR_MSK 

/****************** Bit definition for CAN_RXF1INF register ************************/

# define	CAN_RXF1INF_STAMP_POSS 16U 
# define	CAN_RXF1INF_STAMP_POSE 31U 
# define	CAN_RXF1INF_STAMP_MSK BITS(CAN_RXF1INF_STAMP_POSS, CAN_RXF1INF_STAMP_POSE) 
# define	CAN_RXF1INF_STAMP CAN_RXF1INF_STAMP_MSK 

# define	CAN_RXF1INF_FLTIDX_POSS 8U 
# define	CAN_RXF1INF_FLTIDX_POSE 15U 
# define	CAN_RXF1INF_FLTIDX_MSK BITS(CAN_RXF1INF_FLTIDX_POSS, CAN_RXF1INF_FLTIDX_POSE) 
# define	CAN_RXF1INF_FLTIDX CAN_RXF1INF_FLTIDX_MSK 

# define	CAN_RXF1INF_DLEN_POSS 0U 
# define	CAN_RXF1INF_DLEN_POSE 3U 
# define	CAN_RXF1INF_DLEN_MSK BITS(CAN_RXF1INF_DLEN_POSS, CAN_RXF1INF_DLEN_POSE) 
# define	CAN_RXF1INF_DLEN CAN_RXF1INF_DLEN_MSK 

/****************** Bit definition for CAN_RXF1DL register ************************/

# define	CAN_RXF1DL_BYTE3_POSS 24U 
# define	CAN_RXF1DL_BYTE3_POSE 31U 
# define	CAN_RXF1DL_BYTE3_MSK BITS(CAN_RXF1DL_BYTE3_POSS, CAN_RXF1DL_BYTE3_POSE) 
# define	CAN_RXF1DL_BYTE3 CAN_RXF1DL_BYTE3_MSK 

# define	CAN_RXF1DL_BYTE2_POSS 16U 
# define	CAN_RXF1DL_BYTE2_POSE 23U 
# define	CAN_RXF1DL_BYTE2_MSK BITS(CAN_RXF1DL_BYTE2_POSS, CAN_RXF1DL_BYTE2_POSE) 
# define	CAN_RXF1DL_BYTE2 CAN_RXF1DL_BYTE2_MSK 

# define	CAN_RXF1DL_BYTE1_POSS 8U 
# define	CAN_RXF1DL_BYTE1_POSE 15U 
# define	CAN_RXF1DL_BYTE1_MSK BITS(CAN_RXF1DL_BYTE1_POSS, CAN_RXF1DL_BYTE1_POSE) 
# define	CAN_RXF1DL_BYTE1 CAN_RXF1DL_BYTE1_MSK 

# define	CAN_RXF1DL_BYTE0_POSS 0U 
# define	CAN_RXF1DL_BYTE0_POSE 7U 
# define	CAN_RXF1DL_BYTE0_MSK BITS(CAN_RXF1DL_BYTE0_POSS, CAN_RXF1DL_BYTE0_POSE) 
# define	CAN_RXF1DL_BYTE0 CAN_RXF1DL_BYTE0_MSK 

/****************** Bit definition for CAN_RXF1DH register ************************/

# define	CAN_RXF1DH_BYTE7_POSS 24U 
# define	CAN_RXF1DH_BYTE7_POSE 31U 
# define	CAN_RXF1DH_BYTE7_MSK BITS(CAN_RXF1DH_BYTE7_POSS, CAN_RXF1DH_BYTE7_POSE) 
# define	CAN_RXF1DH_BYTE7 CAN_RXF1DH_BYTE7_MSK 

# define	CAN_RXF1DH_BYTE6_POSS 16U 
# define	CAN_RXF1DH_BYTE6_POSE 23U 
# define	CAN_RXF1DH_BYTE6_MSK BITS(CAN_RXF1DH_BYTE6_POSS, CAN_RXF1DH_BYTE6_POSE) 
# define	CAN_RXF1DH_BYTE6 CAN_RXF1DH_BYTE6_MSK 

# define	CAN_RXF1DH_BYTE5_POSS 8U 
# define	CAN_RXF1DH_BYTE5_POSE 15U 
# define	CAN_RXF1DH_BYTE5_MSK BITS(CAN_RXF1DH_BYTE5_POSS, CAN_RXF1DH_BYTE5_POSE) 
# define	CAN_RXF1DH_BYTE5 CAN_RXF1DH_BYTE5_MSK 

# define	CAN_RXF1DH_BYTE4_POSS 0U 
# define	CAN_RXF1DH_BYTE4_POSE 7U 
# define	CAN_RXF1DH_BYTE4_MSK BITS(CAN_RXF1DH_BYTE4_POSS, CAN_RXF1DH_BYTE4_POSE) 
# define	CAN_RXF1DH_BYTE4 CAN_RXF1DH_BYTE4_MSK 

/****************** Bit definition for CAN_FLTCON register ************************/

# define	CAN_FLTCON_FLTINI_POS 0U 
# define	CAN_FLTCON_FLTINI_MSK BIT(CAN_FLTCON_FLTINI_POS) 
# define	CAN_FLTCON_FLTINI CAN_FLTCON_FLTINI_MSK 

/****************** Bit definition for CAN_FLTM register ************************/

# define	CAN_FLTM_MODx_POSS 0U 
# define	CAN_FLTM_MODx_POSE 13U 
# define	CAN_FLTM_MODx_MSK  BITS(CAN_FLTM_MODx_POSS, CAN_FLTM_MODx_POSE) 
# define	CAN_FLTM_MODx      CAN_FLTM_MODx_MSK 

/****************** Bit definition for CAN_FLTWS register ************************/

# define	CAN_FLTWS_SELx_POSS 0U 
# define	CAN_FLTWS_SELx_POSE 13U 
# define	CAN_FLTWS_SELx_MSK  BITS(CAN_FLTWS_SELx_POSS, CAN_FLTWS_SELx_POSE) 
# define	CAN_FLTWS_SELx      CAN_FLTWS_SELx_MSK

/****************** Bit definition for CAN_FLTAS register ************************/

# define	CAN_FLTAS_ASSIGNx_POSS 0U 
# define	CAN_FLTAS_ASSIGNx_POSE 13U 
# define	CAN_FLTAS_ASSIGNx_MSK  BITS(CAN_FLTAS_ASSIGNx_POSS, CAN_FLTAS_ASSIGNx_POSE) 
# define	CAN_FLTAS_ASSIGNx      CAN_FLTAS_ASSIGNx_MSK

/****************** Bit definition for CAN_FLTGO register ************************/

# define	CAN_FLTGO_GOx_POSS 0U 
# define	CAN_FLTGO_GOx_POSE 13U 
# define	CAN_FLTGO_GOx_MSK  BITS(CAN_FLTGO_GOx_POSS, CAN_FLTGO_GOx_POSE) 
# define	CAN_FLTGO_GOx      CAN_FLTGO_GOx_MSK

/****************** Bit definition for CAN_FLT0R1 register ************************/

# define	CAN_FLT0R1_FLTBx_POSS 0U 
# define	CAN_FLT0R1_FLTBx_POSE 31U 
# define	CAN_FLT0R1_FLTBx_MSK  BITS(CAN_FLT0R1_FLTBx_POSS, CAN_FLT0R1_FLTBx_POSE) 
# define	CAN_FLT0R1_FLTBx      CAN_FLT0R1_FLTBx_MSK

/****************** Bit definition for CAN_FLT0R2 register ************************/

# define	CAN_FLT0R2_FLTBx_POSS 0U 
# define	CAN_FLT0R2_FLTBx_POSE 31U 
# define	CAN_FLT0R2_FLTBx_MSK BITS(CAN_FLT0R2_FLTBx_POSS, CAN_FLT0R2_FLTBx_POSE) 
# define	CAN_FLT0R2_FLTBx CAN_FLT0R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT1R1 register ************************/

# define	CAN_FLT1R1_FLTBx_POSS 0U 
# define	CAN_FLT1R1_FLTBx_POSE 31U 
# define	CAN_FLT1R1_FLTBx_MSK BITS(CAN_FLT1R1_FLTBx_POSS, CAN_FLT1R1_FLTBx_POSE) 
# define	CAN_FLT1R1_FLTBx CAN_FLT1R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT1R2 register ************************/

# define	CAN_FLT1R2_FLTBx_POSS 0U 
# define	CAN_FLT1R2_FLTBx_POSE 31U 
# define	CAN_FLT1R2_FLTBx_MSK BITS(CAN_FLT1R2_FLTBx_POSS, CAN_FLT1R2_FLTBx_POSE) 
# define	CAN_FLT1R2_FLTBx CAN_FLT1R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT2R1 register ************************/

# define	CAN_FLT2R1_FLTBx_POSS 0U 
# define	CAN_FLT2R1_FLTBx_POSE 31U 
# define	CAN_FLT2R1_FLTBx_MSK BITS(CAN_FLT2R1_FLTBx_POSS, CAN_FLT2R1_FLTBx_POSE) 
# define	CAN_FLT2R1_FLTBx CAN_FLT2R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT2R2 register ************************/

# define	CAN_FLT2R2_FLTBx_POSS 0U 
# define	CAN_FLT2R2_FLTBx_POSE 31U 
# define	CAN_FLT2R2_FLTBx_MSK BITS(CAN_FLT2R2_FLTBx_POSS, CAN_FLT2R2_FLTBx_POSE) 
# define	CAN_FLT2R2_FLTBx CAN_FLT2R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT3R1 register ************************/

# define	CAN_FLT3R1_FLTBx_POSS 0U 
# define	CAN_FLT3R1_FLTBx_POSE 31U 
# define	CAN_FLT3R1_FLTBx_MSK BITS(CAN_FLT3R1_FLTBx_POSS, CAN_FLT3R1_FLTBx_POSE) 
# define	CAN_FLT3R1_FLTBx CAN_FLT3R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT3R2 register ************************/

# define	CAN_FLT3R2_FLTBx_POSS 0U 
# define	CAN_FLT3R2_FLTBx_POSE 31U 
# define	CAN_FLT3R2_FLTBx_MSK BITS(CAN_FLT3R2_FLTBx_POSS, CAN_FLT3R2_FLTBx_POSE) 
# define	CAN_FLT3R2_FLTBx CAN_FLT3R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT4R1 register ************************/

# define	CAN_FLT4R1_FLTBx_POSS 0U 
# define	CAN_FLT4R1_FLTBx_POSE 31U 
# define	CAN_FLT4R1_FLTBx_MSK BITS(CAN_FLT4R1_FLTBx_POSS, CAN_FLT4R1_FLTBx_POSE) 
# define	CAN_FLT4R1_FLTBx CAN_FLT4R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT4R2 register ************************/

# define	CAN_FLT4R2_FLTBx_POSS 0U 
# define	CAN_FLT4R2_FLTBx_POSE 31U 
# define	CAN_FLT4R2_FLTBx_MSK BITS(CAN_FLT4R2_FLTBx_POSS, CAN_FLT4R2_FLTBx_POSE) 
# define	CAN_FLT4R2_FLTBx CAN_FLT4R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT5R1 register ************************/

# define	CAN_FLT5R1_FLTBx_POSS 0U 
# define	CAN_FLT5R1_FLTBx_POSE 31U 
# define	CAN_FLT5R1_FLTBx_MSK BITS(CAN_FLT5R1_FLTBx_POSS, CAN_FLT5R1_FLTBx_POSE) 
# define	CAN_FLT5R1_FLTBx CAN_FLT5R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT5R2 register ************************/

# define	CAN_FLT5R2_FLTBx_POSS 0U 
# define	CAN_FLT5R2_FLTBx_POSE 31U 
# define	CAN_FLT5R2_FLTBx_MSK BITS(CAN_FLT5R2_FLTBx_POSS, CAN_FLT5R2_FLTBx_POSE) 
# define	CAN_FLT5R2_FLTBx CAN_FLT5R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT6R1 register ************************/

# define	CAN_FLT6R1_FLTBx_POSS 0U 
# define	CAN_FLT6R1_FLTBx_POSE 31U 
# define	CAN_FLT6R1_FLTBx_MSK BITS(CAN_FLT6R1_FLTBx_POSS, CAN_FLT6R1_FLTBx_POSE) 
# define	CAN_FLT6R1_FLTBx CAN_FLT6R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT6R2 register ************************/

# define	CAN_FLT6R2_FLTBx_POSS 0U 
# define	CAN_FLT6R2_FLTBx_POSE 31U 
# define	CAN_FLT6R2_FLTBx_MSK BITS(CAN_FLT6R2_FLTBx_POSS, CAN_FLT6R2_FLTBx_POSE) 
# define	CAN_FLT6R2_FLTBx CAN_FLT6R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT7R1 register ************************/

# define	CAN_FLT7R1_FLTBx_POSS 0U 
# define	CAN_FLT7R1_FLTBx_POSE 31U 
# define	CAN_FLT7R1_FLTBx_MSK BITS(CAN_FLT7R1_FLTBx_POSS, CAN_FLT7R1_FLTBx_POSE) 
# define	CAN_FLT7R1_FLTBx CAN_FLT7R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT7R2 register ************************/

# define	CAN_FLT7R2_FLTBx_POSS 0U 
# define	CAN_FLT7R2_FLTBx_POSE 31U 
# define	CAN_FLT7R2_FLTBx_MSK BITS(CAN_FLT7R2_FLTBx_POSS, CAN_FLT7R2_FLTBx_POSE) 
# define	CAN_FLT7R2_FLTBx CAN_FLT7R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT8R1 register ************************/

# define	CAN_FLT8R1_FLTBx_POSS 0U 
# define	CAN_FLT8R1_FLTBx_POSE 31U 
# define	CAN_FLT8R1_FLTBx_MSK BITS(CAN_FLT8R1_FLTBx_POSS, CAN_FLT8R1_FLTBx_POSE) 
# define	CAN_FLT8R1_FLTBx CAN_FLT8R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT8R2 register ************************/

# define	CAN_FLT8R2_FLTBx_POSS 0U 
# define	CAN_FLT8R2_FLTBx_POSE 31U 
# define	CAN_FLT8R2_FLTBx_MSK BITS(CAN_FLT8R2_FLTBx_POSS, CAN_FLT8R2_FLTBx_POSE) 
# define	CAN_FLT8R2_FLTBx CAN_FLT8R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT9R1 register ************************/

# define	CAN_FLT9R1_FLTBx_POSS 0U 
# define	CAN_FLT9R1_FLTBx_POSE 31U 
# define	CAN_FLT9R1_FLTBx_MSK BITS(CAN_FLT9R1_FLTBx_POSS, CAN_FLT9R1_FLTBx_POSE) 
# define	CAN_FLT9R1_FLTBx CAN_FLT9R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT9R2 register ************************/

# define	CAN_FLT9R2_FLTBx_POSS 0U 
# define	CAN_FLT9R2_FLTBx_POSE 31U 
# define	CAN_FLT9R2_FLTBx_MSK BITS(CAN_FLT9R2_FLTBx_POSS, CAN_FLT9R2_FLTBx_POSE) 
# define	CAN_FLT9R2_FLTBx CAN_FLT9R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT10R1 register ************************/

# define	CAN_FLT10R1_FLTBx_POSS 0U 
# define	CAN_FLT10R1_FLTBx_POSE 31U 
# define	CAN_FLT10R1_FLTBx_MSK BITS(CAN_FLT10R1_FLTBx_POSS, CAN_FLT10R1_FLTBx_POSE) 
# define	CAN_FLT10R1_FLTBx CAN_FLT10R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT10R2 register ************************/

# define	CAN_FLT10R2_FLTBx_POSS 0U 
# define	CAN_FLT10R2_FLTBx_POSE 31U 
# define	CAN_FLT10R2_FLTBx_MSK BITS(CAN_FLT10R2_FLTBx_POSS, CAN_FLT10R2_FLTBx_POSE) 
# define	CAN_FLT10R2_FLTBx CAN_FLT10R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT11R1 register ************************/

# define	CAN_FLT11R1_FLTBx_POSS 0U 
# define	CAN_FLT11R1_FLTBx_POSE 31U 
# define	CAN_FLT11R1_FLTBx_MSK BITS(CAN_FLT11R1_FLTBx_POSS, CAN_FLT11R1_FLTBx_POSE) 
# define	CAN_FLT11R1_FLTBx CAN_FLT11R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT11R2 register ************************/

# define	CAN_FLT11R2_FLTBx_POSS 0U 
# define	CAN_FLT11R2_FLTBx_POSE 31U 
# define	CAN_FLT11R2_FLTBx_MSK BITS(CAN_FLT11R2_FLTBx_POSS, CAN_FLT11R2_FLTBx_POSE) 
# define	CAN_FLT11R2_FLTBx CAN_FLT11R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT12R1 register ************************/

# define	CAN_FLT12R1_FLTBx_POSS 0U 
# define	CAN_FLT12R1_FLTBx_POSE 31U 
# define	CAN_FLT12R1_FLTBx_MSK BITS(CAN_FLT12R1_FLTBx_POSS, CAN_FLT12R1_FLTBx_POSE) 
# define	CAN_FLT12R1_FLTBx CAN_FLT12R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT12R2 register ************************/

# define	CAN_FLT12R2_FLTBx_POSS 0U 
# define	CAN_FLT12R2_FLTBx_POSE 31U 
# define	CAN_FLT12R2_FLTBx_MSK BITS(CAN_FLT12R2_FLTBx_POSS, CAN_FLT12R2_FLTBx_POSE) 
# define	CAN_FLT12R2_FLTBx CAN_FLT12R2_FLTBx_MSK 

/****************** Bit definition for CAN_FLT13R1 register ************************/

# define	CAN_FLT13R1_FLTBx_POSS 0U 
# define	CAN_FLT13R1_FLTBx_POSE 31U 
# define	CAN_FLT13R1_FLTBx_MSK BITS(CAN_FLT13R1_FLTBx_POSS, CAN_FLT13R1_FLTBx_POSE) 
# define	CAN_FLT13R1_FLTBx CAN_FLT13R1_FLTBx_MSK 

/****************** Bit definition for CAN_FLT13R2 register ************************/

# define	CAN_FLT13R2_FLTBx_POSS 0U 
# define	CAN_FLT13R2_FLTBx_POSE 31U 
# define	CAN_FLT13R2_FLTBx_MSK BITS(CAN_FLT13R2_FLTBx_POSS, CAN_FLT13R2_FLTBx_POSE) 
# define	CAN_FLT13R2_FLTBx CAN_FLT13R2_FLTBx_MSK 

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CON;                      // 0x000
    __I  uint32_t STAT;                     // 0x004
    __O  uint32_t IFC;                      // 0x008
    __IO uint32_t TXSTAT;                   // 0x00c
    __O  uint32_t TXSTATC;                  // 0x010
    __IO uint32_t RXF0;                     // 0x014
    __O  uint32_t RXF0C;                    // 0x018
    __IO uint32_t RXF1;                     // 0x01c
    __O  uint32_t RXF1C;                    // 0x020
    __IO uint32_t IE;                       // 0x024
    __IO uint32_t ERRSTAT;                  // 0x028
    __IO uint32_t BTIME;                    // 0x02c
    __IO uint32_t RESERVED0[84];            // 0x030-0x17c
    __IO uint32_t TXID0;                    // 0x180
    __IO uint32_t TXFCON0;                  // 0x184
    __IO uint32_t TXDL0;                    // 0x188
    __IO uint32_t TXDH0;                    // 0x18c
    __IO uint32_t TXID1;                    // 0x190
    __IO uint32_t TXFCON1;                  // 0x194
    __IO uint32_t TXDL1;                    // 0x198
    __IO uint32_t TXDH1;                    // 0x19c
    __IO uint32_t TXID2;                    // 0x1a0
    __IO uint32_t TXFCON2;                  // 0x1a4
    __IO uint32_t TXDL2;                    // 0x1a8
    __IO uint32_t TXDH2;                    // 0x1ac
    __I  uint32_t RXF0ID;                   // 0x1b0
    __I  uint32_t RXF0INF;                  // 0x1b4
    __I  uint32_t RXF0DL;                   // 0x1b8
    __I  uint32_t RXF0DH;                   // 0x1bc
    __I  uint32_t RXF1ID;                   // 0x1c0
    __I  uint32_t RXF1INF;                  // 0x1c4
    __I  uint32_t RXF1DL;                   // 0x1c8
    __I  uint32_t RXF1DH;                   // 0x1cc
    __IO uint32_t RESERVED1[12];            // 0x1d0-0x1fc
    __IO uint32_t FLTCON;                   // 0x200
    __IO uint32_t FLTM;                     // 0x204
    __IO uint32_t RESERVED2;                // 0x208
    __IO uint32_t FLTWS;                    // 0x20c
    __IO uint32_t RESERVED3;                // 0x210
    __IO uint32_t FLTAS;                    // 0x214
    __IO uint32_t RESERVED4;                // 0x218
    __IO uint32_t FLTGO;                    // 0x21c
    __IO uint32_t RESERVED5[8];             // 0x220-0x23c
    __IO uint32_t FLT0R1;                   // 0x240
    __IO uint32_t FLT0R2;                   // 0x244
    __IO uint32_t FLT1R1;                   // 0x248
    __IO uint32_t FLT1R2;                   // 0x24c
    __IO uint32_t FLT2R1;                   // 0x250
    __IO uint32_t FLT2R2;                   // 0x254
    __IO uint32_t FLT3R1;                   // 0x258
    __IO uint32_t FLT3R2;                   // 0x25c
    __IO uint32_t FLT4R1;                   // 0x260
    __IO uint32_t FLT4R2;                   // 0x264
    __IO uint32_t FLT5R1;                   // 0x268
    __IO uint32_t FLT5R2;                   // 0x26c
    __IO uint32_t FLT6R1;                   // 0x270
    __IO uint32_t FLT6R2;                   // 0x274
    __IO uint32_t FLT7R1;                   // 0x278
    __IO uint32_t FLT7R2;                   // 0x27c
    __IO uint32_t FLT8R1;                   // 0x280
    __IO uint32_t FLT8R2;                   // 0x284
    __IO uint32_t FLT9R1;                   // 0x288
    __IO uint32_t FLT9R2;                   // 0x28c
    __IO uint32_t FLT10R1;                  // 0x290
    __IO uint32_t FLT10R2;                  // 0x294
    __IO uint32_t FLT11R1;                  // 0x298
    __IO uint32_t FLT11R2;                  // 0x29c
    __IO uint32_t FLT12R1;                  // 0x2a0
    __IO uint32_t FLT12R2;                  // 0x2a4
    __IO uint32_t FLT13R1;                  // 0x2a8
    __IO uint32_t FLT13R2;                  // 0x2ac
} CAN_TypeDef;


#endif /* __REG_CAN_H__ */
