/**********************************************************************************
 *
 * @file    reg_adc.h
 * @brief   ADC Head File
 *
 * @date    30 Mar 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Mar 2023     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_ADC_H__
#define __REG_ADC_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/****************** Bit definition for ADC_IER register ************************/

# define    ADC_IER_TO_POS 15U
# define    ADC_IER_TO_MSK BIT(ADC_IER_TO_POS)
# define    ADC_IER_TO     ADC_IER_TO_MSK

# define    ADC_IER_JQOVF_POS 10U
# define    ADC_IER_JQOVF_MSK BIT(ADC_IER_JQOVF_POS)
# define    ADC_IER_JQOVF     ADC_IER_JQOVF_MSK

# define    ADC_IER_AWD3_POS 9U
# define    ADC_IER_AWD3_MSK BIT(ADC_IER_AWD3_POS)
# define    ADC_IER_AWD3     ADC_IER_AWD3_MSK

# define    ADC_IER_AWD2_POS 8U
# define    ADC_IER_AWD2_MSK BIT(ADC_IER_AWD2_POS)
# define    ADC_IER_AWD2     ADC_IER_AWD2_MSK

# define    ADC_IER_AWD1_POS 7U
# define    ADC_IER_AWD1_MSK BIT(ADC_IER_AWD1_POS)
# define    ADC_IER_AWD1     ADC_IER_AWD1_MSK

# define    ADC_IER_JEOS_POS 6U
# define    ADC_IER_JEOS_MSK BIT(ADC_IER_JEOS_POS)
# define    ADC_IER_JEOS     ADC_IER_JEOS_MSK

# define    ADC_IER_JEOC_POS 5U
# define    ADC_IER_JEOC_MSK BIT(ADC_IER_JEOC_POS)
# define    ADC_IER_JEOC     ADC_IER_JEOC_MSK

# define    ADC_IER_ROVR_POS 4U
# define    ADC_IER_ROVR_MSK BIT(ADC_IER_ROVR_POS)
# define    ADC_IER_ROVR     ADC_IER_ROVR_MSK

# define    ADC_IER_REOS_POS 3U
# define    ADC_IER_REOS_MSK BIT(ADC_IER_REOS_POS)
# define    ADC_IER_REOS     ADC_IER_REOS_MSK

# define    ADC_IER_REOC_POS 2U
# define    ADC_IER_REOC_MSK BIT(ADC_IER_REOC_POS)
# define    ADC_IER_REOC     ADC_IER_REOC_MSK

# define    ADC_IER_EOSMP_POS 1U
# define    ADC_IER_EOSMP_MSK BIT(ADC_IER_EOSMP_POS)
# define    ADC_IER_EOSMP     ADC_IER_EOSMP_MSK

/****************** Bit definition for ADC_IDR register ************************/

# define    ADC_IDR_TO_POS 15U
# define    ADC_IDR_TO_MSK BIT(ADC_IDR_TO_POS)
# define    ADC_IDR_TO     ADC_IDR_TO_MSK

# define    ADC_IDR_JQOVF_POS 10U
# define    ADC_IDR_JQOVF_MSK BIT(ADC_IDR_JQOVF_POS)
# define    ADC_IDR_JQOVF     ADC_IDR_JQOVF_MSK

# define    ADC_IDR_AWD3_POS 9U
# define    ADC_IDR_AWD3_MSK BIT(ADC_IDR_AWD3_POS)
# define    ADC_IDR_AWD3     ADC_IDR_AWD3_MSK

# define    ADC_IDR_AWD2_POS 8U
# define    ADC_IDR_AWD2_MSK BIT(ADC_IDR_AWD2_POS)
# define    ADC_IDR_AWD2     ADC_IDR_AWD2_MSK

# define    ADC_IDR_AWD1_POS 7U
# define    ADC_IDR_AWD1_MSK BIT(ADC_IDR_AWD1_POS)
# define    ADC_IDR_AWD1     ADC_IDR_AWD1_MSK

# define    ADC_IDR_JEOS_POS 6U
# define    ADC_IDR_JEOS_MSK BIT(ADC_IDR_JEOS_POS)
# define    ADC_IDR_JEOS     ADC_IDR_JEOS_MSK

# define    ADC_IDR_JEOC_POS 5U
# define    ADC_IDR_JEOC_MSK BIT(ADC_IDR_JEOC_POS)
# define    ADC_IDR_JEOC     ADC_IDR_JEOC_MSK

# define    ADC_IDR_ROVR_POS 4U
# define    ADC_IDR_ROVR_MSK BIT(ADC_IDR_ROVR_POS)
# define    ADC_IDR_ROVR     ADC_IDR_ROVR_MSK

# define    ADC_IDR_REOS_POS 3U
# define    ADC_IDR_REOS_MSK BIT(ADC_IDR_REOS_POS)
# define    ADC_IDR_REOS     ADC_IDR_REOS_MSK

# define    ADC_IDR_REOC_POS 2U
# define    ADC_IDR_REOC_MSK BIT(ADC_IDR_REOC_POS)
# define    ADC_IDR_REOC     ADC_IDR_REOC_MSK

# define    ADC_IDR_EOSMP_POS 1U
# define    ADC_IDR_EOSMP_MSK BIT(ADC_IDR_EOSMP_POS)
# define    ADC_IDR_EOSMP     ADC_IDR_EOSMP_MSK

/****************** Bit definition for ADC_IVS register ************************/

# define    ADC_IVS_TO_POS 15U
# define    ADC_IVS_TO_MSK BIT(ADC_IVS_TO_POS)
# define    ADC_IVS_TO     ADC_IVS_TO_MSK

# define    ADC_IVS_JQOVF_POS 10U
# define    ADC_IVS_JQOVF_MSK BIT(ADC_IVS_JQOVF_POS)
# define    ADC_IVS_JQOVF     ADC_IVS_JQOVF_MSK

# define    ADC_IVS_AWD3_POS 9U
# define    ADC_IVS_AWD3_MSK BIT(ADC_IVS_AWD3_POS)
# define    ADC_IVS_AWD3     ADC_IVS_AWD3_MSK

# define    ADC_IVS_AWD2_POS 8U
# define    ADC_IVS_AWD2_MSK BIT(ADC_IVS_AWD2_POS)
# define    ADC_IVS_AWD2     ADC_IVS_AWD2_MSK

# define    ADC_IVS_AWD1_POS 7U
# define    ADC_IVS_AWD1_MSK BIT(ADC_IVS_AWD1_POS)
# define    ADC_IVS_AWD1     ADC_IVS_AWD1_MSK

# define    ADC_IVS_JEOS_POS 6U
# define    ADC_IVS_JEOS_MSK BIT(ADC_IVS_JEOS_POS)
# define    ADC_IVS_JEOS     ADC_IVS_JEOS_MSK

# define    ADC_IVS_JEOC_POS 5U
# define    ADC_IVS_JEOC_MSK BIT(ADC_IVS_JEOC_POS)
# define    ADC_IVS_JEOC     ADC_IVS_JEOC_MSK

# define    ADC_IVS_ROVR_POS 4U
# define    ADC_IVS_ROVR_MSK BIT(ADC_IVS_ROVR_POS)
# define    ADC_IVS_ROVR     ADC_IVS_ROVR_MSK

# define    ADC_IVS_REOS_POS 3U
# define    ADC_IVS_REOS_MSK BIT(ADC_IVS_REOS_POS)
# define    ADC_IVS_REOS     ADC_IVS_REOS_MSK

# define    ADC_IVS_REOC_POS 2U
# define    ADC_IVS_REOC_MSK BIT(ADC_IVS_REOC_POS)
# define    ADC_IVS_REOC     ADC_IVS_REOC_MSK

# define    ADC_IVS_EOSMP_POS 1U
# define    ADC_IVS_EOSMP_MSK BIT(ADC_IVS_EOSMP_POS)
# define    ADC_IVS_EOSMP     ADC_IVS_EOSMP_MSK

/****************** Bit definition for ADC_RIF register ************************/

# define    ADC_RIF_TO_POS 15U
# define    ADC_RIF_TO_MSK BIT(ADC_RIF_TO_POS)
# define    ADC_RIF_TO     ADC_RIF_TO_MSK

# define    ADC_RIF_JQOVF_POS 10U
# define    ADC_RIF_JQOVF_MSK BIT(ADC_RIF_JQOVF_POS)
# define    ADC_RIF_JQOVF     ADC_RIF_JQOVF_MSK

# define    ADC_RIF_AWD3_POS 9U
# define    ADC_RIF_AWD3_MSK BIT(ADC_RIF_AWD3_POS)
# define    ADC_RIF_AWD3     ADC_RIF_AWD3_MSK

# define    ADC_RIF_AWD2_POS 8U
# define    ADC_RIF_AWD2_MSK BIT(ADC_RIF_AWD2_POS)
# define    ADC_RIF_AWD2     ADC_RIF_AWD2_MSK

# define    ADC_RIF_AWD1_POS 7U
# define    ADC_RIF_AWD1_MSK BIT(ADC_RIF_AWD1_POS)
# define    ADC_RIF_AWD1     ADC_RIF_AWD1_MSK

# define    ADC_RIF_JEOS_POS 6U
# define    ADC_RIF_JEOS_MSK BIT(ADC_RIF_JEOS_POS)
# define    ADC_RIF_JEOS     ADC_RIF_JEOS_MSK

# define    ADC_RIF_JEOC_POS 5U
# define    ADC_RIF_JEOC_MSK BIT(ADC_RIF_JEOC_POS)
# define    ADC_RIF_JEOC     ADC_RIF_JEOC_MSK

# define    ADC_RIF_ROVR_POS 4U
# define    ADC_RIF_ROVR_MSK BIT(ADC_RIF_ROVR_POS)
# define    ADC_RIF_ROVR     ADC_RIF_ROVR_MSK

# define    ADC_RIF_REOS_POS 3U
# define    ADC_RIF_REOS_MSK BIT(ADC_RIF_REOS_POS)
# define    ADC_RIF_REOS     ADC_RIF_REOS_MSK

# define    ADC_RIF_REOC_POS 2U
# define    ADC_RIF_REOC_MSK BIT(ADC_RIF_REOC_POS)
# define    ADC_RIF_REOC     ADC_RIF_REOC_MSK

# define    ADC_RIF_EOSMP_POS 1U
# define    ADC_RIF_EOSMP_MSK BIT(ADC_RIF_EOSMP_POS)
# define    ADC_RIF_EOSMP     ADC_RIF_EOSMP_MSK

/****************** Bit definition for ADC_IFM register ************************/

# define    ADC_IFM_TO_POS 15U
# define    ADC_IFM_TO_MSK BIT(ADC_IFM_TO_POS)
# define    ADC_IFM_TO     ADC_IFM_TO_MSK

# define    ADC_IFM_JQOVF_POS 10U
# define    ADC_IFM_JQOVF_MSK BIT(ADC_IFM_JQOVF_POS)
# define    ADC_IFM_JQOVF     ADC_IFM_JQOVF_MSK

# define    ADC_IFM_AWD3_POS 9U
# define    ADC_IFM_AWD3_MSK BIT(ADC_IFM_AWD3_POS)
# define    ADC_IFM_AWD3     ADC_IFM_AWD3_MSK

# define    ADC_IFM_AWD2_POS 8U
# define    ADC_IFM_AWD2_MSK BIT(ADC_IFM_AWD2_POS)
# define    ADC_IFM_AWD2     ADC_IFM_AWD2_MSK

# define    ADC_IFM_AWD1_POS 7U
# define    ADC_IFM_AWD1_MSK BIT(ADC_IFM_AWD1_POS)
# define    ADC_IFM_AWD1     ADC_IFM_AWD1_MSK

# define    ADC_IFM_JEOS_POS 6U
# define    ADC_IFM_JEOS_MSK BIT(ADC_IFM_JEOS_POS)
# define    ADC_IFM_JEOS     ADC_IFM_JEOS_MSK

# define    ADC_IFM_JEOC_POS 5U
# define    ADC_IFM_JEOC_MSK BIT(ADC_IFM_JEOC_POS)
# define    ADC_IFM_JEOC     ADC_IFM_JEOC_MSK

# define    ADC_IFM_ROVR_POS 4U
# define    ADC_IFM_ROVR_MSK BIT(ADC_IFM_ROVR_POS)
# define    ADC_IFM_ROVR     ADC_IFM_ROVR_MSK

# define    ADC_IFM_REOS_POS 3U
# define    ADC_IFM_REOS_MSK BIT(ADC_IFM_REOS_POS)
# define    ADC_IFM_REOS     ADC_IFM_REOS_MSK

# define    ADC_IFM_REOC_POS 2U
# define    ADC_IFM_REOC_MSK BIT(ADC_IFM_REOC_POS)
# define    ADC_IFM_REOC     ADC_IFM_REOC_MSK

# define    ADC_IFM_EOSMP_POS 1U
# define    ADC_IFM_EOSMP_MSK BIT(ADC_IFM_EOSMP_POS)
# define    ADC_IFM_EOSMP     ADC_IFM_EOSMP_MSK

/****************** Bit definition for ADC_ICR register ************************/

# define    ADC_ICR_TO_POS 15U
# define    ADC_ICR_TO_MSK BIT(ADC_ICR_TO_POS)
# define    ADC_ICR_TO     ADC_ICR_TO_MSK

# define    ADC_ICR_JQOVF_POS 10U
# define    ADC_ICR_JQOVF_MSK BIT(ADC_ICR_JQOVF_POS)
# define    ADC_ICR_JQOVF     ADC_ICR_JQOVF_MSK

# define    ADC_ICR_AWD3_POS 9U
# define    ADC_ICR_AWD3_MSK BIT(ADC_ICR_AWD3_POS)
# define    ADC_ICR_AWD3     ADC_ICR_AWD3_MSK

# define    ADC_ICR_AWD2_POS 8U
# define    ADC_ICR_AWD2_MSK BIT(ADC_ICR_AWD2_POS)
# define    ADC_ICR_AWD2     ADC_ICR_AWD2_MSK

# define    ADC_ICR_AWD1_POS 7U
# define    ADC_ICR_AWD1_MSK BIT(ADC_ICR_AWD1_POS)
# define    ADC_ICR_AWD1     ADC_ICR_AWD1_MSK

# define    ADC_ICR_JEOS_POS 6U
# define    ADC_ICR_JEOS_MSK BIT(ADC_ICR_JEOS_POS)
# define    ADC_ICR_JEOS     ADC_ICR_JEOS_MSK

# define    ADC_ICR_JEOC_POS 5U
# define    ADC_ICR_JEOC_MSK BIT(ADC_ICR_JEOC_POS)
# define    ADC_ICR_JEOC     ADC_ICR_JEOC_MSK

# define    ADC_ICR_ROVR_POS 4U
# define    ADC_ICR_ROVR_MSK BIT(ADC_ICR_ROVR_POS)
# define    ADC_ICR_ROVR     ADC_ICR_ROVR_MSK

# define    ADC_ICR_REOS_POS 3U
# define    ADC_ICR_REOS_MSK BIT(ADC_ICR_REOS_POS)
# define    ADC_ICR_REOS     ADC_ICR_REOS_MSK

# define    ADC_ICR_REOC_POS 2U
# define    ADC_ICR_REOC_MSK BIT(ADC_ICR_REOC_POS)
# define    ADC_ICR_REOC     ADC_ICR_REOC_MSK

# define    ADC_ICR_EOSMP_POS 1U
# define    ADC_ICR_EOSMP_MSK BIT(ADC_ICR_EOSMP_POS)
# define    ADC_ICR_EOSMP     ADC_ICR_EOSMP_MSK

/****************** Bit definition for ADC_CON register ************************/

# define    ADC_CON_LP_EN_POS 16U
# define    ADC_CON_LP_EN_MSK BIT(ADC_CON_LP_EN_POS)
# define    ADC_CON_LP_EN     ADC_CON_LP_EN_MSK

# define    ADC_CON_JSTP_POS 5U
# define    ADC_CON_JSTP_MSK BIT(ADC_CON_JSTP_POS)
# define    ADC_CON_JSTP     ADC_CON_JSTP_MSK

# define    ADC_CON_RSTP_POS 4U
# define    ADC_CON_RSTP_MSK BIT(ADC_CON_RSTP_POS)
# define    ADC_CON_RSTP     ADC_CON_RSTP_MSK

# define    ADC_CON_JSTART_POS 3U
# define    ADC_CON_JSTART_MSK BIT(ADC_CON_JSTART_POS)
# define    ADC_CON_JSTART     ADC_CON_JSTART_MSK

# define    ADC_CON_RSTART_POS 2U
# define    ADC_CON_RSTART_MSK BIT(ADC_CON_RSTART_POS)
# define    ADC_CON_RSTART     ADC_CON_RSTART_MSK

# define    ADC_CON_ADCDIS_POS 1U
# define    ADC_CON_ADCDIS_MSK BIT(ADC_CON_ADCDIS_POS)
# define    ADC_CON_ADCDIS     ADC_CON_ADCDIS_MSK

# define    ADC_CON_ADCEN_POS 0U
# define    ADC_CON_ADCEN_MSK BIT(ADC_CON_ADCEN_POS)
# define    ADC_CON_ADCEN     ADC_CON_ADCEN_MSK

/****************** Bit definition for ADC_CFG1 register ************************/

# define    ADC_CFG1_JQEN_POS 31U
# define    ADC_CFG1_JQEN_MSK BIT(ADC_CFG1_JQEN_POS)
# define    ADC_CFG1_JQEN     ADC_CFG1_JQEN_MSK

# define    ADC_CFG1_AWD1CH_POSS 26U
# define    ADC_CFG1_AWD1CH_POSE 30U
# define    ADC_CFG1_AWD1CH_MSK  BITS(ADC_CFG1_AWD1CH_POSS, ADC_CFG1_AWD1CH_POSE)
# define    ADC_CFG1_AWD1CH      ADC_CFG1_AWD1CH_MSK

# define    ADC_CFG1_JAUTO_POS 25U
# define    ADC_CFG1_JAUTO_MSK BIT(ADC_CFG1_JAUTO_POS)
# define    ADC_CFG1_JAUTO     ADC_CFG1_JAUTO_MSK

# define    ADC_CFG1_AWD1JEN_POS 24U
# define    ADC_CFG1_AWD1JEN_MSK BIT(ADC_CFG1_AWD1JEN_POS)
# define    ADC_CFG1_AWD1JEN     ADC_CFG1_AWD1JEN_MSK

# define    ADC_CFG1_AWD1REN_POS 23U
# define    ADC_CFG1_AWD1REN_MSK BIT(ADC_CFG1_AWD1REN_POS)
# define    ADC_CFG1_AWD1REN     ADC_CFG1_AWD1REN_MSK

# define    ADC_CFG1_AWD1SEL_POS 22U
# define    ADC_CFG1_AWD1SEL_MSK BIT(ADC_CFG1_AWD1SEL_POS)
# define    ADC_CFG1_AWD1SEL     ADC_CFG1_AWD1SEL_MSK

# define    ADC_CFG1_JQM_POS 21U
# define    ADC_CFG1_JQM_MSK BIT(ADC_CFG1_JQM_POS)
# define    ADC_CFG1_JQM     ADC_CFG1_JQM_MSK

# define    ADC_CFG1_JDISCEN_POS 20U
# define    ADC_CFG1_JDISCEN_MSK BIT(ADC_CFG1_JDISCEN_POS)
# define    ADC_CFG1_JDISCEN     ADC_CFG1_JDISCEN_MSK

# define    ADC_CFG1_DISCNUM_POSS 17U
# define    ADC_CFG1_DISCNUM_POSE 19U
# define    ADC_CFG1_DISCNUM_MSK  BITS(ADC_CFG1_DISCNUM_POSS, ADC_CFG1_DISCNUM_POSE)
# define    ADC_CFG1_DISCNUM      ADC_CFG1_DISCNUM_MSK

# define    ADC_CFG1_DISCEN_POS 16U
# define    ADC_CFG1_DISCEN_MSK BIT(ADC_CFG1_DISCEN_POS)
# define    ADC_CFG1_DISCEN     ADC_CFG1_DISCEN_MSK

# define    ADC_CFG1_ALIGN_POS 15U
# define    ADC_CFG1_ALIGN_MSK BIT(ADC_CFG1_ALIGN_POS)
# define    ADC_CFG1_ALIGN     ADC_CFG1_ALIGN_MSK

# define    ADC_CFG1_AUTODLY_POS 14U
# define    ADC_CFG1_AUTODLY_MSK BIT(ADC_CFG1_AUTODLY_POS)
# define    ADC_CFG1_AUTODLY     ADC_CFG1_AUTODLY_MSK

# define    ADC_CFG1_RCONT_POS 13U
# define    ADC_CFG1_RCONT_MSK BIT(ADC_CFG1_RCONT_POS)
# define    ADC_CFG1_RCONT     ADC_CFG1_RCONT_MSK

# define    ADC_CFG1_OVRRMOD_POS 12U
# define    ADC_CFG1_OVRRMOD_MSK BIT(ADC_CFG1_OVRRMOD_POS)
# define    ADC_CFG1_OVRRMOD     ADC_CFG1_OVRRMOD_MSK

# define    ADC_CFG1_REXTEN_POSS 10U
# define    ADC_CFG1_REXTEN_POSE 11U
# define    ADC_CFG1_REXTEN_MSK  BITS(ADC_CFG1_REXTEN_POSS, ADC_CFG1_REXTEN_POSE)
# define    ADC_CFG1_REXTEN      ADC_CFG1_REXTEN_MSK

# define    ADC_CFG1_REXTSEL_POSS 5U
# define    ADC_CFG1_REXTSEL_POSE 9U
# define    ADC_CFG1_REXTSEL_MSK  BITS(ADC_CFG1_REXTSEL_POSS, ADC_CFG1_REXTSEL_POSE)
# define    ADC_CFG1_REXTSEL      ADC_CFG1_REXTSEL_MSK

# define    ADC_CFG1_RESOL_POSS 3U
# define    ADC_CFG1_RESOL_POSE 4U
# define    ADC_CFG1_RESOL_MSK  BITS(ADC_CFG1_RESOL_POSS, ADC_CFG1_RESOL_POSE)
# define    ADC_CFG1_RESOL      ADC_CFG1_RESOL_MSK

# define    ADC_CFG1_DMAEN_POS 0U
# define    ADC_CFG1_DMAEN_MSK BIT(ADC_CFG1_DMAEN_POS)
# define    ADC_CFG1_DMAEN     ADC_CFG1_DMAEN_MSK

/****************** Bit definition for ADC_CFG2 register ************************/

# define    ADC_CFG2_SMPTRIG_POS 27U
# define    ADC_CFG2_SMPTRIG_MSK BIT(ADC_CFG2_SMPTRIG_POS)
# define    ADC_CFG2_SMPTRIG     ADC_CFG2_SMPTRIG_MSK

# define    ADC_CFG2_BULB_POS 26U
# define    ADC_CFG2_BULB_MSK BIT(ADC_CFG2_BULB_POS)
# define    ADC_CFG2_BULB     ADC_CFG2_BULB_MSK

# define    ADC_CFG2_SWTRIG_POS 25U
# define    ADC_CFG2_SWTRIG_MSK BIT(ADC_CFG2_SWTRIG_POS)
# define    ADC_CFG2_SWTRIG     ADC_CFG2_SWTRIG_MSK

# define    ADC_CFG2_GCOMP_POS 16U
# define    ADC_CFG2_GCOMP_MSK BIT(ADC_CFG2_GCOMP_POS)
# define    ADC_CFG2_GCOMP     ADC_CFG2_GCOMP_MSK

# define    ADC_CFG2_ROVSM_POS 10U
# define    ADC_CFG2_ROVSM_MSK BIT(ADC_CFG2_ROVSM_POS)
# define    ADC_CFG2_ROVSM     ADC_CFG2_ROVSM_MSK

# define    ADC_CFG2_TROVS_POS 9U
# define    ADC_CFG2_TROVS_MSK BIT(ADC_CFG2_TROVS_POS)
# define    ADC_CFG2_TROVS     ADC_CFG2_TROVS_MSK

# define    ADC_CFG2_OVSSHIFT_POSS 5U
# define    ADC_CFG2_OVSSHIFT_POSE 8U
# define    ADC_CFG2_OVSSHIFT_MSK  BITS(ADC_CFG2_OVSSHIFT_POSS, ADC_CFG2_OVSSHIFT_POSE)
# define    ADC_CFG2_OVSSHIFT      ADC_CFG2_OVSSHIFT_MSK

# define    ADC_CFG2_OVSRATIO_POSS 2U
# define    ADC_CFG2_OVSRATIO_POSE 4U
# define    ADC_CFG2_OVSRATIO_MSK  BITS(ADC_CFG2_OVSRATIO_POSS, ADC_CFG2_OVSRATIO_POSE)
# define    ADC_CFG2_OVSRATIO      ADC_CFG2_OVSRATIO_MSK

# define    ADC_CFG2_JOVSEN_POS 1U
# define    ADC_CFG2_JOVSEN_MSK BIT(ADC_CFG2_JOVSEN_POS)
# define    ADC_CFG2_JOVSEN     ADC_CFG2_JOVSEN_MSK

# define    ADC_CFG2_ROVSEN_POS 0U
# define    ADC_CFG2_ROVSEN_MSK BIT(ADC_CFG2_ROVSEN_POS)
# define    ADC_CFG2_ROVSEN     ADC_CFG2_ROVSEN_MSK

/****************** Bit definition for ADC_SMPT1 register ************************/

# define    ADC_SMPT1_SMP3_POSS 24U
# define    ADC_SMPT1_SMP3_POSE 31U
# define    ADC_SMPT1_SMP3_MSK  BITS(ADC_SMPT1_SMP3_POSS, ADC_SMPT1_SMP3_POSE)
# define    ADC_SMPT1_SMP3      ADC_SMPT1_SMP3_MSK

# define    ADC_SMPT1_SMP2_POSS 16U
# define    ADC_SMPT1_SMP2_POSE 23U
# define    ADC_SMPT1_SMP2_MSK  BITS(ADC_SMPT1_SMP2_POSS, ADC_SMPT1_SMP2_POSE)
# define    ADC_SMPT1_SMP2      ADC_SMPT1_SMP2_MSK

# define    ADC_SMPT1_SMP1_POSS 8U
# define    ADC_SMPT1_SMP1_POSE 15U
# define    ADC_SMPT1_SMP1_MSK  BITS(ADC_SMPT1_SMP1_POSS, ADC_SMPT1_SMP1_POSE)
# define    ADC_SMPT1_SMP1      ADC_SMPT1_SMP1_MSK

# define    ADC_SMPT1_SMP0_POSS 0U
# define    ADC_SMPT1_SMP0_POSE 7U
# define    ADC_SMPT1_SMP0_MSK  BITS(ADC_SMPT1_SMP0_POSS, ADC_SMPT1_SMP0_POSE)
# define    ADC_SMPT1_SMP0      ADC_SMPT1_SMP0_MSK

/****************** Bit definition for ADC_SMPT2 register ************************/

# define    ADC_SMPT2_SMP7_POSS 24U
# define    ADC_SMPT2_SMP7_POSE 31U
# define    ADC_SMPT2_SMP7_MSK  BITS(ADC_SMPT2_SMP7_POSS, ADC_SMPT2_SMP7_POSE)
# define    ADC_SMPT2_SMP7      ADC_SMPT2_SMP7_MSK

# define    ADC_SMPT2_SMP6_POSS 16U
# define    ADC_SMPT2_SMP6_POSE 23U
# define    ADC_SMPT2_SMP6_MSK  BITS(ADC_SMPT2_SMP6_POSS, ADC_SMPT2_SMP6_POSE)
# define    ADC_SMPT2_SMP6      ADC_SMPT2_SMP6_MSK

# define    ADC_SMPT2_SMP5_POSS 8U
# define    ADC_SMPT2_SMP5_POSE 15U
# define    ADC_SMPT2_SMP5_MSK  BITS(ADC_SMPT2_SMP5_POSS, ADC_SMPT2_SMP5_POSE)
# define    ADC_SMPT2_SMP5      ADC_SMPT2_SMP5_MSK

# define    ADC_SMPT2_SMP4_POSS 0U
# define    ADC_SMPT2_SMP4_POSE 7U
# define    ADC_SMPT2_SMP4_MSK  BITS(ADC_SMPT2_SMP4_POSS, ADC_SMPT2_SMP4_POSE)
# define    ADC_SMPT2_SMP4      ADC_SMPT2_SMP4_MSK

/****************** Bit definition for ADC_SMPT3 register ************************/

# define    ADC_SMPT3_SMP11_POSS 24U
# define    ADC_SMPT3_SMP11_POSE 31U
# define    ADC_SMPT3_SMP11_MSK  BITS(ADC_SMPT3_SMP11_POSS, ADC_SMPT3_SMP11_POSE)
# define    ADC_SMPT3_SMP11      ADC_SMPT3_SMP11_MSK
    
# define    ADC_SMPT3_SMP10_POSS 16U
# define    ADC_SMPT3_SMP10_POSE 23U
# define    ADC_SMPT3_SMP10_MSK  BITS(ADC_SMPT3_SMP10_POSS, ADC_SMPT3_SMP10_POSE)
# define    ADC_SMPT3_SMP10      ADC_SMPT3_SMP10_MSK
   
# define    ADC_SMPT3_SMP9_POSS 8U
# define    ADC_SMPT3_SMP9_POSE 15U
# define    ADC_SMPT3_SMP9_MSK  BITS(ADC_SMPT3_SMP9_POSS, ADC_SMPT3_SMP9_POSE)
# define    ADC_SMPT3_SMP9      ADC_SMPT3_SMP9_MSK
   
# define    ADC_SMPT3_SMP8_POSS 0U
# define    ADC_SMPT3_SMP8_POSE 7U
# define    ADC_SMPT3_SMP8_MSK  BITS(ADC_SMPT3_SMP8_POSS, ADC_SMPT3_SMP8_POSE)
# define    ADC_SMPT3_SMP8      ADC_SMPT3_SMP8_MSK

/****************** Bit definition for ADC_SMPT4 register ************************/

# define    ADC_SMPT4_SMP15_POSS 24U
# define    ADC_SMPT4_SMP15_POSE 31U
# define    ADC_SMPT4_SMP15_MSK  BITS(ADC_SMPT4_SMP15_POSS, ADC_SMPT4_SMP15_POSE)
# define    ADC_SMPT4_SMP15      ADC_SMPT4_SMP15_MSK

# define    ADC_SMPT4_SMP14_POSS 16U
# define    ADC_SMPT4_SMP14_POSE 23U
# define    ADC_SMPT4_SMP14_MSK  BITS(ADC_SMPT4_SMP14_POSS, ADC_SMPT4_SMP14_POSE)
# define    ADC_SMPT4_SMP14      ADC_SMPT4_SMP14_MSK

# define    ADC_SMPT4_SMP13_POSS 8U
# define    ADC_SMPT4_SMP13_POSE 15U
# define    ADC_SMPT4_SMP13_MSK  BITS(ADC_SMPT4_SMP13_POSS, ADC_SMPT4_SMP13_POSE)
# define    ADC_SMPT4_SMP13      ADC_SMPT4_SMP13_MSK

# define    ADC_SMPT4_SMP12_POSS 0U
# define    ADC_SMPT4_SMP12_POSE 7U
# define    ADC_SMPT4_SMP12_MSK  BITS(ADC_SMPT4_SMP12_POSS, ADC_SMPT4_SMP12_POSE)
# define    ADC_SMPT4_SMP12      ADC_SMPT4_SMP12_MSK

/****************** Bit definition for ADC_SMPT5 register ************************/

# define    ADC_SMPT5_SMPPLUS_POS 24U
# define    ADC_SMPT5_SMPPLUS_MSK  BIT(ADC_SMPT5_SMPPLUS_POS)
# define    ADC_SMPT5_SMPPLUS      ADC_SMPT5_SMPPLUS_MSK

# define    ADC_SMPT5_SMP18_POSS 16U
# define    ADC_SMPT5_SMP18_POSE 23U
# define    ADC_SMPT5_SMP18_MSK  BITS(ADC_SMPT5_SMP18_POSS, ADC_SMPT5_SMP18_POSE)
# define    ADC_SMPT5_SMP18      ADC_SMPT5_SMP18_MSK

# define    ADC_SMPT5_SMP17_POSS 8U
# define    ADC_SMPT5_SMP17_POSE 15U
# define    ADC_SMPT5_SMP17_MSK  BITS(ADC_SMPT5_SMP17_POSS, ADC_SMPT5_SMP17_POSE)
# define    ADC_SMPT5_SMP17      ADC_SMPT5_SMP17_MSK

# define    ADC_SMPT5_SMP16_POSS 0U
# define    ADC_SMPT5_SMP16_POSE 7U
# define    ADC_SMPT5_SMP16_MSK  BITS(ADC_SMPT5_SMP16_POSS, ADC_SMPT5_SMP16_POSE)
# define    ADC_SMPT5_SMP16      ADC_SMPT5_SMP16_MSK

/****************** Bit definition for ADC_TR1 register ************************/

# define    ADC_TR1_HT1_POSS 16U
# define    ADC_TR1_HT1_POSE 27U
# define    ADC_TR1_HT1_MSK  BITS(ADC_TR1_HT1_POSS, ADC_TR1_HT1_POSE)
# define    ADC_TR1_HT1      ADC_TR1_HT1_MSK

# define    ADC_TR1_AWDFILT_POSS 12U
# define    ADC_TR1_AWDFILT_POSE 14U
# define    ADC_TR1_AWDFILT_MSK  BITS(ADC_TR1_AWDFILT_POSS, ADC_TR1_AWDFILT_POSE)
# define    ADC_TR1_AWDFILT      ADC_TR1_AWDFILT_MSK

# define    ADC_TR1_LT1_POSS 0U
# define    ADC_TR1_LT1_POSE 11U
# define    ADC_TR1_LT1_MSK  BITS(ADC_TR1_LT1_POSS, ADC_TR1_LT1_POSE)
# define    ADC_TR1_LT1      ADC_TR1_LT1_MSK

/****************** Bit definition for ADC_TR2 register ************************/

# define    ADC_TR2_HT2_POSS 16U
# define    ADC_TR2_HT2_POSE 23U
# define    ADC_TR2_HT2_MSK  BITS(ADC_TR2_HT2_POSS, ADC_TR2_HT2_POSE)
# define    ADC_TR2_HT2      ADC_TR2_HT2_MSK

# define    ADC_TR2_LT2_POSS 0U
# define    ADC_TR2_LT2_POSE 7U
# define    ADC_TR2_LT2_MSK  BITS(ADC_TR2_LT2_POSS, ADC_TR2_LT2_POSE)
# define    ADC_TR2_LT2      ADC_TR2_LT2_MSK

/****************** Bit definition for ADC_TR3 register ************************/

# define    ADC_TR3_HT3_POSS 16U
# define    ADC_TR3_HT3_POSE 23U
# define    ADC_TR3_HT3_MSK  BITS(ADC_TR3_HT3_POSS, ADC_TR3_HT3_POSE)
# define    ADC_TR3_HT3      ADC_TR3_HT3_MSK

# define    ADC_TR3_LT3_POSS 0U
# define    ADC_TR3_LT3_POSE 7U
# define    ADC_TR3_LT3_MSK  BITS(ADC_TR3_LT3_POSS, ADC_TR3_LT3_POSE)
# define    ADC_TR3_LT3      ADC_TR3_LT3_MSK

/****************** Bit definition for ADC_SQR1 register ************************/

# define    ADC_SQR1_RSQ4_POSS 24U
# define    ADC_SQR1_RSQ4_POSE 28U
# define    ADC_SQR1_RSQ4_MSK  BITS(ADC_SQR1_RSQ4_POSS, ADC_SQR1_RSQ4_POSE)
# define    ADC_SQR1_RSQ4      ADC_SQR1_RSQ4_MSK

# define    ADC_SQR1_RSQ3_POSS 18U
# define    ADC_SQR1_RSQ3_POSE 22U
# define    ADC_SQR1_RSQ3_MSK  BITS(ADC_SQR1_RSQ3_POSS, ADC_SQR1_RSQ3_POSE)
# define    ADC_SQR1_RSQ3      ADC_SQR1_RSQ3_MSK

# define    ADC_SQR1_RSQ2_POSS 12U
# define    ADC_SQR1_RSQ2_POSE 16U
# define    ADC_SQR1_RSQ2_MSK  BITS(ADC_SQR1_RSQ2_POSS, ADC_SQR1_RSQ2_POSE)
# define    ADC_SQR1_RSQ2      ADC_SQR1_RSQ2_MSK

# define    ADC_SQR1_RSQ1_POSS 6U
# define    ADC_SQR1_RSQ1_POSE 10U
# define    ADC_SQR1_RSQ1_MSK  BITS(ADC_SQR1_RSQ1_POSS, ADC_SQR1_RSQ1_POSE)
# define    ADC_SQR1_RSQ1      ADC_SQR1_RSQ1_MSK

# define    ADC_SQR1_RSQLEN_POSS 0U
# define    ADC_SQR1_RSQLEN_POSE 3U
# define    ADC_SQR1_RSQLEN_MSK  BITS(ADC_SQR1_RSQLEN_POSS, ADC_SQR1_RSQLEN_POSE)
# define    ADC_SQR1_RSQLEN      ADC_SQR1_RSQLEN_MSK

/****************** Bit definition for ADC_SQR2 register ************************/

# define    ADC_SQR2_RSQ9_POSS 24U
# define    ADC_SQR2_RSQ9_POSE 28U
# define    ADC_SQR2_RSQ9_MSK  BITS(ADC_SQR2_RSQ9_POSS, ADC_SQR2_RSQ9_POSE)
# define    ADC_SQR2_RSQ9      ADC_SQR2_RSQ9_MSK

# define    ADC_SQR2_RSQ8_POSS 18U
# define    ADC_SQR2_RSQ8_POSE 22U
# define    ADC_SQR2_RSQ8_MSK  BITS(ADC_SQR2_RSQ8_POSS, ADC_SQR2_RSQ8_POSE)
# define    ADC_SQR2_RSQ8      ADC_SQR2_RSQ8_MSK

# define    ADC_SQR2_RSQ7_POSS 12U
# define    ADC_SQR2_RSQ7_POSE 16U
# define    ADC_SQR2_RSQ7_MSK  BITS(ADC_SQR2_RSQ7_POSS, ADC_SQR2_RSQ7_POSE)
# define    ADC_SQR2_RSQ7      ADC_SQR2_RSQ7_MSK

# define    ADC_SQR2_RSQ6_POSS 6U
# define    ADC_SQR2_RSQ6_POSE 10U
# define    ADC_SQR2_RSQ6_MSK  BITS(ADC_SQR2_RSQ6_POSS, ADC_SQR2_RSQ6_POSE)
# define    ADC_SQR2_RSQ6      ADC_SQR2_RSQ6_MSK

# define    ADC_SQR2_RSQ5_POSS 0U
# define    ADC_SQR2_RSQ5_POSE 4U
# define    ADC_SQR2_RSQ5_MSK  BITS(ADC_SQR2_RSQ5_POSS, ADC_SQR2_RSQ5_POSE)
# define    ADC_SQR2_RSQ5      ADC_SQR2_RSQ5_MSK

/****************** Bit definition for ADC_SQR3 register ************************/

# define    ADC_SQR3_RSQ14_POSS 24U
# define    ADC_SQR3_RSQ14_POSE 28U
# define    ADC_SQR3_RSQ14_MSK  BITS(ADC_SQR3_RSQ14_POSS, ADC_SQR3_RSQ14_POSE)
# define    ADC_SQR3_RSQ14      ADC_SQR3_RSQ14_MSK

# define    ADC_SQR3_RSQ13_POSS 18U
# define    ADC_SQR3_RSQ13_POSE 22U
# define    ADC_SQR3_RSQ13_MSK  BITS(ADC_SQR3_RSQ13_POSS, ADC_SQR3_RSQ13_POSE)
# define    ADC_SQR3_RSQ13      ADC_SQR3_RSQ13_MSK

# define    ADC_SQR3_RSQ12_POSS 12U
# define    ADC_SQR3_RSQ12_POSE 16U
# define    ADC_SQR3_RSQ12_MSK  BITS(ADC_SQR3_RSQ12_POSS, ADC_SQR3_RSQ12_POSE)
# define    ADC_SQR3_RSQ12      ADC_SQR3_RSQ12_MSK

# define    ADC_SQR3_RSQ11_POSS 6U
# define    ADC_SQR3_RSQ11_POSE 10U
# define    ADC_SQR3_RSQ11_MSK  BITS(ADC_SQR3_RSQ11_POSS, ADC_SQR3_RSQ11_POSE)
# define    ADC_SQR3_RSQ11      ADC_SQR3_RSQ11_MSK

# define    ADC_SQR3_RSQ10_POSS 0U
# define    ADC_SQR3_RSQ10_POSE 4U
# define    ADC_SQR3_RSQ10_MSK  BITS(ADC_SQR3_RSQ10_POSS, ADC_SQR3_RSQ10_POSE)
# define    ADC_SQR3_RSQ10      ADC_SQR3_RSQ10_MSK

/****************** Bit definition for ADC_SQR4 register ************************/

# define    ADC_SQR4_RSQ16_POSS 6U
# define    ADC_SQR4_RSQ16_POSE 10U
# define    ADC_SQR4_RSQ16_MSK  BITS(ADC_SQR4_RSQ16_POSS, ADC_SQR4_RSQ16_POSE)
# define    ADC_SQR4_RSQ16      ADC_SQR4_RSQ16_MSK

# define    ADC_SQR4_RSQ15_POSS 0U
# define    ADC_SQR4_RSQ15_POSE 4U
# define    ADC_SQR4_RSQ15_MSK  BITS(ADC_SQR4_RSQ15_POSS, ADC_SQR4_RSQ15_POSE)
# define    ADC_SQR4_RSQ15      ADC_SQR4_RSQ15_MSK

/****************** Bit definition for ADC_DR register ************************/

# define    ADC_DR_RDATA_POSS 0U
# define    ADC_DR_RDATA_POSE 15U
# define    ADC_DR_RDATA_MSK  BITS(ADC_DR_RDATA_POSS, ADC_DR_RDATA_POSE)
# define    ADC_DR_RDATA      ADC_DR_RDATA_MSK

/****************** Bit definition for ADC_JSQR register ************************/

# define    ADC_JSQR_JSQ4_POSS 27U
# define    ADC_JSQR_JSQ4_POSE 31U
# define    ADC_JSQR_JSQ4_MSK  BITS(ADC_JSQR_JSQ4_POSS, ADC_JSQR_JSQ4_POSE)
# define    ADC_JSQR_JSQ4      ADC_JSQR_JSQ4_MSK

# define    ADC_JSQR_JSQ3_POSS 21U
# define    ADC_JSQR_JSQ3_POSE 25U
# define    ADC_JSQR_JSQ3_MSK  BITS(ADC_JSQR_JSQ3_POSS, ADC_JSQR_JSQ3_POSE)
# define    ADC_JSQR_JSQ3      ADC_JSQR_JSQ3_MSK

# define    ADC_JSQR_JSQ2_POSS 15U
# define    ADC_JSQR_JSQ2_POSE 19U
# define    ADC_JSQR_JSQ2_MSK  BITS(ADC_JSQR_JSQ2_POSS, ADC_JSQR_JSQ2_POSE)
# define    ADC_JSQR_JSQ2      ADC_JSQR_JSQ2_MSK

# define    ADC_JSQR_JSQ1_POSS 9U
# define    ADC_JSQR_JSQ1_POSE 13U
# define    ADC_JSQR_JSQ1_MSK  BITS(ADC_JSQR_JSQ1_POSS, ADC_JSQR_JSQ1_POSE)
# define    ADC_JSQR_JSQ1      ADC_JSQR_JSQ1_MSK

# define    ADC_JSQR_JEXTEN_POSS 7U
# define    ADC_JSQR_JEXTEN_POSE 8U
# define    ADC_JSQR_JEXTEN_MSK  BITS(ADC_JSQR_JEXTEN_POSS, ADC_JSQR_JEXTEN_POSE)
# define    ADC_JSQR_JEXTEN      ADC_JSQR_JEXTEN_MSK

# define    ADC_JSQR_JEXTSEL_POSS 2U
# define    ADC_JSQR_JEXTSEL_POSE 6U
# define    ADC_JSQR_JEXTSEL_MSK  BITS(ADC_JSQR_JEXTSEL_POSS, ADC_JSQR_JEXTSEL_POSE)
# define    ADC_JSQR_JEXTSEL      ADC_JSQR_JEXTSEL_MSK

# define    ADC_JSQR_JSQLEN_POSS 0U
# define    ADC_JSQR_JSQLEN_POSE 1U
# define    ADC_JSQR_JSQLEN_MSK  BITS(ADC_JSQR_JSQLEN_POSS, ADC_JSQR_JSQLEN_POSE)
# define    ADC_JSQR_JSQLEN      ADC_JSQR_JSQLEN_MSK

/****************** Bit definition for ADC_OFST1 register ************************/

# define    ADC_OFST1_OFFSETEN_POS 31U
# define    ADC_OFST1_OFFSETEN_MSK BIT(ADC_OFST1_OFFSETEN_POS)
# define    ADC_OFST1_OFFSETEN     ADC_OFST1_OFFSETEN_MSK

# define    ADC_OFST1_OFFSETCH_POSS 26U
# define    ADC_OFST1_OFFSETCH_POSE 30U
# define    ADC_OFST1_OFFSETCH_MSK  BITS(ADC_OFST1_OFFSETCH_POSS, ADC_OFST1_OFFSETCH_POSE)
# define    ADC_OFST1_OFFSETCH      ADC_OFST1_OFFSETCH_MSK

# define    ADC_OFST1_SATEN_POS 25U
# define    ADC_OFST1_SATEN_MSK BIT(ADC_OFST1_SATEN_POS)
# define    ADC_OFST1_SATEN     ADC_OFST1_SATEN_MSK

# define    ADC_OFST1_POSEN_POS 24U
# define    ADC_OFST1_POSEN_MSK BIT(ADC_OFST1_POSEN_POS)
# define    ADC_OFST1_POSEN     ADC_OFST1_POSEN_MSK

# define    ADC_OFST1_OFFSET_POSS 0U
# define    ADC_OFST1_OFFSET_POSE 11U
# define    ADC_OFST1_OFFSET_MSK  BITS(ADC_OFST1_OFFSET_POSS, ADC_OFST1_OFFSET_POSE)
# define    ADC_OFST1_OFFSET      ADC_OFST1_OFFSET_MSK

/****************** Bit definition for ADC_OFST2 register ************************/

# define    ADC_OFST2_OFFSETEN_POS 31U
# define    ADC_OFST2_OFFSETEN_MSK BIT(ADC_OFST2_OFFSETEN_POS)
# define    ADC_OFST2_OFFSETEN     ADC_OFST2_OFFSETEN_MSK

# define    ADC_OFST2_OFFSETCH_POSS 26U
# define    ADC_OFST2_OFFSETCH_POSE 30U
# define    ADC_OFST2_OFFSETCH_MSK  BITS(ADC_OFST2_OFFSETCH_POSS, ADC_OFST2_OFFSETCH_POSE)
# define    ADC_OFST2_OFFSETCH      ADC_OFST2_OFFSETCH_MSK

# define    ADC_OFST2_SATEN_POS 25U
# define    ADC_OFST2_SATEN_MSK BIT(ADC_OFST2_SATEN_POS)
# define    ADC_OFST2_SATEN     ADC_OFST2_SATEN_MSK

# define    ADC_OFST2_POSEN_POS 24U
# define    ADC_OFST2_POSEN_MSK BIT(ADC_OFST2_POSEN_POS)
# define    ADC_OFST2_POSEN     ADC_OFST2_POSEN_MSK

# define    ADC_OFST2_OFFSET_POSS 0U
# define    ADC_OFST2_OFFSET_POSE 11U
# define    ADC_OFST2_OFFSET_MSK  BITS(ADC_OFST2_OFFSET_POSS, ADC_OFST2_OFFSET_POSE)
# define    ADC_OFST2_OFFSET      ADC_OFST2_OFFSET_MSK

/****************** Bit definition for ADC_OFST3 register ************************/

# define    ADC_OFST3_OFFSETEN_POS 31U
# define    ADC_OFST3_OFFSETEN_MSK BIT(ADC_OFST3_OFFSETEN_POS)
# define    ADC_OFST3_OFFSETEN     ADC_OFST3_OFFSETEN_MSK

# define    ADC_OFST3_OFFSETCH_POSS 26U
# define    ADC_OFST3_OFFSETCH_POSE 30U
# define    ADC_OFST3_OFFSETCH_MSK  BITS(ADC_OFST3_OFFSETCH_POSS, ADC_OFST3_OFFSETCH_POSE)
# define    ADC_OFST3_OFFSETCH      ADC_OFST3_OFFSETCH_MSK

# define    ADC_OFST3_SATEN_POS 25U
# define    ADC_OFST3_SATEN_MSK BIT(ADC_OFST3_SATEN_POS)
# define    ADC_OFST3_SATEN     ADC_OFST3_SATEN_MSK

# define    ADC_OFST3_POSEN_POS 24U
# define    ADC_OFST3_POSEN_MSK BIT(ADC_OFST3_POSEN_POS)
# define    ADC_OFST3_POSEN     ADC_OFST3_POSEN_MSK

# define    ADC_OFST3_OFFSET_POSS 0U
# define    ADC_OFST3_OFFSET_POSE 11U
# define    ADC_OFST3_OFFSET_MSK  BITS(ADC_OFST3_OFFSET_POSS, ADC_OFST3_OFFSET_POSE)
# define    ADC_OFST3_OFFSET      ADC_OFST3_OFFSET_MSK

/****************** Bit definition for ADC_OFST4 register ************************/

# define    ADC_OFST4_OFFSETEN_POS 31U
# define    ADC_OFST4_OFFSETEN_MSK BIT(ADC_OFST4_OFFSETEN_POS)
# define    ADC_OFST4_OFFSETEN     ADC_OFST4_OFFSETEN_MSK

# define    ADC_OFST4_OFFSETCH_POSS 26U
# define    ADC_OFST4_OFFSETCH_POSE 30U
# define    ADC_OFST4_OFFSETCH_MSK  BITS(ADC_OFST4_OFFSETCH_POSS, ADC_OFST4_OFFSETCH_POSE)
# define    ADC_OFST4_OFFSETCH      ADC_OFST4_OFFSETCH_MSK

# define    ADC_OFST4_SATEN_POS 25U
# define    ADC_OFST4_SATEN_MSK BIT(ADC_OFST4_SATEN_POS)
# define    ADC_OFST4_SATEN     ADC_OFST4_SATEN_MSK

# define    ADC_OFST4_POSEN_POS 24U
# define    ADC_OFST4_POSEN_MSK BIT(ADC_OFST4_POSEN_POS)
# define    ADC_OFST4_POSEN     ADC_OFST4_POSEN_MSK

# define    ADC_OFST4_OFFSET_POSS 0U
# define    ADC_OFST4_OFFSET_POSE 11U
# define    ADC_OFST4_OFFSET_MSK  BITS(ADC_OFST4_OFFSET_POSS, ADC_OFST4_OFFSET_POSE)
# define    ADC_OFST4_OFFSET      ADC_OFST4_OFFSET_MSK

/****************** Bit definition for ADC_JDR1 register ************************/

# define    ADC_JDR1_JDATA1_POSS 0U
# define    ADC_JDR1_JDATA1_POSE 15U
# define    ADC_JDR1_JDATA1_MSK  BITS(ADC_JDR1_JDATA1_POSS, ADC_JDR1_JDATA1_POSE)
# define    ADC_JDR1_JDATA1      ADC_JDR1_JDATA1_MSK

/****************** Bit definition for ADC_JDR2 register ************************/

# define    ADC_JDR2_JDATA2_POSS 0U
# define    ADC_JDR2_JDATA2_POSE 15U
# define    ADC_JDR2_JDATA2_MSK  BITS(ADC_JDR2_JDATA2_POSS, ADC_JDR2_JDATA2_POSE)
# define    ADC_JDR2_JDATA2      ADC_JDR2_JDATA2_MSK

/****************** Bit definition for ADC_JDR3 register ************************/

# define    ADC_JDR3_JDATA3_POSS 0U
# define    ADC_JDR3_JDATA3_POSE 15U
# define    ADC_JDR3_JDATA3_MSK  BITS(ADC_JDR3_JDATA3_POSS, ADC_JDR3_JDATA3_POSE)
# define    ADC_JDR3_JDATA3      ADC_JDR3_JDATA3_MSK

/****************** Bit definition for ADC_JDR4 register ************************/

# define    ADC_JDR4_JDATA4_POSS 0U
# define    ADC_JDR4_JDATA4_POSE 15U
# define    ADC_JDR4_JDATA4_MSK  BITS(ADC_JDR4_JDATA4_POSS, ADC_JDR4_JDATA4_POSE)
# define    ADC_JDR4_JDATA4      ADC_JDR4_JDATA4_MSK

/****************** Bit definition for ADC_AWD2CR register ************************/

# define    ADC_AWD2CR_AWD2CH_POSS 0U
# define    ADC_AWD2CR_AWD2CH_POSE 18U
# define    ADC_AWD2CR_AWD2CH_MSK  BITS(ADC_AWD2CR_AWD2CH_POSS, ADC_AWD2CR_AWD2CH_POSE)
# define    ADC_AWD2CR_AWD2CH      ADC_AWD2CR_AWD2CH_MSK

/****************** Bit definition for ADC_AWD3CR register ************************/

# define    ADC_AWD3CR_AWD3CH_POSS 0U
# define    ADC_AWD3CR_AWD3CH_POSE 18U
# define    ADC_AWD3CR_AWD3CH_MSK  BITS(ADC_AWD3CR_AWD3CH_POSS, ADC_AWD3CR_AWD3CH_POSE)
# define    ADC_AWD3CR_AWD3CH      ADC_AWD3CR_AWD3CH_MSK

/****************** Bit definition for ADC_GCOMP register ************************/

# define    ADC_GCOMP_COEF_POSS 0U
# define    ADC_GCOMP_COEF_POSE 18U
# define    ADC_GCOMP_COEF_MSK  BITS(ADC_GCOMP_COEF_POSS, ADC_GCOMP_COEF_POSE)
# define    ADC_GCOMP_COEF      ADC_GCOMP_COEF_MSK

/****************** Bit definition for ADC_CCR register ************************/

# define    ADC_CCR_VTSENSEEN_POS 24U
# define    ADC_CCR_VTSENSEEN_MSK BIT(ADC_CCR_VTSENSEEN_POS)
# define    ADC_CCR_VTSENSEEN     ADC_CCR_VTSENSEEN_MSK

# define    ADC_CCR_PRESCALE_POSS 16U
# define    ADC_CCR_PRESCALE_POSE 19U
# define    ADC_CCR_PRESCALE_MSK  BITS(ADC_CCR_PRESCALE_POSS, ADC_CCR_PRESCALE_POSE)
# define    ADC_CCR_PRESCALE      ADC_CCR_PRESCALE_MSK

# define    ADC_CCR_DMAMODE_POSS 14U
# define    ADC_CCR_DMAMODE_POSE 15U
# define    ADC_CCR_DMAMODE_MSK  BITS(ADC_CCR_DMAMODE_POSS, ADC_CCR_DMAMODE_POSE)
# define    ADC_CCR_DMAMODE      ADC_CCR_DMAMODE_MSK

# define    ADC_CCR_DELAYSEL_POSS 8U
# define    ADC_CCR_DELAYSEL_POSE 11U
# define    ADC_CCR_DELAYSEL_MSK  BITS(ADC_CCR_DELAYSEL_POSS, ADC_CCR_DELAYSEL_POSE)
# define    ADC_CCR_DELAYSEL      ADC_CCR_DELAYSEL_MSK

# define    ADC_CCR_DUALMODE_POSS 0U
# define    ADC_CCR_DUALMODE_POSE 4U
# define    ADC_CCR_DUALMODE_MSK  BITS(ADC_CCR_DUALMODE_POSS, ADC_CCR_DUALMODE_POSE)
# define    ADC_CCR_DUALMODE      ADC_CCR_DUALMODE_MSK

/****************** Bit definition for ADC_CDR register ************************/

# define    ADC_CDR_ADC2_RDATA_POSS 16U
# define    ADC_CDR_ADC2_RDATA_POSE 31U
# define    ADC_CDR_ADC2_RDATA_MSK  BITS(ADC_CDR_ADC2_RDATA_POSS, ADC_CDR_ADC2_RDATA_POSE)
# define    ADC_CDR_ADC2_RDATA      ADC_CDR_ADC2_RDATA_MSK

# define    ADC_CDR_ADC1_RDATA_POSS 0U
# define    ADC_CDR_ADC1_RDATA_POSE 15U
# define    ADC_CDR_ADC1_RDATA_MSK  BITS(ADC_CDR_ADC1_RDATA_POSS, ADC_CDR_ADC1_RDATA_POSE)
# define    ADC_CDR_ADC1_RDATA      ADC_CDR_ADC1_RDATA_MSK

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __O  uint32_t IER;                // 0x00
    __O  uint32_t IDR;                // 0x04
    __I  uint32_t IVS;                // 0x08
    __I  uint32_t RIF;                // 0x0c
    __I  uint32_t IFM;                // 0x10
    __O  uint32_t ICR;                // 0x14
    __IO uint32_t CON;                // 0x18
    __IO uint32_t CFG1;               // 0x1C
    __IO uint32_t CFG2;               // 0x20
    __IO uint32_t SMPT1;              // 0x24
    __IO uint32_t SMPT2;              // 0x28
    __IO uint32_t SMPT3;              // 0x2C
    __IO uint32_t SMPT4;              // 0x30
    __IO uint32_t SMPT5;              // 0x34
    __IO uint32_t TR1;                // 0x38
    __IO uint32_t TR2;                // 0x3C
    __IO uint32_t TR3;                // 0x40
    __IO uint32_t SQR1;               // 0x44
    __IO uint32_t SQR2;               // 0x48
    __IO uint32_t SQR3;               // 0x4C
    __IO uint32_t SQR4;               // 0x50
    __I  uint32_t DR;                 // 0x54
    __IO uint32_t RESERVED58;         // 0x58
    __IO uint32_t JSQR;               // 0x5C
    __IO uint32_t OFST1;              // 0x60
    __IO uint32_t OFST2;              // 0x64
    __IO uint32_t OFST3;              // 0x68
    __IO uint32_t OFST4;              // 0x6C
    __I  uint32_t JDR1;               // 0x70
    __I  uint32_t JDR2;               // 0x74
    __I  uint32_t JDR3;               // 0x78
    __I  uint32_t JDR4;               // 0x7C
    __IO uint32_t AWD2CR;             // 0x80
    __IO uint32_t AWD3CR;             // 0x84
    __IO uint32_t GCOMP;              // 0x88
} ADC_TypeDef;

typedef struct
{
    __IO uint32_t RESERVED0;          // 0x00
    __IO uint32_t CCR;                // 0x04
    __I  uint32_t CDR;                // 0x08
} ADC_COMM_TypeDef;

#endif /* __REG_ADC_H__ */
