/**
  *********************************************************************************
  *
  * @file    es32f39xx.h
  * @brief   ES32F39xx Device Head File
  *
  * @version V1.0
  * @date    18 Dec 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          18 Dec 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __ES32F39XX_H__
#define __ES32F39XX_H__

#define	__I	volatile const	/* defines 'read only' permissions */
#define __O	volatile	/* defines 'write only' permissions */
#define __IO	volatile	/* defines 'read / write' permissions */

#define  __CHECK_DEVICE_DEFINES
#define  __NVIC_PRIO_BITS	4U
#define  __CM3_REV		0x0200U
#define  __MPU_PRESENT          0x1
#define __Vendor_SysTickConfig	0U

typedef enum IRQn {
	/* Cortex-M3 processor cxceptions index */
	Reset_IRQn        = -15,
	NMI_IRQn          = -14,
	HardFault_IRQn    = -13,
	MemManage_IRQn    = -12,
	BusFault_IRQn     = -11,
	UsageFault_IRQn   = -10,
	SVCall_IRQn       = -5,
	DebugMonitor_IRQn = -4,
	PendSV_IRQn       = -2,
	SysTick_IRQn      = -1,

	/* es32f39xx specific interrupt index */
	WWDG_IRQn              = 0,
	IWDG_IRQn              = 1,
	LVD_IRQn               = 2,
	RTC_IRQn               = 3,
	CMU_IRQn               = 6,
	ADC0_IRQn              = 7,
	CAN0_TX_IRQn           = 8,
	CAN0_RX0_IRQn          = 9,
	CAN0_RX1_IRQn          = 10,
	CAN0_EXCEPTION_IRQn    = 11,
	AD16C4T0_BRK_IRQn      = 12,
	AD16C4T0_UP_IRQn       = 13,
	AD16C4T0_TRIG_COM_IRQn = 14,
	AD16C4T0_CC_IRQn       = 15,
	AD16C4T1_BRK_IRQn      = 16,
	AD16C4T1_UP_IRQn       = 17,
	AD16C4T1_TRIG_COM_IRQn = 18,
	AD16C4T1_CC_IRQn       = 19,
	GP32C4T0_IRQn          = 20,
	GP32C4T1_IRQn          = 21,
	BS16T0_IRQn            = 22,
	BS16T1_IRQn            = 23,
	GP16C4T0_IRQn          = 24,
	GP16C4T1_IRQn          = 25,
	LPTIM0_IRQn            = 26,
	DAC0_CH0_IRQn          = 27,
	I2C0_EV_IRQn           = 28,
	I2C0_ERR_IRQn          = 29,
	I2C1_EV_IRQn           = 30,
	I2C1_ERR_IRQn          = 31,
	SPI0_I2S0_IRQn         = 32,
	SPI1_I2S1_IRQn         = 33,
	UART0_IRQn             = 34,
	UART1_IRQn             = 35,
	UART2_IRQn             = 36,
	UART3_IRQn             = 37,
	UART4_IRQn             = 38,
	UART5_IRQn             = 39,
	LPUART0_IRQn           = 40,
	CRYPT_IRQn             = 42,
	ACMP0_IRQn             = 43,
	ACMP1_IRQn             = 44,
	SPI2_I2S2_IRQn         = 45,
	LCD_IRQn               = 46,
	EBI_IRQn               = 47,
	TRNG_IRQn              = 48,
	TSENSE_IRQn            = 49,
	EXTI0_IRQn             = 50,
	EXTI1_IRQn             = 51,
	EXTI2_IRQn             = 52,
	EXTI3_IRQn             = 53,
	EXTI4_IRQn             = 54,
	EXTI5_IRQn             = 55,
	EXTI6_IRQn             = 56,
	EXTI7_IRQn             = 57,
	EXTI8_IRQn             = 58,
	EXTI9_IRQn             = 59,
	EXTI10_IRQn            = 60,
	EXTI11_IRQn            = 61,
	EXTI12_IRQn            = 62,
	EXTI13_IRQn            = 63,
	EXTI14_IRQn            = 64,
	EXTI15_IRQn            = 65,
	DMA_IRQn               = 66,
	ADC1_IRQn              = 67,
	DAC0_CH1_IRQn          = 68,
	QSPI_IRQn              = 69,
	USB_INT_IRQn           = 70,
	USB_DMA_IRQn           = 71,
	ACMP2_IRQn             = 72,
} IRQn_Type;


#include <stdint.h>
#include "core_cm3.h"

#if defined (__CC_ARM)
#pragma anon_unions
#endif

/* Peripheral register define */

/****************** Bit definition for SYSCFG_PROT register ************************/

#define	SYSCFG_PROT_KEY_POSS	0U 
#define	SYSCFG_PROT_KEY_POSE	31U 
#define	SYSCFG_PROT_KEY_MSK	BITS(SYSCFG_PROT_KEY_POSS,SYSCFG_PROT_KEY_POSE)

#define	SYSCFG_PROT_PROT_POS	0U 
#define	SYSCFG_PROT_PROT_MSK	BIT(SYSCFG_PROT_PROT_POS)

/****************** Bit definition for SYSCFG_MEMRMP register ************************/

#define	SYSCFG_MEMRMP_BFRMPEN_POS	8U 
#define	SYSCFG_MEMRMP_BFRMPEN_MSK	BIT(SYSCFG_MEMRMP_BFRMPEN_POS)

#define	SYSCFG_MEMRMP_BRRMPEN_POS	0U 
#define	SYSCFG_MEMRMP_BRRMPEN_MSK	BIT(SYSCFG_MEMRMP_BRRMPEN_POS)

/****************** Bit definition for SYSCFG_USBCFG register ************************/

#define	SYSCFG_USBCFG_CLKRDY_POS	26U 
#define	SYSCFG_USBCFG_CLKRDY_MSK	BIT(SYSCFG_USBCFG_CLKRDY_POS)

#define	SYSCFG_USBCFG_CLKRDYBP_POS	25U 
#define	SYSCFG_USBCFG_CLKRDYBP_MSK	BIT(SYSCFG_USBCFG_CLKRDYBP_POS)

#define	SYSCFG_USBCFG_CKSEL_POS	24U 
#define	SYSCFG_USBCFG_CKSEL_MSK	BIT(SYSCFG_USBCFG_CKSEL_POS)

#define	SYSCFG_USBCFG_ITRM_POSS	22U 
#define	SYSCFG_USBCFG_ITRM_POSE	23U 
#define	SYSCFG_USBCFG_ITRM_MSK	BITS(SYSCFG_USBCFG_ITRM_POSS,SYSCFG_USBCFG_ITRM_POSE)

#define	SYSCFG_USBCFG_CKDIVN_POSS	16U 
#define	SYSCFG_USBCFG_CKDIVN_POSE	21U 
#define	SYSCFG_USBCFG_CKDIVN_MSK	BITS(SYSCFG_USBCFG_CKDIVN_POSS,SYSCFG_USBCFG_CKDIVN_POSE)

#define	SYSCFG_USBCFG_CKDIVM_POSS	8U 
#define	SYSCFG_USBCFG_CKDIVM_POSE	11U 
#define	SYSCFG_USBCFG_CKDIVM_MSK	BITS(SYSCFG_USBCFG_CKDIVM_POSS,SYSCFG_USBCFG_CKDIVM_POSE)

#define	SYSCFG_USBCFG_HSDRV_POSS	2U 
#define	SYSCFG_USBCFG_HSDRV_POSE	3U 
#define	SYSCFG_USBCFG_HSDRV_MSK	BITS(SYSCFG_USBCFG_HSDRV_POSS,SYSCFG_USBCFG_HSDRV_POSE)

#define	SYSCFG_USBCFG_TXHBSE_POS	1U 
#define	SYSCFG_USBCFG_TXHBSE_MSK	BIT(SYSCFG_USBCFG_TXHBSE_POS)

#define	SYSCFG_USBCFG_TXLBSE_POS	0U 
#define	SYSCFG_USBCFG_TXLBSE_MSK	BIT(SYSCFG_USBCFG_TXLBSE_POS)

/****************** Bit definition for SYSCFG_TBKCFG register ************************/

#define	SYSCFG_TBKCFG_CLUBKE_POS	2U 
#define	SYSCFG_TBKCFG_CLUBKE_MSK	BIT(SYSCFG_TBKCFG_CLUBKE_POS)

#define	SYSCFG_TBKCFG_LVDBKE_POS	1U 
#define	SYSCFG_TBKCFG_LVDBKE_MSK	BIT(SYSCFG_TBKCFG_LVDBKE_POS)

#define	SYSCFG_TBKCFG_CSSBKE_POS	0U 
#define	SYSCFG_TBKCFG_CSSBKE_MSK	BIT(SYSCFG_TBKCFG_CSSBKE_POS)

typedef struct
{
	__IO uint32_t PROT;
	__IO uint32_t MEMRMP;
	uint32_t rsv0;
	__IO uint32_t USBCFG;
	__IO uint32_t TBKCFG;
	uint32_t rsv1[59];
	__IO uint32_t TESTKEY;
	uint32_t rsv2[7];
	__IO uint32_t USBTEST;
} SYSCFG_TypeDef;

/****************** Bit definition for MSC_FLASHKEY register ************************/

#define	MSC_FLASHKEY_STATUS_POSS	0U 
#define	MSC_FLASHKEY_STATUS_POSE	1U 
#define	MSC_FLASHKEY_STATUS_MSK	BITS(MSC_FLASHKEY_STATUS_POSS,MSC_FLASHKEY_STATUS_POSE)

/****************** Bit definition for MSC_INFOKEY register ************************/

#define	MSC_INFOKEY_STATUS_POSS	0U 
#define	MSC_INFOKEY_STATUS_POSE	1U 
#define	MSC_INFOKEY_STATUS_MSK	BITS(MSC_INFOKEY_STATUS_POSS,MSC_INFOKEY_STATUS_POSE)

/****************** Bit definition for MSC_FLASHADDR register ************************/

#define	MSC_FLASHADDR_IFREN_POS	19U 
#define	MSC_FLASHADDR_IFREN_MSK	BIT(MSC_FLASHADDR_IFREN_POS)

#define	MSC_FLASHADDR_ADDR_POSS	0U 
#define	MSC_FLASHADDR_ADDR_POSE	18U 
#define	MSC_FLASHADDR_ADDR_MSK	BITS(MSC_FLASHADDR_ADDR_POSS,MSC_FLASHADDR_ADDR_POSE)

/****************** Bit definition for MSC_FLASHFIFO register ************************/

#define	MSC_FLASHFIFO_FIFO_POSS	0U 
#define	MSC_FLASHFIFO_FIFO_POSE	31U 
#define	MSC_FLASHFIFO_FIFO_MSK	BITS(MSC_FLASHFIFO_FIFO_POSS,MSC_FLASHFIFO_FIFO_POSE)

/****************** Bit definition for MSC_FLASHDL register ************************/

#define	MSC_FLASHDL_DATAL_POSS	0U 
#define	MSC_FLASHDL_DATAL_POSE	31U 
#define	MSC_FLASHDL_DATAL_MSK	BITS(MSC_FLASHDL_DATAL_POSS,MSC_FLASHDL_DATAL_POSE)

/****************** Bit definition for MSC_FLASHDH register ************************/

#define	MSC_FLASHDH_DATAH_POSS	0U 
#define	MSC_FLASHDH_DATAH_POSE	31U 
#define	MSC_FLASHDH_DATAH_MSK	BITS(MSC_FLASHDH_DATAH_POSS,MSC_FLASHDH_DATAH_POSE)

/****************** Bit definition for MSC_FLASHCMD register ************************/

#define	MSC_FLASHCMD_CMD_POSS	0U 
#define	MSC_FLASHCMD_CMD_POSE	31U 
#define	MSC_FLASHCMD_CMD_MSK	BITS(MSC_FLASHCMD_CMD_POSS,MSC_FLASHCMD_CMD_POSE)

/****************** Bit definition for MSC_FLASHCR register ************************/

#define	MSC_FLASHCR_FIFOEN_POS	5U 
#define	MSC_FLASHCR_FIFOEN_MSK	BIT(MSC_FLASHCR_FIFOEN_POS)

#define	MSC_FLASHCR_FLASHREQ_POS	4U 
#define	MSC_FLASHCR_FLASHREQ_MSK	BIT(MSC_FLASHCR_FLASHREQ_POS)

#define	MSC_FLASHCR_IAPRST_POS	1U 
#define	MSC_FLASHCR_IAPRST_MSK	BIT(MSC_FLASHCR_IAPRST_POS)

#define	MSC_FLASHCR_IAPEN_POS	0U 
#define	MSC_FLASHCR_IAPEN_MSK	BIT(MSC_FLASHCR_IAPEN_POS)

/****************** Bit definition for MSC_FLASHSR register ************************/

#define	MSC_FLASHSR_TIMEOUT_POS	7U 
#define	MSC_FLASHSR_TIMEOUT_MSK	BIT(MSC_FLASHSR_TIMEOUT_POS)

#define	MSC_FLASHSR_PROG_POS	6U 
#define	MSC_FLASHSR_PROG_MSK	BIT(MSC_FLASHSR_PROG_POS)

#define	MSC_FLASHSR_SERA_POS	5U 
#define	MSC_FLASHSR_SERA_MSK	BIT(MSC_FLASHSR_SERA_POS)

#define	MSC_FLASHSR_MASE_POS	4U 
#define	MSC_FLASHSR_MASE_MSK	BIT(MSC_FLASHSR_MASE_POS)

#define	MSC_FLASHSR_ADDR_OV_POS	3U 
#define	MSC_FLASHSR_ADDR_OV_MSK	BIT(MSC_FLASHSR_ADDR_OV_POS)

#define	MSC_FLASHSR_WRP_FLAG_POS	2U 
#define	MSC_FLASHSR_WRP_FLAG_MSK	BIT(MSC_FLASHSR_WRP_FLAG_POS)

#define	MSC_FLASHSR_BUSY_POS	1U 
#define	MSC_FLASHSR_BUSY_MSK	BIT(MSC_FLASHSR_BUSY_POS)

#define	MSC_FLASHSR_FLASHACK_POS	0U 
#define	MSC_FLASHSR_FLASHACK_MSK	BIT(MSC_FLASHSR_FLASHACK_POS)

/****************** Bit definition for MSC_FLASHPL register ************************/

#define	MSC_FLASHPL_PROG_LEN_POSS	0U 
#define	MSC_FLASHPL_PROG_LEN_POSE	15U 
#define	MSC_FLASHPL_PROG_LEN_MSK	BITS(MSC_FLASHPL_PROG_LEN_POSS,MSC_FLASHPL_PROG_LEN_POSE)

/****************** Bit definition for MSC_MEMWAIT register ************************/

#define	MSC_MEMWAIT_SRAM_W_POSS	8U 
#define	MSC_MEMWAIT_SRAM_W_POSE	9U 
#define	MSC_MEMWAIT_SRAM_W_MSK	BITS(MSC_MEMWAIT_SRAM_W_POSS,MSC_MEMWAIT_SRAM_W_POSE)

#define	MSC_MEMWAIT_FLASH_W_POSS	0U 
#define	MSC_MEMWAIT_FLASH_W_POSE	3U 
#define	MSC_MEMWAIT_FLASH_W_MSK	BITS(MSC_MEMWAIT_FLASH_W_POSS,MSC_MEMWAIT_FLASH_W_POSE)

typedef struct
{
	__IO uint32_t FLASHKEY;
	__IO uint32_t INFOKEY;
	__IO uint32_t FLASHADDR;
	__O uint32_t FLASHFIFO;
	__IO uint32_t FLASHDL;
	__IO uint32_t FLASHDH;
	__O uint32_t FLASHCMD;
	__IO uint32_t FLASHCR;
	__I uint32_t FLASHSR;
	__IO uint32_t FLASHPL;
	__IO uint32_t MEMWAIT;
} MSC_TypeDef;

/****************** Bit definition for BKPC_PROT register ************************/

#define	BKPC_PROT_KEY_POSS	1U 
#define	BKPC_PROT_KEY_POSE	31U 
#define	BKPC_PROT_KEY_MSK	BITS(BKPC_PROT_KEY_POSS,BKPC_PROT_KEY_POSE)

#define	BKPC_PROT_PROT_POS	0U 
#define	BKPC_PROT_PROT_MSK	BIT(BKPC_PROT_PROT_POS)

/****************** Bit definition for BKPC_CR register ************************/

#define	BKPC_CR_WKPOL_POS	12U 
#define	BKPC_CR_WKPOL_MSK	BIT(BKPC_CR_WKPOL_POS)

#define	BKPC_CR_WKPS_POSS	9U 
#define	BKPC_CR_WKPS_POSE	11U 
#define	BKPC_CR_WKPS_MSK	BITS(BKPC_CR_WKPS_POSS,BKPC_CR_WKPS_POSE)

#define	BKPC_CR_WKPEN_POS	8U 
#define	BKPC_CR_WKPEN_MSK	BIT(BKPC_CR_WKPEN_POS)

#define	BKPC_CR_MRST_WKPEN_POS	7U 
#define	BKPC_CR_MRST_WKPEN_MSK	BIT(BKPC_CR_MRST_WKPEN_POS)

#define	BKPC_CR_LRCEN_POS	2U 
#define	BKPC_CR_LRCEN_MSK	BIT(BKPC_CR_LRCEN_POS)

#define	BKPC_CR_LOSMEN_POS	1U 
#define	BKPC_CR_LOSMEN_MSK	BIT(BKPC_CR_LOSMEN_POS)

#define	BKPC_CR_LOSCEN_POS	0U 
#define	BKPC_CR_LOSCEN_MSK	BIT(BKPC_CR_LOSCEN_POS)

/****************** Bit definition for BKPC_PCCR register ************************/

#define	BKPC_PCCR_CLKEN_POS	16U 
#define	BKPC_PCCR_CLKEN_MSK	BIT(BKPC_PCCR_CLKEN_POS)

#define	BKPC_PCCR_TSENSECS_POSS	4U 
#define	BKPC_PCCR_TSENSECS_POSE	5U 
#define	BKPC_PCCR_TSENSECS_MSK	BITS(BKPC_PCCR_TSENSECS_POSS,BKPC_PCCR_TSENSECS_POSE)

#define	BKPC_PCCR_RTCCS_POSS	0U 
#define	BKPC_PCCR_RTCCS_POSE	1U 
#define	BKPC_PCCR_RTCCS_MSK	BITS(BKPC_PCCR_RTCCS_POSS,BKPC_PCCR_RTCCS_POSE)

/****************** Bit definition for BKPC_PDCR register ************************/

#define	BKPC_PDCR_ISOLATE_POS	0U 
#define	BKPC_PDCR_ISOLATE_MSK	BIT(BKPC_PDCR_ISOLATE_POS)

#define	BKPC_PDCR_PWRDOWN_POS	0U 
#define	BKPC_PDCR_PWRDOWN_MSK	BIT(BKPC_PDCR_PWRDOWN_POS)

typedef struct
{
	__IO uint32_t PROT;
	__IO uint32_t CR;
	__IO uint32_t PCCR;
	__IO uint32_t PCR;
} BKPC_TypeDef;

/****************** Bit definition for PMU_CR0 register ************************/

#define	PMU_CR0_MTSTOP_POS	21U 
#define	PMU_CR0_MTSTOP_MSK	BIT(PMU_CR0_MTSTOP_POS)

#define	PMU_CR0_LPSTOP_POS	20U 
#define	PMU_CR0_LPSTOP_MSK	BIT(PMU_CR0_LPSTOP_POS)

#define	PMU_CR0_LPRUN_POS	19U 
#define	PMU_CR0_LPRUN_MSK	BIT(PMU_CR0_LPRUN_POS)

#define	PMU_CR0_LPVS_POSS	16U 
#define	PMU_CR0_LPVS_POSE	17U 
#define	PMU_CR0_LPVS_MSK	BITS(PMU_CR0_LPVS_POSS,PMU_CR0_LPVS_POSE)

#define	PMU_CR0_SFPD_POS	15U 
#define	PMU_CR0_SFPD_MSK	BIT(PMU_CR0_SFPD_POS)

#define	PMU_CR0_CSTANDBYF_POS	3U 
#define	PMU_CR0_CSTANDBYF_MSK	BIT(PMU_CR0_CSTANDBYF_POS)

#define	PMU_CR0_CWUF_POS	2U 
#define	PMU_CR0_CWUF_MSK	BIT(PMU_CR0_CWUF_POS)

#define	PMU_CR0_LPM_POSS	0U 
#define	PMU_CR0_LPM_POSE	1U 
#define	PMU_CR0_LPM_MSK	BITS(PMU_CR0_LPM_POSS,PMU_CR0_LPM_POSE)

/****************** Bit definition for PMU_CR1 register ************************/

#define	PMU_CR1_LDO18RDY_POS	15U 
#define	PMU_CR1_LDO18RDY_MSK	BIT(PMU_CR1_LDO18RDY_POS)

#define	PMU_CR1_LDO18PRM_POS	2U 
#define	PMU_CR1_LDO18PRM_MSK	BIT(PMU_CR1_LDO18PRM_POS)

#define	PMU_CR1_LDO18MOD_POSS	0U 
#define	PMU_CR1_LDO18MOD_POSE	1U 
#define	PMU_CR1_LDO18MOD_MSK	BITS(PMU_CR1_LDO18MOD_POSS,PMU_CR1_LDO18MOD_POSE)

/****************** Bit definition for PMU_SR register ************************/

#define	PMU_SR_RSTAT_POS	3U 
#define	PMU_SR_RSTAT_MSK	BIT(PMU_SR_RSTAT_POS)

#define	PMU_SR_USBRDY_POS	2U 
#define	PMU_SR_USBRDY_MSK	BIT(PMU_SR_USBRDY_POS)

#define	PMU_SR_STANDBYF_POS	1U 
#define	PMU_SR_STANDBYF_MSK	BIT(PMU_SR_STANDBYF_POS)

#define	PMU_SR_WUF_POS	0U 
#define	PMU_SR_WUF_MSK	BIT(PMU_SR_WUF_POS)

/****************** Bit definition for PMU_LVDCR register ************************/

#define	PMU_LVDCR_LVDO_POS	15U 
#define	PMU_LVDCR_LVDO_MSK	BIT(PMU_LVDCR_LVDO_POS)

#define	PMU_LVDCR_LVDFLT_POS	11U 
#define	PMU_LVDCR_LVDFLT_MSK	BIT(PMU_LVDCR_LVDFLT_POS)

#define	PMU_LVDCR_LVIFS_POSS	8U 
#define	PMU_LVDCR_LVIFS_POSE	10U 
#define	PMU_LVDCR_LVIFS_MSK	BITS(PMU_LVDCR_LVIFS_POSS,PMU_LVDCR_LVIFS_POSE)

#define	PMU_LVDCR_LVDS_POSS	4U 
#define	PMU_LVDCR_LVDS_POSE	7U 
#define	PMU_LVDCR_LVDS_MSK	BITS(PMU_LVDCR_LVDS_POSS,PMU_LVDCR_LVDS_POSE)

#define	PMU_LVDCR_LVDCIF_POS	3U 
#define	PMU_LVDCR_LVDCIF_MSK	BIT(PMU_LVDCR_LVDCIF_POS)

#define	PMU_LVDCR_LVDIF_POS	2U 
#define	PMU_LVDCR_LVDIF_MSK	BIT(PMU_LVDCR_LVDIF_POS)

#define	PMU_LVDCR_LVDIE_POS	1U 
#define	PMU_LVDCR_LVDIE_MSK	BIT(PMU_LVDCR_LVDIE_POS)

#define	PMU_LVDCR_LVDEN_POS	0U 
#define	PMU_LVDCR_LVDEN_MSK	BIT(PMU_LVDCR_LVDEN_POS)

/****************** Bit definition for PMU_PWRCR register ************************/

#define	PMU_PWRCR_ROM_POS	12U 
#define	PMU_PWRCR_ROM_MSK	BIT(PMU_PWRCR_ROM_POS)

#define	PMU_PWRCR_USB_POS	11U 
#define	PMU_PWRCR_USB_MSK	BIT(PMU_PWRCR_USB_POS)

#define	PMU_PWRCR_QSPI_POS	10U 
#define	PMU_PWRCR_QSPI_MSK	BIT(PMU_PWRCR_QSPI_POS)

#define	PMU_PWRCR_BXCAN_POS	8U 
#define	PMU_PWRCR_BXCAN_MSK	BIT(PMU_PWRCR_BXCAN_POS)

#define	PMU_PWRCR_SRAM_POSS	0U 
#define	PMU_PWRCR_SRAM_POSE	5U 
#define	PMU_PWRCR_SRAM_MSK	BITS(PMU_PWRCR_SRAM_POSS,PMU_PWRCR_SRAM_POSE)

/****************** Bit definition for PMU_VREFCR register ************************/

#define	PMU_VREFCR_VREFEN_POS	0U 
#define	PMU_VREFCR_VREFEN_MSK	BIT(PMU_VREFCR_VREFEN_POS)

typedef struct
{
	__IO uint32_t CR0;
	__IO uint32_t CR1;
	__I uint32_t SR;
	__IO uint32_t LVDCR;
	__IO uint32_t PWRCR;
	uint32_t RESERVED0[3] ;
	__IO uint32_t VREFCR;
} PMU_TypeDef;

/****************** Bit definition for RMU_CR register ************************/

#define	RMU_CR_BORVS_POSS	4U 
#define	RMU_CR_BORVS_POSE	7U 
#define	RMU_CR_BORVS_MSK	BITS(RMU_CR_BORVS_POSS,RMU_CR_BORVS_POSE)

#define	RMU_CR_BORFLT_POSS	1U 
#define	RMU_CR_BORFLT_POSE	3U 
#define	RMU_CR_BORFLT_MSK	BITS(RMU_CR_BORFLT_POSS,RMU_CR_BORFLT_POSE)

#define	RMU_CR_BOREN_POS	0U 
#define	RMU_CR_BOREN_MSK	BIT(RMU_CR_BOREN_POS)

/****************** Bit definition for RMU_RSTSR register ************************/

#define	RMU_RSTSR_CFGERR_POS	16U 
#define	RMU_RSTSR_CFGERR_MSK	BIT(RMU_RSTSR_CFGERR_POS)

#define	RMU_RSTSR_CFG_POS	10U 
#define	RMU_RSTSR_CFG_MSK	BIT(RMU_RSTSR_CFG_POS)

#define	RMU_RSTSR_CPU_POS	9U 
#define	RMU_RSTSR_CPU_MSK	BIT(RMU_RSTSR_CPU_POS)

#define	RMU_RSTSR_MCU_POS	8U 
#define	RMU_RSTSR_MCU_MSK	BIT(RMU_RSTSR_MCU_POS)

#define	RMU_RSTSR_CHIP_POS	7U 
#define	RMU_RSTSR_CHIP_MSK	BIT(RMU_RSTSR_CHIP_POS)

#define	RMU_RSTSR_LOCKUP_POS	6U 
#define	RMU_RSTSR_LOCKUP_MSK	BIT(RMU_RSTSR_LOCKUP_POS)

#define	RMU_RSTSR_WWDT_POS	5U 
#define	RMU_RSTSR_WWDT_MSK	BIT(RMU_RSTSR_WWDT_POS)

#define	RMU_RSTSR_IWDT_POS	4U 
#define	RMU_RSTSR_IWDT_MSK	BIT(RMU_RSTSR_IWDT_POS)

#define	RMU_RSTSR_NMRST_POS	3U 
#define	RMU_RSTSR_NMRST_MSK	BIT(RMU_RSTSR_NMRST_POS)

#define	RMU_RSTSR_BOR_POS	2U 
#define	RMU_RSTSR_BOR_MSK	BIT(RMU_RSTSR_BOR_POS)

#define	RMU_RSTSR_WAKEUP_POS	1U 
#define	RMU_RSTSR_WAKEUP_MSK	BIT(RMU_RSTSR_WAKEUP_POS)

#define	RMU_RSTSR_POR_POS	0U 
#define	RMU_RSTSR_POR_MSK	BIT(RMU_RSTSR_POR_POS)

/****************** Bit definition for RMU_CRSTSR register ************************/

#define	RMU_CRSTSR_CFG_POS	10U 
#define	RMU_CRSTSR_CFG_MSK	BIT(RMU_CRSTSR_CFG_POS)

#define	RMU_CRSTSR_CPU_POS	9U 
#define	RMU_CRSTSR_CPU_MSK	BIT(RMU_CRSTSR_CPU_POS)

#define	RMU_CRSTSR_MCU_POS	8U 
#define	RMU_CRSTSR_MCU_MSK	BIT(RMU_CRSTSR_MCU_POS)

#define	RMU_CRSTSR_CHIP_POS	7U 
#define	RMU_CRSTSR_CHIP_MSK	BIT(RMU_CRSTSR_CHIP_POS)

#define	RMU_CRSTSR_LOCKUP_POS	6U 
#define	RMU_CRSTSR_LOCKUP_MSK	BIT(RMU_CRSTSR_LOCKUP_POS)

#define	RMU_CRSTSR_WWDT_POS	5U 
#define	RMU_CRSTSR_WWDT_MSK	BIT(RMU_CRSTSR_WWDT_POS)

#define	RMU_CRSTSR_IWDT_POS	4U 
#define	RMU_CRSTSR_IWDT_MSK	BIT(RMU_CRSTSR_IWDT_POS)

#define	RMU_CRSTSR_NMRST_POS	3U 
#define	RMU_CRSTSR_NMRST_MSK	BIT(RMU_CRSTSR_NMRST_POS)

#define	RMU_CRSTSR_BOR_POS	2U 
#define	RMU_CRSTSR_BOR_MSK	BIT(RMU_CRSTSR_BOR_POS)

#define	RMU_CRSTSR_WAKEUP_POS	1U 
#define	RMU_CRSTSR_WAKEUP_MSK	BIT(RMU_CRSTSR_WAKEUP_POS)

#define	RMU_CRSTSR_POR_POS	0U 
#define	RMU_CRSTSR_POR_MSK	BIT(RMU_CRSTSR_POR_POS)

/****************** Bit definition for RMU_AHB1RSTR register ************************/

#define	RMU_AHB1RSTR_ECCRST_POS	11U 
#define	RMU_AHB1RSTR_ECCRST_MSK	BIT(RMU_AHB1RSTR_ECCRST_POS)

#define	RMU_AHB1RSTR_USBRST_POS	10U 
#define	RMU_AHB1RSTR_USBRST_MSK	BIT(RMU_AHB1RSTR_USBRST_POS)

#define	RMU_AHB1RSTR_TRNGRST_POS	4U 
#define	RMU_AHB1RSTR_TRNGRST_MSK	BIT(RMU_AHB1RSTR_TRNGRST_POS)

#define	RMU_AHB1RSTR_PISRST_POS	5U 
#define	RMU_AHB1RSTR_PISRST_MSK	BIT(RMU_AHB1RSTR_PISRST_POS)

#define	RMU_AHB1RSTR_TRNGRST_POS	4U 
#define	RMU_AHB1RSTR_TRNGRST_MSK	BIT(RMU_AHB1RSTR_TRNGRST_POS)

#define	RMU_AHB1RSTR_CRYPTRST_POS	3U 
#define	RMU_AHB1RSTR_CRYPTRST_MSK	BIT(RMU_AHB1RSTR_CRYPTRST_POS)

#define	RMU_AHB1RSTR_CALCRST_POS	2U 
#define	RMU_AHB1RSTR_CALCRST_MSK	BIT(RMU_AHB1RSTR_CALCRST_POS)

#define	RMU_AHB1RSTR_CRCRST_POS	1U 
#define	RMU_AHB1RSTR_CRCRST_MSK	BIT(RMU_AHB1RSTR_CRCRST_POS)

#define	RMU_AHB1RSTR_GPIORST_POS	0U 
#define	RMU_AHB1RSTR_GPIORST_MSK	BIT(RMU_AHB1RSTR_GPIORST_POS)

/****************** Bit definition for RMU_AHB2RSTR register ************************/

#define	RMU_AHB2RSTR_EBIRST_POS	8U 
#define	RMU_AHB2RSTR_EBIRST_MSK	BIT(RMU_AHB2RSTR_EBIRST_POS)

#define	RMU_AHB2RSTR_CPURST_POS	1U 
#define	RMU_AHB2RSTR_CPURST_MSK	BIT(RMU_AHB2RSTR_CPURST_POS)

#define	RMU_AHB2RSTR_CHIPRST_POS	0U 
#define	RMU_AHB2RSTR_CHIPRST_MSK	BIT(RMU_AHB2RSTR_CHIPRST_POS)

/****************** Bit definition for RMU_APB1RSTR register ************************/

#define	RMU_APB1RSTR_QSPIRST_POS	25U 
#define	RMU_APB1RSTR_QSPIRST_MSK	BIT(RMU_APB1RSTR_QSPIRST_POS)

#define	RMU_APB1RSTR_CAN0RST_POS	24U 
#define	RMU_APB1RSTR_CAN0RST_MSK	BIT(RMU_APB1RSTR_CAN0RST_POS)

#define	RMU_APB1RSTR_I2C1RST_POS	21U 
#define	RMU_APB1RSTR_I2C1RST_MSK	BIT(RMU_APB1RSTR_I2C1RST_POS)

#define	RMU_APB1RSTR_I2C0RST_POS	20U 
#define	RMU_APB1RSTR_I2C0RST_MSK	BIT(RMU_APB1RSTR_I2C0RST_POS)

#define	RMU_APB1RSTR_SPI2RST_POS	18U 
#define	RMU_APB1RSTR_SPI2RST_MSK	BIT(RMU_APB1RSTR_SPI2RST_POS)

#define	RMU_APB1RSTR_SPI1RST_POS	17U 
#define	RMU_APB1RSTR_SPI1RST_MSK	BIT(RMU_APB1RSTR_SPI1RST_POS)

#define	RMU_APB1RSTR_SPI0RST_POS	16U 
#define	RMU_APB1RSTR_SPI0RST_MSK	BIT(RMU_APB1RSTR_SPI0RST_POS)

#define	RMU_APB1RSTR_UART5RST_POS	13U 
#define	RMU_APB1RSTR_UART5RST_MSK	BIT(RMU_APB1RSTR_UART5RST_POS)

#define	RMU_APB1RSTR_UART4RST_POS	12U 
#define	RMU_APB1RSTR_UART4RST_MSK	BIT(RMU_APB1RSTR_UART4RST_POS)

#define	RMU_APB1RSTR_UART3RST_POS	11U 
#define	RMU_APB1RSTR_UART3RST_MSK	BIT(RMU_APB1RSTR_UART3RST_POS)

#define	RMU_APB1RSTR_UART2RST_POS	10U 
#define	RMU_APB1RSTR_UART2RST_MSK	BIT(RMU_APB1RSTR_UART2RST_POS)

#define	RMU_APB1RSTR_UART1RST_POS	9U 
#define	RMU_APB1RSTR_UART1RST_MSK	BIT(RMU_APB1RSTR_UART1RST_POS)

#define	RMU_APB1RSTR_UART0RST_POS	8U 
#define	RMU_APB1RSTR_UART0RST_MSK	BIT(RMU_APB1RSTR_UART0RST_POS)

#define	RMU_APB1RSTR_TIM7RST_POS	7U 
#define	RMU_APB1RSTR_TIM7RST_MSK	BIT(RMU_APB1RSTR_TIM7RST_POS)

#define	RMU_APB1RSTR_TIM6RST_POS	6U 
#define	RMU_APB1RSTR_TIM6RST_MSK	BIT(RMU_APB1RSTR_TIM6RST_POS)

#define	RMU_APB1RSTR_TIM5RST_POS	5U 
#define	RMU_APB1RSTR_TIM5RST_MSK	BIT(RMU_APB1RSTR_TIM5RST_POS)

#define	RMU_APB1RSTR_TIM4RST_POS	4U 
#define	RMU_APB1RSTR_TIM4RST_MSK	BIT(RMU_APB1RSTR_TIM4RST_POS)

#define	RMU_APB1RSTR_TIM3RST_POS	3U 
#define	RMU_APB1RSTR_TIM3RST_MSK	BIT(RMU_APB1RSTR_TIM3RST_POS)

#define	RMU_APB1RSTR_TIM2RST_POS	2U 
#define	RMU_APB1RSTR_TIM2RST_MSK	BIT(RMU_APB1RSTR_TIM2RST_POS)

#define	RMU_APB1RSTR_TIM1RST_POS	1U 
#define	RMU_APB1RSTR_TIM1RST_MSK	BIT(RMU_APB1RSTR_TIM1RST_POS)

#define	RMU_APB1RSTR_TIM0RST_POS	0U 
#define	RMU_APB1RSTR_TIM0RST_MSK	BIT(RMU_APB1RSTR_TIM0RST_POS)

/****************** Bit definition for RMU_APB2RSTR register ************************/

#define	RMU_APB2RSTR_BKPRAMRST_POS	18U 
#define	RMU_APB2RSTR_BKPRAMRST_MSK	BIT(RMU_APB2RSTR_BKPRAMRST_POS)

#define	RMU_APB2RSTR_BKPCRST_POS	17U 
#define	RMU_APB2RSTR_BKPCRST_MSK	BIT(RMU_APB2RSTR_BKPCRST_POS)

#define	RMU_APB2RSTR_TSENSERST_POS	16U 
#define	RMU_APB2RSTR_TSENSERST_MSK	BIT(RMU_APB2RSTR_TSENSERST_POS)

#define	RMU_APB2RSTR_RTCRST_POS	15U 
#define	RMU_APB2RSTR_RTCRST_MSK	BIT(RMU_APB2RSTR_RTCRST_POS)

#define	RMU_APB2RSTR_IWDTRST_POS	14U 
#define	RMU_APB2RSTR_IWDTRST_MSK	BIT(RMU_APB2RSTR_IWDTRST_POS)

#define	RMU_APB2RSTR_LCDRST_POS	13U 
#define	RMU_APB2RSTR_LCDRST_MSK	BIT(RMU_APB2RSTR_LCDRST_POS)

#define	RMU_APB2RSTR_WWDTRST_POS	12U 
#define	RMU_APB2RSTR_WWDTRST_MSK	BIT(RMU_APB2RSTR_WWDTRST_POS)

#define	RMU_APB2RSTR_ACMP2RST_POS	11U 
#define	RMU_APB2RSTR_ACMP2RST_MSK	BIT(RMU_APB2RSTR_DACRST_POS)

#define	RMU_APB2RSTR_DACRST_POS	9U 
#define	RMU_APB2RSTR_DACRST_MSK	BIT(RMU_APB2RSTR_DACRST_POS)

#define	RMU_APB2RSTR_OPAMPRST_POS	8U 
#define	RMU_APB2RSTR_OPAMPRST_MSK	BIT(RMU_APB2RSTR_OPAMPRST_POS)

#define	RMU_APB2RSTR_ACMP1RST_POS	7U 
#define	RMU_APB2RSTR_ACMP1RST_MSK	BIT(RMU_APB2RSTR_ACMP1RST_POS)

#define	RMU_APB2RSTR_ACMP0RST_POS	6U 
#define	RMU_APB2RSTR_ACMP0RST_MSK	BIT(RMU_APB2RSTR_ACMP0RST_POS)

#define	RMU_APB2RSTR_ADC1RST_POS	5U 
#define	RMU_APB2RSTR_ADC1RST_MSK	BIT(RMU_APB2RSTR_ADC1RST_POS)

#define	RMU_APB2RSTR_ADC0RST_POS	4U 
#define	RMU_APB2RSTR_ADC0RST_MSK	BIT(RMU_APB2RSTR_ADC0RST_POS)

#define	RMU_APB2RSTR_LPUART0RST_POS	2U 
#define	RMU_APB2RSTR_LPUART0RST_MSK	BIT(RMU_APB2RSTR_LPUART0RST_POS)

#define	RMU_APB2RSTR_LPTIM0RST_POS	0U 
#define	RMU_APB2RSTR_LPTIM0RST_MSK	BIT(RMU_APB2RSTR_LPTIM0RST_POS)

typedef struct
{
	__IO uint32_t CR;
	uint32_t RESERVED0[3] ;
	__I uint32_t RSTSR;
	__O uint32_t CRSTSR;
	uint32_t RESERVED1[2] ;
	__O uint32_t AHB1RSTR;
	__O uint32_t AHB2RSTR;
	uint32_t RESERVED2[2] ;
	__O uint32_t APB1RSTR;
	__O uint32_t APB2RSTR;
} RMU_TypeDef;

/****************** Bit definition for CMU_CSR register ************************/

#define	CMU_CSR_CFT_RDYN_POS	25U 
#define	CMU_CSR_CFT_RDYN_MSK	BIT(CMU_CSR_CFT_RDYN_POS)

#define	CMU_CSR_CFT_STU_POS	24U 
#define	CMU_CSR_CFT_STU_MSK	BIT(CMU_CSR_CFT_STU_POS)

#define	CMU_CSR_CFT_CMD_POSS	16U 
#define	CMU_CSR_CFT_CMD_POSE	23U 
#define	CMU_CSR_CFT_CMD_MSK	BITS(CMU_CSR_CFT_CMD_POSS,CMU_CSR_CFT_CMD_POSE)

#define	CMU_CSR_SYS_RDYN_POS	12U 
#define	CMU_CSR_SYS_RDYN_MSK	BIT(CMU_CSR_SYS_RDYN_POS)

#define	CMU_CSR_SYS_STU_POSS	8U 
#define	CMU_CSR_SYS_STU_POSE	10U 
#define	CMU_CSR_SYS_STU_MSK	BITS(CMU_CSR_SYS_STU_POSS,CMU_CSR_SYS_STU_POSE)

#define	CMU_CSR_SYS_CMD_POSS	0U 
#define	CMU_CSR_SYS_CMD_POSE	2U 
#define	CMU_CSR_SYS_CMD_MSK	BITS(CMU_CSR_SYS_CMD_POSS,CMU_CSR_SYS_CMD_POSE)

/****************** Bit definition for CMU_CFGR register ************************/

#define	CMU_CFGR_HRCFCS_POS	26U 
#define	CMU_CFGR_HRCFCS_MSK	BIT(CMU_CFGR_HRCFCS_POS)

#define	CMU_CFGR_HRCFST_POS	25U 
#define	CMU_CFGR_HRCFST_MSK	BIT(CMU_CFGR_HRCFST_POS)

#define	CMU_CFGR_HRCFSW_POS	24U 
#define	CMU_CFGR_HRCFSW_MSK	BIT(CMU_CFGR_HRCFSW_POS)

#define	CMU_CFGR_PCLK2DIV_POSS	20U 
#define	CMU_CFGR_PCLK2DIV_POSE	23U 
#define	CMU_CFGR_PCLK2DIV_MSK	BITS(CMU_CFGR_PCLK2DIV_POSS,CMU_CFGR_PCLK2DIV_POSE)

#define	CMU_CFGR_PCLK1DIV_POSS	16U 
#define	CMU_CFGR_PCLK1DIV_POSE	19U 
#define	CMU_CFGR_PCLK1DIV_MSK	BITS(CMU_CFGR_PCLK1DIV_POSS,CMU_CFGR_PCLK1DIV_POSE)

#define	CMU_CFGR_SYSDIV_POSS	12U 
#define	CMU_CFGR_SYSDIV_POSE	15U 
#define	CMU_CFGR_SYSDIV_MSK	BITS(CMU_CFGR_SYSDIV_POSS,CMU_CFGR_SYSDIV_POSE)

#define	CMU_CFGR_HCLK2DIV_POSS	4U 
#define	CMU_CFGR_HCLK2DIV_POSE	7U 
#define	CMU_CFGR_HCLK2DIV_MSK	BITS(CMU_CFGR_HCLK2DIV_POSS,CMU_CFGR_HCLK2DIV_POSE)

#define	CMU_CFGR_HCLK1DIV_POSS	0U 
#define	CMU_CFGR_HCLK1DIV_POSE	3U 
#define	CMU_CFGR_HCLK1DIV_MSK	BITS(CMU_CFGR_HCLK1DIV_POSS,CMU_CFGR_HCLK1DIV_POSE)

/****************** Bit definition for CMU_CLKENR register ************************/

#define	CMU_CLKENR_HOSC1MEN_POS	17U 
#define	CMU_CLKENR_HOSC1MEN_MSK	BIT(CMU_CLKENR_HOSC1MEN_POS)

#define	CMU_CLKENR_HRC1MEN_POS	16U 
#define	CMU_CLKENR_HRC1MEN_MSK	BIT(CMU_CLKENR_HRC1MEN_POS)

#define	CMU_CLKENR_PLL2EN_POS	9U 
#define	CMU_CLKENR_PLL2EN_MSK	BIT(CMU_CLKENR_PLL2EN_POS)

#define	CMU_CLKENR_PLL1EN_POS	8U 
#define	CMU_CLKENR_PLL1EN_MSK	BIT(CMU_CLKENR_PLL1EN_POS)

#define	CMU_CLKENR_ULRCEN_POS	4U 
#define	CMU_CLKENR_ULRCEN_MSK	BIT(CMU_CLKENR_ULRCEN_POS)

#define	CMU_CLKENR_LRCEN_POS	3U 
#define	CMU_CLKENR_LRCEN_MSK	BIT(CMU_CLKENR_LRCEN_POS)

#define	CMU_CLKENR_HRCEN_POS	2U 
#define	CMU_CLKENR_HRCEN_MSK	BIT(CMU_CLKENR_HRCEN_POS)

#define	CMU_CLKENR_LOSCEN_POS	1U 
#define	CMU_CLKENR_LOSCEN_MSK	BIT(CMU_CLKENR_LOSCEN_POS)

#define	CMU_CLKENR_HOSCEN_POS	0U 
#define	CMU_CLKENR_HOSCEN_MSK	BIT(CMU_CLKENR_HOSCEN_POS)

/****************** Bit definition for CMU_CLKSR register ************************/

#define	CMU_CLKSR_PLL2RDY_POS	25U 
#define	CMU_CLKSR_PLL2RDY_MSK	BIT(CMU_CLKSR_PLL2RDY_POS)

#define	CMU_CLKSR_PLL1RDY_POS	24U 
#define	CMU_CLKSR_PLL1RDY_MSK	BIT(CMU_CLKSR_PLL1RDY_POS)

#define	CMU_CLKSR_LRCRDY_POS	19U 
#define	CMU_CLKSR_LRCRDY_MSK	BIT(CMU_CLKSR_LRCRDY_POS)

#define	CMU_CLKSR_HRCRDY_POS	18U 
#define	CMU_CLKSR_HRCRDY_MSK	BIT(CMU_CLKSR_HRCRDY_POS)

#define	CMU_CLKSR_LOSCRDY_POS	17U 
#define	CMU_CLKSR_LOSCRDY_MSK	BIT(CMU_CLKSR_LOSCRDY_POS)

#define	CMU_CLKSR_HOSCRDY_POS	16U 
#define	CMU_CLKSR_HOSCRDY_MSK	BIT(CMU_CLKSR_HOSCRDY_POS)

#define	CMU_CLKSR_PLL2ACT_POS	9U 
#define	CMU_CLKSR_PLL2ACT_MSK	BIT(CMU_CLKSR_PLL2ACT_POS)

#define	CMU_CLKSR_PLL1ACT_POS	8U 
#define	CMU_CLKSR_PLL1ACT_MSK	BIT(CMU_CLKSR_PLL1ACT_POS)

#define	CMU_CLKSR_ULRCACT_POS	4U 
#define	CMU_CLKSR_ULRCACT_MSK	BIT(CMU_CLKSR_ULRCACT_POS)

#define	CMU_CLKSR_LRCACT_POS	3U 
#define	CMU_CLKSR_LRCACT_MSK	BIT(CMU_CLKSR_LRCACT_POS)

#define	CMU_CLKSR_HRCACT_POS	2U 
#define	CMU_CLKSR_HRCACT_MSK	BIT(CMU_CLKSR_HRCACT_POS)

#define	CMU_CLKSR_LOSCACT_POS	1U 
#define	CMU_CLKSR_LOSCACT_MSK	BIT(CMU_CLKSR_LOSCACT_POS)

#define	CMU_CLKSR_HOSCACT_POS	0U 
#define	CMU_CLKSR_HOSCACT_MSK	BIT(CMU_CLKSR_HOSCACT_POS)

/****************** Bit definition for CMU_PLLCFG register ************************/

#define	CMU_PLLCFG_PLL2LCKN_POS	17U 
#define	CMU_PLLCFG_PLL2LCKN_MSK	BIT(CMU_PLLCFG_PLL2LCKN_POS)

#define	CMU_PLLCFG_PLL1LCKN_POS	16U 
#define	CMU_PLLCFG_PLL1LCKN_MSK	BIT(CMU_PLLCFG_PLL1LCKN_POS)

#define	CMU_PLLCFG_PLL2RFS_POSS	8U 
#define	CMU_PLLCFG_PLL2RFS_POSE	9U 
#define	CMU_PLLCFG_PLL2RFS_MSK	BITS(CMU_PLLCFG_PLL2RFS_POSS,CMU_PLLCFG_PLL2RFS_POSE)

#define	CMU_PLLCFG_PLL1OS_POSS	4U 
#define	CMU_PLLCFG_PLL1OS_POSE	5U 
#define	CMU_PLLCFG_PLL1OS_MSK	BITS(CMU_PLLCFG_PLL1OS_POSS,CMU_PLLCFG_PLL1OS_POSE)

#define	CMU_PLLCFG_PLL1RFS_POSS	0U 
#define	CMU_PLLCFG_PLL1RFS_POSE	2U 
#define	CMU_PLLCFG_PLL1RFS_MSK	BITS(CMU_PLLCFG_PLL1RFS_POSS,CMU_PLLCFG_PLL1RFS_POSE)

/****************** Bit definition for CMU_HOSCCFG register ************************/

#define	CMU_HOSCCFG_FREQ_POSS	0U 
#define	CMU_HOSCCFG_FREQ_POSE	4U 
#define	CMU_HOSCCFG_FREQ_MSK	BITS(CMU_HOSCCFG_FREQ_POSS,CMU_HOSCCFG_FREQ_POSE)

/****************** Bit definition for CMU_HOSMCR register ************************/

#define	CMU_HOSMCR_NMIE_POS	20U 
#define	CMU_HOSMCR_NMIE_MSK	BIT(CMU_HOSMCR_NMIE_POS)

#define	CMU_HOSMCR_STPIF_POS	19U 
#define	CMU_HOSMCR_STPIF_MSK	BIT(CMU_HOSMCR_STPIF_POS)

#define	CMU_HOSMCR_STRIF_POS	18U 
#define	CMU_HOSMCR_STRIF_MSK	BIT(CMU_HOSMCR_STRIF_POS)

#define	CMU_HOSMCR_STPIE_POS	17U 
#define	CMU_HOSMCR_STPIE_MSK	BIT(CMU_HOSMCR_STPIE_POS)

#define	CMU_HOSMCR_STRIE_POS	16U 
#define	CMU_HOSMCR_STRIE_MSK	BIT(CMU_HOSMCR_STRIE_POS)

#define	CMU_HOSMCR_FRQS_POSS	8U 
#define	CMU_HOSMCR_FRQS_POSE	10U 
#define	CMU_HOSMCR_FRQS_MSK	BITS(CMU_HOSMCR_FRQS_POSS,CMU_HOSMCR_FRQS_POSE)

#define	CMU_HOSMCR_CLKS_POS	1U 
#define	CMU_HOSMCR_CLKS_MSK	BIT(CMU_HOSMCR_CLKS_POS)

#define	CMU_HOSMCR_EN_POS	0U 
#define	CMU_HOSMCR_EN_MSK	BIT(CMU_HOSMCR_EN_POS)

/****************** Bit definition for CMU_LOSMCR register ************************/

#define	CMU_LOSMCR_NMIE_POS	20U 
#define	CMU_LOSMCR_NMIE_MSK	BIT(CMU_LOSMCR_NMIE_POS)

#define	CMU_LOSMCR_STPIF_POS	19U 
#define	CMU_LOSMCR_STPIF_MSK	BIT(CMU_LOSMCR_STPIF_POS)

#define	CMU_LOSMCR_STRIF_POS	18U 
#define	CMU_LOSMCR_STRIF_MSK	BIT(CMU_LOSMCR_STRIF_POS)

#define	CMU_LOSMCR_STPIE_POS	17U 
#define	CMU_LOSMCR_STPIE_MSK	BIT(CMU_LOSMCR_STPIE_POS)

#define	CMU_LOSMCR_STRIE_POS	16U 
#define	CMU_LOSMCR_STRIE_MSK	BIT(CMU_LOSMCR_STRIE_POS)

#define	CMU_LOSMCR_CLKS_POS	1U 
#define	CMU_LOSMCR_CLKS_MSK	BIT(CMU_LOSMCR_CLKS_POS)

#define	CMU_LOSMCR_EN_POS	0U 
#define	CMU_LOSMCR_EN_MSK	BIT(CMU_LOSMCR_EN_POS)

/****************** Bit definition for CMU_PULMCR register ************************/

#define	CMU_PULMCR_NMIE_POS	20U 
#define	CMU_PULMCR_NMIE_MSK	BIT(CMU_PULMCR_NMIE_POS)

#define	CMU_PULMCR_ULKIF_POS	19U 
#define	CMU_PULMCR_ULKIF_MSK	BIT(CMU_PULMCR_ULKIF_POS)

#define	CMU_PULMCR_LCKIF_POS	18U 
#define	CMU_PULMCR_LCKIF_MSK	BIT(CMU_PULMCR_LCKIF_POS)

#define	CMU_PULMCR_ULKIE_POS	17U 
#define	CMU_PULMCR_ULKIE_MSK	BIT(CMU_PULMCR_ULKIE_POS)

#define	CMU_PULMCR_LCKIE_POS	16U 
#define	CMU_PULMCR_LCKIE_MSK	BIT(CMU_PULMCR_LCKIE_POS)

#define	CMU_PULMCR_MODE_POSS	8U 
#define	CMU_PULMCR_MODE_POSE	9U 
#define	CMU_PULMCR_MODE_MSK	BITS(CMU_PULMCR_MODE_POSS,CMU_PULMCR_MODE_POSE)

#define	CMU_PULMCR_CLKS_POS	1U 
#define	CMU_PULMCR_CLKS_MSK	BIT(CMU_PULMCR_CLKS_POS)

#define	CMU_PULMCR_EN_POS	0U 
#define	CMU_PULMCR_EN_MSK	BIT(CMU_PULMCR_EN_POS)

/****************** Bit definition for CMU_CLKOCR register ************************/

#define	CMU_CLKOCR_LSCOS_POSS	24U 
#define	CMU_CLKOCR_LSCOS_POSE	26U 
#define	CMU_CLKOCR_LSCOS_MSK	BITS(CMU_CLKOCR_LSCOS_POSS,CMU_CLKOCR_LSCOS_POSE)

#define	CMU_CLKOCR_LSCOEN_POS	16U 
#define	CMU_CLKOCR_LSCOEN_MSK	BIT(CMU_CLKOCR_LSCOEN_POS)

#define	CMU_CLKOCR_HSCODIV_POSS	12U 
#define	CMU_CLKOCR_HSCODIV_POSE	14U 
#define	CMU_CLKOCR_HSCODIV_MSK	BITS(CMU_CLKOCR_HSCODIV_POSS,CMU_CLKOCR_HSCODIV_POSE)

#define	CMU_CLKOCR_HSCOS_POSS	8U 
#define	CMU_CLKOCR_HSCOS_POSE	10U 
#define	CMU_CLKOCR_HSCOS_MSK	BITS(CMU_CLKOCR_HSCOS_POSS,CMU_CLKOCR_HSCOS_POSE)

#define	CMU_CLKOCR_HSCOEN_POS	0U 
#define	CMU_CLKOCR_HSCOEN_MSK	BIT(CMU_CLKOCR_HSCOEN_POS)

/****************** Bit definition for CMU_BUZZCR register ************************/

#define	CMU_BUZZCR_DAT_POSS	16U 
#define	CMU_BUZZCR_DAT_POSE	31U 
#define	CMU_BUZZCR_DAT_MSK	BITS(CMU_BUZZCR_DAT_POSS,CMU_BUZZCR_DAT_POSE)

#define	CMU_BUZZCR_DIV_POSS	8U 
#define	CMU_BUZZCR_DIV_POSE	10U 
#define	CMU_BUZZCR_DIV_MSK	BITS(CMU_BUZZCR_DIV_POSS,CMU_BUZZCR_DIV_POSE)

#define	CMU_BUZZCR_EN_POS	0U 
#define	CMU_BUZZCR_EN_MSK	BIT(CMU_BUZZCR_EN_POS)

/****************** Bit definition for CMU_AHB1ENR register ************************/

#define	CMU_AHB1ENR_ECCEN_POS	11U 
#define	CMU_AHB1ENR_ECCEN_MSK	BIT(CMU_AHB1ENR_ECCEN_POS)

#define	CMU_AHB1ENR_USBEN_POS	10U 
#define	CMU_AHB1ENR_USBEN_MSK	BIT(CMU_AHB1ENR_USBEN_POS)

#define	CMU_AHB1ENR_DMAEN_POS	8U 
#define	CMU_AHB1ENR_DMAEN_MSK	BIT(CMU_AHB1ENR_DMAEN_POS)

#define	CMU_AHB1ENR_QSPIEN_POS	7U 
#define	CMU_AHB1ENR_QSPIEN_MSK	BIT(CMU_AHB1ENR_QSPIEN_POS)

#define	CMU_AHB1ENR_EBIEN_POS	6U 
#define	CMU_AHB1ENR_EBIEN_MSK	BIT(CMU_AHB1ENR_EBIEN_POS)

#define	CMU_AHB1ENR_PISEN_POS	5U 
#define	CMU_AHB1ENR_PISEN_MSK	BIT(CMU_AHB1ENR_PISEN_POS)

#define	CMU_AHB1ENR_TRNGEN_POS	4U 
#define	CMU_AHB1ENR_TRNGEN_MSK	BIT(CMU_AHB1ENR_TRNGEN_POS)

#define	CMU_AHB1ENR_CRYPTEN_POS	3U 
#define	CMU_AHB1ENR_CRYPTEN_MSK	BIT(CMU_AHB1ENR_CRYPTEN_POS)

#define	CMU_AHB1ENR_CALCEN_POS	2U 
#define	CMU_AHB1ENR_CALCEN_MSK	BIT(CMU_AHB1ENR_CALCEN_POS)

#define	CMU_AHB1ENR_CRCEN_POS	1U 
#define	CMU_AHB1ENR_CRCEN_MSK	BIT(CMU_AHB1ENR_CRCEN_POS)

#define	CMU_AHB1ENR_GPIOEN_POS	0U 
#define	CMU_AHB1ENR_GPIOEN_MSK	BIT(CMU_AHB1ENR_GPIOEN_POS)

/****************** Bit definition for CMU_APB1ENR register ************************/

#define	CMU_APB1ENR_QSPIEN_POS	25U 
#define	CMU_APB1ENR_QSPIEN_MSK	BIT(CMU_APB1ENR_QSPIEN_POS)

#define	CMU_APB1ENR_CAN0EN_POS	24U 
#define	CMU_APB1ENR_CAN0EN_MSK	BIT(CMU_APB1ENR_CAN0EN_POS)

#define	CMU_APB1ENR_I2C1EN_POS	21U 
#define	CMU_APB1ENR_I2C1EN_MSK	BIT(CMU_APB1ENR_I2C1EN_POS)

#define	CMU_APB1ENR_I2C0EN_POS	20U 
#define	CMU_APB1ENR_I2C0EN_MSK	BIT(CMU_APB1ENR_I2C0EN_POS)

#define	CMU_APB1ENR_SPI2EN_POS	18U 
#define	CMU_APB1ENR_SPI2EN_MSK	BIT(CMU_APB1ENR_SPI2EN_POS)

#define	CMU_APB1ENR_SPI1EN_POS	17U 
#define	CMU_APB1ENR_SPI1EN_MSK	BIT(CMU_APB1ENR_SPI1EN_POS)

#define	CMU_APB1ENR_SPI0EN_POS	16U 
#define	CMU_APB1ENR_SPI0EN_MSK	BIT(CMU_APB1ENR_SPI0EN_POS)

#define	CMU_APB1ENR_UART5EN_POS	13U 
#define	CMU_APB1ENR_UART5EN_MSK	BIT(CMU_APB1ENR_UART5EN_POS)

#define	CMU_APB1ENR_UART4EN_POS	12U 
#define	CMU_APB1ENR_UART4EN_MSK	BIT(CMU_APB1ENR_UART4EN_POS)

#define	CMU_APB1ENR_UART3EN_POS	11U 
#define	CMU_APB1ENR_UART3EN_MSK	BIT(CMU_APB1ENR_UART3EN_POS)

#define	CMU_APB1ENR_UART2EN_POS	10U 
#define	CMU_APB1ENR_UART2EN_MSK	BIT(CMU_APB1ENR_UART2EN_POS)

#define	CMU_APB1ENR_UART1EN_POS	9U 
#define	CMU_APB1ENR_UART1EN_MSK	BIT(CMU_APB1ENR_UART1EN_POS)

#define	CMU_APB1ENR_UART0EN_POS	8U 
#define	CMU_APB1ENR_UART0EN_MSK	BIT(CMU_APB1ENR_UART0EN_POS)

#define	CMU_APB1ENR_TIM7EN_POS	7U 
#define	CMU_APB1ENR_TIM7EN_MSK	BIT(CMU_APB1ENR_TIM7EN_POS)

#define	CMU_APB1ENR_TIM6EN_POS	6U 
#define	CMU_APB1ENR_TIM6EN_MSK	BIT(CMU_APB1ENR_TIM6EN_POS)

#define	CMU_APB1ENR_TIM5EN_POS	5U 
#define	CMU_APB1ENR_TIM5EN_MSK	BIT(CMU_APB1ENR_TIM5EN_POS)

#define	CMU_APB1ENR_TIM4EN_POS	4U 
#define	CMU_APB1ENR_TIM4EN_MSK	BIT(CMU_APB1ENR_TIM4EN_POS)

#define	CMU_APB1ENR_TIM3EN_POS	3U 
#define	CMU_APB1ENR_TIM3EN_MSK	BIT(CMU_APB1ENR_TIM3EN_POS)

#define	CMU_APB1ENR_TIM2EN_POS	2U 
#define	CMU_APB1ENR_TIM2EN_MSK	BIT(CMU_APB1ENR_TIM2EN_POS)

#define	CMU_APB1ENR_TIM1EN_POS	1U 
#define	CMU_APB1ENR_TIM1EN_MSK	BIT(CMU_APB1ENR_TIM1EN_POS)

#define	CMU_APB1ENR_TIM0EN_POS	0U 
#define	CMU_APB1ENR_TIM0EN_MSK	BIT(CMU_APB1ENR_TIM0EN_POS)

/****************** Bit definition for CMU_APB2ENR register ************************/

#define	CMU_APB2ENR_DBGCEN_POS	19U 
#define	CMU_APB2ENR_DBGCEN_MSK	BIT(CMU_APB2ENR_DBGCEN_POS)

#define	CMU_APB2ENR_BKPCEN_POS	17U 
#define	CMU_APB2ENR_BKPCEN_MSK	BIT(CMU_APB2ENR_BKPCEN_POS)

#define	CMU_APB2ENR_TSENSEEN_POS	16U 
#define	CMU_APB2ENR_TSENSEEN_MSK	BIT(CMU_APB2ENR_TSENSEEN_POS)

#define	CMU_APB2ENR_RTCEN_POS	15U 
#define	CMU_APB2ENR_RTCEN_MSK	BIT(CMU_APB2ENR_RTCEN_POS)

#define	CMU_APB2ENR_IWDTEN_POS	14U 
#define	CMU_APB2ENR_IWDTEN_MSK	BIT(CMU_APB2ENR_IWDTEN_POS)

#define	CMU_APB2ENR_LCDEN_POS	13U 
#define	CMU_APB2ENR_LCDEN_MSK	BIT(CMU_APB2ENR_LCDEN_POS)

#define	CMU_APB2ENR_WWDTEN_POS	12U 
#define	CMU_APB2ENR_WWDTEN_MSK	BIT(CMU_APB2ENR_WWDTEN_POS)

#define	CMU_APB2ENR_ACMP2EN_POS	11U 
#define	CMU_APB2ENR_ACMP2EN_MSK	BIT(CMU_APB2ENR_ACMP2EN_POS)

#define	CMU_APB2ENR_DAC0EN_POS	9U 
#define	CMU_APB2ENR_DAC0EN_MSK	BIT(CMU_APB2ENR_DAC0EN_POS)

#define	CMU_APB2ENR_OPAMPEN_POS	8U 
#define	CMU_APB2ENR_OPAMPEN_MSK	BIT(CMU_APB2ENR_OPAMPEN_POS)

#define	CMU_APB2ENR_ACMP1EN_POS	7U 
#define	CMU_APB2ENR_ACMP1EN_MSK	BIT(CMU_APB2ENR_ACMP1EN_POS)

#define	CMU_APB2ENR_ACMP0EN_POS	6U 
#define	CMU_APB2ENR_ACMP0EN_MSK	BIT(CMU_APB2ENR_ACMP0EN_POS)

#define	CMU_APB2ENR_ADC1EN_POS	5U 
#define	CMU_APB2ENR_ADC1EN_MSK	BIT(CMU_APB2ENR_ADC1EN_POS)

#define	CMU_APB2ENR_ADC0EN_POS	4U 
#define	CMU_APB2ENR_ADC0EN_MSK	BIT(CMU_APB2ENR_ADC0EN_POS)

#define	CMU_APB2ENR_LPUART0EN_POS	2U 
#define	CMU_APB2ENR_LPUART0EN_MSK	BIT(CMU_APB2ENR_LPUART0EN_POS)

#define	CMU_APB2ENR_LPTIM0EN_POS	0U 
#define	CMU_APB2ENR_LPTIM0EN_MSK	BIT(CMU_APB2ENR_LPTIM0EN_POS)

/****************** Bit definition for CMU_LPENR register ************************/

#define	CMU_LPENR_STOP1CS_POSS	16U 
#define	CMU_LPENR_STOP1CS_POSE	18U 
#define	CMU_LPENR_STOP1CS_MSK	BITS(CMU_LPENR_STOP1CS_POSS,CMU_LPENR_STOP1CS_POSE)

#define	CMU_LPENR_HOSCEN_POS	3U 
#define	CMU_LPENR_HOSCEN_MSK	BIT(CMU_LPENR_HOSCEN_POS)

#define	CMU_LPENR_HRCEN_POS	2U 
#define	CMU_LPENR_HRCEN_MSK	BIT(CMU_LPENR_HRCEN_POS)

#define	CMU_LPENR_LOSCEN_POS	1U 
#define	CMU_LPENR_LOSCEN_MSK	BIT(CMU_LPENR_LOSCEN_POS)

#define	CMU_LPENR_LRCEN_POS	0U 
#define	CMU_LPENR_LRCEN_MSK	BIT(CMU_LPENR_LRCEN_POS)

/****************** Bit definition for CMU_PERICR register ************************/

#define	CMU_PERICR_USBPHYCS_POSS	28U 
#define	CMU_PERICR_USBPHYCS_POSE	30U 
#define	CMU_PERICR_USBPHYCS_MSK	BITS(CMU_PERICR_USBPHYCS_POSS,CMU_PERICR_USBPHYCS_POSE)

#define	CMU_PERICR_QSPICS_POSS	24U 
#define	CMU_PERICR_QSPICS_POSE	26U 
#define	CMU_PERICR_QSPICS_MSK	BITS(CMU_PERICR_QSPICS_POSS,CMU_PERICR_QSPICS_POSE)

#define	CMU_PERICR_LCD_POSS	16U 
#define	CMU_PERICR_LCD_POSE	18U 
#define	CMU_PERICR_LCD_MSK	BITS(CMU_PERICR_LCD_POSS,CMU_PERICR_LCD_POSE)

#define	CMU_PERICR_LPUART0_POSS	8U 
#define	CMU_PERICR_LPUART0_POSE	11U 
#define	CMU_PERICR_LPUART0_MSK	BITS(CMU_PERICR_LPUART0_POSS,CMU_PERICR_LPUART0_POSE)

#define	CMU_PERICR_LPTIM0_POSS	0U 
#define	CMU_PERICR_LPTIM0_POSE	3U 
#define	CMU_PERICR_LPTIM0_MSK	BITS(CMU_PERICR_LPTIM0_POSS,CMU_PERICR_LPTIM0_POSE)

/****************** Bit definition for CMU_PERIDIVR register ************************/

#define	CMU_PERIDIVR_USBPHYDIV_POSS	28U 
#define	CMU_PERIDIVR_USBPHYDIV_POSE	31U 
#define	CMU_PERIDIVR_USBPHYDIV_MSK	BITS(CMU_PERIDIVR_USBPHYDIV_POSS,CMU_PERIDIVR_USBPHYDIV_POSE)

typedef struct
{
	__O uint32_t CSR;
	__IO uint32_t CFGR;
	uint32_t RESERVED0[2] ;
	__IO uint32_t CLKENR;
	__I uint32_t CLKSR;
	__IO uint32_t PLLCFG;
	__IO uint32_t HOSCCFG;
	__IO uint32_t HOSMCR;
	__IO uint32_t LOSMCR;
	__IO uint32_t PULMCR;
	uint32_t RESERVED1 ;
	__IO uint32_t CLKOCR;
	__IO uint32_t BUZZCR;
	uint32_t RESERVED2[2] ;
	__IO uint32_t AHB1ENR;
	uint32_t RESERVED3[3] ;
	__IO uint32_t APB1ENR;
	__IO uint32_t APB2ENR;
	uint32_t RESERVED4[2] ;
	__IO uint32_t LPENR;
	uint32_t RESERVED5[7] ;
	__IO uint32_t PERICR;
	uint32_t RESERVED6 ;
	__IO uint32_t PERIDIVR;
} CMU_TypeDef;

/****************** Bit definition for DMA_STATUS register ************************/

#define	DMA_STATUS_STATUS_POSS	4U 
#define	DMA_STATUS_STATUS_POSE	7U 
#define	DMA_STATUS_STATUS_MSK	BITS(DMA_STATUS_STATUS_POSS,DMA_STATUS_STATUS_POSE)

#define	DMA_STATUS_MASTER_ENABLE_POS	0U 
#define	DMA_STATUS_MASTER_ENABLE_MSK	BIT(DMA_STATUS_MASTER_ENABLE_POS)

/****************** Bit definition for DMA_CFG register ************************/

#define	DMA_CFG_CHNL_PROT_CTRL_POSS	5U 
#define	DMA_CFG_CHNL_PROT_CTRL_POSE	7U 
#define	DMA_CFG_CHNL_PROT_CTRL_MSK	BITS(DMA_CFG_CHNL_PROT_CTRL_POSS,DMA_CFG_CHNL_PROT_CTRL_POSE)

#define	DMA_CFG_MASTER_ENABLE_POS	0U 
#define	DMA_CFG_MASTER_ENABLE_MSK	BIT(DMA_CFG_MASTER_ENABLE_POS)

/****************** Bit definition for DMA_CTRLBASE register ************************/

#define	DMA_CTRLBASE_CTRL_BASE_PTR_POSS	9U 
#define	DMA_CTRLBASE_CTRL_BASE_PTR_POSE	31U 
#define	DMA_CTRLBASE_CTRL_BASE_PTR_MSK	BITS(DMA_CTRLBASE_CTRL_BASE_PTR_POSS,DMA_CTRLBASE_CTRL_BASE_PTR_POSE)

/****************** Bit definition for DMA_ALTCTRLBASE register ************************/

#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSS	0U 
#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSE	31U 
#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_MSK	BITS(DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSS,DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSE)

/****************** Bit definition for DMA_CHWAITSTATUS register ************************/

#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSS	0U 
#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSE	31U 
#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_MSK	BITS(DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSS,DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSE)

/****************** Bit definition for DMA_CHSWREQ register ************************/

#define	DMA_CHSWREQ_CHSWREQ_POSS	0U 
#define	DMA_CHSWREQ_CHSWREQ_POSE	31U 
#define	DMA_CHSWREQ_CHSWREQ_MSK	BITS(DMA_CHSWREQ_CHSWREQ_POSS,DMA_CHSWREQ_CHSWREQ_POSE)

/****************** Bit definition for DMA_CHUSEBURSTSET register ************************/

#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSS	0U 
#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSE	31U 
#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_MSK	BITS(DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSS,DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSE)

/****************** Bit definition for DMA_CHUSEBURSTCLR register ************************/

#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSS	0U 
#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSE	31U 
#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_MSK	BITS(DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSS,DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSE)

/****************** Bit definition for DMA_CHREQMASKSET register ************************/

#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSS	0U 
#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSE	31U 
#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_MSK	BITS(DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSS,DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSE)

/****************** Bit definition for DMA_CHREQMASKCLR register ************************/

#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSS	0U 
#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSE	31U 
#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_MSK	BITS(DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSS,DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSE)

/****************** Bit definition for DMA_CHENSET register ************************/

#define	DMA_CHENSET_CHNL_ENABLE_SET_POSS	0U 
#define	DMA_CHENSET_CHNL_ENABLE_SET_POSE	31U 
#define	DMA_CHENSET_CHNL_ENABLE_SET_MSK	BITS(DMA_CHENSET_CHNL_ENABLE_SET_POSS,DMA_CHENSET_CHNL_ENABLE_SET_POSE)

/****************** Bit definition for DMA_CHENCLR register ************************/

#define	DMA_CHENCLR_CHNL_ENABLE_CLR_POSS	0U 
#define	DMA_CHENCLR_CHNL_ENABLE_CLR_POSE	31U 
#define	DMA_CHENCLR_CHNL_ENABLE_CLR_MSK	BITS(DMA_CHENCLR_CHNL_ENABLE_CLR_POSS,DMA_CHENCLR_CHNL_ENABLE_CLR_POSE)

/****************** Bit definition for DMA_CHPRIALTSET register ************************/

#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSS	0U 
#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSE	31U 
#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_MSK	BITS(DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSS,DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSE)

/****************** Bit definition for DMA_CHPRIALTCLR register ************************/

#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSS	0U 
#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSE	31U 
#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_MSK	BITS(DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSS,DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSE)

/****************** Bit definition for DMA_CHPRSET register ************************/

#define	DMA_CHPRSET_CHNL_PRIORITY_SET_POSS	0U 
#define	DMA_CHPRSET_CHNL_PRIORITY_SET_POSE	31U 
#define	DMA_CHPRSET_CHNL_PRIORITY_SET_MSK	BITS(DMA_CHPRSET_CHNL_PRIORITY_SET_POSS,DMA_CHPRSET_CHNL_PRIORITY_SET_POSE)

/****************** Bit definition for DMA_CHPRCLR register ************************/

#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSS	0U 
#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSE	31U 
#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_MSK	BITS(DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSS,DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSE)

/****************** Bit definition for DMA_ERRCLR register ************************/

#define	DMA_ERRCLR_ERR_CLR_POS	0U 
#define	DMA_ERRCLR_ERR_CLR_MSK	BIT(DMA_ERRCLR_ERR_CLR_POS)

/****************** Bit definition for DMA_IFLAG register ************************/

#define	DMA_IFLAG_DMAERRIF_POS	31U 
#define	DMA_IFLAG_DMAERRIF_MSK	BIT(DMA_IFLAG_DMAERRIF_POS)

#define	DMA_IFLAG_CH11DONEIF_POS	11U 
#define	DMA_IFLAG_CH11DONEIF_MSK	BIT(DMA_IFLAG_CH11DONEIF_POS)

#define	DMA_IFLAG_CH10DONEIF_POS	10U 
#define	DMA_IFLAG_CH10DONEIF_MSK	BIT(DMA_IFLAG_CH10DONEIF_POS)

#define	DMA_IFLAG_CH9DONEIF_POS	9U 
#define	DMA_IFLAG_CH9DONEIF_MSK	BIT(DMA_IFLAG_CH9DONEIF_POS)

#define	DMA_IFLAG_CH8DONEIF_POS	8U 
#define	DMA_IFLAG_CH8DONEIF_MSK	BIT(DMA_IFLAG_CH8DONEIF_POS)

#define	DMA_IFLAG_CH7DONEIF_POS	7U 
#define	DMA_IFLAG_CH7DONEIF_MSK	BIT(DMA_IFLAG_CH7DONEIF_POS)

#define	DMA_IFLAG_CH6DONEIF_POS	6U 
#define	DMA_IFLAG_CH6DONEIF_MSK	BIT(DMA_IFLAG_CH6DONEIF_POS)

#define	DMA_IFLAG_CH5DONEIF_POS	5U 
#define	DMA_IFLAG_CH5DONEIF_MSK	BIT(DMA_IFLAG_CH5DONEIF_POS)

#define	DMA_IFLAG_CH4DONEIF_POS	4U 
#define	DMA_IFLAG_CH4DONEIF_MSK	BIT(DMA_IFLAG_CH4DONEIF_POS)

#define	DMA_IFLAG_CH3DONEIF_POS	3U 
#define	DMA_IFLAG_CH3DONEIF_MSK	BIT(DMA_IFLAG_CH3DONEIF_POS)

#define	DMA_IFLAG_CH2DONEIF_POS	2U 
#define	DMA_IFLAG_CH2DONEIF_MSK	BIT(DMA_IFLAG_CH2DONEIF_POS)

#define	DMA_IFLAG_CH1DONEIF_POS	1U 
#define	DMA_IFLAG_CH1DONEIF_MSK	BIT(DMA_IFLAG_CH1DONEIF_POS)

#define	DMA_IFLAG_CH0DONEIF_POS	0U 
#define	DMA_IFLAG_CH0DONEIF_MSK	BIT(DMA_IFLAG_CH0DONEIF_POS)

/****************** Bit definition for DMA_ICFR register ************************/

#define	DMA_ICFR_DMAERRC_POS	31U 
#define	DMA_ICFR_DMAERRC_MSK	BIT(DMA_ICFR_DMAERRC_POS)

#define	DMA_ICFR_CH11DONEC_POS	11U 
#define	DMA_ICFR_CH11DONEC_MSK	BIT(DMA_ICFR_CH11DONEC_POS)

#define	DMA_ICFR_CH10DONEC_POS	10U 
#define	DMA_ICFR_CH10DONEC_MSK	BIT(DMA_ICFR_CH10DONEC_POS)

#define	DMA_ICFR_CH9DONEC_POS	9U 
#define	DMA_ICFR_CH9DONEC_MSK	BIT(DMA_ICFR_CH9DONEC_POS)

#define	DMA_ICFR_CH8DONEC_POS	8U 
#define	DMA_ICFR_CH8DONEC_MSK	BIT(DMA_ICFR_CH8DONEC_POS)

#define	DMA_ICFR_CH7DONEC_POS	7U 
#define	DMA_ICFR_CH7DONEC_MSK	BIT(DMA_ICFR_CH7DONEC_POS)

#define	DMA_ICFR_CH6DONEC_POS	6U 
#define	DMA_ICFR_CH6DONEC_MSK	BIT(DMA_ICFR_CH6DONEC_POS)

#define	DMA_ICFR_CH5DONEC_POS	5U 
#define	DMA_ICFR_CH5DONEC_MSK	BIT(DMA_ICFR_CH5DONEC_POS)

#define	DMA_ICFR_CH4DONEC_POS	4U 
#define	DMA_ICFR_CH4DONEC_MSK	BIT(DMA_ICFR_CH4DONEC_POS)

#define	DMA_ICFR_CH3DONEC_POS	3U 
#define	DMA_ICFR_CH3DONEC_MSK	BIT(DMA_ICFR_CH3DONEC_POS)

#define	DMA_ICFR_CH2DONEC_POS	2U 
#define	DMA_ICFR_CH2DONEC_MSK	BIT(DMA_ICFR_CH2DONEC_POS)

#define	DMA_ICFR_CH1DONEC_POS	1U 
#define	DMA_ICFR_CH1DONEC_MSK	BIT(DMA_ICFR_CH1DONEC_POS)

#define	DMA_ICFR_CH0DONEC_POS	0U 
#define	DMA_ICFR_CH0DONEC_MSK	BIT(DMA_ICFR_CH0DONEC_POS)

/****************** Bit definition for DMA_IER register ************************/

#define	DMA_IER_DMAERRIE_POS	31U 
#define	DMA_IER_DMAERRIE_MSK	BIT(DMA_IER_DMAERRIE_POS)

#define	DMA_IER_CH11DONEIE_POS	11U 
#define	DMA_IER_CH11DONEIE_MSK	BIT(DMA_IER_CH11DONEIE_POS)

#define	DMA_IER_CH10DONEIE_POS	10U 
#define	DMA_IER_CH10DONEIE_MSK	BIT(DMA_IER_CH10DONEIE_POS)

#define	DMA_IER_CH9DONEIE_POS	9U 
#define	DMA_IER_CH9DONEIE_MSK	BIT(DMA_IER_CH9DONEIE_POS)

#define	DMA_IER_CH8DONEIE_POS	8U 
#define	DMA_IER_CH8DONEIE_MSK	BIT(DMA_IER_CH8DONEIE_POS)

#define	DMA_IER_CH7DONEIE_POS	7U 
#define	DMA_IER_CH7DONEIE_MSK	BIT(DMA_IER_CH7DONEIE_POS)

#define	DMA_IER_CH6DONEIE_POS	6U 
#define	DMA_IER_CH6DONEIE_MSK	BIT(DMA_IER_CH6DONEIE_POS)

#define	DMA_IER_CH5DONEIE_POS	5U 
#define	DMA_IER_CH5DONEIE_MSK	BIT(DMA_IER_CH5DONEIE_POS)

#define	DMA_IER_CH4DONEIE_POS	4U 
#define	DMA_IER_CH4DONEIE_MSK	BIT(DMA_IER_CH4DONEIE_POS)

#define	DMA_IER_CH3DONEIE_POS	3U 
#define	DMA_IER_CH3DONEIE_MSK	BIT(DMA_IER_CH3DONEIE_POS)

#define	DMA_IER_CH2DONEIE_POS	2U 
#define	DMA_IER_CH2DONEIE_MSK	BIT(DMA_IER_CH2DONEIE_POS)

#define	DMA_IER_CH1DONEIE_POS	1U 
#define	DMA_IER_CH1DONEIE_MSK	BIT(DMA_IER_CH1DONEIE_POS)

#define	DMA_IER_CH0DONEIE_POS	0U 
#define	DMA_IER_CH0DONEIE_MSK	BIT(DMA_IER_CH0DONEIE_POS)

/****************** Bit definition for DMA_CH0_SELCON register ************************/

#define	DMA_CH0_SELCON_MSEL_POSS	8U 
#define	DMA_CH0_SELCON_MSEL_POSE	13U 
#define	DMA_CH0_SELCON_MSEL_MSK	BITS(DMA_CH0_SELCON_MSEL_POSS,DMA_CH0_SELCON_MSEL_POSE)

#define	DMA_CH0_SELCON_MSIGSEL_POSS	0U 
#define	DMA_CH0_SELCON_MSIGSEL_POSE	3U 
#define	DMA_CH0_SELCON_MSIGSEL_MSK	BITS(DMA_CH0_SELCON_MSIGSEL_POSS,DMA_CH0_SELCON_MSIGSEL_POSE)

typedef struct
{
	__I uint32_t STATUS;
	__IO uint32_t CFG;
	__IO uint32_t CTRLBASE;
	__I uint32_t ALTCTRLBASE;
	__I uint32_t CHWAITSTATUS;
	__IO uint32_t CHSWREQ;
	__IO uint32_t CHUSEBURSTSET;
	__O uint32_t CHUSEBURSTCLR;
	__IO uint32_t CHREQMASKSET;
	__O uint32_t CHREQMASKCLR;
	__IO uint32_t CHENSET;
	__O uint32_t CHENCLR;
	__IO uint32_t CHPRIALTSET;
	__O uint32_t CHPRIALTCLR;
	__IO uint32_t CHPRSET;
	__O uint32_t CHPRCLR;
	uint32_t RESERVED0[3] ;
	__IO uint32_t ERRCLR;
	uint32_t RESERVED1[1004] ;
	__I uint32_t IFLAG;
	uint32_t RESERVED2 ;
	__O uint32_t ICFR;
	__IO uint32_t IER;
	uint32_t RESERVED3[60] ;
	__IO uint32_t CH_SELCON[12];
} DMA_TypeDef;

/****************** Bit definition for ECC_AREG(x = 1 .. 64) register ************************/
#define	ECC_AREGx_VAL_POSS	0U 
#define	ECC_AREGx_VAL_POSE	31U 
#define	ECC_AREGx_VAL_MSK	BITS(ECC_AREG1_VAL_POSS,ECC_AREG1_VAL_POSE)

/****************** Bit definition for ECC_NREG register ************************/
#define	ECC_NREGx_VAL_POSS	0U 
#define	ECC_NREGx_VAL_POSE	31U 
#define	ECC_NREGx_VAL_MSK	BITS(ECC_AREG1_VAL_POSS,ECC_AREG1_VAL_POSE)

/****************** Bit definition for ECC_CON register ************************/

#define	ECC_CON_SINGST_POS	31U 
#define	ECC_CON_SINGST_MSK	BIT(ECC_CON_SINGST_POS)

#define	ECC_CON_COMBST_POS	30U 
#define	ECC_CON_COMBST_MSK	BIT(ECC_CON_COMBST_POS)

#define	ECC_CON_REMAP_POS	29U 
#define	ECC_CON_REMAP_MSK	BIT(ECC_CON_REMAP_POS)

#define	ECC_CON_COMBMD_POSS	27U 
#define	ECC_CON_COMBMD_POSE	28U 
#define	ECC_CON_COMBMD_MSK	BITS(ECC_CON_COMBMD_POSS,ECC_CON_COMBMD_POSE)

#define	ECC_CON_OPL_POSS	10U 
#define	ECC_CON_OPL_POSE	12U 
#define	ECC_CON_OPL_MSK	BITS(ECC_CON_OPL_POSS,ECC_CON_OPL_POSE)

#define	ECC_CON_OPR_POSS	7U 
#define	ECC_CON_OPR_POSE	9U 
#define	ECC_CON_OPR_MSK	BITS(ECC_CON_OPR_POSS,ECC_CON_OPR_POSE)

#define	ECC_CON_RES_POSS	4U 
#define	ECC_CON_RES_POSE	6U 
#define	ECC_CON_RES_MSK	BITS(ECC_CON_RES_POSS,ECC_CON_RES_POSE)

#define	ECC_CON_MODE_POSS	1U 
#define	ECC_CON_MODE_POSE	3U 
#define	ECC_CON_MODE_MSK	BITS(ECC_CON_MODE_POSS,ECC_CON_MODE_POSE)

#define	ECC_CON_IE_POS	0U 
#define	ECC_CON_IE_MSK	BIT(ECC_CON_IE_POS)

/****************** Bit definition for ECC_STAT register ************************/

#define	ECC_STAT_ERR_POS	2U 
#define	ECC_STAT_ERR_MSK	BIT(ECC_STAT_ERR_POS)

#define	ECC_STAT_DONE_POS	1U 
#define	ECC_STAT_DONE_MSK	BIT(ECC_STAT_DONE_POS)

#define	ECC_STAT_BUSY_POS	0U 
#define	ECC_STAT_BUSY_MSK	BIT(ECC_STAT_BUSY_POS)

/****************** Bit definition for ECC_PARA register ************************/

#define	ECC_PARA_VAL_POSS	0U 
#define	ECC_PARA_VAL_POSE	31U 
#define	ECC_PARA_VAL_MSK	BITS(ECC_PARA_VAL_POSS,ECC_PARA_VAL_POSE)

typedef struct
{
	__IO uint32_t AREG[64];
	__IO uint32_t NREG[8];
	uint32_t RESERVED0[120];
	__IO uint32_t CON;
	__IO uint32_t STAT;
	__IO uint32_t PARA;
} ECC_TypeDef;

/****************** Bit definition for PIS_CH0_CON register ************************/

#define	PIS_CH0_CON_SYNCSEL_POSS	24U 
#define	PIS_CH0_CON_SYNCSEL_POSE	26U 
#define	PIS_CH0_CON_SYNCSEL_MSK	BITS(PIS_CH0_CON_SYNCSEL_POSS,PIS_CH0_CON_SYNCSEL_POSE)

#define	PIS_CH0_CON_PULCK_POSS	18U 
#define	PIS_CH0_CON_PULCK_POSE	19U 
#define	PIS_CH0_CON_PULCK_MSK	BITS(PIS_CH0_CON_PULCK_POSS,PIS_CH0_CON_PULCK_POSE)

#define	PIS_CH0_CON_EDGS_POSS	16U 
#define	PIS_CH0_CON_EDGS_POSE	17U 
#define	PIS_CH0_CON_EDGS_MSK	BITS(PIS_CH0_CON_EDGS_POSS,PIS_CH0_CON_EDGS_POSE)

#define	PIS_CH0_CON_SRCS_POSS	8U 
#define	PIS_CH0_CON_SRCS_POSE	13U 
#define	PIS_CH0_CON_SRCS_MSK	BITS(PIS_CH0_CON_SRCS_POSS,PIS_CH0_CON_SRCS_POSE)

#define	PIS_CH0_CON_MSIGS_POSS	0U 
#define	PIS_CH0_CON_MSIGS_POSE	3U 
#define	PIS_CH0_CON_MSIGS_MSK	BITS(PIS_CH0_CON_MSIGS_POSS,PIS_CH0_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH1_CON register ************************/

#define	PIS_CH1_CON_SYNCSEL_POSS	24U 
#define	PIS_CH1_CON_SYNCSEL_POSE	26U 
#define	PIS_CH1_CON_SYNCSEL_MSK	BITS(PIS_CH1_CON_SYNCSEL_POSS,PIS_CH1_CON_SYNCSEL_POSE)

#define	PIS_CH1_CON_PULCK_POSS	18U 
#define	PIS_CH1_CON_PULCK_POSE	19U 
#define	PIS_CH1_CON_PULCK_MSK	BITS(PIS_CH1_CON_PULCK_POSS,PIS_CH1_CON_PULCK_POSE)

#define	PIS_CH1_CON_EDGS_POSS	16U 
#define	PIS_CH1_CON_EDGS_POSE	17U 
#define	PIS_CH1_CON_EDGS_MSK	BITS(PIS_CH1_CON_EDGS_POSS,PIS_CH1_CON_EDGS_POSE)

#define	PIS_CH1_CON_SRCS_POSS	8U 
#define	PIS_CH1_CON_SRCS_POSE	13U 
#define	PIS_CH1_CON_SRCS_MSK	BITS(PIS_CH1_CON_SRCS_POSS,PIS_CH1_CON_SRCS_POSE)

#define	PIS_CH1_CON_MSIGS_POSS	0U 
#define	PIS_CH1_CON_MSIGS_POSE	3U 
#define	PIS_CH1_CON_MSIGS_MSK	BITS(PIS_CH1_CON_MSIGS_POSS,PIS_CH1_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH2_CON register ************************/

#define	PIS_CH2_CON_SYNCSEL_POSS	24U 
#define	PIS_CH2_CON_SYNCSEL_POSE	26U 
#define	PIS_CH2_CON_SYNCSEL_MSK	BITS(PIS_CH2_CON_SYNCSEL_POSS,PIS_CH2_CON_SYNCSEL_POSE)

#define	PIS_CH2_CON_PULCK_POSS	18U 
#define	PIS_CH2_CON_PULCK_POSE	19U 
#define	PIS_CH2_CON_PULCK_MSK	BITS(PIS_CH2_CON_PULCK_POSS,PIS_CH2_CON_PULCK_POSE)

#define	PIS_CH2_CON_EDGS_POSS	16U 
#define	PIS_CH2_CON_EDGS_POSE	17U 
#define	PIS_CH2_CON_EDGS_MSK	BITS(PIS_CH2_CON_EDGS_POSS,PIS_CH2_CON_EDGS_POSE)

#define	PIS_CH2_CON_SRCS_POSS	8U 
#define	PIS_CH2_CON_SRCS_POSE	13U 
#define	PIS_CH2_CON_SRCS_MSK	BITS(PIS_CH2_CON_SRCS_POSS,PIS_CH2_CON_SRCS_POSE)

#define	PIS_CH2_CON_MSIGS_POSS	0U 
#define	PIS_CH2_CON_MSIGS_POSE	3U 
#define	PIS_CH2_CON_MSIGS_MSK	BITS(PIS_CH2_CON_MSIGS_POSS,PIS_CH2_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH3_CON register ************************/

#define	PIS_CH3_CON_SYNCSEL_POSS	24U 
#define	PIS_CH3_CON_SYNCSEL_POSE	26U 
#define	PIS_CH3_CON_SYNCSEL_MSK	BITS(PIS_CH3_CON_SYNCSEL_POSS,PIS_CH3_CON_SYNCSEL_POSE)

#define	PIS_CH3_CON_PULCK_POSS	18U 
#define	PIS_CH3_CON_PULCK_POSE	19U 
#define	PIS_CH3_CON_PULCK_MSK	BITS(PIS_CH3_CON_PULCK_POSS,PIS_CH3_CON_PULCK_POSE)

#define	PIS_CH3_CON_EDGS_POSS	16U 
#define	PIS_CH3_CON_EDGS_POSE	17U 
#define	PIS_CH3_CON_EDGS_MSK	BITS(PIS_CH3_CON_EDGS_POSS,PIS_CH3_CON_EDGS_POSE)

#define	PIS_CH3_CON_SRCS_POSS	8U 
#define	PIS_CH3_CON_SRCS_POSE	13U 
#define	PIS_CH3_CON_SRCS_MSK	BITS(PIS_CH3_CON_SRCS_POSS,PIS_CH3_CON_SRCS_POSE)

#define	PIS_CH3_CON_MSIGS_POSS	0U 
#define	PIS_CH3_CON_MSIGS_POSE	3U 
#define	PIS_CH3_CON_MSIGS_MSK	BITS(PIS_CH3_CON_MSIGS_POSS,PIS_CH3_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH4_CON register ************************/

#define	PIS_CH4_CON_SYNCSEL_POSS	24U 
#define	PIS_CH4_CON_SYNCSEL_POSE	26U 
#define	PIS_CH4_CON_SYNCSEL_MSK	BITS(PIS_CH4_CON_SYNCSEL_POSS,PIS_CH4_CON_SYNCSEL_POSE)

#define	PIS_CH4_CON_PULCK_POSS	18U 
#define	PIS_CH4_CON_PULCK_POSE	19U 
#define	PIS_CH4_CON_PULCK_MSK	BITS(PIS_CH4_CON_PULCK_POSS,PIS_CH4_CON_PULCK_POSE)

#define	PIS_CH4_CON_EDGS_POSS	16U 
#define	PIS_CH4_CON_EDGS_POSE	17U 
#define	PIS_CH4_CON_EDGS_MSK	BITS(PIS_CH4_CON_EDGS_POSS,PIS_CH4_CON_EDGS_POSE)

#define	PIS_CH4_CON_SRCS_POSS	8U 
#define	PIS_CH4_CON_SRCS_POSE	13U 
#define	PIS_CH4_CON_SRCS_MSK	BITS(PIS_CH4_CON_SRCS_POSS,PIS_CH4_CON_SRCS_POSE)

#define	PIS_CH4_CON_MSIGS_POSS	0U 
#define	PIS_CH4_CON_MSIGS_POSE	3U 
#define	PIS_CH4_CON_MSIGS_MSK	BITS(PIS_CH4_CON_MSIGS_POSS,PIS_CH4_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH5_CON register ************************/

#define	PIS_CH5_CON_SYNCSEL_POSS	24U 
#define	PIS_CH5_CON_SYNCSEL_POSE	26U 
#define	PIS_CH5_CON_SYNCSEL_MSK	BITS(PIS_CH5_CON_SYNCSEL_POSS,PIS_CH5_CON_SYNCSEL_POSE)

#define	PIS_CH5_CON_PULCK_POSS	18U 
#define	PIS_CH5_CON_PULCK_POSE	19U 
#define	PIS_CH5_CON_PULCK_MSK	BITS(PIS_CH5_CON_PULCK_POSS,PIS_CH5_CON_PULCK_POSE)

#define	PIS_CH5_CON_EDGS_POSS	16U 
#define	PIS_CH5_CON_EDGS_POSE	17U 
#define	PIS_CH5_CON_EDGS_MSK	BITS(PIS_CH5_CON_EDGS_POSS,PIS_CH5_CON_EDGS_POSE)

#define	PIS_CH5_CON_SRCS_POSS	8U 
#define	PIS_CH5_CON_SRCS_POSE	13U 
#define	PIS_CH5_CON_SRCS_MSK	BITS(PIS_CH5_CON_SRCS_POSS,PIS_CH5_CON_SRCS_POSE)

#define	PIS_CH5_CON_MSIGS_POSS	0U 
#define	PIS_CH5_CON_MSIGS_POSE	3U 
#define	PIS_CH5_CON_MSIGS_MSK	BITS(PIS_CH5_CON_MSIGS_POSS,PIS_CH5_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH6_CON register ************************/

#define	PIS_CH6_CON_SYNCSEL_POSS	24U 
#define	PIS_CH6_CON_SYNCSEL_POSE	26U 
#define	PIS_CH6_CON_SYNCSEL_MSK	BITS(PIS_CH6_CON_SYNCSEL_POSS,PIS_CH6_CON_SYNCSEL_POSE)

#define	PIS_CH6_CON_PULCK_POSS	18U 
#define	PIS_CH6_CON_PULCK_POSE	19U 
#define	PIS_CH6_CON_PULCK_MSK	BITS(PIS_CH6_CON_PULCK_POSS,PIS_CH6_CON_PULCK_POSE)

#define	PIS_CH6_CON_EDGS_POSS	16U 
#define	PIS_CH6_CON_EDGS_POSE	17U 
#define	PIS_CH6_CON_EDGS_MSK	BITS(PIS_CH6_CON_EDGS_POSS,PIS_CH6_CON_EDGS_POSE)

#define	PIS_CH6_CON_SRCS_POSS	8U 
#define	PIS_CH6_CON_SRCS_POSE	13U 
#define	PIS_CH6_CON_SRCS_MSK	BITS(PIS_CH6_CON_SRCS_POSS,PIS_CH6_CON_SRCS_POSE)

#define	PIS_CH6_CON_MSIGS_POSS	0U 
#define	PIS_CH6_CON_MSIGS_POSE	3U 
#define	PIS_CH6_CON_MSIGS_MSK	BITS(PIS_CH6_CON_MSIGS_POSS,PIS_CH6_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH7_CON register ************************/

#define	PIS_CH7_CON_SYNCSEL_POSS	24U 
#define	PIS_CH7_CON_SYNCSEL_POSE	26U 
#define	PIS_CH7_CON_SYNCSEL_MSK	BITS(PIS_CH7_CON_SYNCSEL_POSS,PIS_CH7_CON_SYNCSEL_POSE)

#define	PIS_CH7_CON_PULCK_POSS	18U 
#define	PIS_CH7_CON_PULCK_POSE	19U 
#define	PIS_CH7_CON_PULCK_MSK	BITS(PIS_CH7_CON_PULCK_POSS,PIS_CH7_CON_PULCK_POSE)

#define	PIS_CH7_CON_EDGS_POSS	16U 
#define	PIS_CH7_CON_EDGS_POSE	17U 
#define	PIS_CH7_CON_EDGS_MSK	BITS(PIS_CH7_CON_EDGS_POSS,PIS_CH7_CON_EDGS_POSE)

#define	PIS_CH7_CON_SRCS_POSS	8U 
#define	PIS_CH7_CON_SRCS_POSE	13U 
#define	PIS_CH7_CON_SRCS_MSK	BITS(PIS_CH7_CON_SRCS_POSS,PIS_CH7_CON_SRCS_POSE)

#define	PIS_CH7_CON_MSIGS_POSS	0U 
#define	PIS_CH7_CON_MSIGS_POSE	3U 
#define	PIS_CH7_CON_MSIGS_MSK	BITS(PIS_CH7_CON_MSIGS_POSS,PIS_CH7_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH8_CON register ************************/

#define	PIS_CH8_CON_SYNCSEL_POSS	24U 
#define	PIS_CH8_CON_SYNCSEL_POSE	26U 
#define	PIS_CH8_CON_SYNCSEL_MSK	BITS(PIS_CH8_CON_SYNCSEL_POSS,PIS_CH8_CON_SYNCSEL_POSE)

#define	PIS_CH8_CON_PULCK_POSS	18U 
#define	PIS_CH8_CON_PULCK_POSE	19U 
#define	PIS_CH8_CON_PULCK_MSK	BITS(PIS_CH8_CON_PULCK_POSS,PIS_CH8_CON_PULCK_POSE)

#define	PIS_CH8_CON_EDGS_POSS	16U 
#define	PIS_CH8_CON_EDGS_POSE	17U 
#define	PIS_CH8_CON_EDGS_MSK	BITS(PIS_CH8_CON_EDGS_POSS,PIS_CH8_CON_EDGS_POSE)

#define	PIS_CH8_CON_SRCS_POSS	8U 
#define	PIS_CH8_CON_SRCS_POSE	13U 
#define	PIS_CH8_CON_SRCS_MSK	BITS(PIS_CH8_CON_SRCS_POSS,PIS_CH8_CON_SRCS_POSE)

#define	PIS_CH8_CON_MSIGS_POSS	0U 
#define	PIS_CH8_CON_MSIGS_POSE	3U 
#define	PIS_CH8_CON_MSIGS_MSK	BITS(PIS_CH8_CON_MSIGS_POSS,PIS_CH8_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH9_CON register ************************/

#define	PIS_CH9_CON_SYNCSEL_POSS	24U 
#define	PIS_CH9_CON_SYNCSEL_POSE	26U 
#define	PIS_CH9_CON_SYNCSEL_MSK	BITS(PIS_CH9_CON_SYNCSEL_POSS,PIS_CH9_CON_SYNCSEL_POSE)

#define	PIS_CH9_CON_PULCK_POSS	18U 
#define	PIS_CH9_CON_PULCK_POSE	19U 
#define	PIS_CH9_CON_PULCK_MSK	BITS(PIS_CH9_CON_PULCK_POSS,PIS_CH9_CON_PULCK_POSE)

#define	PIS_CH9_CON_EDGS_POSS	16U 
#define	PIS_CH9_CON_EDGS_POSE	17U 
#define	PIS_CH9_CON_EDGS_MSK	BITS(PIS_CH9_CON_EDGS_POSS,PIS_CH9_CON_EDGS_POSE)

#define	PIS_CH9_CON_SRCS_POSS	8U 
#define	PIS_CH9_CON_SRCS_POSE	13U 
#define	PIS_CH9_CON_SRCS_MSK	BITS(PIS_CH9_CON_SRCS_POSS,PIS_CH9_CON_SRCS_POSE)

#define	PIS_CH9_CON_MSIGS_POSS	0U 
#define	PIS_CH9_CON_MSIGS_POSE	3U 
#define	PIS_CH9_CON_MSIGS_MSK	BITS(PIS_CH9_CON_MSIGS_POSS,PIS_CH9_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH10_CON register ************************/

#define	PIS_CH10_CON_SYNCSEL_POSS	24U 
#define	PIS_CH10_CON_SYNCSEL_POSE	26U 
#define	PIS_CH10_CON_SYNCSEL_MSK	BITS(PIS_CH10_CON_SYNCSEL_POSS,PIS_CH10_CON_SYNCSEL_POSE)

#define	PIS_CH10_CON_PULCK_POSS	18U 
#define	PIS_CH10_CON_PULCK_POSE	19U 
#define	PIS_CH10_CON_PULCK_MSK	BITS(PIS_CH10_CON_PULCK_POSS,PIS_CH10_CON_PULCK_POSE)

#define	PIS_CH10_CON_EDGS_POSS	16U 
#define	PIS_CH10_CON_EDGS_POSE	17U 
#define	PIS_CH10_CON_EDGS_MSK	BITS(PIS_CH10_CON_EDGS_POSS,PIS_CH10_CON_EDGS_POSE)

#define	PIS_CH10_CON_SRCS_POSS	8U 
#define	PIS_CH10_CON_SRCS_POSE	13U 
#define	PIS_CH10_CON_SRCS_MSK	BITS(PIS_CH10_CON_SRCS_POSS,PIS_CH10_CON_SRCS_POSE)

#define	PIS_CH10_CON_MSIGS_POSS	0U 
#define	PIS_CH10_CON_MSIGS_POSE	3U 
#define	PIS_CH10_CON_MSIGS_MSK	BITS(PIS_CH10_CON_MSIGS_POSS,PIS_CH10_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH11_CON register ************************/

#define	PIS_CH11_CON_SYNCSEL_POSS	24U 
#define	PIS_CH11_CON_SYNCSEL_POSE	26U 
#define	PIS_CH11_CON_SYNCSEL_MSK	BITS(PIS_CH11_CON_SYNCSEL_POSS,PIS_CH11_CON_SYNCSEL_POSE)

#define	PIS_CH11_CON_PULCK_POSS	18U 
#define	PIS_CH11_CON_PULCK_POSE	19U 
#define	PIS_CH11_CON_PULCK_MSK	BITS(PIS_CH11_CON_PULCK_POSS,PIS_CH11_CON_PULCK_POSE)

#define	PIS_CH11_CON_EDGS_POSS	16U 
#define	PIS_CH11_CON_EDGS_POSE	17U 
#define	PIS_CH11_CON_EDGS_MSK	BITS(PIS_CH11_CON_EDGS_POSS,PIS_CH11_CON_EDGS_POSE)

#define	PIS_CH11_CON_SRCS_POSS	8U 
#define	PIS_CH11_CON_SRCS_POSE	13U 
#define	PIS_CH11_CON_SRCS_MSK	BITS(PIS_CH11_CON_SRCS_POSS,PIS_CH11_CON_SRCS_POSE)

#define	PIS_CH11_CON_MSIGS_POSS	0U 
#define	PIS_CH11_CON_MSIGS_POSE	3U 
#define	PIS_CH11_CON_MSIGS_MSK	BITS(PIS_CH11_CON_MSIGS_POSS,PIS_CH11_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH12_CON register ************************/

#define	PIS_CH12_CON_SYNCSEL_POSS	24U 
#define	PIS_CH12_CON_SYNCSEL_POSE	26U 
#define	PIS_CH12_CON_SYNCSEL_MSK	BITS(PIS_CH12_CON_SYNCSEL_POSS,PIS_CH12_CON_SYNCSEL_POSE)

#define	PIS_CH12_CON_PULCK_POSS	18U 
#define	PIS_CH12_CON_PULCK_POSE	19U 
#define	PIS_CH12_CON_PULCK_MSK	BITS(PIS_CH12_CON_PULCK_POSS,PIS_CH12_CON_PULCK_POSE)

#define	PIS_CH12_CON_EDGS_POSS	16U 
#define	PIS_CH12_CON_EDGS_POSE	17U 
#define	PIS_CH12_CON_EDGS_MSK	BITS(PIS_CH12_CON_EDGS_POSS,PIS_CH12_CON_EDGS_POSE)

#define	PIS_CH12_CON_SRCS_POSS	8U 
#define	PIS_CH12_CON_SRCS_POSE	13U 
#define	PIS_CH12_CON_SRCS_MSK	BITS(PIS_CH12_CON_SRCS_POSS,PIS_CH12_CON_SRCS_POSE)

#define	PIS_CH12_CON_MSIGS_POSS	0U 
#define	PIS_CH12_CON_MSIGS_POSE	3U 
#define	PIS_CH12_CON_MSIGS_MSK	BITS(PIS_CH12_CON_MSIGS_POSS,PIS_CH12_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH13_CON register ************************/

#define	PIS_CH13_CON_SYNCSEL_POSS	24U 
#define	PIS_CH13_CON_SYNCSEL_POSE	26U 
#define	PIS_CH13_CON_SYNCSEL_MSK	BITS(PIS_CH13_CON_SYNCSEL_POSS,PIS_CH13_CON_SYNCSEL_POSE)

#define	PIS_CH13_CON_PULCK_POSS	18U 
#define	PIS_CH13_CON_PULCK_POSE	19U 
#define	PIS_CH13_CON_PULCK_MSK	BITS(PIS_CH13_CON_PULCK_POSS,PIS_CH13_CON_PULCK_POSE)

#define	PIS_CH13_CON_EDGS_POSS	16U 
#define	PIS_CH13_CON_EDGS_POSE	17U 
#define	PIS_CH13_CON_EDGS_MSK	BITS(PIS_CH13_CON_EDGS_POSS,PIS_CH13_CON_EDGS_POSE)

#define	PIS_CH13_CON_SRCS_POSS	8U 
#define	PIS_CH13_CON_SRCS_POSE	13U 
#define	PIS_CH13_CON_SRCS_MSK	BITS(PIS_CH13_CON_SRCS_POSS,PIS_CH13_CON_SRCS_POSE)

#define	PIS_CH13_CON_MSIGS_POSS	0U 
#define	PIS_CH13_CON_MSIGS_POSE	3U 
#define	PIS_CH13_CON_MSIGS_MSK	BITS(PIS_CH13_CON_MSIGS_POSS,PIS_CH13_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH14_CON register ************************/

#define	PIS_CH14_CON_SYNCSEL_POSS	24U 
#define	PIS_CH14_CON_SYNCSEL_POSE	26U 
#define	PIS_CH14_CON_SYNCSEL_MSK	BITS(PIS_CH14_CON_SYNCSEL_POSS,PIS_CH14_CON_SYNCSEL_POSE)

#define	PIS_CH14_CON_PULCK_POSS	18U 
#define	PIS_CH14_CON_PULCK_POSE	19U 
#define	PIS_CH14_CON_PULCK_MSK	BITS(PIS_CH14_CON_PULCK_POSS,PIS_CH14_CON_PULCK_POSE)

#define	PIS_CH14_CON_EDGS_POSS	16U 
#define	PIS_CH14_CON_EDGS_POSE	17U 
#define	PIS_CH14_CON_EDGS_MSK	BITS(PIS_CH14_CON_EDGS_POSS,PIS_CH14_CON_EDGS_POSE)

#define	PIS_CH14_CON_SRCS_POSS	8U 
#define	PIS_CH14_CON_SRCS_POSE	13U 
#define	PIS_CH14_CON_SRCS_MSK	BITS(PIS_CH14_CON_SRCS_POSS,PIS_CH14_CON_SRCS_POSE)

#define	PIS_CH14_CON_MSIGS_POSS	0U 
#define	PIS_CH14_CON_MSIGS_POSE	3U 
#define	PIS_CH14_CON_MSIGS_MSK	BITS(PIS_CH14_CON_MSIGS_POSS,PIS_CH14_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH15_CON register ************************/

#define	PIS_CH15_CON_SYNCSEL_POSS	24U 
#define	PIS_CH15_CON_SYNCSEL_POSE	26U 
#define	PIS_CH15_CON_SYNCSEL_MSK	BITS(PIS_CH15_CON_SYNCSEL_POSS,PIS_CH15_CON_SYNCSEL_POSE)

#define	PIS_CH15_CON_PULCK_POSS	18U 
#define	PIS_CH15_CON_PULCK_POSE	19U 
#define	PIS_CH15_CON_PULCK_MSK	BITS(PIS_CH15_CON_PULCK_POSS,PIS_CH15_CON_PULCK_POSE)

#define	PIS_CH15_CON_EDGS_POSS	16U 
#define	PIS_CH15_CON_EDGS_POSE	17U 
#define	PIS_CH15_CON_EDGS_MSK	BITS(PIS_CH15_CON_EDGS_POSS,PIS_CH15_CON_EDGS_POSE)

#define	PIS_CH15_CON_SRCS_POSS	8U 
#define	PIS_CH15_CON_SRCS_POSE	13U 
#define	PIS_CH15_CON_SRCS_MSK	BITS(PIS_CH15_CON_SRCS_POSS,PIS_CH15_CON_SRCS_POSE)

#define	PIS_CH15_CON_MSIGS_POSS	0U 
#define	PIS_CH15_CON_MSIGS_POSE	3U 
#define	PIS_CH15_CON_MSIGS_MSK	BITS(PIS_CH15_CON_MSIGS_POSS,PIS_CH15_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH_OER register ************************/

#define	PIS_CH_OER_CH3OE_POS	3U 
#define	PIS_CH_OER_CH3OE_MSK	BIT(PIS_CH_OER_CH3OE_POS)

#define	PIS_CH_OER_CH2OE_POS	2U 
#define	PIS_CH_OER_CH2OE_MSK	BIT(PIS_CH_OER_CH2OE_POS)

#define	PIS_CH_OER_CH1OE_POS	1U 
#define	PIS_CH_OER_CH1OE_MSK	BIT(PIS_CH_OER_CH1OE_POS)

#define	PIS_CH_OER_CH0OE_POS	0U 
#define	PIS_CH_OER_CH0OE_MSK	BIT(PIS_CH_OER_CH0OE_POS)

/****************** Bit definition for PIS_TAR_CON0 register ************************/

#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_POS	27U 
#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_POS	26U 
#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_POS	25U 
#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_POS	24U 
#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_POS	19U 
#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_POS	18U 
#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_POS	17U 
#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_POS	16U 
#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_POS	12U 
#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_POS	11U 
#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_POS	10U 
#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_POS	9U 
#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_POS	8U 
#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_POS	4U 
#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_POS	3U 
#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_POS	2U 
#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_POS	1U 
#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_POS	0U 
#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH1IN_SEL_POS)

/****************** Bit definition for PIS_TAR_CON1 register ************************/

#define	PIS_TAR_CON1_SPI1_CLK_SEL_POS	15U 
#define	PIS_TAR_CON1_SPI1_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI1_RX_SEL_POS	14U 
#define	PIS_TAR_CON1_SPI1_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_RX_SEL_POS)

#define	PIS_TAR_CON1_SPI0_CLK_SEL_POS	13U 
#define	PIS_TAR_CON1_SPI0_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI0_RX_SEL_POS	12U 
#define	PIS_TAR_CON1_SPI0_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_RX_SEL_POS)

#define	PIS_TAR_CON1_LPUART0_RXD_SEL_POS	8U 
#define	PIS_TAR_CON1_LPUART0_RXD_SEL_MSK	BIT(PIS_TAR_CON1_LPUART0_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART5_RXD_SEL_POS	7U 
#define	PIS_TAR_CON1_UART5_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART5_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART4_RXD_SEL_POS	6U 
#define	PIS_TAR_CON1_UART4_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART4_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART3_RXD_SEL_POS	3U 
#define	PIS_TAR_CON1_UART3_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART3_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART2_RXD_SEL_POS	2U 
#define	PIS_TAR_CON1_UART2_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART2_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART1_RXD_SEL_POS	1U 
#define	PIS_TAR_CON1_UART1_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART1_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART0_RXD_SEL_POS	0U 
#define	PIS_TAR_CON1_UART0_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART0_RXD_SEL_POS)

/****************** Bit definition for PIS_UART0_TXMCR register ************************/

#define	PIS_UART0_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART0_TXMCR_TXMLVLS_MSK	BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define	PIS_UART0_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART0_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART0_TXMCR_TXMSS_MSK	BITS(PIS_UART0_TXMCR_TXMSS_POSS,PIS_UART0_TXMCR_TXMSS_POSE)

#define	PIS_UART0_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART0_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART0_TXMCR_TXSIGS_MSK	BITS(PIS_UART0_TXMCR_TXSIGS_POSS,PIS_UART0_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART1_TXMCR register ************************/

#define	PIS_UART1_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART1_TXMCR_TXMLVLS_MSK	BIT(PIS_UART1_TXMCR_TXMLVLS_POS)

#define	PIS_UART1_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART1_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART1_TXMCR_TXMSS_MSK	BITS(PIS_UART1_TXMCR_TXMSS_POSS,PIS_UART1_TXMCR_TXMSS_POSE)

#define	PIS_UART1_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART1_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART1_TXMCR_TXSIGS_MSK	BITS(PIS_UART1_TXMCR_TXSIGS_POSS,PIS_UART1_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART2_TXMCR register ************************/

#define	PIS_UART2_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART2_TXMCR_TXMLVLS_MSK	BIT(PIS_UART2_TXMCR_TXMLVLS_POS)

#define	PIS_UART2_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART2_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART2_TXMCR_TXMSS_MSK	BITS(PIS_UART2_TXMCR_TXMSS_POSS,PIS_UART2_TXMCR_TXMSS_POSE)

#define	PIS_UART2_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART2_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART2_TXMCR_TXSIGS_MSK	BITS(PIS_UART2_TXMCR_TXSIGS_POSS,PIS_UART2_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART3_TXMCR register ************************/

#define	PIS_UART3_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART3_TXMCR_TXMLVLS_MSK	BIT(PIS_UART3_TXMCR_TXMLVLS_POS)

#define	PIS_UART3_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART3_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART3_TXMCR_TXMSS_MSK	BITS(PIS_UART3_TXMCR_TXMSS_POSS,PIS_UART3_TXMCR_TXMSS_POSE)

#define	PIS_UART3_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART3_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART3_TXMCR_TXSIGS_MSK	BITS(PIS_UART3_TXMCR_TXSIGS_POSS,PIS_UART3_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_LPUART0_TXMCR register ************************/

#define	PIS_LPUART0_TXMCR_TXMLVLS_POS	8U 
#define	PIS_LPUART0_TXMCR_TXMLVLS_MSK	BIT(PIS_LPUART0_TXMCR_TXMLVLS_POS)

#define	PIS_LPUART0_TXMCR_TXMSS_POSS	4U 
#define	PIS_LPUART0_TXMCR_TXMSS_POSE	7U 
#define	PIS_LPUART0_TXMCR_TXMSS_MSK	BITS(PIS_LPUART0_TXMCR_TXMSS_POSS,PIS_LPUART0_TXMCR_TXMSS_POSE)

#define	PIS_LPUART0_TXMCR_TXSIGS_POSS	0U 
#define	PIS_LPUART0_TXMCR_TXSIGS_POSE	3U 
#define	PIS_LPUART0_TXMCR_TXSIGS_MSK	BITS(PIS_LPUART0_TXMCR_TXSIGS_POSS,PIS_LPUART0_TXMCR_TXSIGS_POSE)

typedef struct
{
	__IO uint32_t CH_CON[16];
	__IO uint32_t CH_OER;
	__IO uint32_t TAR_CON0;
	__IO uint32_t TAR_CON1;
	uint32_t RESERVED0[5] ;
	__IO uint32_t UART0_TXMCR;
	__IO uint32_t UART1_TXMCR;
	__IO uint32_t UART2_TXMCR;
	__IO uint32_t UART3_TXMCR;
	__IO uint32_t LPUART0_TXMCR;
} PIS_TypeDef;


/****************** Bit definition for GPIO_DIN register ************************/

#define	GPIO_DIN_DIN_POSS	0U 
#define	GPIO_DIN_DIN_POSE	15U 
#define	GPIO_DIN_DIN_MSK	BITS(GPIO_DIN_DIN_POSS,GPIO_DIN_DIN_POSE)

/****************** Bit definition for GPIO_DOUT register ************************/

#define	GPIO_DOUT_DOUT_POSS	0U 
#define	GPIO_DOUT_DOUT_POSE	15U 
#define	GPIO_DOUT_DOUT_MSK	BITS(GPIO_DOUT_DOUT_POSS,GPIO_DOUT_DOUT_POSE)

/****************** Bit definition for GPIO_BSRR register ************************/

#define	GPIO_BSRR_BRR_POSS	16U 
#define	GPIO_BSRR_BRR_POSE	31U 
#define	GPIO_BSRR_BRR_MSK	BITS(GPIO_BSRR_BRR_POSS,GPIO_BSRR_BRR_POSE)

#define	GPIO_BSRR_BSR_POSS	0U 
#define	GPIO_BSRR_BSR_POSE	15U 
#define	GPIO_BSRR_BSR_MSK	BITS(GPIO_BSRR_BSR_POSS,GPIO_BSRR_BSR_POSE)

/****************** Bit definition for GPIO_BIR register ************************/

#define	GPIO_BIR_BIR_POSS	0U 
#define	GPIO_BIR_BIR_POSE	15U 
#define	GPIO_BIR_BIR_MSK	BITS(GPIO_BIR_BIR_POSS,GPIO_BIR_BIR_POSE)

/****************** Bit definition for GPIO_MODE register ************************/

#define	GPIO_MODE_MODE_POSS	0U 
#define	GPIO_MODE_MODE_POSE	31U 
#define	GPIO_MODE_MODE_MSK	BITS(GPIO_MODE_MODE_POSS,GPIO_MODE_MODE_POSE)

/****************** Bit definition for GPIO_ODOS register ************************/

#define	GPIO_ODOS_ODOS_POSS	0U 
#define	GPIO_ODOS_ODOS_POSE	31U 
#define	GPIO_ODOS_ODOS_MSK	BITS(GPIO_ODOS_ODOS_POSS,GPIO_ODOS_ODOS_POSE)

/****************** Bit definition for GPIO_PUPD register ************************/

#define	GPIO_PUPD_PUPD_POSS	0U 
#define	GPIO_PUPD_PUPD_POSE	31U 
#define	GPIO_PUPD_PUPD_MSK	BITS(GPIO_PUPD_PUPD_POSS,GPIO_PUPD_PUPD_POSE)

/****************** Bit definition for GPIO_PODRV register ************************/

#define	GPIO_PODRV_PODRV_POSS	0U 
#define	GPIO_PODRV_PODRV_POSE	31U 
#define	GPIO_PODRV_PODRV_MSK	BITS(GPIO_PODRV_PODRV_POSS,GPIO_PODRV_PODRV_POSE)

/****************** Bit definition for GPIO_NODRV register ************************/

#define	GPIO_NODRV_NODRV_POSS	0U 
#define	GPIO_NODRV_NODRV_POSE	31U 
#define	GPIO_NODRV_NODRV_MSK	BITS(GPIO_NODRV_NODRV_POSS,GPIO_NODRV_NODRV_POSE)

/****************** Bit definition for GPIO_FLT register ************************/

#define	GPIO_FLT_FLT_POSS	0U 
#define	GPIO_FLT_FLT_POSE	15U 
#define	GPIO_FLT_FLT_MSK	BITS(GPIO_FLT_FLT_POSS,GPIO_FLT_FLT_POSE)

/****************** Bit definition for GPIO_TYPE register ************************/

#define	GPIO_TYPE_TYPE_POSS	0U 
#define	GPIO_TYPE_TYPE_POSE	15U 
#define	GPIO_TYPE_TYPE_MSK	BITS(GPIO_TYPE_TYPE_POSS,GPIO_TYPE_TYPE_POSE)

/****************** Bit definition for GPIO_FUNC0 register ************************/

#define	GPIO_FUNC0_FSEL_IO7_POSS	28U 
#define	GPIO_FUNC0_FSEL_IO7_POSE	31U 
#define	GPIO_FUNC0_FSEL_IO7_MSK	BITS(GPIO_FUNC0_FSEL_IO7_POSS,GPIO_FUNC0_FSEL_IO7_POSE)

#define	GPIO_FUNC0_FSEL_IO6_POSS	24U 
#define	GPIO_FUNC0_FSEL_IO6_POSE	27U 
#define	GPIO_FUNC0_FSEL_IO6_MSK	BITS(GPIO_FUNC0_FSEL_IO6_POSS,GPIO_FUNC0_FSEL_IO6_POSE)

#define	GPIO_FUNC0_FSEL_IO5_POSS	20U 
#define	GPIO_FUNC0_FSEL_IO5_POSE	23U 
#define	GPIO_FUNC0_FSEL_IO5_MSK	BITS(GPIO_FUNC0_FSEL_IO5_POSS,GPIO_FUNC0_FSEL_IO5_POSE)

#define	GPIO_FUNC0_FSEL_IO4_POSS	16U 
#define	GPIO_FUNC0_FSEL_IO4_POSE	19U 
#define	GPIO_FUNC0_FSEL_IO4_MSK	BITS(GPIO_FUNC0_FSEL_IO4_POSS,GPIO_FUNC0_FSEL_IO4_POSE)

#define	GPIO_FUNC0_FSEL_IO3_POSS	12U 
#define	GPIO_FUNC0_FSEL_IO3_POSE	15U 
#define	GPIO_FUNC0_FSEL_IO3_MSK	BITS(GPIO_FUNC0_FSEL_IO3_POSS,GPIO_FUNC0_FSEL_IO3_POSE)

#define	GPIO_FUNC0_FSEL_IO2_POSS	8U 
#define	GPIO_FUNC0_FSEL_IO2_POSE	11U 
#define	GPIO_FUNC0_FSEL_IO2_MSK	BITS(GPIO_FUNC0_FSEL_IO2_POSS,GPIO_FUNC0_FSEL_IO2_POSE)

#define	GPIO_FUNC0_FSEL_IO1_POSS	4U 
#define	GPIO_FUNC0_FSEL_IO1_POSE	7U 
#define	GPIO_FUNC0_FSEL_IO1_MSK	BITS(GPIO_FUNC0_FSEL_IO1_POSS,GPIO_FUNC0_FSEL_IO1_POSE)

#define	GPIO_FUNC0_FSEL_IO0_POSS	0U 
#define	GPIO_FUNC0_FSEL_IO0_POSE	3U 
#define	GPIO_FUNC0_FSEL_IO0_MSK	BITS(GPIO_FUNC0_FSEL_IO0_POSS,GPIO_FUNC0_FSEL_IO0_POSE)

/****************** Bit definition for GPIO_FUNC1 register ************************/

#define	GPIO_FUNC1_FSEL_IO15_POSS	28U 
#define	GPIO_FUNC1_FSEL_IO15_POSE	31U 
#define	GPIO_FUNC1_FSEL_IO15_MSK	BITS(GPIO_FUNC1_FSEL_IO15_POSS,GPIO_FUNC1_FSEL_IO15_POSE)

#define	GPIO_FUNC1_FSEL_IO14_POSS	24U 
#define	GPIO_FUNC1_FSEL_IO14_POSE	27U 
#define	GPIO_FUNC1_FSEL_IO14_MSK	BITS(GPIO_FUNC1_FSEL_IO14_POSS,GPIO_FUNC1_FSEL_IO14_POSE)

#define	GPIO_FUNC1_FSEL_IO13_POSS	20U 
#define	GPIO_FUNC1_FSEL_IO13_POSE	23U 
#define	GPIO_FUNC1_FSEL_IO13_MSK	BITS(GPIO_FUNC1_FSEL_IO13_POSS,GPIO_FUNC1_FSEL_IO13_POSE)

#define	GPIO_FUNC1_FSEL_IO12_POSS	16U 
#define	GPIO_FUNC1_FSEL_IO12_POSE	19U 
#define	GPIO_FUNC1_FSEL_IO12_MSK	BITS(GPIO_FUNC1_FSEL_IO12_POSS,GPIO_FUNC1_FSEL_IO12_POSE)

#define	GPIO_FUNC1_FSEL_IO11_POSS	12U 
#define	GPIO_FUNC1_FSEL_IO11_POSE	15U 
#define	GPIO_FUNC1_FSEL_IO11_MSK	BITS(GPIO_FUNC1_FSEL_IO11_POSS,GPIO_FUNC1_FSEL_IO11_POSE)

#define	GPIO_FUNC1_FSEL_IO10_POSS	8U 
#define	GPIO_FUNC1_FSEL_IO10_POSE	11U 
#define	GPIO_FUNC1_FSEL_IO10_MSK	BITS(GPIO_FUNC1_FSEL_IO10_POSS,GPIO_FUNC1_FSEL_IO10_POSE)

#define	GPIO_FUNC1_FSEL_IO9_POSS	4U 
#define	GPIO_FUNC1_FSEL_IO9_POSE	7U 
#define	GPIO_FUNC1_FSEL_IO9_MSK	BITS(GPIO_FUNC1_FSEL_IO9_POSS,GPIO_FUNC1_FSEL_IO9_POSE)

#define	GPIO_FUNC1_FSEL_IO8_POSS	0U 
#define	GPIO_FUNC1_FSEL_IO8_POSE	3U 
#define	GPIO_FUNC1_FSEL_IO8_MSK	BITS(GPIO_FUNC1_FSEL_IO8_POSS,GPIO_FUNC1_FSEL_IO8_POSE)

/****************** Bit definition for GPIO_LOCK register ************************/

#define	GPIO_LOCK_KEY_POSS	16U 
#define	GPIO_LOCK_KEY_POSE	31U 
#define	GPIO_LOCK_KEY_MSK	BITS(GPIO_LOCK_KEY_POSS,GPIO_LOCK_KEY_POSE)

#define	GPIO_LOCK_LOCK_POSS	0U 
#define	GPIO_LOCK_LOCK_POSE	15U 
#define	GPIO_LOCK_LOCK_MSK	BITS(GPIO_LOCK_LOCK_POSS,GPIO_LOCK_LOCK_POSE)

typedef struct
{
	__I uint32_t DIN;
	__IO uint32_t DOUT;
	__O uint32_t BSRR;
	__O uint32_t BIR;
	__IO uint32_t MODE;
	__IO uint32_t ODOS;
	__IO uint32_t PUPD;
	__IO uint32_t PODRV;
	__IO uint32_t NODRV;
	__IO uint32_t FLT;
	__IO uint32_t TYPE;
	__IO uint32_t FUNC0;
	__IO uint32_t FUNC1;
	__IO uint32_t LOCK;
} GPIO_TypeDef;

/****************** Bit definition for GPIO_EXTIRER register ************************/

#define	GPIO_EXTIRER_EXTIRER_POSS	0U 
#define	GPIO_EXTIRER_EXTIRER_POSE	15U 
#define	GPIO_EXTIRER_EXTIRER_MSK	BITS(GPIO_EXTIRER_EXTIRER_POSS,GPIO_EXTIRER_EXTIRER_POSE)

/****************** Bit definition for GPIO_EXTIFER register ************************/

#define	GPIO_EXTIFER_EXTIFER_POSS	0U 
#define	GPIO_EXTIFER_EXTIFER_POSE	15U 
#define	GPIO_EXTIFER_EXTIFER_MSK	BITS(GPIO_EXTIFER_EXTIFER_POSS,GPIO_EXTIFER_EXTIFER_POSE)

/****************** Bit definition for GPIO_EXTIEN register ************************/

#define	GPIO_EXTIEN_EXTIEN_POSS	0U 
#define	GPIO_EXTIEN_EXTIEN_POSE	15U 
#define	GPIO_EXTIEN_EXTIEN_MSK	BITS(GPIO_EXTIEN_EXTIEN_POSS,GPIO_EXTIEN_EXTIEN_POSE)

/****************** Bit definition for GPIO_EXTIFLAG register ************************/

#define	GPIO_EXTIFLAG_EXTIFLAG_POSS	0U 
#define	GPIO_EXTIFLAG_EXTIFLAG_POSE	15U 
#define	GPIO_EXTIFLAG_EXTIFLAG_MSK	BITS(GPIO_EXTIFLAG_EXTIFLAG_POSS,GPIO_EXTIFLAG_EXTIFLAG_POSE)

/****************** Bit definition for GPIO_EXTISFR register ************************/

#define	GPIO_EXTISFR_EXTISFR_POSS	0U 
#define	GPIO_EXTISFR_EXTISFR_POSE	15U 
#define	GPIO_EXTISFR_EXTISFR_MSK	BITS(GPIO_EXTISFR_EXTISFR_POSS,GPIO_EXTISFR_EXTISFR_POSE)

/****************** Bit definition for GPIO_EXTICFR register ************************/

#define	GPIO_EXTICFR_EXTICFR_POSS	0U 
#define	GPIO_EXTICFR_EXTICFR_POSE	15U 
#define	GPIO_EXTICFR_EXTICFR_MSK	BITS(GPIO_EXTICFR_EXTICFR_POSS,GPIO_EXTICFR_EXTICFR_POSE)

/****************** Bit definition for GPIO_EXTIPSR0 register ************************/

#define	GPIO_EXTIPSR0_EXTIS7_POSS	28U 
#define	GPIO_EXTIPSR0_EXTIS7_POSE	30U 
#define	GPIO_EXTIPSR0_EXTIS7_MSK	BITS(GPIO_EXTIPSR0_EXTIS7_POSS,GPIO_EXTIPSR0_EXTIS7_POSE)

#define	GPIO_EXTIPSR0_EXTIS6_POSS	24U 
#define	GPIO_EXTIPSR0_EXTIS6_POSE	26U 
#define	GPIO_EXTIPSR0_EXTIS6_MSK	BITS(GPIO_EXTIPSR0_EXTIS6_POSS,GPIO_EXTIPSR0_EXTIS6_POSE)

#define	GPIO_EXTIPSR0_EXTIS5_POSS	20U 
#define	GPIO_EXTIPSR0_EXTIS5_POSE	22U 
#define	GPIO_EXTIPSR0_EXTIS5_MSK	BITS(GPIO_EXTIPSR0_EXTIS5_POSS,GPIO_EXTIPSR0_EXTIS5_POSE)

#define	GPIO_EXTIPSR0_EXTIS4_POSS	16U 
#define	GPIO_EXTIPSR0_EXTIS4_POSE	18U 
#define	GPIO_EXTIPSR0_EXTIS4_MSK	BITS(GPIO_EXTIPSR0_EXTIS4_POSS,GPIO_EXTIPSR0_EXTIS4_POSE)

#define	GPIO_EXTIPSR0_EXTIS3_POSS	12U 
#define	GPIO_EXTIPSR0_EXTIS3_POSE	14U 
#define	GPIO_EXTIPSR0_EXTIS3_MSK	BITS(GPIO_EXTIPSR0_EXTIS3_POSS,GPIO_EXTIPSR0_EXTIS3_POSE)

#define	GPIO_EXTIPSR0_EXTIS2_POSS	8U 
#define	GPIO_EXTIPSR0_EXTIS2_POSE	10U 
#define	GPIO_EXTIPSR0_EXTIS2_MSK	BITS(GPIO_EXTIPSR0_EXTIS2_POSS,GPIO_EXTIPSR0_EXTIS2_POSE)

#define	GPIO_EXTIPSR0_EXTIS1_POSS	4U 
#define	GPIO_EXTIPSR0_EXTIS1_POSE	6U 
#define	GPIO_EXTIPSR0_EXTIS1_MSK	BITS(GPIO_EXTIPSR0_EXTIS1_POSS,GPIO_EXTIPSR0_EXTIS1_POSE)

#define	GPIO_EXTIPSR0_EXTIS0_POSS	0U 
#define	GPIO_EXTIPSR0_EXTIS0_POSE	2U 
#define	GPIO_EXTIPSR0_EXTIS0_MSK	BITS(GPIO_EXTIPSR0_EXTIS0_POSS,GPIO_EXTIPSR0_EXTIS0_POSE)

/****************** Bit definition for GPIO_EXTIPSR1 register ************************/

#define	GPIO_EXTIPSR1_EXTIS15_POSS	28U 
#define	GPIO_EXTIPSR1_EXTIS15_POSE	30U 
#define	GPIO_EXTIPSR1_EXTIS15_MSK	BITS(GPIO_EXTIPSR1_EXTIS15_POSS,GPIO_EXTIPSR1_EXTIS15_POSE)

#define	GPIO_EXTIPSR1_EXTIS14_POSS	24U 
#define	GPIO_EXTIPSR1_EXTIS14_POSE	26U 
#define	GPIO_EXTIPSR1_EXTIS14_MSK	BITS(GPIO_EXTIPSR1_EXTIS14_POSS,GPIO_EXTIPSR1_EXTIS14_POSE)

#define	GPIO_EXTIPSR1_EXTIS13_POSS	20U 
#define	GPIO_EXTIPSR1_EXTIS13_POSE	22U 
#define	GPIO_EXTIPSR1_EXTIS13_MSK	BITS(GPIO_EXTIPSR1_EXTIS13_POSS,GPIO_EXTIPSR1_EXTIS13_POSE)

#define	GPIO_EXTIPSR1_EXTIS12_POSS	16U 
#define	GPIO_EXTIPSR1_EXTIS12_POSE	18U 
#define	GPIO_EXTIPSR1_EXTIS12_MSK	BITS(GPIO_EXTIPSR1_EXTIS12_POSS,GPIO_EXTIPSR1_EXTIS12_POSE)

#define	GPIO_EXTIPSR1_EXTIS11_POSS	12U 
#define	GPIO_EXTIPSR1_EXTIS11_POSE	14U 
#define	GPIO_EXTIPSR1_EXTIS11_MSK	BITS(GPIO_EXTIPSR1_EXTIS11_POSS,GPIO_EXTIPSR1_EXTIS11_POSE)

#define	GPIO_EXTIPSR1_EXTIS10_POSS	8U 
#define	GPIO_EXTIPSR1_EXTIS10_POSE	10U 
#define	GPIO_EXTIPSR1_EXTIS10_MSK	BITS(GPIO_EXTIPSR1_EXTIS10_POSS,GPIO_EXTIPSR1_EXTIS10_POSE)

#define	GPIO_EXTIPSR1_EXTIS9_POSS	4U 
#define	GPIO_EXTIPSR1_EXTIS9_POSE	6U 
#define	GPIO_EXTIPSR1_EXTIS9_MSK	BITS(GPIO_EXTIPSR1_EXTIS9_POSS,GPIO_EXTIPSR1_EXTIS9_POSE)

#define	GPIO_EXTIPSR1_EXTIS8_POSS	0U 
#define	GPIO_EXTIPSR1_EXTIS8_POSE	2U 
#define	GPIO_EXTIPSR1_EXTIS8_MSK	BITS(GPIO_EXTIPSR1_EXTIS8_POSS,GPIO_EXTIPSR1_EXTIS8_POSE)

/****************** Bit definition for GPIO_EXTIFLTCR register ************************/

#define	GPIO_EXTIFLTCR_FLTCKS_POSS	24U 
#define	GPIO_EXTIFLTCR_FLTCKS_POSE	25U 
#define	GPIO_EXTIFLTCR_FLTCKS_MSK	BITS(GPIO_EXTIFLTCR_FLTCKS_POSS,GPIO_EXTIFLTCR_FLTCKS_POSE)

#define	GPIO_EXTIFLTCR_FLTSEL_POSS	16U 
#define	GPIO_EXTIFLTCR_FLTSEL_POSE	23U 
#define	GPIO_EXTIFLTCR_FLTSEL_MSK	BITS(GPIO_EXTIFLTCR_FLTSEL_POSS,GPIO_EXTIFLTCR_FLTSEL_POSE)

#define	GPIO_EXTIFLTCR_FLTEN_POSS	0U 
#define	GPIO_EXTIFLTCR_FLTEN_POSE	15U 
#define	GPIO_EXTIFLTCR_FLTEN_MSK	BITS(GPIO_EXTIFLTCR_FLTEN_POSS,GPIO_EXTIFLTCR_FLTEN_POSE)

typedef struct
{
	__IO uint32_t EXTIRER;
	uint32_t RESERVED0 ;
	__IO uint32_t EXTIFER;
	uint32_t RESERVED1 ;
	__IO uint32_t EXTIEN;
	uint32_t RESERVED2 ;
	__I uint32_t EXTIFLAG;
	uint32_t RESERVED3 ;
	__O uint32_t EXTISFR;
	uint32_t RESERVED4 ;
	__O uint32_t EXTICFR;
	uint32_t RESERVED5 ;
	__IO uint32_t EXTIPSR0;
	__IO uint32_t EXTIPSR1;
	uint32_t RESERVED6[2] ;
	__IO uint32_t EXTIFLTCR;
} EXTI_TypeDef;

/****************** Bit definition for RTC_WPR register ************************/

#define	RTC_WPR_WP_POS	0U 
#define	RTC_WPR_WP_MSK	BIT(RTC_WPR_WP_POS)

/****************** Bit definition for RTC_CON register ************************/

#define	RTC_CON_SSEC_POS	25U 
#define	RTC_CON_SSEC_MSK	BIT(RTC_CON_SSEC_POS)

#define	RTC_CON_BUSY_POS	24U 
#define	RTC_CON_BUSY_MSK	BIT(RTC_CON_BUSY_POS)

#define	RTC_CON_POL_POS	22U 
#define	RTC_CON_POL_MSK	BIT(RTC_CON_POL_POS)

#define	RTC_CON_EOS_POSS	20U 
#define	RTC_CON_EOS_POSE	21U 
#define	RTC_CON_EOS_MSK	BITS(RTC_CON_EOS_POSS,RTC_CON_EOS_POSE)

#define	RTC_CON_CKOS_POSS	17U 
#define	RTC_CON_CKOS_POSE	19U 
#define	RTC_CON_CKOS_MSK	BITS(RTC_CON_CKOS_POSS,RTC_CON_CKOS_POSE)

#define	RTC_CON_CKOE_POS	16U 
#define	RTC_CON_CKOE_MSK	BIT(RTC_CON_CKOE_POS)

#define	RTC_CON_WUCKS_POSS	13U 
#define	RTC_CON_WUCKS_POSE	15U 
#define	RTC_CON_WUCKS_MSK	BITS(RTC_CON_WUCKS_POSS,RTC_CON_WUCKS_POSE)

#define	RTC_CON_WUTE_POS	12U 
#define	RTC_CON_WUTE_MSK	BIT(RTC_CON_WUTE_POS)

#define	RTC_CON_DSTS_POS	10U 
#define	RTC_CON_DSTS_MSK	BIT(RTC_CON_DSTS_POS)

#define	RTC_CON_SUB1H_POS	9U 
#define	RTC_CON_SUB1H_MSK	BIT(RTC_CON_SUB1H_POS)

#define	RTC_CON_ADD1H_POS	8U 
#define	RTC_CON_ADD1H_MSK	BIT(RTC_CON_ADD1H_POS)

#define	RTC_CON_TSPIN_POS	7U 
#define	RTC_CON_TSPIN_MSK	BIT(RTC_CON_TSPIN_POS)

#define	RTC_CON_TSSEL_POS	6U 
#define	RTC_CON_TSSEL_MSK	BIT(RTC_CON_TSSEL_POS)

#define	RTC_CON_TSEN_POS	5U 
#define	RTC_CON_TSEN_MSK	BIT(RTC_CON_TSEN_POS)

#define	RTC_CON_SHDBP_POS	4U 
#define	RTC_CON_SHDBP_MSK	BIT(RTC_CON_SHDBP_POS)

#define	RTC_CON_HFM_POS	3U 
#define	RTC_CON_HFM_MSK	BIT(RTC_CON_HFM_POS)

#define	RTC_CON_ALMBEN_POS	2U 
#define	RTC_CON_ALMBEN_MSK	BIT(RTC_CON_ALMBEN_POS)

#define	RTC_CON_ALMAEN_POS	1U 
#define	RTC_CON_ALMAEN_MSK	BIT(RTC_CON_ALMAEN_POS)

#define	RTC_CON_GO_POS	0U 
#define	RTC_CON_GO_MSK	BIT(RTC_CON_GO_POS)

/****************** Bit definition for RTC_PSR register ************************/

#define	RTC_PSR_APRS_POSS	16U 
#define	RTC_PSR_APRS_POSE	22U 
#define	RTC_PSR_APRS_MSK	BITS(RTC_PSR_APRS_POSS,RTC_PSR_APRS_POSE)

#define	RTC_PSR_SPRS_POSS	0U 
#define	RTC_PSR_SPRS_POSE	14U 
#define	RTC_PSR_SPRS_MSK	BITS(RTC_PSR_SPRS_POSS,RTC_PSR_SPRS_POSE)

/****************** Bit definition for RTC_TAMPCON register ************************/

#define	RTC_TAMPCON_TAMPFLT_POSS	20U 
#define	RTC_TAMPCON_TAMPFLT_POSE	21U 
#define	RTC_TAMPCON_TAMPFLT_MSK	BITS(RTC_TAMPCON_TAMPFLT_POSS,RTC_TAMPCON_TAMPFLT_POSE)

#define	RTC_TAMPCON_TAMPCKS_POSS	17U 
#define	RTC_TAMPCON_TAMPCKS_POSE	19U 
#define	RTC_TAMPCON_TAMPCKS_MSK	BITS(RTC_TAMPCON_TAMPCKS_POSS,RTC_TAMPCON_TAMPCKS_POSE)

#define	RTC_TAMPCON_TAMPTS_POS	16U 
#define	RTC_TAMPCON_TAMPTS_MSK	BIT(RTC_TAMPCON_TAMPTS_POS)

#define	RTC_TAMPCON_TAMP1LV_POS	9U 
#define	RTC_TAMPCON_TAMP1LV_MSK	BIT(RTC_TAMPCON_TAMP1LV_POS)

#define	RTC_TAMPCON_TAMP1EN_POS	8U 
#define	RTC_TAMPCON_TAMP1EN_MSK	BIT(RTC_TAMPCON_TAMP1EN_POS)

#define	RTC_TAMPCON_TAMP0LV_POS	1U 
#define	RTC_TAMPCON_TAMP0LV_MSK	BIT(RTC_TAMPCON_TAMP0LV_POS)

#define	RTC_TAMPCON_TAMP0EN_POS	0U 
#define	RTC_TAMPCON_TAMP0EN_MSK	BIT(RTC_TAMPCON_TAMP0EN_POS)

/****************** Bit definition for RTC_TIME register ************************/

#define	RTC_TIME_PM_POS	22U 
#define	RTC_TIME_PM_MSK	BIT(RTC_TIME_PM_POS)

#define	RTC_TIME_HRT_POSS	20U 
#define	RTC_TIME_HRT_POSE	21U 
#define	RTC_TIME_HRT_MSK	BITS(RTC_TIME_HRT_POSS,RTC_TIME_HRT_POSE)

#define	RTC_TIME_HRU_POSS	16U 
#define	RTC_TIME_HRU_POSE	19U 
#define	RTC_TIME_HRU_MSK	BITS(RTC_TIME_HRU_POSS,RTC_TIME_HRU_POSE)

#define	RTC_TIME_MINT_POSS	12U 
#define	RTC_TIME_MINT_POSE	14U 
#define	RTC_TIME_MINT_MSK	BITS(RTC_TIME_MINT_POSS,RTC_TIME_MINT_POSE)

#define	RTC_TIME_MINU_POSS	8U 
#define	RTC_TIME_MINU_POSE	11U 
#define	RTC_TIME_MINU_MSK	BITS(RTC_TIME_MINU_POSS,RTC_TIME_MINU_POSE)

#define	RTC_TIME_SECT_POSS	4U 
#define	RTC_TIME_SECT_POSE	6U 
#define	RTC_TIME_SECT_MSK	BITS(RTC_TIME_SECT_POSS,RTC_TIME_SECT_POSE)

#define	RTC_TIME_SECU_POSS	0U 
#define	RTC_TIME_SECU_POSE	3U 
#define	RTC_TIME_SECU_MSK	BITS(RTC_TIME_SECU_POSS,RTC_TIME_SECU_POSE)

/****************** Bit definition for RTC_DATE register ************************/

#define	RTC_DATE_WD_POSS	24U 
#define	RTC_DATE_WD_POSE	26U 
#define	RTC_DATE_WD_MSK	BITS(RTC_DATE_WD_POSS,RTC_DATE_WD_POSE)

#define	RTC_DATE_YRT_POSS	20U 
#define	RTC_DATE_YRT_POSE	23U 
#define	RTC_DATE_YRT_MSK	BITS(RTC_DATE_YRT_POSS,RTC_DATE_YRT_POSE)

#define	RTC_DATE_YRU_POSS	16U 
#define	RTC_DATE_YRU_POSE	19U 
#define	RTC_DATE_YRU_MSK	BITS(RTC_DATE_YRU_POSS,RTC_DATE_YRU_POSE)

#define	RTC_DATE_MONT_POS	12U 
#define	RTC_DATE_MONT_MSK	BIT(RTC_DATE_MONT_POS)

#define	RTC_DATE_MONU_POSS	8U 
#define	RTC_DATE_MONU_POSE	11U 
#define	RTC_DATE_MONU_MSK	BITS(RTC_DATE_MONU_POSS,RTC_DATE_MONU_POSE)

#define	RTC_DATE_DAYT_POSS	4U 
#define	RTC_DATE_DAYT_POSE	5U 
#define	RTC_DATE_DAYT_MSK	BITS(RTC_DATE_DAYT_POSS,RTC_DATE_DAYT_POSE)

#define	RTC_DATE_DAYU_POSS	0U 
#define	RTC_DATE_DAYU_POSE	3U 
#define	RTC_DATE_DAYU_MSK	BITS(RTC_DATE_DAYU_POSS,RTC_DATE_DAYU_POSE)

/****************** Bit definition for RTC_SSEC register ************************/

#define	RTC_SSEC_VAL_POSS	0U 
#define	RTC_SSEC_VAL_POSE	15U 
#define	RTC_SSEC_VAL_MSK	BITS(RTC_SSEC_VAL_POSS,RTC_SSEC_VAL_POSE)

/****************** Bit definition for RTC_WUMAT register ************************/

#define	RTC_WUMAT_VAL_POSS	0U 
#define	RTC_WUMAT_VAL_POSE	15U 
#define	RTC_WUMAT_VAL_MSK	BITS(RTC_WUMAT_VAL_POSS,RTC_WUMAT_VAL_POSE)

/****************** Bit definition for RTC_ALMA register ************************/

#define	RTC_ALMA_WDS_POS	31U 
#define	RTC_ALMA_WDS_MSK	BIT(RTC_ALMA_WDS_POS)

#define	RTC_ALMA_DAWD_POSS	24U 
#define	RTC_ALMA_DAWD_POSE	30U 
#define	RTC_ALMA_DAWD_MSK	BITS(RTC_ALMA_DAWD_POSS,RTC_ALMA_DAWD_POSE)

#define RTC_ALMA_DAYMSK_POS	30U
#define RTC_ALMA_DAYMSK_MSK 	BIT(RTC_ALMA_DAYMSK_POS)

#define RTC_ALMA_DAWD_DAYT_POSS	28U
#define RTC_ALMA_DAWD_DAYT_POSE	29U
#define RTC_ALMA_DAWD_DAYT_MSK	BITS(RTC_ALMA_DAWD_DAYT_POSS, RTC_ALMA_DAWD_DAYT_POSE)

#define RTC_ALMA_DAWD_DAYU_POSS	24U
#define RTC_ALMA_DAWD_DAYU_POSE	27U
#define RTC_ALMA_DAWD_DAYU_MSK	BITS(RTC_ALMA_DAWD_DAYU_POSS, RTC_ALMA_DAWD_DAYU_POSE)

#define	RTC_ALMA_HRMSK_POS	23U 
#define	RTC_ALMA_HRMSK_MSK	BIT(RTC_ALMA_HRMSK_POS)

#define	RTC_ALMA_PM_POS	22U 
#define	RTC_ALMA_PM_MSK	BIT(RTC_ALMA_PM_POS)

#define	RTC_ALMA_HRT_POSS	20U 
#define	RTC_ALMA_HRT_POSE	21U 
#define	RTC_ALMA_HRT_MSK	BITS(RTC_ALMA_HRT_POSS,RTC_ALMA_HRT_POSE)

#define	RTC_ALMA_HRU_POSS	16U 
#define	RTC_ALMA_HRU_POSE	19U 
#define	RTC_ALMA_HRU_MSK	BITS(RTC_ALMA_HRU_POSS,RTC_ALMA_HRU_POSE)

#define	RTC_ALMA_MINMSK_POS	15U 
#define	RTC_ALMA_MINMSK_MSK	BIT(RTC_ALMA_MINMSK_POS)

#define	RTC_ALMA_MINT_POSS	12U 
#define	RTC_ALMA_MINT_POSE	14U 
#define	RTC_ALMA_MINT_MSK	BITS(RTC_ALMA_MINT_POSS,RTC_ALMA_MINT_POSE)

#define	RTC_ALMA_MINU_POSS	8U 
#define	RTC_ALMA_MINU_POSE	11U 
#define	RTC_ALMA_MINU_MSK	BITS(RTC_ALMA_MINU_POSS,RTC_ALMA_MINU_POSE)

#define	RTC_ALMA_SECMSK_POS	7U 
#define	RTC_ALMA_SECMSK_MSK	BIT(RTC_ALMA_SECMSK_POS)

#define	RTC_ALMA_SECT_POSS	4U 
#define	RTC_ALMA_SECT_POSE	6U 
#define	RTC_ALMA_SECT_MSK	BITS(RTC_ALMA_SECT_POSS,RTC_ALMA_SECT_POSE)

#define	RTC_ALMA_SECU_POSS	0U 
#define	RTC_ALMA_SECU_POSE	3U 
#define	RTC_ALMA_SECU_MSK	BITS(RTC_ALMA_SECU_POSS,RTC_ALMA_SECU_POSE)

/****************** Bit definition for RTC_ALMB register ************************/

#define	RTC_ALMB_WDS_POS	31U 
#define	RTC_ALMB_WDS_MSK	BIT(RTC_ALMB_WDS_POS)

#define	RTC_ALMB_DAWD_POSS	24U 
#define	RTC_ALMB_DAWD_POSE	30U 
#define	RTC_ALMB_DAWD_MSK	BITS(RTC_ALMB_DAWD_POSS,RTC_ALMB_DAWD_POSE)

#define RTC_ALMB_DAYMSK_POS	30U
#define RTC_ALMB_DAYMSK_MSK 	BIT(RTC_ALMB_DAYMSK_POS)

#define RTC_ALMB_DAWD_DAYT_POSS	28U
#define RTC_ALMB_DAWD_DAYT_POSE	29U
#define RTC_ALMB_DAWD_DAYT_MSK	BITS(RTC_ALMB_DAWD_DAYT_POSS, RTC_ALMB_DAWD_DAYT_POSE)

#define RTC_ALMB_DAWD_DAYU_POSS	24U
#define RTC_ALMB_DAWD_DAYU_POSE	27U
#define RTC_ALMB_DAWD_DAYU_MSK	BITS(RTC_ALMB_DAWD_DAYU_POSS, RTC_ALMB_DAWD_DAYU_POSE)

#define	RTC_ALMB_HRMSK_POS	23U 
#define	RTC_ALMB_HRMSK_MSK	BIT(RTC_ALMB_HRMSK_POS)

#define	RTC_ALMB_PM_POS	22U 
#define	RTC_ALMB_PM_MSK	BIT(RTC_ALMB_PM_POS)

#define	RTC_ALMB_HRT_POSS	20U 
#define	RTC_ALMB_HRT_POSE	21U 
#define	RTC_ALMB_HRT_MSK	BITS(RTC_ALMB_HRT_POSS,RTC_ALMB_HRT_POSE)

#define	RTC_ALMB_HRU_POSS	16U 
#define	RTC_ALMB_HRU_POSE	19U 
#define	RTC_ALMB_HRU_MSK	BITS(RTC_ALMB_HRU_POSS,RTC_ALMB_HRU_POSE)

#define	RTC_ALMB_MINMSK_POS	15U 
#define	RTC_ALMB_MINMSK_MSK	BIT(RTC_ALMB_MINMSK_POS)

#define	RTC_ALMB_MINT_POSS	12U 
#define	RTC_ALMB_MINT_POSE	14U 
#define	RTC_ALMB_MINT_MSK	BITS(RTC_ALMB_MINT_POSS,RTC_ALMB_MINT_POSE)

#define	RTC_ALMB_MINU_POSS	8U 
#define	RTC_ALMB_MINU_POSE	11U 
#define	RTC_ALMB_MINU_MSK	BITS(RTC_ALMB_MINU_POSS,RTC_ALMB_MINU_POSE)

#define	RTC_ALMB_SECMSK_POS	7U 
#define	RTC_ALMB_SECMSK_MSK	BIT(RTC_ALMB_SECMSK_POS)

#define	RTC_ALMB_SECT_POSS	4U 
#define	RTC_ALMB_SECT_POSE	6U 
#define	RTC_ALMB_SECT_MSK	BITS(RTC_ALMB_SECT_POSS,RTC_ALMB_SECT_POSE)

#define	RTC_ALMB_SECU_POSS	0U 
#define	RTC_ALMB_SECU_POSE	3U 
#define	RTC_ALMB_SECU_MSK	BITS(RTC_ALMB_SECU_POSS,RTC_ALMB_SECU_POSE)

/****************** Bit definition for RTC_ALMASSEC register ************************/

#define	RTC_ALMASSEC_SSECM_POSS	24U 
#define	RTC_ALMASSEC_SSECM_POSE	27U 
#define	RTC_ALMASSEC_SSECM_MSK	BITS(RTC_ALMASSEC_SSECM_POSS,RTC_ALMASSEC_SSECM_POSE)

#define	RTC_ALMASSEC_SSEC_POSS	0U 
#define	RTC_ALMASSEC_SSEC_POSE	14U 
#define	RTC_ALMASSEC_SSEC_MSK	BITS(RTC_ALMASSEC_SSEC_POSS,RTC_ALMASSEC_SSEC_POSE)

/****************** Bit definition for RTC_ALMBSSEC register ************************/

#define	RTC_ALMBSSEC_SSECM_POSS	24U 
#define	RTC_ALMBSSEC_SSECM_POSE	27U 
#define	RTC_ALMBSSEC_SSECM_MSK	BITS(RTC_ALMBSSEC_SSECM_POSS,RTC_ALMBSSEC_SSECM_POSE)

#define	RTC_ALMBSSEC_SSEC_POSS	0U 
#define	RTC_ALMBSSEC_SSEC_POSE	14U 
#define	RTC_ALMBSSEC_SSEC_MSK	BITS(RTC_ALMBSSEC_SSEC_POSS,RTC_ALMBSSEC_SSEC_POSE)

/****************** Bit definition for RTC_TSTIME register ************************/

#define	RTC_TSTIME_PM_POS	22U 
#define	RTC_TSTIME_PM_MSK	BIT(RTC_TSTIME_PM_POS)

#define	RTC_TSTIME_HRT_POSS	20U 
#define	RTC_TSTIME_HRT_POSE	21U 
#define	RTC_TSTIME_HRT_MSK	BITS(RTC_TSTIME_HRT_POSS,RTC_TSTIME_HRT_POSE)

#define	RTC_TSTIME_HRU_POSS	16U 
#define	RTC_TSTIME_HRU_POSE	19U 
#define	RTC_TSTIME_HRU_MSK	BITS(RTC_TSTIME_HRU_POSS,RTC_TSTIME_HRU_POSE)

#define	RTC_TSTIME_MINT_POSS	12U 
#define	RTC_TSTIME_MINT_POSE	14U 
#define	RTC_TSTIME_MINT_MSK	BITS(RTC_TSTIME_MINT_POSS,RTC_TSTIME_MINT_POSE)

#define	RTC_TSTIME_MINU_POSS	8U 
#define	RTC_TSTIME_MINU_POSE	11U 
#define	RTC_TSTIME_MINU_MSK	BITS(RTC_TSTIME_MINU_POSS,RTC_TSTIME_MINU_POSE)

#define	RTC_TSTIME_SECT_POSS	4U 
#define	RTC_TSTIME_SECT_POSE	6U 
#define	RTC_TSTIME_SECT_MSK	BITS(RTC_TSTIME_SECT_POSS,RTC_TSTIME_SECT_POSE)

#define	RTC_TSTIME_SECU_POSS	0U 
#define	RTC_TSTIME_SECU_POSE	3U 
#define	RTC_TSTIME_SECU_MSK	BITS(RTC_TSTIME_SECU_POSS,RTC_TSTIME_SECU_POSE)

/****************** Bit definition for RTC_TSDATE register ************************/

#define	RTC_TSDATE_WD_POSS	24U 
#define	RTC_TSDATE_WD_POSE	26U 
#define	RTC_TSDATE_WD_MSK	BITS(RTC_TSDATE_WD_POSS,RTC_TSDATE_WD_POSE)

#define	RTC_TSDATE_YRT_POSS	20U 
#define	RTC_TSDATE_YRT_POSE	23U 
#define	RTC_TSDATE_YRT_MSK	BITS(RTC_TSDATE_YRT_POSS,RTC_TSDATE_YRT_POSE)

#define	RTC_TSDATE_YRU_POSS	16U 
#define	RTC_TSDATE_YRU_POSE	19U 
#define	RTC_TSDATE_YRU_MSK	BITS(RTC_TSDATE_YRU_POSS,RTC_TSDATE_YRU_POSE)

#define	RTC_TSDATE_MONT_POS	12U 
#define	RTC_TSDATE_MONT_MSK	BIT(RTC_TSDATE_MONT_POS)

#define	RTC_TSDATE_MONU_POSS	8U 
#define	RTC_TSDATE_MONU_POSE	11U 
#define	RTC_TSDATE_MONU_MSK	BITS(RTC_TSDATE_MONU_POSS,RTC_TSDATE_MONU_POSE)

#define	RTC_TSDATE_DAYT_POSS	4U 
#define	RTC_TSDATE_DAYT_POSE	5U 
#define	RTC_TSDATE_DAYT_MSK	BITS(RTC_TSDATE_DAYT_POSS,RTC_TSDATE_DAYT_POSE)

#define	RTC_TSDATE_DAYU_POSS	0U 
#define	RTC_TSDATE_DAYU_POSE	3U 
#define	RTC_TSDATE_DAYU_MSK	BITS(RTC_TSDATE_DAYU_POSS,RTC_TSDATE_DAYU_POSE)

/****************** Bit definition for RTC_TSSSEC register ************************/

#define	RTC_TSSSEC_SSEC_POSS	0U 
#define	RTC_TSSSEC_SSEC_POSE	15U 
#define	RTC_TSSSEC_SSEC_MSK	BITS(RTC_TSSSEC_SSEC_POSS,RTC_TSSSEC_SSEC_POSE)

/****************** Bit definition for RTC_SSECTR register ************************/

#define	RTC_SSECTR_INC_POS	31U 
#define	RTC_SSECTR_INC_MSK	BIT(RTC_SSECTR_INC_POS)

#define	RTC_SSECTR_TRIM_POSS	0U 
#define	RTC_SSECTR_TRIM_POSE	14U 
#define	RTC_SSECTR_TRIM_MSK	BITS(RTC_SSECTR_TRIM_POSS,RTC_SSECTR_TRIM_POSE)

/****************** Bit definition for RTC_IER register ************************/

#define	RTC_IER_TCE_POS	25U 
#define	RTC_IER_TCE_MSK	BIT(RTC_IER_TCE_POS)

#define	RTC_IER_TCC_POS	24U 
#define	RTC_IER_TCC_MSK	BIT(RTC_IER_TCC_POS)

#define	RTC_IER_WU_POS	18U 
#define	RTC_IER_WU_MSK	BIT(RTC_IER_WU_POS)

#define	RTC_IER_SSTC_POS	17U 
#define	RTC_IER_SSTC_MSK	BIT(RTC_IER_SSTC_POS)

#define	RTC_IER_RSC_POS	16U 
#define	RTC_IER_RSC_MSK	BIT(RTC_IER_RSC_POS)

#define	RTC_IER_TAMP1_POS	13U 
#define	RTC_IER_TAMP1_MSK	BIT(RTC_IER_TAMP1_POS)

#define	RTC_IER_TAMP0_POS	12U 
#define	RTC_IER_TAMP0_MSK	BIT(RTC_IER_TAMP0_POS)

#define	RTC_IER_TSOV_POS	11U 
#define	RTC_IER_TSOV_MSK	BIT(RTC_IER_TSOV_POS)

#define	RTC_IER_TS_POS	10U 
#define	RTC_IER_TS_MSK	BIT(RTC_IER_TS_POS)

#define	RTC_IER_ALMB_POS	9U 
#define	RTC_IER_ALMB_MSK	BIT(RTC_IER_ALMB_POS)

#define	RTC_IER_ALMA_POS	8U 
#define	RTC_IER_ALMA_MSK	BIT(RTC_IER_ALMA_POS)

#define	RTC_IER_YR_POS	5U 
#define	RTC_IER_YR_MSK	BIT(RTC_IER_YR_POS)

#define	RTC_IER_MON_POS	4U 
#define	RTC_IER_MON_MSK	BIT(RTC_IER_MON_POS)

#define	RTC_IER_DAY_POS	3U 
#define	RTC_IER_DAY_MSK	BIT(RTC_IER_DAY_POS)

#define	RTC_IER_HR_POS	2U 
#define	RTC_IER_HR_MSK	BIT(RTC_IER_HR_POS)

#define	RTC_IER_MIN_POS	1U 
#define	RTC_IER_MIN_MSK	BIT(RTC_IER_MIN_POS)

#define	RTC_IER_SEC_POS	0U 
#define	RTC_IER_SEC_MSK	BIT(RTC_IER_SEC_POS)

/****************** Bit definition for RTC_IFR register ************************/

#define	RTC_IFR_TCEF_POS	25U 
#define	RTC_IFR_TCEF_MSK	BIT(RTC_IFR_TCEF_POS)

#define	RTC_IFR_TCCF_POS	24U 
#define	RTC_IFR_TCCF_MSK	BIT(RTC_IFR_TCCF_POS)

#define	RTC_IFR_WUF_POS	18U 
#define	RTC_IFR_WUF_MSK	BIT(RTC_IFR_WUF_POS)

#define	RTC_IFR_SSTCF_POS	17U 
#define	RTC_IFR_SSTCF_MSK	BIT(RTC_IFR_SSTCF_POS)

#define	RTC_IFR_RSCF_POS	16U 
#define	RTC_IFR_RSCF_MSK	BIT(RTC_IFR_RSCF_POS)

#define	RTC_IFR_TAMP1F_POS	13U 
#define	RTC_IFR_TAMP1F_MSK	BIT(RTC_IFR_TAMP1F_POS)

#define	RTC_IFR_TAMP0F_POS	12U 
#define	RTC_IFR_TAMP0F_MSK	BIT(RTC_IFR_TAMP0F_POS)

#define	RTC_IFR_TSOVF_POS	11U 
#define	RTC_IFR_TSOVF_MSK	BIT(RTC_IFR_TSOVF_POS)

#define	RTC_IFR_TSF_POS	10U 
#define	RTC_IFR_TSF_MSK	BIT(RTC_IFR_TSF_POS)

#define	RTC_IFR_ALMBF_POS	9U 
#define	RTC_IFR_ALMBF_MSK	BIT(RTC_IFR_ALMBF_POS)

#define	RTC_IFR_ALMAF_POS	8U 
#define	RTC_IFR_ALMAF_MSK	BIT(RTC_IFR_ALMAF_POS)

#define	RTC_IFR_YRF_POS	5U 
#define	RTC_IFR_YRF_MSK	BIT(RTC_IFR_YRF_POS)

#define	RTC_IFR_MONF_POS	4U 
#define	RTC_IFR_MONF_MSK	BIT(RTC_IFR_MONF_POS)

#define	RTC_IFR_DAYF_POS	3U 
#define	RTC_IFR_DAYF_MSK	BIT(RTC_IFR_DAYF_POS)

#define	RTC_IFR_HRF_POS	2U 
#define	RTC_IFR_HRF_MSK	BIT(RTC_IFR_HRF_POS)

#define	RTC_IFR_MINF_POS	1U 
#define	RTC_IFR_MINF_MSK	BIT(RTC_IFR_MINF_POS)

#define	RTC_IFR_SECF_POS	0U 
#define	RTC_IFR_SECF_MSK	BIT(RTC_IFR_SECF_POS)

/****************** Bit definition for RTC_IFCR register ************************/

#define	RTC_IFCR_TCEFC_POS	25U 
#define	RTC_IFCR_TCEFC_MSK	BIT(RTC_IFCR_TCEFC_POS)

#define	RTC_IFCR_TCCFC_POS	24U 
#define	RTC_IFCR_TCCFC_MSK	BIT(RTC_IFCR_TCCFC_POS)

#define	RTC_IFCR_WUFC_POS	18U 
#define	RTC_IFCR_WUFC_MSK	BIT(RTC_IFCR_WUFC_POS)

#define	RTC_IFCR_SSTCFC_POS	17U 
#define	RTC_IFCR_SSTCFC_MSK	BIT(RTC_IFCR_SSTCFC_POS)

#define	RTC_IFCR_RSCFC_POS	16U 
#define	RTC_IFCR_RSCFC_MSK	BIT(RTC_IFCR_RSCFC_POS)

#define	RTC_IFCR_TAMP1FC_POS	13U 
#define	RTC_IFCR_TAMP1FC_MSK	BIT(RTC_IFCR_TAMP1FC_POS)

#define	RTC_IFCR_TAMP0FC_POS	12U 
#define	RTC_IFCR_TAMP0FC_MSK	BIT(RTC_IFCR_TAMP0FC_POS)

#define	RTC_IFCR_TSOVFC_POS	11U 
#define	RTC_IFCR_TSOVFC_MSK	BIT(RTC_IFCR_TSOVFC_POS)

#define	RTC_IFCR_TSFC_POS	10U 
#define	RTC_IFCR_TSFC_MSK	BIT(RTC_IFCR_TSFC_POS)

#define	RTC_IFCR_ALMBFC_POS	9U 
#define	RTC_IFCR_ALMBFC_MSK	BIT(RTC_IFCR_ALMBFC_POS)

#define	RTC_IFCR_ALMAFC_POS	8U 
#define	RTC_IFCR_ALMAFC_MSK	BIT(RTC_IFCR_ALMAFC_POS)

#define	RTC_IFCR_YRFC_POS	5U 
#define	RTC_IFCR_YRFC_MSK	BIT(RTC_IFCR_YRFC_POS)

#define	RTC_IFCR_MONFC_POS	4U 
#define	RTC_IFCR_MONFC_MSK	BIT(RTC_IFCR_MONFC_POS)

#define	RTC_IFCR_DAYFC_POS	3U 
#define	RTC_IFCR_DAYFC_MSK	BIT(RTC_IFCR_DAYFC_POS)

#define	RTC_IFCR_HRFC_POS	2U 
#define	RTC_IFCR_HRFC_MSK	BIT(RTC_IFCR_HRFC_POS)

#define	RTC_IFCR_MINFC_POS	1U 
#define	RTC_IFCR_MINFC_MSK	BIT(RTC_IFCR_MINFC_POS)

#define	RTC_IFCR_SECFC_POS	0U 
#define	RTC_IFCR_SECFC_MSK	BIT(RTC_IFCR_SECFC_POS)

/****************** Bit definition for RTC_ISR register ************************/

#define	RTC_ISR_TCEF_POS	25U 
#define	RTC_ISR_TCEF_MSK	BIT(RTC_ISR_TCEF_POS)

#define	RTC_ISR_TCCF_POS	24U 
#define	RTC_ISR_TCCF_MSK	BIT(RTC_ISR_TCCF_POS)

#define	RTC_ISR_WUF_POS	18U 
#define	RTC_ISR_WUF_MSK	BIT(RTC_ISR_WUF_POS)

#define	RTC_ISR_SSTCF_POS	17U 
#define	RTC_ISR_SSTCF_MSK	BIT(RTC_ISR_SSTCF_POS)

#define	RTC_ISR_RSCF_POS	16U 
#define	RTC_ISR_RSCF_MSK	BIT(RTC_ISR_RSCF_POS)

#define	RTC_ISR_TAMP1F_POS	13U 
#define	RTC_ISR_TAMP1F_MSK	BIT(RTC_ISR_TAMP1F_POS)

#define	RTC_ISR_TAMP0F_POS	12U 
#define	RTC_ISR_TAMP0F_MSK	BIT(RTC_ISR_TAMP0F_POS)

#define	RTC_ISR_TSOVF_POS	11U 
#define	RTC_ISR_TSOVF_MSK	BIT(RTC_ISR_TSOVF_POS)

#define	RTC_ISR_TSF_POS	10U 
#define	RTC_ISR_TSF_MSK	BIT(RTC_ISR_TSF_POS)

#define	RTC_ISR_ALMBF_POS	9U 
#define	RTC_ISR_ALMBF_MSK	BIT(RTC_ISR_ALMBF_POS)

#define	RTC_ISR_ALMAF_POS	8U 
#define	RTC_ISR_ALMAF_MSK	BIT(RTC_ISR_ALMAF_POS)

#define	RTC_ISR_YRF_POS	5U 
#define	RTC_ISR_YRF_MSK	BIT(RTC_ISR_YRF_POS)

#define	RTC_ISR_MONF_POS	4U 
#define	RTC_ISR_MONF_MSK	BIT(RTC_ISR_MONF_POS)

#define	RTC_ISR_DAYF_POS	3U 
#define	RTC_ISR_DAYF_MSK	BIT(RTC_ISR_DAYF_POS)

#define	RTC_ISR_HRF_POS	2U 
#define	RTC_ISR_HRF_MSK	BIT(RTC_ISR_HRF_POS)

#define	RTC_ISR_MINF_POS	1U 
#define	RTC_ISR_MINF_MSK	BIT(RTC_ISR_MINF_POS)

#define	RTC_ISR_SECF_POS	0U 
#define	RTC_ISR_SECF_MSK	BIT(RTC_ISR_SECF_POS)

/****************** Bit definition for RTC_CALWPR register ************************/

#define	RTC_CALWPR_WP_POS	0U 
#define	RTC_CALWPR_WP_MSK	BIT(RTC_CALWPR_WP_POS)

/****************** Bit definition for RTC_CALCON register ************************/

#define	RTC_CALCON_DCMACC_POS	24U 
#define	RTC_CALCON_DCMACC_MSK	BIT(RTC_CALCON_DCMACC_POS)

#define	RTC_CALCON_ALG_POS	23U 
#define	RTC_CALCON_ALG_MSK	BIT(RTC_CALCON_ALG_POS)

#define	RTC_CALCON_TCP_POSS	20U 
#define	RTC_CALCON_TCP_POSE	22U 
#define	RTC_CALCON_TCP_MSK	BITS(RTC_CALCON_TCP_POSS,RTC_CALCON_TCP_POSE)

#define	RTC_CALCON_ERR_POS	19U 
#define	RTC_CALCON_ERR_MSK	BIT(RTC_CALCON_ERR_POS)

#define	RTC_CALCON_BUSY_POS	18U 
#define	RTC_CALCON_BUSY_MSK	BIT(RTC_CALCON_BUSY_POS)

#define	RTC_CALCON_TCM_POSS	16U 
#define	RTC_CALCON_TCM_POSE	17U 
#define	RTC_CALCON_TCM_MSK	BITS(RTC_CALCON_TCM_POSS,RTC_CALCON_TCM_POSE)

#define	RTC_CALCON_CALP_POSS	1U 
#define	RTC_CALCON_CALP_POSE	3U 
#define	RTC_CALCON_CALP_MSK	BITS(RTC_CALCON_CALP_POSS,RTC_CALCON_CALP_POSE)

#define	RTC_CALCON_CALEN_POS	0U 
#define	RTC_CALCON_CALEN_MSK	BIT(RTC_CALCON_CALEN_POS)

/****************** Bit definition for RTC_CALDR register ************************/

#define	RTC_CALDR_DATA_POSS	16U 
#define	RTC_CALDR_DATA_POSE	31U 
#define	RTC_CALDR_DATA_MSK	BITS(RTC_CALDR_DATA_POSS,RTC_CALDR_DATA_POSE)

#define	RTC_CALDR_VAL_POSS	0U 
#define	RTC_CALDR_VAL_POSE	15U 
#define	RTC_CALDR_VAL_MSK	BITS(RTC_CALDR_VAL_POSS,RTC_CALDR_VAL_POSE)

/****************** Bit definition for RTC_TEMPR register ************************/

#define	RTC_TEMPR_DATA_POSS	16U 
#define	RTC_TEMPR_DATA_POSE	31U 
#define	RTC_TEMPR_DATA_MSK	BITS(RTC_TEMPR_DATA_POSS,RTC_TEMPR_DATA_POSE)

#define	RTC_TEMPR_VAL_POSS	0U 
#define	RTC_TEMPR_VAL_POSE	15U 
#define	RTC_TEMPR_VAL_MSK	BITS(RTC_TEMPR_VAL_POSS,RTC_TEMPR_VAL_POSE)

/****************** Bit definition for RTC_TEMPBDR register ************************/

#define	RTC_TEMPBDR_VAL_POSS	0U 
#define	RTC_TEMPBDR_VAL_POSE	15U 
#define	RTC_TEMPBDR_VAL_MSK	BITS(RTC_TEMPBDR_VAL_POSS,RTC_TEMPBDR_VAL_POSE)

/****************** Bit definition for RTC_BKP register ************************/

#define	RTC_BKP_BKP_POSS	0U 
#define	RTC_BKP_BKP_POSE	31U 
#define	RTC_BKP_BKP_MSK	BITS(RTC_BKP_BKP_POSS,RTC_BKP_BKP_POSE)

typedef struct
{
	__IO uint32_t WPR;
	__IO uint32_t CON;
	__IO uint32_t PSR;
	__IO uint32_t TAMPCON;
	__IO uint32_t TIME;
	__IO uint32_t DATE;
	__IO uint32_t SSEC;
	__IO uint32_t WUMAT;
	__IO uint32_t ALMA;
	__IO uint32_t ALMB;
	__IO uint32_t ALMASSEC;
	__IO uint32_t ALMBSSEC;
	__I uint32_t TSTIME;
	__I uint32_t TSDATE;
	__I uint32_t TSSSEC;
	__O uint32_t SSECTR;
	__IO uint32_t IER;
	__I uint32_t IFR;
	__O uint32_t IFCR;
	__I uint32_t ISR;
	__IO uint32_t CALWPR;
	__IO uint32_t CALCON;
	__IO uint32_t CALDR;
	__IO uint32_t TEMPR;
	__IO uint32_t LTCAR;
	__IO uint32_t LTCBR;
	__IO uint32_t LTCCR;
	__IO uint32_t LTCDR;
	__IO uint32_t LTCER;
	__IO uint32_t HTCAR;
	__IO uint32_t HTCBR;
	__IO uint32_t HTCCR;
	__IO uint32_t HTCDR;
	__IO uint32_t HTCER;
	__IO uint32_t TEMPBDR;
	__IO uint32_t LTAXR;
	__IO uint32_t HTAXR;
	uint32_t RESERVED0[27] ;
	__IO uint32_t BKPR[32];
} RTC_TypeDef;

/****************** Bit definition for TIMER_CON1 register ************************/

#define	TIMER_CON1_DBGSEL_POSS	15U 
#define	TIMER_CON1_DBGSEL_MSK	BIT(TIMER_CON1_DBGSEL_POSS)

#define	TIMER_CON1_OCCISS_POSS	11U 
#define	TIMER_CON1_OCCISS_POSE	13U 
#define	TIMER_CON1_OCCISS_MSK	BITS(TIMER_CON1_OCCISS_POSS,TIMER_CON1_OCCISS_POSE)

#define	TIMER_CON1_OCCISP_POSS	10U 
#define	TIMER_CON1_OCCISP_MSK	BIT(TIMER_CON1_OCCISP_POSS)

#define	TIMER_CON1_DFCKSEL_POSS	8U 
#define	TIMER_CON1_DFCKSEL_POSE	9U 
#define	TIMER_CON1_DFCKSEL_MSK	BITS(TIMER_CON1_DFCKSEL_POSS,TIMER_CON1_DFCKSEL_POSE)

#define	TIMER_CON1_ARPEN_POS	7U 
#define	TIMER_CON1_ARPEN_MSK	BIT(TIMER_CON1_ARPEN_POS)

#define	TIMER_CON1_CMSEL_POSS	5U 
#define	TIMER_CON1_CMSEL_POSE	6U 
#define	TIMER_CON1_CMSEL_MSK	BITS(TIMER_CON1_CMSEL_POSS,TIMER_CON1_CMSEL_POSE)

#define	TIMER_CON1_DIRSEL_POS	4U 
#define	TIMER_CON1_DIRSEL_MSK	BIT(TIMER_CON1_DIRSEL_POS)

#define	TIMER_CON1_SPMEN_POS	3U 
#define	TIMER_CON1_SPMEN_MSK	BIT(TIMER_CON1_SPMEN_POS)

#define	TIMER_CON1_UERSEL_POS	2U 
#define	TIMER_CON1_UERSEL_MSK	BIT(TIMER_CON1_UERSEL_POS)

#define	TIMER_CON1_DISUE_POS	1U 
#define	TIMER_CON1_DISUE_MSK	BIT(TIMER_CON1_DISUE_POS)

#define	TIMER_CON1_CNTEN_POS	0U 
#define	TIMER_CON1_CNTEN_MSK	BIT(TIMER_CON1_CNTEN_POS)

/****************** Bit definition for TIMER_CON2 register ************************/

#define	TIMER_CON2_OISS4_POS	14U 
#define	TIMER_CON2_OISS4_MSK	BIT(TIMER_CON2_OISS4_POS)

#define	TIMER_CON2_OISS3N_POS	13U 
#define	TIMER_CON2_OISS3N_MSK	BIT(TIMER_CON2_OISS3N_POS)

#define	TIMER_CON2_OISS3_POS	12U 
#define	TIMER_CON2_OISS3_MSK	BIT(TIMER_CON2_OISS3_POS)

#define	TIMER_CON2_OISS2N_POS	11U 
#define	TIMER_CON2_OISS2N_MSK	BIT(TIMER_CON2_OISS2N_POS)

#define	TIMER_CON2_OISS2_POS	10U 
#define	TIMER_CON2_OISS2_MSK	BIT(TIMER_CON2_OISS2_POS)

#define	TIMER_CON2_OISS1N_POS	9U 
#define	TIMER_CON2_OISS1N_MSK	BIT(TIMER_CON2_OISS1N_POS)

#define	TIMER_CON2_OISS1_POS	8U 
#define	TIMER_CON2_OISS1_MSK	BIT(TIMER_CON2_OISS1_POS)

#define	TIMER_CON2_I1FSEL_POS	7U 
#define	TIMER_CON2_I1FSEL_MSK	BIT(TIMER_CON2_I1FSEL_POS)

#define	TIMER_CON2_TRGOSEL_POSS	4U 
#define	TIMER_CON2_TRGOSEL_POSE	6U 
#define	TIMER_CON2_TRGOSEL_MSK	BITS(TIMER_CON2_TRGOSEL_POSS,TIMER_CON2_TRGOSEL_POSE)

#define	TIMER_CON2_CCDMASEL_POS	3U 
#define	TIMER_CON2_CCDMASEL_MSK	BIT(TIMER_CON2_CCDMASEL_POS)

#define	TIMER_CON2_CCUSEL_POS	2U 
#define	TIMER_CON2_CCUSEL_MSK	BIT(TIMER_CON2_CCUSEL_POS)

#define	TIMER_CON2_CCPCEN_POS	0U 
#define	TIMER_CON2_CCPCEN_MSK	BIT(TIMER_CON2_CCPCEN_POS)

/****************** Bit definition for TIMER_SMCON register ************************/

#define	TIMER_SMCON_ETPOL_POS	15U 
#define	TIMER_SMCON_ETPOL_MSK	BIT(TIMER_SMCON_ETPOL_POS)

#define	TIMER_SMCON_ECM2EN_POS	14U 
#define	TIMER_SMCON_ECM2EN_MSK	BIT(TIMER_SMCON_ECM2EN_POS)

#define	TIMER_SMCON_ETPSEL_POSS	12U 
#define	TIMER_SMCON_ETPSEL_POSE	13U 
#define	TIMER_SMCON_ETPSEL_MSK	BITS(TIMER_SMCON_ETPSEL_POSS,TIMER_SMCON_ETPSEL_POSE)

#define	TIMER_SMCON_ETFLT_POSS	8U 
#define	TIMER_SMCON_ETFLT_POSE	11U 
#define	TIMER_SMCON_ETFLT_MSK	BITS(TIMER_SMCON_ETFLT_POSS,TIMER_SMCON_ETFLT_POSE)

#define	TIMER_SMCON_MSCFG_POS	7U 
#define	TIMER_SMCON_MSCFG_MSK	BIT(TIMER_SMCON_MSCFG_POS)

#define	TIMER_SMCON_TSSEL_POSS	4U 
#define	TIMER_SMCON_TSSEL_POSE	6U 
#define	TIMER_SMCON_TSSEL_MSK	BITS(TIMER_SMCON_TSSEL_POSS,TIMER_SMCON_TSSEL_POSE)

#define TIMER_SMCON_CHCSEL_POS  3U
#define TIMER_SMCON_CHCSEL_MASK BIT(TIMER_SMCON_CHCSEL_POS)

#define	TIMER_SMCON_SMODS_POSS	0U 
#define	TIMER_SMCON_SMODS_POSE	2U 
#define	TIMER_SMCON_SMODS_MSK	BITS(TIMER_SMCON_SMODS_POSS,TIMER_SMCON_SMODS_POSE)

/****************** Bit definition for TIMER_IER register ************************/

#define	TIMER_IER_BRKIT_POS	7U 
#define	TIMER_IER_BRKIT_MSK	BIT(TIMER_IER_BRKIT_POS)

#define	TIMER_IER_TRGIT_POS	6U 
#define	TIMER_IER_TRGIT_MSK	BIT(TIMER_IER_TRGIT_POS)

#define	TIMER_IER_COMIT_POS	5U 
#define	TIMER_IER_COMIT_MSK	BIT(TIMER_IER_COMIT_POS)

#define	TIMER_IER_CC4IT_POS	4U 
#define	TIMER_IER_CC4IT_MSK	BIT(TIMER_IER_CC4IT_POS)

#define	TIMER_IER_CC3IT_POS	3U 
#define	TIMER_IER_CC3IT_MSK	BIT(TIMER_IER_CC3IT_POS)

#define	TIMER_IER_CC2IT_POS	2U 
#define	TIMER_IER_CC2IT_MSK	BIT(TIMER_IER_CC2IT_POS)

#define	TIMER_IER_CC1IT_POS	1U 
#define	TIMER_IER_CC1IT_MSK	BIT(TIMER_IER_CC1IT_POS)

#define	TIMER_IER_UIT_POS	0U 
#define	TIMER_IER_UIT_MSK	BIT(TIMER_IER_UIT_POS)

/****************** Bit definition for TIMER_IDR register ************************/
#define	TIMER_IDR_BRKI_POS	7U 
#define	TIMER_IDR_BRKI_MSK	BIT(TIMER_IDR_BRKI_POS)

#define	TIMER_IDR_TRGI_POS	6U 
#define	TIMER_IDR_TRGI_MSK	BIT(TIMER_IDR_TRGI_POS)

#define	TIMER_IDR_COMI_POS	5U 
#define	TIMER_IDR_COMI_MSK	BIT(TIMER_IDR_COMI_POS)

#define	TIMER_IDR_CC4I_POS	4U 
#define	TIMER_IDR_CC4I_MSK	BIT(TIMER_IDR_CC4I_POS)

#define	TIMER_IDR_CC3I_POS	3U 
#define	TIMER_IDR_CC3I_MSK	BIT(TIMER_IDR_CC3I_POS)

#define	TIMER_IDR_CC2I_POS	2U 
#define	TIMER_IDR_CC2I_MSK	BIT(TIMER_IDR_CC2I_POS)

#define	TIMER_IDR_CC1I_POS	1U 
#define	TIMER_IDR_CC1I_MSK	BIT(TIMER_IDR_CC1I_POS)

#define	TIMER_IDR_UI_POS	0U 
#define	TIMER_IDR_UI_MSK	BIT(TIMER_IDR_UI_POS)

/****************** Bit definition for TIMER_IVS register ************************/

#define	TIMER_IVS_BKI_POS	7U 
#define	TIMER_IVS_BKI_MSK	BIT(TIMER_IVS_BKI_POS)

#define	TIMER_IVS_TRGI_POS	6U 
#define	TIMER_IVS_TRGI_MSK	BIT(TIMER_IVS_TRGI_POS)

#define	TIMER_IVS_COMI_POS	5U 
#define	TIMER_IVS_COMI_MSK	BIT(TIMER_IVS_COMI_POS)

#define	TIMER_IVS_CC4I_POS	4U 
#define	TIMER_IVS_CC4I_MSK	BIT(TIMER_IVS_CC4I_POS)

#define	TIMER_IVS_CC3I_POS	3U 
#define	TIMER_IVS_CC3I_MSK	BIT(TIMER_IVS_CC3I_POS)

#define	TIMER_IVS_CC2I_POS	2U 
#define	TIMER_IVS_CC2I_MSK	BIT(TIMER_IVS_CC2I_POS)

#define	TIMER_IVS_CC1I_POS	1U 
#define	TIMER_IVS_CC1I_MSK	BIT(TIMER_IVS_CC1I_POS)

#define	TIMER_IVS_UEI_POS	0U 
#define	TIMER_IVS_UEI_MSK	BIT(TIMER_IVS_UEI_POS)

/****************** Bit definition for TIMER_RIF register ************************/

#define	TIMER_RIF_CH4OVIF_POS	12U 
#define	TIMER_RIF_CH4OVIF_MSK	BIT(TIMER_RIF_CH4OVIF_POS)

#define	TIMER_RIF_CH3OVIF_POS	11U 
#define	TIMER_RIF_CH3OVIF_MSK	BIT(TIMER_RIF_CH3OVIF_POS)

#define	TIMER_RIF_CH2OVIF_POS	10U 
#define	TIMER_RIF_CH2OVIF_MSK	BIT(TIMER_RIF_CH2OVIF_POS)

#define	TIMER_RIF_CH1OVIF_POS	9U 
#define	TIMER_RIF_CH1OVIF_MSK	BIT(TIMER_RIF_CH1OVIF_POS)

#define	TIMER_RIF_BRKIF_POS	7U 
#define	TIMER_RIF_BRKIF_MSK	BIT(TIMER_RIF_BRKIF_POS)

#define	TIMER_RIF_TRGIF_POS	6U 
#define	TIMER_RIF_TRGIF_MSK	BIT(TIMER_RIF_TRGIF_POS)

#define	TIMER_RIF_COMIF_POS	5U 
#define	TIMER_RIF_COMIF_MSK	BIT(TIMER_RIF_COMIF_POS)

#define	TIMER_RIF_CH4IF_POS	4U 
#define	TIMER_RIF_CH4IF_MSK	BIT(TIMER_RIF_CH4IF_POS)

#define	TIMER_RIF_CH3IF_POS	3U 
#define	TIMER_RIF_CH3IF_MSK	BIT(TIMER_RIF_CH3IF_POS)

#define	TIMER_RIF_CH2IF_POS	2U 
#define	TIMER_RIF_CH2IF_MSK	BIT(TIMER_RIF_CH2IF_POS)

#define	TIMER_RIF_CH1IF_POS	1U 
#define	TIMER_RIF_CH1IF_MSK	BIT(TIMER_RIF_CH1IF_POS)

#define	TIMER_RIF_UEVTIF_POS	0U 
#define	TIMER_RIF_UEVTIF_MSK	BIT(TIMER_RIF_UEVTIF_POS)

/****************** Bit definition for TIMER_IFM register ************************/

#define	TIMER_IFM_BRKIM_POS	7U 
#define	TIMER_IFM_BRKIM_MSK	BIT(TIMER_IFM_BRKIM_POS)

#define	TIMER_IFM_TRGI_POS	6U 
#define	TIMER_IFM_TRGI_MSK	BIT(TIMER_IFM_TRGI_POS)

#define	TIMER_IFM_COMI_POS	5U 
#define	TIMER_IFM_COMI_MSK	BIT(TIMER_IFM_COMI_POS)

#define	TIMER_IFM_CH4CCI_POS	4U 
#define	TIMER_IFM_CH4CCI_MSK	BIT(TIMER_IFM_CH4CCI_POS)

#define	TIMER_IFM_CH3CCI_POS	3U 
#define	TIMER_IFM_CH3CCI_MSK	BIT(TIMER_IFM_CH3CCI_POS)

#define	TIMER_IFM_CH2CCI_POS	2U 
#define	TIMER_IFM_CH2CCI_MSK	BIT(TIMER_IFM_CH2CCI_POS)

#define	TIMER_IFM_CH1CCI_POS	1U 
#define	TIMER_IFM_CH1CCI_MSK	BIT(TIMER_IFM_CH1CCI_POS)

#define	TIMER_IFM_UEI_POS	0U 
#define	TIMER_IFM_UEI_MSK	BIT(TIMER_IFM_UEI_POS)

/****************** Bit definition for TIMER_ICR register ************************/

#define	TIMER_ICR_BRKIC_POS	7U 
#define	TIMER_ICR_BRKIC_MSK	BIT(TIMER_ICR_BRKIC_POS)

#define	TIMER_ICR_TRGIC_POS	6U 
#define	TIMER_ICR_TRGIC_MSK	BIT(TIMER_ICR_TRGIC_POS)

#define	TIMER_ICR_COMIC_POS	5U 
#define	TIMER_ICR_COMIC_MSK	BIT(TIMER_ICR_COMIC_POS)

#define	TIMER_ICR_CH4CCIC_POS	4U 
#define	TIMER_ICR_CH4CCIC_MSK	BIT(TIMER_ICR_CH4CCIC_POS)

#define	TIMER_ICR_CH3CCIC_POS	3U 
#define	TIMER_ICR_CH3CCIC_MSK	BIT(TIMER_ICR_CH3CCIC_POS)

#define	TIMER_ICR_CH2CCIC_POS	2U 
#define	TIMER_ICR_CH2CCIC_MSK	BIT(TIMER_ICR_CH2CCIC_POS)

#define	TIMER_ICR_CH1CCIC_POS	1U 
#define	TIMER_ICR_CH1CCIC_MSK	BIT(TIMER_ICR_CH1CCIC_POS)

#define	TIMER_ICR_UEIC_POS	0U 
#define	TIMER_ICR_UEIC_MSK	BIT(TIMER_ICR_UEIC_POS)

/****************** Bit definition for TIMER_SGE register ************************/

#define	TIMER_SGE_SGBRK_POS	7U 
#define	TIMER_SGE_SGBRK_MSK	BIT(TIMER_SGE_SGBRK_POS)

#define	TIMER_SGE_SGTRG_POS	6U 
#define	TIMER_SGE_SGTRG_MSK	BIT(TIMER_SGE_SGTRG_POS)

#define	TIMER_SGE_SGCOM_POS	5U 
#define	TIMER_SGE_SGCOM_MSK	BIT(TIMER_SGE_SGCOM_POS)

#define	TIMER_SGE_SGCC4E_POS	4U 
#define	TIMER_SGE_SGCC4E_MSK	BIT(TIMER_SGE_SGCC4E_POS)

#define	TIMER_SGE_SGCC3E_POS	3U 
#define	TIMER_SGE_SGCC3E_MSK	BIT(TIMER_SGE_SGCC3E_POS)

#define	TIMER_SGE_SGCC2E_POS	2U 
#define	TIMER_SGE_SGCC2E_MSK	BIT(TIMER_SGE_SGCC2E_POS)

#define	TIMER_SGE_SGCC1E_POS	1U 
#define	TIMER_SGE_SGCC1E_MSK	BIT(TIMER_SGE_SGCC1E_POS)

#define	TIMER_SGE_SGU_POS	0U 
#define	TIMER_SGE_SGU_MSK	BIT(TIMER_SGE_SGU_POS)

/****************** Bit definition for TIMER_CHMR1 register ************************/
/* Output */
#define	TIMER_CHMR1_CH2OCLREN_POS	15U 
#define	TIMER_CHMR1_CH2OCLREN_MSK	BIT(TIMER_CHMR1_CH2OCLREN_POS)

#define	TIMER_CHMR1_CH2OMOD_POSS	12U 
#define	TIMER_CHMR1_CH2OMOD_POSE	14U 
#define	TIMER_CHMR1_CH2OMOD_MSK	BITS(TIMER_CHMR1_CH2OMOD_POSS,TIMER_CHMR1_CH2OMOD_POSE)

#define	TIMER_CHMR1_CH2OPEN_POS	11U 
#define	TIMER_CHMR1_CH2OPEN_MSK	BIT(TIMER_CHMR1_CH2OPEN_POS)

#define	TIMER_CHMR1_CH2OFEN_POS	10U 
#define	TIMER_CHMR1_CH2OFEN_MSK	BIT(TIMER_CHMR1_CH2OFEN_POS)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_CH1OCLREN_POS	7U 
#define	TIMER_CHMR1_CH1OCLREN_MSK	BIT(TIMER_CHMR1_CH1OCLREN_POS)

#define	TIMER_CHMR1_CH1OMOD_POSS	4U 
#define	TIMER_CHMR1_CH1OMOD_POSE	6U 
#define	TIMER_CHMR1_CH1OMOD_MSK	BITS(TIMER_CHMR1_CH1OMOD_POSS,TIMER_CHMR1_CH1OMOD_POSE)

#define	TIMER_CHMR1_CH1OPREN_POS	3U 
#define	TIMER_CHMR1_CH1OPREN_MSK	BIT(TIMER_CHMR1_CH1OPREN_POS)

#define	TIMER_CHMR1_CH1OHSEN_POS	2U 
#define	TIMER_CHMR1_CH1OHSEN_MSK	BIT(TIMER_CHMR1_CH1OHSEN_POS)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/* Input */
#define	TIMER_CHMR1_I2FLT_POSS	12U 
#define	TIMER_CHMR1_I2FLT_POSE	15U 
#define	TIMER_CHMR1_I2FLT_MSK	BITS(TIMER_CHMR1_I2FLT_POSS,TIMER_CHMR1_I2FLT_POSE)

#define	TIMER_CHMR1_IC2PRES_POSS	10U 
#define	TIMER_CHMR1_IC2PRES_POSE	11U 
#define	TIMER_CHMR1_IC2PRES_MSK	BITS(TIMER_CHMR1_IC2PRES_POSS,TIMER_CHMR1_IC2PRES_POSE)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_I1FLT_POSS	4U 
#define	TIMER_CHMR1_I1FLT_POSE	7U 
#define	TIMER_CHMR1_I1FLT_MSK	BITS(TIMER_CHMR1_I1FLT_POSS,TIMER_CHMR1_I1FLT_POSE)

#define	TIMER_CHMR1_IC1PRES_POSS	2U 
#define	TIMER_CHMR1_IC1PRES_POSE	3U 
#define	TIMER_CHMR1_IC1PRES_MSK	BITS(TIMER_CHMR1_IC1PRES_POSS,TIMER_CHMR1_IC1PRES_POSE)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2 register ************************/
/* Output */
#define	TIMER_CHMR2_CH4OCLREN_POS	15U 
#define	TIMER_CHMR2_CH4OCLREN_MSK	BIT(TIMER_CHMR2_CH4OCLREN_POS)

#define	TIMER_CHMR2_CH4OMOD_POSS	12U 
#define	TIMER_CHMR2_CH4OMOD_POSE	14U 
#define	TIMER_CHMR2_CH4OMOD_MSK	BITS(TIMER_CHMR2_CH4OMOD_POSS,TIMER_CHMR2_CH4OMOD_POSE)

#define	TIMER_CHMR2_CH4OPEN_POS	11U 
#define	TIMER_CHMR2_CH4OPEN_MSK	BIT(TIMER_CHMR2_CH4OPEN_POS)

#define	TIMER_CHMR2_CH4OHSEN_POS	10U 
#define	TIMER_CHMR2_CH4OHSEN_MSK	BIT(TIMER_CHMR2_CH4OHSEN_POS)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_CH3OCLREN_POS	7U 
#define	TIMER_CHMR2_CH3OCLREN_MSK	BIT(TIMER_CHMR2_CH3OCLREN_POS)

#define	TIMER_CHMR2_CH3OMOD_POSS	4U 
#define	TIMER_CHMR2_CH3OMOD_POSE	6U 
#define	TIMER_CHMR2_CH3OMOD_MSK	BITS(TIMER_CHMR2_CH3OMOD_POSS,TIMER_CHMR2_CH3OMOD_POSE)

#define	TIMER_CHMR2_CH3OPEN_POS	3U 
#define	TIMER_CHMR2_CH3OPEN_MSK	BIT(TIMER_CHMR2_CH3OPEN_POS)

#define	TIMER_CHMR2_CH3OFEN_POS	2U 
#define	TIMER_CHMR2_CH3OFEN_MSK	BIT(TIMER_CHMR2_CH3OFEN_POS)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U 
#define	TIMER_CHMR2_CC3SSEL_POSE	1U 
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/* Input */
#define	TIMER_CHMR2_I4FLT_POSS	12U
#define	TIMER_CHMR2_I4FLT_POSE	15U
#define	TIMER_CHMR2_I4FLT_MSK	BITS(TIMER_CHMR2_I4FLT_POSS,TIMER_CHMR2_I4FLT_POSE)

#define	TIMER_CHMR2_IC4PRES_POSS	10U
#define	TIMER_CHMR2_IC4PRES_POSE	11U
#define	TIMER_CHMR2_IC4PRES_MSK	BITS(TIMER_CHMR2_IC4PRES_POSS,TIMER_CHMR2_IC4PRES_POSE)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_I3FLT_POSS	4U
#define	TIMER_CHMR2_I3FLT_POSE	7U
#define	TIMER_CHMR2_I3FLT_MSK	BITS(TIMER_CHMR2_I3FLT_POSS,TIMER_CHMR2_I3FLT_POSE)

#define	TIMER_CHMR2_IC3PRES_POSS	2U
#define	TIMER_CHMR2_IC3PRES_POSE	3U
#define	TIMER_CHMR2_IC3PRES_MSK	BITS(TIMER_CHMR2_IC3PRES_POSS,TIMER_CHMR2_IC3PRES_POSE)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U
#define	TIMER_CHMR2_CC3SSEL_POSE	1U
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CCEP register ************************/

#define	TIMER_CCEP_CC4POL_POS	13U 
#define	TIMER_CCEP_CC4POL_MSK	BIT(TIMER_CCEP_CC4POL_POS)

#define	TIMER_CCEP_CC4EN_POS	12U 
#define	TIMER_CCEP_CC4EN_MSK	BIT(TIMER_CCEP_CC4EN_POS)

#define	TIMER_CCEP_CC3NPOL_POS	11U 
#define	TIMER_CCEP_CC3NPOL_MSK	BIT(TIMER_CCEP_CC3NPOL_POS)

#define	TIMER_CCEP_CC3NEN_POS	10U 
#define	TIMER_CCEP_CC3NEN_MSK	BIT(TIMER_CCEP_CC3NEN_POS)

#define	TIMER_CCEP_CC3POL_POS	9U 
#define	TIMER_CCEP_CC3POL_MSK	BIT(TIMER_CCEP_CC3POL_POS)

#define	TIMER_CCEP_CC3EN_POS	8U 
#define	TIMER_CCEP_CC3EN_MSK	BIT(TIMER_CCEP_CC3EN_POS)

#define	TIMER_CCEP_CC2NPOL_POS	7U 
#define	TIMER_CCEP_CC2NPOL_MSK	BIT(TIMER_CCEP_CC2NPOL_POS)

#define	TIMER_CCEP_CC2NEN_POS	6U 
#define	TIMER_CCEP_CC2NEN_MSK	BIT(TIMER_CCEP_CC2NEN_POS)

#define	TIMER_CCEP_CC2POL_POS	5U 
#define	TIMER_CCEP_CC2POL_MSK	BIT(TIMER_CCEP_CC2POL_POS)

#define	TIMER_CCEP_CC2EN_POS	4U 
#define	TIMER_CCEP_CC2EN_MSK	BIT(TIMER_CCEP_CC2EN_POS)

#define	TIMER_CCEP_CC1NPOL_POS	3U 
#define	TIMER_CCEP_CC1NPOL_MSK	BIT(TIMER_CCEP_CC1NPOL_POS)

#define	TIMER_CCEP_CC1NEN_POS	2U 
#define	TIMER_CCEP_CC1NEN_MSK	BIT(TIMER_CCEP_CC1NEN_POS)

#define	TIMER_CCEP_CC1POL_POS	1U 
#define	TIMER_CCEP_CC1POL_MSK	BIT(TIMER_CCEP_CC1POL_POS)

#define	TIMER_CCEP_CC1EN_POS	0U 
#define	TIMER_CCEP_CC1EN_MSK	BIT(TIMER_CCEP_CC1EN_POS)

/****************** Bit definition for TIMER_COUNT register ************************/

#define	TIMER_COUNT_CNTV_POSS	0U 
#define	TIMER_COUNT_CNTV_POSE	15U 
#define	TIMER_COUNT_CNTV_MSK	BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)

/****************** Bit definition for TIMER_PRES register ************************/

#define	TIMER_PRES_PSCV_POSS	0U 
#define	TIMER_PRES_PSCV_POSE	15U 
#define	TIMER_PRES_PSCV_MSK	BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)

/****************** Bit definition for TIMER_AR register ************************/

#define	TIMER_AR_ARRV_POSS	0U 
#define	TIMER_AR_ARRV_POSE	15U 
#define	TIMER_AR_ARRV_MSK	BITS(TIMER_AR_ARRV_POSS,TIMER_AR_ARRV_POSE)

/****************** Bit definition for TIMER_REPAR register ************************/

#define	TIMER_REPAR_REPV_POSS	0U 
#define	TIMER_REPAR_REPV_POSE	7U 
#define	TIMER_REPAR_REPV_MSK	BITS(TIMER_REPAR_REPV_POSS,TIMER_REPAR_REPV_POSE)

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define	TIMER_CCVAL1_CCRV1_POSS	0U 
#define	TIMER_CCVAL1_CCRV1_POSE	15U 
#define	TIMER_CCVAL1_CCRV1_MSK	BITS(TIMER_CCVAL1_CCRV1_POSS,TIMER_CCVAL1_CCRV1_POSE)

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define	TIMER_CCVAL2_CCRV2_POSS	0U 
#define	TIMER_CCVAL2_CCRV2_POSE	15U 
#define	TIMER_CCVAL2_CCRV2_MSK	BITS(TIMER_CCVAL2_CCRV2_POSS,TIMER_CCVAL2_CCRV2_POSE)

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define	TIMER_CCVAL3_CCRV3_POSS	0U 
#define	TIMER_CCVAL3_CCRV3_POSE	15U 
#define	TIMER_CCVAL3_CCRV3_MSK	BITS(TIMER_CCVAL3_CCRV3_POSS,TIMER_CCVAL3_CCRV3_POSE)

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define	TIMER_CCVAL4_CCRV4_POSS	0U 
#define	TIMER_CCVAL4_CCRV4_POSE	15U 
#define	TIMER_CCVAL4_CCRV4_MSK	BITS(TIMER_CCVAL4_CCRV4_POSS,TIMER_CCVAL4_CCRV4_POSE)

/****************** Bit definition for TIMER_BDCFG register ************************/

#define	TIMER_BDCFG_GOEN_POS	15U 
#define	TIMER_BDCFG_GOEN_MSK	BIT(TIMER_BDCFG_GOEN_POS)

#define	TIMER_BDCFG_AOEN_POS	14U 
#define	TIMER_BDCFG_AOEN_MSK	BIT(TIMER_BDCFG_AOEN_POS)

#define	TIMER_BDCFG_BRKP_POS	13U 
#define	TIMER_BDCFG_BRKP_MSK	BIT(TIMER_BDCFG_BRKP_POS)

#define	TIMER_BDCFG_BRKEN_POS	12U 
#define	TIMER_BDCFG_BRKEN_MSK	BIT(TIMER_BDCFG_BRKEN_POS)

#define	TIMER_BDCFG_OFFSSR_POS	11U 
#define	TIMER_BDCFG_OFFSSR_MSK	BIT(TIMER_BDCFG_OFFSSR_POS)

#define	TIMER_BDCFG_OFFSSI_POS	10U 
#define	TIMER_BDCFG_OFFSSI_MSK	BIT(TIMER_BDCFG_OFFSSI_POS)

#define	TIMER_BDCFG_LOCKLVL_POSS	8U 
#define	TIMER_BDCFG_LOCKLVL_POSE	9U 
#define	TIMER_BDCFG_LOCKLVL_MSK	BITS(TIMER_BDCFG_LOCKLVL_POSS,TIMER_BDCFG_LOCKLVL_POSE)

#define	TIMER_BDCFG_DT_POSS	0U 
#define	TIMER_BDCFG_DT_POSE	7U 
#define	TIMER_BDCFG_DT_MSK	BITS(TIMER_BDCFG_DT_POSS,TIMER_BDCFG_DT_POSE)

/****************** Bit definition for TIMER_DMAEN register ************************/

#define	TIMER_DMAEN_TRGDMA_POS	6U 
#define	TIMER_DMAEN_TRGDMA_MSK	BIT(TIMER_DMAEN_TRGDMA_POS)
					  
#define	TIMER_DMAEN_COMD_POS	5U        
#define	TIMER_DMAEN_COMD_MSK	BIT(TIMER_DMAEN_COMD_POS)
					  
#define	TIMER_DMAEN_CC4D_POS	4U        
#define	TIMER_DMAEN_CC4D_MSK	BIT(TIMER_DMAEN_CC4D_POS)
					  
#define	TIMER_DMAEN_CC3D_POS	3U        
#define	TIMER_DMAEN_CC3D_MSK	BIT(TIMER_DMAEN_CC3D_POS)
					  
#define	TIMER_DMAEN_CC2D_POS	2U        
#define	TIMER_DMAEN_CC2D_MSK	BIT(TIMER_DMAEN_CC2D_POS)
					  
#define	TIMER_DMAEN_CC1D_POS	1U        
#define	TIMER_DMAEN_CC1D_MSK	BIT(TIMER_DMAEN_CC1D_POS)
					  
#define	TIMER_DMAEN_UD_POS	0U        
#define	TIMER_DMAEN_UD_MSK	BIT(TIMER_DMAEN_UD_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t SMCON;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
	__O uint32_t SGE;
	__IO uint32_t CHMR1;
	__IO uint32_t CHMR2;
	__IO uint32_t CCEP;
	__IO uint32_t COUNT;
	__IO uint32_t PRES;
	__IO uint32_t AR;
	__IO uint32_t REPAR;
	__IO uint32_t CCVAL1;
	__IO uint32_t CCVAL2;
	__IO uint32_t CCVAL3;
	__IO uint32_t CCVAL4;
	__IO uint32_t BDCFG;
	__IO uint32_t DMAEN;
} TIMER_TypeDef;

#ifdef ES32F36xx
#define	TIMER0  AD16C4T0
#define	TIMER1  AD16C4T1
#define	TIMER2  GP32C4T0
#define	TIMER3  GP32C4T1
#define	TIMER4  BS16T0	
#define	TIMER5  BS16T1	
#define	TIMER6  GP16C4T0
#define	TIMER7  GP16C4T1
#else
#define	TIMER0  GP16C4T0
#define	TIMER1  GP16C4T1
#define	TIMER2  GP32C4T0
#define	TIMER3  GP32C4T1
#define	TIMER4  BS16T0	
#define	TIMER5  BS16T1	
#define	TIMER6  GP16C4T2
#define	TIMER7  GP16C4T3
#endif

/****************** Bit definition for USART_STAT register ************************/

#define	USART_STAT_CTSIF_POS	9U 
#define	USART_STAT_CTSIF_MSK	BIT(USART_STAT_CTSIF_POS)

#define	USART_STAT_TXEMPIF_POS	7U 
#define	USART_STAT_TXEMPIF_MSK	BIT(USART_STAT_TXEMPIF_POS)

#define	USART_STAT_TXCIF_POS	6U 
#define	USART_STAT_TXCIF_MSK	BIT(USART_STAT_TXCIF_POS)

#define	USART_STAT_RXNEIF_POS	5U 
#define	USART_STAT_RXNEIF_MSK	BIT(USART_STAT_RXNEIF_POS)

#define	USART_STAT_IDLEIF_POS	4U 
#define	USART_STAT_IDLEIF_MSK	BIT(USART_STAT_IDLEIF_POS)

#define	USART_STAT_OVRIF_POS	3U 
#define	USART_STAT_OVRIF_MSK	BIT(USART_STAT_OVRIF_POS)

#define	USART_STAT_NDETIF_POS	2U 
#define	USART_STAT_NDETIF_MSK	BIT(USART_STAT_NDETIF_POS)

#define	USART_STAT_FERRIF_POS	1U 
#define	USART_STAT_FERRIF_MSK	BIT(USART_STAT_FERRIF_POS)

#define	USART_STAT_PERRIF_POS	0U 
#define	USART_STAT_PERRIF_MSK	BIT(USART_STAT_PERRIF_POS)

/****************** Bit definition for USART_DATA register ************************/

#define	USART_DATA_VAL_POSS	0U 
#define	USART_DATA_VAL_POSE	8U 
#define	USART_DATA_VAL_MSK	BITS(USART_DATA_VAL_POSS,USART_DATA_VAL_POSE)

/****************** Bit definition for USART_BAUDCON register ************************/

#define	USART_BAUDCON_DIV_M_POSS	4U 
#define	USART_BAUDCON_DIV_M_POSE	15U 
#define	USART_BAUDCON_DIV_M_MSK	BITS(USART_BAUDCON_DIV_M_POSS,USART_BAUDCON_DIV_M_POSE)

#define	USART_BAUDCON_DIV_F_POSS	0U 
#define	USART_BAUDCON_DIV_F_POSE	3U 
#define	USART_BAUDCON_DIV_F_MSK	BITS(USART_BAUDCON_DIV_F_POSS,USART_BAUDCON_DIV_F_POSE)

/****************** Bit definition for USART_CON0 register ************************/

#define	USART_CON0_EN_POS	13U 
#define	USART_CON0_EN_MSK	BIT(USART_CON0_EN_POS)

#define	USART_CON0_DLEN_POS	12U 
#define	USART_CON0_DLEN_MSK	BIT(USART_CON0_DLEN_POS)

#define	USART_CON0_WKMOD_POS	11U 
#define	USART_CON0_WKMOD_MSK	BIT(USART_CON0_WKMOD_POS)

#define	USART_CON0_PEN_POS	10U 
#define	USART_CON0_PEN_MSK	BIT(USART_CON0_PEN_POS)

#define	USART_CON0_PSEL_POS	9U 
#define	USART_CON0_PSEL_MSK	BIT(USART_CON0_PSEL_POS)

#define	USART_CON0_PERRIE_POS	8U 
#define	USART_CON0_PERRIE_MSK	BIT(USART_CON0_PERRIE_POS)

#define	USART_CON0_TXEMPIE_POS	7U 
#define	USART_CON0_TXEMPIE_MSK	BIT(USART_CON0_TXEMPIE_POS)

#define	USART_CON0_TXCIE_POS	6U 
#define	USART_CON0_TXCIE_MSK	BIT(USART_CON0_TXCIE_POS)

#define	USART_CON0_RXNEIE_POS	5U 
#define	USART_CON0_RXNEIE_MSK	BIT(USART_CON0_RXNEIE_POS)

#define	USART_CON0_IDLEIE_POS	4U 
#define	USART_CON0_IDLEIE_MSK	BIT(USART_CON0_IDLEIE_POS)

#define	USART_CON0_TXEN_POS	3U 
#define	USART_CON0_TXEN_MSK	BIT(USART_CON0_TXEN_POS)

#define	USART_CON0_RXEN_POS	2U 
#define	USART_CON0_RXEN_MSK	BIT(USART_CON0_RXEN_POS)

#define	USART_CON0_RXWK_POS	1U 
#define	USART_CON0_RXWK_MSK	BIT(USART_CON0_RXWK_POS)

/****************** Bit definition for USART_CON1 register ************************/

#define	USART_CON1_STPLEN_POSS	12U 
#define	USART_CON1_STPLEN_POSE	13U 
#define	USART_CON1_STPLEN_MSK	BITS(USART_CON1_STPLEN_POSS,USART_CON1_STPLEN_POSE)

#define	USART_CON1_SCKEN_POS	11U 
#define	USART_CON1_SCKEN_MSK	BIT(USART_CON1_SCKEN_POS)

#define	USART_CON1_SCKPOL_POS	10U 
#define	USART_CON1_SCKPOL_MSK	BIT(USART_CON1_SCKPOL_POS)

#define	USART_CON1_SCKPHA_POS	9U 
#define	USART_CON1_SCKPHA_MSK	BIT(USART_CON1_SCKPHA_POS)

#define	USART_CON1_LBCP_POS	8U 
#define	USART_CON1_LBCP_MSK	BIT(USART_CON1_LBCP_POS)

#define	USART_CON1_ADDR_POSS	0U 
#define	USART_CON1_ADDR_POSE	3U 
#define	USART_CON1_ADDR_MSK	BITS(USART_CON1_ADDR_POSS,USART_CON1_ADDR_POSE)

/****************** Bit definition for USART_CON2 register ************************/

#define	USART_CON2_CTSIE_POS	10U 
#define	USART_CON2_CTSIE_MSK	BIT(USART_CON2_CTSIE_POS)

#define	USART_CON2_CTSEN_POS	9U 
#define	USART_CON2_CTSEN_MSK	BIT(USART_CON2_CTSEN_POS)

#define	USART_CON2_RTSEN_POS	8U 
#define	USART_CON2_RTSEN_MSK	BIT(USART_CON2_RTSEN_POS)

#define	USART_CON2_TXDMAEN_POS	7U 
#define	USART_CON2_TXDMAEN_MSK	BIT(USART_CON2_TXDMAEN_POS)

#define	USART_CON2_RXDMAEN_POS	6U 
#define	USART_CON2_RXDMAEN_MSK	BIT(USART_CON2_RXDMAEN_POS)

#define	USART_CON2_SMARTEN_POS	5U 
#define	USART_CON2_SMARTEN_MSK	BIT(USART_CON2_SMARTEN_POS)

#define	USART_CON2_NACK_POS	4U 
#define	USART_CON2_NACK_MSK	BIT(USART_CON2_NACK_POS)

#define	USART_CON2_HDPSEL_POS	3U 
#define	USART_CON2_HDPSEL_MSK	BIT(USART_CON2_HDPSEL_POS)

#define	USART_CON2_IREN_POS	1U 
#define	USART_CON2_IREN_MSK	BIT(USART_CON2_IREN_POS)

#define	USART_CON2_ERRIE_POS	0U 
#define	USART_CON2_ERRIE_MSK	BIT(USART_CON2_ERRIE_POS)

/****************** Bit definition for USART_GP register ************************/

#define	USART_GP_GTVAL_POSS	8U 
#define	USART_GP_GTVAL_POSE	15U 
#define	USART_GP_GTVAL_MSK	BITS(USART_GP_GTVAL_POSS,USART_GP_GTVAL_POSE)

#define	USART_GP_PSC_POSS	0U 
#define	USART_GP_PSC_POSE	7U 
#define	USART_GP_PSC_MSK	BITS(USART_GP_PSC_POSS,USART_GP_PSC_POSE)

typedef struct
{
	__IO uint32_t STAT;
	__IO uint32_t DATA;
	__IO uint32_t BAUDCON;
	__IO uint32_t CON0;
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t GP;
} USART_TypeDef;

/****************** Bit definition for UART_RXBUF register ************************/

#define	UART_RXBUF_RXBUF_POSS	0U 
#define	UART_RXBUF_RXBUF_POSE	8U 
#define	UART_RXBUF_RXBUF_MSK	BITS(UART_RXBUF_RXBUF_POSS,UART_RXBUF_RXBUF_POSE)

/****************** Bit definition for UART_TXBUF register ************************/

#define	UART_TXBUF_TXBUF_POSS	0U 
#define	UART_TXBUF_TXBUF_POSE	8U 
#define	UART_TXBUF_TXBUF_MSK	BITS(UART_TXBUF_TXBUF_POSS,UART_TXBUF_TXBUF_POSE)

/****************** Bit definition for UART_BRR register ************************/

#define	UART_BRR_BRR_POSS	0U 
#define	UART_BRR_BRR_POSE	15U 
#define	UART_BRR_BRR_MSK	BITS(UART_BRR_BRR_POSS,UART_BRR_BRR_POSE)

/****************** Bit definition for UART_LCON register ************************/

#define	UART_LCON_TXEN_POS	15U 
#define	UART_LCON_TXEN_MSK	BIT(UART_LCON_TXEN_POS)

#define	UART_LCON_RXEN_POS	14U 
#define	UART_LCON_RXEN_MSK	BIT(UART_LCON_RXEN_POS)

#define	UART_LCON_DBCEN_POS	13U 
#define	UART_LCON_DBCEN_MSK	BIT(UART_LCON_DBCEN_POS)

#define	UART_LCON_BREAK_POS	10U 
#define	UART_LCON_BREAK_MSK	BIT(UART_LCON_BREAK_POS)

#define	UART_LCON_SWAP_POS	9U 
#define	UART_LCON_SWAP_MSK	BIT(UART_LCON_SWAP_POS)

#define	UART_LCON_TXINV_POS	8U 
#define	UART_LCON_TXINV_MSK	BIT(UART_LCON_TXINV_POS)

#define	UART_LCON_RXINV_POS	7U 
#define	UART_LCON_RXINV_MSK	BIT(UART_LCON_RXINV_POS)

#define	UART_LCON_DATAINV_POS	6U 
#define	UART_LCON_DATAINV_MSK	BIT(UART_LCON_DATAINV_POS)

#define	UART_LCON_MSB_POS	5U 
#define	UART_LCON_MSB_MSK	BIT(UART_LCON_MSB_POS)

#define	UART_LCON_PS_POS	4U 
#define	UART_LCON_PS_MSK	BIT(UART_LCON_PS_POS)

#define	UART_LCON_PE_POS	3U 
#define	UART_LCON_PE_MSK	BIT(UART_LCON_PE_POS)

#define	UART_LCON_STOP_POS	2U 
#define	UART_LCON_STOP_MSK	BIT(UART_LCON_STOP_POS)

#define	UART_LCON_DLS_POSS	0U 
#define	UART_LCON_DLS_POSE	1U 
#define	UART_LCON_DLS_MSK	BITS(UART_LCON_DLS_POSS,UART_LCON_DLS_POSE)

/****************** Bit definition for UART_MCON register ************************/

#define	UART_MCON_TXDMAEN_POS	15U 
#define	UART_MCON_TXDMAEN_MSK	BIT(UART_MCON_TXDMAEN_POS)

#define	UART_MCON_RXDMAEN_POS	14U 
#define	UART_MCON_RXDMAEN_MSK	BIT(UART_MCON_RXDMAEN_POS)

#define	UART_MCON_ABRREPT_POS	11U 
#define	UART_MCON_ABRREPT_MSK	BIT(UART_MCON_ABRREPT_POS)

#define	UART_MCON_ABRMOD_POSS	9U 
#define	UART_MCON_ABRMOD_POSE	10U 
#define	UART_MCON_ABRMOD_MSK	BITS(UART_MCON_ABRMOD_POSS,UART_MCON_ABRMOD_POSE)

#define	UART_MCON_ABREN_POS	8U 
#define	UART_MCON_ABREN_MSK	BIT(UART_MCON_ABREN_POS)

#define	UART_MCON_BKREQ_POS	5U 
#define	UART_MCON_BKREQ_MSK	BIT(UART_MCON_BKREQ_POS)

#define	UART_MCON_HDEN_POS	4U 
#define	UART_MCON_HDEN_MSK	BIT(UART_MCON_HDEN_POS)

#define	UART_MCON_IREN_POS	3U 
#define	UART_MCON_IREN_MSK	BIT(UART_MCON_IREN_POS)

#define	UART_MCON_AFCEN_POS	2U 
#define	UART_MCON_AFCEN_MSK	BIT(UART_MCON_AFCEN_POS)

#define	UART_MCON_RTSSET_POS	1U 
#define	UART_MCON_RTSSET_MSK	BIT(UART_MCON_RTSSET_POS)

#define	UART_MCON_LPBKEN_POS	0U 
#define	UART_MCON_LPBKEN_MSK	BIT(UART_MCON_LPBKEN_POS)

/****************** Bit definition for UART_RS485 register ************************/

#define	UART_RS485_DLY_POSS	16U 
#define	UART_RS485_DLY_POSE	23U 
#define	UART_RS485_DLY_MSK	BITS(UART_RS485_DLY_POSS,UART_RS485_DLY_POSE)

#define	UART_RS485_ADDR_POSS	8U 
#define	UART_RS485_ADDR_POSE	15U 
#define	UART_RS485_ADDR_MSK	BITS(UART_RS485_ADDR_POSS,UART_RS485_ADDR_POSE)

#define	UART_RS485_AADINV_POS	3U 
#define	UART_RS485_AADINV_MSK	BIT(UART_RS485_AADINV_POS)

#define	UART_RS485_AADACEN_POS	2U 
#define	UART_RS485_AADACEN_MSK	BIT(UART_RS485_AADACEN_POS)

#define	UART_RS485_AADNEN_POS	1U 
#define	UART_RS485_AADNEN_MSK	BIT(UART_RS485_AADNEN_POS)

#define	UART_RS485_AADEN_POS	0U 
#define	UART_RS485_AADEN_MSK	BIT(UART_RS485_AADEN_POS)

/****************** Bit definition for UART_SCARD register ************************/

#define	UART_SCARD_BLEN_POSS	24U 
#define	UART_SCARD_BLEN_POSE	31U 
#define	UART_SCARD_BLEN_MSK	BITS(UART_SCARD_BLEN_POSS,UART_SCARD_BLEN_POSE)

#define	UART_SCARD_GT_POSS	16U 
#define	UART_SCARD_GT_POSE	23U 
#define	UART_SCARD_GT_MSK	BITS(UART_SCARD_GT_POSS,UART_SCARD_GT_POSE)

#define	UART_SCARD_PSC_POSS	8U 
#define	UART_SCARD_PSC_POSE	15U 
#define	UART_SCARD_PSC_MSK	BITS(UART_SCARD_PSC_POSS,UART_SCARD_PSC_POSE)

#define	UART_SCARD_SCCNT_POSS	3U 
#define	UART_SCARD_SCCNT_POSE	5U 
#define	UART_SCARD_SCCNT_MSK	BITS(UART_SCARD_SCCNT_POSS,UART_SCARD_SCCNT_POSE)

#define	UART_SCARD_SCLKEN_POS	2U 
#define	UART_SCARD_SCLKEN_MSK	BIT(UART_SCARD_SCLKEN_POS)

#define	UART_SCARD_SCNACK_POS	1U 
#define	UART_SCARD_SCNACK_MSK	BIT(UART_SCARD_SCNACK_POS)

#define	UART_SCARD_SCEN_POS	0U 
#define	UART_SCARD_SCEN_MSK	BIT(UART_SCARD_SCEN_POS)

/****************** Bit definition for UART_LIN register ************************/

#define	UART_LIN_LINBKREQ_POS	2U 
#define	UART_LIN_LINBKREQ_MSK	BIT(UART_LIN_LINBKREQ_POS)

#define	UART_LIN_LINBDL_POS	1U 
#define	UART_LIN_LINBDL_MSK	BIT(UART_LIN_LINBDL_POS)

#define	UART_LIN_LINEN_POS	0U 
#define	UART_LIN_LINEN_MSK	BIT(UART_LIN_LINEN_POS)

/****************** Bit definition for UART_RTOR register ************************/

#define	UART_RTOR_RTOEN_POS	24U 
#define	UART_RTOR_RTOEN_MSK	BIT(UART_RTOR_RTOEN_POS)

#define	UART_RTOR_RTO_POSS	0U 
#define	UART_RTOR_RTO_POSE	23U 
#define	UART_RTOR_RTO_MSK	BITS(UART_RTOR_RTO_POSS,UART_RTOR_RTO_POSE)

/****************** Bit definition for UART_FCON register ************************/

#define	UART_FCON_TXFL_POSS	11U 
#define	UART_FCON_TXFL_POSE	15U 
#define	UART_FCON_TXFL_MSK	BITS(UART_FCON_TXFL_POSS,UART_FCON_TXFL_POSE)

#define	UART_FCON_TXTH_POSS	9U 
#define	UART_FCON_TXTH_POSE	10U 
#define	UART_FCON_TXTH_MSK	BITS(UART_FCON_TXTH_POSS,UART_FCON_TXTH_POSE)

#define	UART_FCON_TFRST_POS	8U 
#define	UART_FCON_TFRST_MSK	BIT(UART_FCON_TFRST_POS)

#define	UART_FCON_RXFL_POSS	3U 
#define	UART_FCON_RXFL_POSE	7U 
#define	UART_FCON_RXFL_MSK	BITS(UART_FCON_RXFL_POSS,UART_FCON_RXFL_POSE)

#define	UART_FCON_RXTH_POSS	1U 
#define	UART_FCON_RXTH_POSE	2U 
#define	UART_FCON_RXTH_MSK	BITS(UART_FCON_RXTH_POSS,UART_FCON_RXTH_POSE)

#define	UART_FCON_RFRST_POS	0U 
#define	UART_FCON_RFRST_MSK	BIT(UART_FCON_RFRST_POS)

/****************** Bit definition for UART_STAT register ************************/

#define	UART_STAT_TFOERR_POS	18U 
#define	UART_STAT_TFOERR_MSK	BIT(UART_STAT_TFOERR_POS)

#define	UART_STAT_TFFULL_POS	17U 
#define	UART_STAT_TFFULL_MSK	BIT(UART_STAT_TFFULL_POS)

#define	UART_STAT_TFEMPTY_POS	16U 
#define	UART_STAT_TFEMPTY_MSK	BIT(UART_STAT_TFEMPTY_POS)

#define	UART_STAT_TFTH_POS	15U 
#define	UART_STAT_TFTH_MSK	BIT(UART_STAT_TFTH_POS)

#define	UART_STAT_TSBUSY_POS	14U 
#define	UART_STAT_TSBUSY_MSK	BIT(UART_STAT_TSBUSY_POS)

#define	UART_STAT_RFUERR_POS	13U 
#define	UART_STAT_RFUERR_MSK	BIT(UART_STAT_RFUERR_POS)

#define	UART_STAT_RFOERR_POS	12U 
#define	UART_STAT_RFOERR_MSK	BIT(UART_STAT_RFOERR_POS)

#define	UART_STAT_RFFULL_POS	11U 
#define	UART_STAT_RFFULL_MSK	BIT(UART_STAT_RFFULL_POS)

#define	UART_STAT_RFEMPTY_POS	10U 
#define	UART_STAT_RFEMPTY_MSK	BIT(UART_STAT_RFEMPTY_POS)

#define	UART_STAT_RFTH_POS	9U 
#define	UART_STAT_RFTH_MSK	BIT(UART_STAT_RFTH_POS)

#define	UART_STAT_RSBUSY_POS	8U 
#define	UART_STAT_RSBUSY_MSK	BIT(UART_STAT_RSBUSY_POS)

#define	UART_STAT_CTSSTA_POS	3U 
#define	UART_STAT_CTSSTA_MSK	BIT(UART_STAT_CTSSTA_POS)

#define	UART_STAT_BKERR_POS	2U 
#define	UART_STAT_BKERR_MSK	BIT(UART_STAT_BKERR_POS)

#define	UART_STAT_FERR_POS	1U 
#define	UART_STAT_FERR_MSK	BIT(UART_STAT_FERR_POS)

#define	UART_STAT_PERR_POS	0U 
#define	UART_STAT_PERR_MSK	BIT(UART_STAT_PERR_POS)

/****************** Bit definition for UART_IER register ************************/

#define	UART_IER_TFOVER_POS	18U 
#define	UART_IER_TFOVER_MSK	BIT(UART_IER_TFOVER_POS)

#define	UART_IER_TFEMPTY_POS	16U 
#define	UART_IER_TFEMPTY_MSK	BIT(UART_IER_TFEMPTY_POS)

#define	UART_IER_TFTH_POS	15U 
#define	UART_IER_TFTH_MSK	BIT(UART_IER_TFTH_POS)

#define	UART_IER_TBC_POS	14U 
#define	UART_IER_TBC_MSK	BIT(UART_IER_TBC_POS)

#define	UART_IER_RFUERR_POS	13U 
#define	UART_IER_RFUERR_MSK	BIT(UART_IER_RFUERR_POS)

#define	UART_IER_RFOERR_POS	12U 
#define	UART_IER_RFOERR_MSK	BIT(UART_IER_RFOERR_POS)

#define	UART_IER_RFFULL_POS	11U 
#define	UART_IER_RFFULL_MSK	BIT(UART_IER_RFFULL_POS)

#define	UART_IER_RFTH_POS	9U 
#define	UART_IER_RFTH_MSK	BIT(UART_IER_RFTH_POS)

#define	UART_IER_NOISE_POS	8U 
#define	UART_IER_NOISE_MSK	BIT(UART_IER_NOISE_POS)

#define	UART_IER_EOB_POS	7U 
#define	UART_IER_EOB_MSK	BIT(UART_IER_EOB_POS)

#define	UART_IER_LINBK_POS	6U 
#define	UART_IER_LINBK_MSK	BIT(UART_IER_LINBK_POS)

#define	UART_IER_ADDRM_POS	5U 
#define	UART_IER_ADDRM_MSK	BIT(UART_IER_ADDRM_POS)

#define	UART_IER_RXTO_POS	4U 
#define	UART_IER_RXTO_MSK	BIT(UART_IER_RXTO_POS)

#define	UART_IER_DCTS_POS	3U 
#define	UART_IER_DCTS_MSK	BIT(UART_IER_DCTS_POS)

#define	UART_IER_ABTO_POS	2U 
#define	UART_IER_ABTO_MSK	BIT(UART_IER_ABTO_POS)

#define	UART_IER_ABEND_POS	1U 
#define	UART_IER_ABEND_MSK	BIT(UART_IER_ABEND_POS)

#define	UART_IER_RXBERR_POS	0U 
#define	UART_IER_RXBERR_MSK	BIT(UART_IER_RXBERR_POS)

/****************** Bit definition for UART_IDR register ************************/

#define	UART_IDR_TFOVER_POS	18U 
#define	UART_IDR_TFOVER_MSK	BIT(UART_IDR_TFOVER_POS)

#define	UART_IDR_TFEMPTY_POS	16U 
#define	UART_IDR_TFEMPTY_MSK	BIT(UART_IDR_TFEMPTY_POS)

#define	UART_IDR_TFTH_POS	15U 
#define	UART_IDR_TFTH_MSK	BIT(UART_IDR_TFTH_POS)

#define	UART_IDR_TBC_POS	14U 
#define	UART_IDR_TBC_MSK	BIT(UART_IDR_TBC_POS)

#define	UART_IDR_RFUERR_POS	13U 
#define	UART_IDR_RFUERR_MSK	BIT(UART_IDR_RFUERR_POS)

#define	UART_IDR_RFOERR_POS	12U 
#define	UART_IDR_RFOERR_MSK	BIT(UART_IDR_RFOERR_POS)

#define	UART_IDR_RFFULL_POS	11U 
#define	UART_IDR_RFFULL_MSK	BIT(UART_IDR_RFFULL_POS)

#define	UART_IDR_RFTH_POS	9U 
#define	UART_IDR_RFTH_MSK	BIT(UART_IDR_RFTH_POS)

#define	UART_IDR_NOISE_POS	8U 
#define	UART_IDR_NOISE_MSK	BIT(UART_IDR_NOISE_POS)

#define	UART_IDR_EOB_POS	7U 
#define	UART_IDR_EOB_MSK	BIT(UART_IDR_EOB_POS)

#define	UART_IDR_LINBK_POS	6U 
#define	UART_IDR_LINBK_MSK	BIT(UART_IDR_LINBK_POS)

#define	UART_IDR_ADDRM_POS	5U 
#define	UART_IDR_ADDRM_MSK	BIT(UART_IDR_ADDRM_POS)

#define	UART_IDR_RXTO_POS	4U 
#define	UART_IDR_RXTO_MSK	BIT(UART_IDR_RXTO_POS)

#define	UART_IDR_DCTS_POS	3U 
#define	UART_IDR_DCTS_MSK	BIT(UART_IDR_DCTS_POS)

#define	UART_IDR_ABTO_POS	2U 
#define	UART_IDR_ABTO_MSK	BIT(UART_IDR_ABTO_POS)

#define	UART_IDR_ABEND_POS	1U 
#define	UART_IDR_ABEND_MSK	BIT(UART_IDR_ABEND_POS)

#define	UART_IDR_RXBERR_POS	0U 
#define	UART_IDR_RXBERR_MSK	BIT(UART_IDR_RXBERR_POS)

/****************** Bit definition for UART_IVS register ************************/

#define	UART_IVS_TFOVER_POS	18U 
#define	UART_IVS_TFOVER_MSK	BIT(UART_IVS_TFOVER_POS)

#define	UART_IVS_TFEMPTY_POS	16U 
#define	UART_IVS_TFEMPTY_MSK	BIT(UART_IVS_TFEMPTY_POS)

#define	UART_IVS_TFTH_POS	15U 
#define	UART_IVS_TFTH_MSK	BIT(UART_IVS_TFTH_POS)

#define	UART_IVS_TBC_POS	14U 
#define	UART_IVS_TBC_MSK	BIT(UART_IVS_TBC_POS)

#define	UART_IVS_RFUERR_POS	13U 
#define	UART_IVS_RFUERR_MSK	BIT(UART_IVS_RFUERR_POS)

#define	UART_IVS_RFOERR_POS	12U 
#define	UART_IVS_RFOERR_MSK	BIT(UART_IVS_RFOERR_POS)

#define	UART_IVS_RFFULL_POS	11U 
#define	UART_IVS_RFFULL_MSK	BIT(UART_IVS_RFFULL_POS)

#define	UART_IVS_RFTH_POS	9U 
#define	UART_IVS_RFTH_MSK	BIT(UART_IVS_RFTH_POS)

#define	UART_IVS_NOISE_POS	8U 
#define	UART_IVS_NOISE_MSK	BIT(UART_IVS_NOISE_POS)

#define	UART_IVS_EOB_POS	7U 
#define	UART_IVS_EOB_MSK	BIT(UART_IVS_EOB_POS)

#define	UART_IVS_LINBK_POS	6U 
#define	UART_IVS_LINBK_MSK	BIT(UART_IVS_LINBK_POS)

#define	UART_IVS_ADDRM_POS	5U 
#define	UART_IVS_ADDRM_MSK	BIT(UART_IVS_ADDRM_POS)

#define	UART_IVS_RXTO_POS	4U 
#define	UART_IVS_RXTO_MSK	BIT(UART_IVS_RXTO_POS)

#define	UART_IVS_DCTS_POS	3U 
#define	UART_IVS_DCTS_MSK	BIT(UART_IVS_DCTS_POS)

#define	UART_IVS_ABTO_POS	2U 
#define	UART_IVS_ABTO_MSK	BIT(UART_IVS_ABTO_POS)

#define	UART_IVS_ABEND_POS	1U 
#define	UART_IVS_ABEND_MSK	BIT(UART_IVS_ABEND_POS)

#define	UART_IVS_RXBERR_POS	0U 
#define	UART_IVS_RXBERR_MSK	BIT(UART_IVS_RXBERR_POS)

/****************** Bit definition for UART_RIF register ************************/

#define	UART_RIF_TFOVER_POS	18U 
#define	UART_RIF_TFOVER_MSK	BIT(UART_RIF_TFOVER_POS)

#define	UART_RIF_TFEMPTY_POS	16U 
#define	UART_RIF_TFEMPTY_MSK	BIT(UART_RIF_TFEMPTY_POS)

#define	UART_RIF_TFTH_POS	15U 
#define	UART_RIF_TFTH_MSK	BIT(UART_RIF_TFTH_POS)

#define	UART_RIF_TBC_POS	14U 
#define	UART_RIF_TBC_MSK	BIT(UART_RIF_TBC_POS)

#define	UART_RIF_RFUERR_POS	13U 
#define	UART_RIF_RFUERR_MSK	BIT(UART_RIF_RFUERR_POS)

#define	UART_RIF_RFOERR_POS	12U 
#define	UART_RIF_RFOERR_MSK	BIT(UART_RIF_RFOERR_POS)

#define	UART_RIF_RFFULL_POS	11U 
#define	UART_RIF_RFFULL_MSK	BIT(UART_RIF_RFFULL_POS)

#define	UART_RIF_RFTH_POS	9U 
#define	UART_RIF_RFTH_MSK	BIT(UART_RIF_RFTH_POS)

#define	UART_RIF_NOISE_POS	8U 
#define	UART_RIF_NOISE_MSK	BIT(UART_RIF_NOISE_POS)

#define	UART_RIF_EOB_POS	7U 
#define	UART_RIF_EOB_MSK	BIT(UART_RIF_EOB_POS)

#define	UART_RIF_LINBK_POS	6U 
#define	UART_RIF_LINBK_MSK	BIT(UART_RIF_LINBK_POS)

#define	UART_RIF_ADDRM_POS	5U 
#define	UART_RIF_ADDRM_MSK	BIT(UART_RIF_ADDRM_POS)

#define	UART_RIF_RXTO_POS	4U 
#define	UART_RIF_RXTO_MSK	BIT(UART_RIF_RXTO_POS)

#define	UART_RIF_DCTS_POS	3U 
#define	UART_RIF_DCTS_MSK	BIT(UART_RIF_DCTS_POS)

#define	UART_RIF_ABTO_POS	2U 
#define	UART_RIF_ABTO_MSK	BIT(UART_RIF_ABTO_POS)

#define	UART_RIF_ABEND_POS	1U 
#define	UART_RIF_ABEND_MSK	BIT(UART_RIF_ABEND_POS)

#define	UART_RIF_RXBERR_POS	0U 
#define	UART_RIF_RXBERR_MSK	BIT(UART_RIF_RXBERR_POS)

/****************** Bit definition for UART_IFM register ************************/

#define	UART_IFM_TFOVER_POS	18U 
#define	UART_IFM_TFOVER_MSK	BIT(UART_IFM_TFOVER_POS)

#define	UART_IFM_TFEMPTY_POS	16U 
#define	UART_IFM_TFEMPTY_MSK	BIT(UART_IFM_TFEMPTY_POS)

#define	UART_IFM_TFTH_POS	15U 
#define	UART_IFM_TFTH_MSK	BIT(UART_IFM_TFTH_POS)

#define	UART_IFM_TBC_POS	14U 
#define	UART_IFM_TBC_MSK	BIT(UART_IFM_TBC_POS)

#define	UART_IFM_RFUERR_POS	13U 
#define	UART_IFM_RFUERR_MSK	BIT(UART_IFM_RFUERR_POS)

#define	UART_IFM_RFOERR_POS	12U 
#define	UART_IFM_RFOERR_MSK	BIT(UART_IFM_RFOERR_POS)

#define	UART_IFM_RFFULL_POS	11U 
#define	UART_IFM_RFFULL_MSK	BIT(UART_IFM_RFFULL_POS)

#define	UART_IFM_RFTH_POS	9U 
#define	UART_IFM_RFTH_MSK	BIT(UART_IFM_RFTH_POS)

#define	UART_IFM_NOISE_POS	8U 
#define	UART_IFM_NOISE_MSK	BIT(UART_IFM_NOISE_POS)

#define	UART_IFM_EOB_POS	7U 
#define	UART_IFM_EOB_MSK	BIT(UART_IFM_EOB_POS)

#define	UART_IFM_LINBK_POS	6U 
#define	UART_IFM_LINBK_MSK	BIT(UART_IFM_LINBK_POS)

#define	UART_IFM_ADDRM_POS	5U 
#define	UART_IFM_ADDRM_MSK	BIT(UART_IFM_ADDRM_POS)

#define	UART_IFM_RXTO_POS	4U 
#define	UART_IFM_RXTO_MSK	BIT(UART_IFM_RXTO_POS)

#define	UART_IFM_DCTS_POS	3U 
#define	UART_IFM_DCTS_MSK	BIT(UART_IFM_DCTS_POS)

#define	UART_IFM_ABTO_POS	2U 
#define	UART_IFM_ABTO_MSK	BIT(UART_IFM_ABTO_POS)

#define	UART_IFM_ABEND_POS	1U 
#define	UART_IFM_ABEND_MSK	BIT(UART_IFM_ABEND_POS)

#define	UART_IFM_RXBERR_POS	0U 
#define	UART_IFM_RXBERR_MSK	BIT(UART_IFM_RXBERR_POS)

/****************** Bit definition for UART_ICR register ************************/

#define	UART_ICR_TFOVER_POS	18U 
#define	UART_ICR_TFOVER_MSK	BIT(UART_ICR_TFOVER_POS)

#define	UART_ICR_TFEMPTY_POS	16U 
#define	UART_ICR_TFEMPTY_MSK	BIT(UART_ICR_TFEMPTY_POS)

#define	UART_ICR_TFTH_POS	15U 
#define	UART_ICR_TFTH_MSK	BIT(UART_ICR_TFTH_POS)

#define	UART_ICR_TBC_POS	14U 
#define	UART_ICR_TBC_MSK	BIT(UART_ICR_TBC_POS)

#define	UART_ICR_RFUERR_POS	13U 
#define	UART_ICR_RFUERR_MSK	BIT(UART_ICR_RFUERR_POS)

#define	UART_ICR_RFOERR_POS	12U 
#define	UART_ICR_RFOERR_MSK	BIT(UART_ICR_RFOERR_POS)

#define	UART_ICR_RFFULL_POS	11U 
#define	UART_ICR_RFFULL_MSK	BIT(UART_ICR_RFFULL_POS)

#define	UART_ICR_RFTH_POS	9U 
#define	UART_ICR_RFTH_MSK	BIT(UART_ICR_RFTH_POS)

#define	UART_ICR_NOISE_POS	8U 
#define	UART_ICR_NOISE_MSK	BIT(UART_ICR_NOISE_POS)

#define	UART_ICR_EOB_POS	7U 
#define	UART_ICR_EOB_MSK	BIT(UART_ICR_EOB_POS)

#define	UART_ICR_LINBK_POS	6U 
#define	UART_ICR_LINBK_MSK	BIT(UART_ICR_LINBK_POS)

#define	UART_ICR_ADDRM_POS	5U 
#define	UART_ICR_ADDRM_MSK	BIT(UART_ICR_ADDRM_POS)

#define	UART_ICR_RXTO_POS	4U 
#define	UART_ICR_RXTO_MSK	BIT(UART_ICR_RXTO_POS)

#define	UART_ICR_DCTS_POS	3U 
#define	UART_ICR_DCTS_MSK	BIT(UART_ICR_DCTS_POS)

#define	UART_ICR_ABTO_POS	2U 
#define	UART_ICR_ABTO_MSK	BIT(UART_ICR_ABTO_POS)

#define	UART_ICR_ABEND_POS	1U 
#define	UART_ICR_ABEND_MSK	BIT(UART_ICR_ABEND_POS)

#define	UART_ICR_RXBERR_POS	0U 
#define	UART_ICR_RXBERR_MSK	BIT(UART_ICR_RXBERR_POS)

typedef struct
{
	__I uint32_t RXBUF;
	__IO uint32_t TXBUF;
	__IO uint32_t BRR;
	__IO uint32_t LCON;
	__IO uint32_t MCON;
	__IO uint32_t RS485;
	__IO uint32_t SCARD;
	__IO uint32_t LIN;
	__IO uint32_t RTOR;
	__O uint32_t FCON;
	__I uint32_t STAT;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} UART_TypeDef;


/****************** Bit definition for LPUART_CON0 register ************************/

#define	LPUART_CON0_MODESEL_POSS	30U 
#define	LPUART_CON0_MODESEL_POSE	31U 
#define	LPUART_CON0_MODESEL_MSK	BITS(LPUART_CON0_MODESEL_POSS,LPUART_CON0_MODESEL_POSE)

#define	LPUART_CON0_TXDMAE_POS	29U 
#define	LPUART_CON0_TXDMAE_MSK	BIT(LPUART_CON0_TXDMAE_POS)

#define	LPUART_CON0_RXDMAE_POS	28U 
#define	LPUART_CON0_RXDMAE_MSK	BIT(LPUART_CON0_RXDMAE_POS)

#define	LPUART_CON0_INTERVAL_POSS	16U 
#define	LPUART_CON0_INTERVAL_POSE	23U 
#define	LPUART_CON0_INTERVAL_MSK	BITS(LPUART_CON0_INTERVAL_POSS,LPUART_CON0_INTERVAL_POSE)

#define	LPUART_CON0_SYNCBP_POS	15U 
#define	LPUART_CON0_SYNCBP_MSK	BIT(LPUART_CON0_SYNCBP_POS)

#define	LPUART_CON0_CTSPOL_POS	13U 
#define	LPUART_CON0_CTSPOL_MSK	BIT(LPUART_CON0_CTSPOL_POS)

#define	LPUART_CON0_RTSPOL_POS	12U 
#define	LPUART_CON0_RTSPOL_MSK	BIT(LPUART_CON0_RTSPOL_POS)

#define	LPUART_CON0_ATCTSE_POS	11U 
#define	LPUART_CON0_ATCTSE_MSK	BIT(LPUART_CON0_ATCTSE_POS)

#define	LPUART_CON0_ATRTSE_POS	10U 
#define	LPUART_CON0_ATRTSE_MSK	BIT(LPUART_CON0_ATRTSE_POS)

#define	LPUART_CON0_BRKCE_POS	8U 
#define	LPUART_CON0_BRKCE_MSK	BIT(LPUART_CON0_BRKCE_POS)

#define	LPUART_CON0_LPBMOD_POS	7U 
#define	LPUART_CON0_LPBMOD_MSK	BIT(LPUART_CON0_LPBMOD_POS)

#define	LPUART_CON0_STICKPARSEL_POS	6U 
#define	LPUART_CON0_STICKPARSEL_MSK	BIT(LPUART_CON0_STICKPARSEL_POS)

#define	LPUART_CON0_EVENPARSEL_POS	5U 
#define	LPUART_CON0_EVENPARSEL_MSK	BIT(LPUART_CON0_EVENPARSEL_POS)

#define	LPUART_CON0_PARCHKE_POS	4U 
#define	LPUART_CON0_PARCHKE_MSK	BIT(LPUART_CON0_PARCHKE_POS)

#define	LPUART_CON0_STPLENTH_POS	3U 
#define	LPUART_CON0_STPLENTH_MSK	BIT(LPUART_CON0_STPLENTH_POS)

#define	LPUART_CON0_DATLENTH_POSS	0U 
#define	LPUART_CON0_DATLENTH_POSE	2U 
#define	LPUART_CON0_DATLENTH_MSK	BITS(LPUART_CON0_DATLENTH_POSS,LPUART_CON0_DATLENTH_POSE)

/****************** Bit definition for LPUART_CON1 register ************************/

#define	LPUART_CON1_ADDCMP_POSS	24U 
#define	LPUART_CON1_ADDCMP_POSE	31U 
#define	LPUART_CON1_ADDCMP_MSK	BITS(LPUART_CON1_ADDCMP_POSS,LPUART_CON1_ADDCMP_POSE)

#define	LPUART_CON1_ADETE_POS	23U 
#define	LPUART_CON1_ADETE_MSK	BIT(LPUART_CON1_ADETE_POS)

#define	LPUART_CON1_ATDIRM_POS	22U 
#define	LPUART_CON1_ATDIRM_MSK	BIT(LPUART_CON1_ATDIRM_POS)

#define	LPUART_CON1_ATADETE_POS	21U 
#define	LPUART_CON1_ATADETE_MSK	BIT(LPUART_CON1_ATADETE_POS)

#define	LPUART_CON1_NMPMOD_POS	20U 
#define	LPUART_CON1_NMPMOD_MSK	BIT(LPUART_CON1_NMPMOD_POS)

#define	LPUART_CON1_IRWIDTH_POS	16U 
#define	LPUART_CON1_IRWIDTH_MSK	BIT(LPUART_CON1_IRWIDTH_POS)

#define	LPUART_CON1_TOICMP_POSS	8U 
#define	LPUART_CON1_TOICMP_POSE	15U 
#define	LPUART_CON1_TOICMP_MSK	BITS(LPUART_CON1_TOICMP_POSS,LPUART_CON1_TOICMP_POSE)

#define	LPUART_CON1_TOCNTE_POS	7U 
#define	LPUART_CON1_TOCNTE_MSK	BIT(LPUART_CON1_TOCNTE_POS)

#define	LPUART_CON1_IRTXINV_POS	3U 
#define	LPUART_CON1_IRTXINV_MSK	BIT(LPUART_CON1_IRTXINV_POS)

#define	LPUART_CON1_IRRXINV_POS	2U 
#define	LPUART_CON1_IRRXINV_MSK	BIT(LPUART_CON1_IRRXINV_POS)

#define	LPUART_CON1_IRTXE_POS	1U 
#define	LPUART_CON1_IRTXE_MSK	BIT(LPUART_CON1_IRTXE_POS)

#define	LPUART_CON1_RTS_POS	0U 
#define	LPUART_CON1_RTS_MSK	BIT(LPUART_CON1_RTS_POS)

/****************** Bit definition for LPUART_CLKDIV register ************************/

#define	LPUART_CLKDIV_CLKDIV_POSS	0U 
#define	LPUART_CLKDIV_CLKDIV_POSE	19U 
#define	LPUART_CLKDIV_CLKDIV_MSK	BITS(LPUART_CLKDIV_CLKDIV_POSS,LPUART_CLKDIV_CLKDIV_POSE)

/****************** Bit definition for LPUART_FIFOCON register ************************/

#define	LPUART_FIFOCON_RTSTRGLVL_POSS	12U 
#define	LPUART_FIFOCON_RTSTRGLVL_POSE	15U 
#define	LPUART_FIFOCON_RTSTRGLVL_MSK	BITS(LPUART_FIFOCON_RTSTRGLVL_POSS,LPUART_FIFOCON_RTSTRGLVL_POSE)

#define	LPUART_FIFOCON_RXTRGLVL_POSS	8U 
#define	LPUART_FIFOCON_RXTRGLVL_POSE	11U 
#define	LPUART_FIFOCON_RXTRGLVL_MSK	BITS(LPUART_FIFOCON_RXTRGLVL_POSS,LPUART_FIFOCON_RXTRGLVL_POSE)

#define	LPUART_FIFOCON_NMPMRXDIS_POS	2U 
#define	LPUART_FIFOCON_NMPMRXDIS_MSK	BIT(LPUART_FIFOCON_NMPMRXDIS_POS)

#define	LPUART_FIFOCON_TXRESET_POS	1U 
#define	LPUART_FIFOCON_TXRESET_MSK	BIT(LPUART_FIFOCON_TXRESET_POS)

#define	LPUART_FIFOCON_RXRESET_POS	0U 
#define	LPUART_FIFOCON_RXRESET_MSK	BIT(LPUART_FIFOCON_RXRESET_POS)

/****************** Bit definition for LPUART_RXDR register ************************/

#define	LPUART_RXDR_FERR_POS	15U 
#define	LPUART_RXDR_FERR_MSK	BIT(LPUART_RXDR_FERR_POS)

#define	LPUART_RXDR_PERR_POS	14U 
#define	LPUART_RXDR_PERR_MSK	BIT(LPUART_RXDR_PERR_POS)

#define	LPUART_RXDR_RXDR_POSS	0U 
#define	LPUART_RXDR_RXDR_POSE	8U 
#define	LPUART_RXDR_RXDR_MSK	BITS(LPUART_RXDR_RXDR_POSS,LPUART_RXDR_RXDR_POSE)

/****************** Bit definition for LPUART_TXDR register ************************/

#define	LPUART_TXDR_TXDR_POSS	0U 
#define	LPUART_TXDR_TXDR_POSE	8U 
#define	LPUART_TXDR_TXDR_MSK	BITS(LPUART_TXDR_TXDR_POSS,LPUART_TXDR_TXDR_POSE)

/****************** Bit definition for LPUART_STAT register ************************/

#define	LPUART_STAT_RTSSTAT_POS	18U 
#define	LPUART_STAT_RTSSTAT_MSK	BIT(LPUART_STAT_RTSSTAT_POS)

#define	LPUART_STAT_CTSSTAT_POS	17U 
#define	LPUART_STAT_CTSSTAT_MSK	BIT(LPUART_STAT_CTSSTAT_POS)

#define	LPUART_STAT_TXIDLE_POS	16U 
#define	LPUART_STAT_TXIDLE_MSK	BIT(LPUART_STAT_TXIDLE_POS)

#define	LPUART_STAT_TXFULL_POS	15U 
#define	LPUART_STAT_TXFULL_MSK	BIT(LPUART_STAT_TXFULL_POS)

#define	LPUART_STAT_TXEMP_POS	14U 
#define	LPUART_STAT_TXEMP_MSK	BIT(LPUART_STAT_TXEMP_POS)

#define	LPUART_STAT_TXPTR_POSS	8U 
#define	LPUART_STAT_TXPTR_POSE	13U 
#define	LPUART_STAT_TXPTR_MSK	BITS(LPUART_STAT_TXPTR_POSS,LPUART_STAT_TXPTR_POSE)

#define	LPUART_STAT_RXFULL_POS	7U 
#define	LPUART_STAT_RXFULL_MSK	BIT(LPUART_STAT_RXFULL_POS)

#define	LPUART_STAT_RXEMP_POS	6U 
#define	LPUART_STAT_RXEMP_MSK	BIT(LPUART_STAT_RXEMP_POS)

#define	LPUART_STAT_RXPTR_POSS	0U 
#define	LPUART_STAT_RXPTR_POSE	5U 
#define	LPUART_STAT_RXPTR_MSK	BITS(LPUART_STAT_RXPTR_POSS,LPUART_STAT_RXPTR_POSE)

/****************** Bit definition for LPUART_IER register ************************/

#define	LPUART_IER_TCIE_POS	15U 
#define	LPUART_IER_TCIE_MSK	BIT(LPUART_IER_TCIE_POS)

#define	LPUART_IER_ADETIE_POS	12U 
#define	LPUART_IER_ADETIE_MSK	BIT(LPUART_IER_ADETIE_POS)

#define	LPUART_IER_BRKERRIE_POS	11U 
#define	LPUART_IER_BRKERRIE_MSK	BIT(LPUART_IER_BRKERRIE_POS)

#define	LPUART_IER_FERRIE_POS	10U 
#define	LPUART_IER_FERRIE_MSK	BIT(LPUART_IER_FERRIE_POS)

#define	LPUART_IER_PERRIE_POS	9U 
#define	LPUART_IER_PERRIE_MSK	BIT(LPUART_IER_PERRIE_POS)

#define	LPUART_IER_DATWKIE_POS	8U 
#define	LPUART_IER_DATWKIE_MSK	BIT(LPUART_IER_DATWKIE_POS)

#define	LPUART_IER_CTSWKIE_POS	7U 
#define	LPUART_IER_CTSWKIE_MSK	BIT(LPUART_IER_CTSWKIE_POS)

#define	LPUART_IER_TXOVIE_POS	5U 
#define	LPUART_IER_TXOVIE_MSK	BIT(LPUART_IER_TXOVIE_POS)

#define	LPUART_IER_RXOVIE_POS	4U 
#define	LPUART_IER_RXOVIE_MSK	BIT(LPUART_IER_RXOVIE_POS)

#define	LPUART_IER_RXTOIE_POS	3U 
#define	LPUART_IER_RXTOIE_MSK	BIT(LPUART_IER_RXTOIE_POS)

#define	LPUART_IER_CTSDETIE_POS	2U 
#define	LPUART_IER_CTSDETIE_MSK	BIT(LPUART_IER_CTSDETIE_POS)

#define	LPUART_IER_TBEMPIE_POS	1U 
#define	LPUART_IER_TBEMPIE_MSK	BIT(LPUART_IER_TBEMPIE_POS)

#define	LPUART_IER_RBRIE_POS	0U 
#define	LPUART_IER_RBRIE_MSK	BIT(LPUART_IER_RBRIE_POS)

/****************** Bit definition for LPUART_IFLAG register ************************/

#define	LPUART_IFLAG_TCIF_POS	15U 
#define	LPUART_IFLAG_TCIF_MSK	BIT(LPUART_IFLAG_TCIF_POS)

#define	LPUART_IFLAG_ADETIF_POS	12U 
#define	LPUART_IFLAG_ADETIF_MSK	BIT(LPUART_IFLAG_ADETIF_POS)

#define	LPUART_IFLAG_BRKERRIF_POS	11U 
#define	LPUART_IFLAG_BRKERRIF_MSK	BIT(LPUART_IFLAG_BRKERRIF_POS)

#define	LPUART_IFLAG_FERRIF_POS	10U 
#define	LPUART_IFLAG_FERRIF_MSK	BIT(LPUART_IFLAG_FERRIF_POS)

#define	LPUART_IFLAG_PERRIF_POS	9U 
#define	LPUART_IFLAG_PERRIF_MSK	BIT(LPUART_IFLAG_PERRIF_POS)

#define	LPUART_IFLAG_DATWKIF_POS	8U 
#define	LPUART_IFLAG_DATWKIF_MSK	BIT(LPUART_IFLAG_DATWKIF_POS)

#define	LPUART_IFLAG_CTSWKIF_POS	7U 
#define	LPUART_IFLAG_CTSWKIF_MSK	BIT(LPUART_IFLAG_CTSWKIF_POS)

#define	LPUART_IFLAG_TXOVIF_POS	5U 
#define	LPUART_IFLAG_TXOVIF_MSK	BIT(LPUART_IFLAG_TXOVIF_POS)

#define	LPUART_IFLAG_RXOVIF_POS	4U 
#define	LPUART_IFLAG_RXOVIF_MSK	BIT(LPUART_IFLAG_RXOVIF_POS)

#define	LPUART_IFLAG_RXTOIF_POS	3U 
#define	LPUART_IFLAG_RXTOIF_MSK	BIT(LPUART_IFLAG_RXTOIF_POS)

#define	LPUART_IFLAG_CTSDETIF_POS	2U 
#define	LPUART_IFLAG_CTSDETIF_MSK	BIT(LPUART_IFLAG_CTSDETIF_POS)

#define	LPUART_IFLAG_TBEMPIF_POS	1U 
#define	LPUART_IFLAG_TBEMPIF_MSK	BIT(LPUART_IFLAG_TBEMPIF_POS)

#define	LPUART_IFLAG_RBRIF_POS	0U 
#define	LPUART_IFLAG_RBRIF_MSK	BIT(LPUART_IFLAG_RBRIF_POS)

/****************** Bit definition for LPUART_IFC register ************************/

#define	LPUART_IFC_TCIFC_POS	15U 
#define	LPUART_IFC_TCIFC_MSK	BIT(LPUART_IFC_TCIFC_POS)

#define	LPUART_IFC_ADETIFC_POS	12U 
#define	LPUART_IFC_ADETIFC_MSK	BIT(LPUART_IFC_ADETIFC_POS)

#define	LPUART_IFC_BRKERRIFC_POS	11U 
#define	LPUART_IFC_BRKERRIFC_MSK	BIT(LPUART_IFC_BRKERRIFC_POS)

#define	LPUART_IFC_FERRIFC_POS	10U 
#define	LPUART_IFC_FERRIFC_MSK	BIT(LPUART_IFC_FERRIFC_POS)

#define	LPUART_IFC_PERRIFC_POS	9U 
#define	LPUART_IFC_PERRIFC_MSK	BIT(LPUART_IFC_PERRIFC_POS)

#define	LPUART_IFC_DATWKIFC_POS	8U 
#define	LPUART_IFC_DATWKIFC_MSK	BIT(LPUART_IFC_DATWKIFC_POS)

#define	LPUART_IFC_CTSWKIFC_POS	7U 
#define	LPUART_IFC_CTSWKIFC_MSK	BIT(LPUART_IFC_CTSWKIFC_POS)

#define	LPUART_IFC_TXOVIFC_POS	5U 
#define	LPUART_IFC_TXOVIFC_MSK	BIT(LPUART_IFC_TXOVIFC_POS)

#define	LPUART_IFC_RXOVIFC_POS	4U 
#define	LPUART_IFC_RXOVIFC_MSK	BIT(LPUART_IFC_RXOVIFC_POS)

#define	LPUART_IFC_CTSDETIFC_POS	2U 
#define	LPUART_IFC_CTSDETIFC_MSK	BIT(LPUART_IFC_CTSDETIFC_POS)

#define	LPUART_IFC_TBEMPIFC_POS	1U 
#define	LPUART_IFC_TBEMPIFC_MSK	BIT(LPUART_IFC_TBEMPIFC_POS)

#define	LPUART_IFC_RBRIFC_POS	0U 
#define	LPUART_IFC_RBRIFC_MSK	BIT(LPUART_IFC_RBRIFC_POS)

/****************** Bit definition for LPUART_ISTAT register ************************/

#define	LPUART_ISTAT_TCINT_POS	15U 
#define	LPUART_ISTAT_TCINT_MSK	BIT(LPUART_ISTAT_TCINT_POS)

#define	LPUART_ISTAT_RXSTATINT_POS	9U 
#define	LPUART_ISTAT_RXSTATINT_MSK	BIT(LPUART_ISTAT_RXSTATINT_POS)

#define	LPUART_ISTAT_DATWKINT_POS	8U 
#define	LPUART_ISTAT_DATWKINT_MSK	BIT(LPUART_ISTAT_DATWKINT_POS)

#define	LPUART_ISTAT_CTSWKINT_POS	7U 
#define	LPUART_ISTAT_CTSWKINT_MSK	BIT(LPUART_ISTAT_CTSWKINT_POS)

#define	LPUART_ISTAT_BUFERRINT_POS	4U 
#define	LPUART_ISTAT_BUFERRINT_MSK	BIT(LPUART_ISTAT_BUFERRINT_POS)

#define	LPUART_ISTAT_RXTOINT_POS	3U 
#define	LPUART_ISTAT_RXTOINT_MSK	BIT(LPUART_ISTAT_RXTOINT_POS)

#define	LPUART_ISTAT_CTSDETINT_POS	2U 
#define	LPUART_ISTAT_CTSDETINT_MSK	BIT(LPUART_ISTAT_CTSDETINT_POS)

#define	LPUART_ISTAT_TBEMPINT_POS	1U 
#define	LPUART_ISTAT_TBEMPINT_MSK	BIT(LPUART_ISTAT_TBEMPINT_POS)

#define	LPUART_ISTAT_RBRINT_POS	0U 
#define	LPUART_ISTAT_RBRINT_MSK	BIT(LPUART_ISTAT_RBRINT_POS)

/****************** Bit definition for LPUART_UPDATE register ************************/

#define	LPUART_UPDATE_UDIS_POS	0U 
#define	LPUART_UPDATE_UDIS_MSK	BIT(LPUART_UPDATE_UDIS_POS)

/****************** Bit definition for LPUART_SYNCSTAT register ************************/

#define	LPUART_SYNCSTAT_FIFOCONWBSY_POS	3U 
#define	LPUART_SYNCSTAT_FIFOCONWBSY_MSK	BIT(LPUART_SYNCSTAT_FIFOCONWBSY_POS)

#define	LPUART_SYNCSTAT_CLKDIVWBSY_POS	2U 
#define	LPUART_SYNCSTAT_CLKDIVWBSY_MSK	BIT(LPUART_SYNCSTAT_CLKDIVWBSY_POS)

#define	LPUART_SYNCSTAT_CON1WBSY_POS	1U 
#define	LPUART_SYNCSTAT_CON1WBSY_MSK	BIT(LPUART_SYNCSTAT_CON1WBSY_POS)

#define	LPUART_SYNCSTAT_CON0WBSY_POS	0U 
#define	LPUART_SYNCSTAT_CON0WBSY_MSK	BIT(LPUART_SYNCSTAT_CON0WBSY_POS)

typedef struct
{
	__IO uint32_t CON0;
	__IO uint32_t CON1;
	__IO uint32_t CLKDIV;
	__IO uint32_t FIFOCON;
	uint32_t RESERVED0 ;
	__I uint32_t RXDR;
	__O uint32_t TXDR;
	__I uint32_t STAT;
	__IO uint32_t IER;
	__I uint32_t IFLAG;
	__O uint32_t IFC;
	__I uint32_t ISTAT;
	uint32_t RESERVED1[2] ;
	__IO uint32_t UPDATE;
	__I uint32_t SYNCSTAT;
} LPUART_TypeDef;

/****************** Bit definition for SPI_CON1 register ************************/

#define	SPI_CON1_BIDEN_POS	15U 
#define	SPI_CON1_BIDEN_MSK	BIT(SPI_CON1_BIDEN_POS)

#define	SPI_CON1_BIDOEN_POS	14U 
#define	SPI_CON1_BIDOEN_MSK	BIT(SPI_CON1_BIDOEN_POS)

#define	SPI_CON1_CRCEN_POS	13U 
#define	SPI_CON1_CRCEN_MSK	BIT(SPI_CON1_CRCEN_POS)

#define	SPI_CON1_NXTCRC_POS	12U 
#define	SPI_CON1_NXTCRC_MSK	BIT(SPI_CON1_NXTCRC_POS)

#define	SPI_CON1_FLEN_POS	11U 
#define	SPI_CON1_FLEN_MSK	BIT(SPI_CON1_FLEN_POS)

#define	SPI_CON1_RXO_POS	10U 
#define	SPI_CON1_RXO_MSK	BIT(SPI_CON1_RXO_POS)

#define	SPI_CON1_SSEN_POS	9U 
#define	SPI_CON1_SSEN_MSK	BIT(SPI_CON1_SSEN_POS)

#define	SPI_CON1_SSOUT_POS	8U 
#define	SPI_CON1_SSOUT_MSK	BIT(SPI_CON1_SSOUT_POS)

#define	SPI_CON1_LSBFST_POS	7U 
#define	SPI_CON1_LSBFST_MSK	BIT(SPI_CON1_LSBFST_POS)

#define	SPI_CON1_SPIEN_POS	6U 
#define	SPI_CON1_SPIEN_MSK	BIT(SPI_CON1_SPIEN_POS)

#define	SPI_CON1_BAUD_POSS	3U 
#define	SPI_CON1_BAUD_POSE	5U 
#define	SPI_CON1_BAUD_MSK	BITS(SPI_CON1_BAUD_POSS,SPI_CON1_BAUD_POSE)

#define	SPI_CON1_MSTREN_POS	2U 
#define	SPI_CON1_MSTREN_MSK	BIT(SPI_CON1_MSTREN_POS)

#define	SPI_CON1_CPOL_POS	1U 
#define	SPI_CON1_CPOL_MSK	BIT(SPI_CON1_CPOL_POS)

#define	SPI_CON1_CPHA_POS	0U 
#define	SPI_CON1_CPHA_MSK	BIT(SPI_CON1_CPHA_POS)

/****************** Bit definition for SPI_CON2 register ************************/

#define	SPI_CON2_RXFTH_POSS	14U 
#define	SPI_CON2_RXFTH_POSE	15U 
#define	SPI_CON2_RXFTH_MSK	BITS(SPI_CON2_RXFTH_POSS,SPI_CON2_RXFTH_POSE)

#define	SPI_CON2_TXFTH_POSS	12U 
#define	SPI_CON2_TXFTH_POSE	13U 
#define	SPI_CON2_TXFTH_MSK	BITS(SPI_CON2_TXFTH_POSS,SPI_CON2_TXFTH_POSE)

#define	SPI_CON2_FRF_POS	4U 
#define	SPI_CON2_FRF_MSK	BIT(SPI_CON2_FRF_POS)

#define	SPI_CON2_NSSP_POS	3U 
#define	SPI_CON2_NSSP_MSK	BIT(SPI_CON2_NSSP_POS)

#define	SPI_CON2_NSSOE_POS	2U 
#define	SPI_CON2_NSSOE_MSK	BIT(SPI_CON2_NSSOE_POS)

#define	SPI_CON2_TXDMA_POS	1U 
#define	SPI_CON2_TXDMA_MSK	BIT(SPI_CON2_TXDMA_POS)

#define	SPI_CON2_RXDMA_POS	0U 
#define	SPI_CON2_RXDMA_MSK	BIT(SPI_CON2_RXDMA_POS)

/****************** Bit definition for SPI_STAT register ************************/

#define	SPI_STAT_RXFLV_POSS	24U 
#define	SPI_STAT_RXFLV_POSE	28U 
#define	SPI_STAT_RXFLV_MSK	BITS(SPI_STAT_RXFLV_POSS,SPI_STAT_RXFLV_POSE)

#define	SPI_STAT_TXFLV_POSS	16U 
#define	SPI_STAT_TXFLV_POSE	20U 
#define	SPI_STAT_TXFLV_MSK	BITS(SPI_STAT_TXFLV_POSS,SPI_STAT_TXFLV_POSE)

#define	SPI_STAT_BUSY_POS	15U 
#define	SPI_STAT_BUSY_MSK	BIT(SPI_STAT_BUSY_POS)

#define	SPI_STAT_CHSIDE_POS	14U 
#define	SPI_STAT_CHSIDE_MSK	BIT(SPI_STAT_CHSIDE_POS)

#define	SPI_STAT_RXTH_POS	12U 
#define	SPI_STAT_RXTH_MSK	BIT(SPI_STAT_RXTH_POS)

#define	SPI_STAT_RXUD_POS	11U 
#define	SPI_STAT_RXUD_MSK	BIT(SPI_STAT_RXUD_POS)

#define	SPI_STAT_RXOV_POS	10U 
#define	SPI_STAT_RXOV_MSK	BIT(SPI_STAT_RXOV_POS)

#define	SPI_STAT_RXF_POS	9U 
#define	SPI_STAT_RXF_MSK	BIT(SPI_STAT_RXF_POS)

#define	SPI_STAT_RXE_POS	8U 
#define	SPI_STAT_RXE_MSK	BIT(SPI_STAT_RXE_POS)

#define	SPI_STAT_TXTH_POS	4U 
#define	SPI_STAT_TXTH_MSK	BIT(SPI_STAT_TXTH_POS)

#define	SPI_STAT_TXUD_POS	3U 
#define	SPI_STAT_TXUD_MSK	BIT(SPI_STAT_TXUD_POS)

#define	SPI_STAT_TXOV_POS	2U 
#define	SPI_STAT_TXOV_MSK	BIT(SPI_STAT_TXOV_POS)

#define	SPI_STAT_TXF_POS	1U 
#define	SPI_STAT_TXF_MSK	BIT(SPI_STAT_TXF_POS)

#define	SPI_STAT_TXE_POS	0U 
#define	SPI_STAT_TXE_MSK	BIT(SPI_STAT_TXE_POS)

/****************** Bit definition for SPI_DATA register ************************/

#define	SPI_DATA_DATA_POSS	0U 
#define	SPI_DATA_DATA_POSE	15U 
#define	SPI_DATA_DATA_MSK	BITS(SPI_DATA_DATA_POSS,SPI_DATA_DATA_POSE)

/****************** Bit definition for SPI_CRCPOLY register ************************/

#define	SPI_CRCPOLY_CRCPOLY_POSS	0U 
#define	SPI_CRCPOLY_CRCPOLY_POSE	15U 
#define	SPI_CRCPOLY_CRCPOLY_MSK	BITS(SPI_CRCPOLY_CRCPOLY_POSS,SPI_CRCPOLY_CRCPOLY_POSE)

/****************** Bit definition for SPI_RXCRC register ************************/

#define	SPI_RXCRC_RXCRC_POSS	0U 
#define	SPI_RXCRC_RXCRC_POSE	15U 
#define	SPI_RXCRC_RXCRC_MSK	BITS(SPI_RXCRC_RXCRC_POSS,SPI_RXCRC_RXCRC_POSE)

/****************** Bit definition for SPI_TXCRC register ************************/

#define	SPI_TXCRC_TXCRC_POSS	0U 
#define	SPI_TXCRC_TXCRC_POSE	15U 
#define	SPI_TXCRC_TXCRC_MSK	BITS(SPI_TXCRC_TXCRC_POSS,SPI_TXCRC_TXCRC_POSE)

/****************** Bit definition for SPI_I2SCFG register ************************/

#define	SPI_I2SCFG_I2SMOD_POS	11U 
#define	SPI_I2SCFG_I2SMOD_MSK	BIT(SPI_I2SCFG_I2SMOD_POS)

#define	SPI_I2SCFG_I2SE_POS	10U 
#define	SPI_I2SCFG_I2SE_MSK	BIT(SPI_I2SCFG_I2SE_POS)

#define	SPI_I2SCFG_I2SCFG_POSS	8U 
#define	SPI_I2SCFG_I2SCFG_POSE	9U 
#define	SPI_I2SCFG_I2SCFG_MSK	BITS(SPI_I2SCFG_I2SCFG_POSS,SPI_I2SCFG_I2SCFG_POSE)

#define	SPI_I2SCFG_PCMSYNC_POS	7U 
#define	SPI_I2SCFG_PCMSYNC_MSK	BIT(SPI_I2SCFG_PCMSYNC_POS)

#define	SPI_I2SCFG_I2SSTD_POSS	4U 
#define	SPI_I2SCFG_I2SSTD_POSE	5U 
#define	SPI_I2SCFG_I2SSTD_MSK	BITS(SPI_I2SCFG_I2SSTD_POSS,SPI_I2SCFG_I2SSTD_POSE)

#define	SPI_I2SCFG_CKPOL_POS	3U 
#define	SPI_I2SCFG_CKPOL_MSK	BIT(SPI_I2SCFG_CKPOL_POS)

#define	SPI_I2SCFG_DATLEN_POSS	1U 
#define	SPI_I2SCFG_DATLEN_POSE	2U 
#define	SPI_I2SCFG_DATLEN_MSK	BITS(SPI_I2SCFG_DATLEN_POSS,SPI_I2SCFG_DATLEN_POSE)

#define	SPI_I2SCFG_CHLEN_POS	0U 
#define	SPI_I2SCFG_CHLEN_MSK	BIT(SPI_I2SCFG_CHLEN_POS)

/****************** Bit definition for SPI_I2SPR register ************************/

#define	SPI_I2SPR_EXTCKEN_POS	10U 
#define	SPI_I2SPR_EXTCKEN_MSK	BIT(SPI_I2SPR_EXTCKEN_POS)

#define	SPI_I2SPR_MCKOE_POS	9U 
#define	SPI_I2SPR_MCKOE_MSK	BIT(SPI_I2SPR_MCKOE_POS)

#define	SPI_I2SPR_ODD_POS	8U 
#define	SPI_I2SPR_ODD_MSK	BIT(SPI_I2SPR_ODD_POS)

#define	SPI_I2SPR_I2SDIV_POSS	0U 
#define	SPI_I2SPR_I2SDIV_POSE	7U 
#define	SPI_I2SPR_I2SDIV_MSK	BITS(SPI_I2SPR_I2SDIV_POSS,SPI_I2SPR_I2SDIV_POSE)

/****************** Bit definition for SPI_IER register ************************/

#define	SPI_IER_FREIE_POS	18U 
#define	SPI_IER_FREIE_MSK	BIT(SPI_IER_FREIE_POS)

#define	SPI_IER_MODFIE_POS	17U 
#define	SPI_IER_MODFIE_MSK	BIT(SPI_IER_MODFIE_POS)

#define	SPI_IER_CRCERRIE_POS	16U 
#define	SPI_IER_CRCERRIE_MSK	BIT(SPI_IER_CRCERRIE_POS)

#define	SPI_IER_RXTHIE_POS	12U 
#define	SPI_IER_RXTHIE_MSK	BIT(SPI_IER_RXTHIE_POS)

#define	SPI_IER_RXUDIE_POS	11U 
#define	SPI_IER_RXUDIE_MSK	BIT(SPI_IER_RXUDIE_POS)

#define	SPI_IER_RXOVIE_POS	10U 
#define	SPI_IER_RXOVIE_MSK	BIT(SPI_IER_RXOVIE_POS)

#define	SPI_IER_RXFIE_POS	9U 
#define	SPI_IER_RXFIE_MSK	BIT(SPI_IER_RXFIE_POS)

#define	SPI_IER_TXTHIE_POS	4U 
#define	SPI_IER_TXTHIE_MSK	BIT(SPI_IER_TXTHIE_POS)

#define	SPI_IER_TXUDIE_POS	3U 
#define	SPI_IER_TXUDIE_MSK	BIT(SPI_IER_TXUDIE_POS)

#define	SPI_IER_TXOVIE_POS	2U 
#define	SPI_IER_TXOVIE_MSK	BIT(SPI_IER_TXOVIE_POS)

#define	SPI_IER_TXEIE_POS	0U 
#define	SPI_IER_TXEIE_MSK	BIT(SPI_IER_TXEIE_POS)

/****************** Bit definition for SPI_IDR register ************************/

#define	SPI_IDR_FREID_POS	18U 
#define	SPI_IDR_FREID_MSK	BIT(SPI_IDR_FREID_POS)

#define	SPI_IDR_MODFID_POS	17U 
#define	SPI_IDR_MODFID_MSK	BIT(SPI_IDR_MODFID_POS)

#define	SPI_IDR_CRCERRID_POS	16U 
#define	SPI_IDR_CRCERRID_MSK	BIT(SPI_IDR_CRCERRID_POS)

#define	SPI_IDR_RXTHID_POS	12U 
#define	SPI_IDR_RXTHID_MSK	BIT(SPI_IDR_RXTHID_POS)

#define	SPI_IDR_RXUDID_POS	11U 
#define	SPI_IDR_RXUDID_MSK	BIT(SPI_IDR_RXUDID_POS)

#define	SPI_IDR_RXOVID_POS	10U 
#define	SPI_IDR_RXOVID_MSK	BIT(SPI_IDR_RXOVID_POS)

#define	SPI_IDR_RXFID_POS	9U 
#define	SPI_IDR_RXFID_MSK	BIT(SPI_IDR_RXFID_POS)

#define	SPI_IDR_TXTHID_POS	4U 
#define	SPI_IDR_TXTHID_MSK	BIT(SPI_IDR_TXTHID_POS)

#define	SPI_IDR_TXUDID_POS	3U 
#define	SPI_IDR_TXUDID_MSK	BIT(SPI_IDR_TXUDID_POS)

#define	SPI_IDR_TXOVID_POS	2U 
#define	SPI_IDR_TXOVID_MSK	BIT(SPI_IDR_TXOVID_POS)

#define	SPI_IDR_TXEID_POS	0U 
#define	SPI_IDR_TXEID_MSK	BIT(SPI_IDR_TXEID_POS)

/****************** Bit definition for SPI_IVS register ************************/

#define	SPI_IVS_FREIV_POS	18U 
#define	SPI_IVS_FREIV_MSK	BIT(SPI_IVS_FREIV_POS)

#define	SPI_IVS_MODFIV_POS	17U 
#define	SPI_IVS_MODFIV_MSK	BIT(SPI_IVS_MODFIV_POS)

#define	SPI_IVS_CRCERRIV_POS	16U 
#define	SPI_IVS_CRCERRIV_MSK	BIT(SPI_IVS_CRCERRIV_POS)

#define	SPI_IVS_RXTHIV_POS	12U 
#define	SPI_IVS_RXTHIV_MSK	BIT(SPI_IVS_RXTHIV_POS)

#define	SPI_IVS_RXUDIV_POS	11U 
#define	SPI_IVS_RXUDIV_MSK	BIT(SPI_IVS_RXUDIV_POS)

#define	SPI_IVS_RXOVIV_POS	10U 
#define	SPI_IVS_RXOVIV_MSK	BIT(SPI_IVS_RXOVIV_POS)

#define	SPI_IVS_RXFIV_POS	9U 
#define	SPI_IVS_RXFIV_MSK	BIT(SPI_IVS_RXFIV_POS)

#define	SPI_IVS_TXTHIV_POS	4U 
#define	SPI_IVS_TXTHIV_MSK	BIT(SPI_IVS_TXTHIV_POS)

#define	SPI_IVS_TXUDIV_POS	3U 
#define	SPI_IVS_TXUDIV_MSK	BIT(SPI_IVS_TXUDIV_POS)

#define	SPI_IVS_TXOVIV_POS	2U 
#define	SPI_IVS_TXOVIV_MSK	BIT(SPI_IVS_TXOVIV_POS)

#define	SPI_IVS_TXEIV_POS	0U 
#define	SPI_IVS_TXEIV_MSK	BIT(SPI_IVS_TXEIV_POS)

/****************** Bit definition for SPI_RIF register ************************/

#define	SPI_RIF_FRERI_POS	18U 
#define	SPI_RIF_FRERI_MSK	BIT(SPI_RIF_FRERI_POS)

#define	SPI_RIF_MODFRI_POS	17U 
#define	SPI_RIF_MODFRI_MSK	BIT(SPI_RIF_MODFRI_POS)

#define	SPI_RIF_CRCERRRI_POS	16U 
#define	SPI_RIF_CRCERRRI_MSK	BIT(SPI_RIF_CRCERRRI_POS)

#define	SPI_RIF_RXTHRI_POS	12U 
#define	SPI_RIF_RXTHRI_MSK	BIT(SPI_RIF_RXTHRI_POS)

#define	SPI_RIF_RXUDRI_POS	11U 
#define	SPI_RIF_RXUDRI_MSK	BIT(SPI_RIF_RXUDRI_POS)

#define	SPI_RIF_RXOVRI_POS	10U 
#define	SPI_RIF_RXOVRI_MSK	BIT(SPI_RIF_RXOVRI_POS)

#define	SPI_RIF_RXFRI_POS	9U 
#define	SPI_RIF_RXFRI_MSK	BIT(SPI_RIF_RXFRI_POS)

#define	SPI_RIF_TXTHRI_POS	4U 
#define	SPI_RIF_TXTHRI_MSK	BIT(SPI_RIF_TXTHRI_POS)

#define	SPI_RIF_TXUDRI_POS	3U 
#define	SPI_RIF_TXUDRI_MSK	BIT(SPI_RIF_TXUDRI_POS)

#define	SPI_RIF_TXOVRI_POS	2U 
#define	SPI_RIF_TXOVRI_MSK	BIT(SPI_RIF_TXOVRI_POS)

#define	SPI_RIF_TXERI_POS	0U 
#define	SPI_RIF_TXERI_MSK	BIT(SPI_RIF_TXERI_POS)

/****************** Bit definition for SPI_IFM register ************************/

#define	SPI_IFM_FREFM_POS	18U 
#define	SPI_IFM_FREFM_MSK	BIT(SPI_IFM_FREFM_POS)

#define	SPI_IFM_MODFFM_POS	17U 
#define	SPI_IFM_MODFFM_MSK	BIT(SPI_IFM_MODFFM_POS)

#define	SPI_IFM_CRCERRFM_POS	16U 
#define	SPI_IFM_CRCERRFM_MSK	BIT(SPI_IFM_CRCERRFM_POS)

#define	SPI_IFM_RXTHFM_POS	12U 
#define	SPI_IFM_RXTHFM_MSK	BIT(SPI_IFM_RXTHFM_POS)

#define	SPI_IFM_RXUDFM_POS	11U 
#define	SPI_IFM_RXUDFM_MSK	BIT(SPI_IFM_RXUDFM_POS)

#define	SPI_IFM_RXOVFM_POS	10U 
#define	SPI_IFM_RXOVFM_MSK	BIT(SPI_IFM_RXOVFM_POS)

#define	SPI_IFM_RXFFM_POS	9U 
#define	SPI_IFM_RXFFM_MSK	BIT(SPI_IFM_RXFFM_POS)

#define	SPI_IFM_TXTHFM_POS	4U 
#define	SPI_IFM_TXTHFM_MSK	BIT(SPI_IFM_TXTHFM_POS)

#define	SPI_IFM_TXUDFM_POS	3U 
#define	SPI_IFM_TXUDFM_MSK	BIT(SPI_IFM_TXUDFM_POS)

#define	SPI_IFM_TXOVFM_POS	2U 
#define	SPI_IFM_TXOVFM_MSK	BIT(SPI_IFM_TXOVFM_POS)

#define	SPI_IFM_TXEFM_POS	0U 
#define	SPI_IFM_TXEFM_MSK	BIT(SPI_IFM_TXEFM_POS)

/****************** Bit definition for SPI_ICR register ************************/

#define	SPI_ICR_FREIC_POS	18U 
#define	SPI_ICR_FREIC_MSK	BIT(SPI_ICR_FREIC_POS)

#define	SPI_ICR_MODFIC_POS	17U 
#define	SPI_ICR_MODFIC_MSK	BIT(SPI_ICR_MODFIC_POS)

#define	SPI_ICR_CRCERRIC_POS	16U 
#define	SPI_ICR_CRCERRIC_MSK	BIT(SPI_ICR_CRCERRIC_POS)

#define	SPI_ICR_RXTHIC_POS	12U 
#define	SPI_ICR_RXTHIC_MSK	BIT(SPI_ICR_RXTHIC_POS)

#define	SPI_ICR_RXUDIC_POS	11U 
#define	SPI_ICR_RXUDIC_MSK	BIT(SPI_ICR_RXUDIC_POS)

#define	SPI_ICR_RXOVIC_POS	10U 
#define	SPI_ICR_RXOVIC_MSK	BIT(SPI_ICR_RXOVIC_POS)

#define	SPI_ICR_RXFIC_POS	9U 
#define	SPI_ICR_RXFIC_MSK	BIT(SPI_ICR_RXFIC_POS)

#define	SPI_ICR_TXTHIC_POS	4U 
#define	SPI_ICR_TXTHIC_MSK	BIT(SPI_ICR_TXTHIC_POS)

#define	SPI_ICR_TXUDIC_POS	3U 
#define	SPI_ICR_TXUDIC_MSK	BIT(SPI_ICR_TXUDIC_POS)

#define	SPI_ICR_TXOVIC_POS	2U 
#define	SPI_ICR_TXOVIC_MSK	BIT(SPI_ICR_TXOVIC_POS)

#define	SPI_ICR_TXEIC_POS	0U 
#define	SPI_ICR_TXEIC_MSK	BIT(SPI_ICR_TXEIC_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__I uint32_t STAT;
	__IO uint32_t DATA;
	__IO uint32_t CRCPOLY;
	__I uint32_t RXCRC;
	__I uint32_t TXCRC;
	__IO uint32_t I2SCFG;
	__IO uint32_t I2SPR;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} SPI_I2S_TypeDef;

/****************** Bit definition for I2C_CON1 register ************************/

#define	I2C_CON1_PECEN_POS	23U 
#define	I2C_CON1_PECEN_MSK	BIT(I2C_CON1_PECEN_POS)

#define	I2C_CON1_ALERTEN_POS	22U 
#define	I2C_CON1_ALERTEN_MSK	BIT(I2C_CON1_ALERTEN_POS)

#define	I2C_CON1_SMBDEN_POS	21U 
#define	I2C_CON1_SMBDEN_MSK	BIT(I2C_CON1_SMBDEN_POS)

#define	I2C_CON1_SMBHEN_POS	20U 
#define	I2C_CON1_SMBHEN_MSK	BIT(I2C_CON1_SMBHEN_POS)

#define	I2C_CON1_GCEN_POS	19U 
#define	I2C_CON1_GCEN_MSK	BIT(I2C_CON1_GCEN_POS)

#define	I2C_CON1_NOSTRETCH_POS	17U 
#define	I2C_CON1_NOSTRETCH_MSK	BIT(I2C_CON1_NOSTRETCH_POS)

#define	I2C_CON1_SBC_POS	16U 
#define	I2C_CON1_SBC_MSK	BIT(I2C_CON1_SBC_POS)

#define	I2C_CON1_RXDMAEN_POS	15U 
#define	I2C_CON1_RXDMAEN_MSK	BIT(I2C_CON1_RXDMAEN_POS)

#define	I2C_CON1_TXDMAEN_POS	14U 
#define	I2C_CON1_TXDMAEN_MSK	BIT(I2C_CON1_TXDMAEN_POS)

#define	I2C_CON1_DNF_POSS	8U 
#define	I2C_CON1_DNF_POSE	11U 
#define	I2C_CON1_DNF_MSK	BITS(I2C_CON1_DNF_POSS,I2C_CON1_DNF_POSE)

#define	I2C_CON1_PE_POS	0U 
#define	I2C_CON1_PE_MSK	BIT(I2C_CON1_PE_POS)

/****************** Bit definition for I2C_CON2 register ************************/

#define	I2C_CON2_ACK_UPD_POS	29U 
#define	I2C_CON2_ACK_UPD_MSK	BIT(I2C_CON2_ACK_UPD_POS)

#define	I2C_CON2_HOLDACK_POS	28U 
#define	I2C_CON2_HOLDACK_MSK	BIT(I2C_CON2_HOLDACK_POS)

#define	I2C_CON2_PECBYTE_POS	26U 
#define	I2C_CON2_PECBYTE_MSK	BIT(I2C_CON2_PECBYTE_POS)

#define	I2C_CON2_AUTOEND_POS	25U 
#define	I2C_CON2_AUTOEND_MSK	BIT(I2C_CON2_AUTOEND_POS)

#define	I2C_CON2_RELOAD_POS	24U 
#define	I2C_CON2_RELOAD_MSK	BIT(I2C_CON2_RELOAD_POS)

#define	I2C_CON2_NBYTES_POSS	16U 
#define	I2C_CON2_NBYTES_POSE	23U 
#define	I2C_CON2_NBYTES_MSK	BITS(I2C_CON2_NBYTES_POSS,I2C_CON2_NBYTES_POSE)

#define	I2C_CON2_NACK_POS	15U 
#define	I2C_CON2_NACK_MSK	BIT(I2C_CON2_NACK_POS)

#define	I2C_CON2_STOP_POS	14U 
#define	I2C_CON2_STOP_MSK	BIT(I2C_CON2_STOP_POS)

#define	I2C_CON2_START_POS	13U 
#define	I2C_CON2_START_MSK	BIT(I2C_CON2_START_POS)

#define	I2C_CON2_HEAD10R_POS	12U 
#define	I2C_CON2_HEAD10R_MSK	BIT(I2C_CON2_HEAD10R_POS)

#define	I2C_CON2_ADD10_POS	11U 
#define	I2C_CON2_ADD10_MSK	BIT(I2C_CON2_ADD10_POS)

#define	I2C_CON2_RD_WRN_POS	10U 
#define	I2C_CON2_RD_WRN_MSK	BIT(I2C_CON2_RD_WRN_POS)

#define	I2C_CON2_SADD_POSS	0U 
#define	I2C_CON2_SADD_POSE	9U 
#define	I2C_CON2_SADD_MSK	BITS(I2C_CON2_SADD_POSS,I2C_CON2_SADD_POSE)

/****************** Bit definition for I2C_ADDR1 register ************************/

#define	I2C_ADDR1_OA1EN_POS	15U 
#define	I2C_ADDR1_OA1EN_MSK	BIT(I2C_ADDR1_OA1EN_POS)

#define	I2C_ADDR1_OA1MODE_POS	10U 
#define	I2C_ADDR1_OA1MODE_MSK	BIT(I2C_ADDR1_OA1MODE_POS)

#define	I2C_ADDR1_OA1_POSS	0U 
#define	I2C_ADDR1_OA1_POSE	9U 
#define	I2C_ADDR1_OA1_MSK	BITS(I2C_ADDR1_OA1_POSS,I2C_ADDR1_OA1_POSE)

/****************** Bit definition for I2C_ADDR2 register ************************/

#define	I2C_ADDR2_OA2EN_POS	15U 
#define	I2C_ADDR2_OA2EN_MSK	BIT(I2C_ADDR2_OA2EN_POS)

#define	I2C_ADDR2_OA2MSK_POSS	8U 
#define	I2C_ADDR2_OA2MSK_POSE	10U 
#define	I2C_ADDR2_OA2MSK_MSK	BITS(I2C_ADDR2_OA2MSK_POSS,I2C_ADDR2_OA2MSK_POSE)

#define	I2C_ADDR2_OA2_POSS	1U 
#define	I2C_ADDR2_OA2_POSE	7U 
#define	I2C_ADDR2_OA2_MSK	BITS(I2C_ADDR2_OA2_POSS,I2C_ADDR2_OA2_POSE)

/****************** Bit definition for I2C_TIMINGR register ************************/

#define	I2C_TIMINGR_PRESC_POSS	28U 
#define	I2C_TIMINGR_PRESC_POSE	31U 
#define	I2C_TIMINGR_PRESC_MSK	BITS(I2C_TIMINGR_PRESC_POSS,I2C_TIMINGR_PRESC_POSE)

#define	I2C_TIMINGR_SCLDEL_POSS	20U 
#define	I2C_TIMINGR_SCLDEL_POSE	23U 
#define	I2C_TIMINGR_SCLDEL_MSK	BITS(I2C_TIMINGR_SCLDEL_POSS,I2C_TIMINGR_SCLDEL_POSE)

#define	I2C_TIMINGR_SDADEL_POSS	16U 
#define	I2C_TIMINGR_SDADEL_POSE	19U 
#define	I2C_TIMINGR_SDADEL_MSK	BITS(I2C_TIMINGR_SDADEL_POSS,I2C_TIMINGR_SDADEL_POSE)

#define	I2C_TIMINGR_SCLH_POSS	8U 
#define	I2C_TIMINGR_SCLH_POSE	15U 
#define	I2C_TIMINGR_SCLH_MSK	BITS(I2C_TIMINGR_SCLH_POSS,I2C_TIMINGR_SCLH_POSE)

#define	I2C_TIMINGR_SCLL_POSS	0U 
#define	I2C_TIMINGR_SCLL_POSE	7U 
#define	I2C_TIMINGR_SCLL_MSK	BITS(I2C_TIMINGR_SCLL_POSS,I2C_TIMINGR_SCLL_POSE)

/****************** Bit definition for I2C_TIMEOUTR register ************************/

#define	I2C_TIMEOUTR_TEXTEN_POS	31U 
#define	I2C_TIMEOUTR_TEXTEN_MSK	BIT(I2C_TIMEOUTR_TEXTEN_POS)

#define	I2C_TIMEOUTR_TIMEOUTB_POSS	16U 
#define	I2C_TIMEOUTR_TIMEOUTB_POSE	27U 
#define	I2C_TIMEOUTR_TIMEOUTB_MSK	BITS(I2C_TIMEOUTR_TIMEOUTB_POSS,I2C_TIMEOUTR_TIMEOUTB_POSE)

#define	I2C_TIMEOUTR_TIMEOUTEN_POS	15U 
#define	I2C_TIMEOUTR_TIMEOUTEN_MSK	BIT(I2C_TIMEOUTR_TIMEOUTEN_POS)

#define	I2C_TIMEOUTR_TIDLE_POS	12U 
#define	I2C_TIMEOUTR_TIDLE_MSK	BIT(I2C_TIMEOUTR_TIDLE_POS)

#define	I2C_TIMEOUTR_TIMEOUTA_POSS	0U 
#define	I2C_TIMEOUTR_TIMEOUTA_POSE	11U 
#define	I2C_TIMEOUTR_TIMEOUTA_MSK	BITS(I2C_TIMEOUTR_TIMEOUTA_POSS,I2C_TIMEOUTR_TIMEOUTA_POSE)

/****************** Bit definition for I2C_STAT register ************************/

#define	I2C_STAT_ADDCODE_POSS	17U 
#define	I2C_STAT_ADDCODE_POSE	23U 
#define	I2C_STAT_ADDCODE_MSK	BITS(I2C_STAT_ADDCODE_POSS,I2C_STAT_ADDCODE_POSE)

#define	I2C_STAT_DIR_POS	16U 
#define	I2C_STAT_DIR_MSK	BIT(I2C_STAT_DIR_POS)

#define	I2C_STAT_BUSY_POS	15U 
#define	I2C_STAT_BUSY_MSK	BIT(I2C_STAT_BUSY_POS)

#define	I2C_STAT_TCR_POS	11U 
#define	I2C_STAT_TCR_MSK	BIT(I2C_STAT_TCR_POS)

#define	I2C_STAT_TC_POS	10U 
#define	I2C_STAT_TC_MSK	BIT(I2C_STAT_TC_POS)

#define	I2C_STAT_RXTH_POS	9U 
#define	I2C_STAT_RXTH_MSK	BIT(I2C_STAT_RXTH_POS)

#define	I2C_STAT_RXUD_POS	8U 
#define	I2C_STAT_RXUD_MSK	BIT(I2C_STAT_RXUD_POS)

#define	I2C_STAT_RXOV_POS	7U 
#define	I2C_STAT_RXOV_MSK	BIT(I2C_STAT_RXOV_POS)

#define	I2C_STAT_RXF_POS	6U 
#define	I2C_STAT_RXF_MSK	BIT(I2C_STAT_RXF_POS)

#define	I2C_STAT_RXE_POS	5U 
#define	I2C_STAT_RXE_MSK	BIT(I2C_STAT_RXE_POS)

#define	I2C_STAT_TXTH_POS	4U 
#define	I2C_STAT_TXTH_MSK	BIT(I2C_STAT_TXTH_POS)

#define	I2C_STAT_TXUD_POS	3U 
#define	I2C_STAT_TXUD_MSK	BIT(I2C_STAT_TXUD_POS)

#define	I2C_STAT_TXOV_POS	2U 
#define	I2C_STAT_TXOV_MSK	BIT(I2C_STAT_TXOV_POS)

#define	I2C_STAT_TXF_POS	1U 
#define	I2C_STAT_TXF_MSK	BIT(I2C_STAT_TXF_POS)

#define	I2C_STAT_TXE_POS	0U 
#define	I2C_STAT_TXE_MSK	BIT(I2C_STAT_TXE_POS)

/****************** Bit definition for I2C_FCON register ************************/

#define	I2C_FCON_RXFTH_POSS	14U 
#define	I2C_FCON_RXFTH_POSE	15U 
#define	I2C_FCON_RXFTH_MSK	BITS(I2C_FCON_RXFTH_POSS,I2C_FCON_RXFTH_POSE)

#define	I2C_FCON_RXFRST_POS	13U 
#define	I2C_FCON_RXFRST_MSK	BIT(I2C_FCON_RXFRST_POS)

#define	I2C_FCON_RXFLV_POSS	8U 
#define	I2C_FCON_RXFLV_POSE	12U 
#define	I2C_FCON_RXFLV_MSK	BITS(I2C_FCON_RXFLV_POSS,I2C_FCON_RXFLV_POSE)

#define	I2C_FCON_TXFTH_POSS	6U 
#define	I2C_FCON_TXFTH_POSE	7U 
#define	I2C_FCON_TXFTH_MSK	BITS(I2C_FCON_TXFTH_POSS,I2C_FCON_TXFTH_POSE)

#define	I2C_FCON_TXFRST_POS	5U 
#define	I2C_FCON_TXFRST_MSK	BIT(I2C_FCON_TXFRST_POS)

#define	I2C_FCON_TXFLV_POSS	0U 
#define	I2C_FCON_TXFLV_POSE	4U 
#define	I2C_FCON_TXFLV_MSK	BITS(I2C_FCON_TXFLV_POSS,I2C_FCON_TXFLV_POSE)

/****************** Bit definition for I2C_PECR register ************************/

#define	I2C_PECR_PEC_POSS	0U 
#define	I2C_PECR_PEC_POSE	7U 
#define	I2C_PECR_PEC_MSK	BITS(I2C_PECR_PEC_POSS,I2C_PECR_PEC_POSE)

/****************** Bit definition for I2C_RXDATA register ************************/

#define	I2C_RXDATA_RXDATA_POSS	0U 
#define	I2C_RXDATA_RXDATA_POSE	7U 
#define	I2C_RXDATA_RXDATA_MSK	BITS(I2C_RXDATA_RXDATA_POSS,I2C_RXDATA_RXDATA_POSE)

/****************** Bit definition for I2C_TXDATA register ************************/

#define	I2C_TXDATA_TXDATA_POSS	0U 
#define	I2C_TXDATA_TXDATA_POSE	7U 
#define	I2C_TXDATA_TXDATA_MSK	BITS(I2C_TXDATA_TXDATA_POSS,I2C_TXDATA_TXDATA_POSE)

/****************** Bit definition for I2C_IER register ************************/

#define	I2C_IER_ALERTIE_POS	20U 
#define	I2C_IER_ALERTIE_MSK	BIT(I2C_IER_ALERTIE_POS)

#define	I2C_IER_TOUTIE_POS	19U 
#define	I2C_IER_TOUTIE_MSK	BIT(I2C_IER_TOUTIE_POS)

#define	I2C_IER_PECEIE_POS	18U 
#define	I2C_IER_PECEIE_MSK	BIT(I2C_IER_PECEIE_POS)

#define	I2C_IER_ARLOIE_POS	17U 
#define	I2C_IER_ARLOIE_MSK	BIT(I2C_IER_ARLOIE_POS)

#define	I2C_IER_BERRIE_POS	16U 
#define	I2C_IER_BERRIE_MSK	BIT(I2C_IER_BERRIE_POS)

#define	I2C_IER_STOPIE_POS	14U 
#define	I2C_IER_STOPIE_MSK	BIT(I2C_IER_STOPIE_POS)

#define	I2C_IER_NACKIE_POS	13U 
#define	I2C_IER_NACKIE_MSK	BIT(I2C_IER_NACKIE_POS)

#define	I2C_IER_ADDRIE_POS	12U 
#define	I2C_IER_ADDRIE_MSK	BIT(I2C_IER_ADDRIE_POS)

#define	I2C_IER_TCRIE_POS	11U 
#define	I2C_IER_TCRIE_MSK	BIT(I2C_IER_TCRIE_POS)

#define	I2C_IER_TCIE_POS	10U 
#define	I2C_IER_TCIE_MSK	BIT(I2C_IER_TCIE_POS)

#define	I2C_IER_RXTHIE_POS	9U 
#define	I2C_IER_RXTHIE_MSK	BIT(I2C_IER_RXTHIE_POS)

#define	I2C_IER_RXUDIE_POS	8U 
#define	I2C_IER_RXUDIE_MSK	BIT(I2C_IER_RXUDIE_POS)

#define	I2C_IER_RXOVIE_POS	7U 
#define	I2C_IER_RXOVIE_MSK	BIT(I2C_IER_RXOVIE_POS)

#define	I2C_IER_RXFIE_POS	6U 
#define	I2C_IER_RXFIE_MSK	BIT(I2C_IER_RXFIE_POS)

#define	I2C_IER_TXTHIE_POS	4U 
#define	I2C_IER_TXTHIE_MSK	BIT(I2C_IER_TXTHIE_POS)

#define	I2C_IER_TXUDIE_POS	3U 
#define	I2C_IER_TXUDIE_MSK	BIT(I2C_IER_TXUDIE_POS)

#define	I2C_IER_TXOVIE_POS	2U 
#define	I2C_IER_TXOVIE_MSK	BIT(I2C_IER_TXOVIE_POS)

#define	I2C_IER_TXEIE_POS	0U 
#define	I2C_IER_TXEIE_MSK	BIT(I2C_IER_TXEIE_POS)

/****************** Bit definition for I2C_IDR register ************************/

#define	I2C_IDR_ALERTID_POS	20U 
#define	I2C_IDR_ALERTID_MSK	BIT(I2C_IDR_ALERTID_POS)

#define	I2C_IDR_TOUTID_POS	19U 
#define	I2C_IDR_TOUTID_MSK	BIT(I2C_IDR_TOUTID_POS)

#define	I2C_IDR_PECEID_POS	18U 
#define	I2C_IDR_PECEID_MSK	BIT(I2C_IDR_PECEID_POS)

#define	I2C_IDR_ARLOID_POS	17U 
#define	I2C_IDR_ARLOID_MSK	BIT(I2C_IDR_ARLOID_POS)

#define	I2C_IDR_BERRID_POS	16U 
#define	I2C_IDR_BERRID_MSK	BIT(I2C_IDR_BERRID_POS)

#define	I2C_IDR_STOPID_POS	14U 
#define	I2C_IDR_STOPID_MSK	BIT(I2C_IDR_STOPID_POS)

#define	I2C_IDR_NACKID_POS	13U 
#define	I2C_IDR_NACKID_MSK	BIT(I2C_IDR_NACKID_POS)

#define	I2C_IDR_ADDRID_POS	12U 
#define	I2C_IDR_ADDRID_MSK	BIT(I2C_IDR_ADDRID_POS)

#define	I2C_IDR_TCRID_POS	11U 
#define	I2C_IDR_TCRID_MSK	BIT(I2C_IDR_TCRID_POS)

#define	I2C_IDR_TCID_POS	10U 
#define	I2C_IDR_TCID_MSK	BIT(I2C_IDR_TCID_POS)

#define	I2C_IDR_RXTHID_POS	9U 
#define	I2C_IDR_RXTHID_MSK	BIT(I2C_IDR_RXTHID_POS)

#define	I2C_IDR_RXUDID_POS	8U 
#define	I2C_IDR_RXUDID_MSK	BIT(I2C_IDR_RXUDID_POS)

#define	I2C_IDR_RXOVID_POS	7U 
#define	I2C_IDR_RXOVID_MSK	BIT(I2C_IDR_RXOVID_POS)

#define	I2C_IDR_RXFID_POS	6U 
#define	I2C_IDR_RXFID_MSK	BIT(I2C_IDR_RXFID_POS)

#define	I2C_IDR_TXTHID_POS	4U 
#define	I2C_IDR_TXTHID_MSK	BIT(I2C_IDR_TXTHID_POS)

#define	I2C_IDR_TXUDID_POS	3U 
#define	I2C_IDR_TXUDID_MSK	BIT(I2C_IDR_TXUDID_POS)

#define	I2C_IDR_TXOVID_POS	2U 
#define	I2C_IDR_TXOVID_MSK	BIT(I2C_IDR_TXOVID_POS)

#define	I2C_IDR_TXEID_POS	0U 
#define	I2C_IDR_TXEID_MSK	BIT(I2C_IDR_TXEID_POS)

/****************** Bit definition for I2C_IVS register ************************/

#define	I2C_IVS_ALERTIV_POS	20U 
#define	I2C_IVS_ALERTIV_MSK	BIT(I2C_IVS_ALERTIV_POS)

#define	I2C_IVS_TOUTIV_POS	19U 
#define	I2C_IVS_TOUTIV_MSK	BIT(I2C_IVS_TOUTIV_POS)

#define	I2C_IVS_PECEIV_POS	18U 
#define	I2C_IVS_PECEIV_MSK	BIT(I2C_IVS_PECEIV_POS)

#define	I2C_IVS_ARLOIV_POS	17U 
#define	I2C_IVS_ARLOIV_MSK	BIT(I2C_IVS_ARLOIV_POS)

#define	I2C_IVS_BERRIV_POS	16U 
#define	I2C_IVS_BERRIV_MSK	BIT(I2C_IVS_BERRIV_POS)

#define	I2C_IVS_STOPIV_POS	14U 
#define	I2C_IVS_STOPIV_MSK	BIT(I2C_IVS_STOPIV_POS)

#define	I2C_IVS_NACKIV_POS	13U 
#define	I2C_IVS_NACKIV_MSK	BIT(I2C_IVS_NACKIV_POS)

#define	I2C_IVS_ADDRIV_POS	12U 
#define	I2C_IVS_ADDRIV_MSK	BIT(I2C_IVS_ADDRIV_POS)

#define	I2C_IVS_TCRIV_POS	11U 
#define	I2C_IVS_TCRIV_MSK	BIT(I2C_IVS_TCRIV_POS)

#define	I2C_IVS_TCIV_POS	10U 
#define	I2C_IVS_TCIV_MSK	BIT(I2C_IVS_TCIV_POS)

#define	I2C_IVS_RXTHIV_POS	9U 
#define	I2C_IVS_RXTHIV_MSK	BIT(I2C_IVS_RXTHIV_POS)

#define	I2C_IVS_RXUDIV_POS	8U 
#define	I2C_IVS_RXUDIV_MSK	BIT(I2C_IVS_RXUDIV_POS)

#define	I2C_IVS_RXOVIV_POS	7U 
#define	I2C_IVS_RXOVIV_MSK	BIT(I2C_IVS_RXOVIV_POS)

#define	I2C_IVS_RXFIV_POS	6U 
#define	I2C_IVS_RXFIV_MSK	BIT(I2C_IVS_RXFIV_POS)

#define	I2C_IVS_TXTHIV_POS	4U 
#define	I2C_IVS_TXTHIV_MSK	BIT(I2C_IVS_TXTHIV_POS)

#define	I2C_IVS_TXUDIV_POS	3U 
#define	I2C_IVS_TXUDIV_MSK	BIT(I2C_IVS_TXUDIV_POS)

#define	I2C_IVS_TXOVIV_POS	2U 
#define	I2C_IVS_TXOVIV_MSK	BIT(I2C_IVS_TXOVIV_POS)

#define	I2C_IVS_TXEIV_POS	0U 
#define	I2C_IVS_TXEIV_MSK	BIT(I2C_IVS_TXEIV_POS)

/****************** Bit definition for I2C_RIF register ************************/

#define	I2C_RIF_ALERTRI_POS	20U 
#define	I2C_RIF_ALERTRI_MSK	BIT(I2C_RIF_ALERTRI_POS)

#define	I2C_RIF_TOUTRI_POS	19U 
#define	I2C_RIF_TOUTRI_MSK	BIT(I2C_RIF_TOUTRI_POS)

#define	I2C_RIF_PECERI_POS	18U 
#define	I2C_RIF_PECERI_MSK	BIT(I2C_RIF_PECERI_POS)

#define	I2C_RIF_ARLORI_POS	17U 
#define	I2C_RIF_ARLORI_MSK	BIT(I2C_RIF_ARLORI_POS)

#define	I2C_RIF_BERRRI_POS	16U 
#define	I2C_RIF_BERRRI_MSK	BIT(I2C_RIF_BERRRI_POS)

#define	I2C_RIF_STOPRI_POS	14U 
#define	I2C_RIF_STOPRI_MSK	BIT(I2C_RIF_STOPRI_POS)

#define	I2C_RIF_NACKRI_POS	13U 
#define	I2C_RIF_NACKRI_MSK	BIT(I2C_RIF_NACKRI_POS)

#define	I2C_RIF_ADDRRI_POS	12U 
#define	I2C_RIF_ADDRRI_MSK	BIT(I2C_RIF_ADDRRI_POS)

#define	I2C_RIF_TCRRI_POS	11U 
#define	I2C_RIF_TCRRI_MSK	BIT(I2C_RIF_TCRRI_POS)

#define	I2C_RIF_TCRI_POS	10U 
#define	I2C_RIF_TCRI_MSK	BIT(I2C_RIF_TCRI_POS)

#define	I2C_RIF_RXTHRI_POS	9U 
#define	I2C_RIF_RXTHRI_MSK	BIT(I2C_RIF_RXTHRI_POS)

#define	I2C_RIF_RXUDRI_POS	8U 
#define	I2C_RIF_RXUDRI_MSK	BIT(I2C_RIF_RXUDRI_POS)

#define	I2C_RIF_RXOVRI_POS	7U 
#define	I2C_RIF_RXOVRI_MSK	BIT(I2C_RIF_RXOVRI_POS)

#define	I2C_RIF_RXFRI_POS	6U 
#define	I2C_RIF_RXFRI_MSK	BIT(I2C_RIF_RXFRI_POS)

#define	I2C_RIF_TXTHRI_POS	4U 
#define	I2C_RIF_TXTHRI_MSK	BIT(I2C_RIF_TXTHRI_POS)

#define	I2C_RIF_TXUDRI_POS	3U 
#define	I2C_RIF_TXUDRI_MSK	BIT(I2C_RIF_TXUDRI_POS)

#define	I2C_RIF_TXOVRI_POS	2U 
#define	I2C_RIF_TXOVRI_MSK	BIT(I2C_RIF_TXOVRI_POS)

#define	I2C_RIF_TXERI_POS	0U 
#define	I2C_RIF_TXERI_MSK	BIT(I2C_RIF_TXERI_POS)

/****************** Bit definition for I2C_IFM register ************************/

#define	I2C_IFM_ALERTFM_POS	20U 
#define	I2C_IFM_ALERTFM_MSK	BIT(I2C_IFM_ALERTFM_POS)

#define	I2C_IFM_TOUTFM_POS	19U 
#define	I2C_IFM_TOUTFM_MSK	BIT(I2C_IFM_TOUTFM_POS)

#define	I2C_IFM_PECEFM_POS	18U 
#define	I2C_IFM_PECEFM_MSK	BIT(I2C_IFM_PECEFM_POS)

#define	I2C_IFM_ARLOFM_POS	17U 
#define	I2C_IFM_ARLOFM_MSK	BIT(I2C_IFM_ARLOFM_POS)

#define	I2C_IFM_BERRFM_POS	16U 
#define	I2C_IFM_BERRFM_MSK	BIT(I2C_IFM_BERRFM_POS)

#define	I2C_IFM_STOPFM_POS	14U 
#define	I2C_IFM_STOPFM_MSK	BIT(I2C_IFM_STOPFM_POS)

#define	I2C_IFM_NACKFM_POS	13U 
#define	I2C_IFM_NACKFM_MSK	BIT(I2C_IFM_NACKFM_POS)

#define	I2C_IFM_ADDRFM_POS	12U 
#define	I2C_IFM_ADDRFM_MSK	BIT(I2C_IFM_ADDRFM_POS)

#define	I2C_IFM_TCRFM_POS	11U 
#define	I2C_IFM_TCRFM_MSK	BIT(I2C_IFM_TCRFM_POS)

#define	I2C_IFM_TCFM_POS	10U 
#define	I2C_IFM_TCFM_MSK	BIT(I2C_IFM_TCFM_POS)

#define	I2C_IFM_RXTHFM_POS	9U 
#define	I2C_IFM_RXTHFM_MSK	BIT(I2C_IFM_RXTHFM_POS)

#define	I2C_IFM_RXUDFM_POS	8U 
#define	I2C_IFM_RXUDFM_MSK	BIT(I2C_IFM_RXUDFM_POS)

#define	I2C_IFM_RXOVFM_POS	7U 
#define	I2C_IFM_RXOVFM_MSK	BIT(I2C_IFM_RXOVFM_POS)

#define	I2C_IFM_RXFFM_POS	6U 
#define	I2C_IFM_RXFFM_MSK	BIT(I2C_IFM_RXFFM_POS)

#define	I2C_IFM_TXTHFM_POS	4U 
#define	I2C_IFM_TXTHFM_MSK	BIT(I2C_IFM_TXTHFM_POS)

#define	I2C_IFM_TXUDFM_POS	3U 
#define	I2C_IFM_TXUDFM_MSK	BIT(I2C_IFM_TXUDFM_POS)

#define	I2C_IFM_TXOVFM_POS	2U 
#define	I2C_IFM_TXOVFM_MSK	BIT(I2C_IFM_TXOVFM_POS)

#define	I2C_IFM_TXEFM_POS	0U 
#define	I2C_IFM_TXEFM_MSK	BIT(I2C_IFM_TXEFM_POS)

/****************** Bit definition for I2C_ICR register ************************/

#define	I2C_ICR_ALERTIC_POS	20U 
#define	I2C_ICR_ALERTIC_MSK	BIT(I2C_ICR_ALERTIC_POS)

#define	I2C_ICR_TOUTIC_POS	19U 
#define	I2C_ICR_TOUTIC_MSK	BIT(I2C_ICR_TOUTIC_POS)

#define	I2C_ICR_PECEIC_POS	18U 
#define	I2C_ICR_PECEIC_MSK	BIT(I2C_ICR_PECEIC_POS)

#define	I2C_ICR_ARLOIC_POS	17U 
#define	I2C_ICR_ARLOIC_MSK	BIT(I2C_ICR_ARLOIC_POS)

#define	I2C_ICR_BERRIC_POS	16U 
#define	I2C_ICR_BERRIC_MSK	BIT(I2C_ICR_BERRIC_POS)

#define	I2C_ICR_STOPIC_POS	14U 
#define	I2C_ICR_STOPIC_MSK	BIT(I2C_ICR_STOPIC_POS)

#define	I2C_ICR_NACKIC_POS	13U 
#define	I2C_ICR_NACKIC_MSK	BIT(I2C_ICR_NACKIC_POS)

#define	I2C_ICR_ADDRIC_POS	12U 
#define	I2C_ICR_ADDRIC_MSK	BIT(I2C_ICR_ADDRIC_POS)

#define	I2C_ICR_TCRIC_POS	11U 
#define	I2C_ICR_TCRIC_MSK	BIT(I2C_ICR_TCRIC_POS)

#define	I2C_ICR_TCIC_POS	10U 
#define	I2C_ICR_TCIC_MSK	BIT(I2C_ICR_TCIC_POS)

#define	I2C_ICR_RXTHIC_POS	9U 
#define	I2C_ICR_RXTHIC_MSK	BIT(I2C_ICR_RXTHIC_POS)

#define	I2C_ICR_RXUDIC_POS	8U 
#define	I2C_ICR_RXUDIC_MSK	BIT(I2C_ICR_RXUDIC_POS)

#define	I2C_ICR_RXOVIC_POS	7U 
#define	I2C_ICR_RXOVIC_MSK	BIT(I2C_ICR_RXOVIC_POS)

#define	I2C_ICR_RXFIC_POS	6U 
#define	I2C_ICR_RXFIC_MSK	BIT(I2C_ICR_RXFIC_POS)

#define	I2C_ICR_TXTHIC_POS	4U 
#define	I2C_ICR_TXTHIC_MSK	BIT(I2C_ICR_TXTHIC_POS)

#define	I2C_ICR_TXUDIC_POS	3U 
#define	I2C_ICR_TXUDIC_MSK	BIT(I2C_ICR_TXUDIC_POS)

#define	I2C_ICR_TXOVIC_POS	2U 
#define	I2C_ICR_TXOVIC_MSK	BIT(I2C_ICR_TXOVIC_POS)

#define	I2C_ICR_TXEIC_POS	0U 
#define	I2C_ICR_TXEIC_MSK	BIT(I2C_ICR_TXEIC_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t ADDR1;
	__IO uint32_t ADDR2;
	__IO uint32_t TIMINGR;
	__IO uint32_t TIMEOUTR;
	__I uint32_t STAT;
	__IO uint32_t FCON;
	__I uint32_t PECR;
	__I uint32_t RXDATA;
	__O uint32_t TXDATA;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} I2C_TypeDef;

/****************** Bit definition for CAN_CON register ************************/

#define	CAN_CON_DBGSTP_POS	16U 
#define	CAN_CON_DBGSTP_MSK	BIT(CAN_CON_DBGSTP_POS)

#define	CAN_CON_RST_POS	15U 
#define	CAN_CON_RST_MSK	BIT(CAN_CON_RST_POS)

#define	CAN_CON_TTCEN_POS	7U 
#define	CAN_CON_TTCEN_MSK	BIT(CAN_CON_TTCEN_POS)

#define	CAN_CON_ABOFFEN_POS	6U 
#define	CAN_CON_ABOFFEN_MSK	BIT(CAN_CON_ABOFFEN_POS)

#define	CAN_CON_AWKEN_POS	5U 
#define	CAN_CON_AWKEN_MSK	BIT(CAN_CON_AWKEN_POS)

#define	CAN_CON_ARTXDIS_POS	4U 
#define	CAN_CON_ARTXDIS_MSK	BIT(CAN_CON_ARTXDIS_POS)

#define	CAN_CON_RXFOPM_POS	3U 
#define	CAN_CON_RXFOPM_MSK	BIT(CAN_CON_RXFOPM_POS)

#define	CAN_CON_TXMP_POS	2U 
#define	CAN_CON_TXMP_MSK	BIT(CAN_CON_TXMP_POS)

#define	CAN_CON_SLPREQ_POS	1U 
#define	CAN_CON_SLPREQ_MSK	BIT(CAN_CON_SLPREQ_POS)

#define	CAN_CON_INIREQ_POS	0U 
#define	CAN_CON_INIREQ_MSK	BIT(CAN_CON_INIREQ_POS)

/****************** Bit definition for CAN_STAT register ************************/

#define	CAN_STAT_RX_POS	11U 
#define	CAN_STAT_RX_MSK	BIT(CAN_STAT_RX_POS)

#define	CAN_STAT_PRESMP_POS	10U 
#define	CAN_STAT_PRESMP_MSK	BIT(CAN_STAT_PRESMP_POS)

#define	CAN_STAT_RXSTAT_POS	9U 
#define	CAN_STAT_RXSTAT_MSK	BIT(CAN_STAT_RXSTAT_POS)

#define	CAN_STAT_TXSTAT_POS	8U 
#define	CAN_STAT_TXSTAT_MSK	BIT(CAN_STAT_TXSTAT_POS)

#define	CAN_STAT_SLPIF_POS	4U 
#define	CAN_STAT_SLPIF_MSK	BIT(CAN_STAT_SLPIF_POS)

#define	CAN_STAT_WKIF_POS	3U 
#define	CAN_STAT_WKIF_MSK	BIT(CAN_STAT_WKIF_POS)

#define	CAN_STAT_ERRIF_POS	2U 
#define	CAN_STAT_ERRIF_MSK	BIT(CAN_STAT_ERRIF_POS)

#define	CAN_STAT_SLPSTAT_POS	1U 
#define	CAN_STAT_SLPSTAT_MSK	BIT(CAN_STAT_SLPSTAT_POS)

#define	CAN_STAT_INISTAT_POS	0U 
#define	CAN_STAT_INISTAT_MSK	BIT(CAN_STAT_INISTAT_POS)

/****************** Bit definition for CAN_IFC register ************************/

#define	CAN_IFC_SLPIFC_POS	4U 
#define	CAN_IFC_SLPIFC_MSK	BIT(CAN_IFC_SLPIFC_POS)

#define	CAN_IFC_WKIFC_POS	3U 
#define	CAN_IFC_WKIFC_MSK	BIT(CAN_IFC_WKIFC_POS)

#define	CAN_IFC_ERRIFC_POS	2U 
#define	CAN_IFC_ERRIFC_MSK	BIT(CAN_IFC_ERRIFC_POS)

/****************** Bit definition for CAN_TXSTAT register ************************/

#define	CAN_TXSTAT_TXM2LPF_POS	31U 
#define	CAN_TXSTAT_TXM2LPF_MSK	BIT(CAN_TXSTAT_TXM2LPF_POS)

#define	CAN_TXSTAT_TXM1LPF_POS	30U 
#define	CAN_TXSTAT_TXM1LPF_MSK	BIT(CAN_TXSTAT_TXM1LPF_POS)

#define	CAN_TXSTAT_TXM0LPF_POS	29U 
#define	CAN_TXSTAT_TXM0LPF_MSK	BIT(CAN_TXSTAT_TXM0LPF_POS)

#define	CAN_TXSTAT_TXM2EF_POS	28U 
#define	CAN_TXSTAT_TXM2EF_MSK	BIT(CAN_TXSTAT_TXM2EF_POS)

#define	CAN_TXSTAT_TXM1EF_POS	27U 
#define	CAN_TXSTAT_TXM1EF_MSK	BIT(CAN_TXSTAT_TXM1EF_POS)

#define	CAN_TXSTAT_TXM0EF_POS	26U 
#define	CAN_TXSTAT_TXM0EF_MSK	BIT(CAN_TXSTAT_TXM0EF_POS)

#define	CAN_TXSTAT_CODE_POSS	24U 
#define	CAN_TXSTAT_CODE_POSE	25U 
#define	CAN_TXSTAT_CODE_MSK	BITS(CAN_TXSTAT_CODE_POSS,CAN_TXSTAT_CODE_POSE)

#define	CAN_TXSTAT_M2STPREQ_POS	23U 
#define	CAN_TXSTAT_M2STPREQ_MSK	BIT(CAN_TXSTAT_M2STPREQ_POS)

#define	CAN_TXSTAT_M2TXERR_POS	19U 
#define	CAN_TXSTAT_M2TXERR_MSK	BIT(CAN_TXSTAT_M2TXERR_POS)

#define	CAN_TXSTAT_M2ARBLST_POS	18U 
#define	CAN_TXSTAT_M2ARBLST_MSK	BIT(CAN_TXSTAT_M2ARBLST_POS)

#define	CAN_TXSTAT_M2TXC_POS	17U 
#define	CAN_TXSTAT_M2TXC_MSK	BIT(CAN_TXSTAT_M2TXC_POS)

#define	CAN_TXSTAT_M2REQC_POS	16U 
#define	CAN_TXSTAT_M2REQC_MSK	BIT(CAN_TXSTAT_M2REQC_POS)

#define	CAN_TXSTAT_M1STPREQ_POS	15U 
#define	CAN_TXSTAT_M1STPREQ_MSK	BIT(CAN_TXSTAT_M1STPREQ_POS)

#define	CAN_TXSTAT_M1TXERR_POS	11U 
#define	CAN_TXSTAT_M1TXERR_MSK	BIT(CAN_TXSTAT_M1TXERR_POS)

#define	CAN_TXSTAT_M1ARBLST_POS	10U 
#define	CAN_TXSTAT_M1ARBLST_MSK	BIT(CAN_TXSTAT_M1ARBLST_POS)

#define	CAN_TXSTAT_M1TXC_POS	9U 
#define	CAN_TXSTAT_M1TXC_MSK	BIT(CAN_TXSTAT_M1TXC_POS)

#define	CAN_TXSTAT_M1REQC_POS	8U 
#define	CAN_TXSTAT_M1REQC_MSK	BIT(CAN_TXSTAT_M1REQC_POS)

#define	CAN_TXSTAT_M0STPREQ_POS	7U 
#define	CAN_TXSTAT_M0STPREQ_MSK	BIT(CAN_TXSTAT_M0STPREQ_POS)

#define	CAN_TXSTAT_M0TXERR_POS	3U 
#define	CAN_TXSTAT_M0TXERR_MSK	BIT(CAN_TXSTAT_M0TXERR_POS)

#define	CAN_TXSTAT_M0ARBLST_POS	2U 
#define	CAN_TXSTAT_M0ARBLST_MSK	BIT(CAN_TXSTAT_M0ARBLST_POS)

#define	CAN_TXSTAT_M0TXC_POS	1U 
#define	CAN_TXSTAT_M0TXC_MSK	BIT(CAN_TXSTAT_M0TXC_POS)

#define	CAN_TXSTAT_M0REQC_POS	0U 
#define	CAN_TXSTAT_M0REQC_MSK	BIT(CAN_TXSTAT_M0REQC_POS)

/****************** Bit definition for CAN_TXSTATC register ************************/

#define	CAN_TXSTATC_M2TXERR_POS	19U 
#define	CAN_TXSTATC_M2TXERR_MSK	BIT(CAN_TXSTATC_M2TXERR_POS)

#define	CAN_TXSTATC_M2ARBLST_POS	18U 
#define	CAN_TXSTATC_M2ARBLST_MSK	BIT(CAN_TXSTATC_M2ARBLST_POS)

#define	CAN_TXSTATC_M2TXC_POS	17U 
#define	CAN_TXSTATC_M2TXC_MSK	BIT(CAN_TXSTATC_M2TXC_POS)

#define	CAN_TXSTATC_M2REQC_POS	16U 
#define	CAN_TXSTATC_M2REQC_MSK	BIT(CAN_TXSTATC_M2REQC_POS)

#define	CAN_TXSTATC_M1TXERR_POS	11U 
#define	CAN_TXSTATC_M1TXERR_MSK	BIT(CAN_TXSTATC_M1TXERR_POS)

#define	CAN_TXSTATC_M1ARBLST_POS	10U 
#define	CAN_TXSTATC_M1ARBLST_MSK	BIT(CAN_TXSTATC_M1ARBLST_POS)

#define	CAN_TXSTATC_M1TXC_POS	9U 
#define	CAN_TXSTATC_M1TXC_MSK	BIT(CAN_TXSTATC_M1TXC_POS)

#define	CAN_TXSTATC_M1REQC_POS	8U 
#define	CAN_TXSTATC_M1REQC_MSK	BIT(CAN_TXSTATC_M1REQC_POS)

#define	CAN_TXSTATC_M0TXERR_POS	3U 
#define	CAN_TXSTATC_M0TXERR_MSK	BIT(CAN_TXSTATC_M0TXERR_POS)

#define	CAN_TXSTATC_M0ARBLST_POS	2U 
#define	CAN_TXSTATC_M0ARBLST_MSK	BIT(CAN_TXSTATC_M0ARBLST_POS)

#define	CAN_TXSTATC_M0TXC_POS	1U 
#define	CAN_TXSTATC_M0TXC_MSK	BIT(CAN_TXSTATC_M0TXC_POS)

#define	CAN_TXSTATC_M0REQC_POS	0U 
#define	CAN_TXSTATC_M0REQC_MSK	BIT(CAN_TXSTATC_M0REQC_POS)

/****************** Bit definition for CAN_RXF0 register ************************/

#define	CAN_RXF0_FREE_POS	5U 
#define	CAN_RXF0_FREE_MSK	BIT(CAN_RXF0_FREE_POS)

#define	CAN_RXF0_OVR_POS	4U 
#define	CAN_RXF0_OVR_MSK	BIT(CAN_RXF0_OVR_POS)

#define	CAN_RXF0_FULL_POS	3U 
#define	CAN_RXF0_FULL_MSK	BIT(CAN_RXF0_FULL_POS)

#define	CAN_RXF0_PEND_POSS	0U 
#define	CAN_RXF0_PEND_POSE	1U 
#define	CAN_RXF0_PEND_MSK	BITS(CAN_RXF0_PEND_POSS,CAN_RXF0_PEND_POSE)

/****************** Bit definition for CAN_RXF0C register ************************/

#define	CAN_RXF0C_OVRC_POS	4U 
#define	CAN_RXF0C_OVRC_MSK	BIT(CAN_RXF0C_OVRC_POS)

#define	CAN_RXF0C_FULLC_POS	3U 
#define	CAN_RXF0C_FULLC_MSK	BIT(CAN_RXF0C_FULLC_POS)

/****************** Bit definition for CAN_RXF1 register ************************/

#define	CAN_RXF1_FREE_POS	5U 
#define	CAN_RXF1_FREE_MSK	BIT(CAN_RXF1_FREE_POS)

#define	CAN_RXF1_OVR_POS	4U 
#define	CAN_RXF1_OVR_MSK	BIT(CAN_RXF1_OVR_POS)

#define	CAN_RXF1_FULL_POS	3U 
#define	CAN_RXF1_FULL_MSK	BIT(CAN_RXF1_FULL_POS)

#define	CAN_RXF1_PEND_POSS	0U 
#define	CAN_RXF1_PEND_POSE	1U 
#define	CAN_RXF1_PEND_MSK	BITS(CAN_RXF1_PEND_POSS,CAN_RXF1_PEND_POSE)

/****************** Bit definition for CAN_RXF1C register ************************/

#define	CAN_RXF1C_OVRC_POS	4U 
#define	CAN_RXF1C_OVRC_MSK	BIT(CAN_RXF1C_OVRC_POS)

#define	CAN_RXF1C_FULLC_POS	3U 
#define	CAN_RXF1C_FULLC_MSK	BIT(CAN_RXF1C_FULLC_POS)

/****************** Bit definition for CAN_IE register ************************/

#define	CAN_IE_SLPIE_POS	17U 
#define	CAN_IE_SLPIE_MSK	BIT(CAN_IE_SLPIE_POS)

#define	CAN_IE_WKIE_POS	16U 
#define	CAN_IE_WKIE_MSK	BIT(CAN_IE_WKIE_POS)

#define	CAN_IE_ERRIE_POS	15U 
#define	CAN_IE_ERRIE_MSK	BIT(CAN_IE_ERRIE_POS)

#define	CAN_IE_PRERRIE_POS	11U 
#define	CAN_IE_PRERRIE_MSK	BIT(CAN_IE_PRERRIE_POS)

#define	CAN_IE_BOFFIE_POS	10U 
#define	CAN_IE_BOFFIE_MSK	BIT(CAN_IE_BOFFIE_POS)

#define	CAN_IE_PERRIE_POS	9U 
#define	CAN_IE_PERRIE_MSK	BIT(CAN_IE_PERRIE_POS)

#define	CAN_IE_WARNIE_POS	8U 
#define	CAN_IE_WARNIE_MSK	BIT(CAN_IE_WARNIE_POS)

#define	CAN_IE_F1OVRIE_POS	6U 
#define	CAN_IE_F1OVRIE_MSK	BIT(CAN_IE_F1OVRIE_POS)

#define	CAN_IE_F1FULIE_POS	5U 
#define	CAN_IE_F1FULIE_MSK	BIT(CAN_IE_F1FULIE_POS)

#define	CAN_IE_F1PIE_POS	4U 
#define	CAN_IE_F1PIE_MSK	BIT(CAN_IE_F1PIE_POS)

#define	CAN_IE_F0OVRIE_POS	3U 
#define	CAN_IE_F0OVRIE_MSK	BIT(CAN_IE_F0OVRIE_POS)

#define	CAN_IE_F0FULIE_POS	2U 
#define	CAN_IE_F0FULIE_MSK	BIT(CAN_IE_F0FULIE_POS)

#define	CAN_IE_F0PIE_POS	1U 
#define	CAN_IE_F0PIE_MSK	BIT(CAN_IE_F0PIE_POS)

#define	CAN_IE_TXMEIE_POS	0U 
#define	CAN_IE_TXMEIE_MSK	BIT(CAN_IE_TXMEIE_POS)

/****************** Bit definition for CAN_ERRSTAT register ************************/

#define	CAN_ERRSTAT_RXERRC_POSS	24U 
#define	CAN_ERRSTAT_RXERRC_POSE	31U 
#define	CAN_ERRSTAT_RXERRC_MSK	BITS(CAN_ERRSTAT_RXERRC_POSS,CAN_ERRSTAT_RXERRC_POSE)

#define	CAN_ERRSTAT_TXERRC_POSS	16U 
#define	CAN_ERRSTAT_TXERRC_POSE	23U 
#define	CAN_ERRSTAT_TXERRC_MSK	BITS(CAN_ERRSTAT_TXERRC_POSS,CAN_ERRSTAT_TXERRC_POSE)

#define	CAN_ERRSTAT_PRERRF_POSS	4U 
#define	CAN_ERRSTAT_PRERRF_POSE	6U 
#define	CAN_ERRSTAT_PRERRF_MSK	BITS(CAN_ERRSTAT_PRERRF_POSS,CAN_ERRSTAT_PRERRF_POSE)

#define	CAN_ERRSTAT_BOFF_POS	2U 
#define	CAN_ERRSTAT_BOFF_MSK	BIT(CAN_ERRSTAT_BOFF_POS)

#define	CAN_ERRSTAT_PERRF_POS	1U 
#define	CAN_ERRSTAT_PERRF_MSK	BIT(CAN_ERRSTAT_PERRF_POS)

#define	CAN_ERRSTAT_WARNF_POS	0U 
#define	CAN_ERRSTAT_WARNF_MSK	BIT(CAN_ERRSTAT_WARNF_POS)

/****************** Bit definition for CAN_BTIME register ************************/

#define	CAN_BTIME_SILENT_POS	31U 
#define	CAN_BTIME_SILENT_MSK	BIT(CAN_BTIME_SILENT_POS)

#define	CAN_BTIME_LOOP_POS	30U 
#define	CAN_BTIME_LOOP_MSK	BIT(CAN_BTIME_LOOP_POS)

#define	CAN_BTIME_RESJW_POSS	24U 
#define	CAN_BTIME_RESJW_POSE	25U 
#define	CAN_BTIME_RESJW_MSK	BITS(CAN_BTIME_RESJW_POSS,CAN_BTIME_RESJW_POSE)

#define	CAN_BTIME_SEG2_POSS	20U 
#define	CAN_BTIME_SEG2_POSE	22U 
#define	CAN_BTIME_SEG2_MSK	BITS(CAN_BTIME_SEG2_POSS,CAN_BTIME_SEG2_POSE)

#define	CAN_BTIME_SEG1_POSS	16U 
#define	CAN_BTIME_SEG1_POSE	19U 
#define	CAN_BTIME_SEG1_MSK	BITS(CAN_BTIME_SEG1_POSS,CAN_BTIME_SEG1_POSE)

#define	CAN_BTIME_BPSC_POSS	0U 
#define	CAN_BTIME_BPSC_POSE	9U 
#define	CAN_BTIME_BPSC_MSK	BITS(CAN_BTIME_BPSC_POSS,CAN_BTIME_BPSC_POSE)

/****************** Bit definition for CAN_TXID0 register ************************/

#define	CAN_TXID0_STDID_POSS	21U 
#define	CAN_TXID0_STDID_POSE	31U 
#define	CAN_TXID0_STDID_MSK	BITS(CAN_TXID0_STDID_POSS,CAN_TXID0_STDID_POSE)

#define	CAN_TXID0_EXID_POSS	3U 
#define	CAN_TXID0_EXID_POSE	20U 
#define	CAN_TXID0_EXID_MSK	BITS(CAN_TXID0_EXID_POSS,CAN_TXID0_EXID_POSE)

#define	CAN_TXID0_IDE_POS	2U 
#define	CAN_TXID0_IDE_MSK	BIT(CAN_TXID0_IDE_POS)

#define	CAN_TXID0_RTR_POS	1U 
#define	CAN_TXID0_RTR_MSK	BIT(CAN_TXID0_RTR_POS)

#define	CAN_TXID0_TXMREQ_POS	0U 
#define	CAN_TXID0_TXMREQ_MSK	BIT(CAN_TXID0_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON0 register ************************/

#define	CAN_TXFCON0_STAMP_POSS	16U 
#define	CAN_TXFCON0_STAMP_POSE	31U 
#define	CAN_TXFCON0_STAMP_MSK	BITS(CAN_TXFCON0_STAMP_POSS,CAN_TXFCON0_STAMP_POSE)

#define	CAN_TXFCON0_TXGT_POS	8U 
#define	CAN_TXFCON0_TXGT_MSK	BIT(CAN_TXFCON0_TXGT_POS)

#define	CAN_TXFCON0_DLEN_POSS	0U 
#define	CAN_TXFCON0_DLEN_POSE	3U 
#define	CAN_TXFCON0_DLEN_MSK	BITS(CAN_TXFCON0_DLEN_POSS,CAN_TXFCON0_DLEN_POSE)

/****************** Bit definition for CAN_TXDL0 register ************************/

#define	CAN_TXDL0_BYTE3_POSS	24U 
#define	CAN_TXDL0_BYTE3_POSE	31U 
#define	CAN_TXDL0_BYTE3_MSK	BITS(CAN_TXDL0_BYTE3_POSS,CAN_TXDL0_BYTE3_POSE)

#define	CAN_TXDL0_BYTE2_POSS	16U 
#define	CAN_TXDL0_BYTE2_POSE	23U 
#define	CAN_TXDL0_BYTE2_MSK	BITS(CAN_TXDL0_BYTE2_POSS,CAN_TXDL0_BYTE2_POSE)

#define	CAN_TXDL0_BYTE1_POSS	8U 
#define	CAN_TXDL0_BYTE1_POSE	15U 
#define	CAN_TXDL0_BYTE1_MSK	BITS(CAN_TXDL0_BYTE1_POSS,CAN_TXDL0_BYTE1_POSE)

#define	CAN_TXDL0_BYTE0_POSS	0U 
#define	CAN_TXDL0_BYTE0_POSE	7U 
#define	CAN_TXDL0_BYTE0_MSK	BITS(CAN_TXDL0_BYTE0_POSS,CAN_TXDL0_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH0 register ************************/

#define	CAN_TXDH0_BYTE7_POSS	24U 
#define	CAN_TXDH0_BYTE7_POSE	31U 
#define	CAN_TXDH0_BYTE7_MSK	BITS(CAN_TXDH0_BYTE7_POSS,CAN_TXDH0_BYTE7_POSE)

#define	CAN_TXDH0_BYTE6_POSS	16U 
#define	CAN_TXDH0_BYTE6_POSE	23U 
#define	CAN_TXDH0_BYTE6_MSK	BITS(CAN_TXDH0_BYTE6_POSS,CAN_TXDH0_BYTE6_POSE)

#define	CAN_TXDH0_BYTE5_POSS	8U 
#define	CAN_TXDH0_BYTE5_POSE	15U 
#define	CAN_TXDH0_BYTE5_MSK	BITS(CAN_TXDH0_BYTE5_POSS,CAN_TXDH0_BYTE5_POSE)

#define	CAN_TXDH0_BYTE4_POSS	0U 
#define	CAN_TXDH0_BYTE4_POSE	7U 
#define	CAN_TXDH0_BYTE4_MSK	BITS(CAN_TXDH0_BYTE4_POSS,CAN_TXDH0_BYTE4_POSE)

/****************** Bit definition for CAN_TXID1 register ************************/

#define	CAN_TXID1_STDID_POSS	21U 
#define	CAN_TXID1_STDID_POSE	31U 
#define	CAN_TXID1_STDID_MSK	BITS(CAN_TXID1_STDID_POSS,CAN_TXID1_STDID_POSE)

#define	CAN_TXID1_EXID_POSS	3U 
#define	CAN_TXID1_EXID_POSE	20U 
#define	CAN_TXID1_EXID_MSK	BITS(CAN_TXID1_EXID_POSS,CAN_TXID1_EXID_POSE)

#define	CAN_TXID1_IDE_POS	2U 
#define	CAN_TXID1_IDE_MSK	BIT(CAN_TXID1_IDE_POS)

#define	CAN_TXID1_RTR_POS	1U 
#define	CAN_TXID1_RTR_MSK	BIT(CAN_TXID1_RTR_POS)

#define	CAN_TXID1_TXMREQ_POS	0U 
#define	CAN_TXID1_TXMREQ_MSK	BIT(CAN_TXID1_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON1 register ************************/

#define	CAN_TXFCON1_STAMP_POSS	16U 
#define	CAN_TXFCON1_STAMP_POSE	31U 
#define	CAN_TXFCON1_STAMP_MSK	BITS(CAN_TXFCON1_STAMP_POSS,CAN_TXFCON1_STAMP_POSE)

#define	CAN_TXFCON1_TXGT_POS	8U 
#define	CAN_TXFCON1_TXGT_MSK	BIT(CAN_TXFCON1_TXGT_POS)

#define	CAN_TXFCON1_DLEN_POSS	0U 
#define	CAN_TXFCON1_DLEN_POSE	3U 
#define	CAN_TXFCON1_DLEN_MSK	BITS(CAN_TXFCON1_DLEN_POSS,CAN_TXFCON1_DLEN_POSE)

/****************** Bit definition for CAN_TXDL1 register ************************/

#define	CAN_TXDL1_BYTE3_POSS	24U 
#define	CAN_TXDL1_BYTE3_POSE	31U 
#define	CAN_TXDL1_BYTE3_MSK	BITS(CAN_TXDL1_BYTE3_POSS,CAN_TXDL1_BYTE3_POSE)

#define	CAN_TXDL1_BYTE2_POSS	16U 
#define	CAN_TXDL1_BYTE2_POSE	23U 
#define	CAN_TXDL1_BYTE2_MSK	BITS(CAN_TXDL1_BYTE2_POSS,CAN_TXDL1_BYTE2_POSE)

#define	CAN_TXDL1_BYTE1_POSS	8U 
#define	CAN_TXDL1_BYTE1_POSE	15U 
#define	CAN_TXDL1_BYTE1_MSK	BITS(CAN_TXDL1_BYTE1_POSS,CAN_TXDL1_BYTE1_POSE)

#define	CAN_TXDL1_BYTE0_POSS	0U 
#define	CAN_TXDL1_BYTE0_POSE	7U 
#define	CAN_TXDL1_BYTE0_MSK	BITS(CAN_TXDL1_BYTE0_POSS,CAN_TXDL1_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH1 register ************************/

#define	CAN_TXDH1_BYTE7_POSS	24U 
#define	CAN_TXDH1_BYTE7_POSE	31U 
#define	CAN_TXDH1_BYTE7_MSK	BITS(CAN_TXDH1_BYTE7_POSS,CAN_TXDH1_BYTE7_POSE)

#define	CAN_TXDH1_BYTE6_POSS	16U 
#define	CAN_TXDH1_BYTE6_POSE	23U 
#define	CAN_TXDH1_BYTE6_MSK	BITS(CAN_TXDH1_BYTE6_POSS,CAN_TXDH1_BYTE6_POSE)

#define	CAN_TXDH1_BYTE5_POSS	8U 
#define	CAN_TXDH1_BYTE5_POSE	15U 
#define	CAN_TXDH1_BYTE5_MSK	BITS(CAN_TXDH1_BYTE5_POSS,CAN_TXDH1_BYTE5_POSE)

#define	CAN_TXDH1_BYTE4_POSS	0U 
#define	CAN_TXDH1_BYTE4_POSE	7U 
#define	CAN_TXDH1_BYTE4_MSK	BITS(CAN_TXDH1_BYTE4_POSS,CAN_TXDH1_BYTE4_POSE)

/****************** Bit definition for CAN_TXID2 register ************************/

#define	CAN_TXID2_STDID_POSS	21U 
#define	CAN_TXID2_STDID_POSE	31U 
#define	CAN_TXID2_STDID_MSK	BITS(CAN_TXID2_STDID_POSS,CAN_TXID2_STDID_POSE)

#define	CAN_TXID2_EXID_POSS	3U 
#define	CAN_TXID2_EXID_POSE	20U 
#define	CAN_TXID2_EXID_MSK	BITS(CAN_TXID2_EXID_POSS,CAN_TXID2_EXID_POSE)

#define	CAN_TXID2_IDE_POS	2U 
#define	CAN_TXID2_IDE_MSK	BIT(CAN_TXID2_IDE_POS)

#define	CAN_TXID2_RTR_POS	1U 
#define	CAN_TXID2_RTR_MSK	BIT(CAN_TXID2_RTR_POS)

#define	CAN_TXID2_TXMREQ_POS	0U 
#define	CAN_TXID2_TXMREQ_MSK	BIT(CAN_TXID2_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON2 register ************************/

#define	CAN_TXFCON2_STAMP_POSS	16U 
#define	CAN_TXFCON2_STAMP_POSE	31U 
#define	CAN_TXFCON2_STAMP_MSK	BITS(CAN_TXFCON2_STAMP_POSS,CAN_TXFCON2_STAMP_POSE)

#define	CAN_TXFCON2_TXGT_POS	8U 
#define	CAN_TXFCON2_TXGT_MSK	BIT(CAN_TXFCON2_TXGT_POS)

#define	CAN_TXFCON2_DLEN_POSS	0U 
#define	CAN_TXFCON2_DLEN_POSE	3U 
#define	CAN_TXFCON2_DLEN_MSK	BITS(CAN_TXFCON2_DLEN_POSS,CAN_TXFCON2_DLEN_POSE)

/****************** Bit definition for CAN_TXDL2 register ************************/

#define	CAN_TXDL2_BYTE3_POSS	24U 
#define	CAN_TXDL2_BYTE3_POSE	31U 
#define	CAN_TXDL2_BYTE3_MSK	BITS(CAN_TXDL2_BYTE3_POSS,CAN_TXDL2_BYTE3_POSE)

#define	CAN_TXDL2_BYTE2_POSS	16U 
#define	CAN_TXDL2_BYTE2_POSE	23U 
#define	CAN_TXDL2_BYTE2_MSK	BITS(CAN_TXDL2_BYTE2_POSS,CAN_TXDL2_BYTE2_POSE)

#define	CAN_TXDL2_BYTE1_POSS	8U 
#define	CAN_TXDL2_BYTE1_POSE	15U 
#define	CAN_TXDL2_BYTE1_MSK	BITS(CAN_TXDL2_BYTE1_POSS,CAN_TXDL2_BYTE1_POSE)

#define	CAN_TXDL2_BYTE0_POSS	0U 
#define	CAN_TXDL2_BYTE0_POSE	7U 
#define	CAN_TXDL2_BYTE0_MSK	BITS(CAN_TXDL2_BYTE0_POSS,CAN_TXDL2_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH2 register ************************/

#define	CAN_TXDH2_BYTE7_POSS	24U 
#define	CAN_TXDH2_BYTE7_POSE	31U 
#define	CAN_TXDH2_BYTE7_MSK	BITS(CAN_TXDH2_BYTE7_POSS,CAN_TXDH2_BYTE7_POSE)

#define	CAN_TXDH2_BYTE6_POSS	16U 
#define	CAN_TXDH2_BYTE6_POSE	23U 
#define	CAN_TXDH2_BYTE6_MSK	BITS(CAN_TXDH2_BYTE6_POSS,CAN_TXDH2_BYTE6_POSE)

#define	CAN_TXDH2_BYTE5_POSS	8U 
#define	CAN_TXDH2_BYTE5_POSE	15U 
#define	CAN_TXDH2_BYTE5_MSK	BITS(CAN_TXDH2_BYTE5_POSS,CAN_TXDH2_BYTE5_POSE)

#define	CAN_TXDH2_BYTE4_POSS	0U 
#define	CAN_TXDH2_BYTE4_POSE	7U 
#define	CAN_TXDH2_BYTE4_MSK	BITS(CAN_TXDH2_BYTE4_POSS,CAN_TXDH2_BYTE4_POSE)

/****************** Bit definition for CAN_RXF0ID register ************************/

#define	CAN_RXF0ID_STDID_POSS	21U 
#define	CAN_RXF0ID_STDID_POSE	31U 
#define	CAN_RXF0ID_STDID_MSK	BITS(CAN_RXF0ID_STDID_POSS,CAN_RXF0ID_STDID_POSE)

#define	CAN_RXF0ID_EXID_POSS	3U 
#define	CAN_RXF0ID_EXID_POSE	20U 
#define	CAN_RXF0ID_EXID_MSK	BITS(CAN_RXF0ID_EXID_POSS,CAN_RXF0ID_EXID_POSE)

#define	CAN_RXF0ID_IDE_POS	2U 
#define	CAN_RXF0ID_IDE_MSK	BIT(CAN_RXF0ID_IDE_POS)

#define	CAN_RXF0ID_RTR_POS	1U 
#define	CAN_RXF0ID_RTR_MSK	BIT(CAN_RXF0ID_RTR_POS)

/****************** Bit definition for CAN_RXF0INF register ************************/

#define	CAN_RXF0INF_STAMP_POSS	16U 
#define	CAN_RXF0INF_STAMP_POSE	31U 
#define	CAN_RXF0INF_STAMP_MSK	BITS(CAN_RXF0INF_STAMP_POSS,CAN_RXF0INF_STAMP_POSE)

#define	CAN_RXF0INF_FLTIDX_POSS	8U 
#define	CAN_RXF0INF_FLTIDX_POSE	15U 
#define	CAN_RXF0INF_FLTIDX_MSK	BITS(CAN_RXF0INF_FLTIDX_POSS,CAN_RXF0INF_FLTIDX_POSE)

#define	CAN_RXF0INF_DLEN_POSS	0U 
#define	CAN_RXF0INF_DLEN_POSE	3U 
#define	CAN_RXF0INF_DLEN_MSK	BITS(CAN_RXF0INF_DLEN_POSS,CAN_RXF0INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF0DL register ************************/

#define	CAN_RXF0DL_BYTE3_POSS	24U 
#define	CAN_RXF0DL_BYTE3_POSE	31U 
#define	CAN_RXF0DL_BYTE3_MSK	BITS(CAN_RXF0DL_BYTE3_POSS,CAN_RXF0DL_BYTE3_POSE)

#define	CAN_RXF0DL_BYTE2_POSS	16U 
#define	CAN_RXF0DL_BYTE2_POSE	23U 
#define	CAN_RXF0DL_BYTE2_MSK	BITS(CAN_RXF0DL_BYTE2_POSS,CAN_RXF0DL_BYTE2_POSE)

#define	CAN_RXF0DL_BYTE1_POSS	8U 
#define	CAN_RXF0DL_BYTE1_POSE	15U 
#define	CAN_RXF0DL_BYTE1_MSK	BITS(CAN_RXF0DL_BYTE1_POSS,CAN_RXF0DL_BYTE1_POSE)

#define	CAN_RXF0DL_BYTE0_POSS	0U 
#define	CAN_RXF0DL_BYTE0_POSE	7U 
#define	CAN_RXF0DL_BYTE0_MSK	BITS(CAN_RXF0DL_BYTE0_POSS,CAN_RXF0DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF0DH register ************************/

#define	CAN_RXF0DH_BYTE7_POSS	24U 
#define	CAN_RXF0DH_BYTE7_POSE	31U 
#define	CAN_RXF0DH_BYTE7_MSK	BITS(CAN_RXF0DH_BYTE7_POSS,CAN_RXF0DH_BYTE7_POSE)

#define	CAN_RXF0DH_BYTE6_POSS	16U 
#define	CAN_RXF0DH_BYTE6_POSE	23U 
#define	CAN_RXF0DH_BYTE6_MSK	BITS(CAN_RXF0DH_BYTE6_POSS,CAN_RXF0DH_BYTE6_POSE)

#define	CAN_RXF0DH_BYTE5_POSS	8U 
#define	CAN_RXF0DH_BYTE5_POSE	15U 
#define	CAN_RXF0DH_BYTE5_MSK	BITS(CAN_RXF0DH_BYTE5_POSS,CAN_RXF0DH_BYTE5_POSE)

#define	CAN_RXF0DH_BYTE4_POSS	0U 
#define	CAN_RXF0DH_BYTE4_POSE	7U 
#define	CAN_RXF0DH_BYTE4_MSK	BITS(CAN_RXF0DH_BYTE4_POSS,CAN_RXF0DH_BYTE4_POSE)

/****************** Bit definition for CAN_RXF1ID register ************************/

#define	CAN_RXF1ID_STDID_POSS	21U 
#define	CAN_RXF1ID_STDID_POSE	31U 
#define	CAN_RXF1ID_STDID_MSK	BITS(CAN_RXF1ID_STDID_POSS,CAN_RXF1ID_STDID_POSE)

#define	CAN_RXF1ID_EXID_POSS	3U 
#define	CAN_RXF1ID_EXID_POSE	20U 
#define	CAN_RXF1ID_EXID_MSK	BITS(CAN_RXF1ID_EXID_POSS,CAN_RXF1ID_EXID_POSE)

#define	CAN_RXF1ID_IDE_POS	2U 
#define	CAN_RXF1ID_IDE_MSK	BIT(CAN_RXF1ID_IDE_POS)

#define	CAN_RXF1ID_RTR_POS	1U 
#define	CAN_RXF1ID_RTR_MSK	BIT(CAN_RXF1ID_RTR_POS)

/****************** Bit definition for CAN_RXF1INF register ************************/

#define	CAN_RXF1INF_STAMP_POSS	16U 
#define	CAN_RXF1INF_STAMP_POSE	31U 
#define	CAN_RXF1INF_STAMP_MSK	BITS(CAN_RXF1INF_STAMP_POSS,CAN_RXF1INF_STAMP_POSE)

#define	CAN_RXF1INF_FLTIDX_POSS	8U 
#define	CAN_RXF1INF_FLTIDX_POSE	15U 
#define	CAN_RXF1INF_FLTIDX_MSK	BITS(CAN_RXF1INF_FLTIDX_POSS,CAN_RXF1INF_FLTIDX_POSE)

#define	CAN_RXF1INF_DLEN_POSS	0U 
#define	CAN_RXF1INF_DLEN_POSE	3U 
#define	CAN_RXF1INF_DLEN_MSK	BITS(CAN_RXF1INF_DLEN_POSS,CAN_RXF1INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF1DL register ************************/

#define	CAN_RXF1DL_BYTE3_POSS	24U 
#define	CAN_RXF1DL_BYTE3_POSE	31U 
#define	CAN_RXF1DL_BYTE3_MSK	BITS(CAN_RXF1DL_BYTE3_POSS,CAN_RXF1DL_BYTE3_POSE)

#define	CAN_RXF1DL_BYTE2_POSS	16U 
#define	CAN_RXF1DL_BYTE2_POSE	23U 
#define	CAN_RXF1DL_BYTE2_MSK	BITS(CAN_RXF1DL_BYTE2_POSS,CAN_RXF1DL_BYTE2_POSE)

#define	CAN_RXF1DL_BYTE1_POSS	8U 
#define	CAN_RXF1DL_BYTE1_POSE	15U 
#define	CAN_RXF1DL_BYTE1_MSK	BITS(CAN_RXF1DL_BYTE1_POSS,CAN_RXF1DL_BYTE1_POSE)

#define	CAN_RXF1DL_BYTE0_POSS	0U 
#define	CAN_RXF1DL_BYTE0_POSE	7U 
#define	CAN_RXF1DL_BYTE0_MSK	BITS(CAN_RXF1DL_BYTE0_POSS,CAN_RXF1DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF1DH register ************************/

#define	CAN_RXF1DH_BYTE7_POSS	24U 
#define	CAN_RXF1DH_BYTE7_POSE	31U 
#define	CAN_RXF1DH_BYTE7_MSK	BITS(CAN_RXF1DH_BYTE7_POSS,CAN_RXF1DH_BYTE7_POSE)

#define	CAN_RXF1DH_BYTE6_POSS	16U 
#define	CAN_RXF1DH_BYTE6_POSE	23U 
#define	CAN_RXF1DH_BYTE6_MSK	BITS(CAN_RXF1DH_BYTE6_POSS,CAN_RXF1DH_BYTE6_POSE)

#define	CAN_RXF1DH_BYTE5_POSS	8U 
#define	CAN_RXF1DH_BYTE5_POSE	15U 
#define	CAN_RXF1DH_BYTE5_MSK	BITS(CAN_RXF1DH_BYTE5_POSS,CAN_RXF1DH_BYTE5_POSE)

#define	CAN_RXF1DH_BYTE4_POSS	0U 
#define	CAN_RXF1DH_BYTE4_POSE	7U 
#define	CAN_RXF1DH_BYTE4_MSK	BITS(CAN_RXF1DH_BYTE4_POSS,CAN_RXF1DH_BYTE4_POSE)

/****************** Bit definition for CAN_FLTCON register ************************/

#define	CAN_FLTCON_FLTINI_POS	0U 
#define	CAN_FLTCON_FLTINI_MSK	BIT(CAN_FLTCON_FLTINI_POS)

/****************** Bit definition for CAN_FLTM register ************************/

#define	CAN_FLTM_MOD_POSS	0U 
#define	CAN_FLTM_MOD_POSE	13U 
#define	CAN_FLTM_MOD_MSK	BITS(CAN_FLTM_MOD_POSS,CAN_FLTM_MOD_POSE)

/****************** Bit definition for CAN_FLTWS register ************************/

#define	CAN_FLTWS_SEL_POSS	0U 
#define	CAN_FLTWS_SEL_POSE	13U 
#define	CAN_FLTWS_SEL_MSK	BITS(CAN_FLTWS_SEL_POSS,CAN_FLTWS_SEL_POSE)

/****************** Bit definition for CAN_FLTAS register ************************/

#define	CAN_FLTAS_ASSIGN_POSS	0U 
#define	CAN_FLTAS_ASSIGN_POSE	13U 
#define	CAN_FLTAS_ASSIGN_MSK	BITS(CAN_FLTAS_ASSIGN_POSS,CAN_FLTAS_ASSIGN_POSE)

/****************** Bit definition for CAN_FLTGO register ************************/

#define	CAN_FLTGO_GO_POSS	0U 
#define	CAN_FLTGO_GO_POSE	13U 
#define	CAN_FLTGO_GO_MSK	BITS(CAN_FLTGO_GO_POSS,CAN_FLTGO_GO_POSE)

typedef struct {
	__IO uint32_t TXID;
	__IO uint32_t TXFCON;
	__IO uint32_t TXDL;
	__IO uint32_t TXDH;
} CAN_TxMailBox_Typedef;

typedef struct {
	__IO uint32_t RXFID;
	__IO uint32_t RXFINF;
	__IO uint32_t RXFDL;
	__IO uint32_t RXFDH;
} CAN_RxFIFO_Typedef;

typedef struct {
	__IO uint32_t FLT1;
	__IO uint32_t FLT2;
} CAN_Filter_Typedef;

typedef struct
{
	__IO uint32_t CON;
	__I uint32_t STAT;
	__O uint32_t IFC;
	__IO uint32_t TXSTAT;
	__O uint32_t TXSTATC;
	__IO uint32_t RXF0;
	__O uint32_t RXF0C;
	__IO uint32_t RXF1;
	__O uint32_t RXF1C;
	__IO uint32_t IE;
	__IO uint32_t ERRSTAT;
	__IO uint32_t BTIME;
	uint32_t RESERVED0[84] ;
	CAN_TxMailBox_Typedef TxMailBox[3];
	CAN_RxFIFO_Typedef RxFIFO[2];
	uint32_t RESERVED1[12] ;
	__IO uint32_t FLTCON;
	__IO uint32_t FLTM;
	uint32_t RESERVED2 ;
	__IO uint32_t FLTWS;
	uint32_t RESERVED3 ;
	__IO uint32_t FLTAS;
	uint32_t RESERVED4 ;
	__IO uint32_t FLTGO;
	uint32_t RESERVED5[8] ;
	CAN_Filter_Typedef Filter[14];
} CAN_TypeDef;

/****************** Bit definition for CRC_CR register ************************/
#define	CRC_CR_BYTORD_POS	24U 
#define	CRC_CR_BYTORD_MSK	BIT(CRC_CR_BYTORD_POS)

#define	CRC_CR_DATLEN_POSS	22U 
#define	CRC_CR_DATLEN_POSE	23U 
#define	CRC_CR_DATLEN_MSK	BITS(CRC_CR_DATLEN_POSS,CRC_CR_DATLEN_POSE)

#define	CRC_CR_MODE_POSS	20U 
#define	CRC_CR_MODE_POSE	21U 
#define	CRC_CR_MODE_MSK	BITS(CRC_CR_MODE_POSS,CRC_CR_MODE_POSE)

#define	CRC_CR_CHSINV_POS	19U 
#define	CRC_CR_CHSINV_MSK	BIT(CRC_CR_CHSINV_POS)

#define	CRC_CR_DATINV_POS	18U 
#define	CRC_CR_DATINV_MSK	BIT(CRC_CR_DATINV_POS)

#define	CRC_CR_CHSREV_POS	17U 
#define	CRC_CR_CHSREV_MSK	BIT(CRC_CR_CHSREV_POS)

#define	CRC_CR_DATREV_POS	16U 
#define	CRC_CR_DATREV_MSK	BIT(CRC_CR_DATREV_POS)

#define	CRC_CR_DMAEN_POS	4U 
#define	CRC_CR_DMAEN_MSK	BIT(CRC_CR_DMAEN_POS)

#define	CRC_CR_CWERR_POS	3U 
#define	CRC_CR_CWERR_MSK	BIT(CRC_CR_CWERR_POS)

#define	CRC_CR_WERR_POS	2U 
#define	CRC_CR_WERR_MSK	BIT(CRC_CR_WERR_POS)

#define	CRC_CR_RST_POS	1U 
#define	CRC_CR_RST_MSK	BIT(CRC_CR_RST_POS)

#define	CRC_CR_EN_POS	0U 
#define	CRC_CR_EN_MSK	BIT(CRC_CR_EN_POS)

/****************** Bit definition for CRC_DATA register ************************/

#define	CRC_DATA_DATA_POSS	0U 
#define	CRC_DATA_DATA_POSE	31U 
#define	CRC_DATA_DATA_MSK	BITS(CRC_DATA_DATA_POSS,CRC_DATA_DATA_POSE)

/****************** Bit definition for CRC_SEED register ************************/

#define	CRC_SEED_SEED_POSS	0U 
#define	CRC_SEED_SEED_POSE	31U 
#define	CRC_SEED_SEED_MSK	BITS(CRC_SEED_SEED_POSS,CRC_SEED_SEED_POSE)

/****************** Bit definition for CRC_CHECKSUM register ************************/

#define	CRC_CHECKSUM_CHECKSUM_POSS	0U 
#define	CRC_CHECKSUM_CHECKSUM_POSE	31U 
#define	CRC_CHECKSUM_CHECKSUM_MSK	BITS(CRC_CHECKSUM_CHECKSUM_POSS,CRC_CHECKSUM_CHECKSUM_POSE)

typedef struct
{
	__IO uint32_t CR;
	__IO uint32_t DATA;
	__IO uint32_t SEED;
	__I uint32_t CHECKSUM;
} CRC_TypeDef;

/****************** Bit definition for CRYPT_CON register ************************/

#define	CRYPT_CON_CRYSEL_POS	31U 
#define	CRYPT_CON_CRYSEL_MSK	BIT(CRYPT_CON_CRYSEL_POS)

#define	CRYPT_CON_RESCLR_POS	15U 
#define	CRYPT_CON_RESCLR_MSK	BIT(CRYPT_CON_RESCLR_POS)

#define	CRYPT_CON_DMAEN_POS	14U 
#define	CRYPT_CON_DMAEN_MSK	BIT(CRYPT_CON_DMAEN_POS)

#define	CRYPT_CON_FIFOODR_POS	13U 
#define	CRYPT_CON_FIFOODR_MSK	BIT(CRYPT_CON_FIFOODR_POS)

#define	CRYPT_CON_FIFOEN_POS	12U 
#define	CRYPT_CON_FIFOEN_MSK	BIT(CRYPT_CON_FIFOEN_POS)

#define	CRYPT_CON_DESKS_POS	11U 
#define	CRYPT_CON_DESKS_MSK	BIT(CRYPT_CON_DESKS_POS)

#define	CRYPT_CON_TDES_POS	10U 
#define	CRYPT_CON_TDES_MSK	BIT(CRYPT_CON_TDES_POS)

#define	CRYPT_CON_TYPE_POSS	8U 
#define	CRYPT_CON_TYPE_POSE	9U 
#define	CRYPT_CON_TYPE_MSK	BITS(CRYPT_CON_TYPE_POSS,CRYPT_CON_TYPE_POSE)

#define	CRYPT_CON_IE_POS	7U 
#define	CRYPT_CON_IE_MSK	BIT(CRYPT_CON_IE_POS)

#define	CRYPT_CON_IVEN_POS	6U 
#define	CRYPT_CON_IVEN_MSK	BIT(CRYPT_CON_IVEN_POS)

#define	CRYPT_CON_MODE_POSS	4U 
#define	CRYPT_CON_MODE_POSE	5U 
#define	CRYPT_CON_MODE_MSK	BITS(CRYPT_CON_MODE_POSS,CRYPT_CON_MODE_POSE)

#define	CRYPT_CON_AESKS_POSS	2U 
#define	CRYPT_CON_AESKS_POSE	3U 
#define	CRYPT_CON_AESKS_MSK	BITS(CRYPT_CON_AESKS_POSS,CRYPT_CON_AESKS_POSE)

#define	CRYPT_CON_ENCS_POS	1U 
#define	CRYPT_CON_ENCS_MSK	BIT(CRYPT_CON_ENCS_POS)

#define	CRYPT_CON_GO_POS	0U 
#define	CRYPT_CON_GO_MSK	BIT(CRYPT_CON_GO_POS)

/****************** Bit definition for CRYPT_IF register ************************/

#define	CRYPT_IF_DONE_POS	8U 
#define	CRYPT_IF_DONE_MSK	BIT(CRYPT_IF_DONE_POS)

#define	CRYPT_IF_MULTHIF_POS	2U 
#define	CRYPT_IF_MULTHIF_MSK	BIT(CRYPT_IF_MULTHIF_POS)

#define	CRYPT_IF_DESIF_POS	1U 
#define	CRYPT_IF_DESIF_MSK	BIT(CRYPT_IF_DESIF_POS)

#define	CRYPT_IF_AESIF_POS	0U 
#define	CRYPT_IF_AESIF_MSK	BIT(CRYPT_IF_AESIF_POS)

/****************** Bit definition for CRYPT_IFC register ************************/

#define	CRYPT_IFC_MULTHIFC_POS	2U 
#define	CRYPT_IFC_MULTHIFC_MSK	BIT(CRYPT_IFC_MULTHIFC_POS)

#define	CRYPT_IFC_DESIFC_POS	1U 
#define	CRYPT_IFC_DESIFC_MSK	BIT(CRYPT_IFC_DESIFC_POS)

#define	CRYPT_IFC_AESIFC_POS	0U 
#define	CRYPT_IFC_AESIFC_MSK	BIT(CRYPT_IFC_AESIFC_POS)

/****************** Bit definition for CRYPT_FIFO register ************************/

#define	CRYPT_FIFO_FIFO_POSS	0U 
#define	CRYPT_FIFO_FIFO_POSE	31U 
#define	CRYPT_FIFO_FIFO_MSK	BITS(CRYPT_FIFO_FIFO_POSS,CRYPT_FIFO_FIFO_POSE)

typedef struct
{
	__IO uint32_t DATA[4];
	__IO uint32_t KEY[8];
	__IO uint32_t IV[4];
	__I uint32_t RES[4];
	__IO uint32_t CON;
	__I uint32_t IF;
	__O uint32_t IFC;
	__IO uint32_t FIFO;
} CRYPT_TypeDef;

/****************** Bit definition for LCD_CR register ************************/

#define	LCD_CR_VCHPS_POSS	24U 
#define	LCD_CR_VCHPS_POSE	25U 
#define	LCD_CR_VCHPS_MSK	BITS(LCD_CR_VCHPS_POSS,LCD_CR_VCHPS_POSE)

#define	LCD_CR_DSLD_POSS	20U 
#define	LCD_CR_DSLD_POSE	23U 
#define	LCD_CR_DSLD_MSK	BITS(LCD_CR_DSLD_POSS,LCD_CR_DSLD_POSE)

#define	LCD_CR_DSHD_POSS	16U 
#define	LCD_CR_DSHD_POSE	19U 
#define	LCD_CR_DSHD_MSK	BITS(LCD_CR_DSHD_POSS,LCD_CR_DSHD_POSE)

#define	LCD_CR_VBUFLD_POS	15U 
#define	LCD_CR_VBUFLD_MSK	BIT(LCD_CR_VBUFLD_POS)

#define	LCD_CR_VBUFHD_POS	14U 
#define	LCD_CR_VBUFHD_MSK	BIT(LCD_CR_VBUFHD_POS)

#define	LCD_CR_RESLD_POSS	12U 
#define	LCD_CR_RESLD_POSE	13U 
#define	LCD_CR_RESLD_MSK	BITS(LCD_CR_RESLD_POSS,LCD_CR_RESLD_POSE)

#define	LCD_CR_RESHD_POSS	10U 
#define	LCD_CR_RESHD_POSE	11U 
#define	LCD_CR_RESHD_MSK	BITS(LCD_CR_RESHD_POSS,LCD_CR_RESHD_POSE)

#define	LCD_CR_BIAS_POSS	8U 
#define	LCD_CR_BIAS_POSE	9U 
#define	LCD_CR_BIAS_MSK	BITS(LCD_CR_BIAS_POSS,LCD_CR_BIAS_POSE)

#define	LCD_CR_DUTY_POSS	4U 
#define	LCD_CR_DUTY_POSE	6U 
#define	LCD_CR_DUTY_MSK	BITS(LCD_CR_DUTY_POSS,LCD_CR_DUTY_POSE)

#define	LCD_CR_OE_POS	3U 
#define	LCD_CR_OE_MSK	BIT(LCD_CR_OE_POS)

#define	LCD_CR_VSEL_POSS	1U 
#define	LCD_CR_VSEL_POSE	2U 
#define	LCD_CR_VSEL_MSK	BITS(LCD_CR_VSEL_POSS,LCD_CR_VSEL_POSE)

#define	LCD_CR_EN_POS	0U 
#define	LCD_CR_EN_MSK	BIT(LCD_CR_EN_POS)

/****************** Bit definition for LCD_FCR register ************************/

#define	LCD_FCR_WFS_POS	31U 
#define	LCD_FCR_WFS_MSK	BIT(LCD_FCR_WFS_POS)

#define	LCD_FCR_PRS_POSS	24U 
#define	LCD_FCR_PRS_POSE	27U 
#define	LCD_FCR_PRS_MSK	BITS(LCD_FCR_PRS_POSS,LCD_FCR_PRS_POSE)

#define	LCD_FCR_DIV_POSS	20U 
#define	LCD_FCR_DIV_POSE	23U 
#define	LCD_FCR_DIV_MSK	BITS(LCD_FCR_DIV_POSS,LCD_FCR_DIV_POSE)

#define	LCD_FCR_BLMOD_POSS	16U 
#define	LCD_FCR_BLMOD_POSE	17U 
#define	LCD_FCR_BLMOD_MSK	BITS(LCD_FCR_BLMOD_POSS,LCD_FCR_BLMOD_POSE)

#define	LCD_FCR_BLFRQ_POSS	12U 
#define	LCD_FCR_BLFRQ_POSE	14U 
#define	LCD_FCR_BLFRQ_MSK	BITS(LCD_FCR_BLFRQ_POSS,LCD_FCR_BLFRQ_POSE)

#define	LCD_FCR_DEAD_POSS	8U 
#define	LCD_FCR_DEAD_POSE	10U 
#define	LCD_FCR_DEAD_MSK	BITS(LCD_FCR_DEAD_POSS,LCD_FCR_DEAD_POSE)

#define	LCD_FCR_HD_POS	7U 
#define	LCD_FCR_HD_MSK	BIT(LCD_FCR_HD_POS)

#define	LCD_FCR_PON_POSS	4U 
#define	LCD_FCR_PON_POSE	6U 
#define	LCD_FCR_PON_MSK	BITS(LCD_FCR_PON_POSS,LCD_FCR_PON_POSE)

#define	LCD_FCR_VGS_POSS	0U 
#define	LCD_FCR_VGS_POSE	3U 
#define	LCD_FCR_VGS_MSK	BITS(LCD_FCR_VGS_POSS,LCD_FCR_VGS_POSE)

/****************** Bit definition for LCD_SEGCR0 register ************************/

#define	LCD_SEGCR0_SEG_OE_POSS	0U 
#define	LCD_SEGCR0_SEG_OE_POSE	31U 
#define	LCD_SEGCR0_SEG_OE_MSK	BITS(LCD_SEGCR0_SEG_OE_POSS,LCD_SEGCR0_SEG_OE_POSE)

/****************** Bit definition for LCD_SEGCR1 register ************************/

#define	LCD_SEGCR1_SEG_OE_POSS	0U 
#define	LCD_SEGCR1_SEG_OE_POSE	11U 
#define	LCD_SEGCR1_SEG_OE_MSK	BITS(LCD_SEGCR1_SEG_OE_POSS,LCD_SEGCR1_SEG_OE_POSE)

/****************** Bit definition for LCD_IE register ************************/

#define	LCD_IE_UDDIE_POS	1U 
#define	LCD_IE_UDDIE_MSK	BIT(LCD_IE_UDDIE_POS)

#define	LCD_IE_SOFIE_POS	0U 
#define	LCD_IE_SOFIE_MSK	BIT(LCD_IE_SOFIE_POS)

/****************** Bit definition for LCD_IF register ************************/

#define	LCD_IF_UDDIF_POS	1U 
#define	LCD_IF_UDDIF_MSK	BIT(LCD_IF_UDDIF_POS)

#define	LCD_IF_SOFIF_POS	0U 
#define	LCD_IF_SOFIF_MSK	BIT(LCD_IF_SOFIF_POS)

/****************** Bit definition for LCD_IFCR register ************************/

#define	LCD_IFCR_UDDIFC_POS	1U 
#define	LCD_IFCR_UDDIFC_MSK	BIT(LCD_IFCR_UDDIFC_POS)

#define	LCD_IFCR_SOFIFC_POS	0U 
#define	LCD_IFCR_SOFIFC_MSK	BIT(LCD_IFCR_SOFIFC_POS)

/****************** Bit definition for LCD_SR register ************************/

#define	LCD_SR_FCRSF_POS	3U 
#define	LCD_SR_FCRSF_MSK	BIT(LCD_SR_FCRSF_POS)

#define	LCD_SR_UDR_POS	2U 
#define	LCD_SR_UDR_MSK	BIT(LCD_SR_UDR_POS)

#define	LCD_SR_ENS_POS	1U 
#define	LCD_SR_ENS_MSK	BIT(LCD_SR_ENS_POS)

#define	LCD_SR_RDY_POS	0U 
#define	LCD_SR_RDY_MSK	BIT(LCD_SR_RDY_POS)

/****************** Bit definition for LCD_BUF register ************************/

#define	LCD_BUF_SEG_DATA_POSS	0U 
#define	LCD_BUF_SEG_DATA_POSE	31U 
#define	LCD_BUF_SEG_DATA_MSK	BITS(LCD_BUF_SEG_DATA_POSS,LCD_BUF_SEG_DATA_POSE)

typedef struct
{
	__IO uint32_t CR;
	__IO uint32_t FCR;
	__IO uint32_t SEGCR0;
	__IO uint32_t SEGCR1;
	__IO uint32_t IE;
	__I uint32_t IF;
	__O uint32_t IFCR;
	__I uint32_t SR;
	uint32_t RESERVED0[8] ;
	__IO uint32_t BUF[16];
} LCD_TypeDef;

/****************** Bit definition for ADC_STAT register ************************/

#define	ADC_STAT_ICHS_POS	9U 
#define	ADC_STAT_ICHS_MSK	BIT(ADC_STAT_ICHS_POS)

#define	ADC_STAT_NCHS_POS	8U 
#define	ADC_STAT_NCHS_MSK	BIT(ADC_STAT_NCHS_POS)

#define	ADC_STAT_OVR_POS	3U 
#define	ADC_STAT_OVR_MSK	BIT(ADC_STAT_OVR_POS)

#define	ADC_STAT_ICHE_POS	2U 
#define	ADC_STAT_ICHE_MSK	BIT(ADC_STAT_ICHE_POS)

#define	ADC_STAT_NCHE_POS	1U 
#define	ADC_STAT_NCHE_MSK	BIT(ADC_STAT_NCHE_POS)

#define	ADC_STAT_AWDF_POS	0U 
#define	ADC_STAT_AWDF_MSK	BIT(ADC_STAT_AWDF_POS)

/****************** Bit definition for ADC_CLR register ************************/

#define	ADC_CLR_ICHS_POS	9U 
#define	ADC_CLR_ICHS_MSK	BIT(ADC_CLR_ICHS_POS)

#define	ADC_CLR_NCHS_POS	8U 
#define	ADC_CLR_NCHS_MSK	BIT(ADC_CLR_NCHS_POS)

#define	ADC_CLR_OVR_POS	3U 
#define	ADC_CLR_OVR_MSK	BIT(ADC_CLR_OVR_POS)

#define	ADC_CLR_ICHE_POS	2U 
#define	ADC_CLR_ICHE_MSK	BIT(ADC_CLR_ICHE_POS)

#define	ADC_CLR_NCHE_POS	1U 
#define	ADC_CLR_NCHE_MSK	BIT(ADC_CLR_NCHE_POS)

#define	ADC_CLR_AWDF_POS	0U 
#define	ADC_CLR_AWDF_MSK	BIT(ADC_CLR_AWDF_POS)

/****************** Bit definition for ADC_CON0 register ************************/

#define	ADC_CON0_OVRIE_POS	26U 
#define	ADC_CON0_OVRIE_MSK	BIT(ADC_CON0_OVRIE_POS)

#define	ADC_CON0_RSEL_POSS	24U 
#define	ADC_CON0_RSEL_POSE	25U 
#define	ADC_CON0_RSEL_MSK	BITS(ADC_CON0_RSEL_POSS,ADC_CON0_RSEL_POSE)

#define	ADC_CON0_NCHWDEN_POS	23U 
#define	ADC_CON0_NCHWDEN_MSK	BIT(ADC_CON0_NCHWDEN_POS)

#define	ADC_CON0_ICHWDTEN_POS	22U 
#define	ADC_CON0_ICHWDTEN_MSK	BIT(ADC_CON0_ICHWDTEN_POS)

#define	ADC_CON0_ETRGN_POSS	13U 
#define	ADC_CON0_ETRGN_POSE	15U 
#define	ADC_CON0_ETRGN_MSK	BITS(ADC_CON0_ETRGN_POSS,ADC_CON0_ETRGN_POSE)

#define	ADC_CON0_ICHDCEN_POS	12U 
#define	ADC_CON0_ICHDCEN_MSK	BIT(ADC_CON0_ICHDCEN_POS)

#define	ADC_CON0_NCHDCEN_POS	11U 
#define	ADC_CON0_NCHDCEN_MSK	BIT(ADC_CON0_NCHDCEN_POS)

#define	ADC_CON0_IAUTO_POS	10U 
#define	ADC_CON0_IAUTO_MSK	BIT(ADC_CON0_IAUTO_POS)

#define	ADC_CON0_AWDSGL_POS	9U 
#define	ADC_CON0_AWDSGL_MSK	BIT(ADC_CON0_AWDSGL_POS)

#define	ADC_CON0_SCANEN_POS	8U 
#define	ADC_CON0_SCANEN_MSK	BIT(ADC_CON0_SCANEN_POS)

#define	ADC_CON0_ICHEIE_POS	7U 
#define	ADC_CON0_ICHEIE_MSK	BIT(ADC_CON0_ICHEIE_POS)

#define	ADC_CON0_AWDIE_POS	6U 
#define	ADC_CON0_AWDIE_MSK	BIT(ADC_CON0_AWDIE_POS)

#define	ADC_CON0_NCHEIE_POS	5U 
#define	ADC_CON0_NCHEIE_MSK	BIT(ADC_CON0_NCHEIE_POS)

#define	ADC_CON0_AWDCH_POSS	0U 
#define	ADC_CON0_AWDCH_POSE	4U 
#define	ADC_CON0_AWDCH_MSK	BITS(ADC_CON0_AWDCH_POSS,ADC_CON0_AWDCH_POSE)

/****************** Bit definition for ADC_CON1 register ************************/

#define	ADC_CON1_NCHTRG_POS	30U 
#define	ADC_CON1_NCHTRG_MSK	BIT(ADC_CON1_NCHTRG_POS)

#define	ADC_CON1_NETS_POSS	28U 
#define	ADC_CON1_NETS_POSE	29U 
#define	ADC_CON1_NETS_MSK	BITS(ADC_CON1_NETS_POSS,ADC_CON1_NETS_POSE)

#define	ADC_CON1_ICHTRG_POS	22U 
#define	ADC_CON1_ICHTRG_MSK	BIT(ADC_CON1_ICHTRG_POS)

#define	ADC_CON1_IETS_POSS	20U 
#define	ADC_CON1_IETS_POSE	21U 
#define	ADC_CON1_IETS_MSK	BITS(ADC_CON1_IETS_POSS,ADC_CON1_IETS_POSE)

#define	ADC_CON1_ALIGN_POS	11U 
#define	ADC_CON1_ALIGN_MSK	BIT(ADC_CON1_ALIGN_POS)

#define	ADC_CON1_NCHESEL_POS	10U 
#define	ADC_CON1_NCHESEL_MSK	BIT(ADC_CON1_NCHESEL_POS)

#define	ADC_CON1_DMA_POS	8U 
#define	ADC_CON1_DMA_MSK	BIT(ADC_CON1_DMA_POS)

#define	ADC_CON1_CM_POS	1U 
#define	ADC_CON1_CM_MSK	BIT(ADC_CON1_CM_POS)

#define	ADC_CON1_ADCEN_POS	0U 
#define	ADC_CON1_ADCEN_MSK	BIT(ADC_CON1_ADCEN_POS)

/****************** Bit definition for ADC_SMPT1 register ************************/

#define	ADC_SMPT1_CHT_POSS	0U 
#define	ADC_SMPT1_CHT_POSE	31U 
#define	ADC_SMPT1_CHT_MSK	BITS(ADC_SMPT1_CHT_POSS,ADC_SMPT1_CHT_POSE)

/****************** Bit definition for ADC_SMPT2 register ************************/

#define	ADC_SMPT2_CHT_POSS	0U 
#define	ADC_SMPT2_CHT_POSE	31U 
#define	ADC_SMPT2_CHT_MSK	BITS(ADC_SMPT2_CHT_POSS,ADC_SMPT2_CHT_POSE)

/****************** Bit definition for ADC_SMPT3 register ************************/

#define	ADC_SMPT3_SMP_POSS	0U 
#define	ADC_SMPT3_SMP_POSE	31U 
#define	ADC_SMPT3_SMP_MSK	BITS(ADC_SMPT3_SMP_POSS,ADC_SMPT3_SMP_POSE)

/****************** Bit definition for ADC_ICHOFF1 register ************************/

#define	ADC_ICHOFF1_IOFF_POSS	0U 
#define	ADC_ICHOFF1_IOFF_POSE	11U 
#define	ADC_ICHOFF1_IOFF_MSK	BITS(ADC_ICHOFF1_IOFF_POSS,ADC_ICHOFF1_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF2 register ************************/

#define	ADC_ICHOFF2_IOFF_POSS	0U 
#define	ADC_ICHOFF2_IOFF_POSE	11U 
#define	ADC_ICHOFF2_IOFF_MSK	BITS(ADC_ICHOFF2_IOFF_POSS,ADC_ICHOFF2_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF3 register ************************/

#define	ADC_ICHOFF3_IOFF_POSS	0U 
#define	ADC_ICHOFF3_IOFF_POSE	11U 
#define	ADC_ICHOFF3_IOFF_MSK	BITS(ADC_ICHOFF3_IOFF_POSS,ADC_ICHOFF3_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF4 register ************************/

#define	ADC_ICHOFF4_IOFF_POSS	0U 
#define	ADC_ICHOFF4_IOFF_POSE	11U 
#define	ADC_ICHOFF4_IOFF_MSK	BITS(ADC_ICHOFF4_IOFF_POSS,ADC_ICHOFF4_IOFF_POSE)

/****************** Bit definition for ADC_NCHS1 register ************************/

#define	ADC_NCHS1_NS4_POSS	24U 
#define	ADC_NCHS1_NS4_POSE	28U 
#define	ADC_NCHS1_NS4_MSK	BITS(ADC_NCHS1_NS4_POSS,ADC_NCHS1_NS4_POSE)

#define	ADC_NCHS1_NS3_POSS	16U 
#define	ADC_NCHS1_NS3_POSE	20U 
#define	ADC_NCHS1_NS3_MSK	BITS(ADC_NCHS1_NS3_POSS,ADC_NCHS1_NS3_POSE)

#define	ADC_NCHS1_NS2_POSS	8U 
#define	ADC_NCHS1_NS2_POSE	12U 
#define	ADC_NCHS1_NS2_MSK	BITS(ADC_NCHS1_NS2_POSS,ADC_NCHS1_NS2_POSE)

#define	ADC_NCHS1_NS1_POSS	0U 
#define	ADC_NCHS1_NS1_POSE	4U 
#define	ADC_NCHS1_NS1_MSK	BITS(ADC_NCHS1_NS1_POSS,ADC_NCHS1_NS1_POSE)

/****************** Bit definition for ADC_NCHS2 register ************************/

#define	ADC_NCHS2_NS8_POSS	24U 
#define	ADC_NCHS2_NS8_POSE	28U 
#define	ADC_NCHS2_NS8_MSK	BITS(ADC_NCHS2_NS8_POSS,ADC_NCHS2_NS8_POSE)

#define	ADC_NCHS2_NS7_POSS	16U 
#define	ADC_NCHS2_NS7_POSE	20U 
#define	ADC_NCHS2_NS7_MSK	BITS(ADC_NCHS2_NS7_POSS,ADC_NCHS2_NS7_POSE)

#define	ADC_NCHS2_NS6_POSS	8U 
#define	ADC_NCHS2_NS6_POSE	12U 
#define	ADC_NCHS2_NS6_MSK	BITS(ADC_NCHS2_NS6_POSS,ADC_NCHS2_NS6_POSE)

#define	ADC_NCHS2_NS5_POSS	0U 
#define	ADC_NCHS2_NS5_POSE	4U 
#define	ADC_NCHS2_NS5_MSK	BITS(ADC_NCHS2_NS5_POSS,ADC_NCHS2_NS5_POSE)

/****************** Bit definition for ADC_NCHS3 register ************************/

#define	ADC_NCHS3_NS12_POSS	24U 
#define	ADC_NCHS3_NS12_POSE	28U 
#define	ADC_NCHS3_NS12_MSK	BITS(ADC_NCHS3_NS12_POSS,ADC_NCHS3_NS12_POSE)

#define	ADC_NCHS3_NS11_POSS	16U 
#define	ADC_NCHS3_NS11_POSE	20U 
#define	ADC_NCHS3_NS11_MSK	BITS(ADC_NCHS3_NS11_POSS,ADC_NCHS3_NS11_POSE)

#define	ADC_NCHS3_NS10_POSS	8U 
#define	ADC_NCHS3_NS10_POSE	12U 
#define	ADC_NCHS3_NS10_MSK	BITS(ADC_NCHS3_NS10_POSS,ADC_NCHS3_NS10_POSE)

#define	ADC_NCHS3_NS9_POSS	0U 
#define	ADC_NCHS3_NS9_POSE	4U 
#define	ADC_NCHS3_NS9_MSK	BITS(ADC_NCHS3_NS9_POSS,ADC_NCHS3_NS9_POSE)

/****************** Bit definition for ADC_NCHS4 register ************************/

#define	ADC_NCHS4_NS16_POSS	24U 
#define	ADC_NCHS4_NS16_POSE	28U 
#define	ADC_NCHS4_NS16_MSK	BITS(ADC_NCHS4_NS16_POSS,ADC_NCHS4_NS16_POSE)

#define	ADC_NCHS4_NS15_POSS	16U 
#define	ADC_NCHS4_NS15_POSE	20U 
#define	ADC_NCHS4_NS15_MSK	BITS(ADC_NCHS4_NS15_POSS,ADC_NCHS4_NS15_POSE)

#define	ADC_NCHS4_NS14_POSS	8U 
#define	ADC_NCHS4_NS14_POSE	12U 
#define	ADC_NCHS4_NS14_MSK	BITS(ADC_NCHS4_NS14_POSS,ADC_NCHS4_NS14_POSE)

#define	ADC_NCHS4_NS13_POSS	0U 
#define	ADC_NCHS4_NS13_POSE	4U 
#define	ADC_NCHS4_NS13_MSK	BITS(ADC_NCHS4_NS13_POSS,ADC_NCHS4_NS13_POSE)

/****************** Bit definition for ADC_ICHS register ************************/

#define	ADC_ICHS_IS4_POSS	24U 
#define	ADC_ICHS_IS4_POSE	28U 
#define	ADC_ICHS_IS4_MSK	BITS(ADC_ICHS_IS4_POSS,ADC_ICHS_IS4_POSE)

#define	ADC_ICHS_IS3_POSS	16U 
#define	ADC_ICHS_IS3_POSE	20U 
#define	ADC_ICHS_IS3_MSK	BITS(ADC_ICHS_IS3_POSS,ADC_ICHS_IS3_POSE)

#define	ADC_ICHS_IS2_POSS	8U 
#define	ADC_ICHS_IS2_POSE	12U 
#define	ADC_ICHS_IS2_MSK	BITS(ADC_ICHS_IS2_POSS,ADC_ICHS_IS2_POSE)

#define	ADC_ICHS_IS1_POSS	0U 
#define	ADC_ICHS_IS1_POSE	4U 
#define	ADC_ICHS_IS1_MSK	BITS(ADC_ICHS_IS1_POSS,ADC_ICHS_IS1_POSE)

/****************** Bit definition for ADC_CHSL register ************************/

#define	ADC_CHSL_ISL_POSS	8U 
#define	ADC_CHSL_ISL_POSE	9U 
#define	ADC_CHSL_ISL_MSK	BITS(ADC_CHSL_ISL_POSS,ADC_CHSL_ISL_POSE)

#define	ADC_CHSL_NSL_POSS	0U 
#define	ADC_CHSL_NSL_POSE	3U 
#define	ADC_CHSL_NSL_MSK	BITS(ADC_CHSL_NSL_POSS,ADC_CHSL_NSL_POSE)

/****************** Bit definition for ADC_WDTH register ************************/

#define	ADC_WDTH_HT_POSS	0U 
#define	ADC_WDTH_HT_POSE	11U 
#define	ADC_WDTH_HT_MSK	BITS(ADC_WDTH_HT_POSS,ADC_WDTH_HT_POSE)

/****************** Bit definition for ADC_WDTL register ************************/

#define	ADC_WDTL_LT_POSS	0U 
#define	ADC_WDTL_LT_POSE	11U 
#define	ADC_WDTL_LT_MSK	BITS(ADC_WDTL_LT_POSS,ADC_WDTL_LT_POSE)

/****************** Bit definition for ADC_ICHDR1 register ************************/

#define	ADC_ICHDR1_VAL_POSS	0U 
#define	ADC_ICHDR1_VAL_POSE	15U 
#define	ADC_ICHDR1_VAL_MSK	BITS(ADC_ICHDR1_VAL_POSS,ADC_ICHDR1_VAL_POSE)

/****************** Bit definition for ADC_ICHDR2 register ************************/

#define	ADC_ICHDR2_VAL_POSS	0U 
#define	ADC_ICHDR2_VAL_POSE	15U 
#define	ADC_ICHDR2_VAL_MSK	BITS(ADC_ICHDR2_VAL_POSS,ADC_ICHDR2_VAL_POSE)

/****************** Bit definition for ADC_ICHDR3 register ************************/

#define	ADC_ICHDR3_VAL_POSS	0U 
#define	ADC_ICHDR3_VAL_POSE	15U 
#define	ADC_ICHDR3_VAL_MSK	BITS(ADC_ICHDR3_VAL_POSS,ADC_ICHDR3_VAL_POSE)

/****************** Bit definition for ADC_ICHDR4 register ************************/

#define	ADC_ICHDR4_VAL_POSS	0U 
#define	ADC_ICHDR4_VAL_POSE	15U 
#define	ADC_ICHDR4_VAL_MSK	BITS(ADC_ICHDR4_VAL_POSS,ADC_ICHDR4_VAL_POSE)

/****************** Bit definition for ADC_NCHDR register ************************/

#define	ADC_NCHDR_VAL_POSS	0U 
#define	ADC_NCHDR_VAL_POSE	15U 
#define	ADC_NCHDR_VAL_MSK	BITS(ADC_NCHDR_VAL_POSS,ADC_NCHDR_VAL_POSE)

/****************** Bit definition for ADC_CCR register ************************/

#define	ADC_CCR_ADCH_PBUF_EN_POS	31U 
#define	ADC_CCR_ADCH_PBUF_EN_MSK	BIT(ADC_CCR_ADCH_PBUF_EN_POS)

#define	ADC_CCR_ADCH_NBUF_EN_POS	30U 
#define	ADC_CCR_ADCH_NBUF_EN_MSK	BIT(ADC_CCR_ADCH_NBUF_EN_POS)

#define	ADC_CCR_ADCH_INBUF_CALEN_POS	29U 
#define	ADC_CCR_ADCH_INBUF_CALEN_MSK	BIT(ADC_CCR_ADCH_INBUF_CALEN_POS)

#define	ADC_CCR_TRMEN_POS	28U 
#define	ADC_CCR_TRMEN_MSK	BIT(ADC_CCR_TRMEN_POS)

#define	ADC_CCR_GAINCALEN_POS	25U 
#define	ADC_CCR_GAINCALEN_MSK	BIT(ADC_CCR_GAINCALEN_POS)

#define	ADC_CCR_OFFCALEN_POS	24U 
#define	ADC_CCR_OFFCALEN_MSK	BIT(ADC_CCR_OFFCALEN_POS)

#define	ADC_CCR_VREFOEN_POS	19U 
#define	ADC_CCR_VREFOEN_MSK	BIT(ADC_CCR_VREFOEN_POS)

#define	ADC_CCR_VRNSEL_POS	18U 
#define	ADC_CCR_VRNSEL_MSK	BIT(ADC_CCR_VRNSEL_POS)

#define	ADC_CCR_VRPSEL_POSS	16U 
#define	ADC_CCR_VRPSEL_POSE	17U 
#define	ADC_CCR_VRPSEL_MSK	BITS(ADC_CCR_VRPSEL_POSS,ADC_CCR_VRPSEL_POSE)

#define	ADC_CCR_PWRMODSEL_POS	15U 
#define	ADC_CCR_PWRMODSEL_MSK	BIT(ADC_CCR_PWRMODSEL_POS)

#define	ADC_CCR_DIFFEN_POS	12U 
#define	ADC_CCR_DIFFEN_MSK	BIT(ADC_CCR_DIFFEN_POS)

#define	ADC_CCR_IREFEN_POS	11U 
#define	ADC_CCR_IREFEN_MSK	BIT(ADC_CCR_IREFEN_POS)

#define	ADC_CCR_VRBUFEN_POS	10U 
#define	ADC_CCR_VRBUFEN_MSK	BIT(ADC_CCR_VRBUFEN_POS)

#define	ADC_CCR_VCMBUFEN_POS	9U 
#define	ADC_CCR_VCMBUFEN_MSK	BIT(ADC_CCR_VCMBUFEN_POS)

#define	ADC_CCR_VREFEN_POS	8U 
#define	ADC_CCR_VREFEN_MSK	BIT(ADC_CCR_VREFEN_POS)

#define	ADC_CCR_CKDIV_POSS	0U 
#define	ADC_CCR_CKDIV_POSE	2U 
#define	ADC_CCR_CKDIV_MSK	BITS(ADC_CCR_CKDIV_POSS,ADC_CCR_CKDIV_POSE)

typedef struct
{
	__I uint32_t STAT;
	__O uint32_t CLR;
	__IO uint32_t CON0;
	__IO uint32_t CON1;
	__IO uint32_t SMPT1;
	__IO uint32_t SMPT2;
	__IO uint32_t SMPT3;
	__IO uint32_t RESERVED;
	__IO uint32_t ICHOFF1;
	__IO uint32_t ICHOFF2;
	__IO uint32_t ICHOFF3;
	__IO uint32_t ICHOFF4;
	__IO uint32_t NCHS1;
	__IO uint32_t NCHS2;
	__IO uint32_t NCHS3;
	__IO uint32_t NCHS4;
	__IO uint32_t ICHS;
	__IO uint32_t CHSL;
	__IO uint32_t WDTH;
	__IO uint32_t WDTL;
	__I uint32_t ICHDR1;
	__I uint32_t ICHDR2;
	__I uint32_t ICHDR3;
	__I uint32_t ICHDR4;
	__I uint32_t NCHDR;
	__IO uint32_t CCR;
} ADC_TypeDef;

/****************** Bit definition for ACMP_CON register ************************/

#define	ACMP_CON_FALLEN_POS	17U 
#define	ACMP_CON_FALLEN_MSK	BIT(ACMP_CON_FALLEN_POS)

#define	ACMP_CON_RISEEN_POS	16U 
#define	ACMP_CON_RISEEN_MSK	BIT(ACMP_CON_RISEEN_POS)

#define	ACMP_CON_MODSEL_POSS	14U 
#define	ACMP_CON_MODSEL_POSE	15U 
#define	ACMP_CON_MODSEL_MSK	BITS(ACMP_CON_MODSEL_POSS,ACMP_CON_MODSEL_POSE)

#define	ACMP_CON_WARMUPT_POSS	8U 
#define	ACMP_CON_WARMUPT_POSE	10U 
#define	ACMP_CON_WARMUPT_MSK	BITS(ACMP_CON_WARMUPT_POSS,ACMP_CON_WARMUPT_POSE)

#define	ACMP_CON_HYSTSEL_POSS	4U 
#define	ACMP_CON_HYSTSEL_POSE	6U 
#define	ACMP_CON_HYSTSEL_MSK	BITS(ACMP_CON_HYSTSEL_POSS,ACMP_CON_HYSTSEL_POSE)

#define	ACMP_CON_OUTINV_POS	3U 
#define	ACMP_CON_OUTINV_MSK	BIT(ACMP_CON_OUTINV_POS)

#define	ACMP_CON_INACTV_POS	2U 
#define	ACMP_CON_INACTV_MSK	BIT(ACMP_CON_INACTV_POS)

#define	ACMP_CON_EN_POS	0U 
#define	ACMP_CON_EN_MSK	BIT(ACMP_CON_EN_POS)

/****************** Bit definition for ACMP_INPUTSEL register ************************/

#define	ACMP_INPUTSEL_VDDLVL_POSS	8U 
#define	ACMP_INPUTSEL_VDDLVL_POSE	13U 
#define	ACMP_INPUTSEL_VDDLVL_MSK	BITS(ACMP_INPUTSEL_VDDLVL_POSS,ACMP_INPUTSEL_VDDLVL_POSE)

#define	ACMP_INPUTSEL_NSEL_POSS	4U 
#define	ACMP_INPUTSEL_NSEL_POSE	7U 
#define	ACMP_INPUTSEL_NSEL_MSK	BITS(ACMP_INPUTSEL_NSEL_POSS,ACMP_INPUTSEL_NSEL_POSE)

#define	ACMP_INPUTSEL_PSEL_POSS	0U 
#define	ACMP_INPUTSEL_PSEL_POSE	2U 
#define	ACMP_INPUTSEL_PSEL_MSK	BITS(ACMP_INPUTSEL_PSEL_POSS,ACMP_INPUTSEL_PSEL_POSE)

/****************** Bit definition for ACMP_STAT register ************************/

#define	ACMP_STAT_OUT_POS	1U 
#define	ACMP_STAT_OUT_MSK	BIT(ACMP_STAT_OUT_POS)

#define	ACMP_STAT_ACT_POS	0U 
#define	ACMP_STAT_ACT_MSK	BIT(ACMP_STAT_ACT_POS)

/****************** Bit definition for ACMP_IES register ************************/

#define	ACMP_IES_WARMUP_POS	1U 
#define	ACMP_IES_WARMUP_MSK	BIT(ACMP_IES_WARMUP_POS)

#define	ACMP_IES_EDGE_POS	0U 
#define	ACMP_IES_EDGE_MSK	BIT(ACMP_IES_EDGE_POS)

/****************** Bit definition for ACMP_IEV register ************************/

#define	ACMP_IEV_WARMUP_POS	1U 
#define	ACMP_IEV_WARMUP_MSK	BIT(ACMP_IEV_WARMUP_POS)

#define	ACMP_IEV_EDGE_POS	0U 
#define	ACMP_IEV_EDGE_MSK	BIT(ACMP_IEV_EDGE_POS)

/****************** Bit definition for ACMP_IEC register ************************/

#define	ACMP_IEC_WARMUP_POS	1U 
#define	ACMP_IEC_WARMUP_MSK	BIT(ACMP_IEC_WARMUP_POS)

#define	ACMP_IEC_EDGE_POS	0U 
#define	ACMP_IEC_EDGE_MSK	BIT(ACMP_IEC_EDGE_POS)

/****************** Bit definition for ACMP_RIF register ************************/

#define	ACMP_RIF_WARMUP_POS	1U 
#define	ACMP_RIF_WARMUP_MSK	BIT(ACMP_RIF_WARMUP_POS)

#define	ACMP_RIF_EDGE_POS	0U 
#define	ACMP_RIF_EDGE_MSK	BIT(ACMP_RIF_EDGE_POS)

/****************** Bit definition for ACMP_IFM register ************************/

#define	ACMP_IFM_WARMUP_POS	1U 
#define	ACMP_IFM_WARMUP_MSK	BIT(ACMP_IFM_WARMUP_POS)

#define	ACMP_IFM_EDGE_POS	0U 
#define	ACMP_IFM_EDGE_MSK	BIT(ACMP_IFM_EDGE_POS)

/****************** Bit definition for ACMP_IFC register ************************/

#define	ACMP_IFC_WARMUP_POS	1U 
#define	ACMP_IFC_WARMUP_MSK	BIT(ACMP_IFC_WARMUP_POS)

#define	ACMP_IFC_EDGE_POS	0U 
#define	ACMP_IFC_EDGE_MSK	BIT(ACMP_IFC_EDGE_POS)

/****************** Bit definition for ACMP_PORT register ************************/

#define	ACMP_PORT_PEN_POS	0U 
#define	ACMP_PORT_PEN_MSK	BIT(ACMP_PORT_PEN_POS)

typedef struct
{
	__IO uint32_t CON;
	__IO uint32_t INPUTSEL;
	__I uint32_t STAT;
	__O uint32_t IES;
	__O uint32_t IEC;
	__I uint32_t IEV;
	__I uint32_t RIF;
	__O uint32_t IFM;
	__O uint32_t IFC;
	__IO uint32_t PORT;
} ACMP_TypeDef;

/****************** Bit definition for CALC_SQRTSR register ************************/

#define	CALC_SQRTSR_BUSY_POS	0U 
#define	CALC_SQRTSR_BUSY_MSK	BIT(CALC_SQRTSR_BUSY_POS)

/****************** Bit definition for CALC_RDCND register ************************/

#define	CALC_RDCND_RADICAND_POSS	0U 
#define	CALC_RDCND_RADICAND_POSE	31U 
#define	CALC_RDCND_RADICAND_MSK	BITS(CALC_RDCND_RADICAND_POSS,CALC_RDCND_RADICAND_POSE)

/****************** Bit definition for CALC_SQRTRES register ************************/

#define	CALC_SQRTRES_RESULT_POSS	0U 
#define	CALC_SQRTRES_RESULT_POSE	15U 
#define	CALC_SQRTRES_RESULT_MSK	BITS(CALC_SQRTRES_RESULT_POSS,CALC_SQRTRES_RESULT_POSE)

/****************** Bit definition for CALC_DIVDR register ************************/

#define	CALC_DIVDR_DIVD_POSS	0U 
#define	CALC_DIVDR_DIVD_POSE	31U 
#define	CALC_DIVDR_DIVD_MSK	BITS(CALC_DIVDR_DIVD_POSS,CALC_DIVDR_DIVD_POSE)

/****************** Bit definition for CALC_DIVSR register ************************/

#define	CALC_DIVSR_DIVS_POSS	0U 
#define	CALC_DIVSR_DIVS_POSE	31U 
#define	CALC_DIVSR_DIVS_MSK	BITS(CALC_DIVSR_DIVS_POSS,CALC_DIVSR_DIVS_POSE)

/****************** Bit definition for CALC_DIVQR register ************************/

#define	CALC_DIVQR_DIVQ_POSS	0U 
#define	CALC_DIVQR_DIVQ_POSE	31U 
#define	CALC_DIVQR_DIVQ_MSK	BITS(CALC_DIVQR_DIVQ_POSS,CALC_DIVQR_DIVQ_POSE)

/****************** Bit definition for CALC_DIVRR register ************************/

#define	CALC_DIVRR_DIVS_POSS	0U 
#define	CALC_DIVRR_DIVS_POSE	31U 
#define	CALC_DIVRR_DIVS_MSK	BITS(CALC_DIVRR_DIVS_POSS,CALC_DIVRR_DIVS_POSE)

/****************** Bit definition for CALC_DIVCSR register ************************/

#define	CALC_DIVCSR_TRM_POS	9U 
#define	CALC_DIVCSR_TRM_MSK	BIT(CALC_DIVCSR_TRM_POS)

#define	CALC_DIVCSR_SIGN_POS	8U 
#define	CALC_DIVCSR_SIGN_MSK	BIT(CALC_DIVCSR_SIGN_POS)

#define	CALC_DIVCSR_DZ_POS	1U 
#define	CALC_DIVCSR_DZ_MSK	BIT(CALC_DIVCSR_DZ_POS)

#define	CALC_DIVCSR_BUSY_POS	0U 
#define	CALC_DIVCSR_BUSY_MSK	BIT(CALC_DIVCSR_BUSY_POS)

typedef struct
{
	__I uint32_t SQRTSR;
	__IO uint32_t RDCND;
	__I uint32_t SQRTRES;
	uint32_t RESERVED0[5] ;
	__IO uint32_t DIVDR;
	__IO uint32_t DIVSR;
	__I uint32_t DIVQR;
	__I uint32_t DIVRR;
	__IO uint32_t DIVCSR;
} CALC_TypeDef;

/****************** Bit definition for TRNG_CR register ************************/

#define	TRNG_CR_ADJC_POSS	16U 
#define	TRNG_CR_ADJC_POSE	17U 
#define	TRNG_CR_ADJC_MSK	BITS(TRNG_CR_ADJC_POSS,TRNG_CR_ADJC_POSE)

#define	TRNG_CR_SDSEL_POSS	10U 
#define	TRNG_CR_SDSEL_POSE	11U 
#define	TRNG_CR_SDSEL_MSK	BITS(TRNG_CR_SDSEL_POSS,TRNG_CR_SDSEL_POSE)

#define	TRNG_CR_DSEL_POSS	8U 
#define	TRNG_CR_DSEL_POSE	9U 
#define	TRNG_CR_DSEL_MSK	BITS(TRNG_CR_DSEL_POSS,TRNG_CR_DSEL_POSE)

#define	TRNG_CR_POSTEN_POS	3U 
#define	TRNG_CR_POSTEN_MSK	BIT(TRNG_CR_POSTEN_POS)

#define	TRNG_CR_TRNGSEL_POS	2U 
#define	TRNG_CR_TRNGSEL_MSK	BIT(TRNG_CR_TRNGSEL_POS)

#define	TRNG_CR_ADJM_POS	1U 
#define	TRNG_CR_ADJM_MSK	BIT(TRNG_CR_ADJM_POS)

#define	TRNG_CR_TRNGEN_POS	0U 
#define	TRNG_CR_TRNGEN_MSK	BIT(TRNG_CR_TRNGEN_POS)

/****************** Bit definition for TRNG_SR register ************************/

#define	TRNG_SR_OVER_POS	3U 
#define	TRNG_SR_OVER_MSK	BIT(TRNG_SR_OVER_POS)

#define	TRNG_SR_SERR_POS	2U 
#define	TRNG_SR_SERR_MSK	BIT(TRNG_SR_SERR_POS)

#define	TRNG_SR_DAVLD_POS	1U 
#define	TRNG_SR_DAVLD_MSK	BIT(TRNG_SR_DAVLD_POS)

#define	TRNG_SR_START_POS	0U 
#define	TRNG_SR_START_MSK	BIT(TRNG_SR_START_POS)

/****************** Bit definition for TRNG_DR register ************************/

#define	TRNG_DR_DATA_POSS	0U 
#define	TRNG_DR_DATA_POSE	31U 
#define	TRNG_DR_DATA_MSK	BITS(TRNG_DR_DATA_POSS,TRNG_DR_DATA_POSE)

/****************** Bit definition for TRNG_SEED register ************************/

#define	TRNG_SEED_SEED_POSS	0U 
#define	TRNG_SEED_SEED_POSE	31U 
#define	TRNG_SEED_SEED_MSK	BITS(TRNG_SEED_SEED_POSS,TRNG_SEED_SEED_POSE)

/****************** Bit definition for TRNG_CFGR register ************************/

#define	TRNG_CFGR_TOPLMT_POSS	16U 
#define	TRNG_CFGR_TOPLMT_POSE	24U 
#define	TRNG_CFGR_TOPLMT_MSK	BITS(TRNG_CFGR_TOPLMT_POSS,TRNG_CFGR_TOPLMT_POSE)

#define	TRNG_CFGR_CKDIV_POSS	8U 
#define	TRNG_CFGR_CKDIV_POSE	11U 
#define	TRNG_CFGR_CKDIV_MSK	BITS(TRNG_CFGR_CKDIV_POSS,TRNG_CFGR_CKDIV_POSE)

#define	TRNG_CFGR_TSTART_POSS	0U 
#define	TRNG_CFGR_TSTART_POSE	2U 
#define	TRNG_CFGR_TSTART_MSK	BITS(TRNG_CFGR_TSTART_POSS,TRNG_CFGR_TSTART_POSE)

/****************** Bit definition for TRNG_IER register ************************/

#define	TRNG_IER_SERR_POS	2U 
#define	TRNG_IER_SERR_MSK	BIT(TRNG_IER_SERR_POS)

#define	TRNG_IER_DAVLD_POS	1U 
#define	TRNG_IER_DAVLD_MSK	BIT(TRNG_IER_DAVLD_POS)

#define	TRNG_IER_START_POS	0U 
#define	TRNG_IER_START_MSK	BIT(TRNG_IER_START_POS)

/****************** Bit definition for TRNG_IFR register ************************/

#define	TRNG_IFR_SERR_POS	2U 
#define	TRNG_IFR_SERR_MSK	BIT(TRNG_IFR_SERR_POS)

#define	TRNG_IFR_DAVLD_POS	1U 
#define	TRNG_IFR_DAVLD_MSK	BIT(TRNG_IFR_DAVLD_POS)

#define	TRNG_IFR_START_POS	0U 
#define	TRNG_IFR_START_MSK	BIT(TRNG_IFR_START_POS)

/****************** Bit definition for TRNG_IFCR register ************************/

#define	TRNG_IFCR_SERRC_POS	2U 
#define	TRNG_IFCR_SERRC_MSK	BIT(TRNG_IFCR_SERRC_POS)

#define	TRNG_IFCR_DAVLDC_POS	1U 
#define	TRNG_IFCR_DAVLDC_MSK	BIT(TRNG_IFCR_DAVLDC_POS)

#define	TRNG_IFCR_STARTC_POS	0U 
#define	TRNG_IFCR_STARTC_MSK	BIT(TRNG_IFCR_STARTC_POS)

/****************** Bit definition for TRNG_ISR register ************************/

#define	TRNG_ISR_SERR_POS	2U 
#define	TRNG_ISR_SERR_MSK	BIT(TRNG_ISR_SERR_POS)

#define	TRNG_ISR_DAVLD_POS	1U 
#define	TRNG_ISR_DAVLD_MSK	BIT(TRNG_ISR_DAVLD_POS)

#define	TRNG_ISR_START_POS	0U 
#define	TRNG_ISR_START_MSK	BIT(TRNG_ISR_START_POS)

typedef struct
{
	__IO uint32_t CR;
	__I uint32_t SR;
	__I uint32_t DR;
	__IO uint32_t SEED;
	__IO uint32_t CFGR;
	__IO uint32_t IER;
	__I uint32_t IFR;
	__O uint32_t IFCR;
	__I uint32_t ISR;
} TRNG_TypeDef;

/****************** Bit definition for TSENSE_WPR register ************************/

#define	TSENSE_WPR_WP_POS	0U 
#define	TSENSE_WPR_WP_MSK	BIT(TSENSE_WPR_WP_POS)

/****************** Bit definition for TSENSE_CR register ************************/

#define	TSENSE_CR_TSU_POSS	12U 
#define	TSENSE_CR_TSU_POSE	14U 
#define	TSENSE_CR_TSU_MSK	BITS(TSENSE_CR_TSU_POSS,TSENSE_CR_TSU_POSE)

#define	TSENSE_CR_TOM_POSS	8U 
#define	TSENSE_CR_TOM_POSE	10U 
#define	TSENSE_CR_TOM_MSK	BITS(TSENSE_CR_TOM_POSS,TSENSE_CR_TOM_POSE)

#define	TSENSE_CR_CTN_POS	4U 
#define	TSENSE_CR_CTN_MSK	BIT(TSENSE_CR_CTN_POS)

#define	TSENSE_CR_RST_POS	3U 
#define	TSENSE_CR_RST_MSK	BIT(TSENSE_CR_RST_POS)

#define	TSENSE_CR_ENS_POS	2U 
#define	TSENSE_CR_ENS_MSK	BIT(TSENSE_CR_ENS_POS)

#define	TSENSE_CR_REQEN_POS	1U 
#define	TSENSE_CR_REQEN_MSK	BIT(TSENSE_CR_REQEN_POS)

#define	TSENSE_CR_EN_POS	0U 
#define	TSENSE_CR_EN_MSK	BIT(TSENSE_CR_EN_POS)

/****************** Bit definition for TSENSE_DR register ************************/

#define	TSENSE_DR_ERR_POS	31U 
#define	TSENSE_DR_ERR_MSK	BIT(TSENSE_DR_ERR_POS)

#define	TSENSE_DR_DATA_POSS	0U 
#define	TSENSE_DR_DATA_POSE	15U 
#define	TSENSE_DR_DATA_MSK	BITS(TSENSE_DR_DATA_POSS,TSENSE_DR_DATA_POSE)

/****************** Bit definition for TSENSE_PSR register ************************/

#define	TSENSE_PSR_PRS_POSS	0U 
#define	TSENSE_PSR_PRS_POSE	7U 
#define	TSENSE_PSR_PRS_MSK	BITS(TSENSE_PSR_PRS_POSS,TSENSE_PSR_PRS_POSE)

/****************** Bit definition for TSENSE_IE register ************************/

#define	TSENSE_IE_TSENSE_POS	0U 
#define	TSENSE_IE_TSENSE_MSK	BIT(TSENSE_IE_TSENSE_POS)

/****************** Bit definition for TSENSE_IF register ************************/

#define	TSENSE_IF_TSENSE_POS	0U 
#define	TSENSE_IF_TSENSE_MSK	BIT(TSENSE_IF_TSENSE_POS)

/****************** Bit definition for TSENSE_IFCR register ************************/

#define	TSENSE_IFCR_TSENSE_POS	0U 
#define	TSENSE_IFCR_TSENSE_MSK	BIT(TSENSE_IFCR_TSENSE_POS)

/****************** Bit definition for TSENSE_LTGR register ************************/

#define	TSENSE_LTGR_LTG_POSS	0U 
#define	TSENSE_LTGR_LTG_POSE	20U 
#define	TSENSE_LTGR_LTG_MSK	BITS(TSENSE_LTGR_LTG_POSS,TSENSE_LTGR_LTG_POSE)

/****************** Bit definition for TSENSE_HTGR register ************************/

#define	TSENSE_HTGR_HTG_POSS	0U 
#define	TSENSE_HTGR_HTG_POSE	20U 
#define	TSENSE_HTGR_HTG_MSK	BITS(TSENSE_HTGR_HTG_POSS,TSENSE_HTGR_HTG_POSE)

/****************** Bit definition for TSENSE_TBDR register ************************/

#define	TSENSE_TBDR_TBD_POSS	0U 
#define	TSENSE_TBDR_TBD_POSE	15U 
#define	TSENSE_TBDR_TBD_MSK	BITS(TSENSE_TBDR_TBD_POSS,TSENSE_TBDR_TBD_POSE)

/****************** Bit definition for TSENSE_TCALBDR register ************************/

#define	TSENSE_TCALBDR_TCAL_POSS	0U 
#define	TSENSE_TCALBDR_TCAL_POSE	16U 
#define	TSENSE_TCALBDR_TCAL_MSK	BITS(TSENSE_TCALBDR_TCAL_POSS,TSENSE_TCALBDR_TCAL_POSE)

/****************** Bit definition for TSENSE_SR register ************************/

#define	TSENSE_SR_TSOUT_POS	31U 
#define	TSENSE_SR_TSOUT_MSK	BIT(TSENSE_SR_TSOUT_POS)

#define	TSENSE_SR_NVLD_POS	25U 
#define	TSENSE_SR_NVLD_MSK	BIT(TSENSE_SR_NVLD_POS)

#define	TSENSE_SR_TCAL_POSS	0U 
#define	TSENSE_SR_TCAL_POSE	24U 
#define	TSENSE_SR_TCAL_MSK	BITS(TSENSE_SR_TCAL_POSS,TSENSE_SR_TCAL_POSE)

typedef struct
{
	__IO uint32_t WPR;
	__IO uint32_t CR;
	__I uint32_t DR;
	__IO uint32_t PSR;
	__IO uint32_t IE;
	__I uint32_t IF;
	__IO uint32_t IFCR;
	__IO uint32_t LTGR;
	__IO uint32_t HTGR;
	__IO uint32_t TBDR;
	__IO uint32_t TCALBDR;
	__I uint32_t SR;
} TSENSE_TypeDef;

/****************** Bit definition for IWDT_LOAD register ************************/

#define	IWDT_LOAD_LOAD_POSS	0U 
#define	IWDT_LOAD_LOAD_POSE	31U 
#define	IWDT_LOAD_LOAD_MSK	BITS(IWDT_LOAD_LOAD_POSS,IWDT_LOAD_LOAD_POSE)

/****************** Bit definition for IWDT_VALUE register ************************/

#define	IWDT_VALUE_VALUE_POSS	0U 
#define	IWDT_VALUE_VALUE_POSE	31U 
#define	IWDT_VALUE_VALUE_MSK	BITS(IWDT_VALUE_VALUE_POSS,IWDT_VALUE_VALUE_POSE)

/****************** Bit definition for IWDT_CON register ************************/

#define	IWDT_CON_CLKS_POS	3U 
#define	IWDT_CON_CLKS_MSK	BIT(IWDT_CON_CLKS_POS)

#define	IWDT_CON_RSTEN_POS	2U 
#define	IWDT_CON_RSTEN_MSK	BIT(IWDT_CON_RSTEN_POS)

#define	IWDT_CON_IE_POS	1U 
#define	IWDT_CON_IE_MSK	BIT(IWDT_CON_IE_POS)

#define	IWDT_CON_EN_POS	0U 
#define	IWDT_CON_EN_MSK	BIT(IWDT_CON_EN_POS)

/****************** Bit definition for IWDT_INTCLR register ************************/

#define	IWDT_INTCLR_INTCLR_POSS	0U 
#define	IWDT_INTCLR_INTCLR_POSE	31U 
#define	IWDT_INTCLR_INTCLR_MSK	BITS(IWDT_INTCLR_INTCLR_POSS,IWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for IWDT_RIS register ************************/

#define	IWDT_RIS_WDTIF_POS	0U 
#define	IWDT_RIS_WDTIF_MSK	BIT(IWDT_RIS_WDTIF_POS)

/****************** Bit definition for IWDT_LOCK register ************************/

#define	IWDT_LOCK_LOCK_POS	0U 
#define	IWDT_LOCK_LOCK_MSK	BIT(IWDT_LOCK_LOCK_POS)

typedef struct
{
	__O uint32_t LOAD;
	__I uint32_t VALUE;
	__IO uint32_t CON;
	__O uint32_t INTCLR;
	__I uint32_t RIS;
	uint32_t RESERVED0[59] ;
	__IO uint32_t LOCK;
} IWDT_TypeDef;

/****************** Bit definition for WWDT_LOAD register ************************/

#define	WWDT_LOAD_LOAD_POSS	0U 
#define	WWDT_LOAD_LOAD_POSE	31U 
#define	WWDT_LOAD_LOAD_MSK	BITS(WWDT_LOAD_LOAD_POSS,WWDT_LOAD_LOAD_POSE)

/****************** Bit definition for WWDT_VALUE register ************************/

#define	WWDT_VALUE_VALUE_POSS	0U 
#define	WWDT_VALUE_VALUE_POSE	31U 
#define	WWDT_VALUE_VALUE_MSK	BITS(WWDT_VALUE_VALUE_POSS,WWDT_VALUE_VALUE_POSE)

/****************** Bit definition for WWDT_CON register ************************/

#define	WWDT_CON_WWDTWIN_POSS	4U 
#define	WWDT_CON_WWDTWIN_POSE	5U 
#define	WWDT_CON_WWDTWIN_MSK	BITS(WWDT_CON_WWDTWIN_POSS,WWDT_CON_WWDTWIN_POSE)

#define	WWDT_CON_CLKS_POS	3U 
#define	WWDT_CON_CLKS_MSK	BIT(WWDT_CON_CLKS_POS)

#define	WWDT_CON_RSTEN_POS	2U 
#define	WWDT_CON_RSTEN_MSK	BIT(WWDT_CON_RSTEN_POS)

#define	WWDT_CON_IE_POS	1U 
#define	WWDT_CON_IE_MSK	BIT(WWDT_CON_IE_POS)

#define	WWDT_CON_EN_POS	0U 
#define	WWDT_CON_EN_MSK	BIT(WWDT_CON_EN_POS)

/****************** Bit definition for WWDT_INTCLR register ************************/

#define	WWDT_INTCLR_INTCLR_POSS	0U 
#define	WWDT_INTCLR_INTCLR_POSE	31U 
#define	WWDT_INTCLR_INTCLR_MSK	BITS(WWDT_INTCLR_INTCLR_POSS,WWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for WWDT_RIS register ************************/

#define	WWDT_RIS_WWDTIF_POS	0U 
#define	WWDT_RIS_WWDTIF_MSK	BIT(WWDT_RIS_WWDTIF_POS)

/****************** Bit definition for WWDT_LOCK register ************************/

#define	WWDT_LOCK_LOCK_POS	0U 
#define	WWDT_LOCK_LOCK_MSK	BIT(WWDT_LOCK_LOCK_POS)

typedef struct
{
	__O uint32_t LOAD;
	__I uint32_t VALUE;
	__IO uint32_t CON;
	__O uint32_t INTCLR;
	__I uint32_t RIS;
	uint32_t RESERVED0[59];
	__IO uint32_t LOCK;
} WWDT_TypeDef;

/****************** Bit definition for QSPI_CR register ************************/

#define	QSPI_CR_IDLES_POS	31U 
#define	QSPI_CR_IDLES_MSK	BIT(QSPI_CR_IDLES_POS)
#define QSPI_CR_IDLES		QSPI_CR_IDLES_MSK


#define	QSPI_CR_DTRM_POS	24U 
#define	QSPI_CR_DTRM_MSK	BIT(QSPI_CR_DTRM_POS)

#define	QSPI_CR_ADEN_POS	23U 
#define	QSPI_CR_ADEN_MSK	BIT(QSPI_CR_ADEN_POS)

#define	QSPI_CR_BAUD_POSS	19U 
#define	QSPI_CR_BAUD_POSE	22U 
#define	QSPI_CR_BAUD_MSK	BITS(QSPI_CR_BAUD_POSS,QSPI_CR_BAUD_POSE)

#define	QSPI_CR_XIPIM_POS	18U 
#define	QSPI_CR_XIPIM_MSK	BIT(QSPI_CR_XIPIM_POS)

#define	QSPI_CR_XIPNX_POS	17U 
#define	QSPI_CR_XIPNX_MSK	BIT(QSPI_CR_XIPNX_POS)

#define	QSPI_CR_AREN_POS	16U 
#define	QSPI_CR_AREN_MSK	BIT(QSPI_CR_AREN_POS)

#define	QSPI_CR_DMAEN_POS	15U 
#define	QSPI_CR_DMAEN_MSK	BIT(QSPI_CR_DMAEN_POS)

#define	QSPI_CR_SWPP_POS	14U 
#define	QSPI_CR_SWPP_MSK	BIT(QSPI_CR_SWPP_POS)

#define	QSPI_CR_PSL_POSS	10U 
#define	QSPI_CR_PSL_POSE	13U 
#define	QSPI_CR_PSL_MSK	BITS(QSPI_CR_PSL_POSS,QSPI_CR_PSL_POSE)

#define	QSPI_CR_PSD_POS	9U 
#define	QSPI_CR_PSD_MSK	BIT(QSPI_CR_PSD_POS)

#define	QSPI_CR_LIMEN_POS	8U 
#define	QSPI_CR_LIMEN_MSK	BIT(QSPI_CR_LIMEN_POS)

#define	QSPI_CR_DACEN_POS	7U 
#define	QSPI_CR_DACEN_MSK	BIT(QSPI_CR_DACEN_POS)

#define	QSPI_CR_CPHA_POS	2U 
#define	QSPI_CR_CPHA_MSK	BIT(QSPI_CR_CPHA_POS)
#define QSPI_CR_CPHA		QSPI_CR_CPHA_MSK

#define	QSPI_CR_CPOL_POS	1U 
#define	QSPI_CR_CPOL_MSK	BIT(QSPI_CR_CPOL_POS)
#define QSPI_CR_CPOL		QSPI_CR_CPOL_MSK

#define	QSPI_CR_EN_POS	0U 
#define	QSPI_CR_EN_MSK	BIT(QSPI_CR_EN_POS)

/****************** Bit definition for QSPI_DRIR register ************************/

#define	QSPI_DRIR_DCYC_POSS	24U 
#define	QSPI_DRIR_DCYC_POSE	28U 
#define	QSPI_DRIR_DCYC_MSK	BITS(QSPI_DRIR_DCYC_POSS,QSPI_DRIR_DCYC_POSE)

#define	QSPI_DRIR_MBEN_POS	20U 
#define	QSPI_DRIR_MBEN_MSK	BIT(QSPI_DRIR_MBEN_POS)

#define	QSPI_DRIR_DMODE_POSS	16U 
#define	QSPI_DRIR_DMODE_POSE	17U 
#define	QSPI_DRIR_DMODE_MSK	BITS(QSPI_DRIR_DMODE_POSS,QSPI_DRIR_DMODE_POSE)

#define	QSPI_DRIR_ADMODE_POSS	12U 
#define	QSPI_DRIR_ADMODE_POSE	13U 
#define	QSPI_DRIR_ADMODE_MSK	BITS(QSPI_DRIR_ADMODE_POSS,QSPI_DRIR_ADMODE_POSE)

#define	QSPI_DRIR_DDRM_POS	10U 
#define	QSPI_DRIR_DDRM_MSK	BIT(QSPI_DRIR_DDRM_POS)

#define	QSPI_DRIR_IMODE_POSS	8U 
#define	QSPI_DRIR_IMODE_POSE	9U 
#define	QSPI_DRIR_IMODE_MSK	BITS(QSPI_DRIR_IMODE_POSS,QSPI_DRIR_IMODE_POSE)

#define	QSPI_DRIR_RINST_POSS	0U 
#define	QSPI_DRIR_RINST_POSE	7U 
#define	QSPI_DRIR_RINST_MSK	BITS(QSPI_DRIR_RINST_POSS,QSPI_DRIR_RINST_POSE)

/****************** Bit definition for QSPI_DWIR register ************************/

#define	QSPI_DWIR_DCYC_POSS	24U 
#define	QSPI_DWIR_DCYC_POSE	28U 
#define	QSPI_DWIR_DCYC_MSK	BITS(QSPI_DWIR_DCYC_POSS,QSPI_DWIR_DCYC_POSE)

#define	QSPI_DWIR_DMODE_POSS	16U 
#define	QSPI_DWIR_DMODE_POSE	17U 
#define	QSPI_DWIR_DMODE_MSK	BITS(QSPI_DWIR_DMODE_POSS,QSPI_DWIR_DMODE_POSE)

#define	QSPI_DWIR_ADMODE_POSS	12U 
#define	QSPI_DWIR_ADMODE_POSE	13U 
#define	QSPI_DWIR_ADMODE_MSK	BITS(QSPI_DWIR_ADMODE_POSS,QSPI_DWIR_ADMODE_POSE)

#define	QSPI_DWIR_WELD_POS	8U 
#define	QSPI_DWIR_WELD_MSK	BIT(QSPI_DWIR_WELD_POS)

#define	QSPI_DWIR_WINST_POSS	0U 
#define	QSPI_DWIR_WINST_POSE	7U 
#define	QSPI_DWIR_WINST_MSK	BITS(QSPI_DWIR_WINST_POSS,QSPI_DWIR_WINST_POSE)

/****************** Bit definition for QSPI_DDLR register ************************/

#define	QSPI_DDLR_CSDA_POSS	24U 
#define	QSPI_DDLR_CSDA_POSE	31U 
#define	QSPI_DDLR_CSDA_MSK	BITS(QSPI_DDLR_CSDA_POSS,QSPI_DDLR_CSDA_POSE)

#define	QSPI_DDLR_CSDADS_POSS	16U 
#define	QSPI_DDLR_CSDADS_POSE	23U 
#define	QSPI_DDLR_CSDADS_MSK	BITS(QSPI_DDLR_CSDADS_POSS,QSPI_DDLR_CSDADS_POSE)

#define	QSPI_DDLR_CSEOT_POSS	8U 
#define	QSPI_DDLR_CSEOT_POSE	15U 
#define	QSPI_DDLR_CSEOT_MSK	BITS(QSPI_DDLR_CSEOT_POSS,QSPI_DDLR_CSEOT_POSE)

#define	QSPI_DDLR_CSSOT_POSS	0U 
#define	QSPI_DDLR_CSSOT_POSE	7U 
#define	QSPI_DDLR_CSSOT_MSK	BITS(QSPI_DDLR_CSSOT_POSS,QSPI_DDLR_CSSOT_POSE)

/****************** Bit definition for QSPI_RDCR register ************************/

#define	QSPI_RDCR_DLYT_POSS	16U 
#define	QSPI_RDCR_DLYT_POSE	19U 
#define	QSPI_RDCR_DLYT_MSK	BITS(QSPI_RDCR_DLYT_POSS,QSPI_RDCR_DLYT_POSE)

#define	QSPI_RDCR_SMES_POS	5U 
#define	QSPI_RDCR_SMES_MSK	BIT(QSPI_RDCR_SMES_POS)

#define	QSPI_RDCR_DLYR_POSS	1U 
#define	QSPI_RDCR_DLYR_POSE	4U 
#define	QSPI_RDCR_DLYR_MSK	BITS(QSPI_RDCR_DLYR_POSS,QSPI_RDCR_DLYR_POSE)

#define	QSPI_RDCR_BYLPC_POS	0U 
#define	QSPI_RDCR_BYLPC_MSK	BIT(QSPI_RDCR_BYLPC_POS)

/****************** Bit definition for QSPI_DSCR register ************************/

#define	QSPI_DSCR_CS3SIZE_POSS	27U 
#define	QSPI_DSCR_CS3SIZE_POSE	28U 
#define	QSPI_DSCR_CS3SIZE_MSK	BITS(QSPI_DSCR_CS3SIZE_POSS,QSPI_DSCR_CS3SIZE_POSE)

#define	QSPI_DSCR_CS2SIZE_POSS	25U 
#define	QSPI_DSCR_CS2SIZE_POSE	26U 
#define	QSPI_DSCR_CS2SIZE_MSK	BITS(QSPI_DSCR_CS2SIZE_POSS,QSPI_DSCR_CS2SIZE_POSE)

#define	QSPI_DSCR_CS1SIZE_POSS	23U 
#define	QSPI_DSCR_CS1SIZE_POSE	24U 
#define	QSPI_DSCR_CS1SIZE_MSK	BITS(QSPI_DSCR_CS1SIZE_POSS,QSPI_DSCR_CS1SIZE_POSE)

#define	QSPI_DSCR_CS0SIZE_POSS	21U 
#define	QSPI_DSCR_CS0SIZE_POSE	22U 
#define	QSPI_DSCR_CS0SIZE_MSK	BITS(QSPI_DSCR_CS0SIZE_POSS,QSPI_DSCR_CS0SIZE_POSE)

#define	QSPI_DSCR_BKSIZE_POSS	16U 
#define	QSPI_DSCR_BKSIZE_POSE	20U 
#define	QSPI_DSCR_BKSIZE_MSK	BITS(QSPI_DSCR_BKSIZE_POSS,QSPI_DSCR_BKSIZE_POSE)

#define	QSPI_DSCR_PASIZE_POSS	4U 
#define	QSPI_DSCR_PASIZE_POSE	15U 
#define	QSPI_DSCR_PASIZE_MSK	BITS(QSPI_DSCR_PASIZE_POSS,QSPI_DSCR_PASIZE_POSE)

#define	QSPI_DSCR_ADSIZE_POSS	0U 
#define	QSPI_DSCR_ADSIZE_POSE	3U 
#define	QSPI_DSCR_ADSIZE_MSK	BITS(QSPI_DSCR_ADSIZE_POSS,QSPI_DSCR_ADSIZE_POSE)

/****************** Bit definition for QSPI_SPR register ************************/

#define	QSPI_SPR_SRAMPS_POSS	0U 
#define	QSPI_SPR_SRAMPS_POSE	7U 
#define	QSPI_SPR_SRAMPS_MSK	BITS(QSPI_SPR_SRAMPS_POSS,QSPI_SPR_SRAMPS_POSE)

/****************** Bit definition for QSPI_IATR register ************************/

#define	QSPI_IATR_INDTAD_POSS	0U 
#define	QSPI_IATR_INDTAD_POSE	31U 
#define	QSPI_IATR_INDTAD_MSK	BITS(QSPI_IATR_INDTAD_POSS,QSPI_IATR_INDTAD_POSE)

/****************** Bit definition for QSPI_DMACR register ************************/

#define	QSPI_DMACR_BNUMB_POSS	8U 
#define	QSPI_DMACR_BNUMB_POSE	11U 
#define	QSPI_DMACR_BNUMB_MSK	BITS(QSPI_DMACR_BNUMB_POSS,QSPI_DMACR_BNUMB_POSE)

#define	QSPI_DMACR_SNUMB_POSS	0U 
#define	QSPI_DMACR_SNUMB_POSE	3U 
#define	QSPI_DMACR_SNUMB_MSK	BITS(QSPI_DMACR_SNUMB_POSS,QSPI_DMACR_SNUMB_POSE)

/****************** Bit definition for QSPI_RAR register ************************/

#define	QSPI_RAR_READDR_POSS	0U 
#define	QSPI_RAR_READDR_POSE	31U 
#define	QSPI_RAR_READDR_MSK	BITS(QSPI_RAR_READDR_POSS,QSPI_RAR_READDR_POSE)

/****************** Bit definition for QSPI_MBR register ************************/

#define	QSPI_MBR_MODEB_POSS	0U 
#define	QSPI_MBR_MODEB_POSE	7U 
#define	QSPI_MBR_MODEB_MSK	BITS(QSPI_MBR_MODEB_POSS,QSPI_MBR_MODEB_POSE)

/****************** Bit definition for QSPI_SFLR register ************************/

#define	QSPI_SFLR_INDWSFL_POSS	16U 
#define	QSPI_SFLR_INDWSFL_POSE	21U 
#define	QSPI_SFLR_INDWSFL_MSK	BITS(QSPI_SFLR_INDWSFL_POSS,QSPI_SFLR_INDWSFL_POSE)

#define	QSPI_SFLR_INDRSFL_POSS	0U 
#define	QSPI_SFLR_INDRSFL_POSE	5U 
#define	QSPI_SFLR_INDRSFL_MSK	BITS(QSPI_SFLR_INDRSFL_POSS,QSPI_SFLR_INDRSFL_POSE)

/****************** Bit definition for QSPI_TXHR register ************************/

#define	QSPI_TXHR_TXTH_POSS	0U 
#define	QSPI_TXHR_TXTH_POSE	4U 
#define	QSPI_TXHR_TXTH_MSK	BITS(QSPI_TXHR_TXTH_POSS,QSPI_TXHR_TXTH_POSE)

/****************** Bit definition for QSPI_RXHR register ************************/

#define	QSPI_RXHR_RXTH_POSS	0U 
#define	QSPI_RXHR_RXTH_POSE	4U 
#define	QSPI_RXHR_RXTH_MSK	BITS(QSPI_RXHR_RXTH_POSS,QSPI_RXHR_RXTH_POSE)

/****************** Bit definition for QSPI_WCR register ************************/

#define	QSPI_WCR_PREPD_POSS	24U 
#define	QSPI_WCR_PREPD_POSE	31U 
#define	QSPI_WCR_PREPD_MSK	BITS(QSPI_WCR_PREPD_POSS,QSPI_WCR_PREPD_POSE)

#define	QSPI_WCR_PCNT_POSS	16U 
#define	QSPI_WCR_PCNT_POSE	23U 
#define	QSPI_WCR_PCNT_MSK	BITS(QSPI_WCR_PCNT_POSS,QSPI_WCR_PCNT_POSE)

#define	QSPI_WCR_PDIS_POS	14U 
#define	QSPI_WCR_PDIS_MSK	BIT(QSPI_WCR_PDIS_POS)

#define	QSPI_WCR_PPLT_POS	13U 
#define	QSPI_WCR_PPLT_MSK	BIT(QSPI_WCR_PPLT_POS)

#define	QSPI_WCR_PBIND_POSS	8U 
#define	QSPI_WCR_PBIND_POSE	10U 
#define	QSPI_WCR_PBIND_MSK	BITS(QSPI_WCR_PBIND_POSS,QSPI_WCR_PBIND_POSE)

#define	QSPI_WCR_OPCODE_POSS	0U 
#define	QSPI_WCR_OPCODE_POSE	7U 
#define	QSPI_WCR_OPCODE_MSK	BITS(QSPI_WCR_OPCODE_POSS,QSPI_WCR_OPCODE_POSE)

/****************** Bit definition for QSPI_PER register ************************/

#define	QSPI_PER_PCYCN_POSS	0U 
#define	QSPI_PER_PCYCN_POSE	31U 
#define	QSPI_PER_PCYCN_MSK	BITS(QSPI_PER_PCYCN_POSS,QSPI_PER_PCYCN_POSE)

/****************** Bit definition for QSPI_IFR register ************************/

#define	QSPI_IFR_POLLF_POS	13U 
#define	QSPI_IFR_POLLF_MSK	BIT(QSPI_IFR_POLLF_POS)
#define QSPI_IFR_POLLF		QSPI_IFR_POLLF_MSK

#define	QSPI_IFR_INDRSFF_POS	12U 
#define	QSPI_IFR_INDRSFF_MSK	BIT(QSPI_IFR_INDRSFF_POS)
#define QSPI_IFR_INDRSFF	QSPI_IFR_INDRSFF_MSK

#define	QSPI_IFR_SRFFF_POS	11U 
#define	QSPI_IFR_SRFFF_MSK	BIT(QSPI_IFR_SRFFF_POS)
#define QSPI_IFR_SRFFF		QSPI_IFR_SRFFF_MSK

#define	QSPI_IFR_SRFNEF_POS	10U 
#define	QSPI_IFR_SRFNEF_MSK	BIT(QSPI_IFR_SRFNEF_POS)
#define QSPI_IFR_SRFNEF		QSPI_IFR_SRFNEF_MSK

#define	QSPI_IFR_STFFF_POS	9U 
#define	QSPI_IFR_STFFF_MSK	BIT(QSPI_IFR_STFFF_POS)
#define QSPI_IFR_STFFF		QSPI_IFR_STFFF_MSK

#define	QSPI_IFR_STFNFF_POS	8U 
#define	QSPI_IFR_STFNFF_MSK	BIT(QSPI_IFR_STFNFF_POS)
#define QSPI_IFR_STFNFF		QSPI_IFR_STFNFF_MSK

#define	QSPI_IFR_ROVF_POS	7U 
#define	QSPI_IFR_ROVF_MSK	BIT(QSPI_IFR_ROVF_POS)
#define QSPI_IFR_ROVF		QSPI_IFR_ROVF_MSK

#define	QSPI_IFR_INDTWF_POS	6U 
#define	QSPI_IFR_INDTWF_MSK	BIT(QSPI_IFR_INDTWF_POS)
#define QSIP_IFR_INDTWF		QSPI_IFR_INDTWF_MSK

#define	QSPI_IFR_AHBAEF_POS	5U 
#define	QSPI_IFR_AHBAEF_MSK	BIT(QSPI_IFR_AHBAEF_POS)
#define QSPI_IFR_AHBAEF		QSPI_IFR_AHBAEF_MSK

#define	QSPI_IFR_WPAF_POS	4U 
#define	QSPI_IFR_WPAF_MSK	BIT(QSPI_IFR_WPAF_POS)
#define QSPI_IFR_WPAF		QSPI_IFR_WPAF_MSK

#define	QSPI_IFR_INDRRF_POS	3U 
#define	QSPI_IFR_INDRRF_MSK	BIT(QSPI_IFR_INDRRF_POS)
#define QSIP_IFR_INDRRF		QSPI_IFR_INDRRF_MSK

#define	QSPI_IFR_INDCF_POS	2U 
#define	QSPI_IFR_INDCF_MSK	BIT(QSPI_IFR_INDCF_POS)
#define QSPI_IFR_INDCF		QSPI_IFR_INDCF_MSK

#define	QSPI_IFR_UDFF_POS	1U 
#define	QSPI_IFR_UDFF_MSK	BIT(QSPI_IFR_UDFF_POS)
#define QSPI_IFR_UDFF		QSPI_IFR_UDFF_MSK

#define	QSPI_IFR_MODFF_POS	0U 
#define	QSPI_IFR_MODFF_MSK	BIT(QSPI_IFR_MODFF_POS)
#define QSPI_IFR_MODFF		QSPI_IFR_MODFF_MSK

/****************** Bit definition for QSPI_IMR register ************************/

#define	QSPI_IMR_INTEN_POSS	0U 
#define	QSPI_IMR_INTEN_POSE	13U 
#define	QSPI_IMR_INTEN_MSK	BITS(QSPI_IMR_INTEN_POSS,QSPI_IMR_INTEN_POSE)

/****************** Bit definition for QSPI_WPLR register ************************/

#define	QSPI_WPLR_LBLKNUM_POSS	0U 
#define	QSPI_WPLR_LBLKNUM_POSE	31U 
#define	QSPI_WPLR_LBLKNUM_MSK	BITS(QSPI_WPLR_LBLKNUM_POSS,QSPI_WPLR_LBLKNUM_POSE)

/****************** Bit definition for QSPI_WPHR register ************************/

#define	QSPI_WPHR_HBLKNUM_POSS	0U 
#define	QSPI_WPHR_HBLKNUM_POSE	31U 
#define	QSPI_WPHR_HBLKNUM_MSK	BITS(QSPI_WPHR_HBLKNUM_POSS,QSPI_WPHR_HBLKNUM_POSE)

/****************** Bit definition for QSPI_WPCR register ************************/

#define	QSPI_WPCR_WPEN_POS	1U 
#define	QSPI_WPCR_WPEN_MSK	BIT(QSPI_WPCR_WPEN_POS)

#define	QSPI_WPCR_WPINV_POS	0U 
#define	QSPI_WPCR_WPINV_MSK	BIT(QSPI_WPCR_WPINV_POS)

/****************** Bit definition for QSPI_IRTR register ************************/

#define	QSPI_IRTR_INDRNUM_POSS	6U 
#define	QSPI_IRTR_INDRNUM_POSE	7U 
#define	QSPI_IRTR_INDRNUM_MSK	BITS(QSPI_IRTR_INDRNUM_POSS,QSPI_IRTR_INDRNUM_POSE)

#define	QSPI_IRTR_RDCS_POS	5U 
#define	QSPI_IRTR_RDCS_MSK	BIT(QSPI_IRTR_RDCS_POS)

#define	QSPI_IRTR_RDQS_POS	4U 
#define	QSPI_IRTR_RDQS_MSK	BIT(QSPI_IRTR_RDQS_POS)

#define	QSPI_IRTR_SRAMFS_POS	3U 
#define	QSPI_IRTR_SRAMFS_MSK	BIT(QSPI_IRTR_SRAMFS_POS)

#define	QSPI_IRTR_RDPS_POS	2U 
#define	QSPI_IRTR_RDPS_MSK	BIT(QSPI_IRTR_RDPS_POS)

#define	QSPI_IRTR_RDDIS_POS	1U 
#define	QSPI_IRTR_RDDIS_MSK	BIT(QSPI_IRTR_RDDIS_POS)

#define	QSPI_IRTR_RDST_POS	0U 
#define	QSPI_IRTR_RDST_MSK	BIT(QSPI_IRTR_RDST_POS)

/****************** Bit definition for QSPI_IRTWR register ************************/

#define	QSPI_IRTWR_VAULE_POSS	0U 
#define	QSPI_IRTWR_VAULE_POSE	31U 
#define	QSPI_IRTWR_VAULE_MSK	BITS(QSPI_IRTWR_VAULE_POSS,QSPI_IRTWR_VAULE_POSE)

/****************** Bit definition for QSPI_IRTSAR register ************************/

#define	QSPI_IRTSAR_ADDR_POSS	0U 
#define	QSPI_IRTSAR_ADDR_POSE	31U 
#define	QSPI_IRTSAR_ADDR_MSK	BITS(QSPI_IRTSAR_ADDR_POSS,QSPI_IRTSAR_ADDR_POSE)

/****************** Bit definition for QSPI_IRTNR register ************************/

#define	QSPI_IRTNR_NUM_POSS	0U 
#define	QSPI_IRTNR_NUM_POSE	31U 
#define	QSPI_IRTNR_NUM_MSK	BITS(QSPI_IRTNR_NUM_POSS,QSPI_IRTNR_NUM_POSE)

/****************** Bit definition for QSPI_IWTR register ************************/

#define	QSPI_IWTR_INDWNUM_POSS	6U 
#define	QSPI_IWTR_INDWNUM_POSE	7U 
#define	QSPI_IWTR_INDWNUM_MSK	BITS(QSPI_IWTR_INDWNUM_POSS,QSPI_IWTR_INDWNUM_POSE)

#define	QSPI_IWTR_WRCS_POS	5U 
#define	QSPI_IWTR_WRCS_MSK	BIT(QSPI_IWTR_WRCS_POS)

#define	QSPI_IWTR_WRQS_POS	4U 
#define	QSPI_IWTR_WRQS_MSK	BIT(QSPI_IWTR_WRQS_POS)

#define	QSPI_IWTR_WRPS_POS	2U 
#define	QSPI_IWTR_WRPS_MSK	BIT(QSPI_IWTR_WRPS_POS)

#define	QSPI_IWTR_WRDIS_POS	1U 
#define	QSPI_IWTR_WRDIS_MSK	BIT(QSPI_IWTR_WRDIS_POS)

#define	QSPI_IWTR_WRST_POS	0U 
#define	QSPI_IWTR_WRST_MSK	BIT(QSPI_IWTR_WRST_POS)

/****************** Bit definition for QSPI_IWTWR register ************************/

#define	QSPI_IWTWR_VAULE_POSS	0U 
#define	QSPI_IWTWR_VAULE_POSE	31U 
#define	QSPI_IWTWR_VAULE_MSK	BITS(QSPI_IWTWR_VAULE_POSS,QSPI_IWTWR_VAULE_POSE)

/****************** Bit definition for QSPI_IWTSAR register ************************/

#define	QSPI_IWTSAR_ADDR_POSS	0U 
#define	QSPI_IWTSAR_ADDR_POSE	31U 
#define	QSPI_IWTSAR_ADDR_MSK	BITS(QSPI_IWTSAR_ADDR_POSS,QSPI_IWTSAR_ADDR_POSE)

/****************** Bit definition for QSPI_IWTNR register ************************/

#define	QSPI_IWTNR_NUM_POSS	0U 
#define	QSPI_IWTNR_NUM_POSE	31U 
#define	QSPI_IWTNR_NUM_MSK	BITS(QSPI_IWTNR_NUM_POSS,QSPI_IWTNR_NUM_POSE)

/****************** Bit definition for QSPI_ITARR register ************************/

#define	QSPI_ITARR_RNGW_POSS	0U 
#define	QSPI_ITARR_RNGW_POSE	3U 
#define	QSPI_ITARR_RNGW_MSK	BITS(QSPI_ITARR_RNGW_POSS,QSPI_ITARR_RNGW_POSE)

/****************** Bit definition for QSPI_FCR register ************************/

#define	QSPI_FCR_OPCODE_POSS	24U 
#define	QSPI_FCR_OPCODE_POSE	31U 
#define	QSPI_FCR_OPCODE_MSK	BITS(QSPI_FCR_OPCODE_POSS,QSPI_FCR_OPCODE_POSE)

#define	QSPI_FCR_RDEN_POS	23U 
#define	QSPI_FCR_RDEN_MSK	BIT(QSPI_FCR_RDEN_POS)

#define	QSPI_FCR_RDNUM_POSS	20U 
#define	QSPI_FCR_RDNUM_POSE	22U 
#define	QSPI_FCR_RDNUM_MSK	BITS(QSPI_FCR_RDNUM_POSS,QSPI_FCR_RDNUM_POSE)

#define	QSPI_FCR_ADDREN_POS	19U 
#define	QSPI_FCR_ADDREN_MSK	BIT(QSPI_FCR_ADDREN_POS)

#define	QSPI_FCR_MODBEN_POS	18U 
#define	QSPI_FCR_MODBEN_MSK	BIT(QSPI_FCR_MODBEN_POS)

#define	QSPI_FCR_ADNUM_POSS	16U 
#define	QSPI_FCR_ADNUM_POSE	17U 
#define	QSPI_FCR_ADNUM_MSK	BITS(QSPI_FCR_ADNUM_POSS,QSPI_FCR_ADNUM_POSE)

#define	QSPI_FCR_WREN_POS	15U 
#define	QSPI_FCR_WREN_MSK	BIT(QSPI_FCR_WREN_POS)

#define	QSPI_FCR_WDNUM_POSS	12U 
#define	QSPI_FCR_WDNUM_POSE	14U 
#define	QSPI_FCR_WDNUM_MSK	BITS(QSPI_FCR_WDNUM_POSS,QSPI_FCR_WDNUM_POSE)

#define	QSPI_FCR_DUMNUM_POSS	7U 
#define	QSPI_FCR_DUMNUM_POSE	11U 
#define	QSPI_FCR_DUMNUM_MSK	BITS(QSPI_FCR_DUMNUM_POSS,QSPI_FCR_DUMNUM_POSE)

#define	QSPI_FCR_CMDS_POS	1U 
#define	QSPI_FCR_CMDS_MSK	BIT(QSPI_FCR_CMDS_POS)

#define	QSPI_FCR_CMDT_POS	0U 
#define	QSPI_FCR_CMDT_MSK	BIT(QSPI_FCR_CMDT_POS)

/****************** Bit definition for QSPI_FCAR register ************************/

#define	QSPI_FCAR_CMDADR_POSS	0U 
#define	QSPI_FCAR_CMDADR_POSE	31U 
#define	QSPI_FCAR_CMDADR_MSK	BITS(QSPI_FCAR_CMDADR_POSS,QSPI_FCAR_CMDADR_POSE)

/****************** Bit definition for QSPI_FCRLR register ************************/

#define	QSPI_FCRLR_CMDDL_POSS	0U 
#define	QSPI_FCRLR_CMDDL_POSE	31U 
#define	QSPI_FCRLR_CMDDL_MSK	BITS(QSPI_FCRLR_CMDDL_POSS,QSPI_FCRLR_CMDDL_POSE)

/****************** Bit definition for QSPI_FCRHR register ************************/

#define	QSPI_FCRHR_CMDDH_POSS	0U 
#define	QSPI_FCRHR_CMDDH_POSE	31U 
#define	QSPI_FCRHR_CMDDH_MSK	BITS(QSPI_FCRHR_CMDDH_POSS,QSPI_FCRHR_CMDDH_POSE)

/****************** Bit definition for QSPI_FCWLR register ************************/

#define	QSPI_FCWLR_CMDDL_POSS	0U 
#define	QSPI_FCWLR_CMDDL_POSE	31U 
#define	QSPI_FCWLR_CMDDL_MSK	BITS(QSPI_FCWLR_CMDDL_POSS,QSPI_FCWLR_CMDDL_POSE)

/****************** Bit definition for QSPI_FCWHR register ************************/

#define	QSPI_FCWHR_CMDDH_POSS	0U 
#define	QSPI_FCWHR_CMDDH_POSE	31U 
#define	QSPI_FCWHR_CMDDH_MSK	BITS(QSPI_FCWHR_CMDDH_POSS,QSPI_FCWHR_CMDDH_POSE)

/****************** Bit definition for QSPI_PFSR register ************************/

#define	QSPI_PFSR_PSV_POS	8U 
#define	QSPI_PFSR_PSV_MSK	BIT(QSPI_PFSR_PSV_POS)

#define	QSPI_PFSR_FLSS_POSS	0U 
#define	QSPI_PFSR_FLSS_POSE	7U 
#define	QSPI_PFSR_FLSS_MSK	BITS(QSPI_PFSR_FLSS_POSS,QSPI_PFSR_FLSS_POSE)

/****************** Bit definition for QSPI_MIDR register ************************/

#define	QSPI_MIDR_ID1_POSS	24U 
#define	QSPI_MIDR_ID1_POSE	31U 
#define	QSPI_MIDR_ID1_MSK	BITS(QSPI_MIDR_ID1_POSS,QSPI_MIDR_ID1_POSE)

#define	QSPI_MIDR_ID0_POSS	0U 
#define	QSPI_MIDR_ID0_POSE	23U 
#define	QSPI_MIDR_ID0_MSK	BITS(QSPI_MIDR_ID0_POSS,QSPI_MIDR_ID0_POSE)

typedef struct
{
	__IO uint32_t CR;
	__IO uint32_t DRIR;
	__IO uint32_t DWIR;
	__IO uint32_t DDLR;
	__IO uint32_t RDCR;
	__IO uint32_t DSCR;
	__IO uint32_t SPR;
	__IO uint32_t IATR;
	__IO uint32_t DMACR;
	__IO uint32_t RAR;
	__IO uint32_t MBR;
	__I uint32_t SFLR;
	__IO uint32_t TXHR;
	__IO uint32_t RXHR;
	__IO uint32_t WCR;
	__IO uint32_t PER;
	__IO uint32_t IFR;
	__IO uint32_t IMR;
	uint32_t RESERVED0[2] ;
	__IO uint32_t WPLR;
	__IO uint32_t WPHR;
	__IO uint32_t WPCR;
	uint32_t RESERVED1 ;
	__O uint32_t IRTR;
	__IO uint32_t IRTWR;
	__IO uint32_t IRTSAR;
	__IO uint32_t IRTNR;
	__O uint32_t IWTR;
	__IO uint32_t IWTWR;
	__IO uint32_t IWTSAR;
	__IO uint32_t IWTNR;
	__IO uint32_t ITARR;
	uint32_t RESERVED2[3] ;
	__O uint32_t FCR;
	__IO uint32_t FCAR;
	uint32_t RESERVED3[2] ;
	__I uint32_t FCRLR;
	__I uint32_t FCRHR;
	__IO uint32_t FCWLR;
	__IO uint32_t FCWHR;
	__I uint32_t PFSR;
	uint32_t RESERVED4[18] ;
	__I uint32_t MIDR;
} QSPI_TypeDef;

/****************** Bit definition for EBI_BCTRLRx(x= 1..3) register ************************/

#define	EBI_BCTRLRx_RWCBURSTEN_POS	19U 
#define	EBI_BCTRLRx_RWCBURSTEN_MSK	BIT(EBI_BCTRLRx_RWCBURSTEN_POS)

#define	EBI_BCTRLRx_CPAGESIZE_POSS	16U 
#define	EBI_BCTRLRx_CPAGESIZE_POSE	18U 
#define	EBI_BCTRLRx_CPAGESIZE_MSK	BITS(EBI_BCTRLRx_CPAGESIZE_POSS,EBI_BCTRLRx_CPAGESIZE_POSE)

#define	EBI_BCTRLRx_ASYNCWAIT_POS	15U 
#define	EBI_BCTRLRx_ASYNCWAIT_MSK	BIT(EBI_BCTRLRx_ASYNCWAIT_POS)

#define	EBI_BCTRLRx_EXTMODEN_POS	14U 
#define	EBI_BCTRLRx_EXTMODEN_MSK	BIT(EBI_BCTRLRx_EXTMODEN_POS)

#define	EBI_BCTRLRx_WAITEN_POS	13U 
#define	EBI_BCTRLRx_WAITEN_MSK	BIT(EBI_BCTRLRx_WAITEN_POS)

#define	EBI_BCTRLRx_WREN_POS	12U 
#define	EBI_BCTRLRx_WREN_MSK	BIT(EBI_BCTRLRx_WREN_POS)
                  
#define	EBI_BCTRLRx_WAITCFG_POS	11U 
#define	EBI_BCTRLRx_WAITCFG_MSK	BIT(EBI_BCTRLRx_WAITCFG_POS)
                  
#define	EBI_BCTRLRx_WRAPMODE_POS	10U 
#define	EBI_BCTRLRx_WRAPMODE_MSK	BIT(EBI_BCTRLRx_WRAPMODE_POS)
                  
#define	EBI_BCTRLRx_WAITPOL_POS	9U 
#define	EBI_BCTRLRx_WAITPOL_MSK	BIT(EBI_BCTRLRx_WAITPOL_POS)
                  
#define	EBI_BCTRLRx_BURSTEN_POS	8U 
#define	EBI_BCTRLRx_BURSTEN_MSK	BIT(EBI_BCTRLRx_BURSTEN_POS)
                  
#define	EBI_BCTRLRx_FLASHACCEN_POS	6U 
#define	EBI_BCTRLRx_FLASHACCEN_MSK	BIT(EBI_BCTRLRx_FLASHACCEN_POS)
                  
#define	EBI_BCTRLRx_MEMWID_POSS	4U 
#define	EBI_BCTRLRx_MEMWID_POSE	5U 
#define	EBI_BCTRLRx_MEMWID_MSK	BITS(EBI_BCTRLRx_MEMWID_POSS,EBI_BCTRLRx_MEMWID_POSE)
#define EBI_BCTRLRx_MEMWID_0                    (0x1U << EBI_BCTRLRx_MEMWID_POSS)
#define EBI_BCTRLRx_MEMWID_1                    (0x2U << EBI_BCTRLRx_MEMWID_POSS)
                 
#define	EBI_BCTRLRx_MEMTYP_POSS	2U 
#define	EBI_BCTRLRx_MEMTYP_POSE	3U 
#define	EBI_BCTRLRx_MEMTYP_MSK	BITS(EBI_BCTRLRx_MEMTYP_POSS,EBI_BCTRLRx_MEMTYP_POSE)
#define EBI_BCTRLRx_MEMTYP_0                    (0x1U << EBI_BCTRLRx_MEMTYP_POSS)
#define EBI_BCTRLRx_MEMTYP_1                    (0x2U << EBI_BCTRLRx_MEMTYP_POSS)
                 
#define	EBI_BCTRLRx_MUXEN_POS	1U 
#define	EBI_BCTRLRx_MUXEN_MSK	BIT(EBI_BCTRLRx_MUXEN_POS)
                  
#define	EBI_BCTRLRx_MEMBKEN_POS	0U 
#define	EBI_BCTRLRx_MEMBKEN_MSK	BIT(EBI_BCTRLRx_MEMBKEN_POS)

/****************** Bit definition for EBI_BTRx(x= 1..3) register ************************/

#define	EBI_BTRx_ACCMODE_POSS	28U 
#define	EBI_BTRx_ACCMODE_POSE	29U 
#define	EBI_BTRx_ACCMODE_MSK	BITS(EBI_BTRx_ACCMODE_POSS,EBI_BTRx_ACCMODE_POSE)
#define EBI_BTRx_ACCMODE_0                  (0x1U << EBI_BTRx_ACCMODE_POSS)
#define EBI_BTRx_ACCMODE_1                  (0x2U << EBI_BTRx_ACCMODE_POSS)

#define	EBI_BTRx_DATALAT_POSS	24U 
#define	EBI_BTRx_DATALAT_POSE	27U 
#define	EBI_BTRx_DATALAT_MSK	BITS(EBI_BTRx_DATALAT_POSS,EBI_BTRx_DATALAT_POSE)
               
#define	EBI_BTRx_CLKDIV_POSS	20U 
#define	EBI_BTRx_CLKDIV_POSE	23U 
#define	EBI_BTRx_CLKDIV_MSK	BITS(EBI_BTRx_CLKDIV_POSS,EBI_BTRx_CLKDIV_POSE)
               
#define	EBI_BTRx_BUSTURN_POSS	16U 
#define	EBI_BTRx_BUSTURN_POSE	19U 
#define	EBI_BTRx_BUSTURN_MSK	BITS(EBI_BTRx_BUSTURN_POSS,EBI_BTRx_BUSTURN_POSE)
               
#define	EBI_BTRx_DATAHOLD_POSS	8U 
#define	EBI_BTRx_DATAHOLD_POSE	15U 
#define	EBI_BTRx_DATAHOLD_MSK	BITS(EBI_BTRx_DATAHOLD_POSS,EBI_BTRx_DATAHOLD_POSE)
               
#define	EBI_BTRx_ADDHOLD_POSS	4U 
#define	EBI_BTRx_ADDHOLD_POSE	7U 
#define	EBI_BTRx_ADDHOLD_MSK	BITS(EBI_BTRx_ADDHOLD_POSS,EBI_BTRx_ADDHOLD_POSE)
               
#define	EBI_BTRx_ADDATASETUP_POSS	0U 
#define	EBI_BTRx_ADDATASETUP_POSE	3U 
#define	EBI_BTRx_ADDATASETUP_MSK	BITS(EBI_BTRx_ADDATASETUP_POSS,EBI_BTRx_ADDATASETUP_POSE)

/****************** Bit definition for EBI_BWRTRx(x= 1..3) register ************************/

#define	EBI_BWRTRx_ACCMODE_POSS	28U 
#define	EBI_BWRTRx_ACCMODE_POSE	29U 
#define	EBI_BWRTRx_ACCMODE_MSK	BITS(EBI_BWRTRx_ACCMODE_POSS,EBI_BWRTRx_ACCMODE_POSE)
                 
#define	EBI_BWRTRx_BUSTURN_POSS	16U 
#define	EBI_BWRTRx_BUSTURN_POSE	19U 
#define	EBI_BWRTRx_BUSTURN_MSK	BITS(EBI_BWRTRx_BUSTURN_POSS,EBI_BWRTRx_BUSTURN_POSE)
                 
#define	EBI_BWRTRx_DATAHOLD_POSS	8U 
#define	EBI_BWRTRx_DATAHOLD_POSE	15U 
#define	EBI_BWRTRx_DATAHOLD_MSK	BITS(EBI_BWRTRx_DATAHOLD_POSS,EBI_BWRTRx_DATAHOLD_POSE)
                 
#define	EBI_BWRTRx_ADDHOLD_POSS	4U 
#define	EBI_BWRTRx_ADDHOLD_POSE	7U 
#define	EBI_BWRTRx_ADDHOLD_MSK	BITS(EBI_BWRTRx_ADDHOLD_POSS,EBI_BWRTRx_ADDHOLD_POSE)
                 
#define	EBI_BWRTRx_ADDATASETUP_POSS	0U 
#define	EBI_BWRTRx_ADDATASETUP_POSE	3U 
#define	EBI_BWRTRx_ADDATASETUP_MSK	BITS(EBI_BWRTRx_ADDATASETUP_POSS,EBI_BWRTRx_ADDATASETUP_POSE)

/****************** Bit definition for EBI_LCDCTRLx(x= 1..3) register ************************/

#define	EBI_LCDCTRLx_HSYNCPOL_POS	29U 
#define	EBI_LCDCTRLx_HSYNCPOL_MSK	BIT(EBI_LCDCTRLx_HSYNCPOL_POS)
                   
#define	EBI_LCDCTRLx_VSYNCPOL_POS	28U 
#define	EBI_LCDCTRLx_VSYNCPOL_MSK	BIT(EBI_LCDCTRLx_VSYNCPOL_POS)
                   
#define	EBI_LCDCTRLx_DENPOL_POS	27U 
#define	EBI_LCDCTRLx_DENPOL_MSK	BIT(EBI_LCDCTRLx_DENPOL_POS)
                   
#define	EBI_LCDCTRLx_LCDEN_POS	26U 
#define	EBI_LCDCTRLx_LCDEN_MSK	BIT(EBI_LCDCTRLx_LCDEN_POS)
                  
#define	EBI_LCDCTRLx_LCDINT_POS	25U 
#define	EBI_LCDCTRLx_LCDINT_MSK	BIT(EBI_LCDCTRLx_LCDINT_POS)
                   
#define	EBI_LCDCTRLx_DCLKPOL_POS	24U 
#define	EBI_LCDCTRLx_DCLKPOL_MSK	BIT(EBI_LCDCTRLx_DCLKPOL_POS)
                   
#define	EBI_LCDCTRLx_DATASETUP_POSS	16U 
#define	EBI_LCDCTRLx_DATASETUP_POSE	23U 
#define	EBI_LCDCTRLx_DATASETUP_MSK	BITS(EBI_LCDCTRLx_DATASETUP_POSS,EBI_LCDCTRLx_DATASETUP_POSE)
                   
#define	EBI_LCDCTRLx_VSYNCWID_POSS	8U 
#define	EBI_LCDCTRLx_VSYNCWID_POSE	15U 
#define	EBI_LCDCTRLx_VSYNCWID_MSK	BITS(EBI_LCDCTRLx_VSYNCWID_POSS,EBI_LCDCTRLx_VSYNCWID_POSE)
                   
#define	EBI_LCDCTRLx_HSYNCWID_POSS	0U 
#define	EBI_LCDCTRLx_HSYNCWID_POSE	7U 
#define	EBI_LCDCTRLx_HSYNCWID_MSK	BITS(EBI_LCDCTRLx_HSYNCWID_POSS,EBI_LCDCTRLx_HSYNCWID_POSE)

/****************** Bit definition for EBI_LCDCFGx(x= 1..4) register ************************/

#define	EBI_LCDCFGx_LINENUM_POSS	16U 
#define	EBI_LCDCFGx_LINENUM_POSE	31U 
#define	EBI_LCDCFGx_LINENUM_MSK	BITS(EBI_LCDCFGx_LINENUM_POSS,EBI_LCDCFGx_LINENUM_POSE)
                  
#define	EBI_LCDCFGx_PXLNUM_POSS	0U 
#define	EBI_LCDCFGx_PXLNUM_POSE	15U 
#define	EBI_LCDCFGx_PXLNUM_MSK	BITS(EBI_LCDCFGx_PXLNUM_POSS,EBI_LCDCFGx_PXLNUM_POSE)

/****************** Bit definition for EBI_LCDSTx(x= 1..3) register ************************/

#define	EBI_LCDSTx_LINECNT_POSS	16U 
#define	EBI_LCDSTx_LINECNT_POSE	31U 
#define	EBI_LCDSTx_LINECNT_MSK	BITS(EBI_LCDSTx_LINECNT_POSS,EBI_LCDSTx_LINECNT_POSE)
                 
#define	EBI_LCDSTx_PXLCNT_POSS	0U 
#define	EBI_LCDSTx_PXLCNT_POSE	15U 
#define	EBI_LCDSTx_PXLCNT_MSK	BITS(EBI_LCDSTx_PXLCNT_POSS,EBI_LCDSTx_PXLCNT_POSE)

/****************** Bit definition for EBI_PCTRLRx(x = 2..3) register ************************/

#define	EBI_PCTRLRx_ECCPSIZE_POSS	17U 
#define	EBI_PCTRLRx_ECCPSIZE_POSE	19U 
#define	EBI_PCTRLRx_ECCPSIZE_MSK	BITS(EBI_PCTRLRx_ECCPSIZE_POSS,EBI_PCTRLRx_ECCPSIZE_POSE)
#define EBI_PCTRLRx_ECCPS_0             (0x1U << EBI_PCTRLRx_ECCPSIZE_POSS)
#define EBI_PCTRLRx_ECCPS_1             (0x2U << EBI_PCTRLRx_ECCPSIZE_POSS)
#define EBI_PCTRLRx_ECCPS_2             (0x4U << EBI_PCTRLRx_ECCPSIZE_POSS)
                  
#define	EBI_PCTRLRx_ARDLY_POSS	13U 
#define	EBI_PCTRLRx_ARDLY_POSE	16U 
#define	EBI_PCTRLRx_ARDLY_MSK	BITS(EBI_PCTRLRx_ARDLY_POSS,EBI_PCTRLRx_ARDLY_POSE)
                  
#define	EBI_PCTRLRx_CRDLY_POSS	9U 
#define	EBI_PCTRLRx_CRDLY_POSE	12U 
#define	EBI_PCTRLRx_CRDLY_MSK	BITS(EBI_PCTRLRx_CRDLY_POSS,EBI_PCTRLRx_CRDLY_POSE)
                  
#define	EBI_PCTRLRx_TFUNSEL_POS	8U 
#define	EBI_PCTRLRx_TFUNSEL_MSK	BIT(EBI_PCTRLRx_TFUNSEL_POS)
                  
#define	EBI_PCTRLRx_ECCEN_POS	6U 
#define	EBI_PCTRLRx_ECCEN_MSK	BIT(EBI_PCTRLRx_ECCEN_POS)
                  
#define	EBI_PCTRLRx_DATBUSWID_POSS	4U 
#define	EBI_PCTRLRx_DATBUSWID_POSE	5U 
#define	EBI_PCTRLRx_DATBUSWID_MSK	BITS(EBI_PCTRLRx_DATBUSWID_POSS,EBI_PCTRLRx_DATBUSWID_POSE)
                  
#define	EBI_PCTRLRx_MEMTYP_POS	3U 
#define	EBI_PCTRLRx_MEMTYP_MSK	BIT(EBI_PCTRLRx_MEMTYP_POS)
                  
#define	EBI_PCTRLRx_MEMBKEN_POS	2U 
#define	EBI_PCTRLRx_MEMBKEN_MSK	BIT(EBI_PCTRLRx_MEMBKEN_POS)
                 
#define	EBI_PCTRLRx_WAITEN_POS	1U 
#define	EBI_PCTRLRx_WAITEN_MSK	BIT(EBI_PCTRLRx_WAITEN_POS)

/****************** Bit definition for EBI_STARx(x = 2..3) register ************************/

#define	EBI_STARx_FIFOEMPT_POS	6U 
#define	EBI_STARx_FIFOEMPT_MSK	BIT(EBI_STARx_FIFOEMPT_POS)
                
#define	EBI_STARx_IFALLEN_POS	5U 
#define	EBI_STARx_IFALLEN_MSK	BIT(EBI_STARx_IFALLEN_POS)
                
#define	EBI_STARx_IHILEN_POS	4U 
#define	EBI_STARx_IHILEN_MSK	BIT(EBI_STARx_IHILEN_POS)
                
#define	EBI_STARx_IRISEEN_POS	3U 
#define	EBI_STARx_IRISEEN_MSK	BIT(EBI_STARx_IRISEEN_POS)
                
#define	EBI_STARx_IFALLS_POS	2U 
#define	EBI_STARx_IFALLS_MSK	BIT(EBI_STARx_IFALLS_POS)
                
#define	EBI_STARx_IHILS_POS	1U 
#define	EBI_STARx_IHILS_MSK	BIT(EBI_STARx_IHILS_POS)
                
#define	EBI_STARx_IRISES_POS	0U 
#define	EBI_STARx_IRISES_MSK	BIT(EBI_STARx_IRISES_POS)

/****************** Bit definition for EBI_PMEMRx(x = 2..3) register ************************/

#define	EBI_PMEMRx_MEMHIZT_POSS	24U 
#define	EBI_PMEMRx_MEMHIZT_POSE	31U 
#define	EBI_PMEMRx_MEMHIZT_MSK	BITS(EBI_PMEMRx_MEMHIZT_POSS,EBI_PMEMRx_MEMHIZT_POSE)
                 
#define	EBI_PMEMRx_MEMHOLD_POSS	16U 
#define	EBI_PMEMRx_MEMHOLD_POSE	23U 
#define	EBI_PMEMRx_MEMHOLD_MSK	BITS(EBI_PMEMRx_MEMHOLD_POSS,EBI_PMEMRx_MEMHOLD_POSE)
                 
#define	EBI_PMEMRx_MEMWAIT_POSS	8U 
#define	EBI_PMEMRx_MEMWAIT_POSE	15U 
#define	EBI_PMEMRx_MEMWAIT_MSK	BITS(EBI_PMEMRx_MEMWAIT_POSS,EBI_PMEMRx_MEMWAIT_POSE)
                 
#define	EBI_PMEMRx_MEMSETUP_POSS	0U 
#define	EBI_PMEMRx_MEMSETUP_POSE	7U 
#define	EBI_PMEMRx_MEMSETUP_MSK	BITS(EBI_PMEMRx_MEMSETUP_POSS,EBI_PMEMRx_MEMSETUP_POSE)

/****************** Bit definition for EBI_PATTRx(x = 2..3) register ************************/

#define	EBI_PATTRx_ATTHIZT_POSS	24U 
#define	EBI_PATTRx_ATTHIZT_POSE	31U 
#define	EBI_PATTRx_ATTHIZT_MSK	BITS(EBI_PATTRx_ATTHIZT_POSS,EBI_PATTRx_ATTHIZT_POSE)
                 
#define	EBI_PATTRx_ATTHOLD_POSS	16U 
#define	EBI_PATTRx_ATTHOLD_POSE	23U 
#define	EBI_PATTRx_ATTHOLD_MSK	BITS(EBI_PATTRx_ATTHOLD_POSS,EBI_PATTRx_ATTHOLD_POSE)
                 
#define	EBI_PATTRx_ATTWAIT_POSS	8U 
#define	EBI_PATTRx_ATTWAIT_POSE	15U 
#define	EBI_PATTRx_ATTWAIT_MSK	BITS(EBI_PATTRx_ATTWAIT_POSS,EBI_PATTRx_ATTWAIT_POSE)
                 
#define	EBI_PATTRx_ATTSETUP_POSS	0U 
#define	EBI_PATTRx_ATTSETUP_POSE	7U 
#define	EBI_PATTRx_ATTSETUP_MSK	BITS(EBI_PATTRx_ATTSETUP_POSS,EBI_PATTRx_ATTSETUP_POSE)

/****************** Bit definition for EBI_ECCRESULTx(x = 2..3) register ************************/

#define	EBI_ECCRESULTx_ECCRESULT_POSS	0U 
#define	EBI_ECCRESULTx_ECCRESULT_POSE	31U 
#define	EBI_ECCRESULTx_ECCRESULT_MSK	BITS(EBI_ECCRESULTx_ECCRESULT_POSS,EBI_ECCRESULTx_ECCRESULT_POSE)
  
typedef struct
{
	__IO uint32_t BTCR[8];   
} EBI_Bank1_TypeDef; 
  
typedef struct
{
	__IO uint32_t BWTR[7];
} EBI_Bank1E_TypeDef;
  
typedef struct
{
	__IO uint32_t PCTRLR2;
	__IO uint32_t STAR2;
	__IO uint32_t PMEMR2;
	__IO uint32_t PATTR2;
	uint32_t      RESERVED0;
	__IO uint32_t ECCRESULT2;
	uint32_t      RESERVED1;
	uint32_t      RESERVED2;
	__IO uint32_t PCTRLR3;
	__IO uint32_t STAR3;
	__IO uint32_t PMEMR3;
	__IO uint32_t PATTR3;
	uint32_t      RESERVED3;
	__IO uint32_t ECCRESULT3;
} EBI_Bank2_3_TypeDef;  

typedef struct
{
	__IO uint32_t LCDCRCFGS[15];

} EBI_Bank1_LCD_TypeDef;


/****************** Bit definition for USB_FADDR register ************************/

#define	USB_FADDR_FADDR_POSS	0U 
#define	USB_FADDR_FADDR_POSE	6U 
#define	USB_FADDR_FADDR_MSK	BITS(USB_FADDR_FADDR_POSS,USB_FADDR_FADDR_POSE)

/****************** Bit definition for USB_POWER register ************************/

#define	USB_POWER_ISOUPDATA_POS	7U 
#define	USB_POWER_ISOUPDATA_MSK	BIT(USB_POWER_ISOUPDATA_POS)

#define	USB_POWER_SOFTCONN_POS	6U 
#define	USB_POWER_SOFTCONN_MSK	BIT(USB_POWER_SOFTCONN_POS)

#define	USB_POWER_HS_EN_POS	5U 
#define	USB_POWER_HS_EN_MSK	BIT(USB_POWER_HS_EN_POS)

#define	USB_POWER_HS_M_POS	4U 
#define	USB_POWER_HS_M_MSK	BIT(USB_POWER_HS_M_POS)

#define	USB_POWER_RESET_POS	3U 
#define	USB_POWER_RESET_MSK	BIT(USB_POWER_RESET_POS)

#define	USB_POWER_RESUME_POS	2U 
#define	USB_POWER_RESUME_MSK	BIT(USB_POWER_RESUME_POS)

#define	USB_POWER_SUSPEND_POS	1U 
#define	USB_POWER_SUSPEND_MSK	BIT(USB_POWER_SUSPEND_POS)

#define	USB_POWER_EN_SPDM_POS	0U 
#define	USB_POWER_EN_SPDM_MSK	BIT(USB_POWER_EN_SPDM_POS)

/****************** Bit definition for USB_TXIS register ************************/

#define	USB_TXIS_EP7TX_IF_POS	7U 
#define	USB_TXIS_EP7TX_IF_MSK	BIT(USB_TXIS_EP7TX_IF_POS)

#define	USB_TXIS_EP6TX_IF_POS	6U 
#define	USB_TXIS_EP6TX_IF_MSK	BIT(USB_TXIS_EP6TX_IF_POS)

#define	USB_TXIS_EP5TX_IF_POS	5U 
#define	USB_TXIS_EP5TX_IF_MSK	BIT(USB_TXIS_EP5TX_IF_POS)

#define	USB_TXIS_EP4TX_IF_POS	4U 
#define	USB_TXIS_EP4TX_IF_MSK	BIT(USB_TXIS_EP4TX_IF_POS)

#define	USB_TXIS_EP3TX_IF_POS	3U 
#define	USB_TXIS_EP3TX_IF_MSK	BIT(USB_TXIS_EP3TX_IF_POS)

#define	USB_TXIS_EP2TX_IF_POS	2U 
#define	USB_TXIS_EP2TX_IF_MSK	BIT(USB_TXIS_EP2TX_IF_POS)

#define	USB_TXIS_EP1TX_IF_POS	1U 
#define	USB_TXIS_EP1TX_IF_MSK	BIT(USB_TXIS_EP1TX_IF_POS)

#define	USB_TXIS_EP0_IF_POS	0U 
#define	USB_TXIS_EP0_IF_MSK	BIT(USB_TXIS_EP0_IF_POS)

/****************** Bit definition for USB_RXIS register ************************/

#define	USB_RXIS_EP7RX_IF_POS	7U 
#define	USB_RXIS_EP7RX_IF_MSK	BIT(USB_RXIS_EP7RX_IF_POS)

#define	USB_RXIS_EP6RX_IF_POS	6U 
#define	USB_RXIS_EP6RX_IF_MSK	BIT(USB_RXIS_EP6RX_IF_POS)

#define	USB_RXIS_EP5RX_IF_POS	5U 
#define	USB_RXIS_EP5RX_IF_MSK	BIT(USB_RXIS_EP5RX_IF_POS)

#define	USB_RXIS_EP4RX_IF_POS	4U 
#define	USB_RXIS_EP4RX_IF_MSK	BIT(USB_RXIS_EP4RX_IF_POS)

#define	USB_RXIS_EP3RX_IF_POS	3U 
#define	USB_RXIS_EP3RX_IF_MSK	BIT(USB_RXIS_EP3RX_IF_POS)

#define	USB_RXIS_EP2RX_IF_POS	2U 
#define	USB_RXIS_EP2RX_IF_MSK	BIT(USB_RXIS_EP2RX_IF_POS)

#define	USB_RXIS_EP1RX_IF_POS	1U 
#define	USB_RXIS_EP1RX_IF_MSK	BIT(USB_RXIS_EP1RX_IF_POS)

/****************** Bit definition for USB_TXIE register ************************/

#define	USB_TXIE_EP7TX_IE_POS	7U 
#define	USB_TXIE_EP7TX_IE_MSK	BIT(USB_TXIE_EP7TX_IE_POS)

#define	USB_TXIE_EP6TX_IE_POS	6U 
#define	USB_TXIE_EP6TX_IE_MSK	BIT(USB_TXIE_EP6TX_IE_POS)

#define	USB_TXIE_EP5TX_IE_POS	5U 
#define	USB_TXIE_EP5TX_IE_MSK	BIT(USB_TXIE_EP5TX_IE_POS)

#define	USB_TXIE_EP4TX_IE_POS	4U 
#define	USB_TXIE_EP4TX_IE_MSK	BIT(USB_TXIE_EP4TX_IE_POS)

#define	USB_TXIE_EP3TX_IE_POS	3U 
#define	USB_TXIE_EP3TX_IE_MSK	BIT(USB_TXIE_EP3TX_IE_POS)

#define	USB_TXIE_EP2TX_IE_POS	2U 
#define	USB_TXIE_EP2TX_IE_MSK	BIT(USB_TXIE_EP2TX_IE_POS)

#define	USB_TXIE_EP1TX_IE_POS	1U 
#define	USB_TXIE_EP1TX_IE_MSK	BIT(USB_TXIE_EP1TX_IE_POS)

#define	USB_TXIE_EP0_IE_POS	0U 
#define	USB_TXIE_EP0_IE_MSK	BIT(USB_TXIE_EP0_IE_POS)

/****************** Bit definition for USB_RXIE register ************************/

#define	USB_RXIE_EP7RX_IE_POS	7U 
#define	USB_RXIE_EP7RX_IE_MSK	BIT(USB_RXIE_EP7RX_IE_POS)

#define	USB_RXIE_EP6RX_IE_POS	6U 
#define	USB_RXIE_EP6RX_IE_MSK	BIT(USB_RXIE_EP6RX_IE_POS)

#define	USB_RXIE_EP5RX_IE_POS	5U 
#define	USB_RXIE_EP5RX_IE_MSK	BIT(USB_RXIE_EP5RX_IE_POS)

#define	USB_RXIE_EP4RX_IE_POS	4U 
#define	USB_RXIE_EP4RX_IE_MSK	BIT(USB_RXIE_EP4RX_IE_POS)

#define	USB_RXIE_EP3RX_IE_POS	3U 
#define	USB_RXIE_EP3RX_IE_MSK	BIT(USB_RXIE_EP3RX_IE_POS)

#define	USB_RXIE_EP2RX_IE_POS	2U 
#define	USB_RXIE_EP2RX_IE_MSK	BIT(USB_RXIE_EP2RX_IE_POS)

#define	USB_RXIE_EP1RX_IE_POS	1U 
#define	USB_RXIE_EP1RX_IE_MSK	BIT(USB_RXIE_EP1RX_IE_POS)

/****************** Bit definition for USB_USBIS register ************************/

#define	USB_USBIS_DISCON_IF_POS	5U 
#define	USB_USBIS_DISCON_IF_MSK	BIT(USB_USBIS_DISCON_IF_POS)

#define	USB_USBIS_SOF_IF_POS	3U 
#define	USB_USBIS_SOF_IF_MSK	BIT(USB_USBIS_SOF_IF_POS)

#define	USB_USBIS_RESET_IF_POS	2U 
#define	USB_USBIS_RESET_IF_MSK	BIT(USB_USBIS_RESET_IF_POS)

#define	USB_USBIS_RESUME_IF_POS	1U 
#define	USB_USBIS_RESUME_IF_MSK	BIT(USB_USBIS_RESUME_IF_POS)

#define	USB_USBIS_SUSPEND_IF_POS	0U 
#define	USB_USBIS_SUSPEND_IF_MSK	BIT(USB_USBIS_SUSPEND_IF_POS)

/****************** Bit definition for USB_USBIE register ************************/

#define	USB_USBIE_DISCON_IE_POS	5U 
#define	USB_USBIE_DISCON_IE_MSK	BIT(USB_USBIE_DISCON_IE_POS)

#define	USB_USBIE_SOF_IE_POS	3U 
#define	USB_USBIE_SOF_IE_MSK	BIT(USB_USBIE_SOF_IE_POS)

#define	USB_USBIE_RESET_IE_POS	2U 
#define	USB_USBIE_RESET_IE_MSK	BIT(USB_USBIE_RESET_IE_POS)

#define	USB_USBIE_RESUME_IE_POS	1U 
#define	USB_USBIE_RESUME_IE_MSK	BIT(USB_USBIE_RESUME_IE_POS)

#define	USB_USBIE_SUSPEND_IE_POS	0U 
#define	USB_USBIE_SUSPEND_IE_MSK	BIT(USB_USBIE_SUSPEND_IE_POS)

/****************** Bit definition for USB_FRAME register ************************/

#define	USB_FRAME_FRAME_POSS	0U 
#define	USB_FRAME_FRAME_POSE	10U 
#define	USB_FRAME_FRAME_MSK	BITS(USB_FRAME_FRAME_POSS,USB_FRAME_FRAME_POSE)

/****************** Bit definition for USB_INDEX register ************************/

#define	USB_INDEX_EP_INDEX_POSS	0U 
#define	USB_INDEX_EP_INDEX_POSE	3U 
#define	USB_INDEX_EP_INDEX_MSK	BITS(USB_INDEX_EP_INDEX_POSS,USB_INDEX_EP_INDEX_POSE)

/****************** Bit definition for USB_TEST register ************************/

#define	USB_TEST_FORCE_HST_POS	7U 
#define	USB_TEST_FORCE_HST_MSK	BIT(USB_TEST_FORCE_HST_POS)

#define	USB_TEST_FIFO_ACS_POS	6U 
#define	USB_TEST_FIFO_ACS_MSK	BIT(USB_TEST_FIFO_ACS_POS)

#define	USB_TEST_FORCE_FS_POS	5U 
#define	USB_TEST_FORCE_FS_MSK	BIT(USB_TEST_FORCE_FS_POS)

#define	USB_TEST_FORCE_HS_POS	4U 
#define	USB_TEST_FORCE_HS_MSK	BIT(USB_TEST_FORCE_HS_POS)

#define	USB_TEST_TEST_PKT_POS	3U 
#define	USB_TEST_TEST_PKT_MSK	BIT(USB_TEST_TEST_PKT_POS)

#define	USB_TEST_TEST_K_POS	2U 
#define	USB_TEST_TEST_K_MSK	BIT(USB_TEST_TEST_K_POS)

#define	USB_TEST_TEST_J_POS	1U 
#define	USB_TEST_TEST_J_MSK	BIT(USB_TEST_TEST_J_POS)

#define	USB_TEST_TEST_SENA_POS	0U 
#define	USB_TEST_TEST_SENA_MSK	BIT(USB_TEST_TEST_SENA_POS)

typedef union {
	uint8_t Byte[4];
	uint16_t HalfWord[2];
	uint32_t Word;
} USB_FIFO_Typedef;

/****************** Bit definition for USB_DEVCTL register ************************/

#define	USB_DEVCTL_BDEVICE_POS	7U 
#define	USB_DEVCTL_BDEVICE_MSK	BIT(USB_DEVCTL_BDEVICE_POS)

#define	USB_DEVCTL_FSDEV_POS	6U 
#define	USB_DEVCTL_FSDEV_MSK	BIT(USB_DEVCTL_FSDEV_POS)

#define	USB_DEVCTL_LSDEV_POS	5U 
#define	USB_DEVCTL_LSDEV_MSK	BIT(USB_DEVCTL_LSDEV_POS)

#define	USB_DEVCTL_VBUS_POSS	3U 
#define	USB_DEVCTL_VBUS_POSE	4U 
#define	USB_DEVCTL_VBUS_MSK	BITS(USB_DEVCTL_VBUS_POSS,USB_DEVCTL_VBUS_POSE)

#define	USB_DEVCTL_HOSTMODE_POS	2U 
#define	USB_DEVCTL_HOSTMODE_MSK	BIT(USB_DEVCTL_HOSTMODE_POS)

#define	USB_DEVCTL_HOSTREQ_POS	1U 
#define	USB_DEVCTL_HOSTREQ_MSK	BIT(USB_DEVCTL_HOSTREQ_POS)

#define	USB_DEVCTL_SESSION_POS	0U 
#define	USB_DEVCTL_SESSION_MSK	BIT(USB_DEVCTL_SESSION_POS)

/****************** Bit definition for USB_TXFIFOSIZE register ************************/

#define	USB_TXFIFOSIZE_DPB_POS	4U 
#define	USB_TXFIFOSIZE_DPB_MSK	BIT(USB_TXFIFOSIZE_DPB_POS)

#define	USB_TXFIFOSIZE_TXFIFOSIZE_POSS	0U 
#define	USB_TXFIFOSIZE_TXFIFOSIZE_POSE	3U 
#define	USB_TXFIFOSIZE_TXFIFOSIZE_MSK	BITS(USB_TXFIFOSIZE_TXFIFOSIZE_POSS,USB_TXFIFOSIZE_TXFIFOSIZE_POSE)

/****************** Bit definition for USB_RXFIFOSIZE register ************************/

#define	USB_RXFIFOSIZE_DPB_POS	4U 
#define	USB_RXFIFOSIZE_DPB_MSK	BIT(USB_RXFIFOSIZE_DPB_POS)

#define	USB_RXFIFOSIZE_RXFIFOSIZE_POSS	0U 
#define	USB_RXFIFOSIZE_RXFIFOSIZE_POSE	3U 
#define	USB_RXFIFOSIZE_RXFIFOSIZE_MSK	BITS(USB_RXFIFOSIZE_RXFIFOSIZE_POSS,USB_RXFIFOSIZE_RXFIFOSIZE_POSE)

/****************** Bit definition for USB_TXFIFOADD register ************************/

#define	USB_TXFIFOADD_ADDR_POSS	0U 
#define	USB_TXFIFOADD_ADDR_POSE	8U 
#define	USB_TXFIFOADD_ADDR_MSK	BITS(USB_TXFIFOADD_ADDR_POSS,USB_TXFIFOADD_ADDR_POSE)

/****************** Bit definition for USB_RXFIFOADD register ************************/

#define	USB_RXFIFOADD_ADDR_POSS	0U 
#define	USB_RXFIFOADD_ADDR_POSE	8U 
#define	USB_RXFIFOADD_ADDR_MSK	BITS(USB_RXFIFOADD_ADDR_POSS,USB_RXFIFOADD_ADDR_POSE)

/****************** Bit definition for USB_LINKINFO register ************************/

#define	USB_LINKINFO_WTCON_POSS	4U 
#define	USB_LINKINFO_WTCON_POSE	7U 
#define	USB_LINKINFO_WTCON_MSK	BITS(USB_LINKINFO_WTCON_POSS,USB_LINKINFO_WTCON_POSE)

#define	USB_LINKINFO_WTID_POSS	0U 
#define	USB_LINKINFO_WTID_POSE	3U 
#define	USB_LINKINFO_WTID_MSK	BITS(USB_LINKINFO_WTID_POSS,USB_LINKINFO_WTID_POSE)

/****************** Bit definition for USB_VPLEN register ************************/

#define	USB_VPLEN_VPLEN_POSS	0U 
#define	USB_VPLEN_VPLEN_POSE	7U 
#define	USB_VPLEN_VPLEN_MSK	BITS(USB_VPLEN_VPLEN_POSS,USB_VPLEN_VPLEN_POSE)

/****************** Bit definition for USB_HS_EOF1 register ************************/

#define	USB_HS_EOF1_HSEOF1_POSS	0U 
#define	USB_HS_EOF1_HSEOF1_POSE	7U 
#define	USB_HS_EOF1_HSEOF1_MSK	BITS(USB_HS_EOF1_HSEOF1_POSS,USB_HS_EOF1_HSEOF1_POSE)

/****************** Bit definition for USB_FS_EOF1 register ************************/

#define	USB_FS_EOF1_FSEOF1_POSS	0U 
#define	USB_FS_EOF1_FSEOF1_POSE	7U 
#define	USB_FS_EOF1_FSEOF1_MSK	BITS(USB_FS_EOF1_FSEOF1_POSS,USB_FS_EOF1_FSEOF1_POSE)

/****************** Bit definition for USB_LS_EOF1 register ************************/

#define	USB_LS_EOF1_LSEOF1_POSS	0U 
#define	USB_LS_EOF1_LSEOF1_POSE	7U 
#define	USB_LS_EOF1_LSEOF1_MSK	BITS(USB_LS_EOF1_LSEOF1_POSS,USB_LS_EOF1_LSEOF1_POSE)

/****************** Bit definition for TXxFUNCADDR register ************************/

#define	USB_TXxFUNCADDR_ADDR_POSS	0U 
#define	USB_TXxFUNCADDR_ADDR_POSE	6U 
#define	USB_TXxFUNCADDR_ADDR_MSK	BITS(USB_TXxFUNCADDR_ADDR_POSS,USB_TXxFUNCADDR_ADDR_POSE)

/****************** Bit definition for TXxHUBADDR register ************************/

#define	USB_TXxHUBADDR_ADDR_POSS	0U 
#define	USB_TXxHUBADDR_ADDR_POSE	6U 
#define	USB_TXxHUBADDR_ADDR_MSK	BITS(USB_TXxHUBADDR_ADDR_POSS,USB_TXxHUBADDR_ADDR_POSE)

#define	USB_TXxHUBADDR_MULTTRAN_POS	7U
#define	USB_TXxHUBADDR_MULTTRAN_MSK	BIT(USB_TXxHUBADDR_MULTTRAN_POS)

/****************** Bit definition for TXxHUBPORT register ************************/

#define	USB_TXxHUBPORT_HUBPORT_POSS	0U 
#define	USB_TXxHUBPORT_HUBPORT_POSE	6U 
#define	USB_TXxHUBPORT_HUBPORT_MSK	BITS(USB_TXxHUBPORT_HUBPORT_POSS,USB_TXxHUBPORT_HUBPORT_POSE)

/****************** Bit definition for RXxFUNCADDR register ************************/

#define	USB_RXxFUNCADDR_ADDR_POSS	0U 
#define	USB_RXxFUNCADDR_ADDR_POSE	6U 
#define	USB_RXxFUNCADDR_ADDR_MSK	BITS(USB_RXxFUNCADDR_ADDR_POSS,USB_RXxFUNCADDR_ADDR_POSE)

/****************** Bit definition for RXxHUBADDR register ************************/

#define	USB_RXxHUBADDR_ADDR_POSS	0U 
#define	USB_RXxHUBADDR_ADDR_POSE	6U 
#define	USB_RXxHUBADDR_ADDR_MSK	BITS(USB_RXxHUBADDR_ADDR_POSS,USB_RXxHUBADDR_ADDR_POSE)

#define	USB_RXxHUBADDR_MULTTRAN_POS	7U
#define	USB_RXxHUBADDR_MULTTRAN_MSK	BIT(USB_RXxHUBADDR_MULTTRAN_POS)

/****************** Bit definition for RXxHUBPORT register ************************/

#define	USB_RXxHUBPORT_HUBPORT_POSS	0U 
#define	USB_RXxHUBPORT_HUBPORT_POSE	6U 
#define	USB_RXxHUBPORT_HUBPORT_MSK	BITS(USB_RXxHUBPORT_HUBPORT_POSS,USB_RXxHUBPORT_HUBPORT_POSE)

typedef struct {
	__IO uint8_t TXxFUNCADDR;
	uint8_t rsv0;
	__IO uint8_t TXxHUBADDR;
	__IO uint8_t TXxHUBPORT;
	__IO uint8_t RXxFUNCADDR;
	uint8_t rsv1;
	__IO uint8_t RXxHUBADDR;
	__IO uint8_t RXxHUBPORT;
} USB_ADDR_Typedef;

typedef struct{
	__IO uint16_t TXxMAXP;
	__IO uint8_t TXxCSRL;
	__IO uint8_t TXxCSRH;
	__IO uint16_t RXxMAXP;
	__IO uint8_t RXxCSRL;
	__IO uint8_t RXxCSRH;
	__I  uint16_t RXxCOUNT;
	__IO uint8_t TXxTYPE;
	__IO uint8_t TXxINTERVAL;
	__IO uint8_t RXxTYPE;
	__IO uint8_t RXxINTERVAL;
	uint8_t rsv0[2];
} USB_CSRx_Typedef;

/****************** Bit definition for DMA_INTR register ************************/

#define	USB_DMA_INTR_CH0_POS	0U 
#define	USB_DMA_INTR_CH0_MSK	BIT(USB_DMA_INTR_CH0_POS)

#define	USB_DMA_INTR_CH1_POS	1U 
#define	USB_DMA_INTR_CH1_MSK	BIT(USB_DMA_INTR_CH1_POS)

#define	USB_DMA_INTR_CH2_POS	2U 
#define	USB_DMA_INTR_CH2_MSK	BIT(USB_DMA_INTR_CH2_POS)

#define	USB_DMA_INTR_CH3_POS	3U 
#define	USB_DMA_INTR_CH3_MSK	BIT(USB_DMA_INTR_CH3_POS)

/****************** Bit definition for DMA_CNTL register ************************/

#define	USB_DMA_CNTL_EN_POS	0U 
#define	USB_DMA_CNTL_EN_MSK	BIT(USB_DMA_CNTL_EN_POS)

#define	USB_DMA_CNTL_DIR_POS	1U 
#define	USB_DMA_CNTL_DIR_MSK	BIT(USB_DMA_CNTL_DIR_POS)

#define	USB_DMA_CNTL_MODE_POS	2U 
#define	USB_DMA_CNTL_MODE_MSK	BIT(USB_DMA_CNTL_MODE_POS)

#define	USB_DMA_CNTL_IE_POS	3U 
#define	USB_DMA_CNTL_IE_MSK	BIT(USB_DMA_CNTL_IE_POS)

#define	USB_DMA_CNTL_EP_POSS	4U 
#define	USB_DMA_CNTL_EP_POSE	7U 
#define	USB_DMA_CNTL_EP_MSK	BITS(USB_DMA_CNTL_EP_POSS,USB_DMA_CNTL_EP_POSE)

#define	USB_DMA_CNTL_ERR_POS	8U 
#define	USB_DMA_CNTL_ERR_MSK	BIT(USB_DMA_CNTL_ERR_POS)

#define	USB_DMA_CNTL_BRSTM_POSS	9U 
#define	USB_DMA_CNTL_BRSTM_POSE	10U 
#define	USB_DMA_CNTL_BRSTM_MSK	BITS(USB_DMA_CNTL_BRSTM_POSS,USB_DMA_CNTL_BRSTM_POSE)

typedef struct{
	__IO uint32_t DMA_CNTL;
	__IO uint32_t DMA_ADDR;
	__IO uint32_t DMA_COUNT;
	uint32_t rsv;
} USB_DMA_CHx_Typedef;

/****************** Bit definition for USB_RXDPKTBUFDIS register ************************/

#define	USB_RXDPKTBUFDIS_EP7_POS	7U 
#define	USB_RXDPKTBUFDIS_EP7_MSK	BIT(USB_RXDPKTBUFDIS_EP7_POS)

#define	USB_RXDPKTBUFDIS_EP6_POS	6U 
#define	USB_RXDPKTBUFDIS_EP6_MSK	BIT(USB_RXDPKTBUFDIS_EP6_POS)

#define	USB_RXDPKTBUFDIS_EP5_POS	5U 
#define	USB_RXDPKTBUFDIS_EP5_MSK	BIT(USB_RXDPKTBUFDIS_EP5_POS)

#define	USB_RXDPKTBUFDIS_EP4_POS	4U 
#define	USB_RXDPKTBUFDIS_EP4_MSK	BIT(USB_RXDPKTBUFDIS_EP4_POS)

#define	USB_RXDPKTBUFDIS_EP3_POS	3U 
#define	USB_RXDPKTBUFDIS_EP3_MSK	BIT(USB_RXDPKTBUFDIS_EP3_POS)

#define	USB_RXDPKTBUFDIS_EP2_POS	2U 
#define	USB_RXDPKTBUFDIS_EP2_MSK	BIT(USB_RXDPKTBUFDIS_EP2_POS)

#define	USB_RXDPKTBUFDIS_EP1_POS	1U 
#define	USB_RXDPKTBUFDIS_EP1_MSK	BIT(USB_RXDPKTBUFDIS_EP1_POS)

/****************** Bit definition for USB_TXDPKTBUFDIS register ************************/

#define	USB_TXDPKTBUFDIS_EP7_POS	7U 
#define	USB_TXDPKTBUFDIS_EP7_MSK	BIT(USB_TXDPKTBUFDIS_EP7_POS)

#define	USB_TXDPKTBUFDIS_EP6_POS	6U 
#define	USB_TXDPKTBUFDIS_EP6_MSK	BIT(USB_TXDPKTBUFDIS_EP6_POS)

#define	USB_TXDPKTBUFDIS_EP5_POS	5U 
#define	USB_TXDPKTBUFDIS_EP5_MSK	BIT(USB_TXDPKTBUFDIS_EP5_POS)

#define	USB_TXDPKTBUFDIS_EP4_POS	4U 
#define	USB_TXDPKTBUFDIS_EP4_MSK	BIT(USB_TXDPKTBUFDIS_EP4_POS)

#define	USB_TXDPKTBUFDIS_EP3_POS	3U 
#define	USB_TXDPKTBUFDIS_EP3_MSK	BIT(USB_TXDPKTBUFDIS_EP3_POS)

#define	USB_TXDPKTBUFDIS_EP2_POS	2U 
#define	USB_TXDPKTBUFDIS_EP2_MSK	BIT(USB_TXDPKTBUFDIS_EP2_POS)

#define	USB_TXDPKTBUFDIS_EP1_POS	1U 
#define	USB_TXDPKTBUFDIS_EP1_MSK	BIT(USB_TXDPKTBUFDIS_EP1_POS)

/****************** Bit definition for USB_LPM_ATTR register ************************/

#define	USB_LPM_ATTR_ENDPNT_POSS	12U 
#define	USB_LPM_ATTR_ENDPNT_POSE	15U 
#define	USB_LPM_ATTR_ENDPNT_MSK	BITS(USB_LPM_ATTR_ENDPNT_POSS,USB_LPM_ATTR_ENDPNT_POSE)

#define	USB_LPM_ATTR_RMTWAK_POS	8U 
#define	USB_LPM_ATTR_RMTWAK_MSK	BIT(USB_LPM_ATTR_RMTWAK_POS)

#define	USB_LPM_ATTR_HIRD_POSS	4U 
#define	USB_LPM_ATTR_HIRD_POSE	7U 
#define	USB_LPM_ATTR_HIRD_MSK	BITS(USB_LPM_ATTR_HIRD_POSS,USB_LPM_ATTR_HIRD_POSE)

#define	USB_LPM_ATTR_LINKSTATE_POSS	0U 
#define	USB_LPM_ATTR_LINKSTATE_POSE	3U 
#define	USB_LPM_ATTR_LINKSTATE_MSK	BITS(USB_LPM_ATTR_LINKSTATE_POSS,USB_LPM_ATTR_LINKSTATE_POSE)

/****************** Bit definition for USB_LPM_CNTRL register ************************/

#define	USB_LPM_CNTRL_LPMNACK_POS	4U 
#define	USB_LPM_CNTRL_LPMNACK_MSK	BIT(USB_LPM_CNTRL_LPMNACK_POS)

#define	USB_LPM_CNTRL_LPMEN_POSS	2U 
#define	USB_LPM_CNTRL_LPMEN_POSE	3U 
#define	USB_LPM_CNTRL_LPMEN_MSK	BITS(USB_LPM_CNTRL_LPMEN_POSS,USB_LPM_CNTRL_LPMEN_POSE)

#define	USB_LPM_CNTRL_LPMRES_POS	1U 
#define	USB_LPM_CNTRL_LPMRES_MSK	BIT(USB_LPM_CNTRL_LPMRES_POS)

#define	USB_LPM_CNTRL_LPMXMT_POS	0U 
#define	USB_LPM_CNTRL_LPMXMT_MSK	BIT(USB_LPM_CNTRL_LPMXMT_POS)

/****************** Bit definition for USB_LPM_INTREN register ************************/

#define	USB_LPM_INTREN_LPMERREN_POS	5U 
#define	USB_LPM_INTREN_LPMERREN_MSK	BIT(USB_LPM_INTREN_LPMERREN_POS)

#define	USB_LPM_INTREN_LPMRESEN_POS	4U 
#define	USB_LPM_INTREN_LPMRESEN_MSK	BIT(USB_LPM_INTREN_LPMRESEN_POS)

#define	USB_LPM_INTREN_LPMNCEN_POS	3U 
#define	USB_LPM_INTREN_LPMNCEN_MSK	BIT(USB_LPM_INTREN_LPMNCEN_POS)

#define	USB_LPM_INTREN_LPMACKEN_POS	2U 
#define	USB_LPM_INTREN_LPMACKEN_MSK	BIT(USB_LPM_INTREN_LPMACKEN_POS)

#define	USB_LPM_INTREN_LPMNYEN_POS	1U 
#define	USB_LPM_INTREN_LPMNYEN_MSK	BIT(USB_LPM_INTREN_LPMNYEN_POS)

#define	USB_LPM_INTREN_LPMSTEN_POS	0U 
#define	USB_LPM_INTREN_LPMSTEN_MSK	BIT(USB_LPM_INTREN_LPMSTEN_POS)

/****************** Bit definition for USB_LPM_INTR register ************************/

#define	USB_LPM_INTR_LPMERR_POS	5U 
#define	USB_LPM_INTR_LPMERR_MSK	BIT(USB_LPM_INTR_LPMERR_POS)

#define	USB_LPM_INTR_LPMRES_POS	4U 
#define	USB_LPM_INTR_LPMRES_MSK	BIT(USB_LPM_INTR_LPMRES_POS)

#define	USB_LPM_INTR_LPMNC_POS	3U 
#define	USB_LPM_INTR_LPMNC_MSK	BIT(USB_LPM_INTR_LPMNC_POS)

#define	USB_LPM_INTR_LPMACK_POS	2U 
#define	USB_LPM_INTR_LPMACK_MSK	BIT(USB_LPM_INTR_LPMACK_POS)

#define	USB_LPM_INTR_LPMNY_POS	1U 
#define	USB_LPM_INTR_LPMNY_MSK	BIT(USB_LPM_INTR_LPMNY_POS)

#define	USB_LPM_INTR_LPMST_POS	0U 
#define	USB_LPM_INTR_LPMST_MSK	BIT(USB_LPM_INTR_LPMST_POS)

/****************** Bit definition for USB_LPM_FADDR register ************************/

#define	USB_LPM_FADDR_LPMFADDR_POSS	0U 
#define	USB_LPM_FADDR_LPMFADDR_POSE	6U 
#define	USB_LPM_FADDR_LPMFADDR_MSK	BITS(USB_LPM_FADDR_LPMFADDR_POSS,USB_LPM_FADDR_LPMFADDR_POSE)

typedef struct {
	__IO uint8_t FADDR;
	__IO uint8_t POWER;
	__I  uint8_t TXIS;
	uint8_t rsv0;
	__I  uint8_t RXIS;
	uint8_t rsv1;
	__IO uint8_t TXIE;
	uint8_t rsv2;
	__IO uint8_t RXIE;
	uint8_t rsv3;
	__I  uint8_t USBIS;
	__IO uint8_t USBIE;
	__I  uint16_t FRAME;
	__IO uint8_t INDEX;
	__IO uint8_t TEST;
	uint32_t rsv4[4];
	__IO USB_FIFO_Typedef FIFO[8];
	uint32_t rsv5[8];
	__IO uint8_t DEVCTL;
	uint8_t rsv6;
	__IO uint8_t TXFIFOSIZE;
	__IO uint8_t RXFIFOSIZE;
	__IO uint16_t TXFIFOADD;
	__IO uint16_t RXFIFOADD;
	uint8_t rsv7[18];
	__IO uint8_t LINKINFO;
	__IO uint8_t VPLEN;
	__IO uint8_t HS_EOF1;
	__IO uint8_t FS_EOF1;
	__IO uint8_t LS_EOF1;
	uint8_t rsv8;
	USB_ADDR_Typedef ADDR[8];
	uint32_t rsv9[16];
	uint8_t rsv10[2];
	__IO uint8_t CSR0L;
	__IO uint8_t CSR0H;
	uint8_t rsv11[4];
	__I  uint8_t COUNT0;
	uint8_t rsv12;
	__IO uint8_t TYPE0;
	__IO uint8_t NACK;
	uint8_t rsv13[3];
	__I uint8_t CONFIG0;
	USB_CSRx_Typedef CSR[7];
	uint32_t rsv14[32];
	__IO uint8_t DMA_INTR;
	uint8_t rsv15[3];
	USB_DMA_CHx_Typedef DMA_CH[8];
	uint32_t rsv16[32];
	__IO uint32_t EP_RQPKTCOUNT[7];
	uint32_t rsv17[8];
	__IO uint16_t RXDPKTBUFDIS;
	__IO uint16_t TXDPKTBUFDIS;
	uint32_t rsv18[7];
	__IO uint16_t LPM_ATTR;
	__IO uint8_t LPM_CNTRL;
	__IO uint8_t LPM_INTREN;
	__IO uint8_t LPM_INTR;
	__IO uint8_t LPM_FADDR;
} USB_TypeDef;


/****************** Bit definition for LP16T_CON0 register ************************/

#define	LP16T_CON0_PRELOAD_POS	22U 
#define	LP16T_CON0_PRELOAD_MSK	BIT(LP16T_CON0_PRELOAD_POS)

#define	LP16T_CON0_WAVEPOL_POS	21U 
#define	LP16T_CON0_WAVEPOL_MSK	BIT(LP16T_CON0_WAVEPOL_POS)

#define	LP16T_CON0_WAVE_POSS	19U 
#define	LP16T_CON0_WAVE_POSE	20U 
#define	LP16T_CON0_WAVE_MSK	BITS(LP16T_CON0_WAVE_POSS,LP16T_CON0_WAVE_POSE)

#define	LP16T_CON0_TRIGEN_POSS	17U 
#define	LP16T_CON0_TRIGEN_POSE	18U 
#define	LP16T_CON0_TRIGEN_MSK	BITS(LP16T_CON0_TRIGEN_POSS,LP16T_CON0_TRIGEN_POSE)

#define	LP16T_CON0_TRIGSEL_POSS	13U 
#define	LP16T_CON0_TRIGSEL_POSE	15U 
#define	LP16T_CON0_TRIGSEL_MSK	BITS(LP16T_CON0_TRIGSEL_POSS,LP16T_CON0_TRIGSEL_POSE)

#define	LP16T_CON0_PRESC_POSS	9U 
#define	LP16T_CON0_PRESC_POSE	11U 
#define	LP16T_CON0_PRESC_MSK	BITS(LP16T_CON0_PRESC_POSS,LP16T_CON0_PRESC_POSE)

#define	LP16T_CON0_TRGFLT_POSS	6U 
#define	LP16T_CON0_TRGFLT_POSE	7U 
#define	LP16T_CON0_TRGFLT_MSK	BITS(LP16T_CON0_TRGFLT_POSS,LP16T_CON0_TRGFLT_POSE)

#define	LP16T_CON0_CKFLT_POSS	3U 
#define	LP16T_CON0_CKFLT_POSE	4U 
#define	LP16T_CON0_CKFLT_MSK	BITS(LP16T_CON0_CKFLT_POSS,LP16T_CON0_CKFLT_POSE)

#define	LP16T_CON0_CKPOL_POS	1U 
#define	LP16T_CON0_CKPOL_MSK	BIT(LP16T_CON0_CKPOL_POS)

#define	LP16T_CON0_CKSEL_POS	0U 
#define	LP16T_CON0_CKSEL_MSK	BIT(LP16T_CON0_CKSEL_POS)

/****************** Bit definition for LP16T_CON1 register ************************/

#define	LP16T_CON1_CNTSTRT_POS	2U 
#define	LP16T_CON1_CNTSTRT_MSK	BIT(LP16T_CON1_CNTSTRT_POS)

#define	LP16T_CON1_SNGSTRT_POS	1U 
#define	LP16T_CON1_SNGSTRT_MSK	BIT(LP16T_CON1_SNGSTRT_POS)

#define	LP16T_CON1_ENABLE_POS	0U 
#define	LP16T_CON1_ENABLE_MSK	BIT(LP16T_CON1_ENABLE_POS)

/****************** Bit definition for LP16T_ARR register ************************/

#define	LP16T_ARR_ARR_POSS	0U 
#define	LP16T_ARR_ARR_POSE	15U 
#define	LP16T_ARR_ARR_MSK	BITS(LP16T_ARR_ARR_POSS,LP16T_ARR_ARR_POSE)

/****************** Bit definition for LP16T_CNT register ************************/

#define	LP16T_CNT_CNT_POSS	0U 
#define	LP16T_CNT_CNT_POSE	15U 
#define	LP16T_CNT_CNT_MSK	BITS(LP16T_CNT_CNT_POSS,LP16T_CNT_CNT_POSE)

/****************** Bit definition for LP16T_CMP register ************************/

#define	LP16T_CMP_CMP_POSS	0U 
#define	LP16T_CMP_CMP_POSE	15U 
#define	LP16T_CMP_CMP_MSK	BITS(LP16T_CMP_CMP_POSS,LP16T_CMP_CMP_POSE)

/****************** Bit definition for LP16T_IER register ************************/

#define	LP16T_IER_EXTTRIGIE_POS	2U 
#define	LP16T_IER_EXTTRIGIE_MSK	BIT(LP16T_IER_EXTTRIGIE_POS)

#define	LP16T_IER_ARRMIE_POS	1U 
#define	LP16T_IER_ARRMIE_MSK	BIT(LP16T_IER_ARRMIE_POS)

#define	LP16T_IER_CMPMIE_POS	0U 
#define	LP16T_IER_CMPMIE_MSK	BIT(LP16T_IER_CMPMIE_POS)

/****************** Bit definition for LP16T_ISR register ************************/

#define	LP16T_ISR_EXTTRIG_POS	2U 
#define	LP16T_ISR_EXTTRIG_MSK	BIT(LP16T_ISR_EXTTRIG_POS)

#define	LP16T_ISR_ARRM_POS	1U 
#define	LP16T_ISR_ARRM_MSK	BIT(LP16T_ISR_ARRM_POS)

#define	LP16T_ISR_CMPM_POS	0U 
#define	LP16T_ISR_CMPM_MSK	BIT(LP16T_ISR_CMPM_POS)

/****************** Bit definition for LP16T_IFC register ************************/

#define	LP16T_IFC_EXTTRIG_POS	2U 
#define	LP16T_IFC_EXTTRIG_MSK	BIT(LP16T_IFC_EXTTRIG_POS)

#define	LP16T_IFC_ARRM_POS	1U 
#define	LP16T_IFC_ARRM_MSK	BIT(LP16T_IFC_ARRM_POS)

#define	LP16T_IFC_CMPM_POS	0U 
#define	LP16T_IFC_CMPM_MSK	BIT(LP16T_IFC_CMPM_POS)

/****************** Bit definition for LP16T_UPDATE register ************************/

#define	LP16T_UPDATE_UDIS_POS	0U 
#define	LP16T_UPDATE_UDIS_MSK	BIT(LP16T_UPDATE_UDIS_POS)

/****************** Bit definition for LP16T_SYNCSTAT register ************************/

#define	LP16T_SYNCSTAT_CMPWBSY_POS	3U 
#define	LP16T_SYNCSTAT_CMPWBSY_MSK	BIT(LP16T_SYNCSTAT_CMPWBSY_POS)

#define	LP16T_SYNCSTAT_ARRWBSY_POS	2U 
#define	LP16T_SYNCSTAT_ARRWBSY_MSK	BIT(LP16T_SYNCSTAT_ARRWBSY_POS)

#define	LP16T_SYNCSTAT_CON1WBSY_POS	1U 
#define	LP16T_SYNCSTAT_CON1WBSY_MSK	BIT(LP16T_SYNCSTAT_CON1WBSY_POS)

typedef struct
{
	__IO uint32_t CON0;
	__IO uint32_t CON1;
	__IO uint32_t ARR;
	__I uint32_t CNT;
	__IO uint32_t CMP;
	uint32_t RESERVED0 ;
	__IO uint32_t IER;
	__I uint32_t ISR;
	__O uint32_t IFC;
	uint32_t RESERVED1[3] ;
	__IO uint32_t UPDATE;
	__I uint32_t SYNCSTAT;
} LPTIM_TypeDef;

/****************** Bit definition for DBGC_IDCODE register ************************/

#define	DBGC_IDCODE_REV_ID_POSS	16U 
#define	DBGC_IDCODE_REV_ID_POSE	31U 
#define	DBGC_IDCODE_REV_ID_MSK	BITS(DBGC_IDCODE_REV_ID_POSS,DBGC_IDCODE_REV_ID_POSE)

#define	DBGC_IDCODE_CORE_ID_POSS	12U 
#define	DBGC_IDCODE_CORE_ID_POSE	15U 
#define	DBGC_IDCODE_CORE_ID_MSK	BITS(DBGC_IDCODE_CORE_ID_POSS,DBGC_IDCODE_CORE_ID_POSE)

#define	DBGC_IDCODE_DEV_ID_POSS	0U 
#define	DBGC_IDCODE_DEV_ID_POSE	11U 
#define	DBGC_IDCODE_DEV_ID_MSK	BITS(DBGC_IDCODE_DEV_ID_POSS,DBGC_IDCODE_DEV_ID_POSE)

/****************** Bit definition for DBGC_CR register ************************/

#define	DBGC_CR_DBG_STANDBY_POS	3U 
#define	DBGC_CR_DBG_STANDBY_MSK	BIT(DBGC_CR_DBG_STANDBY_POS)

#define	DBGC_CR_DBG_STOP2_POS	2U 
#define	DBGC_CR_DBG_STOP2_MSK	BIT(DBGC_CR_DBG_STOP2_POS)

#define	DBGC_CR_DBG_STOP1_POS	1U 
#define	DBGC_CR_DBG_STOP1_MSK	BIT(DBGC_CR_DBG_STOP1_POS)

#define	DBGC_CR_DBG_SLEEP_POS	0U 
#define	DBGC_CR_DBG_SLEEP_MSK	BIT(DBGC_CR_DBG_SLEEP_POS)

/****************** Bit definition for DBGC_APB1FZ register ************************/

#define	DBGC_APB1FZ_CAN_STOP_POS	12U 
#define	DBGC_APB1FZ_CAN_STOP_MSK	BIT(DBGC_APB1FZ_CAN_STOP_POS)

#define	DBGC_APB1FZ_I2C1_SMBUS_TO_POS	9U 
#define	DBGC_APB1FZ_I2C1_SMBUS_TO_MSK	BIT(DBGC_APB1FZ_I2C1_SMBUS_TO_POS)

#define	DBGC_APB1FZ_I2C0_SMBUS_TO_POS	8U 
#define	DBGC_APB1FZ_I2C0_SMBUS_TO_MSK	BIT(DBGC_APB1FZ_I2C0_SMBUS_TO_POS)

#define	DBGC_APB1FZ_TIM7_STOP_POS	7U 
#define	DBGC_APB1FZ_TIM7_STOP_MSK	BIT(DBGC_APB1FZ_TIM7_STOP_POS)

#define	DBGC_APB1FZ_TIM6_STOP_POS	6U 
#define	DBGC_APB1FZ_TIM6_STOP_MSK	BIT(DBGC_APB1FZ_TIM6_STOP_POS)

#define	DBGC_APB1FZ_TIM5_STOP_POS	5U 
#define	DBGC_APB1FZ_TIM5_STOP_MSK	BIT(DBGC_APB1FZ_TIM5_STOP_POS)

#define	DBGC_APB1FZ_TIM4_STOP_POS	4U 
#define	DBGC_APB1FZ_TIM4_STOP_MSK	BIT(DBGC_APB1FZ_TIM4_STOP_POS)

#define	DBGC_APB1FZ_TIM3_STOP_POS	3U 
#define	DBGC_APB1FZ_TIM3_STOP_MSK	BIT(DBGC_APB1FZ_TIM3_STOP_POS)

#define	DBGC_APB1FZ_TIM2_STOP_POS	2U 
#define	DBGC_APB1FZ_TIM2_STOP_MSK	BIT(DBGC_APB1FZ_TIM2_STOP_POS)

#define	DBGC_APB1FZ_TIM1_STOP_POS	1U 
#define	DBGC_APB1FZ_TIM1_STOP_MSK	BIT(DBGC_APB1FZ_TIM1_STOP_POS)

#define	DBGC_APB1FZ_TIM0_STOP_POS	0U 
#define	DBGC_APB1FZ_TIM0_STOP_MSK	BIT(DBGC_APB1FZ_TIM0_STOP_POS)

/****************** Bit definition for DBGC_APB2FZ register ************************/

#define	DBGC_APB2FZ_RTC_STOP_POS	10U 
#define	DBGC_APB2FZ_RTC_STOP_MSK	BIT(DBGC_APB2FZ_RTC_STOP_POS)

#define	DBGC_APB2FZ_WWDT_STOP_POS	9U 
#define	DBGC_APB2FZ_WWDT_STOP_MSK	BIT(DBGC_APB2FZ_WWDT_STOP_POS)

#define	DBGC_APB2FZ_IWDT_STOP_POS	8U 
#define	DBGC_APB2FZ_IWDT_STOP_MSK	BIT(DBGC_APB2FZ_IWDT_STOP_POS)

#define	DBGC_APB2FZ_LPTIM0_STOP_POS	0U 
#define	DBGC_APB2FZ_LPTIM0_STOP_MSK	BIT(DBGC_APB2FZ_LPTIM0_STOP_POS)

typedef struct
{
	__I uint32_t IDCODE;
	__IO uint32_t CR;
	__IO uint32_t APB1FZ;
	__IO uint32_t APB2FZ;
} DBGC_TypeDef;

/****************** Bit definition for OPAMP_CON register ************************/

#define	OPAMP_CON_OPA2NPSEN_POS	24U 
#define	OPAMP_CON_OPA2NPSEN_MSK	BIT(OPAMP_CON_OPA2NPSEN_POS)

#define	OPAMP_CON_OPA1NPSEN_POS	23U 
#define	OPAMP_CON_OPA1NPSEN_MSK	BIT(OPAMP_CON_OPA1NPSEN_POS)

#define	OPAMP_CON_OPA0NPSEN_POS	22U 
#define	OPAMP_CON_OPA0NPSEN_MSK	BIT(OPAMP_CON_OPA0NPSEN_POS)

#define	OPAMP_CON_OPA2LPFD_POSS	16U 
#define	OPAMP_CON_OPA2LPFD_POSE	17U 
#define	OPAMP_CON_OPA2LPFD_MSK	BITS(OPAMP_CON_OPA2LPFD_POSS,OPAMP_CON_OPA2LPFD_POSE)

#define	OPAMP_CON_OPA1LPFD_POSS	14U 
#define	OPAMP_CON_OPA1LPFD_POSE	15U 
#define	OPAMP_CON_OPA1LPFD_MSK	BITS(OPAMP_CON_OPA1LPFD_POSS,OPAMP_CON_OPA1LPFD_POSE)

#define	OPAMP_CON_OPA0LPFD_POSS	12U 
#define	OPAMP_CON_OPA0LPFD_POSE	13U 
#define	OPAMP_CON_OPA0LPFD_MSK	BITS(OPAMP_CON_OPA0LPFD_POSS,OPAMP_CON_OPA0LPFD_POSE)

#define	OPAMP_CON_OPA2HCMD_POS	8U 
#define	OPAMP_CON_OPA2HCMD_MSK	BIT(OPAMP_CON_OPA2HCMD_POS)

#define	OPAMP_CON_OPA1HCMD_POS	7U 
#define	OPAMP_CON_OPA1HCMD_MSK	BIT(OPAMP_CON_OPA1HCMD_POS)

#define	OPAMP_CON_OPA0HCMD_POS	6U 
#define	OPAMP_CON_OPA0HCMD_MSK	BIT(OPAMP_CON_OPA0HCMD_POS)

#define	OPAMP_CON_OPA2EN_POS	2U 
#define	OPAMP_CON_OPA2EN_MSK	BIT(OPAMP_CON_OPA2EN_POS)

#define	OPAMP_CON_OPA1EN_POS	1U 
#define	OPAMP_CON_OPA1EN_MSK	BIT(OPAMP_CON_OPA1EN_POS)

#define	OPAMP_CON_OPA0EN_POS	0U 
#define	OPAMP_CON_OPA0EN_MSK	BIT(OPAMP_CON_OPA0EN_POS)

/****************** Bit definition for OPAMP_MUX0 register ************************/

#define	OPAMP_MUX0_RSEL_POSS	28U 
#define	OPAMP_MUX0_RSEL_POSE	29U 
#define	OPAMP_MUX0_RSEL_MSK	BITS(OPAMP_MUX0_RSEL_POSS,OPAMP_MUX0_RSEL_POSE)

#define	OPAMP_MUX0_NXTOUT_POS	26U 
#define	OPAMP_MUX0_NXTOUT_MSK	BIT(OPAMP_MUX0_NXTOUT_POS)

#define	OPAMP_MUX0_OPMD_POSS	24U 
#define	OPAMP_MUX0_OPMD_POSE	25U 
#define	OPAMP_MUX0_OPMD_MSK	BITS(OPAMP_MUX0_OPMD_POSS,OPAMP_MUX0_OPMD_POSE)

#define	OPAMP_MUX0_OUTMD_POSS	22U 
#define	OPAMP_MUX0_OUTMD_POSE	23U 
#define	OPAMP_MUX0_OUTMD_MSK	BITS(OPAMP_MUX0_OUTMD_POSS,OPAMP_MUX0_OUTMD_POSE)

#define	OPAMP_MUX0_OUTSEL_POSS	14U 
#define	OPAMP_MUX0_OUTSEL_POSE	15U 
#define	OPAMP_MUX0_OUTSEL_MSK	BITS(OPAMP_MUX0_OUTSEL_POSS,OPAMP_MUX0_OUTSEL_POSE)

#define	OPAMP_MUX0_NEGPEN_POS	13U 
#define	OPAMP_MUX0_NEGPEN_MSK	BIT(OPAMP_MUX0_NEGPEN_POS)

#define	OPAMP_MUX0_POSPEN_POS	12U 
#define	OPAMP_MUX0_POSPEN_MSK	BIT(OPAMP_MUX0_POSPEN_POS)

#define	OPAMP_MUX0_GAINSEL_POS	11U 
#define	OPAMP_MUX0_GAINSEL_MSK	BIT(OPAMP_MUX0_GAINSEL_POS)

#define	OPAMP_MUX0_RINMUX_POSS	8U 
#define	OPAMP_MUX0_RINMUX_POSE	9U 
#define	OPAMP_MUX0_RINMUX_MSK	BITS(OPAMP_MUX0_RINMUX_POSS,OPAMP_MUX0_RINMUX_POSE)

#define	OPAMP_MUX0_NEGSEL_POSS	4U 
#define	OPAMP_MUX0_NEGSEL_POSE	5U 
#define	OPAMP_MUX0_NEGSEL_MSK	BITS(OPAMP_MUX0_NEGSEL_POSS,OPAMP_MUX0_NEGSEL_POSE)

#define	OPAMP_MUX0_POSSEL_POSS	0U 
#define	OPAMP_MUX0_POSSEL_POSE	1U 
#define	OPAMP_MUX0_POSSEL_MSK	BITS(OPAMP_MUX0_POSSEL_POSS,OPAMP_MUX0_POSSEL_POSE)

/****************** Bit definition for OPAMP_MUX1 register ************************/

#define	OPAMP_MUX1_RSEL_POSS	28U 
#define	OPAMP_MUX1_RSEL_POSE	29U 
#define	OPAMP_MUX1_RSEL_MSK	BITS(OPAMP_MUX1_RSEL_POSS,OPAMP_MUX1_RSEL_POSE)

#define	OPAMP_MUX1_NXTOUT_POS	26U 
#define	OPAMP_MUX1_NXTOUT_MSK	BIT(OPAMP_MUX1_NXTOUT_POS)

#define	OPAMP_MUX1_OPMD_POSS	24U 
#define	OPAMP_MUX1_OPMD_POSE	25U 
#define	OPAMP_MUX1_OPMD_MSK	BITS(OPAMP_MUX1_OPMD_POSS,OPAMP_MUX1_OPMD_POSE)

#define	OPAMP_MUX1_OUTMD_POSS	22U 
#define	OPAMP_MUX1_OUTMD_POSE	23U 
#define	OPAMP_MUX1_OUTMD_MSK	BITS(OPAMP_MUX1_OUTMD_POSS,OPAMP_MUX1_OUTMD_POSE)

#define	OPAMP_MUX1_OUTSEL_POSS	14U 
#define	OPAMP_MUX1_OUTSEL_POSE	15U 
#define	OPAMP_MUX1_OUTSEL_MSK	BITS(OPAMP_MUX1_OUTSEL_POSS,OPAMP_MUX1_OUTSEL_POSE)

#define	OPAMP_MUX1_NEGPEN_POS	13U 
#define	OPAMP_MUX1_NEGPEN_MSK	BIT(OPAMP_MUX1_NEGPEN_POS)

#define	OPAMP_MUX1_POSPEN_POS	12U 
#define	OPAMP_MUX1_POSPEN_MSK	BIT(OPAMP_MUX1_POSPEN_POS)

#define	OPAMP_MUX1_GAINSEL_POS	11U 
#define	OPAMP_MUX1_GAINSEL_MSK	BIT(OPAMP_MUX1_GAINSEL_POS)

#define	OPAMP_MUX1_RINMUX_POSS	8U 
#define	OPAMP_MUX1_RINMUX_POSE	9U 
#define	OPAMP_MUX1_RINMUX_MSK	BITS(OPAMP_MUX1_RINMUX_POSS,OPAMP_MUX1_RINMUX_POSE)

#define	OPAMP_MUX1_NEGSEL_POSS	4U 
#define	OPAMP_MUX1_NEGSEL_POSE	5U 
#define	OPAMP_MUX1_NEGSEL_MSK	BITS(OPAMP_MUX1_NEGSEL_POSS,OPAMP_MUX1_NEGSEL_POSE)

#define	OPAMP_MUX1_POSSEL_POSS	0U 
#define	OPAMP_MUX1_POSSEL_POSE	1U 
#define	OPAMP_MUX1_POSSEL_MSK	BITS(OPAMP_MUX1_POSSEL_POSS,OPAMP_MUX1_POSSEL_POSE)

/****************** Bit definition for OPAMP_MUX2 register ************************/

#define	OPAMP_MUX2_RSEL_POSS	28U 
#define	OPAMP_MUX2_RSEL_POSE	29U 
#define	OPAMP_MUX2_RSEL_MSK	BITS(OPAMP_MUX2_RSEL_POSS,OPAMP_MUX2_RSEL_POSE)

#define	OPAMP_MUX2_NXTOUT_POS	26U 
#define	OPAMP_MUX2_NXTOUT_MSK	BIT(OPAMP_MUX2_NXTOUT_POS)

#define	OPAMP_MUX2_OPMD_POSS	24U 
#define	OPAMP_MUX2_OPMD_POSE	25U 
#define	OPAMP_MUX2_OPMD_MSK	BITS(OPAMP_MUX2_OPMD_POSS,OPAMP_MUX2_OPMD_POSE)

#define	OPAMP_MUX2_OUTMD_POS	22U 
#define	OPAMP_MUX2_OUTMD_MSK	BIT(OPAMP_MUX2_OUTMD_POS)

#define	OPAMP_MUX2_OUTSEL_POS	14U 
#define	OPAMP_MUX2_OUTSEL_MSK	BIT(OPAMP_MUX_OUTSEL_POS)

#define	OPAMP_MUX2_NEGPEN_POS	13U 
#define	OPAMP_MUX2_NEGPEN_MSK	BIT(OPAMP_MUX2_NEGPEN_POS)

#define	OPAMP_MUX2_POSPEN_POS	12U 
#define	OPAMP_MUX2_POSPEN_MSK	BIT(OPAMP_MUX2_POSPEN_POS)

#define	OPAMP_MUX2_GAINSEL_POS	11U 
#define	OPAMP_MUX2_GAINSEL_MSK	BIT(OPAMP_MUX2_GAINSEL_POS)

#define	OPAMP_MUX2_RINMUX_POSS	8U 
#define	OPAMP_MUX2_RINMUX_POSE	9U 
#define	OPAMP_MUX2_RINMUX_MSK	BITS(OPAMP_MUX2_RINMUX_POSS,OPAMP_MUX2_RINMUX_POSE)

#define	OPAMP_MUX2_NEGSEL_POSS	4U 
#define	OPAMP_MUX2_NEGSEL_POSE	5U 
#define	OPAMP_MUX2_NEGSEL_MSK	BITS(OPAMP_MUX2_NEGSEL_POSS,OPAMP_MUX2_NEGSEL_POSE)

#define	OPAMP_MUX2_POSSEL_POSS	0U 
#define	OPAMP_MUX2_POSSEL_POSE	1U 
#define	OPAMP_MUX2_POSSEL_MSK	BITS(OPAMP_MUX2_POSSEL_POSS,OPAMP_MUX2_POSSEL_POSE)

typedef struct
{
	__IO uint32_t CON;
	uint32_t RESERVED0 ;
	__IO uint32_t MUX0;
	__IO uint32_t MUX1;
	__IO uint32_t MUX2;
} OPAMP_TypeDef;

/****************** Bit definition for DAC_CON register ************************/

#define	DAC_CON_RCYCLSEL_POSS	20U 
#define	DAC_CON_RCYCLSEL_POSE	21U 
#define	DAC_CON_RCYCLSEL_MSK	BITS(DAC_CON_RCYCLSEL_POSS,DAC_CON_RCYCLSEL_POSE)

#define	DAC_CON_PRES_POSS	16U 
#define	DAC_CON_PRES_POSE	18U 
#define	DAC_CON_PRES_MSK	BITS(DAC_CON_PRES_POSS,DAC_CON_PRES_POSE)

#define	DAC_CON_CH0PRESRST_POS	7U 
#define	DAC_CON_CH0PRESRST_MSK	BIT(DAC_CON_CH0PRESRST_POS)

#define	DAC_CON_OUTENPIS_POS	6U 
#define	DAC_CON_OUTENPIS_MSK	BIT(DAC_CON_OUTENPIS_POS)

#define	DAC_CON_OUTMD_POSS	4U 
#define	DAC_CON_OUTMD_POSE	5U 
#define	DAC_CON_OUTMD_MSK	BITS(DAC_CON_OUTMD_POSS,DAC_CON_OUTMD_POSE)

#define	DAC_CON_CONVMD_POSS	2U 
#define	DAC_CON_CONVMD_POSE	3U 
#define	DAC_CON_CONVMD_MSK	BITS(DAC_CON_CONVMD_POSS,DAC_CON_CONVMD_POSE)

#define	DAC_CON_SINEMD_POS	1U 
#define	DAC_CON_SINEMD_MSK	BIT(DAC_CON_SINEMD_POS)

#define	DAC_CON_DIFEN_POS	0U 
#define	DAC_CON_DIFEN_MSK	BIT(DAC_CON_DIFEN_POS)

/****************** Bit definition for DAC_STAT register ************************/

#define	DAC_STAT_CH1BSY_POS	1U 
#define	DAC_STAT_CH1BSY_MSK	BIT(DAC_STAT_CH1BSY_POS)

#define	DAC_STAT_CH0BSY_POS	0U 
#define	DAC_STAT_CH0BSY_MSK	BIT(DAC_STAT_CH0BSY_POS)

/****************** Bit definition for DAC_CH0CTRL register ************************/

#define	DAC_CH0CTRL_PISSEL_POSS	4U 
#define	DAC_CH0CTRL_PISSEL_POSE	7U 
#define	DAC_CH0CTRL_PISSEL_MSK	BITS(DAC_CH0CTRL_PISSEL_POSS,DAC_CH0CTRL_PISSEL_POSE)

#define	DAC_CH0CTRL_PISEN_POS	2U 
#define	DAC_CH0CTRL_PISEN_MSK	BIT(DAC_CH0CTRL_PISEN_POS)

#define	DAC_CH0CTRL_RCYCLEN_POS	1U 
#define	DAC_CH0CTRL_RCYCLEN_MSK	BIT(DAC_CH0CTRL_RCYCLEN_POS)

#define	DAC_CH0CTRL_EN_POS	0U 
#define	DAC_CH0CTRL_EN_MSK	BIT(DAC_CH0CTRL_EN_POS)

/****************** Bit definition for DAC_CH1CTRL register ************************/

#define	DAC_CH1CTRL_PISSEL_POSS	4U 
#define	DAC_CH1CTRL_PISSEL_POSE	7U 
#define	DAC_CH1CTRL_PISSEL_MSK	BITS(DAC_CH1CTRL_PISSEL_POSS,DAC_CH1CTRL_PISSEL_POSE)

#define	DAC_CH1CTRL_PISEN_POS	2U 
#define	DAC_CH1CTRL_PISEN_MSK	BIT(DAC_CH1CTRL_PISEN_POS)

#define	DAC_CH1CTRL_RCYCLEN_POS	1U 
#define	DAC_CH1CTRL_RCYCLEN_MSK	BIT(DAC_CH1CTRL_RCYCLEN_POS)

#define	DAC_CH1CTRL_EN_POS	0U 
#define	DAC_CH1CTRL_EN_MSK	BIT(DAC_CH1CTRL_EN_POS)

/****************** Bit definition for DAC_IES register ************************/

#define	DAC_IES_CH1UDF_POS	5U 
#define	DAC_IES_CH1UDF_MSK	BIT(DAC_IES_CH1UDF_POS)

#define	DAC_IES_CH0UDF_POS	4U 
#define	DAC_IES_CH0UDF_MSK	BIT(DAC_IES_CH0UDF_POS)

#define	DAC_IES_CH1_POS	1U 
#define	DAC_IES_CH1_MSK	BIT(DAC_IES_CH1_POS)

#define	DAC_IES_CH0_POS	0U 
#define	DAC_IES_CH0_MSK	BIT(DAC_IES_CH0_POS)

/****************** Bit definition for DAC_IEC register ************************/

#define	DAC_IEC_CH1UDF_POS	5U 
#define	DAC_IEC_CH1UDF_MSK	BIT(DAC_IEC_CH1UDF_POS)

#define	DAC_IEC_CH0UDF_POS	4U 
#define	DAC_IEC_CH0UDF_MSK	BIT(DAC_IEC_CH0UDF_POS)

#define	DAC_IEC_CH1_POS	1U 
#define	DAC_IEC_CH1_MSK	BIT(DAC_IEC_CH1_POS)

#define	DAC_IEC_CH0_POS	0U 
#define	DAC_IEC_CH0_MSK	BIT(DAC_IEC_CH0_POS)

/****************** Bit definition for DAC_IEV register ************************/

#define	DAC_IEV_CH1UDF_POS	5U 
#define	DAC_IEV_CH1UDF_MSK	BIT(DAC_IEV_CH1UDF_POS)

#define	DAC_IEV_CH0UDF_POS	4U 
#define	DAC_IEV_CH0UDF_MSK	BIT(DAC_IEV_CH0UDF_POS)

#define	DAC_IEV_CH1_POS	1U 
#define	DAC_IEV_CH1_MSK	BIT(DAC_IEV_CH1_POS)

#define	DAC_IEV_CH0_POS	0U 
#define	DAC_IEV_CH0_MSK	BIT(DAC_IEV_CH0_POS)

/****************** Bit definition for DAC_RIF register ************************/

#define	DAC_RIF_CH1UDF_POS	5U 
#define	DAC_RIF_CH1UDF_MSK	BIT(DAC_RIF_CH1UDF_POS)

#define	DAC_RIF_CH0UDF_POS	4U 
#define	DAC_RIF_CH0UDF_MSK	BIT(DAC_RIF_CH0UDF_POS)

#define	DAC_RIF_CH1_POS	1U 
#define	DAC_RIF_CH1_MSK	BIT(DAC_RIF_CH1_POS)

#define	DAC_RIF_CH0_POS	0U 
#define	DAC_RIF_CH0_MSK	BIT(DAC_RIF_CH0_POS)

/****************** Bit definition for DAC_IFM register ************************/

#define	DAC_IFM_CH1UDF_POS	5U 
#define	DAC_IFM_CH1UDF_MSK	BIT(DAC_IFM_CH1UDF_POS)

#define	DAC_IFM_CH0UDF_POS	4U 
#define	DAC_IFM_CH0UDF_MSK	BIT(DAC_IFM_CH0UDF_POS)

#define	DAC_IFM_CH1_POS	1U 
#define	DAC_IFM_CH1_MSK	BIT(DAC_IFM_CH1_POS)

#define	DAC_IFM_CH0_POS	0U 
#define	DAC_IFM_CH0_MSK	BIT(DAC_IFM_CH0_POS)

/****************** Bit definition for DAC_IFC register ************************/

#define	DAC_IFC_CH1UDF_POS	5U 
#define	DAC_IFC_CH1UDF_MSK	BIT(DAC_IFC_CH1UDF_POS)

#define	DAC_IFC_CH0UDF_POS	4U 
#define	DAC_IFC_CH0UDF_MSK	BIT(DAC_IFC_CH0UDF_POS)

#define	DAC_IFC_CH1_POS	1U 
#define	DAC_IFC_CH1_MSK	BIT(DAC_IFC_CH1_POS)

#define	DAC_IFC_CH0_POS	0U 
#define	DAC_IFC_CH0_MSK	BIT(DAC_IFC_CH0_POS)

/****************** Bit definition for DAC_CH0DATA register ************************/

#define	DAC_CH0DATA_VAL_POSS	0U 
#define	DAC_CH0DATA_VAL_POSE	11U 
#define	DAC_CH0DATA_VAL_MSK	BITS(DAC_CH0DATA_VAL_POSS,DAC_CH0DATA_VAL_POSE)

/****************** Bit definition for DAC_CH1DATA register ************************/

#define	DAC_CH1DATA_VAL_POSS	0U 
#define	DAC_CH1DATA_VAL_POSE	11U 
#define	DAC_CH1DATA_VAL_MSK	BITS(DAC_CH1DATA_VAL_POSS,DAC_CH1DATA_VAL_POSE)

/****************** Bit definition for DAC_COMBDATA register ************************/

#define	DAC_COMBDATA_CH1VAL_POSS	16U 
#define	DAC_COMBDATA_CH1VAL_POSE	27U 
#define	DAC_COMBDATA_CH1VAL_MSK	BITS(DAC_COMBDATA_CH1VAL_POSS,DAC_COMBDATA_CH1VAL_POSE)

#define	DAC_COMBDATA_CH0VAL_POSS	0U 
#define	DAC_COMBDATA_CH0VAL_POSE	11U 
#define	DAC_COMBDATA_CH0VAL_MSK	BITS(DAC_COMBDATA_CH0VAL_POSS,DAC_COMBDATA_CH0VAL_POSE)

/****************** Bit definition for DAC_CAL register ************************/

#define	DAC_CAL_SELF_CALEN_POS	31U 
#define	DAC_CAL_SELF_CALEN_MSK	BIT(DAC_CAL_SELF_CALEN_POS)

typedef struct
{
	__IO uint32_t CON;
	__I uint32_t STAT;
	__IO uint32_t CH0CTRL;
	__IO uint32_t CH1CTRL;
	__O uint32_t IES;
	__O uint32_t IEC;
	__I uint32_t IEV;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t IFC;
	__IO uint32_t CH0DATA;
	__IO uint32_t CH1DATA;
	__O uint32_t COMBDATA;
	__IO uint32_t CAL;
} DAC_TypeDef;


/* Base addresses */
#define SRAM_BASE	(0x20000000UL)
#define APB1_BASE	(0x40000000UL)
#define APB2_BASE	(0x40040000UL)
#define AHB_BASE	(0x40080000UL)
#define EBI_BASE	(0x60000000UL)
#define EBI_R_BASE	(0xA0000000UL)


/* APB1 peripherals Base Address */
#define AD16C4T0_BASE	(APB1_BASE + 0x0000)
#define AD16C4T1_BASE	(APB1_BASE + 0x0400)
#define GP32C4T0_BASE	(APB1_BASE + 0x0800)
#define GP32C4T1_BASE	(APB1_BASE + 0x0C00)
#define BS16T0_BASE	(APB1_BASE + 0x1000)
#define BS16T1_BASE	(APB1_BASE + 0x1400)
#define GP16C4T0_BASE	(APB1_BASE + 0x1800)
#define GP16C4T1_BASE	(APB1_BASE + 0x1C00)
#define UART0_BASE	(APB1_BASE + 0x4000)
#define UART1_BASE	(APB1_BASE + 0x4400)
#define UART2_BASE	(APB1_BASE + 0x4800)
#define UART3_BASE	(APB1_BASE + 0x4C00)
#define UART4_BASE	(APB1_BASE + 0x5000)
#define UART5_BASE	(APB1_BASE + 0x5400)
#define SPI0_I2S0_BASE	(APB1_BASE + 0x6000)
#define SPI1_I2S1_BASE	(APB1_BASE + 0x6400)
#define SPI2_I2S2_BASE	(APB1_BASE + 0x6800)
#define I2C0_BASE	(APB1_BASE + 0x8000)
#define I2C1_BASE	(APB1_BASE + 0x8400)
#define CAN0_BASE	(APB1_BASE + 0xB000)
#define DMA0_BASE    	(APB1_BASE + 0xC000)
#define QSPI_BASE	(APB1_BASE + 0xD400)

/* APB2 peripherals Base Address */
#define LPTIM0_BASE	(APB2_BASE + 0x0000)
#define LPUART0_BASE	(APB2_BASE + 0x1000)
#define ADC0_BASE	(APB2_BASE + 0x2000)
#define ADC1_BASE	(APB2_BASE + 0x2400)
#define ACMP0_BASE	(APB2_BASE + 0x3000)
#define ACMP1_BASE	(APB2_BASE + 0x3400)
#define ACMP2_BASE	(APB2_BASE + 0x3800)
#define OPAMP_BASE	(APB2_BASE + 0x4000)
#define DAC0_BASE	(APB2_BASE + 0x5000)
#define WWDT_BASE	(APB2_BASE + 0x6000)
#define IWDT_BASE	(APB2_BASE + 0x6400)
#define LCD_BASE        (APB2_BASE + 0x7000)
#define BKPC_BASE	(APB2_BASE + 0x8000)
#define RTC_BASE	(APB2_BASE + 0x8400)
#define TSENSE_BASE	(APB2_BASE + 0x8800)
#define DBGC_BASE	(APB2_BASE + 0xA000)

/* AHB peripherals Base Address */
#define SYSTEM_BASE	(AHB_BASE + 0x0000)
#define CMU_BASE	(AHB_BASE + 0x0400)
#define RMU_BASE	(AHB_BASE + 0x0800)
#define PMU_BASE	(AHB_BASE + 0x0C00)
#define MSC_BASE	(AHB_BASE + 0x1000)
#define GPIOA_BASE	(AHB_BASE + 0x4000)
#define GPIOB_BASE	(AHB_BASE + 0x4040)
#define GPIOC_BASE	(AHB_BASE + 0x4080)
#define GPIOD_BASE	(AHB_BASE + 0x40C0)
#define GPIOE_BASE	(AHB_BASE + 0x4100)
#define GPIOF_BASE	(AHB_BASE + 0x4140)
#define GPIOG_BASE	(AHB_BASE + 0x4180)
#define GPIOH_BASE	(AHB_BASE + 0x41C0)
#define EXTI_BASE	(AHB_BASE + 0x4300)
#define CRC_BASE	(AHB_BASE + 0x5000)
#define CALC_BASE	(AHB_BASE + 0x5400)
#define CRYPT_BASE	(AHB_BASE + 0x5800)
#define TRNG_BASE	(AHB_BASE + 0x5C00)
#define PIS_BASE	(AHB_BASE + 0x6000)
#define USB0_BASE	(AHB_BASE + 0x6400)
#define ECC_BASE	(AHB_BASE + 0x6800)

/* EBI Base Address */
#define EBI_BANK1	(EBI_BASE)
#define EBI_BANK1_1	(EBI_BANK1)
#define EBI_BANK1_2	(EBI_BANK1  + 0x04000000UL)
#define EBI_BANK1_3	(EBI_BANK1  + 0x08000000UL)
#define EBI_BANK1_4	(EBI_BANK1  + 0x0C000000UL)
#define EBI_BANK2	(EBI_BASE   + 0x10000000UL)
#define EBI_BANK3	(EBI_BASE   + 0x20000000UL)
#define EBI_BANK1_R_BASE	(EBI_R_BASE + 0x0000)
#define EBI_BANK1E_R_BASE	(EBI_R_BASE + 0x0104)
#define EBI_BANK2_3_R_BASE	(EBI_R_BASE + 0x0060)
#define EBI_BANK1_LCD_R_BASE	(EBI_R_BASE + 0X0200)

/* APB1 peripherals */
#define AD16C4T0	((TIMER_TypeDef *)AD16C4T0_BASE)
#define AD16C4T1	((TIMER_TypeDef *)AD16C4T1_BASE)
#define GP32C4T0	((TIMER_TypeDef *)GP32C4T0_BASE)
#define GP32C4T1	((TIMER_TypeDef *)GP32C4T1_BASE)
#define BS16T0		((TIMER_TypeDef *)BS16T0_BASE)
#define BS16T1		((TIMER_TypeDef *)BS16T1_BASE)
#define GP16C4T0	((TIMER_TypeDef *)GP16C4T0_BASE)
#define GP16C4T1	((TIMER_TypeDef *)GP16C4T1_BASE)
#define UART0		((UART_TypeDef *)UART0_BASE)
#define UART1		((UART_TypeDef *)UART1_BASE)
#define UART2		((UART_TypeDef *)UART2_BASE)
#define UART3		((UART_TypeDef *)UART3_BASE)
#define UART4		((UART_TypeDef *)UART4_BASE)
#define UART5		((UART_TypeDef *)UART5_BASE)
#define SPI0		((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define SPI1		((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)
#define SPI2		((SPI_I2S_TypeDef *)SPI2_I2S2_BASE)
#define I2S0		((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define I2S1		((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)
#define I2S2		((SPI_I2S_TypeDef *)SPI2_I2S2_BASE)
#define I2C0		((I2C_TypeDef *)I2C0_BASE)
#define I2C1		((I2C_TypeDef *)I2C1_BASE)
#define CAN0		((CAN_TypeDef *)CAN0_BASE)
#define DMA0		((DMA_TypeDef *)DMA0_BASE)
#define QSPI		((QSPI_TypeDef *)QSPI_BASE)

/* APB2 peripherals */
#define LPTIM0		((LPTIM_TypeDef *)LPTIM0_BASE)
#define LPUART0		((LPUART_TypeDef *)LPUART0_BASE)
#define ADC0		((ADC_TypeDef *)ADC0_BASE)
#define ADC1		((ADC_TypeDef *)ADC1_BASE)
#define ACMP0		((ACMP_TypeDef *)ACMP0_BASE)
#define ACMP1		((ACMP_TypeDef *)ACMP1_BASE)
#define ACMP2		((ACMP_TypeDef *)ACMP2_BASE)
#define OPAMP		((OPAMP_TypeDef *)OPAMP_BASE)
#define DAC0		((DAC_TypeDef *)DAC0_BASE)
#define WWDT		((WWDT_TypeDef *)WWDT_BASE)
#define IWDT		((IWDT_TypeDef *)IWDT_BASE)
#define LCD		((LCD_TypeDef *)LCD_BASE)
#define BKPC		((BKPC_TypeDef *)BKPC_BASE)
#define RTC		((RTC_TypeDef *)RTC_BASE)
#define TSENSE		((TSENSE_TypeDef *)TSENSE_BASE)
#define DBGC		((DBGC_TypeDef *)DBGC_BASE)

/* AHB peripherals */
#define SYSCFG		((SYSCFG_TypeDef *)SYSTEM_BASE)
#define CMU		((CMU_TypeDef *)CMU_BASE)
#define RMU		((RMU_TypeDef *)RMU_BASE)
#define PMU		((PMU_TypeDef *)PMU_BASE)
#define MSC		((MSC_TypeDef *)MSC_BASE)
#define GPIOA		((GPIO_TypeDef *)GPIOA_BASE)
#define GPIOB		((GPIO_TypeDef *)GPIOB_BASE)
#define GPIOC		((GPIO_TypeDef *)GPIOC_BASE)
#define GPIOD		((GPIO_TypeDef *)GPIOD_BASE)
#define GPIOE		((GPIO_TypeDef *)GPIOE_BASE)
#define GPIOF		((GPIO_TypeDef *)GPIOF_BASE)
#define GPIOG		((GPIO_TypeDef *)GPIOG_BASE)
#define GPIOH		((GPIO_TypeDef *)GPIOH_BASE)
#define EXTI		((EXTI_TypeDef *)EXTI_BASE)
#define CRC		((CRC_TypeDef  *)CRC_BASE)
#define CALC		((CALC_TypeDef *)CALC_BASE)
#define CRYPT		((CRYPT_TypeDef *)CRYPT_BASE)
#define TRNG		((TRNG_TypeDef *)TRNG_BASE)
#define PIS		((PIS_TypeDef *)PIS_BASE)
#define USB0		((USB_TypeDef *)USB0_BASE)
#define ECC		((ECC_TypeDef *)ECC_BASE)

/* EBI peripherals */
#define EBI_Bank1	((EBI_Bank1_TypeDef *)EBI_BANK1_R_BASE)
#define EBI_Bank1E	((EBI_Bank1E_TypeDef *)EBI_BANK1E_R_BASE)
#define EBI_Bank2_3	((EBI_Bank2_3_TypeDef *)EBI_BANK2_3_R_BASE)
#define EBI_Bank1_LCD	((EBI_Bank1_LCD_TypeDef *)EBI_BANK1_LCD_R_BASE)

#endif
