/**
  ******************************************************************************
  * @file      startup_es32f36xx.S
  * @author    AE Team
  * @brief     ES32F36xx devices vector table for GCC toolchain.
  *            This module performs:
  *                - Set the initial SP
  *                - Set the initial PC == Reset_Handler,
  *                - Set the vector table entries with the exceptions ISR address
  *                - Branches to main in the C library (which eventually
  *                  calls main()).
  *            After Reset the Cortex-M3 processor is in Thread mode,
  *            priority is Privileged, and the Stack is set to Main.
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          23 Sep. 2022    AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

.syntax unified
.cpu cortex-m3
.arch armv7-m
.fpu softvfp
.thumb

/*  Stack Configuration
Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
*/

.equ Stack_Size,  0x00000800

.section  .stack, "wa"
.align 3
.global Stack_Mem
.global Stack_Size
Stack_Mem:     
.if Stack_Size
.space   Stack_Size
.endif
.size    Stack_Mem,.-Stack_Mem
.set     Stack_Size,.-Stack_Mem
__init_sp:

/*
<h> Heap Configuration
<o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
</h>
*/

.equ     Heap_Size,       0x00000000

.section  .heap, "wa"
.align 3

.global Heap_Mem_Start
.global Heap_Mem_End
__heap_start:     
.if Heap_Size
.space   Heap_Size
.endif        
/* __heap_end__: */     


/* Vector Table Mapped to Address 0 at Reset*/
                                
.section  .vectors, "wax"
.global  __vector
.type  __vector, %object

.global __stack_end__

__vector: 
        /* .long     __stack_end__ */  /* Top of Stack*/
        .long     __init_sp  /* Top of Stack*/
        .long     Reset_Handler  /*Reset_Handler*/    
        .long     NMI_Handler  /* NMI IRQIRQHandler*/
        .long     HardFault_Handler         /* Hard Fault IRQIRQHandler*/
        .long     MemManage_Handler                           /* Reserved*/
        .long     BusFault_Handler                          /* Reserved*/
        .long     UsageFault_Handler                            /* Reserved*/
        .long     0                            /* Reserved*/
        .long     0                            /* Reserved*/
        .long     0                            /* Reserved*/
        .long     0                            /* Reserved*/
        .long     SVC_Handler               /* SVCall IRQIRQHandler*/
        .long     DebugMon_Handler                            /* Reserved*/
        .long     0                            /* Reserved*/
        .long     PendSV_Handler            /* PendSV IRQIRQHandler*/
        .long     SysTick_Handler           /* SysTick IRQIRQHandler*/


        /* External Interrupts*/
        .long     WWDG_Handler                    
        .long     IWDG_Handler                    
        .long     LVD_Handler                     
        .long     RTC_Handler                     
        .long     0                               
        .long     0                               
        .long     CMU_Handler                    
        .long     ADC0_Handler                    
        .long     CAN0_TX_Handler                 
        .long     CAN0_RX0_Handler                
        .long     CAN0_RX1_Handler                
        .long     CAN0_EXCEPTION_Handler         
        .long     AD16C4T0_BRK_Handler              
        .long     AD16C4T0_UP_Handler             
        .long     AD16C4T0_TRIG_COM_Handler        
        .long     AD16C4T0_CC_Handler             
        .long     AD16C4T1_BRK_Handler          
        .long     AD16C4T1_UP_Handler        
        .long     AD16C4T1_TRIG_COM_Handler    
        .long     AD16C4T1_CC_Handler            
        .long     GP32C4T0_Handler                 
        .long     GP32C4T1_Handler                 
        .long     BS16T0_Handler               
        .long     BS16T1_Handler              
        .long     GP16C4T0_Handler             
        .long     GP16C4T1_Handler              
        .long     0              
        .long     DAC0_CH0_Handler     
        .long     I2C0_EV_Handler           
        .long     I2C0_ERR_Handler           
        .long     I2C1_EV_Handler           
        .long     I2C1_ERR_Handler           
        .long     SPI0_I2S0_Handler      
        .long     SPI1_I2S1_Handler          
        .long     UART0_Handler       
        .long     UART1_Handler     
        .long     UART2_Handler         
        .long     UART3_Handler         
        .long     UART4_Handler          
        .long     UART5_Handler         
        .long     0           
        .long     0                         
        .long     CRYPT_Handler         
        .long     ACMP0_Handler       
        .long     ACMP1_Handler           
        .long     SPI2_I2S2_Handler             
        .long     0              
        .long     EBI_Handler             
        .long     TRNG_Handler          
        .long     TSENSE_Handler            
        .long     EXTI0_Handler                
        .long     EXTI1_Handler        
        .long     EXTI2_Handler             
        .long     EXTI3_Handler          
        .long     EXTI4_Handler               
        .long     EXTI5_Handler             
        .long     EXTI6_Handler                
        .long     EXTI7_Handler           
        .long     EXTI8_Handler        
        .long     EXTI9_Handler               
        .long     EXTI10_Handler               
        .long     EXTI11_Handler           
        .long     EXTI12_Handler           
        .long     EXTI13_Handler            
        .long     EXTI14_Handler       
        .long     EXTI15_Handler    
        .long     DMA_Handler      
        .long     ADC1_Handler       
        .long     DAC0_CH1_Handler 
        .long     QSPI_Handler           
        .long     USB_INT_Handler   
        .long     USB_DMA_Handler       
        .long     ACMP2_Handler        

       .size  __vector, .-__vector
        
.thumb
        .text
        .thumb_func
        .global  Reset_Handler
        .type Reset_Handler,%function
Reset_Handler:

        ldr r0, =0x55AA6996
        ldr r1, =0x40080000
        str r0, [r1]

        ldr r0, =0x5A962814
        ldr r1, =0x40080100
        str r0, [r1]
        ldr r0, =0xE7CB69A5
        str r0, [r1]

        ldr r0, =0x40083C00
        ldr r1, [r0]
        ldr r2, =0xffff
        and r1, r2
        ldr r2, =0x55AA0000
        orr r1, r2
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]
        str r1, [r0]

        mov r0, r0
        mov r0, r0

        ldr r0, =0x123456
        ldr r1, =0x40080100
        str r0, [r1]

        ldr r0, =0x40080404
        ldr r1, =0x4000000
        str r1, [r0]

        ldr r0, =0x123456
        ldr r1, =0x40080000
        str r0, [r1]

        .extern main
        .extern InitRam

        LDR		R0, =InitRam
        BLX		R0
        LDR     R0, =main
        BLX     R0
     
       .size  Reset_Handler, .-Reset_Handler

        .text
/* Dummy Exception IRQHandlers (infinite loops which can be modified)*/                
       
         .weak NMI_Handler
         .type NMI_Handler,%function
NMI_Handler:     
         B       .
         .size  NMI_Handler, .-NMI_Handler
        
         .weak  HardFault_Handler
         .type  HardFault_Handler,%function
HardFault_Handler:
         B .
         .size  HardFault_Handler, .-HardFault_Handler



         .weak  MemManage_Handler
         .type  MemManage_Handler,%function
MemManage_Handler:
         B .
         .size  MemManage_Handler, .-MemManage_Handler
        

         .weak  BusFault_Handler
         .type  BusFault_Handler,%function
BusFault_Handler:
         B .
         .size  BusFault_Handler, .-BusFault_Handler
            
         .weak  UsageFault_Handler
         .type  UsageFault_Handler,%function
UsageFault_Handler:
         B .
         .size  UsageFault_Handler, .-UsageFault_Handler
            
         .weak  DebugMon_Handler
         .type  DebugMon_Handler,%function
DebugMon_Handler:
         B .
         .size  DebugMon_Handler, .-DebugMon_Handler
        
        .weak SVC_Handler
        .type SVC_Handler,%function
SVC_Handler: 
        B       .
        .size  SVC_Handler, .-SVC_Handler
      
        .weak  PendSV_Handler
        .type  PendSV_Handler,%function
PendSV_Handler:
        B .
        .size  PendSV_Handler, .-PendSV_Handler
         
        .weak  SysTick_Handler
        .type  SysTick_Handler,%function
SysTick_Handler: 
        B .
        .size  SysTick_Handler, .-SysTick_Handler

        .global Default_IRQHandler
        .type  Default_IRQHandler,%function
Default_IRQHandler: 
        B       .
        .size  Default_IRQHandler, .-Default_IRQHandler
        .macro IRQ handler
        .weak \handler
        .set \handler,Default_IRQHandler 
        .endm
        
        IRQ     WWDG_Handler                    
        IRQ     IWDG_Handler                    
        IRQ     LVD_Handler                     
        IRQ     RTC_Handler
        IRQ     FLASH_Handler                            
        IRQ     CMU_Handler                    
        IRQ     ADC0_Handler                    
        IRQ     CAN0_TX_Handler                 
        IRQ     CAN0_RX0_Handler                
        IRQ     CAN0_RX1_Handler                
        IRQ     CAN0_EXCEPTION_Handler         
        IRQ     AD16C4T0_BRK_Handler
        IRQ     AD16C4T0_UP_Handler              
        IRQ     AD16C4T0_TRIG_COM_Handler             
        IRQ     AD16C4T0_CC_Handler        
        IRQ     AD16C4T1_BRK_Handler             
        IRQ     AD16C4T1_UP_Handler          
        IRQ     AD16C4T1_TRIG_COM_Handler        
        IRQ     AD16C4T1_CC_Handler    
        IRQ     GP32C4T0_Handler            
        IRQ     GP32C4T1_Handler                 
        IRQ     BS16T0_Handler                 
        IRQ     BS16T1_Handler               
        IRQ     GP16C4T0_Handler              
        IRQ     GP16C4T1_Handler             
        IRQ     DAC0_CH0_Handler              
        IRQ     I2C0_EV_Handler              
        IRQ     DAC0_CH0_Handler     
        IRQ     I2C0_EV_Handler           
        IRQ     I2C0_ERR_Handler           
        IRQ     I2C1_EV_Handler           
        IRQ     I2C1_ERR_Handler           
        IRQ     SPI0_I2S0_Handler      
        IRQ     SPI1_I2S1_Handler          
        IRQ     UART0_Handler       
        IRQ     UART1_Handler     
        IRQ     UART2_Handler         
        IRQ     UART3_Handler         
        IRQ     UART4_Handler          
        IRQ     UART5_Handler            
        IRQ     CRYPT_Handler         
        IRQ     ACMP0_Handler       
        IRQ     ACMP1_Handler           
        IRQ     SPI2_I2S2_Handler                           
        IRQ     EBI_Handler             
        IRQ     TRNG_Handler          
        IRQ     TSENSE_Handler            
        IRQ     EXTI0_Handler                
        IRQ     EXTI1_Handler        
        IRQ     EXTI2_Handler             
        IRQ     EXTI3_Handler          
        IRQ     EXTI4_Handler               
        IRQ     EXTI5_Handler             
        IRQ     EXTI6_Handler                
        IRQ     EXTI7_Handler           
        IRQ     EXTI8_Handler        
        IRQ     EXTI9_Handler               
        IRQ     EXTI10_Handler               
        IRQ     EXTI11_Handler           
        IRQ     EXTI12_Handler           
        IRQ     EXTI13_Handler            
        IRQ     EXTI14_Handler       
        IRQ     EXTI15_Handler    
        IRQ     DMA_Handler      
        IRQ     ADC1_Handler       
        IRQ     DAC0_CH1_Handler 
        IRQ     QSPI_Handler           
        IRQ     USB_INT_Handler   
        IRQ     USB_DMA_Handler       
        IRQ     ACMP2_Handler        

        .end
