        .syntax unified
        .cpu cortex-m3
        .arch armv7-m
        .fpu softvfp
        .thumb
 
/*  Stack Configuration
    Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
*/
       
        .equ Stack_Size,  0x00004000
 
        .section  .stack, "wa"
        .align 3
        .global Stack_Mem
        .global Stack_Size
Stack_Mem:     
        .if Stack_Size
        .space   Stack_Size
        .endif
        .size    Stack_Mem,.-Stack_Mem
        .set     Stack_Size,.-Stack_Mem
 
 
/*
 <h> Heap Configuration
   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
</h>
*/
 
        .equ     Heap_Size,       0x00001000
 
        .section  .heap, "wa"
        .align 3
 
        .global Heap_Mem_Start
        .global Heap_Mem_End
__heap_start:     
        .if Heap_Size
        .space   Heap_Size
        .endif        
__heap_end__:     
 
 
/* Vector Table Mapped to Address 0 at Reset*/
                                        
        .section  .vectors, "wax"
        .global  __vector
        .type  __vector, %object
        
		.global __stack_end__

__vector: 
                .long     __stack_end__  				  /* Top of Stack*/
                .long     Reset_Handler                   /*1,  reset handler*/
                .long     NMI_Handler                     /*2,  nmi handler*/
                .long     HardFault_Handler               /*3,  hard fault handler*/
                .long     MemManage_Handler               /*4,  MPU Fault Handler*/
                .long     BusFault_Handler                /*5,  Bus Fault Handler*/
                .long     UsageFault_Handler              /*6,  Usage Fault Handler*/
                .long     0                               /*7,  Reserved*/
                .long     0                               /*8,  Reserved*/
                .long     0                               /*9,  Reserved*/
                .long     0                               /*10, Reserved*/
                .long     SVC_Handler                     /*11, svcall handler*/
                .long     DebugMon_Handler                /*12, Debug Monitor Handler*/
                .long     0                               /*13, Reserved*/
                .long     PendSV_Handler                  /*14, pendsv handler*/
                .long     SysTick_Handler                 /*15, systick handler*/
                .long     WWDG_Handler                    /*16, irq0    WWDG handler*/
                .long     IWDG_Handler                    /*17, irq1    IWDG handler*/
                .long     LVD_Handler                     /*18, irq2    LVD handler*/
                .long     RTC_Handler                     /*19, irq3    RTC handler*/
                .long     FLASH_CACHE_Handler             /*20, irq4    FLASH CACHE handler*/
                .long     FLASH_ECC_Handler               /*21, irq5    FLASH ECC handler*/
                .long     CMU_Handler                     /*22, irq6    CMU handler*/
                .long     ADC0_Handler                    /*23, irq7    ADC0 handler*/
                .long     CAN0_TX_Handler                 /*24, irq8    CAN0_TX handler*/
                .long     CAN0_RX0_Handler                /*25, irq9    CAN0_RX0 handler*/
                .long     CAN0_RX1_Handler                /*26, irq10   CAN0_RX1 handler*/
                .long     CAN0_EXCEPTION_Handler          /*27, irq11   CAN0_EXCEPTION handler*/
                .long     AD16C4T0_BRK_Handler            /*28, irq12   AD16C4T0_BRK handler*/
                .long     AD16C4T0_UP_Handler             /*29, irq13   AD16C4T0_UP handler*/
                .long     AD16C4T0_TRIG_COM_Handler       /*30, irq14   AD16C4T0_TRIG_COM handler*/
                .long     AD16C4T0_CC_Handler             /*31, irq15   AD16C4T0_CC handler*/
                .long     0                               /*32, irq16   Reserved */
                .long     0                               /*33, irq17   Reserved */
                .long     0                               /*34, irq18   Reserved */
                .long     0                               /*35, irq19   Reserved */
                .long     GP32C4T0_Handler                /*36, irq20   GP32C4T0 handler*/
                .long     GP32C4T1_Handler                /*37, irq21   GP32C4T1 handler*/
                .long     BS16T0_Handler                  /*38, irq22   BS16T0 handler*/
                .long     BS16T1_Handler                  /*39, irq23   BS16T1 handler*/
                .long     GP16C4T0_Handler                /*40, irq24   GP16C4T0 handler*/
                .long     GP16C4T1_Handler                /*41, irq25   GP16C4T1 handler*/
                .long     LP16T0_Handler                  /*42, irq26   LP16T0 handler*/
                .long     DAC0_CH0_Handler                /*43, irq27   DAC0_CH0 handler*/
                .long     I2C0_EV_Handler                 /*44, irq28   I2C0_EV handler*/
                .long     I2C0_ERR_Handler                /*45, irq29   I2C0_ERR handler*/
                .long     I2C1_EV_Handler                 /*46, irq30   I2C1_EV handler*/
                .long     I2C1_ERR_Handler                /*47, irq31   I2C1_ERR handler*/
                .long     SPI0_I2S0_Handler               /*48, irq32   SPI0_I2S0 handler*/
                .long     SPI1_I2S1_Handler               /*49, irq33   SPI1_I2S1 handler*/
                .long     UART0_Handler                   /*50, irq34   UART0 handler*/
                .long     UART1_Handler                   /*51, irq35   UART1 handler*/
                .long     UART2_Handler                   /*52, irq36   UART2 handler*/
                .long     UART3_Handler                   /*53, irq37   UART3 handler*/
                .long     UART4_Handler                   /*54, irq38   UART4 handler*/
                .long     UART5_Handler                   /*55, irq39   UART5 handler*/
                .long     LPUART0_Handler                 /*56, irq40   LPUART0 handler*/
                .long     0                               /*57, irq41   Reserved*/
                .long     0                               /*58, irq42   Reserved*/
                .long     0                               /*59, irq43   Reserved*/
                .long     0                               /*60, irq44   Reserved*/
                .long     0                               /*61, irq45   Reserved*/
                .long     0                               /*62, irq46   Reserved*/
                .long     0                               /*63, irq47   Reserved*/
                .long     0                               /*64, irq48   Reserved*/
                .long     0                               /*65, irq49   Reserved*/
                .long     EXTI0_Handler                   /*66, irq50   EXTI0 handler*/
                .long     EXTI1_Handler                   /*67, irq51   EXTI1 handler*/
                .long     EXTI2_Handler                   /*68, irq52   EXTI2 handler*/
                .long     EXTI3_Handler                   /*69, irq53   EXTI3 handler*/
                .long     EXTI4_Handler                   /*70, irq54   EXTI4 handler*/
                .long     EXTI5_Handler                   /*71, irq55   EXTI5 handler*/
                .long     EXTI6_Handler                   /*72, irq56   EXTI6 handler*/
                .long     EXTI7_Handler                   /*73, irq57   EXTI7 handler*/
                .long     EXTI8_Handler                   /*74, irq58   EXTI8 handler*/
                .long     EXTI9_Handler                   /*75, irq59   EXTI9 handler*/
                .long     EXTI10_Handler                  /*76, irq60   EXTI10 handler*/
                .long     EXTI11_Handler                  /*77, irq61   EXTI11 handler*/
                .long     EXTI12_Handler                  /*78, irq62   EXTI12 handler*/
                .long     EXTI13_Handler                  /*79, irq63   EXTI13 handler*/
                .long     EXTI14_Handler                  /*80, irq64   EXTI14 handler*/
                .long     EXTI15_Handler                  /*81, irq65   EXTI15 handler*/
                .long     DMA0_Handler                    /*82, irq66   DMA0 handler*/
                .long     0                               /*83, irq67   Reserved*/
                .long     DAC0_CH1_Handler                /*84, irq68   DAC0_CH1 handler*/
                .long     0                               /*85, irq69   Reserved*/
                .long     0                               /*86, irq70   Reserved*/
                .long     0                               /*87, irq71   Reserved*/
                .long     0                               /*88, irq72   Reserved*/
                .long     0                               /*89, irq73   Reserved*/
                .long     DMA1_Handler                    /*90, irq74   DMA1 handler*/
                .long     0                               /*91, irq75   Reserved*/
 
               .size  __vector, .-__vector
                
.thumb
                .text
                .thumb_func
                .global  Reset_Handler
                .type Reset_Handler,%function
Reset_Handler:
           
                .extern main
                .extern InitRam

				LDR		R0, =InitRam
				BLX		R0
                LDR     R0, =main
                BLX     R0
             
               .size  Reset_Handler, .-Reset_Handler
 
                .text
/* Dummy Exception IRQHandlers (infinite loops which can be modified)*/                
               
                 .weak NMI_Handler
                 .type NMI_Handler,%function
NMI_Handler:     
                 B       .
                 .size  NMI_Handler, .-NMI_Handler
                
                 .weak  HardFault_Handler
                 .type  HardFault_Handler,%function
HardFault_Handler:
                 B .
                 .size  HardFault_Handler, .-HardFault_Handler
    
	
	
	             .weak  MemManage_Handler
                 .type  MemManage_Handler,%function
MemManage_Handler:
                 B .
                 .size  MemManage_Handler, .-MemManage_Handler
                
	
	             .weak  BusFault_Handler
                 .type  BusFault_Handler,%function
BusFault_Handler:
                 B .
                 .size  BusFault_Handler, .-BusFault_Handler
                	
	             .weak  UsageFault_Handler
                 .type  UsageFault_Handler,%function
UsageFault_Handler:
                 B .
                 .size  UsageFault_Handler, .-UsageFault_Handler
                	
	             .weak  DebugMon_Handler
                 .type  DebugMon_Handler,%function
DebugMon_Handler:
                 B .
                 .size  DebugMon_Handler, .-DebugMon_Handler
	            
                .weak SVC_Handler
                .type SVC_Handler,%function
SVC_Handler: 
                B       .
                .size  SVC_Handler, .-SVC_Handler
              
                .weak  PendSV_Handler
                .type  PendSV_Handler,%function
PendSV_Handler:
                B .
				.size  PendSV_Handler, .-PendSV_Handler
                 
                .weak  SysTick_Handler
                .type  SysTick_Handler,%function
SysTick_Handler: 
                B .
                .size  SysTick_Handler, .-SysTick_Handler
 
                .global Default_IRQHandler
                .type  Default_IRQHandler,%function
Default_IRQHandler: 
                B       .
                .size  Default_IRQHandler, .-Default_IRQHandler
                .macro IRQ handler
                .weak \handler
                .set \handler,Default_IRQHandler 
                .endm
                
                IRQ     WWDG_Handler                    
                IRQ     IWDG_Handler                    
                IRQ     LVD_Handler                     
                IRQ     RTC_Handler                     
                IRQ     FLASH_CACHE_Handler             
                IRQ     FLASH_ECC_Handler               
                IRQ     CMU_Handler                     
                IRQ     ADC0_Handler                    
                IRQ     CAN0_TX_Handler                 
                IRQ     CAN0_RX0_Handler                
                IRQ     CAN0_RX1_Handler                
                IRQ     CAN0_EXCEPTION_Handler          
                IRQ     AD16C4T0_BRK_Handler            
                IRQ     AD16C4T0_UP_Handler             
                IRQ     AD16C4T0_TRIG_COM_Handler       
                IRQ     AD16C4T0_CC_Handler             
                IRQ     GP32C4T0_Handler                
                IRQ     GP32C4T1_Handler                
                IRQ     BS16T0_Handler                  
                IRQ     BS16T1_Handler                  
                IRQ     GP16C4T0_Handler                
                IRQ     GP16C4T1_Handler                
                IRQ     LP16T0_Handler                  
                IRQ     DAC0_CH0_Handler                
                IRQ     I2C0_EV_Handler                 
                IRQ     I2C0_ERR_Handler                
                IRQ     I2C1_EV_Handler                 
                IRQ     I2C1_ERR_Handler                
                IRQ     SPI0_I2S0_Handler               
                IRQ     SPI1_I2S1_Handler               
                IRQ     UART0_Handler                  
                IRQ     UART1_Handler                   
                IRQ     UART2_Handler                   
                IRQ     UART3_Handler                   
                IRQ     UART4_Handler                   
                IRQ     UART5_Handler                   
                IRQ     LPUART0_Handler                 
                IRQ     EXTI0_Handler                   
                IRQ     EXTI1_Handler                   
                IRQ     EXTI2_Handler                   
                IRQ     EXTI3_Handler                   
                IRQ     EXTI4_Handler                  
                IRQ     EXTI5_Handler                   
                IRQ     EXTI6_Handler                   
                IRQ     EXTI7_Handler                   
                IRQ     EXTI8_Handler                   
                IRQ     EXTI9_Handler                   
                IRQ     EXTI10_Handler                  
                IRQ     EXTI11_Handler                  
                IRQ     EXTI12_Handler                  
                IRQ     EXTI13_Handler                  
                IRQ     EXTI14_Handler                  
                IRQ     EXTI15_Handler                  
                IRQ     DMA0_Handler                    
                IRQ     DAC0_CH1_Handler                
                IRQ     DMA1_Handler                    
 
				.end
