/**
  *********************************************************************************
  *
  * @file    es32f361x_362x.h
  * @brief   ES32F361x_362x Device Head File
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __ES32F36XX_H__
#define __ES32F36XX_H__

#define __I  volatile const  /* defines 'read only' permissions */
#define __O  volatile        /* defines 'write only' permissions */
#define __IO volatile        /* defines 'read / write' permissions */

#define  __CHECK_DEVICE_DEFINES
#define  __NVIC_PRIO_BITS       3U
#define  __CM3_REV              0x0200U
#define  __MPU_PRESENT          0x1
#define __Vendor_SysTickConfig  0U

typedef enum IRQn
{
    /* Cortex-M3 processor cxceptions index */
    Reset_IRQn        = -15,
    NMI_IRQn          = -14,
    HardFault_IRQn    = -13,
    MemManage_IRQn    = -12,
    BusFault_IRQn     = -11,
    UsageFault_IRQn   = -10,
    SVCall_IRQn       = -5,
    DebugMonitor_IRQn = -4,
    PendSV_IRQn       = -2,
    SysTick_IRQn      = -1,

    /* es32f361x/es32f362x specific interrupt index */
    WWDG_IRQn              = 0,
    IWDG_IRQn              = 1,
    LVD_IRQn               = 2,
    RTC_IRQn               = 3,
    FLASH_CACHE            = 4,
    FLASH_ECC              = 5,
    CMU_IRQn               = 6,
    ADC0_IRQn              = 7,
    CAN0_TX_IRQn           = 8,
    CAN0_RX0_IRQn          = 9,
    CAN0_RX1_IRQn          = 10,
    CAN0_EXCEPTION_IRQn    = 11,
    AD16C4T0_BRK_IRQn      = 12,
    AD16C4T0_UP_IRQn       = 13,
    AD16C4T0_TRIG_COM_IRQn = 14,
    AD16C4T0_CC_IRQn       = 15,
    GP32C4T0_IRQn          = 20,
    GP32C4T1_IRQn          = 21,
    BS16T0_IRQn            = 22,
    BS16T1_IRQn            = 23,
    GP16C4T0_IRQn          = 24,
    GP16C4T1_IRQn          = 25,
    LP16T0_IRQn            = 26,
    DAC0_CH0_IRQn          = 27,
    I2C0_EV_IRQn           = 28,
    I2C0_ERR_IRQn          = 29,
    I2C1_EV_IRQn           = 30,
    I2C1_ERR_IRQn          = 31,
    SPI0_I2S0_IRQn         = 32,
    SPI1_I2S1_IRQn         = 33,
    UART0_IRQn             = 34,
    UART1_IRQn             = 35,
    UART2_IRQn             = 36,
    UART3_IRQn             = 37,
    UART4_IRQn             = 38,
    UART5_IRQn             = 39,
    LPUART0_IRQn           = 40,
    EXTI0_IRQn             = 50,
    EXTI1_IRQn             = 51,
    EXTI2_IRQn             = 52,
    EXTI3_IRQn             = 53,
    EXTI4_IRQn             = 54,
    EXTI5_IRQn             = 55,
    EXTI6_IRQn             = 56,
    EXTI7_IRQn             = 57,
    EXTI8_IRQn             = 58,
    EXTI9_IRQn             = 59,
    EXTI10_IRQn            = 60,
    EXTI11_IRQn            = 61,
    EXTI12_IRQn            = 62,
    EXTI13_IRQn            = 63,
    EXTI14_IRQn            = 64,
    EXTI15_IRQn            = 65,
    DMA0_IRQn              = 66,
    DMA1_IRQn              = 74,
} IRQn_Type;


#include <stdint.h>
#include "core_cm3.h"

#if defined (__CC_ARM)
    #pragma anon_unions
#endif

/* Peripheral register define */

/****************** Bit definition for SYSCFG_PROT register ************************/

#define SYSCFG_PROT_KEY_POSS    1U
#define SYSCFG_PROT_KEY_POSE    31U
#define SYSCFG_PROT_KEY_MSK BITS(SYSCFG_PROT_KEY_POSS,SYSCFG_PROT_KEY_POSE)

#define SYSCFG_PROT_PROT_POS    0U
#define SYSCFG_PROT_PROT_MSK    BIT(SYSCFG_PROT_PROT_POS)

/****************** Bit definition for SYSCFG_MEMRMP register ************************/

#define SYSCFG_MEMRMP_BFRMPEN_POS   8U
#define SYSCFG_MEMRMP_BFRMPEN_MSK   BIT(SYSCFG_MEMRMP_BFRMPEN_POS)

#define SYSCFG_MEMRMP_BRMPEN_POS    0U
#define SYSCFG_MEMRMP_BRMPEN_MSK    BIT(SYSCFG_MEMRMP_BRMPEN_POS)

/****************** Bit definition for SYSCFG_TBKCFG register ************************/

#define SYSCFG_TBKCFG_SRAMBKE_POS   5U
#define SYSCFG_TBKCFG_SRAMBKE_MSK   BIT(SYSCFG_TBKCFG_SRAMBKE_POS)

#define SYSCFG_TBKCFG_EDC2BKE_POS   4U
#define SYSCFG_TBKCFG_EDC2BKE_MSK   BIT(SYSCFG_TBKCFG_EDC2BKE_POS)

#define SYSCFG_TBKCFG_EDC1BKE_POS   3U
#define SYSCFG_TBKCFG_EDC1BKE_MSK   BIT(SYSCFG_TBKCFG_EDC1BKE_POS)

#define SYSCFG_TBKCFG_CLUBKE_POS    2U
#define SYSCFG_TBKCFG_CLUBKE_MSK    BIT(SYSCFG_TBKCFG_CLUBKE_POS)

#define SYSCFG_TBKCFG_LVDBKE_POS    1U
#define SYSCFG_TBKCFG_LVDBKE_MSK    BIT(SYSCFG_TBKCFG_LVDBKE_POS)

#define SYSCFG_TBKCFG_CSSBKE_POS    0U
#define SYSCFG_TBKCFG_CSSBKE_MSK    BIT(SYSCFG_TBKCFG_CSSBKE_POS)

/****************** Bit definition for SYSCFG_TIMRMP0 register ************************/

#define SYSCFG_TIMRMP0_CH3N_RMP0_POSS   12U 
#define SYSCFG_TIMRMP0_CH3N_RMP0_POSE   13U 
#define SYSCFG_TIMRMP0_CH3N_RMP0_MSK    BITS(SYSCFG_TIMRMP0_CH3N_RMP0_POSS,SYSCFG_TIMRMP0_CH3N_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH2N_RMP0_POSS   10U 
#define SYSCFG_TIMRMP0_CH2N_RMP0_POSE   11U 
#define SYSCFG_TIMRMP0_CH2N_RMP0_MSK    BITS(SYSCFG_TIMRMP0_CH2N_RMP0_POSS,SYSCFG_TIMRMP0_CH2N_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH1N_RMP0_POSS   8U 
#define SYSCFG_TIMRMP0_CH1N_RMP0_POSE   9U 
#define SYSCFG_TIMRMP0_CH1N_RMP0_MSK    BITS(SYSCFG_TIMRMP0_CH1N_RMP0_POSS,SYSCFG_TIMRMP0_CH1N_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH4_RMP0_POSS    6U 
#define SYSCFG_TIMRMP0_CH4_RMP0_POSE    7U 
#define SYSCFG_TIMRMP0_CH4_RMP0_MSK BITS(SYSCFG_TIMRMP0_CH4_RMP0_POSS,SYSCFG_TIMRMP0_CH4_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH3_RMP0_POSS    4U 
#define SYSCFG_TIMRMP0_CH3_RMP0_POSE    5U 
#define SYSCFG_TIMRMP0_CH3_RMP0_MSK BITS(SYSCFG_TIMRMP0_CH3_RMP0_POSS,SYSCFG_TIMRMP0_CH3_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH2_RMP0_POSS    2U 
#define SYSCFG_TIMRMP0_CH2_RMP0_POSE    3U 
#define SYSCFG_TIMRMP0_CH2_RMP0_MSK BITS(SYSCFG_TIMRMP0_CH2_RMP0_POSS,SYSCFG_TIMRMP0_CH2_RMP0_POSE)
    
#define SYSCFG_TIMRMP0_CH1_RMP0_POSS    0U 
#define SYSCFG_TIMRMP0_CH1_RMP0_POSE    1U 
#define SYSCFG_TIMRMP0_CH1_RMP0_MSK BITS(SYSCFG_TIMRMP0_CH1_RMP0_POSS,SYSCFG_TIMRMP0_CH1_RMP0_POSE)
    
/****** *********** Bit definition for SYSCFG_TIMRMP1 register ************************/
    
#define SYSCFG_TIMRMP1_MIRROR_POS   31U 
#define SYSCFG_TIMRMP1_MIRROR_MSK   BIT(SYSCFG_TIMRMP1_MIRROR_POS)
    
#define SYSCFG_TIMRMP1_CH4_RMP1_POSS    22U 
#define SYSCFG_TIMRMP1_CH4_RMP1_POSE    23U 
#define SYSCFG_TIMRMP1_CH4_RMP1_MSK BITS(SYSCFG_TIMRMP1_CH4_RMP1_POSS,SYSCFG_TIMRMP1_CH4_RMP1_POSE)
    
#define SYSCFG_TIMRMP1_CH3_RMP1_POSS    20U 
#define SYSCFG_TIMRMP1_CH3_RMP1_POSE    21U 
#define SYSCFG_TIMRMP1_CH3_RMP1_MSK BITS(SYSCFG_TIMRMP1_CH3_RMP1_POSS,SYSCFG_TIMRMP1_CH3_RMP1_POSE)
    
#define SYSCFG_TIMRMP1_CH2_RMP1_POSS    18U 
#define SYSCFG_TIMRMP1_CH2_RMP1_POSE    19U 
#define SYSCFG_TIMRMP1_CH2_RMP1_MSK BITS(SYSCFG_TIMRMP1_CH2_RMP1_POSS,SYSCFG_TIMRMP1_CH2_RMP1_POSE)
    
#define SYSCFG_TIMRMP1_CH1_RMP1_POSS    16U 
#define SYSCFG_TIMRMP1_CH1_RMP1_POSE    17U 
#define SYSCFG_TIMRMP1_CH1_RMP1_MSK BITS(SYSCFG_TIMRMP1_CH1_RMP1_POSS,SYSCFG_TIMRMP1_CH1_RMP1_POSE)
    
#define SYSCFG_TIMRMP1_CH4_RMP0_POSS    6U 
#define SYSCFG_TIMRMP1_CH4_RMP0_POSE    7U 
#define SYSCFG_TIMRMP1_CH4_RMP0_MSK BITS(SYSCFG_TIMRMP1_CH4_RMP0_POSS,SYSCFG_TIMRMP1_CH4_RMP0_POSE)
    
#define SYSCFG_TIMRMP1_CH3_RMP0_POSS    4U 
#define SYSCFG_TIMRMP1_CH3_RMP0_POSE    5U 
#define SYSCFG_TIMRMP1_CH3_RMP0_MSK BITS(SYSCFG_TIMRMP1_CH3_RMP0_POSS,SYSCFG_TIMRMP1_CH3_RMP0_POSE)
    
#define SYSCFG_TIMRMP1_CH2_RMP0_POSS    2U 
#define SYSCFG_TIMRMP1_CH2_RMP0_POSE    3U 
#define SYSCFG_TIMRMP1_CH2_RMP0_MSK BITS(SYSCFG_TIMRMP1_CH2_RMP0_POSS,SYSCFG_TIMRMP1_CH2_RMP0_POSE)
    
#define SYSCFG_TIMRMP1_CH1_RMP0_POSS    0U 
#define SYSCFG_TIMRMP1_CH1_RMP0_POSE    1U 
#define SYSCFG_TIMRMP1_CH1_RMP0_MSK BITS(SYSCFG_TIMRMP1_CH1_RMP0_POSS,SYSCFG_TIMRMP1_CH1_RMP0_POSE)


typedef struct
{
    __IO uint32_t PROT;
    __IO uint32_t MEMRMP;
    uint32_t RESERVED0[2] ;
    __IO uint32_t TBKCFG;
    uint32_t RESERVED1[3] ;
    __IO uint32_t TIMRMP0;
    __IO uint32_t TIMRMP1;
} SYSCFG_TypeDef;

/****************** Bit definition for MSC_FLASHKEY register ************************/

#define MSC_FLASHKEY_STATUS_POSS    0U
#define MSC_FLASHKEY_STATUS_POSE    1U
#define MSC_FLASHKEY_STATUS_MSK BITS(MSC_FLASHKEY_STATUS_POSS,MSC_FLASHKEY_STATUS_POSE)

/****************** Bit definition for MSC_INFOKEY register ************************/

#define MSC_INFOKEY_STATUS_POSS 0U
#define MSC_INFOKEY_STATUS_POSE 1U
#define MSC_INFOKEY_STATUS_MSK  BITS(MSC_INFOKEY_STATUS_POSS,MSC_INFOKEY_STATUS_POSE)

/****************** Bit definition for MSC_FLASHADDR register ************************/

#define MSC_FLASHADDR_IFREN_POS 19U
#define MSC_FLASHADDR_IFREN_MSK BIT(MSC_FLASHADDR_IFREN_POS)

#define MSC_FLASHADDR_ADDR_POSS 0U
#define MSC_FLASHADDR_ADDR_POSE 18U
#define MSC_FLASHADDR_ADDR_MSK  BITS(MSC_FLASHADDR_ADDR_POSS,MSC_FLASHADDR_ADDR_POSE)

/****************** Bit definition for MSC_FLASHFIFO register ************************/

#define MSC_FLASHFIFO_FIFO_POSS 0U
#define MSC_FLASHFIFO_FIFO_POSE 31U
#define MSC_FLASHFIFO_FIFO_MSK  BITS(MSC_FLASHFIFO_FIFO_POSS,MSC_FLASHFIFO_FIFO_POSE)

/****************** Bit definition for MSC_FLASHDR register ************************/

#define MSC_FLASHDR_DATA_POSS  0U
#define MSC_FLASHDR_DATA_POSE  31U
#define MSC_FLASHDR_DATA_MSK   BITS(MSC_FLASHDR_DATA_POSS,MSC_FLASHDR_DATA_POSE)

/****************** Bit definition for MSC_FLASHCMD register ************************/

#define MSC_FLASHCMD_CMD_POSS   0U
#define MSC_FLASHCMD_CMD_POSE   31U
#define MSC_FLASHCMD_CMD_MSK    BITS(MSC_FLASHCMD_CMD_POSS,MSC_FLASHCMD_CMD_POSE)

/****************** Bit definition for MSC_FLASHCR register ************************/

#define MSC_FLASHCR_PGSZ_POS    8U 
#define MSC_FLASHCR_PGSZ_MSK    BIT(MSC_FLASHCR_PGSZ_POS)
    
#define MSC_FLASHCR_FIFODFS_POS 7U 
#define MSC_FLASHCR_FIFODFS_MSK BIT(MSC_FLASHCR_FIFODFS_POS)
    
#define MSC_FLASHCR_FIFOFP_POS  6U 
#define MSC_FLASHCR_FIFOFP_MSK  BIT(MSC_FLASHCR_FIFOFP_POS)

#define MSC_FLASHCR_FIFOEN_POS  5U
#define MSC_FLASHCR_FIFOEN_MSK  BIT(MSC_FLASHCR_FIFOEN_POS)

#define MSC_FLASHCR_FLASHREQ_POS    4U
#define MSC_FLASHCR_FLASHREQ_MSK    BIT(MSC_FLASHCR_FLASHREQ_POS)

#define MSC_FLASHCR_IAPRST_POS  1U
#define MSC_FLASHCR_IAPRST_MSK  BIT(MSC_FLASHCR_IAPRST_POS)

#define MSC_FLASHCR_IAPEN_POS   0U
#define MSC_FLASHCR_IAPEN_MSK   BIT(MSC_FLASHCR_IAPEN_POS)

/****************** Bit definition for MSC_FLASHSR register ************************/

#define MSC_FLASHSR_ADERR_POS   31U 
#define MSC_FLASHSR_ADERR_MSK   BIT(MSC_FLASHSR_ADERR_POS)

#define MSC_FLASHSR_MEPRT_POS   30U 
#define MSC_FLASHSR_MEPRT_MSK   BIT(MSC_FLASHSR_MEPRT_POS)

#define MSC_FLASHSR_SEPRT_POS   29U 
#define MSC_FLASHSR_SEPRT_MSK   BIT(MSC_FLASHSR_SEPRT_POS)

#define MSC_FLASHSR_PGPRT_POS   28U 
#define MSC_FLASHSR_PGPRT_MSK   BIT(MSC_FLASHSR_PGPRT_POS)

#define MSC_FLASHSR_AERA_POS    27U 
#define MSC_FLASHSR_AERA_MSK    BIT(MSC_FLASHSR_AERA_POS)

#define MSC_FLASHSR_DAFLS_POS   26U 
#define MSC_FLASHSR_DAFLS_MSK   BIT(MSC_FLASHSR_DAFLS_POS)

#define MSC_FLASHSR_MERF_POS    25U 
#define MSC_FLASHSR_MERF_MSK    BIT(MSC_FLASHSR_MERF_POS)

#define MSC_FLASHSR_FERF_POS    24U 
#define MSC_FLASHSR_FERF_MSK    BIT(MSC_FLASHSR_FERF_POS)
        
#define MSC_FLASHSR_FEEND_POS   17U 
#define MSC_FLASHSR_FEEND_MSK   BIT(MSC_FLASHSR_FEEND_POS)
    
#define MSC_FLASHSR_FEBUSY_POS  16U 
#define MSC_FLASHSR_FEBUSY_MSK  BIT(MSC_FLASHSR_FEBUSY_POS)

#define MSC_FLASHSR_TIMEOUT_POS 7U
#define MSC_FLASHSR_TIMEOUT_MSK BIT(MSC_FLASHSR_TIMEOUT_POS)

#define MSC_FLASHSR_PROG_POS    6U
#define MSC_FLASHSR_PROG_MSK    BIT(MSC_FLASHSR_PROG_POS)

#define MSC_FLASHSR_SERA_POS    5U
#define MSC_FLASHSR_SERA_MSK    BIT(MSC_FLASHSR_SERA_POS)

#define MSC_FLASHSR_MASE_POS    4U
#define MSC_FLASHSR_MASE_MSK    BIT(MSC_FLASHSR_MASE_POS)

#define MSC_FLASHSR_WAE_POS 3U 
#define MSC_FLASHSR_WAE_MSK BIT(MSC_FLASHSR_WAE_POS)
    
#define MSC_FLASHSR_WPE_POS 2U 
#define MSC_FLASHSR_WPE_MSK BIT(MSC_FLASHSR_WPE_POS)

#define MSC_FLASHSR_BUSY_POS    1U
#define MSC_FLASHSR_BUSY_MSK    BIT(MSC_FLASHSR_BUSY_POS)

#define MSC_FLASHSR_FLASHACK_POS    0U
#define MSC_FLASHSR_FLASHACK_MSK    BIT(MSC_FLASHSR_FLASHACK_POS)

/****************** Bit definition for MSC_MEMWAIT register ************************/

#define MSC_MEMWAIT_SRAM_W_POSS 8U
#define MSC_MEMWAIT_SRAM_W_POSE 9U
#define MSC_MEMWAIT_SRAM_W_MSK  BITS(MSC_MEMWAIT_SRAM_W_POSS,MSC_MEMWAIT_SRAM_W_POSE)

#define MSC_MEMWAIT_PRFEN_POS   6U 
#define MSC_MEMWAIT_PRFEN_MSK   BIT(MSC_MEMWAIT_PRFEN_POS)
    
#define MSC_MEMWAIT_BRCBEN_POS  5U 
#define MSC_MEMWAIT_BRCBEN_MSK  BIT(MSC_MEMWAIT_BRCBEN_POS)

#define MSC_MEMWAIT_FLASH_W_POSS    0U
#define MSC_MEMWAIT_FLASH_W_POSE    3U
#define MSC_MEMWAIT_FLASH_W_MSK BITS(MSC_MEMWAIT_FLASH_W_POSS,MSC_MEMWAIT_FLASH_W_POSE)

/****************** Bit definition for MSC_FECCR register ************************/

#define MSC_FECCR_NMIFW3_POS    15U 
#define MSC_FECCR_NMIFW3_MSK    BIT(MSC_FECCR_NMIFW3_POS)
        
#define MSC_FECCR_NMIFW2_POS    14U 
#define MSC_FECCR_NMIFW2_MSK    BIT(MSC_FECCR_NMIFW2_POS)
        
#define MSC_FECCR_NMIFW1_POS    13U 
#define MSC_FECCR_NMIFW1_MSK    BIT(MSC_FECCR_NMIFW1_POS)
        
#define MSC_FECCR_NMIFW0_POS    12U 
#define MSC_FECCR_NMIFW0_MSK    BIT(MSC_FECCR_NMIFW0_POS)
    
#define MSC_FECCR_IFW3_POS  11U 
#define MSC_FECCR_IFW3_MSK  BIT(MSC_FECCR_IFW3_POS)
    
#define MSC_FECCR_IFW2_POS  10U 
#define MSC_FECCR_IFW2_MSK  BIT(MSC_FECCR_IFW2_POS)
        
#define MSC_FECCR_IFW1_POS  9U 
#define MSC_FECCR_IFW1_MSK  BIT(MSC_FECCR_IFW1_POS)
        
#define MSC_FECCR_IFW0_POS  8U 
#define MSC_FECCR_IFW0_MSK  BIT(MSC_FECCR_IFW0_POS)
    
#define MSC_FECCR_NMIFC_POS 7U 
#define MSC_FECCR_NMIFC_MSK BIT(MSC_FECCR_NMIFC_POS)
    
#define MSC_FECCR_IFC_POS   6U 
#define MSC_FECCR_IFC_MSK   BIT(MSC_FECCR_IFC_POS)
    
#define MSC_FECCR_NMIE_POS  5U 
#define MSC_FECCR_NMIE_MSK  BIT(MSC_FECCR_NMIE_POS)

#define MSC_FECCR_IE_POS    4U 
#define MSC_FECCR_IE_MSK    BIT(MSC_FECCR_IE_POS)
    
#define MSC_FECCR_ECEN_POS  0U 
#define MSC_FECCR_ECEN_MSK  BIT(MSC_FECCR_ECEN_POS)

/****************** Bit definition for MSC_FECSR register ************************/

#define MSC_FECSR_IFRS_POS  19U 
#define MSC_FECSR_IFRS_MSK  BIT(MSC_FECSR_IFRS_POS)
    
#define MSC_FECSR_ADDR_POSS 0U 
#define MSC_FECSR_ADDR_POSE 18U 
#define MSC_FECSR_ADDR_MSK  BITS(MSC_FECSR_ADDR_POSS,MSC_FECSR_ADDR_POSE)

/****************** Bit definition for MSC_RPCSR register ************************/

#define MSC_RPCSR_NMIF_POS  3U 
#define MSC_RPCSR_NMIF_MSK  BIT(MSC_RPCSR_NMIF_POS)
    
#define MSC_RPCSR_NMIFC_POS 2U 
#define MSC_RPCSR_NMIFC_MSK BIT(MSC_RPCSR_NMIFC_POS)
    
#define MSC_RPCSR_NMIE_POS  1U 
#define MSC_RPCSR_NMIE_MSK  BIT(MSC_RPCSR_NMIE_POS)
    
#define MSC_RPCSR_PEN_POS   0U 
#define MSC_RPCSR_PEN_MSK   BIT(MSC_RPCSR_PEN_POS)

typedef struct
{
    __IO uint32_t FLASHKEY;
    __IO uint32_t INFOKEY;
    __IO uint32_t FLASHADDR;
    __O  uint32_t FLASHFIFO;
    __IO uint32_t FLASHDR;
         uint32_t RESERVED0;
    __O  uint32_t FLASHCMD;
    __IO uint32_t FLASHCR;
    __I  uint32_t FLASHSR;
         uint32_t RESERVED1;
    __IO uint32_t MEMWAIT;
    __IO uint32_t FECCR;
    __I uint32_t FECSR;
    __IO uint32_t RPCSR;
} MSC_TypeDef;

/****************** Bit definition for PMU_CR register ************************/

#define PMU_CR_STOPFM_POSS  22U
#define PMU_CR_STOPFM_POSE  23U
#define PMU_CR_STOPFM_MSK   BITS(PMU_CR_STOPFM_POSS,PMU_CR_STOPFM_POSE)

#define PMU_CR_LPSTOP_POS   20U
#define PMU_CR_LPSTOP_MSK   BIT(PMU_CR_LPSTOP_POS)

#define PMU_CR_LPRUN_POS    19U
#define PMU_CR_LPRUN_MSK    BIT(PMU_CR_LPRUN_POS)

#define PMU_CR_LPCLKDIS_POS 18U
#define PMU_CR_LPCLKDIS_MSK BIT(PMU_CR_LPCLKDIS_POS)

#define PMU_CR_LPOPSEL_POSS 16U
#define PMU_CR_LPOPSEL_POSE 17U
#define PMU_CR_LPOPSEL_MSK  BITS(PMU_CR_LPOPSEL_POSS,PMU_CR_LPOPSEL_POSE)

#define PMU_CR_CSHUTOFFF_POS    4U
#define PMU_CR_CSHUTOFFF_MSK    BIT(PMU_CR_CSHUTOFFF_POS)

#define PMU_CR_CSTANDBYF_POS    3U
#define PMU_CR_CSTANDBYF_MSK    BIT(PMU_CR_CSTANDBYF_POS)

#define PMU_CR_CWUF_POS 2U
#define PMU_CR_CWUF_MSK BIT(PMU_CR_CWUF_POS)

#define PMU_CR_LPM_POSS 0U
#define PMU_CR_LPM_POSE 1U
#define PMU_CR_LPM_MSK  BITS(PMU_CR_LPM_POSS,PMU_CR_LPM_POSE)

/****************** Bit definition for PMU_SR register ************************/

#define PMU_SR_SHUTOFFF_POS 2U
#define PMU_SR_SHUTOFFF_MSK BIT(PMU_SR_SHUTOFFF_POS)

#define PMU_SR_STANDBYF_POS 1U
#define PMU_SR_STANDBYF_MSK BIT(PMU_SR_STANDBYF_POS)

#define PMU_SR_WUF_POS  0U
#define PMU_SR_WUF_MSK  BIT(PMU_SR_WUF_POS)

/****************** Bit definition for PMU_LVDCR register ************************/

#define PMU_LVDCR_LVDO_POS  15U
#define PMU_LVDCR_LVDO_MSK  BIT(PMU_LVDCR_LVDO_POS)

#define PMU_LVDCR_LVDFLT_POS    11U
#define PMU_LVDCR_LVDFLT_MSK    BIT(PMU_LVDCR_LVDFLT_POS)

#define PMU_LVDCR_LVDIFS_POSS   8U
#define PMU_LVDCR_LVDIFS_POSE   10U
#define PMU_LVDCR_LVDIFS_MSK    BITS(PMU_LVDCR_LVDIFS_POSS,PMU_LVDCR_LVDIFS_POSE)

#define PMU_LVDCR_LVDS_POSS 4U
#define PMU_LVDCR_LVDS_POSE 6U
#define PMU_LVDCR_LVDS_MSK  BITS(PMU_LVDCR_LVDS_POSS,PMU_LVDCR_LVDS_POSE)

#define PMU_LVDCR_LVDCIF_POS    3U
#define PMU_LVDCR_LVDCIF_MSK    BIT(PMU_LVDCR_LVDCIF_POS)

#define PMU_LVDCR_LVDIF_POS 2U
#define PMU_LVDCR_LVDIF_MSK BIT(PMU_LVDCR_LVDIF_POS)

#define PMU_LVDCR_LVDIE_POS 1U
#define PMU_LVDCR_LVDIE_MSK BIT(PMU_LVDCR_LVDIE_POS)

#define PMU_LVDCR_LVDEN_POS 0U
#define PMU_LVDCR_LVDEN_MSK BIT(PMU_LVDCR_LVDEN_POS)

/****************** Bit definition for PMU_PWRCR register ************************/

#define PMU_PWRCR_ROM_POS   26U
#define PMU_PWRCR_ROM_MSK   BIT(PMU_PWRCR_ROM_POS)

#define PMU_PWRCR_BXCAN0_POS    16U
#define PMU_PWRCR_BXCAN0_MSK    BIT(PMU_PWRCR_BXCAN0_POS)

#define PMU_PWRCR_SRAM_POSS 0U
#define PMU_PWRCR_SRAM_POSE 3U
#define PMU_PWRCR_SRAM_MSK  BITS(PMU_PWRCR_SRAM_POSS,PMU_PWRCR_SRAM_POSE)

/****************** Bit definition for PMU_BKPCR0 register ************************/

#define PMU_BKPCR0_STBWKEN_POS  5U
#define PMU_BKPCR0_STBWKEN_MSK  BIT(PMU_BKPCR0_STBWKEN_POS)

#define PMU_BKPCR0_WKPL_POS 4U
#define PMU_BKPCR0_WKPL_MSK BIT(PMU_BKPCR0_WKPL_POS)

#define PMU_BKPCR0_WKPS_POSS    1U
#define PMU_BKPCR0_WKPS_POSE    3U
#define PMU_BKPCR0_WKPS_MSK BITS(PMU_BKPCR0_WKPS_POSS,PMU_BKPCR0_WKPS_POSE)

#define PMU_BKPCR0_WKPEN_POS    0U
#define PMU_BKPCR0_WKPEN_MSK    BIT(PMU_BKPCR0_WKPEN_POS)

/****************** Bit definition for PMU_BKPCR1 register ************************/

#define PMU_BKPCR1_BKRAMRET_POS 4U
#define PMU_BKPCR1_BKRAMRET_MSK BIT(PMU_BKPCR1_BKRAMRET_POS)

#define PMU_BKPCR1_BKRAMPWR_POS 3U
#define PMU_BKPCR1_BKRAMPWR_MSK BIT(PMU_BKPCR1_BKRAMPWR_POS)

#define PMU_BKPCR1_STBLPVS_POSS 0U
#define PMU_BKPCR1_STBLPVS_POSE 1U
#define PMU_BKPCR1_STBLPVS_MSK  BITS(PMU_BKPCR1_STBLPVS_POSS,PMU_BKPCR1_STBLPVS_POSE)

/****************** Bit definition for PMU_BKPSR register ************************/

#define PMU_BKPSR_RTC_POS   5U
#define PMU_BKPSR_RTC_MSK   BIT(PMU_BKPSR_RTC_POS)

#define PMU_BKPSR_WKP_POS   4U
#define PMU_BKPSR_WKP_MSK   BIT(PMU_BKPSR_WKP_POS)

typedef struct
{
    __IO uint32_t CR;
    __I uint32_t SR;
    __IO uint32_t LVDCR;
    __IO uint32_t PWRCR;
    __IO uint32_t Reserved[12];
    __IO uint32_t BKPCR0;
    __IO uint32_t BKPCR1;
    __IO uint32_t BKPSR;
} PMU_TypeDef;

/****************** Bit definition for RMU_CSR register ************************/
#define RMU_CSR_BORVS_POSS  4U
#define RMU_CSR_BORVS_POSE  6U
#define RMU_CSR_BORVS_MSK   BITS(RMU_CSR_BORVS_POSS,RMU_CSR_BORVS_POSE)

#define RMU_CSR_BORFLT_POSS 1U
#define RMU_CSR_BORFLT_POSE 3U
#define RMU_CSR_BORFLT_MSK  BITS(RMU_CSR_BORFLT_POSS,RMU_CSR_BORFLT_POSE)

#define RMU_CSR_BOREN_POS   0U
#define RMU_CSR_BOREN_MSK   BIT(RMU_CSR_BOREN_POS)

/****************** Bit definition for RMU_RSTSR register ************************/

#define RMU_RSTSR_CFGERR_POS    16U
#define RMU_RSTSR_CFGERR_MSK    BIT(RMU_RSTSR_CFGERR_POS)

#define RMU_RSTSR_CFG_POS   10U
#define RMU_RSTSR_CFG_MSK   BIT(RMU_RSTSR_CFG_POS)

#define RMU_RSTSR_CPU_POS   9U
#define RMU_RSTSR_CPU_MSK   BIT(RMU_RSTSR_CPU_POS)

#define RMU_RSTSR_MCU_POS   8U
#define RMU_RSTSR_MCU_MSK   BIT(RMU_RSTSR_MCU_POS)

#define RMU_RSTSR_CHIP_POS  7U
#define RMU_RSTSR_CHIP_MSK  BIT(RMU_RSTSR_CHIP_POS)

#define RMU_RSTSR_LOCKUP_POS    6U
#define RMU_RSTSR_LOCKUP_MSK    BIT(RMU_RSTSR_LOCKUP_POS)

#define RMU_RSTSR_WWDT_POS  5U
#define RMU_RSTSR_WWDT_MSK  BIT(RMU_RSTSR_WWDT_POS)

#define RMU_RSTSR_IWDT_POS  4U
#define RMU_RSTSR_IWDT_MSK  BIT(RMU_RSTSR_IWDT_POS)

#define RMU_RSTSR_NMRST_POS 3U
#define RMU_RSTSR_NMRST_MSK BIT(RMU_RSTSR_NMRST_POS)

#define RMU_RSTSR_BOR_POS   2U
#define RMU_RSTSR_BOR_MSK   BIT(RMU_RSTSR_BOR_POS)

#define RMU_RSTSR_WAKEUP_POS    1U
#define RMU_RSTSR_WAKEUP_MSK    BIT(RMU_RSTSR_WAKEUP_POS)

#define RMU_RSTSR_POR_POS   0U
#define RMU_RSTSR_POR_MSK   BIT(RMU_RSTSR_POR_POS)

/****************** Bit definition for RMU_CRSTSR register ************************/

#define RMU_CRSTSR_CFG_POS  10U
#define RMU_CRSTSR_CFG_MSK  BIT(RMU_CRSTSR_CFG_POS)

#define RMU_CRSTSR_CPU_POS  9U
#define RMU_CRSTSR_CPU_MSK  BIT(RMU_CRSTSR_CPU_POS)

#define RMU_CRSTSR_MCU_POS  8U
#define RMU_CRSTSR_MCU_MSK  BIT(RMU_CRSTSR_MCU_POS)

#define RMU_CRSTSR_CHIP_POS 7U
#define RMU_CRSTSR_CHIP_MSK BIT(RMU_CRSTSR_CHIP_POS)

#define RMU_CRSTSR_LOCKUP_POS   6U
#define RMU_CRSTSR_LOCKUP_MSK   BIT(RMU_CRSTSR_LOCKUP_POS)

#define RMU_CRSTSR_WWDT_POS 5U
#define RMU_CRSTSR_WWDT_MSK BIT(RMU_CRSTSR_WWDT_POS)

#define RMU_CRSTSR_IWDT_POS 4U
#define RMU_CRSTSR_IWDT_MSK BIT(RMU_CRSTSR_IWDT_POS)

#define RMU_CRSTSR_NMRST_POS    3U
#define RMU_CRSTSR_NMRST_MSK    BIT(RMU_CRSTSR_NMRST_POS)

#define RMU_CRSTSR_BOR_POS  2U
#define RMU_CRSTSR_BOR_MSK  BIT(RMU_CRSTSR_BOR_POS)

#define RMU_CRSTSR_WAKEUP_POS   1U
#define RMU_CRSTSR_WAKEUP_MSK   BIT(RMU_CRSTSR_WAKEUP_POS)

#define RMU_CRSTSR_POR_POS  0U
#define RMU_CRSTSR_POR_MSK  BIT(RMU_CRSTSR_POR_POS)

/****************** Bit definition for RMU_AHB1RSTR register ************************/
#define RMU_AHB1RSTR_PISRST_POS 5U
#define RMU_AHB1RSTR_PISRST_MSK BIT(RMU_AHB1RSTR_PISRST_POS)

#define RMU_AHB1RSTR_CALCRST_POS    2U
#define RMU_AHB1RSTR_CALCRST_MSK    BIT(RMU_AHB1RSTR_CALCRST_POS)

#define RMU_AHB1RSTR_CRCRST_POS 1U
#define RMU_AHB1RSTR_CRCRST_MSK BIT(RMU_AHB1RSTR_CRCRST_POS)

#define RMU_AHB1RSTR_GPIORST_POS    0U
#define RMU_AHB1RSTR_GPIORST_MSK    BIT(RMU_AHB1RSTR_GPIORST_POS)

/****************** Bit definition for RMU_AHB2RSTR register ************************/
#define RMU_AHB2RSTR_DMAMUX_POS 4U
#define RMU_AHB2RSTR_DMAMUX_MSK BIT(RMU_AHB2RSTR_DMAMUX_POS)

#define RMU_AHB2RSTR_DMA1RST_POS    3U
#define RMU_AHB2RSTR_DMA1RST_MSK    BIT(RMU_AHB2RSTR_DMA1RST_POS)

#define RMU_AHB2RSTR_DMA0RST_POS    2U
#define RMU_AHB2RSTR_DMA0RST_MSK    BIT(RMU_AHB2RSTR_DMA0RST_POS)

#define RMU_AHB2RSTR_CPURST_POS 1U
#define RMU_AHB2RSTR_CPURST_MSK BIT(RMU_AHB2RSTR_CPURST_POS)

#define RMU_AHB2RSTR_CHIPRST_POS    0U
#define RMU_AHB2RSTR_CHIPRST_MSK    BIT(RMU_AHB2RSTR_CHIPRST_POS)

/****************** Bit definition for RMU_APB1RSTR register ************************/
#define RMU_APB1RSTR_CAN0RST_POS    24U
#define RMU_APB1RSTR_CAN0RST_MSK    BIT(RMU_APB1RSTR_CAN0RST_POS)

#define RMU_APB1RSTR_I2C1RST_POS    21U
#define RMU_APB1RSTR_I2C1RST_MSK    BIT(RMU_APB1RSTR_I2C1RST_POS)

#define RMU_APB1RSTR_I2C0RST_POS    20U
#define RMU_APB1RSTR_I2C0RST_MSK    BIT(RMU_APB1RSTR_I2C0RST_POS)

#define RMU_APB1RSTR_SPI1RST_POS    17U
#define RMU_APB1RSTR_SPI1RST_MSK    BIT(RMU_APB1RSTR_SPI1RST_POS)

#define RMU_APB1RSTR_SPI0RST_POS    16U
#define RMU_APB1RSTR_SPI0RST_MSK    BIT(RMU_APB1RSTR_SPI0RST_POS)

#define RMU_APB1RSTR_UART5RST_POS   13U
#define RMU_APB1RSTR_UART5RST_MSK   BIT(RMU_APB1RSTR_UART5RST_POS)

#define RMU_APB1RSTR_UART4RST_POS   12U
#define RMU_APB1RSTR_UART4RST_MSK   BIT(RMU_APB1RSTR_UART4RST_POS)

#define RMU_APB1RSTR_UART3RST_POS   11U
#define RMU_APB1RSTR_UART3RST_MSK   BIT(RMU_APB1RSTR_UART3RST_POS)

#define RMU_APB1RSTR_UART2RST_POS   10U
#define RMU_APB1RSTR_UART2RST_MSK   BIT(RMU_APB1RSTR_UART2RST_POS)

#define RMU_APB1RSTR_UART1RST_POS   9U
#define RMU_APB1RSTR_UART1RST_MSK   BIT(RMU_APB1RSTR_UART1RST_POS)

#define RMU_APB1RSTR_UART0RST_POS   8U
#define RMU_APB1RSTR_UART0RST_MSK   BIT(RMU_APB1RSTR_UART0RST_POS)

#define RMU_APB1RSTR_GP16C4T1RST_POS 7U
#define RMU_APB1RSTR_GP16C4T1RST_MSK BIT(RMU_APB1RSTR_GP16C4T1RST_POS)

#define RMU_APB1RSTR_GP16C4T0RST_POS 6U
#define RMU_APB1RSTR_GP16C4T0RST_MSK BIT(RMU_APB1RSTR_GP16C4T0RST_POS)

#define RMU_APB1RSTR_BS16T1RST_POS  5U
#define RMU_APB1RSTR_BS16T1RST_MSK  BIT(RMU_APB1RSTR_BS16T1RST_POS)

#define RMU_APB1RSTR_BS16T0RST_POS  4U
#define RMU_APB1RSTR_BS16T0RST_MSK  BIT(RMU_APB1RSTR_BS16T0RST_POS)

#define RMU_APB1RSTR_GP32C4T1RST_POS 3U
#define RMU_APB1RSTR_GP32C4T1RST_MSK BIT(RMU_APB1RSTR_GP32C4T1RST_POS)

#define RMU_APB1RSTR_GP32C4T0RST_POS 2U
#define RMU_APB1RSTR_GP32C4T0RST_MSK BIT(RMU_APB1RSTR_GP32C4T0RST_POS)

#define RMU_APB1RSTR_AD16C4T0RST_POS  0U
#define RMU_APB1RSTR_AD16C4T0RST_MSK  BIT(RMU_APB1RSTR_AD16C4T0RST_POS)

/****************** Bit definition for RMU_APB2RSTR register ************************/
#define RMU_APB2RSTR_DBGCONRST_POS  19U
#define RMU_APB2RSTR_DBGCONRST_MSK  BIT(RMU_APB2RSTR_DBGCONRST_POS)

#define RMU_APB2RSTR_DACRST_POS 16U
#define RMU_APB2RSTR_DACRST_MSK BIT(RMU_APB2RSTR_DACRST_POS)

#define RMU_APB2RSTR_RTCRST_POS 15U
#define RMU_APB2RSTR_RTCRST_MSK BIT(RMU_APB2RSTR_RTCRST_POS)

#define RMU_APB2RSTR_IWDTRST_POS    14U
#define RMU_APB2RSTR_IWDTRST_MSK    BIT(RMU_APB2RSTR_IWDTRST_POS)

#define RMU_APB2RSTR_WWDTRST_POS    12U
#define RMU_APB2RSTR_WWDTRST_MSK    BIT(RMU_APB2RSTR_WWDTRST_POS)

#define RMU_APB2RSTR_ADC0RST_POS    4U
#define RMU_APB2RSTR_ADC0RST_MSK    BIT(RMU_APB2RSTR_ADC0RST_POS)

#define RMU_APB2RSTR_LPUART0RST_POS 2U
#define RMU_APB2RSTR_LPUART0RST_MSK BIT(RMU_APB2RSTR_LPUART0RST_POS)

#define RMU_APB2RSTR_LPTIM0RST_POS  0U
#define RMU_APB2RSTR_LPTIM0RST_MSK  BIT(RMU_APB2RSTR_LPTIM0RST_POS)

typedef struct
{
    __IO uint32_t CSR;
    uint32_t RESERVED0[3] ;
    __I uint32_t RSTSR;
    __O uint32_t CRSTSR;
    uint32_t RESERVED1[2] ;
    __O uint32_t AHB1RSTR;
    __O uint32_t AHB2RSTR;
    uint32_t RESERVED2[2] ;
    __O uint32_t APB1RSTR;
    __O uint32_t APB2RSTR;
} RMU_TypeDef;

/****************** Bit definition for CMU_CSR register ************************/

#define CMU_CSR_CFT_RDYN_POS    25U
#define CMU_CSR_CFT_RDYN_MSK    BIT(CMU_CSR_CFT_RDYN_POS)

#define CMU_CSR_CFT_STU_POS     24U
#define CMU_CSR_CFT_STU_MSK BIT(CMU_CSR_CFT_STU_POS)

#define CMU_CSR_CFT_CMD_POSS    16U
#define CMU_CSR_CFT_CMD_POSE    23U
#define CMU_CSR_CFT_CMD_MSK BITS(CMU_CSR_CFT_CMD_POSS,CMU_CSR_CFT_CMD_POSE)

#define CMU_CSR_SYS_RDYN_POS    12U
#define CMU_CSR_SYS_RDYN_MSK    BIT(CMU_CSR_SYS_RDYN_POS)

#define CMU_CSR_SYS_STU_POSS    8U
#define CMU_CSR_SYS_STU_POSE    10U
#define CMU_CSR_SYS_STU_MSK BITS(CMU_CSR_SYS_STU_POSS,CMU_CSR_SYS_STU_POSE)

#define CMU_CSR_SYS_CMD_POSS    0U
#define CMU_CSR_SYS_CMD_POSE    2U
#define CMU_CSR_SYS_CMD_MSK BITS(CMU_CSR_SYS_CMD_POSS,CMU_CSR_SYS_CMD_POSE)

/****************** Bit definition for CMU_CFGR register ************************/

#define CMU_CFGR_PCLK2DIV_POSS  20U
#define CMU_CFGR_PCLK2DIV_POSE  23U
#define CMU_CFGR_PCLK2DIV_MSK   BITS(CMU_CFGR_PCLK2DIV_POSS,CMU_CFGR_PCLK2DIV_POSE)

#define CMU_CFGR_PCLK1DIV_POSS  16U
#define CMU_CFGR_PCLK1DIV_POSE  19U
#define CMU_CFGR_PCLK1DIV_MSK   BITS(CMU_CFGR_PCLK1DIV_POSS,CMU_CFGR_PCLK1DIV_POSE)

#define CMU_CFGR_SYSDIV_POSS    12U
#define CMU_CFGR_SYSDIV_POSE    15U
#define CMU_CFGR_SYSDIV_MSK BITS(CMU_CFGR_SYSDIV_POSS,CMU_CFGR_SYSDIV_POSE)

/****************** Bit definition for CMU_CLKENR register ************************/

#define CMU_CLKENR_HOSC1MEN_POS 17U
#define CMU_CLKENR_HOSC1MEN_MSK BIT(CMU_CLKENR_HOSC1MEN_POS)

#define CMU_CLKENR_HRC1MEN_POS  16U
#define CMU_CLKENR_HRC1MEN_MSK  BIT(CMU_CLKENR_HRC1MEN_POS)

#define CMU_CLKENR_PLLEN_POS    8U
#define CMU_CLKENR_PLLEN_MSK    BIT(CMU_CLKENR_PLLEN_POS)

#define CMU_CLKENR_ULRCEN_POS   4U
#define CMU_CLKENR_ULRCEN_MSK   BIT(CMU_CLKENR_ULRCEN_POS)

#define CMU_CLKENR_LRCEN_POS    3U
#define CMU_CLKENR_LRCEN_MSK    BIT(CMU_CLKENR_LRCEN_POS)

#define CMU_CLKENR_HRCEN_POS    2U
#define CMU_CLKENR_HRCEN_MSK    BIT(CMU_CLKENR_HRCEN_POS)

#define CMU_CLKENR_LOSCEN_POS   1U
#define CMU_CLKENR_LOSCEN_MSK   BIT(CMU_CLKENR_LOSCEN_POS)

#define CMU_CLKENR_HOSCEN_POS   0U
#define CMU_CLKENR_HOSCEN_MSK   BIT(CMU_CLKENR_HOSCEN_POS)

/****************** Bit definition for CMU_CLKSR register ************************/

#define CMU_CLKSR_PLLRDY_POS    24U
#define CMU_CLKSR_PLLRDY_MSK    BIT(CMU_CLKSR_PLLRDY_POS)

#define CMU_CLKSR_LRCRDY_POS    19U
#define CMU_CLKSR_LRCRDY_MSK    BIT(CMU_CLKSR_LRCRDY_POS)

#define CMU_CLKSR_HRCRDY_POS    18U
#define CMU_CLKSR_HRCRDY_MSK    BIT(CMU_CLKSR_HRCRDY_POS)

#define CMU_CLKSR_LOSCRDY_POS   17U
#define CMU_CLKSR_LOSCRDY_MSK   BIT(CMU_CLKSR_LOSCRDY_POS)

#define CMU_CLKSR_HOSCRDY_POS   16U
#define CMU_CLKSR_HOSCRDY_MSK   BIT(CMU_CLKSR_HOSCRDY_POS)

#define CMU_CLKSR_PLLACT_POS    8U
#define CMU_CLKSR_PLLACT_MSK    BIT(CMU_CLKSR_PLLACT_POS)

#define CMU_CLKSR_ULRCACT_POS   4U
#define CMU_CLKSR_ULRCACT_MSK   BIT(CMU_CLKSR_ULRCACT_POS)

#define CMU_CLKSR_LRCACT_POS    3U
#define CMU_CLKSR_LRCACT_MSK    BIT(CMU_CLKSR_LRCACT_POS)

#define CMU_CLKSR_HRCACT_POS    2U
#define CMU_CLKSR_HRCACT_MSK    BIT(CMU_CLKSR_HRCACT_POS)

#define CMU_CLKSR_LOSCACT_POS   1U
#define CMU_CLKSR_LOSCACT_MSK   BIT(CMU_CLKSR_LOSCACT_POS)

#define CMU_CLKSR_HOSCACT_POS   0U
#define CMU_CLKSR_HOSCACT_MSK   BIT(CMU_CLKSR_HOSCACT_POS)

/****************** Bit definition for CMU_PLLCFG register ************************/

#define CMU_PLLCFG_PLLLCKN_POS  16U
#define CMU_PLLCFG_PLLLCKN_MSK  BIT(CMU_PLLCFG_PLLLCKN_POS)

#define CMU_PLLCFG_PLLOS_POSS   4U
#define CMU_PLLCFG_PLLOS_POSE   6U
#define CMU_PLLCFG_PLLOS_MSK    BITS(CMU_PLLCFG_PLLOS_POSS,CMU_PLLCFG_PLLOS_POSE)

#define CMU_PLLCFG_PLLRFS_POSS  0U
#define CMU_PLLCFG_PLLRFS_POSE  2U
#define CMU_PLLCFG_PLLRFS_MSK   BITS(CMU_PLLCFG_PLLRFS_POSS,CMU_PLLCFG_PLLRFS_POSE)

/****************** Bit definition for CMU_HOSCCFG register ************************/

#define CMU_HOSCCFG_FREQ_POSS   0U
#define CMU_HOSCCFG_FREQ_POSE   4U
#define CMU_HOSCCFG_FREQ_MSK    BITS(CMU_HOSCCFG_FREQ_POSS,CMU_HOSCCFG_FREQ_POSE)

/****************** Bit definition for CMU_HOSMCR register ************************/

#define CMU_HOSMCR_NMIE_POS 20U
#define CMU_HOSMCR_NMIE_MSK BIT(CMU_HOSMCR_NMIE_POS)

#define CMU_HOSMCR_STPIF_POS    19U
#define CMU_HOSMCR_STPIF_MSK    BIT(CMU_HOSMCR_STPIF_POS)

#define CMU_HOSMCR_STRIF_POS    18U
#define CMU_HOSMCR_STRIF_MSK    BIT(CMU_HOSMCR_STRIF_POS)

#define CMU_HOSMCR_STPIE_POS    17U
#define CMU_HOSMCR_STPIE_MSK    BIT(CMU_HOSMCR_STPIE_POS)

#define CMU_HOSMCR_STRIE_POS    16U
#define CMU_HOSMCR_STRIE_MSK    BIT(CMU_HOSMCR_STRIE_POS)

#define CMU_HOSMCR_FRQS_POSS    8U
#define CMU_HOSMCR_FRQS_POSE    10U
#define CMU_HOSMCR_FRQS_MSK BITS(CMU_HOSMCR_FRQS_POSS,CMU_HOSMCR_FRQS_POSE)

#define CMU_HOSMCR_CLKS_POS 1U
#define CMU_HOSMCR_CLKS_MSK BIT(CMU_HOSMCR_CLKS_POS)

#define CMU_HOSMCR_EN_POS   0U
#define CMU_HOSMCR_EN_MSK   BIT(CMU_HOSMCR_EN_POS)

/****************** Bit definition for CMU_LOSMCR register ************************/

#define CMU_LOSMCR_NMIE_POS 20U
#define CMU_LOSMCR_NMIE_MSK BIT(CMU_LOSMCR_NMIE_POS)

#define CMU_LOSMCR_STPIF_POS    19U
#define CMU_LOSMCR_STPIF_MSK    BIT(CMU_LOSMCR_STPIF_POS)

#define CMU_LOSMCR_STRIF_POS    18U
#define CMU_LOSMCR_STRIF_MSK    BIT(CMU_LOSMCR_STRIF_POS)

#define CMU_LOSMCR_STPIE_POS    17U
#define CMU_LOSMCR_STPIE_MSK    BIT(CMU_LOSMCR_STPIE_POS)

#define CMU_LOSMCR_STRIE_POS    16U
#define CMU_LOSMCR_STRIE_MSK    BIT(CMU_LOSMCR_STRIE_POS)

#define CMU_LOSMCR_CLKS_POS 1U
#define CMU_LOSMCR_CLKS_MSK BIT(CMU_LOSMCR_CLKS_POS)

#define CMU_LOSMCR_EN_POS   0U
#define CMU_LOSMCR_EN_MSK   BIT(CMU_LOSMCR_EN_POS)

/****************** Bit definition for CMU_PULMCR register ************************/

#define CMU_PULMCR_NMIE_POS 20U
#define CMU_PULMCR_NMIE_MSK BIT(CMU_PULMCR_NMIE_POS)

#define CMU_PULMCR_ULKIF_POS    19U
#define CMU_PULMCR_ULKIF_MSK    BIT(CMU_PULMCR_ULKIF_POS)

#define CMU_PULMCR_LCKIF_POS    18U
#define CMU_PULMCR_LCKIF_MSK    BIT(CMU_PULMCR_LCKIF_POS)

#define CMU_PULMCR_ULKIE_POS    17U
#define CMU_PULMCR_ULKIE_MSK    BIT(CMU_PULMCR_ULKIE_POS)

#define CMU_PULMCR_LCKIE_POS    16U
#define CMU_PULMCR_LCKIE_MSK    BIT(CMU_PULMCR_LCKIE_POS)

#define CMU_PULMCR_MODE_POSS    8U
#define CMU_PULMCR_MODE_POSE    9U
#define CMU_PULMCR_MODE_MSK BITS(CMU_PULMCR_MODE_POSS,CMU_PULMCR_MODE_POSE)

#define CMU_PULMCR_CLKS_POS 1U
#define CMU_PULMCR_CLKS_MSK BIT(CMU_PULMCR_CLKS_POS)

#define CMU_PULMCR_EN_POS   0U
#define CMU_PULMCR_EN_MSK   BIT(CMU_PULMCR_EN_POS)

/****************** Bit definition for CMU_CLKOCR register ************************/

#define CMU_CLKOCR_LSCOS_POSS   24U
#define CMU_CLKOCR_LSCOS_POSE   26U
#define CMU_CLKOCR_LSCOS_MSK    BITS(CMU_CLKOCR_LSCOS_POSS,CMU_CLKOCR_LSCOS_POSE)

#define CMU_CLKOCR_LSCOEN_POS   16U
#define CMU_CLKOCR_LSCOEN_MSK   BIT(CMU_CLKOCR_LSCOEN_POS)

#define CMU_CLKOCR_HSCODIV_POSS 12U
#define CMU_CLKOCR_HSCODIV_POSE 14U
#define CMU_CLKOCR_HSCODIV_MSK  BITS(CMU_CLKOCR_HSCODIV_POSS,CMU_CLKOCR_HSCODIV_POSE)

#define CMU_CLKOCR_HSCOS_POSS   8U
#define CMU_CLKOCR_HSCOS_POSE   11U
#define CMU_CLKOCR_HSCOS_MSK    BITS(CMU_CLKOCR_HSCOS_POSS,CMU_CLKOCR_HSCOS_POSE)

#define CMU_CLKOCR_HSCOEN_POS   0U
#define CMU_CLKOCR_HSCOEN_MSK   BIT(CMU_CLKOCR_HSCOEN_POS)

/****************** Bit definition for CMU_BUZZCR register ************************/

#define CMU_BUZZCR_DAT_POSS 16U
#define CMU_BUZZCR_DAT_POSE 31U
#define CMU_BUZZCR_DAT_MSK  BITS(CMU_BUZZCR_DAT_POSS,CMU_BUZZCR_DAT_POSE)

#define CMU_BUZZCR_DIV_POSS 8U
#define CMU_BUZZCR_DIV_POSE 10U
#define CMU_BUZZCR_DIV_MSK  BITS(CMU_BUZZCR_DIV_POSS,CMU_BUZZCR_DIV_POSE)

#define CMU_BUZZCR_EN_POS   0U
#define CMU_BUZZCR_EN_MSK   BIT(CMU_BUZZCR_EN_POS)

/****************** Bit definition for CMU_AHB1ENR register ************************/

#define CMU_AHB1ENR_PISEN_POS   5U
#define CMU_AHB1ENR_PISEN_MSK   BIT(CMU_AHB1ENR_PISEN_POS)

#define CMU_AHB1ENR_CALCEN_POS  2U
#define CMU_AHB1ENR_CALCEN_MSK  BIT(CMU_AHB1ENR_CALCEN_POS)

#define CMU_AHB1ENR_CRCEN_POS   1U
#define CMU_AHB1ENR_CRCEN_MSK   BIT(CMU_AHB1ENR_CRCEN_POS)

#define CMU_AHB1ENR_GPIOEN_POS  0U
#define CMU_AHB1ENR_GPIOEN_MSK  BIT(CMU_AHB1ENR_GPIOEN_POS)

/****************** Bit definition for CMU_AHB2ENR register ************************/

#define CMU_AHB2ENR_DMAMUX_POS  4U
#define CMU_AHB2ENR_DMAMUX_MSK  BIT(CMU_AHB2ENR_DMAMUX_POS)

#define CMU_AHB2ENR_DMA1EN_POS  3U
#define CMU_AHB2ENR_DMA1EN_MSK  BIT(CMU_AHB2ENR_DMA1EN_POS)

#define CMU_AHB2ENR_DMA0EN_POS  2U
#define CMU_AHB2ENR_DMA0EN_MSK  BIT(CMU_AHB2ENR_DMA0EN_POS)

/****************** Bit definition for CMU_APB1ENR register ************************/

#define CMU_APB1ENR_CAN0EN_POS  24U
#define CMU_APB1ENR_CAN0EN_MSK  BIT(CMU_APB1ENR_CAN0EN_POS)

#define CMU_APB1ENR_I2C1EN_POS  21U
#define CMU_APB1ENR_I2C1EN_MSK  BIT(CMU_APB1ENR_I2C1EN_POS)

#define CMU_APB1ENR_I2C0EN_POS  20U
#define CMU_APB1ENR_I2C0EN_MSK  BIT(CMU_APB1ENR_I2C0EN_POS)

#define CMU_APB1ENR_SPI1EN_POS  17U
#define CMU_APB1ENR_SPI1EN_MSK  BIT(CMU_APB1ENR_SPI1EN_POS)

#define CMU_APB1ENR_SPI0EN_POS  16U
#define CMU_APB1ENR_SPI0EN_MSK  BIT(CMU_APB1ENR_SPI0EN_POS)

#define CMU_APB1ENR_UART5EN_POS 13U
#define CMU_APB1ENR_UART5EN_MSK BIT(CMU_APB1ENR_UART5EN_POS)

#define CMU_APB1ENR_UART4EN_POS 12U
#define CMU_APB1ENR_UART4EN_MSK BIT(CMU_APB1ENR_UART4EN_POS)

#define CMU_APB1ENR_UART3EN_POS 11U
#define CMU_APB1ENR_UART3EN_MSK BIT(CMU_APB1ENR_UART3EN_POS)

#define CMU_APB1ENR_UART2EN_POS 10U
#define CMU_APB1ENR_UART2EN_MSK BIT(CMU_APB1ENR_UART2EN_POS)

#define CMU_APB1ENR_UART1EN_POS 9U
#define CMU_APB1ENR_UART1EN_MSK BIT(CMU_APB1ENR_UART1EN_POS)

#define CMU_APB1ENR_UART0EN_POS 8U
#define CMU_APB1ENR_UART0EN_MSK BIT(CMU_APB1ENR_UART0EN_POS)

#define CMU_APB1ENR_GP16C4T1EN_POS   7U
#define CMU_APB1ENR_GP16C4T1EN_MSK   BIT(CMU_APB1ENR_GP16C4T1EN_POS)

#define CMU_APB1ENR_GP16C4T0EN_POS   6U
#define CMU_APB1ENR_GP16C4T0EN_MSK   BIT(CMU_APB1ENR_GP16C4T0EN_POS)

#define CMU_APB1ENR_BS16T1EN_POS    5U
#define CMU_APB1ENR_BS16T1EN_MSK    BIT(CMU_APB1ENR_BS16T1EN_POS)

#define CMU_APB1ENR_BS16T0EN_POS    4U
#define CMU_APB1ENR_BS16T0EN_MSK    BIT(CMU_APB1ENR_BS16T0EN_POS)

#define CMU_APB1ENR_GP32C4T1EN_POS   3U
#define CMU_APB1ENR_GP32C4T1EN_MSK   BIT(CMU_APB1ENR_GP32C4T1EN_POS)

#define CMU_APB1ENR_GP32C4T0EN_POS   2U
#define CMU_APB1ENR_GP32C4T0EN_MSK   BIT(CMU_APB1ENR_GP32C4T0EN_POS)

#define CMU_APB1ENR_AD16C4T0EN_POS    0U
#define CMU_APB1ENR_AD16C4T0EN_MSK    BIT(CMU_APB1ENR_AD16C4T0EN_POS)

/****************** Bit definition for CMU_APB2ENR register ************************/

#define CMU_APB2ENR_DBGCONEN_POS    19U
#define CMU_APB2ENR_DBGCONEN_MSK    BIT(CMU_APB2ENR_DBGCONEN_POS)

#define CMU_APB2ENR_DACEN_POS   16U
#define CMU_APB2ENR_DACEN_MSK   BIT(CMU_APB2ENR_DACEN_POS)

#define CMU_APB2ENR_RTCEN_POS   15U
#define CMU_APB2ENR_RTCEN_MSK   BIT(CMU_APB2ENR_RTCEN_POS)

#define CMU_APB2ENR_IWDTEN_POS  14U
#define CMU_APB2ENR_IWDTEN_MSK  BIT(CMU_APB2ENR_IWDTEN_POS)

#define CMU_APB2ENR_WWDTEN_POS  12U
#define CMU_APB2ENR_WWDTEN_MSK  BIT(CMU_APB2ENR_WWDTEN_POS)

#define CMU_APB2ENR_ADC0EN_POS  4U
#define CMU_APB2ENR_ADC0EN_MSK  BIT(CMU_APB2ENR_ADC0EN_POS)

#define CMU_APB2ENR_LPUART0EN_POS   2U
#define CMU_APB2ENR_LPUART0EN_MSK   BIT(CMU_APB2ENR_LPUART0EN_POS)

#define CMU_APB2ENR_LPTIM0EN_POS    0U
#define CMU_APB2ENR_LPTIM0EN_MSK    BIT(CMU_APB2ENR_LPTIM0EN_POS)

/****************** Bit definition for CMU_LPENR register ************************/

#define CMU_LPENR_STOP2CS_POS   19U
#define CMU_LPENR_STOP2CS_MSK   BIT(CMU_LPENR_STOP2CS_POS)

#define CMU_LPENR_STOP1CS_POSS  16U
#define CMU_LPENR_STOP1CS_POSE  18U
#define CMU_LPENR_STOP1CS_MSK   BITS(CMU_LPENR_STOP1CS_POSS,CMU_LPENR_STOP1CS_POSE)

#define CMU_LPENR_HOSCEN_POS    3U
#define CMU_LPENR_HOSCEN_MSK    BIT(CMU_LPENR_HOSCEN_POS)

#define CMU_LPENR_HRCEN_POS 2U
#define CMU_LPENR_HRCEN_MSK BIT(CMU_LPENR_HRCEN_POS)

#define CMU_LPENR_LOSCEN_POS    1U
#define CMU_LPENR_LOSCEN_MSK    BIT(CMU_LPENR_LOSCEN_POS)

#define CMU_LPENR_LRCEN_POS 0U
#define CMU_LPENR_LRCEN_MSK BIT(CMU_LPENR_LRCEN_POS)

/****************** Bit definition for CMU_PERICR register ************************/

#define CMU_PERICR_LPUART0CS_POSS   8U
#define CMU_PERICR_LPUART0CS_POSE   11U
#define CMU_PERICR_LPUART0CS_MSK    BITS(CMU_PERICR_LPUART0CS_POSS,CMU_PERICR_LPUART0CS_POSE)

#define CMU_PERICR_LPTIM0CS_POSS    0U
#define CMU_PERICR_LPTIM0CS_POSE    3U
#define CMU_PERICR_LPTIM0CS_MSK BITS(CMU_PERICR_LPTIM0CS_POSS,CMU_PERICR_LPTIM0CS_POSE)

/****************** Bit definition for CMU_HRCACR register ************************/

#define CMU_HRCACR_IB_POSS  28U
#define CMU_HRCACR_IB_POSE  29U
#define CMU_HRCACR_IB_MSK   BITS(CMU_HRCACR_IB_POSS,CMU_HRCACR_IB_POSE)

#define CMU_HRCACR_CAP_POSS 26U
#define CMU_HRCACR_CAP_POSE 27U
#define CMU_HRCACR_CAP_MSK  BITS(CMU_HRCACR_CAP_POSS,CMU_HRCACR_CAP_POSE)

#define CMU_HRCACR_CAL_POSS 16U
#define CMU_HRCACR_CAL_POSE 25U
#define CMU_HRCACR_CAL_MSK  BITS(CMU_HRCACR_CAL_POSS,CMU_HRCACR_CAL_POSE)

#define CMU_HRCACR_IBSET_POSS   14U
#define CMU_HRCACR_IBSET_POSE   15U
#define CMU_HRCACR_IBSET_MSK    BITS(CMU_HRCACR_IBSET_POSS,CMU_HRCACR_IBSET_POSE)

#define CMU_HRCACR_CAPSET_POSS  12U
#define CMU_HRCACR_CAPSET_POSE  13U
#define CMU_HRCACR_CAPSET_MSK   BITS(CMU_HRCACR_CAPSET_POSS,CMU_HRCACR_CAPSET_POSE)

#define CMU_HRCACR_STA_POSS 9U
#define CMU_HRCACR_STA_POSE 10U
#define CMU_HRCACR_STA_MSK  BITS(CMU_HRCACR_STA_POSS,CMU_HRCACR_STA_POSE)

#define CMU_HRCACR_BUSY_POS 8U
#define CMU_HRCACR_BUSY_MSK BIT(CMU_HRCACR_BUSY_POS)

#define CMU_HRCACR_WRTRG_POS    7U
#define CMU_HRCACR_WRTRG_MSK    BIT(CMU_HRCACR_WRTRG_POS)

#define CMU_HRCACR_AC_POSS  4U
#define CMU_HRCACR_AC_POSE  6U
#define CMU_HRCACR_AC_MSK   BITS(CMU_HRCACR_AC_POSS,CMU_HRCACR_AC_POSE)

#define CMU_HRCACR_IBS_POS  3U
#define CMU_HRCACR_IBS_MSK  BIT(CMU_HRCACR_IBS_POS)

#define CMU_HRCACR_RFSEL_POS    2U
#define CMU_HRCACR_RFSEL_MSK    BIT(CMU_HRCACR_RFSEL_POS)

#define CMU_HRCACR_EN_POS   0U
#define CMU_HRCACR_EN_MSK   BIT(CMU_HRCACR_EN_POS)

/****************** Bit definition for CMU_LRCACR register ************************/
#define CMU_LRCACR_IB_POSS  24U
#define CMU_LRCACR_IB_POSE  27U
#define CMU_LRCACR_IB_MSK   BITS(CMU_LRCACR_IB_POSS,CMU_LRCACR_IB_POSE)

#define CMU_LRCACR_CAL_POSS 16U
#define CMU_LRCACR_CAL_POSE 23U
#define CMU_LRCACR_CAL_MSK  BITS(CMU_LRCACR_CAL_POSS,CMU_LRCACR_CAL_POSE)

#define CMU_LRCACR_STA_POSS 9U
#define CMU_LRCACR_STA_POSE 10U
#define CMU_LRCACR_STA_MSK  BITS(CMU_LRCACR_STA_POSS,CMU_LRCACR_STA_POSE)

#define CMU_LRCACR_BUSY_POS 8U
#define CMU_LRCACR_BUSY_MSK BIT(CMU_LRCACR_BUSY_POS)

#define CMU_LRCACR_WRTRG_POS    7U
#define CMU_LRCACR_WRTRG_MSK    BIT(CMU_LRCACR_WRTRG_POS)

#define CMU_LRCACR_AC_POSS  4U
#define CMU_LRCACR_AC_POSE  6U
#define CMU_LRCACR_AC_MSK   BITS(CMU_LRCACR_AC_POSS,CMU_LRCACR_AC_POSE)

#define CMU_LRCACR_RFSEL_POS    1U
#define CMU_LRCACR_RFSEL_MSK    BIT(CMU_LRCACR_RFSEL_POS)

#define CMU_LRCACR_EN_POS   0U
#define CMU_LRCACR_EN_MSK   BIT(CMU_LRCACR_EN_POS)

typedef struct
{
    __O uint32_t CSR;
    __IO uint32_t CFGR;
    uint32_t RESERVED0[2] ;
    __IO uint32_t CLKENR;
    __I uint32_t CLKSR;
    __IO uint32_t PLLCFG;
    __IO uint32_t HOSCCFG;
    __IO uint32_t HOSMCR;
    __IO uint32_t LOSMCR;
    __IO uint32_t PULMCR;
    uint32_t RESERVED1 ;
    __IO uint32_t CLKOCR;
    __IO uint32_t BUZZCR;
    uint32_t RESERVED2[2] ;
    __IO uint32_t AHB1ENR;
    __IO uint32_t AHB2ENR;
    uint32_t RESERVED3[2] ;
    __IO uint32_t APB1ENR;
    __IO uint32_t APB2ENR;
    uint32_t RESERVED4[2] ;
    __IO uint32_t LPENR;
    uint32_t RESERVED5[7] ;
    __IO uint32_t PERICR;
    uint32_t RESERVED6[3] ;
    __IO uint32_t HRCACR;
    __IO uint32_t LRCACR;
} CMU_TypeDef;

#define DMA_CHANNELS  12
/****************** Bit definition for DMA_IER register ************************/

#define DMA_IER_CH5HT_POS   11U
#define DMA_IER_CH5HT_MSK   BIT(DMA_IER_CH5HT_POS)

#define DMA_IER_CH5TC_POS   10U
#define DMA_IER_CH5TC_MSK   BIT(DMA_IER_CH5TC_POS)

#define DMA_IER_CH4HT_POS   9U
#define DMA_IER_CH4HT_MSK   BIT(DMA_IER_CH4HT_POS)

#define DMA_IER_CH4TC_POS   8U
#define DMA_IER_CH4TC_MSK   BIT(DMA_IER_CH4TC_POS)

#define DMA_IER_CH3HT_POS   7U
#define DMA_IER_CH3HT_MSK   BIT(DMA_IER_CH3HT_POS)

#define DMA_IER_CH3TC_POS   6U
#define DMA_IER_CH3TC_MSK   BIT(DMA_IER_CH3TC_POS)

#define DMA_IER_CH2HT_POS   5U
#define DMA_IER_CH2HT_MSK   BIT(DMA_IER_CH2HT_POS)

#define DMA_IER_CH2TC_POS   4U
#define DMA_IER_CH2TC_MSK   BIT(DMA_IER_CH2TC_POS)

#define DMA_IER_CH1HT_POS   3U
#define DMA_IER_CH1HT_MSK   BIT(DMA_IER_CH1HT_POS)

#define DMA_IER_CH1TC_POS   2U
#define DMA_IER_CH1TC_MSK   BIT(DMA_IER_CH1TC_POS)

#define DMA_IER_CH0HT_POS   1U
#define DMA_IER_CH0HT_MSK   BIT(DMA_IER_CH0HT_POS)

#define DMA_IER_CH0TC_POS   0U
#define DMA_IER_CH0TC_MSK   BIT(DMA_IER_CH0TC_POS)

/****************** Bit definition for DMA_IDR register ************************/


#define DMA_IDR_CH5HT_POS   11U
#define DMA_IDR_CH5HT_MSK   BIT(DMA_IDR_CH5HT_POS)

#define DMA_IDR_CH5TC_POS   10U
#define DMA_IDR_CH5TC_MSK   BIT(DMA_IDR_CH5TC_POS)

#define DMA_IDR_CH4HT_POS   9U
#define DMA_IDR_CH4HT_MSK   BIT(DMA_IDR_CH4HT_POS)

#define DMA_IDR_CH4TC_POS   8U
#define DMA_IDR_CH4TC_MSK   BIT(DMA_IDR_CH4TC_POS)

#define DMA_IDR_CH3HT_POS   7U
#define DMA_IDR_CH3HT_MSK   BIT(DMA_IDR_CH3HT_POS)

#define DMA_IDR_CH3TC_POS   6U
#define DMA_IDR_CH3TC_MSK   BIT(DMA_IDR_CH3TC_POS)

#define DMA_IDR_CH2HT_POS   5U
#define DMA_IDR_CH2HT_MSK   BIT(DMA_IDR_CH2HT_POS)

#define DMA_IDR_CH2TC_POS   4U
#define DMA_IDR_CH2TC_MSK   BIT(DMA_IDR_CH2TC_POS)

#define DMA_IDR_CH1HT_POS   3U
#define DMA_IDR_CH1HT_MSK   BIT(DMA_IDR_CH1HT_POS)

#define DMA_IDR_CH1TC_POS   2U
#define DMA_IDR_CH1TC_MSK   BIT(DMA_IDR_CH1TC_POS)

#define DMA_IDR_CH0HT_POS   1U
#define DMA_IDR_CH0HT_MSK   BIT(DMA_IDR_CH0HT_POS)

#define DMA_IDR_CH0TC_POS   0U
#define DMA_IDR_CH0TC_MSK   BIT(DMA_IDR_CH0TC_POS)

/****************** Bit definition for DMA_IVS register ************************/


#define DMA_IVS_CH5HT_POS   11U
#define DMA_IVS_CH5HT_MSK   BIT(DMA_IVS_CH5HT_POS)

#define DMA_IVS_CH5TC_POS   10U
#define DMA_IVS_CH5TC_MSK   BIT(DMA_IVS_CH5TC_POS)

#define DMA_IVS_CH4HT_POS   9U
#define DMA_IVS_CH4HT_MSK   BIT(DMA_IVS_CH4HT_POS)

#define DMA_IVS_CH4TC_POS   8U
#define DMA_IVS_CH4TC_MSK   BIT(DMA_IVS_CH4TC_POS)

#define DMA_IVS_CH3HT_POS   7U
#define DMA_IVS_CH3HT_MSK   BIT(DMA_IVS_CH3HT_POS)

#define DMA_IVS_CH3TC_POS   6U
#define DMA_IVS_CH3TC_MSK   BIT(DMA_IVS_CH3TC_POS)

#define DMA_IVS_CH2HT_POS   5U
#define DMA_IVS_CH2HT_MSK   BIT(DMA_IVS_CH2HT_POS)

#define DMA_IVS_CH2TC_POS   4U
#define DMA_IVS_CH2TC_MSK   BIT(DMA_IVS_CH2TC_POS)

#define DMA_IVS_CH1HT_POS   3U
#define DMA_IVS_CH1HT_MSK   BIT(DMA_IVS_CH1HT_POS)

#define DMA_IVS_CH1TC_POS   2U
#define DMA_IVS_CH1TC_MSK   BIT(DMA_IVS_CH1TC_POS)

#define DMA_IVS_CH0HT_POS   1U
#define DMA_IVS_CH0HT_MSK   BIT(DMA_IVS_CH0HT_POS)

#define DMA_IVS_CH0TC_POS   0U
#define DMA_IVS_CH0TC_MSK   BIT(DMA_IVS_CH0TC_POS)

/****************** Bit definition for DMA_RIF register ************************/

#define DMA_RIF_CH5HT_POS   11U
#define DMA_RIF_CH5HT_MSK   BIT(DMA_RIF_CH5HT_POS)

#define DMA_RIF_CH5TC_POS   10U
#define DMA_RIF_CH5TC_MSK   BIT(DMA_RIF_CH5TC_POS)

#define DMA_RIF_CH4HT_POS   9U
#define DMA_RIF_CH4HT_MSK   BIT(DMA_RIF_CH4HT_POS)

#define DMA_RIF_CH4TC_POS   8U
#define DMA_RIF_CH4TC_MSK   BIT(DMA_RIF_CH4TC_POS)

#define DMA_RIF_CH3HT_POS   7U
#define DMA_RIF_CH3HT_MSK   BIT(DMA_RIF_CH3HT_POS)

#define DMA_RIF_CH3TC_POS   6U
#define DMA_RIF_CH3TC_MSK   BIT(DMA_RIF_CH3TC_POS)

#define DMA_RIF_CH2HT_POS   5U
#define DMA_RIF_CH2HT_MSK   BIT(DMA_RIF_CH2HT_POS)

#define DMA_RIF_CH2TC_POS   4U
#define DMA_RIF_CH2TC_MSK   BIT(DMA_RIF_CH2TC_POS)

#define DMA_RIF_CH1HT_POS   3U
#define DMA_RIF_CH1HT_MSK   BIT(DMA_RIF_CH1HT_POS)

#define DMA_RIF_CH1TC_POS   2U
#define DMA_RIF_CH1TC_MSK   BIT(DMA_RIF_CH1TC_POS)

#define DMA_RIF_CH0HT_POS   1U
#define DMA_RIF_CH0HT_MSK   BIT(DMA_RIF_CH0HT_POS)

#define DMA_RIF_CH0TC_POS   0U
#define DMA_RIF_CH0TC_MSK   BIT(DMA_RIF_CH0TC_POS)

/****************** Bit definition for DMA_IFM register ************************/

#define DMA_IFM_CH5HT_POS   11U
#define DMA_IFM_CH5HT_MSK   BIT(DMA_IFM_CH5HT_POS)

#define DMA_IFM_CH5TC_POS   10U
#define DMA_IFM_CH5TC_MSK   BIT(DMA_IFM_CH5TC_POS)

#define DMA_IFM_CH4HT_POS   9U
#define DMA_IFM_CH4HT_MSK   BIT(DMA_IFM_CH4HT_POS)

#define DMA_IFM_CH4TC_POS   8U
#define DMA_IFM_CH4TC_MSK   BIT(DMA_IFM_CH4TC_POS)

#define DMA_IFM_CH3HT_POS   7U
#define DMA_IFM_CH3HT_MSK   BIT(DMA_IFM_CH3HT_POS)

#define DMA_IFM_CH3TC_POS   6U
#define DMA_IFM_CH3TC_MSK   BIT(DMA_IFM_CH3TC_POS)

#define DMA_IFM_CH2HT_POS   5U
#define DMA_IFM_CH2HT_MSK   BIT(DMA_IFM_CH2HT_POS)

#define DMA_IFM_CH2TC_POS   4U
#define DMA_IFM_CH2TC_MSK   BIT(DMA_IFM_CH2TC_POS)

#define DMA_IFM_CH1HT_POS   3U
#define DMA_IFM_CH1HT_MSK   BIT(DMA_IFM_CH1HT_POS)

#define DMA_IFM_CH1TC_POS   2U
#define DMA_IFM_CH1TC_MSK   BIT(DMA_IFM_CH1TC_POS)

#define DMA_IFM_CH0HT_POS   1U
#define DMA_IFM_CH0HT_MSK   BIT(DMA_IFM_CH0HT_POS)

#define DMA_IFM_CH0TC_POS   0U
#define DMA_IFM_CH0TC_MSK   BIT(DMA_IFM_CH0TC_POS)

/****************** Bit definition for DMA_ICR register ************************/

#define DMA_ICR_CH5HT_POS   11U
#define DMA_ICR_CH5HT_MSK   BIT(DMA_ICR_CH5HT_POS)

#define DMA_ICR_CH5TC_POS   10U
#define DMA_ICR_CH5TC_MSK   BIT(DMA_ICR_CH5TC_POS)

#define DMA_ICR_CH4HT_POS   9U
#define DMA_ICR_CH4HT_MSK   BIT(DMA_ICR_CH4HT_POS)

#define DMA_ICR_CH4TC_POS   8U
#define DMA_ICR_CH4TC_MSK   BIT(DMA_ICR_CH4TC_POS)

#define DMA_ICR_CH3HT_POS   7U
#define DMA_ICR_CH3HT_MSK   BIT(DMA_ICR_CH3HT_POS)

#define DMA_ICR_CH3TC_POS   6U
#define DMA_ICR_CH3TC_MSK   BIT(DMA_ICR_CH3TC_POS)

#define DMA_ICR_CH2HT_POS   5U
#define DMA_ICR_CH2HT_MSK   BIT(DMA_ICR_CH2HT_POS)

#define DMA_ICR_CH2TC_POS   4U
#define DMA_ICR_CH2TC_MSK   BIT(DMA_ICR_CH2TC_POS)

#define DMA_ICR_CH1HT_POS   3U
#define DMA_ICR_CH1HT_MSK   BIT(DMA_ICR_CH1HT_POS)

#define DMA_ICR_CH1TC_POS   2U
#define DMA_ICR_CH1TC_MSK   BIT(DMA_ICR_CH1TC_POS)

#define DMA_ICR_CH0HT_POS   1U
#define DMA_ICR_CH0HT_MSK   BIT(DMA_ICR_CH0HT_POS)

#define DMA_ICR_CH0TC_POS   0U
#define DMA_ICR_CH0TC_MSK   BIT(DMA_ICR_CH0TC_POS)

/****************** Bit definition for DMA_CON register ************************/

#define DMA_CON_MAX_BURST_POSS  16U
#define DMA_CON_MAX_BURST_POSE  19U
#define DMA_CON_MAX_BURST_MSK   BITS(DMA_CON_MAX_BURST_POSS,DMA_CON_MAX_BURST_POSE)

#define DMA_CON_DDWSEL_POSS 13U
#define DMA_CON_DDWSEL_POSE 14U
#define DMA_CON_DDWSEL_MSK  BITS(DMA_CON_DDWSEL_POSS,DMA_CON_DDWSEL_POSE)

#define DMA_CON_DINC_POS    12U
#define DMA_CON_DINC_MSK    BIT(DMA_CON_DINC_POS)

#define DMA_CON_SDWSEL_POSS 9U
#define DMA_CON_SDWSEL_POSE 10U
#define DMA_CON_SDWSEL_MSK  BITS(DMA_CON_SDWSEL_POSS,DMA_CON_SDWSEL_POSE)

#define DMA_CON_SINC_POS    8U
#define DMA_CON_SINC_MSK    BIT(DMA_CON_SINC_POS)

#define DMA_CON_CHPRI_POSS  4U
#define DMA_CON_CHPRI_POSE  5U
#define DMA_CON_CHPRI_MSK   BITS(DMA_CON_CHPRI_POSS,DMA_CON_CHPRI_POSE)

#define DMA_CON_M2M_POS 3U
#define DMA_CON_M2M_MSK BIT(DMA_CON_M2M_POS)

#define DMA_CON_DIR_POS 2U
#define DMA_CON_DIR_MSK BIT(DMA_CON_DIR_POS)

#define DMA_CON_CIRC_POS    1U
#define DMA_CON_CIRC_MSK    BIT(DMA_CON_CIRC_POS)

#define DMA_CON_CHEN_POS    0U
#define DMA_CON_CHEN_MSK    BIT(DMA_CON_CHEN_POS)

/****************** Bit definition for DMA_SAR register ************************/

#define DMA_SAR_SAR_POSS    0U
#define DMA_SAR_SAR_POSE    31U
#define DMA_SAR_SAR_MSK BITS(DMA_SAR_SAR_POSS,DMA_SAR_SAR_POSE)

/****************** Bit definition for DMA_DAR register ************************/

#define DMA_DAR_DAR_POSS    0U
#define DMA_DAR_DAR_POSE    31U
#define DMA_DAR_DAR_MSK BITS(DMA_DAR_DAR_POSS,DMA_DAR_DAR_POSE)

/****************** Bit definition for DMA_NDT register ************************/

#define DMA_NDT_NRDT_POSS   16U
#define DMA_NDT_NRDT_POSE   31U
#define DMA_NDT_NRDT_MSK    BITS(DMA_NDT_NRDT_POSS,DMA_NDT_NRDT_POSE)

#define DMA_NDT_TNDT_POSS   0U
#define DMA_NDT_TNDT_POSE   15U
#define DMA_NDT_TNDT_MSK    BITS(DMA_NDT_TNDT_POSS,DMA_NDT_TNDT_POSE)

typedef struct
{
    __IO uint32_t CON;
    __IO uint32_t SAR;
    __IO uint32_t DAR;
    __IO uint32_t NDT;
} DMA_CHANNEL_Typedef;

typedef struct
{
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __I uint32_t RESERVED[2];
    DMA_CHANNEL_Typedef CH[6];
} DMA_TypeDef;

typedef struct
{
    __IO uint32_t CH_SELCON[DMA_CHANNELS];
} DMA_MUX_Typedef;

#define DMA_MUX_MSEL_POSS    8U
#define DMA_MUX_MSEL_MSK     0x3F00U
#define DMA_MUX_MSIGSEL_POSS 0U
#define DMA_MUX_MSIGSEL_MSK  0xFU
#define DMA_MUX_SINGLE_POSS  31U
#define DMA_MUX_SINGLE_MSK   0x80000000U

/****************** Bit definition for PIS_CH0_CON register ************************/

#define PIS_CH0_CON_LEVEL_POSS  31
#define PIS_CH0_CON_LEVEL_MSK  BIT(PIS_CH0_CON_LEVEL_POSS)

#define PIS_CH0_CON_PULSE_POSS  30
#define PIS_CH0_CON_PULSE_MSK  BIT(PIS_CH0_CON_PULSE_POSS)

#define PIS_CH0_CON_SYNCSEL_POSS    24U
#define PIS_CH0_CON_SYNCSEL_POSE    26U
#define PIS_CH0_CON_SYNCSEL_MSK BITS(PIS_CH0_CON_SYNCSEL_POSS,PIS_CH0_CON_SYNCSEL_POSE)

#define PIS_CH0_CON_PULCK_POSS  18U
#define PIS_CH0_CON_PULCK_POSE  19U
#define PIS_CH0_CON_PULCK_MSK   BITS(PIS_CH0_CON_PULCK_POSS,PIS_CH0_CON_PULCK_POSE)

#define PIS_CH0_CON_EDGS_POSS   16U
#define PIS_CH0_CON_EDGS_POSE   17U
#define PIS_CH0_CON_EDGS_MSK    BITS(PIS_CH0_CON_EDGS_POSS,PIS_CH0_CON_EDGS_POSE)

#define PIS_CH0_CON_SRCS_POSS   8U
#define PIS_CH0_CON_SRCS_POSE   13U
#define PIS_CH0_CON_SRCS_MSK    BITS(PIS_CH0_CON_SRCS_POSS,PIS_CH0_CON_SRCS_POSE)

#define PIS_CH0_CON_MSIGS_POSS  0U
#define PIS_CH0_CON_MSIGS_POSE  3U
#define PIS_CH0_CON_MSIGS_MSK   BITS(PIS_CH0_CON_MSIGS_POSS,PIS_CH0_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH1_CON register ************************/

#define PIS_CH1_CON_LEVEL_POSS  31
#define PIS_CH1_CON_LEVEL_MSK  BIT(PIS_CH1_CON_LEVEL_POSS)

#define PIS_CH1_CON_PULSE_POSS  30
#define PIS_CH1_CON_PULSE_MSK  BIT(PIS_CH1_CON_PULSE_POSS)

#define PIS_CH1_CON_SYNCSEL_POSS    24U
#define PIS_CH1_CON_SYNCSEL_POSE    26U
#define PIS_CH1_CON_SYNCSEL_MSK BITS(PIS_CH1_CON_SYNCSEL_POSS,PIS_CH1_CON_SYNCSEL_POSE)

#define PIS_CH1_CON_PULCK_POSS  18U
#define PIS_CH1_CON_PULCK_POSE  19U
#define PIS_CH1_CON_PULCK_MSK   BITS(PIS_CH1_CON_PULCK_POSS,PIS_CH1_CON_PULCK_POSE)

#define PIS_CH1_CON_EDGS_POSS   16U
#define PIS_CH1_CON_EDGS_POSE   17U
#define PIS_CH1_CON_EDGS_MSK    BITS(PIS_CH1_CON_EDGS_POSS,PIS_CH1_CON_EDGS_POSE)

#define PIS_CH1_CON_SRCS_POSS   8U
#define PIS_CH1_CON_SRCS_POSE   13U
#define PIS_CH1_CON_SRCS_MSK    BITS(PIS_CH1_CON_SRCS_POSS,PIS_CH1_CON_SRCS_POSE)

#define PIS_CH1_CON_MSIGS_POSS  0U
#define PIS_CH1_CON_MSIGS_POSE  3U
#define PIS_CH1_CON_MSIGS_MSK   BITS(PIS_CH1_CON_MSIGS_POSS,PIS_CH1_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH2_CON register ************************/

#define PIS_CH2_CON_LEVEL_POSS  31
#define PIS_CH2_CON_LEVEL_MSK  BIT(PIS_CH2_CON_LEVEL_POSS)

#define PIS_CH2_CON_PULSE_POSS  30
#define PIS_CH2_CON_PULSE_MSK  BIT(PIS_CH2_CON_PULSE_POSS)

#define PIS_CH2_CON_SYNCSEL_POSS    24U
#define PIS_CH2_CON_SYNCSEL_POSE    26U
#define PIS_CH2_CON_SYNCSEL_MSK BITS(PIS_CH2_CON_SYNCSEL_POSS,PIS_CH2_CON_SYNCSEL_POSE)

#define PIS_CH2_CON_PULCK_POSS  18U
#define PIS_CH2_CON_PULCK_POSE  19U
#define PIS_CH2_CON_PULCK_MSK   BITS(PIS_CH2_CON_PULCK_POSS,PIS_CH2_CON_PULCK_POSE)

#define PIS_CH2_CON_EDGS_POSS   16U
#define PIS_CH2_CON_EDGS_POSE   17U
#define PIS_CH2_CON_EDGS_MSK    BITS(PIS_CH2_CON_EDGS_POSS,PIS_CH2_CON_EDGS_POSE)

#define PIS_CH2_CON_SRCS_POSS   8U
#define PIS_CH2_CON_SRCS_POSE   13U
#define PIS_CH2_CON_SRCS_MSK    BITS(PIS_CH2_CON_SRCS_POSS,PIS_CH2_CON_SRCS_POSE)

#define PIS_CH2_CON_MSIGS_POSS  0U
#define PIS_CH2_CON_MSIGS_POSE  3U
#define PIS_CH2_CON_MSIGS_MSK   BITS(PIS_CH2_CON_MSIGS_POSS,PIS_CH2_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH3_CON register ************************/

#define PIS_CH3_CON_LEVEL_POSS  31
#define PIS_CH3_CON_LEVEL_MSK  BIT(PIS_CH3_CON_LEVEL_POSS)

#define PIS_CH3_CON_PULSE_POSS  30
#define PIS_CH3_CON_PULSE_MSK  BIT(PIS_CH3_CON_PULSE_POSS)

#define PIS_CH3_CON_SYNCSEL_POSS    24U
#define PIS_CH3_CON_SYNCSEL_POSE    26U
#define PIS_CH3_CON_SYNCSEL_MSK BITS(PIS_CH3_CON_SYNCSEL_POSS,PIS_CH3_CON_SYNCSEL_POSE)

#define PIS_CH3_CON_PULCK_POSS  18U
#define PIS_CH3_CON_PULCK_POSE  19U
#define PIS_CH3_CON_PULCK_MSK   BITS(PIS_CH3_CON_PULCK_POSS,PIS_CH3_CON_PULCK_POSE)

#define PIS_CH3_CON_EDGS_POSS   16U
#define PIS_CH3_CON_EDGS_POSE   17U
#define PIS_CH3_CON_EDGS_MSK    BITS(PIS_CH3_CON_EDGS_POSS,PIS_CH3_CON_EDGS_POSE)

#define PIS_CH3_CON_SRCS_POSS   8U
#define PIS_CH3_CON_SRCS_POSE   13U
#define PIS_CH3_CON_SRCS_MSK    BITS(PIS_CH3_CON_SRCS_POSS,PIS_CH3_CON_SRCS_POSE)

#define PIS_CH3_CON_MSIGS_POSS  0U
#define PIS_CH3_CON_MSIGS_POSE  3U
#define PIS_CH3_CON_MSIGS_MSK   BITS(PIS_CH3_CON_MSIGS_POSS,PIS_CH3_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH4_CON register ************************/

#define PIS_CH4_CON_LEVEL_POSS  31
#define PIS_CH4_CON_LEVEL_MSK  BIT(PIS_CH4_CON_LEVEL_POSS)

#define PIS_CH4_CON_PULSE_POSS  30
#define PIS_CH4_CON_PULSE_MSK  BIT(PIS_CH4_CON_PULSE_POSS)

#define PIS_CH4_CON_SYNCSEL_POSS    24U
#define PIS_CH4_CON_SYNCSEL_POSE    26U
#define PIS_CH4_CON_SYNCSEL_MSK BITS(PIS_CH4_CON_SYNCSEL_POSS,PIS_CH4_CON_SYNCSEL_POSE)

#define PIS_CH4_CON_PULCK_POSS  18U
#define PIS_CH4_CON_PULCK_POSE  19U
#define PIS_CH4_CON_PULCK_MSK   BITS(PIS_CH4_CON_PULCK_POSS,PIS_CH4_CON_PULCK_POSE)

#define PIS_CH4_CON_EDGS_POSS   16U
#define PIS_CH4_CON_EDGS_POSE   17U
#define PIS_CH4_CON_EDGS_MSK    BITS(PIS_CH4_CON_EDGS_POSS,PIS_CH4_CON_EDGS_POSE)

#define PIS_CH4_CON_SRCS_POSS   8U
#define PIS_CH4_CON_SRCS_POSE   13U
#define PIS_CH4_CON_SRCS_MSK    BITS(PIS_CH4_CON_SRCS_POSS,PIS_CH4_CON_SRCS_POSE)

#define PIS_CH4_CON_MSIGS_POSS  0U
#define PIS_CH4_CON_MSIGS_POSE  3U
#define PIS_CH4_CON_MSIGS_MSK   BITS(PIS_CH4_CON_MSIGS_POSS,PIS_CH4_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH5_CON register ************************/

#define PIS_CH5_CON_LEVEL_POSS  31
#define PIS_CH5_CON_LEVEL_MSK  BIT(PIS_CH5_CON_LEVEL_POSS)

#define PIS_CH5_CON_PULSE_POSS  30
#define PIS_CH5_CON_PULSE_MSK  BIT(PIS_CH5_CON_PULSE_POSS)

#define PIS_CH5_CON_SYNCSEL_POSS    24U
#define PIS_CH5_CON_SYNCSEL_POSE    26U
#define PIS_CH5_CON_SYNCSEL_MSK BITS(PIS_CH5_CON_SYNCSEL_POSS,PIS_CH5_CON_SYNCSEL_POSE)

#define PIS_CH5_CON_PULCK_POSS  18U
#define PIS_CH5_CON_PULCK_POSE  19U
#define PIS_CH5_CON_PULCK_MSK   BITS(PIS_CH5_CON_PULCK_POSS,PIS_CH5_CON_PULCK_POSE)

#define PIS_CH5_CON_EDGS_POSS   16U
#define PIS_CH5_CON_EDGS_POSE   17U
#define PIS_CH5_CON_EDGS_MSK    BITS(PIS_CH5_CON_EDGS_POSS,PIS_CH5_CON_EDGS_POSE)

#define PIS_CH5_CON_SRCS_POSS   8U
#define PIS_CH5_CON_SRCS_POSE   13U
#define PIS_CH5_CON_SRCS_MSK    BITS(PIS_CH5_CON_SRCS_POSS,PIS_CH5_CON_SRCS_POSE)

#define PIS_CH5_CON_MSIGS_POSS  0U
#define PIS_CH5_CON_MSIGS_POSE  3U
#define PIS_CH5_CON_MSIGS_MSK   BITS(PIS_CH5_CON_MSIGS_POSS,PIS_CH5_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH6_CON register ************************/

#define PIS_CH6_CON_LEVEL_POSS  31
#define PIS_CH6_CON_LEVEL_MSK  BIT(PIS_CH6_CON_LEVEL_POSS)

#define PIS_CH6_CON_PULSE_POSS  30
#define PIS_CH6_CON_PULSE_MSK  BIT(PIS_CH6_CON_PULSE_POSS)

#define PIS_CH6_CON_SYNCSEL_POSS    24U
#define PIS_CH6_CON_SYNCSEL_POSE    26U
#define PIS_CH6_CON_SYNCSEL_MSK BITS(PIS_CH6_CON_SYNCSEL_POSS,PIS_CH6_CON_SYNCSEL_POSE)

#define PIS_CH6_CON_PULCK_POSS  18U
#define PIS_CH6_CON_PULCK_POSE  19U
#define PIS_CH6_CON_PULCK_MSK   BITS(PIS_CH6_CON_PULCK_POSS,PIS_CH6_CON_PULCK_POSE)

#define PIS_CH6_CON_EDGS_POSS   16U
#define PIS_CH6_CON_EDGS_POSE   17U
#define PIS_CH6_CON_EDGS_MSK    BITS(PIS_CH6_CON_EDGS_POSS,PIS_CH6_CON_EDGS_POSE)

#define PIS_CH6_CON_SRCS_POSS   8U
#define PIS_CH6_CON_SRCS_POSE   13U
#define PIS_CH6_CON_SRCS_MSK    BITS(PIS_CH6_CON_SRCS_POSS,PIS_CH6_CON_SRCS_POSE)

#define PIS_CH6_CON_MSIGS_POSS  0U
#define PIS_CH6_CON_MSIGS_POSE  3U
#define PIS_CH6_CON_MSIGS_MSK   BITS(PIS_CH6_CON_MSIGS_POSS,PIS_CH6_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH7_CON register ************************/

#define PIS_CH7_CON_LEVEL_POSS  31
#define PIS_CH7_CON_LEVEL_MSK  BIT(PIS_CH7_CON_LEVEL_POSS)

#define PIS_CH7_CON_PULSE_POSS  30
#define PIS_CH7_CON_PULSE_MSK  BIT(PIS_CH7_CON_PULSE_POSS)

#define PIS_CH7_CON_SYNCSEL_POSS    24U
#define PIS_CH7_CON_SYNCSEL_POSE    26U
#define PIS_CH7_CON_SYNCSEL_MSK BITS(PIS_CH7_CON_SYNCSEL_POSS,PIS_CH7_CON_SYNCSEL_POSE)

#define PIS_CH7_CON_PULCK_POSS  18U
#define PIS_CH7_CON_PULCK_POSE  19U
#define PIS_CH7_CON_PULCK_MSK   BITS(PIS_CH7_CON_PULCK_POSS,PIS_CH7_CON_PULCK_POSE)

#define PIS_CH7_CON_EDGS_POSS   16U
#define PIS_CH7_CON_EDGS_POSE   17U
#define PIS_CH7_CON_EDGS_MSK    BITS(PIS_CH7_CON_EDGS_POSS,PIS_CH7_CON_EDGS_POSE)

#define PIS_CH7_CON_SRCS_POSS   8U
#define PIS_CH7_CON_SRCS_POSE   13U
#define PIS_CH7_CON_SRCS_MSK    BITS(PIS_CH7_CON_SRCS_POSS,PIS_CH7_CON_SRCS_POSE)

#define PIS_CH7_CON_MSIGS_POSS  0U
#define PIS_CH7_CON_MSIGS_POSE  3U
#define PIS_CH7_CON_MSIGS_MSK   BITS(PIS_CH7_CON_MSIGS_POSS,PIS_CH7_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH8_CON register ************************/

#define PIS_CH8_CON_LEVEL_POSS  31
#define PIS_CH8_CON_LEVEL_MSK  BIT(PIS_CH8_CON_LEVEL_POSS)

#define PIS_CH8_CON_PULSE_POSS  30
#define PIS_CH8_CON_PULSE_MSK  BIT(PIS_CH8_CON_PULSE_POSS)

#define PIS_CH8_CON_SYNCSEL_POSS    24U
#define PIS_CH8_CON_SYNCSEL_POSE    26U
#define PIS_CH8_CON_SYNCSEL_MSK BITS(PIS_CH8_CON_SYNCSEL_POSS,PIS_CH8_CON_SYNCSEL_POSE)

#define PIS_CH8_CON_PULCK_POSS  18U
#define PIS_CH8_CON_PULCK_POSE  19U
#define PIS_CH8_CON_PULCK_MSK   BITS(PIS_CH8_CON_PULCK_POSS,PIS_CH8_CON_PULCK_POSE)

#define PIS_CH8_CON_EDGS_POSS   16U
#define PIS_CH8_CON_EDGS_POSE   17U
#define PIS_CH8_CON_EDGS_MSK    BITS(PIS_CH8_CON_EDGS_POSS,PIS_CH8_CON_EDGS_POSE)

#define PIS_CH8_CON_SRCS_POSS   8U
#define PIS_CH8_CON_SRCS_POSE   13U
#define PIS_CH8_CON_SRCS_MSK    BITS(PIS_CH8_CON_SRCS_POSS,PIS_CH8_CON_SRCS_POSE)

#define PIS_CH8_CON_MSIGS_POSS  0U
#define PIS_CH8_CON_MSIGS_POSE  3U
#define PIS_CH8_CON_MSIGS_MSK   BITS(PIS_CH8_CON_MSIGS_POSS,PIS_CH8_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH9_CON register ************************/

#define PIS_CH9_CON_LEVEL_POSS  31
#define PIS_CH9_CON_LEVEL_MSK  BIT(PIS_CH9_CON_LEVEL_POSS)

#define PIS_CH9_CON_PULSE_POSS  30
#define PIS_CH9_CON_PULSE_MSK  BIT(PIS_CH9_CON_PULSE_POSS)

#define PIS_CH9_CON_SYNCSEL_POSS    24U
#define PIS_CH9_CON_SYNCSEL_POSE    26U
#define PIS_CH9_CON_SYNCSEL_MSK BITS(PIS_CH9_CON_SYNCSEL_POSS,PIS_CH9_CON_SYNCSEL_POSE)

#define PIS_CH9_CON_PULCK_POSS  18U
#define PIS_CH9_CON_PULCK_POSE  19U
#define PIS_CH9_CON_PULCK_MSK   BITS(PIS_CH9_CON_PULCK_POSS,PIS_CH9_CON_PULCK_POSE)

#define PIS_CH9_CON_EDGS_POSS   16U
#define PIS_CH9_CON_EDGS_POSE   17U
#define PIS_CH9_CON_EDGS_MSK    BITS(PIS_CH9_CON_EDGS_POSS,PIS_CH9_CON_EDGS_POSE)

#define PIS_CH9_CON_SRCS_POSS   8U
#define PIS_CH9_CON_SRCS_POSE   13U
#define PIS_CH9_CON_SRCS_MSK    BITS(PIS_CH9_CON_SRCS_POSS,PIS_CH9_CON_SRCS_POSE)

#define PIS_CH9_CON_MSIGS_POSS  0U
#define PIS_CH9_CON_MSIGS_POSE  3U
#define PIS_CH9_CON_MSIGS_MSK   BITS(PIS_CH9_CON_MSIGS_POSS,PIS_CH9_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH10_CON register ************************/

#define PIS_CH10_CON_LEVEL_POSS  31
#define PIS_CH10_CON_LEVEL_MSK  BIT(PIS_CH10_CON_LEVEL_POSS)

#define PIS_CH10_CON_PULSE_POSS  30
#define PIS_CH10_CON_PULSE_MSK  BIT(PIS_CH10_CON_PULSE_POSS)

#define PIS_CH10_CON_SYNCSEL_POSS   24U
#define PIS_CH10_CON_SYNCSEL_POSE   26U
#define PIS_CH10_CON_SYNCSEL_MSK    BITS(PIS_CH10_CON_SYNCSEL_POSS,PIS_CH10_CON_SYNCSEL_POSE)

#define PIS_CH10_CON_PULCK_POSS 18U
#define PIS_CH10_CON_PULCK_POSE 19U
#define PIS_CH10_CON_PULCK_MSK  BITS(PIS_CH10_CON_PULCK_POSS,PIS_CH10_CON_PULCK_POSE)

#define PIS_CH10_CON_EDGS_POSS  16U
#define PIS_CH10_CON_EDGS_POSE  17U
#define PIS_CH10_CON_EDGS_MSK   BITS(PIS_CH10_CON_EDGS_POSS,PIS_CH10_CON_EDGS_POSE)

#define PIS_CH10_CON_SRCS_POSS  8U
#define PIS_CH10_CON_SRCS_POSE  13U
#define PIS_CH10_CON_SRCS_MSK   BITS(PIS_CH10_CON_SRCS_POSS,PIS_CH10_CON_SRCS_POSE)

#define PIS_CH10_CON_MSIGS_POSS 0U
#define PIS_CH10_CON_MSIGS_POSE 3U
#define PIS_CH10_CON_MSIGS_MSK  BITS(PIS_CH10_CON_MSIGS_POSS,PIS_CH10_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH11_CON register ************************/

#define PIS_CH11_CON_LEVEL_POSS  31
#define PIS_CH11_CON_LEVEL_MSK  BIT(PIS_CH11_CON_LEVEL_POSS)

#define PIS_CH11_CON_PULSE_POSS  30
#define PIS_CH11_CON_PULSE_MSK  BIT(PIS_CH11_CON_PULSE_POSS)

#define PIS_CH11_CON_SYNCSEL_POSS   24U
#define PIS_CH11_CON_SYNCSEL_POSE   26U
#define PIS_CH11_CON_SYNCSEL_MSK    BITS(PIS_CH11_CON_SYNCSEL_POSS,PIS_CH11_CON_SYNCSEL_POSE)

#define PIS_CH11_CON_PULCK_POSS 18U
#define PIS_CH11_CON_PULCK_POSE 19U
#define PIS_CH11_CON_PULCK_MSK  BITS(PIS_CH11_CON_PULCK_POSS,PIS_CH11_CON_PULCK_POSE)

#define PIS_CH11_CON_EDGS_POSS  16U
#define PIS_CH11_CON_EDGS_POSE  17U
#define PIS_CH11_CON_EDGS_MSK   BITS(PIS_CH11_CON_EDGS_POSS,PIS_CH11_CON_EDGS_POSE)

#define PIS_CH11_CON_SRCS_POSS  8U
#define PIS_CH11_CON_SRCS_POSE  13U
#define PIS_CH11_CON_SRCS_MSK   BITS(PIS_CH11_CON_SRCS_POSS,PIS_CH11_CON_SRCS_POSE)

#define PIS_CH11_CON_MSIGS_POSS 0U
#define PIS_CH11_CON_MSIGS_POSE 3U
#define PIS_CH11_CON_MSIGS_MSK  BITS(PIS_CH11_CON_MSIGS_POSS,PIS_CH11_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH12_CON register ************************/

#define PIS_CH12_CON_LEVEL_POSS  31
#define PIS_CH12_CON_LEVEL_MSK  BIT(PIS_CH12_CON_LEVEL_POSS)

#define PIS_CH12_CON_PULSE_POSS  30
#define PIS_CH12_CON_PULSE_MSK  BIT(PIS_CH12_CON_PULSE_POSS)

#define PIS_CH12_CON_SYNCSEL_POSS   24U
#define PIS_CH12_CON_SYNCSEL_POSE   26U
#define PIS_CH12_CON_SYNCSEL_MSK    BITS(PIS_CH12_CON_SYNCSEL_POSS,PIS_CH12_CON_SYNCSEL_POSE)

#define PIS_CH12_CON_PULCK_POSS 18U
#define PIS_CH12_CON_PULCK_POSE 19U
#define PIS_CH12_CON_PULCK_MSK  BITS(PIS_CH12_CON_PULCK_POSS,PIS_CH12_CON_PULCK_POSE)

#define PIS_CH12_CON_EDGS_POSS  16U
#define PIS_CH12_CON_EDGS_POSE  17U
#define PIS_CH12_CON_EDGS_MSK   BITS(PIS_CH12_CON_EDGS_POSS,PIS_CH12_CON_EDGS_POSE)

#define PIS_CH12_CON_SRCS_POSS  8U
#define PIS_CH12_CON_SRCS_POSE  13U
#define PIS_CH12_CON_SRCS_MSK   BITS(PIS_CH12_CON_SRCS_POSS,PIS_CH12_CON_SRCS_POSE)

#define PIS_CH12_CON_MSIGS_POSS 0U
#define PIS_CH12_CON_MSIGS_POSE 3U
#define PIS_CH12_CON_MSIGS_MSK  BITS(PIS_CH12_CON_MSIGS_POSS,PIS_CH12_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH13_CON register ************************/

#define PIS_CH13_CON_LEVEL_POSS  31
#define PIS_CH13_CON_LEVEL_MSK  BIT(PIS_CH13_CON_LEVEL_POSS)

#define PIS_CH13_CON_PULSE_POSS  30
#define PIS_CH13_CON_PULSE_MSK  BIT(PIS_CH13_CON_PULSE_POSS)

#define PIS_CH13_CON_SYNCSEL_POSS   24U
#define PIS_CH13_CON_SYNCSEL_POSE   26U
#define PIS_CH13_CON_SYNCSEL_MSK    BITS(PIS_CH13_CON_SYNCSEL_POSS,PIS_CH13_CON_SYNCSEL_POSE)

#define PIS_CH13_CON_PULCK_POSS 18U
#define PIS_CH13_CON_PULCK_POSE 19U
#define PIS_CH13_CON_PULCK_MSK  BITS(PIS_CH13_CON_PULCK_POSS,PIS_CH13_CON_PULCK_POSE)

#define PIS_CH13_CON_EDGS_POSS  16U
#define PIS_CH13_CON_EDGS_POSE  17U
#define PIS_CH13_CON_EDGS_MSK   BITS(PIS_CH13_CON_EDGS_POSS,PIS_CH13_CON_EDGS_POSE)

#define PIS_CH13_CON_SRCS_POSS  8U
#define PIS_CH13_CON_SRCS_POSE  13U
#define PIS_CH13_CON_SRCS_MSK   BITS(PIS_CH13_CON_SRCS_POSS,PIS_CH13_CON_SRCS_POSE)

#define PIS_CH13_CON_MSIGS_POSS 0U
#define PIS_CH13_CON_MSIGS_POSE 3U
#define PIS_CH13_CON_MSIGS_MSK  BITS(PIS_CH13_CON_MSIGS_POSS,PIS_CH13_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH14_CON register ************************/

#define PIS_CH14_CON_LEVEL_POSS  31
#define PIS_CH14_CON_LEVEL_MSK  BIT(PIS_CH14_CON_LEVEL_POSS)

#define PIS_CH14_CON_PULSE_POSS  30
#define PIS_CH14_CON_PULSE_MSK  BIT(PIS_CH14_CON_PULSE_POSS)

#define PIS_CH14_CON_SYNCSEL_POSS   24U
#define PIS_CH14_CON_SYNCSEL_POSE   26U
#define PIS_CH14_CON_SYNCSEL_MSK    BITS(PIS_CH14_CON_SYNCSEL_POSS,PIS_CH14_CON_SYNCSEL_POSE)

#define PIS_CH14_CON_PULCK_POSS 18U
#define PIS_CH14_CON_PULCK_POSE 19U
#define PIS_CH14_CON_PULCK_MSK  BITS(PIS_CH14_CON_PULCK_POSS,PIS_CH14_CON_PULCK_POSE)

#define PIS_CH14_CON_EDGS_POSS  16U
#define PIS_CH14_CON_EDGS_POSE  17U
#define PIS_CH14_CON_EDGS_MSK   BITS(PIS_CH14_CON_EDGS_POSS,PIS_CH14_CON_EDGS_POSE)

#define PIS_CH14_CON_SRCS_POSS  8U
#define PIS_CH14_CON_SRCS_POSE  13U
#define PIS_CH14_CON_SRCS_MSK   BITS(PIS_CH14_CON_SRCS_POSS,PIS_CH14_CON_SRCS_POSE)

#define PIS_CH14_CON_MSIGS_POSS 0U
#define PIS_CH14_CON_MSIGS_POSE 3U
#define PIS_CH14_CON_MSIGS_MSK  BITS(PIS_CH14_CON_MSIGS_POSS,PIS_CH14_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH15_CON register ************************/

#define PIS_CH15_CON_LEVEL_POSS  31
#define PIS_CH15_CON_LEVEL_MSK  BIT(PIS_CH15_CON_LEVEL_POSS)

#define PIS_CH15_CON_PULSE_POSS  30
#define PIS_CH15_CON_PULSE_MSK  BIT(PIS_CH15_CON_PULSE_POSS)

#define PIS_CH15_CON_SYNCSEL_POSS   24U
#define PIS_CH15_CON_SYNCSEL_POSE   26U
#define PIS_CH15_CON_SYNCSEL_MSK    BITS(PIS_CH15_CON_SYNCSEL_POSS,PIS_CH15_CON_SYNCSEL_POSE)

#define PIS_CH15_CON_PULCK_POSS 18U
#define PIS_CH15_CON_PULCK_POSE 19U
#define PIS_CH15_CON_PULCK_MSK  BITS(PIS_CH15_CON_PULCK_POSS,PIS_CH15_CON_PULCK_POSE)

#define PIS_CH15_CON_EDGS_POSS  16U
#define PIS_CH15_CON_EDGS_POSE  17U
#define PIS_CH15_CON_EDGS_MSK   BITS(PIS_CH15_CON_EDGS_POSS,PIS_CH15_CON_EDGS_POSE)

#define PIS_CH15_CON_SRCS_POSS  8U
#define PIS_CH15_CON_SRCS_POSE  13U
#define PIS_CH15_CON_SRCS_MSK   BITS(PIS_CH15_CON_SRCS_POSS,PIS_CH15_CON_SRCS_POSE)

#define PIS_CH15_CON_MSIGS_POSS 0U
#define PIS_CH15_CON_MSIGS_POSE 3U
#define PIS_CH15_CON_MSIGS_MSK  BITS(PIS_CH15_CON_MSIGS_POSS,PIS_CH15_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH_OER register ************************/

#define PIS_CH_OER_CH3OE_POS    3U
#define PIS_CH_OER_CH3OE_MSK    BIT(PIS_CH_OER_CH3OE_POS)

#define PIS_CH_OER_CH2OE_POS    2U
#define PIS_CH_OER_CH2OE_MSK    BIT(PIS_CH_OER_CH2OE_POS)

#define PIS_CH_OER_CH1OE_POS    1U
#define PIS_CH_OER_CH1OE_MSK    BIT(PIS_CH_OER_CH1OE_POS)

#define PIS_CH_OER_CH0OE_POS    0U
#define PIS_CH_OER_CH0OE_MSK    BIT(PIS_CH_OER_CH0OE_POS)

/****************** Bit definition for PIS_TAR_CON0 register ************************/

#define PIS_TAR_CON0_TIM3_CH4IN_SEL_POS 27U
#define PIS_TAR_CON0_TIM3_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH3IN_SEL_POS 26U
#define PIS_TAR_CON0_TIM3_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH2IN_SEL_POS 25U
#define PIS_TAR_CON0_TIM3_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH1IN_SEL_POS 24U
#define PIS_TAR_CON0_TIM3_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH1IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH4IN_SEL_POS 19U
#define PIS_TAR_CON0_TIM2_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH3IN_SEL_POS 18U
#define PIS_TAR_CON0_TIM2_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH2IN_SEL_POS 17U
#define PIS_TAR_CON0_TIM2_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH1IN_SEL_POS 16U
#define PIS_TAR_CON0_TIM2_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH1IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_BRKIN_SEL_POS 4U
#define PIS_TAR_CON0_TIM0_BRKIN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_BRKIN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH4IN_SEL_POS 3U
#define PIS_TAR_CON0_TIM0_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH3IN_SEL_POS 2U
#define PIS_TAR_CON0_TIM0_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH2IN_SEL_POS 1U
#define PIS_TAR_CON0_TIM0_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH1IN_SEL_POS 0U
#define PIS_TAR_CON0_TIM0_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH1IN_SEL_POS)

/****************** Bit definition for PIS_TAR_CON1 register ************************/

#define PIS_TAR_CON1_SPI1_CLK_SEL_POS   15U
#define PIS_TAR_CON1_SPI1_CLK_SEL_MSK   BIT(PIS_TAR_CON1_SPI1_CLK_SEL_POS)

#define PIS_TAR_CON1_SPI1_RX_SEL_POS    14U
#define PIS_TAR_CON1_SPI1_RX_SEL_MSK    BIT(PIS_TAR_CON1_SPI1_RX_SEL_POS)

#define PIS_TAR_CON1_SPI0_CLK_SEL_POS   13U
#define PIS_TAR_CON1_SPI0_CLK_SEL_MSK   BIT(PIS_TAR_CON1_SPI0_CLK_SEL_POS)

#define PIS_TAR_CON1_SPI0_RX_SEL_POS    12U
#define PIS_TAR_CON1_SPI0_RX_SEL_MSK    BIT(PIS_TAR_CON1_SPI0_RX_SEL_POS)

#define PIS_TAR_CON1_LPUART0_RXD_SEL_POS    8U
#define PIS_TAR_CON1_LPUART0_RXD_SEL_MSK    BIT(PIS_TAR_CON1_LPUART0_RXD_SEL_POS)

#define PIS_TAR_CON1_UART5_RXD_SEL_POS  5U
#define PIS_TAR_CON1_UART5_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART5_RXD_SEL_POS)

#define PIS_TAR_CON1_UART4_RXD_SEL_POS  4U
#define PIS_TAR_CON1_UART4_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART4_RXD_SEL_POS)

#define PIS_TAR_CON1_UART3_RXD_SEL_POS  3U
#define PIS_TAR_CON1_UART3_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART3_RXD_SEL_POS)

#define PIS_TAR_CON1_UART2_RXD_SEL_POS  2U
#define PIS_TAR_CON1_UART2_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART2_RXD_SEL_POS)

#define PIS_TAR_CON1_UART1_RXD_SEL_POS  1U
#define PIS_TAR_CON1_UART1_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART1_RXD_SEL_POS)

#define PIS_TAR_CON1_UART0_RXD_SEL_POS  0U
#define PIS_TAR_CON1_UART0_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART0_RXD_SEL_POS)

/****************** Bit definition for PIS_UART0_TXMCR register ************************/

#define PIS_UART0_TXMCR_TXMLVLS_POS 8U
#define PIS_UART0_TXMCR_TXMLVLS_MSK BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define PIS_UART0_TXMCR_TXMSS_POSS  4U
#define PIS_UART0_TXMCR_TXMSS_POSE  7U
#define PIS_UART0_TXMCR_TXMSS_MSK   BITS(PIS_UART0_TXMCR_TXMSS_POSS,PIS_UART0_TXMCR_TXMSS_POSE)

#define PIS_UART0_TXMCR_TXSIGS_POSS 0U
#define PIS_UART0_TXMCR_TXSIGS_POSE 3U
#define PIS_UART0_TXMCR_TXSIGS_MSK  BITS(PIS_UART0_TXMCR_TXSIGS_POSS,PIS_UART0_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART1_TXMCR register ************************/

#define PIS_UART1_TXMCR_TXMLVLS_POS 8U
#define PIS_UART1_TXMCR_TXMLVLS_MSK BIT(PIS_UART1_TXMCR_TXMLVLS_POS)

#define PIS_UART1_TXMCR_TXMSS_POSS  4U
#define PIS_UART1_TXMCR_TXMSS_POSE  7U
#define PIS_UART1_TXMCR_TXMSS_MSK   BITS(PIS_UART1_TXMCR_TXMSS_POSS,PIS_UART1_TXMCR_TXMSS_POSE)

#define PIS_UART1_TXMCR_TXSIGS_POSS 0U
#define PIS_UART1_TXMCR_TXSIGS_POSE 3U
#define PIS_UART1_TXMCR_TXSIGS_MSK  BITS(PIS_UART1_TXMCR_TXSIGS_POSS,PIS_UART1_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART2_TXMCR register ************************/

#define PIS_UART2_TXMCR_TXMLVLS_POS 8U
#define PIS_UART2_TXMCR_TXMLVLS_MSK BIT(PIS_UART2_TXMCR_TXMLVLS_POS)

#define PIS_UART2_TXMCR_TXMSS_POSS  4U
#define PIS_UART2_TXMCR_TXMSS_POSE  7U
#define PIS_UART2_TXMCR_TXMSS_MSK   BITS(PIS_UART2_TXMCR_TXMSS_POSS,PIS_UART2_TXMCR_TXMSS_POSE)

#define PIS_UART2_TXMCR_TXSIGS_POSS 0U
#define PIS_UART2_TXMCR_TXSIGS_POSE 3U
#define PIS_UART2_TXMCR_TXSIGS_MSK  BITS(PIS_UART2_TXMCR_TXSIGS_POSS,PIS_UART2_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART3_TXMCR register ************************/

#define PIS_UART3_TXMCR_TXMLVLS_POS 8U
#define PIS_UART3_TXMCR_TXMLVLS_MSK BIT(PIS_UART3_TXMCR_TXMLVLS_POS)

#define PIS_UART3_TXMCR_TXMSS_POSS  4U
#define PIS_UART3_TXMCR_TXMSS_POSE  7U
#define PIS_UART3_TXMCR_TXMSS_MSK   BITS(PIS_UART3_TXMCR_TXMSS_POSS,PIS_UART3_TXMCR_TXMSS_POSE)

#define PIS_UART3_TXMCR_TXSIGS_POSS 0U
#define PIS_UART3_TXMCR_TXSIGS_POSE 3U
#define PIS_UART3_TXMCR_TXSIGS_MSK  BITS(PIS_UART3_TXMCR_TXSIGS_POSS,PIS_UART3_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART4_TXMCR register ************************/

#define PIS_UART4_TXMCR_TXMLVLS_POS 8U
#define PIS_UART4_TXMCR_TXMLVLS_MSK BIT(PIS_UART4_TXMCR_TXMLVLS_POS)

#define PIS_UART4_TXMCR_TXMSS_POSS  4U
#define PIS_UART4_TXMCR_TXMSS_POSE  7U
#define PIS_UART4_TXMCR_TXMSS_MSK   BITS(PIS_UART4_TXMCR_TXMSS_POSS,PIS_UART4_TXMCR_TXMSS_POSE)

#define PIS_UART4_TXMCR_TXSIGS_POSS 0U
#define PIS_UART4_TXMCR_TXSIGS_POSE 3U
#define PIS_UART4_TXMCR_TXSIGS_MSK  BITS(PIS_UART4_TXMCR_TXSIGS_POSS,PIS_UART4_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART5_TXMCR register ************************/

#define PIS_UART5_TXMCR_TXMLVLS_POS 8U
#define PIS_UART5_TXMCR_TXMLVLS_MSK BIT(PIS_UART5_TXMCR_TXMLVLS_POS)

#define PIS_UART5_TXMCR_TXMSS_POSS  4U
#define PIS_UART5_TXMCR_TXMSS_POSE  7U
#define PIS_UART5_TXMCR_TXMSS_MSK   BITS(PIS_UART5_TXMCR_TXMSS_POSS,PIS_UART5_TXMCR_TXMSS_POSE)

#define PIS_UART5_TXMCR_TXSIGS_POSS 0U
#define PIS_UART5_TXMCR_TXSIGS_POSE 3U
#define PIS_UART5_TXMCR_TXSIGS_MSK  BITS(PIS_UART5_TXMCR_TXSIGS_POSS,PIS_UART5_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_LPUART0_TXMCR register ************************/

#define PIS_LPUART0_TXMCR_TXMLVLS_POS   8U
#define PIS_LPUART0_TXMCR_TXMLVLS_MSK   BIT(PIS_LPUART0_TXMCR_TXMLVLS_POS)

#define PIS_LPUART0_TXMCR_TXMSS_POSS    4U
#define PIS_LPUART0_TXMCR_TXMSS_POSE    7U
#define PIS_LPUART0_TXMCR_TXMSS_MSK BITS(PIS_LPUART0_TXMCR_TXMSS_POSS,PIS_LPUART0_TXMCR_TXMSS_POSE)

#define PIS_LPUART0_TXMCR_TXSIGS_POSS   0U
#define PIS_LPUART0_TXMCR_TXSIGS_POSE   3U
#define PIS_LPUART0_TXMCR_TXSIGS_MSK    BITS(PIS_LPUART0_TXMCR_TXSIGS_POSS,PIS_LPUART0_TXMCR_TXSIGS_POSE)

typedef struct
{
    __IO uint32_t CH_CON[16];
    __IO uint32_t CH_OER;
    __IO uint32_t TAR_CON0;
    __IO uint32_t TAR_CON1;
    uint32_t RESERVED0[5];
    __IO uint32_t UART0_TXMCR;
    __IO uint32_t UART1_TXMCR;
    __IO uint32_t UART2_TXMCR;
    __IO uint32_t UART3_TXMCR;
    __IO uint32_t UART4_TXMCR;
    __IO uint32_t UART5_TXMCR;
    uint32_t RESERVED1[2];
    __IO uint32_t LPUART0_TXMCR;
} PIS_TypeDef;

/****************** Bit definition for LP16T_CON0 register ************************/

#define LP16T_CON0_PRELOAD_POS  22U
#define LP16T_CON0_PRELOAD_MSK  BIT(LP16T_CON0_PRELOAD_POS)

#define LP16T_CON0_WAVEPOL_POS  21U
#define LP16T_CON0_WAVEPOL_MSK  BIT(LP16T_CON0_WAVEPOL_POS)

#define LP16T_CON0_WAVE_POSS    19U
#define LP16T_CON0_WAVE_POSE    20U
#define LP16T_CON0_WAVE_MSK BITS(LP16T_CON0_WAVE_POSS,LP16T_CON0_WAVE_POSE)

#define LP16T_CON0_TRIGEN_POSS  17U
#define LP16T_CON0_TRIGEN_POSE  18U
#define LP16T_CON0_TRIGEN_MSK   BITS(LP16T_CON0_TRIGEN_POSS,LP16T_CON0_TRIGEN_POSE)

#define LP16T_CON0_TRIGSEL_POSS 13U
#define LP16T_CON0_TRIGSEL_POSE 15U
#define LP16T_CON0_TRIGSEL_MSK  BITS(LP16T_CON0_TRIGSEL_POSS,LP16T_CON0_TRIGSEL_POSE)

#define LP16T_CON0_PRESC_POSS   9U
#define LP16T_CON0_PRESC_POSE   11U
#define LP16T_CON0_PRESC_MSK    BITS(LP16T_CON0_PRESC_POSS,LP16T_CON0_PRESC_POSE)

#define LP16T_CON0_TRGFLT_POSS  6U
#define LP16T_CON0_TRGFLT_POSE  7U
#define LP16T_CON0_TRGFLT_MSK   BITS(LP16T_CON0_TRGFLT_POSS,LP16T_CON0_TRGFLT_POSE)

#define LP16T_CON0_CKFLT_POSS   3U
#define LP16T_CON0_CKFLT_POSE   4U
#define LP16T_CON0_CKFLT_MSK    BITS(LP16T_CON0_CKFLT_POSS,LP16T_CON0_CKFLT_POSE)

#define LP16T_CON0_CKPOL_POS    1U
#define LP16T_CON0_CKPOL_MSK    BIT(LP16T_CON0_CKPOL_POS)

#define LP16T_CON0_CKSEL_POS    0U
#define LP16T_CON0_CKSEL_MSK    BIT(LP16T_CON0_CKSEL_POS)

/****************** Bit definition for LP16T_CON1 register ************************/

#define LP16T_CON1_CNTSTRT_POS  2U
#define LP16T_CON1_CNTSTRT_MSK  BIT(LP16T_CON1_CNTSTRT_POS)

#define LP16T_CON1_SNGSTRT_POS  1U
#define LP16T_CON1_SNGSTRT_MSK  BIT(LP16T_CON1_SNGSTRT_POS)

#define LP16T_CON1_ENABLE_POS   0U
#define LP16T_CON1_ENABLE_MSK   BIT(LP16T_CON1_ENABLE_POS)

/****************** Bit definition for LP16T_ARR register ************************/

#define LP16T_ARR_ARR_POSS  0U
#define LP16T_ARR_ARR_POSE  15U
#define LP16T_ARR_ARR_MSK   BITS(LP16T_ARR_ARR_POSS,LP16T_ARR_ARR_POSE)

/****************** Bit definition for LP16T_CNT register ************************/

#define LP16T_CNT_CNT_POSS  0U
#define LP16T_CNT_CNT_POSE  15U
#define LP16T_CNT_CNT_MSK   BITS(LP16T_CNT_CNT_POSS,LP16T_CNT_CNT_POSE)

/****************** Bit definition for LP16T_CMP register ************************/

#define LP16T_CMP_CMP_POSS  0U
#define LP16T_CMP_CMP_POSE  15U
#define LP16T_CMP_CMP_MSK   BITS(LP16T_CMP_CMP_POSS,LP16T_CMP_CMP_POSE)

/****************** Bit definition for LP16T_IER register ************************/

#define LP16T_IER_EXTTRIGIE_POS 2U
#define LP16T_IER_EXTTRIGIE_MSK BIT(LP16T_IER_EXTTRIGIE_POS)

#define LP16T_IER_ARRMIE_POS    1U
#define LP16T_IER_ARRMIE_MSK    BIT(LP16T_IER_ARRMIE_POS)

#define LP16T_IER_CMPMIE_POS    0U
#define LP16T_IER_CMPMIE_MSK    BIT(LP16T_IER_CMPMIE_POS)

/****************** Bit definition for LP16T_ISR register ************************/

#define LP16T_ISR_EXTTRIG_POS   2U
#define LP16T_ISR_EXTTRIG_MSK   BIT(LP16T_ISR_EXTTRIG_POS)

#define LP16T_ISR_ARRM_POS  1U
#define LP16T_ISR_ARRM_MSK  BIT(LP16T_ISR_ARRM_POS)

#define LP16T_ISR_CMPM_POS  0U
#define LP16T_ISR_CMPM_MSK  BIT(LP16T_ISR_CMPM_POS)

/****************** Bit definition for LP16T_IFC register ************************/

#define LP16T_IFC_EXTTRIG_POS   2U
#define LP16T_IFC_EXTTRIG_MSK   BIT(LP16T_IFC_EXTTRIG_POS)

#define LP16T_IFC_ARRM_POS  1U
#define LP16T_IFC_ARRM_MSK  BIT(LP16T_IFC_ARRM_POS)

#define LP16T_IFC_CMPM_POS  0U
#define LP16T_IFC_CMPM_MSK  BIT(LP16T_IFC_CMPM_POS)

/****************** Bit definition for LP16T_UPDATE register ************************/

#define LP16T_UPDATE_UDIS_POS   0U
#define LP16T_UPDATE_UDIS_MSK   BIT(LP16T_UPDATE_UDIS_POS)

/****************** Bit definition for LP16T_SYNCSTAT register ************************/

#define LP16T_SYNCSTAT_CMPWBSY_POS  3U
#define LP16T_SYNCSTAT_CMPWBSY_MSK  BIT(LP16T_SYNCSTAT_CMPWBSY_POS)

#define LP16T_SYNCSTAT_ARRWBSY_POS  2U
#define LP16T_SYNCSTAT_ARRWBSY_MSK  BIT(LP16T_SYNCSTAT_ARRWBSY_POS)

#define LP16T_SYNCSTAT_CON1WBSY_POS 1U
#define LP16T_SYNCSTAT_CON1WBSY_MSK BIT(LP16T_SYNCSTAT_CON1WBSY_POS)

typedef struct
{
    __IO uint32_t CON0;
    __IO uint32_t CON1;
    __IO uint32_t ARR;
    __I uint32_t CNT;
    __IO uint32_t CMP;
    uint32_t RESERVED0 ;
    __IO uint32_t IER;
    __I uint32_t ISR;
    __O uint32_t IFC;
    uint32_t RESERVED1[3];
    __IO uint32_t UPDATE;
    __I uint32_t SYNCSTAT;
} LP16T_TypeDef;

/****************** Bit definition for DBGC_IDCODE register ************************/

#define DBGC_IDCODE_REV_ID_POSS 16U
#define DBGC_IDCODE_REV_ID_POSE 31U
#define DBGC_IDCODE_REV_ID_MSK  BITS(DBGC_IDCODE_REV_ID_POSS,DBGC_IDCODE_REV_ID_POSE)

#define DBGC_IDCODE_CORE_ID_POSS    12U
#define DBGC_IDCODE_CORE_ID_POSE    15U
#define DBGC_IDCODE_CORE_ID_MSK BITS(DBGC_IDCODE_CORE_ID_POSS,DBGC_IDCODE_CORE_ID_POSE)

#define DBGC_IDCODE_DEV_ID_POSS 0U
#define DBGC_IDCODE_DEV_ID_POSE 11U
#define DBGC_IDCODE_DEV_ID_MSK  BITS(DBGC_IDCODE_DEV_ID_POSS,DBGC_IDCODE_DEV_ID_POSE)

/****************** Bit definition for DBGC_APBFZ1 register ************************/
#define DBGC_APBFZ1_TIM7_STOP_POS   7U
#define DBGC_APBFZ1_TIM7_STOP_MSK   BIT(DBGC_APBFZ1_TIM7_STOP_POS)

#define DBGC_APBFZ1_TIM6_STOP_POS   6U
#define DBGC_APBFZ1_TIM6_STOP_MSK   BIT(DBGC_APBFZ1_TIM6_STOP_POS)

#define DBGC_APBFZ1_TIM5_STOP_POS   5U
#define DBGC_APBFZ1_TIM5_STOP_MSK   BIT(DBGC_APB1FZ_TIM5_STOP_POS)

#define DBGC_APBFZ1_TIM4_STOP_POS   4U
#define DBGC_APBFZ1_TIM4_STOP_MSK   BIT(DBGC_APBFZ1_TIM4_STOP_POS)

#define DBGC_APBFZ1_TIM3_STOP_POS   3U
#define DBGC_APBFZ1_TIM3_STOP_MSK   BIT(DBGC_APBFZ1_TIM3_STOP_POS)

#define DBGC_APBFZ1_TIM2_STOP_POS   2U
#define DBGC_APBFZ1_TIM2_STOP_MSK   BIT(DBGC_APBFZ1_TIM2_STOP_POS)

#define DBGC_APBFZ1_TIM1_STOP_POS   1U
#define DBGC_APBFZ1_TIM1_STOP_MSK   BIT(DBGC_APBFZ1_TIM1_STOP_POS)

#define DBGC_APBFZ1_TIM0_STOP_POS   0U
#define DBGC_APBFZ1_TIM0_STOP_MSK   BIT(DBGC_APBFZ1_TIM0_STOP_POS)

/****************** Bit definition for DBGC_APBFZ2 register ************************/

#define DBGC_APBFZ2_CAN0_STOP_POS 12U
#define DBGC_APBFZ2_CAN0_STOP_MSK BIT(DBGC_APBFZ2_CAN0_STOP_POS)

#define DBGC_APBFZ2_LPTIM0_STOP_POS 11U
#define DBGC_APBFZ2_LPTIM0_STOP_MSK BIT(DBGC_APBFZ2_LPTIM0_STOP_POS)

#define DBGC_APBFZ2_RTC_STOP_POS    10U
#define DBGC_APBFZ2_RTC_STOP_MSK    BIT(DBGC_APBFZ2_RTC_STOP_POS)

#define DBGC_APBFZ2_WWDT_STOP_POS   9U
#define DBGC_APBFZ2_WWDT_STOP_MSK   BIT(DBGC_APBFZ2_WWDT_STOP_POS)

#define DBGC_APBFZ2_IWDT_STOP_POS   8U
#define DBGC_APBFZ2_IWDT_STOP_MSK   BIT(DBGC_APBFZ2_IWDT_STOP_POS)

#define DBGC_APBFZ2_I2C1_STOP_POS 0U
#define DBGC_APBFZ2_I2C1_STOP_MSK BIT(DBGC_APBFZ2_I2C1_STOP_POS)

#define DBGC_APBFZ2_I2C0_STOP_POS 0U
#define DBGC_APBFZ2_I2C0_STOP_MSK BIT(DBGC_APBFZ2_I2C0_STOP_POS)

typedef struct
{
    __I uint32_t IDCODE;
    uint32_t RESERVED0;
    __IO uint32_t APB1FZ;
    __IO uint32_t APB2FZ;
} DBGC_TypeDef;

/****************** Bit definition for GPIO_DIN register ************************/

#define GPIO_DIN_DIN_POSS   0U
#define GPIO_DIN_DIN_POSE   15U
#define GPIO_DIN_DIN_MSK    BITS(GPIO_DIN_DIN_POSS,GPIO_DIN_DIN_POSE)

/****************** Bit definition for GPIO_DOUT register ************************/

#define GPIO_DOUT_DOUT_POSS 0U
#define GPIO_DOUT_DOUT_POSE 15U
#define GPIO_DOUT_DOUT_MSK  BITS(GPIO_DOUT_DOUT_POSS,GPIO_DOUT_DOUT_POSE)

/****************** Bit definition for GPIO_BSRR register ************************/

#define GPIO_BSRR_BRR_POSS  16U
#define GPIO_BSRR_BRR_POSE  31U
#define GPIO_BSRR_BRR_MSK   BITS(GPIO_BSRR_BRR_POSS,GPIO_BSRR_BRR_POSE)

#define GPIO_BSRR_BSR_POSS  0U
#define GPIO_BSRR_BSR_POSE  15U
#define GPIO_BSRR_BSR_MSK   BITS(GPIO_BSRR_BSR_POSS,GPIO_BSRR_BSR_POSE)

/****************** Bit definition for GPIO_BIR register ************************/

#define GPIO_BIR_BIR_POSS   0U
#define GPIO_BIR_BIR_POSE   15U
#define GPIO_BIR_BIR_MSK    BITS(GPIO_BIR_BIR_POSS,GPIO_BIR_BIR_POSE)

/****************** Bit definition for GPIO_MODE register ************************/

#define GPIO_MODE_MODE_POSS 0U
#define GPIO_MODE_MODE_POSE 31U
#define GPIO_MODE_MODE_MSK  BITS(GPIO_MODE_MODE_POSS,GPIO_MODE_MODE_POSE)

/****************** Bit definition for GPIO_ODOS register ************************/

#define GPIO_ODOS_ODOS_POSS 0U
#define GPIO_ODOS_ODOS_POSE 31U
#define GPIO_ODOS_ODOS_MSK  BITS(GPIO_ODOS_ODOS_POSS,GPIO_ODOS_ODOS_POSE)

/****************** Bit definition for GPIO_PUPD register ************************/

#define GPIO_PUPD_PUPD_POSS 0U
#define GPIO_PUPD_PUPD_POSE 31U
#define GPIO_PUPD_PUPD_MSK  BITS(GPIO_PUPD_PUPD_POSS,GPIO_PUPD_PUPD_POSE)

/****************** Bit definition for GPIO_PODRV register ************************/

#define GPIO_PODRV_PODRV_POSS   0U
#define GPIO_PODRV_PODRV_POSE   31U
#define GPIO_PODRV_PODRV_MSK    BITS(GPIO_PODRV_PODRV_POSS,GPIO_PODRV_PODRV_POSE)

/****************** Bit definition for GPIO_NODRV register ************************/

#define GPIO_NODRV_NODRV_POSS   0U
#define GPIO_NODRV_NODRV_POSE   31U
#define GPIO_NODRV_NODRV_MSK    BITS(GPIO_NODRV_NODRV_POSS,GPIO_NODRV_NODRV_POSE)

/****************** Bit definition for GPIO_FLT register ************************/

#define GPIO_FLT_FLT_POSS   0U
#define GPIO_FLT_FLT_POSE   15U
#define GPIO_FLT_FLT_MSK    BITS(GPIO_FLT_FLT_POSS,GPIO_FLT_FLT_POSE)

/****************** Bit definition for GPIO_TYPE register ************************/

#define GPIO_TYPE_TYPE_POSS 0U
#define GPIO_TYPE_TYPE_POSE 15U
#define GPIO_TYPE_TYPE_MSK  BITS(GPIO_TYPE_TYPE_POSS,GPIO_TYPE_TYPE_POSE)

/****************** Bit definition for GPIO_FUNC0 register ************************/

#define GPIO_FUNC0_FSEL_IO7_POSS    28U
#define GPIO_FUNC0_FSEL_IO7_POSE    31U
#define GPIO_FUNC0_FSEL_IO7_MSK BITS(GPIO_FUNC0_FSEL_IO7_POSS,GPIO_FUNC0_FSEL_IO7_POSE)

#define GPIO_FUNC0_FSEL_IO6_POSS    24U
#define GPIO_FUNC0_FSEL_IO6_POSE    27U
#define GPIO_FUNC0_FSEL_IO6_MSK BITS(GPIO_FUNC0_FSEL_IO6_POSS,GPIO_FUNC0_FSEL_IO6_POSE)

#define GPIO_FUNC0_FSEL_IO5_POSS    20U
#define GPIO_FUNC0_FSEL_IO5_POSE    23U
#define GPIO_FUNC0_FSEL_IO5_MSK BITS(GPIO_FUNC0_FSEL_IO5_POSS,GPIO_FUNC0_FSEL_IO5_POSE)

#define GPIO_FUNC0_FSEL_IO4_POSS    16U
#define GPIO_FUNC0_FSEL_IO4_POSE    19U
#define GPIO_FUNC0_FSEL_IO4_MSK BITS(GPIO_FUNC0_FSEL_IO4_POSS,GPIO_FUNC0_FSEL_IO4_POSE)

#define GPIO_FUNC0_FSEL_IO3_POSS    12U
#define GPIO_FUNC0_FSEL_IO3_POSE    15U
#define GPIO_FUNC0_FSEL_IO3_MSK BITS(GPIO_FUNC0_FSEL_IO3_POSS,GPIO_FUNC0_FSEL_IO3_POSE)

#define GPIO_FUNC0_FSEL_IO2_POSS    8U
#define GPIO_FUNC0_FSEL_IO2_POSE    11U
#define GPIO_FUNC0_FSEL_IO2_MSK BITS(GPIO_FUNC0_FSEL_IO2_POSS,GPIO_FUNC0_FSEL_IO2_POSE)

#define GPIO_FUNC0_FSEL_IO1_POSS    4U
#define GPIO_FUNC0_FSEL_IO1_POSE    7U
#define GPIO_FUNC0_FSEL_IO1_MSK BITS(GPIO_FUNC0_FSEL_IO1_POSS,GPIO_FUNC0_FSEL_IO1_POSE)

#define GPIO_FUNC0_FSEL_IO0_POSS    0U
#define GPIO_FUNC0_FSEL_IO0_POSE    3U
#define GPIO_FUNC0_FSEL_IO0_MSK BITS(GPIO_FUNC0_FSEL_IO0_POSS,GPIO_FUNC0_FSEL_IO0_POSE)

/****************** Bit definition for GPIO_FUNC1 register ************************/

#define GPIO_FUNC1_FSEL_IO15_POSS   28U
#define GPIO_FUNC1_FSEL_IO15_POSE   31U
#define GPIO_FUNC1_FSEL_IO15_MSK    BITS(GPIO_FUNC1_FSEL_IO15_POSS,GPIO_FUNC1_FSEL_IO15_POSE)

#define GPIO_FUNC1_FSEL_IO14_POSS   24U
#define GPIO_FUNC1_FSEL_IO14_POSE   27U
#define GPIO_FUNC1_FSEL_IO14_MSK    BITS(GPIO_FUNC1_FSEL_IO14_POSS,GPIO_FUNC1_FSEL_IO14_POSE)

#define GPIO_FUNC1_FSEL_IO13_POSS   20U
#define GPIO_FUNC1_FSEL_IO13_POSE   23U
#define GPIO_FUNC1_FSEL_IO13_MSK    BITS(GPIO_FUNC1_FSEL_IO13_POSS,GPIO_FUNC1_FSEL_IO13_POSE)

#define GPIO_FUNC1_FSEL_IO12_POSS   16U
#define GPIO_FUNC1_FSEL_IO12_POSE   19U
#define GPIO_FUNC1_FSEL_IO12_MSK    BITS(GPIO_FUNC1_FSEL_IO12_POSS,GPIO_FUNC1_FSEL_IO12_POSE)

#define GPIO_FUNC1_FSEL_IO11_POSS   12U
#define GPIO_FUNC1_FSEL_IO11_POSE   15U
#define GPIO_FUNC1_FSEL_IO11_MSK    BITS(GPIO_FUNC1_FSEL_IO11_POSS,GPIO_FUNC1_FSEL_IO11_POSE)

#define GPIO_FUNC1_FSEL_IO10_POSS   8U
#define GPIO_FUNC1_FSEL_IO10_POSE   11U
#define GPIO_FUNC1_FSEL_IO10_MSK    BITS(GPIO_FUNC1_FSEL_IO10_POSS,GPIO_FUNC1_FSEL_IO10_POSE)

#define GPIO_FUNC1_FSEL_IO9_POSS    4U
#define GPIO_FUNC1_FSEL_IO9_POSE    7U
#define GPIO_FUNC1_FSEL_IO9_MSK BITS(GPIO_FUNC1_FSEL_IO9_POSS,GPIO_FUNC1_FSEL_IO9_POSE)

#define GPIO_FUNC1_FSEL_IO8_POSS    0U
#define GPIO_FUNC1_FSEL_IO8_POSE    3U
#define GPIO_FUNC1_FSEL_IO8_MSK BITS(GPIO_FUNC1_FSEL_IO8_POSS,GPIO_FUNC1_FSEL_IO8_POSE)

/****************** Bit definition for GPIO_LOCK register ************************/

#define GPIO_LOCK_KEY_POSS  16U
#define GPIO_LOCK_KEY_POSE  31U
#define GPIO_LOCK_KEY_MSK   BITS(GPIO_LOCK_KEY_POSS,GPIO_LOCK_KEY_POSE)

#define GPIO_LOCK_LOCK_POSS 0U
#define GPIO_LOCK_LOCK_POSE 15U
#define GPIO_LOCK_LOCK_MSK  BITS(GPIO_LOCK_LOCK_POSS,GPIO_LOCK_LOCK_POSE)

typedef struct
{
    __I uint32_t DIN;
    __IO uint32_t DOUT;
    __O uint32_t BSRR;
    __O uint32_t BIR;
    __IO uint32_t MODE;
    __IO uint32_t ODOS;
    __IO uint32_t PUPD;
    __IO uint32_t PODRV;
    __IO uint32_t NODRV;
    __IO uint32_t FLT;
    __IO uint32_t TYPE;
    __IO uint32_t FUNC0;
    __IO uint32_t FUNC1;
    __IO uint32_t LOCK;
} GPIO_TypeDef;

/****************** Bit definition for GPIO_EXTIRER register ************************/

#define GPIO_EXTIRER_EXTIRER_POSS   0U
#define GPIO_EXTIRER_EXTIRER_POSE   15U
#define GPIO_EXTIRER_EXTIRER_MSK    BITS(GPIO_EXTIRER_EXTIRER_POSS,GPIO_EXTIRER_EXTIRER_POSE)

/****************** Bit definition for GPIO_EXTIFER register ************************/

#define GPIO_EXTIFER_EXTIFER_POSS   0U
#define GPIO_EXTIFER_EXTIFER_POSE   15U
#define GPIO_EXTIFER_EXTIFER_MSK    BITS(GPIO_EXTIFER_EXTIFER_POSS,GPIO_EXTIFER_EXTIFER_POSE)

/****************** Bit definition for GPIO_EXTIEN register ************************/

#define GPIO_EXTIEN_EXTIEN_POSS 0U
#define GPIO_EXTIEN_EXTIEN_POSE 15U
#define GPIO_EXTIEN_EXTIEN_MSK  BITS(GPIO_EXTIEN_EXTIEN_POSS,GPIO_EXTIEN_EXTIEN_POSE)

/****************** Bit definition for GPIO_EXTIFLAG register ************************/

#define GPIO_EXTIFLAG_EXTIFLAG_POSS 0U
#define GPIO_EXTIFLAG_EXTIFLAG_POSE 15U
#define GPIO_EXTIFLAG_EXTIFLAG_MSK  BITS(GPIO_EXTIFLAG_EXTIFLAG_POSS,GPIO_EXTIFLAG_EXTIFLAG_POSE)

/****************** Bit definition for GPIO_EXTISFR register ************************/

#define GPIO_EXTISFR_EXTISFR_POSS   0U
#define GPIO_EXTISFR_EXTISFR_POSE   15U
#define GPIO_EXTISFR_EXTISFR_MSK    BITS(GPIO_EXTISFR_EXTISFR_POSS,GPIO_EXTISFR_EXTISFR_POSE)

/****************** Bit definition for GPIO_EXTICFR register ************************/

#define GPIO_EXTICFR_EXTICFR_POSS   0U
#define GPIO_EXTICFR_EXTICFR_POSE   15U
#define GPIO_EXTICFR_EXTICFR_MSK    BITS(GPIO_EXTICFR_EXTICFR_POSS,GPIO_EXTICFR_EXTICFR_POSE)

/****************** Bit definition for GPIO_EXTIPSR0 register ************************/

#define GPIO_EXTIPSR0_EXTIS7_POSS   28U
#define GPIO_EXTIPSR0_EXTIS7_POSE   30U
#define GPIO_EXTIPSR0_EXTIS7_MSK    BITS(GPIO_EXTIPSR0_EXTIS7_POSS,GPIO_EXTIPSR0_EXTIS7_POSE)

#define GPIO_EXTIPSR0_EXTIS6_POSS   24U
#define GPIO_EXTIPSR0_EXTIS6_POSE   26U
#define GPIO_EXTIPSR0_EXTIS6_MSK    BITS(GPIO_EXTIPSR0_EXTIS6_POSS,GPIO_EXTIPSR0_EXTIS6_POSE)

#define GPIO_EXTIPSR0_EXTIS5_POSS   20U
#define GPIO_EXTIPSR0_EXTIS5_POSE   22U
#define GPIO_EXTIPSR0_EXTIS5_MSK    BITS(GPIO_EXTIPSR0_EXTIS5_POSS,GPIO_EXTIPSR0_EXTIS5_POSE)

#define GPIO_EXTIPSR0_EXTIS4_POSS   16U
#define GPIO_EXTIPSR0_EXTIS4_POSE   18U
#define GPIO_EXTIPSR0_EXTIS4_MSK    BITS(GPIO_EXTIPSR0_EXTIS4_POSS,GPIO_EXTIPSR0_EXTIS4_POSE)

#define GPIO_EXTIPSR0_EXTIS3_POSS   12U
#define GPIO_EXTIPSR0_EXTIS3_POSE   14U
#define GPIO_EXTIPSR0_EXTIS3_MSK    BITS(GPIO_EXTIPSR0_EXTIS3_POSS,GPIO_EXTIPSR0_EXTIS3_POSE)

#define GPIO_EXTIPSR0_EXTIS2_POSS   8U
#define GPIO_EXTIPSR0_EXTIS2_POSE   10U
#define GPIO_EXTIPSR0_EXTIS2_MSK    BITS(GPIO_EXTIPSR0_EXTIS2_POSS,GPIO_EXTIPSR0_EXTIS2_POSE)

#define GPIO_EXTIPSR0_EXTIS1_POSS   4U
#define GPIO_EXTIPSR0_EXTIS1_POSE   6U
#define GPIO_EXTIPSR0_EXTIS1_MSK    BITS(GPIO_EXTIPSR0_EXTIS1_POSS,GPIO_EXTIPSR0_EXTIS1_POSE)

#define GPIO_EXTIPSR0_EXTIS0_POSS   0U
#define GPIO_EXTIPSR0_EXTIS0_POSE   2U
#define GPIO_EXTIPSR0_EXTIS0_MSK    BITS(GPIO_EXTIPSR0_EXTIS0_POSS,GPIO_EXTIPSR0_EXTIS0_POSE)

/****************** Bit definition for GPIO_EXTIPSR1 register ************************/

#define GPIO_EXTIPSR1_EXTIS15_POSS  28U
#define GPIO_EXTIPSR1_EXTIS15_POSE  30U
#define GPIO_EXTIPSR1_EXTIS15_MSK   BITS(GPIO_EXTIPSR1_EXTIS15_POSS,GPIO_EXTIPSR1_EXTIS15_POSE)

#define GPIO_EXTIPSR1_EXTIS14_POSS  24U
#define GPIO_EXTIPSR1_EXTIS14_POSE  26U
#define GPIO_EXTIPSR1_EXTIS14_MSK   BITS(GPIO_EXTIPSR1_EXTIS14_POSS,GPIO_EXTIPSR1_EXTIS14_POSE)

#define GPIO_EXTIPSR1_EXTIS13_POSS  20U
#define GPIO_EXTIPSR1_EXTIS13_POSE  22U
#define GPIO_EXTIPSR1_EXTIS13_MSK   BITS(GPIO_EXTIPSR1_EXTIS13_POSS,GPIO_EXTIPSR1_EXTIS13_POSE)

#define GPIO_EXTIPSR1_EXTIS12_POSS  16U
#define GPIO_EXTIPSR1_EXTIS12_POSE  18U
#define GPIO_EXTIPSR1_EXTIS12_MSK   BITS(GPIO_EXTIPSR1_EXTIS12_POSS,GPIO_EXTIPSR1_EXTIS12_POSE)

#define GPIO_EXTIPSR1_EXTIS11_POSS  12U
#define GPIO_EXTIPSR1_EXTIS11_POSE  14U
#define GPIO_EXTIPSR1_EXTIS11_MSK   BITS(GPIO_EXTIPSR1_EXTIS11_POSS,GPIO_EXTIPSR1_EXTIS11_POSE)

#define GPIO_EXTIPSR1_EXTIS10_POSS  8U
#define GPIO_EXTIPSR1_EXTIS10_POSE  10U
#define GPIO_EXTIPSR1_EXTIS10_MSK   BITS(GPIO_EXTIPSR1_EXTIS10_POSS,GPIO_EXTIPSR1_EXTIS10_POSE)

#define GPIO_EXTIPSR1_EXTIS9_POSS   4U
#define GPIO_EXTIPSR1_EXTIS9_POSE   6U
#define GPIO_EXTIPSR1_EXTIS9_MSK    BITS(GPIO_EXTIPSR1_EXTIS9_POSS,GPIO_EXTIPSR1_EXTIS9_POSE)

#define GPIO_EXTIPSR1_EXTIS8_POSS   0U
#define GPIO_EXTIPSR1_EXTIS8_POSE   2U
#define GPIO_EXTIPSR1_EXTIS8_MSK    BITS(GPIO_EXTIPSR1_EXTIS8_POSS,GPIO_EXTIPSR1_EXTIS8_POSE)

/****************** Bit definition for GPIO_EXTIFLTCR register ************************/

#define GPIO_EXTIFLTCR_FLTCKS_POSS  24U
#define GPIO_EXTIFLTCR_FLTCKS_POSE  25U
#define GPIO_EXTIFLTCR_FLTCKS_MSK   BITS(GPIO_EXTIFLTCR_FLTCKS_POSS,GPIO_EXTIFLTCR_FLTCKS_POSE)

#define GPIO_EXTIFLTCR_FLTSEL_POSS  16U
#define GPIO_EXTIFLTCR_FLTSEL_POSE  23U
#define GPIO_EXTIFLTCR_FLTSEL_MSK   BITS(GPIO_EXTIFLTCR_FLTSEL_POSS,GPIO_EXTIFLTCR_FLTSEL_POSE)

#define GPIO_EXTIFLTCR_FLTEN_POSS   0U
#define GPIO_EXTIFLTCR_FLTEN_POSE   15U
#define GPIO_EXTIFLTCR_FLTEN_MSK    BITS(GPIO_EXTIFLTCR_FLTEN_POSS,GPIO_EXTIFLTCR_FLTEN_POSE)

typedef struct
{
    __IO uint32_t EXTIRER;
    uint32_t RESERVED1 ;
    __IO uint32_t EXTIFER;
    uint32_t RESERVED2 ;
    __IO uint32_t EXTIEN;
    uint32_t RESERVED3 ;
    __I uint32_t EXTIFLAG;
    uint32_t RESERVED4 ;
    __O uint32_t EXTISFR;
    uint32_t RESERVED5 ;
    __O uint32_t EXTICFR;
    uint32_t RESERVED6 ;
    __IO uint32_t EXTIPSR0;
    __IO uint32_t EXTIPSR1;
    uint32_t RESERVED7[2] ;
    __IO uint32_t EXTIFLTCR;
} EXTI_TypeDef;

/****************** Bit definition for RTC_WPR register ************************/

#define RTC_WPR_WP_POS  0U
#define RTC_WPR_WP_MSK  BIT(RTC_WPR_WP_POS)

/****************** Bit definition for RTC_CON register ************************/

#define RTC_CON_SSEC_POS    25U
#define RTC_CON_SSEC_MSK    BIT(RTC_CON_SSEC_POS)

#define RTC_CON_BUSY_POS    24U
#define RTC_CON_BUSY_MSK    BIT(RTC_CON_BUSY_POS)

#define RTC_CON_POL_POS 22U
#define RTC_CON_POL_MSK BIT(RTC_CON_POL_POS)

#define RTC_CON_EOS_POSS    20U
#define RTC_CON_EOS_POSE    21U
#define RTC_CON_EOS_MSK BITS(RTC_CON_EOS_POSS,RTC_CON_EOS_POSE)

#define RTC_CON_CKOS_POSS   17U
#define RTC_CON_CKOS_POSE   19U
#define RTC_CON_CKOS_MSK    BITS(RTC_CON_CKOS_POSS,RTC_CON_CKOS_POSE)

#define RTC_CON_CKOE_POS    16U
#define RTC_CON_CKOE_MSK    BIT(RTC_CON_CKOE_POS)

#define RTC_CON_WUCKS_POSS  13U
#define RTC_CON_WUCKS_POSE  15U
#define RTC_CON_WUCKS_MSK   BITS(RTC_CON_WUCKS_POSS,RTC_CON_WUCKS_POSE)

#define RTC_CON_WUTE_POS    12U
#define RTC_CON_WUTE_MSK    BIT(RTC_CON_WUTE_POS)

#define RTC_CON_DSTS_POS    10U
#define RTC_CON_DSTS_MSK    BIT(RTC_CON_DSTS_POS)

#define RTC_CON_SUB1H_POS   9U
#define RTC_CON_SUB1H_MSK   BIT(RTC_CON_SUB1H_POS)

#define RTC_CON_ADD1H_POS   8U
#define RTC_CON_ADD1H_MSK   BIT(RTC_CON_ADD1H_POS)

#define RTC_CON_TSPIN_POS   7U
#define RTC_CON_TSPIN_MSK   BIT(RTC_CON_TSPIN_POS)

#define RTC_CON_TSSEL_POS   6U
#define RTC_CON_TSSEL_MSK   BIT(RTC_CON_TSSEL_POS)

#define RTC_CON_TSEN_POS    5U
#define RTC_CON_TSEN_MSK    BIT(RTC_CON_TSEN_POS)

#define RTC_CON_SHDBP_POS   4U
#define RTC_CON_SHDBP_MSK   BIT(RTC_CON_SHDBP_POS)

#define RTC_CON_HFM_POS 3U
#define RTC_CON_HFM_MSK BIT(RTC_CON_HFM_POS)

#define RTC_CON_ALMBEN_POS  2U
#define RTC_CON_ALMBEN_MSK  BIT(RTC_CON_ALMBEN_POS)

#define RTC_CON_ALMAEN_POS  1U
#define RTC_CON_ALMAEN_MSK  BIT(RTC_CON_ALMAEN_POS)

#define RTC_CON_GO_POS  0U
#define RTC_CON_GO_MSK  BIT(RTC_CON_GO_POS)

/****************** Bit definition for RTC_PSR register ************************/
#define RTC_PSR_RTCCS_POSS  24U
#define RTC_PSR_RTCCS_POSE  26U
#define RTC_PSR_RTCCS_MSK   BITS(RTC_PSR_RTCCS_POSS,RTC_PSR_RTCCS_POSE)

#define RTC_PSR_APRS_POSS   16U
#define RTC_PSR_APRS_POSE   22U
#define RTC_PSR_APRS_MSK    BITS(RTC_PSR_APRS_POSS,RTC_PSR_APRS_POSE)

#define RTC_PSR_SPRS_POSS   0U
#define RTC_PSR_SPRS_POSE   14U
#define RTC_PSR_SPRS_MSK    BITS(RTC_PSR_SPRS_POSS,RTC_PSR_SPRS_POSE)

/****************** Bit definition for RTC_TAMPCON register ************************/

#define RTC_TAMPCON_TAMPFLT_POSS    20U
#define RTC_TAMPCON_TAMPFLT_POSE    21U
#define RTC_TAMPCON_TAMPFLT_MSK BITS(RTC_TAMPCON_TAMPFLT_POSS,RTC_TAMPCON_TAMPFLT_POSE)

#define RTC_TAMPCON_TAMPCKS_POSS    17U
#define RTC_TAMPCON_TAMPCKS_POSE    19U
#define RTC_TAMPCON_TAMPCKS_MSK BITS(RTC_TAMPCON_TAMPCKS_POSS,RTC_TAMPCON_TAMPCKS_POSE)

#define RTC_TAMPCON_TAMPTS_POS  16U
#define RTC_TAMPCON_TAMPTS_MSK  BIT(RTC_TAMPCON_TAMPTS_POS)

#define RTC_TAMPCON_TAMP1LV_POS 9U
#define RTC_TAMPCON_TAMP1LV_MSK BIT(RTC_TAMPCON_TAMP1LV_POS)

#define RTC_TAMPCON_TAMP1EN_POS 8U
#define RTC_TAMPCON_TAMP1EN_MSK BIT(RTC_TAMPCON_TAMP1EN_POS)

#define RTC_TAMPCON_TAMP0LV_POS 1U
#define RTC_TAMPCON_TAMP0LV_MSK BIT(RTC_TAMPCON_TAMP0LV_POS)

#define RTC_TAMPCON_TAMP0EN_POS 0U
#define RTC_TAMPCON_TAMP0EN_MSK BIT(RTC_TAMPCON_TAMP0EN_POS)

/****************** Bit definition for RTC_TIME register ************************/

#define RTC_TIME_PM_POS 22U
#define RTC_TIME_PM_MSK BIT(RTC_TIME_PM_POS)

#define RTC_TIME_HRT_POSS   20U
#define RTC_TIME_HRT_POSE   21U
#define RTC_TIME_HRT_MSK    BITS(RTC_TIME_HRT_POSS,RTC_TIME_HRT_POSE)

#define RTC_TIME_HRU_POSS   16U
#define RTC_TIME_HRU_POSE   19U
#define RTC_TIME_HRU_MSK    BITS(RTC_TIME_HRU_POSS,RTC_TIME_HRU_POSE)

#define RTC_TIME_MINT_POSS  12U
#define RTC_TIME_MINT_POSE  14U
#define RTC_TIME_MINT_MSK   BITS(RTC_TIME_MINT_POSS,RTC_TIME_MINT_POSE)

#define RTC_TIME_MINU_POSS  8U
#define RTC_TIME_MINU_POSE  11U
#define RTC_TIME_MINU_MSK   BITS(RTC_TIME_MINU_POSS,RTC_TIME_MINU_POSE)

#define RTC_TIME_SECT_POSS  4U
#define RTC_TIME_SECT_POSE  6U
#define RTC_TIME_SECT_MSK   BITS(RTC_TIME_SECT_POSS,RTC_TIME_SECT_POSE)

#define RTC_TIME_SECU_POSS  0U
#define RTC_TIME_SECU_POSE  3U
#define RTC_TIME_SECU_MSK   BITS(RTC_TIME_SECU_POSS,RTC_TIME_SECU_POSE)

/****************** Bit definition for RTC_DATE register ************************/

#define RTC_DATE_WD_POSS    24U
#define RTC_DATE_WD_POSE    26U
#define RTC_DATE_WD_MSK BITS(RTC_DATE_WD_POSS,RTC_DATE_WD_POSE)

#define RTC_DATE_YRT_POSS   20U
#define RTC_DATE_YRT_POSE   23U
#define RTC_DATE_YRT_MSK    BITS(RTC_DATE_YRT_POSS,RTC_DATE_YRT_POSE)

#define RTC_DATE_YRU_POSS   16U
#define RTC_DATE_YRU_POSE   19U
#define RTC_DATE_YRU_MSK    BITS(RTC_DATE_YRU_POSS,RTC_DATE_YRU_POSE)

#define RTC_DATE_MONT_POS   12U
#define RTC_DATE_MONT_MSK   BIT(RTC_DATE_MONT_POS)

#define RTC_DATE_MONU_POSS  8U
#define RTC_DATE_MONU_POSE  11U
#define RTC_DATE_MONU_MSK   BITS(RTC_DATE_MONU_POSS,RTC_DATE_MONU_POSE)

#define RTC_DATE_DAYT_POSS  4U
#define RTC_DATE_DAYT_POSE  5U
#define RTC_DATE_DAYT_MSK   BITS(RTC_DATE_DAYT_POSS,RTC_DATE_DAYT_POSE)

#define RTC_DATE_DAYU_POSS  0U
#define RTC_DATE_DAYU_POSE  3U
#define RTC_DATE_DAYU_MSK   BITS(RTC_DATE_DAYU_POSS,RTC_DATE_DAYU_POSE)

/****************** Bit definition for RTC_SSEC register ************************/

#define RTC_SSEC_VAL_POSS   0U
#define RTC_SSEC_VAL_POSE   15U
#define RTC_SSEC_VAL_MSK    BITS(RTC_SSEC_VAL_POSS,RTC_SSEC_VAL_POSE)

/****************** Bit definition for RTC_WUMAT register ************************/

#define RTC_WUMAT_VAL_POSS  0U
#define RTC_WUMAT_VAL_POSE  15U
#define RTC_WUMAT_VAL_MSK   BITS(RTC_WUMAT_VAL_POSS,RTC_WUMAT_VAL_POSE)

/****************** Bit definition for RTC_ALMA register ************************/

#define RTC_ALMA_WDS_POS    31U
#define RTC_ALMA_WDS_MSK    BIT(RTC_ALMA_WDS_POS)

#define RTC_ALMA_DAWD_POSS  24U
#define RTC_ALMA_DAWD_POSE  30U
#define RTC_ALMA_DAWD_MSK   BITS(RTC_ALMA_DAWD_POSS,RTC_ALMA_DAWD_POSE)

#define RTC_ALMA_DAYMSK_POS 30U
#define RTC_ALMA_DAYMSK_MSK     BIT(RTC_ALMA_DAYMSK_POS)

#define RTC_ALMA_DAWD_DAYT_POSS 28U
#define RTC_ALMA_DAWD_DAYT_POSE 29U
#define RTC_ALMA_DAWD_DAYT_MSK  BITS(RTC_ALMA_DAWD_DAYT_POSS, RTC_ALMA_DAWD_DAYT_POSE)

#define RTC_ALMA_DAWD_DAYU_POSS 24U
#define RTC_ALMA_DAWD_DAYU_POSE 27U
#define RTC_ALMA_DAWD_DAYU_MSK  BITS(RTC_ALMA_DAWD_DAYU_POSS, RTC_ALMA_DAWD_DAYU_POSE)

#define RTC_ALMA_HRMSK_POS  23U
#define RTC_ALMA_HRMSK_MSK  BIT(RTC_ALMA_HRMSK_POS)

#define RTC_ALMA_PM_POS 22U
#define RTC_ALMA_PM_MSK BIT(RTC_ALMA_PM_POS)

#define RTC_ALMA_HRT_POSS   20U
#define RTC_ALMA_HRT_POSE   21U
#define RTC_ALMA_HRT_MSK    BITS(RTC_ALMA_HRT_POSS,RTC_ALMA_HRT_POSE)

#define RTC_ALMA_HRU_POSS   16U
#define RTC_ALMA_HRU_POSE   19U
#define RTC_ALMA_HRU_MSK    BITS(RTC_ALMA_HRU_POSS,RTC_ALMA_HRU_POSE)

#define RTC_ALMA_MINMSK_POS 15U
#define RTC_ALMA_MINMSK_MSK BIT(RTC_ALMA_MINMSK_POS)

#define RTC_ALMA_MINT_POSS  12U
#define RTC_ALMA_MINT_POSE  14U
#define RTC_ALMA_MINT_MSK   BITS(RTC_ALMA_MINT_POSS,RTC_ALMA_MINT_POSE)

#define RTC_ALMA_MINU_POSS  8U
#define RTC_ALMA_MINU_POSE  11U
#define RTC_ALMA_MINU_MSK   BITS(RTC_ALMA_MINU_POSS,RTC_ALMA_MINU_POSE)

#define RTC_ALMA_SECMSK_POS 7U
#define RTC_ALMA_SECMSK_MSK BIT(RTC_ALMA_SECMSK_POS)

#define RTC_ALMA_SECT_POSS  4U
#define RTC_ALMA_SECT_POSE  6U
#define RTC_ALMA_SECT_MSK   BITS(RTC_ALMA_SECT_POSS,RTC_ALMA_SECT_POSE)

#define RTC_ALMA_SECU_POSS  0U
#define RTC_ALMA_SECU_POSE  3U
#define RTC_ALMA_SECU_MSK   BITS(RTC_ALMA_SECU_POSS,RTC_ALMA_SECU_POSE)

/****************** Bit definition for RTC_ALMB register ************************/

#define RTC_ALMB_WDS_POS    31U
#define RTC_ALMB_WDS_MSK    BIT(RTC_ALMB_WDS_POS)

#define RTC_ALMB_DAWD_POSS  24U
#define RTC_ALMB_DAWD_POSE  30U
#define RTC_ALMB_DAWD_MSK   BITS(RTC_ALMB_DAWD_POSS,RTC_ALMB_DAWD_POSE)

#define RTC_ALMB_DAYMSK_POS 30U
#define RTC_ALMB_DAYMSK_MSK     BIT(RTC_ALMB_DAYMSK_POS)

#define RTC_ALMB_DAWD_DAYT_POSS 28U
#define RTC_ALMB_DAWD_DAYT_POSE 29U
#define RTC_ALMB_DAWD_DAYT_MSK  BITS(RTC_ALMB_DAWD_DAYT_POSS, RTC_ALMB_DAWD_DAYT_POSE)

#define RTC_ALMB_DAWD_DAYU_POSS 24U
#define RTC_ALMB_DAWD_DAYU_POSE 27U
#define RTC_ALMB_DAWD_DAYU_MSK  BITS(RTC_ALMB_DAWD_DAYU_POSS, RTC_ALMB_DAWD_DAYU_POSE)

#define RTC_ALMB_HRMSK_POS  23U
#define RTC_ALMB_HRMSK_MSK  BIT(RTC_ALMB_HRMSK_POS)

#define RTC_ALMB_PM_POS 22U
#define RTC_ALMB_PM_MSK BIT(RTC_ALMB_PM_POS)

#define RTC_ALMB_HRT_POSS   20U
#define RTC_ALMB_HRT_POSE   21U
#define RTC_ALMB_HRT_MSK    BITS(RTC_ALMB_HRT_POSS,RTC_ALMB_HRT_POSE)

#define RTC_ALMB_HRU_POSS   16U
#define RTC_ALMB_HRU_POSE   19U
#define RTC_ALMB_HRU_MSK    BITS(RTC_ALMB_HRU_POSS,RTC_ALMB_HRU_POSE)

#define RTC_ALMB_MINMSK_POS 15U
#define RTC_ALMB_MINMSK_MSK BIT(RTC_ALMB_MINMSK_POS)

#define RTC_ALMB_MINT_POSS  12U
#define RTC_ALMB_MINT_POSE  14U
#define RTC_ALMB_MINT_MSK   BITS(RTC_ALMB_MINT_POSS,RTC_ALMB_MINT_POSE)

#define RTC_ALMB_MINU_POSS  8U
#define RTC_ALMB_MINU_POSE  11U
#define RTC_ALMB_MINU_MSK   BITS(RTC_ALMB_MINU_POSS,RTC_ALMB_MINU_POSE)

#define RTC_ALMB_SECMSK_POS 7U
#define RTC_ALMB_SECMSK_MSK BIT(RTC_ALMB_SECMSK_POS)

#define RTC_ALMB_SECT_POSS  4U
#define RTC_ALMB_SECT_POSE  6U
#define RTC_ALMB_SECT_MSK   BITS(RTC_ALMB_SECT_POSS,RTC_ALMB_SECT_POSE)

#define RTC_ALMB_SECU_POSS  0U
#define RTC_ALMB_SECU_POSE  3U
#define RTC_ALMB_SECU_MSK   BITS(RTC_ALMB_SECU_POSS,RTC_ALMB_SECU_POSE)

/****************** Bit definition for RTC_ALMASSEC register ************************/

#define RTC_ALMASSEC_SSECM_POSS 24U
#define RTC_ALMASSEC_SSECM_POSE 27U
#define RTC_ALMASSEC_SSECM_MSK  BITS(RTC_ALMASSEC_SSECM_POSS,RTC_ALMASSEC_SSECM_POSE)

#define RTC_ALMASSEC_SSEC_POSS  0U
#define RTC_ALMASSEC_SSEC_POSE  14U
#define RTC_ALMASSEC_SSEC_MSK   BITS(RTC_ALMASSEC_SSEC_POSS,RTC_ALMASSEC_SSEC_POSE)

/****************** Bit definition for RTC_ALMBSSEC register ************************/

#define RTC_ALMBSSEC_SSECM_POSS 24U
#define RTC_ALMBSSEC_SSECM_POSE 27U
#define RTC_ALMBSSEC_SSECM_MSK  BITS(RTC_ALMBSSEC_SSECM_POSS,RTC_ALMBSSEC_SSECM_POSE)

#define RTC_ALMBSSEC_SSEC_POSS  0U
#define RTC_ALMBSSEC_SSEC_POSE  14U
#define RTC_ALMBSSEC_SSEC_MSK   BITS(RTC_ALMBSSEC_SSEC_POSS,RTC_ALMBSSEC_SSEC_POSE)

/****************** Bit definition for RTC_TSTIME register ************************/

#define RTC_TSTIME_PM_POS   22U
#define RTC_TSTIME_PM_MSK   BIT(RTC_TSTIME_PM_POS)

#define RTC_TSTIME_HRT_POSS 20U
#define RTC_TSTIME_HRT_POSE 21U
#define RTC_TSTIME_HRT_MSK  BITS(RTC_TSTIME_HRT_POSS,RTC_TSTIME_HRT_POSE)

#define RTC_TSTIME_HRU_POSS 16U
#define RTC_TSTIME_HRU_POSE 19U
#define RTC_TSTIME_HRU_MSK  BITS(RTC_TSTIME_HRU_POSS,RTC_TSTIME_HRU_POSE)

#define RTC_TSTIME_MINT_POSS    12U
#define RTC_TSTIME_MINT_POSE    14U
#define RTC_TSTIME_MINT_MSK BITS(RTC_TSTIME_MINT_POSS,RTC_TSTIME_MINT_POSE)

#define RTC_TSTIME_MINU_POSS    8U
#define RTC_TSTIME_MINU_POSE    11U
#define RTC_TSTIME_MINU_MSK BITS(RTC_TSTIME_MINU_POSS,RTC_TSTIME_MINU_POSE)

#define RTC_TSTIME_SECT_POSS    4U
#define RTC_TSTIME_SECT_POSE    6U
#define RTC_TSTIME_SECT_MSK BITS(RTC_TSTIME_SECT_POSS,RTC_TSTIME_SECT_POSE)

#define RTC_TSTIME_SECU_POSS    0U
#define RTC_TSTIME_SECU_POSE    3U
#define RTC_TSTIME_SECU_MSK BITS(RTC_TSTIME_SECU_POSS,RTC_TSTIME_SECU_POSE)

/****************** Bit definition for RTC_TSDATE register ************************/

#define RTC_TSDATE_WD_POSS  24U
#define RTC_TSDATE_WD_POSE  26U
#define RTC_TSDATE_WD_MSK   BITS(RTC_TSDATE_WD_POSS,RTC_TSDATE_WD_POSE)

#define RTC_TSDATE_YRT_POSS 20U
#define RTC_TSDATE_YRT_POSE 23U
#define RTC_TSDATE_YRT_MSK  BITS(RTC_TSDATE_YRT_POSS,RTC_TSDATE_YRT_POSE)

#define RTC_TSDATE_YRU_POSS 16U
#define RTC_TSDATE_YRU_POSE 19U
#define RTC_TSDATE_YRU_MSK  BITS(RTC_TSDATE_YRU_POSS,RTC_TSDATE_YRU_POSE)

#define RTC_TSDATE_MONT_POS 12U
#define RTC_TSDATE_MONT_MSK BIT(RTC_TSDATE_MONT_POS)

#define RTC_TSDATE_MONU_POSS    8U
#define RTC_TSDATE_MONU_POSE    11U
#define RTC_TSDATE_MONU_MSK BITS(RTC_TSDATE_MONU_POSS,RTC_TSDATE_MONU_POSE)

#define RTC_TSDATE_DAYT_POSS    4U
#define RTC_TSDATE_DAYT_POSE    5U
#define RTC_TSDATE_DAYT_MSK BITS(RTC_TSDATE_DAYT_POSS,RTC_TSDATE_DAYT_POSE)

#define RTC_TSDATE_DAYU_POSS    0U
#define RTC_TSDATE_DAYU_POSE    3U
#define RTC_TSDATE_DAYU_MSK BITS(RTC_TSDATE_DAYU_POSS,RTC_TSDATE_DAYU_POSE)

/****************** Bit definition for RTC_TSSSEC register ************************/

#define RTC_TSSSEC_SSEC_POSS    0U
#define RTC_TSSSEC_SSEC_POSE    15U
#define RTC_TSSSEC_SSEC_MSK BITS(RTC_TSSSEC_SSEC_POSS,RTC_TSSSEC_SSEC_POSE)

/****************** Bit definition for RTC_SSECTR register ************************/

#define RTC_SSECTR_INC_POS  31U
#define RTC_SSECTR_INC_MSK  BIT(RTC_SSECTR_INC_POS)

#define RTC_SSECTR_TRIM_POSS    0U
#define RTC_SSECTR_TRIM_POSE    14U
#define RTC_SSECTR_TRIM_MSK BITS(RTC_SSECTR_TRIM_POSS,RTC_SSECTR_TRIM_POSE)

/****************** Bit definition for RTC_IER register ************************/

#define RTC_IER_WU_POS  18U
#define RTC_IER_WU_MSK  BIT(RTC_IER_WU_POS)

#define RTC_IER_SSTC_POS    17U
#define RTC_IER_SSTC_MSK    BIT(RTC_IER_SSTC_POS)

#define RTC_IER_RSC_POS 16U
#define RTC_IER_RSC_MSK BIT(RTC_IER_RSC_POS)

#define RTC_IER_TAMP1_POS   13U
#define RTC_IER_TAMP1_MSK   BIT(RTC_IER_TAMP1_POS)

#define RTC_IER_TAMP0_POS   12U
#define RTC_IER_TAMP0_MSK   BIT(RTC_IER_TAMP0_POS)

#define RTC_IER_TSOV_POS    11U
#define RTC_IER_TSOV_MSK    BIT(RTC_IER_TSOV_POS)

#define RTC_IER_TS_POS  10U
#define RTC_IER_TS_MSK  BIT(RTC_IER_TS_POS)

#define RTC_IER_ALMB_POS    9U
#define RTC_IER_ALMB_MSK    BIT(RTC_IER_ALMB_POS)

#define RTC_IER_ALMA_POS    8U
#define RTC_IER_ALMA_MSK    BIT(RTC_IER_ALMA_POS)

#define RTC_IER_YR_POS  5U
#define RTC_IER_YR_MSK  BIT(RTC_IER_YR_POS)

#define RTC_IER_MON_POS 4U
#define RTC_IER_MON_MSK BIT(RTC_IER_MON_POS)

#define RTC_IER_DAY_POS 3U
#define RTC_IER_DAY_MSK BIT(RTC_IER_DAY_POS)

#define RTC_IER_HR_POS  2U
#define RTC_IER_HR_MSK  BIT(RTC_IER_HR_POS)

#define RTC_IER_MIN_POS 1U
#define RTC_IER_MIN_MSK BIT(RTC_IER_MIN_POS)

#define RTC_IER_SEC_POS 0U
#define RTC_IER_SEC_MSK BIT(RTC_IER_SEC_POS)

/****************** Bit definition for RTC_IFR register ************************/

#define RTC_IFR_WUF_POS 18U
#define RTC_IFR_WUF_MSK BIT(RTC_IFR_WUF_POS)

#define RTC_IFR_SSTCF_POS   17U
#define RTC_IFR_SSTCF_MSK   BIT(RTC_IFR_SSTCF_POS)

#define RTC_IFR_RSCF_POS    16U
#define RTC_IFR_RSCF_MSK    BIT(RTC_IFR_RSCF_POS)

#define RTC_IFR_TAMP1F_POS  13U
#define RTC_IFR_TAMP1F_MSK  BIT(RTC_IFR_TAMP1F_POS)

#define RTC_IFR_TAMP0F_POS  12U
#define RTC_IFR_TAMP0F_MSK  BIT(RTC_IFR_TAMP0F_POS)

#define RTC_IFR_TSOVF_POS   11U
#define RTC_IFR_TSOVF_MSK   BIT(RTC_IFR_TSOVF_POS)

#define RTC_IFR_TSF_POS 10U
#define RTC_IFR_TSF_MSK BIT(RTC_IFR_TSF_POS)

#define RTC_IFR_ALMBF_POS   9U
#define RTC_IFR_ALMBF_MSK   BIT(RTC_IFR_ALMBF_POS)

#define RTC_IFR_ALMAF_POS   8U
#define RTC_IFR_ALMAF_MSK   BIT(RTC_IFR_ALMAF_POS)

#define RTC_IFR_YRF_POS 5U
#define RTC_IFR_YRF_MSK BIT(RTC_IFR_YRF_POS)

#define RTC_IFR_MONF_POS    4U
#define RTC_IFR_MONF_MSK    BIT(RTC_IFR_MONF_POS)

#define RTC_IFR_DAYF_POS    3U
#define RTC_IFR_DAYF_MSK    BIT(RTC_IFR_DAYF_POS)

#define RTC_IFR_HRF_POS 2U
#define RTC_IFR_HRF_MSK BIT(RTC_IFR_HRF_POS)

#define RTC_IFR_MINF_POS    1U
#define RTC_IFR_MINF_MSK    BIT(RTC_IFR_MINF_POS)

#define RTC_IFR_SECF_POS    0U
#define RTC_IFR_SECF_MSK    BIT(RTC_IFR_SECF_POS)

/****************** Bit definition for RTC_IFCR register ************************/

#define RTC_IFCR_WUFC_POS   18U
#define RTC_IFCR_WUFC_MSK   BIT(RTC_IFCR_WUFC_POS)

#define RTC_IFCR_SSTCFC_POS 17U
#define RTC_IFCR_SSTCFC_MSK BIT(RTC_IFCR_SSTCFC_POS)

#define RTC_IFCR_RSCFC_POS  16U
#define RTC_IFCR_RSCFC_MSK  BIT(RTC_IFCR_RSCFC_POS)

#define RTC_IFCR_TAMP1FC_POS    13U
#define RTC_IFCR_TAMP1FC_MSK    BIT(RTC_IFCR_TAMP1FC_POS)

#define RTC_IFCR_TAMP0FC_POS    12U
#define RTC_IFCR_TAMP0FC_MSK    BIT(RTC_IFCR_TAMP0FC_POS)

#define RTC_IFCR_TSOVFC_POS 11U
#define RTC_IFCR_TSOVFC_MSK BIT(RTC_IFCR_TSOVFC_POS)

#define RTC_IFCR_TSFC_POS   10U
#define RTC_IFCR_TSFC_MSK   BIT(RTC_IFCR_TSFC_POS)

#define RTC_IFCR_ALMBFC_POS 9U
#define RTC_IFCR_ALMBFC_MSK BIT(RTC_IFCR_ALMBFC_POS)

#define RTC_IFCR_ALMAFC_POS 8U
#define RTC_IFCR_ALMAFC_MSK BIT(RTC_IFCR_ALMAFC_POS)

#define RTC_IFCR_YRFC_POS   5U
#define RTC_IFCR_YRFC_MSK   BIT(RTC_IFCR_YRFC_POS)

#define RTC_IFCR_MONFC_POS  4U
#define RTC_IFCR_MONFC_MSK  BIT(RTC_IFCR_MONFC_POS)

#define RTC_IFCR_DAYFC_POS  3U
#define RTC_IFCR_DAYFC_MSK  BIT(RTC_IFCR_DAYFC_POS)

#define RTC_IFCR_HRFC_POS   2U
#define RTC_IFCR_HRFC_MSK   BIT(RTC_IFCR_HRFC_POS)

#define RTC_IFCR_MINFC_POS  1U
#define RTC_IFCR_MINFC_MSK  BIT(RTC_IFCR_MINFC_POS)

#define RTC_IFCR_SECFC_POS  0U
#define RTC_IFCR_SECFC_MSK  BIT(RTC_IFCR_SECFC_POS)

/****************** Bit definition for RTC_ISR register ************************/

#define RTC_ISR_WUF_POS 18U
#define RTC_ISR_WUF_MSK BIT(RTC_ISR_WUF_POS)

#define RTC_ISR_SSTCF_POS   17U
#define RTC_ISR_SSTCF_MSK   BIT(RTC_ISR_SSTCF_POS)

#define RTC_ISR_RSCF_POS    16U
#define RTC_ISR_RSCF_MSK    BIT(RTC_ISR_RSCF_POS)

#define RTC_ISR_TAMP1F_POS  13U
#define RTC_ISR_TAMP1F_MSK  BIT(RTC_ISR_TAMP1F_POS)

#define RTC_ISR_TAMP0F_POS  12U
#define RTC_ISR_TAMP0F_MSK  BIT(RTC_ISR_TAMP0F_POS)

#define RTC_ISR_TSOVF_POS   11U
#define RTC_ISR_TSOVF_MSK   BIT(RTC_ISR_TSOVF_POS)

#define RTC_ISR_TSF_POS 10U
#define RTC_ISR_TSF_MSK BIT(RTC_ISR_TSF_POS)

#define RTC_ISR_ALMBF_POS   9U
#define RTC_ISR_ALMBF_MSK   BIT(RTC_ISR_ALMBF_POS)

#define RTC_ISR_ALMAF_POS   8U
#define RTC_ISR_ALMAF_MSK   BIT(RTC_ISR_ALMAF_POS)

#define RTC_ISR_YRF_POS 5U
#define RTC_ISR_YRF_MSK BIT(RTC_ISR_YRF_POS)

#define RTC_ISR_MONF_POS    4U
#define RTC_ISR_MONF_MSK    BIT(RTC_ISR_MONF_POS)

#define RTC_ISR_DAYF_POS    3U
#define RTC_ISR_DAYF_MSK    BIT(RTC_ISR_DAYF_POS)

#define RTC_ISR_HRF_POS 2U
#define RTC_ISR_HRF_MSK BIT(RTC_ISR_HRF_POS)

#define RTC_ISR_MINF_POS    1U
#define RTC_ISR_MINF_MSK    BIT(RTC_ISR_MINF_POS)

#define RTC_ISR_SECF_POS    0U
#define RTC_ISR_SECF_MSK    BIT(RTC_ISR_SECF_POS)

/****************** Bit definition for RTC_CALWPR register ************************/

#define RTC_CALWPR_WP_POS   0U
#define RTC_CALWPR_WP_MSK   BIT(RTC_CALWPR_WP_POS)

/****************** Bit definition for RTC_CALCON register ************************/

#define RTC_CALCON_DCMACC_POS   24U
#define RTC_CALCON_DCMACC_MSK   BIT(RTC_CALCON_DCMACC_POS)

#define RTC_CALCON_ALG_POS  23U
#define RTC_CALCON_ALG_MSK  BIT(RTC_CALCON_ALG_POS)

#define RTC_CALCON_TCP_POSS 20U
#define RTC_CALCON_TCP_POSE 22U
#define RTC_CALCON_TCP_MSK  BITS(RTC_CALCON_TCP_POSS,RTC_CALCON_TCP_POSE)

#define RTC_CALCON_ERR_POS  19U
#define RTC_CALCON_ERR_MSK  BIT(RTC_CALCON_ERR_POS)

#define RTC_CALCON_BUSY_POS 18U
#define RTC_CALCON_BUSY_MSK BIT(RTC_CALCON_BUSY_POS)

#define RTC_CALCON_TCM_POSS 16U
#define RTC_CALCON_TCM_POSE 17U
#define RTC_CALCON_TCM_MSK  BITS(RTC_CALCON_TCM_POSS,RTC_CALCON_TCM_POSE)

#define RTC_CALCON_CALP_POSS    1U
#define RTC_CALCON_CALP_POSE    3U
#define RTC_CALCON_CALP_MSK BITS(RTC_CALCON_CALP_POSS,RTC_CALCON_CALP_POSE)

#define RTC_CALCON_CALEN_POS    0U
#define RTC_CALCON_CALEN_MSK    BIT(RTC_CALCON_CALEN_POS)

/****************** Bit definition for RTC_CALDR register ************************/

#define RTC_CALDR_DATA_POSS 16U
#define RTC_CALDR_DATA_POSE 31U
#define RTC_CALDR_DATA_MSK  BITS(RTC_CALDR_DATA_POSS,RTC_CALDR_DATA_POSE)

#define RTC_CALDR_VAL_POSS  0U
#define RTC_CALDR_VAL_POSE  15U
#define RTC_CALDR_VAL_MSK   BITS(RTC_CALDR_VAL_POSS,RTC_CALDR_VAL_POSE)

/****************** Bit definition for RTC_BKP register ************************/

#define RTC_BKP_BKP_POSS    0U
#define RTC_BKP_BKP_POSE    31U
#define RTC_BKP_BKP_MSK BITS(RTC_BKP_BKP_POSS,RTC_BKP_BKP_POSE)

typedef struct
{
    __IO uint32_t WPR;
    __IO uint32_t CON;
    __IO uint32_t PSR;
    __IO uint32_t TAMPCON;
    __IO uint32_t TIME;
    __IO uint32_t DATE;
    __IO uint32_t SSEC;
    __IO uint32_t WUMAT;
    __IO uint32_t ALMA;
    __IO uint32_t ALMB;
    __IO uint32_t ALMASSEC;
    __IO uint32_t ALMBSSEC;
    __I uint32_t TSTIME;
    __I uint32_t TSDATE;
    __I uint32_t TSSSEC;
    __O uint32_t SSECTR;
    __IO uint32_t IER;
    __I uint32_t IFR;
    __O uint32_t IFCR;
    __I uint32_t ISR;
    __IO uint32_t CALWPR;
    __IO uint32_t CALCON;
    __IO uint32_t CALDR;
    uint32_t RESERVED0[41];
    __IO uint32_t BKPR[32];
} RTC_TypeDef;

/****************** Bit definition for TIMER_CON1 register ************************/

#define TIMER_CON1_DBGSEL_POS  15U
#define TIMER_CON1_DBGSEL_MSK   BIT(TIMER_CON1_DBGSEL_POSS)

#define TIMER_CON1_DFCKSEL_POSS 8U
#define TIMER_CON1_DFCKSEL_POSE 9U
#define TIMER_CON1_DFCKSEL_MSK  BITS(TIMER_CON1_DFCKSEL_POSS,TIMER_CON1_DFCKSEL_POSE)

#define TIMER_CON1_ARPEN_POS    7U
#define TIMER_CON1_ARPEN_MSK    BIT(TIMER_CON1_ARPEN_POS)

#define TIMER_CON1_CMSEL_POSS   5U
#define TIMER_CON1_CMSEL_POSE   6U
#define TIMER_CON1_CMSEL_MSK    BITS(TIMER_CON1_CMSEL_POSS,TIMER_CON1_CMSEL_POSE)

#define TIMER_CON1_DIRSEL_POS   4U
#define TIMER_CON1_DIRSEL_MSK   BIT(TIMER_CON1_DIRSEL_POS)

#define TIMER_CON1_SPMEN_POS    3U
#define TIMER_CON1_SPMEN_MSK    BIT(TIMER_CON1_SPMEN_POS)

#define TIMER_CON1_UERSEL_POS   2U
#define TIMER_CON1_UERSEL_MSK   BIT(TIMER_CON1_UERSEL_POS)

#define TIMER_CON1_DISUE_POS    1U
#define TIMER_CON1_DISUE_MSK    BIT(TIMER_CON1_DISUE_POS)

#define TIMER_CON1_CNTEN_POS    0U
#define TIMER_CON1_CNTEN_MSK    BIT(TIMER_CON1_CNTEN_POS)

/****************** Bit definition for TIMER_CON2 register ************************/

#define TIMER_CON2_OISS4_POS    14U
#define TIMER_CON2_OISS4_MSK    BIT(TIMER_CON2_OISS4_POS)

#define TIMER_CON2_OISS3N_POS   13U
#define TIMER_CON2_OISS3N_MSK   BIT(TIMER_CON2_OISS3N_POS)

#define TIMER_CON2_OISS3_POS    12U
#define TIMER_CON2_OISS3_MSK    BIT(TIMER_CON2_OISS3_POS)

#define TIMER_CON2_OISS2N_POS   11U
#define TIMER_CON2_OISS2N_MSK   BIT(TIMER_CON2_OISS2N_POS)

#define TIMER_CON2_OISS2_POS    10U
#define TIMER_CON2_OISS2_MSK    BIT(TIMER_CON2_OISS2_POS)

#define TIMER_CON2_OISS1N_POS   9U
#define TIMER_CON2_OISS1N_MSK   BIT(TIMER_CON2_OISS1N_POS)

#define TIMER_CON2_OISS1_POS    8U
#define TIMER_CON2_OISS1_MSK    BIT(TIMER_CON2_OISS1_POS)

#define TIMER_CON2_I1FSEL_POS   7U
#define TIMER_CON2_I1FSEL_MSK   BIT(TIMER_CON2_I1FSEL_POS)

#define TIMER_CON2_TRGOSEL_POSS 4U
#define TIMER_CON2_TRGOSEL_POSE 6U
#define TIMER_CON2_TRGOSEL_MSK  BITS(TIMER_CON2_TRGOSEL_POSS,TIMER_CON2_TRGOSEL_POSE)

#define TIMER_CON2_CCDMASEL_POS 3U
#define TIMER_CON2_CCDMASEL_MSK BIT(TIMER_CON2_CCDMASEL_POS)

#define TIMER_CON2_CCUSEL_POS   2U
#define TIMER_CON2_CCUSEL_MSK   BIT(TIMER_CON2_CCUSEL_POS)

#define TIMER_CON2_CCPCEN_POS   0U
#define TIMER_CON2_CCPCEN_MSK   BIT(TIMER_CON2_CCPCEN_POS)

/****************** Bit definition for TIMER_SMCON register ************************/
#define TIMER_SMCON_TSSEL2_POSS  20U
#define TIMER_SMCON_TSSEL2_POSE  21U
#define TIMER_SMCON_TSSEL2_MSK   BITS(TIMER_SMCON_TSSEL2_POSS,TIMER_SMCON_TSSEL2_POSE)

#define TIMER_SMCON_ETPOL_POS   15U
#define TIMER_SMCON_ETPOL_MSK   BIT(TIMER_SMCON_ETPOL_POS)

#define TIMER_SMCON_ECM2EN_POS  14U
#define TIMER_SMCON_ECM2EN_MSK  BIT(TIMER_SMCON_ECM2EN_POS)

#define TIMER_SMCON_ETPSEL_POSS 12U
#define TIMER_SMCON_ETPSEL_POSE 13U
#define TIMER_SMCON_ETPSEL_MSK  BITS(TIMER_SMCON_ETPSEL_POSS,TIMER_SMCON_ETPSEL_POSE)

#define TIMER_SMCON_ETFLT_POSS  8U
#define TIMER_SMCON_ETFLT_POSE  11U
#define TIMER_SMCON_ETFLT_MSK   BITS(TIMER_SMCON_ETFLT_POSS,TIMER_SMCON_ETFLT_POSE)

#define TIMER_SMCON_MSCFG_POS   7U
#define TIMER_SMCON_MSCFG_MSK   BIT(TIMER_SMCON_MSCFG_POS)

#define TIMER_SMCON_TSSEL1_POSS  4U
#define TIMER_SMCON_TSSEL1_POSE  6U
#define TIMER_SMCON_TSSEL1_MSK   BITS(TIMER_SMCON_TSSEL1_POSS,TIMER_SMCON_TSSEL1_POSE)

#define TIMER_SMCON_SMODS_POSS  0U
#define TIMER_SMCON_SMODS_POSE  2U
#define TIMER_SMCON_SMODS_MSK   BITS(TIMER_SMCON_SMODS_POSS,TIMER_SMCON_SMODS_POSE)

/****************** Bit definition for TIMER_IER register ************************/

#define TIMER_IER_CC4OIT_POS  12U 
#define TIMER_IER_CC4OIT_MSK  BIT(TIMER_IER_CC4OIT_POS)
                              
#define TIMER_IER_CC3OIT_POS  11U 
#define TIMER_IER_CC3OIT_MSK  BIT(TIMER_IER_CC3OIT_POS)
                              
#define TIMER_IER_CC2OIT_POS  10U 
#define TIMER_IER_CC2OIT_MSK  BIT(TIMER_IER_CC2OIT_POS)
                              
#define TIMER_IER_CC1OIT_POS  9U 
#define TIMER_IER_CC1OIT_MSK  BIT(TIMER_IER_CC1OIT_POS)

#define TIMER_IER_BRKIT_POS 7U
#define TIMER_IER_BRKIT_MSK BIT(TIMER_IER_BRKIT_POS)

#define TIMER_IER_TRGIT_POS 6U
#define TIMER_IER_TRGIT_MSK BIT(TIMER_IER_TRGIT_POS)

#define TIMER_IER_COMIT_POS 5U
#define TIMER_IER_COMIT_MSK BIT(TIMER_IER_COMIT_POS)

#define TIMER_IER_CC4IT_POS 4U
#define TIMER_IER_CC4IT_MSK BIT(TIMER_IER_CC4IT_POS)

#define TIMER_IER_CC3IT_POS 3U
#define TIMER_IER_CC3IT_MSK BIT(TIMER_IER_CC3IT_POS)

#define TIMER_IER_CC2IT_POS 2U
#define TIMER_IER_CC2IT_MSK BIT(TIMER_IER_CC2IT_POS)

#define TIMER_IER_CC1IT_POS 1U
#define TIMER_IER_CC1IT_MSK BIT(TIMER_IER_CC1IT_POS)

#define TIMER_IER_UIT_POS   0U
#define TIMER_IER_UIT_MSK   BIT(TIMER_IER_UIT_POS)

/****************** Bit definition for TIMER_IDR register ************************/

#define TIMER_IDR_CC4OIT_POS 12U 
#define TIMER_IDR_CC4OIT_MSK BIT(TIMER_IDR_CC4OIT_POS)
       
#define TIEMR_IDR_CC3OIT_POS 11U 
#define TIEMR_IDR_CC3OIT_MSK BIT(TIMER_IDR_CC3OIT_POS)
       
#define TIMER_IDR_CC2OIT_POS 10U 
#define TIMER_IDR_CC2OIT_MSK BIT(TIMER_IDR_CC2OIT_POS)
       
#define TIMER_IDR_CC1OIT_POS 9U 
#define TIMER_IDR_CC1OIT_MSK BIT(TIMER_IDR_CC1OIT_POS)

#define TIMER_IDR_BRKIT_POS  7U
#define TIMER_IDR_BRKIT_MSK  BIT(TIMER_IDR_BRKIT_POS)

#define TIMER_IDR_TRGIT_POS  6U
#define TIMER_IDR_TRGIT_MSK  BIT(TIMER_IDR_TRGIT_POS)

#define TIMER_IDR_COMIT_POS  5U
#define TIMER_IDR_COMIT_MSK  BIT(TIMER_IDR_COMIT_POS)

#define TIMER_IDR_CC4IT_POS  4U
#define TIMER_IDR_CC4IT_MSK  BIT(TIMER_IDR_CC4IT_POS)

#define TIMER_IDR_CC3IT_POS  3U
#define TIMER_IDR_CC3IT_MSK  BIT(TIMER_IDR_CC3IT_POS)

#define TIMER_IDR_CC2IT_POS  2U
#define TIMER_IDR_CC2IT_MSK  BIT(TIMER_IDR_CC2IT_POS)

#define TIMER_IDR_CC1IT_POS  1U
#define TIMER_IDR_CC1IT_MSK  BIT(TIMER_IDR_CC1IT_POS)

#define TIMER_IDR_UIT_POS    0U
#define TIMER_IDR_UIT_MSK    BIT(TIMER_IDR_UIT_POS)

/****************** Bit definition for TIMER_IVS register ************************/

#define TIMER_IVS_CC4OIT_POS 12U 
#define TIMER_IVS_CC4OIT_MSK BIT(TIMER_IVS_CC4OIT_POS)
                             
#define TIMER_IVS_CC3OIT_POS 11U 
#define TIMER_IVS_CC3OIT_MSK BIT(TIMER_IVS_CC3OIT_POS)
                             
#define TIMER_IVS_CC2OIT_POS 10U 
#define TIMER_IVS_CC2OIT_MSK BIT(TIMER_IVS_CC2OIT_POS)
                             
#define TIMER_IVS_CC1OIT_POS 9U 
#define TIMER_IVS_CC1OIT_MSK BIT(TIMER_IVS_CC1OIT_POS)

#define TIMER_IVS_BKIT_POS   7U
#define TIMER_IVS_BKIT_MSK   BIT(TIMER_IVS_BKIT_POS)

#define TIMER_IVS_TRGIT_POS  6U
#define TIMER_IVS_TRGIT_MSK  BIT(TIMER_IVS_TRGIT_POS)

#define TIMER_IVS_COMIT_POS  5U
#define TIMER_IVS_COMIT_MSK  BIT(TIMER_IVS_COMIT_POS)

#define TIMER_IVS_CC4IT_POS  4U
#define TIMER_IVS_CC4IT_MSK  BIT(TIMER_IVS_CC4IT_POS)

#define TIMER_IVS_CC3IT_POS  3U
#define TIMER_IVS_CC3IT_MSK  BIT(TIMER_IVS_CC3IT_POS)

#define TIMER_IVS_CC2IT_POS  2U
#define TIMER_IVS_CC2IT_MSK  BIT(TIMER_IVS_CC2IT_POS)

#define TIMER_IVS_CC1IT_POS  1U
#define TIMER_IVS_CC1IT_MSK  BIT(TIMER_IVS_CC1IT_POS)

#define TIMER_IVS_UEIT_POS   0U
#define TIMER_IVS_UEIT_MSK   BIT(TIMER_IVS_UEIT_POS)

/****************** Bit definition for TIMER_RIF register ************************/

#define TIMER_RIF_CH4OVIF_POS   12U
#define TIMER_RIF_CH4OVIF_MSK   BIT(TIMER_RIF_CH4OVIF_POS)

#define TIMER_RIF_CH3OVIF_POS   11U
#define TIMER_RIF_CH3OVIF_MSK   BIT(TIMER_RIF_CH3OVIF_POS)

#define TIMER_RIF_CH2OVIF_POS   10U
#define TIMER_RIF_CH2OVIF_MSK   BIT(TIMER_RIF_CH2OVIF_POS)

#define TIMER_RIF_CH1OVIF_POS   9U
#define TIMER_RIF_CH1OVIF_MSK   BIT(TIMER_RIF_CH1OVIF_POS)

#define TIMER_RIF_BRKIF_POS 7U
#define TIMER_RIF_BRKIF_MSK BIT(TIMER_RIF_BRKIF_POS)

#define TIMER_RIF_TRGIF_POS 6U
#define TIMER_RIF_TRGIF_MSK BIT(TIMER_RIF_TRGIF_POS)

#define TIMER_RIF_COMIF_POS 5U
#define TIMER_RIF_COMIF_MSK BIT(TIMER_RIF_COMIF_POS)

#define TIMER_RIF_CH4IF_POS 4U
#define TIMER_RIF_CH4IF_MSK BIT(TIMER_RIF_CH4IF_POS)

#define TIMER_RIF_CH3IF_POS 3U
#define TIMER_RIF_CH3IF_MSK BIT(TIMER_RIF_CH3IF_POS)

#define TIMER_RIF_CH2IF_POS 2U
#define TIMER_RIF_CH2IF_MSK BIT(TIMER_RIF_CH2IF_POS)

#define TIMER_RIF_CH1IF_POS 1U
#define TIMER_RIF_CH1IF_MSK BIT(TIMER_RIF_CH1IF_POS)

#define TIMER_RIF_UEVTIF_POS    0U
#define TIMER_RIF_UEVTIF_MSK    BIT(TIMER_RIF_UEVTIF_POS)

/****************** Bit definition for TIMER_IFM register ************************/

#define TIMER_IFM_CH4OVIM_POS 12U 
#define TIMER_IFM_CH4OVIM_MSK BIT(TIMER_IFM_CH4OVIM_POS)
       
#define TIMER_IFM_CH3OVIM_POS 11U 
#define TIMER_IFM_CH3OVIM_MSK BIT(TIMER_IFM_CH3OVIM_POS)
       
#define TIMER_IFM_CH2OVIM_POS 10U 
#define TIMER_IFM_CH2OVIM_MSK BIT(TIMER_IFM_CH2OVIM_POS)
       
#define TIMER_IFM_CH1OVIM_POS 9U 
#define TIMER_IFM_CH1OVIM_MSK BIT(TIMER_IFM_CH1OVIM_POS)

#define TIMER_IFM_BRKIM_POS 7U
#define TIMER_IFM_BRKIM_MSK BIT(TIMER_IFM_BRKIM_POS)

#define TIMER_IFM_TRGIM_POS  6U
#define TIMER_IFM_TRGIM_MSK  BIT(TIMER_IFM_TRGIM_POS)

#define TIMER_IFM_COMIM_POS  5U
#define TIMER_IFM_COMIM_MSK  BIT(TIMER_IFM_COMIM_POS)

#define TIMER_IFM_CH4CCIM_POS    4U
#define TIMER_IFM_CH4CCIM_MSK    BIT(TIMER_IFM_CH4CCIM_POS)

#define TIMER_IFM_CH3CCIM_POS    3U
#define TIMER_IFM_CH3CCIM_MSK    BIT(TIMER_IFM_CH3CCIM_POS)

#define TIMER_IFM_CH2CCIM_POS    2U
#define TIMER_IFM_CH2CCIM_MSK    BIT(TIMER_IFM_CH2CCIM_POS)

#define TIMER_IFM_CH1CCIM_POS    1U
#define TIMER_IFM_CH1CCIM_MSK    BIT(TIMER_IFM_CH1CCIM_POS)

#define TIMER_IFM_UEIM_POS   0U
#define TIMER_IFM_UEIM_MSK   BIT(TIMER_IFM_UEIM_POS)

/****************** Bit definition for TIMER_ICR register ************************/

#define TIMER_ICR_CH4OVIC_POS 12U 
#define TIMER_ICR_CH4OVIC_MSK BIT(TIMER_ICR_CH4OVIC_POS)
       
#define TIEMR_ICR_CH3OVIC_POS 11U 
#define TIEMR_ICR_CH3OVIC_MSK BIT(TIMER_ICR_CH3OVIC_POS)
       
#define TIEMR_ICR_CH2OVIC_POS 10U 
#define TIEMR_ICR_CH2OVIC_MSK BIT(TIMER_ICR_CH2OVIC_POS)
       
#define TIMER_ICR_CH1OVIC_POS 9U 
#define TIMER_ICR_CH1OVIC_MSK BIT(TIMER_ICR_CH1OVIC_POS)

#define TIMER_ICR_BRKIC_POS 7U
#define TIMER_ICR_BRKIC_MSK BIT(TIMER_ICR_BRKIC_POS)

#define TIMER_ICR_TRGIC_POS 6U
#define TIMER_ICR_TRGIC_MSK BIT(TIMER_ICR_TRGIC_POS)

#define TIMER_ICR_COMIC_POS 5U
#define TIMER_ICR_COMIC_MSK BIT(TIMER_ICR_COMIC_POS)

#define TIMER_ICR_CH4CCIC_POS   4U
#define TIMER_ICR_CH4CCIC_MSK   BIT(TIMER_ICR_CH4CCIC_POS)

#define TIMER_ICR_CH3CCIC_POS   3U
#define TIMER_ICR_CH3CCIC_MSK   BIT(TIMER_ICR_CH3CCIC_POS)

#define TIMER_ICR_CH2CCIC_POS   2U
#define TIMER_ICR_CH2CCIC_MSK   BIT(TIMER_ICR_CH2CCIC_POS)

#define TIMER_ICR_CH1CCIC_POS   1U
#define TIMER_ICR_CH1CCIC_MSK   BIT(TIMER_ICR_CH1CCIC_POS)

#define TIMER_ICR_UEIC_POS  0U
#define TIMER_ICR_UEIC_MSK  BIT(TIMER_ICR_UEIC_POS)

/****************** Bit definition for TIMER_SGE register ************************/

#define TIMER_SGE_SGBRK_POS 7U
#define TIMER_SGE_SGBRK_MSK BIT(TIMER_SGE_SGBRK_POS)

#define TIMER_SGE_SGTRG_POS 6U
#define TIMER_SGE_SGTRG_MSK BIT(TIMER_SGE_SGTRG_POS)

#define TIMER_SGE_SGCOM_POS 5U
#define TIMER_SGE_SGCOM_MSK BIT(TIMER_SGE_SGCOM_POS)

#define TIMER_SGE_SGCC4E_POS    4U
#define TIMER_SGE_SGCC4E_MSK    BIT(TIMER_SGE_SGCC4E_POS)

#define TIMER_SGE_SGCC3E_POS    3U
#define TIMER_SGE_SGCC3E_MSK    BIT(TIMER_SGE_SGCC3E_POS)

#define TIMER_SGE_SGCC2E_POS    2U
#define TIMER_SGE_SGCC2E_MSK    BIT(TIMER_SGE_SGCC2E_POS)

#define TIMER_SGE_SGCC1E_POS    1U
#define TIMER_SGE_SGCC1E_MSK    BIT(TIMER_SGE_SGCC1E_POS)

#define TIMER_SGE_SGU_POS   0U
#define TIMER_SGE_SGU_MSK   BIT(TIMER_SGE_SGU_POS)

/****************** Bit definition for TIMER_CHMR1 register ************************/
/* Output */
#define TIMER_CHMR1_CH2OCLREN_POS   15U
#define TIMER_CHMR1_CH2OCLREN_MSK   BIT(TIMER_CHMR1_CH2OCLREN_POS)

#define TIMER_CHMR1_CH2OMOD_POSS    12U
#define TIMER_CHMR1_CH2OMOD_POSE    14U
#define TIMER_CHMR1_CH2OMOD_MSK BITS(TIMER_CHMR1_CH2OMOD_POSS,TIMER_CHMR1_CH2OMOD_POSE)

#define TIMER_CHMR1_CH2OPEN_POS 11U
#define TIMER_CHMR1_CH2OPEN_MSK BIT(TIMER_CHMR1_CH2OPEN_POS)

#define TIMER_CHMR1_CH2OFEN_POS 10U
#define TIMER_CHMR1_CH2OFEN_MSK BIT(TIMER_CHMR1_CH2OFEN_POS)

#define TIMER_CHMR1_CC2SSEL_POSS    8U
#define TIMER_CHMR1_CC2SSEL_POSE    9U
#define TIMER_CHMR1_CC2SSEL_MSK BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define TIMER_CHMR1_CH1OCLREN_POS   7U
#define TIMER_CHMR1_CH1OCLREN_MSK   BIT(TIMER_CHMR1_CH1OCLREN_POS)

#define TIMER_CHMR1_CH1OMOD_POSS    4U
#define TIMER_CHMR1_CH1OMOD_POSE    6U
#define TIMER_CHMR1_CH1OMOD_MSK BITS(TIMER_CHMR1_CH1OMOD_POSS,TIMER_CHMR1_CH1OMOD_POSE)

#define TIMER_CHMR1_CH1OPREN_POS    3U
#define TIMER_CHMR1_CH1OPREN_MSK    BIT(TIMER_CHMR1_CH1OPREN_POS)

#define TIMER_CHMR1_CH1OHSEN_POS    2U
#define TIMER_CHMR1_CH1OHSEN_MSK    BIT(TIMER_CHMR1_CH1OHSEN_POS)

#define TIMER_CHMR1_CC1SSEL_POSS    0U
#define TIMER_CHMR1_CC1SSEL_POSE    1U
#define TIMER_CHMR1_CC1SSEL_MSK BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/* Input */
#define TIMER_CHMR1_I2FLT_POSS  12U
#define TIMER_CHMR1_I2FLT_POSE  15U
#define TIMER_CHMR1_I2FLT_MSK   BITS(TIMER_CHMR1_I2FLT_POSS,TIMER_CHMR1_I2FLT_POSE)

#define TIMER_CHMR1_IC2PRES_POSS    10U
#define TIMER_CHMR1_IC2PRES_POSE    11U
#define TIMER_CHMR1_IC2PRES_MSK BITS(TIMER_CHMR1_IC2PRES_POSS,TIMER_CHMR1_IC2PRES_POSE)

#define TIMER_CHMR1_CC2SSEL_POSS    8U
#define TIMER_CHMR1_CC2SSEL_POSE    9U
#define TIMER_CHMR1_CC2SSEL_MSK BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define TIMER_CHMR1_I1FLT_POSS  4U
#define TIMER_CHMR1_I1FLT_POSE  7U
#define TIMER_CHMR1_I1FLT_MSK   BITS(TIMER_CHMR1_I1FLT_POSS,TIMER_CHMR1_I1FLT_POSE)

#define TIMER_CHMR1_IC1PRES_POSS    2U
#define TIMER_CHMR1_IC1PRES_POSE    3U
#define TIMER_CHMR1_IC1PRES_MSK BITS(TIMER_CHMR1_IC1PRES_POSS,TIMER_CHMR1_IC1PRES_POSE)

#define TIMER_CHMR1_CC1SSEL_POSS    0U
#define TIMER_CHMR1_CC1SSEL_POSE    1U
#define TIMER_CHMR1_CC1SSEL_MSK BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2 register ************************/
/* Output */
#define TIMER_CHMR2_CH4OCLREN_POS   15U
#define TIMER_CHMR2_CH4OCLREN_MSK   BIT(TIMER_CHMR2_CH4OCLREN_POS)

#define TIMER_CHMR2_CH4OMOD_POSS    12U
#define TIMER_CHMR2_CH4OMOD_POSE    14U
#define TIMER_CHMR2_CH4OMOD_MSK BITS(TIMER_CHMR2_CH4OMOD_POSS,TIMER_CHMR2_CH4OMOD_POSE)

#define TIMER_CHMR2_CH4OPEN_POS 11U
#define TIMER_CHMR2_CH4OPEN_MSK BIT(TIMER_CHMR2_CH4OPEN_POS)

#define TIMER_CHMR2_CH4OHSEN_POS    10U
#define TIMER_CHMR2_CH4OHSEN_MSK    BIT(TIMER_CHMR2_CH4OHSEN_POS)

#define TIMER_CHMR2_CC4SSEL_POSS    8U
#define TIMER_CHMR2_CC4SSEL_POSE    9U
#define TIMER_CHMR2_CC4SSEL_MSK BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define TIMER_CHMR2_CH3OCLREN_POS   7U
#define TIMER_CHMR2_CH3OCLREN_MSK   BIT(TIMER_CHMR2_CH3OCLREN_POS)

#define TIMER_CHMR2_CH3OMOD_POSS    4U
#define TIMER_CHMR2_CH3OMOD_POSE    6U
#define TIMER_CHMR2_CH3OMOD_MSK BITS(TIMER_CHMR2_CH3OMOD_POSS,TIMER_CHMR2_CH3OMOD_POSE)

#define TIMER_CHMR2_CH3OPEN_POS 3U
#define TIMER_CHMR2_CH3OPEN_MSK BIT(TIMER_CHMR2_CH3OPEN_POS)

#define TIMER_CHMR2_CH3OFEN_POS 2U
#define TIMER_CHMR2_CH3OFEN_MSK BIT(TIMER_CHMR2_CH3OFEN_POS)

#define TIMER_CHMR2_CC3SSEL_POSS    0U
#define TIMER_CHMR2_CC3SSEL_POSE    1U
#define TIMER_CHMR2_CC3SSEL_MSK BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/* Input */
#define TIMER_CHMR2_I4FLT_POSS  12U
#define TIMER_CHMR2_I4FLT_POSE  15U
#define TIMER_CHMR2_I4FLT_MSK   BITS(TIMER_CHMR2_I4FLT_POSS,TIMER_CHMR2_I4FLT_POSE)

#define TIMER_CHMR2_IC4PRES_POSS    10U
#define TIMER_CHMR2_IC4PRES_POSE    11U
#define TIMER_CHMR2_IC4PRES_MSK BITS(TIMER_CHMR2_IC4PRES_POSS,TIMER_CHMR2_IC4PRES_POSE)

#define TIMER_CHMR2_CC4SSEL_POSS    8U
#define TIMER_CHMR2_CC4SSEL_POSE    9U
#define TIMER_CHMR2_CC4SSEL_MSK BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define TIMER_CHMR2_I3FLT_POSS  4U
#define TIMER_CHMR2_I3FLT_POSE  7U
#define TIMER_CHMR2_I3FLT_MSK   BITS(TIMER_CHMR2_I3FLT_POSS,TIMER_CHMR2_I3FLT_POSE)

#define TIMER_CHMR2_IC3PRES_POSS    2U
#define TIMER_CHMR2_IC3PRES_POSE    3U
#define TIMER_CHMR2_IC3PRES_MSK BITS(TIMER_CHMR2_IC3PRES_POSS,TIMER_CHMR2_IC3PRES_POSE)

#define TIMER_CHMR2_CC3SSEL_POSS    0U
#define TIMER_CHMR2_CC3SSEL_POSE    1U
#define TIMER_CHMR2_CC3SSEL_MSK BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CCEP register ************************/

#define TIMER_CCEP_CC4NPOL_POS  15U 
#define TIMER_CCEP_CC4NPOL_MSK  BIT(TIMER_CCEP_CC4NPOL_POS)

#define TIMER_CCEP_CC4POL_POS   13U
#define TIMER_CCEP_CC4POL_MSK   BIT(TIMER_CCEP_CC4POL_POS)

#define TIMER_CCEP_CC4EN_POS    12U
#define TIMER_CCEP_CC4EN_MSK    BIT(TIMER_CCEP_CC4EN_POS)

#define TIMER_CCEP_CC3NPOL_POS  11U
#define TIMER_CCEP_CC3NPOL_MSK  BIT(TIMER_CCEP_CC3NPOL_POS)

#define TIMER_CCEP_CC3NEN_POS   10U
#define TIMER_CCEP_CC3NEN_MSK   BIT(TIMER_CCEP_CC3NEN_POS)

#define TIMER_CCEP_CC3POL_POS   9U
#define TIMER_CCEP_CC3POL_MSK   BIT(TIMER_CCEP_CC3POL_POS)

#define TIMER_CCEP_CC3EN_POS    8U
#define TIMER_CCEP_CC3EN_MSK    BIT(TIMER_CCEP_CC3EN_POS)

#define TIMER_CCEP_CC2NPOL_POS  7U
#define TIMER_CCEP_CC2NPOL_MSK  BIT(TIMER_CCEP_CC2NPOL_POS)

#define TIMER_CCEP_CC2NEN_POS   6U
#define TIMER_CCEP_CC2NEN_MSK   BIT(TIMER_CCEP_CC2NEN_POS)

#define TIMER_CCEP_CC2POL_POS   5U
#define TIMER_CCEP_CC2POL_MSK   BIT(TIMER_CCEP_CC2POL_POS)

#define TIMER_CCEP_CC2EN_POS    4U
#define TIMER_CCEP_CC2EN_MSK    BIT(TIMER_CCEP_CC2EN_POS)

#define TIMER_CCEP_CC1NPOL_POS  3U
#define TIMER_CCEP_CC1NPOL_MSK  BIT(TIMER_CCEP_CC1NPOL_POS)

#define TIMER_CCEP_CC1NEN_POS   2U
#define TIMER_CCEP_CC1NEN_MSK   BIT(TIMER_CCEP_CC1NEN_POS)

#define TIMER_CCEP_CC1POL_POS   1U
#define TIMER_CCEP_CC1POL_MSK   BIT(TIMER_CCEP_CC1POL_POS)

#define TIMER_CCEP_CC1EN_POS    0U
#define TIMER_CCEP_CC1EN_MSK    BIT(TIMER_CCEP_CC1EN_POS)

/****************** Bit definition for TIMER_COUNT register ************************/

#define TIMER_COUNT_CNTV_POSS   0U
#define TIMER_COUNT_CNTV_POSE   15U
#define TIMER_COUNT_CNTV_MSK    BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)

/****************** Bit definition for TIMER_PRES register ************************/

#define TIMER_PRES_PSCV_POSS    0U
#define TIMER_PRES_PSCV_POSE    15U
#define TIMER_PRES_PSCV_MSK BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)

/****************** Bit definition for TIMER_AR register ************************/

#define TIMER_AR_ARRV_POSS  0U
#define TIMER_AR_ARRV_POSE  15U
#define TIMER_AR_ARRV_MSK   BITS(TIMER_AR_ARRV_POSS,TIMER_AR_ARRV_POSE)

/****************** Bit definition for TIMER_REPAR register ************************/

#define TIMER_REPAR_REPV_POSS   0U
#define TIMER_REPAR_REPV_POSE   7U
#define TIMER_REPAR_REPV_MSK    BITS(TIMER_REPAR_REPV_POSS,TIMER_REPAR_REPV_POSE)

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define TIMER_CCVAL1_CCRV1_POSS 0U
#define TIMER_CCVAL1_CCRV1_POSE 15U
#define TIMER_CCVAL1_CCRV1_MSK  BITS(TIMER_CCVAL1_CCRV1_POSS,TIMER_CCVAL1_CCRV1_POSE)

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define TIMER_CCVAL2_CCRV2_POSS 0U
#define TIMER_CCVAL2_CCRV2_POSE 15U
#define TIMER_CCVAL2_CCRV2_MSK  BITS(TIMER_CCVAL2_CCRV2_POSS,TIMER_CCVAL2_CCRV2_POSE)

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define TIMER_CCVAL3_CCRV3_POSS 0U
#define TIMER_CCVAL3_CCRV3_POSE 15U
#define TIMER_CCVAL3_CCRV3_MSK  BITS(TIMER_CCVAL3_CCRV3_POSS,TIMER_CCVAL3_CCRV3_POSE)

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define TIMER_CCVAL4_CCRV4_POSS 0U
#define TIMER_CCVAL4_CCRV4_POSE 15U
#define TIMER_CCVAL4_CCRV4_MSK  BITS(TIMER_CCVAL4_CCRV4_POSS,TIMER_CCVAL4_CCRV4_POSE)

/****************** Bit definition for TIMER_BDCFG register ************************/

#define TIMER_BDCFG_GOEN_POS    15U
#define TIMER_BDCFG_GOEN_MSK    BIT(TIMER_BDCFG_GOEN_POS)

#define TIMER_BDCFG_AOEN_POS    14U
#define TIMER_BDCFG_AOEN_MSK    BIT(TIMER_BDCFG_AOEN_POS)

#define TIMER_BDCFG_BRKP_POS    13U
#define TIMER_BDCFG_BRKP_MSK    BIT(TIMER_BDCFG_BRKP_POS)

#define TIMER_BDCFG_BRKEN_POS   12U
#define TIMER_BDCFG_BRKEN_MSK   BIT(TIMER_BDCFG_BRKEN_POS)

#define TIMER_BDCFG_OFFSSR_POS  11U
#define TIMER_BDCFG_OFFSSR_MSK  BIT(TIMER_BDCFG_OFFSSR_POS)

#define TIMER_BDCFG_OFFSSI_POS  10U
#define TIMER_BDCFG_OFFSSI_MSK  BIT(TIMER_BDCFG_OFFSSI_POS)

#define TIMER_BDCFG_LOCKLVL_POSS    8U
#define TIMER_BDCFG_LOCKLVL_POSE    9U
#define TIMER_BDCFG_LOCKLVL_MSK BITS(TIMER_BDCFG_LOCKLVL_POSS,TIMER_BDCFG_LOCKLVL_POSE)

#define TIMER_BDCFG_DT_POSS 0U
#define TIMER_BDCFG_DT_POSE 7U
#define TIMER_BDCFG_DT_MSK  BITS(TIMER_BDCFG_DT_POSS,TIMER_BDCFG_DT_POSE)

/****************** Bit definition for TIMER_DMAEN register ************************/

#define TIMER_DMAEN_TRGDMA_POS  6U
#define TIMER_DMAEN_TRGDMA_MSK  BIT(TIMER_DMAEN_TRGDMA_POS)

#define TIMER_DMAEN_COMDMA_POS    5U
#define TIMER_DMAEN_COMDMA_MSK    BIT(TIMER_DMAEN_COMDMA_POS)

#define TIMER_DMAEN_CC4DMA_POS    4U
#define TIMER_DMAEN_CC4DMA_MSK    BIT(TIMER_DMAEN_CC4DMA_POS)

#define TIMER_DMAEN_CC3DMA_POS    3U
#define TIMER_DMAEN_CC3DMA_MSK    BIT(TIMER_DMAEN_CC3DMA_POS)

#define TIMER_DMAEN_CC2DMA_POS    2U
#define TIMER_DMAEN_CC2DMA_MSK    BIT(TIMER_DMAEN_CC2DMA_POS)

#define TIMER_DMAEN_CC1DMA_POS    1U
#define TIMER_DMAEN_CC1DMA_MSK    BIT(TIMER_DMAEN_CC1DMA_POS)

#define TIMER_DMAEN_UDMA_POS  0U
#define TIMER_DMAEN_UDMA_MSK  BIT(TIMER_DMAEN_UDMA_POS)

/****************** Bit definition for AD16C4T_OPTR register ************************/

#define TIMER_OPTR_ETR_RMP_POSS 8U 
#define TIMER_OPTR_ETR_RMP_POSE 9U 
#define TIMER_OPTR_ETR_RMP_MSK  BITS(TIMER_OPTR_ETR_RMP_POSS,TIMER_OPTR_ETR_RMP_POSE)
        
#define TIMER_OPTR_CH4_RMP_POSS 6U 
#define TIMER_OPTR_CH4_RMP_POSE 7U 
#define TIMER_OPTR_CH4_RMP_MSK  BITS(TIMER_OPTR_CH4_RMP_POSS,TIMER_OPTR_CH4_RMP_POSE)
        
#define TIMER_OPTR_CH3_RMP_POSS 4U 
#define TIMER_OPTR_CH3_RMP_POSE 5U 
#define TIMER_OPTR_CH3_RMP_MSK  BITS(TIMER_OPTR_CH3_RMP_POSS,TIMER_OPTR_CH3_RMP_POSE)
        
#define TIMER_OPTR_CH2_RMP_POSS 2U 
#define TIMER_OPTR_CH2_RMP_POSE 3U 
#define TIMER_OPTR_CH2_RMP_MSK  BITS(TIMER_OPTR_CH2_RMP_POSS,TIMER_OPTR_CH2_RMP_POSE)
        
#define TIMER_OPTR_CH1_RMP_POSS 0U 
#define TIMER_OPTR_CH1_RMP_POSE 1U 
#define TIMER_OPTR_CH1_RMP_MSK  BITS(TIMER_OPTR_CH1_RMP_POSS,TIMER_OPTR_CH1_RMP_POSE)


typedef struct
{
    __IO uint32_t CON1;
    __IO uint32_t CON2;
    __IO uint32_t SMCON;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __O uint32_t SGE;
    __IO uint32_t CHMR1;
    __IO uint32_t CHMR2;
    __IO uint32_t CCEP;
    __IO uint32_t COUNT;
    __IO uint32_t PRES;
    __IO uint32_t AR;
    __IO uint32_t REPAR;
    __IO uint32_t CCVAL1;
    __IO uint32_t CCVAL2;
    __IO uint32_t CCVAL3;
    __IO uint32_t CCVAL4;
    __IO uint32_t BDCFG;
    __IO uint32_t DMAEN;
    __IO uint32_t OPTR;
} TIMER_TypeDef;

#define TIMER0  AD16C4T0
#define TIMER2  GP32C4T0
#define TIMER3  GP32C4T1
#define TIMER4  BS16T0
#define TIMER5  BS16T1
#define TIMER6  GP16C4T0
#define TIMER7  GP16C4T1

/****************** Bit definition for UART_RXBUF register ************************/

#define UART_RXBUF_RXBUF_POSS   0U
#define UART_RXBUF_RXBUF_POSE   8U
#define UART_RXBUF_RXBUF_MSK    BITS(UART_RXBUF_RXBUF_POSS,UART_RXBUF_RXBUF_POSE)

/****************** Bit definition for UART_TXBUF register ************************/

#define UART_TXBUF_TXBUF_POSS   0U
#define UART_TXBUF_TXBUF_POSE   8U
#define UART_TXBUF_TXBUF_MSK    BITS(UART_TXBUF_TXBUF_POSS,UART_TXBUF_TXBUF_POSE)

/****************** Bit definition for UART_BRR register ************************/

#define UART_BRR_BRR_POSS   0U
#define UART_BRR_BRR_POSE   15U
#define UART_BRR_BRR_MSK    BITS(UART_BRR_BRR_POSS,UART_BRR_BRR_POSE)

/****************** Bit definition for UART_LCON register ************************/

#define UART_LCON_TXEN_POS  15U
#define UART_LCON_TXEN_MSK  BIT(UART_LCON_TXEN_POS)

#define UART_LCON_RXEN_POS  14U
#define UART_LCON_RXEN_MSK  BIT(UART_LCON_RXEN_POS)

#define UART_LCON_DBCEN_POS 13U
#define UART_LCON_DBCEN_MSK BIT(UART_LCON_DBCEN_POS)

#define UART_LCON_BREAK_POS 10U
#define UART_LCON_BREAK_MSK BIT(UART_LCON_BREAK_POS)

#define UART_LCON_TXINV_POS 8U
#define UART_LCON_TXINV_MSK BIT(UART_LCON_TXINV_POS)

#define UART_LCON_RXINV_POS 7U
#define UART_LCON_RXINV_MSK BIT(UART_LCON_RXINV_POS)

#define UART_LCON_DATAINV_POS   6U
#define UART_LCON_DATAINV_MSK   BIT(UART_LCON_DATAINV_POS)

#define UART_LCON_MSB_POS   5U
#define UART_LCON_MSB_MSK   BIT(UART_LCON_MSB_POS)

#define UART_LCON_PS_POS    4U
#define UART_LCON_PS_MSK    BIT(UART_LCON_PS_POS)

#define UART_LCON_PE_POS    3U
#define UART_LCON_PE_MSK    BIT(UART_LCON_PE_POS)

#define UART_LCON_STOP_POS  2U
#define UART_LCON_STOP_MSK  BIT(UART_LCON_STOP_POS)

#define UART_LCON_DLS_POSS  0U
#define UART_LCON_DLS_POSE  1U
#define UART_LCON_DLS_MSK   BITS(UART_LCON_DLS_POSS,UART_LCON_DLS_POSE)

/****************** Bit definition for UART_MCON register ************************/

#define UART_MCON_TXFLOAT_POS   16U
#define UART_MCON_TXFLOAT_MSK   BIT(UART_MCON_TXFLOAT_POS)

#define UART_MCON_TXDMAEN_POS   15U
#define UART_MCON_TXDMAEN_MSK   BIT(UART_MCON_TXDMAEN_POS)

#define UART_MCON_RXDMAEN_POS   14U
#define UART_MCON_RXDMAEN_MSK   BIT(UART_MCON_RXDMAEN_POS)

#define UART_MCON_ABRREPT_POS   11U
#define UART_MCON_ABRREPT_MSK   BIT(UART_MCON_ABRREPT_POS)

#define UART_MCON_ABRMOD_POSS   9U
#define UART_MCON_ABRMOD_POSE   10U
#define UART_MCON_ABRMOD_MSK    BITS(UART_MCON_ABRMOD_POSS,UART_MCON_ABRMOD_POSE)

#define UART_MCON_ABREN_POS 8U
#define UART_MCON_ABREN_MSK BIT(UART_MCON_ABREN_POS)

#define UART_MCON_BKREQ_POS 5U
#define UART_MCON_BKREQ_MSK BIT(UART_MCON_BKREQ_POS)

#define UART_MCON_HDEN_POS  4U
#define UART_MCON_HDEN_MSK  BIT(UART_MCON_HDEN_POS)

#define UART_MCON_IREN_POS  3U
#define UART_MCON_IREN_MSK  BIT(UART_MCON_IREN_POS)

#define UART_MCON_AFCEN_POS 2U
#define UART_MCON_AFCEN_MSK BIT(UART_MCON_AFCEN_POS)

#define UART_MCON_RTSSET_POS    1U
#define UART_MCON_RTSSET_MSK    BIT(UART_MCON_RTSSET_POS)

#define UART_MCON_LPBKEN_POS    0U
#define UART_MCON_LPBKEN_MSK    BIT(UART_MCON_LPBKEN_POS)

/****************** Bit definition for UART_RS485 register ************************/

#define UART_RS485_DLY_POSS 16U
#define UART_RS485_DLY_POSE 23U
#define UART_RS485_DLY_MSK  BITS(UART_RS485_DLY_POSS,UART_RS485_DLY_POSE)

#define UART_RS485_ADDR_POSS    8U
#define UART_RS485_ADDR_POSE    15U
#define UART_RS485_ADDR_MSK BITS(UART_RS485_ADDR_POSS,UART_RS485_ADDR_POSE)

#define UART_RS485_AADINV_POS   3U
#define UART_RS485_AADINV_MSK   BIT(UART_RS485_AADINV_POS)

#define UART_RS485_AADACEN_POS  2U
#define UART_RS485_AADACEN_MSK  BIT(UART_RS485_AADACEN_POS)

#define UART_RS485_AADNEN_POS   1U
#define UART_RS485_AADNEN_MSK   BIT(UART_RS485_AADNEN_POS)

#define UART_RS485_AADEN_POS    0U
#define UART_RS485_AADEN_MSK    BIT(UART_RS485_AADEN_POS)

/****************** Bit definition for UART_SCARD register ************************/

#define UART_SCARD_BLEN_POSS    24U
#define UART_SCARD_BLEN_POSE    31U
#define UART_SCARD_BLEN_MSK BITS(UART_SCARD_BLEN_POSS,UART_SCARD_BLEN_POSE)

#define UART_SCARD_GT_POSS  16U
#define UART_SCARD_GT_POSE  23U
#define UART_SCARD_GT_MSK   BITS(UART_SCARD_GT_POSS,UART_SCARD_GT_POSE)

#define UART_SCARD_PSC_POSS 8U
#define UART_SCARD_PSC_POSE 15U
#define UART_SCARD_PSC_MSK  BITS(UART_SCARD_PSC_POSS,UART_SCARD_PSC_POSE)

#define UART_SCARD_SCCNT_POSS   3U
#define UART_SCARD_SCCNT_POSE   5U
#define UART_SCARD_SCCNT_MSK    BITS(UART_SCARD_SCCNT_POSS,UART_SCARD_SCCNT_POSE)

#define UART_SCARD_SCLKEN_POS   2U
#define UART_SCARD_SCLKEN_MSK   BIT(UART_SCARD_SCLKEN_POS)

#define UART_SCARD_SCNACK_POS   1U
#define UART_SCARD_SCNACK_MSK   BIT(UART_SCARD_SCNACK_POS)

#define UART_SCARD_SCEN_POS 0U
#define UART_SCARD_SCEN_MSK BIT(UART_SCARD_SCEN_POS)

/****************** Bit definition for UART_LIN register ************************/

#define UART_LIN_LINBKREQ_POS   2U
#define UART_LIN_LINBKREQ_MSK   BIT(UART_LIN_LINBKREQ_POS)

#define UART_LIN_LINBDL_POS 1U
#define UART_LIN_LINBDL_MSK BIT(UART_LIN_LINBDL_POS)

#define UART_LIN_LINEN_POS  0U
#define UART_LIN_LINEN_MSK  BIT(UART_LIN_LINEN_POS)

/****************** Bit definition for UART_RTOR register ************************/

#define UART_RTOR_RTOEN_POS 24U
#define UART_RTOR_RTOEN_MSK BIT(UART_RTOR_RTOEN_POS)

#define UART_RTOR_RTO_POSS  0U
#define UART_RTOR_RTO_POSE  23U
#define UART_RTOR_RTO_MSK   BITS(UART_RTOR_RTO_POSS,UART_RTOR_RTO_POSE)

/****************** Bit definition for UART_FCON register ************************/

#define UART_FCON_TXFL_POSS 11U
#define UART_FCON_TXFL_POSE 15U
#define UART_FCON_TXFL_MSK  BITS(UART_FCON_TXFL_POSS,UART_FCON_TXFL_POSE)

#define UART_FCON_TXTH_POSS 9U
#define UART_FCON_TXTH_POSE 10U
#define UART_FCON_TXTH_MSK  BITS(UART_FCON_TXTH_POSS,UART_FCON_TXTH_POSE)

#define UART_FCON_TFRST_POS 8U
#define UART_FCON_TFRST_MSK BIT(UART_FCON_TFRST_POS)

#define UART_FCON_RXFL_POSS 3U
#define UART_FCON_RXFL_POSE 7U
#define UART_FCON_RXFL_MSK  BITS(UART_FCON_RXFL_POSS,UART_FCON_RXFL_POSE)

#define UART_FCON_RXTH_POSS 1U
#define UART_FCON_RXTH_POSE 2U
#define UART_FCON_RXTH_MSK  BITS(UART_FCON_RXTH_POSS,UART_FCON_RXTH_POSE)

#define UART_FCON_RFRST_POS 0U
#define UART_FCON_RFRST_MSK BIT(UART_FCON_RFRST_POS)

/****************** Bit definition for UART_STAT register ************************/

#define UART_STAT_TFOERR_POS    18U
#define UART_STAT_TFOERR_MSK    BIT(UART_STAT_TFOERR_POS)

#define UART_STAT_TFFULL_POS    17U
#define UART_STAT_TFFULL_MSK    BIT(UART_STAT_TFFULL_POS)

#define UART_STAT_TFEMPTY_POS   16U
#define UART_STAT_TFEMPTY_MSK   BIT(UART_STAT_TFEMPTY_POS)

#define UART_STAT_TFTH_POS      15U
#define UART_STAT_TFTH_MSK      BIT(UART_STAT_TFTH_POS)

#define UART_STAT_TSBUSY_POS    14U
#define UART_STAT_TSBUSY_MSK    BIT(UART_STAT_TSBUSY_POS)

#define UART_STAT_RFUERR_POS    13U
#define UART_STAT_RFUERR_MSK    BIT(UART_STAT_RFUERR_POS)

#define UART_STAT_RFOERR_POS    12U
#define UART_STAT_RFOERR_MSK    BIT(UART_STAT_RFOERR_POS)

#define UART_STAT_RFFULL_POS    11U
#define UART_STAT_RFFULL_MSK    BIT(UART_STAT_RFFULL_POS)

#define UART_STAT_RFNEMPTY_POS   10U
#define UART_STAT_RFNEMPTY_MSK   BIT(UART_STAT_RFNEMPTY_POS)

#define UART_STAT_RFTH_POS  9U
#define UART_STAT_RFTH_MSK  BIT(UART_STAT_RFTH_POS)

#define UART_STAT_RSBUSY_POS    8U
#define UART_STAT_RSBUSY_MSK    BIT(UART_STAT_RSBUSY_POS)

#define UART_STAT_CTSSTA_POS    3U
#define UART_STAT_CTSSTA_MSK    BIT(UART_STAT_CTSSTA_POS)

#define UART_STAT_BKERR_POS 2U
#define UART_STAT_BKERR_MSK BIT(UART_STAT_BKERR_POS)

#define UART_STAT_FERR_POS  1U
#define UART_STAT_FERR_MSK  BIT(UART_STAT_FERR_POS)

#define UART_STAT_PERR_POS  0U
#define UART_STAT_PERR_MSK  BIT(UART_STAT_PERR_POS)

/****************** Bit definition for UART_IER register ************************/

#define UART_IER_TFOVER_POS 18U
#define UART_IER_TFOVER_MSK BIT(UART_IER_TFOVER_POS)

#define UART_IER_TFEMPTY_POS    16U
#define UART_IER_TFEMPTY_MSK    BIT(UART_IER_TFEMPTY_POS)

#define UART_IER_TFTH_POS   15U
#define UART_IER_TFTH_MSK   BIT(UART_IER_TFTH_POS)

#define UART_IER_TBC_POS    14U
#define UART_IER_TBC_MSK    BIT(UART_IER_TBC_POS)

#define UART_IER_RFUERR_POS 13U
#define UART_IER_RFUERR_MSK BIT(UART_IER_RFUERR_POS)

#define UART_IER_RFOERR_POS 12U
#define UART_IER_RFOERR_MSK BIT(UART_IER_RFOERR_POS)

#define UART_IER_RFFULL_POS 11U
#define UART_IER_RFFULL_MSK BIT(UART_IER_RFFULL_POS)

#define UART_IER_RFNEMPTY_POS 10U
#define UART_IER_RFNEMPTY_MSK BIT(UART_IER_RFNEMPTY_POS)

#define UART_IER_RFTH_POS   9U
#define UART_IER_RFTH_MSK   BIT(UART_IER_RFTH_POS)

#define UART_IER_NOISE_POS  8U
#define UART_IER_NOISE_MSK  BIT(UART_IER_NOISE_POS)

#define UART_IER_EOB_POS    7U
#define UART_IER_EOB_MSK    BIT(UART_IER_EOB_POS)

#define UART_IER_LINBK_POS  6U
#define UART_IER_LINBK_MSK  BIT(UART_IER_LINBK_POS)

#define UART_IER_ADDRM_POS  5U
#define UART_IER_ADDRM_MSK  BIT(UART_IER_ADDRM_POS)

#define UART_IER_RXTO_POS   4U
#define UART_IER_RXTO_MSK   BIT(UART_IER_RXTO_POS)

#define UART_IER_DCTS_POS   3U
#define UART_IER_DCTS_MSK   BIT(UART_IER_DCTS_POS)

#define UART_IER_ABTO_POS   2U
#define UART_IER_ABTO_MSK   BIT(UART_IER_ABTO_POS)

#define UART_IER_ABEND_POS  1U
#define UART_IER_ABEND_MSK  BIT(UART_IER_ABEND_POS)

#define UART_IER_RXBERR_POS 0U
#define UART_IER_RXBERR_MSK BIT(UART_IER_RXBERR_POS)

/****************** Bit definition for UART_IDR register ************************/

#define UART_IDR_TFOVER_POS 18U
#define UART_IDR_TFOVER_MSK BIT(UART_IDR_TFOVER_POS)

#define UART_IDR_TFEMPTY_POS    16U
#define UART_IDR_TFEMPTY_MSK    BIT(UART_IDR_TFEMPTY_POS)

#define UART_IDR_TFTH_POS   15U
#define UART_IDR_TFTH_MSK   BIT(UART_IDR_TFTH_POS)

#define UART_IDR_TBC_POS    14U
#define UART_IDR_TBC_MSK    BIT(UART_IDR_TBC_POS)

#define UART_IDR_RFUERR_POS 13U
#define UART_IDR_RFUERR_MSK BIT(UART_IDR_RFUERR_POS)

#define UART_IDR_RFOERR_POS 12U
#define UART_IDR_RFOERR_MSK BIT(UART_IDR_RFOERR_POS)

#define UART_IDR_RFFULL_POS 11U
#define UART_IDR_RFFULL_MSK BIT(UART_IDR_RFFULL_POS)

#define UART_IDR_RFNEMPTY_POS 10U
#define UART_IDR_RFNEMPTY_MSK BIT(UART_IDR_RFNEMPTY_POS)

#define UART_IDR_RFTH_POS   9U
#define UART_IDR_RFTH_MSK   BIT(UART_IDR_RFTH_POS)

#define UART_IDR_NOISE_POS  8U
#define UART_IDR_NOISE_MSK  BIT(UART_IDR_NOISE_POS)

#define UART_IDR_EOB_POS    7U
#define UART_IDR_EOB_MSK    BIT(UART_IDR_EOB_POS)

#define UART_IDR_LINBK_POS  6U
#define UART_IDR_LINBK_MSK  BIT(UART_IDR_LINBK_POS)

#define UART_IDR_ADDRM_POS  5U
#define UART_IDR_ADDRM_MSK  BIT(UART_IDR_ADDRM_POS)

#define UART_IDR_RXTO_POS   4U
#define UART_IDR_RXTO_MSK   BIT(UART_IDR_RXTO_POS)

#define UART_IDR_DCTS_POS   3U
#define UART_IDR_DCTS_MSK   BIT(UART_IDR_DCTS_POS)

#define UART_IDR_ABTO_POS   2U
#define UART_IDR_ABTO_MSK   BIT(UART_IDR_ABTO_POS)

#define UART_IDR_ABEND_POS  1U
#define UART_IDR_ABEND_MSK  BIT(UART_IDR_ABEND_POS)

#define UART_IDR_RXBERR_POS 0U
#define UART_IDR_RXBERR_MSK BIT(UART_IDR_RXBERR_POS)

/****************** Bit definition for UART_IVS register ************************/

#define UART_IVS_TFOVER_POS 18U
#define UART_IVS_TFOVER_MSK BIT(UART_IVS_TFOVER_POS)

#define UART_IVS_TFEMPTY_POS    16U
#define UART_IVS_TFEMPTY_MSK    BIT(UART_IVS_TFEMPTY_POS)

#define UART_IVS_TFTH_POS   15U
#define UART_IVS_TFTH_MSK   BIT(UART_IVS_TFTH_POS)

#define UART_IVS_TBC_POS    14U
#define UART_IVS_TBC_MSK    BIT(UART_IVS_TBC_POS)

#define UART_IVS_RFUERR_POS 13U
#define UART_IVS_RFUERR_MSK BIT(UART_IVS_RFUERR_POS)

#define UART_IVS_RFOERR_POS 12U
#define UART_IVS_RFOERR_MSK BIT(UART_IVS_RFOERR_POS)

#define UART_IVS_RFFULL_POS 11U
#define UART_IVS_RFFULL_MSK BIT(UART_IVS_RFFULL_POS)

#define UART_IVS_RFNEMPTY_POS   10U
#define UART_IVS_RFNEMPTY_MSK   BIT(UART_IVS_RFNEMPTY_POS)

#define UART_IVS_RFTH_POS   9U
#define UART_IVS_RFTH_MSK   BIT(UART_IVS_RFTH_POS)

#define UART_IVS_NOISE_POS  8U
#define UART_IVS_NOISE_MSK  BIT(UART_IVS_NOISE_POS)

#define UART_IVS_EOB_POS    7U
#define UART_IVS_EOB_MSK    BIT(UART_IVS_EOB_POS)

#define UART_IVS_LINBK_POS  6U
#define UART_IVS_LINBK_MSK  BIT(UART_IVS_LINBK_POS)

#define UART_IVS_ADDRM_POS  5U
#define UART_IVS_ADDRM_MSK  BIT(UART_IVS_ADDRM_POS)

#define UART_IVS_RXTO_POS   4U
#define UART_IVS_RXTO_MSK   BIT(UART_IVS_RXTO_POS)

#define UART_IVS_DCTS_POS   3U
#define UART_IVS_DCTS_MSK   BIT(UART_IVS_DCTS_POS)

#define UART_IVS_ABTO_POS   2U
#define UART_IVS_ABTO_MSK   BIT(UART_IVS_ABTO_POS)

#define UART_IVS_ABEND_POS  1U
#define UART_IVS_ABEND_MSK  BIT(UART_IVS_ABEND_POS)

#define UART_IVS_RXBERR_POS 0U
#define UART_IVS_RXBERR_MSK BIT(UART_IVS_RXBERR_POS)

/****************** Bit definition for UART_RIF register ************************/

#define UART_RIF_TFOVER_POS 18U
#define UART_RIF_TFOVER_MSK BIT(UART_RIF_TFOVER_POS)

#define UART_RIF_TFEMPTY_POS    16U
#define UART_RIF_TFEMPTY_MSK    BIT(UART_RIF_TFEMPTY_POS)

#define UART_RIF_TFTH_POS   15U
#define UART_RIF_TFTH_MSK   BIT(UART_RIF_TFTH_POS)

#define UART_RIF_TBC_POS    14U
#define UART_RIF_TBC_MSK    BIT(UART_RIF_TBC_POS)

#define UART_RIF_RFUERR_POS 13U
#define UART_RIF_RFUERR_MSK BIT(UART_RIF_RFUERR_POS)

#define UART_RIF_RFOERR_POS 12U
#define UART_RIF_RFOERR_MSK BIT(UART_RIF_RFOERR_POS)

#define UART_RIF_RFFULL_POS 11U
#define UART_RIF_RFFULL_MSK BIT(UART_RIF_RFFULL_POS)

#define UART_RIF_RFNEMPTY_POS  10U
#define UART_RIF_RFNEMPTY_MSK  BIT(UART_RIF_RFNEMPTY_POS)

#define UART_RIF_RFTH_POS   9U
#define UART_RIF_RFTH_MSK   BIT(UART_RIF_RFTH_POS)

#define UART_RIF_NOISE_POS  8U
#define UART_RIF_NOISE_MSK  BIT(UART_RIF_NOISE_POS)

#define UART_RIF_EOB_POS    7U
#define UART_RIF_EOB_MSK    BIT(UART_RIF_EOB_POS)

#define UART_RIF_LINBK_POS  6U
#define UART_RIF_LINBK_MSK  BIT(UART_RIF_LINBK_POS)

#define UART_RIF_ADDRM_POS  5U
#define UART_RIF_ADDRM_MSK  BIT(UART_RIF_ADDRM_POS)

#define UART_RIF_RXTO_POS   4U
#define UART_RIF_RXTO_MSK   BIT(UART_RIF_RXTO_POS)

#define UART_RIF_DCTS_POS   3U
#define UART_RIF_DCTS_MSK   BIT(UART_RIF_DCTS_POS)

#define UART_RIF_ABTO_POS   2U
#define UART_RIF_ABTO_MSK   BIT(UART_RIF_ABTO_POS)

#define UART_RIF_ABEND_POS  1U
#define UART_RIF_ABEND_MSK  BIT(UART_RIF_ABEND_POS)

#define UART_RIF_RXBERR_POS 0U
#define UART_RIF_RXBERR_MSK BIT(UART_RIF_RXBERR_POS)

/****************** Bit definition for UART_IFM register ************************/

#define UART_IFM_TFOVER_POS 18U
#define UART_IFM_TFOVER_MSK BIT(UART_IFM_TFOVER_POS)

#define UART_IFM_TFEMPTY_POS    16U
#define UART_IFM_TFEMPTY_MSK    BIT(UART_IFM_TFEMPTY_POS)

#define UART_IFM_TFTH_POS   15U
#define UART_IFM_TFTH_MSK   BIT(UART_IFM_TFTH_POS)

#define UART_IFM_TBC_POS    14U
#define UART_IFM_TBC_MSK    BIT(UART_IFM_TBC_POS)

#define UART_IFM_RFUERR_POS 13U
#define UART_IFM_RFUERR_MSK BIT(UART_IFM_RFUERR_POS)

#define UART_IFM_RFOERR_POS 12U
#define UART_IFM_RFOERR_MSK BIT(UART_IFM_RFOERR_POS)

#define UART_IFM_RFFULL_POS 11U
#define UART_IFM_RFFULL_MSK BIT(UART_IFM_RFFULL_POS)

#define UART_IFM_RFNEMPTY_POS   10U
#define UART_IFM_RFNEMPTY_MSK   BIT(UART_IFM_RFNEMPTY_POS)

#define UART_IFM_RFTH_POS   9U
#define UART_IFM_RFTH_MSK   BIT(UART_IFM_RFTH_POS)

#define UART_IFM_NOISE_POS  8U
#define UART_IFM_NOISE_MSK  BIT(UART_IFM_NOISE_POS)

#define UART_IFM_EOB_POS    7U
#define UART_IFM_EOB_MSK    BIT(UART_IFM_EOB_POS)

#define UART_IFM_LINBK_POS  6U
#define UART_IFM_LINBK_MSK  BIT(UART_IFM_LINBK_POS)

#define UART_IFM_ADDRM_POS  5U
#define UART_IFM_ADDRM_MSK  BIT(UART_IFM_ADDRM_POS)

#define UART_IFM_RXTO_POS   4U
#define UART_IFM_RXTO_MSK   BIT(UART_IFM_RXTO_POS)

#define UART_IFM_DCTS_POS   3U
#define UART_IFM_DCTS_MSK   BIT(UART_IFM_DCTS_POS)

#define UART_IFM_ABTO_POS   2U
#define UART_IFM_ABTO_MSK   BIT(UART_IFM_ABTO_POS)

#define UART_IFM_ABEND_POS  1U
#define UART_IFM_ABEND_MSK  BIT(UART_IFM_ABEND_POS)

#define UART_IFM_RXBERR_POS 0U
#define UART_IFM_RXBERR_MSK BIT(UART_IFM_RXBERR_POS)

/****************** Bit definition for UART_ICR register ************************/

#define UART_ICR_TFOVER_POS 18U
#define UART_ICR_TFOVER_MSK BIT(UART_ICR_TFOVER_POS)

#define UART_ICR_TFEMPTY_POS    16U
#define UART_ICR_TFEMPTY_MSK    BIT(UART_ICR_TFEMPTY_POS)

#define UART_ICR_TFTH_POS   15U
#define UART_ICR_TFTH_MSK   BIT(UART_ICR_TFTH_POS)

#define UART_ICR_TBC_POS    14U
#define UART_ICR_TBC_MSK    BIT(UART_ICR_TBC_POS)

#define UART_ICR_RFUERR_POS 13U
#define UART_ICR_RFUERR_MSK BIT(UART_ICR_RFUERR_POS)

#define UART_ICR_RFOERR_POS 12U
#define UART_ICR_RFOERR_MSK BIT(UART_ICR_RFOERR_POS)

#define UART_ICR_RFFULL_POS 11U
#define UART_ICR_RFFULL_MSK BIT(UART_ICR_RFFULL_POS)

#define UART_ICR_RFNEMPTY_POS 10U
#define UART_ICR_RFNEMPTY_MSK BIT(UART_ICR_RFNEMPTY_POS)

#define UART_ICR_RFTH_POS   9U
#define UART_ICR_RFTH_MSK   BIT(UART_ICR_RFTH_POS)

#define UART_ICR_NOISE_POS  8U
#define UART_ICR_NOISE_MSK  BIT(UART_ICR_NOISE_POS)

#define UART_ICR_EOB_POS    7U
#define UART_ICR_EOB_MSK    BIT(UART_ICR_EOB_POS)

#define UART_ICR_LINBK_POS  6U
#define UART_ICR_LINBK_MSK  BIT(UART_ICR_LINBK_POS)

#define UART_ICR_ADDRM_POS  5U
#define UART_ICR_ADDRM_MSK  BIT(UART_ICR_ADDRM_POS)

#define UART_ICR_RXTO_POS   4U
#define UART_ICR_RXTO_MSK   BIT(UART_ICR_RXTO_POS)

#define UART_ICR_DCTS_POS   3U
#define UART_ICR_DCTS_MSK   BIT(UART_ICR_DCTS_POS)

#define UART_ICR_ABTO_POS   2U
#define UART_ICR_ABTO_MSK   BIT(UART_ICR_ABTO_POS)

#define UART_ICR_ABEND_POS  1U
#define UART_ICR_ABEND_MSK  BIT(UART_ICR_ABEND_POS)

#define UART_ICR_RXBERR_POS 0U
#define UART_ICR_RXBERR_MSK BIT(UART_ICR_RXBERR_POS)

typedef struct
{
    __I uint32_t RXBUF;
    __IO uint32_t TXBUF;
    __IO uint32_t BRR;
    __IO uint32_t LCON;
    __IO uint32_t MCON;
    __IO uint32_t RS485;
    __IO uint32_t SCARD;
    __IO uint32_t LIN;
    __IO uint32_t RTOR;
    __O uint32_t FCON;
    __I uint32_t STAT;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
} UART_TypeDef;

/****************** Bit definition for SPI_CON1 register ************************/

#define SPI_CON1_BIDEN_POS  15U
#define SPI_CON1_BIDEN_MSK  BIT(SPI_CON1_BIDEN_POS)

#define SPI_CON1_BIDOEN_POS 14U
#define SPI_CON1_BIDOEN_MSK BIT(SPI_CON1_BIDOEN_POS)

#define SPI_CON1_CRCEN_POS  13U
#define SPI_CON1_CRCEN_MSK  BIT(SPI_CON1_CRCEN_POS)

#define SPI_CON1_NXTCRC_POS 12U
#define SPI_CON1_NXTCRC_MSK BIT(SPI_CON1_NXTCRC_POS)

#define SPI_CON1_FLEN_POS   11U
#define SPI_CON1_FLEN_MSK   BIT(SPI_CON1_FLEN_POS)

#define SPI_CON1_RXO_POS    10U
#define SPI_CON1_RXO_MSK    BIT(SPI_CON1_RXO_POS)

#define SPI_CON1_SSEN_POS   9U
#define SPI_CON1_SSEN_MSK   BIT(SPI_CON1_SSEN_POS)

#define SPI_CON1_SSOUT_POS  8U
#define SPI_CON1_SSOUT_MSK  BIT(SPI_CON1_SSOUT_POS)

#define SPI_CON1_LSBFST_POS 7U
#define SPI_CON1_LSBFST_MSK BIT(SPI_CON1_LSBFST_POS)

#define SPI_CON1_SPIEN_POS  6U
#define SPI_CON1_SPIEN_MSK  BIT(SPI_CON1_SPIEN_POS)

#define SPI_CON1_BAUD_POSS  3U
#define SPI_CON1_BAUD_POSE  5U
#define SPI_CON1_BAUD_MSK   BITS(SPI_CON1_BAUD_POSS,SPI_CON1_BAUD_POSE)

#define SPI_CON1_MSTREN_POS 2U
#define SPI_CON1_MSTREN_MSK BIT(SPI_CON1_MSTREN_POS)

#define SPI_CON1_CPOL_POS   1U
#define SPI_CON1_CPOL_MSK   BIT(SPI_CON1_CPOL_POS)

#define SPI_CON1_CPHA_POS   0U
#define SPI_CON1_CPHA_MSK   BIT(SPI_CON1_CPHA_POS)

/****************** Bit definition for SPI_CON2 register ************************/

#define SPI_CON2_RXFTH_POSS 14U
#define SPI_CON2_RXFTH_POSE 15U
#define SPI_CON2_RXFTH_MSK  BITS(SPI_CON2_RXFTH_POSS,SPI_CON2_RXFTH_POSE)

#define SPI_CON2_TXFTH_POSS 12U
#define SPI_CON2_TXFTH_POSE 13U
#define SPI_CON2_TXFTH_MSK  BITS(SPI_CON2_TXFTH_POSS,SPI_CON2_TXFTH_POSE)

#define SPI_CON2_FRF_POS    4U
#define SPI_CON2_FRF_MSK    BIT(SPI_CON2_FRF_POS)

#define SPI_CON2_NSSP_POS   3U
#define SPI_CON2_NSSP_MSK   BIT(SPI_CON2_NSSP_POS)

#define SPI_CON2_NSSOE_POS  2U
#define SPI_CON2_NSSOE_MSK  BIT(SPI_CON2_NSSOE_POS)

#define SPI_CON2_TXDMA_POS  1U
#define SPI_CON2_TXDMA_MSK  BIT(SPI_CON2_TXDMA_POS)

#define SPI_CON2_RXDMA_POS  0U
#define SPI_CON2_RXDMA_MSK  BIT(SPI_CON2_RXDMA_POS)

/****************** Bit definition for SPI_STAT register ************************/

#define SPI_STAT_RXFLV_POSS 24U
#define SPI_STAT_RXFLV_POSE 28U
#define SPI_STAT_RXFLV_MSK  BITS(SPI_STAT_RXFLV_POSS,SPI_STAT_RXFLV_POSE)

#define SPI_STAT_TXFLV_POSS 16U
#define SPI_STAT_TXFLV_POSE 20U
#define SPI_STAT_TXFLV_MSK  BITS(SPI_STAT_TXFLV_POSS,SPI_STAT_TXFLV_POSE)

#define SPI_STAT_BUSY_POS   15U
#define SPI_STAT_BUSY_MSK   BIT(SPI_STAT_BUSY_POS)

#define SPI_STAT_CHSIDE_POS 14U
#define SPI_STAT_CHSIDE_MSK BIT(SPI_STAT_CHSIDE_POS)

#define SPI_STAT_RXTH_POS   12U
#define SPI_STAT_RXTH_MSK   BIT(SPI_STAT_RXTH_POS)

#define SPI_STAT_RXUD_POS   11U
#define SPI_STAT_RXUD_MSK   BIT(SPI_STAT_RXUD_POS)

#define SPI_STAT_RXOV_POS   10U
#define SPI_STAT_RXOV_MSK   BIT(SPI_STAT_RXOV_POS)

#define SPI_STAT_RXF_POS    9U
#define SPI_STAT_RXF_MSK    BIT(SPI_STAT_RXF_POS)

#define SPI_STAT_RXNE_POS   8U
#define SPI_STAT_RXNE_MSK   BIT(SPI_STAT_RXNE_POS)

#define SPI_STAT_TXTH_POS   4U
#define SPI_STAT_TXTH_MSK   BIT(SPI_STAT_TXTH_POS)

#define SPI_STAT_TXUD_POS   3U
#define SPI_STAT_TXUD_MSK   BIT(SPI_STAT_TXUD_POS)

#define SPI_STAT_TXOV_POS   2U
#define SPI_STAT_TXOV_MSK   BIT(SPI_STAT_TXOV_POS)

#define SPI_STAT_TXF_POS    1U
#define SPI_STAT_TXF_MSK    BIT(SPI_STAT_TXF_POS)

#define SPI_STAT_TXE_POS    0U
#define SPI_STAT_TXE_MSK    BIT(SPI_STAT_TXE_POS)

/****************** Bit definition for SPI_DATA register ************************/

#define SPI_DATA_DATA_POSS  0U
#define SPI_DATA_DATA_POSE  15U
#define SPI_DATA_DATA_MSK   BITS(SPI_DATA_DATA_POSS,SPI_DATA_DATA_POSE)

/****************** Bit definition for SPI_CRCPOLY register ************************/

#define SPI_CRCPOLY_CRCPOLY_POSS    0U
#define SPI_CRCPOLY_CRCPOLY_POSE    15U
#define SPI_CRCPOLY_CRCPOLY_MSK BITS(SPI_CRCPOLY_CRCPOLY_POSS,SPI_CRCPOLY_CRCPOLY_POSE)

/****************** Bit definition for SPI_RXCRC register ************************/

#define SPI_RXCRC_RXCRC_POSS    0U
#define SPI_RXCRC_RXCRC_POSE    15U
#define SPI_RXCRC_RXCRC_MSK BITS(SPI_RXCRC_RXCRC_POSS,SPI_RXCRC_RXCRC_POSE)

/****************** Bit definition for SPI_TXCRC register ************************/

#define SPI_TXCRC_TXCRC_POSS    0U
#define SPI_TXCRC_TXCRC_POSE    15U
#define SPI_TXCRC_TXCRC_MSK BITS(SPI_TXCRC_TXCRC_POSS,SPI_TXCRC_TXCRC_POSE)

/****************** Bit definition for SPI_I2SCFG register ************************/

#define SPI_I2SCFG_I2SMOD_POS   12U
#define SPI_I2SCFG_I2SMOD_MSK   BIT(SPI_I2SCFG_I2SMOD_POS)

#define SPI_I2SCFG_I2SE_POS 11U
#define SPI_I2SCFG_I2SE_MSK BIT(SPI_I2SCFG_I2SE_POS)

#define SPI_I2SCFG_I2SCFG_POSS  8U
#define SPI_I2SCFG_I2SCFG_POSE  10U
#define SPI_I2SCFG_I2SCFG_MSK   BITS(SPI_I2SCFG_I2SCFG_POSS,SPI_I2SCFG_I2SCFG_POSE)

#define SPI_I2SCFG_PCMSYNC_POS  7U
#define SPI_I2SCFG_PCMSYNC_MSK  BIT(SPI_I2SCFG_PCMSYNC_POS)

#define SPI_I2SCFG_I2SSTD_POSS  4U
#define SPI_I2SCFG_I2SSTD_POSE  5U
#define SPI_I2SCFG_I2SSTD_MSK   BITS(SPI_I2SCFG_I2SSTD_POSS,SPI_I2SCFG_I2SSTD_POSE)

#define SPI_I2SCFG_CKPOL_POS    3U
#define SPI_I2SCFG_CKPOL_MSK    BIT(SPI_I2SCFG_CKPOL_POS)

#define SPI_I2SCFG_DATLEN_POSS  1U
#define SPI_I2SCFG_DATLEN_POSE  2U
#define SPI_I2SCFG_DATLEN_MSK   BITS(SPI_I2SCFG_DATLEN_POSS,SPI_I2SCFG_DATLEN_POSE)

#define SPI_I2SCFG_CHLEN_POS    0U
#define SPI_I2SCFG_CHLEN_MSK    BIT(SPI_I2SCFG_CHLEN_POS)

/****************** Bit definition for SPI_I2SPR register ************************/

#define SPI_I2SPR_EXTCKEN_POS   10U
#define SPI_I2SPR_EXTCKEN_MSK   BIT(SPI_I2SPR_EXTCKEN_POS)

#define SPI_I2SPR_MCKOE_POS 9U
#define SPI_I2SPR_MCKOE_MSK BIT(SPI_I2SPR_MCKOE_POS)

#define SPI_I2SPR_ODD_POS   8U
#define SPI_I2SPR_ODD_MSK   BIT(SPI_I2SPR_ODD_POS)

#define SPI_I2SPR_I2SDIV_POSS   0U
#define SPI_I2SPR_I2SDIV_POSE   7U
#define SPI_I2SPR_I2SDIV_MSK    BITS(SPI_I2SPR_I2SDIV_POSS,SPI_I2SPR_I2SDIV_POSE)

/****************** Bit definition for SPI_IER register ************************/

#define SPI_IER_FRE_POS 18U
#define SPI_IER_FRE_MSK BIT(SPI_IER_FRE_POS)

#define SPI_IER_MODF_POS    17U
#define SPI_IER_MODF_MSK    BIT(SPI_IER_MODF_POS)

#define SPI_IER_CRCERR_POS  16U
#define SPI_IER_CRCERR_MSK  BIT(SPI_IER_CRCERR_POS)

#define SPI_IER_RXTH_POS    12U
#define SPI_IER_RXTH_MSK    BIT(SPI_IER_RXTH_POS)

#define SPI_IER_RXUD_POS    11U
#define SPI_IER_RXUD_MSK    BIT(SPI_IER_RXUD_POS)

#define SPI_IER_RXOV_POS    10U
#define SPI_IER_RXOV_MSK    BIT(SPI_IER_RXOV_POS)

#define SPI_IER_RXF_POS 9U
#define SPI_IER_RXF_MSK BIT(SPI_IER_RXF_POS)

#define SPI_IER_RXNE_POS    8U
#define SPI_IER_RXNE_MSK    BIT(SPI_IER_RXNE_POS)

#define SPI_IER_TXTH_POS    4U
#define SPI_IER_TXTH_MSK    BIT(SPI_IER_TXTH_POS)

#define SPI_IER_TXUD_POS    3U
#define SPI_IER_TXUD_MSK    BIT(SPI_IER_TXUD_POS)

#define SPI_IER_TXOV_POS    2U
#define SPI_IER_TXOV_MSK    BIT(SPI_IER_TXOV_POS)

#define SPI_IER_TXE_POS 0U
#define SPI_IER_TXE_MSK BIT(SPI_IER_TXE_POS)

/****************** Bit definition for SPI_IDR register ************************/

#define SPI_IDR_FRE_POS 18U
#define SPI_IDR_FRE_MSK BIT(SPI_IDR_FRE_POS)

#define SPI_IDR_MODF_POS    17U
#define SPI_IDR_MODF_MSK    BIT(SPI_IDR_MODF_POS)

#define SPI_IDR_CRCERR_POS  16U
#define SPI_IDR_CRCERR_MSK  BIT(SPI_IDR_CRCERR_POS)

#define SPI_IDR_RXTH_POS    12U
#define SPI_IDR_RXTH_MSK    BIT(SPI_IDR_RXTH_POS)

#define SPI_IDR_RXUD_POS    11U
#define SPI_IDR_RXUD_MSK    BIT(SPI_IDR_RXUD_POS)

#define SPI_IDR_RXOV_POS    10U
#define SPI_IDR_RXOV_MSK    BIT(SPI_IDR_RXOV_POS)

#define SPI_IDR_RXF_POS 9U
#define SPI_IDR_RXF_MSK BIT(SPI_IDR_RXF_POS)

#define SPI_IDR_RXNE_POS    8U
#define SPI_IDR_RXNE_MSK    BIT(SPI_IDR_RXNE_POS)

#define SPI_IDR_TXTH_POS    4U
#define SPI_IDR_TXTH_MSK    BIT(SPI_IDR_TXTH_POS)

#define SPI_IDR_TXUD_POS    3U
#define SPI_IDR_TXUD_MSK    BIT(SPI_IDR_TXUD_POS)

#define SPI_IDR_TXOV_POS    2U
#define SPI_IDR_TXOV_MSK    BIT(SPI_IDR_TXOV_POS)

#define SPI_IDR_TXE_POS 0U
#define SPI_IDR_TXE_MSK BIT(SPI_IDR_TXE_POS)

/****************** Bit definition for SPI_IVS register ************************/

#define SPI_IVS_FRE_POS 18U
#define SPI_IVS_FRE_MSK BIT(SPI_IVS_FRE_POS)

#define SPI_IVS_MODF_POS    17U
#define SPI_IVS_MODF_MSK    BIT(SPI_IVS_MODF_POS)

#define SPI_IVS_CRCERR_POS  16U
#define SPI_IVS_CRCERR_MSK  BIT(SPI_IVS_CRCERR_POS)

#define SPI_IVS_RXTH_POS    12U
#define SPI_IVS_RXTH_MSK    BIT(SPI_IVS_RXTH_POS)

#define SPI_IVS_RXUD_POS    11U
#define SPI_IVS_RXUD_MSK    BIT(SPI_IVS_RXUD_POS)

#define SPI_IVS_RXOV_POS    10U
#define SPI_IVS_RXOV_MSK    BIT(SPI_IVS_RXOV_POS)

#define SPI_IVS_RXF_POS 9U
#define SPI_IVS_RXF_MSK BIT(SPI_IVS_RXF_POS)

#define SPI_IVS_RXNE_POS    8U
#define SPI_IVS_RXNE_MSK    BIT(SPI_IVS_RXNE_POS)

#define SPI_IVS_TXTH_POS    4U
#define SPI_IVS_TXTH_MSK    BIT(SPI_IVS_TXTH_POS)

#define SPI_IVS_TXUD_POS    3U
#define SPI_IVS_TXUD_MSK    BIT(SPI_IVS_TXUD_POS)

#define SPI_IVS_TXOV_POS    2U
#define SPI_IVS_TXOV_MSK    BIT(SPI_IVS_TXOV_POS)

#define SPI_IVS_TXE_POS 0U
#define SPI_IVS_TXE_MSK BIT(SPI_IVS_TXE_POS)

/****************** Bit definition for SPI_RIF register ************************/

#define SPI_RIF_FRE_POS 18U
#define SPI_RIF_FRE_MSK BIT(SPI_RIF_FRE_POS)

#define SPI_RIF_MODF_POS    17U
#define SPI_RIF_MODF_MSK    BIT(SPI_RIF_MODF_POS)

#define SPI_RIF_CRCERR_POS  16U
#define SPI_RIF_CRCERR_MSK  BIT(SPI_RIF_CRCERR_POS)

#define SPI_RIF_RXTH_POS    12U
#define SPI_RIF_RXTH_MSK    BIT(SPI_RIF_RXTH_POS)

#define SPI_RIF_RXUD_POS    11U
#define SPI_RIF_RXUD_MSK    BIT(SPI_RIF_RXUD_POS)

#define SPI_RIF_RXOV_POS    10U
#define SPI_RIF_RXOV_MSK    BIT(SPI_RIF_RXOV_POS)

#define SPI_RIF_RXF_POS 9U
#define SPI_RIF_RXF_MSK BIT(SPI_RIF_RXF_POS)

#define SPI_RIF_RXNE_POS    8U
#define SPI_RIF_RXNE_MSK    BIT(SPI_RIF_RXNE_POS)

#define SPI_RIF_TXTH_POS    4U
#define SPI_RIF_TXTH_MSK    BIT(SPI_RIF_TXTH_POS)

#define SPI_RIF_TXUD_POS    3U
#define SPI_RIF_TXUD_MSK    BIT(SPI_RIF_TXUD_POS)

#define SPI_RIF_TXOV_POS    2U
#define SPI_RIF_TXOV_MSK    BIT(SPI_RIF_TXOV_POS)

#define SPI_RIF_TXE_POS 0U
#define SPI_RIF_TXE_MSK BIT(SPI_RIF_TXE_POS)

/****************** Bit definition for SPI_IFM register ************************/

#define SPI_IFM_FRE_POS 18U
#define SPI_IFM_FRE_MSK BIT(SPI_IFM_FRE_POS)

#define SPI_IFM_MODF_POS    17U
#define SPI_IFM_MODF_MSK    BIT(SPI_IFM_MODF_POS)

#define SPI_IFM_CRCERR_POS  16U
#define SPI_IFM_CRCERR_MSK  BIT(SPI_IFM_CRCERR_POS)

#define SPI_IFM_RXTH_POS    12U
#define SPI_IFM_RXTH_MSK    BIT(SPI_IFM_RXTH_POS)

#define SPI_IFM_RXUD_POS    11U
#define SPI_IFM_RXUD_MSK    BIT(SPI_IFM_RXUD_POS)

#define SPI_IFM_RXOV_POS    10U
#define SPI_IFM_RXOV_MSK    BIT(SPI_IFM_RXOV_POS)

#define SPI_IFM_RXF_POS 9U
#define SPI_IFM_RXF_MSK BIT(SPI_IFM_RXF_POS)

#define SPI_IFM_RXNE_POS    8U
#define SPI_IFM_RXNE_MSK    BIT(SPI_IFM_RXNE_POS)

#define SPI_IFM_TXTH_POS    4U
#define SPI_IFM_TXTH_MSK    BIT(SPI_IFM_TXTH_POS)

#define SPI_IFM_TXUD_POS    3U
#define SPI_IFM_TXUD_MSK    BIT(SPI_IFM_TXUD_POS)

#define SPI_IFM_TXOV_POS    2U
#define SPI_IFM_TXOV_MSK    BIT(SPI_IFM_TXOV_POS)

#define SPI_IFM_TXE_POS 0U
#define SPI_IFM_TXE_MSK BIT(SPI_IFM_TXE_POS)

/****************** Bit definition for SPI_ICR register ************************/

#define SPI_ICR_FRE_POS 18U
#define SPI_ICR_FRE_MSK BIT(SPI_ICR_FRE_POS)

#define SPI_ICR_MODF_POS    17U
#define SPI_ICR_MODF_MSK    BIT(SPI_ICR_MODF_POS)

#define SPI_ICR_CRCERR_POS  16U
#define SPI_ICR_CRCERR_MSK  BIT(SPI_ICR_CRCERR_POS)

#define SPI_ICR_RXTH_POS    12U
#define SPI_ICR_RXTH_MSK    BIT(SPI_ICR_RXTH_POS)

#define SPI_ICR_RXUD_POS    11U
#define SPI_ICR_RXUD_MSK    BIT(SPI_ICR_RXUD_POS)

#define SPI_ICR_RXOV_POS    10U
#define SPI_ICR_RXOV_MSK    BIT(SPI_ICR_RXOV_POS)

#define SPI_ICR_RXF_POS 9U
#define SPI_ICR_RXF_MSK BIT(SPI_ICR_RXF_POS)

#define SPI_ICR_RXNE_POS    8U
#define SPI_ICR_RXNE_MSK    BIT(SPI_ICR_RXNE_POS)

#define SPI_ICR_TXTH_POS    4U
#define SPI_ICR_TXTH_MSK    BIT(SPI_ICR_TXTH_POS)

#define SPI_ICR_TXUD_POS    3U
#define SPI_ICR_TXUD_MSK    BIT(SPI_ICR_TXUD_POS)

#define SPI_ICR_TXOV_POS    2U
#define SPI_ICR_TXOV_MSK    BIT(SPI_ICR_TXOV_POS)

#define SPI_ICR_TXE_POS 0U
#define SPI_ICR_TXE_MSK BIT(SPI_ICR_TXE_POS)

/****************** Bit definition for SPI_QCR register ************************/
#define SPI_QCR_QIODR_POS   2U
#define SPI_QCR_QIODR_MSK   BIT(SPI_QCR_QIODR_POS)

#define SPI_QCR_QDIR_POS    1U
#define SPI_QCR_QDIR_MSK    BIT(SPI_QCR_QDIR_POS)

#define SPI_QCR_QEN_POS     0U
#define SPI_QCR_QEN_MSK     BIT(SPI_QCR_QEN_POS)

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CON1;
    __IO uint32_t CON2;
    __I uint32_t STAT;
    __IO uint32_t DATA;
    __IO uint32_t CRCPOLY;
    __I uint32_t RXCRC;
    __I uint32_t TXCRC;
    __IO uint32_t I2SCFG;
    __IO uint32_t I2SPR;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __IO uint32_t QCR;
} SPI_I2S_TypeDef;

/****************** Bit definition for I2C_CON1 register ************************/

# define  I2C_CON1_NBYTESH_POSS 24U
# define  I2C_CON1_NBYTESH_POSE 31U
# define  I2C_CON1_NBYTESH_MSK  BITS(I2C_CON1_NBYTESH_POSS, I2C_CON1_NBYTESH_POSE)

# define  I2C_CON1_PECEN_POS 23U
# define  I2C_CON1_PECEN_MSK BIT(I2C_CON1_PECEN_POS)

# define  I2C_CON1_ALERTEN_POS 22U
# define  I2C_CON1_ALERTEN_MSK BIT(I2C_CON1_ALERTEN_POS)

# define  I2C_CON1_SMBDEN_POS 21U
# define  I2C_CON1_SMBDEN_MSK BIT(I2C_CON1_SMBDEN_POS)

# define  I2C_CON1_SMBHEN_POS 20U
# define  I2C_CON1_SMBHEN_MSK BIT(I2C_CON1_SMBHEN_POS)

# define  I2C_CON1_GCEN_POS 19U
# define  I2C_CON1_GCEN_MSK BIT(I2C_CON1_GCEN_POS)

# define  I2C_CON1_NOSTRETCH_POS 17U
# define  I2C_CON1_NOSTRETCH_MSK BIT(I2C_CON1_NOSTRETCH_POS)

# define  I2C_CON1_SBC_POS 16U
# define  I2C_CON1_SBC_MSK BIT(I2C_CON1_SBC_POS)

# define  I2C_CON1_RXDMAEN_POS 15U
# define  I2C_CON1_RXDMAEN_MSK BIT(I2C_CON1_RXDMAEN_POS)

# define  I2C_CON1_TXDMAEN_POS 14U
# define  I2C_CON1_TXDMAEN_MSK BIT(I2C_CON1_TXDMAEN_POS)

# define  I2C_CON1_DNF_POSS 8U
# define  I2C_CON1_DNF_POSE 11U
# define  I2C_CON1_DNF_MSK  BITS(I2C_CON1_DNF_POSS, I2C_CON1_DNF_POSE)

# define  I2C_CON1_PE_POS 0U
# define  I2C_CON1_PE_MSK BIT(I2C_CON1_PE_POS)

/****************** Bit definition for I2C_CON2 register ************************/

# define  I2C_CON2_PECBYTE_POS 26U
# define  I2C_CON2_PECBYTE_MSK BIT(I2C_CON2_PECBYTE_POS)

# define  I2C_CON2_AUTOEND_POS 25U
# define  I2C_CON2_AUTOEND_MSK BIT(I2C_CON2_AUTOEND_POS)

# define  I2C_CON2_RELOAD_POS 24U
# define  I2C_CON2_RELOAD_MSK BIT(I2C_CON2_RELOAD_POS)

# define  I2C_CON2_NBYTESL_POSS 16U
# define  I2C_CON2_NBYTESL_POSE 23U
# define  I2C_CON2_NBYTESL_MSK  BITS(I2C_CON2_NBYTESL_POSS, I2C_CON2_NBYTESL_POSE)

# define  I2C_CON2_NACK_POS 15U
# define  I2C_CON2_NACK_MSK BIT(I2C_CON2_NACK_POS)

# define  I2C_CON2_STOP_POS 14U
# define  I2C_CON2_STOP_MSK BIT(I2C_CON2_STOP_POS)

# define  I2C_CON2_START_POS 13U
# define  I2C_CON2_START_MSK BIT(I2C_CON2_START_POS)

# define  I2C_CON2_HEAD10R_POS 12U
# define  I2C_CON2_HEAD10R_MSK BIT(I2C_CON2_HEAD10R_POS)

# define  I2C_CON2_ADD10_POS 11U
# define  I2C_CON2_ADD10_MSK BIT(I2C_CON2_ADD10_POS)

# define  I2C_CON2_RD_WRN_POS 10U
# define  I2C_CON2_RD_WRN_MSK BIT(I2C_CON2_RD_WRN_POS)

# define  I2C_CON2_SADD_POSS 0U
# define  I2C_CON2_SADD_POSE 9U
# define  I2C_CON2_SADD_MSK  BITS(I2C_CON2_SADD_POSS, I2C_CON2_SADD_POSE)

/****************** Bit definition for I2C_ADDR1 register ************************/

# define  I2C_ADDR1_OA1EN_POS 15U
# define  I2C_ADDR1_OA1EN_MSK BIT(I2C_ADDR1_OA1EN_POS)

# define  I2C_ADDR1_OA1MODE_POS 10U
# define  I2C_ADDR1_OA1MODE_MSK BIT(I2C_ADDR1_OA1MODE_POS)

# define  I2C_ADDR1_OA1_POSS 0U
# define  I2C_ADDR1_OA1_POSE 9U
# define  I2C_ADDR1_OA1_MSK  BITS(I2C_ADDR1_OA1_POSS, I2C_ADDR1_OA1_POSE)

/****************** Bit definition for I2C_ADDR2 register ************************/

# define  I2C_ADDR2_OA2EN_POS 15U
# define  I2C_ADDR2_OA2EN_MSK BIT(I2C_ADDR2_OA2EN_POS)

# define  I2C_ADDR2_OA2MSK_POSS 8U
# define  I2C_ADDR2_OA2MSK_POSE 10U
# define  I2C_ADDR2_OA2MSK_MSK  BITS(I2C_ADDR2_OA2MSK_POSS, I2C_ADDR2_OA2MSK_POSE)

# define  I2C_ADDR2_OA2_POSS 1U
# define  I2C_ADDR2_OA2_POSE 7U
# define  I2C_ADDR2_OA2_MSK  BITS(I2C_ADDR2_OA2_POSS, I2C_ADDR2_OA2_POSE)

/****************** Bit definition for I2C_TIMINGR register ************************/

# define  I2C_TIMINGR_PRESC_POSS 28U
# define  I2C_TIMINGR_PRESC_POSE 31U
# define  I2C_TIMINGR_PRESC_MSK  BITS(I2C_TIMINGR_PRESC_POSS, I2C_TIMINGR_PRESC_POSE)

# define  I2C_TIMINGR_SCLDEL_POSS 20U
# define  I2C_TIMINGR_SCLDEL_POSE 23U
# define  I2C_TIMINGR_SCLDEL_MSK  BITS(I2C_TIMINGR_SCLDEL_POSS, I2C_TIMINGR_SCLDEL_POSE)

# define  I2C_TIMINGR_SDADEL_POSS 16U
# define  I2C_TIMINGR_SDADEL_POSE 19U
# define  I2C_TIMINGR_SDADEL_MSK  BITS(I2C_TIMINGR_SDADEL_POSS, I2C_TIMINGR_SDADEL_POSE)

# define  I2C_TIMINGR_SCLH_POSS 8U
# define  I2C_TIMINGR_SCLH_POSE 15U
# define  I2C_TIMINGR_SCLH_MSK  BITS(I2C_TIMINGR_SCLH_POSS, I2C_TIMINGR_SCLH_POSE)

# define  I2C_TIMINGR_SCLL_POSS 0U
# define  I2C_TIMINGR_SCLL_POSE 7U
# define  I2C_TIMINGR_SCLL_MSK  BITS(I2C_TIMINGR_SCLL_POSS, I2C_TIMINGR_SCLL_POSE)

/****************** Bit definition for I2C_TIMEOUTR register ************************/

# define  I2C_TIMEOUTR_TEXTEN_POS 31U
# define  I2C_TIMEOUTR_TEXTEN_MSK BIT(I2C_TIMEOUTR_TEXTEN_POS)

# define  I2C_TIMEOUTR_TIMEOUTB_POSS 16U
# define  I2C_TIMEOUTR_TIMEOUTB_POSE 27U
# define  I2C_TIMEOUTR_TIMEOUTB_MSK  BITS(I2C_TIMEOUTR_TIMEOUTB_POSS, I2C_TIMEOUTR_TIMEOUTB_POSE)

# define  I2C_TIMEOUTR_TIMEOUTEN_POS 15U
# define  I2C_TIMEOUTR_TIMEOUTEN_MSK BIT(I2C_TIMEOUTR_TIMEOUTEN_POS)

# define  I2C_TIMEOUTR_TIDLE_POS 12U
# define  I2C_TIMEOUTR_TIDLE_MSK BIT(I2C_TIMEOUTR_TIDLE_POS)

# define  I2C_TIMEOUTR_TIMEOUTA_POSS 0U
# define  I2C_TIMEOUTR_TIMEOUTA_POSE 11U
# define  I2C_TIMEOUTR_TIMEOUTA_MSK  BITS(I2C_TIMEOUTR_TIMEOUTA_POSS, I2C_TIMEOUTR_TIMEOUTA_POSE)

/****************** Bit definition for I2C_STAT register ************************/

# define  I2C_STAT_ADDCODE_POSS 17U
# define  I2C_STAT_ADDCODE_POSE 23U
# define  I2C_STAT_ADDCODE_MSK  BITS(I2C_STAT_ADDCODE_POSS, I2C_STAT_ADDCODE_POSE)

# define  I2C_STAT_DIR_POS 16U
# define  I2C_STAT_DIR_MSK BIT(I2C_STAT_DIR_POS)

# define  I2C_STAT_BUSY_POS 15U
# define  I2C_STAT_BUSY_MSK BIT(I2C_STAT_BUSY_POS)

# define  I2C_STAT_TCR_POS 11U
# define  I2C_STAT_TCR_MSK BIT(I2C_STAT_TCR_POS)

# define  I2C_STAT_TC_POS 10U
# define  I2C_STAT_TC_MSK BIT(I2C_STAT_TC_POS)

# define  I2C_STAT_RXUD_POS 8U
# define  I2C_STAT_RXUD_MSK BIT(I2C_STAT_RXUD_POS)

# define  I2C_STAT_RXOV_POS 7U
# define  I2C_STAT_RXOV_MSK BIT(I2C_STAT_RXOV_POS)

# define  I2C_STAT_RXNE_POS 5U
# define  I2C_STAT_RXNE_MSK BIT(I2C_STAT_RXNE_POS)

# define  I2C_STAT_TXUD_POS 3U
# define  I2C_STAT_TXUD_MSK BIT(I2C_STAT_TXUD_POS)

# define  I2C_STAT_TXOV_POS 2U
# define  I2C_STAT_TXOV_MSK BIT(I2C_STAT_TXOV_POS)

# define  I2C_STAT_TXE_POS 0U
# define  I2C_STAT_TXE_MSK BIT(I2C_STAT_TXE_POS)

/****************** Bit definition for I2C_PECR register ************************/

# define  I2C_PECR_PEC_POSS 0U
# define  I2C_PECR_PEC_POSE 7U
# define  I2C_PECR_PEC_MSK  BITS(I2C_PECR_PEC_POSS, I2C_PECR_PEC_POSE)

/****************** Bit definition for I2C_RXDATA register ************************/

# define  I2C_RXDATA_RXDATA_POSS 0U
# define  I2C_RXDATA_RXDATA_POSE 7U
# define  I2C_RXDATA_RXDATA_MSK  BITS(I2C_RXDATA_RXDATA_POSS, I2C_RXDATA_RXDATA_POSE)

/****************** Bit definition for I2C_TXDATA register ************************/

# define  I2C_TXDATA_TXDATA_POSS 0U
# define  I2C_TXDATA_TXDATA_POSE 7U
# define  I2C_TXDATA_TXDATA_MSK  BITS(I2C_TXDATA_TXDATA_POSS, I2C_TXDATA_TXDATA_POSE)

/****************** Bit definition for I2C_IER register ************************/

# define  I2C_IER_ALERT_POS 20U
# define  I2C_IER_ALERT_MSK BIT(I2C_IER_ALERT_POS)

# define  I2C_IER_TOUT_POS 19U
# define  I2C_IER_TOUT_MSK BIT(I2C_IER_TOUT_POS)

# define  I2C_IER_PECE_POS 18U
# define  I2C_IER_PECE_MSK BIT(I2C_IER_PECE_POS)

# define  I2C_IER_ARLO_POS 17U
# define  I2C_IER_ARLO_MSK BIT(I2C_IER_ARLO_POS)

# define  I2C_IER_BERR_POS 16U
# define  I2C_IER_BERR_MSK BIT(I2C_IER_BERR_POS)

# define  I2C_IER_STOP_POS 14U
# define  I2C_IER_STOP_MSK BIT(I2C_IER_STOP_POS)

# define  I2C_IER_NACK_POS 13U
# define  I2C_IER_NACK_MSK BIT(I2C_IER_NACK_POS)

# define  I2C_IER_ADDR_POS 12U
# define  I2C_IER_ADDR_MSK BIT(I2C_IER_ADDR_POS)

# define  I2C_IER_TCR_POS 11U
# define  I2C_IER_TCR_MSK BIT(I2C_IER_TCR_POS)

# define  I2C_IER_TC_POS 10U
# define  I2C_IER_TC_MSK BIT(I2C_IER_TC_POS)

# define  I2C_IER_RXUD_POS 8U
# define  I2C_IER_RXUD_MSK BIT(I2C_IER_RXUD_POS)

# define  I2C_IER_RXOV_POS 7U
# define  I2C_IER_RXOV_MSK BIT(I2C_IER_RXOV_POS)

# define  I2C_IER_RXNE_POS 5U
# define  I2C_IER_RXNE_MSK BIT(I2C_IER_RXNE_POS)

# define  I2C_IER_TXUD_POS 3U
# define  I2C_IER_TXUD_MSK BIT(I2C_IER_TXUD_POS)

# define  I2C_IER_TXOV_POS 2U
# define  I2C_IER_TXOV_MSK BIT(I2C_IER_TXOV_POS)

# define  I2C_IER_TXE_POS 0U
# define  I2C_IER_TXE_MSK BIT(I2C_IER_TXE_POS)

/****************** Bit definition for I2C_IDR register ************************/

# define  I2C_IDR_ALERT_POS 20U
# define  I2C_IDR_ALERT_MSK BIT(I2C_IDR_ALERT_POS)

# define  I2C_IDR_TOUT_POS 19U
# define  I2C_IDR_TOUT_MSK BIT(I2C_IDR_TOUT_POS)

# define  I2C_IDR_PECE_POS 18U
# define  I2C_IDR_PECE_MSK BIT(I2C_IDR_PECE_POS)

# define  I2C_IDR_ARLO_POS 17U
# define  I2C_IDR_ARLO_MSK BIT(I2C_IDR_ARLO_POS)

# define  I2C_IDR_BERR_POS 16U
# define  I2C_IDR_BERR_MSK BIT(I2C_IDR_BERR_POS)

# define  I2C_IDR_STOP_POS 14U
# define  I2C_IDR_STOP_MSK BIT(I2C_IDR_STOP_POS)

# define  I2C_IDR_NACK_POS 13U
# define  I2C_IDR_NACK_MSK BIT(I2C_IDR_NACK_POS)

# define  I2C_IDR_ADDR_POS 12U
# define  I2C_IDR_ADDR_MSK BIT(I2C_IDR_ADDR_POS)

# define  I2C_IDR_TCR_POS 11U
# define  I2C_IDR_TCR_MSK BIT(I2C_IDR_TCR_POS)

# define  I2C_IDR_TC_POS 10U
# define  I2C_IDR_TC_MSK BIT(I2C_IDR_TC_POS)

# define  I2C_IDR_RXUD_POS 8U
# define  I2C_IDR_RXUD_MSK BIT(I2C_IDR_RXUD_POS)

# define  I2C_IDR_RXOV_POS 7U
# define  I2C_IDR_RXOV_MSK BIT(I2C_IDR_RXOV_POS)

# define  I2C_IDR_RXNE_POS 5U
# define  I2C_IDR_RXNE_MSK BIT(I2C_IDR_RXNE_POS)

# define  I2C_IDR_TXUD_POS 3U
# define  I2C_IDR_TXUD_MSK BIT(I2C_IDR_TXUD_POS)

# define  I2C_IDR_TXOV_POS 2U
# define  I2C_IDR_TXOV_MSK BIT(I2C_IDR_TXOV_POS)

# define  I2C_IDR_TXE_POS 0U
# define  I2C_IDR_TXE_MSK BIT(I2C_IDR_TXE_POS)
/****************** Bit definition for I2C_IVS register ************************/

# define  I2C_IVS_ALERT_POS 20U
# define  I2C_IVS_ALERT_MSK BIT(I2C_IVS_ALERT_POS)

# define  I2C_IVS_TOUT_POS 19U
# define  I2C_IVS_TOUT_MSK BIT(I2C_IVS_TOUT_POS)

# define  I2C_IVS_PECE_POS 18U
# define  I2C_IVS_PECE_MSK BIT(I2C_IVS_PECE_POS)

# define  I2C_IVS_ARLO_POS 17U
# define  I2C_IVS_ARLO_MSK BIT(I2C_IVS_ARLO_POS)

# define  I2C_IVS_BERR_POS 16U
# define  I2C_IVS_BERR_MSK BIT(I2C_IVS_BERR_POS)

# define  I2C_IVS_STOP_POS 14U
# define  I2C_IVS_STOP_MSK BIT(I2C_IVS_STOP_POS)

# define  I2C_IVS_NACK_POS 13U
# define  I2C_IVS_NACK_MSK BIT(I2C_IVS_NACK_POS)

# define  I2C_IVS_ADDR_POS 12U
# define  I2C_IVS_ADDR_MSK BIT(I2C_IVS_ADDR_POS)

# define  I2C_IVS_TCR_POS 11U
# define  I2C_IVS_TCR_MSK BIT(I2C_IVS_TCR_POS)

# define  I2C_IVS_TC_POS 10U
# define  I2C_IVS_TC_MSK BIT(I2C_IVS_TC_POS)

# define  I2C_IVS_RXUD_POS 8U
# define  I2C_IVS_RXUD_MSK BIT(I2C_IVS_RXUD_POS)

# define  I2C_IVS_RXOV_POS 7U
# define  I2C_IVS_RXOV_MSK BIT(I2C_IVS_RXOV_POS)

# define  I2C_IVS_RXNE_POS 5U
# define  I2C_IVS_RXNE_MSK BIT(I2C_IVS_RXNE_POS)

# define  I2C_IVS_TXUD_POS 3U
# define  I2C_IVS_TXUD_MSK BIT(I2C_IVS_TXUD_POS)

# define  I2C_IVS_TXOV_POS 2U
# define  I2C_IVS_TXOV_MSK BIT(I2C_IVS_TXOV_POS)

# define  I2C_IVS_TXE_POS 0U
# define  I2C_IVS_TXE_MSK BIT(I2C_IVS_TXE_POS)

/****************** Bit definition for I2C_RIF register ************************/

# define  I2C_RIF_ALERT_POS 20U
# define  I2C_RIF_ALERT_MSK BIT(I2C_RIF_ALERT_POS)

# define  I2C_RIF_TOUT_POS 19U
# define  I2C_RIF_TOUT_MSK BIT(I2C_RIF_TOUT_POS)

# define  I2C_RIF_PECE_POS 18U
# define  I2C_RIF_PECE_MSK BIT(I2C_RIF_PECE_POS)

# define  I2C_RIF_ARLO_POS 17U
# define  I2C_RIF_ARLO_MSK BIT(I2C_RIF_ARLO_POS)

# define  I2C_RIF_BERR_POS 16U
# define  I2C_RIF_BERR_MSK BIT(I2C_RIF_BERR_POS)

# define  I2C_RIF_STOP_POS 14U
# define  I2C_RIF_STOP_MSK BIT(I2C_RIF_STOP_POS)

# define  I2C_RIF_NACK_POS 13U
# define  I2C_RIF_NACK_MSK BIT(I2C_RIF_NACK_POS)

# define  I2C_RIF_ADDR_POS 12U
# define  I2C_RIF_ADDR_MSK BIT(I2C_RIF_ADDR_POS)

# define  I2C_RIF_TCR_POS 11U
# define  I2C_RIF_TCR_MSK BIT(I2C_RIF_TCR_POS)

# define  I2C_RIF_TC_POS 10U
# define  I2C_RIF_TC_MSK BIT(I2C_RIF_TC_POS)

# define  I2C_RIF_RXUD_POS 8U
# define  I2C_RIF_RXUD_MSK BIT(I2C_RIF_RXUD_POS)

# define  I2C_RIF_RXOV_POS 7U
# define  I2C_RIF_RXOV_MSK BIT(I2C_RIF_RXOV_POS)

# define  I2C_RIF_RXNE_POS 5U
# define  I2C_RIF_RXNE_MSK BIT(I2C_RIF_RXNE_POS)

# define  I2C_RIF_TXUD_POS 3U
# define  I2C_RIF_TXUD_MSK BIT(I2C_RIF_TXUD_POS)

# define  I2C_RIF_TXOV_POS 2U
# define  I2C_RIF_TXOV_MSK BIT(I2C_RIF_TXOV_POS)

# define  I2C_RIF_TXE_POS 0U
# define  I2C_RIF_TXE_MSK BIT(I2C_RIF_TXE_POS)

/****************** Bit definition for I2C_IFM register ************************/

# define  I2C_IFM_ALERT_POS 20U
# define  I2C_IFM_ALERT_MSK BIT(I2C_IFM_ALERT_POS)

# define  I2C_IFM_TOUT_POS 19U
# define  I2C_IFM_TOUT_MSK BIT(I2C_IFM_TOUT_POS)

# define  I2C_IFM_PECE_POS 18U
# define  I2C_IFM_PECE_MSK BIT(I2C_IFM_PECE_POS)

# define  I2C_IFM_ARLO_POS 17U
# define  I2C_IFM_ARLO_MSK BIT(I2C_IFM_ARLO_POS)

# define  I2C_IFM_BERR_POS 16U
# define  I2C_IFM_BERR_MSK BIT(I2C_IFM_BERR_POS)

# define  I2C_IFM_STOP_POS 14U
# define  I2C_IFM_STOP_MSK BIT(I2C_IFM_STOP_POS)

# define  I2C_IFM_NACK_POS 13U
# define  I2C_IFM_NACK_MSK BIT(I2C_IFM_NACK_POS)

# define  I2C_IFM_ADDR_POS 12U
# define  I2C_IFM_ADDR_MSK BIT(I2C_IFM_ADDR_POS)

# define  I2C_IFM_TCR_POS 11U
# define  I2C_IFM_TCR_MSK BIT(I2C_IFM_TCR_POS)

# define  I2C_IFM_TC_POS 10U
# define  I2C_IFM_TC_MSK BIT(I2C_IFM_TC_POS)

# define  I2C_IFM_RXUD_POS 8U
# define  I2C_IFM_RXUD_MSK BIT(I2C_IFM_RXUD_POS)

# define  I2C_IFM_RXOV_POS 7U
# define  I2C_IFM_RXOV_MSK BIT(I2C_IFM_RXOV_POS)

# define  I2C_IFM_RXNE_POS 5U
# define  I2C_IFM_RXNE_MSK BIT(I2C_IFM_RXNE_POS)

# define  I2C_IFM_TXUD_POS 3U
# define  I2C_IFM_TXUD_MSK BIT(I2C_IFM_TXUD_POS)

# define  I2C_IFM_TXOV_POS 2U
# define  I2C_IFM_TXOV_MSK BIT(I2C_IFM_TXOV_POS)

# define  I2C_IFM_TXE_POS 0U
# define  I2C_IFM_TXE_MSK BIT(I2C_IFM_TXE_POS)

/****************** Bit definition for I2C_ICR register ************************/

# define  I2C_ICR_ALERT_POS 20U
# define  I2C_ICR_ALERT_MSK BIT(I2C_ICR_ALERT_POS)

# define  I2C_ICR_TOUT_POS 19U
# define  I2C_ICR_TOUT_MSK BIT(I2C_ICR_TOUT_POS)

# define  I2C_ICR_PECE_POS 18U
# define  I2C_ICR_PECE_MSK BIT(I2C_ICR_PECE_POS)

# define  I2C_ICR_ARLO_POS 17U
# define  I2C_ICR_ARLO_MSK BIT(I2C_ICR_ARLO_POS)

# define  I2C_ICR_BERR_POS 16U
# define  I2C_ICR_BERR_MSK BIT(I2C_ICR_BERR_POS)

# define  I2C_ICR_STOP_POS 14U
# define  I2C_ICR_STOP_MSK BIT(I2C_ICR_STOP_POS)

# define  I2C_ICR_NACK_POS 13U
# define  I2C_ICR_NACK_MSK BIT(I2C_ICR_NACK_POS)

# define  I2C_ICR_ADDR_POS 12U
# define  I2C_ICR_ADDR_MSK BIT(I2C_ICR_ADDR_POS)

# define  I2C_ICR_TCR_POS 11U
# define  I2C_ICR_TCR_MSK BIT(I2C_ICR_TCR_POS)

# define  I2C_ICR_TC_POS 10U
# define  I2C_ICR_TC_MSK BIT(I2C_ICR_TC_POS)

# define  I2C_ICR_RXUD_POS 8U
# define  I2C_ICR_RXUD_MSK BIT(I2C_ICR_RXUD_POS)

# define  I2C_ICR_RXOV_POS 7U
# define  I2C_ICR_RXOV_MSK BIT(I2C_ICR_RXOV_POS)

# define  I2C_ICR_RXNE_POS 5U
# define  I2C_ICR_RXNE_MSK BIT(I2C_ICR_RXNE_POS)

# define  I2C_ICR_TXUD_POS 3U
# define  I2C_ICR_TXUD_MSK BIT(I2C_ICR_TXUD_POS)

# define  I2C_ICR_TXOV_POS 2U
# define  I2C_ICR_TXOV_MSK BIT(I2C_ICR_TXOV_POS)

# define  I2C_ICR_TXE_POS 0U
# define  I2C_ICR_TXE_MSK BIT(I2C_ICR_TXE_POS)

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CON1;
    __IO uint32_t CON2;
    __IO uint32_t ADDR1;
    __IO uint32_t ADDR2;
    __IO uint32_t TIMINGR;
    __IO uint32_t TIMEOUTR;
    __I  uint32_t STAT;
    __IO uint32_t RESERVED0;
    __IO uint32_t PECR;
    __I  uint32_t RXDATA;
    __O  uint32_t TXDATA;
    __O  uint32_t IER;
    __O  uint32_t IDR;
    __I  uint32_t IVS;
    __I  uint32_t RIF;
    __I  uint32_t IFM;
    __O  uint32_t ICR;
} I2C_TypeDef;

/****************** Bit definition for CAN_CON register ************************/

#define CAN_CON_DBGSTP_POS  16U
#define CAN_CON_DBGSTP_MSK  BIT(CAN_CON_DBGSTP_POS)

#define CAN_CON_RST_POS 15U
#define CAN_CON_RST_MSK BIT(CAN_CON_RST_POS)

#define CAN_CON_TTCEN_POS   7U
#define CAN_CON_TTCEN_MSK   BIT(CAN_CON_TTCEN_POS)

#define CAN_CON_ABOFFEN_POS 6U
#define CAN_CON_ABOFFEN_MSK BIT(CAN_CON_ABOFFEN_POS)

#define CAN_CON_AWKEN_POS   5U
#define CAN_CON_AWKEN_MSK   BIT(CAN_CON_AWKEN_POS)

#define CAN_CON_ARTXDIS_POS 4U
#define CAN_CON_ARTXDIS_MSK BIT(CAN_CON_ARTXDIS_POS)

#define CAN_CON_RXFOPM_POS  3U
#define CAN_CON_RXFOPM_MSK  BIT(CAN_CON_RXFOPM_POS)

#define CAN_CON_TXMP_POS    2U
#define CAN_CON_TXMP_MSK    BIT(CAN_CON_TXMP_POS)

#define CAN_CON_SLPREQ_POS  1U
#define CAN_CON_SLPREQ_MSK  BIT(CAN_CON_SLPREQ_POS)

#define CAN_CON_INIREQ_POS  0U
#define CAN_CON_INIREQ_MSK  BIT(CAN_CON_INIREQ_POS)

/****************** Bit definition for CAN_STAT register ************************/

#define CAN_STAT_RX_POS 11U
#define CAN_STAT_RX_MSK BIT(CAN_STAT_RX_POS)

#define CAN_STAT_PRESMP_POS 10U
#define CAN_STAT_PRESMP_MSK BIT(CAN_STAT_PRESMP_POS)

#define CAN_STAT_RXSTAT_POS 9U
#define CAN_STAT_RXSTAT_MSK BIT(CAN_STAT_RXSTAT_POS)

#define CAN_STAT_TXSTAT_POS 8U
#define CAN_STAT_TXSTAT_MSK BIT(CAN_STAT_TXSTAT_POS)

#define CAN_STAT_SLPIF_POS  4U
#define CAN_STAT_SLPIF_MSK  BIT(CAN_STAT_SLPIF_POS)

#define CAN_STAT_WKIF_POS   3U
#define CAN_STAT_WKIF_MSK   BIT(CAN_STAT_WKIF_POS)

#define CAN_STAT_ERRIF_POS  2U
#define CAN_STAT_ERRIF_MSK  BIT(CAN_STAT_ERRIF_POS)

#define CAN_STAT_SLPSTAT_POS    1U
#define CAN_STAT_SLPSTAT_MSK    BIT(CAN_STAT_SLPSTAT_POS)

#define CAN_STAT_INISTAT_POS    0U
#define CAN_STAT_INISTAT_MSK    BIT(CAN_STAT_INISTAT_POS)

/****************** Bit definition for CAN_IFC register ************************/

#define CAN_IFC_SLPIFC_POS  4U
#define CAN_IFC_SLPIFC_MSK  BIT(CAN_IFC_SLPIFC_POS)

#define CAN_IFC_WKIFC_POS   3U
#define CAN_IFC_WKIFC_MSK   BIT(CAN_IFC_WKIFC_POS)

#define CAN_IFC_ERRIFC_POS  2U
#define CAN_IFC_ERRIFC_MSK  BIT(CAN_IFC_ERRIFC_POS)

/****************** Bit definition for CAN_TXSTAT register ************************/

#define CAN_TXSTAT_TXM2LPF_POS  31U
#define CAN_TXSTAT_TXM2LPF_MSK  BIT(CAN_TXSTAT_TXM2LPF_POS)

#define CAN_TXSTAT_TXM1LPF_POS  30U
#define CAN_TXSTAT_TXM1LPF_MSK  BIT(CAN_TXSTAT_TXM1LPF_POS)

#define CAN_TXSTAT_TXM0LPF_POS  29U
#define CAN_TXSTAT_TXM0LPF_MSK  BIT(CAN_TXSTAT_TXM0LPF_POS)

#define CAN_TXSTAT_TXM2EF_POS   28U
#define CAN_TXSTAT_TXM2EF_MSK   BIT(CAN_TXSTAT_TXM2EF_POS)

#define CAN_TXSTAT_TXM1EF_POS   27U
#define CAN_TXSTAT_TXM1EF_MSK   BIT(CAN_TXSTAT_TXM1EF_POS)

#define CAN_TXSTAT_TXM0EF_POS   26U
#define CAN_TXSTAT_TXM0EF_MSK   BIT(CAN_TXSTAT_TXM0EF_POS)

#define CAN_TXSTAT_CODE_POSS    24U
#define CAN_TXSTAT_CODE_POSE    25U
#define CAN_TXSTAT_CODE_MSK BITS(CAN_TXSTAT_CODE_POSS,CAN_TXSTAT_CODE_POSE)

#define CAN_TXSTAT_M2STPREQ_POS 23U
#define CAN_TXSTAT_M2STPREQ_MSK BIT(CAN_TXSTAT_M2STPREQ_POS)

#define CAN_TXSTAT_M2TXERR_POS  19U
#define CAN_TXSTAT_M2TXERR_MSK  BIT(CAN_TXSTAT_M2TXERR_POS)

#define CAN_TXSTAT_M2ARBLST_POS 18U
#define CAN_TXSTAT_M2ARBLST_MSK BIT(CAN_TXSTAT_M2ARBLST_POS)

#define CAN_TXSTAT_M2TXC_POS    17U
#define CAN_TXSTAT_M2TXC_MSK    BIT(CAN_TXSTAT_M2TXC_POS)

#define CAN_TXSTAT_M2REQC_POS   16U
#define CAN_TXSTAT_M2REQC_MSK   BIT(CAN_TXSTAT_M2REQC_POS)

#define CAN_TXSTAT_M1STPREQ_POS 15U
#define CAN_TXSTAT_M1STPREQ_MSK BIT(CAN_TXSTAT_M1STPREQ_POS)

#define CAN_TXSTAT_M1TXERR_POS  11U
#define CAN_TXSTAT_M1TXERR_MSK  BIT(CAN_TXSTAT_M1TXERR_POS)

#define CAN_TXSTAT_M1ARBLST_POS 10U
#define CAN_TXSTAT_M1ARBLST_MSK BIT(CAN_TXSTAT_M1ARBLST_POS)

#define CAN_TXSTAT_M1TXC_POS    9U
#define CAN_TXSTAT_M1TXC_MSK    BIT(CAN_TXSTAT_M1TXC_POS)

#define CAN_TXSTAT_M1REQC_POS   8U
#define CAN_TXSTAT_M1REQC_MSK   BIT(CAN_TXSTAT_M1REQC_POS)

#define CAN_TXSTAT_M0STPREQ_POS 7U
#define CAN_TXSTAT_M0STPREQ_MSK BIT(CAN_TXSTAT_M0STPREQ_POS)

#define CAN_TXSTAT_M0TXERR_POS  3U
#define CAN_TXSTAT_M0TXERR_MSK  BIT(CAN_TXSTAT_M0TXERR_POS)

#define CAN_TXSTAT_M0ARBLST_POS 2U
#define CAN_TXSTAT_M0ARBLST_MSK BIT(CAN_TXSTAT_M0ARBLST_POS)

#define CAN_TXSTAT_M0TXC_POS    1U
#define CAN_TXSTAT_M0TXC_MSK    BIT(CAN_TXSTAT_M0TXC_POS)

#define CAN_TXSTAT_M0REQC_POS   0U
#define CAN_TXSTAT_M0REQC_MSK   BIT(CAN_TXSTAT_M0REQC_POS)

/****************** Bit definition for CAN_TXSTATC register ************************/

#define CAN_TXSTATC_M2TXERR_POS 19U
#define CAN_TXSTATC_M2TXERR_MSK BIT(CAN_TXSTATC_M2TXERR_POS)

#define CAN_TXSTATC_M2ARBLST_POS    18U
#define CAN_TXSTATC_M2ARBLST_MSK    BIT(CAN_TXSTATC_M2ARBLST_POS)

#define CAN_TXSTATC_M2TXC_POS   17U
#define CAN_TXSTATC_M2TXC_MSK   BIT(CAN_TXSTATC_M2TXC_POS)

#define CAN_TXSTATC_M2REQC_POS  16U
#define CAN_TXSTATC_M2REQC_MSK  BIT(CAN_TXSTATC_M2REQC_POS)

#define CAN_TXSTATC_M1TXERR_POS 11U
#define CAN_TXSTATC_M1TXERR_MSK BIT(CAN_TXSTATC_M1TXERR_POS)

#define CAN_TXSTATC_M1ARBLST_POS    10U
#define CAN_TXSTATC_M1ARBLST_MSK    BIT(CAN_TXSTATC_M1ARBLST_POS)

#define CAN_TXSTATC_M1TXC_POS   9U
#define CAN_TXSTATC_M1TXC_MSK   BIT(CAN_TXSTATC_M1TXC_POS)

#define CAN_TXSTATC_M1REQC_POS  8U
#define CAN_TXSTATC_M1REQC_MSK  BIT(CAN_TXSTATC_M1REQC_POS)

#define CAN_TXSTATC_M0TXERR_POS 3U
#define CAN_TXSTATC_M0TXERR_MSK BIT(CAN_TXSTATC_M0TXERR_POS)

#define CAN_TXSTATC_M0ARBLST_POS    2U
#define CAN_TXSTATC_M0ARBLST_MSK    BIT(CAN_TXSTATC_M0ARBLST_POS)

#define CAN_TXSTATC_M0TXC_POS   1U
#define CAN_TXSTATC_M0TXC_MSK   BIT(CAN_TXSTATC_M0TXC_POS)

#define CAN_TXSTATC_M0REQC_POS  0U
#define CAN_TXSTATC_M0REQC_MSK  BIT(CAN_TXSTATC_M0REQC_POS)

/****************** Bit definition for CAN_RXF0 register ************************/

#define CAN_RXF0_FREE_POS   5U
#define CAN_RXF0_FREE_MSK   BIT(CAN_RXF0_FREE_POS)

#define CAN_RXF0_OVR_POS    4U
#define CAN_RXF0_OVR_MSK    BIT(CAN_RXF0_OVR_POS)

#define CAN_RXF0_FULL_POS   3U
#define CAN_RXF0_FULL_MSK   BIT(CAN_RXF0_FULL_POS)

#define CAN_RXF0_PEND_POSS  0U
#define CAN_RXF0_PEND_POSE  1U
#define CAN_RXF0_PEND_MSK   BITS(CAN_RXF0_PEND_POSS,CAN_RXF0_PEND_POSE)

/****************** Bit definition for CAN_RXF0C register ************************/

#define CAN_RXF0C_OVRC_POS  4U
#define CAN_RXF0C_OVRC_MSK  BIT(CAN_RXF0C_OVRC_POS)

#define CAN_RXF0C_FULLC_POS 3U
#define CAN_RXF0C_FULLC_MSK BIT(CAN_RXF0C_FULLC_POS)

/****************** Bit definition for CAN_RXF1 register ************************/

#define CAN_RXF1_FREE_POS   5U
#define CAN_RXF1_FREE_MSK   BIT(CAN_RXF1_FREE_POS)

#define CAN_RXF1_OVR_POS    4U
#define CAN_RXF1_OVR_MSK    BIT(CAN_RXF1_OVR_POS)

#define CAN_RXF1_FULL_POS   3U
#define CAN_RXF1_FULL_MSK   BIT(CAN_RXF1_FULL_POS)

#define CAN_RXF1_PEND_POSS  0U
#define CAN_RXF1_PEND_POSE  1U
#define CAN_RXF1_PEND_MSK   BITS(CAN_RXF1_PEND_POSS,CAN_RXF1_PEND_POSE)

/****************** Bit definition for CAN_RXF1C register ************************/

#define CAN_RXF1C_OVRC_POS  4U
#define CAN_RXF1C_OVRC_MSK  BIT(CAN_RXF1C_OVRC_POS)

#define CAN_RXF1C_FULLC_POS 3U
#define CAN_RXF1C_FULLC_MSK BIT(CAN_RXF1C_FULLC_POS)

/****************** Bit definition for CAN_IE register ************************/

#define CAN_IE_SLPIE_POS    17U
#define CAN_IE_SLPIE_MSK    BIT(CAN_IE_SLPIE_POS)

#define CAN_IE_WKIE_POS 16U
#define CAN_IE_WKIE_MSK BIT(CAN_IE_WKIE_POS)

#define CAN_IE_ERRIE_POS    15U
#define CAN_IE_ERRIE_MSK    BIT(CAN_IE_ERRIE_POS)

#define CAN_IE_PRERRIE_POS  11U
#define CAN_IE_PRERRIE_MSK  BIT(CAN_IE_PRERRIE_POS)

#define CAN_IE_BOFFIE_POS   10U
#define CAN_IE_BOFFIE_MSK   BIT(CAN_IE_BOFFIE_POS)

#define CAN_IE_PERRIE_POS   9U
#define CAN_IE_PERRIE_MSK   BIT(CAN_IE_PERRIE_POS)

#define CAN_IE_WARNIE_POS   8U
#define CAN_IE_WARNIE_MSK   BIT(CAN_IE_WARNIE_POS)

#define CAN_IE_F1OVRIE_POS  6U
#define CAN_IE_F1OVRIE_MSK  BIT(CAN_IE_F1OVRIE_POS)

#define CAN_IE_F1FULIE_POS  5U
#define CAN_IE_F1FULIE_MSK  BIT(CAN_IE_F1FULIE_POS)

#define CAN_IE_F1PIE_POS    4U
#define CAN_IE_F1PIE_MSK    BIT(CAN_IE_F1PIE_POS)

#define CAN_IE_F0OVRIE_POS  3U
#define CAN_IE_F0OVRIE_MSK  BIT(CAN_IE_F0OVRIE_POS)

#define CAN_IE_F0FULIE_POS  2U
#define CAN_IE_F0FULIE_MSK  BIT(CAN_IE_F0FULIE_POS)

#define CAN_IE_F0PIE_POS    1U
#define CAN_IE_F0PIE_MSK    BIT(CAN_IE_F0PIE_POS)

#define CAN_IE_TXMEIE_POS   0U
#define CAN_IE_TXMEIE_MSK   BIT(CAN_IE_TXMEIE_POS)

/****************** Bit definition for CAN_ERRSTAT register ************************/

#define CAN_ERRSTAT_RXERRC_POSS 24U
#define CAN_ERRSTAT_RXERRC_POSE 31U
#define CAN_ERRSTAT_RXERRC_MSK  BITS(CAN_ERRSTAT_RXERRC_POSS,CAN_ERRSTAT_RXERRC_POSE)

#define CAN_ERRSTAT_TXERRC_POSS 16U
#define CAN_ERRSTAT_TXERRC_POSE 23U
#define CAN_ERRSTAT_TXERRC_MSK  BITS(CAN_ERRSTAT_TXERRC_POSS,CAN_ERRSTAT_TXERRC_POSE)

#define CAN_ERRSTAT_PRERRF_POSS 4U
#define CAN_ERRSTAT_PRERRF_POSE 6U
#define CAN_ERRSTAT_PRERRF_MSK  BITS(CAN_ERRSTAT_PRERRF_POSS,CAN_ERRSTAT_PRERRF_POSE)

#define CAN_ERRSTAT_BOFF_POS    2U
#define CAN_ERRSTAT_BOFF_MSK    BIT(CAN_ERRSTAT_BOFF_POS)

#define CAN_ERRSTAT_PERRF_POS   1U
#define CAN_ERRSTAT_PERRF_MSK   BIT(CAN_ERRSTAT_PERRF_POS)

#define CAN_ERRSTAT_WARNF_POS   0U
#define CAN_ERRSTAT_WARNF_MSK   BIT(CAN_ERRSTAT_WARNF_POS)

/****************** Bit definition for CAN_BTIME register ************************/

#define CAN_BTIME_SILENT_POS    31U
#define CAN_BTIME_SILENT_MSK    BIT(CAN_BTIME_SILENT_POS)

#define CAN_BTIME_LOOP_POS  30U
#define CAN_BTIME_LOOP_MSK  BIT(CAN_BTIME_LOOP_POS)

#define CAN_BTIME_RESJW_POSS    24U
#define CAN_BTIME_RESJW_POSE    25U
#define CAN_BTIME_RESJW_MSK BITS(CAN_BTIME_RESJW_POSS,CAN_BTIME_RESJW_POSE)

#define CAN_BTIME_SEG2_POSS 20U
#define CAN_BTIME_SEG2_POSE 22U
#define CAN_BTIME_SEG2_MSK  BITS(CAN_BTIME_SEG2_POSS,CAN_BTIME_SEG2_POSE)

#define CAN_BTIME_SEG1_POSS 16U
#define CAN_BTIME_SEG1_POSE 19U
#define CAN_BTIME_SEG1_MSK  BITS(CAN_BTIME_SEG1_POSS,CAN_BTIME_SEG1_POSE)

#define CAN_BTIME_BPSC_POSS 0U
#define CAN_BTIME_BPSC_POSE 9U
#define CAN_BTIME_BPSC_MSK  BITS(CAN_BTIME_BPSC_POSS,CAN_BTIME_BPSC_POSE)

/****************** Bit definition for CAN_TXID0 register ************************/

#define CAN_TXID0_STDID_POSS    21U
#define CAN_TXID0_STDID_POSE    31U
#define CAN_TXID0_STDID_MSK BITS(CAN_TXID0_STDID_POSS,CAN_TXID0_STDID_POSE)

#define CAN_TXID0_EXID_POSS 3U
#define CAN_TXID0_EXID_POSE 20U
#define CAN_TXID0_EXID_MSK  BITS(CAN_TXID0_EXID_POSS,CAN_TXID0_EXID_POSE)

#define CAN_TXID0_IDE_POS   2U
#define CAN_TXID0_IDE_MSK   BIT(CAN_TXID0_IDE_POS)

#define CAN_TXID0_RTR_POS   1U
#define CAN_TXID0_RTR_MSK   BIT(CAN_TXID0_RTR_POS)

#define CAN_TXID0_TXMREQ_POS    0U
#define CAN_TXID0_TXMREQ_MSK    BIT(CAN_TXID0_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON0 register ************************/

#define CAN_TXFCON0_STAMP_POSS  16U
#define CAN_TXFCON0_STAMP_POSE  31U
#define CAN_TXFCON0_STAMP_MSK   BITS(CAN_TXFCON0_STAMP_POSS,CAN_TXFCON0_STAMP_POSE)

#define CAN_TXFCON0_TXGT_POS    8U
#define CAN_TXFCON0_TXGT_MSK    BIT(CAN_TXFCON0_TXGT_POS)

#define CAN_TXFCON0_DLEN_POSS   0U
#define CAN_TXFCON0_DLEN_POSE   3U
#define CAN_TXFCON0_DLEN_MSK    BITS(CAN_TXFCON0_DLEN_POSS,CAN_TXFCON0_DLEN_POSE)

/****************** Bit definition for CAN_TXDL0 register ************************/

#define CAN_TXDL0_BYTE3_POSS    24U
#define CAN_TXDL0_BYTE3_POSE    31U
#define CAN_TXDL0_BYTE3_MSK BITS(CAN_TXDL0_BYTE3_POSS,CAN_TXDL0_BYTE3_POSE)

#define CAN_TXDL0_BYTE2_POSS    16U
#define CAN_TXDL0_BYTE2_POSE    23U
#define CAN_TXDL0_BYTE2_MSK BITS(CAN_TXDL0_BYTE2_POSS,CAN_TXDL0_BYTE2_POSE)

#define CAN_TXDL0_BYTE1_POSS    8U
#define CAN_TXDL0_BYTE1_POSE    15U
#define CAN_TXDL0_BYTE1_MSK BITS(CAN_TXDL0_BYTE1_POSS,CAN_TXDL0_BYTE1_POSE)

#define CAN_TXDL0_BYTE0_POSS    0U
#define CAN_TXDL0_BYTE0_POSE    7U
#define CAN_TXDL0_BYTE0_MSK BITS(CAN_TXDL0_BYTE0_POSS,CAN_TXDL0_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH0 register ************************/

#define CAN_TXDH0_BYTE7_POSS    24U
#define CAN_TXDH0_BYTE7_POSE    31U
#define CAN_TXDH0_BYTE7_MSK BITS(CAN_TXDH0_BYTE7_POSS,CAN_TXDH0_BYTE7_POSE)

#define CAN_TXDH0_BYTE6_POSS    16U
#define CAN_TXDH0_BYTE6_POSE    23U
#define CAN_TXDH0_BYTE6_MSK BITS(CAN_TXDH0_BYTE6_POSS,CAN_TXDH0_BYTE6_POSE)

#define CAN_TXDH0_BYTE5_POSS    8U
#define CAN_TXDH0_BYTE5_POSE    15U
#define CAN_TXDH0_BYTE5_MSK BITS(CAN_TXDH0_BYTE5_POSS,CAN_TXDH0_BYTE5_POSE)

#define CAN_TXDH0_BYTE4_POSS    0U
#define CAN_TXDH0_BYTE4_POSE    7U
#define CAN_TXDH0_BYTE4_MSK BITS(CAN_TXDH0_BYTE4_POSS,CAN_TXDH0_BYTE4_POSE)

/****************** Bit definition for CAN_TXID1 register ************************/

#define CAN_TXID1_STDID_POSS    21U
#define CAN_TXID1_STDID_POSE    31U
#define CAN_TXID1_STDID_MSK BITS(CAN_TXID1_STDID_POSS,CAN_TXID1_STDID_POSE)

#define CAN_TXID1_EXID_POSS 3U
#define CAN_TXID1_EXID_POSE 20U
#define CAN_TXID1_EXID_MSK  BITS(CAN_TXID1_EXID_POSS,CAN_TXID1_EXID_POSE)

#define CAN_TXID1_IDE_POS   2U
#define CAN_TXID1_IDE_MSK   BIT(CAN_TXID1_IDE_POS)

#define CAN_TXID1_RTR_POS   1U
#define CAN_TXID1_RTR_MSK   BIT(CAN_TXID1_RTR_POS)

#define CAN_TXID1_TXMREQ_POS    0U
#define CAN_TXID1_TXMREQ_MSK    BIT(CAN_TXID1_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON1 register ************************/

#define CAN_TXFCON1_STAMP_POSS  16U
#define CAN_TXFCON1_STAMP_POSE  31U
#define CAN_TXFCON1_STAMP_MSK   BITS(CAN_TXFCON1_STAMP_POSS,CAN_TXFCON1_STAMP_POSE)

#define CAN_TXFCON1_TXGT_POS    8U
#define CAN_TXFCON1_TXGT_MSK    BIT(CAN_TXFCON1_TXGT_POS)

#define CAN_TXFCON1_DLEN_POSS   0U
#define CAN_TXFCON1_DLEN_POSE   3U
#define CAN_TXFCON1_DLEN_MSK    BITS(CAN_TXFCON1_DLEN_POSS,CAN_TXFCON1_DLEN_POSE)

/****************** Bit definition for CAN_TXDL1 register ************************/

#define CAN_TXDL1_BYTE3_POSS    24U
#define CAN_TXDL1_BYTE3_POSE    31U
#define CAN_TXDL1_BYTE3_MSK BITS(CAN_TXDL1_BYTE3_POSS,CAN_TXDL1_BYTE3_POSE)

#define CAN_TXDL1_BYTE2_POSS    16U
#define CAN_TXDL1_BYTE2_POSE    23U
#define CAN_TXDL1_BYTE2_MSK BITS(CAN_TXDL1_BYTE2_POSS,CAN_TXDL1_BYTE2_POSE)

#define CAN_TXDL1_BYTE1_POSS    8U
#define CAN_TXDL1_BYTE1_POSE    15U
#define CAN_TXDL1_BYTE1_MSK BITS(CAN_TXDL1_BYTE1_POSS,CAN_TXDL1_BYTE1_POSE)

#define CAN_TXDL1_BYTE0_POSS    0U
#define CAN_TXDL1_BYTE0_POSE    7U
#define CAN_TXDL1_BYTE0_MSK BITS(CAN_TXDL1_BYTE0_POSS,CAN_TXDL1_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH1 register ************************/

#define CAN_TXDH1_BYTE7_POSS    24U
#define CAN_TXDH1_BYTE7_POSE    31U
#define CAN_TXDH1_BYTE7_MSK BITS(CAN_TXDH1_BYTE7_POSS,CAN_TXDH1_BYTE7_POSE)

#define CAN_TXDH1_BYTE6_POSS    16U
#define CAN_TXDH1_BYTE6_POSE    23U
#define CAN_TXDH1_BYTE6_MSK BITS(CAN_TXDH1_BYTE6_POSS,CAN_TXDH1_BYTE6_POSE)

#define CAN_TXDH1_BYTE5_POSS    8U
#define CAN_TXDH1_BYTE5_POSE    15U
#define CAN_TXDH1_BYTE5_MSK BITS(CAN_TXDH1_BYTE5_POSS,CAN_TXDH1_BYTE5_POSE)

#define CAN_TXDH1_BYTE4_POSS    0U
#define CAN_TXDH1_BYTE4_POSE    7U
#define CAN_TXDH1_BYTE4_MSK BITS(CAN_TXDH1_BYTE4_POSS,CAN_TXDH1_BYTE4_POSE)

/****************** Bit definition for CAN_TXID2 register ************************/

#define CAN_TXID2_STDID_POSS    21U
#define CAN_TXID2_STDID_POSE    31U
#define CAN_TXID2_STDID_MSK BITS(CAN_TXID2_STDID_POSS,CAN_TXID2_STDID_POSE)

#define CAN_TXID2_EXID_POSS 3U
#define CAN_TXID2_EXID_POSE 20U
#define CAN_TXID2_EXID_MSK  BITS(CAN_TXID2_EXID_POSS,CAN_TXID2_EXID_POSE)

#define CAN_TXID2_IDE_POS   2U
#define CAN_TXID2_IDE_MSK   BIT(CAN_TXID2_IDE_POS)

#define CAN_TXID2_RTR_POS   1U
#define CAN_TXID2_RTR_MSK   BIT(CAN_TXID2_RTR_POS)

#define CAN_TXID2_TXMREQ_POS    0U
#define CAN_TXID2_TXMREQ_MSK    BIT(CAN_TXID2_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON2 register ************************/

#define CAN_TXFCON2_STAMP_POSS  16U
#define CAN_TXFCON2_STAMP_POSE  31U
#define CAN_TXFCON2_STAMP_MSK   BITS(CAN_TXFCON2_STAMP_POSS,CAN_TXFCON2_STAMP_POSE)

#define CAN_TXFCON2_TXGT_POS    8U
#define CAN_TXFCON2_TXGT_MSK    BIT(CAN_TXFCON2_TXGT_POS)

#define CAN_TXFCON2_DLEN_POSS   0U
#define CAN_TXFCON2_DLEN_POSE   3U
#define CAN_TXFCON2_DLEN_MSK    BITS(CAN_TXFCON2_DLEN_POSS,CAN_TXFCON2_DLEN_POSE)

/****************** Bit definition for CAN_TXDL2 register ************************/

#define CAN_TXDL2_BYTE3_POSS    24U
#define CAN_TXDL2_BYTE3_POSE    31U
#define CAN_TXDL2_BYTE3_MSK BITS(CAN_TXDL2_BYTE3_POSS,CAN_TXDL2_BYTE3_POSE)

#define CAN_TXDL2_BYTE2_POSS    16U
#define CAN_TXDL2_BYTE2_POSE    23U
#define CAN_TXDL2_BYTE2_MSK BITS(CAN_TXDL2_BYTE2_POSS,CAN_TXDL2_BYTE2_POSE)

#define CAN_TXDL2_BYTE1_POSS    8U
#define CAN_TXDL2_BYTE1_POSE    15U
#define CAN_TXDL2_BYTE1_MSK BITS(CAN_TXDL2_BYTE1_POSS,CAN_TXDL2_BYTE1_POSE)

#define CAN_TXDL2_BYTE0_POSS    0U
#define CAN_TXDL2_BYTE0_POSE    7U
#define CAN_TXDL2_BYTE0_MSK BITS(CAN_TXDL2_BYTE0_POSS,CAN_TXDL2_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH2 register ************************/

#define CAN_TXDH2_BYTE7_POSS    24U
#define CAN_TXDH2_BYTE7_POSE    31U
#define CAN_TXDH2_BYTE7_MSK BITS(CAN_TXDH2_BYTE7_POSS,CAN_TXDH2_BYTE7_POSE)

#define CAN_TXDH2_BYTE6_POSS    16U
#define CAN_TXDH2_BYTE6_POSE    23U
#define CAN_TXDH2_BYTE6_MSK BITS(CAN_TXDH2_BYTE6_POSS,CAN_TXDH2_BYTE6_POSE)

#define CAN_TXDH2_BYTE5_POSS    8U
#define CAN_TXDH2_BYTE5_POSE    15U
#define CAN_TXDH2_BYTE5_MSK BITS(CAN_TXDH2_BYTE5_POSS,CAN_TXDH2_BYTE5_POSE)

#define CAN_TXDH2_BYTE4_POSS    0U
#define CAN_TXDH2_BYTE4_POSE    7U
#define CAN_TXDH2_BYTE4_MSK BITS(CAN_TXDH2_BYTE4_POSS,CAN_TXDH2_BYTE4_POSE)

/****************** Bit definition for CAN_RXF0ID register ************************/

#define CAN_RXF0ID_STDID_POSS   21U
#define CAN_RXF0ID_STDID_POSE   31U
#define CAN_RXF0ID_STDID_MSK    BITS(CAN_RXF0ID_STDID_POSS,CAN_RXF0ID_STDID_POSE)

#define CAN_RXF0ID_EXID_POSS    3U
#define CAN_RXF0ID_EXID_POSE    20U
#define CAN_RXF0ID_EXID_MSK BITS(CAN_RXF0ID_EXID_POSS,CAN_RXF0ID_EXID_POSE)

#define CAN_RXF0ID_IDE_POS  2U
#define CAN_RXF0ID_IDE_MSK  BIT(CAN_RXF0ID_IDE_POS)

#define CAN_RXF0ID_RTR_POS  1U
#define CAN_RXF0ID_RTR_MSK  BIT(CAN_RXF0ID_RTR_POS)

/****************** Bit definition for CAN_RXF0INF register ************************/

#define CAN_RXF0INF_STAMP_POSS  16U
#define CAN_RXF0INF_STAMP_POSE  31U
#define CAN_RXF0INF_STAMP_MSK   BITS(CAN_RXF0INF_STAMP_POSS,CAN_RXF0INF_STAMP_POSE)

#define CAN_RXF0INF_FLTIDX_POSS 8U
#define CAN_RXF0INF_FLTIDX_POSE 15U
#define CAN_RXF0INF_FLTIDX_MSK  BITS(CAN_RXF0INF_FLTIDX_POSS,CAN_RXF0INF_FLTIDX_POSE)

#define CAN_RXF0INF_DLEN_POSS   0U
#define CAN_RXF0INF_DLEN_POSE   3U
#define CAN_RXF0INF_DLEN_MSK    BITS(CAN_RXF0INF_DLEN_POSS,CAN_RXF0INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF0DL register ************************/

#define CAN_RXF0DL_BYTE3_POSS   24U
#define CAN_RXF0DL_BYTE3_POSE   31U
#define CAN_RXF0DL_BYTE3_MSK    BITS(CAN_RXF0DL_BYTE3_POSS,CAN_RXF0DL_BYTE3_POSE)

#define CAN_RXF0DL_BYTE2_POSS   16U
#define CAN_RXF0DL_BYTE2_POSE   23U
#define CAN_RXF0DL_BYTE2_MSK    BITS(CAN_RXF0DL_BYTE2_POSS,CAN_RXF0DL_BYTE2_POSE)

#define CAN_RXF0DL_BYTE1_POSS   8U
#define CAN_RXF0DL_BYTE1_POSE   15U
#define CAN_RXF0DL_BYTE1_MSK    BITS(CAN_RXF0DL_BYTE1_POSS,CAN_RXF0DL_BYTE1_POSE)

#define CAN_RXF0DL_BYTE0_POSS   0U
#define CAN_RXF0DL_BYTE0_POSE   7U
#define CAN_RXF0DL_BYTE0_MSK    BITS(CAN_RXF0DL_BYTE0_POSS,CAN_RXF0DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF0DH register ************************/

#define CAN_RXF0DH_BYTE7_POSS   24U
#define CAN_RXF0DH_BYTE7_POSE   31U
#define CAN_RXF0DH_BYTE7_MSK    BITS(CAN_RXF0DH_BYTE7_POSS,CAN_RXF0DH_BYTE7_POSE)

#define CAN_RXF0DH_BYTE6_POSS   16U
#define CAN_RXF0DH_BYTE6_POSE   23U
#define CAN_RXF0DH_BYTE6_MSK    BITS(CAN_RXF0DH_BYTE6_POSS,CAN_RXF0DH_BYTE6_POSE)

#define CAN_RXF0DH_BYTE5_POSS   8U
#define CAN_RXF0DH_BYTE5_POSE   15U
#define CAN_RXF0DH_BYTE5_MSK    BITS(CAN_RXF0DH_BYTE5_POSS,CAN_RXF0DH_BYTE5_POSE)

#define CAN_RXF0DH_BYTE4_POSS   0U
#define CAN_RXF0DH_BYTE4_POSE   7U
#define CAN_RXF0DH_BYTE4_MSK    BITS(CAN_RXF0DH_BYTE4_POSS,CAN_RXF0DH_BYTE4_POSE)

/****************** Bit definition for CAN_RXF1ID register ************************/

#define CAN_RXF1ID_STDID_POSS   21U
#define CAN_RXF1ID_STDID_POSE   31U
#define CAN_RXF1ID_STDID_MSK    BITS(CAN_RXF1ID_STDID_POSS,CAN_RXF1ID_STDID_POSE)

#define CAN_RXF1ID_EXID_POSS    3U
#define CAN_RXF1ID_EXID_POSE    20U
#define CAN_RXF1ID_EXID_MSK BITS(CAN_RXF1ID_EXID_POSS,CAN_RXF1ID_EXID_POSE)

#define CAN_RXF1ID_IDE_POS  2U
#define CAN_RXF1ID_IDE_MSK  BIT(CAN_RXF1ID_IDE_POS)

#define CAN_RXF1ID_RTR_POS  1U
#define CAN_RXF1ID_RTR_MSK  BIT(CAN_RXF1ID_RTR_POS)

/****************** Bit definition for CAN_RXF1INF register ************************/

#define CAN_RXF1INF_STAMP_POSS  16U
#define CAN_RXF1INF_STAMP_POSE  31U
#define CAN_RXF1INF_STAMP_MSK   BITS(CAN_RXF1INF_STAMP_POSS,CAN_RXF1INF_STAMP_POSE)

#define CAN_RXF1INF_FLTIDX_POSS 8U
#define CAN_RXF1INF_FLTIDX_POSE 15U
#define CAN_RXF1INF_FLTIDX_MSK  BITS(CAN_RXF1INF_FLTIDX_POSS,CAN_RXF1INF_FLTIDX_POSE)

#define CAN_RXF1INF_DLEN_POSS   0U
#define CAN_RXF1INF_DLEN_POSE   3U
#define CAN_RXF1INF_DLEN_MSK    BITS(CAN_RXF1INF_DLEN_POSS,CAN_RXF1INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF1DL register ************************/

#define CAN_RXF1DL_BYTE3_POSS   24U
#define CAN_RXF1DL_BYTE3_POSE   31U
#define CAN_RXF1DL_BYTE3_MSK    BITS(CAN_RXF1DL_BYTE3_POSS,CAN_RXF1DL_BYTE3_POSE)

#define CAN_RXF1DL_BYTE2_POSS   16U
#define CAN_RXF1DL_BYTE2_POSE   23U
#define CAN_RXF1DL_BYTE2_MSK    BITS(CAN_RXF1DL_BYTE2_POSS,CAN_RXF1DL_BYTE2_POSE)

#define CAN_RXF1DL_BYTE1_POSS   8U
#define CAN_RXF1DL_BYTE1_POSE   15U
#define CAN_RXF1DL_BYTE1_MSK    BITS(CAN_RXF1DL_BYTE1_POSS,CAN_RXF1DL_BYTE1_POSE)

#define CAN_RXF1DL_BYTE0_POSS   0U
#define CAN_RXF1DL_BYTE0_POSE   7U
#define CAN_RXF1DL_BYTE0_MSK    BITS(CAN_RXF1DL_BYTE0_POSS,CAN_RXF1DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF1DH register ************************/

#define CAN_RXF1DH_BYTE7_POSS   24U
#define CAN_RXF1DH_BYTE7_POSE   31U
#define CAN_RXF1DH_BYTE7_MSK    BITS(CAN_RXF1DH_BYTE7_POSS,CAN_RXF1DH_BYTE7_POSE)

#define CAN_RXF1DH_BYTE6_POSS   16U
#define CAN_RXF1DH_BYTE6_POSE   23U
#define CAN_RXF1DH_BYTE6_MSK    BITS(CAN_RXF1DH_BYTE6_POSS,CAN_RXF1DH_BYTE6_POSE)

#define CAN_RXF1DH_BYTE5_POSS   8U
#define CAN_RXF1DH_BYTE5_POSE   15U
#define CAN_RXF1DH_BYTE5_MSK    BITS(CAN_RXF1DH_BYTE5_POSS,CAN_RXF1DH_BYTE5_POSE)

#define CAN_RXF1DH_BYTE4_POSS   0U
#define CAN_RXF1DH_BYTE4_POSE   7U
#define CAN_RXF1DH_BYTE4_MSK    BITS(CAN_RXF1DH_BYTE4_POSS,CAN_RXF1DH_BYTE4_POSE)

/****************** Bit definition for CAN_FLTCON register ************************/

#define CAN_FLTCON_FLTINI_POS   0U
#define CAN_FLTCON_FLTINI_MSK   BIT(CAN_FLTCON_FLTINI_POS)

/****************** Bit definition for CAN_FLTM register ************************/

#define CAN_FLTM_MOD_POSS   0U
#define CAN_FLTM_MOD_POSE   13U
#define CAN_FLTM_MOD_MSK    BITS(CAN_FLTM_MOD_POSS,CAN_FLTM_MOD_POSE)

/****************** Bit definition for CAN_FLTWS register ************************/

#define CAN_FLTWS_SEL_POSS  0U
#define CAN_FLTWS_SEL_POSE  13U
#define CAN_FLTWS_SEL_MSK   BITS(CAN_FLTWS_SEL_POSS,CAN_FLTWS_SEL_POSE)

/****************** Bit definition for CAN_FLTAS register ************************/

#define CAN_FLTAS_ASSIGN_POSS   0U
#define CAN_FLTAS_ASSIGN_POSE   13U
#define CAN_FLTAS_ASSIGN_MSK    BITS(CAN_FLTAS_ASSIGN_POSS,CAN_FLTAS_ASSIGN_POSE)

/****************** Bit definition for CAN_FLTGO register ************************/

#define CAN_FLTGO_GO_POSS   0U
#define CAN_FLTGO_GO_POSE   13U
#define CAN_FLTGO_GO_MSK    BITS(CAN_FLTGO_GO_POSS,CAN_FLTGO_GO_POSE)

typedef struct
{
    __IO uint32_t TXID;
    __IO uint32_t TXFCON;
    __IO uint32_t TXDL;
    __IO uint32_t TXDH;
} CAN_TxMailBox_Typedef;

typedef struct
{
    __IO uint32_t RXFID;
    __IO uint32_t RXFINF;
    __IO uint32_t RXFDL;
    __IO uint32_t RXFDH;
} CAN_RxFIFO_Typedef;

typedef struct
{
    __IO uint32_t FLT1;
    __IO uint32_t FLT2;
} CAN_Filter_Typedef;

typedef struct
{
    __IO uint32_t CON;
    __I uint32_t STAT;
    __O uint32_t IFC;
    __IO uint32_t TXSTAT;
    __O uint32_t TXSTATC;
    __IO uint32_t RXF0;
    __O uint32_t RXF0C;
    __IO uint32_t RXF1;
    __O uint32_t RXF1C;
    __IO uint32_t IE;
    __IO uint32_t ERRSTAT;
    __IO uint32_t BTIME;
    uint32_t RESERVED0[84] ;
    CAN_TxMailBox_Typedef TxMailBox[3];
    CAN_RxFIFO_Typedef RxFIFO[2];
    uint32_t RESERVED1[12] ;
    __IO uint32_t FLTCON;
    __IO uint32_t FLTM;
    uint32_t RESERVED2 ;
    __IO uint32_t FLTWS;
    uint32_t RESERVED3 ;
    __IO uint32_t FLTAS;
    uint32_t RESERVED4 ;
    __IO uint32_t FLTGO;
    uint32_t RESERVED5[8] ;
    CAN_Filter_Typedef Filter[14];
} CAN_TypeDef;

/****************** Bit definition for CRC_CR register ************************/

#define CRC_CR_BYTORD_POS   24U
#define CRC_CR_BYTORD_MSK   BIT(CRC_CR_BYTORD_POS)

#define CRC_CR_DATLEN_POSS  22U
#define CRC_CR_DATLEN_POSE  23U
#define CRC_CR_DATLEN_MSK   BITS(CRC_CR_DATLEN_POSS,CRC_CR_DATLEN_POSE)

#define CRC_CR_MODE_POSS    20U
#define CRC_CR_MODE_POSE    21U
#define CRC_CR_MODE_MSK BITS(CRC_CR_MODE_POSS,CRC_CR_MODE_POSE)

#define CRC_CR_CHSINV_POS   19U
#define CRC_CR_CHSINV_MSK   BIT(CRC_CR_CHSINV_POS)

#define CRC_CR_DATINV_POS   18U
#define CRC_CR_DATINV_MSK   BIT(CRC_CR_DATINV_POS)

#define CRC_CR_CHSREV_POS   17U
#define CRC_CR_CHSREV_MSK   BIT(CRC_CR_CHSREV_POS)

#define CRC_CR_DATREV_POS   16U
#define CRC_CR_DATREV_MSK   BIT(CRC_CR_DATREV_POS)

#define CRC_CR_DMAEN_POS    4U
#define CRC_CR_DMAEN_MSK    BIT(CRC_CR_DMAEN_POS)

#define CRC_CR_CWERR_POS    3U
#define CRC_CR_CWERR_MSK    BIT(CRC_CR_CWERR_POS)

#define CRC_CR_WERR_POS 2U
#define CRC_CR_WERR_MSK BIT(CRC_CR_WERR_POS)

#define CRC_CR_RST_POS  1U
#define CRC_CR_RST_MSK  BIT(CRC_CR_RST_POS)

#define CRC_CR_EN_POS   0U
#define CRC_CR_EN_MSK   BIT(CRC_CR_EN_POS)

/****************** Bit definition for CRC_DATA register ************************/

#define CRC_DATA_DATA_POSS  0U
#define CRC_DATA_DATA_POSE  31U
#define CRC_DATA_DATA_MSK   BITS(CRC_DATA_DATA_POSS,CRC_DATA_DATA_POSE)

/****************** Bit definition for CRC_SEED register ************************/

#define CRC_SEED_SEED_POSS  0U
#define CRC_SEED_SEED_POSE  31U
#define CRC_SEED_SEED_MSK   BITS(CRC_SEED_SEED_POSS,CRC_SEED_SEED_POSE)

/****************** Bit definition for CRC_CHECKSUM register ************************/

#define CRC_CHECKSUM_CHECKSUM_POSS  0U
#define CRC_CHECKSUM_CHECKSUM_POSE  31U
#define CRC_CHECKSUM_CHECKSUM_MSK   BITS(CRC_CHECKSUM_CHECKSUM_POSS,CRC_CHECKSUM_CHECKSUM_POSE)

typedef struct
{
    __IO uint32_t CR;
    __IO uint32_t DATA;
    __IO uint32_t SEED;
    __I uint32_t CHECKSUM;
} CRC_TypeDef;

/****************** Bit definition for ADC_STAT register ************************/

#define ADC_STAT_ICHS_POS   9U
#define ADC_STAT_ICHS_MSK   BIT(ADC_STAT_ICHS_POS)

#define ADC_STAT_NCHS_POS   8U
#define ADC_STAT_NCHS_MSK   BIT(ADC_STAT_NCHS_POS)

#define ADC_STAT_OVR_POS    3U
#define ADC_STAT_OVR_MSK    BIT(ADC_STAT_OVR_POS)

#define ADC_STAT_ICHE_POS   2U
#define ADC_STAT_ICHE_MSK   BIT(ADC_STAT_ICHE_POS)

#define ADC_STAT_NCHE_POS   1U
#define ADC_STAT_NCHE_MSK   BIT(ADC_STAT_NCHE_POS)

#define ADC_STAT_AWDF_POS   0U
#define ADC_STAT_AWDF_MSK   BIT(ADC_STAT_AWDF_POS)

/****************** Bit definition for ADC_CLR register ************************/

#define ADC_CLR_ICHS_POS    9U
#define ADC_CLR_ICHS_MSK    BIT(ADC_CLR_ICHS_POS)

#define ADC_CLR_NCHS_POS    8U
#define ADC_CLR_NCHS_MSK    BIT(ADC_CLR_NCHS_POS)

#define ADC_CLR_OVR_POS 3U
#define ADC_CLR_OVR_MSK BIT(ADC_CLR_OVR_POS)

#define ADC_CLR_ICHE_POS    2U
#define ADC_CLR_ICHE_MSK    BIT(ADC_CLR_ICHE_POS)

#define ADC_CLR_NCHE_POS    1U
#define ADC_CLR_NCHE_MSK    BIT(ADC_CLR_NCHE_POS)

#define ADC_CLR_AWDF_POS    0U
#define ADC_CLR_AWDF_MSK    BIT(ADC_CLR_AWDF_POS)

/****************** Bit definition for ADC_CON0 register ************************/

#define ADC_CON0_OVRIE_POS  26U
#define ADC_CON0_OVRIE_MSK  BIT(ADC_CON0_OVRIE_POS)

#define ADC_CON0_RSEL_POSS  24U
#define ADC_CON0_RSEL_POSE  25U
#define ADC_CON0_RSEL_MSK   BITS(ADC_CON0_RSEL_POSS,ADC_CON0_RSEL_POSE)

#define ADC_CON0_NCHWDEN_POS    23U
#define ADC_CON0_NCHWDEN_MSK    BIT(ADC_CON0_NCHWDEN_POS)

#define ADC_CON0_ICHWDTEN_POS   22U
#define ADC_CON0_ICHWDTEN_MSK   BIT(ADC_CON0_ICHWDTEN_POS)

#define ADC_CON0_CHTW_POSS  16U
#define ADC_CON0_CHTW_POSE  19U
#define ADC_CON0_CHTW_MSK   BITS(ADC_CON0_CHTW_POSS,ADC_CON0_CHTW_POSE)

#define ADC_CON0_ETRGN_POSS 13U
#define ADC_CON0_ETRGN_POSE 15U
#define ADC_CON0_ETRGN_MSK  BITS(ADC_CON0_ETRGN_POSS,ADC_CON0_ETRGN_POSE)

#define ADC_CON0_ICHDCEN_POS    12U
#define ADC_CON0_ICHDCEN_MSK    BIT(ADC_CON0_ICHDCEN_POS)

#define ADC_CON0_NCHDCEN_POS    11U
#define ADC_CON0_NCHDCEN_MSK    BIT(ADC_CON0_NCHDCEN_POS)

#define ADC_CON0_IAUTO_POS  10U
#define ADC_CON0_IAUTO_MSK  BIT(ADC_CON0_IAUTO_POS)

#define ADC_CON0_AWDSGL_POS 9U
#define ADC_CON0_AWDSGL_MSK BIT(ADC_CON0_AWDSGL_POS)

#define ADC_CON0_SCANEN_POS 8U
#define ADC_CON0_SCANEN_MSK BIT(ADC_CON0_SCANEN_POS)

#define ADC_CON0_ICHEIE_POS 7U
#define ADC_CON0_ICHEIE_MSK BIT(ADC_CON0_ICHEIE_POS)

#define ADC_CON0_AWDIE_POS  6U
#define ADC_CON0_AWDIE_MSK  BIT(ADC_CON0_AWDIE_POS)

#define ADC_CON0_NCHEIE_POS 5U
#define ADC_CON0_NCHEIE_MSK BIT(ADC_CON0_NCHEIE_POS)

#define ADC_CON0_AWDCH_POSS 0U
#define ADC_CON0_AWDCH_POSE 4U
#define ADC_CON0_AWDCH_MSK  BITS(ADC_CON0_AWDCH_POSS,ADC_CON0_AWDCH_POSE)

/****************** Bit definition for ADC_CON1 register ************************/

#define ADC_CON1_NCHTRG_POS 30U
#define ADC_CON1_NCHTRG_MSK BIT(ADC_CON1_NCHTRG_POS)

#define ADC_CON1_NETS_POSS  28U
#define ADC_CON1_NETS_POSE  29U
#define ADC_CON1_NETS_MSK   BITS(ADC_CON1_NETS_POSS,ADC_CON1_NETS_POSE)

#define ADC_CON1_NETP_POSS  24U
#define ADC_CON1_NETP_POSE  27U
#define ADC_CON1_NETP_MSK   BITS(ADC_CON1_NETP_POSS,ADC_CON1_NETP_POSE)

#define ADC_CON1_ICHTRG_POS 22U
#define ADC_CON1_ICHTRG_MSK BIT(ADC_CON1_ICHTRG_POS)

#define ADC_CON1_IETS_POSS  20U
#define ADC_CON1_IETS_POSE  21U
#define ADC_CON1_IETS_MSK   BITS(ADC_CON1_IETS_POSS,ADC_CON1_IETS_POSE)

#define ADC_CON1_IETP_POSS  16U
#define ADC_CON1_IETP_POSE  19U
#define ADC_CON1_IETP_MSK   BITS(ADC_CON1_IETP_POSS,ADC_CON1_IETP_POSE)

#define ADC_CON1_ALIGN_POS  11U
#define ADC_CON1_ALIGN_MSK  BIT(ADC_CON1_ALIGN_POS)

#define ADC_CON1_NCHESEL_POS    10U
#define ADC_CON1_NCHESEL_MSK    BIT(ADC_CON1_NCHESEL_POS)

#define ADC_CON1_DMA_POS    8U
#define ADC_CON1_DMA_MSK    BIT(ADC_CON1_DMA_POS)

#define ADC_CON1_CM_POS 1U
#define ADC_CON1_CM_MSK BIT(ADC_CON1_CM_POS)

#define ADC_CON1_ADCEN_POS  0U
#define ADC_CON1_ADCEN_MSK  BIT(ADC_CON1_ADCEN_POS)

/****************** Bit definition for ADC_SMPT1 register ************************/

#define ADC_SMPT1_CHT_POSS  0U
#define ADC_SMPT1_CHT_POSE  31U
#define ADC_SMPT1_CHT_MSK   BITS(ADC_SMPT1_CHT_POSS,ADC_SMPT1_CHT_POSE)

/****************** Bit definition for ADC_SMPT2 register ************************/

#define ADC_SMPT2_CHT_POSS  0U
#define ADC_SMPT2_CHT_POSE  31U
#define ADC_SMPT2_CHT_MSK   BITS(ADC_SMPT2_CHT_POSS,ADC_SMPT2_CHT_POSE)

/****************** Bit definition for ADC_SMPT3 register ************************/

#define ADC_SMPT3_CHT_POSS  0U
#define ADC_SMPT3_CHT_POSE  15U
#define ADC_SMPT3_CHT_MSK   BITS(ADC_SMPT3_CHT_POSS,ADC_SMPT3_CHT_POSE)

/****************** Bit definition for ADC_NCHOFF register ************************/

#define ADC_NCHOFF_IOFF_POSS    0U
#define ADC_NCHOFF_IOFF_POSE    11U
#define ADC_NCHOFF_IOFF_MSK BITS(ADC_NCHOFF_IOFF_POSS,ADC_NCHOFF_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF1 register ************************/

#define ADC_ICHOFF1_IOFF_POSS   0U
#define ADC_ICHOFF1_IOFF_POSE   11U
#define ADC_ICHOFF1_IOFF_MSK    BITS(ADC_ICHOFF1_IOFF_POSS,ADC_ICHOFF1_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF2 register ************************/

#define ADC_ICHOFF2_IOFF_POSS   0U
#define ADC_ICHOFF2_IOFF_POSE   11U
#define ADC_ICHOFF2_IOFF_MSK    BITS(ADC_ICHOFF2_IOFF_POSS,ADC_ICHOFF2_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF3 register ************************/

#define ADC_ICHOFF3_IOFF_POSS   0U
#define ADC_ICHOFF3_IOFF_POSE   11U
#define ADC_ICHOFF3_IOFF_MSK    BITS(ADC_ICHOFF3_IOFF_POSS,ADC_ICHOFF3_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF4 register ************************/

#define ADC_ICHOFF4_IOFF_POSS   0U
#define ADC_ICHOFF4_IOFF_POSE   11U
#define ADC_ICHOFF4_IOFF_MSK    BITS(ADC_ICHOFF4_IOFF_POSS,ADC_ICHOFF4_IOFF_POSE)

/****************** Bit definition for ADC_NCHS1 register ************************/

#define ADC_NCHS1_NS4_POSS  24U
#define ADC_NCHS1_NS4_POSE  28U
#define ADC_NCHS1_NS4_MSK   BITS(ADC_NCHS1_NS4_POSS,ADC_NCHS1_NS4_POSE)

#define ADC_NCHS1_NS3_POSS  16U
#define ADC_NCHS1_NS3_POSE  20U
#define ADC_NCHS1_NS3_MSK   BITS(ADC_NCHS1_NS3_POSS,ADC_NCHS1_NS3_POSE)

#define ADC_NCHS1_NS2_POSS  8U
#define ADC_NCHS1_NS2_POSE  12U
#define ADC_NCHS1_NS2_MSK   BITS(ADC_NCHS1_NS2_POSS,ADC_NCHS1_NS2_POSE)

#define ADC_NCHS1_NS1_POSS  0U
#define ADC_NCHS1_NS1_POSE  4U
#define ADC_NCHS1_NS1_MSK   BITS(ADC_NCHS1_NS1_POSS,ADC_NCHS1_NS1_POSE)

/****************** Bit definition for ADC_NCHS2 register ************************/

#define ADC_NCHS2_NS8_POSS  24U
#define ADC_NCHS2_NS8_POSE  28U
#define ADC_NCHS2_NS8_MSK   BITS(ADC_NCHS2_NS8_POSS,ADC_NCHS2_NS8_POSE)

#define ADC_NCHS2_NS7_POSS  16U
#define ADC_NCHS2_NS7_POSE  20U
#define ADC_NCHS2_NS7_MSK   BITS(ADC_NCHS2_NS7_POSS,ADC_NCHS2_NS7_POSE)

#define ADC_NCHS2_NS6_POSS  8U
#define ADC_NCHS2_NS6_POSE  12U
#define ADC_NCHS2_NS6_MSK   BITS(ADC_NCHS2_NS6_POSS,ADC_NCHS2_NS6_POSE)

#define ADC_NCHS2_NS5_POSS  0U
#define ADC_NCHS2_NS5_POSE  4U
#define ADC_NCHS2_NS5_MSK   BITS(ADC_NCHS2_NS5_POSS,ADC_NCHS2_NS5_POSE)

/****************** Bit definition for ADC_NCHS3 register ************************/

#define ADC_NCHS3_NS12_POSS 24U
#define ADC_NCHS3_NS12_POSE 28U
#define ADC_NCHS3_NS12_MSK  BITS(ADC_NCHS3_NS12_POSS,ADC_NCHS3_NS12_POSE)

#define ADC_NCHS3_NS11_POSS 16U
#define ADC_NCHS3_NS11_POSE 20U
#define ADC_NCHS3_NS11_MSK  BITS(ADC_NCHS3_NS11_POSS,ADC_NCHS3_NS11_POSE)

#define ADC_NCHS3_NS10_POSS 8U
#define ADC_NCHS3_NS10_POSE 12U
#define ADC_NCHS3_NS10_MSK  BITS(ADC_NCHS3_NS10_POSS,ADC_NCHS3_NS10_POSE)

#define ADC_NCHS3_NS9_POSS  0U
#define ADC_NCHS3_NS9_POSE  4U
#define ADC_NCHS3_NS9_MSK   BITS(ADC_NCHS3_NS9_POSS,ADC_NCHS3_NS9_POSE)

/****************** Bit definition for ADC_NCHS4 register ************************/

#define ADC_NCHS4_NS16_POSS 24U
#define ADC_NCHS4_NS16_POSE 28U
#define ADC_NCHS4_NS16_MSK  BITS(ADC_NCHS4_NS16_POSS,ADC_NCHS4_NS16_POSE)

#define ADC_NCHS4_NS15_POSS 16U
#define ADC_NCHS4_NS15_POSE 20U
#define ADC_NCHS4_NS15_MSK  BITS(ADC_NCHS4_NS15_POSS,ADC_NCHS4_NS15_POSE)

#define ADC_NCHS4_NS14_POSS 8U
#define ADC_NCHS4_NS14_POSE 12U
#define ADC_NCHS4_NS14_MSK  BITS(ADC_NCHS4_NS14_POSS,ADC_NCHS4_NS14_POSE)

#define ADC_NCHS4_NS13_POSS 0U
#define ADC_NCHS4_NS13_POSE 4U
#define ADC_NCHS4_NS13_MSK  BITS(ADC_NCHS4_NS13_POSS,ADC_NCHS4_NS13_POSE)

/****************** Bit definition for ADC_ICHS register ************************/

#define ADC_ICHS_IS4_POSS   24U
#define ADC_ICHS_IS4_POSE   28U
#define ADC_ICHS_IS4_MSK    BITS(ADC_ICHS_IS4_POSS,ADC_ICHS_IS4_POSE)

#define ADC_ICHS_IS3_POSS   16U
#define ADC_ICHS_IS3_POSE   20U
#define ADC_ICHS_IS3_MSK    BITS(ADC_ICHS_IS3_POSS,ADC_ICHS_IS3_POSE)

#define ADC_ICHS_IS2_POSS   8U
#define ADC_ICHS_IS2_POSE   12U
#define ADC_ICHS_IS2_MSK    BITS(ADC_ICHS_IS2_POSS,ADC_ICHS_IS2_POSE)

#define ADC_ICHS_IS1_POSS   0U
#define ADC_ICHS_IS1_POSE   4U
#define ADC_ICHS_IS1_MSK    BITS(ADC_ICHS_IS1_POSS,ADC_ICHS_IS1_POSE)

/****************** Bit definition for ADC_CHSL register ************************/

#define ADC_CHSL_ISL_POSS   8U
#define ADC_CHSL_ISL_POSE   9U
#define ADC_CHSL_ISL_MSK    BITS(ADC_CHSL_ISL_POSS,ADC_CHSL_ISL_POSE)

#define ADC_CHSL_NSL_POSS   0U
#define ADC_CHSL_NSL_POSE   3U
#define ADC_CHSL_NSL_MSK    BITS(ADC_CHSL_NSL_POSS,ADC_CHSL_NSL_POSE)

/****************** Bit definition for ADC_WDTH register ************************/

#define ADC_WDTH_HT_POSS    0U
#define ADC_WDTH_HT_POSE    11U
#define ADC_WDTH_HT_MSK BITS(ADC_WDTH_HT_POSS,ADC_WDTH_HT_POSE)

/****************** Bit definition for ADC_WDTL register ************************/

#define ADC_WDTL_LT_POSS    0U
#define ADC_WDTL_LT_POSE    11U
#define ADC_WDTL_LT_MSK BITS(ADC_WDTL_LT_POSS,ADC_WDTL_LT_POSE)

/****************** Bit definition for ADC_ICHDR1 register ************************/

#define ADC_ICHDR1_VAL_POSS 0U
#define ADC_ICHDR1_VAL_POSE 15U
#define ADC_ICHDR1_VAL_MSK  BITS(ADC_ICHDR1_VAL_POSS,ADC_ICHDR1_VAL_POSE)

/****************** Bit definition for ADC_ICHDR2 register ************************/

#define ADC_ICHDR2_VAL_POSS 0U
#define ADC_ICHDR2_VAL_POSE 15U
#define ADC_ICHDR2_VAL_MSK  BITS(ADC_ICHDR2_VAL_POSS,ADC_ICHDR2_VAL_POSE)

/****************** Bit definition for ADC_ICHDR3 register ************************/

#define ADC_ICHDR3_VAL_POSS 0U
#define ADC_ICHDR3_VAL_POSE 15U
#define ADC_ICHDR3_VAL_MSK  BITS(ADC_ICHDR3_VAL_POSS,ADC_ICHDR3_VAL_POSE)

/****************** Bit definition for ADC_ICHDR4 register ************************/

#define ADC_ICHDR4_VAL_POSS 0U
#define ADC_ICHDR4_VAL_POSE 15U
#define ADC_ICHDR4_VAL_MSK  BITS(ADC_ICHDR4_VAL_POSS,ADC_ICHDR4_VAL_POSE)

/****************** Bit definition for ADC_NCHDR register ************************/

#define ADC_NCHDR_VAL_POSS  0U
#define ADC_NCHDR_VAL_POSE  15U
#define ADC_NCHDR_VAL_MSK   BITS(ADC_NCHDR_VAL_POSS,ADC_NCHDR_VAL_POSE)

/****************** Bit definition for ADC_CCR register ************************/

#define ADC_CCR_TRMEN_POS   28U
#define ADC_CCR_TRMEN_MSK   BIT(ADC_CCR_TRMEN_POS)

#define ADC_CCR_TSEN_POS    20U
#define ADC_CCR_TSEN_MSK    BIT(ADC_CCR_TSEN_POS)

#define ADC_CCR_VRNSEL_POS  18U
#define ADC_CCR_VRNSEL_MSK  BIT(ADC_CCR_VRNSEL_POS)

#define ADC_CCR_VRPSEL_POSS 16U
#define ADC_CCR_VRPSEL_POSE 17U
#define ADC_CCR_VRPSEL_MSK  BITS(ADC_CCR_VRPSEL_POSS,ADC_CCR_VRPSEL_POSE)

#define ADC_CCR_PMSEL_POS   15U
#define ADC_CCR_PMSEL_MSK   BIT(ADC_CCR_PMSEL_POS)

#define ADC_CCR_CKSEL_POSS  4U
#define ADC_CCR_CKSEL_POSE  6U
#define ADC_CCR_CKSEL_MSK   BITS(ADC_CCR_CKSEL_POSS,ADC_CCR_CKSEL_POSE)

#define ADC_CCR_CKDIV_POSS  0U
#define ADC_CCR_CKDIV_POSE  2U
#define ADC_CCR_CKDIV_MSK   BITS(ADC_CCR_CKDIV_POSS,ADC_CCR_CKDIV_POSE)

/****************** Bit definition for ADC_VRCFG register ************************/

#define ADC_VRCFG_VAL_POSS  0U
#define ADC_VRCFG_VAL_POSE  15U
#define ADC_VRCFG_VAL_MSK   BITS(ADC_VRCFG_VAL_POSS,ADC_VRCFG_VAL_POSE)

typedef struct
{
    __I uint32_t STAT;
    __O uint32_t CLR;
    __IO uint32_t CON0;
    __IO uint32_t CON1;
    __IO uint32_t SMPT1;
    __IO uint32_t SMPT2;
    __IO uint32_t SMPT3;
    __IO uint32_t NCHOFF;
    __IO uint32_t ICHOFF1;
    __IO uint32_t ICHOFF2;
    __IO uint32_t ICHOFF3;
    __IO uint32_t ICHOFF4;
    __IO uint32_t NCHS1;
    __IO uint32_t NCHS2;
    __IO uint32_t NCHS3;
    __IO uint32_t NCHS4;
    __IO uint32_t ICHS;
    __IO uint32_t CHSL;
    __IO uint32_t WDTH;
    __IO uint32_t WDTL;
    __I uint32_t ICHDR1;
    __I uint32_t ICHDR2;
    __I uint32_t ICHDR3;
    __I uint32_t ICHDR4;
    __I uint32_t NCHDR;
    __IO uint32_t CCR;
    __IO uint32_t VRCFG;
} ADC_TypeDef;

/****************** Bit definition for CALC_OPA register ************************/

#define CALC_OPA_VAL_POSS   0U
#define CALC_OPA_VAL_POSE   31U
#define CALC_OPA_VAL_MSK    BITS(CALC_OPA_VAL_POSS,CALC_OPA_VAL_POSE)

/****************** Bit definition for CALC_OPB register ************************/

#define CALC_OPB_VAL_POSS   0U
#define CALC_OPB_VAL_POSE   31U
#define CALC_OPB_VAL_MSK    BITS(CALC_OPB_VAL_POSS,CALC_OPB_VAL_POSE)

/****************** Bit definition for CALC_RESA register ************************/

#define CALC_RESA_VAL_POSS  0U
#define CALC_RESA_VAL_POSE  31U
#define CALC_RESA_VAL_MSK   BITS(CALC_RESA_VAL_POSS,CALC_RESA_VAL_POSE)

/****************** Bit definition for CALC_RESB register ************************/

#define CALC_RESB_VAL_POSS  0U
#define CALC_RESB_VAL_POSE  31U
#define CALC_RESB_VAL_MSK   BITS(CALC_RESB_VAL_POSS,CALC_RESB_VAL_POSE)

/****************** Bit definition for CALC_CSR register ************************/

#define CALC_CSR_TRM_POS    10U
#define CALC_CSR_TRM_MSK    BIT(CALC_CSR_TRM_POS)

#define CALC_CSR_MODE_POSS  8U
#define CALC_CSR_MODE_POSE  9U
#define CALC_CSR_MODE_MSK   BITS(CALC_CSR_MODE_POSS,CALC_CSR_MODE_POSE)

#define CALC_CSR_DZ_POS 1U
#define CALC_CSR_DZ_MSK BIT(CALC_CSR_DZ_POS)

#define CALC_CSR_BUSY_POS   0U
#define CALC_CSR_BUSY_MSK   BIT(CALC_CSR_BUSY_POS)

typedef struct
{
    __IO uint32_t OPA;
    __IO uint32_t OPB;
    __I uint32_t RESA;
    __I uint32_t RESB;
    __IO uint32_t CSR;
} CALC_TypeDef;

/****************** Bit definition for IWDT_LOAD register ************************/

#define IWDT_LOAD_LOAD_POSS 0U
#define IWDT_LOAD_LOAD_POSE 31U
#define IWDT_LOAD_LOAD_MSK  BITS(IWDT_LOAD_LOAD_POSS,IWDT_LOAD_LOAD_POSE)

/****************** Bit definition for IWDT_VALUE register ************************/

#define IWDT_VALUE_VALUE_POSS   0U
#define IWDT_VALUE_VALUE_POSE   31U
#define IWDT_VALUE_VALUE_MSK    BITS(IWDT_VALUE_VALUE_POSS,IWDT_VALUE_VALUE_POSE)

/****************** Bit definition for IWDT_CON register ************************/

#define IWDT_CON_CLKS_POS   3U
#define IWDT_CON_CLKS_MSK   BIT(IWDT_CON_CLKS_POS)

#define IWDT_CON_RSTEN_POS  2U
#define IWDT_CON_RSTEN_MSK  BIT(IWDT_CON_RSTEN_POS)

#define IWDT_CON_IE_POS 1U
#define IWDT_CON_IE_MSK BIT(IWDT_CON_IE_POS)

#define IWDT_CON_EN_POS 0U
#define IWDT_CON_EN_MSK BIT(IWDT_CON_EN_POS)

/****************** Bit definition for IWDT_INTCLR register ************************/

#define IWDT_INTCLR_INTCLR_POSS 0U
#define IWDT_INTCLR_INTCLR_POSE 31U
#define IWDT_INTCLR_INTCLR_MSK  BITS(IWDT_INTCLR_INTCLR_POSS,IWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for IWDT_RIS register ************************/

#define IWDT_RIS_WDTIF_POS  0U
#define IWDT_RIS_WDTIF_MSK  BIT(IWDT_RIS_WDTIF_POS)

/****************** Bit definition for IWDT_LOCK register ************************/

#define IWDT_LOCK_LOCK_POS  0U
#define IWDT_LOCK_LOCK_MSK  BIT(IWDT_LOCK_LOCK_POS)

typedef struct
{
    __IO uint32_t LOAD;
    __IO uint32_t VALUE;
    __IO uint32_t CON;
    __O uint32_t INTCLR;
    __I uint32_t RIS;
    uint32_t RESERVED0[59] ;
    __IO uint32_t LOCK;
} IWDT_TypeDef;

/****************** Bit definition for WWDT_LOAD register ************************/

#define WWDT_LOAD_LOAD_POSS 0U
#define WWDT_LOAD_LOAD_POSE 31U
#define WWDT_LOAD_LOAD_MSK  BITS(WWDT_LOAD_LOAD_POSS,WWDT_LOAD_LOAD_POSE)

/****************** Bit definition for WWDT_VALUE register ************************/

#define WWDT_VALUE_VALUE_POSS   0U
#define WWDT_VALUE_VALUE_POSE   31U
#define WWDT_VALUE_VALUE_MSK    BITS(WWDT_VALUE_VALUE_POSS,WWDT_VALUE_VALUE_POSE)

/****************** Bit definition for WWDT_CON register ************************/

#define WWDT_CON_WWDTWIN_POSS   4U
#define WWDT_CON_WWDTWIN_POSE   5U
#define WWDT_CON_WWDTWIN_MSK    BITS(WWDT_CON_WWDTWIN_POSS,WWDT_CON_WWDTWIN_POSE)

#define WWDT_CON_CLKS_POS   3U
#define WWDT_CON_CLKS_MSK   BIT(WWDT_CON_CLKS_POS)

#define WWDT_CON_RSTEN_POS  2U
#define WWDT_CON_RSTEN_MSK  BIT(WWDT_CON_RSTEN_POS)

#define WWDT_CON_IE_POS 1U
#define WWDT_CON_IE_MSK BIT(WWDT_CON_IE_POS)

#define WWDT_CON_EN_POS 0U
#define WWDT_CON_EN_MSK BIT(WWDT_CON_EN_POS)

/****************** Bit definition for WWDT_INTCLR register ************************/

#define WWDT_INTCLR_INTCLR_POSS 0U
#define WWDT_INTCLR_INTCLR_POSE 31U
#define WWDT_INTCLR_INTCLR_MSK  BITS(WWDT_INTCLR_INTCLR_POSS,WWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for WWDT_RIS register ************************/

#define WWDT_RIS_WWDTIF_POS 0U
#define WWDT_RIS_WWDTIF_MSK BIT(WWDT_RIS_WWDTIF_POS)

/****************** Bit definition for WWDT_LOCK register ************************/

#define WWDT_LOCK_LOCK_POS  0U
#define WWDT_LOCK_LOCK_MSK  BIT(WWDT_LOCK_LOCK_POS)

typedef struct
{
    __O uint32_t LOAD;
    __IO uint32_t VALUE;
    __IO uint32_t CON;
    __O uint32_t INTCLR;
    __I uint32_t RIS;
    uint32_t RESERVED0[59];
    __IO uint32_t LOCK;
} WWDT_TypeDef;

/****************** Bit definition for LPUART_CON0 register ************************/

#define LPUART_CON0_MODESEL_POSS    30U
#define LPUART_CON0_MODESEL_POSE    31U
#define LPUART_CON0_MODESEL_MSK BITS(LPUART_CON0_MODESEL_POSS,LPUART_CON0_MODESEL_POSE)

#define LPUART_CON0_TXDMAE_POS  29U
#define LPUART_CON0_TXDMAE_MSK  BIT(LPUART_CON0_TXDMAE_POS)

#define LPUART_CON0_RXDMAE_POS  28U
#define LPUART_CON0_RXDMAE_MSK  BIT(LPUART_CON0_RXDMAE_POS)

#define LPUART_CON0_INTERVAL_POSS   16U
#define LPUART_CON0_INTERVAL_POSE   23U
#define LPUART_CON0_INTERVAL_MSK    BITS(LPUART_CON0_INTERVAL_POSS,LPUART_CON0_INTERVAL_POSE)

#define LPUART_CON0_CTSPOL_POS  13U
#define LPUART_CON0_CTSPOL_MSK  BIT(LPUART_CON0_CTSPOL_POS)

#define LPUART_CON0_RTSPOL_POS  12U
#define LPUART_CON0_RTSPOL_MSK  BIT(LPUART_CON0_RTSPOL_POS)

#define LPUART_CON0_ATCTSE_POS  11U
#define LPUART_CON0_ATCTSE_MSK  BIT(LPUART_CON0_ATCTSE_POS)

#define LPUART_CON0_ATRTSE_POS  10U
#define LPUART_CON0_ATRTSE_MSK  BIT(LPUART_CON0_ATRTSE_POS)

#define LPUART_CON0_BRKCE_POS   8U
#define LPUART_CON0_BRKCE_MSK   BIT(LPUART_CON0_BRKCE_POS)

#define LPUART_CON0_LPBMOD_POS  7U
#define LPUART_CON0_LPBMOD_MSK  BIT(LPUART_CON0_LPBMOD_POS)

#define LPUART_CON0_STICKPARSEL_POS 6U
#define LPUART_CON0_STICKPARSEL_MSK BIT(LPUART_CON0_STICKPARSEL_POS)

#define LPUART_CON0_EVENPARSEL_POS  5U
#define LPUART_CON0_EVENPARSEL_MSK  BIT(LPUART_CON0_EVENPARSEL_POS)

#define LPUART_CON0_PARCHKE_POS 4U
#define LPUART_CON0_PARCHKE_MSK BIT(LPUART_CON0_PARCHKE_POS)

#define LPUART_CON0_STPLENTH_POS    3U
#define LPUART_CON0_STPLENTH_MSK    BIT(LPUART_CON0_STPLENTH_POS)

#define LPUART_CON0_DATLENTH_POSS   0U
#define LPUART_CON0_DATLENTH_POSE   2U
#define LPUART_CON0_DATLENTH_MSK    BITS(LPUART_CON0_DATLENTH_POSS,LPUART_CON0_DATLENTH_POSE)

/****************** Bit definition for LPUART_CON1 register ************************/

#define LPUART_CON1_ADDCMP_POSS 24U
#define LPUART_CON1_ADDCMP_POSE 31U
#define LPUART_CON1_ADDCMP_MSK  BITS(LPUART_CON1_ADDCMP_POSS,LPUART_CON1_ADDCMP_POSE)

#define LPUART_CON1_ADETE_POS   23U
#define LPUART_CON1_ADETE_MSK   BIT(LPUART_CON1_ADETE_POS)

#define LPUART_CON1_ATDIRM_POS  22U
#define LPUART_CON1_ATDIRM_MSK  BIT(LPUART_CON1_ATDIRM_POS)

#define LPUART_CON1_ATADETE_POS 21U
#define LPUART_CON1_ATADETE_MSK BIT(LPUART_CON1_ATADETE_POS)

#define LPUART_CON1_NMPMOD_POS  20U
#define LPUART_CON1_NMPMOD_MSK  BIT(LPUART_CON1_NMPMOD_POS)

#define LPUART_CON1_IRWIDTH_POS 16U
#define LPUART_CON1_IRWIDTH_MSK BIT(LPUART_CON1_IRWIDTH_POS)

#define LPUART_CON1_TOICMP_POSS 8U
#define LPUART_CON1_TOICMP_POSE 15U
#define LPUART_CON1_TOICMP_MSK  BITS(LPUART_CON1_TOICMP_POSS,LPUART_CON1_TOICMP_POSE)

#define LPUART_CON1_TOCNTE_POS  7U
#define LPUART_CON1_TOCNTE_MSK  BIT(LPUART_CON1_TOCNTE_POS)

#define LPUART_CON1_IRTXINV_POS 3U
#define LPUART_CON1_IRTXINV_MSK BIT(LPUART_CON1_IRTXINV_POS)

#define LPUART_CON1_IRRXINV_POS 2U
#define LPUART_CON1_IRRXINV_MSK BIT(LPUART_CON1_IRRXINV_POS)

#define LPUART_CON1_IRTXE_POS   1U
#define LPUART_CON1_IRTXE_MSK   BIT(LPUART_CON1_IRTXE_POS)

#define LPUART_CON1_RTS_POS 0U
#define LPUART_CON1_RTS_MSK BIT(LPUART_CON1_RTS_POS)

/****************** Bit definition for LPUART_CLKDIV register ************************/

#define LPUART_CLKDIV_CLKDIV_POSS   0U
#define LPUART_CLKDIV_CLKDIV_POSE   19U
#define LPUART_CLKDIV_CLKDIV_MSK    BITS(LPUART_CLKDIV_CLKDIV_POSS,LPUART_CLKDIV_CLKDIV_POSE)

/****************** Bit definition for LPUART_FIFOCON register ************************/

#define LPUART_FIFOCON_RTSTRGLVL_POSS   12U
#define LPUART_FIFOCON_RTSTRGLVL_POSE   15U
#define LPUART_FIFOCON_RTSTRGLVL_MSK    BITS(LPUART_FIFOCON_RTSTRGLVL_POSS,LPUART_FIFOCON_RTSTRGLVL_POSE)

#define LPUART_FIFOCON_RXTRGLVL_POSS    8U
#define LPUART_FIFOCON_RXTRGLVL_POSE    11U
#define LPUART_FIFOCON_RXTRGLVL_MSK BITS(LPUART_FIFOCON_RXTRGLVL_POSS,LPUART_FIFOCON_RXTRGLVL_POSE)

#define LPUART_FIFOCON_NMPMRXDIS_POS    2U
#define LPUART_FIFOCON_NMPMRXDIS_MSK    BIT(LPUART_FIFOCON_NMPMRXDIS_POS)

#define LPUART_FIFOCON_TXRESET_POS  1U
#define LPUART_FIFOCON_TXRESET_MSK  BIT(LPUART_FIFOCON_TXRESET_POS)

#define LPUART_FIFOCON_RXRESET_POS  0U
#define LPUART_FIFOCON_RXRESET_MSK  BIT(LPUART_FIFOCON_RXRESET_POS)

/****************** Bit definition for LPUART_RXDR register ************************/

#define LPUART_RXDR_FERR_POS    15U
#define LPUART_RXDR_FERR_MSK    BIT(LPUART_RXDR_FERR_POS)

#define LPUART_RXDR_PERR_POS    14U
#define LPUART_RXDR_PERR_MSK    BIT(LPUART_RXDR_PERR_POS)

#define LPUART_RXDR_RXDR_POSS   0U
#define LPUART_RXDR_RXDR_POSE   8U
#define LPUART_RXDR_RXDR_MSK    BITS(LPUART_RXDR_RXDR_POSS,LPUART_RXDR_RXDR_POSE)

/****************** Bit definition for LPUART_TXDR register ************************/

#define LPUART_TXDR_TXDR_POSS   0U
#define LPUART_TXDR_TXDR_POSE   8U
#define LPUART_TXDR_TXDR_MSK    BITS(LPUART_TXDR_TXDR_POSS,LPUART_TXDR_TXDR_POSE)

/****************** Bit definition for LPUART_STAT register ************************/

#define LPUART_STAT_RTSSTAT_POS 18U
#define LPUART_STAT_RTSSTAT_MSK BIT(LPUART_STAT_RTSSTAT_POS)

#define LPUART_STAT_CTSSTAT_POS 17U
#define LPUART_STAT_CTSSTAT_MSK BIT(LPUART_STAT_CTSSTAT_POS)

#define LPUART_STAT_TXIDLE_POS  16U
#define LPUART_STAT_TXIDLE_MSK  BIT(LPUART_STAT_TXIDLE_POS)

#define LPUART_STAT_TXFULL_POS  15U
#define LPUART_STAT_TXFULL_MSK  BIT(LPUART_STAT_TXFULL_POS)

#define LPUART_STAT_TXEMP_POS   14U
#define LPUART_STAT_TXEMP_MSK   BIT(LPUART_STAT_TXEMP_POS)

#define LPUART_STAT_TXPTR_POSS  8U
#define LPUART_STAT_TXPTR_POSE  13U
#define LPUART_STAT_TXPTR_MSK   BITS(LPUART_STAT_TXPTR_POSS,LPUART_STAT_TXPTR_POSE)

#define LPUART_STAT_RXFULL_POS  7U
#define LPUART_STAT_RXFULL_MSK  BIT(LPUART_STAT_RXFULL_POS)

#define LPUART_STAT_RXEMP_POS   6U
#define LPUART_STAT_RXEMP_MSK   BIT(LPUART_STAT_RXEMP_POS)

#define LPUART_STAT_RXPTR_POSS  0U
#define LPUART_STAT_RXPTR_POSE  5U
#define LPUART_STAT_RXPTR_MSK   BITS(LPUART_STAT_RXPTR_POSS,LPUART_STAT_RXPTR_POSE)

/****************** Bit definition for LPUART_IER register ************************/

#define LPUART_IER_TCIE_POS 15U
#define LPUART_IER_TCIE_MSK BIT(LPUART_IER_TCIE_POS)

#define LPUART_IER_ADETIE_POS   12U
#define LPUART_IER_ADETIE_MSK   BIT(LPUART_IER_ADETIE_POS)

#define LPUART_IER_BRKERRIE_POS 11U
#define LPUART_IER_BRKERRIE_MSK BIT(LPUART_IER_BRKERRIE_POS)

#define LPUART_IER_FERRIE_POS   10U
#define LPUART_IER_FERRIE_MSK   BIT(LPUART_IER_FERRIE_POS)

#define LPUART_IER_PERRIE_POS   9U
#define LPUART_IER_PERRIE_MSK   BIT(LPUART_IER_PERRIE_POS)

#define LPUART_IER_DATWKIE_POS  8U
#define LPUART_IER_DATWKIE_MSK  BIT(LPUART_IER_DATWKIE_POS)

#define LPUART_IER_CTSWKIE_POS  7U
#define LPUART_IER_CTSWKIE_MSK  BIT(LPUART_IER_CTSWKIE_POS)

#define LPUART_IER_TXOVIE_POS   5U
#define LPUART_IER_TXOVIE_MSK   BIT(LPUART_IER_TXOVIE_POS)

#define LPUART_IER_RXOVIE_POS   4U
#define LPUART_IER_RXOVIE_MSK   BIT(LPUART_IER_RXOVIE_POS)

#define LPUART_IER_RXTOIE_POS   3U
#define LPUART_IER_RXTOIE_MSK   BIT(LPUART_IER_RXTOIE_POS)

#define LPUART_IER_CTSDETIE_POS 2U
#define LPUART_IER_CTSDETIE_MSK BIT(LPUART_IER_CTSDETIE_POS)

#define LPUART_IER_TBEMPIE_POS  1U
#define LPUART_IER_TBEMPIE_MSK  BIT(LPUART_IER_TBEMPIE_POS)

#define LPUART_IER_RBRIE_POS    0U
#define LPUART_IER_RBRIE_MSK    BIT(LPUART_IER_RBRIE_POS)

/****************** Bit definition for LPUART_IFLAG register ************************/

#define LPUART_IFLAG_TCIF_POS   15U
#define LPUART_IFLAG_TCIF_MSK   BIT(LPUART_IFLAG_TCIF_POS)

#define LPUART_IFLAG_ADETIF_POS 12U
#define LPUART_IFLAG_ADETIF_MSK BIT(LPUART_IFLAG_ADETIF_POS)

#define LPUART_IFLAG_BRKERRIF_POS   11U
#define LPUART_IFLAG_BRKERRIF_MSK   BIT(LPUART_IFLAG_BRKERRIF_POS)

#define LPUART_IFLAG_FERRIF_POS 10U
#define LPUART_IFLAG_FERRIF_MSK BIT(LPUART_IFLAG_FERRIF_POS)

#define LPUART_IFLAG_PERRIF_POS 9U
#define LPUART_IFLAG_PERRIF_MSK BIT(LPUART_IFLAG_PERRIF_POS)

#define LPUART_IFLAG_DATWKIF_POS    8U
#define LPUART_IFLAG_DATWKIF_MSK    BIT(LPUART_IFLAG_DATWKIF_POS)

#define LPUART_IFLAG_CTSWKIF_POS    7U
#define LPUART_IFLAG_CTSWKIF_MSK    BIT(LPUART_IFLAG_CTSWKIF_POS)

#define LPUART_IFLAG_TXOVIF_POS 5U
#define LPUART_IFLAG_TXOVIF_MSK BIT(LPUART_IFLAG_TXOVIF_POS)

#define LPUART_IFLAG_RXOVIF_POS 4U
#define LPUART_IFLAG_RXOVIF_MSK BIT(LPUART_IFLAG_RXOVIF_POS)

#define LPUART_IFLAG_RXTOIF_POS 3U
#define LPUART_IFLAG_RXTOIF_MSK BIT(LPUART_IFLAG_RXTOIF_POS)

#define LPUART_IFLAG_CTSDETIF_POS   2U
#define LPUART_IFLAG_CTSDETIF_MSK   BIT(LPUART_IFLAG_CTSDETIF_POS)

#define LPUART_IFLAG_TBEMPIF_POS    1U
#define LPUART_IFLAG_TBEMPIF_MSK    BIT(LPUART_IFLAG_TBEMPIF_POS)

#define LPUART_IFLAG_RBRIF_POS  0U
#define LPUART_IFLAG_RBRIF_MSK  BIT(LPUART_IFLAG_RBRIF_POS)

/****************** Bit definition for LPUART_IFC register ************************/

#define LPUART_IFC_TCIFC_POS    15U
#define LPUART_IFC_TCIFC_MSK    BIT(LPUART_IFC_TCIFC_POS)

#define LPUART_IFC_ADETIFC_POS  12U
#define LPUART_IFC_ADETIFC_MSK  BIT(LPUART_IFC_ADETIFC_POS)

#define LPUART_IFC_BRKERRIFC_POS    11U
#define LPUART_IFC_BRKERRIFC_MSK    BIT(LPUART_IFC_BRKERRIFC_POS)

#define LPUART_IFC_FERRIFC_POS  10U
#define LPUART_IFC_FERRIFC_MSK  BIT(LPUART_IFC_FERRIFC_POS)

#define LPUART_IFC_PERRIFC_POS  9U
#define LPUART_IFC_PERRIFC_MSK  BIT(LPUART_IFC_PERRIFC_POS)

#define LPUART_IFC_DATWKIFC_POS 8U
#define LPUART_IFC_DATWKIFC_MSK BIT(LPUART_IFC_DATWKIFC_POS)

#define LPUART_IFC_CTSWKIFC_POS 7U
#define LPUART_IFC_CTSWKIFC_MSK BIT(LPUART_IFC_CTSWKIFC_POS)

#define LPUART_IFC_TXOVIFC_POS  5U
#define LPUART_IFC_TXOVIFC_MSK  BIT(LPUART_IFC_TXOVIFC_POS)

#define LPUART_IFC_RXOVIFC_POS  4U
#define LPUART_IFC_RXOVIFC_MSK  BIT(LPUART_IFC_RXOVIFC_POS)

#define LPUART_IFC_CTSDETIFC_POS    2U
#define LPUART_IFC_CTSDETIFC_MSK    BIT(LPUART_IFC_CTSDETIFC_POS)

#define LPUART_IFC_TBEMPIFC_POS 1U
#define LPUART_IFC_TBEMPIFC_MSK BIT(LPUART_IFC_TBEMPIFC_POS)

#define LPUART_IFC_RBRIFC_POS   0U
#define LPUART_IFC_RBRIFC_MSK   BIT(LPUART_IFC_RBRIFC_POS)

/****************** Bit definition for LPUART_ISTAT register ************************/

#define LPUART_ISTAT_TCINT_POS  15U
#define LPUART_ISTAT_TCINT_MSK  BIT(LPUART_ISTAT_TCINT_POS)

#define LPUART_ISTAT_RXSTATINT_POS  9U
#define LPUART_ISTAT_RXSTATINT_MSK  BIT(LPUART_ISTAT_RXSTATINT_POS)

#define LPUART_ISTAT_DATWKINT_POS   8U
#define LPUART_ISTAT_DATWKINT_MSK   BIT(LPUART_ISTAT_DATWKINT_POS)

#define LPUART_ISTAT_CTSWKINT_POS   7U
#define LPUART_ISTAT_CTSWKINT_MSK   BIT(LPUART_ISTAT_CTSWKINT_POS)

#define LPUART_ISTAT_BUFERRINT_POS  4U
#define LPUART_ISTAT_BUFERRINT_MSK  BIT(LPUART_ISTAT_BUFERRINT_POS)

#define LPUART_ISTAT_RXTOINT_POS    3U
#define LPUART_ISTAT_RXTOINT_MSK    BIT(LPUART_ISTAT_RXTOINT_POS)

#define LPUART_ISTAT_CTSDETINT_POS  2U
#define LPUART_ISTAT_CTSDETINT_MSK  BIT(LPUART_ISTAT_CTSDETINT_POS)

#define LPUART_ISTAT_TBEMPINT_POS   1U
#define LPUART_ISTAT_TBEMPINT_MSK   BIT(LPUART_ISTAT_TBEMPINT_POS)

#define LPUART_ISTAT_RBRINT_POS 0U
#define LPUART_ISTAT_RBRINT_MSK BIT(LPUART_ISTAT_RBRINT_POS)

/****************** Bit definition for LPUART_UPDATE register ************************/

#define LPUART_UPDATE_UDIS_POS  0U
#define LPUART_UPDATE_UDIS_MSK  BIT(LPUART_UPDATE_UDIS_POS)

/****************** Bit definition for LPUART_SYNCSTAT register ************************/

#define LPUART_SYNCSTAT_FIFOCONWBSY_POS 3U
#define LPUART_SYNCSTAT_FIFOCONWBSY_MSK BIT(LPUART_SYNCSTAT_FIFOCONWBSY_POS)

#define LPUART_SYNCSTAT_CLKDIVWBSY_POS  2U
#define LPUART_SYNCSTAT_CLKDIVWBSY_MSK  BIT(LPUART_SYNCSTAT_CLKDIVWBSY_POS)

#define LPUART_SYNCSTAT_CON1WBSY_POS    1U
#define LPUART_SYNCSTAT_CON1WBSY_MSK    BIT(LPUART_SYNCSTAT_CON1WBSY_POS)

#define LPUART_SYNCSTAT_CON0WBSY_POS    0U
#define LPUART_SYNCSTAT_CON0WBSY_MSK    BIT(LPUART_SYNCSTAT_CON0WBSY_POS)

typedef struct
{
    __IO uint32_t CON0;
    __IO uint32_t CON1;
    __IO uint32_t CLKDIV;
    __IO uint32_t FIFOCON;
    uint32_t RESERVED0 ;
    __I uint32_t RXDR;
    __O uint32_t TXDR;
    __I uint32_t STAT;
    __IO uint32_t IER;
    __I uint32_t IFLAG;
    __O uint32_t IFC;
    __I uint32_t ISTAT;
    uint32_t RESERVED1[2] ;
    __IO uint32_t UPDATE;
    __I uint32_t SYNCSTAT;
} LPUART_TypeDef;

/****************** Bit definition for DAC_CON register ************************/

#define DAC_CON_NWBW_POSS   18U
#define DAC_CON_NWBW_POSE   21U
#define DAC_CON_NWBW_MSK    BITS(DAC_CON_NWBW_POSS,DAC_CON_NWBW_POSE)

#define DAC_CON_NWM_POSS    16U
#define DAC_CON_NWM_POSE    17U
#define DAC_CON_NWM_MSK BITS(DAC_CON_NWM_POSS,DAC_CON_NWM_POSE)

#define DAC_CON_EXTS_POSS   10U
#define DAC_CON_EXTS_POSE   13U
#define DAC_CON_EXTS_MSK    BITS(DAC_CON_EXTS_POSS,DAC_CON_EXTS_POSE)

#define DAC_CON_EXTEN_POSS   9U
#define DAC_CON_EXTEN_MSK   BIT(DAC_CON_EXTEN_POSS)

#define DAC_CON_SWTEN_POSS   8U
#define DAC_CON_SWTEN_MSK   BIT(DAC_CON_SWTEN_POSS)

#define DAC_CON_DMAEN_POSS   4U
#define DAC_CON_DMAEN_MSK   BIT(DAC_CON_DMAEN_POSS)

#define DAC_CON_MSEL_POSS    3U
#define DAC_CON_MSEL_MSK    BIT(DAC_CON_MSEL_POSS)

#define DAC_CON_DACOE_POSS   2U
#define DAC_CON_DACOE_MSK   BIT(DAC_CON_DACOE_POSS)

#define DAC_CON_OPOFF_POSS   1U
#define DAC_CON_OPOFF_MSK   BIT(DAC_CON_OPOFF_POSS)

#define DAC_CON_DACEN_POSS   0U
#define DAC_CON_DACEN_MSK   BIT(DAC_CON_DACEN_POSS)

/****************** Bit definition for DAC_SWTRG register ************************/

#define DAC_SWTRG_RST_POSS   8U
#define DAC_SWTRG_RST_MSK   BIT(DAC_SWTRG_RST_POSS)

#define DAC_SWTRG_TRG_POSS   0U
#define DAC_SWTRG_TRG_MSK   BIT(DAC_SWTRG_TRG_POSS)

/****************** Bit definition for DAC_DOUT register ************************/

#define DAC_DOUT_VAL_POSS   0U
#define DAC_DOUT_VAL_POSE   11U
#define DAC_DOUT_VAL_MSK    BITS(DAC_DOUT_VAL_POSS,DAC_DOUT_VAL_POSE)

/****************** Bit definition for DAC_R12BUF register ************************/

#define DAC_R12BUF_VAL_POSS 0U
#define DAC_R12BUF_VAL_POSE 11U
#define DAC_R12BUF_VAL_MSK  BITS(DAC_R12BUF_VAL_POSS,DAC_R12BUF_VAL_POSE)

/****************** Bit definition for DAC_L12BUF register ************************/

#define DAC_L12BUF_VAL_POSS 4U
#define DAC_L12BUF_VAL_POSE 15U
#define DAC_L12BUF_VAL_MSK  BITS(DAC_L12BUF_VAL_POSS,DAC_L12BUF_VAL_POSE)

/****************** Bit definition for DAC_R8BUF register ************************/

#define DAC_R8BUF_VAL_POSS  0U
#define DAC_R8BUF_VAL_POSE  7U
#define DAC_R8BUF_VAL_MSK   BITS(DAC_R8BUF_VAL_POSS,DAC_R8BUF_VAL_POSE)

typedef struct
{
    __IO uint32_t CON;
    uint32_t RESERVED0 ;
    __IO uint32_t SWTRG;
    __IO uint32_t DOUT;
    uint32_t RESERVED1 ;
    __IO uint32_t R12BUF;
    __IO uint32_t L12BUF;
    __IO uint32_t R8BUF;
} DAC_TypeDef;

/****************** Bit definition for CACHE_CCR register ************************/

#define CACHE_CCR_STATISTIC_EN_POS  6U
#define CACHE_CCR_STATISTIC_EN_MSK  BIT(CACHE_CCR_STATISTIC_EN_POS)

#define CACHE_CCR_SET_PREFETCH_POS  5U
#define CACHE_CCR_SET_PREFETCH_MSK  BIT(CACHE_CCR_SET_PREFETCH_POS)

#define CACHE_CCR_SET_MAN_INV_POS   4U
#define CACHE_CCR_SET_MAN_INV_MSK   BIT(CACHE_CCR_SET_MAN_INV_POS)

#define CACHE_CCR_SET_MAN_POW_POS   3U
#define CACHE_CCR_SET_MAN_POW_MSK   BIT(CACHE_CCR_SET_MAN_POW_POS)

#define CACHE_CCR_POW_REQ_POS   2U
#define CACHE_CCR_POW_REQ_MSK   BIT(CACHE_CCR_POW_REQ_POS)

#define CACHE_CCR_INV_REQ_POS   1U
#define CACHE_CCR_INV_REQ_MSK   BIT(CACHE_CCR_INV_REQ_POS)

#define CACHE_CCR_EN_POS    0U
#define CACHE_CCR_EN_MSK    BIT(CACHE_CCR_EN_POS)

/****************** Bit definition for CACHE_SR register ************************/

#define CACHE_SR_POW_STAT_POS   4U
#define CACHE_SR_POW_STAT_MSK   BIT(CACHE_SR_POW_STAT_POS)

#define CACHE_SR_INV_STAT_POS   2U
#define CACHE_SR_INV_STAT_MSK   BIT(CACHE_SR_INV_STAT_POS)

#define CACHE_SR_CS_POSS    0U
#define CACHE_SR_CS_POSE    1U
#define CACHE_SR_CS_MSK BITS(CACHE_SR_CS_POSS,CACHE_SR_CS_POSE)

/****************** Bit definition for CACHE_IRQMASK register ************************/

#define CACHE_IRQMASK_MAN_INV_ERR_POS   1U
#define CACHE_IRQMASK_MAN_INV_ERR_MSK   BIT(CACHE_IRQMASK_MAN_INV_ERR_POS)

#define CACHE_IRQMASK_POW_ERR_POS   0U
#define CACHE_IRQMASK_POW_ERR_MSK   BIT(CACHE_IRQMASK_POW_ERR_POS)

/****************** Bit definition for CACHE_IRQSTAT register ************************/

#define CACHE_IRQSTAT_MAN_INV_ERR_POS   1U
#define CACHE_IRQSTAT_MAN_INV_ERR_MSK   BIT(CACHE_IRQSTAT_MAN_INV_ERR_POS)

#define CACHE_IRQSTAT_POW_ERR_POS   0U
#define CACHE_IRQSTAT_POW_ERR_MSK   BIT(CACHE_IRQSTAT_POW_ERR_POS)

/****************** Bit definition for CACHE_CSHR register ************************/

#define CACHE_CSHR_CSHR_POSS    0U
#define CACHE_CSHR_CSHR_POSE    31U
#define CACHE_CSHR_CSHR_MSK BITS(CACHE_CSHR_CSHR_POSS,CACHE_CSHR_CSHR_POSE)

/****************** Bit definition for CACHE_CSMR register ************************/

#define CACHE_CSMR_CSMR_POSS    0U
#define CACHE_CSMR_CSMR_POSE    31U
#define CACHE_CSMR_CSMR_MSK BITS(CACHE_CSMR_CSMR_POSS,CACHE_CSMR_CSMR_POSE)

typedef struct
{
    __IO uint32_t CCR;
    __I uint32_t SR;
    __IO uint32_t IRQMASK;
    __IO uint32_t IRQSTAT;
    uint32_t RESERVED0 ;
    __IO uint32_t CSHR;
    __IO uint32_t CSMR;
} CACHE_TypeDef;

/* Base addresses */
#define SRAM_BASE       (0x20000000UL)
#define APB1_BASE       (0x40000000UL)
#define APB2_BASE       (0x40040000UL)
#define AHB_BASE        (0x40080000UL)

/* APB1 peripherals Base Address */
#define AD16C4T0_BASE   (APB1_BASE + 0x0000)
#define GP32C4T0_BASE   (APB1_BASE + 0x0800)
#define GP32C4T1_BASE   (APB1_BASE + 0x0C00)
#define BS16T0_BASE     (APB1_BASE + 0x1000)
#define BS16T1_BASE     (APB1_BASE + 0x1400)
#define GP16C4T0_BASE   (APB1_BASE + 0x1800)
#define GP16C4T1_BASE   (APB1_BASE + 0x1C00)
#define UART0_BASE      (APB1_BASE + 0x4000)
#define UART1_BASE      (APB1_BASE + 0x4400)
#define UART2_BASE      (APB1_BASE + 0x4800)
#define UART3_BASE      (APB1_BASE + 0x4C00)
#define UART4_BASE      (APB1_BASE + 0x5000)
#define UART5_BASE      (APB1_BASE + 0x5400)
#define SPI0_I2S0_BASE  (APB1_BASE + 0x6000)
#define SPI1_I2S1_BASE  (APB1_BASE + 0x6400)
#define I2C0_BASE       (APB1_BASE + 0x8000)
#define I2C1_BASE       (APB1_BASE + 0x8400)
#define CAN0_BASE       (APB1_BASE + 0xB000)
#define CACHE_BASE      (APB1_BASE + 0X10000)


/* APB2 peripherals Base Address */
#define LPTIM_BASE      (APB2_BASE + 0X0000)
#define LPUART_BASE     (APB2_BASE + 0X1000)
#define ADC0_BASE       (APB2_BASE + 0x2000)
#define DAC0_BASE       (APB2_BASE + 0x5000)
#define WWDT_BASE       (APB2_BASE + 0x6000)
#define IWDT_BASE       (APB2_BASE + 0x6400)
#define RTC_BASE        (APB2_BASE + 0x8400)
#define DBGC_BASE       (APB2_BASE + 0xA000)

/* AHB peripherals Base Address */
#define SYSCFG_BASE     (AHB_BASE + 0x0000)
#define CMU_BASE        (AHB_BASE + 0x0400)
#define RMU_BASE        (AHB_BASE + 0x0800)
#define PMU_BASE        (AHB_BASE + 0x0C00)
#define MSC_BASE        (AHB_BASE + 0x1000)
#define GPIOA_BASE      (AHB_BASE + 0x4000)
#define GPIOB_BASE      (AHB_BASE + 0x4040)
#define GPIOC_BASE      (AHB_BASE + 0x4080)
#define GPIOD_BASE      (AHB_BASE + 0x40C0)
#define GPIOE_BASE      (AHB_BASE + 0x4100)
#define GPIOF_BASE      (AHB_BASE + 0x4140)
#define GPIOG_BASE      (AHB_BASE + 0x4180)
#define GPIOH_BASE      (AHB_BASE + 0x41C0)
#define EXTI_BASE       (AHB_BASE + 0x4300)
#define CRC_BASE        (AHB_BASE + 0x5000)
#define CALC_BASE       (AHB_BASE + 0x5400)
#define PIS_BASE        (AHB_BASE + 0x6000)
#define DMA0_BASE       (AHB_BASE + 0x8000)
#define DMA1_BASE       (AHB_BASE + 0x8400)
#define DMA_MUX_BASE    (AHB_BASE + 0x8800)

/* APB1 peripherals */
#define AD16C4T0        ((TIMER_TypeDef *)AD16C4T0_BASE)
#define GP32C4T0        ((TIMER_TypeDef *)GP32C4T0_BASE)
#define GP32C4T1        ((TIMER_TypeDef *)GP32C4T1_BASE)
#define BS16T0          ((TIMER_TypeDef *)BS16T0_BASE)
#define BS16T1          ((TIMER_TypeDef *)BS16T1_BASE)
#define GP16C4T0        ((TIMER_TypeDef *)GP16C4T0_BASE)
#define GP16C4T1        ((TIMER_TypeDef *)GP16C4T1_BASE)
#define UART0           ((UART_TypeDef *)UART0_BASE)
#define UART1           ((UART_TypeDef *)UART1_BASE)
#define UART2           ((UART_TypeDef *)UART2_BASE)
#define UART3           ((UART_TypeDef *)UART3_BASE)
#define UART4           ((UART_TypeDef *)UART4_BASE)
#define UART5           ((UART_TypeDef *)UART5_BASE)
#define SPI0            ((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define SPI1            ((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)

#define I2S0            ((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define I2S1            ((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)
#define I2C0            ((I2C_TypeDef *)I2C0_BASE)
#define I2C1            ((I2C_TypeDef *)I2C1_BASE)
#define CAN0            ((CAN_TypeDef *)CAN0_BASE)
#define CACHE           ((CACHE_TypeDef *)CACHE_BASE)


/* APB2 peripherals */
#define LPTIM           ((LP16T_TypeDef *)LPTIM_BASE)
#define LPUART0          ((LPUART_TypeDef *)LPUART_BASE)
#define ADC0            ((ADC_TypeDef *)ADC0_BASE)
#define DAC0            ((DAC_TypeDef *)DAC0_BASE)
#define WWDT            ((WWDT_TypeDef *)WWDT_BASE)
#define IWDT            ((IWDT_TypeDef *)IWDT_BASE)
#define RTC             ((RTC_TypeDef *)RTC_BASE)
#define DBGC            ((DBGC_TypeDef *)DBGC_BASE)

/* AHB peripherals */
#define SYSCFG          ((SYSCFG_TypeDef *)SYSCFG_BASE)
#define CMU             ((CMU_TypeDef *)CMU_BASE)
#define RMU             ((RMU_TypeDef *)RMU_BASE)
#define PMU             ((PMU_TypeDef *)PMU_BASE)
#define MSC             ((MSC_TypeDef *)MSC_BASE)
#define GPIOA           ((GPIO_TypeDef *)GPIOA_BASE)
#define GPIOB           ((GPIO_TypeDef *)GPIOB_BASE)
#define GPIOC           ((GPIO_TypeDef *)GPIOC_BASE)
#define GPIOD           ((GPIO_TypeDef *)GPIOD_BASE)
#define GPIOE           ((GPIO_TypeDef *)GPIOE_BASE)
#define GPIOF           ((GPIO_TypeDef *)GPIOF_BASE)
#define GPIOG           ((GPIO_TypeDef *)GPIOG_BASE)
#define GPIOH           ((GPIO_TypeDef *)GPIOH_BASE)
#define EXTI            ((EXTI_TypeDef *)EXTI_BASE)
#define CRC             ((CRC_TypeDef  *)CRC_BASE)
#define CALC            ((CALC_TypeDef *)CALC_BASE)
#define PIS             ((PIS_TypeDef *)PIS_BASE)
#define DMA0            ((DMA_TypeDef *)DMA0_BASE)
#define DMA1            ((DMA_TypeDef *)DMA1_BASE)
#define DMA_MUX         ((DMA_MUX_Typedef *) DMA_MUX_BASE)

#endif
