/**
  *********************************************************************************
  *
  * @file    es32f355x.h
  * @brief   ES32F355x Device Head File
  *
  * @version V1.0
  * @date    18 Dec 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          18 Dec 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __ES32F355X_H__
#define __ES32F355X_H__

#define	__I	volatile const	/* defines 'read only' permissions */
#define __O	volatile	/* defines 'write only' permissions */
#define __IO	volatile	/* defines 'read / write' permissions */

#define  __CHECK_DEVICE_DEFINES
#define  __NVIC_PRIO_BITS	4U
#define  __CM3_REV		0x0200U
#define  __MPU_PRESENT          0x1
#define __Vendor_SysTickConfig	0U

typedef enum IRQn {
	/* Cortex-M3 processor cxceptions index */
	Reset_IRQn        = -15,
	NMI_IRQn          = -14,
	HardFault_IRQn    = -13,
	MemManage_IRQn    = -12,
	BusFault_IRQn     = -11,
	UsageFault_IRQn   = -10,
	SVCall_IRQn       = -5,
	DebugMonitor_IRQn = -4,
	PendSV_IRQn       = -2,
	SysTick_IRQn      = -1,

	/* es32f36xx specific interrupt index */
	WWDG_IRQn              = 0,
	IWDG_IRQn              = 1,
	LVD_IRQn               = 2,
	RTC_IRQn               = 3,
	CMU_IRQn               = 6,
	ADC0_IRQn              = 7,
	CAN0_TX_IRQn           = 8,
	CAN0_RX0_IRQn          = 9,
	CAN0_RX1_IRQn          = 10,
	CAN0_EXCEPTION_IRQn    = 11,
	AD16C4T0_BRK_IRQn      = 12,
	AD16C4T0_UP_IRQn       = 13,
	AD16C4T0_TRIG_COM_IRQn = 14,
	AD16C4T0_CC_IRQn       = 15,
	AD16C4T1_BRK_IRQn      = 16,
	AD16C4T1_UP_IRQn       = 17,
	AD16C4T1_TRIG_COM_IRQn = 18,
	AD16C4T1_CC_IRQn       = 19,
	GP32C4T0_IRQn          = 20,
	GP32C4T1_IRQn          = 21,
	BS16T0_IRQn            = 22,
	BS16T1_IRQn            = 23,
	GP16C4T0_IRQn          = 24,
	GP16C4T1_IRQn          = 25,
	DAC0_CH0_IRQn          = 27,
	I2C0_EV_IRQn           = 28,
	I2C0_ERR_IRQn          = 29,
	I2C1_EV_IRQn           = 30,
	I2C1_ERR_IRQn          = 31,
	SPI0_I2S0_IRQn         = 32,
	SPI1_I2S1_IRQn         = 33,
	UART0_IRQn             = 34,
	UART1_IRQn             = 35,
	UART2_IRQn             = 36,
	UART3_IRQn             = 37,
	UART4_IRQn             = 38,
	UART5_IRQn             = 39,
	CRYPT_IRQn             = 42,
	ACMP0_IRQn             = 43,
	ACMP1_IRQn             = 44,
	SPI2_I2S2_IRQn         = 45,
	EBI_IRQn               = 47,
	TRNG_IRQn              = 48,
	TSENSE_IRQn            = 49,
	EXTI0_IRQn             = 50,
	EXTI1_IRQn             = 51,
	EXTI2_IRQn             = 52,
	EXTI3_IRQn             = 53,
	EXTI4_IRQn             = 54,
	EXTI5_IRQn             = 55,
	EXTI6_IRQn             = 56,
	EXTI7_IRQn             = 57,
	EXTI8_IRQn             = 58,
	EXTI9_IRQn             = 59,
	EXTI10_IRQn            = 60,
	EXTI11_IRQn            = 61,
	EXTI12_IRQn            = 62,
	EXTI13_IRQn            = 63,
	EXTI14_IRQn            = 64,
	EXTI15_IRQn            = 65,
	DMA_IRQn               = 66,
	ADC1_IRQn              = 67,
	DAC0_CH1_IRQn          = 68,
	QSPI_IRQn              = 69,
	USB_INT_IRQn           = 70,
	USB_DMA_IRQn           = 71,
	ACMP2_IRQn             = 72,
} IRQn_Type;


#include <stdint.h>
#include "core_cm3.h"

#if defined (__CC_ARM)
#pragma anon_unions
#endif

/* Peripheral register define */

/****************** Bit definition for SYSCFG_PROT register ************************/

#define	SYSCFG_PROT_KEY_POSS	0U 
#define	SYSCFG_PROT_KEY_POSE	31U 
#define	SYSCFG_PROT_KEY_MSK	BITS(SYSCFG_PROT_KEY_POSS,SYSCFG_PROT_KEY_POSE)

#define	SYSCFG_PROT_PROT_POS	0U 
#define	SYSCFG_PROT_PROT_MSK	BIT(SYSCFG_PROT_PROT_POS)

/****************** Bit definition for SYSCFG_MEMRMP register ************************/

#define	SYSCFG_MEMRMP_BFRMPEN_POS	8U 
#define	SYSCFG_MEMRMP_BFRMPEN_MSK	BIT(SYSCFG_MEMRMP_BFRMPEN_POS)

#define	SYSCFG_MEMRMP_BRRMPEN_POS	0U 
#define	SYSCFG_MEMRMP_BRRMPEN_MSK	BIT(SYSCFG_MEMRMP_BRRMPEN_POS)

/****************** Bit definition for SYSCFG_USBCFG register ************************/

#define	SYSCFG_USBCFG_CLKRDY_POS	26U 
#define	SYSCFG_USBCFG_CLKRDY_MSK	BIT(SYSCFG_USBCFG_CLKRDY_POS)

#define	SYSCFG_USBCFG_CLKRDYBP_POS	25U 
#define	SYSCFG_USBCFG_CLKRDYBP_MSK	BIT(SYSCFG_USBCFG_CLKRDYBP_POS)

#define	SYSCFG_USBCFG_CKSEL_POS	24U 
#define	SYSCFG_USBCFG_CKSEL_MSK	BIT(SYSCFG_USBCFG_CKSEL_POS)

#define	SYSCFG_USBCFG_ITRM_POSS	22U 
#define	SYSCFG_USBCFG_ITRM_POSE	23U 
#define	SYSCFG_USBCFG_ITRM_MSK	BITS(SYSCFG_USBCFG_ITRM_POSS,SYSCFG_USBCFG_ITRM_POSE)

#define	SYSCFG_USBCFG_CKDIVN_POSS	16U 
#define	SYSCFG_USBCFG_CKDIVN_POSE	21U 
#define	SYSCFG_USBCFG_CKDIVN_MSK	BITS(SYSCFG_USBCFG_CKDIVN_POSS,SYSCFG_USBCFG_CKDIVN_POSE)

#define	SYSCFG_USBCFG_CKDIVM_POSS	8U 
#define	SYSCFG_USBCFG_CKDIVM_POSE	11U 
#define	SYSCFG_USBCFG_CKDIVM_MSK	BITS(SYSCFG_USBCFG_CKDIVM_POSS,SYSCFG_USBCFG_CKDIVM_POSE)

#define	SYSCFG_USBCFG_HSDRV_POSS	2U 
#define	SYSCFG_USBCFG_HSDRV_POSE	3U 
#define	SYSCFG_USBCFG_HSDRV_MSK	BITS(SYSCFG_USBCFG_HSDRV_POSS,SYSCFG_USBCFG_HSDRV_POSE)

#define	SYSCFG_USBCFG_TXHBSE_POS	1U 
#define	SYSCFG_USBCFG_TXHBSE_MSK	BIT(SYSCFG_USBCFG_TXHBSE_POS)

#define	SYSCFG_USBCFG_TXLBSE_POS	0U 
#define	SYSCFG_USBCFG_TXLBSE_MSK	BIT(SYSCFG_USBCFG_TXLBSE_POS)

/****************** Bit definition for SYSCFG_TBKCFG register ************************/

#define	SYSCFG_TBKCFG_CLUBKE_POS	2U 
#define	SYSCFG_TBKCFG_CLUBKE_MSK	BIT(SYSCFG_TBKCFG_CLUBKE_POS)

#define	SYSCFG_TBKCFG_LVDBKE_POS	1U 
#define	SYSCFG_TBKCFG_LVDBKE_MSK	BIT(SYSCFG_TBKCFG_LVDBKE_POS)

#define	SYSCFG_TBKCFG_CSSBKE_POS	0U 
#define	SYSCFG_TBKCFG_CSSBKE_MSK	BIT(SYSCFG_TBKCFG_CSSBKE_POS)

typedef struct
{
	__IO uint32_t PROT;
	__IO uint32_t MEMRMP;
	uint32_t rsv0;
	__IO uint32_t USBCFG;
	__IO uint32_t TBKCFG;
	uint32_t rsv1[59];
	__IO uint32_t TESTKEY;
	uint32_t rsv2[7];
	__IO uint32_t USBTEST;
} SYSCFG_TypeDef;

/****************** Bit definition for MSC_FLASHKEY register ************************/

#define	MSC_FLASHKEY_STATUS_POSS	0U 
#define	MSC_FLASHKEY_STATUS_POSE	1U 
#define	MSC_FLASHKEY_STATUS_MSK	BITS(MSC_FLASHKEY_STATUS_POSS,MSC_FLASHKEY_STATUS_POSE)

/****************** Bit definition for MSC_INFOKEY register ************************/

#define	MSC_INFOKEY_STATUS_POSS	0U 
#define	MSC_INFOKEY_STATUS_POSE	1U 
#define	MSC_INFOKEY_STATUS_MSK	BITS(MSC_INFOKEY_STATUS_POSS,MSC_INFOKEY_STATUS_POSE)

/****************** Bit definition for MSC_FLASHADDR register ************************/

#define	MSC_FLASHADDR_IFREN_POS	19U 
#define	MSC_FLASHADDR_IFREN_MSK	BIT(MSC_FLASHADDR_IFREN_POS)

#define	MSC_FLASHADDR_ADDR_POSS	0U 
#define	MSC_FLASHADDR_ADDR_POSE	18U 
#define	MSC_FLASHADDR_ADDR_MSK	BITS(MSC_FLASHADDR_ADDR_POSS,MSC_FLASHADDR_ADDR_POSE)

/****************** Bit definition for MSC_FLASHFIFO register ************************/

#define	MSC_FLASHFIFO_FIFO_POSS	0U 
#define	MSC_FLASHFIFO_FIFO_POSE	31U 
#define	MSC_FLASHFIFO_FIFO_MSK	BITS(MSC_FLASHFIFO_FIFO_POSS,MSC_FLASHFIFO_FIFO_POSE)

/****************** Bit definition for MSC_FLASHDL register ************************/

#define	MSC_FLASHDL_DATAL_POSS	0U 
#define	MSC_FLASHDL_DATAL_POSE	31U 
#define	MSC_FLASHDL_DATAL_MSK	BITS(MSC_FLASHDL_DATAL_POSS,MSC_FLASHDL_DATAL_POSE)

/****************** Bit definition for MSC_FLASHDH register ************************/

#define	MSC_FLASHDH_DATAH_POSS	0U 
#define	MSC_FLASHDH_DATAH_POSE	31U 
#define	MSC_FLASHDH_DATAH_MSK	BITS(MSC_FLASHDH_DATAH_POSS,MSC_FLASHDH_DATAH_POSE)

/****************** Bit definition for MSC_FLASHCMD register ************************/

#define	MSC_FLASHCMD_CMD_POSS	0U 
#define	MSC_FLASHCMD_CMD_POSE	31U 
#define	MSC_FLASHCMD_CMD_MSK	BITS(MSC_FLASHCMD_CMD_POSS,MSC_FLASHCMD_CMD_POSE)

/****************** Bit definition for MSC_FLASHCR register ************************/

#define	MSC_FLASHCR_FIFOEN_POS	5U 
#define	MSC_FLASHCR_FIFOEN_MSK	BIT(MSC_FLASHCR_FIFOEN_POS)

#define	MSC_FLASHCR_FLASHREQ_POS	4U 
#define	MSC_FLASHCR_FLASHREQ_MSK	BIT(MSC_FLASHCR_FLASHREQ_POS)

#define	MSC_FLASHCR_IAPRST_POS	1U 
#define	MSC_FLASHCR_IAPRST_MSK	BIT(MSC_FLASHCR_IAPRST_POS)

#define	MSC_FLASHCR_IAPEN_POS	0U 
#define	MSC_FLASHCR_IAPEN_MSK	BIT(MSC_FLASHCR_IAPEN_POS)

/****************** Bit definition for MSC_FLASHSR register ************************/

#define	MSC_FLASHSR_TIMEOUT_POS	7U 
#define	MSC_FLASHSR_TIMEOUT_MSK	BIT(MSC_FLASHSR_TIMEOUT_POS)

#define	MSC_FLASHSR_PROG_POS	6U 
#define	MSC_FLASHSR_PROG_MSK	BIT(MSC_FLASHSR_PROG_POS)

#define	MSC_FLASHSR_SERA_POS	5U 
#define	MSC_FLASHSR_SERA_MSK	BIT(MSC_FLASHSR_SERA_POS)

#define	MSC_FLASHSR_MASE_POS	4U 
#define	MSC_FLASHSR_MASE_MSK	BIT(MSC_FLASHSR_MASE_POS)

#define	MSC_FLASHSR_ADDR_OV_POS	3U 
#define	MSC_FLASHSR_ADDR_OV_MSK	BIT(MSC_FLASHSR_ADDR_OV_POS)

#define	MSC_FLASHSR_WRP_FLAG_POS	2U 
#define	MSC_FLASHSR_WRP_FLAG_MSK	BIT(MSC_FLASHSR_WRP_FLAG_POS)

#define	MSC_FLASHSR_BUSY_POS	1U 
#define	MSC_FLASHSR_BUSY_MSK	BIT(MSC_FLASHSR_BUSY_POS)

#define	MSC_FLASHSR_FLASHACK_POS	0U 
#define	MSC_FLASHSR_FLASHACK_MSK	BIT(MSC_FLASHSR_FLASHACK_POS)

/****************** Bit definition for MSC_FLASHPL register ************************/

#define	MSC_FLASHPL_PROG_LEN_POSS	0U 
#define	MSC_FLASHPL_PROG_LEN_POSE	15U 
#define	MSC_FLASHPL_PROG_LEN_MSK	BITS(MSC_FLASHPL_PROG_LEN_POSS,MSC_FLASHPL_PROG_LEN_POSE)

/****************** Bit definition for MSC_MEMWAIT register ************************/

#define	MSC_MEMWAIT_SRAM_W_POSS	8U 
#define	MSC_MEMWAIT_SRAM_W_POSE	9U 
#define	MSC_MEMWAIT_SRAM_W_MSK	BITS(MSC_MEMWAIT_SRAM_W_POSS,MSC_MEMWAIT_SRAM_W_POSE)

#define	MSC_MEMWAIT_FLASH_W_POSS	0U 
#define	MSC_MEMWAIT_FLASH_W_POSE	3U 
#define	MSC_MEMWAIT_FLASH_W_MSK	BITS(MSC_MEMWAIT_FLASH_W_POSS,MSC_MEMWAIT_FLASH_W_POSE)

typedef struct
{
	__IO uint32_t FLASHKEY;
	__IO uint32_t INFOKEY;
	__IO uint32_t FLASHADDR;
	__O uint32_t FLASHFIFO;
	__IO uint32_t FLASHDL;
	__IO uint32_t FLASHDH;
	__O uint32_t FLASHCMD;
	__IO uint32_t FLASHCR;
	__I uint32_t FLASHSR;
	__IO uint32_t FLASHPL;
	__IO uint32_t MEMWAIT;
} MSC_TypeDef;

/****************** Bit definition for BKPC_PROT register ************************/

#define	BKPC_PROT_KEY_POSS	1U 
#define	BKPC_PROT_KEY_POSE	31U 
#define	BKPC_PROT_KEY_MSK	BITS(BKPC_PROT_KEY_POSS,BKPC_PROT_KEY_POSE)

#define	BKPC_PROT_PROT_POS	0U 
#define	BKPC_PROT_PROT_MSK	BIT(BKPC_PROT_PROT_POS)

/****************** Bit definition for BKPC_CR register ************************/

#define	BKPC_CR_WKPOL_POS	12U 
#define	BKPC_CR_WKPOL_MSK	BIT(BKPC_CR_WKPOL_POS)

#define	BKPC_CR_WKPS_POSS	9U 
#define	BKPC_CR_WKPS_POSE	11U 
#define	BKPC_CR_WKPS_MSK	BITS(BKPC_CR_WKPS_POSS,BKPC_CR_WKPS_POSE)

#define	BKPC_CR_WKPEN_POS	8U 
#define	BKPC_CR_WKPEN_MSK	BIT(BKPC_CR_WKPEN_POS)

#define	BKPC_CR_MRST_WKPEN_POS	7U 
#define	BKPC_CR_MRST_WKPEN_MSK	BIT(BKPC_CR_MRST_WKPEN_POS)

#define	BKPC_CR_LRCEN_POS	2U 
#define	BKPC_CR_LRCEN_MSK	BIT(BKPC_CR_LRCEN_POS)

#define	BKPC_CR_LOSMEN_POS	1U 
#define	BKPC_CR_LOSMEN_MSK	BIT(BKPC_CR_LOSMEN_POS)

#define	BKPC_CR_LOSCEN_POS	0U 
#define	BKPC_CR_LOSCEN_MSK	BIT(BKPC_CR_LOSCEN_POS)

/****************** Bit definition for BKPC_PCCR register ************************/

#define	BKPC_PCCR_CLKEN_POS	16U 
#define	BKPC_PCCR_CLKEN_MSK	BIT(BKPC_PCCR_CLKEN_POS)

#define	BKPC_PCCR_TSENSECS_POSS	4U 
#define	BKPC_PCCR_TSENSECS_POSE	5U 
#define	BKPC_PCCR_TSENSECS_MSK	BITS(BKPC_PCCR_TSENSECS_POSS,BKPC_PCCR_TSENSECS_POSE)

#define	BKPC_PCCR_RTCCS_POSS	0U 
#define	BKPC_PCCR_RTCCS_POSE	1U 
#define	BKPC_PCCR_RTCCS_MSK	BITS(BKPC_PCCR_RTCCS_POSS,BKPC_PCCR_RTCCS_POSE)

/****************** Bit definition for BKPC_PDCR register ************************/

#define	BKPC_PDCR_ISOLATE_POS	0U 
#define	BKPC_PDCR_ISOLATE_MSK	BIT(BKPC_PDCR_ISOLATE_POS)

#define	BKPC_PDCR_PWRDOWN_POS	0U 
#define	BKPC_PDCR_PWRDOWN_MSK	BIT(BKPC_PDCR_PWRDOWN_POS)

typedef struct
{
	__IO uint32_t PROT;
	__IO uint32_t CR;
	__IO uint32_t PCCR;
	__IO uint32_t PCR;
} BKPC_TypeDef;

/****************** Bit definition for PMU_CR0 register ************************/

#define	PMU_CR0_MTSTOP_POS	21U 
#define	PMU_CR0_MTSTOP_MSK	BIT(PMU_CR0_MTSTOP_POS)

#define	PMU_CR0_LPSTOP_POS	20U 
#define	PMU_CR0_LPSTOP_MSK	BIT(PMU_CR0_LPSTOP_POS)

#define	PMU_CR0_LPRUN_POS	19U 
#define	PMU_CR0_LPRUN_MSK	BIT(PMU_CR0_LPRUN_POS)

#define	PMU_CR0_LPVS_POSS	16U 
#define	PMU_CR0_LPVS_POSE	17U 
#define	PMU_CR0_LPVS_MSK	BITS(PMU_CR0_LPVS_POSS,PMU_CR0_LPVS_POSE)

#define	PMU_CR0_SFPD_POS	15U 
#define	PMU_CR0_SFPD_MSK	BIT(PMU_CR0_SFPD_POS)

#define	PMU_CR0_CSTANDBYF_POS	3U 
#define	PMU_CR0_CSTANDBYF_MSK	BIT(PMU_CR0_CSTANDBYF_POS)

#define	PMU_CR0_CWUF_POS	2U 
#define	PMU_CR0_CWUF_MSK	BIT(PMU_CR0_CWUF_POS)

#define	PMU_CR0_LPM_POSS	0U 
#define	PMU_CR0_LPM_POSE	1U 
#define	PMU_CR0_LPM_MSK	BITS(PMU_CR0_LPM_POSS,PMU_CR0_LPM_POSE)

/****************** Bit definition for PMU_CR1 register ************************/

#define	PMU_CR1_LDO18RDY_POS	15U 
#define	PMU_CR1_LDO18RDY_MSK	BIT(PMU_CR1_LDO18RDY_POS)

#define	PMU_CR1_LDO18PRM_POS	2U 
#define	PMU_CR1_LDO18PRM_MSK	BIT(PMU_CR1_LDO18PRM_POS)

#define	PMU_CR1_LDO18MOD_POSS	0U 
#define	PMU_CR1_LDO18MOD_POSE	1U 
#define	PMU_CR1_LDO18MOD_MSK	BITS(PMU_CR1_LDO18MOD_POSS,PMU_CR1_LDO18MOD_POSE)

/****************** Bit definition for PMU_SR register ************************/

#define	PMU_SR_RSTAT_POS	3U 
#define	PMU_SR_RSTAT_MSK	BIT(PMU_SR_RSTAT_POS)

#define	PMU_SR_USBRDY_POS	2U 
#define	PMU_SR_USBRDY_MSK	BIT(PMU_SR_USBRDY_POS)

#define	PMU_SR_STANDBYF_POS	1U 
#define	PMU_SR_STANDBYF_MSK	BIT(PMU_SR_STANDBYF_POS)

#define	PMU_SR_WUF_POS	0U 
#define	PMU_SR_WUF_MSK	BIT(PMU_SR_WUF_POS)

/****************** Bit definition for PMU_LVDCR register ************************/

#define	PMU_LVDCR_LVDO_POS	15U 
#define	PMU_LVDCR_LVDO_MSK	BIT(PMU_LVDCR_LVDO_POS)

#define	PMU_LVDCR_LVDFLT_POS	11U 
#define	PMU_LVDCR_LVDFLT_MSK	BIT(PMU_LVDCR_LVDFLT_POS)

#define	PMU_LVDCR_LVIFS_POSS	8U 
#define	PMU_LVDCR_LVIFS_POSE	10U 
#define	PMU_LVDCR_LVIFS_MSK	BITS(PMU_LVDCR_LVIFS_POSS,PMU_LVDCR_LVIFS_POSE)

#define	PMU_LVDCR_LVDS_POSS	4U 
#define	PMU_LVDCR_LVDS_POSE	7U 
#define	PMU_LVDCR_LVDS_MSK	BITS(PMU_LVDCR_LVDS_POSS,PMU_LVDCR_LVDS_POSE)

#define	PMU_LVDCR_LVDCIF_POS	3U 
#define	PMU_LVDCR_LVDCIF_MSK	BIT(PMU_LVDCR_LVDCIF_POS)

#define	PMU_LVDCR_LVDIF_POS	2U 
#define	PMU_LVDCR_LVDIF_MSK	BIT(PMU_LVDCR_LVDIF_POS)

#define	PMU_LVDCR_LVDIE_POS	1U 
#define	PMU_LVDCR_LVDIE_MSK	BIT(PMU_LVDCR_LVDIE_POS)

#define	PMU_LVDCR_LVDEN_POS	0U 
#define	PMU_LVDCR_LVDEN_MSK	BIT(PMU_LVDCR_LVDEN_POS)

/****************** Bit definition for PMU_PWRCR register ************************/

#define	PMU_PWRCR_ROM_POS	12U 
#define	PMU_PWRCR_ROM_MSK	BIT(PMU_PWRCR_ROM_POS)

#define	PMU_PWRCR_USB_POS	11U 
#define	PMU_PWRCR_USB_MSK	BIT(PMU_PWRCR_USB_POS)

#define	PMU_PWRCR_QSPI_POS	10U 
#define	PMU_PWRCR_QSPI_MSK	BIT(PMU_PWRCR_QSPI_POS)

#define	PMU_PWRCR_BXCAN_POS	8U 
#define	PMU_PWRCR_BXCAN_MSK	BIT(PMU_PWRCR_BXCAN_POS)

#define	PMU_PWRCR_SRAM_POSS	0U 
#define	PMU_PWRCR_SRAM_POSE	5U 
#define	PMU_PWRCR_SRAM_MSK	BITS(PMU_PWRCR_SRAM_POSS,PMU_PWRCR_SRAM_POSE)

/****************** Bit definition for PMU_VREFCR register ************************/

#define	PMU_VREFCR_VREFEN_POS	0U 
#define	PMU_VREFCR_VREFEN_MSK	BIT(PMU_VREFCR_VREFEN_POS)

typedef struct
{
	__IO uint32_t CR0;
	__IO uint32_t CR1;
	__I uint32_t SR;
	__IO uint32_t LVDCR;
	__IO uint32_t PWRCR;
	uint32_t RESERVED0[3] ;
	__IO uint32_t VREFCR;
} PMU_TypeDef;

/****************** Bit definition for RMU_CR register ************************/

#define	RMU_CR_BORVS_POSS	4U 
#define	RMU_CR_BORVS_POSE	7U 
#define	RMU_CR_BORVS_MSK	BITS(RMU_CR_BORVS_POSS,RMU_CR_BORVS_POSE)

#define	RMU_CR_BORFLT_POSS	1U 
#define	RMU_CR_BORFLT_POSE	3U 
#define	RMU_CR_BORFLT_MSK	BITS(RMU_CR_BORFLT_POSS,RMU_CR_BORFLT_POSE)

#define	RMU_CR_BOREN_POS	0U 
#define	RMU_CR_BOREN_MSK	BIT(RMU_CR_BOREN_POS)

/****************** Bit definition for RMU_RSTSR register ************************/

#define	RMU_RSTSR_CFGERR_POS	16U 
#define	RMU_RSTSR_CFGERR_MSK	BIT(RMU_RSTSR_CFGERR_POS)

#define	RMU_RSTSR_CFG_POS	10U 
#define	RMU_RSTSR_CFG_MSK	BIT(RMU_RSTSR_CFG_POS)

#define	RMU_RSTSR_CPU_POS	9U 
#define	RMU_RSTSR_CPU_MSK	BIT(RMU_RSTSR_CPU_POS)

#define	RMU_RSTSR_MCU_POS	8U 
#define	RMU_RSTSR_MCU_MSK	BIT(RMU_RSTSR_MCU_POS)

#define	RMU_RSTSR_CHIP_POS	7U 
#define	RMU_RSTSR_CHIP_MSK	BIT(RMU_RSTSR_CHIP_POS)

#define	RMU_RSTSR_LOCKUP_POS	6U 
#define	RMU_RSTSR_LOCKUP_MSK	BIT(RMU_RSTSR_LOCKUP_POS)

#define	RMU_RSTSR_WWDT_POS	5U 
#define	RMU_RSTSR_WWDT_MSK	BIT(RMU_RSTSR_WWDT_POS)

#define	RMU_RSTSR_IWDT_POS	4U 
#define	RMU_RSTSR_IWDT_MSK	BIT(RMU_RSTSR_IWDT_POS)

#define	RMU_RSTSR_NMRST_POS	3U 
#define	RMU_RSTSR_NMRST_MSK	BIT(RMU_RSTSR_NMRST_POS)

#define	RMU_RSTSR_BOR_POS	2U 
#define	RMU_RSTSR_BOR_MSK	BIT(RMU_RSTSR_BOR_POS)

#define	RMU_RSTSR_WAKEUP_POS	1U 
#define	RMU_RSTSR_WAKEUP_MSK	BIT(RMU_RSTSR_WAKEUP_POS)

#define	RMU_RSTSR_POR_POS	0U 
#define	RMU_RSTSR_POR_MSK	BIT(RMU_RSTSR_POR_POS)

/****************** Bit definition for RMU_CRSTSR register ************************/

#define	RMU_CRSTSR_CFG_POS	10U 
#define	RMU_CRSTSR_CFG_MSK	BIT(RMU_CRSTSR_CFG_POS)

#define	RMU_CRSTSR_CPU_POS	9U 
#define	RMU_CRSTSR_CPU_MSK	BIT(RMU_CRSTSR_CPU_POS)

#define	RMU_CRSTSR_MCU_POS	8U 
#define	RMU_CRSTSR_MCU_MSK	BIT(RMU_CRSTSR_MCU_POS)

#define	RMU_CRSTSR_CHIP_POS	7U 
#define	RMU_CRSTSR_CHIP_MSK	BIT(RMU_CRSTSR_CHIP_POS)

#define	RMU_CRSTSR_LOCKUP_POS	6U 
#define	RMU_CRSTSR_LOCKUP_MSK	BIT(RMU_CRSTSR_LOCKUP_POS)

#define	RMU_CRSTSR_WWDT_POS	5U 
#define	RMU_CRSTSR_WWDT_MSK	BIT(RMU_CRSTSR_WWDT_POS)

#define	RMU_CRSTSR_IWDT_POS	4U 
#define	RMU_CRSTSR_IWDT_MSK	BIT(RMU_CRSTSR_IWDT_POS)

#define	RMU_CRSTSR_NMRST_POS	3U 
#define	RMU_CRSTSR_NMRST_MSK	BIT(RMU_CRSTSR_NMRST_POS)

#define	RMU_CRSTSR_BOR_POS	2U 
#define	RMU_CRSTSR_BOR_MSK	BIT(RMU_CRSTSR_BOR_POS)

#define	RMU_CRSTSR_WAKEUP_POS	1U 
#define	RMU_CRSTSR_WAKEUP_MSK	BIT(RMU_CRSTSR_WAKEUP_POS)

#define	RMU_CRSTSR_POR_POS	0U 
#define	RMU_CRSTSR_POR_MSK	BIT(RMU_CRSTSR_POR_POS)

/****************** Bit definition for RMU_AHB1RSTR register ************************/

#define	RMU_AHB1RSTR_ECCRST_POS	11U 
#define	RMU_AHB1RSTR_ECCRST_MSK	BIT(RMU_AHB1RSTR_ECCRST_POS)

#define	RMU_AHB1RSTR_USBRST_POS	10U 
#define	RMU_AHB1RSTR_USBRST_MSK	BIT(RMU_AHB1RSTR_USBRST_POS)

#define	RMU_AHB1RSTR_TRNGRST_POS	4U 
#define	RMU_AHB1RSTR_TRNGRST_MSK	BIT(RMU_AHB1RSTR_TRNGRST_POS)

#define	RMU_AHB1RSTR_PISRST_POS	5U 
#define	RMU_AHB1RSTR_PISRST_MSK	BIT(RMU_AHB1RSTR_PISRST_POS)

#define	RMU_AHB1RSTR_TRNGRST_POS	4U 
#define	RMU_AHB1RSTR_TRNGRST_MSK	BIT(RMU_AHB1RSTR_TRNGRST_POS)

#define	RMU_AHB1RSTR_CRYPTRST_POS	3U 
#define	RMU_AHB1RSTR_CRYPTRST_MSK	BIT(RMU_AHB1RSTR_CRYPTRST_POS)

#define	RMU_AHB1RSTR_CALCRST_POS	2U 
#define	RMU_AHB1RSTR_CALCRST_MSK	BIT(RMU_AHB1RSTR_CALCRST_POS)

#define	RMU_AHB1RSTR_CRCRST_POS	1U 
#define	RMU_AHB1RSTR_CRCRST_MSK	BIT(RMU_AHB1RSTR_CRCRST_POS)

#define	RMU_AHB1RSTR_GPIORST_POS	0U 
#define	RMU_AHB1RSTR_GPIORST_MSK	BIT(RMU_AHB1RSTR_GPIORST_POS)

/****************** Bit definition for RMU_AHB2RSTR register ************************/

#define	RMU_AHB2RSTR_EBIRST_POS	8U 
#define	RMU_AHB2RSTR_EBIRST_MSK	BIT(RMU_AHB2RSTR_EBIRST_POS)

#define	RMU_AHB2RSTR_CPURST_POS	1U 
#define	RMU_AHB2RSTR_CPURST_MSK	BIT(RMU_AHB2RSTR_CPURST_POS)

#define	RMU_AHB2RSTR_CHIPRST_POS	0U 
#define	RMU_AHB2RSTR_CHIPRST_MSK	BIT(RMU_AHB2RSTR_CHIPRST_POS)

/****************** Bit definition for RMU_APB1RSTR register ************************/

#define	RMU_APB1RSTR_QSPIRST_POS	25U 
#define	RMU_APB1RSTR_QSPIRST_MSK	BIT(RMU_APB1RSTR_QSPIRST_POS)

#define	RMU_APB1RSTR_CAN0RST_POS	24U 
#define	RMU_APB1RSTR_CAN0RST_MSK	BIT(RMU_APB1RSTR_CAN0RST_POS)

#define	RMU_APB1RSTR_I2C1RST_POS	21U 
#define	RMU_APB1RSTR_I2C1RST_MSK	BIT(RMU_APB1RSTR_I2C1RST_POS)

#define	RMU_APB1RSTR_I2C0RST_POS	20U 
#define	RMU_APB1RSTR_I2C0RST_MSK	BIT(RMU_APB1RSTR_I2C0RST_POS)

#define	RMU_APB1RSTR_SPI2RST_POS	18U 
#define	RMU_APB1RSTR_SPI2RST_MSK	BIT(RMU_APB1RSTR_SPI2RST_POS)

#define	RMU_APB1RSTR_SPI1RST_POS	17U 
#define	RMU_APB1RSTR_SPI1RST_MSK	BIT(RMU_APB1RSTR_SPI1RST_POS)

#define	RMU_APB1RSTR_SPI0RST_POS	16U 
#define	RMU_APB1RSTR_SPI0RST_MSK	BIT(RMU_APB1RSTR_SPI0RST_POS)

#define	RMU_APB1RSTR_UART5RST_POS	13U 
#define	RMU_APB1RSTR_UART5RST_MSK	BIT(RMU_APB1RSTR_UART5RST_POS)

#define	RMU_APB1RSTR_UART4RST_POS	12U 
#define	RMU_APB1RSTR_UART4RST_MSK	BIT(RMU_APB1RSTR_UART4RST_POS)

#define	RMU_APB1RSTR_UART3RST_POS	11U 
#define	RMU_APB1RSTR_UART3RST_MSK	BIT(RMU_APB1RSTR_UART3RST_POS)

#define	RMU_APB1RSTR_UART2RST_POS	10U 
#define	RMU_APB1RSTR_UART2RST_MSK	BIT(RMU_APB1RSTR_UART2RST_POS)

#define	RMU_APB1RSTR_UART1RST_POS	9U 
#define	RMU_APB1RSTR_UART1RST_MSK	BIT(RMU_APB1RSTR_UART1RST_POS)

#define	RMU_APB1RSTR_UART0RST_POS	8U 
#define	RMU_APB1RSTR_UART0RST_MSK	BIT(RMU_APB1RSTR_UART0RST_POS)

#define	RMU_APB1RSTR_TIM7RST_POS	7U 
#define	RMU_APB1RSTR_TIM7RST_MSK	BIT(RMU_APB1RSTR_TIM7RST_POS)

#define	RMU_APB1RSTR_TIM6RST_POS	6U 
#define	RMU_APB1RSTR_TIM6RST_MSK	BIT(RMU_APB1RSTR_TIM6RST_POS)

#define	RMU_APB1RSTR_TIM5RST_POS	5U 
#define	RMU_APB1RSTR_TIM5RST_MSK	BIT(RMU_APB1RSTR_TIM5RST_POS)

#define	RMU_APB1RSTR_TIM4RST_POS	4U 
#define	RMU_APB1RSTR_TIM4RST_MSK	BIT(RMU_APB1RSTR_TIM4RST_POS)

#define	RMU_APB1RSTR_TIM3RST_POS	3U 
#define	RMU_APB1RSTR_TIM3RST_MSK	BIT(RMU_APB1RSTR_TIM3RST_POS)

#define	RMU_APB1RSTR_TIM2RST_POS	2U 
#define	RMU_APB1RSTR_TIM2RST_MSK	BIT(RMU_APB1RSTR_TIM2RST_POS)

#define	RMU_APB1RSTR_TIM1RST_POS	1U 
#define	RMU_APB1RSTR_TIM1RST_MSK	BIT(RMU_APB1RSTR_TIM1RST_POS)

#define	RMU_APB1RSTR_TIM0RST_POS	0U 
#define	RMU_APB1RSTR_TIM0RST_MSK	BIT(RMU_APB1RSTR_TIM0RST_POS)

/****************** Bit definition for RMU_APB2RSTR register ************************/

#define	RMU_APB2RSTR_BKPRAMRST_POS	18U 
#define	RMU_APB2RSTR_BKPRAMRST_MSK	BIT(RMU_APB2RSTR_BKPRAMRST_POS)

#define	RMU_APB2RSTR_BKPCRST_POS	17U 
#define	RMU_APB2RSTR_BKPCRST_MSK	BIT(RMU_APB2RSTR_BKPCRST_POS)

#define	RMU_APB2RSTR_TSENSERST_POS	16U 
#define	RMU_APB2RSTR_TSENSERST_MSK	BIT(RMU_APB2RSTR_TSENSERST_POS)

#define	RMU_APB2RSTR_RTCRST_POS	15U 
#define	RMU_APB2RSTR_RTCRST_MSK	BIT(RMU_APB2RSTR_RTCRST_POS)

#define	RMU_APB2RSTR_IWDTRST_POS	14U 
#define	RMU_APB2RSTR_IWDTRST_MSK	BIT(RMU_APB2RSTR_IWDTRST_POS)

#define	RMU_APB2RSTR_LCDRST_POS	13U 
#define	RMU_APB2RSTR_LCDRST_MSK	BIT(RMU_APB2RSTR_LCDRST_POS)

#define	RMU_APB2RSTR_WWDTRST_POS	12U 
#define	RMU_APB2RSTR_WWDTRST_MSK	BIT(RMU_APB2RSTR_WWDTRST_POS)

#define	RMU_APB2RSTR_ACMP2RST_POS	11U 
#define	RMU_APB2RSTR_ACMP2RST_MSK	BIT(RMU_APB2RSTR_DACRST_POS)

#define	RMU_APB2RSTR_DACRST_POS	9U 
#define	RMU_APB2RSTR_DACRST_MSK	BIT(RMU_APB2RSTR_DACRST_POS)

#define	RMU_APB2RSTR_OPAMPRST_POS	8U 
#define	RMU_APB2RSTR_OPAMPRST_MSK	BIT(RMU_APB2RSTR_OPAMPRST_POS)

#define	RMU_APB2RSTR_ACMP1RST_POS	7U 
#define	RMU_APB2RSTR_ACMP1RST_MSK	BIT(RMU_APB2RSTR_ACMP1RST_POS)

#define	RMU_APB2RSTR_ACMP0RST_POS	6U 
#define	RMU_APB2RSTR_ACMP0RST_MSK	BIT(RMU_APB2RSTR_ACMP0RST_POS)

#define	RMU_APB2RSTR_ADC1RST_POS	5U 
#define	RMU_APB2RSTR_ADC1RST_MSK	BIT(RMU_APB2RSTR_ADC1RST_POS)

#define	RMU_APB2RSTR_ADC0RST_POS	4U 
#define	RMU_APB2RSTR_ADC0RST_MSK	BIT(RMU_APB2RSTR_ADC0RST_POS)

#define	RMU_APB2RSTR_LPUART0RST_POS	2U 
#define	RMU_APB2RSTR_LPUART0RST_MSK	BIT(RMU_APB2RSTR_LPUART0RST_POS)

#define	RMU_APB2RSTR_LPTIM0RST_POS	0U 
#define	RMU_APB2RSTR_LPTIM0RST_MSK	BIT(RMU_APB2RSTR_LPTIM0RST_POS)

typedef struct
{
	__IO uint32_t CR;
	uint32_t RESERVED0[3] ;
	__I uint32_t RSTSR;
	__O uint32_t CRSTSR;
	uint32_t RESERVED1[2] ;
	__O uint32_t AHB1RSTR;
	__O uint32_t AHB2RSTR;
	uint32_t RESERVED2[2] ;
	__O uint32_t APB1RSTR;
	__O uint32_t APB2RSTR;
} RMU_TypeDef;

/****************** Bit definition for CMU_CSR register ************************/

#define	CMU_CSR_CFT_RDYN_POS	25U 
#define	CMU_CSR_CFT_RDYN_MSK	BIT(CMU_CSR_CFT_RDYN_POS)

#define	CMU_CSR_CFT_STU_POS	24U 
#define	CMU_CSR_CFT_STU_MSK	BIT(CMU_CSR_CFT_STU_POS)

#define	CMU_CSR_CFT_CMD_POSS	16U 
#define	CMU_CSR_CFT_CMD_POSE	23U 
#define	CMU_CSR_CFT_CMD_MSK	BITS(CMU_CSR_CFT_CMD_POSS,CMU_CSR_CFT_CMD_POSE)

#define	CMU_CSR_SYS_RDYN_POS	12U 
#define	CMU_CSR_SYS_RDYN_MSK	BIT(CMU_CSR_SYS_RDYN_POS)

#define	CMU_CSR_SYS_STU_POSS	8U 
#define	CMU_CSR_SYS_STU_POSE	10U 
#define	CMU_CSR_SYS_STU_MSK	BITS(CMU_CSR_SYS_STU_POSS,CMU_CSR_SYS_STU_POSE)

#define	CMU_CSR_SYS_CMD_POSS	0U 
#define	CMU_CSR_SYS_CMD_POSE	2U 
#define	CMU_CSR_SYS_CMD_MSK	BITS(CMU_CSR_SYS_CMD_POSS,CMU_CSR_SYS_CMD_POSE)

/****************** Bit definition for CMU_CFGR register ************************/

#define	CMU_CFGR_HRCFCS_POS	26U 
#define	CMU_CFGR_HRCFCS_MSK	BIT(CMU_CFGR_HRCFCS_POS)

#define	CMU_CFGR_HRCFST_POS	25U 
#define	CMU_CFGR_HRCFST_MSK	BIT(CMU_CFGR_HRCFST_POS)

#define	CMU_CFGR_HRCFSW_POS	24U 
#define	CMU_CFGR_HRCFSW_MSK	BIT(CMU_CFGR_HRCFSW_POS)

#define	CMU_CFGR_PCLK2DIV_POSS	20U 
#define	CMU_CFGR_PCLK2DIV_POSE	23U 
#define	CMU_CFGR_PCLK2DIV_MSK	BITS(CMU_CFGR_PCLK2DIV_POSS,CMU_CFGR_PCLK2DIV_POSE)

#define	CMU_CFGR_PCLK1DIV_POSS	16U 
#define	CMU_CFGR_PCLK1DIV_POSE	19U 
#define	CMU_CFGR_PCLK1DIV_MSK	BITS(CMU_CFGR_PCLK1DIV_POSS,CMU_CFGR_PCLK1DIV_POSE)

#define	CMU_CFGR_SYSDIV_POSS	12U 
#define	CMU_CFGR_SYSDIV_POSE	15U 
#define	CMU_CFGR_SYSDIV_MSK	BITS(CMU_CFGR_SYSDIV_POSS,CMU_CFGR_SYSDIV_POSE)

#define	CMU_CFGR_HCLK2DIV_POSS	4U 
#define	CMU_CFGR_HCLK2DIV_POSE	7U 
#define	CMU_CFGR_HCLK2DIV_MSK	BITS(CMU_CFGR_HCLK2DIV_POSS,CMU_CFGR_HCLK2DIV_POSE)

#define	CMU_CFGR_HCLK1DIV_POSS	0U 
#define	CMU_CFGR_HCLK1DIV_POSE	3U 
#define	CMU_CFGR_HCLK1DIV_MSK	BITS(CMU_CFGR_HCLK1DIV_POSS,CMU_CFGR_HCLK1DIV_POSE)

/****************** Bit definition for CMU_CLKENR register ************************/

#define	CMU_CLKENR_HOSC1MEN_POS	17U 
#define	CMU_CLKENR_HOSC1MEN_MSK	BIT(CMU_CLKENR_HOSC1MEN_POS)

#define	CMU_CLKENR_HRC1MEN_POS	16U 
#define	CMU_CLKENR_HRC1MEN_MSK	BIT(CMU_CLKENR_HRC1MEN_POS)

#define	CMU_CLKENR_PLL2EN_POS	9U 
#define	CMU_CLKENR_PLL2EN_MSK	BIT(CMU_CLKENR_PLL2EN_POS)

#define	CMU_CLKENR_PLL1EN_POS	8U 
#define	CMU_CLKENR_PLL1EN_MSK	BIT(CMU_CLKENR_PLL1EN_POS)

#define	CMU_CLKENR_ULRCEN_POS	4U 
#define	CMU_CLKENR_ULRCEN_MSK	BIT(CMU_CLKENR_ULRCEN_POS)

#define	CMU_CLKENR_LRCEN_POS	3U 
#define	CMU_CLKENR_LRCEN_MSK	BIT(CMU_CLKENR_LRCEN_POS)

#define	CMU_CLKENR_HRCEN_POS	2U 
#define	CMU_CLKENR_HRCEN_MSK	BIT(CMU_CLKENR_HRCEN_POS)

#define	CMU_CLKENR_LOSCEN_POS	1U 
#define	CMU_CLKENR_LOSCEN_MSK	BIT(CMU_CLKENR_LOSCEN_POS)

#define	CMU_CLKENR_HOSCEN_POS	0U 
#define	CMU_CLKENR_HOSCEN_MSK	BIT(CMU_CLKENR_HOSCEN_POS)

/****************** Bit definition for CMU_CLKSR register ************************/

#define	CMU_CLKSR_PLL2RDY_POS	25U 
#define	CMU_CLKSR_PLL2RDY_MSK	BIT(CMU_CLKSR_PLL2RDY_POS)

#define	CMU_CLKSR_PLL1RDY_POS	24U 
#define	CMU_CLKSR_PLL1RDY_MSK	BIT(CMU_CLKSR_PLL1RDY_POS)

#define	CMU_CLKSR_LRCRDY_POS	19U 
#define	CMU_CLKSR_LRCRDY_MSK	BIT(CMU_CLKSR_LRCRDY_POS)

#define	CMU_CLKSR_HRCRDY_POS	18U 
#define	CMU_CLKSR_HRCRDY_MSK	BIT(CMU_CLKSR_HRCRDY_POS)

#define	CMU_CLKSR_LOSCRDY_POS	17U 
#define	CMU_CLKSR_LOSCRDY_MSK	BIT(CMU_CLKSR_LOSCRDY_POS)

#define	CMU_CLKSR_HOSCRDY_POS	16U 
#define	CMU_CLKSR_HOSCRDY_MSK	BIT(CMU_CLKSR_HOSCRDY_POS)

#define	CMU_CLKSR_PLL2ACT_POS	9U 
#define	CMU_CLKSR_PLL2ACT_MSK	BIT(CMU_CLKSR_PLL2ACT_POS)

#define	CMU_CLKSR_PLL1ACT_POS	8U 
#define	CMU_CLKSR_PLL1ACT_MSK	BIT(CMU_CLKSR_PLL1ACT_POS)

#define	CMU_CLKSR_ULRCACT_POS	4U 
#define	CMU_CLKSR_ULRCACT_MSK	BIT(CMU_CLKSR_ULRCACT_POS)

#define	CMU_CLKSR_LRCACT_POS	3U 
#define	CMU_CLKSR_LRCACT_MSK	BIT(CMU_CLKSR_LRCACT_POS)

#define	CMU_CLKSR_HRCACT_POS	2U 
#define	CMU_CLKSR_HRCACT_MSK	BIT(CMU_CLKSR_HRCACT_POS)

#define	CMU_CLKSR_LOSCACT_POS	1U 
#define	CMU_CLKSR_LOSCACT_MSK	BIT(CMU_CLKSR_LOSCACT_POS)

#define	CMU_CLKSR_HOSCACT_POS	0U 
#define	CMU_CLKSR_HOSCACT_MSK	BIT(CMU_CLKSR_HOSCACT_POS)

/****************** Bit definition for CMU_PLLCFG register ************************/

#define	CMU_PLLCFG_PLL2LCKN_POS	17U 
#define	CMU_PLLCFG_PLL2LCKN_MSK	BIT(CMU_PLLCFG_PLL2LCKN_POS)

#define	CMU_PLLCFG_PLL1LCKN_POS	16U 
#define	CMU_PLLCFG_PLL1LCKN_MSK	BIT(CMU_PLLCFG_PLL1LCKN_POS)

#define	CMU_PLLCFG_PLL2RFS_POSS	8U 
#define	CMU_PLLCFG_PLL2RFS_POSE	9U 
#define	CMU_PLLCFG_PLL2RFS_MSK	BITS(CMU_PLLCFG_PLL2RFS_POSS,CMU_PLLCFG_PLL2RFS_POSE)

#define	CMU_PLLCFG_PLL1OS_POSS	4U 
#define	CMU_PLLCFG_PLL1OS_POSE	5U 
#define	CMU_PLLCFG_PLL1OS_MSK	BITS(CMU_PLLCFG_PLL1OS_POSS,CMU_PLLCFG_PLL1OS_POSE)

#define	CMU_PLLCFG_PLL1RFS_POSS	0U 
#define	CMU_PLLCFG_PLL1RFS_POSE	2U 
#define	CMU_PLLCFG_PLL1RFS_MSK	BITS(CMU_PLLCFG_PLL1RFS_POSS,CMU_PLLCFG_PLL1RFS_POSE)

/****************** Bit definition for CMU_HOSCCFG register ************************/

#define	CMU_HOSCCFG_FREQ_POSS	0U 
#define	CMU_HOSCCFG_FREQ_POSE	4U 
#define	CMU_HOSCCFG_FREQ_MSK	BITS(CMU_HOSCCFG_FREQ_POSS,CMU_HOSCCFG_FREQ_POSE)

/****************** Bit definition for CMU_HOSMCR register ************************/

#define	CMU_HOSMCR_NMIE_POS	20U 
#define	CMU_HOSMCR_NMIE_MSK	BIT(CMU_HOSMCR_NMIE_POS)

#define	CMU_HOSMCR_STPIF_POS	19U 
#define	CMU_HOSMCR_STPIF_MSK	BIT(CMU_HOSMCR_STPIF_POS)

#define	CMU_HOSMCR_STRIF_POS	18U 
#define	CMU_HOSMCR_STRIF_MSK	BIT(CMU_HOSMCR_STRIF_POS)

#define	CMU_HOSMCR_STPIE_POS	17U 
#define	CMU_HOSMCR_STPIE_MSK	BIT(CMU_HOSMCR_STPIE_POS)

#define	CMU_HOSMCR_STRIE_POS	16U 
#define	CMU_HOSMCR_STRIE_MSK	BIT(CMU_HOSMCR_STRIE_POS)

#define	CMU_HOSMCR_FRQS_POSS	8U 
#define	CMU_HOSMCR_FRQS_POSE	10U 
#define	CMU_HOSMCR_FRQS_MSK	BITS(CMU_HOSMCR_FRQS_POSS,CMU_HOSMCR_FRQS_POSE)

#define	CMU_HOSMCR_CLKS_POS	1U 
#define	CMU_HOSMCR_CLKS_MSK	BIT(CMU_HOSMCR_CLKS_POS)

#define	CMU_HOSMCR_EN_POS	0U 
#define	CMU_HOSMCR_EN_MSK	BIT(CMU_HOSMCR_EN_POS)

/****************** Bit definition for CMU_LOSMCR register ************************/

#define	CMU_LOSMCR_NMIE_POS	20U 
#define	CMU_LOSMCR_NMIE_MSK	BIT(CMU_LOSMCR_NMIE_POS)

#define	CMU_LOSMCR_STPIF_POS	19U 
#define	CMU_LOSMCR_STPIF_MSK	BIT(CMU_LOSMCR_STPIF_POS)

#define	CMU_LOSMCR_STRIF_POS	18U 
#define	CMU_LOSMCR_STRIF_MSK	BIT(CMU_LOSMCR_STRIF_POS)

#define	CMU_LOSMCR_STPIE_POS	17U 
#define	CMU_LOSMCR_STPIE_MSK	BIT(CMU_LOSMCR_STPIE_POS)

#define	CMU_LOSMCR_STRIE_POS	16U 
#define	CMU_LOSMCR_STRIE_MSK	BIT(CMU_LOSMCR_STRIE_POS)

#define	CMU_LOSMCR_CLKS_POS	1U 
#define	CMU_LOSMCR_CLKS_MSK	BIT(CMU_LOSMCR_CLKS_POS)

#define	CMU_LOSMCR_EN_POS	0U 
#define	CMU_LOSMCR_EN_MSK	BIT(CMU_LOSMCR_EN_POS)

/****************** Bit definition for CMU_PULMCR register ************************/

#define	CMU_PULMCR_NMIE_POS	20U 
#define	CMU_PULMCR_NMIE_MSK	BIT(CMU_PULMCR_NMIE_POS)

#define	CMU_PULMCR_ULKIF_POS	19U 
#define	CMU_PULMCR_ULKIF_MSK	BIT(CMU_PULMCR_ULKIF_POS)

#define	CMU_PULMCR_LCKIF_POS	18U 
#define	CMU_PULMCR_LCKIF_MSK	BIT(CMU_PULMCR_LCKIF_POS)

#define	CMU_PULMCR_ULKIE_POS	17U 
#define	CMU_PULMCR_ULKIE_MSK	BIT(CMU_PULMCR_ULKIE_POS)

#define	CMU_PULMCR_LCKIE_POS	16U 
#define	CMU_PULMCR_LCKIE_MSK	BIT(CMU_PULMCR_LCKIE_POS)

#define	CMU_PULMCR_MODE_POSS	8U 
#define	CMU_PULMCR_MODE_POSE	9U 
#define	CMU_PULMCR_MODE_MSK	BITS(CMU_PULMCR_MODE_POSS,CMU_PULMCR_MODE_POSE)

#define	CMU_PULMCR_CLKS_POS	1U 
#define	CMU_PULMCR_CLKS_MSK	BIT(CMU_PULMCR_CLKS_POS)

#define	CMU_PULMCR_EN_POS	0U 
#define	CMU_PULMCR_EN_MSK	BIT(CMU_PULMCR_EN_POS)

/****************** Bit definition for CMU_CLKOCR register ************************/

#define	CMU_CLKOCR_LSCOS_POSS	24U 
#define	CMU_CLKOCR_LSCOS_POSE	26U 
#define	CMU_CLKOCR_LSCOS_MSK	BITS(CMU_CLKOCR_LSCOS_POSS,CMU_CLKOCR_LSCOS_POSE)

#define	CMU_CLKOCR_LSCOEN_POS	16U 
#define	CMU_CLKOCR_LSCOEN_MSK	BIT(CMU_CLKOCR_LSCOEN_POS)

#define	CMU_CLKOCR_HSCODIV_POSS	12U 
#define	CMU_CLKOCR_HSCODIV_POSE	14U 
#define	CMU_CLKOCR_HSCODIV_MSK	BITS(CMU_CLKOCR_HSCODIV_POSS,CMU_CLKOCR_HSCODIV_POSE)

#define	CMU_CLKOCR_HSCOS_POSS	8U 
#define	CMU_CLKOCR_HSCOS_POSE	10U 
#define	CMU_CLKOCR_HSCOS_MSK	BITS(CMU_CLKOCR_HSCOS_POSS,CMU_CLKOCR_HSCOS_POSE)

#define	CMU_CLKOCR_HSCOEN_POS	0U 
#define	CMU_CLKOCR_HSCOEN_MSK	BIT(CMU_CLKOCR_HSCOEN_POS)

/****************** Bit definition for CMU_BUZZCR register ************************/

#define	CMU_BUZZCR_DAT_POSS	16U 
#define	CMU_BUZZCR_DAT_POSE	31U 
#define	CMU_BUZZCR_DAT_MSK	BITS(CMU_BUZZCR_DAT_POSS,CMU_BUZZCR_DAT_POSE)

#define	CMU_BUZZCR_DIV_POSS	8U 
#define	CMU_BUZZCR_DIV_POSE	10U 
#define	CMU_BUZZCR_DIV_MSK	BITS(CMU_BUZZCR_DIV_POSS,CMU_BUZZCR_DIV_POSE)

#define	CMU_BUZZCR_EN_POS	0U 
#define	CMU_BUZZCR_EN_MSK	BIT(CMU_BUZZCR_EN_POS)

/****************** Bit definition for CMU_AHB1ENR register ************************/

#define	CMU_AHB1ENR_ECCEN_POS	11U 
#define	CMU_AHB1ENR_ECCEN_MSK	BIT(CMU_AHB1ENR_ECCEN_POS)

#define	CMU_AHB1ENR_USBEN_POS	10U 
#define	CMU_AHB1ENR_USBEN_MSK	BIT(CMU_AHB1ENR_USBEN_POS)

#define	CMU_AHB1ENR_DMAEN_POS	8U 
#define	CMU_AHB1ENR_DMAEN_MSK	BIT(CMU_AHB1ENR_DMAEN_POS)

#define	CMU_AHB1ENR_QSPIEN_POS	7U 
#define	CMU_AHB1ENR_QSPIEN_MSK	BIT(CMU_AHB1ENR_QSPIEN_POS)

#define	CMU_AHB1ENR_EBIEN_POS	6U 
#define	CMU_AHB1ENR_EBIEN_MSK	BIT(CMU_AHB1ENR_EBIEN_POS)

#define	CMU_AHB1ENR_PISEN_POS	5U 
#define	CMU_AHB1ENR_PISEN_MSK	BIT(CMU_AHB1ENR_PISEN_POS)

#define	CMU_AHB1ENR_TRNGEN_POS	4U 
#define	CMU_AHB1ENR_TRNGEN_MSK	BIT(CMU_AHB1ENR_TRNGEN_POS)

#define	CMU_AHB1ENR_CRYPTEN_POS	3U 
#define	CMU_AHB1ENR_CRYPTEN_MSK	BIT(CMU_AHB1ENR_CRYPTEN_POS)

#define	CMU_AHB1ENR_CALCEN_POS	2U 
#define	CMU_AHB1ENR_CALCEN_MSK	BIT(CMU_AHB1ENR_CALCEN_POS)

#define	CMU_AHB1ENR_CRCEN_POS	1U 
#define	CMU_AHB1ENR_CRCEN_MSK	BIT(CMU_AHB1ENR_CRCEN_POS)

#define	CMU_AHB1ENR_GPIOEN_POS	0U 
#define	CMU_AHB1ENR_GPIOEN_MSK	BIT(CMU_AHB1ENR_GPIOEN_POS)

/****************** Bit definition for CMU_APB1ENR register ************************/

#define	CMU_APB1ENR_QSPIEN_POS	25U 
#define	CMU_APB1ENR_QSPIEN_MSK	BIT(CMU_APB1ENR_QSPIEN_POS)

#define	CMU_APB1ENR_CAN0EN_POS	24U 
#define	CMU_APB1ENR_CAN0EN_MSK	BIT(CMU_APB1ENR_CAN0EN_POS)

#define	CMU_APB1ENR_I2C1EN_POS	21U 
#define	CMU_APB1ENR_I2C1EN_MSK	BIT(CMU_APB1ENR_I2C1EN_POS)

#define	CMU_APB1ENR_I2C0EN_POS	20U 
#define	CMU_APB1ENR_I2C0EN_MSK	BIT(CMU_APB1ENR_I2C0EN_POS)

#define	CMU_APB1ENR_SPI2EN_POS	18U 
#define	CMU_APB1ENR_SPI2EN_MSK	BIT(CMU_APB1ENR_SPI2EN_POS)

#define	CMU_APB1ENR_SPI1EN_POS	17U 
#define	CMU_APB1ENR_SPI1EN_MSK	BIT(CMU_APB1ENR_SPI1EN_POS)

#define	CMU_APB1ENR_SPI0EN_POS	16U 
#define	CMU_APB1ENR_SPI0EN_MSK	BIT(CMU_APB1ENR_SPI0EN_POS)

#define	CMU_APB1ENR_UART5EN_POS	13U 
#define	CMU_APB1ENR_UART5EN_MSK	BIT(CMU_APB1ENR_UART5EN_POS)

#define	CMU_APB1ENR_UART4EN_POS	12U 
#define	CMU_APB1ENR_UART4EN_MSK	BIT(CMU_APB1ENR_UART4EN_POS)

#define	CMU_APB1ENR_UART3EN_POS	11U 
#define	CMU_APB1ENR_UART3EN_MSK	BIT(CMU_APB1ENR_UART3EN_POS)

#define	CMU_APB1ENR_UART2EN_POS	10U 
#define	CMU_APB1ENR_UART2EN_MSK	BIT(CMU_APB1ENR_UART2EN_POS)

#define	CMU_APB1ENR_UART1EN_POS	9U 
#define	CMU_APB1ENR_UART1EN_MSK	BIT(CMU_APB1ENR_UART1EN_POS)

#define	CMU_APB1ENR_UART0EN_POS	8U 
#define	CMU_APB1ENR_UART0EN_MSK	BIT(CMU_APB1ENR_UART0EN_POS)

#define	CMU_APB1ENR_TIM7EN_POS	7U 
#define	CMU_APB1ENR_TIM7EN_MSK	BIT(CMU_APB1ENR_TIM7EN_POS)

#define	CMU_APB1ENR_TIM6EN_POS	6U 
#define	CMU_APB1ENR_TIM6EN_MSK	BIT(CMU_APB1ENR_TIM6EN_POS)

#define	CMU_APB1ENR_TIM5EN_POS	5U 
#define	CMU_APB1ENR_TIM5EN_MSK	BIT(CMU_APB1ENR_TIM5EN_POS)

#define	CMU_APB1ENR_TIM4EN_POS	4U 
#define	CMU_APB1ENR_TIM4EN_MSK	BIT(CMU_APB1ENR_TIM4EN_POS)

#define	CMU_APB1ENR_TIM3EN_POS	3U 
#define	CMU_APB1ENR_TIM3EN_MSK	BIT(CMU_APB1ENR_TIM3EN_POS)

#define	CMU_APB1ENR_TIM2EN_POS	2U 
#define	CMU_APB1ENR_TIM2EN_MSK	BIT(CMU_APB1ENR_TIM2EN_POS)

#define	CMU_APB1ENR_TIM1EN_POS	1U 
#define	CMU_APB1ENR_TIM1EN_MSK	BIT(CMU_APB1ENR_TIM1EN_POS)

#define	CMU_APB1ENR_TIM0EN_POS	0U 
#define	CMU_APB1ENR_TIM0EN_MSK	BIT(CMU_APB1ENR_TIM0EN_POS)

/****************** Bit definition for CMU_APB2ENR register ************************/

#define	CMU_APB2ENR_DBGCEN_POS	19U 
#define	CMU_APB2ENR_DBGCEN_MSK	BIT(CMU_APB2ENR_DBGCEN_POS)

#define	CMU_APB2ENR_BKPCEN_POS	17U 
#define	CMU_APB2ENR_BKPCEN_MSK	BIT(CMU_APB2ENR_BKPCEN_POS)

#define	CMU_APB2ENR_TSENSEEN_POS	16U 
#define	CMU_APB2ENR_TSENSEEN_MSK	BIT(CMU_APB2ENR_TSENSEEN_POS)

#define	CMU_APB2ENR_RTCEN_POS	15U 
#define	CMU_APB2ENR_RTCEN_MSK	BIT(CMU_APB2ENR_RTCEN_POS)

#define	CMU_APB2ENR_IWDTEN_POS	14U 
#define	CMU_APB2ENR_IWDTEN_MSK	BIT(CMU_APB2ENR_IWDTEN_POS)

#define	CMU_APB2ENR_LCDEN_POS	13U 
#define	CMU_APB2ENR_LCDEN_MSK	BIT(CMU_APB2ENR_LCDEN_POS)

#define	CMU_APB2ENR_WWDTEN_POS	12U 
#define	CMU_APB2ENR_WWDTEN_MSK	BIT(CMU_APB2ENR_WWDTEN_POS)

#define	CMU_APB2ENR_ACMP2EN_POS	11U 
#define	CMU_APB2ENR_ACMP2EN_MSK	BIT(CMU_APB2ENR_ACMP2EN_POS)

#define	CMU_APB2ENR_DAC0EN_POS	9U 
#define	CMU_APB2ENR_DAC0EN_MSK	BIT(CMU_APB2ENR_DAC0EN_POS)

#define	CMU_APB2ENR_OPAMPEN_POS	8U 
#define	CMU_APB2ENR_OPAMPEN_MSK	BIT(CMU_APB2ENR_OPAMPEN_POS)

#define	CMU_APB2ENR_ACMP1EN_POS	7U 
#define	CMU_APB2ENR_ACMP1EN_MSK	BIT(CMU_APB2ENR_ACMP1EN_POS)

#define	CMU_APB2ENR_ACMP0EN_POS	6U 
#define	CMU_APB2ENR_ACMP0EN_MSK	BIT(CMU_APB2ENR_ACMP0EN_POS)

#define	CMU_APB2ENR_ADC1EN_POS	5U 
#define	CMU_APB2ENR_ADC1EN_MSK	BIT(CMU_APB2ENR_ADC1EN_POS)

#define	CMU_APB2ENR_ADC0EN_POS	4U 
#define	CMU_APB2ENR_ADC0EN_MSK	BIT(CMU_APB2ENR_ADC0EN_POS)

#define	CMU_APB2ENR_LPUART0EN_POS	2U 
#define	CMU_APB2ENR_LPUART0EN_MSK	BIT(CMU_APB2ENR_LPUART0EN_POS)

#define	CMU_APB2ENR_LPTIM0EN_POS	0U 
#define	CMU_APB2ENR_LPTIM0EN_MSK	BIT(CMU_APB2ENR_LPTIM0EN_POS)

/****************** Bit definition for CMU_LPENR register ************************/

#define	CMU_LPENR_STOP1CS_POSS	16U 
#define	CMU_LPENR_STOP1CS_POSE	18U 
#define	CMU_LPENR_STOP1CS_MSK	BITS(CMU_LPENR_STOP1CS_POSS,CMU_LPENR_STOP1CS_POSE)

#define	CMU_LPENR_HOSCEN_POS	3U 
#define	CMU_LPENR_HOSCEN_MSK	BIT(CMU_LPENR_HOSCEN_POS)

#define	CMU_LPENR_HRCEN_POS	2U 
#define	CMU_LPENR_HRCEN_MSK	BIT(CMU_LPENR_HRCEN_POS)

#define	CMU_LPENR_LOSCEN_POS	1U 
#define	CMU_LPENR_LOSCEN_MSK	BIT(CMU_LPENR_LOSCEN_POS)

#define	CMU_LPENR_LRCEN_POS	0U 
#define	CMU_LPENR_LRCEN_MSK	BIT(CMU_LPENR_LRCEN_POS)

/****************** Bit definition for CMU_PERICR register ************************/

#define	CMU_PERICR_USBPHYCS_POSS	28U 
#define	CMU_PERICR_USBPHYCS_POSE	30U 
#define	CMU_PERICR_USBPHYCS_MSK	BITS(CMU_PERICR_USBPHYCS_POSS,CMU_PERICR_USBPHYCS_POSE)

#define	CMU_PERICR_QSPICS_POSS	24U 
#define	CMU_PERICR_QSPICS_POSE	26U 
#define	CMU_PERICR_QSPICS_MSK	BITS(CMU_PERICR_QSPICS_POSS,CMU_PERICR_QSPICS_POSE)

#define	CMU_PERICR_LCD_POSS	16U 
#define	CMU_PERICR_LCD_POSE	18U 
#define	CMU_PERICR_LCD_MSK	BITS(CMU_PERICR_LCD_POSS,CMU_PERICR_LCD_POSE)

#define	CMU_PERICR_LPUART0_POSS	8U 
#define	CMU_PERICR_LPUART0_POSE	11U 
#define	CMU_PERICR_LPUART0_MSK	BITS(CMU_PERICR_LPUART0_POSS,CMU_PERICR_LPUART0_POSE)

#define	CMU_PERICR_LPTIM0_POSS	0U 
#define	CMU_PERICR_LPTIM0_POSE	3U 
#define	CMU_PERICR_LPTIM0_MSK	BITS(CMU_PERICR_LPTIM0_POSS,CMU_PERICR_LPTIM0_POSE)

/****************** Bit definition for CMU_PERIDIVR register ************************/

#define	CMU_PERIDIVR_USBPHYDIV_POSS	28U 
#define	CMU_PERIDIVR_USBPHYDIV_POSE	31U 
#define	CMU_PERIDIVR_USBPHYDIV_MSK	BITS(CMU_PERIDIVR_USBPHYDIV_POSS,CMU_PERIDIVR_USBPHYDIV_POSE)

typedef struct
{
	__O uint32_t CSR;
	__IO uint32_t CFGR;
	uint32_t RESERVED0[2] ;
	__IO uint32_t CLKENR;
	__I uint32_t CLKSR;
	__IO uint32_t PLLCFG;
	__IO uint32_t HOSCCFG;
	__IO uint32_t HOSMCR;
	__IO uint32_t LOSMCR;
	__IO uint32_t PULMCR;
	uint32_t RESERVED1 ;
	__IO uint32_t CLKOCR;
	__IO uint32_t BUZZCR;
	uint32_t RESERVED2[2] ;
	__IO uint32_t AHB1ENR;
	uint32_t RESERVED3[3] ;
	__IO uint32_t APB1ENR;
	__IO uint32_t APB2ENR;
	uint32_t RESERVED4[2] ;
	__IO uint32_t LPENR;
	uint32_t RESERVED5[7] ;
	__IO uint32_t PERICR;
	uint32_t RESERVED6 ;
	__IO uint32_t PERIDIVR;
} CMU_TypeDef;

/****************** Bit definition for DMA_STATUS register ************************/

#define	DMA_STATUS_STATUS_POSS	4U 
#define	DMA_STATUS_STATUS_POSE	7U 
#define	DMA_STATUS_STATUS_MSK	BITS(DMA_STATUS_STATUS_POSS,DMA_STATUS_STATUS_POSE)

#define	DMA_STATUS_MASTER_ENABLE_POS	0U 
#define	DMA_STATUS_MASTER_ENABLE_MSK	BIT(DMA_STATUS_MASTER_ENABLE_POS)

/****************** Bit definition for DMA_CFG register ************************/

#define	DMA_CFG_CHNL_PROT_CTRL_POSS	5U 
#define	DMA_CFG_CHNL_PROT_CTRL_POSE	7U 
#define	DMA_CFG_CHNL_PROT_CTRL_MSK	BITS(DMA_CFG_CHNL_PROT_CTRL_POSS,DMA_CFG_CHNL_PROT_CTRL_POSE)

#define	DMA_CFG_MASTER_ENABLE_POS	0U 
#define	DMA_CFG_MASTER_ENABLE_MSK	BIT(DMA_CFG_MASTER_ENABLE_POS)

/****************** Bit definition for DMA_CTRLBASE register ************************/

#define	DMA_CTRLBASE_CTRL_BASE_PTR_POSS	9U 
#define	DMA_CTRLBASE_CTRL_BASE_PTR_POSE	31U 
#define	DMA_CTRLBASE_CTRL_BASE_PTR_MSK	BITS(DMA_CTRLBASE_CTRL_BASE_PTR_POSS,DMA_CTRLBASE_CTRL_BASE_PTR_POSE)

/****************** Bit definition for DMA_ALTCTRLBASE register ************************/

#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSS	0U 
#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSE	31U 
#define	DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_MSK	BITS(DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSS,DMA_ALTCTRLBASE_ALT_CTRL_BASE_PTR_POSE)

/****************** Bit definition for DMA_CHWAITSTATUS register ************************/

#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSS	0U 
#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSE	31U 
#define	DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_MSK	BITS(DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSS,DMA_CHWAITSTATUS_DMA_WAITONREQ_STATUS_POSE)

/****************** Bit definition for DMA_CHSWREQ register ************************/

#define	DMA_CHSWREQ_CHSWREQ_POSS	0U 
#define	DMA_CHSWREQ_CHSWREQ_POSE	31U 
#define	DMA_CHSWREQ_CHSWREQ_MSK	BITS(DMA_CHSWREQ_CHSWREQ_POSS,DMA_CHSWREQ_CHSWREQ_POSE)

/****************** Bit definition for DMA_CHUSEBURSTSET register ************************/

#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSS	0U 
#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSE	31U 
#define	DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_MSK	BITS(DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSS,DMA_CHUSEBURSTSET_CHNL_USEBURST_SET_POSE)

/****************** Bit definition for DMA_CHUSEBURSTCLR register ************************/

#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSS	0U 
#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSE	31U 
#define	DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_MSK	BITS(DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSS,DMA_CHUSEBURSTCLR_CHNL_USEBURST_CLR_POSE)

/****************** Bit definition for DMA_CHREQMASKSET register ************************/

#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSS	0U 
#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSE	31U 
#define	DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_MSK	BITS(DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSS,DMA_CHREQMASKSET_CHNL_REQ_MASK_SET_POSE)

/****************** Bit definition for DMA_CHREQMASKCLR register ************************/

#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSS	0U 
#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSE	31U 
#define	DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_MSK	BITS(DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSS,DMA_CHREQMASKCLR_CHNL_REQ_MASK_CLR_POSE)

/****************** Bit definition for DMA_CHENSET register ************************/

#define	DMA_CHENSET_CHNL_ENABLE_SET_POSS	0U 
#define	DMA_CHENSET_CHNL_ENABLE_SET_POSE	31U 
#define	DMA_CHENSET_CHNL_ENABLE_SET_MSK	BITS(DMA_CHENSET_CHNL_ENABLE_SET_POSS,DMA_CHENSET_CHNL_ENABLE_SET_POSE)

/****************** Bit definition for DMA_CHENCLR register ************************/

#define	DMA_CHENCLR_CHNL_ENABLE_CLR_POSS	0U 
#define	DMA_CHENCLR_CHNL_ENABLE_CLR_POSE	31U 
#define	DMA_CHENCLR_CHNL_ENABLE_CLR_MSK	BITS(DMA_CHENCLR_CHNL_ENABLE_CLR_POSS,DMA_CHENCLR_CHNL_ENABLE_CLR_POSE)

/****************** Bit definition for DMA_CHPRIALTSET register ************************/

#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSS	0U 
#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSE	31U 
#define	DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_MSK	BITS(DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSS,DMA_CHPRIALTSET_CHNL_PRI_ALT_SET_POSE)

/****************** Bit definition for DMA_CHPRIALTCLR register ************************/

#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSS	0U 
#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSE	31U 
#define	DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_MSK	BITS(DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSS,DMA_CHPRIALTCLR_CHNL_PRI_ALT_CLR_POSE)

/****************** Bit definition for DMA_CHPRSET register ************************/

#define	DMA_CHPRSET_CHNL_PRIORITY_SET_POSS	0U 
#define	DMA_CHPRSET_CHNL_PRIORITY_SET_POSE	31U 
#define	DMA_CHPRSET_CHNL_PRIORITY_SET_MSK	BITS(DMA_CHPRSET_CHNL_PRIORITY_SET_POSS,DMA_CHPRSET_CHNL_PRIORITY_SET_POSE)

/****************** Bit definition for DMA_CHPRCLR register ************************/

#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSS	0U 
#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSE	31U 
#define	DMA_CHPRCLR_CHNL_PRIORITY_CLR_MSK	BITS(DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSS,DMA_CHPRCLR_CHNL_PRIORITY_CLR_POSE)

/****************** Bit definition for DMA_ERRCLR register ************************/

#define	DMA_ERRCLR_ERR_CLR_POS	0U 
#define	DMA_ERRCLR_ERR_CLR_MSK	BIT(DMA_ERRCLR_ERR_CLR_POS)

/****************** Bit definition for DMA_IFLAG register ************************/

#define	DMA_IFLAG_DMAERRIF_POS	31U 
#define	DMA_IFLAG_DMAERRIF_MSK	BIT(DMA_IFLAG_DMAERRIF_POS)

#define	DMA_IFLAG_CH11DONEIF_POS	11U 
#define	DMA_IFLAG_CH11DONEIF_MSK	BIT(DMA_IFLAG_CH11DONEIF_POS)

#define	DMA_IFLAG_CH10DONEIF_POS	10U 
#define	DMA_IFLAG_CH10DONEIF_MSK	BIT(DMA_IFLAG_CH10DONEIF_POS)

#define	DMA_IFLAG_CH9DONEIF_POS	9U 
#define	DMA_IFLAG_CH9DONEIF_MSK	BIT(DMA_IFLAG_CH9DONEIF_POS)

#define	DMA_IFLAG_CH8DONEIF_POS	8U 
#define	DMA_IFLAG_CH8DONEIF_MSK	BIT(DMA_IFLAG_CH8DONEIF_POS)

#define	DMA_IFLAG_CH7DONEIF_POS	7U 
#define	DMA_IFLAG_CH7DONEIF_MSK	BIT(DMA_IFLAG_CH7DONEIF_POS)

#define	DMA_IFLAG_CH6DONEIF_POS	6U 
#define	DMA_IFLAG_CH6DONEIF_MSK	BIT(DMA_IFLAG_CH6DONEIF_POS)

#define	DMA_IFLAG_CH5DONEIF_POS	5U 
#define	DMA_IFLAG_CH5DONEIF_MSK	BIT(DMA_IFLAG_CH5DONEIF_POS)

#define	DMA_IFLAG_CH4DONEIF_POS	4U 
#define	DMA_IFLAG_CH4DONEIF_MSK	BIT(DMA_IFLAG_CH4DONEIF_POS)

#define	DMA_IFLAG_CH3DONEIF_POS	3U 
#define	DMA_IFLAG_CH3DONEIF_MSK	BIT(DMA_IFLAG_CH3DONEIF_POS)

#define	DMA_IFLAG_CH2DONEIF_POS	2U 
#define	DMA_IFLAG_CH2DONEIF_MSK	BIT(DMA_IFLAG_CH2DONEIF_POS)

#define	DMA_IFLAG_CH1DONEIF_POS	1U 
#define	DMA_IFLAG_CH1DONEIF_MSK	BIT(DMA_IFLAG_CH1DONEIF_POS)

#define	DMA_IFLAG_CH0DONEIF_POS	0U 
#define	DMA_IFLAG_CH0DONEIF_MSK	BIT(DMA_IFLAG_CH0DONEIF_POS)

/****************** Bit definition for DMA_ICFR register ************************/

#define	DMA_ICFR_DMAERRC_POS	31U 
#define	DMA_ICFR_DMAERRC_MSK	BIT(DMA_ICFR_DMAERRC_POS)

#define	DMA_ICFR_CH11DONEC_POS	11U 
#define	DMA_ICFR_CH11DONEC_MSK	BIT(DMA_ICFR_CH11DONEC_POS)

#define	DMA_ICFR_CH10DONEC_POS	10U 
#define	DMA_ICFR_CH10DONEC_MSK	BIT(DMA_ICFR_CH10DONEC_POS)

#define	DMA_ICFR_CH9DONEC_POS	9U 
#define	DMA_ICFR_CH9DONEC_MSK	BIT(DMA_ICFR_CH9DONEC_POS)

#define	DMA_ICFR_CH8DONEC_POS	8U 
#define	DMA_ICFR_CH8DONEC_MSK	BIT(DMA_ICFR_CH8DONEC_POS)

#define	DMA_ICFR_CH7DONEC_POS	7U 
#define	DMA_ICFR_CH7DONEC_MSK	BIT(DMA_ICFR_CH7DONEC_POS)

#define	DMA_ICFR_CH6DONEC_POS	6U 
#define	DMA_ICFR_CH6DONEC_MSK	BIT(DMA_ICFR_CH6DONEC_POS)

#define	DMA_ICFR_CH5DONEC_POS	5U 
#define	DMA_ICFR_CH5DONEC_MSK	BIT(DMA_ICFR_CH5DONEC_POS)

#define	DMA_ICFR_CH4DONEC_POS	4U 
#define	DMA_ICFR_CH4DONEC_MSK	BIT(DMA_ICFR_CH4DONEC_POS)

#define	DMA_ICFR_CH3DONEC_POS	3U 
#define	DMA_ICFR_CH3DONEC_MSK	BIT(DMA_ICFR_CH3DONEC_POS)

#define	DMA_ICFR_CH2DONEC_POS	2U 
#define	DMA_ICFR_CH2DONEC_MSK	BIT(DMA_ICFR_CH2DONEC_POS)

#define	DMA_ICFR_CH1DONEC_POS	1U 
#define	DMA_ICFR_CH1DONEC_MSK	BIT(DMA_ICFR_CH1DONEC_POS)

#define	DMA_ICFR_CH0DONEC_POS	0U 
#define	DMA_ICFR_CH0DONEC_MSK	BIT(DMA_ICFR_CH0DONEC_POS)

/****************** Bit definition for DMA_IER register ************************/

#define	DMA_IER_DMAERRIE_POS	31U 
#define	DMA_IER_DMAERRIE_MSK	BIT(DMA_IER_DMAERRIE_POS)

#define	DMA_IER_CH11DONEIE_POS	11U 
#define	DMA_IER_CH11DONEIE_MSK	BIT(DMA_IER_CH11DONEIE_POS)

#define	DMA_IER_CH10DONEIE_POS	10U 
#define	DMA_IER_CH10DONEIE_MSK	BIT(DMA_IER_CH10DONEIE_POS)

#define	DMA_IER_CH9DONEIE_POS	9U 
#define	DMA_IER_CH9DONEIE_MSK	BIT(DMA_IER_CH9DONEIE_POS)

#define	DMA_IER_CH8DONEIE_POS	8U 
#define	DMA_IER_CH8DONEIE_MSK	BIT(DMA_IER_CH8DONEIE_POS)

#define	DMA_IER_CH7DONEIE_POS	7U 
#define	DMA_IER_CH7DONEIE_MSK	BIT(DMA_IER_CH7DONEIE_POS)

#define	DMA_IER_CH6DONEIE_POS	6U 
#define	DMA_IER_CH6DONEIE_MSK	BIT(DMA_IER_CH6DONEIE_POS)

#define	DMA_IER_CH5DONEIE_POS	5U 
#define	DMA_IER_CH5DONEIE_MSK	BIT(DMA_IER_CH5DONEIE_POS)

#define	DMA_IER_CH4DONEIE_POS	4U 
#define	DMA_IER_CH4DONEIE_MSK	BIT(DMA_IER_CH4DONEIE_POS)

#define	DMA_IER_CH3DONEIE_POS	3U 
#define	DMA_IER_CH3DONEIE_MSK	BIT(DMA_IER_CH3DONEIE_POS)

#define	DMA_IER_CH2DONEIE_POS	2U 
#define	DMA_IER_CH2DONEIE_MSK	BIT(DMA_IER_CH2DONEIE_POS)

#define	DMA_IER_CH1DONEIE_POS	1U 
#define	DMA_IER_CH1DONEIE_MSK	BIT(DMA_IER_CH1DONEIE_POS)

#define	DMA_IER_CH0DONEIE_POS	0U 
#define	DMA_IER_CH0DONEIE_MSK	BIT(DMA_IER_CH0DONEIE_POS)

/****************** Bit definition for DMA_CH0_SELCON register ************************/

#define	DMA_CH0_SELCON_MSEL_POSS	8U 
#define	DMA_CH0_SELCON_MSEL_POSE	13U 
#define	DMA_CH0_SELCON_MSEL_MSK	BITS(DMA_CH0_SELCON_MSEL_POSS,DMA_CH0_SELCON_MSEL_POSE)

#define	DMA_CH0_SELCON_MSIGSEL_POSS	0U 
#define	DMA_CH0_SELCON_MSIGSEL_POSE	3U 
#define	DMA_CH0_SELCON_MSIGSEL_MSK	BITS(DMA_CH0_SELCON_MSIGSEL_POSS,DMA_CH0_SELCON_MSIGSEL_POSE)

typedef struct
{
	__I uint32_t STATUS;
	__IO uint32_t CFG;
	__IO uint32_t CTRLBASE;
	__I uint32_t ALTCTRLBASE;
	__I uint32_t CHWAITSTATUS;
	__IO uint32_t CHSWREQ;
	__IO uint32_t CHUSEBURSTSET;
	__O uint32_t CHUSEBURSTCLR;
	__IO uint32_t CHREQMASKSET;
	__O uint32_t CHREQMASKCLR;
	__IO uint32_t CHENSET;
	__O uint32_t CHENCLR;
	__IO uint32_t CHPRIALTSET;
	__O uint32_t CHPRIALTCLR;
	__IO uint32_t CHPRSET;
	__O uint32_t CHPRCLR;
	uint32_t RESERVED0[3] ;
	__IO uint32_t ERRCLR;
	uint32_t RESERVED1[1004] ;
	__I uint32_t IFLAG;
	uint32_t RESERVED2 ;
	__O uint32_t ICFR;
	__IO uint32_t IER;
	uint32_t RESERVED3[60] ;
	__IO uint32_t CH_SELCON[12];
} DMA_TypeDef;

/****************** Bit definition for ECC_AREG(x = 1 .. 64) register ************************/
#define	ECC_AREGx_VAL_POSS	0U 
#define	ECC_AREGx_VAL_POSE	31U 
#define	ECC_AREGx_VAL_MSK	BITS(ECC_AREG1_VAL_POSS,ECC_AREG1_VAL_POSE)

/****************** Bit definition for ECC_NREG register ************************/
#define	ECC_NREGx_VAL_POSS	0U 
#define	ECC_NREGx_VAL_POSE	31U 
#define	ECC_NREGx_VAL_MSK	BITS(ECC_AREG1_VAL_POSS,ECC_AREG1_VAL_POSE)

/****************** Bit definition for ECC_CON register ************************/

#define	ECC_CON_SINGST_POS	31U 
#define	ECC_CON_SINGST_MSK	BIT(ECC_CON_SINGST_POS)

#define	ECC_CON_COMBST_POS	30U 
#define	ECC_CON_COMBST_MSK	BIT(ECC_CON_COMBST_POS)

#define	ECC_CON_REMAP_POS	29U 
#define	ECC_CON_REMAP_MSK	BIT(ECC_CON_REMAP_POS)

#define	ECC_CON_COMBMD_POSS	27U 
#define	ECC_CON_COMBMD_POSE	28U 
#define	ECC_CON_COMBMD_MSK	BITS(ECC_CON_COMBMD_POSS,ECC_CON_COMBMD_POSE)

#define	ECC_CON_OPL_POSS	10U 
#define	ECC_CON_OPL_POSE	12U 
#define	ECC_CON_OPL_MSK	BITS(ECC_CON_OPL_POSS,ECC_CON_OPL_POSE)

#define	ECC_CON_OPR_POSS	7U 
#define	ECC_CON_OPR_POSE	9U 
#define	ECC_CON_OPR_MSK	BITS(ECC_CON_OPR_POSS,ECC_CON_OPR_POSE)

#define	ECC_CON_RES_POSS	4U 
#define	ECC_CON_RES_POSE	6U 
#define	ECC_CON_RES_MSK	BITS(ECC_CON_RES_POSS,ECC_CON_RES_POSE)

#define	ECC_CON_MODE_POSS	1U 
#define	ECC_CON_MODE_POSE	3U 
#define	ECC_CON_MODE_MSK	BITS(ECC_CON_MODE_POSS,ECC_CON_MODE_POSE)

#define	ECC_CON_IE_POS	0U 
#define	ECC_CON_IE_MSK	BIT(ECC_CON_IE_POS)

/****************** Bit definition for ECC_STAT register ************************/

#define	ECC_STAT_ERR_POS	2U 
#define	ECC_STAT_ERR_MSK	BIT(ECC_STAT_ERR_POS)

#define	ECC_STAT_DONE_POS	1U 
#define	ECC_STAT_DONE_MSK	BIT(ECC_STAT_DONE_POS)

#define	ECC_STAT_BUSY_POS	0U 
#define	ECC_STAT_BUSY_MSK	BIT(ECC_STAT_BUSY_POS)

/****************** Bit definition for ECC_PARA register ************************/

#define	ECC_PARA_VAL_POSS	0U 
#define	ECC_PARA_VAL_POSE	31U 
#define	ECC_PARA_VAL_MSK	BITS(ECC_PARA_VAL_POSS,ECC_PARA_VAL_POSE)

typedef struct
{
	__IO uint32_t AREG[64];
	__IO uint32_t NREG[8];
	uint32_t RESERVED0[120];
	__IO uint32_t CON;
	__IO uint32_t STAT;
	__IO uint32_t PARA;
} ECC_TypeDef;

/****************** Bit definition for PIS_CH0_CON register ************************/

#define	PIS_CH0_CON_SYNCSEL_POSS	24U 
#define	PIS_CH0_CON_SYNCSEL_POSE	26U 
#define	PIS_CH0_CON_SYNCSEL_MSK	BITS(PIS_CH0_CON_SYNCSEL_POSS,PIS_CH0_CON_SYNCSEL_POSE)

#define	PIS_CH0_CON_PULCK_POSS	18U 
#define	PIS_CH0_CON_PULCK_POSE	19U 
#define	PIS_CH0_CON_PULCK_MSK	BITS(PIS_CH0_CON_PULCK_POSS,PIS_CH0_CON_PULCK_POSE)

#define	PIS_CH0_CON_EDGS_POSS	16U 
#define	PIS_CH0_CON_EDGS_POSE	17U 
#define	PIS_CH0_CON_EDGS_MSK	BITS(PIS_CH0_CON_EDGS_POSS,PIS_CH0_CON_EDGS_POSE)

#define	PIS_CH0_CON_SRCS_POSS	8U 
#define	PIS_CH0_CON_SRCS_POSE	13U 
#define	PIS_CH0_CON_SRCS_MSK	BITS(PIS_CH0_CON_SRCS_POSS,PIS_CH0_CON_SRCS_POSE)

#define	PIS_CH0_CON_MSIGS_POSS	0U 
#define	PIS_CH0_CON_MSIGS_POSE	3U 
#define	PIS_CH0_CON_MSIGS_MSK	BITS(PIS_CH0_CON_MSIGS_POSS,PIS_CH0_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH1_CON register ************************/

#define	PIS_CH1_CON_SYNCSEL_POSS	24U 
#define	PIS_CH1_CON_SYNCSEL_POSE	26U 
#define	PIS_CH1_CON_SYNCSEL_MSK	BITS(PIS_CH1_CON_SYNCSEL_POSS,PIS_CH1_CON_SYNCSEL_POSE)

#define	PIS_CH1_CON_PULCK_POSS	18U 
#define	PIS_CH1_CON_PULCK_POSE	19U 
#define	PIS_CH1_CON_PULCK_MSK	BITS(PIS_CH1_CON_PULCK_POSS,PIS_CH1_CON_PULCK_POSE)

#define	PIS_CH1_CON_EDGS_POSS	16U 
#define	PIS_CH1_CON_EDGS_POSE	17U 
#define	PIS_CH1_CON_EDGS_MSK	BITS(PIS_CH1_CON_EDGS_POSS,PIS_CH1_CON_EDGS_POSE)

#define	PIS_CH1_CON_SRCS_POSS	8U 
#define	PIS_CH1_CON_SRCS_POSE	13U 
#define	PIS_CH1_CON_SRCS_MSK	BITS(PIS_CH1_CON_SRCS_POSS,PIS_CH1_CON_SRCS_POSE)

#define	PIS_CH1_CON_MSIGS_POSS	0U 
#define	PIS_CH1_CON_MSIGS_POSE	3U 
#define	PIS_CH1_CON_MSIGS_MSK	BITS(PIS_CH1_CON_MSIGS_POSS,PIS_CH1_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH2_CON register ************************/

#define	PIS_CH2_CON_SYNCSEL_POSS	24U 
#define	PIS_CH2_CON_SYNCSEL_POSE	26U 
#define	PIS_CH2_CON_SYNCSEL_MSK	BITS(PIS_CH2_CON_SYNCSEL_POSS,PIS_CH2_CON_SYNCSEL_POSE)

#define	PIS_CH2_CON_PULCK_POSS	18U 
#define	PIS_CH2_CON_PULCK_POSE	19U 
#define	PIS_CH2_CON_PULCK_MSK	BITS(PIS_CH2_CON_PULCK_POSS,PIS_CH2_CON_PULCK_POSE)

#define	PIS_CH2_CON_EDGS_POSS	16U 
#define	PIS_CH2_CON_EDGS_POSE	17U 
#define	PIS_CH2_CON_EDGS_MSK	BITS(PIS_CH2_CON_EDGS_POSS,PIS_CH2_CON_EDGS_POSE)

#define	PIS_CH2_CON_SRCS_POSS	8U 
#define	PIS_CH2_CON_SRCS_POSE	13U 
#define	PIS_CH2_CON_SRCS_MSK	BITS(PIS_CH2_CON_SRCS_POSS,PIS_CH2_CON_SRCS_POSE)

#define	PIS_CH2_CON_MSIGS_POSS	0U 
#define	PIS_CH2_CON_MSIGS_POSE	3U 
#define	PIS_CH2_CON_MSIGS_MSK	BITS(PIS_CH2_CON_MSIGS_POSS,PIS_CH2_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH3_CON register ************************/

#define	PIS_CH3_CON_SYNCSEL_POSS	24U 
#define	PIS_CH3_CON_SYNCSEL_POSE	26U 
#define	PIS_CH3_CON_SYNCSEL_MSK	BITS(PIS_CH3_CON_SYNCSEL_POSS,PIS_CH3_CON_SYNCSEL_POSE)

#define	PIS_CH3_CON_PULCK_POSS	18U 
#define	PIS_CH3_CON_PULCK_POSE	19U 
#define	PIS_CH3_CON_PULCK_MSK	BITS(PIS_CH3_CON_PULCK_POSS,PIS_CH3_CON_PULCK_POSE)

#define	PIS_CH3_CON_EDGS_POSS	16U 
#define	PIS_CH3_CON_EDGS_POSE	17U 
#define	PIS_CH3_CON_EDGS_MSK	BITS(PIS_CH3_CON_EDGS_POSS,PIS_CH3_CON_EDGS_POSE)

#define	PIS_CH3_CON_SRCS_POSS	8U 
#define	PIS_CH3_CON_SRCS_POSE	13U 
#define	PIS_CH3_CON_SRCS_MSK	BITS(PIS_CH3_CON_SRCS_POSS,PIS_CH3_CON_SRCS_POSE)

#define	PIS_CH3_CON_MSIGS_POSS	0U 
#define	PIS_CH3_CON_MSIGS_POSE	3U 
#define	PIS_CH3_CON_MSIGS_MSK	BITS(PIS_CH3_CON_MSIGS_POSS,PIS_CH3_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH4_CON register ************************/

#define	PIS_CH4_CON_SYNCSEL_POSS	24U 
#define	PIS_CH4_CON_SYNCSEL_POSE	26U 
#define	PIS_CH4_CON_SYNCSEL_MSK	BITS(PIS_CH4_CON_SYNCSEL_POSS,PIS_CH4_CON_SYNCSEL_POSE)

#define	PIS_CH4_CON_PULCK_POSS	18U 
#define	PIS_CH4_CON_PULCK_POSE	19U 
#define	PIS_CH4_CON_PULCK_MSK	BITS(PIS_CH4_CON_PULCK_POSS,PIS_CH4_CON_PULCK_POSE)

#define	PIS_CH4_CON_EDGS_POSS	16U 
#define	PIS_CH4_CON_EDGS_POSE	17U 
#define	PIS_CH4_CON_EDGS_MSK	BITS(PIS_CH4_CON_EDGS_POSS,PIS_CH4_CON_EDGS_POSE)

#define	PIS_CH4_CON_SRCS_POSS	8U 
#define	PIS_CH4_CON_SRCS_POSE	13U 
#define	PIS_CH4_CON_SRCS_MSK	BITS(PIS_CH4_CON_SRCS_POSS,PIS_CH4_CON_SRCS_POSE)

#define	PIS_CH4_CON_MSIGS_POSS	0U 
#define	PIS_CH4_CON_MSIGS_POSE	3U 
#define	PIS_CH4_CON_MSIGS_MSK	BITS(PIS_CH4_CON_MSIGS_POSS,PIS_CH4_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH5_CON register ************************/

#define	PIS_CH5_CON_SYNCSEL_POSS	24U 
#define	PIS_CH5_CON_SYNCSEL_POSE	26U 
#define	PIS_CH5_CON_SYNCSEL_MSK	BITS(PIS_CH5_CON_SYNCSEL_POSS,PIS_CH5_CON_SYNCSEL_POSE)

#define	PIS_CH5_CON_PULCK_POSS	18U 
#define	PIS_CH5_CON_PULCK_POSE	19U 
#define	PIS_CH5_CON_PULCK_MSK	BITS(PIS_CH5_CON_PULCK_POSS,PIS_CH5_CON_PULCK_POSE)

#define	PIS_CH5_CON_EDGS_POSS	16U 
#define	PIS_CH5_CON_EDGS_POSE	17U 
#define	PIS_CH5_CON_EDGS_MSK	BITS(PIS_CH5_CON_EDGS_POSS,PIS_CH5_CON_EDGS_POSE)

#define	PIS_CH5_CON_SRCS_POSS	8U 
#define	PIS_CH5_CON_SRCS_POSE	13U 
#define	PIS_CH5_CON_SRCS_MSK	BITS(PIS_CH5_CON_SRCS_POSS,PIS_CH5_CON_SRCS_POSE)

#define	PIS_CH5_CON_MSIGS_POSS	0U 
#define	PIS_CH5_CON_MSIGS_POSE	3U 
#define	PIS_CH5_CON_MSIGS_MSK	BITS(PIS_CH5_CON_MSIGS_POSS,PIS_CH5_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH6_CON register ************************/

#define	PIS_CH6_CON_SYNCSEL_POSS	24U 
#define	PIS_CH6_CON_SYNCSEL_POSE	26U 
#define	PIS_CH6_CON_SYNCSEL_MSK	BITS(PIS_CH6_CON_SYNCSEL_POSS,PIS_CH6_CON_SYNCSEL_POSE)

#define	PIS_CH6_CON_PULCK_POSS	18U 
#define	PIS_CH6_CON_PULCK_POSE	19U 
#define	PIS_CH6_CON_PULCK_MSK	BITS(PIS_CH6_CON_PULCK_POSS,PIS_CH6_CON_PULCK_POSE)

#define	PIS_CH6_CON_EDGS_POSS	16U 
#define	PIS_CH6_CON_EDGS_POSE	17U 
#define	PIS_CH6_CON_EDGS_MSK	BITS(PIS_CH6_CON_EDGS_POSS,PIS_CH6_CON_EDGS_POSE)

#define	PIS_CH6_CON_SRCS_POSS	8U 
#define	PIS_CH6_CON_SRCS_POSE	13U 
#define	PIS_CH6_CON_SRCS_MSK	BITS(PIS_CH6_CON_SRCS_POSS,PIS_CH6_CON_SRCS_POSE)

#define	PIS_CH6_CON_MSIGS_POSS	0U 
#define	PIS_CH6_CON_MSIGS_POSE	3U 
#define	PIS_CH6_CON_MSIGS_MSK	BITS(PIS_CH6_CON_MSIGS_POSS,PIS_CH6_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH7_CON register ************************/

#define	PIS_CH7_CON_SYNCSEL_POSS	24U 
#define	PIS_CH7_CON_SYNCSEL_POSE	26U 
#define	PIS_CH7_CON_SYNCSEL_MSK	BITS(PIS_CH7_CON_SYNCSEL_POSS,PIS_CH7_CON_SYNCSEL_POSE)

#define	PIS_CH7_CON_PULCK_POSS	18U 
#define	PIS_CH7_CON_PULCK_POSE	19U 
#define	PIS_CH7_CON_PULCK_MSK	BITS(PIS_CH7_CON_PULCK_POSS,PIS_CH7_CON_PULCK_POSE)

#define	PIS_CH7_CON_EDGS_POSS	16U 
#define	PIS_CH7_CON_EDGS_POSE	17U 
#define	PIS_CH7_CON_EDGS_MSK	BITS(PIS_CH7_CON_EDGS_POSS,PIS_CH7_CON_EDGS_POSE)

#define	PIS_CH7_CON_SRCS_POSS	8U 
#define	PIS_CH7_CON_SRCS_POSE	13U 
#define	PIS_CH7_CON_SRCS_MSK	BITS(PIS_CH7_CON_SRCS_POSS,PIS_CH7_CON_SRCS_POSE)

#define	PIS_CH7_CON_MSIGS_POSS	0U 
#define	PIS_CH7_CON_MSIGS_POSE	3U 
#define	PIS_CH7_CON_MSIGS_MSK	BITS(PIS_CH7_CON_MSIGS_POSS,PIS_CH7_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH8_CON register ************************/

#define	PIS_CH8_CON_SYNCSEL_POSS	24U 
#define	PIS_CH8_CON_SYNCSEL_POSE	26U 
#define	PIS_CH8_CON_SYNCSEL_MSK	BITS(PIS_CH8_CON_SYNCSEL_POSS,PIS_CH8_CON_SYNCSEL_POSE)

#define	PIS_CH8_CON_PULCK_POSS	18U 
#define	PIS_CH8_CON_PULCK_POSE	19U 
#define	PIS_CH8_CON_PULCK_MSK	BITS(PIS_CH8_CON_PULCK_POSS,PIS_CH8_CON_PULCK_POSE)

#define	PIS_CH8_CON_EDGS_POSS	16U 
#define	PIS_CH8_CON_EDGS_POSE	17U 
#define	PIS_CH8_CON_EDGS_MSK	BITS(PIS_CH8_CON_EDGS_POSS,PIS_CH8_CON_EDGS_POSE)

#define	PIS_CH8_CON_SRCS_POSS	8U 
#define	PIS_CH8_CON_SRCS_POSE	13U 
#define	PIS_CH8_CON_SRCS_MSK	BITS(PIS_CH8_CON_SRCS_POSS,PIS_CH8_CON_SRCS_POSE)

#define	PIS_CH8_CON_MSIGS_POSS	0U 
#define	PIS_CH8_CON_MSIGS_POSE	3U 
#define	PIS_CH8_CON_MSIGS_MSK	BITS(PIS_CH8_CON_MSIGS_POSS,PIS_CH8_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH9_CON register ************************/

#define	PIS_CH9_CON_SYNCSEL_POSS	24U 
#define	PIS_CH9_CON_SYNCSEL_POSE	26U 
#define	PIS_CH9_CON_SYNCSEL_MSK	BITS(PIS_CH9_CON_SYNCSEL_POSS,PIS_CH9_CON_SYNCSEL_POSE)

#define	PIS_CH9_CON_PULCK_POSS	18U 
#define	PIS_CH9_CON_PULCK_POSE	19U 
#define	PIS_CH9_CON_PULCK_MSK	BITS(PIS_CH9_CON_PULCK_POSS,PIS_CH9_CON_PULCK_POSE)

#define	PIS_CH9_CON_EDGS_POSS	16U 
#define	PIS_CH9_CON_EDGS_POSE	17U 
#define	PIS_CH9_CON_EDGS_MSK	BITS(PIS_CH9_CON_EDGS_POSS,PIS_CH9_CON_EDGS_POSE)

#define	PIS_CH9_CON_SRCS_POSS	8U 
#define	PIS_CH9_CON_SRCS_POSE	13U 
#define	PIS_CH9_CON_SRCS_MSK	BITS(PIS_CH9_CON_SRCS_POSS,PIS_CH9_CON_SRCS_POSE)

#define	PIS_CH9_CON_MSIGS_POSS	0U 
#define	PIS_CH9_CON_MSIGS_POSE	3U 
#define	PIS_CH9_CON_MSIGS_MSK	BITS(PIS_CH9_CON_MSIGS_POSS,PIS_CH9_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH10_CON register ************************/

#define	PIS_CH10_CON_SYNCSEL_POSS	24U 
#define	PIS_CH10_CON_SYNCSEL_POSE	26U 
#define	PIS_CH10_CON_SYNCSEL_MSK	BITS(PIS_CH10_CON_SYNCSEL_POSS,PIS_CH10_CON_SYNCSEL_POSE)

#define	PIS_CH10_CON_PULCK_POSS	18U 
#define	PIS_CH10_CON_PULCK_POSE	19U 
#define	PIS_CH10_CON_PULCK_MSK	BITS(PIS_CH10_CON_PULCK_POSS,PIS_CH10_CON_PULCK_POSE)

#define	PIS_CH10_CON_EDGS_POSS	16U 
#define	PIS_CH10_CON_EDGS_POSE	17U 
#define	PIS_CH10_CON_EDGS_MSK	BITS(PIS_CH10_CON_EDGS_POSS,PIS_CH10_CON_EDGS_POSE)

#define	PIS_CH10_CON_SRCS_POSS	8U 
#define	PIS_CH10_CON_SRCS_POSE	13U 
#define	PIS_CH10_CON_SRCS_MSK	BITS(PIS_CH10_CON_SRCS_POSS,PIS_CH10_CON_SRCS_POSE)

#define	PIS_CH10_CON_MSIGS_POSS	0U 
#define	PIS_CH10_CON_MSIGS_POSE	3U 
#define	PIS_CH10_CON_MSIGS_MSK	BITS(PIS_CH10_CON_MSIGS_POSS,PIS_CH10_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH11_CON register ************************/

#define	PIS_CH11_CON_SYNCSEL_POSS	24U 
#define	PIS_CH11_CON_SYNCSEL_POSE	26U 
#define	PIS_CH11_CON_SYNCSEL_MSK	BITS(PIS_CH11_CON_SYNCSEL_POSS,PIS_CH11_CON_SYNCSEL_POSE)

#define	PIS_CH11_CON_PULCK_POSS	18U 
#define	PIS_CH11_CON_PULCK_POSE	19U 
#define	PIS_CH11_CON_PULCK_MSK	BITS(PIS_CH11_CON_PULCK_POSS,PIS_CH11_CON_PULCK_POSE)

#define	PIS_CH11_CON_EDGS_POSS	16U 
#define	PIS_CH11_CON_EDGS_POSE	17U 
#define	PIS_CH11_CON_EDGS_MSK	BITS(PIS_CH11_CON_EDGS_POSS,PIS_CH11_CON_EDGS_POSE)

#define	PIS_CH11_CON_SRCS_POSS	8U 
#define	PIS_CH11_CON_SRCS_POSE	13U 
#define	PIS_CH11_CON_SRCS_MSK	BITS(PIS_CH11_CON_SRCS_POSS,PIS_CH11_CON_SRCS_POSE)

#define	PIS_CH11_CON_MSIGS_POSS	0U 
#define	PIS_CH11_CON_MSIGS_POSE	3U 
#define	PIS_CH11_CON_MSIGS_MSK	BITS(PIS_CH11_CON_MSIGS_POSS,PIS_CH11_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH12_CON register ************************/

#define	PIS_CH12_CON_SYNCSEL_POSS	24U 
#define	PIS_CH12_CON_SYNCSEL_POSE	26U 
#define	PIS_CH12_CON_SYNCSEL_MSK	BITS(PIS_CH12_CON_SYNCSEL_POSS,PIS_CH12_CON_SYNCSEL_POSE)

#define	PIS_CH12_CON_PULCK_POSS	18U 
#define	PIS_CH12_CON_PULCK_POSE	19U 
#define	PIS_CH12_CON_PULCK_MSK	BITS(PIS_CH12_CON_PULCK_POSS,PIS_CH12_CON_PULCK_POSE)

#define	PIS_CH12_CON_EDGS_POSS	16U 
#define	PIS_CH12_CON_EDGS_POSE	17U 
#define	PIS_CH12_CON_EDGS_MSK	BITS(PIS_CH12_CON_EDGS_POSS,PIS_CH12_CON_EDGS_POSE)

#define	PIS_CH12_CON_SRCS_POSS	8U 
#define	PIS_CH12_CON_SRCS_POSE	13U 
#define	PIS_CH12_CON_SRCS_MSK	BITS(PIS_CH12_CON_SRCS_POSS,PIS_CH12_CON_SRCS_POSE)

#define	PIS_CH12_CON_MSIGS_POSS	0U 
#define	PIS_CH12_CON_MSIGS_POSE	3U 
#define	PIS_CH12_CON_MSIGS_MSK	BITS(PIS_CH12_CON_MSIGS_POSS,PIS_CH12_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH13_CON register ************************/

#define	PIS_CH13_CON_SYNCSEL_POSS	24U 
#define	PIS_CH13_CON_SYNCSEL_POSE	26U 
#define	PIS_CH13_CON_SYNCSEL_MSK	BITS(PIS_CH13_CON_SYNCSEL_POSS,PIS_CH13_CON_SYNCSEL_POSE)

#define	PIS_CH13_CON_PULCK_POSS	18U 
#define	PIS_CH13_CON_PULCK_POSE	19U 
#define	PIS_CH13_CON_PULCK_MSK	BITS(PIS_CH13_CON_PULCK_POSS,PIS_CH13_CON_PULCK_POSE)

#define	PIS_CH13_CON_EDGS_POSS	16U 
#define	PIS_CH13_CON_EDGS_POSE	17U 
#define	PIS_CH13_CON_EDGS_MSK	BITS(PIS_CH13_CON_EDGS_POSS,PIS_CH13_CON_EDGS_POSE)

#define	PIS_CH13_CON_SRCS_POSS	8U 
#define	PIS_CH13_CON_SRCS_POSE	13U 
#define	PIS_CH13_CON_SRCS_MSK	BITS(PIS_CH13_CON_SRCS_POSS,PIS_CH13_CON_SRCS_POSE)

#define	PIS_CH13_CON_MSIGS_POSS	0U 
#define	PIS_CH13_CON_MSIGS_POSE	3U 
#define	PIS_CH13_CON_MSIGS_MSK	BITS(PIS_CH13_CON_MSIGS_POSS,PIS_CH13_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH14_CON register ************************/

#define	PIS_CH14_CON_SYNCSEL_POSS	24U 
#define	PIS_CH14_CON_SYNCSEL_POSE	26U 
#define	PIS_CH14_CON_SYNCSEL_MSK	BITS(PIS_CH14_CON_SYNCSEL_POSS,PIS_CH14_CON_SYNCSEL_POSE)

#define	PIS_CH14_CON_PULCK_POSS	18U 
#define	PIS_CH14_CON_PULCK_POSE	19U 
#define	PIS_CH14_CON_PULCK_MSK	BITS(PIS_CH14_CON_PULCK_POSS,PIS_CH14_CON_PULCK_POSE)

#define	PIS_CH14_CON_EDGS_POSS	16U 
#define	PIS_CH14_CON_EDGS_POSE	17U 
#define	PIS_CH14_CON_EDGS_MSK	BITS(PIS_CH14_CON_EDGS_POSS,PIS_CH14_CON_EDGS_POSE)

#define	PIS_CH14_CON_SRCS_POSS	8U 
#define	PIS_CH14_CON_SRCS_POSE	13U 
#define	PIS_CH14_CON_SRCS_MSK	BITS(PIS_CH14_CON_SRCS_POSS,PIS_CH14_CON_SRCS_POSE)

#define	PIS_CH14_CON_MSIGS_POSS	0U 
#define	PIS_CH14_CON_MSIGS_POSE	3U 
#define	PIS_CH14_CON_MSIGS_MSK	BITS(PIS_CH14_CON_MSIGS_POSS,PIS_CH14_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH15_CON register ************************/

#define	PIS_CH15_CON_SYNCSEL_POSS	24U 
#define	PIS_CH15_CON_SYNCSEL_POSE	26U 
#define	PIS_CH15_CON_SYNCSEL_MSK	BITS(PIS_CH15_CON_SYNCSEL_POSS,PIS_CH15_CON_SYNCSEL_POSE)

#define	PIS_CH15_CON_PULCK_POSS	18U 
#define	PIS_CH15_CON_PULCK_POSE	19U 
#define	PIS_CH15_CON_PULCK_MSK	BITS(PIS_CH15_CON_PULCK_POSS,PIS_CH15_CON_PULCK_POSE)

#define	PIS_CH15_CON_EDGS_POSS	16U 
#define	PIS_CH15_CON_EDGS_POSE	17U 
#define	PIS_CH15_CON_EDGS_MSK	BITS(PIS_CH15_CON_EDGS_POSS,PIS_CH15_CON_EDGS_POSE)

#define	PIS_CH15_CON_SRCS_POSS	8U 
#define	PIS_CH15_CON_SRCS_POSE	13U 
#define	PIS_CH15_CON_SRCS_MSK	BITS(PIS_CH15_CON_SRCS_POSS,PIS_CH15_CON_SRCS_POSE)

#define	PIS_CH15_CON_MSIGS_POSS	0U 
#define	PIS_CH15_CON_MSIGS_POSE	3U 
#define	PIS_CH15_CON_MSIGS_MSK	BITS(PIS_CH15_CON_MSIGS_POSS,PIS_CH15_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH_OER register ************************/

#define	PIS_CH_OER_CH3OE_POS	3U 
#define	PIS_CH_OER_CH3OE_MSK	BIT(PIS_CH_OER_CH3OE_POS)

#define	PIS_CH_OER_CH2OE_POS	2U 
#define	PIS_CH_OER_CH2OE_MSK	BIT(PIS_CH_OER_CH2OE_POS)

#define	PIS_CH_OER_CH1OE_POS	1U 
#define	PIS_CH_OER_CH1OE_MSK	BIT(PIS_CH_OER_CH1OE_POS)

#define	PIS_CH_OER_CH0OE_POS	0U 
#define	PIS_CH_OER_CH0OE_MSK	BIT(PIS_CH_OER_CH0OE_POS)

/****************** Bit definition for PIS_TAR_CON0 register ************************/

#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_POS	27U 
#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_POS	26U 
#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_POS	25U 
#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_POS	24U 
#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_POS	19U 
#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_POS	18U 
#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_POS	17U 
#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_POS	16U 
#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_POS	12U 
#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_POS	11U 
#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_POS	10U 
#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_POS	9U 
#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_POS	8U 
#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_POS	4U 
#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_POS	3U 
#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_POS	2U 
#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_POS	1U 
#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_POS	0U 
#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH1IN_SEL_POS)

/****************** Bit definition for PIS_TAR_CON1 register ************************/

#define	PIS_TAR_CON1_SPI1_CLK_SEL_POS	15U 
#define	PIS_TAR_CON1_SPI1_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI1_RX_SEL_POS	14U 
#define	PIS_TAR_CON1_SPI1_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_RX_SEL_POS)

#define	PIS_TAR_CON1_SPI0_CLK_SEL_POS	13U 
#define	PIS_TAR_CON1_SPI0_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI0_RX_SEL_POS	12U 
#define	PIS_TAR_CON1_SPI0_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_RX_SEL_POS)

#define	PIS_TAR_CON1_LPUART0_RXD_SEL_POS	8U 
#define	PIS_TAR_CON1_LPUART0_RXD_SEL_MSK	BIT(PIS_TAR_CON1_LPUART0_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART5_RXD_SEL_POS	7U 
#define	PIS_TAR_CON1_UART5_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART5_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART4_RXD_SEL_POS	6U 
#define	PIS_TAR_CON1_UART4_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART4_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART3_RXD_SEL_POS	3U 
#define	PIS_TAR_CON1_UART3_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART3_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART2_RXD_SEL_POS	2U 
#define	PIS_TAR_CON1_UART2_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART2_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART1_RXD_SEL_POS	1U 
#define	PIS_TAR_CON1_UART1_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART1_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART0_RXD_SEL_POS	0U 
#define	PIS_TAR_CON1_UART0_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART0_RXD_SEL_POS)

/****************** Bit definition for PIS_UART0_TXMCR register ************************/

#define	PIS_UART0_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART0_TXMCR_TXMLVLS_MSK	BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define	PIS_UART0_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART0_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART0_TXMCR_TXMSS_MSK	BITS(PIS_UART0_TXMCR_TXMSS_POSS,PIS_UART0_TXMCR_TXMSS_POSE)

#define	PIS_UART0_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART0_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART0_TXMCR_TXSIGS_MSK	BITS(PIS_UART0_TXMCR_TXSIGS_POSS,PIS_UART0_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART1_TXMCR register ************************/

#define	PIS_UART1_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART1_TXMCR_TXMLVLS_MSK	BIT(PIS_UART1_TXMCR_TXMLVLS_POS)

#define	PIS_UART1_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART1_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART1_TXMCR_TXMSS_MSK	BITS(PIS_UART1_TXMCR_TXMSS_POSS,PIS_UART1_TXMCR_TXMSS_POSE)

#define	PIS_UART1_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART1_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART1_TXMCR_TXSIGS_MSK	BITS(PIS_UART1_TXMCR_TXSIGS_POSS,PIS_UART1_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART2_TXMCR register ************************/

#define	PIS_UART2_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART2_TXMCR_TXMLVLS_MSK	BIT(PIS_UART2_TXMCR_TXMLVLS_POS)

#define	PIS_UART2_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART2_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART2_TXMCR_TXMSS_MSK	BITS(PIS_UART2_TXMCR_TXMSS_POSS,PIS_UART2_TXMCR_TXMSS_POSE)

#define	PIS_UART2_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART2_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART2_TXMCR_TXSIGS_MSK	BITS(PIS_UART2_TXMCR_TXSIGS_POSS,PIS_UART2_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART3_TXMCR register ************************/

#define	PIS_UART3_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART3_TXMCR_TXMLVLS_MSK	BIT(PIS_UART3_TXMCR_TXMLVLS_POS)

#define	PIS_UART3_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART3_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART3_TXMCR_TXMSS_MSK	BITS(PIS_UART3_TXMCR_TXMSS_POSS,PIS_UART3_TXMCR_TXMSS_POSE)

#define	PIS_UART3_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART3_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART3_TXMCR_TXSIGS_MSK	BITS(PIS_UART3_TXMCR_TXSIGS_POSS,PIS_UART3_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_LPUART0_TXMCR register ************************/

#define	PIS_LPUART0_TXMCR_TXMLVLS_POS	8U 
#define	PIS_LPUART0_TXMCR_TXMLVLS_MSK	BIT(PIS_LPUART0_TXMCR_TXMLVLS_POS)

#define	PIS_LPUART0_TXMCR_TXMSS_POSS	4U 
#define	PIS_LPUART0_TXMCR_TXMSS_POSE	7U 
#define	PIS_LPUART0_TXMCR_TXMSS_MSK	BITS(PIS_LPUART0_TXMCR_TXMSS_POSS,PIS_LPUART0_TXMCR_TXMSS_POSE)

#define	PIS_LPUART0_TXMCR_TXSIGS_POSS	0U 
#define	PIS_LPUART0_TXMCR_TXSIGS_POSE	3U 
#define	PIS_LPUART0_TXMCR_TXSIGS_MSK	BITS(PIS_LPUART0_TXMCR_TXSIGS_POSS,PIS_LPUART0_TXMCR_TXSIGS_POSE)

typedef struct
{
	__IO uint32_t CH_CON[16];
	__IO uint32_t CH_OER;
	__IO uint32_t TAR_CON0;
	__IO uint32_t TAR_CON1;
	uint32_t RESERVED0[5] ;
	__IO uint32_t UART0_TXMCR;
	__IO uint32_t UART1_TXMCR;
	__IO uint32_t UART2_TXMCR;
	__IO uint32_t UART3_TXMCR;
	__IO uint32_t LPUART0_TXMCR;
} PIS_TypeDef;


/****************** Bit definition for GPIO_DIN register ************************/

#define	GPIO_DIN_DIN_POSS	0U 
#define	GPIO_DIN_DIN_POSE	15U 
#define	GPIO_DIN_DIN_MSK	BITS(GPIO_DIN_DIN_POSS,GPIO_DIN_DIN_POSE)

/****************** Bit definition for GPIO_DOUT register ************************/

#define	GPIO_DOUT_DOUT_POSS	0U 
#define	GPIO_DOUT_DOUT_POSE	15U 
#define	GPIO_DOUT_DOUT_MSK	BITS(GPIO_DOUT_DOUT_POSS,GPIO_DOUT_DOUT_POSE)

/****************** Bit definition for GPIO_BSRR register ************************/

#define	GPIO_BSRR_BRR_POSS	16U 
#define	GPIO_BSRR_BRR_POSE	31U 
#define	GPIO_BSRR_BRR_MSK	BITS(GPIO_BSRR_BRR_POSS,GPIO_BSRR_BRR_POSE)

#define	GPIO_BSRR_BSR_POSS	0U 
#define	GPIO_BSRR_BSR_POSE	15U 
#define	GPIO_BSRR_BSR_MSK	BITS(GPIO_BSRR_BSR_POSS,GPIO_BSRR_BSR_POSE)

/****************** Bit definition for GPIO_BIR register ************************/

#define	GPIO_BIR_BIR_POSS	0U 
#define	GPIO_BIR_BIR_POSE	15U 
#define	GPIO_BIR_BIR_MSK	BITS(GPIO_BIR_BIR_POSS,GPIO_BIR_BIR_POSE)

/****************** Bit definition for GPIO_MODE register ************************/

#define	GPIO_MODE_MODE_POSS	0U 
#define	GPIO_MODE_MODE_POSE	31U 
#define	GPIO_MODE_MODE_MSK	BITS(GPIO_MODE_MODE_POSS,GPIO_MODE_MODE_POSE)

/****************** Bit definition for GPIO_ODOS register ************************/

#define	GPIO_ODOS_ODOS_POSS	0U 
#define	GPIO_ODOS_ODOS_POSE	31U 
#define	GPIO_ODOS_ODOS_MSK	BITS(GPIO_ODOS_ODOS_POSS,GPIO_ODOS_ODOS_POSE)

/****************** Bit definition for GPIO_PUPD register ************************/

#define	GPIO_PUPD_PUPD_POSS	0U 
#define	GPIO_PUPD_PUPD_POSE	31U 
#define	GPIO_PUPD_PUPD_MSK	BITS(GPIO_PUPD_PUPD_POSS,GPIO_PUPD_PUPD_POSE)

/****************** Bit definition for GPIO_PODRV register ************************/

#define	GPIO_PODRV_PODRV_POSS	0U 
#define	GPIO_PODRV_PODRV_POSE	31U 
#define	GPIO_PODRV_PODRV_MSK	BITS(GPIO_PODRV_PODRV_POSS,GPIO_PODRV_PODRV_POSE)

/****************** Bit definition for GPIO_NODRV register ************************/

#define	GPIO_NODRV_NODRV_POSS	0U 
#define	GPIO_NODRV_NODRV_POSE	31U 
#define	GPIO_NODRV_NODRV_MSK	BITS(GPIO_NODRV_NODRV_POSS,GPIO_NODRV_NODRV_POSE)

/****************** Bit definition for GPIO_FLT register ************************/

#define	GPIO_FLT_FLT_POSS	0U 
#define	GPIO_FLT_FLT_POSE	15U 
#define	GPIO_FLT_FLT_MSK	BITS(GPIO_FLT_FLT_POSS,GPIO_FLT_FLT_POSE)

/****************** Bit definition for GPIO_TYPE register ************************/

#define	GPIO_TYPE_TYPE_POSS	0U 
#define	GPIO_TYPE_TYPE_POSE	15U 
#define	GPIO_TYPE_TYPE_MSK	BITS(GPIO_TYPE_TYPE_POSS,GPIO_TYPE_TYPE_POSE)

/****************** Bit definition for GPIO_FUNC0 register ************************/

#define	GPIO_FUNC0_FSEL_IO7_POSS	28U 
#define	GPIO_FUNC0_FSEL_IO7_POSE	31U 
#define	GPIO_FUNC0_FSEL_IO7_MSK	BITS(GPIO_FUNC0_FSEL_IO7_POSS,GPIO_FUNC0_FSEL_IO7_POSE)

#define	GPIO_FUNC0_FSEL_IO6_POSS	24U 
#define	GPIO_FUNC0_FSEL_IO6_POSE	27U 
#define	GPIO_FUNC0_FSEL_IO6_MSK	BITS(GPIO_FUNC0_FSEL_IO6_POSS,GPIO_FUNC0_FSEL_IO6_POSE)

#define	GPIO_FUNC0_FSEL_IO5_POSS	20U 
#define	GPIO_FUNC0_FSEL_IO5_POSE	23U 
#define	GPIO_FUNC0_FSEL_IO5_MSK	BITS(GPIO_FUNC0_FSEL_IO5_POSS,GPIO_FUNC0_FSEL_IO5_POSE)

#define	GPIO_FUNC0_FSEL_IO4_POSS	16U 
#define	GPIO_FUNC0_FSEL_IO4_POSE	19U 
#define	GPIO_FUNC0_FSEL_IO4_MSK	BITS(GPIO_FUNC0_FSEL_IO4_POSS,GPIO_FUNC0_FSEL_IO4_POSE)

#define	GPIO_FUNC0_FSEL_IO3_POSS	12U 
#define	GPIO_FUNC0_FSEL_IO3_POSE	15U 
#define	GPIO_FUNC0_FSEL_IO3_MSK	BITS(GPIO_FUNC0_FSEL_IO3_POSS,GPIO_FUNC0_FSEL_IO3_POSE)

#define	GPIO_FUNC0_FSEL_IO2_POSS	8U 
#define	GPIO_FUNC0_FSEL_IO2_POSE	11U 
#define	GPIO_FUNC0_FSEL_IO2_MSK	BITS(GPIO_FUNC0_FSEL_IO2_POSS,GPIO_FUNC0_FSEL_IO2_POSE)

#define	GPIO_FUNC0_FSEL_IO1_POSS	4U 
#define	GPIO_FUNC0_FSEL_IO1_POSE	7U 
#define	GPIO_FUNC0_FSEL_IO1_MSK	BITS(GPIO_FUNC0_FSEL_IO1_POSS,GPIO_FUNC0_FSEL_IO1_POSE)

#define	GPIO_FUNC0_FSEL_IO0_POSS	0U 
#define	GPIO_FUNC0_FSEL_IO0_POSE	3U 
#define	GPIO_FUNC0_FSEL_IO0_MSK	BITS(GPIO_FUNC0_FSEL_IO0_POSS,GPIO_FUNC0_FSEL_IO0_POSE)

/****************** Bit definition for GPIO_FUNC1 register ************************/

#define	GPIO_FUNC1_FSEL_IO15_POSS	28U 
#define	GPIO_FUNC1_FSEL_IO15_POSE	31U 
#define	GPIO_FUNC1_FSEL_IO15_MSK	BITS(GPIO_FUNC1_FSEL_IO15_POSS,GPIO_FUNC1_FSEL_IO15_POSE)

#define	GPIO_FUNC1_FSEL_IO14_POSS	24U 
#define	GPIO_FUNC1_FSEL_IO14_POSE	27U 
#define	GPIO_FUNC1_FSEL_IO14_MSK	BITS(GPIO_FUNC1_FSEL_IO14_POSS,GPIO_FUNC1_FSEL_IO14_POSE)

#define	GPIO_FUNC1_FSEL_IO13_POSS	20U 
#define	GPIO_FUNC1_FSEL_IO13_POSE	23U 
#define	GPIO_FUNC1_FSEL_IO13_MSK	BITS(GPIO_FUNC1_FSEL_IO13_POSS,GPIO_FUNC1_FSEL_IO13_POSE)

#define	GPIO_FUNC1_FSEL_IO12_POSS	16U 
#define	GPIO_FUNC1_FSEL_IO12_POSE	19U 
#define	GPIO_FUNC1_FSEL_IO12_MSK	BITS(GPIO_FUNC1_FSEL_IO12_POSS,GPIO_FUNC1_FSEL_IO12_POSE)

#define	GPIO_FUNC1_FSEL_IO11_POSS	12U 
#define	GPIO_FUNC1_FSEL_IO11_POSE	15U 
#define	GPIO_FUNC1_FSEL_IO11_MSK	BITS(GPIO_FUNC1_FSEL_IO11_POSS,GPIO_FUNC1_FSEL_IO11_POSE)

#define	GPIO_FUNC1_FSEL_IO10_POSS	8U 
#define	GPIO_FUNC1_FSEL_IO10_POSE	11U 
#define	GPIO_FUNC1_FSEL_IO10_MSK	BITS(GPIO_FUNC1_FSEL_IO10_POSS,GPIO_FUNC1_FSEL_IO10_POSE)

#define	GPIO_FUNC1_FSEL_IO9_POSS	4U 
#define	GPIO_FUNC1_FSEL_IO9_POSE	7U 
#define	GPIO_FUNC1_FSEL_IO9_MSK	BITS(GPIO_FUNC1_FSEL_IO9_POSS,GPIO_FUNC1_FSEL_IO9_POSE)

#define	GPIO_FUNC1_FSEL_IO8_POSS	0U 
#define	GPIO_FUNC1_FSEL_IO8_POSE	3U 
#define	GPIO_FUNC1_FSEL_IO8_MSK	BITS(GPIO_FUNC1_FSEL_IO8_POSS,GPIO_FUNC1_FSEL_IO8_POSE)

/****************** Bit definition for GPIO_LOCK register ************************/

#define	GPIO_LOCK_KEY_POSS	16U 
#define	GPIO_LOCK_KEY_POSE	31U 
#define	GPIO_LOCK_KEY_MSK	BITS(GPIO_LOCK_KEY_POSS,GPIO_LOCK_KEY_POSE)

#define	GPIO_LOCK_LOCK_POSS	0U 
#define	GPIO_LOCK_LOCK_POSE	15U 
#define	GPIO_LOCK_LOCK_MSK	BITS(GPIO_LOCK_LOCK_POSS,GPIO_LOCK_LOCK_POSE)

typedef struct
{
	__I uint32_t DIN;
	__IO uint32_t DOUT;
	__O uint32_t BSRR;
	__O uint32_t BIR;
	__IO uint32_t MODE;
	__IO uint32_t ODOS;
	__IO uint32_t PUPD;
	__IO uint32_t PODRV;
	__IO uint32_t NODRV;
	__IO uint32_t FLT;
	__IO uint32_t TYPE;
	__IO uint32_t FUNC0;
	__IO uint32_t FUNC1;
	__IO uint32_t LOCK;
} GPIO_TypeDef;

/****************** Bit definition for GPIO_EXTIRER register ************************/

#define	GPIO_EXTIRER_EXTIRER_POSS	0U 
#define	GPIO_EXTIRER_EXTIRER_POSE	15U 
#define	GPIO_EXTIRER_EXTIRER_MSK	BITS(GPIO_EXTIRER_EXTIRER_POSS,GPIO_EXTIRER_EXTIRER_POSE)

/****************** Bit definition for GPIO_EXTIFER register ************************/

#define	GPIO_EXTIFER_EXTIFER_POSS	0U 
#define	GPIO_EXTIFER_EXTIFER_POSE	15U 
#define	GPIO_EXTIFER_EXTIFER_MSK	BITS(GPIO_EXTIFER_EXTIFER_POSS,GPIO_EXTIFER_EXTIFER_POSE)

/****************** Bit definition for GPIO_EXTIEN register ************************/

#define	GPIO_EXTIEN_EXTIEN_POSS	0U 
#define	GPIO_EXTIEN_EXTIEN_POSE	15U 
#define	GPIO_EXTIEN_EXTIEN_MSK	BITS(GPIO_EXTIEN_EXTIEN_POSS,GPIO_EXTIEN_EXTIEN_POSE)

/****************** Bit definition for GPIO_EXTIFLAG register ************************/

#define	GPIO_EXTIFLAG_EXTIFLAG_POSS	0U 
#define	GPIO_EXTIFLAG_EXTIFLAG_POSE	15U 
#define	GPIO_EXTIFLAG_EXTIFLAG_MSK	BITS(GPIO_EXTIFLAG_EXTIFLAG_POSS,GPIO_EXTIFLAG_EXTIFLAG_POSE)

/****************** Bit definition for GPIO_EXTISFR register ************************/

#define	GPIO_EXTISFR_EXTISFR_POSS	0U 
#define	GPIO_EXTISFR_EXTISFR_POSE	15U 
#define	GPIO_EXTISFR_EXTISFR_MSK	BITS(GPIO_EXTISFR_EXTISFR_POSS,GPIO_EXTISFR_EXTISFR_POSE)

/****************** Bit definition for GPIO_EXTICFR register ************************/

#define	GPIO_EXTICFR_EXTICFR_POSS	0U 
#define	GPIO_EXTICFR_EXTICFR_POSE	15U 
#define	GPIO_EXTICFR_EXTICFR_MSK	BITS(GPIO_EXTICFR_EXTICFR_POSS,GPIO_EXTICFR_EXTICFR_POSE)

/****************** Bit definition for GPIO_EXTIPSR0 register ************************/

#define	GPIO_EXTIPSR0_EXTIS7_POSS	28U 
#define	GPIO_EXTIPSR0_EXTIS7_POSE	30U 
#define	GPIO_EXTIPSR0_EXTIS7_MSK	BITS(GPIO_EXTIPSR0_EXTIS7_POSS,GPIO_EXTIPSR0_EXTIS7_POSE)

#define	GPIO_EXTIPSR0_EXTIS6_POSS	24U 
#define	GPIO_EXTIPSR0_EXTIS6_POSE	26U 
#define	GPIO_EXTIPSR0_EXTIS6_MSK	BITS(GPIO_EXTIPSR0_EXTIS6_POSS,GPIO_EXTIPSR0_EXTIS6_POSE)

#define	GPIO_EXTIPSR0_EXTIS5_POSS	20U 
#define	GPIO_EXTIPSR0_EXTIS5_POSE	22U 
#define	GPIO_EXTIPSR0_EXTIS5_MSK	BITS(GPIO_EXTIPSR0_EXTIS5_POSS,GPIO_EXTIPSR0_EXTIS5_POSE)

#define	GPIO_EXTIPSR0_EXTIS4_POSS	16U 
#define	GPIO_EXTIPSR0_EXTIS4_POSE	18U 
#define	GPIO_EXTIPSR0_EXTIS4_MSK	BITS(GPIO_EXTIPSR0_EXTIS4_POSS,GPIO_EXTIPSR0_EXTIS4_POSE)

#define	GPIO_EXTIPSR0_EXTIS3_POSS	12U 
#define	GPIO_EXTIPSR0_EXTIS3_POSE	14U 
#define	GPIO_EXTIPSR0_EXTIS3_MSK	BITS(GPIO_EXTIPSR0_EXTIS3_POSS,GPIO_EXTIPSR0_EXTIS3_POSE)

#define	GPIO_EXTIPSR0_EXTIS2_POSS	8U 
#define	GPIO_EXTIPSR0_EXTIS2_POSE	10U 
#define	GPIO_EXTIPSR0_EXTIS2_MSK	BITS(GPIO_EXTIPSR0_EXTIS2_POSS,GPIO_EXTIPSR0_EXTIS2_POSE)

#define	GPIO_EXTIPSR0_EXTIS1_POSS	4U 
#define	GPIO_EXTIPSR0_EXTIS1_POSE	6U 
#define	GPIO_EXTIPSR0_EXTIS1_MSK	BITS(GPIO_EXTIPSR0_EXTIS1_POSS,GPIO_EXTIPSR0_EXTIS1_POSE)

#define	GPIO_EXTIPSR0_EXTIS0_POSS	0U 
#define	GPIO_EXTIPSR0_EXTIS0_POSE	2U 
#define	GPIO_EXTIPSR0_EXTIS0_MSK	BITS(GPIO_EXTIPSR0_EXTIS0_POSS,GPIO_EXTIPSR0_EXTIS0_POSE)

/****************** Bit definition for GPIO_EXTIPSR1 register ************************/

#define	GPIO_EXTIPSR1_EXTIS15_POSS	28U 
#define	GPIO_EXTIPSR1_EXTIS15_POSE	30U 
#define	GPIO_EXTIPSR1_EXTIS15_MSK	BITS(GPIO_EXTIPSR1_EXTIS15_POSS,GPIO_EXTIPSR1_EXTIS15_POSE)

#define	GPIO_EXTIPSR1_EXTIS14_POSS	24U 
#define	GPIO_EXTIPSR1_EXTIS14_POSE	26U 
#define	GPIO_EXTIPSR1_EXTIS14_MSK	BITS(GPIO_EXTIPSR1_EXTIS14_POSS,GPIO_EXTIPSR1_EXTIS14_POSE)

#define	GPIO_EXTIPSR1_EXTIS13_POSS	20U 
#define	GPIO_EXTIPSR1_EXTIS13_POSE	22U 
#define	GPIO_EXTIPSR1_EXTIS13_MSK	BITS(GPIO_EXTIPSR1_EXTIS13_POSS,GPIO_EXTIPSR1_EXTIS13_POSE)

#define	GPIO_EXTIPSR1_EXTIS12_POSS	16U 
#define	GPIO_EXTIPSR1_EXTIS12_POSE	18U 
#define	GPIO_EXTIPSR1_EXTIS12_MSK	BITS(GPIO_EXTIPSR1_EXTIS12_POSS,GPIO_EXTIPSR1_EXTIS12_POSE)

#define	GPIO_EXTIPSR1_EXTIS11_POSS	12U 
#define	GPIO_EXTIPSR1_EXTIS11_POSE	14U 
#define	GPIO_EXTIPSR1_EXTIS11_MSK	BITS(GPIO_EXTIPSR1_EXTIS11_POSS,GPIO_EXTIPSR1_EXTIS11_POSE)

#define	GPIO_EXTIPSR1_EXTIS10_POSS	8U 
#define	GPIO_EXTIPSR1_EXTIS10_POSE	10U 
#define	GPIO_EXTIPSR1_EXTIS10_MSK	BITS(GPIO_EXTIPSR1_EXTIS10_POSS,GPIO_EXTIPSR1_EXTIS10_POSE)

#define	GPIO_EXTIPSR1_EXTIS9_POSS	4U 
#define	GPIO_EXTIPSR1_EXTIS9_POSE	6U 
#define	GPIO_EXTIPSR1_EXTIS9_MSK	BITS(GPIO_EXTIPSR1_EXTIS9_POSS,GPIO_EXTIPSR1_EXTIS9_POSE)

#define	GPIO_EXTIPSR1_EXTIS8_POSS	0U 
#define	GPIO_EXTIPSR1_EXTIS8_POSE	2U 
#define	GPIO_EXTIPSR1_EXTIS8_MSK	BITS(GPIO_EXTIPSR1_EXTIS8_POSS,GPIO_EXTIPSR1_EXTIS8_POSE)

/****************** Bit definition for GPIO_EXTIFLTCR register ************************/

#define	GPIO_EXTIFLTCR_FLTCKS_POSS	24U 
#define	GPIO_EXTIFLTCR_FLTCKS_POSE	25U 
#define	GPIO_EXTIFLTCR_FLTCKS_MSK	BITS(GPIO_EXTIFLTCR_FLTCKS_POSS,GPIO_EXTIFLTCR_FLTCKS_POSE)

#define	GPIO_EXTIFLTCR_FLTSEL_POSS	16U 
#define	GPIO_EXTIFLTCR_FLTSEL_POSE	23U 
#define	GPIO_EXTIFLTCR_FLTSEL_MSK	BITS(GPIO_EXTIFLTCR_FLTSEL_POSS,GPIO_EXTIFLTCR_FLTSEL_POSE)

#define	GPIO_EXTIFLTCR_FLTEN_POSS	0U 
#define	GPIO_EXTIFLTCR_FLTEN_POSE	15U 
#define	GPIO_EXTIFLTCR_FLTEN_MSK	BITS(GPIO_EXTIFLTCR_FLTEN_POSS,GPIO_EXTIFLTCR_FLTEN_POSE)

typedef struct
{
	__IO uint32_t EXTIRER;
	uint32_t RESERVED0 ;
	__IO uint32_t EXTIFER;
	uint32_t RESERVED1 ;
	__IO uint32_t EXTIEN;
	uint32_t RESERVED2 ;
	__I uint32_t EXTIFLAG;
	uint32_t RESERVED3 ;
	__O uint32_t EXTISFR;
	uint32_t RESERVED4 ;
	__O uint32_t EXTICFR;
	uint32_t RESERVED5 ;
	__IO uint32_t EXTIPSR0;
	__IO uint32_t EXTIPSR1;
	uint32_t RESERVED6[2] ;
	__IO uint32_t EXTIFLTCR;
} EXTI_TypeDef;

/****************** Bit definition for TIMER_CON1 register ************************/

#define	TIMER_CON1_DBGSEL_POSS	15U 
#define	TIMER_CON1_DBGSEL_MSK	BIT(TIMER_CON1_DBGSEL_POSS)

#define	TIMER_CON1_OCCISS_POSS	11U 
#define	TIMER_CON1_OCCISS_POSE	13U 
#define	TIMER_CON1_OCCISS_MSK	BITS(TIMER_CON1_OCCISS_POSS,TIMER_CON1_OCCISS_POSE)

#define	TIMER_CON1_OCCISP_POSS	10U 
#define	TIMER_CON1_OCCISP_MSK	BIT(TIMER_CON1_OCCISP_POSS)

#define	TIMER_CON1_DFCKSEL_POSS	8U 
#define	TIMER_CON1_DFCKSEL_POSE	9U 
#define	TIMER_CON1_DFCKSEL_MSK	BITS(TIMER_CON1_DFCKSEL_POSS,TIMER_CON1_DFCKSEL_POSE)

#define	TIMER_CON1_ARPEN_POS	7U 
#define	TIMER_CON1_ARPEN_MSK	BIT(TIMER_CON1_ARPEN_POS)

#define	TIMER_CON1_CMSEL_POSS	5U 
#define	TIMER_CON1_CMSEL_POSE	6U 
#define	TIMER_CON1_CMSEL_MSK	BITS(TIMER_CON1_CMSEL_POSS,TIMER_CON1_CMSEL_POSE)

#define	TIMER_CON1_DIRSEL_POS	4U 
#define	TIMER_CON1_DIRSEL_MSK	BIT(TIMER_CON1_DIRSEL_POS)

#define	TIMER_CON1_SPMEN_POS	3U 
#define	TIMER_CON1_SPMEN_MSK	BIT(TIMER_CON1_SPMEN_POS)

#define	TIMER_CON1_UERSEL_POS	2U 
#define	TIMER_CON1_UERSEL_MSK	BIT(TIMER_CON1_UERSEL_POS)

#define	TIMER_CON1_DISUE_POS	1U 
#define	TIMER_CON1_DISUE_MSK	BIT(TIMER_CON1_DISUE_POS)

#define	TIMER_CON1_CNTEN_POS	0U 
#define	TIMER_CON1_CNTEN_MSK	BIT(TIMER_CON1_CNTEN_POS)

/****************** Bit definition for TIMER_CON2 register ************************/

#define	TIMER_CON2_OISS4_POS	14U 
#define	TIMER_CON2_OISS4_MSK	BIT(TIMER_CON2_OISS4_POS)

#define	TIMER_CON2_OISS3N_POS	13U 
#define	TIMER_CON2_OISS3N_MSK	BIT(TIMER_CON2_OISS3N_POS)

#define	TIMER_CON2_OISS3_POS	12U 
#define	TIMER_CON2_OISS3_MSK	BIT(TIMER_CON2_OISS3_POS)

#define	TIMER_CON2_OISS2N_POS	11U 
#define	TIMER_CON2_OISS2N_MSK	BIT(TIMER_CON2_OISS2N_POS)

#define	TIMER_CON2_OISS2_POS	10U 
#define	TIMER_CON2_OISS2_MSK	BIT(TIMER_CON2_OISS2_POS)

#define	TIMER_CON2_OISS1N_POS	9U 
#define	TIMER_CON2_OISS1N_MSK	BIT(TIMER_CON2_OISS1N_POS)

#define	TIMER_CON2_OISS1_POS	8U 
#define	TIMER_CON2_OISS1_MSK	BIT(TIMER_CON2_OISS1_POS)

#define	TIMER_CON2_I1FSEL_POS	7U 
#define	TIMER_CON2_I1FSEL_MSK	BIT(TIMER_CON2_I1FSEL_POS)

#define	TIMER_CON2_TRGOSEL_POSS	4U 
#define	TIMER_CON2_TRGOSEL_POSE	6U 
#define	TIMER_CON2_TRGOSEL_MSK	BITS(TIMER_CON2_TRGOSEL_POSS,TIMER_CON2_TRGOSEL_POSE)

#define	TIMER_CON2_CCDMASEL_POS	3U 
#define	TIMER_CON2_CCDMASEL_MSK	BIT(TIMER_CON2_CCDMASEL_POS)

#define	TIMER_CON2_CCUSEL_POS	2U 
#define	TIMER_CON2_CCUSEL_MSK	BIT(TIMER_CON2_CCUSEL_POS)

#define	TIMER_CON2_CCPCEN_POS	0U 
#define	TIMER_CON2_CCPCEN_MSK	BIT(TIMER_CON2_CCPCEN_POS)

/****************** Bit definition for TIMER_SMCON register ************************/

#define	TIMER_SMCON_ETPOL_POS	15U 
#define	TIMER_SMCON_ETPOL_MSK	BIT(TIMER_SMCON_ETPOL_POS)

#define	TIMER_SMCON_ECM2EN_POS	14U 
#define	TIMER_SMCON_ECM2EN_MSK	BIT(TIMER_SMCON_ECM2EN_POS)

#define	TIMER_SMCON_ETPSEL_POSS	12U 
#define	TIMER_SMCON_ETPSEL_POSE	13U 
#define	TIMER_SMCON_ETPSEL_MSK	BITS(TIMER_SMCON_ETPSEL_POSS,TIMER_SMCON_ETPSEL_POSE)

#define	TIMER_SMCON_ETFLT_POSS	8U 
#define	TIMER_SMCON_ETFLT_POSE	11U 
#define	TIMER_SMCON_ETFLT_MSK	BITS(TIMER_SMCON_ETFLT_POSS,TIMER_SMCON_ETFLT_POSE)

#define	TIMER_SMCON_MSCFG_POS	7U 
#define	TIMER_SMCON_MSCFG_MSK	BIT(TIMER_SMCON_MSCFG_POS)

#define	TIMER_SMCON_TSSEL_POSS	4U 
#define	TIMER_SMCON_TSSEL_POSE	6U 
#define	TIMER_SMCON_TSSEL_MSK	BITS(TIMER_SMCON_TSSEL_POSS,TIMER_SMCON_TSSEL_POSE)

#define TIMER_SMCON_CHCSEL_POS  3U
#define TIMER_SMCON_CHCSEL_MASK BIT(TIMER_SMCON_CHCSEL_POS)

#define	TIMER_SMCON_SMODS_POSS	0U 
#define	TIMER_SMCON_SMODS_POSE	2U 
#define	TIMER_SMCON_SMODS_MSK	BITS(TIMER_SMCON_SMODS_POSS,TIMER_SMCON_SMODS_POSE)

/****************** Bit definition for TIMER_IER register ************************/

#define	TIMER_IER_BRKIT_POS	7U 
#define	TIMER_IER_BRKIT_MSK	BIT(TIMER_IER_BRKIT_POS)

#define	TIMER_IER_TRGIT_POS	6U 
#define	TIMER_IER_TRGIT_MSK	BIT(TIMER_IER_TRGIT_POS)

#define	TIMER_IER_COMIT_POS	5U 
#define	TIMER_IER_COMIT_MSK	BIT(TIMER_IER_COMIT_POS)

#define	TIMER_IER_CC4IT_POS	4U 
#define	TIMER_IER_CC4IT_MSK	BIT(TIMER_IER_CC4IT_POS)

#define	TIMER_IER_CC3IT_POS	3U 
#define	TIMER_IER_CC3IT_MSK	BIT(TIMER_IER_CC3IT_POS)

#define	TIMER_IER_CC2IT_POS	2U 
#define	TIMER_IER_CC2IT_MSK	BIT(TIMER_IER_CC2IT_POS)

#define	TIMER_IER_CC1IT_POS	1U 
#define	TIMER_IER_CC1IT_MSK	BIT(TIMER_IER_CC1IT_POS)

#define	TIMER_IER_UIT_POS	0U 
#define	TIMER_IER_UIT_MSK	BIT(TIMER_IER_UIT_POS)

/****************** Bit definition for TIMER_IDR register ************************/
#define	TIMER_IDR_BRKI_POS	7U 
#define	TIMER_IDR_BRKI_MSK	BIT(TIMER_IDR_BRKI_POS)

#define	TIMER_IDR_TRGI_POS	6U 
#define	TIMER_IDR_TRGI_MSK	BIT(TIMER_IDR_TRGI_POS)

#define	TIMER_IDR_COMI_POS	5U 
#define	TIMER_IDR_COMI_MSK	BIT(TIMER_IDR_COMI_POS)

#define	TIMER_IDR_CC4I_POS	4U 
#define	TIMER_IDR_CC4I_MSK	BIT(TIMER_IDR_CC4I_POS)

#define	TIMER_IDR_CC3I_POS	3U 
#define	TIMER_IDR_CC3I_MSK	BIT(TIMER_IDR_CC3I_POS)

#define	TIMER_IDR_CC2I_POS	2U 
#define	TIMER_IDR_CC2I_MSK	BIT(TIMER_IDR_CC2I_POS)

#define	TIMER_IDR_CC1I_POS	1U 
#define	TIMER_IDR_CC1I_MSK	BIT(TIMER_IDR_CC1I_POS)

#define	TIMER_IDR_UI_POS	0U 
#define	TIMER_IDR_UI_MSK	BIT(TIMER_IDR_UI_POS)

/****************** Bit definition for TIMER_IVS register ************************/

#define	TIMER_IVS_BKI_POS	7U 
#define	TIMER_IVS_BKI_MSK	BIT(TIMER_IVS_BKI_POS)

#define	TIMER_IVS_TRGI_POS	6U 
#define	TIMER_IVS_TRGI_MSK	BIT(TIMER_IVS_TRGI_POS)

#define	TIMER_IVS_COMI_POS	5U 
#define	TIMER_IVS_COMI_MSK	BIT(TIMER_IVS_COMI_POS)

#define	TIMER_IVS_CC4I_POS	4U 
#define	TIMER_IVS_CC4I_MSK	BIT(TIMER_IVS_CC4I_POS)

#define	TIMER_IVS_CC3I_POS	3U 
#define	TIMER_IVS_CC3I_MSK	BIT(TIMER_IVS_CC3I_POS)

#define	TIMER_IVS_CC2I_POS	2U 
#define	TIMER_IVS_CC2I_MSK	BIT(TIMER_IVS_CC2I_POS)

#define	TIMER_IVS_CC1I_POS	1U 
#define	TIMER_IVS_CC1I_MSK	BIT(TIMER_IVS_CC1I_POS)

#define	TIMER_IVS_UEI_POS	0U 
#define	TIMER_IVS_UEI_MSK	BIT(TIMER_IVS_UEI_POS)

/****************** Bit definition for TIMER_RIF register ************************/

#define	TIMER_RIF_CH4OVIF_POS	12U 
#define	TIMER_RIF_CH4OVIF_MSK	BIT(TIMER_RIF_CH4OVIF_POS)

#define	TIMER_RIF_CH3OVIF_POS	11U 
#define	TIMER_RIF_CH3OVIF_MSK	BIT(TIMER_RIF_CH3OVIF_POS)

#define	TIMER_RIF_CH2OVIF_POS	10U 
#define	TIMER_RIF_CH2OVIF_MSK	BIT(TIMER_RIF_CH2OVIF_POS)

#define	TIMER_RIF_CH1OVIF_POS	9U 
#define	TIMER_RIF_CH1OVIF_MSK	BIT(TIMER_RIF_CH1OVIF_POS)

#define	TIMER_RIF_BRKIF_POS	7U 
#define	TIMER_RIF_BRKIF_MSK	BIT(TIMER_RIF_BRKIF_POS)

#define	TIMER_RIF_TRGIF_POS	6U 
#define	TIMER_RIF_TRGIF_MSK	BIT(TIMER_RIF_TRGIF_POS)

#define	TIMER_RIF_COMIF_POS	5U 
#define	TIMER_RIF_COMIF_MSK	BIT(TIMER_RIF_COMIF_POS)

#define	TIMER_RIF_CH4IF_POS	4U 
#define	TIMER_RIF_CH4IF_MSK	BIT(TIMER_RIF_CH4IF_POS)

#define	TIMER_RIF_CH3IF_POS	3U 
#define	TIMER_RIF_CH3IF_MSK	BIT(TIMER_RIF_CH3IF_POS)

#define	TIMER_RIF_CH2IF_POS	2U 
#define	TIMER_RIF_CH2IF_MSK	BIT(TIMER_RIF_CH2IF_POS)

#define	TIMER_RIF_CH1IF_POS	1U 
#define	TIMER_RIF_CH1IF_MSK	BIT(TIMER_RIF_CH1IF_POS)

#define	TIMER_RIF_UEVTIF_POS	0U 
#define	TIMER_RIF_UEVTIF_MSK	BIT(TIMER_RIF_UEVTIF_POS)

/****************** Bit definition for TIMER_IFM register ************************/

#define	TIMER_IFM_BRKIM_POS	7U 
#define	TIMER_IFM_BRKIM_MSK	BIT(TIMER_IFM_BRKIM_POS)

#define	TIMER_IFM_TRGI_POS	6U 
#define	TIMER_IFM_TRGI_MSK	BIT(TIMER_IFM_TRGI_POS)

#define	TIMER_IFM_COMI_POS	5U 
#define	TIMER_IFM_COMI_MSK	BIT(TIMER_IFM_COMI_POS)

#define	TIMER_IFM_CH4CCI_POS	4U 
#define	TIMER_IFM_CH4CCI_MSK	BIT(TIMER_IFM_CH4CCI_POS)

#define	TIMER_IFM_CH3CCI_POS	3U 
#define	TIMER_IFM_CH3CCI_MSK	BIT(TIMER_IFM_CH3CCI_POS)

#define	TIMER_IFM_CH2CCI_POS	2U 
#define	TIMER_IFM_CH2CCI_MSK	BIT(TIMER_IFM_CH2CCI_POS)

#define	TIMER_IFM_CH1CCI_POS	1U 
#define	TIMER_IFM_CH1CCI_MSK	BIT(TIMER_IFM_CH1CCI_POS)

#define	TIMER_IFM_UEI_POS	0U 
#define	TIMER_IFM_UEI_MSK	BIT(TIMER_IFM_UEI_POS)

/****************** Bit definition for TIMER_ICR register ************************/

#define	TIMER_ICR_BRKIC_POS	7U 
#define	TIMER_ICR_BRKIC_MSK	BIT(TIMER_ICR_BRKIC_POS)

#define	TIMER_ICR_TRGIC_POS	6U 
#define	TIMER_ICR_TRGIC_MSK	BIT(TIMER_ICR_TRGIC_POS)

#define	TIMER_ICR_COMIC_POS	5U 
#define	TIMER_ICR_COMIC_MSK	BIT(TIMER_ICR_COMIC_POS)

#define	TIMER_ICR_CH4CCIC_POS	4U 
#define	TIMER_ICR_CH4CCIC_MSK	BIT(TIMER_ICR_CH4CCIC_POS)

#define	TIMER_ICR_CH3CCIC_POS	3U 
#define	TIMER_ICR_CH3CCIC_MSK	BIT(TIMER_ICR_CH3CCIC_POS)

#define	TIMER_ICR_CH2CCIC_POS	2U 
#define	TIMER_ICR_CH2CCIC_MSK	BIT(TIMER_ICR_CH2CCIC_POS)

#define	TIMER_ICR_CH1CCIC_POS	1U 
#define	TIMER_ICR_CH1CCIC_MSK	BIT(TIMER_ICR_CH1CCIC_POS)

#define	TIMER_ICR_UEIC_POS	0U 
#define	TIMER_ICR_UEIC_MSK	BIT(TIMER_ICR_UEIC_POS)

/****************** Bit definition for TIMER_SGE register ************************/

#define	TIMER_SGE_SGBRK_POS	7U 
#define	TIMER_SGE_SGBRK_MSK	BIT(TIMER_SGE_SGBRK_POS)

#define	TIMER_SGE_SGTRG_POS	6U 
#define	TIMER_SGE_SGTRG_MSK	BIT(TIMER_SGE_SGTRG_POS)

#define	TIMER_SGE_SGCOM_POS	5U 
#define	TIMER_SGE_SGCOM_MSK	BIT(TIMER_SGE_SGCOM_POS)

#define	TIMER_SGE_SGCC4E_POS	4U 
#define	TIMER_SGE_SGCC4E_MSK	BIT(TIMER_SGE_SGCC4E_POS)

#define	TIMER_SGE_SGCC3E_POS	3U 
#define	TIMER_SGE_SGCC3E_MSK	BIT(TIMER_SGE_SGCC3E_POS)

#define	TIMER_SGE_SGCC2E_POS	2U 
#define	TIMER_SGE_SGCC2E_MSK	BIT(TIMER_SGE_SGCC2E_POS)

#define	TIMER_SGE_SGCC1E_POS	1U 
#define	TIMER_SGE_SGCC1E_MSK	BIT(TIMER_SGE_SGCC1E_POS)

#define	TIMER_SGE_SGU_POS	0U 
#define	TIMER_SGE_SGU_MSK	BIT(TIMER_SGE_SGU_POS)

/****************** Bit definition for TIMER_CHMR1 register ************************/
/* Output */
#define	TIMER_CHMR1_CH2OCLREN_POS	15U 
#define	TIMER_CHMR1_CH2OCLREN_MSK	BIT(TIMER_CHMR1_CH2OCLREN_POS)

#define	TIMER_CHMR1_CH2OMOD_POSS	12U 
#define	TIMER_CHMR1_CH2OMOD_POSE	14U 
#define	TIMER_CHMR1_CH2OMOD_MSK	BITS(TIMER_CHMR1_CH2OMOD_POSS,TIMER_CHMR1_CH2OMOD_POSE)

#define	TIMER_CHMR1_CH2OPEN_POS	11U 
#define	TIMER_CHMR1_CH2OPEN_MSK	BIT(TIMER_CHMR1_CH2OPEN_POS)

#define	TIMER_CHMR1_CH2OFEN_POS	10U 
#define	TIMER_CHMR1_CH2OFEN_MSK	BIT(TIMER_CHMR1_CH2OFEN_POS)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_CH1OCLREN_POS	7U 
#define	TIMER_CHMR1_CH1OCLREN_MSK	BIT(TIMER_CHMR1_CH1OCLREN_POS)

#define	TIMER_CHMR1_CH1OMOD_POSS	4U 
#define	TIMER_CHMR1_CH1OMOD_POSE	6U 
#define	TIMER_CHMR1_CH1OMOD_MSK	BITS(TIMER_CHMR1_CH1OMOD_POSS,TIMER_CHMR1_CH1OMOD_POSE)

#define	TIMER_CHMR1_CH1OPREN_POS	3U 
#define	TIMER_CHMR1_CH1OPREN_MSK	BIT(TIMER_CHMR1_CH1OPREN_POS)

#define	TIMER_CHMR1_CH1OHSEN_POS	2U 
#define	TIMER_CHMR1_CH1OHSEN_MSK	BIT(TIMER_CHMR1_CH1OHSEN_POS)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/* Input */
#define	TIMER_CHMR1_I2FLT_POSS	12U 
#define	TIMER_CHMR1_I2FLT_POSE	15U 
#define	TIMER_CHMR1_I2FLT_MSK	BITS(TIMER_CHMR1_I2FLT_POSS,TIMER_CHMR1_I2FLT_POSE)

#define	TIMER_CHMR1_IC2PRES_POSS	10U 
#define	TIMER_CHMR1_IC2PRES_POSE	11U 
#define	TIMER_CHMR1_IC2PRES_MSK	BITS(TIMER_CHMR1_IC2PRES_POSS,TIMER_CHMR1_IC2PRES_POSE)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_I1FLT_POSS	4U 
#define	TIMER_CHMR1_I1FLT_POSE	7U 
#define	TIMER_CHMR1_I1FLT_MSK	BITS(TIMER_CHMR1_I1FLT_POSS,TIMER_CHMR1_I1FLT_POSE)

#define	TIMER_CHMR1_IC1PRES_POSS	2U 
#define	TIMER_CHMR1_IC1PRES_POSE	3U 
#define	TIMER_CHMR1_IC1PRES_MSK	BITS(TIMER_CHMR1_IC1PRES_POSS,TIMER_CHMR1_IC1PRES_POSE)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2 register ************************/
/* Output */
#define	TIMER_CHMR2_CH4OCLREN_POS	15U 
#define	TIMER_CHMR2_CH4OCLREN_MSK	BIT(TIMER_CHMR2_CH4OCLREN_POS)

#define	TIMER_CHMR2_CH4OMOD_POSS	12U 
#define	TIMER_CHMR2_CH4OMOD_POSE	14U 
#define	TIMER_CHMR2_CH4OMOD_MSK	BITS(TIMER_CHMR2_CH4OMOD_POSS,TIMER_CHMR2_CH4OMOD_POSE)

#define	TIMER_CHMR2_CH4OPEN_POS	11U 
#define	TIMER_CHMR2_CH4OPEN_MSK	BIT(TIMER_CHMR2_CH4OPEN_POS)

#define	TIMER_CHMR2_CH4OHSEN_POS	10U 
#define	TIMER_CHMR2_CH4OHSEN_MSK	BIT(TIMER_CHMR2_CH4OHSEN_POS)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_CH3OCLREN_POS	7U 
#define	TIMER_CHMR2_CH3OCLREN_MSK	BIT(TIMER_CHMR2_CH3OCLREN_POS)

#define	TIMER_CHMR2_CH3OMOD_POSS	4U 
#define	TIMER_CHMR2_CH3OMOD_POSE	6U 
#define	TIMER_CHMR2_CH3OMOD_MSK	BITS(TIMER_CHMR2_CH3OMOD_POSS,TIMER_CHMR2_CH3OMOD_POSE)

#define	TIMER_CHMR2_CH3OPEN_POS	3U 
#define	TIMER_CHMR2_CH3OPEN_MSK	BIT(TIMER_CHMR2_CH3OPEN_POS)

#define	TIMER_CHMR2_CH3OFEN_POS	2U 
#define	TIMER_CHMR2_CH3OFEN_MSK	BIT(TIMER_CHMR2_CH3OFEN_POS)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U 
#define	TIMER_CHMR2_CC3SSEL_POSE	1U 
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/* Input */
#define	TIMER_CHMR2_I4FLT_POSS	12U
#define	TIMER_CHMR2_I4FLT_POSE	15U
#define	TIMER_CHMR2_I4FLT_MSK	BITS(TIMER_CHMR2_I4FLT_POSS,TIMER_CHMR2_I4FLT_POSE)

#define	TIMER_CHMR2_IC4PRES_POSS	10U
#define	TIMER_CHMR2_IC4PRES_POSE	11U
#define	TIMER_CHMR2_IC4PRES_MSK	BITS(TIMER_CHMR2_IC4PRES_POSS,TIMER_CHMR2_IC4PRES_POSE)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_I3FLT_POSS	4U
#define	TIMER_CHMR2_I3FLT_POSE	7U
#define	TIMER_CHMR2_I3FLT_MSK	BITS(TIMER_CHMR2_I3FLT_POSS,TIMER_CHMR2_I3FLT_POSE)

#define	TIMER_CHMR2_IC3PRES_POSS	2U
#define	TIMER_CHMR2_IC3PRES_POSE	3U
#define	TIMER_CHMR2_IC3PRES_MSK	BITS(TIMER_CHMR2_IC3PRES_POSS,TIMER_CHMR2_IC3PRES_POSE)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U
#define	TIMER_CHMR2_CC3SSEL_POSE	1U
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CCEP register ************************/

#define	TIMER_CCEP_CC4POL_POS	13U 
#define	TIMER_CCEP_CC4POL_MSK	BIT(TIMER_CCEP_CC4POL_POS)

#define	TIMER_CCEP_CC4EN_POS	12U 
#define	TIMER_CCEP_CC4EN_MSK	BIT(TIMER_CCEP_CC4EN_POS)

#define	TIMER_CCEP_CC3NPOL_POS	11U 
#define	TIMER_CCEP_CC3NPOL_MSK	BIT(TIMER_CCEP_CC3NPOL_POS)

#define	TIMER_CCEP_CC3NEN_POS	10U 
#define	TIMER_CCEP_CC3NEN_MSK	BIT(TIMER_CCEP_CC3NEN_POS)

#define	TIMER_CCEP_CC3POL_POS	9U 
#define	TIMER_CCEP_CC3POL_MSK	BIT(TIMER_CCEP_CC3POL_POS)

#define	TIMER_CCEP_CC3EN_POS	8U 
#define	TIMER_CCEP_CC3EN_MSK	BIT(TIMER_CCEP_CC3EN_POS)

#define	TIMER_CCEP_CC2NPOL_POS	7U 
#define	TIMER_CCEP_CC2NPOL_MSK	BIT(TIMER_CCEP_CC2NPOL_POS)

#define	TIMER_CCEP_CC2NEN_POS	6U 
#define	TIMER_CCEP_CC2NEN_MSK	BIT(TIMER_CCEP_CC2NEN_POS)

#define	TIMER_CCEP_CC2POL_POS	5U 
#define	TIMER_CCEP_CC2POL_MSK	BIT(TIMER_CCEP_CC2POL_POS)

#define	TIMER_CCEP_CC2EN_POS	4U 
#define	TIMER_CCEP_CC2EN_MSK	BIT(TIMER_CCEP_CC2EN_POS)

#define	TIMER_CCEP_CC1NPOL_POS	3U 
#define	TIMER_CCEP_CC1NPOL_MSK	BIT(TIMER_CCEP_CC1NPOL_POS)

#define	TIMER_CCEP_CC1NEN_POS	2U 
#define	TIMER_CCEP_CC1NEN_MSK	BIT(TIMER_CCEP_CC1NEN_POS)

#define	TIMER_CCEP_CC1POL_POS	1U 
#define	TIMER_CCEP_CC1POL_MSK	BIT(TIMER_CCEP_CC1POL_POS)

#define	TIMER_CCEP_CC1EN_POS	0U 
#define	TIMER_CCEP_CC1EN_MSK	BIT(TIMER_CCEP_CC1EN_POS)

/****************** Bit definition for TIMER_COUNT register ************************/

#define	TIMER_COUNT_CNTV_POSS	0U 
#define	TIMER_COUNT_CNTV_POSE	15U 
#define	TIMER_COUNT_CNTV_MSK	BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)

/****************** Bit definition for TIMER_PRES register ************************/

#define	TIMER_PRES_PSCV_POSS	0U 
#define	TIMER_PRES_PSCV_POSE	15U 
#define	TIMER_PRES_PSCV_MSK	BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)

/****************** Bit definition for TIMER_AR register ************************/

#define	TIMER_AR_ARRV_POSS	0U 
#define	TIMER_AR_ARRV_POSE	15U 
#define	TIMER_AR_ARRV_MSK	BITS(TIMER_AR_ARRV_POSS,TIMER_AR_ARRV_POSE)

/****************** Bit definition for TIMER_REPAR register ************************/

#define	TIMER_REPAR_REPV_POSS	0U 
#define	TIMER_REPAR_REPV_POSE	7U 
#define	TIMER_REPAR_REPV_MSK	BITS(TIMER_REPAR_REPV_POSS,TIMER_REPAR_REPV_POSE)

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define	TIMER_CCVAL1_CCRV1_POSS	0U 
#define	TIMER_CCVAL1_CCRV1_POSE	15U 
#define	TIMER_CCVAL1_CCRV1_MSK	BITS(TIMER_CCVAL1_CCRV1_POSS,TIMER_CCVAL1_CCRV1_POSE)

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define	TIMER_CCVAL2_CCRV2_POSS	0U 
#define	TIMER_CCVAL2_CCRV2_POSE	15U 
#define	TIMER_CCVAL2_CCRV2_MSK	BITS(TIMER_CCVAL2_CCRV2_POSS,TIMER_CCVAL2_CCRV2_POSE)

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define	TIMER_CCVAL3_CCRV3_POSS	0U 
#define	TIMER_CCVAL3_CCRV3_POSE	15U 
#define	TIMER_CCVAL3_CCRV3_MSK	BITS(TIMER_CCVAL3_CCRV3_POSS,TIMER_CCVAL3_CCRV3_POSE)

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define	TIMER_CCVAL4_CCRV4_POSS	0U 
#define	TIMER_CCVAL4_CCRV4_POSE	15U 
#define	TIMER_CCVAL4_CCRV4_MSK	BITS(TIMER_CCVAL4_CCRV4_POSS,TIMER_CCVAL4_CCRV4_POSE)

/****************** Bit definition for TIMER_BDCFG register ************************/

#define	TIMER_BDCFG_GOEN_POS	15U 
#define	TIMER_BDCFG_GOEN_MSK	BIT(TIMER_BDCFG_GOEN_POS)

#define	TIMER_BDCFG_AOEN_POS	14U 
#define	TIMER_BDCFG_AOEN_MSK	BIT(TIMER_BDCFG_AOEN_POS)

#define	TIMER_BDCFG_BRKP_POS	13U 
#define	TIMER_BDCFG_BRKP_MSK	BIT(TIMER_BDCFG_BRKP_POS)

#define	TIMER_BDCFG_BRKEN_POS	12U 
#define	TIMER_BDCFG_BRKEN_MSK	BIT(TIMER_BDCFG_BRKEN_POS)

#define	TIMER_BDCFG_OFFSSR_POS	11U 
#define	TIMER_BDCFG_OFFSSR_MSK	BIT(TIMER_BDCFG_OFFSSR_POS)

#define	TIMER_BDCFG_OFFSSI_POS	10U 
#define	TIMER_BDCFG_OFFSSI_MSK	BIT(TIMER_BDCFG_OFFSSI_POS)

#define	TIMER_BDCFG_LOCKLVL_POSS	8U 
#define	TIMER_BDCFG_LOCKLVL_POSE	9U 
#define	TIMER_BDCFG_LOCKLVL_MSK	BITS(TIMER_BDCFG_LOCKLVL_POSS,TIMER_BDCFG_LOCKLVL_POSE)

#define	TIMER_BDCFG_DT_POSS	0U 
#define	TIMER_BDCFG_DT_POSE	7U 
#define	TIMER_BDCFG_DT_MSK	BITS(TIMER_BDCFG_DT_POSS,TIMER_BDCFG_DT_POSE)

/****************** Bit definition for TIMER_DMAEN register ************************/

#define	TIMER_DMAEN_TRGDMA_POS	6U 
#define	TIMER_DMAEN_TRGDMA_MSK	BIT(TIMER_DMAEN_TRGDMA_POS)
					  
#define	TIMER_DMAEN_COMD_POS	5U        
#define	TIMER_DMAEN_COMD_MSK	BIT(TIMER_DMAEN_COMD_POS)
					  
#define	TIMER_DMAEN_CC4D_POS	4U        
#define	TIMER_DMAEN_CC4D_MSK	BIT(TIMER_DMAEN_CC4D_POS)
					  
#define	TIMER_DMAEN_CC3D_POS	3U        
#define	TIMER_DMAEN_CC3D_MSK	BIT(TIMER_DMAEN_CC3D_POS)
					  
#define	TIMER_DMAEN_CC2D_POS	2U        
#define	TIMER_DMAEN_CC2D_MSK	BIT(TIMER_DMAEN_CC2D_POS)
					  
#define	TIMER_DMAEN_CC1D_POS	1U        
#define	TIMER_DMAEN_CC1D_MSK	BIT(TIMER_DMAEN_CC1D_POS)
					  
#define	TIMER_DMAEN_UD_POS	0U        
#define	TIMER_DMAEN_UD_MSK	BIT(TIMER_DMAEN_UD_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t SMCON;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
	__O uint32_t SGE;
	__IO uint32_t CHMR1;
	__IO uint32_t CHMR2;
	__IO uint32_t CCEP;
	__IO uint32_t COUNT;
	__IO uint32_t PRES;
	__IO uint32_t AR;
	__IO uint32_t REPAR;
	__IO uint32_t CCVAL1;
	__IO uint32_t CCVAL2;
	__IO uint32_t CCVAL3;
	__IO uint32_t CCVAL4;
	__IO uint32_t BDCFG;
	__IO uint32_t DMAEN;
} TIMER_TypeDef;

#ifdef ES32F36xx
#define	TIMER0  AD16C4T0
#define	TIMER1  AD16C4T1
#define	TIMER2  GP32C4T0
#define	TIMER3  GP32C4T1
#define	TIMER4  BS16T0	
#define	TIMER5  BS16T1	
#define	TIMER6  GP16C4T0
#define	TIMER7  GP16C4T1
#else
#define	TIMER0  GP16C4T0
#define	TIMER1  GP16C4T1
#define	TIMER2  GP32C4T0
#define	TIMER3  GP32C4T1
#define	TIMER4  BS16T0	
#define	TIMER5  BS16T1	
#define	TIMER6  GP16C4T2
#define	TIMER7  GP16C4T3
#endif

/****************** Bit definition for UART_RXBUF register ************************/

#define	UART_RXBUF_RXBUF_POSS	0U 
#define	UART_RXBUF_RXBUF_POSE	8U 
#define	UART_RXBUF_RXBUF_MSK	BITS(UART_RXBUF_RXBUF_POSS,UART_RXBUF_RXBUF_POSE)

/****************** Bit definition for UART_TXBUF register ************************/

#define	UART_TXBUF_TXBUF_POSS	0U 
#define	UART_TXBUF_TXBUF_POSE	8U 
#define	UART_TXBUF_TXBUF_MSK	BITS(UART_TXBUF_TXBUF_POSS,UART_TXBUF_TXBUF_POSE)

/****************** Bit definition for UART_BRR register ************************/

#define	UART_BRR_BRR_POSS	0U 
#define	UART_BRR_BRR_POSE	15U 
#define	UART_BRR_BRR_MSK	BITS(UART_BRR_BRR_POSS,UART_BRR_BRR_POSE)

/****************** Bit definition for UART_LCON register ************************/

#define	UART_LCON_TXEN_POS	15U 
#define	UART_LCON_TXEN_MSK	BIT(UART_LCON_TXEN_POS)

#define	UART_LCON_RXEN_POS	14U 
#define	UART_LCON_RXEN_MSK	BIT(UART_LCON_RXEN_POS)

#define	UART_LCON_DBCEN_POS	13U 
#define	UART_LCON_DBCEN_MSK	BIT(UART_LCON_DBCEN_POS)

#define	UART_LCON_BREAK_POS	10U 
#define	UART_LCON_BREAK_MSK	BIT(UART_LCON_BREAK_POS)

#define	UART_LCON_SWAP_POS	9U 
#define	UART_LCON_SWAP_MSK	BIT(UART_LCON_SWAP_POS)

#define	UART_LCON_TXINV_POS	8U 
#define	UART_LCON_TXINV_MSK	BIT(UART_LCON_TXINV_POS)

#define	UART_LCON_RXINV_POS	7U 
#define	UART_LCON_RXINV_MSK	BIT(UART_LCON_RXINV_POS)

#define	UART_LCON_DATAINV_POS	6U 
#define	UART_LCON_DATAINV_MSK	BIT(UART_LCON_DATAINV_POS)

#define	UART_LCON_MSB_POS	5U 
#define	UART_LCON_MSB_MSK	BIT(UART_LCON_MSB_POS)

#define	UART_LCON_PS_POS	4U 
#define	UART_LCON_PS_MSK	BIT(UART_LCON_PS_POS)

#define	UART_LCON_PE_POS	3U 
#define	UART_LCON_PE_MSK	BIT(UART_LCON_PE_POS)

#define	UART_LCON_STOP_POS	2U 
#define	UART_LCON_STOP_MSK	BIT(UART_LCON_STOP_POS)

#define	UART_LCON_DLS_POSS	0U 
#define	UART_LCON_DLS_POSE	1U 
#define	UART_LCON_DLS_MSK	BITS(UART_LCON_DLS_POSS,UART_LCON_DLS_POSE)

/****************** Bit definition for UART_MCON register ************************/

#define	UART_MCON_TXDMAEN_POS	15U 
#define	UART_MCON_TXDMAEN_MSK	BIT(UART_MCON_TXDMAEN_POS)

#define	UART_MCON_RXDMAEN_POS	14U 
#define	UART_MCON_RXDMAEN_MSK	BIT(UART_MCON_RXDMAEN_POS)

#define	UART_MCON_ABRREPT_POS	11U 
#define	UART_MCON_ABRREPT_MSK	BIT(UART_MCON_ABRREPT_POS)

#define	UART_MCON_ABRMOD_POSS	9U 
#define	UART_MCON_ABRMOD_POSE	10U 
#define	UART_MCON_ABRMOD_MSK	BITS(UART_MCON_ABRMOD_POSS,UART_MCON_ABRMOD_POSE)

#define	UART_MCON_ABREN_POS	8U 
#define	UART_MCON_ABREN_MSK	BIT(UART_MCON_ABREN_POS)

#define	UART_MCON_BKREQ_POS	5U 
#define	UART_MCON_BKREQ_MSK	BIT(UART_MCON_BKREQ_POS)

#define	UART_MCON_HDEN_POS	4U 
#define	UART_MCON_HDEN_MSK	BIT(UART_MCON_HDEN_POS)

#define	UART_MCON_IREN_POS	3U 
#define	UART_MCON_IREN_MSK	BIT(UART_MCON_IREN_POS)

#define	UART_MCON_AFCEN_POS	2U 
#define	UART_MCON_AFCEN_MSK	BIT(UART_MCON_AFCEN_POS)

#define	UART_MCON_RTSSET_POS	1U 
#define	UART_MCON_RTSSET_MSK	BIT(UART_MCON_RTSSET_POS)

#define	UART_MCON_LPBKEN_POS	0U 
#define	UART_MCON_LPBKEN_MSK	BIT(UART_MCON_LPBKEN_POS)

/****************** Bit definition for UART_RS485 register ************************/

#define	UART_RS485_DLY_POSS	16U 
#define	UART_RS485_DLY_POSE	23U 
#define	UART_RS485_DLY_MSK	BITS(UART_RS485_DLY_POSS,UART_RS485_DLY_POSE)

#define	UART_RS485_ADDR_POSS	8U 
#define	UART_RS485_ADDR_POSE	15U 
#define	UART_RS485_ADDR_MSK	BITS(UART_RS485_ADDR_POSS,UART_RS485_ADDR_POSE)

#define	UART_RS485_AADINV_POS	3U 
#define	UART_RS485_AADINV_MSK	BIT(UART_RS485_AADINV_POS)

#define	UART_RS485_AADACEN_POS	2U 
#define	UART_RS485_AADACEN_MSK	BIT(UART_RS485_AADACEN_POS)

#define	UART_RS485_AADNEN_POS	1U 
#define	UART_RS485_AADNEN_MSK	BIT(UART_RS485_AADNEN_POS)

#define	UART_RS485_AADEN_POS	0U 
#define	UART_RS485_AADEN_MSK	BIT(UART_RS485_AADEN_POS)

/****************** Bit definition for UART_SCARD register ************************/

#define	UART_SCARD_BLEN_POSS	24U 
#define	UART_SCARD_BLEN_POSE	31U 
#define	UART_SCARD_BLEN_MSK	BITS(UART_SCARD_BLEN_POSS,UART_SCARD_BLEN_POSE)

#define	UART_SCARD_GT_POSS	16U 
#define	UART_SCARD_GT_POSE	23U 
#define	UART_SCARD_GT_MSK	BITS(UART_SCARD_GT_POSS,UART_SCARD_GT_POSE)

#define	UART_SCARD_PSC_POSS	8U 
#define	UART_SCARD_PSC_POSE	15U 
#define	UART_SCARD_PSC_MSK	BITS(UART_SCARD_PSC_POSS,UART_SCARD_PSC_POSE)

#define	UART_SCARD_SCCNT_POSS	3U 
#define	UART_SCARD_SCCNT_POSE	5U 
#define	UART_SCARD_SCCNT_MSK	BITS(UART_SCARD_SCCNT_POSS,UART_SCARD_SCCNT_POSE)

#define	UART_SCARD_SCLKEN_POS	2U 
#define	UART_SCARD_SCLKEN_MSK	BIT(UART_SCARD_SCLKEN_POS)

#define	UART_SCARD_SCNACK_POS	1U 
#define	UART_SCARD_SCNACK_MSK	BIT(UART_SCARD_SCNACK_POS)

#define	UART_SCARD_SCEN_POS	0U 
#define	UART_SCARD_SCEN_MSK	BIT(UART_SCARD_SCEN_POS)

/****************** Bit definition for UART_LIN register ************************/

#define	UART_LIN_LINBKREQ_POS	2U 
#define	UART_LIN_LINBKREQ_MSK	BIT(UART_LIN_LINBKREQ_POS)

#define	UART_LIN_LINBDL_POS	1U 
#define	UART_LIN_LINBDL_MSK	BIT(UART_LIN_LINBDL_POS)

#define	UART_LIN_LINEN_POS	0U 
#define	UART_LIN_LINEN_MSK	BIT(UART_LIN_LINEN_POS)

/****************** Bit definition for UART_RTOR register ************************/

#define	UART_RTOR_RTOEN_POS	24U 
#define	UART_RTOR_RTOEN_MSK	BIT(UART_RTOR_RTOEN_POS)

#define	UART_RTOR_RTO_POSS	0U 
#define	UART_RTOR_RTO_POSE	23U 
#define	UART_RTOR_RTO_MSK	BITS(UART_RTOR_RTO_POSS,UART_RTOR_RTO_POSE)

/****************** Bit definition for UART_FCON register ************************/

#define	UART_FCON_TXFL_POSS	11U 
#define	UART_FCON_TXFL_POSE	15U 
#define	UART_FCON_TXFL_MSK	BITS(UART_FCON_TXFL_POSS,UART_FCON_TXFL_POSE)

#define	UART_FCON_TXTH_POSS	9U 
#define	UART_FCON_TXTH_POSE	10U 
#define	UART_FCON_TXTH_MSK	BITS(UART_FCON_TXTH_POSS,UART_FCON_TXTH_POSE)

#define	UART_FCON_TFRST_POS	8U 
#define	UART_FCON_TFRST_MSK	BIT(UART_FCON_TFRST_POS)

#define	UART_FCON_RXFL_POSS	3U 
#define	UART_FCON_RXFL_POSE	7U 
#define	UART_FCON_RXFL_MSK	BITS(UART_FCON_RXFL_POSS,UART_FCON_RXFL_POSE)

#define	UART_FCON_RXTH_POSS	1U 
#define	UART_FCON_RXTH_POSE	2U 
#define	UART_FCON_RXTH_MSK	BITS(UART_FCON_RXTH_POSS,UART_FCON_RXTH_POSE)

#define	UART_FCON_RFRST_POS	0U 
#define	UART_FCON_RFRST_MSK	BIT(UART_FCON_RFRST_POS)

/****************** Bit definition for UART_STAT register ************************/

#define	UART_STAT_TFOERR_POS	18U 
#define	UART_STAT_TFOERR_MSK	BIT(UART_STAT_TFOERR_POS)

#define	UART_STAT_TFFULL_POS	17U 
#define	UART_STAT_TFFULL_MSK	BIT(UART_STAT_TFFULL_POS)

#define	UART_STAT_TFEMPTY_POS	16U 
#define	UART_STAT_TFEMPTY_MSK	BIT(UART_STAT_TFEMPTY_POS)

#define	UART_STAT_TFTH_POS	15U 
#define	UART_STAT_TFTH_MSK	BIT(UART_STAT_TFTH_POS)

#define	UART_STAT_TSBUSY_POS	14U 
#define	UART_STAT_TSBUSY_MSK	BIT(UART_STAT_TSBUSY_POS)

#define	UART_STAT_RFUERR_POS	13U 
#define	UART_STAT_RFUERR_MSK	BIT(UART_STAT_RFUERR_POS)

#define	UART_STAT_RFOERR_POS	12U 
#define	UART_STAT_RFOERR_MSK	BIT(UART_STAT_RFOERR_POS)

#define	UART_STAT_RFFULL_POS	11U 
#define	UART_STAT_RFFULL_MSK	BIT(UART_STAT_RFFULL_POS)

#define	UART_STAT_RFEMPTY_POS	10U 
#define	UART_STAT_RFEMPTY_MSK	BIT(UART_STAT_RFEMPTY_POS)

#define	UART_STAT_RFTH_POS	9U 
#define	UART_STAT_RFTH_MSK	BIT(UART_STAT_RFTH_POS)

#define	UART_STAT_RSBUSY_POS	8U 
#define	UART_STAT_RSBUSY_MSK	BIT(UART_STAT_RSBUSY_POS)

#define	UART_STAT_CTSSTA_POS	3U 
#define	UART_STAT_CTSSTA_MSK	BIT(UART_STAT_CTSSTA_POS)

#define	UART_STAT_BKERR_POS	2U 
#define	UART_STAT_BKERR_MSK	BIT(UART_STAT_BKERR_POS)

#define	UART_STAT_FERR_POS	1U 
#define	UART_STAT_FERR_MSK	BIT(UART_STAT_FERR_POS)

#define	UART_STAT_PERR_POS	0U 
#define	UART_STAT_PERR_MSK	BIT(UART_STAT_PERR_POS)

/****************** Bit definition for UART_IER register ************************/

#define	UART_IER_TFOVER_POS	18U 
#define	UART_IER_TFOVER_MSK	BIT(UART_IER_TFOVER_POS)

#define	UART_IER_TFEMPTY_POS	16U 
#define	UART_IER_TFEMPTY_MSK	BIT(UART_IER_TFEMPTY_POS)

#define	UART_IER_TFTH_POS	15U 
#define	UART_IER_TFTH_MSK	BIT(UART_IER_TFTH_POS)

#define	UART_IER_TBC_POS	14U 
#define	UART_IER_TBC_MSK	BIT(UART_IER_TBC_POS)

#define	UART_IER_RFUERR_POS	13U 
#define	UART_IER_RFUERR_MSK	BIT(UART_IER_RFUERR_POS)

#define	UART_IER_RFOERR_POS	12U 
#define	UART_IER_RFOERR_MSK	BIT(UART_IER_RFOERR_POS)

#define	UART_IER_RFFULL_POS	11U 
#define	UART_IER_RFFULL_MSK	BIT(UART_IER_RFFULL_POS)

#define	UART_IER_RFTH_POS	9U 
#define	UART_IER_RFTH_MSK	BIT(UART_IER_RFTH_POS)

#define	UART_IER_NOISE_POS	8U 
#define	UART_IER_NOISE_MSK	BIT(UART_IER_NOISE_POS)

#define	UART_IER_EOB_POS	7U 
#define	UART_IER_EOB_MSK	BIT(UART_IER_EOB_POS)

#define	UART_IER_LINBK_POS	6U 
#define	UART_IER_LINBK_MSK	BIT(UART_IER_LINBK_POS)

#define	UART_IER_ADDRM_POS	5U 
#define	UART_IER_ADDRM_MSK	BIT(UART_IER_ADDRM_POS)

#define	UART_IER_RXTO_POS	4U 
#define	UART_IER_RXTO_MSK	BIT(UART_IER_RXTO_POS)

#define	UART_IER_DCTS_POS	3U 
#define	UART_IER_DCTS_MSK	BIT(UART_IER_DCTS_POS)

#define	UART_IER_ABTO_POS	2U 
#define	UART_IER_ABTO_MSK	BIT(UART_IER_ABTO_POS)

#define	UART_IER_ABEND_POS	1U 
#define	UART_IER_ABEND_MSK	BIT(UART_IER_ABEND_POS)

#define	UART_IER_RXBERR_POS	0U 
#define	UART_IER_RXBERR_MSK	BIT(UART_IER_RXBERR_POS)

/****************** Bit definition for UART_IDR register ************************/

#define	UART_IDR_TFOVER_POS	18U 
#define	UART_IDR_TFOVER_MSK	BIT(UART_IDR_TFOVER_POS)

#define	UART_IDR_TFEMPTY_POS	16U 
#define	UART_IDR_TFEMPTY_MSK	BIT(UART_IDR_TFEMPTY_POS)

#define	UART_IDR_TFTH_POS	15U 
#define	UART_IDR_TFTH_MSK	BIT(UART_IDR_TFTH_POS)

#define	UART_IDR_TBC_POS	14U 
#define	UART_IDR_TBC_MSK	BIT(UART_IDR_TBC_POS)

#define	UART_IDR_RFUERR_POS	13U 
#define	UART_IDR_RFUERR_MSK	BIT(UART_IDR_RFUERR_POS)

#define	UART_IDR_RFOERR_POS	12U 
#define	UART_IDR_RFOERR_MSK	BIT(UART_IDR_RFOERR_POS)

#define	UART_IDR_RFFULL_POS	11U 
#define	UART_IDR_RFFULL_MSK	BIT(UART_IDR_RFFULL_POS)

#define	UART_IDR_RFTH_POS	9U 
#define	UART_IDR_RFTH_MSK	BIT(UART_IDR_RFTH_POS)

#define	UART_IDR_NOISE_POS	8U 
#define	UART_IDR_NOISE_MSK	BIT(UART_IDR_NOISE_POS)

#define	UART_IDR_EOB_POS	7U 
#define	UART_IDR_EOB_MSK	BIT(UART_IDR_EOB_POS)

#define	UART_IDR_LINBK_POS	6U 
#define	UART_IDR_LINBK_MSK	BIT(UART_IDR_LINBK_POS)

#define	UART_IDR_ADDRM_POS	5U 
#define	UART_IDR_ADDRM_MSK	BIT(UART_IDR_ADDRM_POS)

#define	UART_IDR_RXTO_POS	4U 
#define	UART_IDR_RXTO_MSK	BIT(UART_IDR_RXTO_POS)

#define	UART_IDR_DCTS_POS	3U 
#define	UART_IDR_DCTS_MSK	BIT(UART_IDR_DCTS_POS)

#define	UART_IDR_ABTO_POS	2U 
#define	UART_IDR_ABTO_MSK	BIT(UART_IDR_ABTO_POS)

#define	UART_IDR_ABEND_POS	1U 
#define	UART_IDR_ABEND_MSK	BIT(UART_IDR_ABEND_POS)

#define	UART_IDR_RXBERR_POS	0U 
#define	UART_IDR_RXBERR_MSK	BIT(UART_IDR_RXBERR_POS)

/****************** Bit definition for UART_IVS register ************************/

#define	UART_IVS_TFOVER_POS	18U 
#define	UART_IVS_TFOVER_MSK	BIT(UART_IVS_TFOVER_POS)

#define	UART_IVS_TFEMPTY_POS	16U 
#define	UART_IVS_TFEMPTY_MSK	BIT(UART_IVS_TFEMPTY_POS)

#define	UART_IVS_TFTH_POS	15U 
#define	UART_IVS_TFTH_MSK	BIT(UART_IVS_TFTH_POS)

#define	UART_IVS_TBC_POS	14U 
#define	UART_IVS_TBC_MSK	BIT(UART_IVS_TBC_POS)

#define	UART_IVS_RFUERR_POS	13U 
#define	UART_IVS_RFUERR_MSK	BIT(UART_IVS_RFUERR_POS)

#define	UART_IVS_RFOERR_POS	12U 
#define	UART_IVS_RFOERR_MSK	BIT(UART_IVS_RFOERR_POS)

#define	UART_IVS_RFFULL_POS	11U 
#define	UART_IVS_RFFULL_MSK	BIT(UART_IVS_RFFULL_POS)

#define	UART_IVS_RFTH_POS	9U 
#define	UART_IVS_RFTH_MSK	BIT(UART_IVS_RFTH_POS)

#define	UART_IVS_NOISE_POS	8U 
#define	UART_IVS_NOISE_MSK	BIT(UART_IVS_NOISE_POS)

#define	UART_IVS_EOB_POS	7U 
#define	UART_IVS_EOB_MSK	BIT(UART_IVS_EOB_POS)

#define	UART_IVS_LINBK_POS	6U 
#define	UART_IVS_LINBK_MSK	BIT(UART_IVS_LINBK_POS)

#define	UART_IVS_ADDRM_POS	5U 
#define	UART_IVS_ADDRM_MSK	BIT(UART_IVS_ADDRM_POS)

#define	UART_IVS_RXTO_POS	4U 
#define	UART_IVS_RXTO_MSK	BIT(UART_IVS_RXTO_POS)

#define	UART_IVS_DCTS_POS	3U 
#define	UART_IVS_DCTS_MSK	BIT(UART_IVS_DCTS_POS)

#define	UART_IVS_ABTO_POS	2U 
#define	UART_IVS_ABTO_MSK	BIT(UART_IVS_ABTO_POS)

#define	UART_IVS_ABEND_POS	1U 
#define	UART_IVS_ABEND_MSK	BIT(UART_IVS_ABEND_POS)

#define	UART_IVS_RXBERR_POS	0U 
#define	UART_IVS_RXBERR_MSK	BIT(UART_IVS_RXBERR_POS)

/****************** Bit definition for UART_RIF register ************************/

#define	UART_RIF_TFOVER_POS	18U 
#define	UART_RIF_TFOVER_MSK	BIT(UART_RIF_TFOVER_POS)

#define	UART_RIF_TFEMPTY_POS	16U 
#define	UART_RIF_TFEMPTY_MSK	BIT(UART_RIF_TFEMPTY_POS)

#define	UART_RIF_TFTH_POS	15U 
#define	UART_RIF_TFTH_MSK	BIT(UART_RIF_TFTH_POS)

#define	UART_RIF_TBC_POS	14U 
#define	UART_RIF_TBC_MSK	BIT(UART_RIF_TBC_POS)

#define	UART_RIF_RFUERR_POS	13U 
#define	UART_RIF_RFUERR_MSK	BIT(UART_RIF_RFUERR_POS)

#define	UART_RIF_RFOERR_POS	12U 
#define	UART_RIF_RFOERR_MSK	BIT(UART_RIF_RFOERR_POS)

#define	UART_RIF_RFFULL_POS	11U 
#define	UART_RIF_RFFULL_MSK	BIT(UART_RIF_RFFULL_POS)

#define	UART_RIF_RFTH_POS	9U 
#define	UART_RIF_RFTH_MSK	BIT(UART_RIF_RFTH_POS)

#define	UART_RIF_NOISE_POS	8U 
#define	UART_RIF_NOISE_MSK	BIT(UART_RIF_NOISE_POS)

#define	UART_RIF_EOB_POS	7U 
#define	UART_RIF_EOB_MSK	BIT(UART_RIF_EOB_POS)

#define	UART_RIF_LINBK_POS	6U 
#define	UART_RIF_LINBK_MSK	BIT(UART_RIF_LINBK_POS)

#define	UART_RIF_ADDRM_POS	5U 
#define	UART_RIF_ADDRM_MSK	BIT(UART_RIF_ADDRM_POS)

#define	UART_RIF_RXTO_POS	4U 
#define	UART_RIF_RXTO_MSK	BIT(UART_RIF_RXTO_POS)

#define	UART_RIF_DCTS_POS	3U 
#define	UART_RIF_DCTS_MSK	BIT(UART_RIF_DCTS_POS)

#define	UART_RIF_ABTO_POS	2U 
#define	UART_RIF_ABTO_MSK	BIT(UART_RIF_ABTO_POS)

#define	UART_RIF_ABEND_POS	1U 
#define	UART_RIF_ABEND_MSK	BIT(UART_RIF_ABEND_POS)

#define	UART_RIF_RXBERR_POS	0U 
#define	UART_RIF_RXBERR_MSK	BIT(UART_RIF_RXBERR_POS)

/****************** Bit definition for UART_IFM register ************************/

#define	UART_IFM_TFOVER_POS	18U 
#define	UART_IFM_TFOVER_MSK	BIT(UART_IFM_TFOVER_POS)

#define	UART_IFM_TFEMPTY_POS	16U 
#define	UART_IFM_TFEMPTY_MSK	BIT(UART_IFM_TFEMPTY_POS)

#define	UART_IFM_TFTH_POS	15U 
#define	UART_IFM_TFTH_MSK	BIT(UART_IFM_TFTH_POS)

#define	UART_IFM_TBC_POS	14U 
#define	UART_IFM_TBC_MSK	BIT(UART_IFM_TBC_POS)

#define	UART_IFM_RFUERR_POS	13U 
#define	UART_IFM_RFUERR_MSK	BIT(UART_IFM_RFUERR_POS)

#define	UART_IFM_RFOERR_POS	12U 
#define	UART_IFM_RFOERR_MSK	BIT(UART_IFM_RFOERR_POS)

#define	UART_IFM_RFFULL_POS	11U 
#define	UART_IFM_RFFULL_MSK	BIT(UART_IFM_RFFULL_POS)

#define	UART_IFM_RFTH_POS	9U 
#define	UART_IFM_RFTH_MSK	BIT(UART_IFM_RFTH_POS)

#define	UART_IFM_NOISE_POS	8U 
#define	UART_IFM_NOISE_MSK	BIT(UART_IFM_NOISE_POS)

#define	UART_IFM_EOB_POS	7U 
#define	UART_IFM_EOB_MSK	BIT(UART_IFM_EOB_POS)

#define	UART_IFM_LINBK_POS	6U 
#define	UART_IFM_LINBK_MSK	BIT(UART_IFM_LINBK_POS)

#define	UART_IFM_ADDRM_POS	5U 
#define	UART_IFM_ADDRM_MSK	BIT(UART_IFM_ADDRM_POS)

#define	UART_IFM_RXTO_POS	4U 
#define	UART_IFM_RXTO_MSK	BIT(UART_IFM_RXTO_POS)

#define	UART_IFM_DCTS_POS	3U 
#define	UART_IFM_DCTS_MSK	BIT(UART_IFM_DCTS_POS)

#define	UART_IFM_ABTO_POS	2U 
#define	UART_IFM_ABTO_MSK	BIT(UART_IFM_ABTO_POS)

#define	UART_IFM_ABEND_POS	1U 
#define	UART_IFM_ABEND_MSK	BIT(UART_IFM_ABEND_POS)

#define	UART_IFM_RXBERR_POS	0U 
#define	UART_IFM_RXBERR_MSK	BIT(UART_IFM_RXBERR_POS)

/****************** Bit definition for UART_ICR register ************************/

#define	UART_ICR_TFOVER_POS	18U 
#define	UART_ICR_TFOVER_MSK	BIT(UART_ICR_TFOVER_POS)

#define	UART_ICR_TFEMPTY_POS	16U 
#define	UART_ICR_TFEMPTY_MSK	BIT(UART_ICR_TFEMPTY_POS)

#define	UART_ICR_TFTH_POS	15U 
#define	UART_ICR_TFTH_MSK	BIT(UART_ICR_TFTH_POS)

#define	UART_ICR_TBC_POS	14U 
#define	UART_ICR_TBC_MSK	BIT(UART_ICR_TBC_POS)

#define	UART_ICR_RFUERR_POS	13U 
#define	UART_ICR_RFUERR_MSK	BIT(UART_ICR_RFUERR_POS)

#define	UART_ICR_RFOERR_POS	12U 
#define	UART_ICR_RFOERR_MSK	BIT(UART_ICR_RFOERR_POS)

#define	UART_ICR_RFFULL_POS	11U 
#define	UART_ICR_RFFULL_MSK	BIT(UART_ICR_RFFULL_POS)

#define	UART_ICR_RFTH_POS	9U 
#define	UART_ICR_RFTH_MSK	BIT(UART_ICR_RFTH_POS)

#define	UART_ICR_NOISE_POS	8U 
#define	UART_ICR_NOISE_MSK	BIT(UART_ICR_NOISE_POS)

#define	UART_ICR_EOB_POS	7U 
#define	UART_ICR_EOB_MSK	BIT(UART_ICR_EOB_POS)

#define	UART_ICR_LINBK_POS	6U 
#define	UART_ICR_LINBK_MSK	BIT(UART_ICR_LINBK_POS)

#define	UART_ICR_ADDRM_POS	5U 
#define	UART_ICR_ADDRM_MSK	BIT(UART_ICR_ADDRM_POS)

#define	UART_ICR_RXTO_POS	4U 
#define	UART_ICR_RXTO_MSK	BIT(UART_ICR_RXTO_POS)

#define	UART_ICR_DCTS_POS	3U 
#define	UART_ICR_DCTS_MSK	BIT(UART_ICR_DCTS_POS)

#define	UART_ICR_ABTO_POS	2U 
#define	UART_ICR_ABTO_MSK	BIT(UART_ICR_ABTO_POS)

#define	UART_ICR_ABEND_POS	1U 
#define	UART_ICR_ABEND_MSK	BIT(UART_ICR_ABEND_POS)

#define	UART_ICR_RXBERR_POS	0U 
#define	UART_ICR_RXBERR_MSK	BIT(UART_ICR_RXBERR_POS)

typedef struct
{
	__I uint32_t RXBUF;
	__IO uint32_t TXBUF;
	__IO uint32_t BRR;
	__IO uint32_t LCON;
	__IO uint32_t MCON;
	__IO uint32_t RS485;
	__IO uint32_t SCARD;
	__IO uint32_t LIN;
	__IO uint32_t RTOR;
	__O uint32_t FCON;
	__I uint32_t STAT;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} UART_TypeDef;

/****************** Bit definition for SPI_CON1 register ************************/

#define	SPI_CON1_BIDEN_POS	15U 
#define	SPI_CON1_BIDEN_MSK	BIT(SPI_CON1_BIDEN_POS)

#define	SPI_CON1_BIDOEN_POS	14U 
#define	SPI_CON1_BIDOEN_MSK	BIT(SPI_CON1_BIDOEN_POS)

#define	SPI_CON1_CRCEN_POS	13U 
#define	SPI_CON1_CRCEN_MSK	BIT(SPI_CON1_CRCEN_POS)

#define	SPI_CON1_NXTCRC_POS	12U 
#define	SPI_CON1_NXTCRC_MSK	BIT(SPI_CON1_NXTCRC_POS)

#define	SPI_CON1_FLEN_POS	11U 
#define	SPI_CON1_FLEN_MSK	BIT(SPI_CON1_FLEN_POS)

#define	SPI_CON1_RXO_POS	10U 
#define	SPI_CON1_RXO_MSK	BIT(SPI_CON1_RXO_POS)

#define	SPI_CON1_SSEN_POS	9U 
#define	SPI_CON1_SSEN_MSK	BIT(SPI_CON1_SSEN_POS)

#define	SPI_CON1_SSOUT_POS	8U 
#define	SPI_CON1_SSOUT_MSK	BIT(SPI_CON1_SSOUT_POS)

#define	SPI_CON1_LSBFST_POS	7U 
#define	SPI_CON1_LSBFST_MSK	BIT(SPI_CON1_LSBFST_POS)

#define	SPI_CON1_SPIEN_POS	6U 
#define	SPI_CON1_SPIEN_MSK	BIT(SPI_CON1_SPIEN_POS)

#define	SPI_CON1_BAUD_POSS	3U 
#define	SPI_CON1_BAUD_POSE	5U 
#define	SPI_CON1_BAUD_MSK	BITS(SPI_CON1_BAUD_POSS,SPI_CON1_BAUD_POSE)

#define	SPI_CON1_MSTREN_POS	2U 
#define	SPI_CON1_MSTREN_MSK	BIT(SPI_CON1_MSTREN_POS)

#define	SPI_CON1_CPOL_POS	1U 
#define	SPI_CON1_CPOL_MSK	BIT(SPI_CON1_CPOL_POS)

#define	SPI_CON1_CPHA_POS	0U 
#define	SPI_CON1_CPHA_MSK	BIT(SPI_CON1_CPHA_POS)

/****************** Bit definition for SPI_CON2 register ************************/

#define	SPI_CON2_RXFTH_POSS	14U 
#define	SPI_CON2_RXFTH_POSE	15U 
#define	SPI_CON2_RXFTH_MSK	BITS(SPI_CON2_RXFTH_POSS,SPI_CON2_RXFTH_POSE)

#define	SPI_CON2_TXFTH_POSS	12U 
#define	SPI_CON2_TXFTH_POSE	13U 
#define	SPI_CON2_TXFTH_MSK	BITS(SPI_CON2_TXFTH_POSS,SPI_CON2_TXFTH_POSE)

#define	SPI_CON2_FRF_POS	4U 
#define	SPI_CON2_FRF_MSK	BIT(SPI_CON2_FRF_POS)

#define	SPI_CON2_NSSP_POS	3U 
#define	SPI_CON2_NSSP_MSK	BIT(SPI_CON2_NSSP_POS)

#define	SPI_CON2_NSSOE_POS	2U 
#define	SPI_CON2_NSSOE_MSK	BIT(SPI_CON2_NSSOE_POS)

#define	SPI_CON2_TXDMA_POS	1U 
#define	SPI_CON2_TXDMA_MSK	BIT(SPI_CON2_TXDMA_POS)

#define	SPI_CON2_RXDMA_POS	0U 
#define	SPI_CON2_RXDMA_MSK	BIT(SPI_CON2_RXDMA_POS)

/****************** Bit definition for SPI_STAT register ************************/

#define	SPI_STAT_RXFLV_POSS	24U 
#define	SPI_STAT_RXFLV_POSE	28U 
#define	SPI_STAT_RXFLV_MSK	BITS(SPI_STAT_RXFLV_POSS,SPI_STAT_RXFLV_POSE)

#define	SPI_STAT_TXFLV_POSS	16U 
#define	SPI_STAT_TXFLV_POSE	20U 
#define	SPI_STAT_TXFLV_MSK	BITS(SPI_STAT_TXFLV_POSS,SPI_STAT_TXFLV_POSE)

#define	SPI_STAT_BUSY_POS	15U 
#define	SPI_STAT_BUSY_MSK	BIT(SPI_STAT_BUSY_POS)

#define	SPI_STAT_CHSIDE_POS	14U 
#define	SPI_STAT_CHSIDE_MSK	BIT(SPI_STAT_CHSIDE_POS)

#define	SPI_STAT_RXTH_POS	12U 
#define	SPI_STAT_RXTH_MSK	BIT(SPI_STAT_RXTH_POS)

#define	SPI_STAT_RXUD_POS	11U 
#define	SPI_STAT_RXUD_MSK	BIT(SPI_STAT_RXUD_POS)

#define	SPI_STAT_RXOV_POS	10U 
#define	SPI_STAT_RXOV_MSK	BIT(SPI_STAT_RXOV_POS)

#define	SPI_STAT_RXF_POS	9U 
#define	SPI_STAT_RXF_MSK	BIT(SPI_STAT_RXF_POS)

#define	SPI_STAT_RXE_POS	8U 
#define	SPI_STAT_RXE_MSK	BIT(SPI_STAT_RXE_POS)

#define	SPI_STAT_TXTH_POS	4U 
#define	SPI_STAT_TXTH_MSK	BIT(SPI_STAT_TXTH_POS)

#define	SPI_STAT_TXUD_POS	3U 
#define	SPI_STAT_TXUD_MSK	BIT(SPI_STAT_TXUD_POS)

#define	SPI_STAT_TXOV_POS	2U 
#define	SPI_STAT_TXOV_MSK	BIT(SPI_STAT_TXOV_POS)

#define	SPI_STAT_TXF_POS	1U 
#define	SPI_STAT_TXF_MSK	BIT(SPI_STAT_TXF_POS)

#define	SPI_STAT_TXE_POS	0U 
#define	SPI_STAT_TXE_MSK	BIT(SPI_STAT_TXE_POS)

/****************** Bit definition for SPI_DATA register ************************/

#define	SPI_DATA_DATA_POSS	0U 
#define	SPI_DATA_DATA_POSE	15U 
#define	SPI_DATA_DATA_MSK	BITS(SPI_DATA_DATA_POSS,SPI_DATA_DATA_POSE)

/****************** Bit definition for SPI_CRCPOLY register ************************/

#define	SPI_CRCPOLY_CRCPOLY_POSS	0U 
#define	SPI_CRCPOLY_CRCPOLY_POSE	15U 
#define	SPI_CRCPOLY_CRCPOLY_MSK	BITS(SPI_CRCPOLY_CRCPOLY_POSS,SPI_CRCPOLY_CRCPOLY_POSE)

/****************** Bit definition for SPI_RXCRC register ************************/

#define	SPI_RXCRC_RXCRC_POSS	0U 
#define	SPI_RXCRC_RXCRC_POSE	15U 
#define	SPI_RXCRC_RXCRC_MSK	BITS(SPI_RXCRC_RXCRC_POSS,SPI_RXCRC_RXCRC_POSE)

/****************** Bit definition for SPI_TXCRC register ************************/

#define	SPI_TXCRC_TXCRC_POSS	0U 
#define	SPI_TXCRC_TXCRC_POSE	15U 
#define	SPI_TXCRC_TXCRC_MSK	BITS(SPI_TXCRC_TXCRC_POSS,SPI_TXCRC_TXCRC_POSE)

/****************** Bit definition for SPI_I2SCFG register ************************/

#define	SPI_I2SCFG_I2SMOD_POS	11U 
#define	SPI_I2SCFG_I2SMOD_MSK	BIT(SPI_I2SCFG_I2SMOD_POS)

#define	SPI_I2SCFG_I2SE_POS	10U 
#define	SPI_I2SCFG_I2SE_MSK	BIT(SPI_I2SCFG_I2SE_POS)

#define	SPI_I2SCFG_I2SCFG_POSS	8U 
#define	SPI_I2SCFG_I2SCFG_POSE	9U 
#define	SPI_I2SCFG_I2SCFG_MSK	BITS(SPI_I2SCFG_I2SCFG_POSS,SPI_I2SCFG_I2SCFG_POSE)

#define	SPI_I2SCFG_PCMSYNC_POS	7U 
#define	SPI_I2SCFG_PCMSYNC_MSK	BIT(SPI_I2SCFG_PCMSYNC_POS)

#define	SPI_I2SCFG_I2SSTD_POSS	4U 
#define	SPI_I2SCFG_I2SSTD_POSE	5U 
#define	SPI_I2SCFG_I2SSTD_MSK	BITS(SPI_I2SCFG_I2SSTD_POSS,SPI_I2SCFG_I2SSTD_POSE)

#define	SPI_I2SCFG_CKPOL_POS	3U 
#define	SPI_I2SCFG_CKPOL_MSK	BIT(SPI_I2SCFG_CKPOL_POS)

#define	SPI_I2SCFG_DATLEN_POSS	1U 
#define	SPI_I2SCFG_DATLEN_POSE	2U 
#define	SPI_I2SCFG_DATLEN_MSK	BITS(SPI_I2SCFG_DATLEN_POSS,SPI_I2SCFG_DATLEN_POSE)

#define	SPI_I2SCFG_CHLEN_POS	0U 
#define	SPI_I2SCFG_CHLEN_MSK	BIT(SPI_I2SCFG_CHLEN_POS)

/****************** Bit definition for SPI_I2SPR register ************************/

#define	SPI_I2SPR_EXTCKEN_POS	10U 
#define	SPI_I2SPR_EXTCKEN_MSK	BIT(SPI_I2SPR_EXTCKEN_POS)

#define	SPI_I2SPR_MCKOE_POS	9U 
#define	SPI_I2SPR_MCKOE_MSK	BIT(SPI_I2SPR_MCKOE_POS)

#define	SPI_I2SPR_ODD_POS	8U 
#define	SPI_I2SPR_ODD_MSK	BIT(SPI_I2SPR_ODD_POS)

#define	SPI_I2SPR_I2SDIV_POSS	0U 
#define	SPI_I2SPR_I2SDIV_POSE	7U 
#define	SPI_I2SPR_I2SDIV_MSK	BITS(SPI_I2SPR_I2SDIV_POSS,SPI_I2SPR_I2SDIV_POSE)

/****************** Bit definition for SPI_IER register ************************/

#define	SPI_IER_FREIE_POS	18U 
#define	SPI_IER_FREIE_MSK	BIT(SPI_IER_FREIE_POS)

#define	SPI_IER_MODFIE_POS	17U 
#define	SPI_IER_MODFIE_MSK	BIT(SPI_IER_MODFIE_POS)

#define	SPI_IER_CRCERRIE_POS	16U 
#define	SPI_IER_CRCERRIE_MSK	BIT(SPI_IER_CRCERRIE_POS)

#define	SPI_IER_RXTHIE_POS	12U 
#define	SPI_IER_RXTHIE_MSK	BIT(SPI_IER_RXTHIE_POS)

#define	SPI_IER_RXUDIE_POS	11U 
#define	SPI_IER_RXUDIE_MSK	BIT(SPI_IER_RXUDIE_POS)

#define	SPI_IER_RXOVIE_POS	10U 
#define	SPI_IER_RXOVIE_MSK	BIT(SPI_IER_RXOVIE_POS)

#define	SPI_IER_RXFIE_POS	9U 
#define	SPI_IER_RXFIE_MSK	BIT(SPI_IER_RXFIE_POS)

#define	SPI_IER_TXTHIE_POS	4U 
#define	SPI_IER_TXTHIE_MSK	BIT(SPI_IER_TXTHIE_POS)

#define	SPI_IER_TXUDIE_POS	3U 
#define	SPI_IER_TXUDIE_MSK	BIT(SPI_IER_TXUDIE_POS)

#define	SPI_IER_TXOVIE_POS	2U 
#define	SPI_IER_TXOVIE_MSK	BIT(SPI_IER_TXOVIE_POS)

#define	SPI_IER_TXEIE_POS	0U 
#define	SPI_IER_TXEIE_MSK	BIT(SPI_IER_TXEIE_POS)

/****************** Bit definition for SPI_IDR register ************************/

#define	SPI_IDR_FREID_POS	18U 
#define	SPI_IDR_FREID_MSK	BIT(SPI_IDR_FREID_POS)

#define	SPI_IDR_MODFID_POS	17U 
#define	SPI_IDR_MODFID_MSK	BIT(SPI_IDR_MODFID_POS)

#define	SPI_IDR_CRCERRID_POS	16U 
#define	SPI_IDR_CRCERRID_MSK	BIT(SPI_IDR_CRCERRID_POS)

#define	SPI_IDR_RXTHID_POS	12U 
#define	SPI_IDR_RXTHID_MSK	BIT(SPI_IDR_RXTHID_POS)

#define	SPI_IDR_RXUDID_POS	11U 
#define	SPI_IDR_RXUDID_MSK	BIT(SPI_IDR_RXUDID_POS)

#define	SPI_IDR_RXOVID_POS	10U 
#define	SPI_IDR_RXOVID_MSK	BIT(SPI_IDR_RXOVID_POS)

#define	SPI_IDR_RXFID_POS	9U 
#define	SPI_IDR_RXFID_MSK	BIT(SPI_IDR_RXFID_POS)

#define	SPI_IDR_TXTHID_POS	4U 
#define	SPI_IDR_TXTHID_MSK	BIT(SPI_IDR_TXTHID_POS)

#define	SPI_IDR_TXUDID_POS	3U 
#define	SPI_IDR_TXUDID_MSK	BIT(SPI_IDR_TXUDID_POS)

#define	SPI_IDR_TXOVID_POS	2U 
#define	SPI_IDR_TXOVID_MSK	BIT(SPI_IDR_TXOVID_POS)

#define	SPI_IDR_TXEID_POS	0U 
#define	SPI_IDR_TXEID_MSK	BIT(SPI_IDR_TXEID_POS)

/****************** Bit definition for SPI_IVS register ************************/

#define	SPI_IVS_FREIV_POS	18U 
#define	SPI_IVS_FREIV_MSK	BIT(SPI_IVS_FREIV_POS)

#define	SPI_IVS_MODFIV_POS	17U 
#define	SPI_IVS_MODFIV_MSK	BIT(SPI_IVS_MODFIV_POS)

#define	SPI_IVS_CRCERRIV_POS	16U 
#define	SPI_IVS_CRCERRIV_MSK	BIT(SPI_IVS_CRCERRIV_POS)

#define	SPI_IVS_RXTHIV_POS	12U 
#define	SPI_IVS_RXTHIV_MSK	BIT(SPI_IVS_RXTHIV_POS)

#define	SPI_IVS_RXUDIV_POS	11U 
#define	SPI_IVS_RXUDIV_MSK	BIT(SPI_IVS_RXUDIV_POS)

#define	SPI_IVS_RXOVIV_POS	10U 
#define	SPI_IVS_RXOVIV_MSK	BIT(SPI_IVS_RXOVIV_POS)

#define	SPI_IVS_RXFIV_POS	9U 
#define	SPI_IVS_RXFIV_MSK	BIT(SPI_IVS_RXFIV_POS)

#define	SPI_IVS_TXTHIV_POS	4U 
#define	SPI_IVS_TXTHIV_MSK	BIT(SPI_IVS_TXTHIV_POS)

#define	SPI_IVS_TXUDIV_POS	3U 
#define	SPI_IVS_TXUDIV_MSK	BIT(SPI_IVS_TXUDIV_POS)

#define	SPI_IVS_TXOVIV_POS	2U 
#define	SPI_IVS_TXOVIV_MSK	BIT(SPI_IVS_TXOVIV_POS)

#define	SPI_IVS_TXEIV_POS	0U 
#define	SPI_IVS_TXEIV_MSK	BIT(SPI_IVS_TXEIV_POS)

/****************** Bit definition for SPI_RIF register ************************/

#define	SPI_RIF_FRERI_POS	18U 
#define	SPI_RIF_FRERI_MSK	BIT(SPI_RIF_FRERI_POS)

#define	SPI_RIF_MODFRI_POS	17U 
#define	SPI_RIF_MODFRI_MSK	BIT(SPI_RIF_MODFRI_POS)

#define	SPI_RIF_CRCERRRI_POS	16U 
#define	SPI_RIF_CRCERRRI_MSK	BIT(SPI_RIF_CRCERRRI_POS)

#define	SPI_RIF_RXTHRI_POS	12U 
#define	SPI_RIF_RXTHRI_MSK	BIT(SPI_RIF_RXTHRI_POS)

#define	SPI_RIF_RXUDRI_POS	11U 
#define	SPI_RIF_RXUDRI_MSK	BIT(SPI_RIF_RXUDRI_POS)

#define	SPI_RIF_RXOVRI_POS	10U 
#define	SPI_RIF_RXOVRI_MSK	BIT(SPI_RIF_RXOVRI_POS)

#define	SPI_RIF_RXFRI_POS	9U 
#define	SPI_RIF_RXFRI_MSK	BIT(SPI_RIF_RXFRI_POS)

#define	SPI_RIF_TXTHRI_POS	4U 
#define	SPI_RIF_TXTHRI_MSK	BIT(SPI_RIF_TXTHRI_POS)

#define	SPI_RIF_TXUDRI_POS	3U 
#define	SPI_RIF_TXUDRI_MSK	BIT(SPI_RIF_TXUDRI_POS)

#define	SPI_RIF_TXOVRI_POS	2U 
#define	SPI_RIF_TXOVRI_MSK	BIT(SPI_RIF_TXOVRI_POS)

#define	SPI_RIF_TXERI_POS	0U 
#define	SPI_RIF_TXERI_MSK	BIT(SPI_RIF_TXERI_POS)

/****************** Bit definition for SPI_IFM register ************************/

#define	SPI_IFM_FREFM_POS	18U 
#define	SPI_IFM_FREFM_MSK	BIT(SPI_IFM_FREFM_POS)

#define	SPI_IFM_MODFFM_POS	17U 
#define	SPI_IFM_MODFFM_MSK	BIT(SPI_IFM_MODFFM_POS)

#define	SPI_IFM_CRCERRFM_POS	16U 
#define	SPI_IFM_CRCERRFM_MSK	BIT(SPI_IFM_CRCERRFM_POS)

#define	SPI_IFM_RXTHFM_POS	12U 
#define	SPI_IFM_RXTHFM_MSK	BIT(SPI_IFM_RXTHFM_POS)

#define	SPI_IFM_RXUDFM_POS	11U 
#define	SPI_IFM_RXUDFM_MSK	BIT(SPI_IFM_RXUDFM_POS)

#define	SPI_IFM_RXOVFM_POS	10U 
#define	SPI_IFM_RXOVFM_MSK	BIT(SPI_IFM_RXOVFM_POS)

#define	SPI_IFM_RXFFM_POS	9U 
#define	SPI_IFM_RXFFM_MSK	BIT(SPI_IFM_RXFFM_POS)

#define	SPI_IFM_TXTHFM_POS	4U 
#define	SPI_IFM_TXTHFM_MSK	BIT(SPI_IFM_TXTHFM_POS)

#define	SPI_IFM_TXUDFM_POS	3U 
#define	SPI_IFM_TXUDFM_MSK	BIT(SPI_IFM_TXUDFM_POS)

#define	SPI_IFM_TXOVFM_POS	2U 
#define	SPI_IFM_TXOVFM_MSK	BIT(SPI_IFM_TXOVFM_POS)

#define	SPI_IFM_TXEFM_POS	0U 
#define	SPI_IFM_TXEFM_MSK	BIT(SPI_IFM_TXEFM_POS)

/****************** Bit definition for SPI_ICR register ************************/

#define	SPI_ICR_FREIC_POS	18U 
#define	SPI_ICR_FREIC_MSK	BIT(SPI_ICR_FREIC_POS)

#define	SPI_ICR_MODFIC_POS	17U 
#define	SPI_ICR_MODFIC_MSK	BIT(SPI_ICR_MODFIC_POS)

#define	SPI_ICR_CRCERRIC_POS	16U 
#define	SPI_ICR_CRCERRIC_MSK	BIT(SPI_ICR_CRCERRIC_POS)

#define	SPI_ICR_RXTHIC_POS	12U 
#define	SPI_ICR_RXTHIC_MSK	BIT(SPI_ICR_RXTHIC_POS)

#define	SPI_ICR_RXUDIC_POS	11U 
#define	SPI_ICR_RXUDIC_MSK	BIT(SPI_ICR_RXUDIC_POS)

#define	SPI_ICR_RXOVIC_POS	10U 
#define	SPI_ICR_RXOVIC_MSK	BIT(SPI_ICR_RXOVIC_POS)

#define	SPI_ICR_RXFIC_POS	9U 
#define	SPI_ICR_RXFIC_MSK	BIT(SPI_ICR_RXFIC_POS)

#define	SPI_ICR_TXTHIC_POS	4U 
#define	SPI_ICR_TXTHIC_MSK	BIT(SPI_ICR_TXTHIC_POS)

#define	SPI_ICR_TXUDIC_POS	3U 
#define	SPI_ICR_TXUDIC_MSK	BIT(SPI_ICR_TXUDIC_POS)

#define	SPI_ICR_TXOVIC_POS	2U 
#define	SPI_ICR_TXOVIC_MSK	BIT(SPI_ICR_TXOVIC_POS)

#define	SPI_ICR_TXEIC_POS	0U 
#define	SPI_ICR_TXEIC_MSK	BIT(SPI_ICR_TXEIC_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__I uint32_t STAT;
	__IO uint32_t DATA;
	__IO uint32_t CRCPOLY;
	__I uint32_t RXCRC;
	__I uint32_t TXCRC;
	__IO uint32_t I2SCFG;
	__IO uint32_t I2SPR;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} SPI_I2S_TypeDef;

/****************** Bit definition for I2C_CON1 register ************************/

#define	I2C_CON1_PECEN_POS	23U 
#define	I2C_CON1_PECEN_MSK	BIT(I2C_CON1_PECEN_POS)

#define	I2C_CON1_ALERTEN_POS	22U 
#define	I2C_CON1_ALERTEN_MSK	BIT(I2C_CON1_ALERTEN_POS)

#define	I2C_CON1_SMBDEN_POS	21U 
#define	I2C_CON1_SMBDEN_MSK	BIT(I2C_CON1_SMBDEN_POS)

#define	I2C_CON1_SMBHEN_POS	20U 
#define	I2C_CON1_SMBHEN_MSK	BIT(I2C_CON1_SMBHEN_POS)

#define	I2C_CON1_GCEN_POS	19U 
#define	I2C_CON1_GCEN_MSK	BIT(I2C_CON1_GCEN_POS)

#define	I2C_CON1_NOSTRETCH_POS	17U 
#define	I2C_CON1_NOSTRETCH_MSK	BIT(I2C_CON1_NOSTRETCH_POS)

#define	I2C_CON1_SBC_POS	16U 
#define	I2C_CON1_SBC_MSK	BIT(I2C_CON1_SBC_POS)

#define	I2C_CON1_RXDMAEN_POS	15U 
#define	I2C_CON1_RXDMAEN_MSK	BIT(I2C_CON1_RXDMAEN_POS)

#define	I2C_CON1_TXDMAEN_POS	14U 
#define	I2C_CON1_TXDMAEN_MSK	BIT(I2C_CON1_TXDMAEN_POS)

#define	I2C_CON1_DNF_POSS	8U 
#define	I2C_CON1_DNF_POSE	11U 
#define	I2C_CON1_DNF_MSK	BITS(I2C_CON1_DNF_POSS,I2C_CON1_DNF_POSE)

#define	I2C_CON1_PE_POS	0U 
#define	I2C_CON1_PE_MSK	BIT(I2C_CON1_PE_POS)

/****************** Bit definition for I2C_CON2 register ************************/

#define	I2C_CON2_ACK_UPD_POS	29U 
#define	I2C_CON2_ACK_UPD_MSK	BIT(I2C_CON2_ACK_UPD_POS)

#define	I2C_CON2_HOLDACK_POS	28U 
#define	I2C_CON2_HOLDACK_MSK	BIT(I2C_CON2_HOLDACK_POS)

#define	I2C_CON2_PECBYTE_POS	26U 
#define	I2C_CON2_PECBYTE_MSK	BIT(I2C_CON2_PECBYTE_POS)

#define	I2C_CON2_AUTOEND_POS	25U 
#define	I2C_CON2_AUTOEND_MSK	BIT(I2C_CON2_AUTOEND_POS)

#define	I2C_CON2_RELOAD_POS	24U 
#define	I2C_CON2_RELOAD_MSK	BIT(I2C_CON2_RELOAD_POS)

#define	I2C_CON2_NBYTES_POSS	16U 
#define	I2C_CON2_NBYTES_POSE	23U 
#define	I2C_CON2_NBYTES_MSK	BITS(I2C_CON2_NBYTES_POSS,I2C_CON2_NBYTES_POSE)

#define	I2C_CON2_NACK_POS	15U 
#define	I2C_CON2_NACK_MSK	BIT(I2C_CON2_NACK_POS)

#define	I2C_CON2_STOP_POS	14U 
#define	I2C_CON2_STOP_MSK	BIT(I2C_CON2_STOP_POS)

#define	I2C_CON2_START_POS	13U 
#define	I2C_CON2_START_MSK	BIT(I2C_CON2_START_POS)

#define	I2C_CON2_HEAD10R_POS	12U 
#define	I2C_CON2_HEAD10R_MSK	BIT(I2C_CON2_HEAD10R_POS)

#define	I2C_CON2_ADD10_POS	11U 
#define	I2C_CON2_ADD10_MSK	BIT(I2C_CON2_ADD10_POS)

#define	I2C_CON2_RD_WRN_POS	10U 
#define	I2C_CON2_RD_WRN_MSK	BIT(I2C_CON2_RD_WRN_POS)

#define	I2C_CON2_SADD_POSS	0U 
#define	I2C_CON2_SADD_POSE	9U 
#define	I2C_CON2_SADD_MSK	BITS(I2C_CON2_SADD_POSS,I2C_CON2_SADD_POSE)

/****************** Bit definition for I2C_ADDR1 register ************************/

#define	I2C_ADDR1_OA1EN_POS	15U 
#define	I2C_ADDR1_OA1EN_MSK	BIT(I2C_ADDR1_OA1EN_POS)

#define	I2C_ADDR1_OA1MODE_POS	10U 
#define	I2C_ADDR1_OA1MODE_MSK	BIT(I2C_ADDR1_OA1MODE_POS)

#define	I2C_ADDR1_OA1_POSS	0U 
#define	I2C_ADDR1_OA1_POSE	9U 
#define	I2C_ADDR1_OA1_MSK	BITS(I2C_ADDR1_OA1_POSS,I2C_ADDR1_OA1_POSE)

/****************** Bit definition for I2C_ADDR2 register ************************/

#define	I2C_ADDR2_OA2EN_POS	15U 
#define	I2C_ADDR2_OA2EN_MSK	BIT(I2C_ADDR2_OA2EN_POS)

#define	I2C_ADDR2_OA2MSK_POSS	8U 
#define	I2C_ADDR2_OA2MSK_POSE	10U 
#define	I2C_ADDR2_OA2MSK_MSK	BITS(I2C_ADDR2_OA2MSK_POSS,I2C_ADDR2_OA2MSK_POSE)

#define	I2C_ADDR2_OA2_POSS	1U 
#define	I2C_ADDR2_OA2_POSE	7U 
#define	I2C_ADDR2_OA2_MSK	BITS(I2C_ADDR2_OA2_POSS,I2C_ADDR2_OA2_POSE)

/****************** Bit definition for I2C_TIMINGR register ************************/

#define	I2C_TIMINGR_PRESC_POSS	28U 
#define	I2C_TIMINGR_PRESC_POSE	31U 
#define	I2C_TIMINGR_PRESC_MSK	BITS(I2C_TIMINGR_PRESC_POSS,I2C_TIMINGR_PRESC_POSE)

#define	I2C_TIMINGR_SCLDEL_POSS	20U 
#define	I2C_TIMINGR_SCLDEL_POSE	23U 
#define	I2C_TIMINGR_SCLDEL_MSK	BITS(I2C_TIMINGR_SCLDEL_POSS,I2C_TIMINGR_SCLDEL_POSE)

#define	I2C_TIMINGR_SDADEL_POSS	16U 
#define	I2C_TIMINGR_SDADEL_POSE	19U 
#define	I2C_TIMINGR_SDADEL_MSK	BITS(I2C_TIMINGR_SDADEL_POSS,I2C_TIMINGR_SDADEL_POSE)

#define	I2C_TIMINGR_SCLH_POSS	8U 
#define	I2C_TIMINGR_SCLH_POSE	15U 
#define	I2C_TIMINGR_SCLH_MSK	BITS(I2C_TIMINGR_SCLH_POSS,I2C_TIMINGR_SCLH_POSE)

#define	I2C_TIMINGR_SCLL_POSS	0U 
#define	I2C_TIMINGR_SCLL_POSE	7U 
#define	I2C_TIMINGR_SCLL_MSK	BITS(I2C_TIMINGR_SCLL_POSS,I2C_TIMINGR_SCLL_POSE)

/****************** Bit definition for I2C_TIMEOUTR register ************************/

#define	I2C_TIMEOUTR_TEXTEN_POS	31U 
#define	I2C_TIMEOUTR_TEXTEN_MSK	BIT(I2C_TIMEOUTR_TEXTEN_POS)

#define	I2C_TIMEOUTR_TIMEOUTB_POSS	16U 
#define	I2C_TIMEOUTR_TIMEOUTB_POSE	27U 
#define	I2C_TIMEOUTR_TIMEOUTB_MSK	BITS(I2C_TIMEOUTR_TIMEOUTB_POSS,I2C_TIMEOUTR_TIMEOUTB_POSE)

#define	I2C_TIMEOUTR_TIMEOUTEN_POS	15U 
#define	I2C_TIMEOUTR_TIMEOUTEN_MSK	BIT(I2C_TIMEOUTR_TIMEOUTEN_POS)

#define	I2C_TIMEOUTR_TIDLE_POS	12U 
#define	I2C_TIMEOUTR_TIDLE_MSK	BIT(I2C_TIMEOUTR_TIDLE_POS)

#define	I2C_TIMEOUTR_TIMEOUTA_POSS	0U 
#define	I2C_TIMEOUTR_TIMEOUTA_POSE	11U 
#define	I2C_TIMEOUTR_TIMEOUTA_MSK	BITS(I2C_TIMEOUTR_TIMEOUTA_POSS,I2C_TIMEOUTR_TIMEOUTA_POSE)

/****************** Bit definition for I2C_STAT register ************************/

#define	I2C_STAT_ADDCODE_POSS	17U 
#define	I2C_STAT_ADDCODE_POSE	23U 
#define	I2C_STAT_ADDCODE_MSK	BITS(I2C_STAT_ADDCODE_POSS,I2C_STAT_ADDCODE_POSE)

#define	I2C_STAT_DIR_POS	16U 
#define	I2C_STAT_DIR_MSK	BIT(I2C_STAT_DIR_POS)

#define	I2C_STAT_BUSY_POS	15U 
#define	I2C_STAT_BUSY_MSK	BIT(I2C_STAT_BUSY_POS)

#define	I2C_STAT_TCR_POS	11U 
#define	I2C_STAT_TCR_MSK	BIT(I2C_STAT_TCR_POS)

#define	I2C_STAT_TC_POS	10U 
#define	I2C_STAT_TC_MSK	BIT(I2C_STAT_TC_POS)

#define	I2C_STAT_RXTH_POS	9U 
#define	I2C_STAT_RXTH_MSK	BIT(I2C_STAT_RXTH_POS)

#define	I2C_STAT_RXUD_POS	8U 
#define	I2C_STAT_RXUD_MSK	BIT(I2C_STAT_RXUD_POS)

#define	I2C_STAT_RXOV_POS	7U 
#define	I2C_STAT_RXOV_MSK	BIT(I2C_STAT_RXOV_POS)

#define	I2C_STAT_RXF_POS	6U 
#define	I2C_STAT_RXF_MSK	BIT(I2C_STAT_RXF_POS)

#define	I2C_STAT_RXE_POS	5U 
#define	I2C_STAT_RXE_MSK	BIT(I2C_STAT_RXE_POS)

#define	I2C_STAT_TXTH_POS	4U 
#define	I2C_STAT_TXTH_MSK	BIT(I2C_STAT_TXTH_POS)

#define	I2C_STAT_TXUD_POS	3U 
#define	I2C_STAT_TXUD_MSK	BIT(I2C_STAT_TXUD_POS)

#define	I2C_STAT_TXOV_POS	2U 
#define	I2C_STAT_TXOV_MSK	BIT(I2C_STAT_TXOV_POS)

#define	I2C_STAT_TXF_POS	1U 
#define	I2C_STAT_TXF_MSK	BIT(I2C_STAT_TXF_POS)

#define	I2C_STAT_TXE_POS	0U 
#define	I2C_STAT_TXE_MSK	BIT(I2C_STAT_TXE_POS)

/****************** Bit definition for I2C_FCON register ************************/

#define	I2C_FCON_RXFTH_POSS	14U 
#define	I2C_FCON_RXFTH_POSE	15U 
#define	I2C_FCON_RXFTH_MSK	BITS(I2C_FCON_RXFTH_POSS,I2C_FCON_RXFTH_POSE)

#define	I2C_FCON_RXFRST_POS	13U 
#define	I2C_FCON_RXFRST_MSK	BIT(I2C_FCON_RXFRST_POS)

#define	I2C_FCON_RXFLV_POSS	8U 
#define	I2C_FCON_RXFLV_POSE	12U 
#define	I2C_FCON_RXFLV_MSK	BITS(I2C_FCON_RXFLV_POSS,I2C_FCON_RXFLV_POSE)

#define	I2C_FCON_TXFTH_POSS	6U 
#define	I2C_FCON_TXFTH_POSE	7U 
#define	I2C_FCON_TXFTH_MSK	BITS(I2C_FCON_TXFTH_POSS,I2C_FCON_TXFTH_POSE)

#define	I2C_FCON_TXFRST_POS	5U 
#define	I2C_FCON_TXFRST_MSK	BIT(I2C_FCON_TXFRST_POS)

#define	I2C_FCON_TXFLV_POSS	0U 
#define	I2C_FCON_TXFLV_POSE	4U 
#define	I2C_FCON_TXFLV_MSK	BITS(I2C_FCON_TXFLV_POSS,I2C_FCON_TXFLV_POSE)

/****************** Bit definition for I2C_PECR register ************************/

#define	I2C_PECR_PEC_POSS	0U 
#define	I2C_PECR_PEC_POSE	7U 
#define	I2C_PECR_PEC_MSK	BITS(I2C_PECR_PEC_POSS,I2C_PECR_PEC_POSE)

/****************** Bit definition for I2C_RXDATA register ************************/

#define	I2C_RXDATA_RXDATA_POSS	0U 
#define	I2C_RXDATA_RXDATA_POSE	7U 
#define	I2C_RXDATA_RXDATA_MSK	BITS(I2C_RXDATA_RXDATA_POSS,I2C_RXDATA_RXDATA_POSE)

/****************** Bit definition for I2C_TXDATA register ************************/

#define	I2C_TXDATA_TXDATA_POSS	0U 
#define	I2C_TXDATA_TXDATA_POSE	7U 
#define	I2C_TXDATA_TXDATA_MSK	BITS(I2C_TXDATA_TXDATA_POSS,I2C_TXDATA_TXDATA_POSE)

/****************** Bit definition for I2C_IER register ************************/

#define	I2C_IER_ALERTIE_POS	20U 
#define	I2C_IER_ALERTIE_MSK	BIT(I2C_IER_ALERTIE_POS)

#define	I2C_IER_TOUTIE_POS	19U 
#define	I2C_IER_TOUTIE_MSK	BIT(I2C_IER_TOUTIE_POS)

#define	I2C_IER_PECEIE_POS	18U 
#define	I2C_IER_PECEIE_MSK	BIT(I2C_IER_PECEIE_POS)

#define	I2C_IER_ARLOIE_POS	17U 
#define	I2C_IER_ARLOIE_MSK	BIT(I2C_IER_ARLOIE_POS)

#define	I2C_IER_BERRIE_POS	16U 
#define	I2C_IER_BERRIE_MSK	BIT(I2C_IER_BERRIE_POS)

#define	I2C_IER_STOPIE_POS	14U 
#define	I2C_IER_STOPIE_MSK	BIT(I2C_IER_STOPIE_POS)

#define	I2C_IER_NACKIE_POS	13U 
#define	I2C_IER_NACKIE_MSK	BIT(I2C_IER_NACKIE_POS)

#define	I2C_IER_ADDRIE_POS	12U 
#define	I2C_IER_ADDRIE_MSK	BIT(I2C_IER_ADDRIE_POS)

#define	I2C_IER_TCRIE_POS	11U 
#define	I2C_IER_TCRIE_MSK	BIT(I2C_IER_TCRIE_POS)

#define	I2C_IER_TCIE_POS	10U 
#define	I2C_IER_TCIE_MSK	BIT(I2C_IER_TCIE_POS)

#define	I2C_IER_RXTHIE_POS	9U 
#define	I2C_IER_RXTHIE_MSK	BIT(I2C_IER_RXTHIE_POS)

#define	I2C_IER_RXUDIE_POS	8U 
#define	I2C_IER_RXUDIE_MSK	BIT(I2C_IER_RXUDIE_POS)

#define	I2C_IER_RXOVIE_POS	7U 
#define	I2C_IER_RXOVIE_MSK	BIT(I2C_IER_RXOVIE_POS)

#define	I2C_IER_RXFIE_POS	6U 
#define	I2C_IER_RXFIE_MSK	BIT(I2C_IER_RXFIE_POS)

#define	I2C_IER_TXTHIE_POS	4U 
#define	I2C_IER_TXTHIE_MSK	BIT(I2C_IER_TXTHIE_POS)

#define	I2C_IER_TXUDIE_POS	3U 
#define	I2C_IER_TXUDIE_MSK	BIT(I2C_IER_TXUDIE_POS)

#define	I2C_IER_TXOVIE_POS	2U 
#define	I2C_IER_TXOVIE_MSK	BIT(I2C_IER_TXOVIE_POS)

#define	I2C_IER_TXEIE_POS	0U 
#define	I2C_IER_TXEIE_MSK	BIT(I2C_IER_TXEIE_POS)

/****************** Bit definition for I2C_IDR register ************************/

#define	I2C_IDR_ALERTID_POS	20U 
#define	I2C_IDR_ALERTID_MSK	BIT(I2C_IDR_ALERTID_POS)

#define	I2C_IDR_TOUTID_POS	19U 
#define	I2C_IDR_TOUTID_MSK	BIT(I2C_IDR_TOUTID_POS)

#define	I2C_IDR_PECEID_POS	18U 
#define	I2C_IDR_PECEID_MSK	BIT(I2C_IDR_PECEID_POS)

#define	I2C_IDR_ARLOID_POS	17U 
#define	I2C_IDR_ARLOID_MSK	BIT(I2C_IDR_ARLOID_POS)

#define	I2C_IDR_BERRID_POS	16U 
#define	I2C_IDR_BERRID_MSK	BIT(I2C_IDR_BERRID_POS)

#define	I2C_IDR_STOPID_POS	14U 
#define	I2C_IDR_STOPID_MSK	BIT(I2C_IDR_STOPID_POS)

#define	I2C_IDR_NACKID_POS	13U 
#define	I2C_IDR_NACKID_MSK	BIT(I2C_IDR_NACKID_POS)

#define	I2C_IDR_ADDRID_POS	12U 
#define	I2C_IDR_ADDRID_MSK	BIT(I2C_IDR_ADDRID_POS)

#define	I2C_IDR_TCRID_POS	11U 
#define	I2C_IDR_TCRID_MSK	BIT(I2C_IDR_TCRID_POS)

#define	I2C_IDR_TCID_POS	10U 
#define	I2C_IDR_TCID_MSK	BIT(I2C_IDR_TCID_POS)

#define	I2C_IDR_RXTHID_POS	9U 
#define	I2C_IDR_RXTHID_MSK	BIT(I2C_IDR_RXTHID_POS)

#define	I2C_IDR_RXUDID_POS	8U 
#define	I2C_IDR_RXUDID_MSK	BIT(I2C_IDR_RXUDID_POS)

#define	I2C_IDR_RXOVID_POS	7U 
#define	I2C_IDR_RXOVID_MSK	BIT(I2C_IDR_RXOVID_POS)

#define	I2C_IDR_RXFID_POS	6U 
#define	I2C_IDR_RXFID_MSK	BIT(I2C_IDR_RXFID_POS)

#define	I2C_IDR_TXTHID_POS	4U 
#define	I2C_IDR_TXTHID_MSK	BIT(I2C_IDR_TXTHID_POS)

#define	I2C_IDR_TXUDID_POS	3U 
#define	I2C_IDR_TXUDID_MSK	BIT(I2C_IDR_TXUDID_POS)

#define	I2C_IDR_TXOVID_POS	2U 
#define	I2C_IDR_TXOVID_MSK	BIT(I2C_IDR_TXOVID_POS)

#define	I2C_IDR_TXEID_POS	0U 
#define	I2C_IDR_TXEID_MSK	BIT(I2C_IDR_TXEID_POS)

/****************** Bit definition for I2C_IVS register ************************/

#define	I2C_IVS_ALERTIV_POS	20U 
#define	I2C_IVS_ALERTIV_MSK	BIT(I2C_IVS_ALERTIV_POS)

#define	I2C_IVS_TOUTIV_POS	19U 
#define	I2C_IVS_TOUTIV_MSK	BIT(I2C_IVS_TOUTIV_POS)

#define	I2C_IVS_PECEIV_POS	18U 
#define	I2C_IVS_PECEIV_MSK	BIT(I2C_IVS_PECEIV_POS)

#define	I2C_IVS_ARLOIV_POS	17U 
#define	I2C_IVS_ARLOIV_MSK	BIT(I2C_IVS_ARLOIV_POS)

#define	I2C_IVS_BERRIV_POS	16U 
#define	I2C_IVS_BERRIV_MSK	BIT(I2C_IVS_BERRIV_POS)

#define	I2C_IVS_STOPIV_POS	14U 
#define	I2C_IVS_STOPIV_MSK	BIT(I2C_IVS_STOPIV_POS)

#define	I2C_IVS_NACKIV_POS	13U 
#define	I2C_IVS_NACKIV_MSK	BIT(I2C_IVS_NACKIV_POS)

#define	I2C_IVS_ADDRIV_POS	12U 
#define	I2C_IVS_ADDRIV_MSK	BIT(I2C_IVS_ADDRIV_POS)

#define	I2C_IVS_TCRIV_POS	11U 
#define	I2C_IVS_TCRIV_MSK	BIT(I2C_IVS_TCRIV_POS)

#define	I2C_IVS_TCIV_POS	10U 
#define	I2C_IVS_TCIV_MSK	BIT(I2C_IVS_TCIV_POS)

#define	I2C_IVS_RXTHIV_POS	9U 
#define	I2C_IVS_RXTHIV_MSK	BIT(I2C_IVS_RXTHIV_POS)

#define	I2C_IVS_RXUDIV_POS	8U 
#define	I2C_IVS_RXUDIV_MSK	BIT(I2C_IVS_RXUDIV_POS)

#define	I2C_IVS_RXOVIV_POS	7U 
#define	I2C_IVS_RXOVIV_MSK	BIT(I2C_IVS_RXOVIV_POS)

#define	I2C_IVS_RXFIV_POS	6U 
#define	I2C_IVS_RXFIV_MSK	BIT(I2C_IVS_RXFIV_POS)

#define	I2C_IVS_TXTHIV_POS	4U 
#define	I2C_IVS_TXTHIV_MSK	BIT(I2C_IVS_TXTHIV_POS)

#define	I2C_IVS_TXUDIV_POS	3U 
#define	I2C_IVS_TXUDIV_MSK	BIT(I2C_IVS_TXUDIV_POS)

#define	I2C_IVS_TXOVIV_POS	2U 
#define	I2C_IVS_TXOVIV_MSK	BIT(I2C_IVS_TXOVIV_POS)

#define	I2C_IVS_TXEIV_POS	0U 
#define	I2C_IVS_TXEIV_MSK	BIT(I2C_IVS_TXEIV_POS)

/****************** Bit definition for I2C_RIF register ************************/

#define	I2C_RIF_ALERTRI_POS	20U 
#define	I2C_RIF_ALERTRI_MSK	BIT(I2C_RIF_ALERTRI_POS)

#define	I2C_RIF_TOUTRI_POS	19U 
#define	I2C_RIF_TOUTRI_MSK	BIT(I2C_RIF_TOUTRI_POS)

#define	I2C_RIF_PECERI_POS	18U 
#define	I2C_RIF_PECERI_MSK	BIT(I2C_RIF_PECERI_POS)

#define	I2C_RIF_ARLORI_POS	17U 
#define	I2C_RIF_ARLORI_MSK	BIT(I2C_RIF_ARLORI_POS)

#define	I2C_RIF_BERRRI_POS	16U 
#define	I2C_RIF_BERRRI_MSK	BIT(I2C_RIF_BERRRI_POS)

#define	I2C_RIF_STOPRI_POS	14U 
#define	I2C_RIF_STOPRI_MSK	BIT(I2C_RIF_STOPRI_POS)

#define	I2C_RIF_NACKRI_POS	13U 
#define	I2C_RIF_NACKRI_MSK	BIT(I2C_RIF_NACKRI_POS)

#define	I2C_RIF_ADDRRI_POS	12U 
#define	I2C_RIF_ADDRRI_MSK	BIT(I2C_RIF_ADDRRI_POS)

#define	I2C_RIF_TCRRI_POS	11U 
#define	I2C_RIF_TCRRI_MSK	BIT(I2C_RIF_TCRRI_POS)

#define	I2C_RIF_TCRI_POS	10U 
#define	I2C_RIF_TCRI_MSK	BIT(I2C_RIF_TCRI_POS)

#define	I2C_RIF_RXTHRI_POS	9U 
#define	I2C_RIF_RXTHRI_MSK	BIT(I2C_RIF_RXTHRI_POS)

#define	I2C_RIF_RXUDRI_POS	8U 
#define	I2C_RIF_RXUDRI_MSK	BIT(I2C_RIF_RXUDRI_POS)

#define	I2C_RIF_RXOVRI_POS	7U 
#define	I2C_RIF_RXOVRI_MSK	BIT(I2C_RIF_RXOVRI_POS)

#define	I2C_RIF_RXFRI_POS	6U 
#define	I2C_RIF_RXFRI_MSK	BIT(I2C_RIF_RXFRI_POS)

#define	I2C_RIF_TXTHRI_POS	4U 
#define	I2C_RIF_TXTHRI_MSK	BIT(I2C_RIF_TXTHRI_POS)

#define	I2C_RIF_TXUDRI_POS	3U 
#define	I2C_RIF_TXUDRI_MSK	BIT(I2C_RIF_TXUDRI_POS)

#define	I2C_RIF_TXOVRI_POS	2U 
#define	I2C_RIF_TXOVRI_MSK	BIT(I2C_RIF_TXOVRI_POS)

#define	I2C_RIF_TXERI_POS	0U 
#define	I2C_RIF_TXERI_MSK	BIT(I2C_RIF_TXERI_POS)

/****************** Bit definition for I2C_IFM register ************************/

#define	I2C_IFM_ALERTFM_POS	20U 
#define	I2C_IFM_ALERTFM_MSK	BIT(I2C_IFM_ALERTFM_POS)

#define	I2C_IFM_TOUTFM_POS	19U 
#define	I2C_IFM_TOUTFM_MSK	BIT(I2C_IFM_TOUTFM_POS)

#define	I2C_IFM_PECEFM_POS	18U 
#define	I2C_IFM_PECEFM_MSK	BIT(I2C_IFM_PECEFM_POS)

#define	I2C_IFM_ARLOFM_POS	17U 
#define	I2C_IFM_ARLOFM_MSK	BIT(I2C_IFM_ARLOFM_POS)

#define	I2C_IFM_BERRFM_POS	16U 
#define	I2C_IFM_BERRFM_MSK	BIT(I2C_IFM_BERRFM_POS)

#define	I2C_IFM_STOPFM_POS	14U 
#define	I2C_IFM_STOPFM_MSK	BIT(I2C_IFM_STOPFM_POS)

#define	I2C_IFM_NACKFM_POS	13U 
#define	I2C_IFM_NACKFM_MSK	BIT(I2C_IFM_NACKFM_POS)

#define	I2C_IFM_ADDRFM_POS	12U 
#define	I2C_IFM_ADDRFM_MSK	BIT(I2C_IFM_ADDRFM_POS)

#define	I2C_IFM_TCRFM_POS	11U 
#define	I2C_IFM_TCRFM_MSK	BIT(I2C_IFM_TCRFM_POS)

#define	I2C_IFM_TCFM_POS	10U 
#define	I2C_IFM_TCFM_MSK	BIT(I2C_IFM_TCFM_POS)

#define	I2C_IFM_RXTHFM_POS	9U 
#define	I2C_IFM_RXTHFM_MSK	BIT(I2C_IFM_RXTHFM_POS)

#define	I2C_IFM_RXUDFM_POS	8U 
#define	I2C_IFM_RXUDFM_MSK	BIT(I2C_IFM_RXUDFM_POS)

#define	I2C_IFM_RXOVFM_POS	7U 
#define	I2C_IFM_RXOVFM_MSK	BIT(I2C_IFM_RXOVFM_POS)

#define	I2C_IFM_RXFFM_POS	6U 
#define	I2C_IFM_RXFFM_MSK	BIT(I2C_IFM_RXFFM_POS)

#define	I2C_IFM_TXTHFM_POS	4U 
#define	I2C_IFM_TXTHFM_MSK	BIT(I2C_IFM_TXTHFM_POS)

#define	I2C_IFM_TXUDFM_POS	3U 
#define	I2C_IFM_TXUDFM_MSK	BIT(I2C_IFM_TXUDFM_POS)

#define	I2C_IFM_TXOVFM_POS	2U 
#define	I2C_IFM_TXOVFM_MSK	BIT(I2C_IFM_TXOVFM_POS)

#define	I2C_IFM_TXEFM_POS	0U 
#define	I2C_IFM_TXEFM_MSK	BIT(I2C_IFM_TXEFM_POS)

/****************** Bit definition for I2C_ICR register ************************/

#define	I2C_ICR_ALERTIC_POS	20U 
#define	I2C_ICR_ALERTIC_MSK	BIT(I2C_ICR_ALERTIC_POS)

#define	I2C_ICR_TOUTIC_POS	19U 
#define	I2C_ICR_TOUTIC_MSK	BIT(I2C_ICR_TOUTIC_POS)

#define	I2C_ICR_PECEIC_POS	18U 
#define	I2C_ICR_PECEIC_MSK	BIT(I2C_ICR_PECEIC_POS)

#define	I2C_ICR_ARLOIC_POS	17U 
#define	I2C_ICR_ARLOIC_MSK	BIT(I2C_ICR_ARLOIC_POS)

#define	I2C_ICR_BERRIC_POS	16U 
#define	I2C_ICR_BERRIC_MSK	BIT(I2C_ICR_BERRIC_POS)

#define	I2C_ICR_STOPIC_POS	14U 
#define	I2C_ICR_STOPIC_MSK	BIT(I2C_ICR_STOPIC_POS)

#define	I2C_ICR_NACKIC_POS	13U 
#define	I2C_ICR_NACKIC_MSK	BIT(I2C_ICR_NACKIC_POS)

#define	I2C_ICR_ADDRIC_POS	12U 
#define	I2C_ICR_ADDRIC_MSK	BIT(I2C_ICR_ADDRIC_POS)

#define	I2C_ICR_TCRIC_POS	11U 
#define	I2C_ICR_TCRIC_MSK	BIT(I2C_ICR_TCRIC_POS)

#define	I2C_ICR_TCIC_POS	10U 
#define	I2C_ICR_TCIC_MSK	BIT(I2C_ICR_TCIC_POS)

#define	I2C_ICR_RXTHIC_POS	9U 
#define	I2C_ICR_RXTHIC_MSK	BIT(I2C_ICR_RXTHIC_POS)

#define	I2C_ICR_RXUDIC_POS	8U 
#define	I2C_ICR_RXUDIC_MSK	BIT(I2C_ICR_RXUDIC_POS)

#define	I2C_ICR_RXOVIC_POS	7U 
#define	I2C_ICR_RXOVIC_MSK	BIT(I2C_ICR_RXOVIC_POS)

#define	I2C_ICR_RXFIC_POS	6U 
#define	I2C_ICR_RXFIC_MSK	BIT(I2C_ICR_RXFIC_POS)

#define	I2C_ICR_TXTHIC_POS	4U 
#define	I2C_ICR_TXTHIC_MSK	BIT(I2C_ICR_TXTHIC_POS)

#define	I2C_ICR_TXUDIC_POS	3U 
#define	I2C_ICR_TXUDIC_MSK	BIT(I2C_ICR_TXUDIC_POS)

#define	I2C_ICR_TXOVIC_POS	2U 
#define	I2C_ICR_TXOVIC_MSK	BIT(I2C_ICR_TXOVIC_POS)

#define	I2C_ICR_TXEIC_POS	0U 
#define	I2C_ICR_TXEIC_MSK	BIT(I2C_ICR_TXEIC_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t ADDR1;
	__IO uint32_t ADDR2;
	__IO uint32_t TIMINGR;
	__IO uint32_t TIMEOUTR;
	__I uint32_t STAT;
	__IO uint32_t FCON;
	__I uint32_t PECR;
	__I uint32_t RXDATA;
	__O uint32_t TXDATA;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} I2C_TypeDef;

/****************** Bit definition for CAN_CON register ************************/

#define	CAN_CON_DBGSTP_POS	16U 
#define	CAN_CON_DBGSTP_MSK	BIT(CAN_CON_DBGSTP_POS)

#define	CAN_CON_RST_POS	15U 
#define	CAN_CON_RST_MSK	BIT(CAN_CON_RST_POS)

#define	CAN_CON_TTCEN_POS	7U 
#define	CAN_CON_TTCEN_MSK	BIT(CAN_CON_TTCEN_POS)

#define	CAN_CON_ABOFFEN_POS	6U 
#define	CAN_CON_ABOFFEN_MSK	BIT(CAN_CON_ABOFFEN_POS)

#define	CAN_CON_AWKEN_POS	5U 
#define	CAN_CON_AWKEN_MSK	BIT(CAN_CON_AWKEN_POS)

#define	CAN_CON_ARTXDIS_POS	4U 
#define	CAN_CON_ARTXDIS_MSK	BIT(CAN_CON_ARTXDIS_POS)

#define	CAN_CON_RXFOPM_POS	3U 
#define	CAN_CON_RXFOPM_MSK	BIT(CAN_CON_RXFOPM_POS)

#define	CAN_CON_TXMP_POS	2U 
#define	CAN_CON_TXMP_MSK	BIT(CAN_CON_TXMP_POS)

#define	CAN_CON_SLPREQ_POS	1U 
#define	CAN_CON_SLPREQ_MSK	BIT(CAN_CON_SLPREQ_POS)

#define	CAN_CON_INIREQ_POS	0U 
#define	CAN_CON_INIREQ_MSK	BIT(CAN_CON_INIREQ_POS)

/****************** Bit definition for CAN_STAT register ************************/

#define	CAN_STAT_RX_POS	11U 
#define	CAN_STAT_RX_MSK	BIT(CAN_STAT_RX_POS)

#define	CAN_STAT_PRESMP_POS	10U 
#define	CAN_STAT_PRESMP_MSK	BIT(CAN_STAT_PRESMP_POS)

#define	CAN_STAT_RXSTAT_POS	9U 
#define	CAN_STAT_RXSTAT_MSK	BIT(CAN_STAT_RXSTAT_POS)

#define	CAN_STAT_TXSTAT_POS	8U 
#define	CAN_STAT_TXSTAT_MSK	BIT(CAN_STAT_TXSTAT_POS)

#define	CAN_STAT_SLPIF_POS	4U 
#define	CAN_STAT_SLPIF_MSK	BIT(CAN_STAT_SLPIF_POS)

#define	CAN_STAT_WKIF_POS	3U 
#define	CAN_STAT_WKIF_MSK	BIT(CAN_STAT_WKIF_POS)

#define	CAN_STAT_ERRIF_POS	2U 
#define	CAN_STAT_ERRIF_MSK	BIT(CAN_STAT_ERRIF_POS)

#define	CAN_STAT_SLPSTAT_POS	1U 
#define	CAN_STAT_SLPSTAT_MSK	BIT(CAN_STAT_SLPSTAT_POS)

#define	CAN_STAT_INISTAT_POS	0U 
#define	CAN_STAT_INISTAT_MSK	BIT(CAN_STAT_INISTAT_POS)

/****************** Bit definition for CAN_IFC register ************************/

#define	CAN_IFC_SLPIFC_POS	4U 
#define	CAN_IFC_SLPIFC_MSK	BIT(CAN_IFC_SLPIFC_POS)

#define	CAN_IFC_WKIFC_POS	3U 
#define	CAN_IFC_WKIFC_MSK	BIT(CAN_IFC_WKIFC_POS)

#define	CAN_IFC_ERRIFC_POS	2U 
#define	CAN_IFC_ERRIFC_MSK	BIT(CAN_IFC_ERRIFC_POS)

/****************** Bit definition for CAN_TXSTAT register ************************/

#define	CAN_TXSTAT_TXM2LPF_POS	31U 
#define	CAN_TXSTAT_TXM2LPF_MSK	BIT(CAN_TXSTAT_TXM2LPF_POS)

#define	CAN_TXSTAT_TXM1LPF_POS	30U 
#define	CAN_TXSTAT_TXM1LPF_MSK	BIT(CAN_TXSTAT_TXM1LPF_POS)

#define	CAN_TXSTAT_TXM0LPF_POS	29U 
#define	CAN_TXSTAT_TXM0LPF_MSK	BIT(CAN_TXSTAT_TXM0LPF_POS)

#define	CAN_TXSTAT_TXM2EF_POS	28U 
#define	CAN_TXSTAT_TXM2EF_MSK	BIT(CAN_TXSTAT_TXM2EF_POS)

#define	CAN_TXSTAT_TXM1EF_POS	27U 
#define	CAN_TXSTAT_TXM1EF_MSK	BIT(CAN_TXSTAT_TXM1EF_POS)

#define	CAN_TXSTAT_TXM0EF_POS	26U 
#define	CAN_TXSTAT_TXM0EF_MSK	BIT(CAN_TXSTAT_TXM0EF_POS)

#define	CAN_TXSTAT_CODE_POSS	24U 
#define	CAN_TXSTAT_CODE_POSE	25U 
#define	CAN_TXSTAT_CODE_MSK	BITS(CAN_TXSTAT_CODE_POSS,CAN_TXSTAT_CODE_POSE)

#define	CAN_TXSTAT_M2STPREQ_POS	23U 
#define	CAN_TXSTAT_M2STPREQ_MSK	BIT(CAN_TXSTAT_M2STPREQ_POS)

#define	CAN_TXSTAT_M2TXERR_POS	19U 
#define	CAN_TXSTAT_M2TXERR_MSK	BIT(CAN_TXSTAT_M2TXERR_POS)

#define	CAN_TXSTAT_M2ARBLST_POS	18U 
#define	CAN_TXSTAT_M2ARBLST_MSK	BIT(CAN_TXSTAT_M2ARBLST_POS)

#define	CAN_TXSTAT_M2TXC_POS	17U 
#define	CAN_TXSTAT_M2TXC_MSK	BIT(CAN_TXSTAT_M2TXC_POS)

#define	CAN_TXSTAT_M2REQC_POS	16U 
#define	CAN_TXSTAT_M2REQC_MSK	BIT(CAN_TXSTAT_M2REQC_POS)

#define	CAN_TXSTAT_M1STPREQ_POS	15U 
#define	CAN_TXSTAT_M1STPREQ_MSK	BIT(CAN_TXSTAT_M1STPREQ_POS)

#define	CAN_TXSTAT_M1TXERR_POS	11U 
#define	CAN_TXSTAT_M1TXERR_MSK	BIT(CAN_TXSTAT_M1TXERR_POS)

#define	CAN_TXSTAT_M1ARBLST_POS	10U 
#define	CAN_TXSTAT_M1ARBLST_MSK	BIT(CAN_TXSTAT_M1ARBLST_POS)

#define	CAN_TXSTAT_M1TXC_POS	9U 
#define	CAN_TXSTAT_M1TXC_MSK	BIT(CAN_TXSTAT_M1TXC_POS)

#define	CAN_TXSTAT_M1REQC_POS	8U 
#define	CAN_TXSTAT_M1REQC_MSK	BIT(CAN_TXSTAT_M1REQC_POS)

#define	CAN_TXSTAT_M0STPREQ_POS	7U 
#define	CAN_TXSTAT_M0STPREQ_MSK	BIT(CAN_TXSTAT_M0STPREQ_POS)

#define	CAN_TXSTAT_M0TXERR_POS	3U 
#define	CAN_TXSTAT_M0TXERR_MSK	BIT(CAN_TXSTAT_M0TXERR_POS)

#define	CAN_TXSTAT_M0ARBLST_POS	2U 
#define	CAN_TXSTAT_M0ARBLST_MSK	BIT(CAN_TXSTAT_M0ARBLST_POS)

#define	CAN_TXSTAT_M0TXC_POS	1U 
#define	CAN_TXSTAT_M0TXC_MSK	BIT(CAN_TXSTAT_M0TXC_POS)

#define	CAN_TXSTAT_M0REQC_POS	0U 
#define	CAN_TXSTAT_M0REQC_MSK	BIT(CAN_TXSTAT_M0REQC_POS)

/****************** Bit definition for CAN_TXSTATC register ************************/

#define	CAN_TXSTATC_M2TXERR_POS	19U 
#define	CAN_TXSTATC_M2TXERR_MSK	BIT(CAN_TXSTATC_M2TXERR_POS)

#define	CAN_TXSTATC_M2ARBLST_POS	18U 
#define	CAN_TXSTATC_M2ARBLST_MSK	BIT(CAN_TXSTATC_M2ARBLST_POS)

#define	CAN_TXSTATC_M2TXC_POS	17U 
#define	CAN_TXSTATC_M2TXC_MSK	BIT(CAN_TXSTATC_M2TXC_POS)

#define	CAN_TXSTATC_M2REQC_POS	16U 
#define	CAN_TXSTATC_M2REQC_MSK	BIT(CAN_TXSTATC_M2REQC_POS)

#define	CAN_TXSTATC_M1TXERR_POS	11U 
#define	CAN_TXSTATC_M1TXERR_MSK	BIT(CAN_TXSTATC_M1TXERR_POS)

#define	CAN_TXSTATC_M1ARBLST_POS	10U 
#define	CAN_TXSTATC_M1ARBLST_MSK	BIT(CAN_TXSTATC_M1ARBLST_POS)

#define	CAN_TXSTATC_M1TXC_POS	9U 
#define	CAN_TXSTATC_M1TXC_MSK	BIT(CAN_TXSTATC_M1TXC_POS)

#define	CAN_TXSTATC_M1REQC_POS	8U 
#define	CAN_TXSTATC_M1REQC_MSK	BIT(CAN_TXSTATC_M1REQC_POS)

#define	CAN_TXSTATC_M0TXERR_POS	3U 
#define	CAN_TXSTATC_M0TXERR_MSK	BIT(CAN_TXSTATC_M0TXERR_POS)

#define	CAN_TXSTATC_M0ARBLST_POS	2U 
#define	CAN_TXSTATC_M0ARBLST_MSK	BIT(CAN_TXSTATC_M0ARBLST_POS)

#define	CAN_TXSTATC_M0TXC_POS	1U 
#define	CAN_TXSTATC_M0TXC_MSK	BIT(CAN_TXSTATC_M0TXC_POS)

#define	CAN_TXSTATC_M0REQC_POS	0U 
#define	CAN_TXSTATC_M0REQC_MSK	BIT(CAN_TXSTATC_M0REQC_POS)

/****************** Bit definition for CAN_RXF0 register ************************/

#define	CAN_RXF0_FREE_POS	5U 
#define	CAN_RXF0_FREE_MSK	BIT(CAN_RXF0_FREE_POS)

#define	CAN_RXF0_OVR_POS	4U 
#define	CAN_RXF0_OVR_MSK	BIT(CAN_RXF0_OVR_POS)

#define	CAN_RXF0_FULL_POS	3U 
#define	CAN_RXF0_FULL_MSK	BIT(CAN_RXF0_FULL_POS)

#define	CAN_RXF0_PEND_POSS	0U 
#define	CAN_RXF0_PEND_POSE	1U 
#define	CAN_RXF0_PEND_MSK	BITS(CAN_RXF0_PEND_POSS,CAN_RXF0_PEND_POSE)

/****************** Bit definition for CAN_RXF0C register ************************/

#define	CAN_RXF0C_OVRC_POS	4U 
#define	CAN_RXF0C_OVRC_MSK	BIT(CAN_RXF0C_OVRC_POS)

#define	CAN_RXF0C_FULLC_POS	3U 
#define	CAN_RXF0C_FULLC_MSK	BIT(CAN_RXF0C_FULLC_POS)

/****************** Bit definition for CAN_RXF1 register ************************/

#define	CAN_RXF1_FREE_POS	5U 
#define	CAN_RXF1_FREE_MSK	BIT(CAN_RXF1_FREE_POS)

#define	CAN_RXF1_OVR_POS	4U 
#define	CAN_RXF1_OVR_MSK	BIT(CAN_RXF1_OVR_POS)

#define	CAN_RXF1_FULL_POS	3U 
#define	CAN_RXF1_FULL_MSK	BIT(CAN_RXF1_FULL_POS)

#define	CAN_RXF1_PEND_POSS	0U 
#define	CAN_RXF1_PEND_POSE	1U 
#define	CAN_RXF1_PEND_MSK	BITS(CAN_RXF1_PEND_POSS,CAN_RXF1_PEND_POSE)

/****************** Bit definition for CAN_RXF1C register ************************/

#define	CAN_RXF1C_OVRC_POS	4U 
#define	CAN_RXF1C_OVRC_MSK	BIT(CAN_RXF1C_OVRC_POS)

#define	CAN_RXF1C_FULLC_POS	3U 
#define	CAN_RXF1C_FULLC_MSK	BIT(CAN_RXF1C_FULLC_POS)

/****************** Bit definition for CAN_IE register ************************/

#define	CAN_IE_SLPIE_POS	17U 
#define	CAN_IE_SLPIE_MSK	BIT(CAN_IE_SLPIE_POS)

#define	CAN_IE_WKIE_POS	16U 
#define	CAN_IE_WKIE_MSK	BIT(CAN_IE_WKIE_POS)

#define	CAN_IE_ERRIE_POS	15U 
#define	CAN_IE_ERRIE_MSK	BIT(CAN_IE_ERRIE_POS)

#define	CAN_IE_PRERRIE_POS	11U 
#define	CAN_IE_PRERRIE_MSK	BIT(CAN_IE_PRERRIE_POS)

#define	CAN_IE_BOFFIE_POS	10U 
#define	CAN_IE_BOFFIE_MSK	BIT(CAN_IE_BOFFIE_POS)

#define	CAN_IE_PERRIE_POS	9U 
#define	CAN_IE_PERRIE_MSK	BIT(CAN_IE_PERRIE_POS)

#define	CAN_IE_WARNIE_POS	8U 
#define	CAN_IE_WARNIE_MSK	BIT(CAN_IE_WARNIE_POS)

#define	CAN_IE_F1OVRIE_POS	6U 
#define	CAN_IE_F1OVRIE_MSK	BIT(CAN_IE_F1OVRIE_POS)

#define	CAN_IE_F1FULIE_POS	5U 
#define	CAN_IE_F1FULIE_MSK	BIT(CAN_IE_F1FULIE_POS)

#define	CAN_IE_F1PIE_POS	4U 
#define	CAN_IE_F1PIE_MSK	BIT(CAN_IE_F1PIE_POS)

#define	CAN_IE_F0OVRIE_POS	3U 
#define	CAN_IE_F0OVRIE_MSK	BIT(CAN_IE_F0OVRIE_POS)

#define	CAN_IE_F0FULIE_POS	2U 
#define	CAN_IE_F0FULIE_MSK	BIT(CAN_IE_F0FULIE_POS)

#define	CAN_IE_F0PIE_POS	1U 
#define	CAN_IE_F0PIE_MSK	BIT(CAN_IE_F0PIE_POS)

#define	CAN_IE_TXMEIE_POS	0U 
#define	CAN_IE_TXMEIE_MSK	BIT(CAN_IE_TXMEIE_POS)

/****************** Bit definition for CAN_ERRSTAT register ************************/

#define	CAN_ERRSTAT_RXERRC_POSS	24U 
#define	CAN_ERRSTAT_RXERRC_POSE	31U 
#define	CAN_ERRSTAT_RXERRC_MSK	BITS(CAN_ERRSTAT_RXERRC_POSS,CAN_ERRSTAT_RXERRC_POSE)

#define	CAN_ERRSTAT_TXERRC_POSS	16U 
#define	CAN_ERRSTAT_TXERRC_POSE	23U 
#define	CAN_ERRSTAT_TXERRC_MSK	BITS(CAN_ERRSTAT_TXERRC_POSS,CAN_ERRSTAT_TXERRC_POSE)

#define	CAN_ERRSTAT_PRERRF_POSS	4U 
#define	CAN_ERRSTAT_PRERRF_POSE	6U 
#define	CAN_ERRSTAT_PRERRF_MSK	BITS(CAN_ERRSTAT_PRERRF_POSS,CAN_ERRSTAT_PRERRF_POSE)

#define	CAN_ERRSTAT_BOFF_POS	2U 
#define	CAN_ERRSTAT_BOFF_MSK	BIT(CAN_ERRSTAT_BOFF_POS)

#define	CAN_ERRSTAT_PERRF_POS	1U 
#define	CAN_ERRSTAT_PERRF_MSK	BIT(CAN_ERRSTAT_PERRF_POS)

#define	CAN_ERRSTAT_WARNF_POS	0U 
#define	CAN_ERRSTAT_WARNF_MSK	BIT(CAN_ERRSTAT_WARNF_POS)

/****************** Bit definition for CAN_BTIME register ************************/

#define	CAN_BTIME_SILENT_POS	31U 
#define	CAN_BTIME_SILENT_MSK	BIT(CAN_BTIME_SILENT_POS)

#define	CAN_BTIME_LOOP_POS	30U 
#define	CAN_BTIME_LOOP_MSK	BIT(CAN_BTIME_LOOP_POS)

#define	CAN_BTIME_RESJW_POSS	24U 
#define	CAN_BTIME_RESJW_POSE	25U 
#define	CAN_BTIME_RESJW_MSK	BITS(CAN_BTIME_RESJW_POSS,CAN_BTIME_RESJW_POSE)

#define	CAN_BTIME_SEG2_POSS	20U 
#define	CAN_BTIME_SEG2_POSE	22U 
#define	CAN_BTIME_SEG2_MSK	BITS(CAN_BTIME_SEG2_POSS,CAN_BTIME_SEG2_POSE)

#define	CAN_BTIME_SEG1_POSS	16U 
#define	CAN_BTIME_SEG1_POSE	19U 
#define	CAN_BTIME_SEG1_MSK	BITS(CAN_BTIME_SEG1_POSS,CAN_BTIME_SEG1_POSE)

#define	CAN_BTIME_BPSC_POSS	0U 
#define	CAN_BTIME_BPSC_POSE	9U 
#define	CAN_BTIME_BPSC_MSK	BITS(CAN_BTIME_BPSC_POSS,CAN_BTIME_BPSC_POSE)

/****************** Bit definition for CAN_TXID0 register ************************/

#define	CAN_TXID0_STDID_POSS	21U 
#define	CAN_TXID0_STDID_POSE	31U 
#define	CAN_TXID0_STDID_MSK	BITS(CAN_TXID0_STDID_POSS,CAN_TXID0_STDID_POSE)

#define	CAN_TXID0_EXID_POSS	3U 
#define	CAN_TXID0_EXID_POSE	20U 
#define	CAN_TXID0_EXID_MSK	BITS(CAN_TXID0_EXID_POSS,CAN_TXID0_EXID_POSE)

#define	CAN_TXID0_IDE_POS	2U 
#define	CAN_TXID0_IDE_MSK	BIT(CAN_TXID0_IDE_POS)

#define	CAN_TXID0_RTR_POS	1U 
#define	CAN_TXID0_RTR_MSK	BIT(CAN_TXID0_RTR_POS)

#define	CAN_TXID0_TXMREQ_POS	0U 
#define	CAN_TXID0_TXMREQ_MSK	BIT(CAN_TXID0_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON0 register ************************/

#define	CAN_TXFCON0_STAMP_POSS	16U 
#define	CAN_TXFCON0_STAMP_POSE	31U 
#define	CAN_TXFCON0_STAMP_MSK	BITS(CAN_TXFCON0_STAMP_POSS,CAN_TXFCON0_STAMP_POSE)

#define	CAN_TXFCON0_TXGT_POS	8U 
#define	CAN_TXFCON0_TXGT_MSK	BIT(CAN_TXFCON0_TXGT_POS)

#define	CAN_TXFCON0_DLEN_POSS	0U 
#define	CAN_TXFCON0_DLEN_POSE	3U 
#define	CAN_TXFCON0_DLEN_MSK	BITS(CAN_TXFCON0_DLEN_POSS,CAN_TXFCON0_DLEN_POSE)

/****************** Bit definition for CAN_TXDL0 register ************************/

#define	CAN_TXDL0_BYTE3_POSS	24U 
#define	CAN_TXDL0_BYTE3_POSE	31U 
#define	CAN_TXDL0_BYTE3_MSK	BITS(CAN_TXDL0_BYTE3_POSS,CAN_TXDL0_BYTE3_POSE)

#define	CAN_TXDL0_BYTE2_POSS	16U 
#define	CAN_TXDL0_BYTE2_POSE	23U 
#define	CAN_TXDL0_BYTE2_MSK	BITS(CAN_TXDL0_BYTE2_POSS,CAN_TXDL0_BYTE2_POSE)

#define	CAN_TXDL0_BYTE1_POSS	8U 
#define	CAN_TXDL0_BYTE1_POSE	15U 
#define	CAN_TXDL0_BYTE1_MSK	BITS(CAN_TXDL0_BYTE1_POSS,CAN_TXDL0_BYTE1_POSE)

#define	CAN_TXDL0_BYTE0_POSS	0U 
#define	CAN_TXDL0_BYTE0_POSE	7U 
#define	CAN_TXDL0_BYTE0_MSK	BITS(CAN_TXDL0_BYTE0_POSS,CAN_TXDL0_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH0 register ************************/

#define	CAN_TXDH0_BYTE7_POSS	24U 
#define	CAN_TXDH0_BYTE7_POSE	31U 
#define	CAN_TXDH0_BYTE7_MSK	BITS(CAN_TXDH0_BYTE7_POSS,CAN_TXDH0_BYTE7_POSE)

#define	CAN_TXDH0_BYTE6_POSS	16U 
#define	CAN_TXDH0_BYTE6_POSE	23U 
#define	CAN_TXDH0_BYTE6_MSK	BITS(CAN_TXDH0_BYTE6_POSS,CAN_TXDH0_BYTE6_POSE)

#define	CAN_TXDH0_BYTE5_POSS	8U 
#define	CAN_TXDH0_BYTE5_POSE	15U 
#define	CAN_TXDH0_BYTE5_MSK	BITS(CAN_TXDH0_BYTE5_POSS,CAN_TXDH0_BYTE5_POSE)

#define	CAN_TXDH0_BYTE4_POSS	0U 
#define	CAN_TXDH0_BYTE4_POSE	7U 
#define	CAN_TXDH0_BYTE4_MSK	BITS(CAN_TXDH0_BYTE4_POSS,CAN_TXDH0_BYTE4_POSE)

/****************** Bit definition for CAN_TXID1 register ************************/

#define	CAN_TXID1_STDID_POSS	21U 
#define	CAN_TXID1_STDID_POSE	31U 
#define	CAN_TXID1_STDID_MSK	BITS(CAN_TXID1_STDID_POSS,CAN_TXID1_STDID_POSE)

#define	CAN_TXID1_EXID_POSS	3U 
#define	CAN_TXID1_EXID_POSE	20U 
#define	CAN_TXID1_EXID_MSK	BITS(CAN_TXID1_EXID_POSS,CAN_TXID1_EXID_POSE)

#define	CAN_TXID1_IDE_POS	2U 
#define	CAN_TXID1_IDE_MSK	BIT(CAN_TXID1_IDE_POS)

#define	CAN_TXID1_RTR_POS	1U 
#define	CAN_TXID1_RTR_MSK	BIT(CAN_TXID1_RTR_POS)

#define	CAN_TXID1_TXMREQ_POS	0U 
#define	CAN_TXID1_TXMREQ_MSK	BIT(CAN_TXID1_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON1 register ************************/

#define	CAN_TXFCON1_STAMP_POSS	16U 
#define	CAN_TXFCON1_STAMP_POSE	31U 
#define	CAN_TXFCON1_STAMP_MSK	BITS(CAN_TXFCON1_STAMP_POSS,CAN_TXFCON1_STAMP_POSE)

#define	CAN_TXFCON1_TXGT_POS	8U 
#define	CAN_TXFCON1_TXGT_MSK	BIT(CAN_TXFCON1_TXGT_POS)

#define	CAN_TXFCON1_DLEN_POSS	0U 
#define	CAN_TXFCON1_DLEN_POSE	3U 
#define	CAN_TXFCON1_DLEN_MSK	BITS(CAN_TXFCON1_DLEN_POSS,CAN_TXFCON1_DLEN_POSE)

/****************** Bit definition for CAN_TXDL1 register ************************/

#define	CAN_TXDL1_BYTE3_POSS	24U 
#define	CAN_TXDL1_BYTE3_POSE	31U 
#define	CAN_TXDL1_BYTE3_MSK	BITS(CAN_TXDL1_BYTE3_POSS,CAN_TXDL1_BYTE3_POSE)

#define	CAN_TXDL1_BYTE2_POSS	16U 
#define	CAN_TXDL1_BYTE2_POSE	23U 
#define	CAN_TXDL1_BYTE2_MSK	BITS(CAN_TXDL1_BYTE2_POSS,CAN_TXDL1_BYTE2_POSE)

#define	CAN_TXDL1_BYTE1_POSS	8U 
#define	CAN_TXDL1_BYTE1_POSE	15U 
#define	CAN_TXDL1_BYTE1_MSK	BITS(CAN_TXDL1_BYTE1_POSS,CAN_TXDL1_BYTE1_POSE)

#define	CAN_TXDL1_BYTE0_POSS	0U 
#define	CAN_TXDL1_BYTE0_POSE	7U 
#define	CAN_TXDL1_BYTE0_MSK	BITS(CAN_TXDL1_BYTE0_POSS,CAN_TXDL1_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH1 register ************************/

#define	CAN_TXDH1_BYTE7_POSS	24U 
#define	CAN_TXDH1_BYTE7_POSE	31U 
#define	CAN_TXDH1_BYTE7_MSK	BITS(CAN_TXDH1_BYTE7_POSS,CAN_TXDH1_BYTE7_POSE)

#define	CAN_TXDH1_BYTE6_POSS	16U 
#define	CAN_TXDH1_BYTE6_POSE	23U 
#define	CAN_TXDH1_BYTE6_MSK	BITS(CAN_TXDH1_BYTE6_POSS,CAN_TXDH1_BYTE6_POSE)

#define	CAN_TXDH1_BYTE5_POSS	8U 
#define	CAN_TXDH1_BYTE5_POSE	15U 
#define	CAN_TXDH1_BYTE5_MSK	BITS(CAN_TXDH1_BYTE5_POSS,CAN_TXDH1_BYTE5_POSE)

#define	CAN_TXDH1_BYTE4_POSS	0U 
#define	CAN_TXDH1_BYTE4_POSE	7U 
#define	CAN_TXDH1_BYTE4_MSK	BITS(CAN_TXDH1_BYTE4_POSS,CAN_TXDH1_BYTE4_POSE)

/****************** Bit definition for CAN_TXID2 register ************************/

#define	CAN_TXID2_STDID_POSS	21U 
#define	CAN_TXID2_STDID_POSE	31U 
#define	CAN_TXID2_STDID_MSK	BITS(CAN_TXID2_STDID_POSS,CAN_TXID2_STDID_POSE)

#define	CAN_TXID2_EXID_POSS	3U 
#define	CAN_TXID2_EXID_POSE	20U 
#define	CAN_TXID2_EXID_MSK	BITS(CAN_TXID2_EXID_POSS,CAN_TXID2_EXID_POSE)

#define	CAN_TXID2_IDE_POS	2U 
#define	CAN_TXID2_IDE_MSK	BIT(CAN_TXID2_IDE_POS)

#define	CAN_TXID2_RTR_POS	1U 
#define	CAN_TXID2_RTR_MSK	BIT(CAN_TXID2_RTR_POS)

#define	CAN_TXID2_TXMREQ_POS	0U 
#define	CAN_TXID2_TXMREQ_MSK	BIT(CAN_TXID2_TXMREQ_POS)

/****************** Bit definition for CAN_TXFCON2 register ************************/

#define	CAN_TXFCON2_STAMP_POSS	16U 
#define	CAN_TXFCON2_STAMP_POSE	31U 
#define	CAN_TXFCON2_STAMP_MSK	BITS(CAN_TXFCON2_STAMP_POSS,CAN_TXFCON2_STAMP_POSE)

#define	CAN_TXFCON2_TXGT_POS	8U 
#define	CAN_TXFCON2_TXGT_MSK	BIT(CAN_TXFCON2_TXGT_POS)

#define	CAN_TXFCON2_DLEN_POSS	0U 
#define	CAN_TXFCON2_DLEN_POSE	3U 
#define	CAN_TXFCON2_DLEN_MSK	BITS(CAN_TXFCON2_DLEN_POSS,CAN_TXFCON2_DLEN_POSE)

/****************** Bit definition for CAN_TXDL2 register ************************/

#define	CAN_TXDL2_BYTE3_POSS	24U 
#define	CAN_TXDL2_BYTE3_POSE	31U 
#define	CAN_TXDL2_BYTE3_MSK	BITS(CAN_TXDL2_BYTE3_POSS,CAN_TXDL2_BYTE3_POSE)

#define	CAN_TXDL2_BYTE2_POSS	16U 
#define	CAN_TXDL2_BYTE2_POSE	23U 
#define	CAN_TXDL2_BYTE2_MSK	BITS(CAN_TXDL2_BYTE2_POSS,CAN_TXDL2_BYTE2_POSE)

#define	CAN_TXDL2_BYTE1_POSS	8U 
#define	CAN_TXDL2_BYTE1_POSE	15U 
#define	CAN_TXDL2_BYTE1_MSK	BITS(CAN_TXDL2_BYTE1_POSS,CAN_TXDL2_BYTE1_POSE)

#define	CAN_TXDL2_BYTE0_POSS	0U 
#define	CAN_TXDL2_BYTE0_POSE	7U 
#define	CAN_TXDL2_BYTE0_MSK	BITS(CAN_TXDL2_BYTE0_POSS,CAN_TXDL2_BYTE0_POSE)

/****************** Bit definition for CAN_TXDH2 register ************************/

#define	CAN_TXDH2_BYTE7_POSS	24U 
#define	CAN_TXDH2_BYTE7_POSE	31U 
#define	CAN_TXDH2_BYTE7_MSK	BITS(CAN_TXDH2_BYTE7_POSS,CAN_TXDH2_BYTE7_POSE)

#define	CAN_TXDH2_BYTE6_POSS	16U 
#define	CAN_TXDH2_BYTE6_POSE	23U 
#define	CAN_TXDH2_BYTE6_MSK	BITS(CAN_TXDH2_BYTE6_POSS,CAN_TXDH2_BYTE6_POSE)

#define	CAN_TXDH2_BYTE5_POSS	8U 
#define	CAN_TXDH2_BYTE5_POSE	15U 
#define	CAN_TXDH2_BYTE5_MSK	BITS(CAN_TXDH2_BYTE5_POSS,CAN_TXDH2_BYTE5_POSE)

#define	CAN_TXDH2_BYTE4_POSS	0U 
#define	CAN_TXDH2_BYTE4_POSE	7U 
#define	CAN_TXDH2_BYTE4_MSK	BITS(CAN_TXDH2_BYTE4_POSS,CAN_TXDH2_BYTE4_POSE)

/****************** Bit definition for CAN_RXF0ID register ************************/

#define	CAN_RXF0ID_STDID_POSS	21U 
#define	CAN_RXF0ID_STDID_POSE	31U 
#define	CAN_RXF0ID_STDID_MSK	BITS(CAN_RXF0ID_STDID_POSS,CAN_RXF0ID_STDID_POSE)

#define	CAN_RXF0ID_EXID_POSS	3U 
#define	CAN_RXF0ID_EXID_POSE	20U 
#define	CAN_RXF0ID_EXID_MSK	BITS(CAN_RXF0ID_EXID_POSS,CAN_RXF0ID_EXID_POSE)

#define	CAN_RXF0ID_IDE_POS	2U 
#define	CAN_RXF0ID_IDE_MSK	BIT(CAN_RXF0ID_IDE_POS)

#define	CAN_RXF0ID_RTR_POS	1U 
#define	CAN_RXF0ID_RTR_MSK	BIT(CAN_RXF0ID_RTR_POS)

/****************** Bit definition for CAN_RXF0INF register ************************/

#define	CAN_RXF0INF_STAMP_POSS	16U 
#define	CAN_RXF0INF_STAMP_POSE	31U 
#define	CAN_RXF0INF_STAMP_MSK	BITS(CAN_RXF0INF_STAMP_POSS,CAN_RXF0INF_STAMP_POSE)

#define	CAN_RXF0INF_FLTIDX_POSS	8U 
#define	CAN_RXF0INF_FLTIDX_POSE	15U 
#define	CAN_RXF0INF_FLTIDX_MSK	BITS(CAN_RXF0INF_FLTIDX_POSS,CAN_RXF0INF_FLTIDX_POSE)

#define	CAN_RXF0INF_DLEN_POSS	0U 
#define	CAN_RXF0INF_DLEN_POSE	3U 
#define	CAN_RXF0INF_DLEN_MSK	BITS(CAN_RXF0INF_DLEN_POSS,CAN_RXF0INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF0DL register ************************/

#define	CAN_RXF0DL_BYTE3_POSS	24U 
#define	CAN_RXF0DL_BYTE3_POSE	31U 
#define	CAN_RXF0DL_BYTE3_MSK	BITS(CAN_RXF0DL_BYTE3_POSS,CAN_RXF0DL_BYTE3_POSE)

#define	CAN_RXF0DL_BYTE2_POSS	16U 
#define	CAN_RXF0DL_BYTE2_POSE	23U 
#define	CAN_RXF0DL_BYTE2_MSK	BITS(CAN_RXF0DL_BYTE2_POSS,CAN_RXF0DL_BYTE2_POSE)

#define	CAN_RXF0DL_BYTE1_POSS	8U 
#define	CAN_RXF0DL_BYTE1_POSE	15U 
#define	CAN_RXF0DL_BYTE1_MSK	BITS(CAN_RXF0DL_BYTE1_POSS,CAN_RXF0DL_BYTE1_POSE)

#define	CAN_RXF0DL_BYTE0_POSS	0U 
#define	CAN_RXF0DL_BYTE0_POSE	7U 
#define	CAN_RXF0DL_BYTE0_MSK	BITS(CAN_RXF0DL_BYTE0_POSS,CAN_RXF0DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF0DH register ************************/

#define	CAN_RXF0DH_BYTE7_POSS	24U 
#define	CAN_RXF0DH_BYTE7_POSE	31U 
#define	CAN_RXF0DH_BYTE7_MSK	BITS(CAN_RXF0DH_BYTE7_POSS,CAN_RXF0DH_BYTE7_POSE)

#define	CAN_RXF0DH_BYTE6_POSS	16U 
#define	CAN_RXF0DH_BYTE6_POSE	23U 
#define	CAN_RXF0DH_BYTE6_MSK	BITS(CAN_RXF0DH_BYTE6_POSS,CAN_RXF0DH_BYTE6_POSE)

#define	CAN_RXF0DH_BYTE5_POSS	8U 
#define	CAN_RXF0DH_BYTE5_POSE	15U 
#define	CAN_RXF0DH_BYTE5_MSK	BITS(CAN_RXF0DH_BYTE5_POSS,CAN_RXF0DH_BYTE5_POSE)

#define	CAN_RXF0DH_BYTE4_POSS	0U 
#define	CAN_RXF0DH_BYTE4_POSE	7U 
#define	CAN_RXF0DH_BYTE4_MSK	BITS(CAN_RXF0DH_BYTE4_POSS,CAN_RXF0DH_BYTE4_POSE)

/****************** Bit definition for CAN_RXF1ID register ************************/

#define	CAN_RXF1ID_STDID_POSS	21U 
#define	CAN_RXF1ID_STDID_POSE	31U 
#define	CAN_RXF1ID_STDID_MSK	BITS(CAN_RXF1ID_STDID_POSS,CAN_RXF1ID_STDID_POSE)

#define	CAN_RXF1ID_EXID_POSS	3U 
#define	CAN_RXF1ID_EXID_POSE	20U 
#define	CAN_RXF1ID_EXID_MSK	BITS(CAN_RXF1ID_EXID_POSS,CAN_RXF1ID_EXID_POSE)

#define	CAN_RXF1ID_IDE_POS	2U 
#define	CAN_RXF1ID_IDE_MSK	BIT(CAN_RXF1ID_IDE_POS)

#define	CAN_RXF1ID_RTR_POS	1U 
#define	CAN_RXF1ID_RTR_MSK	BIT(CAN_RXF1ID_RTR_POS)

/****************** Bit definition for CAN_RXF1INF register ************************/

#define	CAN_RXF1INF_STAMP_POSS	16U 
#define	CAN_RXF1INF_STAMP_POSE	31U 
#define	CAN_RXF1INF_STAMP_MSK	BITS(CAN_RXF1INF_STAMP_POSS,CAN_RXF1INF_STAMP_POSE)

#define	CAN_RXF1INF_FLTIDX_POSS	8U 
#define	CAN_RXF1INF_FLTIDX_POSE	15U 
#define	CAN_RXF1INF_FLTIDX_MSK	BITS(CAN_RXF1INF_FLTIDX_POSS,CAN_RXF1INF_FLTIDX_POSE)

#define	CAN_RXF1INF_DLEN_POSS	0U 
#define	CAN_RXF1INF_DLEN_POSE	3U 
#define	CAN_RXF1INF_DLEN_MSK	BITS(CAN_RXF1INF_DLEN_POSS,CAN_RXF1INF_DLEN_POSE)

/****************** Bit definition for CAN_RXF1DL register ************************/

#define	CAN_RXF1DL_BYTE3_POSS	24U 
#define	CAN_RXF1DL_BYTE3_POSE	31U 
#define	CAN_RXF1DL_BYTE3_MSK	BITS(CAN_RXF1DL_BYTE3_POSS,CAN_RXF1DL_BYTE3_POSE)

#define	CAN_RXF1DL_BYTE2_POSS	16U 
#define	CAN_RXF1DL_BYTE2_POSE	23U 
#define	CAN_RXF1DL_BYTE2_MSK	BITS(CAN_RXF1DL_BYTE2_POSS,CAN_RXF1DL_BYTE2_POSE)

#define	CAN_RXF1DL_BYTE1_POSS	8U 
#define	CAN_RXF1DL_BYTE1_POSE	15U 
#define	CAN_RXF1DL_BYTE1_MSK	BITS(CAN_RXF1DL_BYTE1_POSS,CAN_RXF1DL_BYTE1_POSE)

#define	CAN_RXF1DL_BYTE0_POSS	0U 
#define	CAN_RXF1DL_BYTE0_POSE	7U 
#define	CAN_RXF1DL_BYTE0_MSK	BITS(CAN_RXF1DL_BYTE0_POSS,CAN_RXF1DL_BYTE0_POSE)

/****************** Bit definition for CAN_RXF1DH register ************************/

#define	CAN_RXF1DH_BYTE7_POSS	24U 
#define	CAN_RXF1DH_BYTE7_POSE	31U 
#define	CAN_RXF1DH_BYTE7_MSK	BITS(CAN_RXF1DH_BYTE7_POSS,CAN_RXF1DH_BYTE7_POSE)

#define	CAN_RXF1DH_BYTE6_POSS	16U 
#define	CAN_RXF1DH_BYTE6_POSE	23U 
#define	CAN_RXF1DH_BYTE6_MSK	BITS(CAN_RXF1DH_BYTE6_POSS,CAN_RXF1DH_BYTE6_POSE)

#define	CAN_RXF1DH_BYTE5_POSS	8U 
#define	CAN_RXF1DH_BYTE5_POSE	15U 
#define	CAN_RXF1DH_BYTE5_MSK	BITS(CAN_RXF1DH_BYTE5_POSS,CAN_RXF1DH_BYTE5_POSE)

#define	CAN_RXF1DH_BYTE4_POSS	0U 
#define	CAN_RXF1DH_BYTE4_POSE	7U 
#define	CAN_RXF1DH_BYTE4_MSK	BITS(CAN_RXF1DH_BYTE4_POSS,CAN_RXF1DH_BYTE4_POSE)

/****************** Bit definition for CAN_FLTCON register ************************/

#define	CAN_FLTCON_FLTINI_POS	0U 
#define	CAN_FLTCON_FLTINI_MSK	BIT(CAN_FLTCON_FLTINI_POS)

/****************** Bit definition for CAN_FLTM register ************************/

#define	CAN_FLTM_MOD_POSS	0U 
#define	CAN_FLTM_MOD_POSE	13U 
#define	CAN_FLTM_MOD_MSK	BITS(CAN_FLTM_MOD_POSS,CAN_FLTM_MOD_POSE)

/****************** Bit definition for CAN_FLTWS register ************************/

#define	CAN_FLTWS_SEL_POSS	0U 
#define	CAN_FLTWS_SEL_POSE	13U 
#define	CAN_FLTWS_SEL_MSK	BITS(CAN_FLTWS_SEL_POSS,CAN_FLTWS_SEL_POSE)

/****************** Bit definition for CAN_FLTAS register ************************/

#define	CAN_FLTAS_ASSIGN_POSS	0U 
#define	CAN_FLTAS_ASSIGN_POSE	13U 
#define	CAN_FLTAS_ASSIGN_MSK	BITS(CAN_FLTAS_ASSIGN_POSS,CAN_FLTAS_ASSIGN_POSE)

/****************** Bit definition for CAN_FLTGO register ************************/

#define	CAN_FLTGO_GO_POSS	0U 
#define	CAN_FLTGO_GO_POSE	13U 
#define	CAN_FLTGO_GO_MSK	BITS(CAN_FLTGO_GO_POSS,CAN_FLTGO_GO_POSE)

typedef struct {
	__IO uint32_t TXID;
	__IO uint32_t TXFCON;
	__IO uint32_t TXDL;
	__IO uint32_t TXDH;
} CAN_TxMailBox_Typedef;

typedef struct {
	__IO uint32_t RXFID;
	__IO uint32_t RXFINF;
	__IO uint32_t RXFDL;
	__IO uint32_t RXFDH;
} CAN_RxFIFO_Typedef;

typedef struct {
	__IO uint32_t FLT1;
	__IO uint32_t FLT2;
} CAN_Filter_Typedef;

typedef struct
{
	__IO uint32_t CON;
	__I uint32_t STAT;
	__O uint32_t IFC;
	__IO uint32_t TXSTAT;
	__O uint32_t TXSTATC;
	__IO uint32_t RXF0;
	__O uint32_t RXF0C;
	__IO uint32_t RXF1;
	__O uint32_t RXF1C;
	__IO uint32_t IE;
	__IO uint32_t ERRSTAT;
	__IO uint32_t BTIME;
	uint32_t RESERVED0[84] ;
	CAN_TxMailBox_Typedef TxMailBox[3];
	CAN_RxFIFO_Typedef RxFIFO[2];
	uint32_t RESERVED1[12] ;
	__IO uint32_t FLTCON;
	__IO uint32_t FLTM;
	uint32_t RESERVED2 ;
	__IO uint32_t FLTWS;
	uint32_t RESERVED3 ;
	__IO uint32_t FLTAS;
	uint32_t RESERVED4 ;
	__IO uint32_t FLTGO;
	uint32_t RESERVED5[8] ;
	CAN_Filter_Typedef Filter[14];
} CAN_TypeDef;

/****************** Bit definition for CRC_CR register ************************/
#define	CRC_CR_BYTORD_POS	24U 
#define	CRC_CR_BYTORD_MSK	BIT(CRC_CR_BYTORD_POS)

#define	CRC_CR_DATLEN_POSS	22U 
#define	CRC_CR_DATLEN_POSE	23U 
#define	CRC_CR_DATLEN_MSK	BITS(CRC_CR_DATLEN_POSS,CRC_CR_DATLEN_POSE)

#define	CRC_CR_MODE_POSS	20U 
#define	CRC_CR_MODE_POSE	21U 
#define	CRC_CR_MODE_MSK	BITS(CRC_CR_MODE_POSS,CRC_CR_MODE_POSE)

#define	CRC_CR_CHSINV_POS	19U 
#define	CRC_CR_CHSINV_MSK	BIT(CRC_CR_CHSINV_POS)

#define	CRC_CR_DATINV_POS	18U 
#define	CRC_CR_DATINV_MSK	BIT(CRC_CR_DATINV_POS)

#define	CRC_CR_CHSREV_POS	17U 
#define	CRC_CR_CHSREV_MSK	BIT(CRC_CR_CHSREV_POS)

#define	CRC_CR_DATREV_POS	16U 
#define	CRC_CR_DATREV_MSK	BIT(CRC_CR_DATREV_POS)

#define	CRC_CR_DMAEN_POS	4U 
#define	CRC_CR_DMAEN_MSK	BIT(CRC_CR_DMAEN_POS)

#define	CRC_CR_CWERR_POS	3U 
#define	CRC_CR_CWERR_MSK	BIT(CRC_CR_CWERR_POS)

#define	CRC_CR_WERR_POS	2U 
#define	CRC_CR_WERR_MSK	BIT(CRC_CR_WERR_POS)

#define	CRC_CR_RST_POS	1U 
#define	CRC_CR_RST_MSK	BIT(CRC_CR_RST_POS)

#define	CRC_CR_EN_POS	0U 
#define	CRC_CR_EN_MSK	BIT(CRC_CR_EN_POS)

/****************** Bit definition for CRC_DATA register ************************/

#define	CRC_DATA_DATA_POSS	0U 
#define	CRC_DATA_DATA_POSE	31U 
#define	CRC_DATA_DATA_MSK	BITS(CRC_DATA_DATA_POSS,CRC_DATA_DATA_POSE)

/****************** Bit definition for CRC_SEED register ************************/

#define	CRC_SEED_SEED_POSS	0U 
#define	CRC_SEED_SEED_POSE	31U 
#define	CRC_SEED_SEED_MSK	BITS(CRC_SEED_SEED_POSS,CRC_SEED_SEED_POSE)

/****************** Bit definition for CRC_CHECKSUM register ************************/

#define	CRC_CHECKSUM_CHECKSUM_POSS	0U 
#define	CRC_CHECKSUM_CHECKSUM_POSE	31U 
#define	CRC_CHECKSUM_CHECKSUM_MSK	BITS(CRC_CHECKSUM_CHECKSUM_POSS,CRC_CHECKSUM_CHECKSUM_POSE)

typedef struct
{
	__IO uint32_t CR;
	__IO uint32_t DATA;
	__IO uint32_t SEED;
	__I uint32_t CHECKSUM;
} CRC_TypeDef;

/****************** Bit definition for ADC_STAT register ************************/

#define	ADC_STAT_ICHS_POS	9U 
#define	ADC_STAT_ICHS_MSK	BIT(ADC_STAT_ICHS_POS)

#define	ADC_STAT_NCHS_POS	8U 
#define	ADC_STAT_NCHS_MSK	BIT(ADC_STAT_NCHS_POS)

#define	ADC_STAT_OVR_POS	3U 
#define	ADC_STAT_OVR_MSK	BIT(ADC_STAT_OVR_POS)

#define	ADC_STAT_ICHE_POS	2U 
#define	ADC_STAT_ICHE_MSK	BIT(ADC_STAT_ICHE_POS)

#define	ADC_STAT_NCHE_POS	1U 
#define	ADC_STAT_NCHE_MSK	BIT(ADC_STAT_NCHE_POS)

#define	ADC_STAT_AWDF_POS	0U 
#define	ADC_STAT_AWDF_MSK	BIT(ADC_STAT_AWDF_POS)

/****************** Bit definition for ADC_CLR register ************************/

#define	ADC_CLR_ICHS_POS	9U 
#define	ADC_CLR_ICHS_MSK	BIT(ADC_CLR_ICHS_POS)

#define	ADC_CLR_NCHS_POS	8U 
#define	ADC_CLR_NCHS_MSK	BIT(ADC_CLR_NCHS_POS)

#define	ADC_CLR_OVR_POS	3U 
#define	ADC_CLR_OVR_MSK	BIT(ADC_CLR_OVR_POS)

#define	ADC_CLR_ICHE_POS	2U 
#define	ADC_CLR_ICHE_MSK	BIT(ADC_CLR_ICHE_POS)

#define	ADC_CLR_NCHE_POS	1U 
#define	ADC_CLR_NCHE_MSK	BIT(ADC_CLR_NCHE_POS)

#define	ADC_CLR_AWDF_POS	0U 
#define	ADC_CLR_AWDF_MSK	BIT(ADC_CLR_AWDF_POS)

/****************** Bit definition for ADC_CON0 register ************************/

#define	ADC_CON0_OVRIE_POS	26U 
#define	ADC_CON0_OVRIE_MSK	BIT(ADC_CON0_OVRIE_POS)

#define	ADC_CON0_RSEL_POSS	24U 
#define	ADC_CON0_RSEL_POSE	25U 
#define	ADC_CON0_RSEL_MSK	BITS(ADC_CON0_RSEL_POSS,ADC_CON0_RSEL_POSE)

#define	ADC_CON0_NCHWDEN_POS	23U 
#define	ADC_CON0_NCHWDEN_MSK	BIT(ADC_CON0_NCHWDEN_POS)

#define	ADC_CON0_ICHWDTEN_POS	22U 
#define	ADC_CON0_ICHWDTEN_MSK	BIT(ADC_CON0_ICHWDTEN_POS)

#define	ADC_CON0_ETRGN_POSS	13U 
#define	ADC_CON0_ETRGN_POSE	15U 
#define	ADC_CON0_ETRGN_MSK	BITS(ADC_CON0_ETRGN_POSS,ADC_CON0_ETRGN_POSE)

#define	ADC_CON0_ICHDCEN_POS	12U 
#define	ADC_CON0_ICHDCEN_MSK	BIT(ADC_CON0_ICHDCEN_POS)

#define	ADC_CON0_NCHDCEN_POS	11U 
#define	ADC_CON0_NCHDCEN_MSK	BIT(ADC_CON0_NCHDCEN_POS)

#define	ADC_CON0_IAUTO_POS	10U 
#define	ADC_CON0_IAUTO_MSK	BIT(ADC_CON0_IAUTO_POS)

#define	ADC_CON0_AWDSGL_POS	9U 
#define	ADC_CON0_AWDSGL_MSK	BIT(ADC_CON0_AWDSGL_POS)

#define	ADC_CON0_SCANEN_POS	8U 
#define	ADC_CON0_SCANEN_MSK	BIT(ADC_CON0_SCANEN_POS)

#define	ADC_CON0_ICHEIE_POS	7U 
#define	ADC_CON0_ICHEIE_MSK	BIT(ADC_CON0_ICHEIE_POS)

#define	ADC_CON0_AWDIE_POS	6U 
#define	ADC_CON0_AWDIE_MSK	BIT(ADC_CON0_AWDIE_POS)

#define	ADC_CON0_NCHEIE_POS	5U 
#define	ADC_CON0_NCHEIE_MSK	BIT(ADC_CON0_NCHEIE_POS)

#define	ADC_CON0_AWDCH_POSS	0U 
#define	ADC_CON0_AWDCH_POSE	4U 
#define	ADC_CON0_AWDCH_MSK	BITS(ADC_CON0_AWDCH_POSS,ADC_CON0_AWDCH_POSE)

/****************** Bit definition for ADC_CON1 register ************************/

#define	ADC_CON1_NCHTRG_POS	30U 
#define	ADC_CON1_NCHTRG_MSK	BIT(ADC_CON1_NCHTRG_POS)

#define	ADC_CON1_NETS_POSS	28U 
#define	ADC_CON1_NETS_POSE	29U 
#define	ADC_CON1_NETS_MSK	BITS(ADC_CON1_NETS_POSS,ADC_CON1_NETS_POSE)

#define	ADC_CON1_ICHTRG_POS	22U 
#define	ADC_CON1_ICHTRG_MSK	BIT(ADC_CON1_ICHTRG_POS)

#define	ADC_CON1_IETS_POSS	20U 
#define	ADC_CON1_IETS_POSE	21U 
#define	ADC_CON1_IETS_MSK	BITS(ADC_CON1_IETS_POSS,ADC_CON1_IETS_POSE)

#define	ADC_CON1_ALIGN_POS	11U 
#define	ADC_CON1_ALIGN_MSK	BIT(ADC_CON1_ALIGN_POS)

#define	ADC_CON1_NCHESEL_POS	10U 
#define	ADC_CON1_NCHESEL_MSK	BIT(ADC_CON1_NCHESEL_POS)

#define	ADC_CON1_DMA_POS	8U 
#define	ADC_CON1_DMA_MSK	BIT(ADC_CON1_DMA_POS)

#define	ADC_CON1_CM_POS	1U 
#define	ADC_CON1_CM_MSK	BIT(ADC_CON1_CM_POS)

#define	ADC_CON1_ADCEN_POS	0U 
#define	ADC_CON1_ADCEN_MSK	BIT(ADC_CON1_ADCEN_POS)

/****************** Bit definition for ADC_SMPT1 register ************************/

#define	ADC_SMPT1_CHT_POSS	0U 
#define	ADC_SMPT1_CHT_POSE	31U 
#define	ADC_SMPT1_CHT_MSK	BITS(ADC_SMPT1_CHT_POSS,ADC_SMPT1_CHT_POSE)

/****************** Bit definition for ADC_SMPT2 register ************************/

#define	ADC_SMPT2_CHT_POSS	0U 
#define	ADC_SMPT2_CHT_POSE	31U 
#define	ADC_SMPT2_CHT_MSK	BITS(ADC_SMPT2_CHT_POSS,ADC_SMPT2_CHT_POSE)

/****************** Bit definition for ADC_SMPT3 register ************************/

#define	ADC_SMPT3_SMP_POSS	0U 
#define	ADC_SMPT3_SMP_POSE	31U 
#define	ADC_SMPT3_SMP_MSK	BITS(ADC_SMPT3_SMP_POSS,ADC_SMPT3_SMP_POSE)

/****************** Bit definition for ADC_ICHOFF1 register ************************/

#define	ADC_ICHOFF1_IOFF_POSS	0U 
#define	ADC_ICHOFF1_IOFF_POSE	11U 
#define	ADC_ICHOFF1_IOFF_MSK	BITS(ADC_ICHOFF1_IOFF_POSS,ADC_ICHOFF1_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF2 register ************************/

#define	ADC_ICHOFF2_IOFF_POSS	0U 
#define	ADC_ICHOFF2_IOFF_POSE	11U 
#define	ADC_ICHOFF2_IOFF_MSK	BITS(ADC_ICHOFF2_IOFF_POSS,ADC_ICHOFF2_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF3 register ************************/

#define	ADC_ICHOFF3_IOFF_POSS	0U 
#define	ADC_ICHOFF3_IOFF_POSE	11U 
#define	ADC_ICHOFF3_IOFF_MSK	BITS(ADC_ICHOFF3_IOFF_POSS,ADC_ICHOFF3_IOFF_POSE)

/****************** Bit definition for ADC_ICHOFF4 register ************************/

#define	ADC_ICHOFF4_IOFF_POSS	0U 
#define	ADC_ICHOFF4_IOFF_POSE	11U 
#define	ADC_ICHOFF4_IOFF_MSK	BITS(ADC_ICHOFF4_IOFF_POSS,ADC_ICHOFF4_IOFF_POSE)

/****************** Bit definition for ADC_NCHS1 register ************************/

#define	ADC_NCHS1_NS4_POSS	24U 
#define	ADC_NCHS1_NS4_POSE	28U 
#define	ADC_NCHS1_NS4_MSK	BITS(ADC_NCHS1_NS4_POSS,ADC_NCHS1_NS4_POSE)

#define	ADC_NCHS1_NS3_POSS	16U 
#define	ADC_NCHS1_NS3_POSE	20U 
#define	ADC_NCHS1_NS3_MSK	BITS(ADC_NCHS1_NS3_POSS,ADC_NCHS1_NS3_POSE)

#define	ADC_NCHS1_NS2_POSS	8U 
#define	ADC_NCHS1_NS2_POSE	12U 
#define	ADC_NCHS1_NS2_MSK	BITS(ADC_NCHS1_NS2_POSS,ADC_NCHS1_NS2_POSE)

#define	ADC_NCHS1_NS1_POSS	0U 
#define	ADC_NCHS1_NS1_POSE	4U 
#define	ADC_NCHS1_NS1_MSK	BITS(ADC_NCHS1_NS1_POSS,ADC_NCHS1_NS1_POSE)

/****************** Bit definition for ADC_NCHS2 register ************************/

#define	ADC_NCHS2_NS8_POSS	24U 
#define	ADC_NCHS2_NS8_POSE	28U 
#define	ADC_NCHS2_NS8_MSK	BITS(ADC_NCHS2_NS8_POSS,ADC_NCHS2_NS8_POSE)

#define	ADC_NCHS2_NS7_POSS	16U 
#define	ADC_NCHS2_NS7_POSE	20U 
#define	ADC_NCHS2_NS7_MSK	BITS(ADC_NCHS2_NS7_POSS,ADC_NCHS2_NS7_POSE)

#define	ADC_NCHS2_NS6_POSS	8U 
#define	ADC_NCHS2_NS6_POSE	12U 
#define	ADC_NCHS2_NS6_MSK	BITS(ADC_NCHS2_NS6_POSS,ADC_NCHS2_NS6_POSE)

#define	ADC_NCHS2_NS5_POSS	0U 
#define	ADC_NCHS2_NS5_POSE	4U 
#define	ADC_NCHS2_NS5_MSK	BITS(ADC_NCHS2_NS5_POSS,ADC_NCHS2_NS5_POSE)

/****************** Bit definition for ADC_NCHS3 register ************************/

#define	ADC_NCHS3_NS12_POSS	24U 
#define	ADC_NCHS3_NS12_POSE	28U 
#define	ADC_NCHS3_NS12_MSK	BITS(ADC_NCHS3_NS12_POSS,ADC_NCHS3_NS12_POSE)

#define	ADC_NCHS3_NS11_POSS	16U 
#define	ADC_NCHS3_NS11_POSE	20U 
#define	ADC_NCHS3_NS11_MSK	BITS(ADC_NCHS3_NS11_POSS,ADC_NCHS3_NS11_POSE)

#define	ADC_NCHS3_NS10_POSS	8U 
#define	ADC_NCHS3_NS10_POSE	12U 
#define	ADC_NCHS3_NS10_MSK	BITS(ADC_NCHS3_NS10_POSS,ADC_NCHS3_NS10_POSE)

#define	ADC_NCHS3_NS9_POSS	0U 
#define	ADC_NCHS3_NS9_POSE	4U 
#define	ADC_NCHS3_NS9_MSK	BITS(ADC_NCHS3_NS9_POSS,ADC_NCHS3_NS9_POSE)

/****************** Bit definition for ADC_NCHS4 register ************************/

#define	ADC_NCHS4_NS16_POSS	24U 
#define	ADC_NCHS4_NS16_POSE	28U 
#define	ADC_NCHS4_NS16_MSK	BITS(ADC_NCHS4_NS16_POSS,ADC_NCHS4_NS16_POSE)

#define	ADC_NCHS4_NS15_POSS	16U 
#define	ADC_NCHS4_NS15_POSE	20U 
#define	ADC_NCHS4_NS15_MSK	BITS(ADC_NCHS4_NS15_POSS,ADC_NCHS4_NS15_POSE)

#define	ADC_NCHS4_NS14_POSS	8U 
#define	ADC_NCHS4_NS14_POSE	12U 
#define	ADC_NCHS4_NS14_MSK	BITS(ADC_NCHS4_NS14_POSS,ADC_NCHS4_NS14_POSE)

#define	ADC_NCHS4_NS13_POSS	0U 
#define	ADC_NCHS4_NS13_POSE	4U 
#define	ADC_NCHS4_NS13_MSK	BITS(ADC_NCHS4_NS13_POSS,ADC_NCHS4_NS13_POSE)

/****************** Bit definition for ADC_ICHS register ************************/

#define	ADC_ICHS_IS4_POSS	24U 
#define	ADC_ICHS_IS4_POSE	28U 
#define	ADC_ICHS_IS4_MSK	BITS(ADC_ICHS_IS4_POSS,ADC_ICHS_IS4_POSE)

#define	ADC_ICHS_IS3_POSS	16U 
#define	ADC_ICHS_IS3_POSE	20U 
#define	ADC_ICHS_IS3_MSK	BITS(ADC_ICHS_IS3_POSS,ADC_ICHS_IS3_POSE)

#define	ADC_ICHS_IS2_POSS	8U 
#define	ADC_ICHS_IS2_POSE	12U 
#define	ADC_ICHS_IS2_MSK	BITS(ADC_ICHS_IS2_POSS,ADC_ICHS_IS2_POSE)

#define	ADC_ICHS_IS1_POSS	0U 
#define	ADC_ICHS_IS1_POSE	4U 
#define	ADC_ICHS_IS1_MSK	BITS(ADC_ICHS_IS1_POSS,ADC_ICHS_IS1_POSE)

/****************** Bit definition for ADC_CHSL register ************************/

#define	ADC_CHSL_ISL_POSS	8U 
#define	ADC_CHSL_ISL_POSE	9U 
#define	ADC_CHSL_ISL_MSK	BITS(ADC_CHSL_ISL_POSS,ADC_CHSL_ISL_POSE)

#define	ADC_CHSL_NSL_POSS	0U 
#define	ADC_CHSL_NSL_POSE	3U 
#define	ADC_CHSL_NSL_MSK	BITS(ADC_CHSL_NSL_POSS,ADC_CHSL_NSL_POSE)

/****************** Bit definition for ADC_WDTH register ************************/

#define	ADC_WDTH_HT_POSS	0U 
#define	ADC_WDTH_HT_POSE	11U 
#define	ADC_WDTH_HT_MSK	BITS(ADC_WDTH_HT_POSS,ADC_WDTH_HT_POSE)

/****************** Bit definition for ADC_WDTL register ************************/

#define	ADC_WDTL_LT_POSS	0U 
#define	ADC_WDTL_LT_POSE	11U 
#define	ADC_WDTL_LT_MSK	BITS(ADC_WDTL_LT_POSS,ADC_WDTL_LT_POSE)

/****************** Bit definition for ADC_ICHDR1 register ************************/

#define	ADC_ICHDR1_VAL_POSS	0U 
#define	ADC_ICHDR1_VAL_POSE	15U 
#define	ADC_ICHDR1_VAL_MSK	BITS(ADC_ICHDR1_VAL_POSS,ADC_ICHDR1_VAL_POSE)

/****************** Bit definition for ADC_ICHDR2 register ************************/

#define	ADC_ICHDR2_VAL_POSS	0U 
#define	ADC_ICHDR2_VAL_POSE	15U 
#define	ADC_ICHDR2_VAL_MSK	BITS(ADC_ICHDR2_VAL_POSS,ADC_ICHDR2_VAL_POSE)

/****************** Bit definition for ADC_ICHDR3 register ************************/

#define	ADC_ICHDR3_VAL_POSS	0U 
#define	ADC_ICHDR3_VAL_POSE	15U 
#define	ADC_ICHDR3_VAL_MSK	BITS(ADC_ICHDR3_VAL_POSS,ADC_ICHDR3_VAL_POSE)

/****************** Bit definition for ADC_ICHDR4 register ************************/

#define	ADC_ICHDR4_VAL_POSS	0U 
#define	ADC_ICHDR4_VAL_POSE	15U 
#define	ADC_ICHDR4_VAL_MSK	BITS(ADC_ICHDR4_VAL_POSS,ADC_ICHDR4_VAL_POSE)

/****************** Bit definition for ADC_NCHDR register ************************/

#define	ADC_NCHDR_VAL_POSS	0U 
#define	ADC_NCHDR_VAL_POSE	15U 
#define	ADC_NCHDR_VAL_MSK	BITS(ADC_NCHDR_VAL_POSS,ADC_NCHDR_VAL_POSE)

/****************** Bit definition for ADC_CCR register ************************/

#define	ADC_CCR_ADCH_PBUF_EN_POS	31U 
#define	ADC_CCR_ADCH_PBUF_EN_MSK	BIT(ADC_CCR_ADCH_PBUF_EN_POS)

#define	ADC_CCR_ADCH_NBUF_EN_POS	30U 
#define	ADC_CCR_ADCH_NBUF_EN_MSK	BIT(ADC_CCR_ADCH_NBUF_EN_POS)

#define	ADC_CCR_ADCH_INBUF_CALEN_POS	29U 
#define	ADC_CCR_ADCH_INBUF_CALEN_MSK	BIT(ADC_CCR_ADCH_INBUF_CALEN_POS)

#define	ADC_CCR_TRMEN_POS	28U 
#define	ADC_CCR_TRMEN_MSK	BIT(ADC_CCR_TRMEN_POS)

#define	ADC_CCR_GAINCALEN_POS	25U 
#define	ADC_CCR_GAINCALEN_MSK	BIT(ADC_CCR_GAINCALEN_POS)

#define	ADC_CCR_OFFCALEN_POS	24U 
#define	ADC_CCR_OFFCALEN_MSK	BIT(ADC_CCR_OFFCALEN_POS)

#define	ADC_CCR_VREFOEN_POS	19U 
#define	ADC_CCR_VREFOEN_MSK	BIT(ADC_CCR_VREFOEN_POS)

#define	ADC_CCR_VRNSEL_POS	18U 
#define	ADC_CCR_VRNSEL_MSK	BIT(ADC_CCR_VRNSEL_POS)

#define	ADC_CCR_VRPSEL_POSS	16U 
#define	ADC_CCR_VRPSEL_POSE	17U 
#define	ADC_CCR_VRPSEL_MSK	BITS(ADC_CCR_VRPSEL_POSS,ADC_CCR_VRPSEL_POSE)

#define	ADC_CCR_PWRMODSEL_POS	15U 
#define	ADC_CCR_PWRMODSEL_MSK	BIT(ADC_CCR_PWRMODSEL_POS)

#define	ADC_CCR_DIFFEN_POS	12U 
#define	ADC_CCR_DIFFEN_MSK	BIT(ADC_CCR_DIFFEN_POS)

#define	ADC_CCR_IREFEN_POS	11U 
#define	ADC_CCR_IREFEN_MSK	BIT(ADC_CCR_IREFEN_POS)

#define	ADC_CCR_VRBUFEN_POS	10U 
#define	ADC_CCR_VRBUFEN_MSK	BIT(ADC_CCR_VRBUFEN_POS)

#define	ADC_CCR_VCMBUFEN_POS	9U 
#define	ADC_CCR_VCMBUFEN_MSK	BIT(ADC_CCR_VCMBUFEN_POS)

#define	ADC_CCR_VREFEN_POS	8U 
#define	ADC_CCR_VREFEN_MSK	BIT(ADC_CCR_VREFEN_POS)

#define	ADC_CCR_CKDIV_POSS	0U 
#define	ADC_CCR_CKDIV_POSE	2U 
#define	ADC_CCR_CKDIV_MSK	BITS(ADC_CCR_CKDIV_POSS,ADC_CCR_CKDIV_POSE)

typedef struct
{
	__I uint32_t STAT;
	__O uint32_t CLR;
	__IO uint32_t CON0;
	__IO uint32_t CON1;
	__IO uint32_t SMPT1;
	__IO uint32_t SMPT2;
	__IO uint32_t SMPT3;
	__IO uint32_t RESERVED;
	__IO uint32_t ICHOFF1;
	__IO uint32_t ICHOFF2;
	__IO uint32_t ICHOFF3;
	__IO uint32_t ICHOFF4;
	__IO uint32_t NCHS1;
	__IO uint32_t NCHS2;
	__IO uint32_t NCHS3;
	__IO uint32_t NCHS4;
	__IO uint32_t ICHS;
	__IO uint32_t CHSL;
	__IO uint32_t WDTH;
	__IO uint32_t WDTL;
	__I uint32_t ICHDR1;
	__I uint32_t ICHDR2;
	__I uint32_t ICHDR3;
	__I uint32_t ICHDR4;
	__I uint32_t NCHDR;
	__IO uint32_t CCR;
} ADC_TypeDef;

/****************** Bit definition for ACMP_CON register ************************/

#define	ACMP_CON_FALLEN_POS	17U 
#define	ACMP_CON_FALLEN_MSK	BIT(ACMP_CON_FALLEN_POS)

#define	ACMP_CON_RISEEN_POS	16U 
#define	ACMP_CON_RISEEN_MSK	BIT(ACMP_CON_RISEEN_POS)

#define	ACMP_CON_MODSEL_POSS	14U 
#define	ACMP_CON_MODSEL_POSE	15U 
#define	ACMP_CON_MODSEL_MSK	BITS(ACMP_CON_MODSEL_POSS,ACMP_CON_MODSEL_POSE)

#define	ACMP_CON_WARMUPT_POSS	8U 
#define	ACMP_CON_WARMUPT_POSE	10U 
#define	ACMP_CON_WARMUPT_MSK	BITS(ACMP_CON_WARMUPT_POSS,ACMP_CON_WARMUPT_POSE)

#define	ACMP_CON_HYSTSEL_POSS	4U 
#define	ACMP_CON_HYSTSEL_POSE	6U 
#define	ACMP_CON_HYSTSEL_MSK	BITS(ACMP_CON_HYSTSEL_POSS,ACMP_CON_HYSTSEL_POSE)

#define	ACMP_CON_OUTINV_POS	3U 
#define	ACMP_CON_OUTINV_MSK	BIT(ACMP_CON_OUTINV_POS)

#define	ACMP_CON_INACTV_POS	2U 
#define	ACMP_CON_INACTV_MSK	BIT(ACMP_CON_INACTV_POS)

#define	ACMP_CON_EN_POS	0U 
#define	ACMP_CON_EN_MSK	BIT(ACMP_CON_EN_POS)

/****************** Bit definition for ACMP_INPUTSEL register ************************/

#define	ACMP_INPUTSEL_VDDLVL_POSS	8U 
#define	ACMP_INPUTSEL_VDDLVL_POSE	13U 
#define	ACMP_INPUTSEL_VDDLVL_MSK	BITS(ACMP_INPUTSEL_VDDLVL_POSS,ACMP_INPUTSEL_VDDLVL_POSE)

#define	ACMP_INPUTSEL_NSEL_POSS	4U 
#define	ACMP_INPUTSEL_NSEL_POSE	7U 
#define	ACMP_INPUTSEL_NSEL_MSK	BITS(ACMP_INPUTSEL_NSEL_POSS,ACMP_INPUTSEL_NSEL_POSE)

#define	ACMP_INPUTSEL_PSEL_POSS	0U 
#define	ACMP_INPUTSEL_PSEL_POSE	2U 
#define	ACMP_INPUTSEL_PSEL_MSK	BITS(ACMP_INPUTSEL_PSEL_POSS,ACMP_INPUTSEL_PSEL_POSE)

/****************** Bit definition for ACMP_STAT register ************************/

#define	ACMP_STAT_OUT_POS	1U 
#define	ACMP_STAT_OUT_MSK	BIT(ACMP_STAT_OUT_POS)

#define	ACMP_STAT_ACT_POS	0U 
#define	ACMP_STAT_ACT_MSK	BIT(ACMP_STAT_ACT_POS)

/****************** Bit definition for ACMP_IES register ************************/

#define	ACMP_IES_WARMUP_POS	1U 
#define	ACMP_IES_WARMUP_MSK	BIT(ACMP_IES_WARMUP_POS)

#define	ACMP_IES_EDGE_POS	0U 
#define	ACMP_IES_EDGE_MSK	BIT(ACMP_IES_EDGE_POS)

/****************** Bit definition for ACMP_IEV register ************************/

#define	ACMP_IEV_WARMUP_POS	1U 
#define	ACMP_IEV_WARMUP_MSK	BIT(ACMP_IEV_WARMUP_POS)

#define	ACMP_IEV_EDGE_POS	0U 
#define	ACMP_IEV_EDGE_MSK	BIT(ACMP_IEV_EDGE_POS)

/****************** Bit definition for ACMP_IEC register ************************/

#define	ACMP_IEC_WARMUP_POS	1U 
#define	ACMP_IEC_WARMUP_MSK	BIT(ACMP_IEC_WARMUP_POS)

#define	ACMP_IEC_EDGE_POS	0U 
#define	ACMP_IEC_EDGE_MSK	BIT(ACMP_IEC_EDGE_POS)

/****************** Bit definition for ACMP_RIF register ************************/

#define	ACMP_RIF_WARMUP_POS	1U 
#define	ACMP_RIF_WARMUP_MSK	BIT(ACMP_RIF_WARMUP_POS)

#define	ACMP_RIF_EDGE_POS	0U 
#define	ACMP_RIF_EDGE_MSK	BIT(ACMP_RIF_EDGE_POS)

/****************** Bit definition for ACMP_IFM register ************************/

#define	ACMP_IFM_WARMUP_POS	1U 
#define	ACMP_IFM_WARMUP_MSK	BIT(ACMP_IFM_WARMUP_POS)

#define	ACMP_IFM_EDGE_POS	0U 
#define	ACMP_IFM_EDGE_MSK	BIT(ACMP_IFM_EDGE_POS)

/****************** Bit definition for ACMP_IFC register ************************/

#define	ACMP_IFC_WARMUP_POS	1U 
#define	ACMP_IFC_WARMUP_MSK	BIT(ACMP_IFC_WARMUP_POS)

#define	ACMP_IFC_EDGE_POS	0U 
#define	ACMP_IFC_EDGE_MSK	BIT(ACMP_IFC_EDGE_POS)

/****************** Bit definition for ACMP_PORT register ************************/

#define	ACMP_PORT_PEN_POS	0U 
#define	ACMP_PORT_PEN_MSK	BIT(ACMP_PORT_PEN_POS)

typedef struct
{
	__IO uint32_t CON;
	__IO uint32_t INPUTSEL;
	__I uint32_t STAT;
	__O uint32_t IES;
	__O uint32_t IEC;
	__I uint32_t IEV;
	__I uint32_t RIF;
	__O uint32_t IFM;
	__O uint32_t IFC;
	__IO uint32_t PORT;
} ACMP_TypeDef;

/****************** Bit definition for CALC_SQRTSR register ************************/

#define	CALC_SQRTSR_BUSY_POS	0U 
#define	CALC_SQRTSR_BUSY_MSK	BIT(CALC_SQRTSR_BUSY_POS)

/****************** Bit definition for CALC_RDCND register ************************/

#define	CALC_RDCND_RADICAND_POSS	0U 
#define	CALC_RDCND_RADICAND_POSE	31U 
#define	CALC_RDCND_RADICAND_MSK	BITS(CALC_RDCND_RADICAND_POSS,CALC_RDCND_RADICAND_POSE)

/****************** Bit definition for CALC_SQRTRES register ************************/

#define	CALC_SQRTRES_RESULT_POSS	0U 
#define	CALC_SQRTRES_RESULT_POSE	15U 
#define	CALC_SQRTRES_RESULT_MSK	BITS(CALC_SQRTRES_RESULT_POSS,CALC_SQRTRES_RESULT_POSE)

/****************** Bit definition for CALC_DIVDR register ************************/

#define	CALC_DIVDR_DIVD_POSS	0U 
#define	CALC_DIVDR_DIVD_POSE	31U 
#define	CALC_DIVDR_DIVD_MSK	BITS(CALC_DIVDR_DIVD_POSS,CALC_DIVDR_DIVD_POSE)

/****************** Bit definition for CALC_DIVSR register ************************/

#define	CALC_DIVSR_DIVS_POSS	0U 
#define	CALC_DIVSR_DIVS_POSE	31U 
#define	CALC_DIVSR_DIVS_MSK	BITS(CALC_DIVSR_DIVS_POSS,CALC_DIVSR_DIVS_POSE)

/****************** Bit definition for CALC_DIVQR register ************************/

#define	CALC_DIVQR_DIVQ_POSS	0U 
#define	CALC_DIVQR_DIVQ_POSE	31U 
#define	CALC_DIVQR_DIVQ_MSK	BITS(CALC_DIVQR_DIVQ_POSS,CALC_DIVQR_DIVQ_POSE)

/****************** Bit definition for CALC_DIVRR register ************************/

#define	CALC_DIVRR_DIVS_POSS	0U 
#define	CALC_DIVRR_DIVS_POSE	31U 
#define	CALC_DIVRR_DIVS_MSK	BITS(CALC_DIVRR_DIVS_POSS,CALC_DIVRR_DIVS_POSE)

/****************** Bit definition for CALC_DIVCSR register ************************/

#define	CALC_DIVCSR_TRM_POS	9U 
#define	CALC_DIVCSR_TRM_MSK	BIT(CALC_DIVCSR_TRM_POS)

#define	CALC_DIVCSR_SIGN_POS	8U 
#define	CALC_DIVCSR_SIGN_MSK	BIT(CALC_DIVCSR_SIGN_POS)

#define	CALC_DIVCSR_DZ_POS	1U 
#define	CALC_DIVCSR_DZ_MSK	BIT(CALC_DIVCSR_DZ_POS)

#define	CALC_DIVCSR_BUSY_POS	0U 
#define	CALC_DIVCSR_BUSY_MSK	BIT(CALC_DIVCSR_BUSY_POS)

typedef struct
{
	__I uint32_t SQRTSR;
	__IO uint32_t RDCND;
	__I uint32_t SQRTRES;
	uint32_t RESERVED0[5] ;
	__IO uint32_t DIVDR;
	__IO uint32_t DIVSR;
	__I uint32_t DIVQR;
	__I uint32_t DIVRR;
	__IO uint32_t DIVCSR;
} CALC_TypeDef;

/****************** Bit definition for TSENSE_WPR register ************************/

#define	TSENSE_WPR_WP_POS	0U 
#define	TSENSE_WPR_WP_MSK	BIT(TSENSE_WPR_WP_POS)

/****************** Bit definition for TSENSE_CR register ************************/

#define	TSENSE_CR_TSU_POSS	12U 
#define	TSENSE_CR_TSU_POSE	14U 
#define	TSENSE_CR_TSU_MSK	BITS(TSENSE_CR_TSU_POSS,TSENSE_CR_TSU_POSE)

#define	TSENSE_CR_TOM_POSS	8U 
#define	TSENSE_CR_TOM_POSE	10U 
#define	TSENSE_CR_TOM_MSK	BITS(TSENSE_CR_TOM_POSS,TSENSE_CR_TOM_POSE)

#define	TSENSE_CR_CTN_POS	4U 
#define	TSENSE_CR_CTN_MSK	BIT(TSENSE_CR_CTN_POS)

#define	TSENSE_CR_RST_POS	3U 
#define	TSENSE_CR_RST_MSK	BIT(TSENSE_CR_RST_POS)

#define	TSENSE_CR_ENS_POS	2U 
#define	TSENSE_CR_ENS_MSK	BIT(TSENSE_CR_ENS_POS)

#define	TSENSE_CR_REQEN_POS	1U 
#define	TSENSE_CR_REQEN_MSK	BIT(TSENSE_CR_REQEN_POS)

#define	TSENSE_CR_EN_POS	0U 
#define	TSENSE_CR_EN_MSK	BIT(TSENSE_CR_EN_POS)

/****************** Bit definition for TSENSE_DR register ************************/

#define	TSENSE_DR_ERR_POS	31U 
#define	TSENSE_DR_ERR_MSK	BIT(TSENSE_DR_ERR_POS)

#define	TSENSE_DR_DATA_POSS	0U 
#define	TSENSE_DR_DATA_POSE	15U 
#define	TSENSE_DR_DATA_MSK	BITS(TSENSE_DR_DATA_POSS,TSENSE_DR_DATA_POSE)

/****************** Bit definition for TSENSE_PSR register ************************/

#define	TSENSE_PSR_PRS_POSS	0U 
#define	TSENSE_PSR_PRS_POSE	7U 
#define	TSENSE_PSR_PRS_MSK	BITS(TSENSE_PSR_PRS_POSS,TSENSE_PSR_PRS_POSE)

/****************** Bit definition for TSENSE_IE register ************************/

#define	TSENSE_IE_TSENSE_POS	0U 
#define	TSENSE_IE_TSENSE_MSK	BIT(TSENSE_IE_TSENSE_POS)

/****************** Bit definition for TSENSE_IF register ************************/

#define	TSENSE_IF_TSENSE_POS	0U 
#define	TSENSE_IF_TSENSE_MSK	BIT(TSENSE_IF_TSENSE_POS)

/****************** Bit definition for TSENSE_IFCR register ************************/

#define	TSENSE_IFCR_TSENSE_POS	0U 
#define	TSENSE_IFCR_TSENSE_MSK	BIT(TSENSE_IFCR_TSENSE_POS)

/****************** Bit definition for TSENSE_LTGR register ************************/

#define	TSENSE_LTGR_LTG_POSS	0U 
#define	TSENSE_LTGR_LTG_POSE	20U 
#define	TSENSE_LTGR_LTG_MSK	BITS(TSENSE_LTGR_LTG_POSS,TSENSE_LTGR_LTG_POSE)

/****************** Bit definition for TSENSE_HTGR register ************************/

#define	TSENSE_HTGR_HTG_POSS	0U 
#define	TSENSE_HTGR_HTG_POSE	20U 
#define	TSENSE_HTGR_HTG_MSK	BITS(TSENSE_HTGR_HTG_POSS,TSENSE_HTGR_HTG_POSE)

/****************** Bit definition for TSENSE_TBDR register ************************/

#define	TSENSE_TBDR_TBD_POSS	0U 
#define	TSENSE_TBDR_TBD_POSE	15U 
#define	TSENSE_TBDR_TBD_MSK	BITS(TSENSE_TBDR_TBD_POSS,TSENSE_TBDR_TBD_POSE)

/****************** Bit definition for TSENSE_TCALBDR register ************************/

#define	TSENSE_TCALBDR_TCAL_POSS	0U 
#define	TSENSE_TCALBDR_TCAL_POSE	16U 
#define	TSENSE_TCALBDR_TCAL_MSK	BITS(TSENSE_TCALBDR_TCAL_POSS,TSENSE_TCALBDR_TCAL_POSE)

/****************** Bit definition for TSENSE_SR register ************************/

#define	TSENSE_SR_TSOUT_POS	31U 
#define	TSENSE_SR_TSOUT_MSK	BIT(TSENSE_SR_TSOUT_POS)

#define	TSENSE_SR_NVLD_POS	25U 
#define	TSENSE_SR_NVLD_MSK	BIT(TSENSE_SR_NVLD_POS)

#define	TSENSE_SR_TCAL_POSS	0U 
#define	TSENSE_SR_TCAL_POSE	24U 
#define	TSENSE_SR_TCAL_MSK	BITS(TSENSE_SR_TCAL_POSS,TSENSE_SR_TCAL_POSE)

typedef struct
{
	__IO uint32_t WPR;
	__IO uint32_t CR;
	__I uint32_t DR;
	__IO uint32_t PSR;
	__IO uint32_t IE;
	__I uint32_t IF;
	__IO uint32_t IFCR;
	__IO uint32_t LTGR;
	__IO uint32_t HTGR;
	__IO uint32_t TBDR;
	__IO uint32_t TCALBDR;
	__I uint32_t SR;
} TSENSE_TypeDef;

/****************** Bit definition for IWDT_LOAD register ************************/

#define	IWDT_LOAD_LOAD_POSS	0U 
#define	IWDT_LOAD_LOAD_POSE	31U 
#define	IWDT_LOAD_LOAD_MSK	BITS(IWDT_LOAD_LOAD_POSS,IWDT_LOAD_LOAD_POSE)

/****************** Bit definition for IWDT_VALUE register ************************/

#define	IWDT_VALUE_VALUE_POSS	0U 
#define	IWDT_VALUE_VALUE_POSE	31U 
#define	IWDT_VALUE_VALUE_MSK	BITS(IWDT_VALUE_VALUE_POSS,IWDT_VALUE_VALUE_POSE)

/****************** Bit definition for IWDT_CON register ************************/

#define	IWDT_CON_CLKS_POS	3U 
#define	IWDT_CON_CLKS_MSK	BIT(IWDT_CON_CLKS_POS)

#define	IWDT_CON_RSTEN_POS	2U 
#define	IWDT_CON_RSTEN_MSK	BIT(IWDT_CON_RSTEN_POS)

#define	IWDT_CON_IE_POS	1U 
#define	IWDT_CON_IE_MSK	BIT(IWDT_CON_IE_POS)

#define	IWDT_CON_EN_POS	0U 
#define	IWDT_CON_EN_MSK	BIT(IWDT_CON_EN_POS)

/****************** Bit definition for IWDT_INTCLR register ************************/

#define	IWDT_INTCLR_INTCLR_POSS	0U 
#define	IWDT_INTCLR_INTCLR_POSE	31U 
#define	IWDT_INTCLR_INTCLR_MSK	BITS(IWDT_INTCLR_INTCLR_POSS,IWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for IWDT_RIS register ************************/

#define	IWDT_RIS_WDTIF_POS	0U 
#define	IWDT_RIS_WDTIF_MSK	BIT(IWDT_RIS_WDTIF_POS)

/****************** Bit definition for IWDT_LOCK register ************************/

#define	IWDT_LOCK_LOCK_POS	0U 
#define	IWDT_LOCK_LOCK_MSK	BIT(IWDT_LOCK_LOCK_POS)

typedef struct
{
	__O uint32_t LOAD;
	__I uint32_t VALUE;
	__IO uint32_t CON;
	__O uint32_t INTCLR;
	__I uint32_t RIS;
	uint32_t RESERVED0[59] ;
	__IO uint32_t LOCK;
} IWDT_TypeDef;

/****************** Bit definition for WWDT_LOAD register ************************/

#define	WWDT_LOAD_LOAD_POSS	0U 
#define	WWDT_LOAD_LOAD_POSE	31U 
#define	WWDT_LOAD_LOAD_MSK	BITS(WWDT_LOAD_LOAD_POSS,WWDT_LOAD_LOAD_POSE)

/****************** Bit definition for WWDT_VALUE register ************************/

#define	WWDT_VALUE_VALUE_POSS	0U 
#define	WWDT_VALUE_VALUE_POSE	31U 
#define	WWDT_VALUE_VALUE_MSK	BITS(WWDT_VALUE_VALUE_POSS,WWDT_VALUE_VALUE_POSE)

/****************** Bit definition for WWDT_CON register ************************/

#define	WWDT_CON_WWDTWIN_POSS	4U 
#define	WWDT_CON_WWDTWIN_POSE	5U 
#define	WWDT_CON_WWDTWIN_MSK	BITS(WWDT_CON_WWDTWIN_POSS,WWDT_CON_WWDTWIN_POSE)

#define	WWDT_CON_CLKS_POS	3U 
#define	WWDT_CON_CLKS_MSK	BIT(WWDT_CON_CLKS_POS)

#define	WWDT_CON_RSTEN_POS	2U 
#define	WWDT_CON_RSTEN_MSK	BIT(WWDT_CON_RSTEN_POS)

#define	WWDT_CON_IE_POS	1U 
#define	WWDT_CON_IE_MSK	BIT(WWDT_CON_IE_POS)

#define	WWDT_CON_EN_POS	0U 
#define	WWDT_CON_EN_MSK	BIT(WWDT_CON_EN_POS)

/****************** Bit definition for WWDT_INTCLR register ************************/

#define	WWDT_INTCLR_INTCLR_POSS	0U 
#define	WWDT_INTCLR_INTCLR_POSE	31U 
#define	WWDT_INTCLR_INTCLR_MSK	BITS(WWDT_INTCLR_INTCLR_POSS,WWDT_INTCLR_INTCLR_POSE)

/****************** Bit definition for WWDT_RIS register ************************/

#define	WWDT_RIS_WWDTIF_POS	0U 
#define	WWDT_RIS_WWDTIF_MSK	BIT(WWDT_RIS_WWDTIF_POS)

/****************** Bit definition for WWDT_LOCK register ************************/

#define	WWDT_LOCK_LOCK_POS	0U 
#define	WWDT_LOCK_LOCK_MSK	BIT(WWDT_LOCK_LOCK_POS)

typedef struct
{
	__O uint32_t LOAD;
	__I uint32_t VALUE;
	__IO uint32_t CON;
	__O uint32_t INTCLR;
	__I uint32_t RIS;
	uint32_t RESERVED0[59];
	__IO uint32_t LOCK;
} WWDT_TypeDef;

/****************** Bit definition for DBGC_IDCODE register ************************/

#define	DBGC_IDCODE_REV_ID_POSS	16U 
#define	DBGC_IDCODE_REV_ID_POSE	31U 
#define	DBGC_IDCODE_REV_ID_MSK	BITS(DBGC_IDCODE_REV_ID_POSS,DBGC_IDCODE_REV_ID_POSE)

#define	DBGC_IDCODE_CORE_ID_POSS	12U 
#define	DBGC_IDCODE_CORE_ID_POSE	15U 
#define	DBGC_IDCODE_CORE_ID_MSK	BITS(DBGC_IDCODE_CORE_ID_POSS,DBGC_IDCODE_CORE_ID_POSE)

#define	DBGC_IDCODE_DEV_ID_POSS	0U 
#define	DBGC_IDCODE_DEV_ID_POSE	11U 
#define	DBGC_IDCODE_DEV_ID_MSK	BITS(DBGC_IDCODE_DEV_ID_POSS,DBGC_IDCODE_DEV_ID_POSE)

/****************** Bit definition for DBGC_CR register ************************/

#define	DBGC_CR_DBG_STANDBY_POS	3U 
#define	DBGC_CR_DBG_STANDBY_MSK	BIT(DBGC_CR_DBG_STANDBY_POS)

#define	DBGC_CR_DBG_STOP2_POS	2U 
#define	DBGC_CR_DBG_STOP2_MSK	BIT(DBGC_CR_DBG_STOP2_POS)

#define	DBGC_CR_DBG_STOP1_POS	1U 
#define	DBGC_CR_DBG_STOP1_MSK	BIT(DBGC_CR_DBG_STOP1_POS)

#define	DBGC_CR_DBG_SLEEP_POS	0U 
#define	DBGC_CR_DBG_SLEEP_MSK	BIT(DBGC_CR_DBG_SLEEP_POS)

/****************** Bit definition for DBGC_APB1FZ register ************************/

#define	DBGC_APB1FZ_CAN_STOP_POS	12U 
#define	DBGC_APB1FZ_CAN_STOP_MSK	BIT(DBGC_APB1FZ_CAN_STOP_POS)

#define	DBGC_APB1FZ_I2C1_SMBUS_TO_POS	9U 
#define	DBGC_APB1FZ_I2C1_SMBUS_TO_MSK	BIT(DBGC_APB1FZ_I2C1_SMBUS_TO_POS)

#define	DBGC_APB1FZ_I2C0_SMBUS_TO_POS	8U 
#define	DBGC_APB1FZ_I2C0_SMBUS_TO_MSK	BIT(DBGC_APB1FZ_I2C0_SMBUS_TO_POS)

#define	DBGC_APB1FZ_TIM7_STOP_POS	7U 
#define	DBGC_APB1FZ_TIM7_STOP_MSK	BIT(DBGC_APB1FZ_TIM7_STOP_POS)

#define	DBGC_APB1FZ_TIM6_STOP_POS	6U 
#define	DBGC_APB1FZ_TIM6_STOP_MSK	BIT(DBGC_APB1FZ_TIM6_STOP_POS)

#define	DBGC_APB1FZ_TIM5_STOP_POS	5U 
#define	DBGC_APB1FZ_TIM5_STOP_MSK	BIT(DBGC_APB1FZ_TIM5_STOP_POS)

#define	DBGC_APB1FZ_TIM4_STOP_POS	4U 
#define	DBGC_APB1FZ_TIM4_STOP_MSK	BIT(DBGC_APB1FZ_TIM4_STOP_POS)

#define	DBGC_APB1FZ_TIM3_STOP_POS	3U 
#define	DBGC_APB1FZ_TIM3_STOP_MSK	BIT(DBGC_APB1FZ_TIM3_STOP_POS)

#define	DBGC_APB1FZ_TIM2_STOP_POS	2U 
#define	DBGC_APB1FZ_TIM2_STOP_MSK	BIT(DBGC_APB1FZ_TIM2_STOP_POS)

#define	DBGC_APB1FZ_TIM1_STOP_POS	1U 
#define	DBGC_APB1FZ_TIM1_STOP_MSK	BIT(DBGC_APB1FZ_TIM1_STOP_POS)

#define	DBGC_APB1FZ_TIM0_STOP_POS	0U 
#define	DBGC_APB1FZ_TIM0_STOP_MSK	BIT(DBGC_APB1FZ_TIM0_STOP_POS)

/****************** Bit definition for DBGC_APB2FZ register ************************/

#define	DBGC_APB2FZ_RTC_STOP_POS	10U 
#define	DBGC_APB2FZ_RTC_STOP_MSK	BIT(DBGC_APB2FZ_RTC_STOP_POS)

#define	DBGC_APB2FZ_WWDT_STOP_POS	9U 
#define	DBGC_APB2FZ_WWDT_STOP_MSK	BIT(DBGC_APB2FZ_WWDT_STOP_POS)

#define	DBGC_APB2FZ_IWDT_STOP_POS	8U 
#define	DBGC_APB2FZ_IWDT_STOP_MSK	BIT(DBGC_APB2FZ_IWDT_STOP_POS)

#define	DBGC_APB2FZ_LPTIM0_STOP_POS	0U 
#define	DBGC_APB2FZ_LPTIM0_STOP_MSK	BIT(DBGC_APB2FZ_LPTIM0_STOP_POS)

typedef struct
{
	__I uint32_t IDCODE;
	__IO uint32_t CR;
	__IO uint32_t APB1FZ;
	__IO uint32_t APB2FZ;
} DBGC_TypeDef;

/****************** Bit definition for DAC_CON register ************************/

#define	DAC_CON_RCYCLSEL_POSS	20U 
#define	DAC_CON_RCYCLSEL_POSE	21U 
#define	DAC_CON_RCYCLSEL_MSK	BITS(DAC_CON_RCYCLSEL_POSS,DAC_CON_RCYCLSEL_POSE)

#define	DAC_CON_PRES_POSS	16U 
#define	DAC_CON_PRES_POSE	18U 
#define	DAC_CON_PRES_MSK	BITS(DAC_CON_PRES_POSS,DAC_CON_PRES_POSE)

#define	DAC_CON_CH0PRESRST_POS	7U 
#define	DAC_CON_CH0PRESRST_MSK	BIT(DAC_CON_CH0PRESRST_POS)

#define	DAC_CON_OUTENPIS_POS	6U 
#define	DAC_CON_OUTENPIS_MSK	BIT(DAC_CON_OUTENPIS_POS)

#define	DAC_CON_OUTMD_POSS	4U 
#define	DAC_CON_OUTMD_POSE	5U 
#define	DAC_CON_OUTMD_MSK	BITS(DAC_CON_OUTMD_POSS,DAC_CON_OUTMD_POSE)

#define	DAC_CON_CONVMD_POSS	2U 
#define	DAC_CON_CONVMD_POSE	3U 
#define	DAC_CON_CONVMD_MSK	BITS(DAC_CON_CONVMD_POSS,DAC_CON_CONVMD_POSE)

#define	DAC_CON_SINEMD_POS	1U 
#define	DAC_CON_SINEMD_MSK	BIT(DAC_CON_SINEMD_POS)

#define	DAC_CON_DIFEN_POS	0U 
#define	DAC_CON_DIFEN_MSK	BIT(DAC_CON_DIFEN_POS)

/****************** Bit definition for DAC_STAT register ************************/

#define	DAC_STAT_CH1BSY_POS	1U 
#define	DAC_STAT_CH1BSY_MSK	BIT(DAC_STAT_CH1BSY_POS)

#define	DAC_STAT_CH0BSY_POS	0U 
#define	DAC_STAT_CH0BSY_MSK	BIT(DAC_STAT_CH0BSY_POS)

/****************** Bit definition for DAC_CH0CTRL register ************************/

#define	DAC_CH0CTRL_PISSEL_POSS	4U 
#define	DAC_CH0CTRL_PISSEL_POSE	7U 
#define	DAC_CH0CTRL_PISSEL_MSK	BITS(DAC_CH0CTRL_PISSEL_POSS,DAC_CH0CTRL_PISSEL_POSE)

#define	DAC_CH0CTRL_PISEN_POS	2U 
#define	DAC_CH0CTRL_PISEN_MSK	BIT(DAC_CH0CTRL_PISEN_POS)

#define	DAC_CH0CTRL_RCYCLEN_POS	1U 
#define	DAC_CH0CTRL_RCYCLEN_MSK	BIT(DAC_CH0CTRL_RCYCLEN_POS)

#define	DAC_CH0CTRL_EN_POS	0U 
#define	DAC_CH0CTRL_EN_MSK	BIT(DAC_CH0CTRL_EN_POS)

/****************** Bit definition for DAC_CH1CTRL register ************************/

#define	DAC_CH1CTRL_PISSEL_POSS	4U 
#define	DAC_CH1CTRL_PISSEL_POSE	7U 
#define	DAC_CH1CTRL_PISSEL_MSK	BITS(DAC_CH1CTRL_PISSEL_POSS,DAC_CH1CTRL_PISSEL_POSE)

#define	DAC_CH1CTRL_PISEN_POS	2U 
#define	DAC_CH1CTRL_PISEN_MSK	BIT(DAC_CH1CTRL_PISEN_POS)

#define	DAC_CH1CTRL_RCYCLEN_POS	1U 
#define	DAC_CH1CTRL_RCYCLEN_MSK	BIT(DAC_CH1CTRL_RCYCLEN_POS)

#define	DAC_CH1CTRL_EN_POS	0U 
#define	DAC_CH1CTRL_EN_MSK	BIT(DAC_CH1CTRL_EN_POS)

/****************** Bit definition for DAC_IES register ************************/

#define	DAC_IES_CH1UDF_POS	5U 
#define	DAC_IES_CH1UDF_MSK	BIT(DAC_IES_CH1UDF_POS)

#define	DAC_IES_CH0UDF_POS	4U 
#define	DAC_IES_CH0UDF_MSK	BIT(DAC_IES_CH0UDF_POS)

#define	DAC_IES_CH1_POS	1U 
#define	DAC_IES_CH1_MSK	BIT(DAC_IES_CH1_POS)

#define	DAC_IES_CH0_POS	0U 
#define	DAC_IES_CH0_MSK	BIT(DAC_IES_CH0_POS)

/****************** Bit definition for DAC_IEC register ************************/

#define	DAC_IEC_CH1UDF_POS	5U 
#define	DAC_IEC_CH1UDF_MSK	BIT(DAC_IEC_CH1UDF_POS)

#define	DAC_IEC_CH0UDF_POS	4U 
#define	DAC_IEC_CH0UDF_MSK	BIT(DAC_IEC_CH0UDF_POS)

#define	DAC_IEC_CH1_POS	1U 
#define	DAC_IEC_CH1_MSK	BIT(DAC_IEC_CH1_POS)

#define	DAC_IEC_CH0_POS	0U 
#define	DAC_IEC_CH0_MSK	BIT(DAC_IEC_CH0_POS)

/****************** Bit definition for DAC_IEV register ************************/

#define	DAC_IEV_CH1UDF_POS	5U 
#define	DAC_IEV_CH1UDF_MSK	BIT(DAC_IEV_CH1UDF_POS)

#define	DAC_IEV_CH0UDF_POS	4U 
#define	DAC_IEV_CH0UDF_MSK	BIT(DAC_IEV_CH0UDF_POS)

#define	DAC_IEV_CH1_POS	1U 
#define	DAC_IEV_CH1_MSK	BIT(DAC_IEV_CH1_POS)

#define	DAC_IEV_CH0_POS	0U 
#define	DAC_IEV_CH0_MSK	BIT(DAC_IEV_CH0_POS)

/****************** Bit definition for DAC_RIF register ************************/

#define	DAC_RIF_CH1UDF_POS	5U 
#define	DAC_RIF_CH1UDF_MSK	BIT(DAC_RIF_CH1UDF_POS)

#define	DAC_RIF_CH0UDF_POS	4U 
#define	DAC_RIF_CH0UDF_MSK	BIT(DAC_RIF_CH0UDF_POS)

#define	DAC_RIF_CH1_POS	1U 
#define	DAC_RIF_CH1_MSK	BIT(DAC_RIF_CH1_POS)

#define	DAC_RIF_CH0_POS	0U 
#define	DAC_RIF_CH0_MSK	BIT(DAC_RIF_CH0_POS)

/****************** Bit definition for DAC_IFM register ************************/

#define	DAC_IFM_CH1UDF_POS	5U 
#define	DAC_IFM_CH1UDF_MSK	BIT(DAC_IFM_CH1UDF_POS)

#define	DAC_IFM_CH0UDF_POS	4U 
#define	DAC_IFM_CH0UDF_MSK	BIT(DAC_IFM_CH0UDF_POS)

#define	DAC_IFM_CH1_POS	1U 
#define	DAC_IFM_CH1_MSK	BIT(DAC_IFM_CH1_POS)

#define	DAC_IFM_CH0_POS	0U 
#define	DAC_IFM_CH0_MSK	BIT(DAC_IFM_CH0_POS)

/****************** Bit definition for DAC_IFC register ************************/

#define	DAC_IFC_CH1UDF_POS	5U 
#define	DAC_IFC_CH1UDF_MSK	BIT(DAC_IFC_CH1UDF_POS)

#define	DAC_IFC_CH0UDF_POS	4U 
#define	DAC_IFC_CH0UDF_MSK	BIT(DAC_IFC_CH0UDF_POS)

#define	DAC_IFC_CH1_POS	1U 
#define	DAC_IFC_CH1_MSK	BIT(DAC_IFC_CH1_POS)

#define	DAC_IFC_CH0_POS	0U 
#define	DAC_IFC_CH0_MSK	BIT(DAC_IFC_CH0_POS)

/****************** Bit definition for DAC_CH0DATA register ************************/

#define	DAC_CH0DATA_VAL_POSS	0U 
#define	DAC_CH0DATA_VAL_POSE	11U 
#define	DAC_CH0DATA_VAL_MSK	BITS(DAC_CH0DATA_VAL_POSS,DAC_CH0DATA_VAL_POSE)

/****************** Bit definition for DAC_CH1DATA register ************************/

#define	DAC_CH1DATA_VAL_POSS	0U 
#define	DAC_CH1DATA_VAL_POSE	11U 
#define	DAC_CH1DATA_VAL_MSK	BITS(DAC_CH1DATA_VAL_POSS,DAC_CH1DATA_VAL_POSE)

/****************** Bit definition for DAC_COMBDATA register ************************/

#define	DAC_COMBDATA_CH1VAL_POSS	16U 
#define	DAC_COMBDATA_CH1VAL_POSE	27U 
#define	DAC_COMBDATA_CH1VAL_MSK	BITS(DAC_COMBDATA_CH1VAL_POSS,DAC_COMBDATA_CH1VAL_POSE)

#define	DAC_COMBDATA_CH0VAL_POSS	0U 
#define	DAC_COMBDATA_CH0VAL_POSE	11U 
#define	DAC_COMBDATA_CH0VAL_MSK	BITS(DAC_COMBDATA_CH0VAL_POSS,DAC_COMBDATA_CH0VAL_POSE)

/****************** Bit definition for DAC_CAL register ************************/

#define	DAC_CAL_SELF_CALEN_POS	31U 
#define	DAC_CAL_SELF_CALEN_MSK	BIT(DAC_CAL_SELF_CALEN_POS)

typedef struct
{
	__IO uint32_t CON;
	__I uint32_t STAT;
	__IO uint32_t CH0CTRL;
	__IO uint32_t CH1CTRL;
	__O uint32_t IES;
	__O uint32_t IEC;
	__I uint32_t IEV;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t IFC;
	__IO uint32_t CH0DATA;
	__IO uint32_t CH1DATA;
	__O uint32_t COMBDATA;
	__IO uint32_t CAL;
} DAC_TypeDef;


/* Base addresses */
#define SRAM_BASE	(0x20000000UL)
#define APB1_BASE	(0x40000000UL)
#define APB2_BASE	(0x40040000UL)
#define AHB_BASE	(0x40080000UL)

/* APB1 peripherals Base Address */
#define AD16C4T0_BASE	(APB1_BASE + 0x0000)
#define AD16C4T1_BASE	(APB1_BASE + 0x0400)
#define GP32C4T0_BASE	(APB1_BASE + 0x0800)
#define GP32C4T1_BASE	(APB1_BASE + 0x0C00)
#define BS16T0_BASE	(APB1_BASE + 0x1000)
#define BS16T1_BASE	(APB1_BASE + 0x1400)
#define GP16C4T0_BASE	(APB1_BASE + 0x1800)
#define GP16C4T1_BASE	(APB1_BASE + 0x1C00)
#define UART0_BASE	(APB1_BASE + 0x4000)
#define UART1_BASE	(APB1_BASE + 0x4400)
#define UART2_BASE	(APB1_BASE + 0x4800)
#define UART3_BASE	(APB1_BASE + 0x4C00)
#define UART4_BASE	(APB1_BASE + 0x5000)
#define SPI0_I2S0_BASE	(APB1_BASE + 0x6000)
#define SPI1_I2S1_BASE	(APB1_BASE + 0x6400)
#define SPI2_I2S2_BASE	(APB1_BASE + 0x6800)
#define I2C0_BASE	(APB1_BASE + 0x8000)
#define I2C1_BASE	(APB1_BASE + 0x8400)
#define CAN0_BASE	(APB1_BASE + 0xB000)
#define DMA0_BASE    	(APB1_BASE + 0xC000)

/* APB2 peripherals Base Address */
#define ADC0_BASE	(APB2_BASE + 0x2000)
#define ADC1_BASE	(APB2_BASE + 0x2400)
#define ACMP0_BASE	(APB2_BASE + 0x3000)
#define ACMP1_BASE	(APB2_BASE + 0x3400)
#define ACMP2_BASE	(APB2_BASE + 0x3800)
#define DAC0_BASE	(APB2_BASE + 0x5000)
#define WWDT_BASE	(APB2_BASE + 0x6000)
#define IWDT_BASE	(APB2_BASE + 0x6400)
#define LCD_BASE        (APB2_BASE + 0x7000)
#define BKPC_BASE	(APB2_BASE + 0x8000)
#define TSENSE_BASE	(APB2_BASE + 0x8800)
#define DBGC_BASE	(APB2_BASE + 0xA000)

/* AHB peripherals Base Address */
#define SYSTEM_BASE	(AHB_BASE + 0x0000)
#define CMU_BASE	(AHB_BASE + 0x0400)
#define RMU_BASE	(AHB_BASE + 0x0800)
#define PMU_BASE	(AHB_BASE + 0x0C00)
#define MSC_BASE	(AHB_BASE + 0x1000)
#define GPIOA_BASE	(AHB_BASE + 0x4000)
#define GPIOB_BASE	(AHB_BASE + 0x4040)
#define GPIOC_BASE	(AHB_BASE + 0x4080)
#define GPIOD_BASE	(AHB_BASE + 0x40C0)
#define EXTI_BASE	(AHB_BASE + 0x4300)
#define CRC_BASE	(AHB_BASE + 0x5000)
#define CALC_BASE	(AHB_BASE + 0x5400)
#define PIS_BASE	(AHB_BASE + 0x6000)

/* APB1 peripherals */
#define AD16C4T0	((TIMER_TypeDef *)AD16C4T0_BASE)
#define AD16C4T1	((TIMER_TypeDef *)AD16C4T1_BASE)
#define GP32C4T0	((TIMER_TypeDef *)GP32C4T0_BASE)
#define GP32C4T1	((TIMER_TypeDef *)GP32C4T1_BASE)
#define BS16T0		((TIMER_TypeDef *)BS16T0_BASE)
#define BS16T1		((TIMER_TypeDef *)BS16T1_BASE)
#define GP16C4T0	((TIMER_TypeDef *)GP16C4T0_BASE)
#define GP16C4T1	((TIMER_TypeDef *)GP16C4T1_BASE)
#define UART0		((UART_TypeDef *)UART0_BASE)
#define UART1		((UART_TypeDef *)UART1_BASE)
#define UART2		((UART_TypeDef *)UART2_BASE)
#define UART3		((UART_TypeDef *)UART3_BASE)
#define UART4		((UART_TypeDef *)UART4_BASE)
#define SPI0		((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define SPI1		((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)
#define SPI2		((SPI_I2S_TypeDef *)SPI2_I2S2_BASE)
#define I2S0		((SPI_I2S_TypeDef *)SPI0_I2S0_BASE)
#define I2S1		((SPI_I2S_TypeDef *)SPI1_I2S1_BASE)
#define I2S2		((SPI_I2S_TypeDef *)SPI2_I2S2_BASE)
#define I2C0		((I2C_TypeDef *)I2C0_BASE)
#define I2C1		((I2C_TypeDef *)I2C1_BASE)
#define CAN0		((CAN_TypeDef *)CAN0_BASE)
#define DMA0		((DMA_TypeDef *)DMA0_BASE)

/* APB2 peripherals */
#define ADC0		((ADC_TypeDef *)ADC0_BASE)
#define ADC1		((ADC_TypeDef *)ADC1_BASE)
#define ACMP0		((ACMP_TypeDef *)ACMP0_BASE)
#define ACMP1		((ACMP_TypeDef *)ACMP1_BASE)
#define ACMP2		((ACMP_TypeDef *)ACMP2_BASE)
#define DAC0		((DAC_TypeDef *)DAC0_BASE)
#define WWDT		((WWDT_TypeDef *)WWDT_BASE)
#define IWDT		((IWDT_TypeDef *)IWDT_BASE)
#define BKPC		((BKPC_TypeDef *)BKPC_BASE)
#define TSENSE		((TSENSE_TypeDef *)TSENSE_BASE)
#define DBGC		((DBGC_TypeDef *)DBGC_BASE)

/* AHB peripherals */
#define SYSCFG		((SYSCFG_TypeDef *)SYSTEM_BASE)
#define CMU		((CMU_TypeDef *)CMU_BASE)
#define RMU		((RMU_TypeDef *)RMU_BASE)
#define PMU		((PMU_TypeDef *)PMU_BASE)
#define MSC		((MSC_TypeDef *)MSC_BASE)
#define GPIOA		((GPIO_TypeDef *)GPIOA_BASE)
#define GPIOB		((GPIO_TypeDef *)GPIOB_BASE)
#define GPIOC		((GPIO_TypeDef *)GPIOC_BASE)
#define GPIOD		((GPIO_TypeDef *)GPIOD_BASE)
#define EXTI		((EXTI_TypeDef *)EXTI_BASE)
#define CRC		((CRC_TypeDef  *)CRC_BASE)
#define CALC		((CALC_TypeDef *)CALC_BASE)
#define PIS		((PIS_TypeDef *)PIS_BASE)

#endif
