;*********************************************************************************
;
; @file    startup_es32f0943.s
; @brief   ES32F0943 Device Startup File
;
; @date    20 Jul 2022
; @author  AE Team
; @note
;          Change Logs:
;          Date            Author          Notes
;          28 Mar 2023     AE Team         the first version
;
; Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
;
; SPDX-License-Identifier: Apache-2.0
;
; Licensed under the Apache License, Version 2.0 (the License); you may
; not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an AS IS BASIS, WITHOUT
; WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
;
;*********************************************************************************

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)
        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table

        DATA
__vector_table
        DCD     sfe(CSTACK)				    ;0,  load top of stack
                DCD     Reset_Handler              ;1, Reset Handler
                DCD     NMI_Handler                ;2, NMI Handler
                DCD     HardFault_Handler          ;3, HardFault Handler
                DCD     0                          ;4, Reserved
                DCD     0                          ;5, Reserved
                DCD     0                          ;6, Reserved
                DCD     0                          ;7, Reserved
                DCD     0                          ;8, Reserved
                DCD     0                          ;9, Reserved
                DCD     0                          ;10, Reserved
                DCD     SVCall_Handler             ;11, SVCall_IRQn Handler
                DCD     0                          ;12, Reserved
                DCD     0                          ;13, Reserved
                DCD     PendSV_Handler             ;14, PendSV Handler
                DCD     SysTick_Handler            ;15, SysTick Handler
                DCD     WWDT_IRQHandler            ;16, WWDT IRQHandler
                DCD     LVD_IRQHandler             ;17, LVD IRQHandler
                DCD     RTC_IRQHandler             ;18, RTC IRQHandler
                DCD     WAKEUP_IRQHandler          ;19, WAKEUP IRQHandler
                DCD     RCU_IRQHandler             ;20, RCU IRQHandler
                DCD     EXTI_0to1_IRQHandler       ;21, EXTI_0to1 IRQHandler
                DCD     EXTI_2to3_IRQHandler       ;22, EXTI_2to3 IRQHandler
                DCD     EXTI_4to15_IRQHandler      ;23, EXTI_4to15 IRQHandler
                DCD     CM0IKMCU_IRQ8_IRQHandler   ;24, Reserved
                DCD     CM0IKMCU_IRQ9_IRQHandler   ;25, Reserved
                DCD     LCD_IRQHandler             ;26, LCD IRQHandler
                DCD     ADC_IRQHandler             ;27, ADC IRQHandler
                DCD     COMP_IRQHandler            ;28, COMP IRQHandler
                DCD     OPAMP_IRQHandler           ;29, OPAMP IRQHandler
                DCD     BS16T1_IRQHandler          ;30, BS16T1 IRQHandler
                DCD     GP32C4T1_IRQHandler        ;31, GP32C4T1 IRQHandler
                DCD     CM0IKMCU_IRQ16_IRQHandler  ;32, Reserved
                DCD     CM0IKMCU_IRQ17_IRQHandler  ;33, Reserved
                DCD     CM0IKMCU_IRQ18_IRQHandler  ;34, Reserved
                DCD     GP16C2T1_IRQHandler        ;35, GP16C2T1 IRQHandler
                DCD     GP16C2T2_IRQHandler        ;36, GP16C2T2 IRQHandler
                DCD     GP16C2T3_IRQHandler        ;37, GP16C2T3 IRQHandler
                DCD     GP16C2T4_IRQHandler        ;38, GP16C2T4 IRQHandler
                DCD     I2C1_IRQHandler            ;39, I2C1 IRQHandler
                DCD     CM0IKMCU_IRQ24_IRQHandler  ;40, Reserved
                DCD     SPI1_IRQHandler            ;41, SPI1 IRQHandler
                DCD     CM0IKMCU_IRQ26_IRQHandler  ;42, Reserved
                DCD     UART1_IRQHandler           ;43, UART1 IRQHandler
                DCD     UART2_IRQHandler           ;44, UART2 IRQHandler
                DCD     UART3_IRQHandler           ;45, UART3 IRQHandler
                DCD     UART4_IRQHandler           ;46, UART4 IRQHandler
                DCD     CM0IKMCU_IRQ31_IRQHandler  ;47, Reserved
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:NOROOT:REORDER(2)
Reset_Handler
        LDR     R0, =__iar_program_start
        BX      R0
        
        PUBWEAK NMI_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK SVCall_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
SVCall_Handler
        B SVCall_Handler
		
    	PUBWEAK PendSV_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
PendSV_Handler
    	B PendSV_Handler

   	PUBWEAK SysTick_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
SysTick_Handler
    	B SysTick_Handler

        PUBWEAK WWDT_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WWDT_IRQHandler
        B WWDT_IRQHandler

	PUBWEAK LVD_IRQHandler
	SECTION .text:CODE:NOROOT:REORDER(1)
LVD_IRQHandler
	B LVD_IRQHandler
		
	PUBWEAK RTC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RTC_IRQHandler
        B RTC_IRQHandler

        PUBWEAK WAKEUP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WAKEUP_IRQHandler
        B WAKEUP_IRQHandler
        
        PUBWEAK RCU_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RCU_IRQHandler
        B RCU_IRQHandler

        PUBWEAK EXTI_0to1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_0to1_IRQHandler
        B EXTI_0to1_IRQHandler

        PUBWEAK EXTI_2to3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_2to3_IRQHandler
        B EXTI_2to3_IRQHandler

        PUBWEAK EXTI_4to15_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_4to15_IRQHandler
        B EXTI_4to15_IRQHandler
        
        PUBWEAK CM0IKMCU_IRQ8_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ8_IRQHandler
        B CM0IKMCU_IRQ8_IRQHandler

        PUBWEAK CM0IKMCU_IRQ9_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ9_IRQHandler
        B CM0IKMCU_IRQ9_IRQHandler

 	PUBWEAK LCD_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LCD_IRQHandler
        B LCD_IRQHandler

        PUBWEAK ADC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
ADC_IRQHandler
        B ADC_IRQHandler

        PUBWEAK COMP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
COMP_IRQHandler
        B COMP_IRQHandler

        PUBWEAK OPAMP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
OPAMP_IRQHandler
        B OPAMP_IRQHandler

        PUBWEAK BS16T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
BS16T1_IRQHandler
        B BS16T1_IRQHandler

        PUBWEAK GP32C4T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP32C4T1_IRQHandler
        B GP32C4T1_IRQHandler

        PUBWEAK CM0IKMCU_IRQ16_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ16_IRQHandler
        B CM0IKMCU_IRQ16_IRQHandler

        PUBWEAK CM0IKMCU_IRQ17_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ17_IRQHandler
        B CM0IKMCU_IRQ17_IRQHandler

        PUBWEAK CM0IKMCU_IRQ18_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ18_IRQHandler
        B CM0IKMCU_IRQ18_IRQHandler

        PUBWEAK GP16C2T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T1_IRQHandler
        B GP16C2T1_IRQHandler

        PUBWEAK GP16C2T2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T2_IRQHandler
        B GP16C2T2_IRQHandler

        PUBWEAK GP16C2T3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T3_IRQHandler
        B GP16C2T3_IRQHandler

        PUBWEAK GP16C2T4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T4_IRQHandler
        B GP16C2T4_IRQHandler

        PUBWEAK I2C1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2C1_IRQHandler
        B I2C1_IRQHandler

	PUBWEAK CM0IKMCU_IRQ24_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ24_IRQHandler
        B CM0IKMCU_IRQ24_IRQHandler

	PUBWEAK SPI1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI1_IRQHandler
        B SPI1_IRQHandler

	PUBWEAK CM0IKMCU_IRQ26_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ26_IRQHandler
        B CM0IKMCU_IRQ26_IRQHandler

	PUBWEAK UART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART1_IRQHandler
        B UART1_IRQHandler

	PUBWEAK UART2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART2_IRQHandler
        B UART2_IRQHandler

	PUBWEAK UART3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART3_IRQHandler
        B UART3_IRQHandler

	PUBWEAK UART4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART4_IRQHandler
        B UART4_IRQHandler

	PUBWEAK CM0IKMCU_IRQ31_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CM0IKMCU_IRQ31_IRQHandler
        B CM0IKMCU_IRQ31_IRQHandler

        END
