/**********************************************************************************
 *
 * @file    reg_uart.h
 * @brief   UART Head File
 *
 * @date    20 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Jul 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __UART_H__
#define __UART_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for UART_RXBUF register ************************/

# define  UART_RXDATA_RXDATA_POSS 0U
# define  UART_RXDATA_RXDATA_POSE 8U
# define  UART_RXDATA_RXDATA_MSK  BITS(UART_RXDATA_RXDATA_POSS, UART_RXDATA_RXDATA_POSE)
# define  UART_RXDATA_RXDATA      UART_RXDATA_RXDATA_MSK

/****************** Bit definition for UART_TXBUF register ************************/

# define  UART_TXDATA_TXDATA_POSS 0U
# define  UART_TXDATA_TXDATA_POSE 8U
# define  UART_TXDATA_TXDATA_MSK  BITS(UART_TXDATA_TXDATA_POSS, UART_TXDATA_TXDATA_POSE)
# define  UART_TXDATA_TXDATA      UART_TXDATA_TXDATA_MSK

/****************** Bit definition for UART_BRR register ************************/

# define  UART_BRR_BRR_POSS 0U
# define  UART_BRR_BRR_POSE 15U
# define  UART_BRR_BRR_MSK  BITS(UART_BRR_BRR_POSS, UART_BRR_BRR_POSE)
# define  UART_BRR_BRR      UART_BRR_BRR_MSK

/****************** Bit definition for UART_LCON register ************************/

# define  UART_LCON_TXEN_POS 15U
# define  UART_LCON_TXEN_MSK BIT(UART_LCON_TXEN_POS)
# define  UART_LCON_TXEN     UART_LCON_TXEN_MSK

# define  UART_LCON_RXEN_POS 14U
# define  UART_LCON_RXEN_MSK BIT(UART_LCON_RXEN_POS)
# define  UART_LCON_RXEN     UART_LCON_RXEN_MSK

# define  UART_LCON_DBCEN_POS 13U
# define  UART_LCON_DBCEN_MSK BIT(UART_LCON_DBCEN_POS)
# define  UART_LCON_DBCEN     UART_LCON_DBCEN_MSK

# define  UART_LCON_BREAK_POS 10U
# define  UART_LCON_BREAK_MSK BIT(UART_LCON_BREAK_POS)
# define  UART_LCON_BREAK     UART_LCON_BREAK_MSK

# define  UART_LCON_SWAP_POS 9U
# define  UART_LCON_SWAP_MSK BIT(UART_LCON_SWAP_POS)
# define  UART_LCON_SWAP     UART_LCON_SWAP_MSK

# define  UART_LCON_TXINV_POS 8U
# define  UART_LCON_TXINV_MSK BIT(UART_LCON_TXINV_POS)
# define  UART_LCON_TXINV     UART_LCON_TXINV_MSK

# define  UART_LCON_RXINV_POS 7U
# define  UART_LCON_RXINV_MSK BIT(UART_LCON_RXINV_POS)
# define  UART_LCON_RXINV     UART_LCON_RXINV_MSK

# define  UART_LCON_DATAINV_POS 6U
# define  UART_LCON_DATAINV_MSK BIT(UART_LCON_DATAINV_POS)
# define  UART_LCON_DATAINV     UART_LCON_DATAINV_MSK

# define  UART_LCON_MSB_POS 5U
# define  UART_LCON_MSB_MSK BIT(UART_LCON_MSB_POS)
# define  UART_LCON_MSB     UART_LCON_MSB_MSK

# define  UART_LCON_PS_POS 4U
# define  UART_LCON_PS_MSK BIT(UART_LCON_PS_POS)
# define  UART_LCON_PS     UART_LCON_PS_MSK

# define  UART_LCON_PE_POS 3U
# define  UART_LCON_PE_MSK BIT(UART_LCON_PE_POS)
# define  UART_LCON_PE     UART_LCON_PE_MSK

# define  UART_LCON_STOP_POS 2U
# define  UART_LCON_STOP_MSK BIT(UART_LCON_STOP_POS)
# define  UART_LCON_STOP     UART_LCON_STOP_MSK

# define  UART_LCON_DLS_POSS 0U
# define  UART_LCON_DLS_POSE 1U
# define  UART_LCON_DLS_MSK  BITS(UART_LCON_DLS_POSS, UART_LCON_DLS_POSE)
# define  UART_LCON_DLS      UART_LCON_DLS_MSK

/****************** Bit definition for UART_MCON register ************************/

# define  UART_MCON_TXFLOAT_POS 16U
# define  UART_MCON_TXFLOAT_MSK BIT(UART_MCON_TXFLOAT_POS)
# define  UART_MCON_TXFLOAT     UART_MCON_TXFLOAT_MSK

# define  UART_MCON_ABRREPT_POS 11U
# define  UART_MCON_ABRREPT_MSK BIT(UART_MCON_ABRREPT_POS)
# define  UART_MCON_ABRREPT     UART_MCON_ABRREPT_MSK

# define  UART_MCON_ABRMOD_POSS 9U
# define  UART_MCON_ABRMOD_POSE 10U
# define  UART_MCON_ABRMOD_MSK  BITS(UART_MCON_ABRMOD_POSS, UART_MCON_ABRMOD_POSE)
# define  UART_MCON_ABRMOD      UART_MCON_ABRMOD_MSK

# define  UART_MCON_ABREN_POS 8U
# define  UART_MCON_ABREN_MSK BIT(UART_MCON_ABREN_POS)
# define  UART_MCON_ABREN     UART_MCON_ABREN_MSK

# define  UART_MCON_AFCEN_POS 2U
# define  UART_MCON_AFCEN_MSK BIT(UART_MCON_AFCEN_POS)
# define  UART_MCON_AFCEN     UART_MCON_AFCEN_MSK

# define  UART_MCON_RTSSET_POS 1U
# define  UART_MCON_RTSSET_MSK BIT(UART_MCON_RTSSET_POS)
# define  UART_MCON_RTSSET     UART_MCON_RTSSET_MSK

# define  UART_MCON_LPBKEN_POS 0U
# define  UART_MCON_LPBKEN_MSK BIT(UART_MCON_LPBKEN_POS)
# define  UART_MCON_LPBKEN     UART_MCON_LPBKEN_MSK

/****************** Bit definition for UART_RS485 register ************************/

# define  UART_RS485_DLY_POSS 16U
# define  UART_RS485_DLY_POSE 23U
# define  UART_RS485_DLY_MSK  BITS(UART_RS485_DLY_POSS, UART_RS485_DLY_POSE)
# define  UART_RS485_DLY      UART_RS485_DLY_MSK

# define  UART_RS485_ADDR_POSS 8U
# define  UART_RS485_ADDR_POSE 15U
# define  UART_RS485_ADDR_MSK  BITS(UART_RS485_ADDR_POSS, UART_RS485_ADDR_POSE)
# define  UART_RS485_ADDR      UART_RS485_ADDR_MSK

# define  UART_RS485_AADINV_POS 3U
# define  UART_RS485_AADINV_MSK BIT(UART_RS485_AADINV_POS)
# define  UART_RS485_AADINV     UART_RS485_AADINV_MSK

# define  UART_RS485_AADACEN_POS 2U
# define  UART_RS485_AADACEN_MSK BIT(UART_RS485_AADACEN_POS)
# define  UART_RS485_AADACEN     UART_RS485_AADACEN_MSK

# define  UART_RS485_AADNEN_POS 1U
# define  UART_RS485_AADNEN_MSK BIT(UART_RS485_AADNEN_POS)
# define  UART_RS485_AADNEN     UART_RS485_AADNEN_MSK

# define  UART_RS485_AADEN_POS 0U
# define  UART_RS485_AADEN_MSK BIT(UART_RS485_AADEN_POS)
# define  UART_RS485_AADEN     UART_RS485_AADEN_MSK

/****************** Bit definition for UART_RTOR register ************************/

# define  UART_RTOR_RTOEN_POS 24U
# define  UART_RTOR_RTOEN_MSK BIT(UART_RTOR_RTOEN_POS)
# define  UART_RTOR_RTOEN     UART_RTOR_RTOEN_MSK

# define  UART_RTOR_RTO_POSS 0U
# define  UART_RTOR_RTO_POSE 7U
# define  UART_RTOR_RTO_MSK  BITS(UART_RTOR_RTO_POSS, UART_RTOR_RTO_POSE)
# define  UART_RTOR_RTO      UART_RTOR_RTO_MSK

/****************** Bit definition for UART_FCON register ************************/

# define  UART_FCON_TXFL_POSS 11U
# define  UART_FCON_TXFL_POSE 15U
# define  UART_FCON_TXFL_MSK  BITS(UART_FCON_TXFL_POSS, UART_FCON_TXFL_POSE)
# define  UART_FCON_TXFL      UART_FCON_TXFL_MSK

# define  UART_FCON_TXTH_POSS 9U
# define  UART_FCON_TXTH_POSE 10U
# define  UART_FCON_TXTH_MSK  BITS(UART_FCON_TXTH_POSS, UART_FCON_TXTH_POSE)
# define  UART_FCON_TXTH      UART_FCON_TXTH_MSK

# define  UART_FCON_TFRST_POS 8U
# define  UART_FCON_TFRST_MSK BIT(UART_FCON_TFRST_POS)
# define  UART_FCON_TFRST     UART_FCON_TFRST_MSK

# define  UART_FCON_RXFL_POSS 3U
# define  UART_FCON_RXFL_POSE 7U
# define  UART_FCON_RXFL_MSK  BITS(UART_FCON_RXFL_POSS, UART_FCON_RXFL_POSE)
# define  UART_FCON_RXFL      UART_FCON_RXFL_MSK

# define  UART_FCON_RXTH_POSS 1U
# define  UART_FCON_RXTH_POSE 2U
# define  UART_FCON_RXTH_MSK  BITS(UART_FCON_RXTH_POSS, UART_FCON_RXTH_POSE)
# define  UART_FCON_RXTH      UART_FCON_RXTH_MSK

# define  UART_FCON_RFRST_POS 0U
# define  UART_FCON_RFRST_MSK BIT(UART_FCON_RFRST_POS)
# define  UART_FCON_RFRST     UART_FCON_RFRST_MSK

/****************** Bit definition for UART_STAT register ************************/

# define  UART_STAT_TFOERR_POS 18U
# define  UART_STAT_TFOERR_MSK BIT(UART_STAT_TFOERR_POS)
# define  UART_STAT_TFOERR     UART_STAT_TFOERR_MSK

# define  UART_STAT_TFFULL_POS 17U
# define  UART_STAT_TFFULL_MSK BIT(UART_STAT_TFFULL_POS)
# define  UART_STAT_TFFULL     UART_STAT_TFFULL_MSK

# define  UART_STAT_TFEMPTY_POS 16U
# define  UART_STAT_TFEMPTY_MSK BIT(UART_STAT_TFEMPTY_POS)
# define  UART_STAT_TFEMPTY     UART_STAT_TFEMPTY_MSK

# define  UART_STAT_TFTH_POS 15U
# define  UART_STAT_TFTH_MSK BIT(UART_STAT_TFTH_POS)
# define  UART_STAT_TFTH     UART_STAT_TFTH_MSK

# define  UART_STAT_TSBUSY_POS 14U
# define  UART_STAT_TSBUSY_MSK BIT(UART_STAT_TSBUSY_POS)
# define  UART_STAT_TSBUSY     UART_STAT_TSBUSY_MSK

# define  UART_STAT_RFUERR_POS 13U
# define  UART_STAT_RFUERR_MSK BIT(UART_STAT_RFUERR_POS)
# define  UART_STAT_RFUERR     UART_STAT_RFUERR_MSK

# define  UART_STAT_RFOERR_POS 12U
# define  UART_STAT_RFOERR_MSK BIT(UART_STAT_RFOERR_POS)
# define  UART_STAT_RFOERR     UART_STAT_RFOERR_MSK

# define  UART_STAT_RFFULL_POS 11U
# define  UART_STAT_RFFULL_MSK BIT(UART_STAT_RFFULL_POS)
# define  UART_STAT_RFFULL     UART_STAT_RFFULL_MSK

# define  UART_STAT_RFNEMPTY_POS 10U
# define  UART_STAT_RFNEMPTY_MSK BIT(UART_STAT_RFNEMPTY_POS)
# define  UART_STAT_RFNEMPTY     UART_STAT_RFNEMPTY_MSK

# define  UART_STAT_RFTH_POS 9U
# define  UART_STAT_RFTH_MSK BIT(UART_STAT_RFTH_POS)
# define  UART_STAT_RFTH     UART_STAT_RFTH_MSK

# define  UART_STAT_RSBUSY_POS 8U
# define  UART_STAT_RSBUSY_MSK BIT(UART_STAT_RSBUSY_POS)
# define  UART_STAT_RSBUSY     UART_STAT_RSBUSY_MSK

# define  UART_STAT_CTSSTA_POS 3U
# define  UART_STAT_CTSSTA_MSK BIT(UART_STAT_CTSSTA_POS)
# define  UART_STAT_CTSSTA     UART_STAT_CTSSTA_MSK

# define  UART_STAT_BKERR_POS 2U
# define  UART_STAT_BKERR_MSK BIT(UART_STAT_BKERR_POS)
# define  UART_STAT_BKERR     UART_STAT_BKERR_MSK

# define  UART_STAT_FERR_POS 1U
# define  UART_STAT_FERR_MSK BIT(UART_STAT_FERR_POS)
# define  UART_STAT_FERR     UART_STAT_FERR_MSK

# define  UART_STAT_PERR_POS 0U
# define  UART_STAT_PERR_MSK BIT(UART_STAT_PERR_POS)
# define  UART_STAT_PERR     UART_STAT_PERR_MSK

/****************** Bit definition for UART_IER register ************************/

# define  UART_IER_TFOERR_POS 18U
# define  UART_IER_TFOERR_MSK BIT(UART_IER_TFOERR_POS)
# define  UART_IER_TFOERR     UART_IER_TFOERR_MSK

# define  UART_IER_TFEMPTY_POS 16U
# define  UART_IER_TFEMPTY_MSK BIT(UART_IER_TFEMPTY_POS)
# define  UART_IER_TFEMPTY     UART_IER_TFEMPTY_MSK

# define  UART_IER_TFTH_POS 15U
# define  UART_IER_TFTH_MSK BIT(UART_IER_TFTH_POS)
# define  UART_IER_TFTH     UART_IER_TFTH_MSK

# define  UART_IER_TBC_POS 14U
# define  UART_IER_TBC_MSK BIT(UART_IER_TBC_POS)
# define  UART_IER_TBC     UART_IER_TBC_MSK

# define  UART_IER_RFUERR_POS 13U
# define  UART_IER_RFUERR_MSK BIT(UART_IER_RFUERR_POS)
# define  UART_IER_RFUERR     UART_IER_RFUERR_MSK

# define  UART_IER_RFOERR_POS 12U
# define  UART_IER_RFOERR_MSK BIT(UART_IER_RFOERR_POS)
# define  UART_IER_RFOERR     UART_IER_RFOERR_MSK

# define  UART_IER_RFFULL_POS 11U
# define  UART_IER_RFFULL_MSK BIT(UART_IER_RFFULL_POS)
# define  UART_IER_RFFULL     UART_IER_RFFULL_MSK

# define  UART_IER_RFNEMPTY_POS 10U
# define  UART_IER_RFNEMPTY_MSK BIT(UART_IER_RFNEMPTY_POS)
# define  UART_IER_RFNEMPTY     UART_IER_RFNEMPTY_MSK

# define  UART_IER_RFTH_POS 9U
# define  UART_IER_RFTH_MSK BIT(UART_IER_RFTH_POS)
# define  UART_IER_RFTH     UART_IER_RFTH_MSK

# define  UART_IER_NOISE_POS 8U
# define  UART_IER_NOISE_MSK BIT(UART_IER_NOISE_POS)
# define  UART_IER_NOISE     UART_IER_NOISE_MSK

# define  UART_IER_ADDRM_POS 5U
# define  UART_IER_ADDRM_MSK BIT(UART_IER_ADDRM_POS)
# define  UART_IER_ADDRM     UART_IER_ADDRM_MSK

# define  UART_IER_RXTO_POS 4U
# define  UART_IER_RXTO_MSK BIT(UART_IER_RXTO_POS)
# define  UART_IER_RXTO     UART_IER_RXTO_MSK

# define  UART_IER_DCTS_POS 3U
# define  UART_IER_DCTS_MSK BIT(UART_IER_DCTS_POS)
# define  UART_IER_DCTS     UART_IER_DCTS_MSK

# define  UART_IER_ABTO_POS 2U
# define  UART_IER_ABTO_MSK BIT(UART_IER_ABTO_POS)
# define  UART_IER_ABTO     UART_IER_ABTO_MSK

# define  UART_IER_ABEND_POS 1U
# define  UART_IER_ABEND_MSK BIT(UART_IER_ABEND_POS)
# define  UART_IER_ABEND     UART_IER_ABEND_MSK

# define  UART_IER_RXBERR_POS 0U
# define  UART_IER_RXBERR_MSK BIT(UART_IER_RXBERR_POS)
# define  UART_IER_RXBERR     UART_IER_RXBERR_MSK

/****************** Bit definition for UART_IDR register ************************/

# define  UART_IDR_TFOERR_POS 18U
# define  UART_IDR_TFOERR_MSK BIT(UART_IDR_TFOERR_POS)
# define  UART_IDR_TFOERR     UART_IDR_TFOERR_MSK

# define  UART_IDR_TFEMPTY_POS 16U
# define  UART_IDR_TFEMPTY_MSK BIT(UART_IDR_TFEMPTY_POS)
# define  UART_IDR_TFEMPTY     UART_IDR_TFEMPTY_MSK

# define  UART_IDR_TFTH_POS 15U
# define  UART_IDR_TFTH_MSK BIT(UART_IDR_TFTH_POS)
# define  UART_IDR_TFTH     UART_IDR_TFTH_MSK

# define  UART_IDR_TBC_POS 14U
# define  UART_IDR_TBC_MSK BIT(UART_IDR_TBC_POS)
# define  UART_IDR_TBC     UART_IDR_TBC_MSK

# define  UART_IDR_RFUERR_POS 13U
# define  UART_IDR_RFUERR_MSK BIT(UART_IDR_RFUERR_POS)
# define  UART_IDR_RFUERR     UART_IDR_RFUERR_MSK

# define  UART_IDR_RFOERR_POS 12U
# define  UART_IDR_RFOERR_MSK BIT(UART_IDR_RFOERR_POS)
# define  UART_IDR_RFOERR     UART_IDR_RFOERR_MSK

# define  UART_IDR_RFFULL_POS 11U
# define  UART_IDR_RFFULL_MSK BIT(UART_IDR_RFFULL_POS)
# define  UART_IDR_RFFULL     UART_IDR_RFFULL_MSK

# define  UART_IDR_RFNEMPTY_POS 10U
# define  UART_IDR_RFNEMPTY_MSK BIT(UART_IDR_RFNEMPTY_POS)
# define  UART_IDR_RFNEMPTY     UART_IDR_RFNEMPTY_MSK

# define  UART_IDR_RFTH_POS 9U
# define  UART_IDR_RFTH_MSK BIT(UART_IDR_RFTH_POS)
# define  UART_IDR_RFTH     UART_IDR_RFTH_MSK

# define  UART_IDR_NOISE_POS 8U
# define  UART_IDR_NOISE_MSK BIT(UART_IDR_NOISE_POS)
# define  UART_IDR_NOISE     UART_IDR_NOISE_MSK

# define  UART_IDR_ADDRM_POS 5U
# define  UART_IDR_ADDRM_MSK BIT(UART_IDR_ADDRM_POS)
# define  UART_IDR_ADDRM     UART_IDR_ADDRM_MSK

# define  UART_IDR_RXTO_POS 4U
# define  UART_IDR_RXTO_MSK BIT(UART_IDR_RXTO_POS)
# define  UART_IDR_RXTO     UART_IDR_RXTO_MSK

# define  UART_IDR_DCTS_POS 3U
# define  UART_IDR_DCTS_MSK BIT(UART_IDR_DCTS_POS)
# define  UART_IDR_DCTS     UART_IDR_DCTS_MSK

# define  UART_IDR_ABTO_POS 2U
# define  UART_IDR_ABTO_MSK BIT(UART_IDR_ABTO_POS)
# define  UART_IDR_ABTO     UART_IDR_ABTO_MSK

# define  UART_IDR_ABEND_POS 1U
# define  UART_IDR_ABEND_MSK BIT(UART_IDR_ABEND_POS)
# define  UART_IDR_ABEND     UART_IDR_ABEND_MSK

# define  UART_IDR_RXBERR_POS 0U
# define  UART_IDR_RXBERR_MSK BIT(UART_IDR_RXBERR_POS)
# define  UART_IDR_RXBERR     UART_IDR_RXBERR_MSK

/****************** Bit definition for UART_IVS register ************************/

# define  UART_IVS_TFOERR_POS 18U
# define  UART_IVS_TFOERR_MSK BIT(UART_IVS_TFOERR_POS)
# define  UART_IVS_TFOERR     UART_IVS_TFOERR_MSK

# define  UART_IVS_TFEMPTY_POS 16U
# define  UART_IVS_TFEMPTY_MSK BIT(UART_IVS_TFEMPTY_POS)
# define  UART_IVS_TFEMPTY     UART_IVS_TFEMPTY_MSK

# define  UART_IVS_TFTH_POS 15U
# define  UART_IVS_TFTH_MSK BIT(UART_IVS_TFTH_POS)
# define  UART_IVS_TFTH     UART_IVS_TFTH_MSK

# define  UART_IVS_TBC_POS 14U
# define  UART_IVS_TBC_MSK BIT(UART_IVS_TBC_POS)
# define  UART_IVS_TBC     UART_IVS_TBC_MSK

# define  UART_IVS_RFUERR_POS 13U
# define  UART_IVS_RFUERR_MSK BIT(UART_IVS_RFUERR_POS)
# define  UART_IVS_RFUERR     UART_IVS_RFUERR_MSK

# define  UART_IVS_RFOERR_POS 12U
# define  UART_IVS_RFOERR_MSK BIT(UART_IVS_RFOERR_POS)
# define  UART_IVS_RFOERR     UART_IVS_RFOERR_MSK

# define  UART_IVS_RFFULL_POS 11U
# define  UART_IVS_RFFULL_MSK BIT(UART_IVS_RFFULL_POS)
# define  UART_IVS_RFFULL     UART_IVS_RFFULL_MSK

# define  UART_IVS_RFNEMPTY_POS 10U
# define  UART_IVS_RFNEMPTY_MSK BIT(UART_IVS_RFNEMPTY_POS)
# define  UART_IVS_RFNEMPTY     UART_IVS_RFNEMPTY_MSK

# define  UART_IVS_RFTH_POS 9U
# define  UART_IVS_RFTH_MSK BIT(UART_IVS_RFTH_POS)
# define  UART_IVS_RFTH     UART_IVS_RFTH_MSK

# define  UART_IVS_NOISE_POS 8U
# define  UART_IVS_NOISE_MSK BIT(UART_IVS_NOISE_POS)
# define  UART_IVS_NOISE     UART_IVS_NOISE_MSK

# define  UART_IVS_ADDRM_POS 5U
# define  UART_IVS_ADDRM_MSK BIT(UART_IVS_ADDRM_POS)
# define  UART_IVS_ADDRM     UART_IVS_ADDRM_MSK

# define  UART_IVS_RXTO_POS 4U
# define  UART_IVS_RXTO_MSK BIT(UART_IVS_RXTO_POS)
# define  UART_IVS_RXTO     UART_IVS_RXTO_MSK

# define  UART_IVS_DCTS_POS 3U
# define  UART_IVS_DCTS_MSK BIT(UART_IVS_DCTS_POS)
# define  UART_IVS_DCTS     UART_IVS_DCTS_MSK

# define  UART_IVS_ABTO_POS 2U
# define  UART_IVS_ABTO_MSK BIT(UART_IVS_ABTO_POS)
# define  UART_IVS_ABTO     UART_IVS_ABTO_MSK

# define  UART_IVS_ABEND_POS 1U
# define  UART_IVS_ABEND_MSK BIT(UART_IVS_ABEND_POS)
# define  UART_IVS_ABEND     UART_IVS_ABEND_MSK

# define  UART_IVS_RXBERR_POS 0U
# define  UART_IVS_RXBERR_MSK BIT(UART_IVS_RXBERR_POS)
# define  UART_IVS_RXBERR     UART_IVS_RXBERR_MSK

/****************** Bit definition for UART_RIF register ************************/

# define  UART_RIF_TFOERR_POS 18U
# define  UART_RIF_TFOERR_MSK BIT(UART_RIF_TFOERR_POS)
# define  UART_RIF_TFOERR     UART_RIF_TFOERR_MSK

# define  UART_RIF_TFEMPTY_POS 16U
# define  UART_RIF_TFEMPTY_MSK BIT(UART_RIF_TFEMPTY_POS)
# define  UART_RIF_TFEMPTY     UART_RIF_TFEMPTY_MSK

# define  UART_RIF_TFTH_POS 15U
# define  UART_RIF_TFTH_MSK BIT(UART_RIF_TFTH_POS)
# define  UART_RIF_TFTH     UART_RIF_TFTH_MSK

# define  UART_RIF_TBC_POS 14U
# define  UART_RIF_TBC_MSK BIT(UART_RIF_TBC_POS)
# define  UART_RIF_TBC     UART_RIF_TBC_MSK

# define  UART_RIF_RFUERR_POS 13U
# define  UART_RIF_RFUERR_MSK BIT(UART_RIF_RFUERR_POS)
# define  UART_RIF_RFUERR     UART_RIF_RFUERR_MSK

# define  UART_RIF_RFOERR_POS 12U
# define  UART_RIF_RFOERR_MSK BIT(UART_RIF_RFOERR_POS)
# define  UART_RIF_RFOERR     UART_RIF_RFOERR_MSK

# define  UART_RIF_RFFULL_POS 11U
# define  UART_RIF_RFFULL_MSK BIT(UART_RIF_RFFULL_POS)
# define  UART_RIF_RFFULL     UART_RIF_RFFULL_MSK

# define  UART_RIF_RFNEMPTY_POS 10U
# define  UART_RIF_RFNEMPTY_MSK BIT(UART_RIF_RFNEMPTY_POS)
# define  UART_RIF_RFNEMPTY     UART_RIF_RFNEMPTY_MSK

# define  UART_RIF_RFTH_POS 9U
# define  UART_RIF_RFTH_MSK BIT(UART_RIF_RFTH_POS)
# define  UART_RIF_RFTH     UART_RIF_RFTH_MSK

# define  UART_RIF_NOISE_POS 8U
# define  UART_RIF_NOISE_MSK BIT(UART_RIF_NOISE_POS)
# define  UART_RIF_NOISE     UART_RIF_NOISE_MSK

# define  UART_RIF_ADDRM_POS 5U
# define  UART_RIF_ADDRM_MSK BIT(UART_RIF_ADDRM_POS)
# define  UART_RIF_ADDRM     UART_RIF_ADDRM_MSK

# define  UART_RIF_RXTO_POS 4U
# define  UART_RIF_RXTO_MSK BIT(UART_RIF_RXTO_POS)
# define  UART_RIF_RXTO     UART_RIF_RXTO_MSK

# define  UART_RIF_DCTS_POS 3U
# define  UART_RIF_DCTS_MSK BIT(UART_RIF_DCTS_POS)
# define  UART_RIF_DCTS     UART_RIF_DCTS_MSK

# define  UART_RIF_ABTO_POS 2U
# define  UART_RIF_ABTO_MSK BIT(UART_RIF_ABTO_POS)
# define  UART_RIF_ABTO     UART_RIF_ABTO_MSK

# define  UART_RIF_ABEND_POS 1U
# define  UART_RIF_ABEND_MSK BIT(UART_RIF_ABEND_POS)
# define  UART_RIF_ABEND     UART_RIF_ABEND_MSK

# define  UART_RIF_RXBERR_POS 0U
# define  UART_RIF_RXBERR_MSK BIT(UART_RIF_RXBERR_POS)
# define  UART_RIF_RXBERR     UART_RIF_RXBERR_MSK

/****************** Bit definition for UART_IFM register ************************/

# define  UART_IFM_TFOERR_POS 18U
# define  UART_IFM_TFOERR_MSK BIT(UART_IFM_TFOERR_POS)
# define  UART_IFM_TFOERR     UART_IFM_TFOERR_MSK

# define  UART_IFM_TFEMPTY_POS 16U
# define  UART_IFM_TFEMPTY_MSK BIT(UART_IFM_TFEMPTY_POS)
# define  UART_IFM_TFEMPTY     UART_IFM_TFEMPTY_MSK

# define  UART_IFM_TFTH_POS 15U
# define  UART_IFM_TFTH_MSK BIT(UART_IFM_TFTH_POS)
# define  UART_IFM_TFTH     UART_IFM_TFTH_MSK

# define  UART_IFM_TBC_POS 14U
# define  UART_IFM_TBC_MSK BIT(UART_IFM_TBC_POS)
# define  UART_IFM_TBC     UART_IFM_TBC_MSK

# define  UART_IFM_RFUERR_POS 13U
# define  UART_IFM_RFUERR_MSK BIT(UART_IFM_RFUERR_POS)
# define  UART_IFM_RFUERR     UART_IFM_RFUERR_MSK

# define  UART_IFM_RFOERR_POS 12U
# define  UART_IFM_RFOERR_MSK BIT(UART_IFM_RFOERR_POS)
# define  UART_IFM_RFOERR     UART_IFM_RFOERR_MSK

# define  UART_IFM_RFFULL_POS 11U
# define  UART_IFM_RFFULL_MSK BIT(UART_IFM_RFFULL_POS)
# define  UART_IFM_RFFULL     UART_IFM_RFFULL_MSK

# define  UART_IFM_RFNEMPTY_POS 10U
# define  UART_IFM_RFNEMPTY_MSK BIT(UART_IFM_RFNEMPTY_POS)
# define  UART_IFM_RFNEMPTY     UART_IFM_RFNEMPTY_MSK

# define  UART_IFM_RFTH_POS 9U
# define  UART_IFM_RFTH_MSK BIT(UART_IFM_RFTH_POS)
# define  UART_IFM_RFTH     UART_IFM_RFTH_MSK

# define  UART_IFM_NOISE_POS 8U
# define  UART_IFM_NOISE_MSK BIT(UART_IFM_NOISE_POS)
# define  UART_IFM_NOISE     UART_IFM_NOISE_MSK

# define  UART_IFM_ADDRM_POS 5U
# define  UART_IFM_ADDRM_MSK BIT(UART_IFM_ADDRM_POS)
# define  UART_IFM_ADDRM     UART_IFM_ADDRM_MSK

# define  UART_IFM_RXTO_POS 4U
# define  UART_IFM_RXTO_MSK BIT(UART_IFM_RXTO_POS)
# define  UART_IFM_RXTO     UART_IFM_RXTO_MSK

# define  UART_IFM_DCTS_POS 3U
# define  UART_IFM_DCTS_MSK BIT(UART_IFM_DCTS_POS)
# define  UART_IFM_DCTS     UART_IFM_DCTS_MSK

# define  UART_IFM_ABTO_POS 2U
# define  UART_IFM_ABTO_MSK BIT(UART_IFM_ABTO_POS)
# define  UART_IFM_ABTO     UART_IFM_ABTO_MSK

# define  UART_IFM_ABEND_POS 1U
# define  UART_IFM_ABEND_MSK BIT(UART_IFM_ABEND_POS)
# define  UART_IFM_ABEND     UART_IFM_ABEND_MSK

# define  UART_IFM_RXBERR_POS 0U
# define  UART_IFM_RXBERR_MSK BIT(UART_IFM_RXBERR_POS)
# define  UART_IFM_RXBERR     UART_IFM_RXBERR_MSK

/****************** Bit definition for UART_ICR register ************************/

# define  UART_IER_TFOERR_POS 18U
# define  UART_ICR_TFOERR_MSK BIT(UART_IER_TFOERR_POS)
# define  UART_ICR_TFOERR     UART_ICR_TFOERR_MSK

# define  UART_ICR_TFEMPTY_POS 16U
# define  UART_ICR_TFEMPTY_MSK BIT(UART_ICR_TFEMPTY_POS)
# define  UART_ICR_TFEMPTY     UART_ICR_TFEMPTY_MSK

# define  UART_ICR_TFTH_POS 15U
# define  UART_ICR_TFTH_MSK BIT(UART_ICR_TFTH_POS)
# define  UART_ICR_TFTH     UART_ICR_TFTH_MSK

# define  UART_ICR_TBC_POS 14U
# define  UART_ICR_TBC_MSK BIT(UART_ICR_TBC_POS)
# define  UART_ICR_TBC     UART_ICR_TBC_MSK

# define  UART_ICR_RFUERR_POS 13U
# define  UART_ICR_RFUERR_MSK BIT(UART_ICR_RFUERR_POS)
# define  UART_ICR_RFUERR     UART_ICR_RFUERR_MSK

# define  UART_ICR_RFOERR_POS 12U
# define  UART_ICR_RFOERR_MSK BIT(UART_ICR_RFOERR_POS)
# define  UART_ICR_RFOERR     UART_ICR_RFOERR_MSK

# define  UART_ICR_RFFULL_POS 11U
# define  UART_ICR_RFFULL_MSK BIT(UART_ICR_RFFULL_POS)
# define  UART_ICR_RFFULL     UART_ICR_RFFULL_MSK

# define  UART_ICR_RFNEMPTY_POS 10U
# define  UART_ICR_RFNEMPTY_MSK BIT(UART_ICR_RFNEMPTY_POS)
# define  UART_ICR_RFNEMPTY     UART_ICR_RFNEMPTY_MSK

# define  UART_ICR_RFTH_POS 9U
# define  UART_ICR_RFTH_MSK BIT(UART_ICR_RFTH_POS)
# define  UART_ICR_RFTH     UART_ICR_RFTH_MSK

# define  UART_ICR_NOISE_POS 8U
# define  UART_ICR_NOISE_MSK BIT(UART_ICR_NOISE_POS)
# define  UART_ICR_NOISE     UART_ICR_NOISE_MSK

# define  UART_ICR_ADDRM_POS 5U
# define  UART_ICR_ADDRM_MSK BIT(UART_ICR_ADDRM_POS)
# define  UART_ICR_ADDRM     UART_ICR_ADDRM_MSK

# define  UART_ICR_RXTO_POS 4U
# define  UART_ICR_RXTO_MSK BIT(UART_ICR_RXTO_POS)
# define  UART_ICR_RXTO     UART_ICR_RXTO_MSK

# define  UART_ICR_DCTS_POS 3U
# define  UART_ICR_DCTS_MSK BIT(UART_ICR_DCTS_POS)
# define  UART_ICR_DCTS     UART_ICR_DCTS_MSK

# define  UART_ICR_ABTO_POS 2U
# define  UART_ICR_ABTO_MSK BIT(UART_ICR_ABTO_POS)
# define  UART_ICR_ABTO     UART_ICR_ABTO_MSK

# define  UART_ICR_ABEND_POS 1U
# define  UART_ICR_ABEND_MSK BIT(UART_ICR_ABEND_POS)
# define  UART_ICR_ABEND     UART_ICR_ABEND_MSK

# define  UART_ICR_RXBERR_POS 0U
# define  UART_ICR_RXBERR_MSK BIT(UART_ICR_RXBERR_POS)
# define  UART_ICR_RXBERR     UART_ICR_RXBERR_MSK

typedef struct
{
    __I  uint32_t RXDATA;                   // 0x000
    __IO uint32_t TXDATA;                   // 0x004
    __IO uint32_t BRR;                      // 0x008
    __IO uint32_t LCON;                     // 0x00c
    __IO uint32_t MCON;                     // 0x010
    __IO uint32_t RS485;                    // 0x014
    __IO uint32_t RESERVED0;                // 0x018
    __IO uint32_t RESERVED1;                // 0x01c
    __IO uint32_t RTOR;                     // 0x020
    __IO uint32_t FCON;                     // 0x024
    __I  uint32_t STAT;                     // 0x028
    __O  uint32_t IER;                      // 0x02c
    __O  uint32_t IDR;                      // 0x030
    __I  uint32_t IVS;                      // 0x034
    __I  uint32_t RIF;                      // 0x038
    __I  uint32_t IFM;                      // 0x03c
    __O  uint32_t ICR;                      // 0x040
} UART_TypeDef;


#endif
