/**********************************************************************************
 *
 * @file    reg_opamp.h
 * @brief   OPAMP Head File
 *
 * @date    3 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2022      Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __OPAMP_H__
#define __OPAMP_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for OPA_CTRL register ************************/

# define    OPAMP_OPA_CTRL_OPA_OUT_POS 31U
# define    OPAMP_OPA_CTRL_OPA_OUT_MSK BIT(OPAMP_OPA_CTRL_OPA_OUT_POS)
# define    OPAMP_OPA_CTRL_OPA_OUT OPAMP_OPA_CTRL_OPA_OUT_MSK

# define    OPAMP_OPA_CTRL_OPA_MULTSRC_POSS 28U
# define    OPAMP_OPA_CTRL_OPA_MULTSRC_POSE 30U
# define    OPAMP_OPA_CTRL_OPA_MULTSRC_MSK BITS(OPAMP_OPA_CTRL_OPA_MULTSRC_POSS, OPAMP_OPA_CTRL_OPA_MULTSRC_POSE)
# define    OPAMP_OPA_CTRL_OPA_MULTSRC OPAMP_OPA_CTRL_OPA_MULTSRC_MSK

# define    OPAMP_OPA_CTRL_OPA_MULTS_POS 27U
# define    OPAMP_OPA_CTRL_OPA_MULTS_MSK BIT(OPAMP_OPA_CTRL_OPA_MULTS_POS)
# define    OPAMP_OPA_CTRL_OPA_MULTS OPAMP_OPA_CTRL_OPA_MULTS_MSK

# define    OPAMP_OPA_CTRL_OPA_POLAS_POS 26U
# define    OPAMP_OPA_CTRL_OPA_POLAS_MSK BIT(OPAMP_OPA_CTRL_OPA_POLAS_POS)
# define    OPAMP_OPA_CTRL_OPA_POLAS OPAMP_OPA_CTRL_OPA_POLAS_MSK

# define    OPAMP_OPA_CTRL_OPA_FILTEN_POS 25U
# define    OPAMP_OPA_CTRL_OPA_FILTEN_MSK BIT(OPAMP_OPA_CTRL_OPA_FILTEN_POS)
# define    OPAMP_OPA_CTRL_OPA_FILTEN OPAMP_OPA_CTRL_OPA_FILTEN_MSK

# define    OPAMP_OPA_CTRL_OPA_DOEN_POS 24U
# define    OPAMP_OPA_CTRL_OPA_DOEN_MSK BIT(OPAMP_OPA_CTRL_OPA_DOEN_POS)
# define    OPAMP_OPA_CTRL_OPA_DOEN OPAMP_OPA_CTRL_OPA_DOEN_MSK

# define    OPAMP_OPA_CTRL_OPA_INNS_POSS 16U
# define    OPAMP_OPA_CTRL_OPA_INNS_POSE 22U
# define    OPAMP_OPA_CTRL_OPA_INNS_MSK BITS(OPAMP_OPA_CTRL_OPA_INNS_POSS, OPAMP_OPA_CTRL_OPA_INNS_POSE)
# define    OPAMP_OPA_CTRL_OPA_INNS OPAMP_OPA_CTRL_OPA_INNS_MSK

# define    OPAMP_OPA_CTRL_OPA_INPS_POSS 8U
# define    OPAMP_OPA_CTRL_OPA_INPS_POSE 14U
# define    OPAMP_OPA_CTRL_OPA_INPS_MSK BITS(OPAMP_OPA_CTRL_OPA_INPS_POSS, OPAMP_OPA_CTRL_OPA_INPS_POSE)
# define    OPAMP_OPA_CTRL_OPA_INPS OPAMP_OPA_CTRL_OPA_INPS_MSK

# define    OPAMP_OPA_CTRL_OPA_AOEN_POS 5U
# define    OPAMP_OPA_CTRL_OPA_AOEN_MSK BIT(OPAMP_OPA_CTRL_OPA_AOEN_POS)
# define    OPAMP_OPA_CTRL_OPA_AOEN OPAMP_OPA_CTRL_OPA_AOEN_MSK

# define    OPAMP_OPA_CTRL_OPA_CAPS_POS 4U
# define    OPAMP_OPA_CTRL_OPA_CAPS_MSK BIT(OPAMP_OPA_CTRL_OPA_CAPS_POS)
# define    OPAMP_OPA_CTRL_OPA_CAPS OPAMP_OPA_CTRL_OPA_CAPS_MSK

# define    OPAMP_OPA_CTRL_OPA_CHPCKS_POS 3U
# define    OPAMP_OPA_CTRL_OPA_CHPCKS_MSK BIT(OPAMP_OPA_CTRL_OPA_CHPCKS_POS)
# define    OPAMP_OPA_CTRL_OPA_CHPCKS OPAMP_OPA_CTRL_OPA_CHPCKS_MSK

# define    OPAMP_OPA_CTRL_OPA_CHPEN_POS 1U
# define    OPAMP_OPA_CTRL_OPA_CHPEN_MSK BIT(OPAMP_OPA_CTRL_OPA_CHPEN_POS)
# define    OPAMP_OPA_CTRL_OPA_CHPEN OPAMP_OPA_CTRL_OPA_CHPEN_MSK

# define    OPAMP_OPA_CTRL_OPA_EN_POS 0U
# define    OPAMP_OPA_CTRL_OPA_EN_MSK BIT(OPAMP_OPA_CTRL_OPA_EN_POS)
# define    OPAMP_OPA_CTRL_OPA_EN OPAMP_OPA_CTRL_OPA_EN_MSK

/****************** Bit definition for OPA_DBC register ************************/

# define    OPAMP_OPA_DBC_DBCNT_POSS 8U
# define    OPAMP_OPA_DBC_DBCNT_POSE 10U
# define    OPAMP_OPA_DBC_DBCNT_MSK BITS(OPAMP_OPA_DBC_DBCNT_POSS, OPAMP_OPA_DBC_DBCNT_POSE)
# define    OPAMP_OPA_DBC_DBCNT OPAMP_OPA_DBC_DBCNT_MSK

# define    OPAMP_OPA_DBC_DBPRE_POSS 0U
# define    OPAMP_OPA_DBC_DBPRE_POSE 7U
# define    OPAMP_OPA_DBC_DBPRE_MSK BITS(OPAMP_OPA_DBC_DBPRE_POSS, OPAMP_OPA_DBC_DBPRE_POSE)
# define    OPAMP_OPA_DBC_DBPRE OPAMP_OPA_DBC_DBPRE_MSK

typedef struct
{
    __IO uint32_t OPA_CTRL;                     // 0x000
    __IO uint32_t OPA_DBC;                      // 0x004
} OPAMP_TypeDef;


#endif
