/**********************************************************************************
 *
 * @file    reg_lcd.h
 * @brief   LCD Head File
 *
 * @date    3 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2022      Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __LED_H__
#define __LED_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for LCD_MODE register ************************/

# define    LCD_MODE_POLA_SEL_POSS 20U
# define    LCD_MODE_POLA_SEL_POSE 21U
# define    LCD_MODE_POLA_SEL_MSK  BITS(LCD_MODE_POLA_SEL_POSS, LCD_MODE_POLA_SEL_POSE)
# define    LCD_MODE_POLA_SEL      LCD_MODE_POLA_SEL_MSK

# define    LCD_MODE_LCD_GPIO_POS 19U
# define    LCD_MODE_LCD_GPIO_MSK BIT(LCD_MODE_LCD_GPIO_POS)
# define    LCD_MODE_LCD_GPIO     LCD_MODE_LCD_GPIO_MSK

# define    LCD_MODE_QTSEL_POSS 16U
# define    LCD_MODE_QTSEL_POSE 18U
# define    LCD_MODE_QTSEL_MSK  BITS(LCD_MODE_QTSEL_POSS, LCD_MODE_QTSEL_POSE)
# define    LCD_MODE_QTSEL      LCD_MODE_QTSEL_MSK

# define    LCD_MODE_RSEL_POSS 12U
# define    LCD_MODE_RSEL_POSE 14U
# define    LCD_MODE_RSEL_MSK  BITS(LCD_MODE_RSEL_POSS, LCD_MODE_RSEL_POSE)
# define    LCD_MODE_RSEL      LCD_MODE_RSEL_MSK

# define    LCD_MODE_VLCD_SEL_POSS 8U
# define    LCD_MODE_VLCD_SEL_POSE 11U
# define    LCD_MODE_VLCD_SEL_MSK  BITS(LCD_MODE_VLCD_SEL_POSS, LCD_MODE_VLCD_SEL_POSE)
# define    LCD_MODE_VLCD_SEL      LCD_MODE_VLCD_SEL_MSK

# define    LCD_MODE_VLCD_SRC_POS 6U
# define    LCD_MODE_VLCD_SRC_MSK BIT(LCD_MODE_VLCD_SRC_POS)
# define    LCD_MODE_VLCD_SRC     LCD_MODE_VLCD_SRC_MSK

# define    LCD_MODE_BUFEN_POS 5U
# define    LCD_MODE_BUFEN_MSK BIT(LCD_MODE_BUFEN_POS)
# define    LCD_MODE_BUFEN     LCD_MODE_BUFEN_MSK

# define    LCD_MODE_TYPE_POS 4U
# define    LCD_MODE_TYPE_MSK BIT(LCD_MODE_TYPE_POS)
# define    LCD_MODE_TYPE     LCD_MODE_TYPE_MSK

# define    LCD_MODE_BIAS_POSS 2U
# define    LCD_MODE_BIAS_POSE 3U
# define    LCD_MODE_BIAS_MSK  BITS(LCD_MODE_BIAS_POSS, LCD_MODE_BIAS_POSE)
# define    LCD_MODE_BIAS      LCD_MODE_BIAS_MSK

# define    LCD_MODE_DUTY_POS 0U
# define    LCD_MODE_DUTY_MSK BIT(LCD_MODE_DUTY_POS)
# define    LCD_MODE_DUTY     LCD_MODE_DUTY_MSK

/****************** Bit definition for LCD_CTRL register ************************/

# define    LCD_CTRL_VLCD_RDY_POS 31U
# define    LCD_CTRL_VLCD_RDY_MSK BIT(LCD_CTRL_VLCD_RDY_POS)
# define    LCD_CTRL_VLCD_RDY     LCD_CTRL_VLCD_RDY_MSK

# define    LCD_CTRL_WSBLINK_POSS 19U
# define    LCD_CTRL_WSBLINK_POSE 20U
# define    LCD_CTRL_WSBLINK_MSK  BITS(LCD_CTRL_WSBLINK_POSS, LCD_CTRL_WSBLINK_POSE)
# define    LCD_CTRL_WSBLINK      LCD_CTRL_WSBLINK_MSK

# define    LCD_CTRL_FCVALUE_POSS 12U
# define    LCD_CTRL_FCVALUE_POSE 18U
# define    LCD_CTRL_FCVALUE_MSK  BITS(LCD_CTRL_FCVALUE_POSS, LCD_CTRL_FCVALUE_POSE)
# define    LCD_CTRL_FCVALUE      LCD_CTRL_FCVALUE_MSK

# define    LCD_CTRL_FCCTRL_POS 11U
# define    LCD_CTRL_FCCTRL_MSK BIT(LCD_CTRL_FCCTRL_POS)
# define    LCD_CTRL_FCCTRL     LCD_CTRL_FCCTRL_MSK

# define    LCD_CTRL_SWUPDATE_POS 10U
# define    LCD_CTRL_SWUPDATE_MSK BIT(LCD_CTRL_SWUPDATE_POS)
# define    LCD_CTRL_SWUPDATE     LCD_CTRL_SWUPDATE_MSK

# define    LCD_CTRL_UPDCTRL_POSS 8U
# define    LCD_CTRL_UPDCTRL_POSE 9U
# define    LCD_CTRL_UPDCTRL_MSK  BITS(LCD_CTRL_UPDCTRL_POSS, LCD_CTRL_UPDCTRL_POSE)
# define    LCD_CTRL_UPDCTRL      LCD_CTRL_UPDCTRL_MSK

# define    LCD_CTRL_FRDIV_POSS 1U
# define    LCD_CTRL_FRDIV_POSE 7U
# define    LCD_CTRL_FRDIV_MSK  BITS(LCD_CTRL_FRDIV_POSS, LCD_CTRL_FRDIV_POSE)
# define    LCD_CTRL_FRDIV      LCD_CTRL_FRDIV_MSK

# define    LCD_CTRL_LCDEN_POS 0U
# define    LCD_CTRL_LCDEN_MSK BIT(LCD_CTRL_LCDEN_POS)
# define    LCD_CTRL_LCDEN     LCD_CTRL_LCDEN_MSK

/****************** Bit definition for LCD_BLINK1 register ************************/

# define    LCD_BLINK1_COM3_POSS 24U
# define    LCD_BLINK1_COM3_POSE 31U
# define    LCD_BLINK1_COM3_MSK  BITS(LCD_BLINK1_COM3_POSS, LCD_BLINK1_COM3_POSE)
# define    LCD_BLINK1_COM3      LCD_BLINK1_COM3_MSK

# define    LCD_BLINK1_COM2_POSS 16U
# define    LCD_BLINK1_COM2_POSE 23U
# define    LCD_BLINK1_COM2_MSK  BITS(LCD_BLINK1_COM2_POSS, LCD_BLINK1_COM2_POSE)
# define    LCD_BLINK1_COM2      LCD_BLINK1_COM2_MSK

# define    LCD_BLINK1_COM1_POSS 8U
# define    LCD_BLINK1_COM1_POSE 15U
# define    LCD_BLINK1_COM1_MSK  BITS(LCD_BLINK1_COM1_POSS, LCD_BLINK1_COM1_POSE)
# define    LCD_BLINK1_COM1      LCD_BLINK1_COM1_MSK

# define    LCD_BLINK1_COM0_POSS 0U
# define    LCD_BLINK1_COM0_POSE 7U
# define    LCD_BLINK1_COM0_MSK  BITS(LCD_BLINK1_COM0_POSS, LCD_BLINK1_COM0_POSE)
# define    LCD_BLINK1_COM0      LCD_BLINK1_COM0_MSK

/****************** Bit definition for LCD_BLINK2 register ************************/

# define    LCD_BLINK2_COM5_POSS 8U
# define    LCD_BLINK2_COM5_POSE 15U
# define    LCD_BLINK2_COM5_MSK  BITS(LCD_BLINK2_COM5_POSS, LCD_BLINK2_COM5_POSE)
# define    LCD_BLINK2_COM5      LCD_BLINK2_COM5_MSK

# define    LCD_BLINK2_COM4_POSS 0U
# define    LCD_BLINK2_COM4_POSE 7U
# define    LCD_BLINK2_COM4_MSK  BITS(LCD_BLINK2_COM4_POSS, LCD_BLINK2_COM4_POSE)
# define    LCD_BLINK2_COM4      LCD_BLINK2_COM4_MSK

/****************** Bit definition for LCD_IER register ************************/

# define    LCD_IER_UPDATE_POS 0U
# define    LCD_IER_UPDATE_MSK BIT(LCD_IER_UPDATE_POS)
# define    LCD_IER_UPDATE     LCD_IER_UPDATE_MSK

/****************** Bit definition for LCD_IDR register ************************/

# define    LCD_IDR_UPDATE_POS 0U
# define    LCD_IDR_UPDATE_MSK BIT(LCD_IDR_UPDATE_POS)
# define    LCD_IDR_UPDATE     LCD_IDR_UPDATE_MSK

/****************** Bit definition for LCD_IVS register ************************/

# define    LCD_IVS_UPDATE_POS 0U
# define    LCD_IVS_UPDATE_MSK BIT(LCD_IVS_UPDATE_POS)
# define    LCD_IVS_UPDATE     LCD_IVS_UPDATE_MSK

/****************** Bit definition for LCD_RIF register ************************/

# define    LCD_RIF_UPDATE_POS 0U
# define    LCD_RIF_UPDATE_MSK BIT(LCD_RIF_UPDATE_POS)
# define    LCD_RIF_UPDATE     LCD_RIF_UPDATE_MSK

/****************** Bit definition for LCD_IFM register ************************/

# define    LCD_IFM_UPDATE_POS 0U
# define    LCD_IFM_UPDATE_MSK BIT(LCD_IFM_UPDATE_POS)
# define    LCD_IFM_UPDATE     LCD_IFM_UPDATE_MSK

/****************** Bit definition for LCD_ICR register ************************/

# define    LCD_ICR_UPDATE_POS 0U
# define    LCD_ICR_UPDATE_MSK BIT(LCD_ICR_UPDATE_POS)
# define    LCD_ICR_UPDATE     LCD_ICR_UPDATE_MSK

/****************** Bit definition for LCD_BUSY register ************************/

# define    LCD_BUSY_UPDATE_POS 0U
# define    LCD_BUSY_UPDATE_MSK BIT(LCD_BUSY_UPDATE_POS)
# define    LCD_BUSY_UPDATE     LCD_BUSY_UPDATE_MSK

/****************** Bit definition for LCD_RAM0 register ************************/

# define    LCD_RAM0_LCD_RAM0_POSS 0U
# define    LCD_RAM0_LCD_RAM0_POSE 31U
# define    LCD_RAM0_LCD_RAM0_MSK  BITS(LCD_RAM0_LCD_RAM0_POSS, LCD_RAM0_LCD_RAM0_POSE)
# define    LCD_RAM0_LCD_RAM0      LCD_RAM0_LCD_RAM0_MSK

/****************** Bit definition for LCD_RAM1 register ************************/

# define    LCD_RAM1_LCD_RAM1_POSS 0U
# define    LCD_RAM1_LCD_RAM1_POSE 31U
# define    LCD_RAM1_LCD_RAM1_MSK  BITS(LCD_RAM1_LCD_RAM1_POSS, LCD_RAM1_LCD_RAM1_POSE)
# define    LCD_RAM1_LCD_RAM1      LCD_RAM1_LCD_RAM1_MSK

/****************** Bit definition for LCD_RAM2 register ************************/

# define    LCD_RAM2_LCD_RAM2_POSS 0U
# define    LCD_RAM2_LCD_RAM2_POSE 31U
# define    LCD_RAM2_LCD_RAM2_MSK  BITS(LCD_RAM2_LCD_RAM2_POSS, LCD_RAM2_LCD_RAM2_POSE)
# define    LCD_RAM2_LCD_RAM2      LCD_RAM2_LCD_RAM2_MSK

/****************** Bit definition for LCD_RAM3 register ************************/

# define    LCD_RAM3_LCD_RAM3_POSS 0U
# define    LCD_RAM3_LCD_RAM3_POSE 31U
# define    LCD_RAM3_LCD_RAM3_MSK  BITS(LCD_RAM3_LCD_RAM3_POSS, LCD_RAM3_LCD_RAM3_POSE)
# define    LCD_RAM3_LCD_RAM3      LCD_RAM3_LCD_RAM3_MSK

/****************** Bit definition for LCD_RAM4 register ************************/

# define    LCD_RAM4_LCD_RAM4_POSS 0U
# define    LCD_RAM4_LCD_RAM4_POSE 31U
# define    LCD_RAM4_LCD_RAM4_MSK  BITS(LCD_RAM4_LCD_RAM4_POSS, LCD_RAM4_LCD_RAM4_POSE)
# define    LCD_RAM4_LCD_RAM4      LCD_RAM4_LCD_RAM4_MSK

/****************** Bit definition for LCD_RAM5 register ************************/

# define    LCD_RAM5_LCD_RAM5_POSS 0U
# define    LCD_RAM5_LCD_RAM5_POSE 31U
# define    LCD_RAM5_LCD_RAM5_MSK  BITS(LCD_RAM5_LCD_RAM5_POSS, LCD_RAM5_LCD_RAM5_POSE)
# define    LCD_RAM5_LCD_RAM5      LCD_RAM5_LCD_RAM5_MSK

/****************** Bit definition for LCD_RAM6 register ************************/

# define    LCD_RAM6_LCD_RAM6_POSS 0U
# define    LCD_RAM6_LCD_RAM6_POSE 31U
# define    LCD_RAM6_LCD_RAM6_MSK  BITS(LCD_RAM6_LCD_RAM6_POSS, LCD_RAM6_LCD_RAM6_POSE)
# define    LCD_RAM6_LCD_RAM6      LCD_RAM6_LCD_RAM6_MSK

/****************** Bit definition for LCD_RAM7 register ************************/

# define    LCD_RAM7_LCD_RAM7_POSS 0U
# define    LCD_RAM7_LCD_RAM7_POSE 31U
# define    LCD_RAM7_LCD_RAM7_MSK  BITS(LCD_RAM7_LCD_RAM7_POSS, LCD_RAM7_LCD_RAM7_POSE)
# define    LCD_RAM7_LCD_RAM7      LCD_RAM7_LCD_RAM7_MSK

/****************** Bit definition for LCD_RAM8 register ************************/

# define    LCD_RAM8_LCD_RAM8_POSS 0U
# define    LCD_RAM8_LCD_RAM8_POSE 31U
# define    LCD_RAM8_LCD_RAM8_MSK  BITS(LCD_RAM8_LCD_RAM8_POSS, LCD_RAM8_LCD_RAM8_POSE)
# define    LCD_RAM8_LCD_RAM8      LCD_RAM8_LCD_RAM8_MSK

/****************** Bit definition for LCD_RAM9 register ************************/

# define    LCD_RAM9_LCD_RAM9_POSS 0U
# define    LCD_RAM9_LCD_RAM9_POSE 31U
# define    LCD_RAM9_LCD_RAM9_MSK  BITS(LCD_RAM9_LCD_RAM9_POSS, LCD_RAM9_LCD_RAM9_POSE)
# define    LCD_RAM9_LCD_RAM9      LCD_RAM9_LCD_RAM9_MSK

/****************** Bit definition for LCD_RAM10 register ************************/

# define    LCD_RAM10_LCD_RAM10_POSS 0U
# define    LCD_RAM10_LCD_RAM10_POSE 31U
# define    LCD_RAM10_LCD_RAM10_MSK  BITS(LCD_RAM10_LCD_RAM10_POSS, LCD_RAM10_LCD_RAM10_POSE)
# define    LCD_RAM10_LCD_RAM10      LCD_RAM10_LCD_RAM10_MSK

/****************** Bit definition for LCD_RAM11 register ************************/

# define    LCD_RAM11_LCD_RAM11_POSS 0U
# define    LCD_RAM11_LCD_RAM11_POSE 31U
# define    LCD_RAM11_LCD_RAM11_MSK  BITS(LCD_RAM11_LCD_RAM11_POSS, LCD_RAM11_LCD_RAM11_POSE)
# define    LCD_RAM11_LCD_RAM11      LCD_RAM11_LCD_RAM11_MSK

typedef struct
{
    __IO uint32_t MODE;                    // 0x000
    __IO uint32_t CTRL;                    // 0x004
    __IO uint32_t BLINK1;                  // 0x008
    __IO uint32_t BLINK2;                  // 0x00c
    __IO uint32_t IER;                     // 0x010
    __IO uint32_t IDR;                     // 0x014
    __IO uint32_t IVS;                     // 0x018
    __IO uint32_t RIF;                     // 0x01c
    __IO uint32_t IFM;                     // 0x020
    __IO uint32_t ICR;                     // 0x024
    __IO uint32_t BUSY;                    // 0x028
    __IO uint32_t RESERVED0;               // 0x02c
    __IO uint32_t RAM0;                    // 0x030
    __IO uint32_t RAM1;                    // 0x034
    __IO uint32_t RAM2;                    // 0x038
    __IO uint32_t RAM3;                    // 0x03c
    __IO uint32_t RAM4;                    // 0x040
    __IO uint32_t RAM5;                    // 0x044
    __IO uint32_t RAM6;                    // 0x048
    __IO uint32_t RAM7;                    // 0x04c
    __IO uint32_t RAM8;                    // 0x050
    __IO uint32_t RAM9;                    // 0x054
    __IO uint32_t RAM10;                   // 0x058
    __IO uint32_t RAM11;                   // 0x05c
    __IO uint32_t RESERVED1[8];            // 0x060~0x07c
    __IO uint32_t TEST;                    // 0x080
} LCD_TypeDef;


#endif
