/**********************************************************************************
 *
 * @file    reg_fc.h
 * @brief   FC Head File
 *
 * @date    28 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Jul 2022     Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __FC_H__
#define __FC_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for FC_CMD register ************************/

# define    FC_CMD_CMD_POSS 0U
# define    FC_CMD_CMD_POSE 7U
# define    FC_CMD_CMD_MSK  BITS(FC_CMD_CMD_POSS, FC_CMD_CMD_POSE)
# define    FC_CMD_CMD      FC_CMD_CMD_MSK

/****************** Bit definition for FC_PA register ************************/

# define    FC_PA_PCNT_POSS 25U
# define    FC_PA_PCNT_POSE 31U
# define    FC_PA_PCNT_MSK  BITS(FC_PA_PCNT_POSS, FC_PA_PCNT_POSE)
# define    FC_PA_PCNT      FC_PA_PCNT_MSK

# define    FC_PA_IFREN_POS 24U
# define    FC_PA_IFREN_MSK BIT(FC_PA_IFREN_POS)
# define    FC_PA_IFREN     FC_PA_IFREN_MSK

# define    FC_PA_SYSMEMEN_POS 23U
# define    FC_PA_SYSMEMEN_MSK BIT(FC_PA_SYSMEMEN_POS)
# define    FC_PA_SYSMEMEN     FC_PA_SYSMEMEN_MSK

# define    FC_PA_PA_POSS 0U
# define    FC_PA_PA_POSE 19U
# define    FC_PA_PA_MSK  BITS(FC_PA_PA_POSS, FC_PA_PA_POSE)
# define    FC_PA_PA      FC_PA_PA_MSK

/****************** Bit definition for FC_PLD register ************************/

#define     FC_PLD_PLD_POSS  0U
#define     FC_PLD_PLD_POSE  31U
#define     FC_PLD_PLD_MSK   BITS(FC_PLD_PLD_POSS,FC_PLD_PLD_POSE)
#define     FC_PLD_PLD       FC_PLD_PLD_MSK

/****************** Bit definition for FC_CTL register ************************/

#define     FC_CTL_FCSLEEP_POS  10U
#define     FC_CTL_FCSLEEP_MSK  BIT(FC_CTL_FCSLEEP_POS)
#define     FC_CTL_FCSLEEP      FC_CTL_FCSLEEP_MSK

#define     FC_CTL_BUFEN_POS 9U
#define     FC_CTL_BUFEN_MSK BIT(FC_CTL_BUFEN_POS)
#define     FC_CTL_BUFEN     FC_CTL_BUFEN_MSK

#define     FC_CTL_OPRLD_POSS  4U
#define     FC_CTL_OPRLD_POSE  7U
#define     FC_CTL_OPRLD_MSK   BITS(FC_CTL_OPRLD_POSS, FC_CTL_OPRLD_POSE)
#define     FC_CTL_OPRLD       FC_CTL_OPRLD_MSK

#define     FC_CTL_WAIT_POSS  0U
#define     FC_CTL_WAIT_POSE  1U
#define     FC_CTL_WAIT_MSK   BITS(FC_CTL_WAIT_POSS, FC_CTL_WAIT_POSE)
#define     FC_CTL_WAIT       FC_CTL_WAIT_MSK

/****************** Bit definition for FC_STA register ************************/

#define     FC_STA_OPRLDLOOP_POSS  8U
#define     FC_STA_OPRLDLOOP_POSE  11U
#define     FC_STA_OPRLDLOOP_MSK   BITS(FC_STA_OPRLDLOOP_POSS, FC_STA_OPRLDLOOP_POSE)
#define     FC_STA_OPRLDLOOP       FC_STA_OPRLDLOOP_MSK

#define     FC_STA_PRTAREARD_POS  7U
#define     FC_STA_PRTAREARD_MSK  BIT(FC_STA_PRTAREARD_POS)
#define     FC_STA_PRTAREARD      FC_STA_PRTAREARD_MSK

#define     FC_STA_PRTAREAWR_POS  6U
#define     FC_STA_PRTAREAWR_MSK  BIT(FC_STA_PRTAREAWR_POS)
#define     FC_STA_PRTAREAWR      FC_STA_PRTAREAWR_MSK

#define     FC_STA_CMDULK_POS  5U
#define     FC_STA_CMDULK_MSK  BIT(FC_STA_CMDULK_POS)
#define     FC_STA_CMDULK      FC_STA_CMDULK_MSK

#define     FC_STA_FCBUSY_POS  4U
#define     FC_STA_FCBUSY_MSK  BIT(FC_STA_FCBUSY_POS)
#define     FC_STA_FCBUSY      FC_STA_FCBUSY_MSK

#define     FC_STA_WPDIS_POS  3U
#define     FC_STA_WPDIS_MSK  BIT(FC_STA_WPDIS_POS)
#define     FC_STA_WPDIS      FC_STA_WPDIS_MSK

#define     FC_STA_RPLV_POSS  1U
#define     FC_STA_RPLV_POSE  2U
#define     FC_STA_RPLV_MSK   BITS(FC_STA_RPLV_POSS, FC_STA_RPLV_POSE)
#define     FC_STA_RPLV       FC_STA_RPLV_MSK

#define     FC_STA_UCRPDIS_POS  0U
#define     FC_STA_UCRPDIS_MSK  BIT(FC_STA_UCRPDIS_POS)
#define     FC_STA_UCRPDIS      FC_STA_UCRPDIS_MSK

/****************** Bit definition for FC_UL register ************************/

#define     FC_UL_UL_POSS  0U
#define     FC_UL_UL_POSE  31U
#define     FC_UL_UL_MSK   BITS(FC_UL_UL_POSS,FC_UL_UL_POSE)
#define     FC_UL_UL       FC_UL_UL_MSK

/****************** Bit definition for FC_UP0 register ************************/

# define    FC_UP0_UP0_POSS 0U
# define    FC_UP0_UP0_POSE 31U
# define    FC_UP0_UP0_MSK  BITS(FC_UP0_UP0_POSS, FC_UP0_UP0_POSE)
# define    FC_UP0_UP0      FC_UP0_UP0_MSK

/****************** Bit definition for FC_UCRP0 register ************************/

# define    FC_UCRP0_UCRP0_POSS 0U
# define    FC_UCRP0_UCRP0_POSE 31U
# define    FC_UCRP0_UCRP0_MSK  BITS(FC_UCRP0_UCRP0_POSS, FC_UCRP0_UCRP0_POSE)
# define    FC_UCRP0_UCRP0      FC_UCRP0_UCRP0_MSK

/****************** Bit definition for FC_UCRP0REV register ************************/

# define    FC_UCRP0REV_UCRP0REV_POSS 0U
# define    FC_UCRP0REV_UCRP0REV_POSE 31U
# define    FC_UCRP0REV_UCRP0REV_MSK  BITS(FC_UCRP0REV_UCRP0REV_POSS, FC_UCRP0REV_UCRP0REV_POSE)
# define    FC_UCRP0REV_UCRP0REV      FC_UCRP0REV_UCRP0REV_MSK

/****************** Bit definition for FC_UCRP1 register ************************/

# define    FC_UCRP1_UCRP1_POSS 0U
# define    FC_UCRP1_UCRP1_POSE 31U
# define    FC_UCRP1_UCRP1_MSK  BITS(FC_UCRP1_UCRP1_POSS, FC_UCRP1_UCRP1_POSE)
# define    FC_UCRP1_UCRP1      FC_UCRP1_UCRP1_MSK

/****************** Bit definition for FC_UCRP1REV register ************************/

# define    FC_UCRP1REV_UCRP1REV_POSS 0U
# define    FC_UCRP1REV_UCRP1REV_POSE 31U
# define    FC_UCRP1REV_UCRP1REV_MSK  BITS(FC_UCRP1REV_UCRP1REV_POSS, FC_UCRP1REV_UCRP1REV_POSE)
# define    FC_UCRP1REV_UCRP1REV      FC_UCRP1REV_UCRP1REV_MSK

/****************** Bit definition for FC_RP register ************************/

# define    FC_RP_RP_POSS 0U
# define    FC_RP_RP_POSE 31U
# define    FC_RP_RP_MSK  BITS(FC_RP_RP_POSS, FC_RP_RP_POSE)
# define    FC_RP_RP      FC_RP_RP_MSK

/****************** Bit definition for FC_WP0 register ************************/

# define    FC_WP0_WP0_POSS 0U
# define    FC_WP0_WP0_POSE 31U
# define    FC_WP0_WP0_MSK  BITS(FC_WP0_WP0_POSS, FC_WP0_WP0_POSE)
# define    FC_WP0_WP0      FC_WP0_WP0_MSK

/****************** Bit definition for FC_WP0REV register ************************/

# define    FC_WP0REV_WP0REV_POSS 0U
# define    FC_WP0REV_WP0REV_POSE 31U
# define    FC_WP0REV_WP0REV_MSK BITS(FC_WP0REV_WP0REV_POSS, FC_WP0REV_WP0REV_POSE)
# define    FC_WP0REV_WP0REV FC_WP0REV_WP0REV_MSK

/****************** Bit definition for FC_WP1 register ************************/

# define    FC_WP1_WP1_POSS 0U
# define    FC_WP1_WP1_POSE 31U
# define    FC_WP1_WP1_MSK  BITS(FC_WP1_WP1_POSS, FC_WP1_WP1_POSE)
# define    FC_WP1_WP1      FC_WP1_WP1_MSK

/****************** Bit definition for FC_WP1REV register ************************/

# define    FC_WP1REV_WP1REV_POSS 0U
# define    FC_WP1REV_WP1REV_POSE 31U
# define    FC_WP1REV_WP1REV_MSK  BITS(FC_WP1REV_WP1REV_POSS, FC_WP1REV_WP1REV_POSE)
# define    FC_WP1REV_WP1REV      FC_WP1REV_WP1REV_MSK

/****************** Bit definition for FC_REMAP register ************************/

# define    FC_REMAP_BOOTBYP_POSS 16U
# define    FC_REMAP_BOOTBYP_POSE 23U
# define    FC_REMAP_BOOTBYP_MSK  BITS(FC_REMAP_BOOTBYP_POSS, FC_REMAP_BOOTBYP_POSE)
# define    FC_REMAP_BOOTBYP      FC_REMAP_BOOTBYP_MSK

# define    FC_REMAP_SELECT_POSS 8U
# define    FC_REMAP_SELECT_POSE 15U
# define    FC_REMAP_SELECT_MSK  BITS(FC_REMAP_SELECT_POSS, FC_REMAP_SELECT_POSE)
# define    FC_REMAP_SELECT      FC_REMAP_SELECT_MSK

# define    FC_REMAP_SEFBASE_POSS 0U
# define    FC_REMAP_SEFBASE_POSE 7U
# define    FC_REMAP_SEFBASE_MSK  BITS(FC_REMAP_SEFBASE_POSS, FC_REMAP_SEFBASE_POSE)
# define    FC_REMAP_SEFBASE      FC_REMAP_SEFBASE_MSK

typedef struct
{
    __IO uint32_t CMD;                      // 0x000
    __IO uint32_t PA;                       // 0x004
    __IO uint32_t PLD;                      // 0x008
    __IO uint32_t RESERVED0;                // 0x00c
    __IO uint32_t CTL;                      // 0x010
    __IO uint32_t STA;                      // 0x014
    __IO uint32_t UL;                       // 0x018
    __IO uint32_t RESERVED1;                // 0x01c
    __IO uint32_t UP0;                      // 0x020
    __IO uint32_t RESERVED2[11];            // 0x024-0x04c
    __I  uint32_t UCRP0;                    // 0x050
    __I  uint32_t UCRP0REV;                 // 0x054
    __I  uint32_t UCRP1;                    // 0x058
    __I  uint32_t UCRP1REV;                 // 0x05c
    __IO uint32_t RESERVED3[4];             // 0x060-0x06c
    __I  uint32_t RP;                       // 0x070
    __I  uint32_t WP0;                      // 0x074
    __I  uint32_t WP0REV;                   // 0x078
    __I  uint32_t WP1;                      // 0x07c
    __I  uint32_t WP1REV;                   // 0x080
    __IO uint32_t RESERVED4[4];             // 0x084-0x090
    __I  uint32_t REMAP;                    // 0x094
} FC_TypeDef;


#endif
