/**********************************************************************************
 *
 * @file    reg_cmp.h
 * @brief   CMP Head File
 *
 * @date    28 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Jul 2022     Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __CMP_H__
#define __CMP_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for CMP_CFG1 register ************************/

# define  CMP_CFG1_LOCK_POS 31U
# define  CMP_CFG1_LOCK_MSK BIT(CMP_CFG1_LOCK_POS)
# define  CMP_CFG1_LOCK     CMP_CFG1_LOCK_MSK

# define  CMP_CFG1_VALUE_POS 30U
# define  CMP_CFG1_VALUE_MSK BIT(CMP_CFG1_VALUE_POS)
# define  CMP_CFG1_VALUE     CMP_CFG1_VALUE_MSK

# define  CMP_CFG1_BLANKSEL_POSS 20U
# define  CMP_CFG1_BLANKSEL_POSE 24U
# define  CMP_CFG1_BLANKSEL_MSK  BITS(CMP_CFG1_BLANKSEL_POSS, CMP_CFG1_BLANKSEL_POSE)
# define  CMP_CFG1_BLANKSEL      CMP_CFG1_BLANKSEL_MSK

# define  CMP_CFG1_FILT_POS 18U
# define  CMP_CFG1_FILT_MSK BIT(CMP_CFG1_FILT_POS)
# define  CMP_CFG1_FILT     CMP_CFG1_FILT_MSK

# define  CMP_CFG1_HYST_POS 16U
# define  CMP_CFG1_HYST_MSK BIT(CMP_CFG1_HYST_POS)
# define  CMP_CFG1_HYST     CMP_CFG1_HYST_MSK

# define  CMP_CFG1_POL_POS 15U
# define  CMP_CFG1_POL_MSK BIT(CMP_CFG1_POL_POS)
# define  CMP_CFG1_POL     CMP_CFG1_POL_MSK

# define  CMP_CFG1_OUTSEL_POSS 12U
# define  CMP_CFG1_OUTSEL_POSE 14U
# define  CMP_CFG1_OUTSEL_MSK  BITS(CMP_CFG1_OUTSEL_POSS, CMP_CFG1_OUTSEL_POSE)
# define  CMP_CFG1_OUTSEL      CMP_CFG1_OUTSEL_MSK

# define  CMP_CFG1_INPSEL_POS 8U
# define  CMP_CFG1_INPSEL_MSK  BIT(CMP_CFG1_INPSEL_POS)
# define  CMP_CFG1_INPSEL      CMP_CFG1_INPSEL_MSK

# define  CMP_CFG1_INNSEL_POS 4U
# define  CMP_CFG1_INNSEL_MSK  BIT(CMP_CFG1_INNSEL_POS)
# define  CMP_CFG1_INNSEL      CMP_CFG1_INNSEL_MSK

# define  CMP_CFG1_EN_POS 0U
# define  CMP_CFG1_EN_MSK BIT(CMP_CFG1_EN_POS)
# define  CMP_CFG1_EN     CMP_CFG1_EN_MSK

/****************** Bit definition for CMP_CFG2 register ************************/

# define    CMP_CFG2_FILT_CNT_POSS 24U
# define    CMP_CFG2_FILT_CNT_POSE 26U
# define    CMP_CFG2_FILT_CNT_MSK BITS(CMP_CFG2_FILT_CNT_POSS, CMP_CFG2_FILT_CNT_POSE)
# define    CMP_CFG2_FILT_CNT CMP_CFG2_FILT_CNT_MSK

# define    CMP_CFG2_FILT_PRE_POSS 16U
# define    CMP_CFG2_FILT_PRE_POSE 23U
# define    CMP_CFG2_FILT_PRE_MSK BITS(CMP_CFG2_FILT_PRE_POSS, CMP_CFG2_FILT_PRE_POSE)
# define    CMP_CFG2_FILT_PRE CMP_CFG2_FILT_PRE_MSK

# define    CMP_CFG2_DM_POSS 12U
# define    CMP_CFG2_DM_POSE 15U
# define    CMP_CFG2_DM_MSK BITS(CMP_CFG2_DM_POSS, CMP_CFG2_DM_POSE)
# define    CMP_CFG2_DM CMP_CFG2_DM_MSK

# define    CMP_CFG2_DA_POSS 8U
# define    CMP_CFG2_DA_POSE 11U
# define    CMP_CFG2_DA_MSK BITS(CMP_CFG2_DA_POSS, CMP_CFG2_DA_POSE)
# define    CMP_CFG2_DA CMP_CFG2_DA_MSK

# define    CMP_CFG2_RLS_POS 5U
# define    CMP_CFG2_RLS_MSK BIT(CMP_CFG2_RLS_POS)
# define    CMP_CFG2_RLS CMP_CFG2_RLS_MSK

# define    CMP_CFG2_RHS_POS 4U
# define    CMP_CFG2_RHS_MSK BIT(CMP_CFG2_RHS_POS)
# define    CMP_CFG2_RHS CMP_CFG2_RHS_MSK

# define    CMP_CFG2_PS_POSS 0U
# define    CMP_CFG2_PS_POSE 1U
# define    CMP_CFG2_PS_MSK BITS(CMP_CFG2_PS_POSS, CMP_CFG2_PS_POSE)
# define    CMP_CFG2_PS      CMP_CFG2_PS_MSK

typedef struct
{
    __IO uint32_t CFG1;                     // 0x000
    __IO uint32_t CFG2;                     // 0x004
} CMP_TypeDef;


#endif
