/**********************************************************************************
 *
 * @file    reg_anpwr.h
 * @brief   ANPWR Head File
 *
 * @date    3 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2022      Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __ANPWR_H__
#define __ANPWR_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/


/****************** Bit definition for PWR_CTRL register ************************/

# define    ANPWR_PWR_CTRL_VDIV_SEL_POSS 16U
# define    ANPWR_PWR_CTRL_VDIV_SEL_POSE 19U
# define    ANPWR_PWR_CTRL_VDIV_SEL_MSK  BITS(ANPWR_PWR_CTRL_VDIV_SEL_POSS, ANPWR_PWR_CTRL_VDIV_SEL_POSE)
# define    ANPWR_PWR_CTRL_VDIV_SEL      ANPWR_PWR_CTRL_VDIV_SEL_MSK

# define    ANPWR_PWR_CTRL_VREF_EN_POS 13U
# define    ANPWR_PWR_CTRL_VREF_EN_MSK BIT(ANPWR_PWR_CTRL_VREF_EN_POS)
# define    ANPWR_PWR_CTRL_VREF_EN     ANPWR_PWR_CTRL_VREF_EN_MSK

# define    ANPWR_PWR_CTRL_VREF_SEL_POS 12U
# define    ANPWR_PWR_CTRL_VREF_SEL_MSK BIT(ANPWR_PWR_CTRL_VREF_SEL_POS)
# define    ANPWR_PWR_CTRL_VREF_SEL ANPWR_PWR_CTRL_VREF_SEL_MSK

# define    ANPWR_PWR_CTRL_TSFLTEN_POS 11U
# define    ANPWR_PWR_CTRL_TSFLTEN_MSK BIT(ANPWR_PWR_CTRL_TSFLTEN_POS)
# define    ANPWR_PWR_CTRL_TSFLTEN ANPWR_PWR_CTRL_TSFLTEN_MSK

# define    ANPWR_PWR_CTRL_VBG_CHPCKS_POS 10U
# define    ANPWR_PWR_CTRL_VBG_CHPCKS_MSK BIT(ANPWR_PWR_CTRL_VBG_CHPCKS_POS)
# define    ANPWR_PWR_CTRL_VBG_CHPCKS ANPWR_PWR_CTRL_VBG_CHPCKS_MSK

# define    ANPWR_PWR_CTRL_VBG_CHPEN_POS 9U
# define    ANPWR_PWR_CTRL_VBG_CHPEN_MSK BIT(ANPWR_PWR_CTRL_VBG_CHPEN_POS)
# define    ANPWR_PWR_CTRL_VBG_CHPEN ANPWR_PWR_CTRL_VBG_CHPEN_MSK

# define    ANPWR_PWR_CTRL_VBG_EN_POS 8U
# define    ANPWR_PWR_CTRL_VBG_EN_MSK BIT(ANPWR_PWR_CTRL_VBG_EN_POS)
# define    ANPWR_PWR_CTRL_VBG_EN ANPWR_PWR_CTRL_VBG_EN_MSK

# define    ANPWR_PWR_CTRL_BIAS_EN_POS 7U
# define    ANPWR_PWR_CTRL_BIAS_EN_MSK BIT(ANPWR_PWR_CTRL_BIAS_EN_POS)
# define    ANPWR_PWR_CTRL_BIAS_EN ANPWR_PWR_CTRL_BIAS_EN_MSK

# define    ANPWR_PWR_CTRL_VLDO_SEL_POSS 4U
# define    ANPWR_PWR_CTRL_VLDO_SEL_POSE 6U
# define    ANPWR_PWR_CTRL_VLDO_SEL_MSK BITS(ANPWR_PWR_CTRL_VLDO_SEL_POSS, ANPWR_PWR_CTRL_VLDO_SEL_POSE)
# define    ANPWR_PWR_CTRL_VLDO_SEL ANPWR_PWR_CTRL_VLDO_SEL_MSK

# define    ANPWR_PWR_CTRL_VLDO_CHPCKS_POS 3U
# define    ANPWR_PWR_CTRL_VLDO_CHPCKS_MSK BIT(ANPWR_PWR_CTRL_VLDO_CHPCKS_POS)
# define    ANPWR_PWR_CTRL_VLDO_CHPCKS ANPWR_PWR_CTRL_VLDO_CHPCKS_MSK

# define    ANPWR_PWR_CTRL_VLDO_CHPEN_POS 2U
# define    ANPWR_PWR_CTRL_VLDO_CHPEN_MSK BIT(ANPWR_PWR_CTRL_VLDO_CHPEN_POS)
# define    ANPWR_PWR_CTRL_VLDO_CHPEN ANPWR_PWR_CTRL_VLDO_CHPEN_MSK

# define    ANPWR_PWR_CTRL_VLDO_MODE_POSS 0U
# define    ANPWR_PWR_CTRL_VLDO_MODE_POSE 1U
# define    ANPWR_PWR_CTRL_VLDO_MODE_MSK BITS(ANPWR_PWR_CTRL_VLDO_MODE_POSS, ANPWR_PWR_CTRL_VLDO_MODE_POSE)
# define    ANPWR_PWR_CTRL_VLDO_MODE ANPWR_PWR_CTRL_VLDO_MODE_MSK

typedef struct
{
    __IO uint32_t PWR_CTRL;                 // 0x000
} ANPWR_TypeDef;


#endif
