/**********************************************************************************
 *
 * @file    reg_adc.h
 * @brief   ADC Head File
 *
 * @date    3 Aug 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Aug 2022      Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __ADC_H__
#define __ADC_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for IA_CTRL register ************************/

# define    ADC_IA_CTRL_IA_POLA_ST_POS 21U
# define    ADC_IA_CTRL_IA_POLA_ST_MSK BIT(ADC_IA_CTRL_IA_POLA_ST_POS)
# define    ADC_IA_CTRL_IA_POLA_ST     ADC_IA_CTRL_IA_POLA_ST_MSK

# define    ADC_IA_CTRL_IA_GAIN_POSS 16U
# define    ADC_IA_CTRL_IA_GAIN_POSE 18U
# define    ADC_IA_CTRL_IA_GAIN_MSK  BITS(ADC_IA_CTRL_IA_GAIN_POSS, ADC_IA_CTRL_IA_GAIN_POSE)
# define    ADC_IA_CTRL_IA_GAIN      ADC_IA_CTRL_IA_GAIN_MSK

# define    ADC_IA_CTRL_IA_INNS_POSS 12U
# define    ADC_IA_CTRL_IA_INNS_POSE 15U
# define    ADC_IA_CTRL_IA_INNS_MSK  BITS(ADC_IA_CTRL_IA_INNS_POSS, ADC_IA_CTRL_IA_INNS_POSE)
# define    ADC_IA_CTRL_IA_INNS      ADC_IA_CTRL_IA_INNS_MSK

# define    ADC_IA_CTRL_IA_INPS_POSS 8U
# define    ADC_IA_CTRL_IA_INPS_POSE 11U
# define    ADC_IA_CTRL_IA_INPS_MSK  BITS(ADC_IA_CTRL_IA_INPS_POSS, ADC_IA_CTRL_IA_INPS_POSE)
# define    ADC_IA_CTRL_IA_INPS      ADC_IA_CTRL_IA_INPS_MSK

# define    ADC_IA_CTRL_IA_CHPCKS_POSS 6U
# define    ADC_IA_CTRL_IA_CHPCKS_POSE 7U
# define    ADC_IA_CTRL_IA_CHPCKS_MSK  BITS(ADC_IA_CTRL_IA_CHPCKS_POSS, ADC_IA_CTRL_IA_CHPCKS_POSE)
# define    ADC_IA_CTRL_IA_CHPCKS      ADC_IA_CTRL_IA_CHPCKS_MSK

# define    ADC_IA_CTRL_IA_CHPS_POSS 4U
# define    ADC_IA_CTRL_IA_CHPS_POSE 5U
# define    ADC_IA_CTRL_IA_CHPS_MSK  BITS(ADC_IA_CTRL_IA_CHPS_POSS, ADC_IA_CTRL_IA_CHPS_POSE)
# define    ADC_IA_CTRL_IA_CHPS      ADC_IA_CTRL_IA_CHPS_MSK

# define    ADC_IA_CTRL_IA_LPFEN_POS 3U
# define    ADC_IA_CTRL_IA_LPFEN_MSK BIT(ADC_IA_CTRL_IA_LPFEN_POS)
# define    ADC_IA_CTRL_IA_LPFEN     ADC_IA_CTRL_IA_LPFEN_MSK

# define    ADC_IA_CTRL_IA_INSHR_POSS 1U
# define    ADC_IA_CTRL_IA_INSHR_POSE 2U
# define    ADC_IA_CTRL_IA_INSHR_MSK BITS(ADC_IA_CTRL_IA_INSHR_POSS, ADC_IA_CTRL_IA_INSHR_POSE)
# define    ADC_IA_CTRL_IA_INSHR     ADC_IA_CTRL_IA_INSHR_MSK

# define    ADC_IA_CTRL_IA_EN_POS 0U
# define    ADC_IA_CTRL_IA_EN_MSK BIT(ADC_IA_CTRL_IA_EN_POS)
# define    ADC_IA_CTRL_IA_EN     ADC_IA_CTRL_IA_EN_MSK

/****************** Bit definition for ADC_CTRL0 register ************************/

# define    ADC_CTRL0_ADC_RST_POS 31U
# define    ADC_CTRL0_ADC_RST_MSK BIT(ADC_CTRL0_ADC_RST_POS)
# define    ADC_CTRL0_ADC_RST     ADC_CTRL0_ADC_RST_MSK

# define    ADC_CTRL0_ADC_CURSEL_POS 24U
# define    ADC_CTRL0_ADC_CURSEL_MSK BIT(ADC_CTRL0_ADC_CURSEL_POS)
# define    ADC_CTRL0_ADC_CURSEL     ADC_CTRL0_ADC_CURSEL_MSK

# define    ADC_CTRL0_ADC_VRRS_POSS 22U
# define    ADC_CTRL0_ADC_VRRS_POSE 23U
# define    ADC_CTRL0_ADC_VRRS_MSK BITS(ADC_CTRL0_ADC_VRRS_POSS, ADC_CTRL0_ADC_VRRS_POSE)
# define    ADC_CTRL0_ADC_VRRS     ADC_CTRL0_ADC_VRRS_MSK

# define    ADC_CTRL0_ADC_INGN_POSS 20U
# define    ADC_CTRL0_ADC_INGN_POSE 21U
# define    ADC_CTRL0_ADC_INGN_MSK  BITS(ADC_CTRL0_ADC_INGN_POSS, ADC_CTRL0_ADC_INGN_POSE)
# define    ADC_CTRL0_ADC_INGN      ADC_CTRL0_ADC_INGN_MSK

# define    ADC_CTRL0_ADC_VRNS_POSS 18U
# define    ADC_CTRL0_ADC_VRNS_POSE 19U
# define    ADC_CTRL0_ADC_VRNS_MSK  BITS(ADC_CTRL0_ADC_VRNS_POSS, ADC_CTRL0_ADC_VRNS_POSE)
# define    ADC_CTRL0_ADC_VRNS      ADC_CTRL0_ADC_VRNS_MSK

# define    ADC_CTRL0_ADC_VRPS_POSS 16U
# define    ADC_CTRL0_ADC_VRPS_POSE 17U
# define    ADC_CTRL0_ADC_VRPS_MSK  BITS(ADC_CTRL0_ADC_VRPS_POSS, ADC_CTRL0_ADC_VRPS_POSE)
# define    ADC_CTRL0_ADC_VRPS      ADC_CTRL0_ADC_VRPS_MSK

# define    ADC_CTRL0_ADC_INNS_POSS 12U
# define    ADC_CTRL0_ADC_INNS_POSE 15U
# define    ADC_CTRL0_ADC_INNS_MSK  BITS(ADC_CTRL0_ADC_INNS_POSS, ADC_CTRL0_ADC_INNS_POSE)
# define    ADC_CTRL0_ADC_INNS      ADC_CTRL0_ADC_INNS_MSK

# define    ADC_CTRL0_ADC_INPS_POSS 8U
# define    ADC_CTRL0_ADC_INPS_POSE 11U
# define    ADC_CTRL0_ADC_INPS_MSK  BITS(ADC_CTRL0_ADC_INPS_POSS, ADC_CTRL0_ADC_INPS_POSE)
# define    ADC_CTRL0_ADC_INPS      ADC_CTRL0_ADC_INPS_MSK

# define    ADC_CTRL0_ADC_CHPS_POSS 6U
# define    ADC_CTRL0_ADC_CHPS_POSE 7U
# define    ADC_CTRL0_ADC_CHPS_MSK  BITS(ADC_CTRL0_ADC_CHPS_POSS, ADC_CTRL0_ADC_CHPS_POSE)
# define    ADC_CTRL0_ADC_CHPS      ADC_CTRL0_ADC_CHPS_MSK

# define    ADC_CTRL0_ADC_CKS_POSS 4U
# define    ADC_CTRL0_ADC_CKS_POSE 5U
# define    ADC_CTRL0_ADC_CKS_MSK  BITS(ADC_CTRL0_ADC_CKS_POSS, ADC_CTRL0_ADC_CKS_POSE)
# define    ADC_CTRL0_ADC_CKS      ADC_CTRL0_ADC_CKS_MSK

# define    ADC_CTRL0_ADC_VRBUF_POS 3U
# define    ADC_CTRL0_ADC_VRBUF_MSK BIT(ADC_CTRL0_ADC_VRBUF_POS)
# define    ADC_CTRL0_ADC_VRBUF     ADC_CTRL0_ADC_VRBUF_MSK

# define    ADC_CTRL0_ADC_VRSHR_POS 2U
# define    ADC_CTRL0_ADC_VRSHR_MSK BIT(ADC_CTRL0_ADC_VRSHR_POS)
# define    ADC_CTRL0_ADC_VRSHR     ADC_CTRL0_ADC_VRSHR_MSK

# define    ADC_CTRL0_ADC_INSHR_POS 1U
# define    ADC_CTRL0_ADC_INSHR_MSK BIT(ADC_CTRL0_ADC_INSHR_POS)
# define    ADC_CTRL0_ADC_INSHR     ADC_CTRL0_ADC_INSHR_MSK

# define    ADC_CTRL0_ADC_EN_POS 0U
# define    ADC_CTRL0_ADC_EN_MSK BIT(ADC_CTRL0_ADC_EN_POS)
# define    ADC_CTRL0_ADC_EN     ADC_CTRL0_ADC_EN_MSK

/****************** Bit definition for ADC_CTRL1 register ************************/

# define    ADC_CTRL1_READY_FLAG_POS 23U
# define    ADC_CTRL1_READY_FLAG_MSK BIT(ADC_CTRL1_READY_FLAG_POS)
# define    ADC_CTRL1_READY_FLAG     ADC_CTRL1_READY_FLAG_MSK

# define    ADC_CTRL1_ADC_OSR_POSS 4U
# define    ADC_CTRL1_ADC_OSR_POSE 7U
# define    ADC_CTRL1_ADC_OSR_MSK  BITS(ADC_CTRL1_ADC_OSR_POSS, ADC_CTRL1_ADC_OSR_POSE)
# define    ADC_CTRL1_ADC_OSR      ADC_CTRL1_ADC_OSR_MSK

# define    ADC_CTRL1_CIC_MODE_POSS 2U
# define    ADC_CTRL1_CIC_MODE_POSE 3U
# define    ADC_CTRL1_CIC_MODE_MSK BITS(ADC_CTRL1_CIC_MODE_POSS, ADC_CTRL1_CIC_MODE_POSE)
# define    ADC_CTRL1_CIC_MODE     ADC_CTRL1_CIC_MODE_MSK

# define    ADC_CTRL1_CIC_RST_POS 1U
# define    ADC_CTRL1_CIC_RST_MSK BIT(ADC_CTRL1_CIC_RST_POS)
# define    ADC_CTRL1_CIC_RST ADC_CTRL1_CIC_RST_MSK

# define    ADC_CTRL1_CIC_EN_POS 0U
# define    ADC_CTRL1_CIC_EN_MSK BIT(ADC_CTRL1_CIC_EN_POS)
# define    ADC_CTRL1_CIC_EN     ADC_CTRL1_CIC_EN_MSK

/****************** Bit definition for ADC_VAL register ************************/

# define    ADC_VAL_ADC_VAL_POSS 0U
# define    ADC_VAL_ADC_VAL_POSE 31U
# define    ADC_VAL_ADC_VAL_MSK  BITS(ADC_VAL_ADC_VAL_POSS, ADC_VAL_ADC_VAL_POSE)
# define    ADC_VAL_ADC_VAL      ADC_VAL_ADC_VAL_MSK

/****************** Bit definition for BIQUAD_CTRL register ************************/

# define    ADC_BIQUAD_CTRL_BIQUAD_SWTRIG_POS 8U
# define    ADC_BIQUAD_CTRL_BIQUAD_SWTRIG_MSK BIT(ADC_BIQUAD_CTRL_BIQUAD_SWTRIG_POS)
# define    ADC_BIQUAD_CTRL_BIQUAD_SWTRIG ADC_BIQUAD_CTRL_BIQUAD_SWTRIG_MSK

# define    ADC_BIQUAD_CTRL_BIQUAD_TRIGMODE_POS 3U
# define    ADC_BIQUAD_CTRL_BIQUAD_TRIGMODE_MSK BIT(ADC_BIQUAD_CTRL_BIQUAD_TRIGMODE_POS)
# define    ADC_BIQUAD_CTRL_BIQUAD_TRIGMODE ADC_BIQUAD_CTRL_BIQUAD_TRIGMODE_MSK

# define    ADC_BIQUAD_CTRL_BIQUAD_SECTION_POS 2U
# define    ADC_BIQUAD_CTRL_BIQUAD_SECTION_MSK BIT(ADC_BIQUAD_CTRL_BIQUAD_SECTION_POS)
# define    ADC_BIQUAD_CTRL_BIQUAD_SECTION ADC_BIQUAD_CTRL_BIQUAD_SECTION_MSK

# define    ADC_BIQUAD_CTRL_BIQUAD_RST_POS 1U
# define    ADC_BIQUAD_CTRL_BIQUAD_RST_MSK BIT(ADC_BIQUAD_CTRL_BIQUAD_RST_POS)
# define    ADC_BIQUAD_CTRL_BIQUAD_RST ADC_BIQUAD_CTRL_BIQUAD_RST_MSK

# define    ADC_BIQUAD_CTRL_BIQAUD_EN_POS 0U
# define    ADC_BIQUAD_CTRL_BIQAUD_EN_MSK BIT(ADC_BIQUAD_CTRL_BIQAUD_EN_POS)
# define    ADC_BIQUAD_CTRL_BIQAUD_EN ADC_BIQUAD_CTRL_BIQAUD_EN_MSK

/****************** Bit definition for BIQUAD_VAL register ************************/

# define    ADC_BIQUAD_VAL_BIQUAD_VAL_POSS 0U
# define    ADC_BIQUAD_VAL_BIQUAD_VAL_POSE 31U
# define    ADC_BIQUAD_VAL_BIQUAD_VAL_MSK BITS(ADC_BIQUAD_VAL_BIQUAD_VAL_POSS, ADC_BIQUAD_VAL_BIQUAD_VAL_POSE)
# define    ADC_BIQUAD_VAL_BIQUAD_VAL ADC_BIQUAD_VAL_BIQUAD_VAL_MSK

/****************** Bit definition for BIQUAD_IN register ************************/

# define    ADC_BIQUAD_IN_BIQUAD_IN_POSS 0U
# define    ADC_BIQUAD_IN_BIQUAD_IN_POSE 31U
# define    ADC_BIQUAD_IN_BIQUAD_IN_MSK BITS(ADC_BIQUAD_IN_BIQUAD_IN_POSS, ADC_BIQUAD_IN_BIQUAD_IN_POSE)
# define    ADC_BIQUAD_IN_BIQUAD_IN ADC_BIQUAD_IN_BIQUAD_IN_MSK

/****************** Bit definition for ADC_IER register ************************/

# define    ADC_IER_BIQUAD_DONE_POS 1U
# define    ADC_IER_BIQUAD_DONE_MSK BIT(ADC_IER_BIQUAD_DONE_POS)
# define    ADC_IER_BIQUAD_DONE ADC_IER_BIQUAD_DONE_MSK

# define    ADC_IER_ADC_DONE_POS 0U
# define    ADC_IER_ADC_DONE_MSK BIT(ADC_IER_ADC_DONE_POS)
# define    ADC_IER_ADC_DONE ADC_IER_ADC_DONE_MSK

/****************** Bit definition for ADC_IDR register ************************/

# define    ADC_IDR_BIQUAD_DONE_POS 1U
# define    ADC_IDR_BIQUAD_DONE_MSK BIT(ADC_IDR_BIQUAD_DONE_POS)
# define    ADC_IDR_BIQUAD_DONE ADC_IDR_BIQUAD_DONE_MSK

# define    ADC_IDR_ADC_DONE_POS 0U
# define    ADC_IDR_ADC_DONE_MSK BIT(ADC_IDR_ADC_DONE_POS)
# define    ADC_IDR_ADC_DONE ADC_IDR_ADC_DONE_MSK

/****************** Bit definition for ADC_IVS register ************************/

# define    ADC_IVS_BIQUAD_DONE_POS 1U
# define    ADC_IVS_BIQUAD_DONE_MSK BIT(ADC_IVS_BIQUAD_DONE_POS)
# define    ADC_IVS_BIQUAD_DONE ADC_IVS_BIQUAD_DONE_MSK

# define    ADC_IVS_ADC_DONE_POS 0U
# define    ADC_IVS_ADC_DONE_MSK BIT(ADC_IVS_ADC_DONE_POS)
# define    ADC_IVS_ADC_DONE ADC_IVS_ADC_DONE_MSK

/****************** Bit definition for ADC_RIF register ************************/

# define    ADC_RIF_BIQUAD_DONE_POS 1U
# define    ADC_RIF_BIQUAD_DONE_MSK BIT(ADC_RIF_BIQUAD_DONE_POS)
# define    ADC_RIF_BIQUAD_DONE ADC_RIF_BIQUAD_DONE_MSK

# define    ADC_RIF_ADC_DONE_POS 0U
# define    ADC_RIF_ADC_DONE_MSK BIT(ADC_RIF_ADC_DONE_POS)
# define    ADC_RIF_ADC_DONE ADC_RIF_ADC_DONE_MSK

/****************** Bit definition for ADC_IFM register ************************/

# define    ADC_IFM_BIQUAD_DONE_POS 1U
# define    ADC_IFM_BIQUAD_DONE_MSK BIT(ADC_IFM_BIQUAD_DONE_POS)
# define    ADC_IFM_BIQUAD_DONE ADC_IFM_BIQUAD_DONE_MSK

# define    ADC_IFM_ADC_DONE_POS 0U
# define    ADC_IFM_ADC_DONE_MSK BIT(ADC_IFM_ADC_DONE_POS)
# define    ADC_IFM_ADC_DONE ADC_IFM_ADC_DONE_MSK

/****************** Bit definition for ADC_ICR register ************************/

# define    ADC_ICR_BIQUAD_DONE_POS 1U
# define    ADC_ICR_BIQUAD_DONE_MSK BIT(ADC_ICR_BIQUAD_DONE_POS)
# define    ADC_ICR_BIQUAD_DONE ADC_ICR_BIQUAD_DONE_MSK

# define    ADC_ICR_ADC_DONE_POS 0U
# define    ADC_ICR_ADC_DONE_MSK BIT(ADC_ICR_ADC_DONE_POS)
# define    ADC_ICR_ADC_DONE ADC_ICR_ADC_DONE_MSK

/****************** Bit definition for COEF_SC_1 register ************************/

# define    ADC_COEF_SC_1_COEF_SC_1_POSS 0U
# define    ADC_COEF_SC_1_COEF_SC_1_POSE 31U
# define    ADC_COEF_SC_1_COEF_SC_1_MSK BITS(ADC_COEF_SC_1_COEF_SC_1_POSS, ADC_COEF_SC_1_COEF_SC_1_POSE)
# define    ADC_COEF_SC_1_COEF_SC_1 ADC_COEF_SC_1_COEF_SC_1_MSK

/****************** Bit definition for COEF_B1_1 register ************************/

# define    ADC_COEF_B1_1_COEF_B1_1_POSS 0U
# define    ADC_COEF_B1_1_COEF_B1_1_POSE 31U
# define    ADC_COEF_B1_1_COEF_B1_1_MSK BITS(ADC_COEF_B1_1_COEF_B1_1_POSS, ADC_COEF_B1_1_COEF_B1_1_POSE)
# define    ADC_COEF_B1_1_COEF_B1_1 ADC_COEF_B1_1_COEF_B1_1_MSK

/****************** Bit definition for COEF_B2_1 register ************************/

# define    ADC_COEF_B2_1_COEF_B2_1_POSS 0U
# define    ADC_COEF_B2_1_COEF_B2_1_POSE 31U
# define    ADC_COEF_B2_1_COEF_B2_1_MSK BITS(ADC_COEF_B2_1_COEF_B2_1_POSS, ADC_COEF_B2_1_COEF_B2_1_POSE)
# define    ADC_COEF_B2_1_COEF_B2_1 ADC_COEF_B2_1_COEF_B2_1_MSK

/****************** Bit definition for COEF_B3_1 register ************************/

# define    ADC_COEF_B3_1_COEF_B3_1_POSS 0U
# define    ADC_COEF_B3_1_COEF_B3_1_POSE 31U
# define    ADC_COEF_B3_1_COEF_B3_1_MSK BITS(ADC_COEF_B3_1_COEF_B3_1_POSS, ADC_COEF_B3_1_COEF_B3_1_POSE)
# define    ADC_COEF_B3_1_COEF_B3_1 ADC_COEF_B3_1_COEF_B3_1_MSK

/****************** Bit definition for COEF_A2_1 register ************************/

# define    ADC_COEF_A2_1_COEF_A2_1_POSS 0U
# define    ADC_COEF_A2_1_COEF_A2_1_POSE 31U
# define    ADC_COEF_A2_1_COEF_A2_1_MSK BITS(ADC_COEF_A2_1_COEF_A2_1_POSS, ADC_COEF_A2_1_COEF_A2_1_POSE)
# define    ADC_COEF_A2_1_COEF_A2_1 ADC_COEF_A2_1_COEF_A2_1_MSK

/****************** Bit definition for COEF_A3_1 register ************************/

# define    ADC_COEF_A3_1_COEF_A3_1_POSS 0U
# define    ADC_COEF_A3_1_COEF_A3_1_POSE 31U
# define    ADC_COEF_A3_1_COEF_A3_1_MSK BITS(ADC_COEF_A3_1_COEF_A3_1_POSS, ADC_COEF_A3_1_COEF_A3_1_POSE)
# define    ADC_COEF_A3_1_COEF_A3_1 ADC_COEF_A3_1_COEF_A3_1_MSK

/****************** Bit definition for COEF_SC_2 register ************************/

# define    ADC_COEF_SC_2_COEF_SC_2_POSS 0U
# define    ADC_COEF_SC_2_COEF_SC_2_POSE 31U
# define    ADC_COEF_SC_2_COEF_SC_2_MSK BITS(ADC_COEF_SC_2_COEF_SC_2_POSS, ADC_COEF_SC_2_COEF_SC_2_POSE)
# define    ADC_COEF_SC_2_COEF_SC_2 ADC_COEF_SC_2_COEF_SC_2_MSK

/****************** Bit definition for COEF_B1_2 register ************************/

# define    ADC_COEF_B1_2_COEF_B1_2_POSS 0U
# define    ADC_COEF_B1_2_COEF_B1_2_POSE 31U
# define    ADC_COEF_B1_2_COEF_B1_2_MSK BITS(ADC_COEF_B1_2_COEF_B1_2_POSS, ADC_COEF_B1_2_COEF_B1_2_POSE)
# define    ADC_COEF_B1_2_COEF_B1_2  ADC_COEF_B1_2_COEF_B1_2_MSK

/****************** Bit definition for COEF_B2_2 register ************************/

# define    ADC_COEF_B2_2_COEF_B2_2_POSS 0U
# define    ADC_COEF_B2_2_COEF_B2_2_POSE 31U
# define    ADC_COEF_B2_2_COEF_B2_2_MSK BITS(ADC_COEF_B2_2_COEF_B2_2_POSS, ADC_COEF_B2_2_COEF_B2_2_POSE)
# define    ADC_COEF_B2_2_COEF_B2_2  ADC_COEF_B2_2_COEF_B2_2_MSK

/****************** Bit definition for COEF_B3_2 register ************************/

# define    ADC_COEF_B3_2_COEF_B3_2_POSS 0U
# define    ADC_COEF_B3_2_COEF_B3_2_POSE 31U
# define    ADC_COEF_B3_2_COEF_B3_2_MSK BITS(ADC_COEF_B3_2_COEF_B3_2_POSS, ADC_COEF_B3_2_COEF_B3_2_POSE)
# define    ADC_COEF_B3_2_COEF_B3_2  ADC_COEF_B3_2_COEF_B3_2_MSK

/****************** Bit definition for COEF_A2_2 register ************************/

# define    ADC_COEF_A2_2_COEF_A2_2_POSS 0U
# define    ADC_COEF_A2_2_COEF_A2_2_POSE 31U
# define    ADC_COEF_A2_2_COEF_A2_2_MSK BITS(ADC_COEF_A2_2_COEF_A2_2_POSS, ADC_COEF_A2_2_COEF_A2_2_POSE)
# define    ADC_COEF_A2_2_COEF_A2_2  ADC_COEF_A2_2_COEF_A2_2_MSK

/****************** Bit definition for COEF_A3_2 register ************************/

# define    ADC_COEF_A3_2_COEF_A3_2_POSS 0U
# define    ADC_COEF_A3_2_COEF_A3_2_POSE 31U
# define    ADC_COEF_A3_2_COEF_A3_2_MSK BITS(ADC_COEF_A3_2_COEF_A3_2_POSS, ADC_COEF_A3_2_COEF_A3_2_POSE)
# define    ADC_COEF_A3_2_COEF_A3_2  ADC_COEF_A3_2_COEF_A3_2_MSK

typedef struct
{
    __IO uint32_t IA_CTRL;                  // 0x000
    __IO uint32_t CTRL0;                    // 0x004
    __IO uint32_t CTRL1;                    // 0x008
    __I  uint32_t VAL;                      // 0x00c
    __IO uint32_t BIQUAD_CTRL;              // 0x010
    __I  uint32_t BIQUAD_VAL;               // 0x014
    __IO uint32_t BIQUAD_IN;                // 0x018
    __IO uint32_t RESERVED0[5];             // 0x01c-0x2c
    __O  uint32_t IER;                      // 0x030
    __O  uint32_t IDR;                      // 0x034
    __I  uint32_t IVS;                      // 0x038
    __I  uint32_t RIF;                      // 0x03c
    __I  uint32_t IFM;                      // 0x040
    __O  uint32_t ICR;                      // 0x044
    __IO uint32_t RESERVED1[2];             // 0x048-0x4c
    __IO uint32_t COEF_SC_1;                // 0x050
    __IO uint32_t COEF_B1_1;                // 0x054
    __IO uint32_t COEF_B2_1;                // 0x058
    __IO uint32_t COEF_B3_1;                // 0x05c
    __IO uint32_t COEF_A2_1;                // 0x060
    __IO uint32_t COEF_A3_1;                // 0x064
    __IO uint32_t COEF_SC_2;                // 0x068
    __IO uint32_t COEF_B1_2;                // 0x06c
    __IO uint32_t COEF_B2_2;                // 0x070
    __IO uint32_t COEF_B3_2;                // 0x074
    __IO uint32_t COEF_A2_2;                // 0x078
    __IO uint32_t COEF_A3_2;                // 0x07c
} ADC_TypeDef;


#endif
