/******************************************************************************/
/* RETARGET.C: 'Retarget' layer for target-dependent low level functions      */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2005-2006 Keil Software. All rights reserved.                */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/

#include <stdio.h>
#include "cmsis_compiler.h"

#if defined ( __ICCARM__ )
    #include <LowLevelIOInterface.h>    //For IAR 9.40

#pragma module_name = "?__write"        //For IAR 9.40
#endif

//#pragma import(__use_no_semihosting_swi)

__WEAK uint8_t  sendchar(uint8_t ui8char)
{
  (void) ui8char;
  return 0;
}


int  ITM_fputc(int ch);  /* ITM debug */

#if !(defined(__STRICT_ANSI__) && !__FILE_INCOMPLETE)
struct __FILE 
{ 
int handle; /* Add whatever you need here */ 
};
#endif

FILE __stdout;

#if defined ( __ICCARM__ )
//For IAR 9.40
int MyLowLevelPutchar(int ch)
{
  return (sendchar(ch));
} 

//For IAR 9.40
/*
 * If the __write implementation uses internal buffering, uncomment
 * the following line to ensure that we are called with "buffer" as 0
 * (i.e. flush) when the application terminates.
 */

size_t __write(int handle, const unsigned char * buffer, size_t size)
{
  /* Remove the #if #endif pair to enable the implementation */
#if 1

  size_t nChars = 0;

  if (buffer == 0)
  {
    /*
     * This means that we should flush internal buffers.  Since we
     * don't we just return.  (Remember, "handle" == -1 means that all
     * handles should be flushed.)
     */
    return 0;
  }

  /* This template only writes to "standard out" and "standard err",
   * for all other file handles it returns failure. */
  if (handle != _LLIO_STDOUT && handle != _LLIO_STDERR)
  {
    return _LLIO_ERROR;
  }

  for (/* Empty */; size != 0; --size)
  {
    if (MyLowLevelPutchar(*buffer++) < 0)
    {
      return _LLIO_ERROR;
    }

    ++nChars;
  }

  return nChars;

#else

  /* Always return error code when implementation is disabled. */
  return _LLIO_ERROR;

#endif

}
#endif

int fputc(int ch, FILE *f)
{
  return (sendchar(ch));
}


int ferror(FILE *f)
{
  /* Your implementation of ferror */
  return EOF;
}


void _ttywrch(int ch)
{
  sendchar(ch);
}

void _sys_exit(int return_code)
{
    return_code = return_code; 
}
